/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1alpha1

import (
	cachev1alpha1 "github.com/kcp-dev/kcp/sdk/apis/cache/v1alpha1"
	conditionsv1alpha1 "github.com/kcp-dev/kcp/sdk/apis/third_party/conditions/apis/conditions/v1alpha1"
)

// CachedResourceStatusApplyConfiguration represents a declarative configuration of the CachedResourceStatus type for use
// with apply.
type CachedResourceStatusApplyConfiguration struct {
	IdentityHash   *string                                `json:"identityHash,omitempty"`
	ResourceCounts *ResourceCountApplyConfiguration       `json:"resourceCounts,omitempty"`
	Phase          *cachev1alpha1.CachedResourcePhaseType `json:"phase,omitempty"`
	Conditions     *conditionsv1alpha1.Conditions         `json:"conditions,omitempty"`
}

// CachedResourceStatusApplyConfiguration constructs a declarative configuration of the CachedResourceStatus type for use with
// apply.
func CachedResourceStatus() *CachedResourceStatusApplyConfiguration {
	return &CachedResourceStatusApplyConfiguration{}
}

// WithIdentityHash sets the IdentityHash field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the IdentityHash field is set to the value of the last call.
func (b *CachedResourceStatusApplyConfiguration) WithIdentityHash(value string) *CachedResourceStatusApplyConfiguration {
	b.IdentityHash = &value
	return b
}

// WithResourceCounts sets the ResourceCounts field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ResourceCounts field is set to the value of the last call.
func (b *CachedResourceStatusApplyConfiguration) WithResourceCounts(value *ResourceCountApplyConfiguration) *CachedResourceStatusApplyConfiguration {
	b.ResourceCounts = value
	return b
}

// WithPhase sets the Phase field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Phase field is set to the value of the last call.
func (b *CachedResourceStatusApplyConfiguration) WithPhase(value cachev1alpha1.CachedResourcePhaseType) *CachedResourceStatusApplyConfiguration {
	b.Phase = &value
	return b
}

// WithConditions sets the Conditions field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Conditions field is set to the value of the last call.
func (b *CachedResourceStatusApplyConfiguration) WithConditions(value conditionsv1alpha1.Conditions) *CachedResourceStatusApplyConfiguration {
	b.Conditions = &value
	return b
}
