import argparse
import json
import requests
from termcolor import colored
import urllib3


urllib3.disable_warnings(urllib3.exceptions.InsecureRequestWarning)

def load_payloads(file_path):

    try:
        with open(file_path, "r") as file:
            return json.load(file)
    except Exception as e:
        print(colored(f"Error loading payload file: {e}", "red"))
        exit(1)

def validate_response(cve, response):
    # Tambahkan validasi sesuai dengan CVE
    if cve == "CVE-2017-9506":
        return "consumerUri" in response.text
    elif cve == "CVE-2018-5230":
        return "<IFRAME" in response.text
    elif cve == "CVE-2018-20824":
        return "alert(document.domain)" in response.text
    elif cve == "CVE-2019-3396":
        return "macro" in response.text
    elif cve == "CVE-2019-3402":
        return "<script>alert(1)</script>" in response.text
    elif cve == "CVE-2019-8442":
        return "atlassian-jira-webapp" in response.text
    elif cve == "CVE-2019-8449":
        return response.status_code == 200 and "groupuserpicker" in response.text
    elif cve == "CVE-2020-14178":
        return response.status_code == 200 and "browse" in response.text
    elif cve == "jira-unauth-popular-filters":
        return "filterView=popular" in response.text
    elif cve == "jira-unauthenticated-dashboards":
        return "dashboard" in response.text
    else:
        return False  

def check_vulnerability(url, payloads):

    results = []
    for cve, endpoint in payloads.items():
        target_url = f"{url.rstrip('/')}{endpoint}"
        try:
            response = requests.get(target_url, timeout=10, verify=False)
            if validate_response(cve, response):
                results.append((cve, endpoint, "VULNERABLE"))
                print(colored(f"[{cve}] {target_url} - VULNERABLE", "green"))
            else:
                results.append((cve, endpoint, "NOT VULNERABLE"))
                print(colored(f"[{cve}] {target_url} - NOT VULNERABLE", "yellow"))
        except requests.exceptions.RequestException as e:
            results.append((cve, endpoint, "ERROR"))
            print(colored(f"[{cve}] {target_url} - ERROR: {e}", "red"))
    return results

def main():
    parser = argparse.ArgumentParser(description="Jira Vulnerability Scanner")
    parser.add_argument("--url", required=True, help="Target Jira URL (e.g., https://jira.example.com)")
    parser.add_argument("--payloads", default="payloads.json", help="Path to the payloads JSON file")
    args = parser.parse_args()

    print(colored(f"Starting scan on: {args.url}", "cyan"))
    print(colored(f"Loading payloads from: {args.payloads}", "cyan"))


    payloads = load_payloads(args.payloads)


    results = check_vulnerability(args.url, payloads)

    print(colored("\nScan Complete!", "cyan"))
    print(colored("Summary:", "cyan"))
    for cve, endpoint, status in results:
        color = "green" if status == "VULNERABLE" else "yellow" if status == "NOT VULNERABLE" else "red"
        print(colored(f"[{cve}] {endpoint} - {status}", color))

if __name__ == "__main__":
    main()
