/**
 * This file was auto-generated by openapi-typescript.
 * Do not make direct changes to the file.
 */

export interface paths {
  "/": {
    /** Get Hypermedia links to resources accessible in GitHub's REST API */
    get: operations["meta/root"];
  };
  "/admin/hooks": {
    get: operations["enterprise-admin/list-global-webhooks"];
    post: operations["enterprise-admin/create-global-webhook"];
  };
  "/admin/hooks/{hook_id}": {
    get: operations["enterprise-admin/get-global-webhook"];
    delete: operations["enterprise-admin/delete-global-webhook"];
    /** Parameters that are not provided will be overwritten with the default value or removed if no default exists. */
    patch: operations["enterprise-admin/update-global-webhook"];
  };
  "/admin/hooks/{hook_id}/pings": {
    /** This will trigger a [ping event](https://docs.github.com/enterprise-server@3.3/webhooks/#ping-event) to be sent to the webhook. */
    post: operations["enterprise-admin/ping-global-webhook"];
  };
  "/admin/keys": {
    get: operations["enterprise-admin/list-public-keys"];
  };
  "/admin/keys/{key_ids}": {
    delete: operations["enterprise-admin/delete-public-key"];
  };
  "/admin/ldap/teams/{team_id}/mapping": {
    /** Updates the [distinguished name](https://www.ldap.com/ldap-dns-and-rdns) (DN) of the LDAP entry to map to a team. [LDAP synchronization](https://docs.github.com/enterprise-server@3.3/admin/identity-and-access-management/using-ldap-for-enterprise-iam/using-ldap#enabling-ldap-sync) must be enabled to map LDAP entries to a team. Use the [Create a team](https://docs.github.com/enterprise-server@3.3/rest/reference/teams/#create-a-team) endpoint to create a team with LDAP mapping. */
    patch: operations["enterprise-admin/update-ldap-mapping-for-team"];
  };
  "/admin/ldap/teams/{team_id}/sync": {
    /** Note that this API call does not automatically initiate an LDAP sync. Rather, if a `201` is returned, the sync job is queued successfully, and is performed when the instance is ready. */
    post: operations["enterprise-admin/sync-ldap-mapping-for-team"];
  };
  "/admin/ldap/users/{username}/mapping": {
    patch: operations["enterprise-admin/update-ldap-mapping-for-user"];
  };
  "/admin/ldap/users/{username}/sync": {
    /** Note that this API call does not automatically initiate an LDAP sync. Rather, if a `201` is returned, the sync job is queued successfully, and is performed when the instance is ready. */
    post: operations["enterprise-admin/sync-ldap-mapping-for-user"];
  };
  "/admin/organizations": {
    post: operations["enterprise-admin/create-org"];
  };
  "/admin/organizations/{org}": {
    patch: operations["enterprise-admin/update-org-name"];
  };
  "/admin/pre-receive-environments": {
    get: operations["enterprise-admin/list-pre-receive-environments"];
    post: operations["enterprise-admin/create-pre-receive-environment"];
  };
  "/admin/pre-receive-environments/{pre_receive_environment_id}": {
    get: operations["enterprise-admin/get-pre-receive-environment"];
    /**
     * If you attempt to delete an environment that cannot be deleted, you will receive a `422 Unprocessable Entity` response.
     *
     * The possible error messages are:
     *
     * *   _Cannot modify or delete the default environment_
     * *   _Cannot delete environment that has hooks_
     * *   _Cannot delete environment when download is in progress_
     */
    delete: operations["enterprise-admin/delete-pre-receive-environment"];
    /** You cannot modify the default environment. If you attempt to modify the default environment, you will receive a `422 Unprocessable Entity` response. */
    patch: operations["enterprise-admin/update-pre-receive-environment"];
  };
  "/admin/pre-receive-environments/{pre_receive_environment_id}/downloads": {
    /**
     * Triggers a new download of the environment tarball from the environment's `image_url`. When the download is finished, the newly downloaded tarball will overwrite the existing environment.
     *
     * If a download cannot be triggered, you will receive a `422 Unprocessable Entity` response.
     *
     * The possible error messages are:
     *
     * * _Cannot modify or delete the default environment_
     * * _Can not start a new download when a download is in progress_
     */
    post: operations["enterprise-admin/start-pre-receive-environment-download"];
  };
  "/admin/pre-receive-environments/{pre_receive_environment_id}/downloads/latest": {
    /** In addition to seeing the download status at the "[Get a pre-receive environment](#get-a-pre-receive-environment)" endpoint, there is also this separate endpoint for just the download status. */
    get: operations["enterprise-admin/get-download-status-for-pre-receive-environment"];
  };
  "/admin/pre-receive-hooks": {
    get: operations["enterprise-admin/list-pre-receive-hooks"];
    post: operations["enterprise-admin/create-pre-receive-hook"];
  };
  "/admin/pre-receive-hooks/{pre_receive_hook_id}": {
    get: operations["enterprise-admin/get-pre-receive-hook"];
    delete: operations["enterprise-admin/delete-pre-receive-hook"];
    patch: operations["enterprise-admin/update-pre-receive-hook"];
  };
  "/admin/tokens": {
    /** Lists personal access tokens for all users, including admin users. */
    get: operations["enterprise-admin/list-personal-access-tokens"];
  };
  "/admin/tokens/{token_id}": {
    /** Deletes a personal access token. Returns a `403 - Forbidden` status when a personal access token is in use. For example, if you access this endpoint with the same personal access token that you are trying to delete, you will receive this error. */
    delete: operations["enterprise-admin/delete-personal-access-token"];
  };
  "/admin/users": {
    /**
     * If an external authentication mechanism is used, the login name should match the login name in the external system. If you are using LDAP authentication, you should also [update the LDAP mapping](https://docs.github.com/enterprise-server@3.3/rest/reference/enterprise-admin#update-ldap-mapping-for-a-user) for the user.
     *
     * The login name will be normalized to only contain alphanumeric characters or single hyphens. For example, if you send `"octo_cat"` as the login, a user named `"octo-cat"` will be created.
     *
     * If the login name or email address is already associated with an account, the server will return a `422` response.
     */
    post: operations["enterprise-admin/create-user"];
  };
  "/admin/users/{username}": {
    /**
     * Deleting a user will delete all their repositories, gists, applications, and personal settings. [Suspending a user](https://docs.github.com/enterprise-server@3.3/rest/reference/enterprise-admin#suspend-a-user) is often a better option.
     *
     * You can delete any user account except your own.
     */
    delete: operations["enterprise-admin/delete-user"];
    patch: operations["enterprise-admin/update-username-for-user"];
  };
  "/admin/users/{username}/authorizations": {
    post: operations["enterprise-admin/create-impersonation-o-auth-token"];
    delete: operations["enterprise-admin/delete-impersonation-o-auth-token"];
  };
  "/app": {
    /**
     * Returns the GitHub App associated with the authentication credentials used. To see how many app installations are associated with this GitHub App, see the `installations_count` in the response. For more details about your app's installations, see the "[List installations for the authenticated app](https://docs.github.com/enterprise-server@3.3/rest/reference/apps#list-installations-for-the-authenticated-app)" endpoint.
     *
     * You must use a [JWT](https://docs.github.com/enterprise-server@3.3/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
     */
    get: operations["apps/get-authenticated"];
  };
  "/app-manifests/{code}/conversions": {
    /** Use this endpoint to complete the handshake necessary when implementing the [GitHub App Manifest flow](https://docs.github.com/enterprise-server@3.3/apps/building-github-apps/creating-github-apps-from-a-manifest/). When you create a GitHub App with the manifest flow, you receive a temporary `code` used to retrieve the GitHub App's `id`, `pem` (private key), and `webhook_secret`. */
    post: operations["apps/create-from-manifest"];
  };
  "/app/hook/config": {
    /**
     * Returns the webhook configuration for a GitHub App. For more information about configuring a webhook for your app, see "[Creating a GitHub App](/developers/apps/creating-a-github-app)."
     *
     * You must use a [JWT](https://docs.github.com/enterprise-server@3.3/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
     */
    get: operations["apps/get-webhook-config-for-app"];
    /**
     * Updates the webhook configuration for a GitHub App. For more information about configuring a webhook for your app, see "[Creating a GitHub App](/developers/apps/creating-a-github-app)."
     *
     * You must use a [JWT](https://docs.github.com/enterprise-server@3.3/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
     */
    patch: operations["apps/update-webhook-config-for-app"];
  };
  "/app/hook/deliveries": {
    /**
     * Returns a list of webhook deliveries for the webhook configured for a GitHub App.
     *
     * You must use a [JWT](https://docs.github.com/enterprise-server@3.3/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
     */
    get: operations["apps/list-webhook-deliveries"];
  };
  "/app/hook/deliveries/{delivery_id}": {
    /**
     * Returns a delivery for the webhook configured for a GitHub App.
     *
     * You must use a [JWT](https://docs.github.com/enterprise-server@3.3/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
     */
    get: operations["apps/get-webhook-delivery"];
  };
  "/app/hook/deliveries/{delivery_id}/attempts": {
    /**
     * Redeliver a delivery for the webhook configured for a GitHub App.
     *
     * You must use a [JWT](https://docs.github.com/enterprise-server@3.3/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
     */
    post: operations["apps/redeliver-webhook-delivery"];
  };
  "/app/installations": {
    /**
     * You must use a [JWT](https://docs.github.com/enterprise-server@3.3/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
     *
     * The permissions the installation has are included under the `permissions` key.
     */
    get: operations["apps/list-installations"];
  };
  "/app/installations/{installation_id}": {
    /**
     * Enables an authenticated GitHub App to find an installation's information using the installation id.
     *
     * You must use a [JWT](https://docs.github.com/enterprise-server@3.3/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
     */
    get: operations["apps/get-installation"];
    /**
     * Uninstalls a GitHub App on a user, organization, or business account. If you prefer to temporarily suspend an app's access to your account's resources, then we recommend the "[Suspend an app installation](https://docs.github.com/enterprise-server@3.3/rest/reference/apps/#suspend-an-app-installation)" endpoint.
     *
     * You must use a [JWT](https://docs.github.com/enterprise-server@3.3/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
     */
    delete: operations["apps/delete-installation"];
  };
  "/app/installations/{installation_id}/access_tokens": {
    /**
     * Creates an installation access token that enables a GitHub App to make authenticated API requests for the app's installation on an organization or individual account. Installation tokens expire one hour from the time you create them. Using an expired token produces a status code of `401 - Unauthorized`, and requires creating a new installation token. By default the installation token has access to all repositories that the installation can access. To restrict the access to specific repositories, you can provide the `repository_ids` when creating the token. When you omit `repository_ids`, the response does not contain the `repositories` key.
     *
     * You must use a [JWT](https://docs.github.com/enterprise-server@3.3/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
     */
    post: operations["apps/create-installation-access-token"];
  };
  "/app/installations/{installation_id}/suspended": {
    /**
     * Suspends a GitHub App on a user, organization, or business account, which blocks the app from accessing the account's resources. When a GitHub App is suspended, the app's access to the GitHub Enterprise Server API or webhook events is blocked for that account.
     *
     * You must use a [JWT](https://docs.github.com/enterprise-server@3.3/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
     */
    put: operations["apps/suspend-installation"];
    /**
     * Removes a GitHub App installation suspension.
     *
     * You must use a [JWT](https://docs.github.com/enterprise-server@3.3/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
     */
    delete: operations["apps/unsuspend-installation"];
  };
  "/applications/grants": {
    /**
     * **Deprecation Notice:** GitHub Enterprise Server will discontinue the [OAuth Authorizations API](https://docs.github.com/enterprise-server@3.3/rest/reference/oauth-authorizations/), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/enterprise-server@3.3/developers/apps/authorizing-oauth-apps#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/enterprise-server@3.3/rest/reference/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/).
     *
     * You can use this API to list the set of OAuth applications that have been granted access to your account. Unlike the [list your authorizations](https://docs.github.com/enterprise-server@3.3/rest/reference/oauth-authorizations#list-your-authorizations) API, this API does not manage individual tokens. This API will return one entry for each OAuth application that has been granted access to your account, regardless of the number of tokens an application has generated for your user. The list of OAuth applications returned matches what is shown on [the application authorizations settings screen within GitHub](https://github.com/settings/applications#authorized). The `scopes` returned are the union of scopes authorized for the application. For example, if an application has one token with `repo` scope and another token with `user` scope, the grant will return `["repo", "user"]`.
     */
    get: operations["oauth-authorizations/list-grants"];
  };
  "/applications/grants/{grant_id}": {
    /** **Deprecation Notice:** GitHub Enterprise Server will discontinue the [OAuth Authorizations API](https://docs.github.com/enterprise-server@3.3/rest/reference/oauth-authorizations), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/enterprise-server@3.3/apps/building-oauth-apps/authorizing-oauth-apps/#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/enterprise-server@3.3/rest/reference/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/). */
    get: operations["oauth-authorizations/get-grant"];
    /**
     * **Deprecation Notice:** GitHub Enterprise Server will discontinue the [OAuth Authorizations API](https://docs.github.com/enterprise-server@3.3/rest/reference/oauth-authorizations/), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/enterprise-server@3.3/developers/apps/authorizing-oauth-apps#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/enterprise-server@3.3/rest/reference/oauth-authorizations/) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/).
     *
     * Deleting an OAuth application's grant will also delete all OAuth tokens associated with the application for your user. Once deleted, the application has no access to your account and is no longer listed on [the application authorizations settings screen within GitHub](https://github.com/settings/applications#authorized).
     */
    delete: operations["oauth-authorizations/delete-grant"];
  };
  "/applications/{client_id}/grant": {
    /**
     * OAuth application owners can revoke a grant for their OAuth application and a specific user. You must use [Basic Authentication](https://docs.github.com/enterprise-server@3.3/rest/overview/other-authentication-methods#basic-authentication) when accessing this endpoint, using the OAuth application's `client_id` and `client_secret` as the username and password. You must also provide a valid OAuth `access_token` as an input parameter and the grant for the token's owner will be deleted.
     * Deleting an OAuth application's grant will also delete all OAuth tokens associated with the application for the user. Once deleted, the application will have no access to the user's account and will no longer be listed on [the application authorizations settings screen within GitHub](https://github.com/settings/applications#authorized).
     */
    delete: operations["apps/delete-authorization"];
  };
  "/applications/{client_id}/grants/{access_token}": {
    /**
     * **Deprecation Notice:** GitHub Enterprise Server will discontinue OAuth endpoints that contain `access_token` in the path parameter. We have introduced new endpoints that allow you to securely manage tokens for OAuth Apps by moving `access_token` to the request body. For more information, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-app-endpoint/).
     *
     * OAuth application owners can revoke a grant for their OAuth application and a specific user. You must use [Basic Authentication](https://docs.github.com/enterprise-server@3.3/rest/overview/other-authentication-methods#basic-authentication) when accessing this endpoint, using the OAuth application's `client_id` and `client_secret` as the username and password. You must also provide a valid token as `:access_token` and the grant for the token's owner will be deleted.
     *
     * Deleting an OAuth application's grant will also delete all OAuth tokens associated with the application for the user. Once deleted, the application will have no access to the user's account and will no longer be listed on [the Applications settings page under "Authorized OAuth Apps" on GitHub Enterprise Server](https://github.com/settings/applications#authorized).
     */
    delete: operations["apps/revoke-grant-for-application"];
  };
  "/applications/{client_id}/token": {
    /** OAuth applications can use a special API method for checking OAuth token validity without exceeding the normal rate limits for failed login attempts. Authentication works differently with this particular endpoint. You must use [Basic Authentication](https://docs.github.com/enterprise-server@3.3/rest/overview/other-authentication-methods#basic-authentication) to use this endpoint, where the username is the OAuth application `client_id` and the password is its `client_secret`. Invalid tokens will return `404 NOT FOUND`. */
    post: operations["apps/check-token"];
    /** OAuth application owners can revoke a single token for an OAuth application. You must use [Basic Authentication](https://docs.github.com/enterprise-server@3.3/rest/overview/other-authentication-methods#basic-authentication) when accessing this endpoint, using the OAuth application's `client_id` and `client_secret` as the username and password. */
    delete: operations["apps/delete-token"];
    /** OAuth applications can use this API method to reset a valid OAuth token without end-user involvement. Applications must save the "token" property in the response because changes take effect immediately. You must use [Basic Authentication](https://docs.github.com/enterprise-server@3.3/rest/overview/other-authentication-methods#basic-authentication) when accessing this endpoint, using the OAuth application's `client_id` and `client_secret` as the username and password. Invalid tokens will return `404 NOT FOUND`. */
    patch: operations["apps/reset-token"];
  };
  "/applications/{client_id}/token/scoped": {
    /** Use a non-scoped user-to-server OAuth access token to create a repository scoped and/or permission scoped user-to-server OAuth access token. You can specify which repositories the token can access and which permissions are granted to the token. You must use [Basic Authentication](https://docs.github.com/enterprise-server@3.3/rest/overview/other-authentication-methods#basic-authentication) when accessing this endpoint, using the OAuth application's `client_id` and `client_secret` as the username and password. Invalid tokens will return `404 NOT FOUND`. */
    post: operations["apps/scope-token"];
  };
  "/applications/{client_id}/tokens/{access_token}": {
    /**
     * **Deprecation Notice:** GitHub Enterprise Server will discontinue OAuth endpoints that contain `access_token` in the path parameter. We have introduced new endpoints that allow you to securely manage tokens for OAuth Apps by moving `access_token` to the request body. For more information, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-app-endpoint/).
     *
     * OAuth applications can use a special API method for checking OAuth token validity without exceeding the normal rate limits for failed login attempts. Authentication works differently with this particular endpoint. You must use [Basic Authentication](https://docs.github.com/enterprise-server@3.3/rest/overview/other-authentication-methods#basic-authentication) when accessing this endpoint, using the OAuth application's `client_id` and `client_secret` as the username and password. Invalid tokens will return `404 NOT FOUND`.
     */
    get: operations["apps/check-authorization"];
    /**
     * **Deprecation Notice:** GitHub Enterprise Server will discontinue OAuth endpoints that contain `access_token` in the path parameter. We have introduced new endpoints that allow you to securely manage tokens for OAuth Apps by moving `access_token` to the request body. For more information, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-app-endpoint/).
     *
     * OAuth applications can use this API method to reset a valid OAuth token without end-user involvement. Applications must save the "token" property in the response because changes take effect immediately. You must use [Basic Authentication](https://docs.github.com/enterprise-server@3.3/rest/overview/other-authentication-methods#basic-authentication) when accessing this endpoint, using the OAuth application's `client_id` and `client_secret` as the username and password. Invalid tokens will return `404 NOT FOUND`.
     */
    post: operations["apps/reset-authorization"];
    /**
     * **Deprecation Notice:** GitHub Enterprise Server will discontinue OAuth endpoints that contain `access_token` in the path parameter. We have introduced new endpoints that allow you to securely manage tokens for OAuth Apps by moving `access_token` to the request body. For more information, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-app-endpoint/).
     *
     * OAuth application owners can revoke a single token for an OAuth application. You must use [Basic Authentication](https://docs.github.com/enterprise-server@3.3/rest/overview/other-authentication-methods#basic-authentication) when accessing this endpoint, using the OAuth application's `client_id` and `client_secret` as the username and password.
     */
    delete: operations["apps/revoke-authorization-for-application"];
  };
  "/apps/{app_slug}": {
    /**
     * **Note**: The `:app_slug` is just the URL-friendly name of your GitHub App. You can find this on the settings page for your GitHub App (e.g., `https://github.com/settings/apps/:app_slug`).
     *
     * If the GitHub App you specify is public, you can access this endpoint without authenticating. If the GitHub App you specify is private, you must authenticate with a [personal access token](https://docs.github.com/articles/creating-a-personal-access-token-for-the-command-line/) or an [installation access token](https://docs.github.com/enterprise-server@3.3/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-an-installation) to access this endpoint.
     */
    get: operations["apps/get-by-slug"];
  };
  "/authorizations": {
    /** **Deprecation Notice:** GitHub Enterprise Server will discontinue the [OAuth Authorizations API](https://docs.github.com/enterprise-server@3.3/rest/reference/oauth-authorizations), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/enterprise-server@3.3/apps/building-oauth-apps/authorizing-oauth-apps/#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/enterprise-server@3.3/rest/reference/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/). */
    get: operations["oauth-authorizations/list-authorizations"];
    /**
     * **Deprecation Notice:** GitHub Enterprise Server will discontinue the [OAuth Authorizations API](https://docs.github.com/enterprise-server@3.3/rest/reference/oauth-authorizations), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/enterprise-server@3.3/developers/apps/authorizing-oauth-apps#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/enterprise-server@3.3/rest/reference/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/).
     *
     * **Warning:** Apps must use the [web application flow](https://docs.github.com/enterprise-server@3.3/apps/building-oauth-apps/authorizing-oauth-apps/#web-application-flow) to obtain OAuth tokens that work with GitHub Enterprise Server SAML organizations. OAuth tokens created using the Authorizations API will be unable to access GitHub Enterprise Server SAML organizations. For more information, see the [blog post](https://developer.github.com/changes/2019-11-05-deprecated-passwords-and-authorizations-api).
     *
     * Creates OAuth tokens using [Basic Authentication](https://docs.github.com/enterprise-server@3.3/rest/overview/other-authentication-methods#basic-authentication). If you have two-factor authentication setup, Basic Authentication for this endpoint requires that you use a one-time password (OTP) and your username and password instead of tokens. For more information, see "[Working with two-factor authentication](https://docs.github.com/enterprise-server@3.3/rest/overview/other-authentication-methods#working-with-two-factor-authentication)."
     *
     * To create tokens for a particular OAuth application using this endpoint, you must authenticate as the user you want to create an authorization for and provide the app's client ID and secret, found on your OAuth application's settings page. If your OAuth application intends to create multiple tokens for one user, use `fingerprint` to differentiate between them.
     *
     * You can also create tokens on GitHub Enterprise Server from the [personal access tokens settings](https://github.com/settings/tokens) page. Read more about these tokens in [the GitHub Help documentation](https://docs.github.com/articles/creating-an-access-token-for-command-line-use).
     *
     * Organizations that enforce SAML SSO require personal access tokens to be allowed. Read more about allowing tokens in [the GitHub Help documentation](https://docs.github.com/articles/about-identity-and-access-management-with-saml-single-sign-on).
     */
    post: operations["oauth-authorizations/create-authorization"];
  };
  "/authorizations/clients/{client_id}": {
    /**
     * **Deprecation Notice:** GitHub Enterprise Server will discontinue the [OAuth Authorizations API](https://docs.github.com/enterprise-server@3.3/rest/reference/oauth-authorizations/), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/enterprise-server@3.3/developers/apps/authorizing-oauth-apps#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/enterprise-server@3.3/rest/reference/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/).
     *
     * **Warning:** Apps must use the [web application flow](https://docs.github.com/enterprise-server@3.3/apps/building-oauth-apps/authorizing-oauth-apps/#web-application-flow) to obtain OAuth tokens that work with GitHub Enterprise Server SAML organizations. OAuth tokens created using the Authorizations API will be unable to access GitHub Enterprise Server SAML organizations. For more information, see the [blog post](https://developer.github.com/changes/2019-11-05-deprecated-passwords-and-authorizations-api).
     *
     * Creates a new authorization for the specified OAuth application, only if an authorization for that application doesn't already exist for the user. The URL includes the 20 character client ID for the OAuth app that is requesting the token. It returns the user's existing authorization for the application if one is present. Otherwise, it creates and returns a new one.
     *
     * If you have two-factor authentication setup, Basic Authentication for this endpoint requires that you use a one-time password (OTP) and your username and password instead of tokens. For more information, see "[Working with two-factor authentication](https://docs.github.com/enterprise-server@3.3/rest/overview/other-authentication-methods#working-with-two-factor-authentication)."
     *
     * **Deprecation Notice:** GitHub Enterprise Server will discontinue the [OAuth Authorizations API](https://docs.github.com/enterprise-server@3.3/rest/reference/oauth-authorizations/), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/enterprise-server@3.3/developers/apps/authorizing-oauth-apps#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/enterprise-server@3.3/rest/reference/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/).
     */
    put: operations["oauth-authorizations/get-or-create-authorization-for-app"];
  };
  "/authorizations/clients/{client_id}/{fingerprint}": {
    /**
     * **Deprecation Notice:** GitHub Enterprise Server will discontinue the [OAuth Authorizations API](https://docs.github.com/enterprise-server@3.3/rest/reference/oauth-authorizations/), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/enterprise-server@3.3/developers/apps/authorizing-oauth-apps#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/enterprise-server@3.3/rest/reference/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/).
     *
     * **Warning:** Apps must use the [web application flow](https://docs.github.com/enterprise-server@3.3/apps/building-oauth-apps/authorizing-oauth-apps/#web-application-flow) to obtain OAuth tokens that work with GitHub Enterprise Server SAML organizations. OAuth tokens created using the Authorizations API will be unable to access GitHub Enterprise Server SAML organizations. For more information, see the [blog post](https://developer.github.com/changes/2019-11-05-deprecated-passwords-and-authorizations-api).
     *
     * This method will create a new authorization for the specified OAuth application, only if an authorization for that application and fingerprint do not already exist for the user. The URL includes the 20 character client ID for the OAuth app that is requesting the token. `fingerprint` is a unique string to distinguish an authorization from others created for the same client ID and user. It returns the user's existing authorization for the application if one is present. Otherwise, it creates and returns a new one.
     *
     * If you have two-factor authentication setup, Basic Authentication for this endpoint requires that you use a one-time password (OTP) and your username and password instead of tokens. For more information, see "[Working with two-factor authentication](https://docs.github.com/enterprise-server@3.3/rest/overview/other-authentication-methods#working-with-two-factor-authentication)."
     */
    put: operations["oauth-authorizations/get-or-create-authorization-for-app-and-fingerprint"];
  };
  "/authorizations/{authorization_id}": {
    /** **Deprecation Notice:** GitHub Enterprise Server will discontinue the [OAuth Authorizations API](https://docs.github.com/enterprise-server@3.3/rest/reference/oauth-authorizations), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/enterprise-server@3.3/apps/building-oauth-apps/authorizing-oauth-apps/#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/enterprise-server@3.3/rest/reference/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/). */
    get: operations["oauth-authorizations/get-authorization"];
    /** **Deprecation Notice:** GitHub Enterprise Server will discontinue the [OAuth Authorizations API](https://docs.github.com/enterprise-server@3.3/rest/reference/oauth-authorizations), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/enterprise-server@3.3/apps/building-oauth-apps/authorizing-oauth-apps/#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/enterprise-server@3.3/rest/reference/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/). */
    delete: operations["oauth-authorizations/delete-authorization"];
    /**
     * **Deprecation Notice:** GitHub Enterprise Server will discontinue the [OAuth Authorizations API](https://docs.github.com/enterprise-server@3.3/rest/reference/oauth-authorizations/), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/enterprise-server@3.3/developers/apps/authorizing-oauth-apps#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/enterprise-server@3.3/rest/reference/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/).
     *
     * If you have two-factor authentication setup, Basic Authentication for this endpoint requires that you use a one-time password (OTP) and your username and password instead of tokens. For more information, see "[Working with two-factor authentication](https://docs.github.com/enterprise-server@3.3/rest/overview/other-authentication-methods#working-with-two-factor-authentication)."
     *
     * You can only send one of these scope keys at a time.
     */
    patch: operations["oauth-authorizations/update-authorization"];
  };
  "/codes_of_conduct": {
    get: operations["codes-of-conduct/get-all-codes-of-conduct"];
  };
  "/codes_of_conduct/{key}": {
    get: operations["codes-of-conduct/get-conduct-code"];
  };
  "/emojis": {
    /** Lists all the emojis available to use on GitHub Enterprise Server. */
    get: operations["emojis/get"];
  };
  "/enterprise/announcement": {
    /** Gets the current message and expiration date of the global announcement banner in your enterprise. */
    get: operations["enterprise-admin/get-announcement"];
    /** Removes the global announcement banner in your enterprise. */
    delete: operations["enterprise-admin/remove-announcement"];
    /** Sets the message and expiration time for the global announcement banner in your enterprise. */
    patch: operations["enterprise-admin/set-announcement"];
  };
  "/enterprise/settings/license": {
    get: operations["enterprise-admin/get-license-information"];
  };
  "/enterprise/stats/all": {
    get: operations["enterprise-admin/get-all-stats"];
  };
  "/enterprise/stats/comments": {
    get: operations["enterprise-admin/get-comment-stats"];
  };
  "/enterprise/stats/gists": {
    get: operations["enterprise-admin/get-gist-stats"];
  };
  "/enterprise/stats/hooks": {
    get: operations["enterprise-admin/get-hooks-stats"];
  };
  "/enterprise/stats/issues": {
    get: operations["enterprise-admin/get-issue-stats"];
  };
  "/enterprise/stats/milestones": {
    get: operations["enterprise-admin/get-milestone-stats"];
  };
  "/enterprise/stats/orgs": {
    get: operations["enterprise-admin/get-org-stats"];
  };
  "/enterprise/stats/pages": {
    get: operations["enterprise-admin/get-pages-stats"];
  };
  "/enterprise/stats/pulls": {
    get: operations["enterprise-admin/get-pull-request-stats"];
  };
  "/enterprise/stats/repos": {
    get: operations["enterprise-admin/get-repo-stats"];
  };
  "/enterprise/stats/users": {
    get: operations["enterprise-admin/get-user-stats"];
  };
  "/enterprises/{enterprise}/actions/permissions": {
    /**
     * Gets the GitHub Actions permissions policy for organizations and allowed actions in an enterprise.
     *
     * You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
     */
    get: operations["enterprise-admin/get-github-actions-permissions-enterprise"];
    /**
     * Sets the GitHub Actions permissions policy for organizations and allowed actions in an enterprise.
     *
     * You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
     */
    put: operations["enterprise-admin/set-github-actions-permissions-enterprise"];
  };
  "/enterprises/{enterprise}/actions/permissions/organizations": {
    /**
     * Lists the organizations that are selected to have GitHub Actions enabled in an enterprise. To use this endpoint, the enterprise permission policy for `enabled_organizations` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an enterprise](#set-github-actions-permissions-for-an-enterprise)."
     *
     * You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
     */
    get: operations["enterprise-admin/list-selected-organizations-enabled-github-actions-enterprise"];
    /**
     * Replaces the list of selected organizations that are enabled for GitHub Actions in an enterprise. To use this endpoint, the enterprise permission policy for `enabled_organizations` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an enterprise](#set-github-actions-permissions-for-an-enterprise)."
     *
     * You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
     */
    put: operations["enterprise-admin/set-selected-organizations-enabled-github-actions-enterprise"];
  };
  "/enterprises/{enterprise}/actions/permissions/organizations/{org_id}": {
    /**
     * Adds an organization to the list of selected organizations that are enabled for GitHub Actions in an enterprise. To use this endpoint, the enterprise permission policy for `enabled_organizations` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an enterprise](#set-github-actions-permissions-for-an-enterprise)."
     *
     * You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
     */
    put: operations["enterprise-admin/enable-selected-organization-github-actions-enterprise"];
    /**
     * Removes an organization from the list of selected organizations that are enabled for GitHub Actions in an enterprise. To use this endpoint, the enterprise permission policy for `enabled_organizations` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an enterprise](#set-github-actions-permissions-for-an-enterprise)."
     *
     * You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
     */
    delete: operations["enterprise-admin/disable-selected-organization-github-actions-enterprise"];
  };
  "/enterprises/{enterprise}/actions/permissions/selected-actions": {
    /**
     * Gets the selected actions that are allowed in an enterprise. To use this endpoint, the enterprise permission policy for `allowed_actions` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an enterprise](#set-github-actions-permissions-for-an-enterprise)."
     *
     * You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
     */
    get: operations["enterprise-admin/get-allowed-actions-enterprise"];
    /**
     * Sets the actions that are allowed in an enterprise. To use this endpoint, the enterprise permission policy for `allowed_actions` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an enterprise](#set-github-actions-permissions-for-an-enterprise)."
     *
     * You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
     */
    put: operations["enterprise-admin/set-allowed-actions-enterprise"];
  };
  "/enterprises/{enterprise}/actions/runner-groups": {
    /**
     * Lists all self-hosted runner groups for an enterprise.
     *
     * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
     */
    get: operations["enterprise-admin/list-self-hosted-runner-groups-for-enterprise"];
    /**
     * Creates a new self-hosted runner group for an enterprise.
     *
     * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
     */
    post: operations["enterprise-admin/create-self-hosted-runner-group-for-enterprise"];
  };
  "/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}": {
    /**
     * Gets a specific self-hosted runner group for an enterprise.
     *
     * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
     */
    get: operations["enterprise-admin/get-self-hosted-runner-group-for-enterprise"];
    /**
     * Deletes a self-hosted runner group for an enterprise.
     *
     * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
     */
    delete: operations["enterprise-admin/delete-self-hosted-runner-group-from-enterprise"];
    /**
     * Updates the `name` and `visibility` of a self-hosted runner group in an enterprise.
     *
     * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
     */
    patch: operations["enterprise-admin/update-self-hosted-runner-group-for-enterprise"];
  };
  "/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/organizations": {
    /**
     * Lists the organizations with access to a self-hosted runner group.
     *
     * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
     */
    get: operations["enterprise-admin/list-org-access-to-self-hosted-runner-group-in-enterprise"];
    /**
     * Replaces the list of organizations that have access to a self-hosted runner configured in an enterprise.
     *
     * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
     */
    put: operations["enterprise-admin/set-org-access-to-self-hosted-runner-group-in-enterprise"];
  };
  "/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/organizations/{org_id}": {
    /**
     * Adds an organization to the list of selected organizations that can access a self-hosted runner group. The runner group must have `visibility` set to `selected`. For more information, see "[Create a self-hosted runner group for an enterprise](#create-a-self-hosted-runner-group-for-an-enterprise)."
     *
     * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
     */
    put: operations["enterprise-admin/add-org-access-to-self-hosted-runner-group-in-enterprise"];
    /**
     * Removes an organization from the list of selected organizations that can access a self-hosted runner group. The runner group must have `visibility` set to `selected`. For more information, see "[Create a self-hosted runner group for an enterprise](#create-a-self-hosted-runner-group-for-an-enterprise)."
     *
     * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
     */
    delete: operations["enterprise-admin/remove-org-access-to-self-hosted-runner-group-in-enterprise"];
  };
  "/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/runners": {
    /**
     * Lists the self-hosted runners that are in a specific enterprise group.
     *
     * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
     */
    get: operations["enterprise-admin/list-self-hosted-runners-in-group-for-enterprise"];
    /**
     * Replaces the list of self-hosted runners that are part of an enterprise runner group.
     *
     * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
     */
    put: operations["enterprise-admin/set-self-hosted-runners-in-group-for-enterprise"];
  };
  "/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/runners/{runner_id}": {
    /**
     * Adds a self-hosted runner to a runner group configured in an enterprise.
     *
     * You must authenticate using an access token with the `manage_runners:enterprise`
     * scope to use this endpoint.
     */
    put: operations["enterprise-admin/add-self-hosted-runner-to-group-for-enterprise"];
    /**
     * Removes a self-hosted runner from a group configured in an enterprise. The runner is then returned to the default group.
     *
     * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
     */
    delete: operations["enterprise-admin/remove-self-hosted-runner-from-group-for-enterprise"];
  };
  "/enterprises/{enterprise}/actions/runners": {
    /**
     * Lists all self-hosted runners configured for an enterprise.
     *
     * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
     */
    get: operations["enterprise-admin/list-self-hosted-runners-for-enterprise"];
  };
  "/enterprises/{enterprise}/actions/runners/downloads": {
    /**
     * Lists binaries for the runner application that you can download and run.
     *
     * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
     */
    get: operations["enterprise-admin/list-runner-applications-for-enterprise"];
  };
  "/enterprises/{enterprise}/actions/runners/registration-token": {
    /**
     * Returns a token that you can pass to the `config` script. The token expires after one hour.
     *
     * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
     *
     * #### Example using registration token
     *
     * Configure your self-hosted runner, replacing `TOKEN` with the registration token provided by this endpoint.
     *
     * ```
     * ./config.sh --url https://github.com/enterprises/octo-enterprise --token TOKEN
     * ```
     */
    post: operations["enterprise-admin/create-registration-token-for-enterprise"];
  };
  "/enterprises/{enterprise}/actions/runners/remove-token": {
    /**
     * Returns a token that you can pass to the `config` script to remove a self-hosted runner from an enterprise. The token expires after one hour.
     *
     * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
     *
     * #### Example using remove token
     *
     * To remove your self-hosted runner from an enterprise, replace `TOKEN` with the remove token provided by this
     * endpoint.
     *
     * ```
     * ./config.sh remove --token TOKEN
     * ```
     */
    post: operations["enterprise-admin/create-remove-token-for-enterprise"];
  };
  "/enterprises/{enterprise}/actions/runners/{runner_id}": {
    /**
     * Gets a specific self-hosted runner configured in an enterprise.
     *
     * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
     */
    get: operations["enterprise-admin/get-self-hosted-runner-for-enterprise"];
    /**
     * Forces the removal of a self-hosted runner from an enterprise. You can use this endpoint to completely remove the runner when the machine you were using no longer exists.
     *
     * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
     */
    delete: operations["enterprise-admin/delete-self-hosted-runner-from-enterprise"];
  };
  "/enterprises/{enterprise}/audit-log": {
    /** Gets the audit log for an enterprise. To use this endpoint, you must be an enterprise admin, and you must use an access token with the `admin:enterprise` scope. */
    get: operations["enterprise-admin/get-audit-log"];
  };
  "/events": {
    /** We delay the public events feed by five minutes, which means the most recent event returned by the public events API actually occurred at least five minutes ago. */
    get: operations["activity/list-public-events"];
  };
  "/feeds": {
    /**
     * GitHub Enterprise Server provides several timeline resources in [Atom](http://en.wikipedia.org/wiki/Atom_(standard)) format. The Feeds API lists all the feeds available to the authenticated user:
     *
     * *   **Timeline**: The GitHub Enterprise Server global public timeline
     * *   **User**: The public timeline for any user, using [URI template](https://docs.github.com/enterprise-server@3.3/rest/overview/resources-in-the-rest-api#hypermedia)
     * *   **Current user public**: The public timeline for the authenticated user
     * *   **Current user**: The private timeline for the authenticated user
     * *   **Current user actor**: The private timeline for activity created by the authenticated user
     * *   **Current user organizations**: The private timeline for the organizations the authenticated user is a member of.
     * *   **Security advisories**: A collection of public announcements that provide information about security-related vulnerabilities in software on GitHub Enterprise Server.
     *
     * **Note**: Private feeds are only returned when [authenticating via Basic Auth](https://docs.github.com/enterprise-server@3.3/rest/overview/other-authentication-methods#basic-authentication) since current feed URIs use the older, non revocable auth tokens.
     */
    get: operations["activity/get-feeds"];
  };
  "/gists": {
    /** Lists the authenticated user's gists or if called anonymously, this endpoint returns all public gists: */
    get: operations["gists/list"];
    /**
     * Allows you to add a new gist with one or more files.
     *
     * **Note:** Don't name your files "gistfile" with a numerical suffix. This is the format of the automatic naming scheme that Gist uses internally.
     */
    post: operations["gists/create"];
  };
  "/gists/public": {
    /**
     * List public gists sorted by most recently updated to least recently updated.
     *
     * Note: With [pagination](https://docs.github.com/enterprise-server@3.3/rest/overview/resources-in-the-rest-api#pagination), you can fetch up to 3000 gists. For example, you can fetch 100 pages with 30 gists per page or 30 pages with 100 gists per page.
     */
    get: operations["gists/list-public"];
  };
  "/gists/starred": {
    /** List the authenticated user's starred gists: */
    get: operations["gists/list-starred"];
  };
  "/gists/{gist_id}": {
    get: operations["gists/get"];
    delete: operations["gists/delete"];
    /** Allows you to update or delete a gist file and rename gist files. Files from the previous version of the gist that aren't explicitly changed during an edit are unchanged. */
    patch: operations["gists/update"];
  };
  "/gists/{gist_id}/comments": {
    get: operations["gists/list-comments"];
    post: operations["gists/create-comment"];
  };
  "/gists/{gist_id}/comments/{comment_id}": {
    get: operations["gists/get-comment"];
    delete: operations["gists/delete-comment"];
    patch: operations["gists/update-comment"];
  };
  "/gists/{gist_id}/commits": {
    get: operations["gists/list-commits"];
  };
  "/gists/{gist_id}/forks": {
    get: operations["gists/list-forks"];
    post: operations["gists/fork"];
  };
  "/gists/{gist_id}/star": {
    get: operations["gists/check-is-starred"];
    /** Note that you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://docs.github.com/enterprise-server@3.3/rest/overview/resources-in-the-rest-api#http-verbs)." */
    put: operations["gists/star"];
    delete: operations["gists/unstar"];
  };
  "/gists/{gist_id}/{sha}": {
    get: operations["gists/get-revision"];
  };
  "/gitignore/templates": {
    /** List all templates available to pass as an option when [creating a repository](https://docs.github.com/enterprise-server@3.3/rest/reference/repos#create-a-repository-for-the-authenticated-user). */
    get: operations["gitignore/get-all-templates"];
  };
  "/gitignore/templates/{name}": {
    /**
     * The API also allows fetching the source of a single template.
     * Use the raw [media type](https://docs.github.com/enterprise-server@3.3/rest/overview/media-types/) to get the raw contents.
     */
    get: operations["gitignore/get-template"];
  };
  "/installation/repositories": {
    /**
     * List repositories that an app installation can access.
     *
     * You must use an [installation access token](https://docs.github.com/enterprise-server@3.3/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-an-installation) to access this endpoint.
     */
    get: operations["apps/list-repos-accessible-to-installation"];
  };
  "/installation/token": {
    /**
     * Revokes the installation token you're using to authenticate as an installation and access this endpoint.
     *
     * Once an installation token is revoked, the token is invalidated and cannot be used. Other endpoints that require the revoked installation token must have a new installation token to work. You can create a new token using the "[Create an installation access token for an app](https://docs.github.com/enterprise-server@3.3/rest/reference/apps#create-an-installation-access-token-for-an-app)" endpoint.
     *
     * You must use an [installation access token](https://docs.github.com/enterprise-server@3.3/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-an-installation) to access this endpoint.
     */
    delete: operations["apps/revoke-installation-access-token"];
  };
  "/issues": {
    /**
     * List issues assigned to the authenticated user across all visible repositories including owned repositories, member
     * repositories, and organization repositories. You can use the `filter` query parameter to fetch issues that are not
     * necessarily assigned to you.
     *
     *
     * **Note**: GitHub's REST API v3 considers every pull request an issue, but not every issue is a pull request. For this
     * reason, "Issues" endpoints may return both issues and pull requests in the response. You can identify pull requests by
     * the `pull_request` key. Be aware that the `id` of a pull request returned from "Issues" endpoints will be an _issue id_. To find out the pull
     * request id, use the "[List pull requests](https://docs.github.com/enterprise-server@3.3/rest/reference/pulls#list-pull-requests)" endpoint.
     */
    get: operations["issues/list"];
  };
  "/licenses": {
    get: operations["licenses/get-all-commonly-used"];
  };
  "/licenses/{license}": {
    get: operations["licenses/get"];
  };
  "/markdown": {
    post: operations["markdown/render"];
  };
  "/markdown/raw": {
    /** You must send Markdown as plain text (using a `Content-Type` header of `text/plain` or `text/x-markdown`) to this endpoint, rather than using JSON format. In raw mode, [GitHub Flavored Markdown](https://github.github.com/gfm/) is not supported and Markdown will be rendered in plain format like a README.md file. Markdown content must be 400 KB or less. */
    post: operations["markdown/render-raw"];
  };
  "/meta": {
    get: operations["meta/get"];
  };
  "/networks/{owner}/{repo}/events": {
    get: operations["activity/list-public-events-for-repo-network"];
  };
  "/notifications": {
    /** List all notifications for the current user, sorted by most recently updated. */
    get: operations["activity/list-notifications-for-authenticated-user"];
    /** Marks all notifications as "read" removes it from the [default view on GitHub Enterprise Server](https://github.com/notifications). If the number of notifications is too large to complete in one request, you will receive a `202 Accepted` status and GitHub Enterprise Server will run an asynchronous process to mark notifications as "read." To check whether any "unread" notifications remain, you can use the [List notifications for the authenticated user](https://docs.github.com/enterprise-server@3.3/rest/reference/activity#list-notifications-for-the-authenticated-user) endpoint and pass the query parameter `all=false`. */
    put: operations["activity/mark-notifications-as-read"];
  };
  "/notifications/threads/{thread_id}": {
    get: operations["activity/get-thread"];
    patch: operations["activity/mark-thread-as-read"];
  };
  "/notifications/threads/{thread_id}/subscription": {
    /**
     * This checks to see if the current user is subscribed to a thread. You can also [get a repository subscription](https://docs.github.com/enterprise-server@3.3/rest/reference/activity#get-a-repository-subscription).
     *
     * Note that subscriptions are only generated if a user is participating in a conversation--for example, they've replied to the thread, were **@mentioned**, or manually subscribe to a thread.
     */
    get: operations["activity/get-thread-subscription-for-authenticated-user"];
    /**
     * If you are watching a repository, you receive notifications for all threads by default. Use this endpoint to ignore future notifications for threads until you comment on the thread or get an **@mention**.
     *
     * You can also use this endpoint to subscribe to threads that you are currently not receiving notifications for or to subscribed to threads that you have previously ignored.
     *
     * Unsubscribing from a conversation in a repository that you are not watching is functionally equivalent to the [Delete a thread subscription](https://docs.github.com/enterprise-server@3.3/rest/reference/activity#delete-a-thread-subscription) endpoint.
     */
    put: operations["activity/set-thread-subscription"];
    /** Mutes all future notifications for a conversation until you comment on the thread or get an **@mention**. If you are watching the repository of the thread, you will still receive notifications. To ignore future notifications for a repository you are watching, use the [Set a thread subscription](https://docs.github.com/enterprise-server@3.3/rest/reference/activity#set-a-thread-subscription) endpoint and set `ignore` to `true`. */
    delete: operations["activity/delete-thread-subscription"];
  };
  "/octocat": {
    /** Get the octocat as ASCII art */
    get: operations["meta/get-octocat"];
  };
  "/organizations": {
    /**
     * Lists all organizations, in the order that they were created on GitHub Enterprise Server.
     *
     * **Note:** Pagination is powered exclusively by the `since` parameter. Use the [Link header](https://docs.github.com/enterprise-server@3.3/rest/overview/resources-in-the-rest-api#link-header) to get the URL for the next page of organizations.
     */
    get: operations["orgs/list"];
  };
  "/orgs/{org}": {
    /**
     * To see many of the organization response values, you need to be an authenticated organization owner with the `admin:org` scope. When the value of `two_factor_requirement_enabled` is `true`, the organization requires all members, billing managers, and outside collaborators to enable [two-factor authentication](https://docs.github.com/articles/securing-your-account-with-two-factor-authentication-2fa/).
     *
     * GitHub Apps with the `Organization plan` permission can use this endpoint to retrieve information about an organization's GitHub Enterprise Server plan. See "[Authenticating with GitHub Apps](https://docs.github.com/enterprise-server@3.3/apps/building-github-apps/authenticating-with-github-apps/)" for details. For an example response, see 'Response with GitHub Enterprise Server plan information' below."
     */
    get: operations["orgs/get"];
    /**
     * **Parameter Deprecation Notice:** GitHub Enterprise Server will replace and discontinue `members_allowed_repository_creation_type` in favor of more granular permissions. The new input parameters are `members_can_create_public_repositories`, `members_can_create_private_repositories` for all organizations and `members_can_create_internal_repositories` for organizations associated with an enterprise account using GitHub Enterprise Cloud or GitHub Enterprise Server 2.20+. For more information, see the [blog post](https://developer.github.com/changes/2019-12-03-internal-visibility-changes).
     *
     * Enables an authenticated organization owner with the `admin:org` scope to update the organization's profile and member privileges.
     */
    patch: operations["orgs/update"];
  };
  "/orgs/{org}/actions/permissions": {
    /**
     * Gets the GitHub Actions permissions policy for repositories and allowed actions in an organization.
     *
     * You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `administration` organization permission to use this API.
     */
    get: operations["actions/get-github-actions-permissions-organization"];
    /**
     * Sets the GitHub Actions permissions policy for repositories and allowed actions in an organization.
     *
     * If the organization belongs to an enterprise that has set restrictive permissions at the enterprise level, such as `allowed_actions` to `selected` actions, then you cannot override them for the organization.
     *
     * You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `administration` organization permission to use this API.
     */
    put: operations["actions/set-github-actions-permissions-organization"];
  };
  "/orgs/{org}/actions/permissions/repositories": {
    /**
     * Lists the selected repositories that are enabled for GitHub Actions in an organization. To use this endpoint, the organization permission policy for `enabled_repositories` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization)."
     *
     * You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `administration` organization permission to use this API.
     */
    get: operations["actions/list-selected-repositories-enabled-github-actions-organization"];
    /**
     * Replaces the list of selected repositories that are enabled for GitHub Actions in an organization. To use this endpoint, the organization permission policy for `enabled_repositories` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization)."
     *
     * You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `administration` organization permission to use this API.
     */
    put: operations["actions/set-selected-repositories-enabled-github-actions-organization"];
  };
  "/orgs/{org}/actions/permissions/repositories/{repository_id}": {
    /**
     * Adds a repository to the list of selected repositories that are enabled for GitHub Actions in an organization. To use this endpoint, the organization permission policy for `enabled_repositories` must be must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization)."
     *
     * You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `administration` organization permission to use this API.
     */
    put: operations["actions/enable-selected-repository-github-actions-organization"];
    /**
     * Removes a repository from the list of selected repositories that are enabled for GitHub Actions in an organization. To use this endpoint, the organization permission policy for `enabled_repositories` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization)."
     *
     * You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `administration` organization permission to use this API.
     */
    delete: operations["actions/disable-selected-repository-github-actions-organization"];
  };
  "/orgs/{org}/actions/permissions/selected-actions": {
    /**
     * Gets the selected actions that are allowed in an organization. To use this endpoint, the organization permission policy for `allowed_actions` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization).""
     *
     * You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `administration` organization permission to use this API.
     */
    get: operations["actions/get-allowed-actions-organization"];
    /**
     * Sets the actions that are allowed in an organization. To use this endpoint, the organization permission policy for `allowed_actions` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization)."
     *
     * If the organization belongs to an enterprise that has `selected` actions set at the enterprise level, then you cannot override any of the enterprise's allowed actions settings.
     *
     * To use the `patterns_allowed` setting for private repositories, the organization must belong to an enterprise. If the organization does not belong to an enterprise, then the `patterns_allowed` setting only applies to public repositories in the organization.
     *
     * You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `administration` organization permission to use this API.
     */
    put: operations["actions/set-allowed-actions-organization"];
  };
  "/orgs/{org}/actions/runner-groups": {
    /**
     * Lists all self-hosted runner groups configured in an organization and inherited from an enterprise.
     * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
     */
    get: operations["actions/list-self-hosted-runner-groups-for-org"];
    /**
     * The self-hosted runner groups REST API is available with GitHub Enterprise Cloud and GitHub Enterprise Server. For more information, see "[GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products)."
     *
     * Creates a new self-hosted runner group for an organization.
     *
     * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
     */
    post: operations["actions/create-self-hosted-runner-group-for-org"];
  };
  "/orgs/{org}/actions/runner-groups/{runner_group_id}": {
    /**
     * Gets a specific self-hosted runner group for an organization.
     * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
     */
    get: operations["actions/get-self-hosted-runner-group-for-org"];
    /**
     * Deletes a self-hosted runner group for an organization.
     * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
     */
    delete: operations["actions/delete-self-hosted-runner-group-from-org"];
    /**
     * Updates the `name` and `visibility` of a self-hosted runner group in an organization.
     * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
     */
    patch: operations["actions/update-self-hosted-runner-group-for-org"];
  };
  "/orgs/{org}/actions/runner-groups/{runner_group_id}/repositories": {
    /**
     * The self-hosted runner groups REST API is available with GitHub Enterprise Cloud and GitHub Enterprise Server. For more information, see "[GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products)."
     *
     * Lists the repositories with access to a self-hosted runner group configured in an organization.
     *
     * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
     */
    get: operations["actions/list-repo-access-to-self-hosted-runner-group-in-org"];
    /**
     * Replaces the list of repositories that have access to a self-hosted runner group configured in an organization.
     * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
     */
    put: operations["actions/set-repo-access-to-self-hosted-runner-group-in-org"];
  };
  "/orgs/{org}/actions/runner-groups/{runner_group_id}/repositories/{repository_id}": {
    /**
     * Adds a repository to the list of selected repositories that can access a self-hosted runner group. The runner group must have `visibility` set to `selected`. For more information, see "[Create a self-hosted runner group for an organization](#create-a-self-hosted-runner-group-for-an-organization)."
     * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
     */
    put: operations["actions/add-repo-access-to-self-hosted-runner-group-in-org"];
    /**
     * Removes a repository from the list of selected repositories that can access a self-hosted runner group. The runner group must have `visibility` set to `selected`. For more information, see "[Create a self-hosted runner group for an organization](#create-a-self-hosted-runner-group-for-an-organization)."
     * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
     */
    delete: operations["actions/remove-repo-access-to-self-hosted-runner-group-in-org"];
  };
  "/orgs/{org}/actions/runner-groups/{runner_group_id}/runners": {
    /**
     * Lists self-hosted runners that are in a specific organization group.
     * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
     */
    get: operations["actions/list-self-hosted-runners-in-group-for-org"];
    /**
     * Replaces the list of self-hosted runners that are part of an organization runner group.
     * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
     */
    put: operations["actions/set-self-hosted-runners-in-group-for-org"];
  };
  "/orgs/{org}/actions/runner-groups/{runner_group_id}/runners/{runner_id}": {
    /**
     * Adds a self-hosted runner to a runner group configured in an organization.
     * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
     */
    put: operations["actions/add-self-hosted-runner-to-group-for-org"];
    /**
     * Removes a self-hosted runner from a group configured in an organization. The runner is then returned to the default group.
     * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
     */
    delete: operations["actions/remove-self-hosted-runner-from-group-for-org"];
  };
  "/orgs/{org}/actions/runners": {
    /**
     * Lists all self-hosted runners configured in an organization.
     *
     * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
     */
    get: operations["actions/list-self-hosted-runners-for-org"];
  };
  "/orgs/{org}/actions/runners/downloads": {
    /**
     * Lists binaries for the runner application that you can download and run.
     *
     * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
     */
    get: operations["actions/list-runner-applications-for-org"];
  };
  "/orgs/{org}/actions/runners/registration-token": {
    /**
     * Returns a token that you can pass to the `config` script. The token expires after one hour.
     *
     * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
     *
     * #### Example using registration token
     *
     * Configure your self-hosted runner, replacing `TOKEN` with the registration token provided by this endpoint.
     *
     * ```
     * ./config.sh --url https://github.com/octo-org --token TOKEN
     * ```
     */
    post: operations["actions/create-registration-token-for-org"];
  };
  "/orgs/{org}/actions/runners/remove-token": {
    /**
     * Returns a token that you can pass to the `config` script to remove a self-hosted runner from an organization. The token expires after one hour.
     *
     * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
     *
     * #### Example using remove token
     *
     * To remove your self-hosted runner from an organization, replace `TOKEN` with the remove token provided by this
     * endpoint.
     *
     * ```
     * ./config.sh remove --token TOKEN
     * ```
     */
    post: operations["actions/create-remove-token-for-org"];
  };
  "/orgs/{org}/actions/runners/{runner_id}": {
    /**
     * Gets a specific self-hosted runner configured in an organization.
     *
     * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
     */
    get: operations["actions/get-self-hosted-runner-for-org"];
    /**
     * Forces the removal of a self-hosted runner from an organization. You can use this endpoint to completely remove the runner when the machine you were using no longer exists.
     *
     * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
     */
    delete: operations["actions/delete-self-hosted-runner-from-org"];
  };
  "/orgs/{org}/actions/secrets": {
    /** Lists all secrets available in an organization without revealing their encrypted values. You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `secrets` organization permission to use this endpoint. */
    get: operations["actions/list-org-secrets"];
  };
  "/orgs/{org}/actions/secrets/public-key": {
    /** Gets your public key, which you need to encrypt secrets. You need to encrypt a secret before you can create or update secrets. You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `secrets` organization permission to use this endpoint. */
    get: operations["actions/get-org-public-key"];
  };
  "/orgs/{org}/actions/secrets/{secret_name}": {
    /** Gets a single organization secret without revealing its encrypted value. You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `secrets` organization permission to use this endpoint. */
    get: operations["actions/get-org-secret"];
    /**
     * Creates or updates an organization secret with an encrypted value. Encrypt your secret using
     * [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages). You must authenticate using an access
     * token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `secrets` organization permission to
     * use this endpoint.
     *
     * #### Example encrypting a secret using Node.js
     *
     * Encrypt your secret using the [tweetsodium](https://github.com/github/tweetsodium) library.
     *
     * ```
     * const sodium = require('tweetsodium');
     *
     * const key = "base64-encoded-public-key";
     * const value = "plain-text-secret";
     *
     * // Convert the message and key to Uint8Array's (Buffer implements that interface)
     * const messageBytes = Buffer.from(value);
     * const keyBytes = Buffer.from(key, 'base64');
     *
     * // Encrypt using LibSodium.
     * const encryptedBytes = sodium.seal(messageBytes, keyBytes);
     *
     * // Base64 the encrypted secret
     * const encrypted = Buffer.from(encryptedBytes).toString('base64');
     *
     * console.log(encrypted);
     * ```
     *
     *
     * #### Example encrypting a secret using Python
     *
     * Encrypt your secret using [pynacl](https://pynacl.readthedocs.io/en/latest/public/#nacl-public-sealedbox) with Python 3.
     *
     * ```
     * from base64 import b64encode
     * from nacl import encoding, public
     *
     * def encrypt(public_key: str, secret_value: str) -> str:
     *   """Encrypt a Unicode string using the public key."""
     *   public_key = public.PublicKey(public_key.encode("utf-8"), encoding.Base64Encoder())
     *   sealed_box = public.SealedBox(public_key)
     *   encrypted = sealed_box.encrypt(secret_value.encode("utf-8"))
     *   return b64encode(encrypted).decode("utf-8")
     * ```
     *
     * #### Example encrypting a secret using C#
     *
     * Encrypt your secret using the [Sodium.Core](https://www.nuget.org/packages/Sodium.Core/) package.
     *
     * ```
     * var secretValue = System.Text.Encoding.UTF8.GetBytes("mySecret");
     * var publicKey = Convert.FromBase64String("2Sg8iYjAxxmI2LvUXpJjkYrMxURPc8r+dB7TJyvvcCU=");
     *
     * var sealedPublicKeyBox = Sodium.SealedPublicKeyBox.Create(secretValue, publicKey);
     *
     * Console.WriteLine(Convert.ToBase64String(sealedPublicKeyBox));
     * ```
     *
     * #### Example encrypting a secret using Ruby
     *
     * Encrypt your secret using the [rbnacl](https://github.com/RubyCrypto/rbnacl) gem.
     *
     * ```ruby
     * require "rbnacl"
     * require "base64"
     *
     * key = Base64.decode64("+ZYvJDZMHUfBkJdyq5Zm9SKqeuBQ4sj+6sfjlH4CgG0=")
     * public_key = RbNaCl::PublicKey.new(key)
     *
     * box = RbNaCl::Boxes::Sealed.from_public_key(public_key)
     * encrypted_secret = box.encrypt("my_secret")
     *
     * # Print the base64 encoded secret
     * puts Base64.strict_encode64(encrypted_secret)
     * ```
     */
    put: operations["actions/create-or-update-org-secret"];
    /** Deletes a secret in an organization using the secret name. You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `secrets` organization permission to use this endpoint. */
    delete: operations["actions/delete-org-secret"];
  };
  "/orgs/{org}/actions/secrets/{secret_name}/repositories": {
    /** Lists all repositories that have been selected when the `visibility` for repository access to a secret is set to `selected`. You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `secrets` organization permission to use this endpoint. */
    get: operations["actions/list-selected-repos-for-org-secret"];
    /** Replaces all repositories for an organization secret when the `visibility` for repository access is set to `selected`. The visibility is set when you [Create or update an organization secret](https://docs.github.com/enterprise-server@3.3/rest/reference/actions#create-or-update-an-organization-secret). You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `secrets` organization permission to use this endpoint. */
    put: operations["actions/set-selected-repos-for-org-secret"];
  };
  "/orgs/{org}/actions/secrets/{secret_name}/repositories/{repository_id}": {
    /** Adds a repository to an organization secret when the `visibility` for repository access is set to `selected`. The visibility is set when you [Create or update an organization secret](https://docs.github.com/enterprise-server@3.3/rest/reference/actions#create-or-update-an-organization-secret). You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `secrets` organization permission to use this endpoint. */
    put: operations["actions/add-selected-repo-to-org-secret"];
    /** Removes a repository from an organization secret when the `visibility` for repository access is set to `selected`. The visibility is set when you [Create or update an organization secret](https://docs.github.com/enterprise-server@3.3/rest/reference/actions#create-or-update-an-organization-secret). You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `secrets` organization permission to use this endpoint. */
    delete: operations["actions/remove-selected-repo-from-org-secret"];
  };
  "/orgs/{org}/audit-log": {
    /**
     * Gets the audit log for an organization. For more information, see "[Reviewing the audit log for your organization](https://docs.github.com/enterprise-server@3.3/github/setting-up-and-managing-organizations-and-teams/reviewing-the-audit-log-for-your-organization)."
     *
     * To use this endpoint, you must be an organization owner, and you must use an access token with the `admin:org` scope. GitHub Apps must have the `organization_administration` read permission to use this endpoint.
     *
     * By default, the response includes up to 30 events from the past three months. Use the `phrase` parameter to filter results and retrieve older events. For example, use the `phrase` parameter with the `created` qualifier to filter events based on when the events occurred. For more information, see "[Reviewing the audit log for your organization](https://docs.github.com/enterprise-server@3.3/organizations/keeping-your-organization-secure/managing-security-settings-for-your-organization/reviewing-the-audit-log-for-your-organization#searching-the-audit-log)."
     *
     * Use pagination to retrieve fewer or more than 30 events. For more information, see "[Resources in the REST API](https://docs.github.com/enterprise-server@3.3/rest/overview/resources-in-the-rest-api#pagination)."
     */
    get: operations["orgs/get-audit-log"];
  };
  "/orgs/{org}/events": {
    get: operations["activity/list-public-org-events"];
  };
  "/orgs/{org}/hooks": {
    get: operations["orgs/list-webhooks"];
    /** Here's how you can create a hook that posts payloads in JSON format: */
    post: operations["orgs/create-webhook"];
  };
  "/orgs/{org}/hooks/{hook_id}": {
    /** Returns a webhook configured in an organization. To get only the webhook `config` properties, see "[Get a webhook configuration for an organization](/rest/reference/orgs#get-a-webhook-configuration-for-an-organization)." */
    get: operations["orgs/get-webhook"];
    delete: operations["orgs/delete-webhook"];
    /** Updates a webhook configured in an organization. When you update a webhook, the `secret` will be overwritten. If you previously had a `secret` set, you must provide the same `secret` or set a new `secret` or the secret will be removed. If you are only updating individual webhook `config` properties, use "[Update a webhook configuration for an organization](/rest/reference/orgs#update-a-webhook-configuration-for-an-organization)." */
    patch: operations["orgs/update-webhook"];
  };
  "/orgs/{org}/hooks/{hook_id}/config": {
    /**
     * Returns the webhook configuration for an organization. To get more information about the webhook, including the `active` state and `events`, use "[Get an organization webhook ](/rest/reference/orgs#get-an-organization-webhook)."
     *
     * Access tokens must have the `admin:org_hook` scope, and GitHub Apps must have the `organization_hooks:read` permission.
     */
    get: operations["orgs/get-webhook-config-for-org"];
    /**
     * Updates the webhook configuration for an organization. To update more information about the webhook, including the `active` state and `events`, use "[Update an organization webhook ](/rest/reference/orgs#update-an-organization-webhook)."
     *
     * Access tokens must have the `admin:org_hook` scope, and GitHub Apps must have the `organization_hooks:write` permission.
     */
    patch: operations["orgs/update-webhook-config-for-org"];
  };
  "/orgs/{org}/hooks/{hook_id}/deliveries": {
    /** Returns a list of webhook deliveries for a webhook configured in an organization. */
    get: operations["orgs/list-webhook-deliveries"];
  };
  "/orgs/{org}/hooks/{hook_id}/deliveries/{delivery_id}": {
    /** Returns a delivery for a webhook configured in an organization. */
    get: operations["orgs/get-webhook-delivery"];
  };
  "/orgs/{org}/hooks/{hook_id}/deliveries/{delivery_id}/attempts": {
    /** Redeliver a delivery for a webhook configured in an organization. */
    post: operations["orgs/redeliver-webhook-delivery"];
  };
  "/orgs/{org}/hooks/{hook_id}/pings": {
    /** This will trigger a [ping event](https://docs.github.com/enterprise-server@3.3/webhooks/#ping-event) to be sent to the hook. */
    post: operations["orgs/ping-webhook"];
  };
  "/orgs/{org}/installation": {
    /**
     * Enables an authenticated GitHub App to find the organization's installation information.
     *
     * You must use a [JWT](https://docs.github.com/enterprise-server@3.3/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
     */
    get: operations["apps/get-org-installation"];
  };
  "/orgs/{org}/installations": {
    /** Lists all GitHub Apps in an organization. The installation count includes all GitHub Apps installed on repositories in the organization. You must be an organization owner with `admin:read` scope to use this endpoint. */
    get: operations["orgs/list-app-installations"];
  };
  "/orgs/{org}/issues": {
    /**
     * List issues in an organization assigned to the authenticated user.
     *
     * **Note**: GitHub's REST API v3 considers every pull request an issue, but not every issue is a pull request. For this
     * reason, "Issues" endpoints may return both issues and pull requests in the response. You can identify pull requests by
     * the `pull_request` key. Be aware that the `id` of a pull request returned from "Issues" endpoints will be an _issue id_. To find out the pull
     * request id, use the "[List pull requests](https://docs.github.com/enterprise-server@3.3/rest/reference/pulls#list-pull-requests)" endpoint.
     */
    get: operations["issues/list-for-org"];
  };
  "/orgs/{org}/members": {
    /** List all users who are members of an organization. If the authenticated user is also a member of this organization then both concealed and public members will be returned. */
    get: operations["orgs/list-members"];
  };
  "/orgs/{org}/members/{username}": {
    /** Check if a user is, publicly or privately, a member of the organization. */
    get: operations["orgs/check-membership-for-user"];
    /** Removing a user from this list will remove them from all teams and they will no longer have any access to the organization's repositories. */
    delete: operations["orgs/remove-member"];
  };
  "/orgs/{org}/memberships/{username}": {
    /** In order to get a user's membership with an organization, the authenticated user must be an organization member. The `state` parameter in the response can be used to identify the user's membership status. */
    get: operations["orgs/get-membership-for-user"];
    /**
     * Only authenticated organization owners can add a member to the organization or update the member's role.
     *
     * *   If the authenticated user is _adding_ a member to the organization, the invited user will receive an email inviting them to the organization. The user's [membership status](https://docs.github.com/enterprise-server@3.3/rest/reference/orgs#get-organization-membership-for-a-user) will be `pending` until they accept the invitation.
     *
     * *   Authenticated users can _update_ a user's membership by passing the `role` parameter. If the authenticated user changes a member's role to `admin`, the affected user will receive an email notifying them that they've been made an organization owner. If the authenticated user changes an owner's role to `member`, no email will be sent.
     *
     * **Rate limits**
     *
     * To prevent abuse, the authenticated user is limited to 50 organization invitations per 24 hour period. If the organization is more than one month old or on a paid plan, the limit is 500 invitations per 24 hour period.
     */
    put: operations["orgs/set-membership-for-user"];
    /**
     * In order to remove a user's membership with an organization, the authenticated user must be an organization owner.
     *
     * If the specified user is an active member of the organization, this will remove them from the organization. If the specified user has been invited to the organization, this will cancel their invitation. The specified user will receive an email notification in both cases.
     */
    delete: operations["orgs/remove-membership-for-user"];
  };
  "/orgs/{org}/outside_collaborators": {
    /** List all users who are outside collaborators of an organization. */
    get: operations["orgs/list-outside-collaborators"];
  };
  "/orgs/{org}/outside_collaborators/{username}": {
    /** When an organization member is converted to an outside collaborator, they'll only have access to the repositories that their current team membership allows. The user will no longer be a member of the organization. For more information, see "[Converting an organization member to an outside collaborator](https://docs.github.com/enterprise-server@3.3/articles/converting-an-organization-member-to-an-outside-collaborator/)". */
    put: operations["orgs/convert-member-to-outside-collaborator"];
    /** Removing a user from this list will remove them from all the organization's repositories. */
    delete: operations["orgs/remove-outside-collaborator"];
  };
  "/orgs/{org}/pre-receive-hooks": {
    /** List all pre-receive hooks that are enabled or testing for this organization as well as any disabled hooks that can be configured at the organization level. Globally disabled pre-receive hooks that do not allow downstream configuration are not listed. */
    get: operations["enterprise-admin/list-pre-receive-hooks-for-org"];
  };
  "/orgs/{org}/pre-receive-hooks/{pre_receive_hook_id}": {
    get: operations["enterprise-admin/get-pre-receive-hook-for-org"];
    /** Removes any overrides for this hook at the org level for this org. */
    delete: operations["enterprise-admin/remove-pre-receive-hook-enforcement-for-org"];
    /** For pre-receive hooks which are allowed to be configured at the org level, you can set `enforcement` and `allow_downstream_configuration` */
    patch: operations["enterprise-admin/update-pre-receive-hook-enforcement-for-org"];
  };
  "/orgs/{org}/projects": {
    /** Lists the projects in an organization. Returns a `404 Not Found` status if projects are disabled in the organization. If you do not have sufficient privileges to perform this action, a `401 Unauthorized` or `410 Gone` status is returned. */
    get: operations["projects/list-for-org"];
    /** Creates an organization project board. Returns a `410 Gone` status if projects are disabled in the organization or if the organization does not have existing classic projects. If you do not have sufficient privileges to perform this action, a `401 Unauthorized` or `410 Gone` status is returned. */
    post: operations["projects/create-for-org"];
  };
  "/orgs/{org}/public_members": {
    /** Members of an organization can choose to have their membership publicized or not. */
    get: operations["orgs/list-public-members"];
  };
  "/orgs/{org}/public_members/{username}": {
    get: operations["orgs/check-public-membership-for-user"];
    /**
     * The user can publicize their own membership. (A user cannot publicize the membership for another user.)
     *
     * Note that you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://docs.github.com/enterprise-server@3.3/rest/overview/resources-in-the-rest-api#http-verbs)."
     */
    put: operations["orgs/set-public-membership-for-authenticated-user"];
    delete: operations["orgs/remove-public-membership-for-authenticated-user"];
  };
  "/orgs/{org}/repos": {
    /** Lists repositories for the specified organization. */
    get: operations["repos/list-for-org"];
    /**
     * Creates a new repository in the specified organization. The authenticated user must be a member of the organization.
     *
     * **OAuth scope requirements**
     *
     * When using [OAuth](https://docs.github.com/enterprise-server@3.3/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/), authorizations must include:
     *
     * *   `public_repo` scope or `repo` scope to create a public repository. Note: For GitHub AE, use `repo` scope to create an internal repository.
     * *   `repo` scope to create a private repository
     */
    post: operations["repos/create-in-org"];
  };
  "/orgs/{org}/secret-scanning/alerts": {
    /**
     * Lists secret scanning alerts for eligible repositories in an organization, from newest to oldest.
     * To use this endpoint, you must be an administrator or security manager for the organization, and you must use an access token with the `repo` scope or `security_events` scope.
     *
     * GitHub Apps must have the `secret_scanning_alerts` read permission to use this endpoint.
     */
    get: operations["secret-scanning/list-alerts-for-org"];
  };
  "/orgs/{org}/teams": {
    /** Lists all teams in an organization that are visible to the authenticated user. */
    get: operations["teams/list"];
    /**
     * To create a team, the authenticated user must be a member or owner of `{org}`. By default, organization members can create teams. Organization owners can limit team creation to organization owners. For more information, see "[Setting team creation permissions](https://docs.github.com/en/articles/setting-team-creation-permissions-in-your-organization)."
     *
     * When you create a new team, you automatically become a team maintainer without explicitly adding yourself to the optional array of `maintainers`. For more information, see "[About teams](https://docs.github.com/en/github/setting-up-and-managing-organizations-and-teams/about-teams)".
     */
    post: operations["teams/create"];
  };
  "/orgs/{org}/teams/{team_slug}": {
    /**
     * Gets a team using the team's `slug`. GitHub Enterprise Server generates the `slug` from the team `name`.
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}`.
     */
    get: operations["teams/get-by-name"];
    /**
     * To delete a team, the authenticated user must be an organization owner or team maintainer.
     *
     * If you are an organization owner, deleting a parent team will delete all of its child teams as well.
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `DELETE /organizations/{org_id}/team/{team_id}`.
     */
    delete: operations["teams/delete-in-org"];
    /**
     * To edit a team, the authenticated user must either be an organization owner or a team maintainer.
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `PATCH /organizations/{org_id}/team/{team_id}`.
     */
    patch: operations["teams/update-in-org"];
  };
  "/orgs/{org}/teams/{team_slug}/discussions": {
    /**
     * List all discussions on a team's page. OAuth access tokens require the `read:discussion` [scope](https://docs.github.com/enterprise-server@3.3/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/discussions`.
     */
    get: operations["teams/list-discussions-in-org"];
    /**
     * Creates a new discussion post on a team's page. OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/enterprise-server@3.3/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
     *
     * This endpoint triggers [notifications](https://docs.github.com/en/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. See "[Secondary rate limits](https://docs.github.com/enterprise-server@3.3/rest/overview/resources-in-the-rest-api#secondary-rate-limits)" and "[Dealing with secondary rate limits](https://docs.github.com/enterprise-server@3.3/rest/guides/best-practices-for-integrators#dealing-with-secondary-rate-limits)" for details.
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `POST /organizations/{org_id}/team/{team_id}/discussions`.
     */
    post: operations["teams/create-discussion-in-org"];
  };
  "/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}": {
    /**
     * Get a specific discussion on a team's page. OAuth access tokens require the `read:discussion` [scope](https://docs.github.com/enterprise-server@3.3/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}`.
     */
    get: operations["teams/get-discussion-in-org"];
    /**
     * Delete a discussion from a team's page. OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/enterprise-server@3.3/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `DELETE /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}`.
     */
    delete: operations["teams/delete-discussion-in-org"];
    /**
     * Edits the title and body text of a discussion post. Only the parameters you provide are updated. OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/enterprise-server@3.3/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `PATCH /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}`.
     */
    patch: operations["teams/update-discussion-in-org"];
  };
  "/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments": {
    /**
     * List all comments on a team discussion. OAuth access tokens require the `read:discussion` [scope](https://docs.github.com/enterprise-server@3.3/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}/comments`.
     */
    get: operations["teams/list-discussion-comments-in-org"];
    /**
     * Creates a new comment on a team discussion. OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/enterprise-server@3.3/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
     *
     * This endpoint triggers [notifications](https://docs.github.com/en/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. See "[Secondary rate limits](https://docs.github.com/enterprise-server@3.3/rest/overview/resources-in-the-rest-api#secondary-rate-limits)" and "[Dealing with secondary rate limits](https://docs.github.com/enterprise-server@3.3/rest/guides/best-practices-for-integrators#dealing-with-secondary-rate-limits)" for details.
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `POST /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}/comments`.
     */
    post: operations["teams/create-discussion-comment-in-org"];
  };
  "/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}": {
    /**
     * Get a specific comment on a team discussion. OAuth access tokens require the `read:discussion` [scope](https://docs.github.com/enterprise-server@3.3/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}/comments/{comment_number}`.
     */
    get: operations["teams/get-discussion-comment-in-org"];
    /**
     * Deletes a comment on a team discussion. OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/enterprise-server@3.3/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `DELETE /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}/comments/{comment_number}`.
     */
    delete: operations["teams/delete-discussion-comment-in-org"];
    /**
     * Edits the body text of a discussion comment. OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/enterprise-server@3.3/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `PATCH /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}/comments/{comment_number}`.
     */
    patch: operations["teams/update-discussion-comment-in-org"];
  };
  "/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions": {
    /**
     * List the reactions to a [team discussion comment](https://docs.github.com/enterprise-server@3.3/rest/reference/teams#discussion-comments/). OAuth access tokens require the `read:discussion` [scope](https://docs.github.com/enterprise-server@3.3/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/:org_id/team/:team_id/discussions/:discussion_number/comments/:comment_number/reactions`.
     */
    get: operations["reactions/list-for-team-discussion-comment-in-org"];
    /**
     * Create a reaction to a [team discussion comment](https://docs.github.com/enterprise-server@3.3/rest/reference/teams#discussion-comments). OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/enterprise-server@3.3/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/). A response with an HTTP `200` status means that you already added the reaction type to this team discussion comment.
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `POST /organizations/:org_id/team/:team_id/discussions/:discussion_number/comments/:comment_number/reactions`.
     */
    post: operations["reactions/create-for-team-discussion-comment-in-org"];
  };
  "/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions/{reaction_id}": {
    /**
     * **Note:** You can also specify a team or organization with `team_id` and `org_id` using the route `DELETE /organizations/:org_id/team/:team_id/discussions/:discussion_number/comments/:comment_number/reactions/:reaction_id`.
     *
     * Delete a reaction to a [team discussion comment](https://docs.github.com/enterprise-server@3.3/rest/reference/teams#discussion-comments). OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/enterprise-server@3.3/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
     */
    delete: operations["reactions/delete-for-team-discussion-comment"];
  };
  "/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions": {
    /**
     * List the reactions to a [team discussion](https://docs.github.com/enterprise-server@3.3/rest/reference/teams#discussions). OAuth access tokens require the `read:discussion` [scope](https://docs.github.com/enterprise-server@3.3/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/:org_id/team/:team_id/discussions/:discussion_number/reactions`.
     */
    get: operations["reactions/list-for-team-discussion-in-org"];
    /**
     * Create a reaction to a [team discussion](https://docs.github.com/enterprise-server@3.3/rest/reference/teams#discussions). OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/enterprise-server@3.3/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/). A response with an HTTP `200` status means that you already added the reaction type to this team discussion.
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `POST /organizations/:org_id/team/:team_id/discussions/:discussion_number/reactions`.
     */
    post: operations["reactions/create-for-team-discussion-in-org"];
  };
  "/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions/{reaction_id}": {
    /**
     * **Note:** You can also specify a team or organization with `team_id` and `org_id` using the route `DELETE /organizations/:org_id/team/:team_id/discussions/:discussion_number/reactions/:reaction_id`.
     *
     * Delete a reaction to a [team discussion](https://docs.github.com/enterprise-server@3.3/rest/reference/teams#discussions). OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/enterprise-server@3.3/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
     */
    delete: operations["reactions/delete-for-team-discussion"];
  };
  "/orgs/{org}/teams/{team_slug}/members": {
    /**
     * Team members will include the members of child teams.
     *
     * To list members in a team, the team must be visible to the authenticated user.
     */
    get: operations["teams/list-members-in-org"];
  };
  "/orgs/{org}/teams/{team_slug}/memberships/{username}": {
    /**
     * Team members will include the members of child teams.
     *
     * To get a user's membership with a team, the team must be visible to the authenticated user.
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/memberships/{username}`.
     *
     * **Note:**
     * The response contains the `state` of the membership and the member's `role`.
     *
     * The `role` for organization owners is set to `maintainer`. For more information about `maintainer` roles, see see [Create a team](https://docs.github.com/enterprise-server@3.3/rest/reference/teams#create-a-team).
     */
    get: operations["teams/get-membership-for-user-in-org"];
    /**
     * Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * Adds an organization member to a team. An authenticated organization owner or team maintainer can add organization members to a team.
     *
     * **Note:** When you have team synchronization set up for a team with your organization's identity provider (IdP), you will see an error if you attempt to use the API for making changes to the team's membership. If you have access to manage group membership in your IdP, you can manage GitHub Enterprise Server team membership through your identity provider, which automatically adds and removes team members in an organization. For more information, see "[Synchronizing teams between your identity provider and GitHub Enterprise Server](https://docs.github.com/articles/synchronizing-teams-between-your-identity-provider-and-github/)."
     *
     * An organization owner can add someone who is not part of the team's organization to a team. When an organization owner adds someone to a team who is not an organization member, this endpoint will send an invitation to the person via email. This newly-created membership will be in the "pending" state until the person accepts the invitation, at which point the membership will transition to the "active" state and the user will be added as a member of the team.
     *
     * If the user is already a member of the team, this endpoint will update the role of the team member's role. To update the membership of a team member, the authenticated user must be an organization owner or a team maintainer.
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `PUT /organizations/{org_id}/team/{team_id}/memberships/{username}`.
     */
    put: operations["teams/add-or-update-membership-for-user-in-org"];
    /**
     * Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * To remove a membership between a user and a team, the authenticated user must have 'admin' permissions to the team or be an owner of the organization that the team is associated with. Removing team membership does not delete the user, it just removes their membership from the team.
     *
     * **Note:** When you have team synchronization set up for a team with your organization's identity provider (IdP), you will see an error if you attempt to use the API for making changes to the team's membership. If you have access to manage group membership in your IdP, you can manage GitHub Enterprise Server team membership through your identity provider, which automatically adds and removes team members in an organization. For more information, see "[Synchronizing teams between your identity provider and GitHub Enterprise Server](https://docs.github.com/articles/synchronizing-teams-between-your-identity-provider-and-github/)."
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `DELETE /organizations/{org_id}/team/{team_id}/memberships/{username}`.
     */
    delete: operations["teams/remove-membership-for-user-in-org"];
  };
  "/orgs/{org}/teams/{team_slug}/projects": {
    /**
     * Lists the organization projects for a team.
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/projects`.
     */
    get: operations["teams/list-projects-in-org"];
  };
  "/orgs/{org}/teams/{team_slug}/projects/{project_id}": {
    /**
     * Checks whether a team has `read`, `write`, or `admin` permissions for an organization project. The response includes projects inherited from a parent team.
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/projects/{project_id}`.
     */
    get: operations["teams/check-permissions-for-project-in-org"];
    /**
     * Adds an organization project to a team. To add a project to a team or update the team's permission on a project, the authenticated user must have `admin` permissions for the project. The project and team must be part of the same organization.
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `PUT /organizations/{org_id}/team/{team_id}/projects/{project_id}`.
     */
    put: operations["teams/add-or-update-project-permissions-in-org"];
    /**
     * Removes an organization project from a team. An organization owner or a team maintainer can remove any project from the team. To remove a project from a team as an organization member, the authenticated user must have `read` access to both the team and project, or `admin` access to the team or project. This endpoint removes the project from the team, but does not delete the project.
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `DELETE /organizations/{org_id}/team/{team_id}/projects/{project_id}`.
     */
    delete: operations["teams/remove-project-in-org"];
  };
  "/orgs/{org}/teams/{team_slug}/repos": {
    /**
     * Lists a team's repositories visible to the authenticated user.
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/repos`.
     */
    get: operations["teams/list-repos-in-org"];
  };
  "/orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}": {
    /**
     * Checks whether a team has `admin`, `push`, `maintain`, `triage`, or `pull` permission for a repository. Repositories inherited through a parent team will also be checked.
     *
     * You can also get information about the specified repository, including what permissions the team grants on it, by passing the following custom [media type](https://docs.github.com/enterprise-server@3.3/rest/overview/media-types/) via the `application/vnd.github.v3.repository+json` accept header.
     *
     * If a team doesn't have permission for the repository, you will receive a `404 Not Found` response status.
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/repos/{owner}/{repo}`.
     */
    get: operations["teams/check-permissions-for-repo-in-org"];
    /**
     * To add a repository to a team or update the team's permission on a repository, the authenticated user must have admin access to the repository, and must be able to see the team. The repository must be owned by the organization, or a direct fork of a repository owned by the organization. You will get a `422 Unprocessable Entity` status if you attempt to add a repository to a team that is not owned by the organization. Note that, if you choose not to pass any parameters, you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://docs.github.com/enterprise-server@3.3/rest/overview/resources-in-the-rest-api#http-verbs)."
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `PUT /organizations/{org_id}/team/{team_id}/repos/{owner}/{repo}`.
     *
     * For more information about the permission levels, see "[Repository permission levels for an organization](https://docs.github.com/en/github/setting-up-and-managing-organizations-and-teams/repository-permission-levels-for-an-organization#permission-levels-for-repositories-owned-by-an-organization)".
     */
    put: operations["teams/add-or-update-repo-permissions-in-org"];
    /**
     * If the authenticated user is an organization owner or a team maintainer, they can remove any repositories from the team. To remove a repository from a team as an organization member, the authenticated user must have admin access to the repository and must be able to see the team. This does not delete the repository, it just removes it from the team.
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `DELETE /organizations/{org_id}/team/{team_id}/repos/{owner}/{repo}`.
     */
    delete: operations["teams/remove-repo-in-org"];
  };
  "/orgs/{org}/teams/{team_slug}/teams": {
    /**
     * Lists the child teams of the team specified by `{team_slug}`.
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/teams`.
     */
    get: operations["teams/list-child-in-org"];
  };
  "/projects/columns/cards/{card_id}": {
    get: operations["projects/get-card"];
    delete: operations["projects/delete-card"];
    patch: operations["projects/update-card"];
  };
  "/projects/columns/cards/{card_id}/moves": {
    post: operations["projects/move-card"];
  };
  "/projects/columns/{column_id}": {
    get: operations["projects/get-column"];
    delete: operations["projects/delete-column"];
    patch: operations["projects/update-column"];
  };
  "/projects/columns/{column_id}/cards": {
    get: operations["projects/list-cards"];
    post: operations["projects/create-card"];
  };
  "/projects/columns/{column_id}/moves": {
    post: operations["projects/move-column"];
  };
  "/projects/{project_id}": {
    /** Gets a project by its `id`. Returns a `404 Not Found` status if projects are disabled. If you do not have sufficient privileges to perform this action, a `401 Unauthorized` or `410 Gone` status is returned. */
    get: operations["projects/get"];
    /** Deletes a project board. Returns a `404 Not Found` status if projects are disabled. */
    delete: operations["projects/delete"];
    /** Updates a project board's information. Returns a `404 Not Found` status if projects are disabled. If you do not have sufficient privileges to perform this action, a `401 Unauthorized` or `410 Gone` status is returned. */
    patch: operations["projects/update"];
  };
  "/projects/{project_id}/collaborators": {
    /** Lists the collaborators for an organization project. For a project, the list of collaborators includes outside collaborators, organization members that are direct collaborators, organization members with access through team memberships, organization members with access through default organization permissions, and organization owners. You must be an organization owner or a project `admin` to list collaborators. */
    get: operations["projects/list-collaborators"];
  };
  "/projects/{project_id}/collaborators/{username}": {
    /** Adds a collaborator to an organization project and sets their permission level. You must be an organization owner or a project `admin` to add a collaborator. */
    put: operations["projects/add-collaborator"];
    /** Removes a collaborator from an organization project. You must be an organization owner or a project `admin` to remove a collaborator. */
    delete: operations["projects/remove-collaborator"];
  };
  "/projects/{project_id}/collaborators/{username}/permission": {
    /** Returns the collaborator's permission level for an organization project. Possible values for the `permission` key: `admin`, `write`, `read`, `none`. You must be an organization owner or a project `admin` to review a user's permission level. */
    get: operations["projects/get-permission-for-user"];
  };
  "/projects/{project_id}/columns": {
    get: operations["projects/list-columns"];
    post: operations["projects/create-column"];
  };
  "/rate_limit": {
    /**
     * **Note:** Accessing this endpoint does not count against your REST API rate limit.
     *
     * **Note:** The `rate` object is deprecated. If you're writing new API client code or updating existing code, you should use the `core` object instead of the `rate` object. The `core` object contains the same information that is present in the `rate` object.
     */
    get: operations["rate-limit/get"];
  };
  "/reactions/{reaction_id}": {
    /**
     * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Reactions API. We recommend migrating your existing code to use the new delete reactions endpoints. For more information, see this [blog post](https://developer.github.com/changes/2020-02-26-new-delete-reactions-endpoints/).
     *
     * OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/enterprise-server@3.3/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/), when deleting a [team discussion](https://docs.github.com/enterprise-server@3.3/rest/reference/teams#discussions) or [team discussion comment](https://docs.github.com/enterprise-server@3.3/rest/reference/teams#discussion-comments).
     */
    delete: operations["reactions/delete-legacy"];
  };
  "/repos/{owner}/{repo}": {
    /** The `parent` and `source` objects are present when the repository is a fork. `parent` is the repository this repository was forked from, `source` is the ultimate source for the network. */
    get: operations["repos/get"];
    /**
     * Deleting a repository requires admin access. If OAuth is used, the `delete_repo` scope is required.
     *
     * If an organization owner has configured the organization to prevent members from deleting organization-owned
     * repositories, you will get a `403 Forbidden` response.
     */
    delete: operations["repos/delete"];
    /** **Note**: To edit a repository's topics, use the [Replace all repository topics](https://docs.github.com/enterprise-server@3.3/rest/reference/repos#replace-all-repository-topics) endpoint. */
    patch: operations["repos/update"];
  };
  "/repos/{owner}/{repo}/actions/artifacts": {
    /** Lists all artifacts for a repository. Anyone with read access to the repository can use this endpoint. If the repository is private you must use an access token with the `repo` scope. GitHub Apps must have the `actions:read` permission to use this endpoint. */
    get: operations["actions/list-artifacts-for-repo"];
  };
  "/repos/{owner}/{repo}/actions/artifacts/{artifact_id}": {
    /** Gets a specific artifact for a workflow run. Anyone with read access to the repository can use this endpoint. If the repository is private you must use an access token with the `repo` scope. GitHub Apps must have the `actions:read` permission to use this endpoint. */
    get: operations["actions/get-artifact"];
    /** Deletes an artifact for a workflow run. You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `actions:write` permission to use this endpoint. */
    delete: operations["actions/delete-artifact"];
  };
  "/repos/{owner}/{repo}/actions/artifacts/{artifact_id}/{archive_format}": {
    /**
     * Gets a redirect URL to download an archive for a repository. This URL expires after 1 minute. Look for `Location:` in
     * the response header to find the URL for the download. The `:archive_format` must be `zip`. Anyone with read access to
     * the repository can use this endpoint. If the repository is private you must use an access token with the `repo` scope.
     * GitHub Apps must have the `actions:read` permission to use this endpoint.
     */
    get: operations["actions/download-artifact"];
  };
  "/repos/{owner}/{repo}/actions/jobs/{job_id}": {
    /** Gets a specific job in a workflow run. Anyone with read access to the repository can use this endpoint. If the repository is private you must use an access token with the `repo` scope. GitHub Apps must have the `actions:read` permission to use this endpoint. */
    get: operations["actions/get-job-for-workflow-run"];
  };
  "/repos/{owner}/{repo}/actions/jobs/{job_id}/logs": {
    /**
     * Gets a redirect URL to download a plain text file of logs for a workflow job. This link expires after 1 minute. Look
     * for `Location:` in the response header to find the URL for the download. Anyone with read access to the repository can
     * use this endpoint. If the repository is private you must use an access token with the `repo` scope. GitHub Apps must
     * have the `actions:read` permission to use this endpoint.
     */
    get: operations["actions/download-job-logs-for-workflow-run"];
  };
  "/repos/{owner}/{repo}/actions/permissions": {
    /**
     * Gets the GitHub Actions permissions policy for a repository, including whether GitHub Actions is enabled and the actions allowed to run in the repository.
     *
     * You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `administration` repository permission to use this API.
     */
    get: operations["actions/get-github-actions-permissions-repository"];
    /**
     * Sets the GitHub Actions permissions policy for enabling GitHub Actions and allowed actions in the repository.
     *
     * If the repository belongs to an organization or enterprise that has set restrictive permissions at the organization or enterprise levels, such as `allowed_actions` to `selected` actions, then you cannot override them for the repository.
     *
     * You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `administration` repository permission to use this API.
     */
    put: operations["actions/set-github-actions-permissions-repository"];
  };
  "/repos/{owner}/{repo}/actions/permissions/selected-actions": {
    /**
     * Gets the settings for selected actions that are allowed in a repository. To use this endpoint, the repository policy for `allowed_actions` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for a repository](#set-github-actions-permissions-for-a-repository)."
     *
     * You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `administration` repository permission to use this API.
     */
    get: operations["actions/get-allowed-actions-repository"];
    /**
     * Sets the actions that are allowed in a repository. To use this endpoint, the repository permission policy for `allowed_actions` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for a repository](#set-github-actions-permissions-for-a-repository)."
     *
     * If the repository belongs to an organization or enterprise that has `selected` actions set at the organization or enterprise levels, then you cannot override any of the allowed actions settings.
     *
     * To use the `patterns_allowed` setting for private repositories, the repository must belong to an enterprise. If the repository does not belong to an enterprise, then the `patterns_allowed` setting only applies to public repositories.
     *
     * You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `administration` repository permission to use this API.
     */
    put: operations["actions/set-allowed-actions-repository"];
  };
  "/repos/{owner}/{repo}/actions/runners": {
    /** Lists all self-hosted runners configured in a repository. You must authenticate using an access token with the `repo` scope to use this endpoint. */
    get: operations["actions/list-self-hosted-runners-for-repo"];
  };
  "/repos/{owner}/{repo}/actions/runners/downloads": {
    /**
     * Lists binaries for the runner application that you can download and run.
     *
     * You must authenticate using an access token with the `repo` scope to use this endpoint.
     */
    get: operations["actions/list-runner-applications-for-repo"];
  };
  "/repos/{owner}/{repo}/actions/runners/registration-token": {
    /**
     * Returns a token that you can pass to the `config` script. The token expires after one hour. You must authenticate
     * using an access token with the `repo` scope to use this endpoint.
     *
     * #### Example using registration token
     *
     * Configure your self-hosted runner, replacing `TOKEN` with the registration token provided by this endpoint.
     *
     * ```
     * ./config.sh --url https://github.com/octo-org/octo-repo-artifacts --token TOKEN
     * ```
     */
    post: operations["actions/create-registration-token-for-repo"];
  };
  "/repos/{owner}/{repo}/actions/runners/remove-token": {
    /**
     * Returns a token that you can pass to remove a self-hosted runner from a repository. The token expires after one hour.
     * You must authenticate using an access token with the `repo` scope to use this endpoint.
     *
     * #### Example using remove token
     *
     * To remove your self-hosted runner from a repository, replace TOKEN with the remove token provided by this endpoint.
     *
     * ```
     * ./config.sh remove --token TOKEN
     * ```
     */
    post: operations["actions/create-remove-token-for-repo"];
  };
  "/repos/{owner}/{repo}/actions/runners/{runner_id}": {
    /**
     * Gets a specific self-hosted runner configured in a repository.
     *
     * You must authenticate using an access token with the `repo` scope to use this
     * endpoint.
     */
    get: operations["actions/get-self-hosted-runner-for-repo"];
    /**
     * Forces the removal of a self-hosted runner from a repository. You can use this endpoint to completely remove the runner when the machine you were using no longer exists.
     *
     * You must authenticate using an access token with the `repo`
     * scope to use this endpoint.
     */
    delete: operations["actions/delete-self-hosted-runner-from-repo"];
  };
  "/repos/{owner}/{repo}/actions/runs": {
    /**
     * Lists all workflow runs for a repository. You can use parameters to narrow the list of results. For more information about using parameters, see [Parameters](https://docs.github.com/enterprise-server@3.3/rest/overview/resources-in-the-rest-api#parameters).
     *
     * Anyone with read access to the repository can use this endpoint. If the repository is private you must use an access token with the `repo` scope. GitHub Apps must have the `actions:read` permission to use this endpoint.
     */
    get: operations["actions/list-workflow-runs-for-repo"];
  };
  "/repos/{owner}/{repo}/actions/runs/{run_id}": {
    /** Gets a specific workflow run. Anyone with read access to the repository can use this endpoint. If the repository is private you must use an access token with the `repo` scope. GitHub Apps must have the `actions:read` permission to use this endpoint. */
    get: operations["actions/get-workflow-run"];
    /**
     * Delete a specific workflow run. Anyone with write access to the repository can use this endpoint. If the repository is
     * private you must use an access token with the `repo` scope. GitHub Apps must have the `actions:write` permission to use
     * this endpoint.
     */
    delete: operations["actions/delete-workflow-run"];
  };
  "/repos/{owner}/{repo}/actions/runs/{run_id}/approvals": {
    /** Anyone with read access to the repository can use this endpoint. If the repository is private, you must use an access token with the `repo` scope. GitHub Apps must have the `actions:read` permission to use this endpoint. */
    get: operations["actions/get-reviews-for-run"];
  };
  "/repos/{owner}/{repo}/actions/runs/{run_id}/artifacts": {
    /** Lists artifacts for a workflow run. Anyone with read access to the repository can use this endpoint. If the repository is private you must use an access token with the `repo` scope. GitHub Apps must have the `actions:read` permission to use this endpoint. */
    get: operations["actions/list-workflow-run-artifacts"];
  };
  "/repos/{owner}/{repo}/actions/runs/{run_id}/cancel": {
    /** Cancels a workflow run using its `id`. You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `actions:write` permission to use this endpoint. */
    post: operations["actions/cancel-workflow-run"];
  };
  "/repos/{owner}/{repo}/actions/runs/{run_id}/jobs": {
    /** Lists jobs for a workflow run. Anyone with read access to the repository can use this endpoint. If the repository is private you must use an access token with the `repo` scope. GitHub Apps must have the `actions:read` permission to use this endpoint. You can use parameters to narrow the list of results. For more information about using parameters, see [Parameters](https://docs.github.com/enterprise-server@3.3/rest/overview/resources-in-the-rest-api#parameters). */
    get: operations["actions/list-jobs-for-workflow-run"];
  };
  "/repos/{owner}/{repo}/actions/runs/{run_id}/logs": {
    /**
     * Gets a redirect URL to download an archive of log files for a workflow run. This link expires after 1 minute. Look for
     * `Location:` in the response header to find the URL for the download. Anyone with read access to the repository can use
     * this endpoint. If the repository is private you must use an access token with the `repo` scope. GitHub Apps must have
     * the `actions:read` permission to use this endpoint.
     */
    get: operations["actions/download-workflow-run-logs"];
    /** Deletes all logs for a workflow run. You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `actions:write` permission to use this endpoint. */
    delete: operations["actions/delete-workflow-run-logs"];
  };
  "/repos/{owner}/{repo}/actions/runs/{run_id}/pending_deployments": {
    /**
     * Get all deployment environments for a workflow run that are waiting for protection rules to pass.
     *
     * Anyone with read access to the repository can use this endpoint. If the repository is private, you must use an access token with the `repo` scope. GitHub Apps must have the `actions:read` permission to use this endpoint.
     */
    get: operations["actions/get-pending-deployments-for-run"];
    /**
     * Approve or reject pending deployments that are waiting on approval by a required reviewer.
     *
     * Required reviewers with read access to the repository contents and deployments can use this endpoint. Required reviewers must authenticate using an access token with the `repo` scope to use this endpoint.
     */
    post: operations["actions/review-pending-deployments-for-run"];
  };
  "/repos/{owner}/{repo}/actions/runs/{run_id}/rerun": {
    /** Re-runs your workflow run using its `id`. You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `actions:write` permission to use this endpoint. */
    post: operations["actions/re-run-workflow"];
  };
  "/repos/{owner}/{repo}/actions/secrets": {
    /** Lists all secrets available in a repository without revealing their encrypted values. You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `secrets` repository permission to use this endpoint. */
    get: operations["actions/list-repo-secrets"];
  };
  "/repos/{owner}/{repo}/actions/secrets/public-key": {
    /** Gets your public key, which you need to encrypt secrets. You need to encrypt a secret before you can create or update secrets. Anyone with read access to the repository can use this endpoint. If the repository is private you must use an access token with the `repo` scope. GitHub Apps must have the `secrets` repository permission to use this endpoint. */
    get: operations["actions/get-repo-public-key"];
  };
  "/repos/{owner}/{repo}/actions/secrets/{secret_name}": {
    /** Gets a single repository secret without revealing its encrypted value. You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `secrets` repository permission to use this endpoint. */
    get: operations["actions/get-repo-secret"];
    /**
     * Creates or updates a repository secret with an encrypted value. Encrypt your secret using
     * [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages). You must authenticate using an access
     * token with the `repo` scope to use this endpoint. GitHub Apps must have the `secrets` repository permission to use
     * this endpoint.
     *
     * #### Example encrypting a secret using Node.js
     *
     * Encrypt your secret using the [tweetsodium](https://github.com/github/tweetsodium) library.
     *
     * ```
     * const sodium = require('tweetsodium');
     *
     * const key = "base64-encoded-public-key";
     * const value = "plain-text-secret";
     *
     * // Convert the message and key to Uint8Array's (Buffer implements that interface)
     * const messageBytes = Buffer.from(value);
     * const keyBytes = Buffer.from(key, 'base64');
     *
     * // Encrypt using LibSodium.
     * const encryptedBytes = sodium.seal(messageBytes, keyBytes);
     *
     * // Base64 the encrypted secret
     * const encrypted = Buffer.from(encryptedBytes).toString('base64');
     *
     * console.log(encrypted);
     * ```
     *
     *
     * #### Example encrypting a secret using Python
     *
     * Encrypt your secret using [pynacl](https://pynacl.readthedocs.io/en/latest/public/#nacl-public-sealedbox) with Python 3.
     *
     * ```
     * from base64 import b64encode
     * from nacl import encoding, public
     *
     * def encrypt(public_key: str, secret_value: str) -> str:
     *   """Encrypt a Unicode string using the public key."""
     *   public_key = public.PublicKey(public_key.encode("utf-8"), encoding.Base64Encoder())
     *   sealed_box = public.SealedBox(public_key)
     *   encrypted = sealed_box.encrypt(secret_value.encode("utf-8"))
     *   return b64encode(encrypted).decode("utf-8")
     * ```
     *
     * #### Example encrypting a secret using C#
     *
     * Encrypt your secret using the [Sodium.Core](https://www.nuget.org/packages/Sodium.Core/) package.
     *
     * ```
     * var secretValue = System.Text.Encoding.UTF8.GetBytes("mySecret");
     * var publicKey = Convert.FromBase64String("2Sg8iYjAxxmI2LvUXpJjkYrMxURPc8r+dB7TJyvvcCU=");
     *
     * var sealedPublicKeyBox = Sodium.SealedPublicKeyBox.Create(secretValue, publicKey);
     *
     * Console.WriteLine(Convert.ToBase64String(sealedPublicKeyBox));
     * ```
     *
     * #### Example encrypting a secret using Ruby
     *
     * Encrypt your secret using the [rbnacl](https://github.com/RubyCrypto/rbnacl) gem.
     *
     * ```ruby
     * require "rbnacl"
     * require "base64"
     *
     * key = Base64.decode64("+ZYvJDZMHUfBkJdyq5Zm9SKqeuBQ4sj+6sfjlH4CgG0=")
     * public_key = RbNaCl::PublicKey.new(key)
     *
     * box = RbNaCl::Boxes::Sealed.from_public_key(public_key)
     * encrypted_secret = box.encrypt("my_secret")
     *
     * # Print the base64 encoded secret
     * puts Base64.strict_encode64(encrypted_secret)
     * ```
     */
    put: operations["actions/create-or-update-repo-secret"];
    /** Deletes a secret in a repository using the secret name. You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `secrets` repository permission to use this endpoint. */
    delete: operations["actions/delete-repo-secret"];
  };
  "/repos/{owner}/{repo}/actions/workflows": {
    /** Lists the workflows in a repository. Anyone with read access to the repository can use this endpoint. If the repository is private you must use an access token with the `repo` scope. GitHub Apps must have the `actions:read` permission to use this endpoint. */
    get: operations["actions/list-repo-workflows"];
  };
  "/repos/{owner}/{repo}/actions/workflows/{workflow_id}": {
    /** Gets a specific workflow. You can replace `workflow_id` with the workflow file name. For example, you could use `main.yaml`. Anyone with read access to the repository can use this endpoint. If the repository is private you must use an access token with the `repo` scope. GitHub Apps must have the `actions:read` permission to use this endpoint. */
    get: operations["actions/get-workflow"];
  };
  "/repos/{owner}/{repo}/actions/workflows/{workflow_id}/disable": {
    /**
     * Disables a workflow and sets the `state` of the workflow to `disabled_manually`. You can replace `workflow_id` with the workflow file name. For example, you could use `main.yaml`.
     *
     * You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `actions:write` permission to use this endpoint.
     */
    put: operations["actions/disable-workflow"];
  };
  "/repos/{owner}/{repo}/actions/workflows/{workflow_id}/dispatches": {
    /**
     * You can use this endpoint to manually trigger a GitHub Actions workflow run. You can replace `workflow_id` with the workflow file name. For example, you could use `main.yaml`.
     *
     * You must configure your GitHub Actions workflow to run when the [`workflow_dispatch` webhook](/developers/webhooks-and-events/webhook-events-and-payloads#workflow_dispatch) event occurs. The `inputs` are configured in the workflow file. For more information about how to configure the `workflow_dispatch` event in the workflow file, see "[Events that trigger workflows](/actions/reference/events-that-trigger-workflows#workflow_dispatch)."
     *
     * You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `actions:write` permission to use this endpoint. For more information, see "[Creating a personal access token for the command line](https://docs.github.com/articles/creating-a-personal-access-token-for-the-command-line)."
     */
    post: operations["actions/create-workflow-dispatch"];
  };
  "/repos/{owner}/{repo}/actions/workflows/{workflow_id}/enable": {
    /**
     * Enables a workflow and sets the `state` of the workflow to `active`. You can replace `workflow_id` with the workflow file name. For example, you could use `main.yaml`.
     *
     * You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `actions:write` permission to use this endpoint.
     */
    put: operations["actions/enable-workflow"];
  };
  "/repos/{owner}/{repo}/actions/workflows/{workflow_id}/runs": {
    /**
     * List all workflow runs for a workflow. You can replace `workflow_id` with the workflow file name. For example, you could use `main.yaml`. You can use parameters to narrow the list of results. For more information about using parameters, see [Parameters](https://docs.github.com/enterprise-server@3.3/rest/overview/resources-in-the-rest-api#parameters).
     *
     * Anyone with read access to the repository can use this endpoint. If the repository is private you must use an access token with the `repo` scope.
     */
    get: operations["actions/list-workflow-runs"];
  };
  "/repos/{owner}/{repo}/assignees": {
    /** Lists the [available assignees](https://docs.github.com/articles/assigning-issues-and-pull-requests-to-other-github-users/) for issues in a repository. */
    get: operations["issues/list-assignees"];
  };
  "/repos/{owner}/{repo}/assignees/{assignee}": {
    /**
     * Checks if a user has permission to be assigned to an issue in this repository.
     *
     * If the `assignee` can be assigned to issues in the repository, a `204` header with no content is returned.
     *
     * Otherwise a `404` status code is returned.
     */
    get: operations["issues/check-user-can-be-assigned"];
  };
  "/repos/{owner}/{repo}/autolinks": {
    /**
     * This returns a list of autolinks configured for the given repository.
     *
     * Information about autolinks are only available to repository administrators.
     */
    get: operations["repos/list-autolinks"];
    /** Users with admin access to the repository can create an autolink. */
    post: operations["repos/create-autolink"];
  };
  "/repos/{owner}/{repo}/autolinks/{autolink_id}": {
    /**
     * This returns a single autolink reference by ID that was configured for the given repository.
     *
     * Information about autolinks are only available to repository administrators.
     */
    get: operations["repos/get-autolink"];
    /**
     * This deletes a single autolink reference by ID that was configured for the given repository.
     *
     * Information about autolinks are only available to repository administrators.
     */
    delete: operations["repos/delete-autolink"];
  };
  "/repos/{owner}/{repo}/branches": {
    get: operations["repos/list-branches"];
  };
  "/repos/{owner}/{repo}/branches/{branch}": {
    get: operations["repos/get-branch"];
  };
  "/repos/{owner}/{repo}/branches/{branch}/protection": {
    /** Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation. */
    get: operations["repos/get-branch-protection"];
    /**
     * Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * Protecting a branch requires admin or owner permissions to the repository.
     *
     * **Note**: Passing new arrays of `users` and `teams` replaces their previous values.
     *
     * **Note**: The list of users, apps, and teams in total is limited to 100 items.
     */
    put: operations["repos/update-branch-protection"];
    /** Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation. */
    delete: operations["repos/delete-branch-protection"];
  };
  "/repos/{owner}/{repo}/branches/{branch}/protection/enforce_admins": {
    /** Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation. */
    get: operations["repos/get-admin-branch-protection"];
    /**
     * Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * Adding admin enforcement requires admin or owner permissions to the repository and branch protection to be enabled.
     */
    post: operations["repos/set-admin-branch-protection"];
    /**
     * Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * Removing admin enforcement requires admin or owner permissions to the repository and branch protection to be enabled.
     */
    delete: operations["repos/delete-admin-branch-protection"];
  };
  "/repos/{owner}/{repo}/branches/{branch}/protection/required_pull_request_reviews": {
    /** Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation. */
    get: operations["repos/get-pull-request-review-protection"];
    /** Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation. */
    delete: operations["repos/delete-pull-request-review-protection"];
    /**
     * Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * Updating pull request review enforcement requires admin or owner permissions to the repository and branch protection to be enabled.
     *
     * **Note**: Passing new arrays of `users` and `teams` replaces their previous values.
     */
    patch: operations["repos/update-pull-request-review-protection"];
  };
  "/repos/{owner}/{repo}/branches/{branch}/protection/required_signatures": {
    /**
     * Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * When authenticated with admin or owner permissions to the repository, you can use this endpoint to check whether a branch requires signed commits. An enabled status of `true` indicates you must sign commits on this branch. For more information, see [Signing commits with GPG](https://docs.github.com/articles/signing-commits-with-gpg) in GitHub Help.
     *
     * **Note**: You must enable branch protection to require signed commits.
     */
    get: operations["repos/get-commit-signature-protection"];
    /**
     * Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * When authenticated with admin or owner permissions to the repository, you can use this endpoint to require signed commits on a branch. You must enable branch protection to require signed commits.
     */
    post: operations["repos/create-commit-signature-protection"];
    /**
     * Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * When authenticated with admin or owner permissions to the repository, you can use this endpoint to disable required signed commits on a branch. You must enable branch protection to require signed commits.
     */
    delete: operations["repos/delete-commit-signature-protection"];
  };
  "/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks": {
    /** Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation. */
    get: operations["repos/get-status-checks-protection"];
    /** Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation. */
    delete: operations["repos/remove-status-check-protection"];
    /**
     * Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * Updating required status checks requires admin or owner permissions to the repository and branch protection to be enabled.
     */
    patch: operations["repos/update-status-check-protection"];
  };
  "/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts": {
    /** Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation. */
    get: operations["repos/get-all-status-check-contexts"];
    /** Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation. */
    put: operations["repos/set-status-check-contexts"];
    /** Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation. */
    post: operations["repos/add-status-check-contexts"];
    /** Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation. */
    delete: operations["repos/remove-status-check-contexts"];
  };
  "/repos/{owner}/{repo}/branches/{branch}/protection/restrictions": {
    /**
     * Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * Lists who has access to this protected branch.
     *
     * **Note**: Users, apps, and teams `restrictions` are only available for organization-owned repositories.
     */
    get: operations["repos/get-access-restrictions"];
    /**
     * Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * Disables the ability to restrict who can push to this branch.
     */
    delete: operations["repos/delete-access-restrictions"];
  };
  "/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps": {
    /**
     * Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * Lists the GitHub Apps that have push access to this branch. Only installed GitHub Apps with `write` access to the `contents` permission can be added as authorized actors on a protected branch.
     */
    get: operations["repos/get-apps-with-access-to-protected-branch"];
    /**
     * Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * Replaces the list of apps that have push access to this branch. This removes all apps that previously had push access and grants push access to the new list of apps. Only installed GitHub Apps with `write` access to the `contents` permission can be added as authorized actors on a protected branch.
     *
     * | Type    | Description                                                                                                                                                |
     * | ------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------- |
     * | `array` | The GitHub Apps that have push access to this branch. Use the app's `slug`. **Note**: The list of users, apps, and teams in total is limited to 100 items. |
     */
    put: operations["repos/set-app-access-restrictions"];
    /**
     * Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * Grants the specified apps push access for this branch. Only installed GitHub Apps with `write` access to the `contents` permission can be added as authorized actors on a protected branch.
     *
     * | Type    | Description                                                                                                                                                |
     * | ------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------- |
     * | `array` | The GitHub Apps that have push access to this branch. Use the app's `slug`. **Note**: The list of users, apps, and teams in total is limited to 100 items. |
     */
    post: operations["repos/add-app-access-restrictions"];
    /**
     * Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * Removes the ability of an app to push to this branch. Only installed GitHub Apps with `write` access to the `contents` permission can be added as authorized actors on a protected branch.
     *
     * | Type    | Description                                                                                                                                                |
     * | ------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------- |
     * | `array` | The GitHub Apps that have push access to this branch. Use the app's `slug`. **Note**: The list of users, apps, and teams in total is limited to 100 items. |
     */
    delete: operations["repos/remove-app-access-restrictions"];
  };
  "/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams": {
    /**
     * Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * Lists the teams who have push access to this branch. The list includes child teams.
     */
    get: operations["repos/get-teams-with-access-to-protected-branch"];
    /**
     * Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * Replaces the list of teams that have push access to this branch. This removes all teams that previously had push access and grants push access to the new list of teams. Team restrictions include child teams.
     *
     * | Type    | Description                                                                                                                                |
     * | ------- | ------------------------------------------------------------------------------------------------------------------------------------------ |
     * | `array` | The teams that can have push access. Use the team's `slug`. **Note**: The list of users, apps, and teams in total is limited to 100 items. |
     */
    put: operations["repos/set-team-access-restrictions"];
    /**
     * Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * Grants the specified teams push access for this branch. You can also give push access to child teams.
     *
     * | Type    | Description                                                                                                                                |
     * | ------- | ------------------------------------------------------------------------------------------------------------------------------------------ |
     * | `array` | The teams that can have push access. Use the team's `slug`. **Note**: The list of users, apps, and teams in total is limited to 100 items. |
     */
    post: operations["repos/add-team-access-restrictions"];
    /**
     * Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * Removes the ability of a team to push to this branch. You can also remove push access for child teams.
     *
     * | Type    | Description                                                                                                                                         |
     * | ------- | --------------------------------------------------------------------------------------------------------------------------------------------------- |
     * | `array` | Teams that should no longer have push access. Use the team's `slug`. **Note**: The list of users, apps, and teams in total is limited to 100 items. |
     */
    delete: operations["repos/remove-team-access-restrictions"];
  };
  "/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users": {
    /**
     * Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * Lists the people who have push access to this branch.
     */
    get: operations["repos/get-users-with-access-to-protected-branch"];
    /**
     * Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * Replaces the list of people that have push access to this branch. This removes all people that previously had push access and grants push access to the new list of people.
     *
     * | Type    | Description                                                                                                                   |
     * | ------- | ----------------------------------------------------------------------------------------------------------------------------- |
     * | `array` | Usernames for people who can have push access. **Note**: The list of users, apps, and teams in total is limited to 100 items. |
     */
    put: operations["repos/set-user-access-restrictions"];
    /**
     * Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * Grants the specified people push access for this branch.
     *
     * | Type    | Description                                                                                                                   |
     * | ------- | ----------------------------------------------------------------------------------------------------------------------------- |
     * | `array` | Usernames for people who can have push access. **Note**: The list of users, apps, and teams in total is limited to 100 items. |
     */
    post: operations["repos/add-user-access-restrictions"];
    /**
     * Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * Removes the ability of a user to push to this branch.
     *
     * | Type    | Description                                                                                                                                   |
     * | ------- | --------------------------------------------------------------------------------------------------------------------------------------------- |
     * | `array` | Usernames of the people who should no longer have push access. **Note**: The list of users, apps, and teams in total is limited to 100 items. |
     */
    delete: operations["repos/remove-user-access-restrictions"];
  };
  "/repos/{owner}/{repo}/branches/{branch}/rename": {
    /**
     * Renames a branch in a repository.
     *
     * **Note:** Although the API responds immediately, the branch rename process might take some extra time to complete in the background. You won't be able to push to the old branch name while the rename process is in progress. For more information, see "[Renaming a branch](https://docs.github.com/enterprise-server@3.3/github/administering-a-repository/renaming-a-branch)".
     *
     * The permissions required to use this endpoint depends on whether you are renaming the default branch.
     *
     * To rename a non-default branch:
     *
     * * Users must have push access.
     * * GitHub Apps must have the `contents:write` repository permission.
     *
     * To rename the default branch:
     *
     * * Users must have admin or owner permissions.
     * * GitHub Apps must have the `administration:write` repository permission.
     */
    post: operations["repos/rename-branch"];
  };
  "/repos/{owner}/{repo}/check-runs": {
    /**
     * **Note:** The Checks API only looks for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array.
     *
     * Creates a new check run for a specific commit in a repository. Your GitHub App must have the `checks:write` permission to create check runs.
     *
     * In a check suite, GitHub limits the number of check runs with the same name to 1000. Once these check runs exceed 1000, GitHub will start to automatically delete older check runs.
     */
    post: operations["checks/create"];
  };
  "/repos/{owner}/{repo}/check-runs/{check_run_id}": {
    /**
     * **Note:** The Checks API only looks for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array.
     *
     * Gets a single check run using its `id`. GitHub Apps must have the `checks:read` permission on a private repository or pull access to a public repository to get check runs. OAuth Apps and authenticated users must have the `repo` scope to get check runs in a private repository.
     */
    get: operations["checks/get"];
    /**
     * **Note:** The Checks API only looks for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array.
     *
     * Updates a check run for a specific commit in a repository. Your GitHub App must have the `checks:write` permission to edit check runs.
     */
    patch: operations["checks/update"];
  };
  "/repos/{owner}/{repo}/check-runs/{check_run_id}/annotations": {
    /** Lists annotations for a check run using the annotation `id`. GitHub Apps must have the `checks:read` permission on a private repository or pull access to a public repository to get annotations for a check run. OAuth Apps and authenticated users must have the `repo` scope to get annotations for a check run in a private repository. */
    get: operations["checks/list-annotations"];
  };
  "/repos/{owner}/{repo}/check-runs/{check_run_id}/rerequest": {
    /**
     * Triggers GitHub to rerequest an existing check run, without pushing new code to a repository. This endpoint will trigger the [`check_run` webhook](https://docs.github.com/enterprise-server@3.3/webhooks/event-payloads/#check_run) event with the action `rerequested`. When a check run is `rerequested`, its `status` is reset to `queued` and the `conclusion` is cleared.
     *
     * To rerequest a check run, your GitHub App must have the `checks:read` permission on a private repository or pull access to a public repository.
     */
    post: operations["checks/rerequest-run"];
  };
  "/repos/{owner}/{repo}/check-suites": {
    /**
     * **Note:** The Checks API only looks for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array and a `null` value for `head_branch`.
     *
     * By default, check suites are automatically created when you create a [check run](https://docs.github.com/enterprise-server@3.3/rest/reference/checks#check-runs). You only need to use this endpoint for manually creating check suites when you've disabled automatic creation using "[Update repository preferences for check suites](https://docs.github.com/enterprise-server@3.3/rest/reference/checks#update-repository-preferences-for-check-suites)". Your GitHub App must have the `checks:write` permission to create check suites.
     */
    post: operations["checks/create-suite"];
  };
  "/repos/{owner}/{repo}/check-suites/preferences": {
    /** Changes the default automatic flow when creating check suites. By default, a check suite is automatically created each time code is pushed to a repository. When you disable the automatic creation of check suites, you can manually [Create a check suite](https://docs.github.com/enterprise-server@3.3/rest/reference/checks#create-a-check-suite). You must have admin permissions in the repository to set preferences for check suites. */
    patch: operations["checks/set-suites-preferences"];
  };
  "/repos/{owner}/{repo}/check-suites/{check_suite_id}": {
    /**
     * **Note:** The Checks API only looks for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array and a `null` value for `head_branch`.
     *
     * Gets a single check suite using its `id`. GitHub Apps must have the `checks:read` permission on a private repository or pull access to a public repository to get check suites. OAuth Apps and authenticated users must have the `repo` scope to get check suites in a private repository.
     */
    get: operations["checks/get-suite"];
  };
  "/repos/{owner}/{repo}/check-suites/{check_suite_id}/check-runs": {
    /**
     * **Note:** The Checks API only looks for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array.
     *
     * Lists check runs for a check suite using its `id`. GitHub Apps must have the `checks:read` permission on a private repository or pull access to a public repository to get check runs. OAuth Apps and authenticated users must have the `repo` scope to get check runs in a private repository.
     */
    get: operations["checks/list-for-suite"];
  };
  "/repos/{owner}/{repo}/check-suites/{check_suite_id}/rerequest": {
    /**
     * Triggers GitHub to rerequest an existing check suite, without pushing new code to a repository. This endpoint will trigger the [`check_suite` webhook](https://docs.github.com/enterprise-server@3.3/webhooks/event-payloads/#check_suite) event with the action `rerequested`. When a check suite is `rerequested`, its `status` is reset to `queued` and the `conclusion` is cleared.
     *
     * To rerequest a check suite, your GitHub App must have the `checks:read` permission on a private repository or pull access to a public repository.
     */
    post: operations["checks/rerequest-suite"];
  };
  "/repos/{owner}/{repo}/code-scanning/alerts": {
    /**
     * Lists all open code scanning alerts for the default branch (usually `main`
     * or `master`). You must use an access token with the `security_events` scope to use
     * this endpoint. GitHub Apps must have the `security_events` read permission to use
     * this endpoint.
     *
     * The response includes a `most_recent_instance` object.
     * This provides details of the most recent instance of this alert
     * for the default branch or for the specified Git reference
     * (if you used `ref` in the request).
     */
    get: operations["code-scanning/list-alerts-for-repo"];
  };
  "/repos/{owner}/{repo}/code-scanning/alerts/{alert_number}": {
    /**
     * Gets a single code scanning alert. You must use an access token with the `security_events` scope to use this endpoint. GitHub Apps must have the `security_events` read permission to use this endpoint.
     *
     * **Deprecation notice**:
     * The instances field is deprecated and will, in future, not be included in the response for this endpoint. The example response reflects this change. The same information can now be retrieved via a GET request to the URL specified by `instances_url`.
     */
    get: operations["code-scanning/get-alert"];
    /** Updates the status of a single code scanning alert. You must use an access token with the `security_events` scope to use this endpoint. GitHub Apps must have the `security_events` write permission to use this endpoint. */
    patch: operations["code-scanning/update-alert"];
  };
  "/repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/instances": {
    /** Lists all instances of the specified code scanning alert. You must use an access token with the `security_events` scope to use this endpoint. GitHub Apps must have the `security_events` read permission to use this endpoint. */
    get: operations["code-scanning/list-alert-instances"];
  };
  "/repos/{owner}/{repo}/code-scanning/analyses": {
    /**
     * Lists the details of all code scanning analyses for a repository,
     * starting with the most recent.
     * The response is paginated and you can use the `page` and `per_page` parameters
     * to list the analyses you're interested in.
     * By default 30 analyses are listed per page.
     *
     * The `rules_count` field in the response give the number of rules
     * that were run in the analysis.
     * For very old analyses this data is not available,
     * and `0` is returned in this field.
     *
     * You must use an access token with the `security_events` scope to use this endpoint.
     * GitHub Apps must have the `security_events` read permission to use this endpoint.
     *
     * **Deprecation notice**:
     * The `tool_name` field is deprecated and will, in future, not be included in the response for this endpoint. The example response reflects this change. The tool name can now be found inside the `tool` field.
     */
    get: operations["code-scanning/list-recent-analyses"];
  };
  "/repos/{owner}/{repo}/code-scanning/analyses/{analysis_id}": {
    /**
     * Gets a specified code scanning analysis for a repository.
     * You must use an access token with the `security_events` scope to use this endpoint.
     * GitHub Apps must have the `security_events` read permission to use this endpoint.
     *
     * The default JSON response contains fields that describe the analysis.
     * This includes the Git reference and commit SHA to which the analysis relates,
     * the datetime of the analysis, the name of the code scanning tool,
     * and the number of alerts.
     *
     * The `rules_count` field in the default response give the number of rules
     * that were run in the analysis.
     * For very old analyses this data is not available,
     * and `0` is returned in this field.
     *
     * If you use the Accept header `application/sarif+json`,
     * the response contains the analysis data that was uploaded.
     * This is formatted as
     * [SARIF version 2.1.0](https://docs.oasis-open.org/sarif/sarif/v2.1.0/cs01/sarif-v2.1.0-cs01.html).
     */
    get: operations["code-scanning/get-analysis"];
    /**
     * Deletes a specified code scanning analysis from a repository. For
     * private repositories, you must use an access token with the `repo` scope. For public repositories,
     * you must use an access token with `public_repo` and `repo:security_events` scopes.
     * GitHub Apps must have the `security_events` write permission to use this endpoint.
     *
     * You can delete one analysis at a time.
     * To delete a series of analyses, start with the most recent analysis and work backwards.
     * Conceptually, the process is similar to the undo function in a text editor.
     *
     * **Note**: The ability to delete analyses was introduced in GitHub Enterprise Server 3.1.
     * You can delete analyses that were generated prior to installing this release,
     * however, if you do so, you will lose information about fixed alerts for all such analyses,
     * for the relevant code scanning tool.
     * We recommend that you only delete analyses that were generated with earlier releases
     * if you don't need the details of fixed alerts from pre-3.1 releases.
     *
     * When you list the analyses for a repository,
     * one or more will be identified as deletable in the response:
     *
     * ```
     * "deletable": true
     * ```
     *
     * An analysis is deletable when it's the most recent in a set of analyses.
     * Typically, a repository will have multiple sets of analyses
     * for each enabled code scanning tool,
     * where a set is determined by a unique combination of analysis values:
     *
     * * `ref`
     * * `tool`
     * * `analysis_key`
     * * `environment`
     *
     * If you attempt to delete an analysis that is not the most recent in a set,
     * you'll get a 400 response with the message:
     *
     * ```
     * Analysis specified is not deletable.
     * ```
     *
     * The response from a successful `DELETE` operation provides you with
     * two alternative URLs for deleting the next analysis in the set
     * (see the example default response below).
     * Use the `next_analysis_url` URL if you want to avoid accidentally deleting the final analysis
     * in the set. This is a useful option if you want to preserve at least one analysis
     * for the specified tool in your repository.
     * Use the `confirm_delete_url` URL if you are content to remove all analyses for a tool.
     * When you delete the last analysis in a set the value of `next_analysis_url` and `confirm_delete_url`
     * in the 200 response is `null`.
     *
     * As an example of the deletion process,
     * let's imagine that you added a workflow that configured a particular code scanning tool
     * to analyze the code in a repository. This tool has added 15 analyses:
     * 10 on the default branch, and another 5 on a topic branch.
     * You therefore have two separate sets of analyses for this tool.
     * You've now decided that you want to remove all of the analyses for the tool.
     * To do this you must make 15 separate deletion requests.
     * To start, you must find the deletable analysis for one of the sets,
     * step through deleting the analyses in that set,
     * and then repeat the process for the second set.
     * The procedure therefore consists of a nested loop:
     *
     * **Outer loop**:
     * * List the analyses for the repository, filtered by tool.
     * * Parse this list to find a deletable analysis. If found:
     *
     *   **Inner loop**:
     *   * Delete the identified analysis.
     *   * Parse the response for the value of `confirm_delete_url` and, if found, use this in the next iteration.
     *
     * The above process assumes that you want to remove all trace of the tool's analyses from the GitHub user interface, for the specified repository, and it therefore uses the `confirm_delete_url` value. Alternatively, you could use the `next_analysis_url` value, which would leave the last analysis in each set undeleted to avoid removing a tool's analysis entirely.
     */
    delete: operations["code-scanning/delete-analysis"];
  };
  "/repos/{owner}/{repo}/code-scanning/sarifs": {
    /**
     * Uploads SARIF data containing the results of a code scanning analysis to make the results available in a repository. You must use an access token with the `security_events` scope to use this endpoint. GitHub Apps must have the `security_events` write permission to use this endpoint.
     *
     * There are two places where you can upload code scanning results.
     *  - If you upload to a pull request, for example `--ref refs/pull/42/merge` or `--ref refs/pull/42/head`, then the results appear as alerts in a pull request check. For more information, see "[Triaging code scanning alerts in pull requests](/code-security/secure-coding/triaging-code-scanning-alerts-in-pull-requests)."
     *  - If you upload to a branch, for example `--ref refs/heads/my-branch`, then the results appear in the **Security** tab for your repository. For more information, see "[Managing code scanning alerts for your repository](/code-security/secure-coding/managing-code-scanning-alerts-for-your-repository#viewing-the-alerts-for-a-repository)."
     *
     * You must compress the SARIF-formatted analysis data that you want to upload, using `gzip`, and then encode it as a Base64 format string. For example:
     *
     * ```
     * gzip -c analysis-data.sarif | base64 -w0
     * ```
     *
     * SARIF upload supports a maximum of 5000 results per analysis run. Any results over this limit are ignored and any SARIF uploads with more than 25,000 results are rejected. Typically, but not necessarily, a SARIF file contains a single run of a single tool. If a code scanning tool generates too many results, you should update the analysis configuration to run only the most important rules or queries.
     *
     * The `202 Accepted`, response includes an `id` value.
     * You can use this ID to check the status of the upload by using this for the `/sarifs/{sarif_id}` endpoint.
     * For more information, see "[Get information about a SARIF upload](/rest/reference/code-scanning#get-information-about-a-sarif-upload)."
     */
    post: operations["code-scanning/upload-sarif"];
  };
  "/repos/{owner}/{repo}/code-scanning/sarifs/{sarif_id}": {
    /** Gets information about a SARIF upload, including the status and the URL of the analysis that was uploaded so that you can retrieve details of the analysis. For more information, see "[Get a code scanning analysis for a repository](/rest/reference/code-scanning#get-a-code-scanning-analysis-for-a-repository)." You must use an access token with the `security_events` scope to use this endpoint. GitHub Apps must have the `security_events` read permission to use this endpoint. */
    get: operations["code-scanning/get-sarif"];
  };
  "/repos/{owner}/{repo}/collaborators": {
    /**
     * For organization-owned repositories, the list of collaborators includes outside collaborators, organization members that are direct collaborators, organization members with access through team memberships, organization members with access through default organization permissions, and organization owners.
     * Organization members with write, maintain, or admin privileges on the organization-owned repository can use this endpoint.
     *
     * Team members will include the members of child teams.
     *
     * You must authenticate using an access token with the `read:org` and `repo` scopes with push access to use this
     * endpoint. GitHub Apps must have the `members` organization permission and `metadata` repository permission to use this
     * endpoint.
     */
    get: operations["repos/list-collaborators"];
  };
  "/repos/{owner}/{repo}/collaborators/{username}": {
    /**
     * For organization-owned repositories, the list of collaborators includes outside collaborators, organization members that are direct collaborators, organization members with access through team memberships, organization members with access through default organization permissions, and organization owners.
     *
     * Team members will include the members of child teams.
     *
     * You must authenticate using an access token with the `read:org` and `repo` scopes with push access to use this
     * endpoint. GitHub Apps must have the `members` organization permission and `metadata` repository permission to use this
     * endpoint.
     */
    get: operations["repos/check-collaborator"];
    /**
     * This endpoint triggers [notifications](https://docs.github.com/enterprise-server@3.3/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. See "[Secondary rate limits](https://docs.github.com/enterprise-server@3.3/rest/overview/resources-in-the-rest-api#secondary-rate-limits)" and "[Dealing with secondary rate limits](https://docs.github.com/enterprise-server@3.3/rest/guides/best-practices-for-integrators#dealing-with-secondary-rate-limits)" for details.
     *
     * For more information on permission levels, see "[Repository permission levels for an organization](https://docs.github.com/enterprise-server@3.3/github/setting-up-and-managing-organizations-and-teams/repository-permission-levels-for-an-organization#permission-levels-for-repositories-owned-by-an-organization)". There are restrictions on which permissions can be granted to organization members when an organization base role is in place. In this case, the permission being given must be equal to or higher than the org base permission. Otherwise, the request will fail with:
     *
     * ```
     * Cannot assign {member} permission of {role name}
     * ```
     *
     * Note that, if you choose not to pass any parameters, you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://docs.github.com/enterprise-server@3.3/rest/overview/resources-in-the-rest-api#http-verbs)."
     *
     * The invitee will receive a notification that they have been invited to the repository, which they must accept or decline. They may do this via the notifications page, the email they receive, or by using the [repository invitations API endpoints](https://docs.github.com/enterprise-server@3.3/rest/reference/repos#invitations).
     *
     * **Updating an existing collaborator's permission level**
     *
     * The endpoint can also be used to change the permissions of an existing collaborator without first removing and re-adding the collaborator. To change the permissions, use the same endpoint and pass a different `permission` parameter. The response will be a `204`, with no other indication that the permission level changed.
     *
     * **Rate limits**
     *
     * You are limited to sending 50 invitations to a repository per 24 hour period. Note there is no limit if you are inviting organization members to an organization repository.
     */
    put: operations["repos/add-collaborator"];
    delete: operations["repos/remove-collaborator"];
  };
  "/repos/{owner}/{repo}/collaborators/{username}/permission": {
    /** Checks the repository permission of a collaborator. The possible repository permissions are `admin`, `write`, `read`, and `none`. */
    get: operations["repos/get-collaborator-permission-level"];
  };
  "/repos/{owner}/{repo}/comments": {
    /**
     * Commit Comments use [these custom media types](https://docs.github.com/enterprise-server@3.3/rest/reference/repos#custom-media-types). You can read more about the use of media types in the API [here](https://docs.github.com/enterprise-server@3.3/rest/overview/media-types/).
     *
     * Comments are ordered by ascending ID.
     */
    get: operations["repos/list-commit-comments-for-repo"];
  };
  "/repos/{owner}/{repo}/comments/{comment_id}": {
    get: operations["repos/get-commit-comment"];
    delete: operations["repos/delete-commit-comment"];
    patch: operations["repos/update-commit-comment"];
  };
  "/repos/{owner}/{repo}/comments/{comment_id}/reactions": {
    /** List the reactions to a [commit comment](https://docs.github.com/enterprise-server@3.3/rest/reference/repos#comments). */
    get: operations["reactions/list-for-commit-comment"];
    /** Create a reaction to a [commit comment](https://docs.github.com/enterprise-server@3.3/rest/reference/repos#comments). A response with an HTTP `200` status means that you already added the reaction type to this commit comment. */
    post: operations["reactions/create-for-commit-comment"];
  };
  "/repos/{owner}/{repo}/comments/{comment_id}/reactions/{reaction_id}": {
    /**
     * **Note:** You can also specify a repository by `repository_id` using the route `DELETE /repositories/:repository_id/comments/:comment_id/reactions/:reaction_id`.
     *
     * Delete a reaction to a [commit comment](https://docs.github.com/enterprise-server@3.3/rest/reference/repos#comments).
     */
    delete: operations["reactions/delete-for-commit-comment"];
  };
  "/repos/{owner}/{repo}/commits": {
    /**
     * **Signature verification object**
     *
     * The response will include a `verification` object that describes the result of verifying the commit's signature. The following fields are included in the `verification` object:
     *
     * | Name | Type | Description |
     * | ---- | ---- | ----------- |
     * | `verified` | `boolean` | Indicates whether GitHub considers the signature in this commit to be verified. |
     * | `reason` | `string` | The reason for verified value. Possible values and their meanings are enumerated in table below. |
     * | `signature` | `string` | The signature that was extracted from the commit. |
     * | `payload` | `string` | The value that was signed. |
     *
     * These are the possible values for `reason` in the `verification` object:
     *
     * | Value | Description |
     * | ----- | ----------- |
     * | `expired_key` | The key that made the signature is expired. |
     * | `not_signing_key` | The "signing" flag is not among the usage flags in the GPG key that made the signature. |
     * | `gpgverify_error` | There was an error communicating with the signature verification service. |
     * | `gpgverify_unavailable` | The signature verification service is currently unavailable. |
     * | `unsigned` | The object does not include a signature. |
     * | `unknown_signature_type` | A non-PGP signature was found in the commit. |
     * | `no_user` | No user was associated with the `committer` email address in the commit. |
     * | `unverified_email` | The `committer` email address in the commit was associated with a user, but the email address is not verified on her/his account. |
     * | `bad_email` | The `committer` email address in the commit is not included in the identities of the PGP key that made the signature. |
     * | `unknown_key` | The key that made the signature has not been registered with any user's account. |
     * | `malformed_signature` | There was an error parsing the signature. |
     * | `invalid` | The signature could not be cryptographically verified using the key whose key-id was found in the signature. |
     * | `valid` | None of the above errors applied, so the signature is considered to be verified. |
     */
    get: operations["repos/list-commits"];
  };
  "/repos/{owner}/{repo}/commits/{commit_sha}/branches-where-head": {
    /**
     * Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * Returns all branches where the given commit SHA is the HEAD, or latest commit for the branch.
     */
    get: operations["repos/list-branches-for-head-commit"];
  };
  "/repos/{owner}/{repo}/commits/{commit_sha}/comments": {
    /** Use the `:commit_sha` to specify the commit that will have its comments listed. */
    get: operations["repos/list-comments-for-commit"];
    /**
     * Create a comment for a commit using its `:commit_sha`.
     *
     * This endpoint triggers [notifications](https://docs.github.com/en/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. See "[Secondary rate limits](https://docs.github.com/enterprise-server@3.3/rest/overview/resources-in-the-rest-api#secondary-rate-limits)" and "[Dealing with secondary rate limits](https://docs.github.com/enterprise-server@3.3/rest/guides/best-practices-for-integrators#dealing-with-secondary-rate-limits)" for details.
     */
    post: operations["repos/create-commit-comment"];
  };
  "/repos/{owner}/{repo}/commits/{commit_sha}/pulls": {
    /** Lists the merged pull request that introduced the commit to the repository. If the commit is not present in the default branch, additionally returns open pull requests associated with the commit. The results may include open and closed pull requests. */
    get: operations["repos/list-pull-requests-associated-with-commit"];
  };
  "/repos/{owner}/{repo}/commits/{ref}": {
    /**
     * Returns the contents of a single commit reference. You must have `read` access for the repository to use this endpoint.
     *
     * **Note:** If there are more than 300 files in the commit diff, the response will include pagination link headers for the remaining files, up to a limit of 3000 files. Each page contains the static commit information, and the only changes are to the file listing.
     *
     * You can pass the appropriate [media type](https://docs.github.com/enterprise-server@3.3/rest/overview/media-types/#commits-commit-comparison-and-pull-requests) to  fetch `diff` and `patch` formats. Diffs with binary data will have no `patch` property.
     *
     * To return only the SHA-1 hash of the commit reference, you can provide the `sha` custom [media type](https://docs.github.com/enterprise-server@3.3/rest/overview/media-types/#commits-commit-comparison-and-pull-requests) in the `Accept` header. You can use this endpoint to check if a remote reference's SHA-1 hash is the same as your local reference's SHA-1 hash by providing the local SHA-1 reference as the ETag.
     *
     * **Signature verification object**
     *
     * The response will include a `verification` object that describes the result of verifying the commit's signature. The following fields are included in the `verification` object:
     *
     * | Name | Type | Description |
     * | ---- | ---- | ----------- |
     * | `verified` | `boolean` | Indicates whether GitHub considers the signature in this commit to be verified. |
     * | `reason` | `string` | The reason for verified value. Possible values and their meanings are enumerated in table below. |
     * | `signature` | `string` | The signature that was extracted from the commit. |
     * | `payload` | `string` | The value that was signed. |
     *
     * These are the possible values for `reason` in the `verification` object:
     *
     * | Value | Description |
     * | ----- | ----------- |
     * | `expired_key` | The key that made the signature is expired. |
     * | `not_signing_key` | The "signing" flag is not among the usage flags in the GPG key that made the signature. |
     * | `gpgverify_error` | There was an error communicating with the signature verification service. |
     * | `gpgverify_unavailable` | The signature verification service is currently unavailable. |
     * | `unsigned` | The object does not include a signature. |
     * | `unknown_signature_type` | A non-PGP signature was found in the commit. |
     * | `no_user` | No user was associated with the `committer` email address in the commit. |
     * | `unverified_email` | The `committer` email address in the commit was associated with a user, but the email address is not verified on her/his account. |
     * | `bad_email` | The `committer` email address in the commit is not included in the identities of the PGP key that made the signature. |
     * | `unknown_key` | The key that made the signature has not been registered with any user's account. |
     * | `malformed_signature` | There was an error parsing the signature. |
     * | `invalid` | The signature could not be cryptographically verified using the key whose key-id was found in the signature. |
     * | `valid` | None of the above errors applied, so the signature is considered to be verified. |
     */
    get: operations["repos/get-commit"];
  };
  "/repos/{owner}/{repo}/commits/{ref}/check-runs": {
    /**
     * **Note:** The Checks API only looks for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array.
     *
     * Lists check runs for a commit ref. The `ref` can be a SHA, branch name, or a tag name. GitHub Apps must have the `checks:read` permission on a private repository or pull access to a public repository to get check runs. OAuth Apps and authenticated users must have the `repo` scope to get check runs in a private repository.
     */
    get: operations["checks/list-for-ref"];
  };
  "/repos/{owner}/{repo}/commits/{ref}/check-suites": {
    /**
     * **Note:** The Checks API only looks for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array and a `null` value for `head_branch`.
     *
     * Lists check suites for a commit `ref`. The `ref` can be a SHA, branch name, or a tag name. GitHub Apps must have the `checks:read` permission on a private repository or pull access to a public repository to list check suites. OAuth Apps and authenticated users must have the `repo` scope to get check suites in a private repository.
     */
    get: operations["checks/list-suites-for-ref"];
  };
  "/repos/{owner}/{repo}/commits/{ref}/status": {
    /**
     * Users with pull access in a repository can access a combined view of commit statuses for a given ref. The ref can be a SHA, a branch name, or a tag name.
     *
     *
     * Additionally, a combined `state` is returned. The `state` is one of:
     *
     * *   **failure** if any of the contexts report as `error` or `failure`
     * *   **pending** if there are no statuses or a context is `pending`
     * *   **success** if the latest status for all contexts is `success`
     */
    get: operations["repos/get-combined-status-for-ref"];
  };
  "/repos/{owner}/{repo}/commits/{ref}/statuses": {
    /**
     * Users with pull access in a repository can view commit statuses for a given ref. The ref can be a SHA, a branch name, or a tag name. Statuses are returned in reverse chronological order. The first status in the list will be the latest one.
     *
     * This resource is also available via a legacy route: `GET /repos/:owner/:repo/statuses/:ref`.
     */
    get: operations["repos/list-commit-statuses-for-ref"];
  };
  "/repos/{owner}/{repo}/compare/{basehead}": {
    /**
     * The `basehead` param is comprised of two parts: `base` and `head`. Both must be branch names in `repo`. To compare branches across other repositories in the same network as `repo`, use the format `<USERNAME>:branch`.
     *
     * The response from the API is equivalent to running the `git log base..head` command; however, commits are returned in chronological order. Pass the appropriate [media type](https://docs.github.com/enterprise-server@3.3/rest/overview/media-types/#commits-commit-comparison-and-pull-requests) to fetch diff and patch formats.
     *
     * The response also includes details on the files that were changed between the two commits. This includes the status of the change (for example, if a file was added, removed, modified, or renamed), and details of the change itself. For example, files with a `renamed` status have a `previous_filename` field showing the previous filename of the file, and files with a `modified` status have a `patch` field showing the changes made to the file.
     *
     * **Working with large comparisons**
     *
     * To process a response with a large number of commits, you can use (`per_page` or `page`) to paginate the results. When using paging, the list of changed files is only returned with page 1, but includes all changed files for the entire comparison. For more information on working with pagination, see "[Traversing with pagination](/rest/guides/traversing-with-pagination)."
     *
     * When calling this API without any paging parameters (`per_page` or `page`), the returned list is limited to 250 commits and the last commit in the list is the most recent of the entire comparison. When a paging parameter is specified, the first commit in the returned list of each page is the earliest.
     *
     * **Signature verification object**
     *
     * The response will include a `verification` object that describes the result of verifying the commit's signature. The following fields are included in the `verification` object:
     *
     * | Name | Type | Description |
     * | ---- | ---- | ----------- |
     * | `verified` | `boolean` | Indicates whether GitHub considers the signature in this commit to be verified. |
     * | `reason` | `string` | The reason for verified value. Possible values and their meanings are enumerated in table below. |
     * | `signature` | `string` | The signature that was extracted from the commit. |
     * | `payload` | `string` | The value that was signed. |
     *
     * These are the possible values for `reason` in the `verification` object:
     *
     * | Value | Description |
     * | ----- | ----------- |
     * | `expired_key` | The key that made the signature is expired. |
     * | `not_signing_key` | The "signing" flag is not among the usage flags in the GPG key that made the signature. |
     * | `gpgverify_error` | There was an error communicating with the signature verification service. |
     * | `gpgverify_unavailable` | The signature verification service is currently unavailable. |
     * | `unsigned` | The object does not include a signature. |
     * | `unknown_signature_type` | A non-PGP signature was found in the commit. |
     * | `no_user` | No user was associated with the `committer` email address in the commit. |
     * | `unverified_email` | The `committer` email address in the commit was associated with a user, but the email address is not verified on her/his account. |
     * | `bad_email` | The `committer` email address in the commit is not included in the identities of the PGP key that made the signature. |
     * | `unknown_key` | The key that made the signature has not been registered with any user's account. |
     * | `malformed_signature` | There was an error parsing the signature. |
     * | `invalid` | The signature could not be cryptographically verified using the key whose key-id was found in the signature. |
     * | `valid` | None of the above errors applied, so the signature is considered to be verified. |
     */
    get: operations["repos/compare-commits-with-basehead"];
  };
  "/repos/{owner}/{repo}/content_references/{content_reference_id}/attachments": {
    /**
     * Creates an attachment under a content reference URL in the body or comment of an issue or pull request. Use the `id` and `repository` `full_name` of the content reference from the [`content_reference` event](https://docs.github.com/enterprise-server@3.3/webhooks/event-payloads/#content_reference) to create an attachment.
     *
     * The app must create a content attachment within six hours of the content reference URL being posted. See "[Using content attachments](https://docs.github.com/enterprise-server@3.3/apps/using-content-attachments/)" for details about content attachments.
     *
     * You must use an [installation access token](https://docs.github.com/enterprise-server@3.3/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-an-installation) to access this endpoint.
     */
    post: operations["apps/create-content-attachment-for-repo"];
  };
  "/repos/{owner}/{repo}/contents/{path}": {
    /**
     * Gets the contents of a file or directory in a repository. Specify the file path or directory in `:path`. If you omit
     * `:path`, you will receive the contents of the repository's root directory. See the description below regarding what the API response includes for directories.
     *
     * Files and symlinks support [a custom media type](https://docs.github.com/enterprise-server@3.3/rest/reference/repos#custom-media-types) for
     * retrieving the raw content or rendered HTML (when supported). All content types support [a custom media
     * type](https://docs.github.com/enterprise-server@3.3/rest/reference/repos#custom-media-types) to ensure the content is returned in a consistent
     * object format.
     *
     * **Notes**:
     * *   To get a repository's contents recursively, you can [recursively get the tree](https://docs.github.com/enterprise-server@3.3/rest/reference/git#trees).
     * *   This API has an upper limit of 1,000 files for a directory. If you need to retrieve more files, use the [Git Trees
     * API](https://docs.github.com/enterprise-server@3.3/rest/reference/git#get-a-tree).
     *  *  Download URLs expire and are meant to be used just once. To ensure the download URL does not expire, please use the contents API to obtain a fresh download URL for each download.
     * *   This API supports files up to 1 megabyte in size.
     *
     * #### If the content is a directory
     * The response will be an array of objects, one object for each item in the directory.
     * When listing the contents of a directory, submodules have their "type" specified as "file". Logically, the value
     * _should_ be "submodule". This behavior exists in API v3 [for backwards compatibility purposes](https://git.io/v1YCW).
     * In the next major version of the API, the type will be returned as "submodule".
     *
     * #### If the content is a symlink
     * If the requested `:path` points to a symlink, and the symlink's target is a normal file in the repository, then the
     * API responds with the content of the file (in the format shown in the example. Otherwise, the API responds with an object
     * describing the symlink itself.
     *
     * #### If the content is a submodule
     * The `submodule_git_url` identifies the location of the submodule repository, and the `sha` identifies a specific
     * commit within the submodule repository. Git uses the given URL when cloning the submodule repository, and checks out
     * the submodule at that specific commit.
     *
     * If the submodule repository is not hosted on github.com, the Git URLs (`git_url` and `_links["git"]`) and the
     * github.com URLs (`html_url` and `_links["html"]`) will have null values.
     */
    get: operations["repos/get-content"];
    /**
     * Creates a new file or replaces an existing file in a repository. You must authenticate using an access token with the `workflow` scope to use this endpoint.
     *
     * **Note:** If you use this endpoint and the "[Delete a file](https://docs.github.com/enterprise-server@3.3/rest/reference/repos/#delete-file)" endpoint in parallel, the concurrent requests will conflict and you will receive errors. You must use these endpoints serially instead.
     */
    put: operations["repos/create-or-update-file-contents"];
    /**
     * Deletes a file in a repository.
     *
     * You can provide an additional `committer` parameter, which is an object containing information about the committer. Or, you can provide an `author` parameter, which is an object containing information about the author.
     *
     * The `author` section is optional and is filled in with the `committer` information if omitted. If the `committer` information is omitted, the authenticated user's information is used.
     *
     * You must provide values for both `name` and `email`, whether you choose to use `author` or `committer`. Otherwise, you'll receive a `422` status code.
     *
     * **Note:** If you use this endpoint and the "[Create or update file contents](https://docs.github.com/enterprise-server@3.3/rest/reference/repos/#create-or-update-file-contents)" endpoint in parallel, the concurrent requests will conflict and you will receive errors. You must use these endpoints serially instead.
     */
    delete: operations["repos/delete-file"];
  };
  "/repos/{owner}/{repo}/contributors": {
    /**
     * Lists contributors to the specified repository and sorts them by the number of commits per contributor in descending order. This endpoint may return information that is a few hours old because the GitHub REST API v3 caches contributor data to improve performance.
     *
     * GitHub identifies contributors by author email address. This endpoint groups contribution counts by GitHub user, which includes all associated email addresses. To improve performance, only the first 500 author email addresses in the repository link to GitHub users. The rest will appear as anonymous contributors without associated GitHub user information.
     */
    get: operations["repos/list-contributors"];
  };
  "/repos/{owner}/{repo}/deployments": {
    /** Simple filtering of deployments is available via query parameters: */
    get: operations["repos/list-deployments"];
    /**
     * Deployments offer a few configurable parameters with certain defaults.
     *
     * The `ref` parameter can be any named branch, tag, or SHA. At GitHub Enterprise Server we often deploy branches and verify them
     * before we merge a pull request.
     *
     * The `environment` parameter allows deployments to be issued to different runtime environments. Teams often have
     * multiple environments for verifying their applications, such as `production`, `staging`, and `qa`. This parameter
     * makes it easier to track which environments have requested deployments. The default environment is `production`.
     *
     * The `auto_merge` parameter is used to ensure that the requested ref is not behind the repository's default branch. If
     * the ref _is_ behind the default branch for the repository, we will attempt to merge it for you. If the merge succeeds,
     * the API will return a successful merge commit. If merge conflicts prevent the merge from succeeding, the API will
     * return a failure response.
     *
     * By default, [commit statuses](https://docs.github.com/enterprise-server@3.3/rest/commits/statuses) for every submitted context must be in a `success`
     * state. The `required_contexts` parameter allows you to specify a subset of contexts that must be `success`, or to
     * specify contexts that have not yet been submitted. You are not required to use commit statuses to deploy. If you do
     * not require any contexts or create any commit statuses, the deployment will always succeed.
     *
     * The `payload` parameter is available for any extra information that a deployment system might need. It is a JSON text
     * field that will be passed on when a deployment event is dispatched.
     *
     * The `task` parameter is used by the deployment system to allow different execution paths. In the web world this might
     * be `deploy:migrations` to run schema changes on the system. In the compiled world this could be a flag to compile an
     * application with debugging enabled.
     *
     * Users with `repo` or `repo_deployment` scopes can create a deployment for a given ref.
     *
     * #### Merged branch response
     * You will see this response when GitHub automatically merges the base branch into the topic branch instead of creating
     * a deployment. This auto-merge happens when:
     * *   Auto-merge option is enabled in the repository
     * *   Topic branch does not include the latest changes on the base branch, which is `master` in the response example
     * *   There are no merge conflicts
     *
     * If there are no new commits in the base branch, a new request to create a deployment should give a successful
     * response.
     *
     * #### Merge conflict response
     * This error happens when the `auto_merge` option is enabled and when the default branch (in this case `master`), can't
     * be merged into the branch that's being deployed (in this case `topic-branch`), due to merge conflicts.
     *
     * #### Failed commit status checks
     * This error happens when the `required_contexts` parameter indicates that one or more contexts need to have a `success`
     * status for the commit to be deployed, but one or more of the required contexts do not have a state of `success`.
     */
    post: operations["repos/create-deployment"];
  };
  "/repos/{owner}/{repo}/deployments/{deployment_id}": {
    get: operations["repos/get-deployment"];
    /**
     * If the repository only has one deployment, you can delete the deployment regardless of its status. If the repository has more than one deployment, you can only delete inactive deployments. This ensures that repositories with multiple deployments will always have an active deployment. Anyone with `repo` or `repo_deployment` scopes can delete a deployment.
     *
     * To set a deployment as inactive, you must:
     *
     * *   Create a new deployment that is active so that the system has a record of the current state, then delete the previously active deployment.
     * *   Mark the active deployment as inactive by adding any non-successful deployment status.
     *
     * For more information, see "[Create a deployment](https://docs.github.com/enterprise-server@3.3/rest/reference/repos/#create-a-deployment)" and "[Create a deployment status](https://docs.github.com/enterprise-server@3.3/rest/reference/repos#create-a-deployment-status)."
     */
    delete: operations["repos/delete-deployment"];
  };
  "/repos/{owner}/{repo}/deployments/{deployment_id}/statuses": {
    /** Users with pull access can view deployment statuses for a deployment: */
    get: operations["repos/list-deployment-statuses"];
    /**
     * Users with `push` access can create deployment statuses for a given deployment.
     *
     * GitHub Apps require `read & write` access to "Deployments" and `read-only` access to "Repo contents" (for private repos). OAuth Apps require the `repo_deployment` scope.
     */
    post: operations["repos/create-deployment-status"];
  };
  "/repos/{owner}/{repo}/deployments/{deployment_id}/statuses/{status_id}": {
    /** Users with pull access can view a deployment status for a deployment: */
    get: operations["repos/get-deployment-status"];
  };
  "/repos/{owner}/{repo}/dispatches": {
    /**
     * You can use this endpoint to trigger a webhook event called `repository_dispatch` when you want activity that happens outside of GitHub Enterprise Server to trigger a GitHub Actions workflow or GitHub App webhook. You must configure your GitHub Actions workflow or GitHub App to run when the `repository_dispatch` event occurs. For an example `repository_dispatch` webhook payload, see "[RepositoryDispatchEvent](https://docs.github.com/enterprise-server@3.3/webhooks/event-payloads/#repository_dispatch)."
     *
     * The `client_payload` parameter is available for any extra information that your workflow might need. This parameter is a JSON payload that will be passed on when the webhook event is dispatched. For example, the `client_payload` can include a message that a user would like to send using a GitHub Actions workflow. Or the `client_payload` can be used as a test to debug your workflow.
     *
     * This endpoint requires write access to the repository by providing either:
     *
     *   - Personal access tokens with `repo` scope. For more information, see "[Creating a personal access token for the command line](https://docs.github.com/articles/creating-a-personal-access-token-for-the-command-line)" in the GitHub Help documentation.
     *   - GitHub Apps with both `metadata:read` and `contents:read&write` permissions.
     *
     * This input example shows how you can use the `client_payload` as a test to debug your workflow.
     */
    post: operations["repos/create-dispatch-event"];
  };
  "/repos/{owner}/{repo}/environments": {
    /**
     * Lists the environments for a repository.
     *
     * Anyone with read access to the repository can use this endpoint. If the repository is private, you must use an access token with the `repo` scope. GitHub Apps must have the `actions:read` permission to use this endpoint.
     */
    get: operations["repos/get-all-environments"];
  };
  "/repos/{owner}/{repo}/environments/{environment_name}": {
    /**
     * **Note:** To get information about name patterns that branches must match in order to deploy to this environment, see "[Get a deployment branch policy](/rest/deployments/branch-policies#get-a-deployment-branch-policy)."
     *
     * Anyone with read access to the repository can use this endpoint. If the
     * repository is private, you must use an access token with the `repo` scope. GitHub
     * Apps must have the `actions:read` permission to use this endpoint.
     */
    get: operations["repos/get-environment"];
    /**
     * Create or update an environment with protection rules, such as required reviewers. For more information about environment protection rules, see "[Environments](/actions/reference/environments#environment-protection-rules)."
     *
     * **Note:** To create or update name patterns that branches must match in order to deploy to this environment, see "[Deployment branch policies](/rest/deployments/branch-policies)."
     *
     * **Note:** To create or update secrets for an environment, see "[Secrets](/rest/reference/actions#secrets)."
     *
     * You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `administration:write` permission for the repository to use this endpoint.
     */
    put: operations["repos/create-or-update-environment"];
    /** You must authenticate using an access token with the repo scope to use this endpoint. */
    delete: operations["repos/delete-an-environment"];
  };
  "/repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies": {
    /**
     * Lists the deployment branch policies for an environment.
     *
     * Anyone with read access to the repository can use this endpoint. If the repository is private, you must use an access token with the `repo` scope. GitHub Apps must have the `actions:read` permission to use this endpoint.
     */
    get: operations["repos/list-deployment-branch-policies"];
    /**
     * Creates a deployment branch policy for an environment.
     *
     * You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `administration:write` permission for the repository to use this endpoint.
     */
    post: operations["repos/create-deployment-branch-policy"];
  };
  "/repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies/{branch_policy_id}": {
    /**
     * Gets a deployment branch policy for an environment.
     *
     * Anyone with read access to the repository can use this endpoint. If the repository is private, you must use an access token with the `repo` scope. GitHub Apps must have the `actions:read` permission to use this endpoint.
     */
    get: operations["repos/get-deployment-branch-policy"];
    /**
     * Updates a deployment branch policy for an environment.
     *
     * You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `administration:write` permission for the repository to use this endpoint.
     */
    put: operations["repos/update-deployment-branch-policy"];
    /**
     * Deletes a deployment branch policy for an environment.
     *
     * You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `administration:write` permission for the repository to use this endpoint.
     */
    delete: operations["repos/delete-deployment-branch-policy"];
  };
  "/repos/{owner}/{repo}/events": {
    get: operations["activity/list-repo-events"];
  };
  "/repos/{owner}/{repo}/forks": {
    get: operations["repos/list-forks"];
    /**
     * Create a fork for the authenticated user.
     *
     * **Note**: Forking a Repository happens asynchronously. You may have to wait a short period of time before you can access the git objects. If this takes longer than 5 minutes, be sure to contact [GitHub Enterprise Server Support](https://support.github.com/contact?tags=dotcom-rest-api).
     */
    post: operations["repos/create-fork"];
  };
  "/repos/{owner}/{repo}/git/blobs": {
    post: operations["git/create-blob"];
  };
  "/repos/{owner}/{repo}/git/blobs/{file_sha}": {
    /**
     * The `content` in the response will always be Base64 encoded.
     *
     * _Note_: This API supports blobs up to 100 megabytes in size.
     */
    get: operations["git/get-blob"];
  };
  "/repos/{owner}/{repo}/git/commits": {
    /**
     * Creates a new Git [commit object](https://git-scm.com/book/en/v1/Git-Internals-Git-Objects#Commit-Objects).
     *
     * **Signature verification object**
     *
     * The response will include a `verification` object that describes the result of verifying the commit's signature. The following fields are included in the `verification` object:
     *
     * | Name | Type | Description |
     * | ---- | ---- | ----------- |
     * | `verified` | `boolean` | Indicates whether GitHub considers the signature in this commit to be verified. |
     * | `reason` | `string` | The reason for verified value. Possible values and their meanings are enumerated in the table below. |
     * | `signature` | `string` | The signature that was extracted from the commit. |
     * | `payload` | `string` | The value that was signed. |
     *
     * These are the possible values for `reason` in the `verification` object:
     *
     * | Value | Description |
     * | ----- | ----------- |
     * | `expired_key` | The key that made the signature is expired. |
     * | `not_signing_key` | The "signing" flag is not among the usage flags in the GPG key that made the signature. |
     * | `gpgverify_error` | There was an error communicating with the signature verification service. |
     * | `gpgverify_unavailable` | The signature verification service is currently unavailable. |
     * | `unsigned` | The object does not include a signature. |
     * | `unknown_signature_type` | A non-PGP signature was found in the commit. |
     * | `no_user` | No user was associated with the `committer` email address in the commit. |
     * | `unverified_email` | The `committer` email address in the commit was associated with a user, but the email address is not verified on her/his account. |
     * | `bad_email` | The `committer` email address in the commit is not included in the identities of the PGP key that made the signature. |
     * | `unknown_key` | The key that made the signature has not been registered with any user's account. |
     * | `malformed_signature` | There was an error parsing the signature. |
     * | `invalid` | The signature could not be cryptographically verified using the key whose key-id was found in the signature. |
     * | `valid` | None of the above errors applied, so the signature is considered to be verified. |
     */
    post: operations["git/create-commit"];
  };
  "/repos/{owner}/{repo}/git/commits/{commit_sha}": {
    /**
     * Gets a Git [commit object](https://git-scm.com/book/en/v1/Git-Internals-Git-Objects#Commit-Objects).
     *
     * **Signature verification object**
     *
     * The response will include a `verification` object that describes the result of verifying the commit's signature. The following fields are included in the `verification` object:
     *
     * | Name | Type | Description |
     * | ---- | ---- | ----------- |
     * | `verified` | `boolean` | Indicates whether GitHub considers the signature in this commit to be verified. |
     * | `reason` | `string` | The reason for verified value. Possible values and their meanings are enumerated in the table below. |
     * | `signature` | `string` | The signature that was extracted from the commit. |
     * | `payload` | `string` | The value that was signed. |
     *
     * These are the possible values for `reason` in the `verification` object:
     *
     * | Value | Description |
     * | ----- | ----------- |
     * | `expired_key` | The key that made the signature is expired. |
     * | `not_signing_key` | The "signing" flag is not among the usage flags in the GPG key that made the signature. |
     * | `gpgverify_error` | There was an error communicating with the signature verification service. |
     * | `gpgverify_unavailable` | The signature verification service is currently unavailable. |
     * | `unsigned` | The object does not include a signature. |
     * | `unknown_signature_type` | A non-PGP signature was found in the commit. |
     * | `no_user` | No user was associated with the `committer` email address in the commit. |
     * | `unverified_email` | The `committer` email address in the commit was associated with a user, but the email address is not verified on her/his account. |
     * | `bad_email` | The `committer` email address in the commit is not included in the identities of the PGP key that made the signature. |
     * | `unknown_key` | The key that made the signature has not been registered with any user's account. |
     * | `malformed_signature` | There was an error parsing the signature. |
     * | `invalid` | The signature could not be cryptographically verified using the key whose key-id was found in the signature. |
     * | `valid` | None of the above errors applied, so the signature is considered to be verified. |
     */
    get: operations["git/get-commit"];
  };
  "/repos/{owner}/{repo}/git/matching-refs/{ref}": {
    /**
     * Returns an array of references from your Git database that match the supplied name. The `:ref` in the URL must be formatted as `heads/<branch name>` for branches and `tags/<tag name>` for tags. If the `:ref` doesn't exist in the repository, but existing refs start with `:ref`, they will be returned as an array.
     *
     * When you use this endpoint without providing a `:ref`, it will return an array of all the references from your Git database, including notes and stashes if they exist on the server. Anything in the namespace is returned, not just `heads` and `tags`.
     *
     * **Note:** You need to explicitly [request a pull request](https://docs.github.com/enterprise-server@3.3/rest/reference/pulls#get-a-pull-request) to trigger a test merge commit, which checks the mergeability of pull requests. For more information, see "[Checking mergeability of pull requests](https://docs.github.com/enterprise-server@3.3/rest/guides/getting-started-with-the-git-database-api#checking-mergeability-of-pull-requests)".
     *
     * If you request matching references for a branch named `feature` but the branch `feature` doesn't exist, the response can still include other matching head refs that start with the word `feature`, such as `featureA` and `featureB`.
     */
    get: operations["git/list-matching-refs"];
  };
  "/repos/{owner}/{repo}/git/ref/{ref}": {
    /**
     * Returns a single reference from your Git database. The `:ref` in the URL must be formatted as `heads/<branch name>` for branches and `tags/<tag name>` for tags. If the `:ref` doesn't match an existing ref, a `404` is returned.
     *
     * **Note:** You need to explicitly [request a pull request](https://docs.github.com/enterprise-server@3.3/rest/reference/pulls#get-a-pull-request) to trigger a test merge commit, which checks the mergeability of pull requests. For more information, see "[Checking mergeability of pull requests](https://docs.github.com/enterprise-server@3.3/rest/guides/getting-started-with-the-git-database-api#checking-mergeability-of-pull-requests)".
     */
    get: operations["git/get-ref"];
  };
  "/repos/{owner}/{repo}/git/refs": {
    /** Creates a reference for your repository. You are unable to create new references for empty repositories, even if the commit SHA-1 hash used exists. Empty repositories are repositories without branches. */
    post: operations["git/create-ref"];
  };
  "/repos/{owner}/{repo}/git/refs/{ref}": {
    delete: operations["git/delete-ref"];
    patch: operations["git/update-ref"];
  };
  "/repos/{owner}/{repo}/git/tags": {
    /**
     * Note that creating a tag object does not create the reference that makes a tag in Git. If you want to create an annotated tag in Git, you have to do this call to create the tag object, and then [create](https://docs.github.com/enterprise-server@3.3/rest/reference/git#create-a-reference) the `refs/tags/[tag]` reference. If you want to create a lightweight tag, you only have to [create](https://docs.github.com/enterprise-server@3.3/rest/reference/git#create-a-reference) the tag reference - this call would be unnecessary.
     *
     * **Signature verification object**
     *
     * The response will include a `verification` object that describes the result of verifying the commit's signature. The following fields are included in the `verification` object:
     *
     * | Name | Type | Description |
     * | ---- | ---- | ----------- |
     * | `verified` | `boolean` | Indicates whether GitHub considers the signature in this commit to be verified. |
     * | `reason` | `string` | The reason for verified value. Possible values and their meanings are enumerated in table below. |
     * | `signature` | `string` | The signature that was extracted from the commit. |
     * | `payload` | `string` | The value that was signed. |
     *
     * These are the possible values for `reason` in the `verification` object:
     *
     * | Value | Description |
     * | ----- | ----------- |
     * | `expired_key` | The key that made the signature is expired. |
     * | `not_signing_key` | The "signing" flag is not among the usage flags in the GPG key that made the signature. |
     * | `gpgverify_error` | There was an error communicating with the signature verification service. |
     * | `gpgverify_unavailable` | The signature verification service is currently unavailable. |
     * | `unsigned` | The object does not include a signature. |
     * | `unknown_signature_type` | A non-PGP signature was found in the commit. |
     * | `no_user` | No user was associated with the `committer` email address in the commit. |
     * | `unverified_email` | The `committer` email address in the commit was associated with a user, but the email address is not verified on her/his account. |
     * | `bad_email` | The `committer` email address in the commit is not included in the identities of the PGP key that made the signature. |
     * | `unknown_key` | The key that made the signature has not been registered with any user's account. |
     * | `malformed_signature` | There was an error parsing the signature. |
     * | `invalid` | The signature could not be cryptographically verified using the key whose key-id was found in the signature. |
     * | `valid` | None of the above errors applied, so the signature is considered to be verified. |
     */
    post: operations["git/create-tag"];
  };
  "/repos/{owner}/{repo}/git/tags/{tag_sha}": {
    /**
     * **Signature verification object**
     *
     * The response will include a `verification` object that describes the result of verifying the commit's signature. The following fields are included in the `verification` object:
     *
     * | Name | Type | Description |
     * | ---- | ---- | ----------- |
     * | `verified` | `boolean` | Indicates whether GitHub considers the signature in this commit to be verified. |
     * | `reason` | `string` | The reason for verified value. Possible values and their meanings are enumerated in table below. |
     * | `signature` | `string` | The signature that was extracted from the commit. |
     * | `payload` | `string` | The value that was signed. |
     *
     * These are the possible values for `reason` in the `verification` object:
     *
     * | Value | Description |
     * | ----- | ----------- |
     * | `expired_key` | The key that made the signature is expired. |
     * | `not_signing_key` | The "signing" flag is not among the usage flags in the GPG key that made the signature. |
     * | `gpgverify_error` | There was an error communicating with the signature verification service. |
     * | `gpgverify_unavailable` | The signature verification service is currently unavailable. |
     * | `unsigned` | The object does not include a signature. |
     * | `unknown_signature_type` | A non-PGP signature was found in the commit. |
     * | `no_user` | No user was associated with the `committer` email address in the commit. |
     * | `unverified_email` | The `committer` email address in the commit was associated with a user, but the email address is not verified on her/his account. |
     * | `bad_email` | The `committer` email address in the commit is not included in the identities of the PGP key that made the signature. |
     * | `unknown_key` | The key that made the signature has not been registered with any user's account. |
     * | `malformed_signature` | There was an error parsing the signature. |
     * | `invalid` | The signature could not be cryptographically verified using the key whose key-id was found in the signature. |
     * | `valid` | None of the above errors applied, so the signature is considered to be verified. |
     */
    get: operations["git/get-tag"];
  };
  "/repos/{owner}/{repo}/git/trees": {
    /**
     * The tree creation API accepts nested entries. If you specify both a tree and a nested path modifying that tree, this endpoint will overwrite the contents of the tree with the new path contents, and create a new tree structure.
     *
     * If you use this endpoint to add, delete, or modify the file contents in a tree, you will need to commit the tree and then update a branch to point to the commit. For more information see "[Create a commit](https://docs.github.com/enterprise-server@3.3/rest/reference/git#create-a-commit)" and "[Update a reference](https://docs.github.com/enterprise-server@3.3/rest/reference/git#update-a-reference)."
     *
     * Returns an error if you try to delete a file that does not exist.
     */
    post: operations["git/create-tree"];
  };
  "/repos/{owner}/{repo}/git/trees/{tree_sha}": {
    /**
     * Returns a single tree using the SHA1 value for that tree.
     *
     * If `truncated` is `true` in the response then the number of items in the `tree` array exceeded our maximum limit. If you need to fetch more items, use the non-recursive method of fetching trees, and fetch one sub-tree at a time.
     *
     *
     * **Note**: The limit for the `tree` array is 100,000 entries with a maximum size of 7 MB when using the `recursive` parameter.
     */
    get: operations["git/get-tree"];
  };
  "/repos/{owner}/{repo}/hooks": {
    /** Lists webhooks for a repository. `last response` may return null if there have not been any deliveries within 30 days. */
    get: operations["repos/list-webhooks"];
    /**
     * Repositories can have multiple webhooks installed. Each webhook should have a unique `config`. Multiple webhooks can
     * share the same `config` as long as those webhooks do not have any `events` that overlap.
     */
    post: operations["repos/create-webhook"];
  };
  "/repos/{owner}/{repo}/hooks/{hook_id}": {
    /** Returns a webhook configured in a repository. To get only the webhook `config` properties, see "[Get a webhook configuration for a repository](/rest/reference/repos#get-a-webhook-configuration-for-a-repository)." */
    get: operations["repos/get-webhook"];
    delete: operations["repos/delete-webhook"];
    /** Updates a webhook configured in a repository. If you previously had a `secret` set, you must provide the same `secret` or set a new `secret` or the secret will be removed. If you are only updating individual webhook `config` properties, use "[Update a webhook configuration for a repository](/rest/reference/repos#update-a-webhook-configuration-for-a-repository)." */
    patch: operations["repos/update-webhook"];
  };
  "/repos/{owner}/{repo}/hooks/{hook_id}/config": {
    /**
     * Returns the webhook configuration for a repository. To get more information about the webhook, including the `active` state and `events`, use "[Get a repository webhook](/rest/reference/orgs#get-a-repository-webhook)."
     *
     * Access tokens must have the `read:repo_hook` or `repo` scope, and GitHub Apps must have the `repository_hooks:read` permission.
     */
    get: operations["repos/get-webhook-config-for-repo"];
    /**
     * Updates the webhook configuration for a repository. To update more information about the webhook, including the `active` state and `events`, use "[Update a repository webhook](/rest/reference/orgs#update-a-repository-webhook)."
     *
     * Access tokens must have the `write:repo_hook` or `repo` scope, and GitHub Apps must have the `repository_hooks:write` permission.
     */
    patch: operations["repos/update-webhook-config-for-repo"];
  };
  "/repos/{owner}/{repo}/hooks/{hook_id}/deliveries": {
    /** Returns a list of webhook deliveries for a webhook configured in a repository. */
    get: operations["repos/list-webhook-deliveries"];
  };
  "/repos/{owner}/{repo}/hooks/{hook_id}/deliveries/{delivery_id}": {
    /** Returns a delivery for a webhook configured in a repository. */
    get: operations["repos/get-webhook-delivery"];
  };
  "/repos/{owner}/{repo}/hooks/{hook_id}/deliveries/{delivery_id}/attempts": {
    /** Redeliver a webhook delivery for a webhook configured in a repository. */
    post: operations["repos/redeliver-webhook-delivery"];
  };
  "/repos/{owner}/{repo}/hooks/{hook_id}/pings": {
    /** This will trigger a [ping event](https://docs.github.com/enterprise-server@3.3/webhooks/#ping-event) to be sent to the hook. */
    post: operations["repos/ping-webhook"];
  };
  "/repos/{owner}/{repo}/hooks/{hook_id}/tests": {
    /**
     * This will trigger the hook with the latest push to the current repository if the hook is subscribed to `push` events. If the hook is not subscribed to `push` events, the server will respond with 204 but no test POST will be generated.
     *
     * **Note**: Previously `/repos/:owner/:repo/hooks/:hook_id/test`
     */
    post: operations["repos/test-push-webhook"];
  };
  "/repos/{owner}/{repo}/installation": {
    /**
     * Enables an authenticated GitHub App to find the repository's installation information. The installation's account type will be either an organization or a user account, depending which account the repository belongs to.
     *
     * You must use a [JWT](https://docs.github.com/enterprise-server@3.3/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
     */
    get: operations["apps/get-repo-installation"];
  };
  "/repos/{owner}/{repo}/invitations": {
    /** When authenticating as a user with admin rights to a repository, this endpoint will list all currently open repository invitations. */
    get: operations["repos/list-invitations"];
  };
  "/repos/{owner}/{repo}/invitations/{invitation_id}": {
    delete: operations["repos/delete-invitation"];
    patch: operations["repos/update-invitation"];
  };
  "/repos/{owner}/{repo}/issues": {
    /**
     * List issues in a repository.
     *
     * **Note**: GitHub's REST API v3 considers every pull request an issue, but not every issue is a pull request. For this
     * reason, "Issues" endpoints may return both issues and pull requests in the response. You can identify pull requests by
     * the `pull_request` key. Be aware that the `id` of a pull request returned from "Issues" endpoints will be an _issue id_. To find out the pull
     * request id, use the "[List pull requests](https://docs.github.com/enterprise-server@3.3/rest/reference/pulls#list-pull-requests)" endpoint.
     */
    get: operations["issues/list-for-repo"];
    /**
     * Any user with pull access to a repository can create an issue. If [issues are disabled in the repository](https://docs.github.com/articles/disabling-issues/), the API returns a `410 Gone` status.
     *
     * This endpoint triggers [notifications](https://docs.github.com/enterprise-server@3.3/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. See "[Secondary rate limits](https://docs.github.com/enterprise-server@3.3/rest/overview/resources-in-the-rest-api#secondary-rate-limits)" and "[Dealing with secondary rate limits](https://docs.github.com/enterprise-server@3.3/rest/guides/best-practices-for-integrators#dealing-with-secondary-rate-limits)" for details.
     */
    post: operations["issues/create"];
  };
  "/repos/{owner}/{repo}/issues/comments": {
    /** By default, Issue Comments are ordered by ascending ID. */
    get: operations["issues/list-comments-for-repo"];
  };
  "/repos/{owner}/{repo}/issues/comments/{comment_id}": {
    get: operations["issues/get-comment"];
    delete: operations["issues/delete-comment"];
    patch: operations["issues/update-comment"];
  };
  "/repos/{owner}/{repo}/issues/comments/{comment_id}/reactions": {
    /** List the reactions to an [issue comment](https://docs.github.com/enterprise-server@3.3/rest/reference/issues#comments). */
    get: operations["reactions/list-for-issue-comment"];
    /** Create a reaction to an [issue comment](https://docs.github.com/enterprise-server@3.3/rest/reference/issues#comments). A response with an HTTP `200` status means that you already added the reaction type to this issue comment. */
    post: operations["reactions/create-for-issue-comment"];
  };
  "/repos/{owner}/{repo}/issues/comments/{comment_id}/reactions/{reaction_id}": {
    /**
     * **Note:** You can also specify a repository by `repository_id` using the route `DELETE delete /repositories/:repository_id/issues/comments/:comment_id/reactions/:reaction_id`.
     *
     * Delete a reaction to an [issue comment](https://docs.github.com/enterprise-server@3.3/rest/reference/issues#comments).
     */
    delete: operations["reactions/delete-for-issue-comment"];
  };
  "/repos/{owner}/{repo}/issues/events": {
    get: operations["issues/list-events-for-repo"];
  };
  "/repos/{owner}/{repo}/issues/events/{event_id}": {
    get: operations["issues/get-event"];
  };
  "/repos/{owner}/{repo}/issues/{issue_number}": {
    /**
     * The API returns a [`301 Moved Permanently` status](https://docs.github.com/enterprise-server@3.3/rest/overview/resources-in-the-rest-api#http-redirects-redirects) if the issue was
     * [transferred](https://docs.github.com/articles/transferring-an-issue-to-another-repository/) to another repository. If
     * the issue was transferred to or deleted from a repository where the authenticated user lacks read access, the API
     * returns a `404 Not Found` status. If the issue was deleted from a repository where the authenticated user has read
     * access, the API returns a `410 Gone` status. To receive webhook events for transferred and deleted issues, subscribe
     * to the [`issues`](https://docs.github.com/enterprise-server@3.3/webhooks/event-payloads/#issues) webhook.
     *
     * **Note**: GitHub's REST API v3 considers every pull request an issue, but not every issue is a pull request. For this
     * reason, "Issues" endpoints may return both issues and pull requests in the response. You can identify pull requests by
     * the `pull_request` key. Be aware that the `id` of a pull request returned from "Issues" endpoints will be an _issue id_. To find out the pull
     * request id, use the "[List pull requests](https://docs.github.com/enterprise-server@3.3/rest/reference/pulls#list-pull-requests)" endpoint.
     */
    get: operations["issues/get"];
    /** Issue owners and users with push access can edit an issue. */
    patch: operations["issues/update"];
  };
  "/repos/{owner}/{repo}/issues/{issue_number}/assignees": {
    /** Adds up to 10 assignees to an issue. Users already assigned to an issue are not replaced. */
    post: operations["issues/add-assignees"];
    /** Removes one or more assignees from an issue. */
    delete: operations["issues/remove-assignees"];
  };
  "/repos/{owner}/{repo}/issues/{issue_number}/comments": {
    /** Issue Comments are ordered by ascending ID. */
    get: operations["issues/list-comments"];
    /** This endpoint triggers [notifications](https://docs.github.com/enterprise-server@3.3/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. See "[Secondary rate limits](https://docs.github.com/enterprise-server@3.3/rest/overview/resources-in-the-rest-api#secondary-rate-limits)" and "[Dealing with secondary rate limits](https://docs.github.com/enterprise-server@3.3/rest/guides/best-practices-for-integrators#dealing-with-secondary-rate-limits)" for details. */
    post: operations["issues/create-comment"];
  };
  "/repos/{owner}/{repo}/issues/{issue_number}/events": {
    get: operations["issues/list-events"];
  };
  "/repos/{owner}/{repo}/issues/{issue_number}/labels": {
    get: operations["issues/list-labels-on-issue"];
    /** Removes any previous labels and sets the new labels for an issue. */
    put: operations["issues/set-labels"];
    post: operations["issues/add-labels"];
    delete: operations["issues/remove-all-labels"];
  };
  "/repos/{owner}/{repo}/issues/{issue_number}/labels/{name}": {
    /** Removes the specified label from the issue, and returns the remaining labels on the issue. This endpoint returns a `404 Not Found` status if the label does not exist. */
    delete: operations["issues/remove-label"];
  };
  "/repos/{owner}/{repo}/issues/{issue_number}/lock": {
    /**
     * Users with push access can lock an issue or pull request's conversation.
     *
     * Note that, if you choose not to pass any parameters, you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://docs.github.com/enterprise-server@3.3/rest/overview/resources-in-the-rest-api#http-verbs)."
     */
    put: operations["issues/lock"];
    /** Users with push access can unlock an issue's conversation. */
    delete: operations["issues/unlock"];
  };
  "/repos/{owner}/{repo}/issues/{issue_number}/reactions": {
    /** List the reactions to an [issue](https://docs.github.com/enterprise-server@3.3/rest/reference/issues). */
    get: operations["reactions/list-for-issue"];
    /** Create a reaction to an [issue](https://docs.github.com/enterprise-server@3.3/rest/reference/issues/). A response with an HTTP `200` status means that you already added the reaction type to this issue. */
    post: operations["reactions/create-for-issue"];
  };
  "/repos/{owner}/{repo}/issues/{issue_number}/reactions/{reaction_id}": {
    /**
     * **Note:** You can also specify a repository by `repository_id` using the route `DELETE /repositories/:repository_id/issues/:issue_number/reactions/:reaction_id`.
     *
     * Delete a reaction to an [issue](https://docs.github.com/enterprise-server@3.3/rest/reference/issues/).
     */
    delete: operations["reactions/delete-for-issue"];
  };
  "/repos/{owner}/{repo}/issues/{issue_number}/timeline": {
    get: operations["issues/list-events-for-timeline"];
  };
  "/repos/{owner}/{repo}/keys": {
    get: operations["repos/list-deploy-keys"];
    /** You can create a read-only deploy key. */
    post: operations["repos/create-deploy-key"];
  };
  "/repos/{owner}/{repo}/keys/{key_id}": {
    get: operations["repos/get-deploy-key"];
    /** Deploy keys are immutable. If you need to update a key, remove the key and create a new one instead. */
    delete: operations["repos/delete-deploy-key"];
  };
  "/repos/{owner}/{repo}/labels": {
    get: operations["issues/list-labels-for-repo"];
    post: operations["issues/create-label"];
  };
  "/repos/{owner}/{repo}/labels/{name}": {
    get: operations["issues/get-label"];
    delete: operations["issues/delete-label"];
    patch: operations["issues/update-label"];
  };
  "/repos/{owner}/{repo}/languages": {
    /** Lists languages for the specified repository. The value shown for each language is the number of bytes of code written in that language. */
    get: operations["repos/list-languages"];
  };
  "/repos/{owner}/{repo}/lfs": {
    put: operations["repos/enable-lfs-for-repo"];
    delete: operations["repos/disable-lfs-for-repo"];
  };
  "/repos/{owner}/{repo}/license": {
    /**
     * This method returns the contents of the repository's license file, if one is detected.
     *
     * Similar to [Get repository content](https://docs.github.com/enterprise-server@3.3/rest/reference/repos#get-repository-content), this method also supports [custom media types](https://docs.github.com/enterprise-server@3.3/rest/overview/media-types) for retrieving the raw license content or rendered license HTML.
     */
    get: operations["licenses/get-for-repo"];
  };
  "/repos/{owner}/{repo}/merge-upstream": {
    /** Sync a branch of a forked repository to keep it up-to-date with the upstream repository. */
    post: operations["repos/merge-upstream"];
  };
  "/repos/{owner}/{repo}/merges": {
    post: operations["repos/merge"];
  };
  "/repos/{owner}/{repo}/milestones": {
    get: operations["issues/list-milestones"];
    post: operations["issues/create-milestone"];
  };
  "/repos/{owner}/{repo}/milestones/{milestone_number}": {
    get: operations["issues/get-milestone"];
    delete: operations["issues/delete-milestone"];
    patch: operations["issues/update-milestone"];
  };
  "/repos/{owner}/{repo}/milestones/{milestone_number}/labels": {
    get: operations["issues/list-labels-for-milestone"];
  };
  "/repos/{owner}/{repo}/notifications": {
    /** List all notifications for the current user. */
    get: operations["activity/list-repo-notifications-for-authenticated-user"];
    /** Marks all notifications in a repository as "read" removes them from the [default view on GitHub Enterprise Server](https://github.com/notifications). If the number of notifications is too large to complete in one request, you will receive a `202 Accepted` status and GitHub Enterprise Server will run an asynchronous process to mark notifications as "read." To check whether any "unread" notifications remain, you can use the [List repository notifications for the authenticated user](https://docs.github.com/enterprise-server@3.3/rest/reference/activity#list-repository-notifications-for-the-authenticated-user) endpoint and pass the query parameter `all=false`. */
    put: operations["activity/mark-repo-notifications-as-read"];
  };
  "/repos/{owner}/{repo}/pages": {
    get: operations["repos/get-pages"];
    /** Updates information for a GitHub Enterprise Server Pages site. For more information, see "[About GitHub Pages](/github/working-with-github-pages/about-github-pages). */
    put: operations["repos/update-information-about-pages-site"];
    /** Configures a GitHub Enterprise Server Pages site. For more information, see "[About GitHub Pages](/github/working-with-github-pages/about-github-pages)." */
    post: operations["repos/create-pages-site"];
    delete: operations["repos/delete-pages-site"];
  };
  "/repos/{owner}/{repo}/pages/builds": {
    get: operations["repos/list-pages-builds"];
    /**
     * You can request that your site be built from the latest revision on the default branch. This has the same effect as pushing a commit to your default branch, but does not require an additional commit. Manually triggering page builds can be helpful when diagnosing build warnings and failures.
     *
     * Build requests are limited to one concurrent build per repository and one concurrent build per requester. If you request a build while another is still in progress, the second request will be queued until the first completes.
     */
    post: operations["repos/request-pages-build"];
  };
  "/repos/{owner}/{repo}/pages/builds/latest": {
    get: operations["repos/get-latest-pages-build"];
  };
  "/repos/{owner}/{repo}/pages/builds/{build_id}": {
    get: operations["repos/get-pages-build"];
  };
  "/repos/{owner}/{repo}/pre-receive-hooks": {
    /** List all pre-receive hooks that are enabled or testing for this repository as well as any disabled hooks that are allowed to be enabled at the repository level. Pre-receive hooks that are disabled at a higher level and are not configurable will not be listed. */
    get: operations["enterprise-admin/list-pre-receive-hooks-for-repo"];
  };
  "/repos/{owner}/{repo}/pre-receive-hooks/{pre_receive_hook_id}": {
    get: operations["enterprise-admin/get-pre-receive-hook-for-repo"];
    /**
     * Deletes any overridden enforcement on this repository for the specified hook.
     *
     * Responds with effective values inherited from owner and/or global level.
     */
    delete: operations["enterprise-admin/remove-pre-receive-hook-enforcement-for-repo"];
    /** For pre-receive hooks which are allowed to be configured at the repo level, you can set `enforcement` */
    patch: operations["enterprise-admin/update-pre-receive-hook-enforcement-for-repo"];
  };
  "/repos/{owner}/{repo}/projects": {
    /** Lists the projects in a repository. Returns a `404 Not Found` status if projects are disabled in the repository. If you do not have sufficient privileges to perform this action, a `401 Unauthorized` or `410 Gone` status is returned. */
    get: operations["projects/list-for-repo"];
    /** Creates a repository project board. Returns a `410 Gone` status if projects are disabled in the repository or if the repository does not have existing classic projects. If you do not have sufficient privileges to perform this action, a `401 Unauthorized` or `410 Gone` status is returned. */
    post: operations["projects/create-for-repo"];
  };
  "/repos/{owner}/{repo}/pulls": {
    /** Draft pull requests are available in public repositories with GitHub Free and GitHub Free for organizations, GitHub Pro, and legacy per-repository billing plans, and in public and private repositories with GitHub Team and GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation. */
    get: operations["pulls/list"];
    /**
     * Draft pull requests are available in public repositories with GitHub Free and GitHub Free for organizations, GitHub Pro, and legacy per-repository billing plans, and in public and private repositories with GitHub Team and GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * To open or update a pull request in a public repository, you must have write access to the head or the source branch. For organization-owned repositories, you must be a member of the organization that owns the repository to open or update a pull request.
     *
     * This endpoint triggers [notifications](https://docs.github.com/en/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. See "[Secondary rate limits](https://docs.github.com/enterprise-server@3.3/rest/overview/resources-in-the-rest-api#secondary-rate-limits)" and "[Dealing with secondary rate limits](https://docs.github.com/enterprise-server@3.3/rest/guides/best-practices-for-integrators#dealing-with-rate-limits)" for details.
     */
    post: operations["pulls/create"];
  };
  "/repos/{owner}/{repo}/pulls/comments": {
    /** Lists review comments for all pull requests in a repository. By default, review comments are in ascending order by ID. */
    get: operations["pulls/list-review-comments-for-repo"];
  };
  "/repos/{owner}/{repo}/pulls/comments/{comment_id}": {
    /** Provides details for a review comment. */
    get: operations["pulls/get-review-comment"];
    /** Deletes a review comment. */
    delete: operations["pulls/delete-review-comment"];
    /** Enables you to edit a review comment. */
    patch: operations["pulls/update-review-comment"];
  };
  "/repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions": {
    /** List the reactions to a [pull request review comment](https://docs.github.com/enterprise-server@3.3/rest/reference/pulls#review-comments). */
    get: operations["reactions/list-for-pull-request-review-comment"];
    /** Create a reaction to a [pull request review comment](https://docs.github.com/enterprise-server@3.3/rest/reference/pulls#comments). A response with an HTTP `200` status means that you already added the reaction type to this pull request review comment. */
    post: operations["reactions/create-for-pull-request-review-comment"];
  };
  "/repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions/{reaction_id}": {
    /**
     * **Note:** You can also specify a repository by `repository_id` using the route `DELETE /repositories/:repository_id/pulls/comments/:comment_id/reactions/:reaction_id.`
     *
     * Delete a reaction to a [pull request review comment](https://docs.github.com/enterprise-server@3.3/rest/reference/pulls#review-comments).
     */
    delete: operations["reactions/delete-for-pull-request-comment"];
  };
  "/repos/{owner}/{repo}/pulls/{pull_number}": {
    /**
     * Draft pull requests are available in public repositories with GitHub Free and GitHub Free for organizations, GitHub Pro, and legacy per-repository billing plans, and in public and private repositories with GitHub Team and GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * Lists details of a pull request by providing its number.
     *
     * When you get, [create](https://docs.github.com/enterprise-server@3.3/rest/reference/pulls/#create-a-pull-request), or [edit](https://docs.github.com/enterprise-server@3.3/rest/reference/pulls#update-a-pull-request) a pull request, GitHub Enterprise Server creates a merge commit to test whether the pull request can be automatically merged into the base branch. This test commit is not added to the base branch or the head branch. You can review the status of the test commit using the `mergeable` key. For more information, see "[Checking mergeability of pull requests](https://docs.github.com/enterprise-server@3.3/rest/guides/getting-started-with-the-git-database-api#checking-mergeability-of-pull-requests)".
     *
     * The value of the `mergeable` attribute can be `true`, `false`, or `null`. If the value is `null`, then GitHub Enterprise Server has started a background job to compute the mergeability. After giving the job time to complete, resubmit the request. When the job finishes, you will see a non-`null` value for the `mergeable` attribute in the response. If `mergeable` is `true`, then `merge_commit_sha` will be the SHA of the _test_ merge commit.
     *
     * The value of the `merge_commit_sha` attribute changes depending on the state of the pull request. Before merging a pull request, the `merge_commit_sha` attribute holds the SHA of the _test_ merge commit. After merging a pull request, the `merge_commit_sha` attribute changes depending on how you merged the pull request:
     *
     * *   If merged as a [merge commit](https://docs.github.com/articles/about-merge-methods-on-github/), `merge_commit_sha` represents the SHA of the merge commit.
     * *   If merged via a [squash](https://docs.github.com/articles/about-merge-methods-on-github/#squashing-your-merge-commits), `merge_commit_sha` represents the SHA of the squashed commit on the base branch.
     * *   If [rebased](https://docs.github.com/articles/about-merge-methods-on-github/#rebasing-and-merging-your-commits), `merge_commit_sha` represents the commit that the base branch was updated to.
     *
     * Pass the appropriate [media type](https://docs.github.com/enterprise-server@3.3/rest/overview/media-types/#commits-commit-comparison-and-pull-requests) to fetch diff and patch formats.
     */
    get: operations["pulls/get"];
    /**
     * Draft pull requests are available in public repositories with GitHub Free and GitHub Free for organizations, GitHub Pro, and legacy per-repository billing plans, and in public and private repositories with GitHub Team and GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * To open or update a pull request in a public repository, you must have write access to the head or the source branch. For organization-owned repositories, you must be a member of the organization that owns the repository to open or update a pull request.
     */
    patch: operations["pulls/update"];
  };
  "/repos/{owner}/{repo}/pulls/{pull_number}/comments": {
    /** Lists all review comments for a pull request. By default, review comments are in ascending order by ID. */
    get: operations["pulls/list-review-comments"];
    /**
     * Creates a review comment in the pull request diff. To add a regular comment to a pull request timeline, see "[Create an issue comment](https://docs.github.com/enterprise-server@3.3/rest/reference/issues#create-an-issue-comment)." We recommend creating a review comment using `line`, `side`, and optionally `start_line` and `start_side` if your comment applies to more than one line in the pull request diff.
     *
     * The `position` parameter is deprecated. If you use `position`, the `line`, `side`, `start_line`, and `start_side` parameters are not required.
     *
     * **Note:** The position value equals the number of lines down from the first "@@" hunk header in the file you want to add a comment. The line just below the "@@" line is position 1, the next line is position 2, and so on. The position in the diff continues to increase through lines of whitespace and additional hunks until the beginning of a new file.
     *
     * This endpoint triggers [notifications](https://docs.github.com/en/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. See "[Secondary rate limits](https://docs.github.com/enterprise-server@3.3/rest/overview/resources-in-the-rest-api#secondary-rate-limits)" and "[Dealing with secondary rate limits](https://docs.github.com/enterprise-server@3.3/rest/guides/best-practices-for-integrators#dealing-with-secondary-rate-limits)" for details.
     */
    post: operations["pulls/create-review-comment"];
  };
  "/repos/{owner}/{repo}/pulls/{pull_number}/comments/{comment_id}/replies": {
    /**
     * Creates a reply to a review comment for a pull request. For the `comment_id`, provide the ID of the review comment you are replying to. This must be the ID of a _top-level review comment_, not a reply to that comment. Replies to replies are not supported.
     *
     * This endpoint triggers [notifications](https://docs.github.com/en/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. See "[Secondary rate limits](https://docs.github.com/enterprise-server@3.3/rest/overview/resources-in-the-rest-api#secondary-rate-limits)" and "[Dealing with secondary rate limits](https://docs.github.com/enterprise-server@3.3/rest/guides/best-practices-for-integrators#dealing-with-secondary-rate-limits)" for details.
     */
    post: operations["pulls/create-reply-for-review-comment"];
  };
  "/repos/{owner}/{repo}/pulls/{pull_number}/commits": {
    /** Lists a maximum of 250 commits for a pull request. To receive a complete commit list for pull requests with more than 250 commits, use the [List commits](https://docs.github.com/enterprise-server@3.3/rest/reference/repos#list-commits) endpoint. */
    get: operations["pulls/list-commits"];
  };
  "/repos/{owner}/{repo}/pulls/{pull_number}/files": {
    /** **Note:** Responses include a maximum of 3000 files. The paginated response returns 30 files per page by default. */
    get: operations["pulls/list-files"];
  };
  "/repos/{owner}/{repo}/pulls/{pull_number}/merge": {
    get: operations["pulls/check-if-merged"];
    /** This endpoint triggers [notifications](https://docs.github.com/enterprise-server@3.3/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. See "[Secondary rate limits](https://docs.github.com/enterprise-server@3.3/rest/overview/resources-in-the-rest-api#secondary-rate-limits)" and "[Dealing with secondary rate limits](https://docs.github.com/enterprise-server@3.3/rest/guides/best-practices-for-integrators#dealing-with-secondary-rate-limits)" for details. */
    put: operations["pulls/merge"];
  };
  "/repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers": {
    /** Gets the users or teams whose review is requested for a pull request. Once a requested reviewer submits a review, they are no longer considered a requested reviewer. Their review will instead be returned by the [List reviews for a pull request](https://docs.github.com/enterprise-server@3.3/rest/pulls/reviews#list-reviews-for-a-pull-request) operation. */
    get: operations["pulls/list-requested-reviewers"];
    /** This endpoint triggers [notifications](https://docs.github.com/enterprise-server@3.3/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. See "[Secondary rate limits](https://docs.github.com/enterprise-server@3.3/rest/overview/resources-in-the-rest-api#secondary-rate-limits)" and "[Dealing with secondary rate limits](https://docs.github.com/enterprise-server@3.3/rest/guides/best-practices-for-integrators#dealing-with-secondary-rate-limits)" for details. */
    post: operations["pulls/request-reviewers"];
    delete: operations["pulls/remove-requested-reviewers"];
  };
  "/repos/{owner}/{repo}/pulls/{pull_number}/reviews": {
    /** The list of reviews returns in chronological order. */
    get: operations["pulls/list-reviews"];
    /**
     * This endpoint triggers [notifications](https://docs.github.com/en/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. See "[Secondary rate limits](https://docs.github.com/enterprise-server@3.3/rest/overview/resources-in-the-rest-api#secondary-rate-limits)" and "[Dealing with secondary rate limits](https://docs.github.com/enterprise-server@3.3/rest/guides/best-practices-for-integrators#dealing-with-secondary-rate-limits)" for details.
     *
     * Pull request reviews created in the `PENDING` state are not submitted and therefore do not include the `submitted_at` property in the response. To create a pending review for a pull request, leave the `event` parameter blank. For more information about submitting a `PENDING` review, see "[Submit a review for a pull request](https://docs.github.com/enterprise-server@3.3/rest/pulls#submit-a-review-for-a-pull-request)."
     *
     * **Note:** To comment on a specific line in a file, you need to first determine the _position_ of that line in the diff. The GitHub REST API v3 offers the `application/vnd.github.v3.diff` [media type](https://docs.github.com/enterprise-server@3.3/rest/overview/media-types#commits-commit-comparison-and-pull-requests). To see a pull request diff, add this media type to the `Accept` header of a call to the [single pull request](https://docs.github.com/enterprise-server@3.3/rest/reference/pulls#get-a-pull-request) endpoint.
     *
     * The `position` value equals the number of lines down from the first "@@" hunk header in the file you want to add a comment. The line just below the "@@" line is position 1, the next line is position 2, and so on. The position in the diff continues to increase through lines of whitespace and additional hunks until the beginning of a new file.
     */
    post: operations["pulls/create-review"];
  };
  "/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}": {
    get: operations["pulls/get-review"];
    /** Update the review summary comment with new text. */
    put: operations["pulls/update-review"];
    delete: operations["pulls/delete-pending-review"];
  };
  "/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/comments": {
    /** List comments for a specific pull request review. */
    get: operations["pulls/list-comments-for-review"];
  };
  "/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/dismissals": {
    /** **Note:** To dismiss a pull request review on a [protected branch](https://docs.github.com/enterprise-server@3.3/rest/reference/repos#branches), you must be a repository administrator or be included in the list of people or teams who can dismiss pull request reviews. */
    put: operations["pulls/dismiss-review"];
  };
  "/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/events": {
    /** Submits a pending review for a pull request. For more information about creating a pending review for a pull request, see "[Create a review for a pull request](https://docs.github.com/enterprise-server@3.3/rest/pulls#create-a-review-for-a-pull-request)." */
    post: operations["pulls/submit-review"];
  };
  "/repos/{owner}/{repo}/pulls/{pull_number}/update-branch": {
    /** Updates the pull request branch with the latest upstream changes by merging HEAD from the base branch into the pull request branch. */
    put: operations["pulls/update-branch"];
  };
  "/repos/{owner}/{repo}/readme": {
    /**
     * Gets the preferred README for a repository.
     *
     * READMEs support [custom media types](https://docs.github.com/enterprise-server@3.3/rest/reference/repos#custom-media-types) for retrieving the raw content or rendered HTML.
     */
    get: operations["repos/get-readme"];
  };
  "/repos/{owner}/{repo}/readme/{dir}": {
    /**
     * Gets the README from a repository directory.
     *
     * READMEs support [custom media types](https://docs.github.com/enterprise-server@3.3/rest/reference/repos#custom-media-types) for retrieving the raw content or rendered HTML.
     */
    get: operations["repos/get-readme-in-directory"];
  };
  "/repos/{owner}/{repo}/releases": {
    /**
     * This returns a list of releases, which does not include regular Git tags that have not been associated with a release. To get a list of Git tags, use the [Repository Tags API](https://docs.github.com/enterprise-server@3.3/rest/reference/repos#list-repository-tags).
     *
     * Information about published releases are available to everyone. Only users with push access will receive listings for draft releases.
     */
    get: operations["repos/list-releases"];
    /**
     * Users with push access to the repository can create a release.
     *
     * This endpoint triggers [notifications](https://docs.github.com/en/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. See "[Secondary rate limits](https://docs.github.com/enterprise-server@3.3/rest/overview/resources-in-the-rest-api#secondary-rate-limits)" and "[Dealing with secondary rate limits](https://docs.github.com/enterprise-server@3.3/rest/guides/best-practices-for-integrators#dealing-with-secondary-rate-limits)" for details.
     */
    post: operations["repos/create-release"];
  };
  "/repos/{owner}/{repo}/releases/assets/{asset_id}": {
    /** To download the asset's binary content, set the `Accept` header of the request to [`application/octet-stream`](https://docs.github.com/enterprise-server@3.3/rest/overview/media-types). The API will either redirect the client to the location, or stream it directly if possible. API clients should handle both a `200` or `302` response. */
    get: operations["repos/get-release-asset"];
    delete: operations["repos/delete-release-asset"];
    /** Users with push access to the repository can edit a release asset. */
    patch: operations["repos/update-release-asset"];
  };
  "/repos/{owner}/{repo}/releases/generate-notes": {
    /** Generate a name and body describing a [release](https://docs.github.com/enterprise-server@3.3/rest/reference/repos#releases). The body content will be markdown formatted and contain information like the changes since last release and users who contributed. The generated release notes are not saved anywhere. They are intended to be generated and used when creating a new release. */
    post: operations["repos/generate-release-notes"];
  };
  "/repos/{owner}/{repo}/releases/latest": {
    /**
     * View the latest published full release for the repository.
     *
     * The latest release is the most recent non-prerelease, non-draft release, sorted by the `created_at` attribute. The `created_at` attribute is the date of the commit used for the release, and not the date when the release was drafted or published.
     */
    get: operations["repos/get-latest-release"];
  };
  "/repos/{owner}/{repo}/releases/tags/{tag}": {
    /** Get a published release with the specified tag. */
    get: operations["repos/get-release-by-tag"];
  };
  "/repos/{owner}/{repo}/releases/{release_id}": {
    /** **Note:** This returns an `upload_url` key corresponding to the endpoint for uploading release assets. This key is a [hypermedia resource](https://docs.github.com/enterprise-server@3.3/rest/overview/resources-in-the-rest-api#hypermedia). */
    get: operations["repos/get-release"];
    /** Users with push access to the repository can delete a release. */
    delete: operations["repos/delete-release"];
    /** Users with push access to the repository can edit a release. */
    patch: operations["repos/update-release"];
  };
  "/repos/{owner}/{repo}/releases/{release_id}/assets": {
    get: operations["repos/list-release-assets"];
    /**
     * This endpoint makes use of [a Hypermedia relation](https://docs.github.com/enterprise-server@3.3/rest/overview/resources-in-the-rest-api#hypermedia) to determine which URL to access. The endpoint you call to upload release assets is specific to your release. Use the `upload_url` returned in
     * the response of the [Create a release endpoint](https://docs.github.com/enterprise-server@3.3/rest/reference/repos#create-a-release) to upload a release asset.
     *
     * You need to use an HTTP client which supports [SNI](http://en.wikipedia.org/wiki/Server_Name_Indication) to make calls to this endpoint.
     *
     * Most libraries will set the required `Content-Length` header automatically. Use the required `Content-Type` header to provide the media type of the asset. For a list of media types, see [Media Types](https://www.iana.org/assignments/media-types/media-types.xhtml). For example:
     *
     * `application/zip`
     *
     * GitHub Enterprise Server expects the asset data in its raw binary form, rather than JSON. You will send the raw binary content of the asset as the request body. Everything else about the endpoint is the same as the rest of the API. For example,
     * you'll still need to pass your authentication to be able to upload an asset.
     *
     * When an upstream failure occurs, you will receive a `502 Bad Gateway` status. This may leave an empty asset with a state of `starter`. It can be safely deleted.
     *
     * **Notes:**
     * *   GitHub Enterprise Server renames asset filenames that have special characters, non-alphanumeric characters, and leading or trailing periods. The "[List assets for a release](https://docs.github.com/enterprise-server@3.3/rest/reference/repos#list-assets-for-a-release)"
     * endpoint lists the renamed filenames. For more information and help, contact [GitHub Enterprise Server Support](https://support.github.com/contact?tags=dotcom-rest-api).
     * *   If you upload an asset with the same filename as another uploaded asset, you'll receive an error and must delete the old file before you can re-upload the new asset.
     */
    post: operations["repos/upload-release-asset"];
  };
  "/repos/{owner}/{repo}/releases/{release_id}/reactions": {
    /** List the reactions to a [release](https://docs.github.com/enterprise-server@3.3/rest/reference/repos#releases). */
    get: operations["reactions/list-for-release"];
    /** Create a reaction to a [release](https://docs.github.com/enterprise-server@3.3/rest/reference/repos#releases). A response with a `Status: 200 OK` means that you already added the reaction type to this release. */
    post: operations["reactions/create-for-release"];
  };
  "/repos/{owner}/{repo}/releases/{release_id}/reactions/{reaction_id}": {
    /**
     * **Note:** You can also specify a repository by `repository_id` using the route `DELETE delete /repositories/:repository_id/releases/:release_id/reactions/:reaction_id`.
     *
     * Delete a reaction to a [release](https://docs.github.com/enterprise-server@3.3/rest/reference/repos#releases).
     */
    delete: operations["reactions/delete-for-release"];
  };
  "/repos/{owner}/{repo}/secret-scanning/alerts": {
    /**
     * Lists secret scanning alerts for a private repository, from newest to oldest. To use this endpoint, you must be an administrator for the repository or organization, and you must use an access token with the `repo` scope or `security_events` scope.
     *
     * GitHub Apps must have the `secret_scanning_alerts` read permission to use this endpoint.
     */
    get: operations["secret-scanning/list-alerts-for-repo"];
  };
  "/repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}": {
    /**
     * Gets a single secret scanning alert detected in a private repository. To use this endpoint, you must be an administrator for the repository or organization, and you must use an access token with the `repo` scope or `security_events` scope.
     *
     * GitHub Apps must have the `secret_scanning_alerts` read permission to use this endpoint.
     */
    get: operations["secret-scanning/get-alert"];
    /**
     * Updates the status of a secret scanning alert in a private repository. To use this endpoint, you must be an administrator for the repository or organization, and you must use an access token with the `repo` scope or `security_events` scope.
     *
     * GitHub Apps must have the `secret_scanning_alerts` write permission to use this endpoint.
     */
    patch: operations["secret-scanning/update-alert"];
  };
  "/repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}/locations": {
    /**
     * Lists all locations for a given secret scanning alert for a private repository. To use this endpoint, you must be an administrator for the repository or organization, and you must use an access token with the `repo` scope or `security_events` scope.
     *
     * GitHub Apps must have the `secret_scanning_alerts` read permission to use this endpoint.
     */
    get: operations["secret-scanning/list-locations-for-alert"];
  };
  "/repos/{owner}/{repo}/stargazers": {
    /**
     * Lists the people that have starred the repository.
     *
     * You can also find out _when_ stars were created by passing the following custom [media type](https://docs.github.com/enterprise-server@3.3/rest/overview/media-types/) via the `Accept` header: `application/vnd.github.star+json`.
     */
    get: operations["activity/list-stargazers-for-repo"];
  };
  "/repos/{owner}/{repo}/stats/code_frequency": {
    /** Returns a weekly aggregate of the number of additions and deletions pushed to a repository. */
    get: operations["repos/get-code-frequency-stats"];
  };
  "/repos/{owner}/{repo}/stats/commit_activity": {
    /** Returns the last year of commit activity grouped by week. The `days` array is a group of commits per day, starting on `Sunday`. */
    get: operations["repos/get-commit-activity-stats"];
  };
  "/repos/{owner}/{repo}/stats/contributors": {
    /**
     * Returns the `total` number of commits authored by the contributor. In addition, the response includes a Weekly Hash (`weeks` array) with the following information:
     *
     * *   `w` - Start of the week, given as a [Unix timestamp](http://en.wikipedia.org/wiki/Unix_time).
     * *   `a` - Number of additions
     * *   `d` - Number of deletions
     * *   `c` - Number of commits
     */
    get: operations["repos/get-contributors-stats"];
  };
  "/repos/{owner}/{repo}/stats/participation": {
    /**
     * Returns the total commit counts for the `owner` and total commit counts in `all`. `all` is everyone combined, including the `owner` in the last 52 weeks. If you'd like to get the commit counts for non-owners, you can subtract `owner` from `all`.
     *
     * The array order is oldest week (index 0) to most recent week.
     */
    get: operations["repos/get-participation-stats"];
  };
  "/repos/{owner}/{repo}/stats/punch_card": {
    /**
     * Each array contains the day number, hour number, and number of commits:
     *
     * *   `0-6`: Sunday - Saturday
     * *   `0-23`: Hour of day
     * *   Number of commits
     *
     * For example, `[2, 14, 25]` indicates that there were 25 total commits, during the 2:00pm hour on Tuesdays. All times are based on the time zone of individual commits.
     */
    get: operations["repos/get-punch-card-stats"];
  };
  "/repos/{owner}/{repo}/statuses/{sha}": {
    /**
     * Users with push access in a repository can create commit statuses for a given SHA.
     *
     * Note: there is a limit of 1000 statuses per `sha` and `context` within a repository. Attempts to create more than 1000 statuses will result in a validation error.
     */
    post: operations["repos/create-commit-status"];
  };
  "/repos/{owner}/{repo}/subscribers": {
    /** Lists the people watching the specified repository. */
    get: operations["activity/list-watchers-for-repo"];
  };
  "/repos/{owner}/{repo}/subscription": {
    get: operations["activity/get-repo-subscription"];
    /** If you would like to watch a repository, set `subscribed` to `true`. If you would like to ignore notifications made within a repository, set `ignored` to `true`. If you would like to stop watching a repository, [delete the repository's subscription](https://docs.github.com/enterprise-server@3.3/rest/reference/activity#delete-a-repository-subscription) completely. */
    put: operations["activity/set-repo-subscription"];
    /** This endpoint should only be used to stop watching a repository. To control whether or not you wish to receive notifications from a repository, [set the repository's subscription manually](https://docs.github.com/enterprise-server@3.3/rest/reference/activity#set-a-repository-subscription). */
    delete: operations["activity/delete-repo-subscription"];
  };
  "/repos/{owner}/{repo}/tags": {
    get: operations["repos/list-tags"];
  };
  "/repos/{owner}/{repo}/tarball/{ref}": {
    /**
     * Gets a redirect URL to download a tar archive for a repository. If you omit `:ref`, the repository’s default branch (usually
     * `master`) will be used. Please make sure your HTTP framework is configured to follow redirects or you will need to use
     * the `Location` header to make a second `GET` request.
     * **Note**: For private repositories, these links are temporary and expire after five minutes.
     */
    get: operations["repos/download-tarball-archive"];
  };
  "/repos/{owner}/{repo}/teams": {
    get: operations["repos/list-teams"];
  };
  "/repos/{owner}/{repo}/topics": {
    get: operations["repos/get-all-topics"];
    put: operations["repos/replace-all-topics"];
  };
  "/repos/{owner}/{repo}/transfer": {
    /** A transfer request will need to be accepted by the new owner when transferring a personal repository to another user. The response will contain the original `owner`, and the transfer will continue asynchronously. For more details on the requirements to transfer personal and organization-owned repositories, see [about repository transfers](https://docs.github.com/articles/about-repository-transfers/). */
    post: operations["repos/transfer"];
  };
  "/repos/{owner}/{repo}/zipball/{ref}": {
    /**
     * Gets a redirect URL to download a zip archive for a repository. If you omit `:ref`, the repository’s default branch (usually
     * `master`) will be used. Please make sure your HTTP framework is configured to follow redirects or you will need to use
     * the `Location` header to make a second `GET` request.
     *
     * **Note**: For private repositories, these links are temporary and expire after five minutes. If the repository is empty, you will receive a 404 when you follow the redirect.
     */
    get: operations["repos/download-zipball-archive"];
  };
  "/repos/{template_owner}/{template_repo}/generate": {
    /**
     * Creates a new repository using a repository template. Use the `template_owner` and `template_repo` route parameters to specify the repository to use as the template. If the repository is not public, the authenticated user must own or be a member of an organization that owns the repository. To check if a repository is available to use as a template, get the repository's information using the [Get a repository](https://docs.github.com/enterprise-server@3.3/rest/reference/repos#get-a-repository) endpoint and check that the `is_template` key is `true`.
     *
     * **OAuth scope requirements**
     *
     * When using [OAuth](https://docs.github.com/enterprise-server@3.3/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/), authorizations must include:
     *
     * *   `public_repo` scope or `repo` scope to create a public repository. Note: For GitHub AE, use `repo` scope to create an internal repository.
     * *   `repo` scope to create a private repository
     */
    post: operations["repos/create-using-template"];
  };
  "/repositories": {
    /**
     * Lists all public repositories in the order that they were created.
     *
     * Note:
     * - For GitHub Enterprise Server, this endpoint will only list repositories available to all users on the enterprise.
     * - Pagination is powered exclusively by the `since` parameter. Use the [Link header](https://docs.github.com/enterprise-server@3.3/rest/overview/resources-in-the-rest-api#link-header) to get the URL for the next page of repositories.
     */
    get: operations["repos/list-public"];
  };
  "/repositories/{repository_id}/environments/{environment_name}/secrets": {
    /** Lists all secrets available in an environment without revealing their encrypted values. You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `secrets` repository permission to use this endpoint. */
    get: operations["actions/list-environment-secrets"];
  };
  "/repositories/{repository_id}/environments/{environment_name}/secrets/public-key": {
    /** Get the public key for an environment, which you need to encrypt environment secrets. You need to encrypt a secret before you can create or update secrets. Anyone with read access to the repository can use this endpoint. If the repository is private you must use an access token with the `repo` scope. GitHub Apps must have the `secrets` repository permission to use this endpoint. */
    get: operations["actions/get-environment-public-key"];
  };
  "/repositories/{repository_id}/environments/{environment_name}/secrets/{secret_name}": {
    /** Gets a single environment secret without revealing its encrypted value. You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `secrets` repository permission to use this endpoint. */
    get: operations["actions/get-environment-secret"];
    /**
     * Creates or updates an environment secret with an encrypted value. Encrypt your secret using
     * [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages). You must authenticate using an access
     * token with the `repo` scope to use this endpoint. GitHub Apps must have the `secrets` repository permission to use
     * this endpoint.
     *
     * #### Example encrypting a secret using Node.js
     *
     * Encrypt your secret using the [tweetsodium](https://github.com/github/tweetsodium) library.
     *
     * ```
     * const sodium = require('tweetsodium');
     *
     * const key = "base64-encoded-public-key";
     * const value = "plain-text-secret";
     *
     * // Convert the message and key to Uint8Array's (Buffer implements that interface)
     * const messageBytes = Buffer.from(value);
     * const keyBytes = Buffer.from(key, 'base64');
     *
     * // Encrypt using LibSodium.
     * const encryptedBytes = sodium.seal(messageBytes, keyBytes);
     *
     * // Base64 the encrypted secret
     * const encrypted = Buffer.from(encryptedBytes).toString('base64');
     *
     * console.log(encrypted);
     * ```
     *
     *
     * #### Example encrypting a secret using Python
     *
     * Encrypt your secret using [pynacl](https://pynacl.readthedocs.io/en/latest/public/#nacl-public-sealedbox) with Python 3.
     *
     * ```
     * from base64 import b64encode
     * from nacl import encoding, public
     *
     * def encrypt(public_key: str, secret_value: str) -> str:
     *   """Encrypt a Unicode string using the public key."""
     *   public_key = public.PublicKey(public_key.encode("utf-8"), encoding.Base64Encoder())
     *   sealed_box = public.SealedBox(public_key)
     *   encrypted = sealed_box.encrypt(secret_value.encode("utf-8"))
     *   return b64encode(encrypted).decode("utf-8")
     * ```
     *
     * #### Example encrypting a secret using C#
     *
     * Encrypt your secret using the [Sodium.Core](https://www.nuget.org/packages/Sodium.Core/) package.
     *
     * ```
     * var secretValue = System.Text.Encoding.UTF8.GetBytes("mySecret");
     * var publicKey = Convert.FromBase64String("2Sg8iYjAxxmI2LvUXpJjkYrMxURPc8r+dB7TJyvvcCU=");
     *
     * var sealedPublicKeyBox = Sodium.SealedPublicKeyBox.Create(secretValue, publicKey);
     *
     * Console.WriteLine(Convert.ToBase64String(sealedPublicKeyBox));
     * ```
     *
     * #### Example encrypting a secret using Ruby
     *
     * Encrypt your secret using the [rbnacl](https://github.com/RubyCrypto/rbnacl) gem.
     *
     * ```ruby
     * require "rbnacl"
     * require "base64"
     *
     * key = Base64.decode64("+ZYvJDZMHUfBkJdyq5Zm9SKqeuBQ4sj+6sfjlH4CgG0=")
     * public_key = RbNaCl::PublicKey.new(key)
     *
     * box = RbNaCl::Boxes::Sealed.from_public_key(public_key)
     * encrypted_secret = box.encrypt("my_secret")
     *
     * # Print the base64 encoded secret
     * puts Base64.strict_encode64(encrypted_secret)
     * ```
     */
    put: operations["actions/create-or-update-environment-secret"];
    /** Deletes a secret in an environment using the secret name. You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `secrets` repository permission to use this endpoint. */
    delete: operations["actions/delete-environment-secret"];
  };
  "/search/code": {
    /**
     * Searches for query terms inside of a file. This method returns up to 100 results [per page](https://docs.github.com/enterprise-server@3.3/rest/overview/resources-in-the-rest-api#pagination).
     *
     * When searching for code, you can get text match metadata for the file **content** and file **path** fields when you pass the `text-match` media type. For more details about how to receive highlighted search results, see [Text match metadata](https://docs.github.com/enterprise-server@3.3/rest/reference/search#text-match-metadata).
     *
     * For example, if you want to find the definition of the `addClass` function inside [jQuery](https://github.com/jquery/jquery) repository, your query would look something like this:
     *
     * `q=addClass+in:file+language:js+repo:jquery/jquery`
     *
     * This query searches for the keyword `addClass` within a file's contents. The query limits the search to files where the language is JavaScript in the `jquery/jquery` repository.
     *
     * #### Considerations for code search
     *
     * Due to the complexity of searching code, there are a few restrictions on how searches are performed:
     *
     * *   Only the _default branch_ is considered. In most cases, this will be the `master` branch.
     * *   Only files smaller than 384 KB are searchable.
     * *   You must always include at least one search term when searching source code. For example, searching for [`language:go`](https://github.com/search?utf8=%E2%9C%93&q=language%3Ago&type=Code) is not valid, while [`amazing
     * language:go`](https://github.com/search?utf8=%E2%9C%93&q=amazing+language%3Ago&type=Code) is.
     */
    get: operations["search/code"];
  };
  "/search/commits": {
    /**
     * Find commits via various criteria on the default branch (usually `master`). This method returns up to 100 results [per page](https://docs.github.com/enterprise-server@3.3/rest/overview/resources-in-the-rest-api#pagination).
     *
     * When searching for commits, you can get text match metadata for the **message** field when you provide the `text-match` media type. For more details about how to receive highlighted search results, see [Text match
     * metadata](https://docs.github.com/enterprise-server@3.3/rest/reference/search#text-match-metadata).
     *
     * For example, if you want to find commits related to CSS in the [octocat/Spoon-Knife](https://github.com/octocat/Spoon-Knife) repository. Your query would look something like this:
     *
     * `q=repo:octocat/Spoon-Knife+css`
     */
    get: operations["search/commits"];
  };
  "/search/issues": {
    /**
     * Find issues by state and keyword. This method returns up to 100 results [per page](https://docs.github.com/enterprise-server@3.3/rest/overview/resources-in-the-rest-api#pagination).
     *
     * When searching for issues, you can get text match metadata for the issue **title**, issue **body**, and issue **comment body** fields when you pass the `text-match` media type. For more details about how to receive highlighted
     * search results, see [Text match metadata](https://docs.github.com/enterprise-server@3.3/rest/reference/search#text-match-metadata).
     *
     * For example, if you want to find the oldest unresolved Python bugs on Windows. Your query might look something like this.
     *
     * `q=windows+label:bug+language:python+state:open&sort=created&order=asc`
     *
     * This query searches for the keyword `windows`, within any open issue that is labeled as `bug`. The search runs across repositories whose primary language is Python. The results are sorted by creation date in ascending order, which means the oldest issues appear first in the search results.
     *
     * **Note:** For [user-to-server](https://docs.github.com/developers/apps/identifying-and-authorizing-users-for-github-apps#user-to-server-requests) GitHub App requests, you can't retrieve a combination of issues and pull requests in a single query. Requests that don't include the `is:issue` or `is:pull-request` qualifier will receive an HTTP `422 Unprocessable Entity` response. To get results for both issues and pull requests, you must send separate queries for issues and pull requests. For more information about the `is` qualifier, see "[Searching only issues or pull requests](https://docs.github.com/github/searching-for-information-on-github/searching-issues-and-pull-requests#search-only-issues-or-pull-requests)."
     */
    get: operations["search/issues-and-pull-requests"];
  };
  "/search/labels": {
    /**
     * Find labels in a repository with names or descriptions that match search keywords. Returns up to 100 results [per page](https://docs.github.com/enterprise-server@3.3/rest/overview/resources-in-the-rest-api#pagination).
     *
     * When searching for labels, you can get text match metadata for the label **name** and **description** fields when you pass the `text-match` media type. For more details about how to receive highlighted search results, see [Text match metadata](https://docs.github.com/enterprise-server@3.3/rest/reference/search#text-match-metadata).
     *
     * For example, if you want to find labels in the `linguist` repository that match `bug`, `defect`, or `enhancement`. Your query might look like this:
     *
     * `q=bug+defect+enhancement&repository_id=64778136`
     *
     * The labels that best match the query appear first in the search results.
     */
    get: operations["search/labels"];
  };
  "/search/repositories": {
    /**
     * Find repositories via various criteria. This method returns up to 100 results [per page](https://docs.github.com/enterprise-server@3.3/rest/overview/resources-in-the-rest-api#pagination).
     *
     * When searching for repositories, you can get text match metadata for the **name** and **description** fields when you pass the `text-match` media type. For more details about how to receive highlighted search results, see [Text match metadata](https://docs.github.com/enterprise-server@3.3/rest/reference/search#text-match-metadata).
     *
     * For example, if you want to search for popular Tetris repositories written in assembly code, your query might look like this:
     *
     * `q=tetris+language:assembly&sort=stars&order=desc`
     *
     * This query searches for repositories with the word `tetris` in the name, the description, or the README. The results are limited to repositories where the primary language is assembly. The results are sorted by stars in descending order, so that the most popular repositories appear first in the search results.
     */
    get: operations["search/repos"];
  };
  "/search/topics": {
    /**
     * Find topics via various criteria. Results are sorted by best match. This method returns up to 100 results [per page](https://docs.github.com/enterprise-server@3.3/rest/overview/resources-in-the-rest-api#pagination). See "[Searching topics](https://docs.github.com/articles/searching-topics/)" for a detailed list of qualifiers.
     *
     * When searching for topics, you can get text match metadata for the topic's **short\_description**, **description**, **name**, or **display\_name** field when you pass the `text-match` media type. For more details about how to receive highlighted search results, see [Text match metadata](https://docs.github.com/enterprise-server@3.3/rest/reference/search#text-match-metadata).
     *
     * For example, if you want to search for topics related to Ruby that are featured on https://github.com/topics. Your query might look like this:
     *
     * `q=ruby+is:featured`
     *
     * This query searches for topics with the keyword `ruby` and limits the results to find only topics that are featured. The topics that are the best match for the query appear first in the search results.
     */
    get: operations["search/topics"];
  };
  "/search/users": {
    /**
     * Find users via various criteria. This method returns up to 100 results [per page](https://docs.github.com/enterprise-server@3.3/rest/overview/resources-in-the-rest-api#pagination).
     *
     * When searching for users, you can get text match metadata for the issue **login**, public **email**, and **name** fields when you pass the `text-match` media type. For more details about highlighting search results, see [Text match metadata](https://docs.github.com/enterprise-server@3.3/rest/reference/search#text-match-metadata). For more details about how to receive highlighted search results, see [Text match metadata](https://docs.github.com/enterprise-server@3.3/rest/reference/search#text-match-metadata).
     *
     * For example, if you're looking for a list of popular users, you might try this query:
     *
     * `q=tom+repos:%3E42+followers:%3E1000`
     *
     * This query searches for users with the name `tom`. The results are restricted to users with more than 42 repositories and over 1,000 followers.
     */
    get: operations["search/users"];
  };
  "/setup/api/configcheck": {
    /**
     * This endpoint allows you to check the status of the most recent configuration process:
     *
     * Note that you may need to wait several seconds after you start a process before you can check its status.
     *
     * The different statuses are:
     *
     * | Status        | Description                       |
     * | ------------- | --------------------------------- |
     * | `PENDING`     | The job has not started yet       |
     * | `CONFIGURING` | The job is running                |
     * | `DONE`        | The job has finished correctly    |
     * | `FAILED`      | The job has finished unexpectedly |
     */
    get: operations["enterprise-admin/get-configuration-status"];
  };
  "/setup/api/configure": {
    /** This endpoint allows you to start a configuration process at any time for your updated settings to take effect: */
    post: operations["enterprise-admin/start-configuration-process"];
  };
  "/setup/api/maintenance": {
    /** Check your installation's maintenance status: */
    get: operations["enterprise-admin/get-maintenance-status"];
    /** **Note:** The request body for this operation must be submitted as `application/x-www-form-urlencoded` data. You can submit a parameter value as a string, or you can use a tool such as `curl` to submit a parameter value as the contents of a text file. For more information, see the [`curl` documentation](https://curl.se/docs/manpage.html#--data-urlencode). */
    post: operations["enterprise-admin/enable-or-disable-maintenance-mode"];
  };
  "/setup/api/settings": {
    /**
     * Gets the settings for your instance. To change settings, see the [Set settings endpoint](https://docs.github.com/enterprise-server@3.3/rest/reference/enterprise-admin#set-settings).
     *
     * **Note:** You cannot retrieve the management console password with the Enterprise administration API.
     */
    get: operations["enterprise-admin/get-settings"];
    /**
     * Applies settings on your instance. For a list of the available settings, see the [Get settings endpoint](https://docs.github.com/enterprise-server@3.3/rest/reference/enterprise-admin#get-settings).
     *
     * **Notes:**
     *
     * - The request body for this operation must be submitted as `application/x-www-form-urlencoded` data. You can submit a parameter value as a string, or you can use a tool such as `curl` to submit a parameter value as the contents of a text file. For more information, see the [`curl` documentation](https://curl.se/docs/manpage.html#--data-urlencode).
     * - You cannot set the management console password with the Enterprise administration API. Use the `ghe-set-password` utility to change the management console password. For more information, see "[Command-line utilities](https://docs.github.com/enterprise-server@3.3/admin/configuration/configuring-your-enterprise/command-line-utilities#ghe-set-password)."
     */
    put: operations["enterprise-admin/set-settings"];
  };
  "/setup/api/settings/authorized-keys": {
    get: operations["enterprise-admin/get-all-authorized-ssh-keys"];
    /** **Note:** The request body for this operation must be submitted as `application/x-www-form-urlencoded` data. You can submit a parameter value as a string, or you can use a tool such as `curl` to submit a parameter value as the contents of a text file. For more information, see the [`curl` documentation](https://curl.se/docs/manpage.html#--data-urlencode). */
    post: operations["enterprise-admin/add-authorized-ssh-key"];
    /** **Note:** The request body for this operation must be submitted as `application/x-www-form-urlencoded` data. You can submit a parameter value as a string, or you can use a tool such as `curl` to submit a parameter value as the contents of a text file. For more information, see the [`curl` documentation](https://curl.se/docs/manpage.html#--data-urlencode). */
    delete: operations["enterprise-admin/remove-authorized-ssh-key"];
  };
  "/setup/api/start": {
    /**
     * When you boot a GitHub instance for the first time, you can use the following endpoint to upload a license.
     *
     * Note that you need to `POST` to [`/setup/api/configure`](https://docs.github.com/enterprise-server@3.3/rest/reference/enterprise-admin#start-a-configuration-process) to start the actual configuration process.
     *
     * When using this endpoint, your GitHub instance must have a password set. This can be accomplished two ways:
     *
     * 1.  If you're working directly with the API before accessing the web interface, you must pass in the password parameter to set your password.
     * 2.  If you set up your instance via the web interface before accessing the API, your calls to this endpoint do not need the password parameter.
     *
     * **Note:** The request body for this operation must be submitted as `application/x-www-form-urlencoded` data. You can submit a parameter value as a string, or you can use a tool such as `curl` to submit a parameter value as the contents of a text file. For more information, see the [`curl` documentation](https://curl.se/docs/manpage.html#--data-urlencode).
     */
    post: operations["enterprise-admin/create-enterprise-server-license"];
  };
  "/setup/api/upgrade": {
    /**
     * This API upgrades your license and also triggers the configuration process.
     *
     * **Note:** The request body for this operation must be submitted as `application/x-www-form-urlencoded` data. You can submit a parameter value as a string, or you can use a tool such as `curl` to submit a parameter value as the contents of a text file. For more information, see the [`curl` documentation](https://curl.se/docs/manpage.html#--data-urlencode).
     */
    post: operations["enterprise-admin/upgrade-license"];
  };
  "/teams/{team_id}": {
    /** **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the [Get a team by name](https://docs.github.com/enterprise-server@3.3/rest/reference/teams#get-a-team-by-name) endpoint. */
    get: operations["teams/get-legacy"];
    /**
     * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Delete a team](https://docs.github.com/enterprise-server@3.3/rest/reference/teams#delete-a-team) endpoint.
     *
     * To delete a team, the authenticated user must be an organization owner or team maintainer.
     *
     * If you are an organization owner, deleting a parent team will delete all of its child teams as well.
     */
    delete: operations["teams/delete-legacy"];
    /**
     * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Update a team](https://docs.github.com/enterprise-server@3.3/rest/reference/teams#update-a-team) endpoint.
     *
     * To edit a team, the authenticated user must either be an organization owner or a team maintainer.
     *
     * **Note:** With nested teams, the `privacy` for parent teams cannot be `secret`.
     */
    patch: operations["teams/update-legacy"];
  };
  "/teams/{team_id}/discussions": {
    /**
     * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List discussions`](https://docs.github.com/enterprise-server@3.3/rest/reference/teams#list-discussions) endpoint.
     *
     * List all discussions on a team's page. OAuth access tokens require the `read:discussion` [scope](https://docs.github.com/enterprise-server@3.3/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
     */
    get: operations["teams/list-discussions-legacy"];
    /**
     * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [`Create a discussion`](https://docs.github.com/enterprise-server@3.3/rest/reference/teams#create-a-discussion) endpoint.
     *
     * Creates a new discussion post on a team's page. OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/enterprise-server@3.3/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
     *
     * This endpoint triggers [notifications](https://docs.github.com/en/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. See "[Secondary rate limits](https://docs.github.com/enterprise-server@3.3/rest/overview/resources-in-the-rest-api#secondary-rate-limits)" and "[Dealing with secondary rate limits](https://docs.github.com/enterprise-server@3.3/rest/guides/best-practices-for-integrators#dealing-with-secondary-rate-limits)" for details.
     */
    post: operations["teams/create-discussion-legacy"];
  };
  "/teams/{team_id}/discussions/{discussion_number}": {
    /**
     * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Get a discussion](https://docs.github.com/enterprise-server@3.3/rest/reference/teams#get-a-discussion) endpoint.
     *
     * Get a specific discussion on a team's page. OAuth access tokens require the `read:discussion` [scope](https://docs.github.com/enterprise-server@3.3/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
     */
    get: operations["teams/get-discussion-legacy"];
    /**
     * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [`Delete a discussion`](https://docs.github.com/enterprise-server@3.3/rest/reference/teams#delete-a-discussion) endpoint.
     *
     * Delete a discussion from a team's page. OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/enterprise-server@3.3/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
     */
    delete: operations["teams/delete-discussion-legacy"];
    /**
     * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Update a discussion](https://docs.github.com/enterprise-server@3.3/rest/reference/teams#update-a-discussion) endpoint.
     *
     * Edits the title and body text of a discussion post. Only the parameters you provide are updated. OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/enterprise-server@3.3/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
     */
    patch: operations["teams/update-discussion-legacy"];
  };
  "/teams/{team_id}/discussions/{discussion_number}/comments": {
    /**
     * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [List discussion comments](https://docs.github.com/enterprise-server@3.3/rest/reference/teams#list-discussion-comments) endpoint.
     *
     * List all comments on a team discussion. OAuth access tokens require the `read:discussion` [scope](https://docs.github.com/enterprise-server@3.3/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
     */
    get: operations["teams/list-discussion-comments-legacy"];
    /**
     * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Create a discussion comment](https://docs.github.com/enterprise-server@3.3/rest/reference/teams#create-a-discussion-comment) endpoint.
     *
     * Creates a new comment on a team discussion. OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/enterprise-server@3.3/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
     *
     * This endpoint triggers [notifications](https://docs.github.com/en/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. See "[Secondary rate limits](https://docs.github.com/enterprise-server@3.3/rest/overview/resources-in-the-rest-api#secondary-rate-limits)" and "[Dealing with secondary rate limits](https://docs.github.com/enterprise-server@3.3/rest/guides/best-practices-for-integrators#dealing-with-secondary-rate-limits)" for details.
     */
    post: operations["teams/create-discussion-comment-legacy"];
  };
  "/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}": {
    /**
     * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Get a discussion comment](https://docs.github.com/enterprise-server@3.3/rest/reference/teams#get-a-discussion-comment) endpoint.
     *
     * Get a specific comment on a team discussion. OAuth access tokens require the `read:discussion` [scope](https://docs.github.com/enterprise-server@3.3/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
     */
    get: operations["teams/get-discussion-comment-legacy"];
    /**
     * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Delete a discussion comment](https://docs.github.com/enterprise-server@3.3/rest/reference/teams#delete-a-discussion-comment) endpoint.
     *
     * Deletes a comment on a team discussion. OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/enterprise-server@3.3/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
     */
    delete: operations["teams/delete-discussion-comment-legacy"];
    /**
     * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Update a discussion comment](https://docs.github.com/enterprise-server@3.3/rest/reference/teams#update-a-discussion-comment) endpoint.
     *
     * Edits the body text of a discussion comment. OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/enterprise-server@3.3/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
     */
    patch: operations["teams/update-discussion-comment-legacy"];
  };
  "/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/reactions": {
    /**
     * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List reactions for a team discussion comment`](https://docs.github.com/enterprise-server@3.3/rest/reference/reactions#list-reactions-for-a-team-discussion-comment) endpoint.
     *
     * List the reactions to a [team discussion comment](https://docs.github.com/enterprise-server@3.3/rest/reference/teams#discussion-comments). OAuth access tokens require the `read:discussion` [scope](https://docs.github.com/enterprise-server@3.3/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
     */
    get: operations["reactions/list-for-team-discussion-comment-legacy"];
    /**
     * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new "[Create reaction for a team discussion comment](https://docs.github.com/enterprise-server@3.3/rest/reference/reactions#create-reaction-for-a-team-discussion-comment)" endpoint.
     *
     * Create a reaction to a [team discussion comment](https://docs.github.com/enterprise-server@3.3/rest/reference/teams#discussion-comments). OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/enterprise-server@3.3/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/). A response with an HTTP `200` status means that you already added the reaction type to this team discussion comment.
     */
    post: operations["reactions/create-for-team-discussion-comment-legacy"];
  };
  "/teams/{team_id}/discussions/{discussion_number}/reactions": {
    /**
     * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List reactions for a team discussion`](https://docs.github.com/enterprise-server@3.3/rest/reference/reactions#list-reactions-for-a-team-discussion) endpoint.
     *
     * List the reactions to a [team discussion](https://docs.github.com/enterprise-server@3.3/rest/reference/teams#discussions). OAuth access tokens require the `read:discussion` [scope](https://docs.github.com/enterprise-server@3.3/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
     */
    get: operations["reactions/list-for-team-discussion-legacy"];
    /**
     * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [`Create reaction for a team discussion`](https://docs.github.com/enterprise-server@3.3/rest/reference/reactions#create-reaction-for-a-team-discussion) endpoint.
     *
     * Create a reaction to a [team discussion](https://docs.github.com/enterprise-server@3.3/rest/reference/teams#discussions). OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/enterprise-server@3.3/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/). A response with an HTTP `200` status means that you already added the reaction type to this team discussion.
     */
    post: operations["reactions/create-for-team-discussion-legacy"];
  };
  "/teams/{team_id}/members": {
    /**
     * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List team members`](https://docs.github.com/enterprise-server@3.3/rest/reference/teams#list-team-members) endpoint.
     *
     * Team members will include the members of child teams.
     */
    get: operations["teams/list-members-legacy"];
  };
  "/teams/{team_id}/members/{username}": {
    /**
     * The "Get team member" endpoint (described below) is deprecated.
     *
     * We recommend using the [Get team membership for a user](https://docs.github.com/enterprise-server@3.3/rest/reference/teams#get-team-membership-for-a-user) endpoint instead. It allows you to get both active and pending memberships.
     *
     * To list members in a team, the team must be visible to the authenticated user.
     */
    get: operations["teams/get-member-legacy"];
    /**
     * The "Add team member" endpoint (described below) is deprecated.
     *
     * We recommend using the [Add or update team membership for a user](https://docs.github.com/enterprise-server@3.3/rest/reference/teams#add-or-update-team-membership-for-a-user) endpoint instead. It allows you to invite new organization members to your teams.
     *
     * Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * To add someone to a team, the authenticated user must be an organization owner or a team maintainer in the team they're changing. The person being added to the team must be a member of the team's organization.
     *
     * **Note:** When you have team synchronization set up for a team with your organization's identity provider (IdP), you will see an error if you attempt to use the API for making changes to the team's membership. If you have access to manage group membership in your IdP, you can manage GitHub Enterprise Server team membership through your identity provider, which automatically adds and removes team members in an organization. For more information, see "[Synchronizing teams between your identity provider and GitHub Enterprise Server](https://docs.github.com/articles/synchronizing-teams-between-your-identity-provider-and-github/)."
     *
     * Note that you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://docs.github.com/enterprise-server@3.3/rest/overview/resources-in-the-rest-api#http-verbs)."
     */
    put: operations["teams/add-member-legacy"];
    /**
     * The "Remove team member" endpoint (described below) is deprecated.
     *
     * We recommend using the [Remove team membership for a user](https://docs.github.com/enterprise-server@3.3/rest/reference/teams#remove-team-membership-for-a-user) endpoint instead. It allows you to remove both active and pending memberships.
     *
     * Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * To remove a team member, the authenticated user must have 'admin' permissions to the team or be an owner of the org that the team is associated with. Removing a team member does not delete the user, it just removes them from the team.
     *
     * **Note:** When you have team synchronization set up for a team with your organization's identity provider (IdP), you will see an error if you attempt to use the API for making changes to the team's membership. If you have access to manage group membership in your IdP, you can manage GitHub Enterprise Server team membership through your identity provider, which automatically adds and removes team members in an organization. For more information, see "[Synchronizing teams between your identity provider and GitHub Enterprise Server](https://docs.github.com/articles/synchronizing-teams-between-your-identity-provider-and-github/)."
     */
    delete: operations["teams/remove-member-legacy"];
  };
  "/teams/{team_id}/memberships/{username}": {
    /**
     * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Get team membership for a user](https://docs.github.com/enterprise-server@3.3/rest/reference/teams#get-team-membership-for-a-user) endpoint.
     *
     * Team members will include the members of child teams.
     *
     * To get a user's membership with a team, the team must be visible to the authenticated user.
     *
     * **Note:**
     * The response contains the `state` of the membership and the member's `role`.
     *
     * The `role` for organization owners is set to `maintainer`. For more information about `maintainer` roles, see [Create a team](https://docs.github.com/enterprise-server@3.3/rest/reference/teams#create-a-team).
     */
    get: operations["teams/get-membership-for-user-legacy"];
    /**
     * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Add or update team membership for a user](https://docs.github.com/enterprise-server@3.3/rest/reference/teams#add-or-update-team-membership-for-a-user) endpoint.
     *
     * Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * If the user is already a member of the team's organization, this endpoint will add the user to the team. To add a membership between an organization member and a team, the authenticated user must be an organization owner or a team maintainer.
     *
     * **Note:** When you have team synchronization set up for a team with your organization's identity provider (IdP), you will see an error if you attempt to use the API for making changes to the team's membership. If you have access to manage group membership in your IdP, you can manage GitHub Enterprise Server team membership through your identity provider, which automatically adds and removes team members in an organization. For more information, see "[Synchronizing teams between your identity provider and GitHub Enterprise Server](https://docs.github.com/articles/synchronizing-teams-between-your-identity-provider-and-github/)."
     *
     * If the user is unaffiliated with the team's organization, this endpoint will send an invitation to the user via email. This newly-created membership will be in the "pending" state until the user accepts the invitation, at which point the membership will transition to the "active" state and the user will be added as a member of the team. To add a membership between an unaffiliated user and a team, the authenticated user must be an organization owner.
     *
     * If the user is already a member of the team, this endpoint will update the role of the team member's role. To update the membership of a team member, the authenticated user must be an organization owner or a team maintainer.
     */
    put: operations["teams/add-or-update-membership-for-user-legacy"];
    /**
     * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Remove team membership for a user](https://docs.github.com/enterprise-server@3.3/rest/reference/teams#remove-team-membership-for-a-user) endpoint.
     *
     * Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * To remove a membership between a user and a team, the authenticated user must have 'admin' permissions to the team or be an owner of the organization that the team is associated with. Removing team membership does not delete the user, it just removes their membership from the team.
     *
     * **Note:** When you have team synchronization set up for a team with your organization's identity provider (IdP), you will see an error if you attempt to use the API for making changes to the team's membership. If you have access to manage group membership in your IdP, you can manage GitHub Enterprise Server team membership through your identity provider, which automatically adds and removes team members in an organization. For more information, see "[Synchronizing teams between your identity provider and GitHub Enterprise Server](https://docs.github.com/articles/synchronizing-teams-between-your-identity-provider-and-github/)."
     */
    delete: operations["teams/remove-membership-for-user-legacy"];
  };
  "/teams/{team_id}/projects": {
    /**
     * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List team projects`](https://docs.github.com/enterprise-server@3.3/rest/reference/teams#list-team-projects) endpoint.
     *
     * Lists the organization projects for a team.
     */
    get: operations["teams/list-projects-legacy"];
  };
  "/teams/{team_id}/projects/{project_id}": {
    /**
     * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Check team permissions for a project](https://docs.github.com/enterprise-server@3.3/rest/reference/teams#check-team-permissions-for-a-project) endpoint.
     *
     * Checks whether a team has `read`, `write`, or `admin` permissions for an organization project. The response includes projects inherited from a parent team.
     */
    get: operations["teams/check-permissions-for-project-legacy"];
    /**
     * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Add or update team project permissions](https://docs.github.com/enterprise-server@3.3/rest/reference/teams#add-or-update-team-project-permissions) endpoint.
     *
     * Adds an organization project to a team. To add a project to a team or update the team's permission on a project, the authenticated user must have `admin` permissions for the project. The project and team must be part of the same organization.
     */
    put: operations["teams/add-or-update-project-permissions-legacy"];
    /**
     * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Remove a project from a team](https://docs.github.com/enterprise-server@3.3/rest/reference/teams#remove-a-project-from-a-team) endpoint.
     *
     * Removes an organization project from a team. An organization owner or a team maintainer can remove any project from the team. To remove a project from a team as an organization member, the authenticated user must have `read` access to both the team and project, or `admin` access to the team or project. **Note:** This endpoint removes the project from the team, but does not delete it.
     */
    delete: operations["teams/remove-project-legacy"];
  };
  "/teams/{team_id}/repos": {
    /** **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [List team repositories](https://docs.github.com/enterprise-server@3.3/rest/reference/teams#list-team-repositories) endpoint. */
    get: operations["teams/list-repos-legacy"];
  };
  "/teams/{team_id}/repos/{owner}/{repo}": {
    /**
     * **Note**: Repositories inherited through a parent team will also be checked.
     *
     * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Check team permissions for a repository](https://docs.github.com/enterprise-server@3.3/rest/reference/teams#check-team-permissions-for-a-repository) endpoint.
     *
     * You can also get information about the specified repository, including what permissions the team grants on it, by passing the following custom [media type](https://docs.github.com/enterprise-server@3.3/rest/overview/media-types/) via the `Accept` header:
     */
    get: operations["teams/check-permissions-for-repo-legacy"];
    /**
     * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new "[Add or update team repository permissions](https://docs.github.com/enterprise-server@3.3/rest/reference/teams#add-or-update-team-repository-permissions)" endpoint.
     *
     * To add a repository to a team or update the team's permission on a repository, the authenticated user must have admin access to the repository, and must be able to see the team. The repository must be owned by the organization, or a direct fork of a repository owned by the organization. You will get a `422 Unprocessable Entity` status if you attempt to add a repository to a team that is not owned by the organization.
     *
     * Note that, if you choose not to pass any parameters, you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://docs.github.com/enterprise-server@3.3/rest/overview/resources-in-the-rest-api#http-verbs)."
     */
    put: operations["teams/add-or-update-repo-permissions-legacy"];
    /**
     * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Remove a repository from a team](https://docs.github.com/enterprise-server@3.3/rest/reference/teams#remove-a-repository-from-a-team) endpoint.
     *
     * If the authenticated user is an organization owner or a team maintainer, they can remove any repositories from the team. To remove a repository from a team as an organization member, the authenticated user must have admin access to the repository and must be able to see the team. NOTE: This does not delete the repository, it just removes it from the team.
     */
    delete: operations["teams/remove-repo-legacy"];
  };
  "/teams/{team_id}/teams": {
    /** **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List child teams`](https://docs.github.com/enterprise-server@3.3/rest/reference/teams#list-child-teams) endpoint. */
    get: operations["teams/list-child-legacy"];
  };
  "/user": {
    /**
     * If the authenticated user is authenticated through basic authentication or OAuth with the `user` scope, then the response lists public and private profile information.
     *
     * If the authenticated user is authenticated through OAuth without the `user` scope, then the response lists only public profile information.
     */
    get: operations["users/get-authenticated"];
    /** **Note:** If your email is set to private and you send an `email` parameter as part of this request to update your profile, your privacy settings are still enforced: the email address will not be displayed on your public profile or via the API. */
    patch: operations["users/update-authenticated"];
  };
  "/user/emails": {
    /** Lists all of your email addresses, and specifies which one is visible to the public. This endpoint is accessible with the `user:email` scope. */
    get: operations["users/list-emails-for-authenticated-user"];
    /** This endpoint is accessible with the `user` scope. */
    post: operations["users/add-email-for-authenticated-user"];
    /** This endpoint is accessible with the `user` scope. */
    delete: operations["users/delete-email-for-authenticated-user"];
  };
  "/user/followers": {
    /** Lists the people following the authenticated user. */
    get: operations["users/list-followers-for-authenticated-user"];
  };
  "/user/following": {
    /** Lists the people who the authenticated user follows. */
    get: operations["users/list-followed-by-authenticated-user"];
  };
  "/user/following/{username}": {
    get: operations["users/check-person-is-followed-by-authenticated"];
    /**
     * Note that you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://docs.github.com/enterprise-server@3.3/rest/overview/resources-in-the-rest-api#http-verbs)."
     *
     * Following a user requires the user to be logged in and authenticated with basic auth or OAuth with the `user:follow` scope.
     */
    put: operations["users/follow"];
    /** Unfollowing a user requires the user to be logged in and authenticated with basic auth or OAuth with the `user:follow` scope. */
    delete: operations["users/unfollow"];
  };
  "/user/gpg_keys": {
    /** Lists the current user's GPG keys. Requires that you are authenticated via Basic Auth or via OAuth with at least `read:gpg_key` [scope](https://docs.github.com/enterprise-server@3.3/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/). */
    get: operations["users/list-gpg-keys-for-authenticated-user"];
    /** Adds a GPG key to the authenticated user's GitHub account. Requires that you are authenticated via Basic Auth, or OAuth with at least `write:gpg_key` [scope](https://docs.github.com/enterprise-server@3.3/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/). */
    post: operations["users/create-gpg-key-for-authenticated-user"];
  };
  "/user/gpg_keys/{gpg_key_id}": {
    /** View extended details for a single GPG key. Requires that you are authenticated via Basic Auth or via OAuth with at least `read:gpg_key` [scope](https://docs.github.com/enterprise-server@3.3/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/). */
    get: operations["users/get-gpg-key-for-authenticated-user"];
    /** Removes a GPG key from the authenticated user's GitHub account. Requires that you are authenticated via Basic Auth or via OAuth with at least `admin:gpg_key` [scope](https://docs.github.com/enterprise-server@3.3/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/). */
    delete: operations["users/delete-gpg-key-for-authenticated-user"];
  };
  "/user/installations": {
    /**
     * Lists installations of your GitHub App that the authenticated user has explicit permission (`:read`, `:write`, or `:admin`) to access.
     *
     * You must use a [user-to-server OAuth access token](https://docs.github.com/enterprise-server@3.3/apps/building-github-apps/identifying-and-authorizing-users-for-github-apps/#identifying-users-on-your-site), created for a user who has authorized your GitHub App, to access this endpoint.
     *
     * The authenticated user has explicit permission to access repositories they own, repositories where they are a collaborator, and repositories that they can access through an organization membership.
     *
     * You can find the permissions for the installation under the `permissions` key.
     */
    get: operations["apps/list-installations-for-authenticated-user"];
  };
  "/user/installations/{installation_id}/repositories": {
    /**
     * List repositories that the authenticated user has explicit permission (`:read`, `:write`, or `:admin`) to access for an installation.
     *
     * The authenticated user has explicit permission to access repositories they own, repositories where they are a collaborator, and repositories that they can access through an organization membership.
     *
     * You must use a [user-to-server OAuth access token](https://docs.github.com/enterprise-server@3.3/apps/building-github-apps/identifying-and-authorizing-users-for-github-apps/#identifying-users-on-your-site), created for a user who has authorized your GitHub App, to access this endpoint.
     *
     * The access the user has to each repository is included in the hash under the `permissions` key.
     */
    get: operations["apps/list-installation-repos-for-authenticated-user"];
  };
  "/user/installations/{installation_id}/repositories/{repository_id}": {
    /**
     * Add a single repository to an installation. The authenticated user must have admin access to the repository.
     *
     * You must use a personal access token (which you can create via the [command line](https://docs.github.com/enterprise-server@3.3/github/authenticating-to-github/creating-a-personal-access-token) or [Basic Authentication](https://docs.github.com/enterprise-server@3.3/rest/overview/other-authentication-methods#basic-authentication)) to access this endpoint.
     */
    put: operations["apps/add-repo-to-installation-for-authenticated-user"];
    /**
     * Remove a single repository from an installation. The authenticated user must have admin access to the repository.
     *
     * You must use a personal access token (which you can create via the [command line](https://docs.github.com/enterprise-server@3.3/github/authenticating-to-github/creating-a-personal-access-token) or [Basic Authentication](https://docs.github.com/enterprise-server@3.3/rest/overview/other-authentication-methods#basic-authentication)) to access this endpoint.
     */
    delete: operations["apps/remove-repo-from-installation-for-authenticated-user"];
  };
  "/user/issues": {
    /**
     * List issues across owned and member repositories assigned to the authenticated user.
     *
     * **Note**: GitHub's REST API v3 considers every pull request an issue, but not every issue is a pull request. For this
     * reason, "Issues" endpoints may return both issues and pull requests in the response. You can identify pull requests by
     * the `pull_request` key. Be aware that the `id` of a pull request returned from "Issues" endpoints will be an _issue id_. To find out the pull
     * request id, use the "[List pull requests](https://docs.github.com/enterprise-server@3.3/rest/reference/pulls#list-pull-requests)" endpoint.
     */
    get: operations["issues/list-for-authenticated-user"];
  };
  "/user/keys": {
    /** Lists the public SSH keys for the authenticated user's GitHub account. Requires that you are authenticated via Basic Auth or via OAuth with at least `read:public_key` [scope](https://docs.github.com/enterprise-server@3.3/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/). */
    get: operations["users/list-public-ssh-keys-for-authenticated-user"];
    /** Adds a public SSH key to the authenticated user's GitHub account. Requires that you are authenticated via Basic Auth, or OAuth with at least `write:public_key` [scope](https://docs.github.com/enterprise-server@3.3/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/). */
    post: operations["users/create-public-ssh-key-for-authenticated-user"];
  };
  "/user/keys/{key_id}": {
    /** View extended details for a single public SSH key. Requires that you are authenticated via Basic Auth or via OAuth with at least `read:public_key` [scope](https://docs.github.com/enterprise-server@3.3/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/). */
    get: operations["users/get-public-ssh-key-for-authenticated-user"];
    /** Removes a public SSH key from the authenticated user's GitHub account. Requires that you are authenticated via Basic Auth or via OAuth with at least `admin:public_key` [scope](https://docs.github.com/enterprise-server@3.3/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/). */
    delete: operations["users/delete-public-ssh-key-for-authenticated-user"];
  };
  "/user/memberships/orgs": {
    get: operations["orgs/list-memberships-for-authenticated-user"];
  };
  "/user/memberships/orgs/{org}": {
    get: operations["orgs/get-membership-for-authenticated-user"];
    patch: operations["orgs/update-membership-for-authenticated-user"];
  };
  "/user/orgs": {
    /**
     * List organizations for the authenticated user.
     *
     * **OAuth scope requirements**
     *
     * This only lists organizations that your authorization allows you to operate on in some way (e.g., you can list teams with `read:org` scope, you can publicize your organization membership with `user` scope, etc.). Therefore, this API requires at least `user` or `read:org` scope. OAuth requests with insufficient scope receive a `403 Forbidden` response.
     */
    get: operations["orgs/list-for-authenticated-user"];
  };
  "/user/projects": {
    /** Creates a user project board. Returns a `410 Gone` status if the user does not have existing classic projects. If you do not have sufficient privileges to perform this action, a `401 Unauthorized` or `410 Gone` status is returned. */
    post: operations["projects/create-for-authenticated-user"];
  };
  "/user/public_emails": {
    /** Lists your publicly visible email address, which you can set with the [Set primary email visibility for the authenticated user](https://docs.github.com/enterprise-server@3.3/rest/reference/users#set-primary-email-visibility-for-the-authenticated-user) endpoint. This endpoint is accessible with the `user:email` scope. */
    get: operations["users/list-public-emails-for-authenticated-user"];
  };
  "/user/repos": {
    /**
     * Lists repositories that the authenticated user has explicit permission (`:read`, `:write`, or `:admin`) to access.
     *
     * The authenticated user has explicit permission to access repositories they own, repositories where they are a collaborator, and repositories that they can access through an organization membership.
     */
    get: operations["repos/list-for-authenticated-user"];
    /**
     * Creates a new repository for the authenticated user.
     *
     * **OAuth scope requirements**
     *
     * When using [OAuth](https://docs.github.com/enterprise-server@3.3/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/), authorizations must include:
     *
     * *   `public_repo` scope or `repo` scope to create a public repository. Note: For GitHub AE, use `repo` scope to create an internal repository.
     * *   `repo` scope to create a private repository.
     */
    post: operations["repos/create-for-authenticated-user"];
  };
  "/user/repository_invitations": {
    /** When authenticating as a user, this endpoint will list all currently open repository invitations for that user. */
    get: operations["repos/list-invitations-for-authenticated-user"];
  };
  "/user/repository_invitations/{invitation_id}": {
    delete: operations["repos/decline-invitation-for-authenticated-user"];
    patch: operations["repos/accept-invitation-for-authenticated-user"];
  };
  "/user/starred": {
    /**
     * Lists repositories the authenticated user has starred.
     *
     * You can also find out _when_ stars were created by passing the following custom [media type](https://docs.github.com/enterprise-server@3.3/rest/overview/media-types/) via the `Accept` header: `application/vnd.github.star+json`.
     */
    get: operations["activity/list-repos-starred-by-authenticated-user"];
  };
  "/user/starred/{owner}/{repo}": {
    get: operations["activity/check-repo-is-starred-by-authenticated-user"];
    /** Note that you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://docs.github.com/enterprise-server@3.3/rest/overview/resources-in-the-rest-api#http-verbs)." */
    put: operations["activity/star-repo-for-authenticated-user"];
    delete: operations["activity/unstar-repo-for-authenticated-user"];
  };
  "/user/subscriptions": {
    /** Lists repositories the authenticated user is watching. */
    get: operations["activity/list-watched-repos-for-authenticated-user"];
  };
  "/user/teams": {
    /** List all of the teams across all of the organizations to which the authenticated user belongs. This method requires `user`, `repo`, or `read:org` [scope](https://docs.github.com/enterprise-server@3.3/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/) when authenticating via [OAuth](https://docs.github.com/enterprise-server@3.3/apps/building-oauth-apps/). */
    get: operations["teams/list-for-authenticated-user"];
  };
  "/users": {
    /**
     * Lists all users, in the order that they signed up on GitHub Enterprise Server. This list includes personal user accounts and organization accounts.
     *
     * Note: Pagination is powered exclusively by the `since` parameter. Use the [Link header](https://docs.github.com/enterprise-server@3.3/rest/overview/resources-in-the-rest-api#link-header) to get the URL for the next page of users.
     */
    get: operations["users/list"];
  };
  "/users/{username}": {
    /**
     * Provides publicly available information about someone with a GitHub account.
     *
     * GitHub Apps with the `Plan` user permission can use this endpoint to retrieve information about a user's GitHub Enterprise Server plan. The GitHub App must be authenticated as a user. See "[Identifying and authorizing users for GitHub Apps](https://docs.github.com/enterprise-server@3.3/apps/building-github-apps/identifying-and-authorizing-users-for-github-apps/)" for details about authentication. For an example response, see 'Response with GitHub Enterprise Server plan information' below"
     *
     * The `email` key in the following response is the publicly visible email address from your GitHub Enterprise Server [profile page](https://github.com/settings/profile). When setting up your profile, you can select a primary email address to be “public” which provides an email entry for this endpoint. If you do not set a public email address for `email`, then it will have a value of `null`. You only see publicly visible email addresses when authenticated with GitHub Enterprise Server. For more information, see [Authentication](https://docs.github.com/enterprise-server@3.3/rest/overview/resources-in-the-rest-api#authentication).
     *
     * The Emails API enables you to list all of your email addresses, and toggle a primary email to be visible publicly. For more information, see "[Emails API](https://docs.github.com/enterprise-server@3.3/rest/reference/users#emails)".
     */
    get: operations["users/get-by-username"];
  };
  "/users/{username}/events": {
    /** If you are authenticated as the given user, you will see your private events. Otherwise, you'll only see public events. */
    get: operations["activity/list-events-for-authenticated-user"];
  };
  "/users/{username}/events/orgs/{org}": {
    /** This is the user's organization dashboard. You must be authenticated as the user to view this. */
    get: operations["activity/list-org-events-for-authenticated-user"];
  };
  "/users/{username}/events/public": {
    get: operations["activity/list-public-events-for-user"];
  };
  "/users/{username}/followers": {
    /** Lists the people following the specified user. */
    get: operations["users/list-followers-for-user"];
  };
  "/users/{username}/following": {
    /** Lists the people who the specified user follows. */
    get: operations["users/list-following-for-user"];
  };
  "/users/{username}/following/{target_user}": {
    get: operations["users/check-following-for-user"];
  };
  "/users/{username}/gists": {
    /** Lists public gists for the specified user: */
    get: operations["gists/list-for-user"];
  };
  "/users/{username}/gpg_keys": {
    /** Lists the GPG keys for a user. This information is accessible by anyone. */
    get: operations["users/list-gpg-keys-for-user"];
  };
  "/users/{username}/hovercard": {
    /**
     * Provides hovercard information when authenticated through basic auth or OAuth with the `repo` scope. You can find out more about someone in relation to their pull requests, issues, repositories, and organizations.
     *
     * The `subject_type` and `subject_id` parameters provide context for the person's hovercard, which returns more information than without the parameters. For example, if you wanted to find out more about `octocat` who owns the `Spoon-Knife` repository via cURL, it would look like this:
     *
     * ```shell
     *  curl -u username:token
     *   https://api.github.com/users/octocat/hovercard?subject_type=repository&subject_id=1300192
     * ```
     */
    get: operations["users/get-context-for-user"];
  };
  "/users/{username}/installation": {
    /**
     * Enables an authenticated GitHub App to find the user’s installation information.
     *
     * You must use a [JWT](https://docs.github.com/enterprise-server@3.3/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
     */
    get: operations["apps/get-user-installation"];
  };
  "/users/{username}/keys": {
    /** Lists the _verified_ public SSH keys for a user. This is accessible by anyone. */
    get: operations["users/list-public-keys-for-user"];
  };
  "/users/{username}/orgs": {
    /**
     * List [public organization memberships](https://docs.github.com/articles/publicizing-or-concealing-organization-membership) for the specified user.
     *
     * This method only lists _public_ memberships, regardless of authentication. If you need to fetch all of the organization memberships (public and private) for the authenticated user, use the [List organizations for the authenticated user](https://docs.github.com/enterprise-server@3.3/rest/reference/orgs#list-organizations-for-the-authenticated-user) API instead.
     */
    get: operations["orgs/list-for-user"];
  };
  "/users/{username}/projects": {
    get: operations["projects/list-for-user"];
  };
  "/users/{username}/received_events": {
    /** These are events that you've received by watching repos and following users. If you are authenticated as the given user, you will see private events. Otherwise, you'll only see public events. */
    get: operations["activity/list-received-events-for-user"];
  };
  "/users/{username}/received_events/public": {
    get: operations["activity/list-received-public-events-for-user"];
  };
  "/users/{username}/repos": {
    /** Lists public repositories for the specified user. Note: For GitHub AE, this endpoint will list internal repositories for the specified user. */
    get: operations["repos/list-for-user"];
  };
  "/users/{username}/site_admin": {
    /** Note that you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://docs.github.com/enterprise-server@3.3/rest/overview/resources-in-the-rest-api#http-verbs)." */
    put: operations["enterprise-admin/promote-user-to-be-site-administrator"];
    /** You can demote any user account except your own. */
    delete: operations["enterprise-admin/demote-site-administrator"];
  };
  "/users/{username}/starred": {
    /**
     * Lists repositories a user has starred.
     *
     * You can also find out _when_ stars were created by passing the following custom [media type](https://docs.github.com/enterprise-server@3.3/rest/overview/media-types/) via the `Accept` header: `application/vnd.github.star+json`.
     */
    get: operations["activity/list-repos-starred-by-user"];
  };
  "/users/{username}/subscriptions": {
    /** Lists repositories a user is watching. */
    get: operations["activity/list-repos-watched-by-user"];
  };
  "/users/{username}/suspended": {
    /**
     * If your GitHub instance uses [LDAP Sync with Active Directory LDAP servers](https://docs.github.com/enterprise-server@3.3/admin/identity-and-access-management/using-ldap-for-enterprise-iam/using-ldap), Active Directory LDAP-authenticated users cannot be suspended through this API. If you attempt to suspend an Active Directory LDAP-authenticated user through this API, it will return a `403` response.
     *
     * You can suspend any user account except your own.
     *
     * Note that, if you choose not to pass any parameters, you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://docs.github.com/enterprise-server@3.3/rest/overview/resources-in-the-rest-api#http-verbs)."
     */
    put: operations["enterprise-admin/suspend-user"];
    /** If your GitHub instance uses [LDAP Sync with Active Directory LDAP servers](https://docs.github.com/enterprise-server@3.3/admin/identity-and-access-management/using-ldap-for-enterprise-iam/using-ldap), this API is disabled and will return a `403` response. Active Directory LDAP-authenticated users cannot be unsuspended using the API. */
    delete: operations["enterprise-admin/unsuspend-user"];
  };
  "/zen": {
    /** Get a random sentence from the Zen of GitHub */
    get: operations["meta/get-zen"];
  };
  "/repos/{owner}/{repo}/compare/{base}...{head}": {
    /**
     * **Deprecated**: Use `repos.compareCommitsWithBasehead()` (`GET /repos/{owner}/{repo}/compare/{basehead}`) instead. Both `:base` and `:head` must be branch names in `:repo`. To compare branches across other repositories in the same network as `:repo`, use the format `<USERNAME>:branch`.
     *
     * The response from the API is equivalent to running the `git log base..head` command; however, commits are returned in chronological order. Pass the appropriate [media type](https://docs.github.com/rest/overview/media-types/#commits-commit-comparison-and-pull-requests) to fetch diff and patch formats.
     *
     * The response also includes details on the files that were changed between the two commits. This includes the status of the change (for example, if a file was added, removed, modified, or renamed), and details of the change itself. For example, files with a `renamed` status have a `previous_filename` field showing the previous filename of the file, and files with a `modified` status have a `patch` field showing the changes made to the file.
     *
     * **Working with large comparisons**
     *
     * To process a response with a large number of commits, you can use (`per_page` or `page`) to paginate the results. When using paging, the list of changed files is only returned with page 1, but includes all changed files for the entire comparison. For more information on working with pagination, see "[Traversing with pagination](/rest/guides/traversing-with-pagination)."
     *
     * When calling this API without any paging parameters (`per_page` or `page`), the returned list is limited to 250 commits and the last commit in the list is the most recent of the entire comparison. When a paging parameter is specified, the first commit in the returned list of each page is the earliest.
     *
     * **Signature verification object**
     *
     * The response will include a `verification` object that describes the result of verifying the commit's signature. The following fields are included in the `verification` object:
     *
     * | Name | Type | Description |
     * | ---- | ---- | ----------- |
     * | `verified` | `boolean` | Indicates whether GitHub considers the signature in this commit to be verified. |
     * | `reason` | `string` | The reason for verified value. Possible values and their meanings are enumerated in table below. |
     * | `signature` | `string` | The signature that was extracted from the commit. |
     * | `payload` | `string` | The value that was signed. |
     *
     * These are the possible values for `reason` in the `verification` object:
     *
     * | Value | Description |
     * | ----- | ----------- |
     * | `expired_key` | The key that made the signature is expired. |
     * | `not_signing_key` | The "signing" flag is not among the usage flags in the GPG key that made the signature. |
     * | `gpgverify_error` | There was an error communicating with the signature verification service. |
     * | `gpgverify_unavailable` | The signature verification service is currently unavailable. |
     * | `unsigned` | The object does not include a signature. |
     * | `unknown_signature_type` | A non-PGP signature was found in the commit. |
     * | `no_user` | No user was associated with the `committer` email address in the commit. |
     * | `unverified_email` | The `committer` email address in the commit was associated with a user, but the email address is not verified on her/his account. |
     * | `bad_email` | The `committer` email address in the commit is not included in the identities of the PGP key that made the signature. |
     * | `unknown_key` | The key that made the signature has not been registered with any user's account. |
     * | `malformed_signature` | There was an error parsing the signature. |
     * | `invalid` | The signature could not be cryptographically verified using the key whose key-id was found in the signature. |
     * | `valid` | None of the above errors applied, so the signature is considered to be verified. |
     */
    get: operations["repos/compare-commits"];
  };
  "/content_references/{content_reference_id}/attachments": {
    /**
     * **Deprecated:** use `apps.createContentAttachmentForRepo()` (`POST /repos/{owner}/{repo}/content_references/{content_reference_id}/attachments`) instead. Creates an attachment under a content reference URL in the body or comment of an issue or pull request. Use the `id` of the content reference from the [`content_reference` event](https://docs.github.com/webhooks/event-payloads/#content_reference) to create an attachment.
     *
     * The app must create a content attachment within six hours of the content reference URL being posted. See "[Using content attachments](https://docs.github.com/apps/using-content-attachments/)" for details about content attachments.
     *
     * You must use an [installation access token](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-an-installation) to access this endpoint.
     */
    post: operations["apps/create-content-attachment"];
  };
  "/repos/{owner}/{repo}/community/code_of_conduct": {
    /**
     * Returns the contents of the repository's code of conduct file, if one is detected.
     *
     * A code of conduct is detected if there is a file named `CODE_OF_CONDUCT` in the root directory of the repository. GitHub detects which code of conduct it is using fuzzy matching.
     */
    get: operations["codes-of-conduct/get-for-repo"];
  };
  "/enterprises/{enterprise}/actions/runners/{runner_id}/labels": {
    /** This endpoint does not exist in GitHub Enterprise Server 3.3. It was added in 3.4 */
    get: operations["enterprise-admin/list-labels-for-self-hosted-runner-for-enterprise"];
    /** This endpoint does not exist in GitHub Enterprise Server 3.3. It was added in 3.4 */
    put: operations["enterprise-admin/set-custom-labels-for-self-hosted-runner-for-enterprise"];
    /** This endpoint does not exist in GitHub Enterprise Server 3.3. It was added in 3.4 */
    post: operations["enterprise-admin/add-custom-labels-to-self-hosted-runner-for-enterprise"];
    /** This endpoint does not exist in GitHub Enterprise Server 3.3. It was added in 3.4 */
    delete: operations["enterprise-admin/remove-all-custom-labels-from-self-hosted-runner-for-enterprise"];
  };
  "/enterprises/{enterprise}/actions/runners/{runner_id}/labels/{name}": {
    /** This endpoint does not exist in GitHub Enterprise Server 3.3. It was added in 3.4 */
    delete: operations["enterprise-admin/remove-custom-label-from-self-hosted-runner-for-enterprise"];
  };
  "/enterprises/{enterprise}/secret-scanning/alerts": {
    /** This endpoint does not exist in GitHub Enterprise Server 3.3. It was added in 3.4 */
    get: operations["secret-scanning/list-alerts-for-enterprise"];
  };
  "/enterprises/{enterprise}/settings/billing/advanced-security": {
    /** This endpoint does not exist in GitHub Enterprise Server 3.3. It was added in 3.4 */
    get: operations["billing/get-github-advanced-security-billing-ghe"];
  };
  "/organizations/{organization_id}/custom_roles": {
    /** This endpoint does not exist in GitHub Enterprise Server 3.3. It was added in 3.4 */
    get: operations["orgs/list-custom-roles"];
  };
  "/orgs/{org}/actions/runners/{runner_id}/labels": {
    /** This endpoint does not exist in GitHub Enterprise Server 3.3. It was added in 3.4 */
    get: operations["actions/list-labels-for-self-hosted-runner-for-org"];
    /** This endpoint does not exist in GitHub Enterprise Server 3.3. It was added in 3.4 */
    put: operations["actions/set-custom-labels-for-self-hosted-runner-for-org"];
    /** This endpoint does not exist in GitHub Enterprise Server 3.3. It was added in 3.4 */
    post: operations["actions/add-custom-labels-to-self-hosted-runner-for-org"];
    /** This endpoint does not exist in GitHub Enterprise Server 3.3. It was added in 3.4 */
    delete: operations["actions/remove-all-custom-labels-from-self-hosted-runner-for-org"];
  };
  "/orgs/{org}/actions/runners/{runner_id}/labels/{name}": {
    /** This endpoint does not exist in GitHub Enterprise Server 3.3. It was added in 3.4 */
    delete: operations["actions/remove-custom-label-from-self-hosted-runner-for-org"];
  };
  "/orgs/{org}/dependabot/secrets": {
    /** This endpoint does not exist in GitHub Enterprise Server 3.3. It was added in 3.4 */
    get: operations["dependabot/list-org-secrets"];
  };
  "/orgs/{org}/dependabot/secrets/public-key": {
    /** This endpoint does not exist in GitHub Enterprise Server 3.3. It was added in 3.4 */
    get: operations["dependabot/get-org-public-key"];
  };
  "/orgs/{org}/dependabot/secrets/{secret_name}": {
    /** This endpoint does not exist in GitHub Enterprise Server 3.3. It was added in 3.4 */
    get: operations["dependabot/get-org-secret"];
    /** This endpoint does not exist in GitHub Enterprise Server 3.3. It was added in 3.4 */
    put: operations["dependabot/create-or-update-org-secret"];
    /** This endpoint does not exist in GitHub Enterprise Server 3.3. It was added in 3.4 */
    delete: operations["dependabot/delete-org-secret"];
  };
  "/orgs/{org}/dependabot/secrets/{secret_name}/repositories": {
    /** This endpoint does not exist in GitHub Enterprise Server 3.3. It was added in 3.4 */
    get: operations["dependabot/list-selected-repos-for-org-secret"];
    /** This endpoint does not exist in GitHub Enterprise Server 3.3. It was added in 3.4 */
    put: operations["dependabot/set-selected-repos-for-org-secret"];
  };
  "/orgs/{org}/dependabot/secrets/{secret_name}/repositories/{repository_id}": {
    /** This endpoint does not exist in GitHub Enterprise Server 3.3. It was added in 3.4 */
    put: operations["dependabot/add-selected-repo-to-org-secret"];
    /** This endpoint does not exist in GitHub Enterprise Server 3.3. It was added in 3.4 */
    delete: operations["dependabot/remove-selected-repo-from-org-secret"];
  };
  "/orgs/{org}/migrations": {
    /** This endpoint does not exist in GitHub Enterprise Server 3.3. It was added in 3.4 */
    get: operations["migrations/list-for-org"];
    /** This endpoint does not exist in GitHub Enterprise Server 3.3. It was added in 3.4 */
    post: operations["migrations/start-for-org"];
  };
  "/orgs/{org}/migrations/{migration_id}": {
    /** This endpoint does not exist in GitHub Enterprise Server 3.3. It was added in 3.4 */
    get: operations["migrations/get-status-for-org"];
  };
  "/orgs/{org}/settings/billing/advanced-security": {
    /** This endpoint does not exist in GitHub Enterprise Server 3.3. It was added in 3.4 */
    get: operations["billing/get-github-advanced-security-billing-org"];
  };
  "/repos/{owner}/{repo}/actions/runners/{runner_id}/labels": {
    /** This endpoint does not exist in GitHub Enterprise Server 3.3. It was added in 3.4 */
    get: operations["actions/list-labels-for-self-hosted-runner-for-repo"];
    /** This endpoint does not exist in GitHub Enterprise Server 3.3. It was added in 3.4 */
    put: operations["actions/set-custom-labels-for-self-hosted-runner-for-repo"];
    /** This endpoint does not exist in GitHub Enterprise Server 3.3. It was added in 3.4 */
    post: operations["actions/add-custom-labels-to-self-hosted-runner-for-repo"];
    /** This endpoint does not exist in GitHub Enterprise Server 3.3. It was added in 3.4 */
    delete: operations["actions/remove-all-custom-labels-from-self-hosted-runner-for-repo"];
  };
  "/repos/{owner}/{repo}/actions/runners/{runner_id}/labels/{name}": {
    /** This endpoint does not exist in GitHub Enterprise Server 3.3. It was added in 3.4 */
    delete: operations["actions/remove-custom-label-from-self-hosted-runner-for-repo"];
  };
  "/repos/{owner}/{repo}/dependabot/secrets": {
    /** This endpoint does not exist in GitHub Enterprise Server 3.3. It was added in 3.4 */
    get: operations["dependabot/list-repo-secrets"];
  };
  "/repos/{owner}/{repo}/dependabot/secrets/public-key": {
    /** This endpoint does not exist in GitHub Enterprise Server 3.3. It was added in 3.4 */
    get: operations["dependabot/get-repo-public-key"];
  };
  "/repos/{owner}/{repo}/dependabot/secrets/{secret_name}": {
    /** This endpoint does not exist in GitHub Enterprise Server 3.3. It was added in 3.4 */
    get: operations["dependabot/get-repo-secret"];
    /** This endpoint does not exist in GitHub Enterprise Server 3.3. It was added in 3.4 */
    put: operations["dependabot/create-or-update-repo-secret"];
    /** This endpoint does not exist in GitHub Enterprise Server 3.3. It was added in 3.4 */
    delete: operations["dependabot/delete-repo-secret"];
  };
  "/repos/{owner}/{repo}/replicas/caches": {
    /** This endpoint does not exist in GitHub Enterprise Server 3.3. It was added in 3.4 */
    get: operations["repos/list-cache-info"];
  };
  "/user/migrations": {
    /** This endpoint does not exist in GitHub Enterprise Server 3.3. It was added in 3.4 */
    get: operations["migrations/list-for-authenticated-user"];
    /** This endpoint does not exist in GitHub Enterprise Server 3.3. It was added in 3.4 */
    post: operations["migrations/start-for-authenticated-user"];
  };
  "/user/migrations/{migration_id}/archive": {
    /** This endpoint does not exist in GitHub Enterprise Server 3.3. It was added in 3.4 */
    get: operations["migrations/get-archive-for-authenticated-user"];
  };
  "/user/migrations/{migration_id}/repositories": {
    /** This endpoint does not exist in GitHub Enterprise Server 3.3. It was added in 3.4 */
    get: operations["migrations/list-repos-for-authenticated-user"];
  };
}

export interface components {
  schemas: {
    root: {
      /** Format: uri-template */
      current_user_url: string;
      /** Format: uri-template */
      current_user_authorizations_html_url: string;
      /** Format: uri-template */
      authorizations_url: string;
      /** Format: uri-template */
      code_search_url: string;
      /** Format: uri-template */
      commit_search_url: string;
      /** Format: uri-template */
      emails_url: string;
      /** Format: uri-template */
      emojis_url: string;
      /** Format: uri-template */
      events_url: string;
      /** Format: uri-template */
      feeds_url: string;
      /** Format: uri-template */
      followers_url: string;
      /** Format: uri-template */
      following_url: string;
      /** Format: uri-template */
      gists_url: string;
      /** Format: uri-template */
      hub_url: string;
      /** Format: uri-template */
      issue_search_url: string;
      /** Format: uri-template */
      issues_url: string;
      /** Format: uri-template */
      keys_url: string;
      /** Format: uri-template */
      label_search_url: string;
      /** Format: uri-template */
      notifications_url: string;
      /** Format: uri-template */
      organization_url: string;
      /** Format: uri-template */
      organization_repositories_url: string;
      /** Format: uri-template */
      organization_teams_url: string;
      /** Format: uri-template */
      public_gists_url: string;
      /** Format: uri-template */
      rate_limit_url: string;
      /** Format: uri-template */
      repository_url: string;
      /** Format: uri-template */
      repository_search_url: string;
      /** Format: uri-template */
      current_user_repositories_url: string;
      /** Format: uri-template */
      starred_url: string;
      /** Format: uri-template */
      starred_gists_url: string;
      /** Format: uri-template */
      topic_search_url?: string;
      /** Format: uri-template */
      user_url: string;
      /** Format: uri-template */
      user_organizations_url: string;
      /** Format: uri-template */
      user_repositories_url: string;
      /** Format: uri-template */
      user_search_url: string;
    };
    "global-hook": {
      type?: string;
      id?: number;
      name?: string;
      active?: boolean;
      events?: string[];
      config?: {
        url?: string;
        content_type?: string;
        insecure_ssl?: string;
        secret?: string;
      };
      updated_at?: string;
      created_at?: string;
      url?: string;
      ping_url?: string;
    };
    "global-hook-2": {
      type?: string;
      id?: number;
      name?: string;
      active?: boolean;
      events?: string[];
      config?: {
        url?: string;
        content_type?: string;
        insecure_ssl?: string;
      };
      updated_at?: string;
      created_at?: string;
      url?: string;
      ping_url?: string;
    };
    "public-key-full": {
      id: number;
      key: string;
      user_id: number | null;
      repository_id: number | null;
      url: string;
      title: string;
      read_only: boolean;
      verified: boolean;
      /** Format: date-time */
      created_at: string;
    } & {
      last_used: unknown;
    };
    "ldap-mapping-team": {
      ldap_dn?: string;
      id?: number;
      node_id?: string;
      url?: string;
      html_url?: string;
      name?: string;
      slug?: string;
      description?: string | null;
      privacy?: string;
      permission?: string;
      members_url?: string;
      repositories_url?: string;
      parent?: unknown | null;
    };
    /**
     * Ldap Private User
     * @description Ldap Private User
     */
    "ldap-mapping-user": {
      ldap_dn?: string;
      /** @example octocat */
      login: string;
      /** @example 1 */
      id: number;
      /** @example MDQ6VXNlcjE= */
      node_id: string;
      /**
       * Format: uri
       * @example https://github.com/images/error/octocat_happy.gif
       */
      avatar_url: string;
      /** @example 41d064eb2195891e12d0413f63227ea7 */
      gravatar_id: string | null;
      /**
       * Format: uri
       * @example https://api.github.com/users/octocat
       */
      url: string;
      /**
       * Format: uri
       * @example https://github.com/octocat
       */
      html_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/users/octocat/followers
       */
      followers_url: string;
      /** @example https://api.github.com/users/octocat/following{/other_user} */
      following_url: string;
      /** @example https://api.github.com/users/octocat/gists{/gist_id} */
      gists_url: string;
      /** @example https://api.github.com/users/octocat/starred{/owner}{/repo} */
      starred_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/users/octocat/subscriptions
       */
      subscriptions_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/users/octocat/orgs
       */
      organizations_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/users/octocat/repos
       */
      repos_url: string;
      /** @example https://api.github.com/users/octocat/events{/privacy} */
      events_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/users/octocat/received_events
       */
      received_events_url: string;
      /** @example User */
      type: string;
      site_admin: boolean;
      /** @example monalisa octocat */
      name: string | null;
      /** @example GitHub */
      company: string | null;
      /** @example https://github.com/blog */
      blog: string | null;
      /** @example San Francisco */
      location: string | null;
      /**
       * Format: email
       * @example octocat@github.com
       */
      email: string | null;
      hireable: boolean | null;
      /** @example There once was... */
      bio: string | null;
      /** @example monalisa */
      twitter_username?: string | null;
      /** @example 2 */
      public_repos: number;
      /** @example 1 */
      public_gists: number;
      /** @example 20 */
      followers: number;
      /** @example 0 */
      following: number;
      /**
       * Format: date-time
       * @example 2008-01-14T04:33:35Z
       */
      created_at: string;
      /**
       * Format: date-time
       * @example 2008-01-14T04:33:35Z
       */
      updated_at: string;
      /** @example 81 */
      private_gists: number;
      /** @example 100 */
      total_private_repos: number;
      /** @example 100 */
      owned_private_repos: number;
      /** @example 10000 */
      disk_usage: number;
      /** @example 8 */
      collaborators: number;
      /** @example true */
      two_factor_authentication: boolean;
      plan?: {
        collaborators: number;
        name: string;
        space: number;
        private_repos: number;
      };
      /** Format: date-time */
      suspended_at?: string | null;
      business_plus?: boolean;
    };
    /**
     * Organization Simple
     * @description Organization Simple
     */
    "organization-simple": {
      /** @example github */
      login: string;
      /** @example 1 */
      id: number;
      /** @example MDEyOk9yZ2FuaXphdGlvbjE= */
      node_id: string;
      /**
       * Format: uri
       * @example https://api.github.com/orgs/github
       */
      url: string;
      /**
       * Format: uri
       * @example https://api.github.com/orgs/github/repos
       */
      repos_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/orgs/github/events
       */
      events_url: string;
      /** @example https://api.github.com/orgs/github/hooks */
      hooks_url: string;
      /** @example https://api.github.com/orgs/github/issues */
      issues_url: string;
      /** @example https://api.github.com/orgs/github/members{/member} */
      members_url: string;
      /** @example https://api.github.com/orgs/github/public_members{/member} */
      public_members_url: string;
      /** @example https://github.com/images/error/octocat_happy.gif */
      avatar_url: string;
      /** @example A great organization */
      description: string | null;
    };
    "pre-receive-environment": {
      id?: number;
      name?: string;
      image_url?: string;
      url?: string;
      html_url?: string;
      default_environment?: boolean;
      created_at?: string;
      hooks_count?: number;
      download?: {
        url?: string;
        state?: string;
        downloaded_at?: string | null;
        message?: string | null;
      };
    };
    "pre-receive-environment-download-status": {
      url?: string;
      state?: string;
      downloaded_at?: string | null;
      message?: string | null;
    };
    "pre-receive-hook": {
      id?: number;
      name?: string;
      enforcement?: string;
      script?: string;
      script_repository?: {
        id?: number;
        full_name?: string;
        url?: string;
        html_url?: string;
      };
      environment?: {
        id?: number;
        name?: string;
        image_url?: string;
        url?: string;
        html_url?: string;
        default_environment?: boolean;
        created_at?: string;
        hooks_count?: number;
        download?: {
          url?: string;
          state?: string;
          downloaded_at?: string | null;
          message?: string | null;
        };
      };
      allow_downstream_configuration?: boolean;
    };
    /**
     * Simple User
     * @description Simple User
     */
    "nullable-simple-user": {
      name?: string | null;
      email?: string | null;
      /** @example octocat */
      login: string;
      /** @example 1 */
      id: number;
      /** @example MDQ6VXNlcjE= */
      node_id: string;
      /**
       * Format: uri
       * @example https://github.com/images/error/octocat_happy.gif
       */
      avatar_url: string;
      /** @example 41d064eb2195891e12d0413f63227ea7 */
      gravatar_id: string | null;
      /**
       * Format: uri
       * @example https://api.github.com/users/octocat
       */
      url: string;
      /**
       * Format: uri
       * @example https://github.com/octocat
       */
      html_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/users/octocat/followers
       */
      followers_url: string;
      /** @example https://api.github.com/users/octocat/following{/other_user} */
      following_url: string;
      /** @example https://api.github.com/users/octocat/gists{/gist_id} */
      gists_url: string;
      /** @example https://api.github.com/users/octocat/starred{/owner}{/repo} */
      starred_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/users/octocat/subscriptions
       */
      subscriptions_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/users/octocat/orgs
       */
      organizations_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/users/octocat/repos
       */
      repos_url: string;
      /** @example https://api.github.com/users/octocat/events{/privacy} */
      events_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/users/octocat/received_events
       */
      received_events_url: string;
      /** @example User */
      type: string;
      site_admin: boolean;
      /** @example "2020-07-09T00:17:55Z" */
      starred_at?: string;
    } | null;
    /**
     * App Permissions
     * @description The permissions granted to the user-to-server access token.
     * @example {
     *   "contents": "read",
     *   "issues": "read",
     *   "deployments": "write",
     *   "single_file": "read"
     * }
     */
    "app-permissions": {
      /**
       * @description The level of permission to grant the access token for GitHub Actions workflows, workflow runs, and artifacts.
       * @enum {string}
       */
      actions?: "read" | "write";
      /**
       * @description The level of permission to grant the access token for repository creation, deletion, settings, teams, and collaborators creation.
       * @enum {string}
       */
      administration?: "read" | "write";
      /**
       * @description The level of permission to grant the access token for checks on code.
       * @enum {string}
       */
      checks?: "read" | "write";
      /**
       * @description The level of permission to grant the access token for repository contents, commits, branches, downloads, releases, and merges.
       * @enum {string}
       */
      contents?: "read" | "write";
      /**
       * @description The level of permission to grant the access token for deployments and deployment statuses.
       * @enum {string}
       */
      deployments?: "read" | "write";
      /**
       * @description The level of permission to grant the access token for managing repository environments.
       * @enum {string}
       */
      environments?: "read" | "write";
      /**
       * @description The level of permission to grant the access token for issues and related comments, assignees, labels, and milestones.
       * @enum {string}
       */
      issues?: "read" | "write";
      /**
       * @description The level of permission to grant the access token to search repositories, list collaborators, and access repository metadata.
       * @enum {string}
       */
      metadata?: "read" | "write";
      /**
       * @description The level of permission to grant the access token for packages published to GitHub Packages.
       * @enum {string}
       */
      packages?: "read" | "write";
      /**
       * @description The level of permission to grant the access token to retrieve Pages statuses, configuration, and builds, as well as create new builds.
       * @enum {string}
       */
      pages?: "read" | "write";
      /**
       * @description The level of permission to grant the access token for pull requests and related comments, assignees, labels, milestones, and merges.
       * @enum {string}
       */
      pull_requests?: "read" | "write";
      /**
       * @description The level of permission to grant the access token to manage the post-receive hooks for a repository.
       * @enum {string}
       */
      repository_hooks?: "read" | "write";
      /**
       * @description The level of permission to grant the access token to manage repository projects, columns, and cards.
       * @enum {string}
       */
      repository_projects?: "read" | "write" | "admin";
      /**
       * @description The level of permission to grant the access token to view and manage secret scanning alerts.
       * @enum {string}
       */
      secret_scanning_alerts?: "read" | "write";
      /**
       * @description The level of permission to grant the access token to manage repository secrets.
       * @enum {string}
       */
      secrets?: "read" | "write";
      /**
       * @description The level of permission to grant the access token to view and manage security events like code scanning alerts.
       * @enum {string}
       */
      security_events?: "read" | "write";
      /**
       * @description The level of permission to grant the access token to manage just a single file.
       * @enum {string}
       */
      single_file?: "read" | "write";
      /**
       * @description The level of permission to grant the access token for commit statuses.
       * @enum {string}
       */
      statuses?: "read" | "write";
      /**
       * @description The level of permission to grant the access token to manage Dependabot alerts.
       * @enum {string}
       */
      vulnerability_alerts?: "read" | "write";
      /**
       * @description The level of permission to grant the access token to update GitHub Actions workflow files.
       * @enum {string}
       */
      workflows?: "write";
      /**
       * @description The level of permission to grant the access token for organization teams and members.
       * @enum {string}
       */
      members?: "read" | "write";
      /**
       * @description The level of permission to grant the access token to manage access to an organization.
       * @enum {string}
       */
      organization_administration?: "read" | "write";
      /**
       * @description The level of permission to grant the access token to manage the post-receive hooks for an organization.
       * @enum {string}
       */
      organization_hooks?: "read" | "write";
      /**
       * @description The level of permission to grant the access token for viewing an organization's plan.
       * @enum {string}
       */
      organization_plan?: "read";
      /**
       * @description The level of permission to grant the access token to manage organization projects and projects beta (where available).
       * @enum {string}
       */
      organization_projects?: "read" | "write" | "admin";
      /**
       * @description The level of permission to grant the access token for organization packages published to GitHub Packages.
       * @enum {string}
       */
      organization_packages?: "read" | "write";
      /**
       * @description The level of permission to grant the access token to manage organization secrets.
       * @enum {string}
       */
      organization_secrets?: "read" | "write";
      /**
       * @description The level of permission to grant the access token to view and manage GitHub Actions self-hosted runners available to an organization.
       * @enum {string}
       */
      organization_self_hosted_runners?: "read" | "write";
      /**
       * @description The level of permission to grant the access token to view and manage users blocked by the organization.
       * @enum {string}
       */
      organization_user_blocking?: "read" | "write";
      /**
       * @description The level of permission to grant the access token to manage team discussions and related comments.
       * @enum {string}
       */
      team_discussions?: "read" | "write";
      /**
       * @description The level of permission to grant the access token for notification of content references and creation content attachments.
       * @enum {string}
       */
      content_references?: "read" | "write";
    };
    /**
     * Simple User
     * @description Simple User
     */
    "simple-user": {
      name?: string | null;
      email?: string | null;
      /** @example octocat */
      login: string;
      /** @example 1 */
      id: number;
      /** @example MDQ6VXNlcjE= */
      node_id: string;
      /**
       * Format: uri
       * @example https://github.com/images/error/octocat_happy.gif
       */
      avatar_url: string;
      /** @example 41d064eb2195891e12d0413f63227ea7 */
      gravatar_id: string | null;
      /**
       * Format: uri
       * @example https://api.github.com/users/octocat
       */
      url: string;
      /**
       * Format: uri
       * @example https://github.com/octocat
       */
      html_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/users/octocat/followers
       */
      followers_url: string;
      /** @example https://api.github.com/users/octocat/following{/other_user} */
      following_url: string;
      /** @example https://api.github.com/users/octocat/gists{/gist_id} */
      gists_url: string;
      /** @example https://api.github.com/users/octocat/starred{/owner}{/repo} */
      starred_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/users/octocat/subscriptions
       */
      subscriptions_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/users/octocat/orgs
       */
      organizations_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/users/octocat/repos
       */
      repos_url: string;
      /** @example https://api.github.com/users/octocat/events{/privacy} */
      events_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/users/octocat/received_events
       */
      received_events_url: string;
      /** @example User */
      type: string;
      site_admin: boolean;
      /** @example "2020-07-09T00:17:55Z" */
      starred_at?: string;
    };
    /** Scoped Installation */
    "nullable-scoped-installation": {
      permissions: components["schemas"]["app-permissions"];
      /**
       * @description Describe whether all repositories have been selected or there's a selection involved
       * @enum {string}
       */
      repository_selection: "all" | "selected";
      /** @example config.yaml */
      single_file_name: string | null;
      /** @example true */
      has_multiple_single_files?: boolean;
      /**
       * @example [
       *   "config.yml",
       *   ".github/issue_TEMPLATE.md"
       * ]
       */
      single_file_paths?: string[];
      /**
       * Format: uri
       * @example https://api.github.com/users/octocat/repos
       */
      repositories_url: string;
      account: components["schemas"]["simple-user"];
    } | null;
    /**
     * Authorization
     * @description The authorization for an OAuth app, GitHub App, or a Personal Access Token.
     */
    authorization: {
      id: number;
      /** Format: uri */
      url: string;
      /** @description A list of scopes that this authorization is in. */
      scopes: string[] | null;
      token: string;
      token_last_eight: string | null;
      hashed_token: string | null;
      app: {
        client_id: string;
        name: string;
        /** Format: uri */
        url: string;
      };
      note: string | null;
      /** Format: uri */
      note_url: string | null;
      /** Format: date-time */
      updated_at: string;
      /** Format: date-time */
      created_at: string;
      fingerprint: string | null;
      user?: components["schemas"]["nullable-simple-user"];
      installation?: components["schemas"]["nullable-scoped-installation"];
      /** Format: date-time */
      expires_at: string | null;
    };
    /**
     * GitHub app
     * @description GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
     */
    integration: {
      /**
       * @description Unique identifier of the GitHub app
       * @example 37
       */
      id: number;
      /**
       * @description The slug name of the GitHub app
       * @example probot-owners
       */
      slug?: string;
      /** @example MDExOkludGVncmF0aW9uMQ== */
      node_id: string;
      owner: components["schemas"]["nullable-simple-user"];
      /**
       * @description The name of the GitHub app
       * @example Probot Owners
       */
      name: string;
      /** @example The description of the app. */
      description: string | null;
      /**
       * Format: uri
       * @example https://example.com
       */
      external_url: string;
      /**
       * Format: uri
       * @example https://github.com/apps/super-ci
       */
      html_url: string;
      /**
       * Format: date-time
       * @example 2017-07-08T16:18:44-04:00
       */
      created_at: string;
      /**
       * Format: date-time
       * @example 2017-07-08T16:18:44-04:00
       */
      updated_at: string;
      /**
       * @description The set of permissions for the GitHub app
       * @example {
       *   "issues": "read",
       *   "deployments": "write"
       * }
       */
      permissions: {
        issues?: string;
        checks?: string;
        metadata?: string;
        contents?: string;
        deployments?: string;
      } & { [key: string]: string };
      /**
       * @description The list of events for the GitHub app
       * @example [
       *   "label",
       *   "deployment"
       * ]
       */
      events: string[];
      /**
       * @description The number of installations associated with the GitHub app
       * @example 5
       */
      installations_count?: number;
      /** @example "Iv1.25b5d1e65ffc4022" */
      client_id?: string;
      /** @example "1d4b2097ac622ba702d19de498f005747a8b21d3" */
      client_secret?: string;
      /** @example "6fba8f2fc8a7e8f2cca5577eddd82ca7586b3b6b" */
      webhook_secret?: string | null;
      /** @example "-----BEGIN RSA PRIVATE KEY-----\nMIIEogIBAAKCAQEArYxrNYD/iT5CZVpRJu4rBKmmze3PVmT/gCo2ATUvDvZTPTey\nxcGJ3vvrJXazKk06pN05TN29o98jrYz4cengG3YGsXPNEpKsIrEl8NhbnxapEnM9\nJCMRe0P5JcPsfZlX6hmiT7136GRWiGOUba2X9+HKh8QJVLG5rM007TBER9/z9mWm\nrJuNh+m5l320oBQY/Qq3A7wzdEfZw8qm/mIN0FCeoXH1L6B8xXWaAYBwhTEh6SSn\nZHlO1Xu1JWDmAvBCi0RO5aRSKM8q9QEkvvHP4yweAtK3N8+aAbZ7ovaDhyGz8r6r\nzhU1b8Uo0Z2ysf503WqzQgIajr7Fry7/kUwpgQIDAQABAoIBADwJp80Ko1xHPZDy\nfcCKBDfIuPvkmSW6KumbsLMaQv1aGdHDwwTGv3t0ixSay8CGlxMRtRDyZPib6SvQ\n6OH/lpfpbMdW2ErkksgtoIKBVrDilfrcAvrNZu7NxRNbhCSvN8q0s4ICecjbbVQh\nnueSdlA6vGXbW58BHMq68uRbHkP+k+mM9U0mDJ1HMch67wlg5GbayVRt63H7R2+r\nVxcna7B80J/lCEjIYZznawgiTvp3MSanTglqAYi+m1EcSsP14bJIB9vgaxS79kTu\noiSo93leJbBvuGo8QEiUqTwMw4tDksmkLsoqNKQ1q9P7LZ9DGcujtPy4EZsamSJT\ny8OJt0ECgYEA2lxOxJsQk2kI325JgKFjo92mQeUObIvPfSNWUIZQDTjniOI6Gv63\nGLWVFrZcvQBWjMEQraJA9xjPbblV8PtfO87MiJGLWCHFxmPz2dzoedN+2Coxom8m\nV95CLz8QUShuao6u/RYcvUaZEoYs5bHcTmy5sBK80JyEmafJPtCQVxMCgYEAy3ar\nZr3yv4xRPEPMat4rseswmuMooSaK3SKub19WFI5IAtB/e7qR1Rj9JhOGcZz+OQrl\nT78O2OFYlgOIkJPvRMrPpK5V9lslc7tz1FSh3BZMRGq5jSyD7ETSOQ0c8T2O/s7v\nbeEPbVbDe4mwvM24XByH0GnWveVxaDl51ABD65sCgYB3ZAspUkOA5egVCh8kNpnd\nSd6SnuQBE3ySRlT2WEnCwP9Ph6oPgn+oAfiPX4xbRqkL8q/k0BdHQ4h+zNwhk7+h\nWtPYRAP1Xxnc/F+jGjb+DVaIaKGU18MWPg7f+FI6nampl3Q0KvfxwX0GdNhtio8T\nTj1E+SnFwh56SRQuxSh2gwKBgHKjlIO5NtNSflsUYFM+hyQiPiqnHzddfhSG+/3o\nm5nNaSmczJesUYreH5San7/YEy2UxAugvP7aSY2MxB+iGsiJ9WD2kZzTUlDZJ7RV\nUzWsoqBR+eZfVJ2FUWWvy8TpSG6trh4dFxImNtKejCR1TREpSiTV3Zb1dmahK9GV\nrK9NAoGAbBxRLoC01xfxCTgt5BDiBcFVh4fp5yYKwavJPLzHSpuDOrrI9jDn1oKN\nonq5sDU1i391zfQvdrbX4Ova48BN+B7p63FocP/MK5tyyBoT8zQEk2+vWDOw7H/Z\nu5dTCPxTIsoIwUw1I+7yIxqJzLPFgR2gVBwY1ra/8iAqCj+zeBw=\n-----END RSA PRIVATE KEY-----\n" */
      pem?: string;
    };
    /**
     * Basic Error
     * @description Basic Error
     */
    "basic-error": {
      message?: string;
      documentation_url?: string;
      url?: string;
      status?: string;
    };
    /**
     * Validation Error Simple
     * @description Validation Error Simple
     */
    "validation-error-simple": {
      message: string;
      documentation_url: string;
      errors?: string[];
    };
    /**
     * Format: uri
     * @description The URL to which the payloads will be delivered.
     * @example https://example.com/webhook
     */
    "webhook-config-url": string;
    /**
     * @description The media type used to serialize the payloads. Supported values include `json` and `form`. The default is `form`.
     * @example "json"
     */
    "webhook-config-content-type": string;
    /**
     * @description If provided, the `secret` will be used as the `key` to generate the HMAC hex digest value for [delivery signature headers](https://docs.github.com/enterprise-server@3.3/webhooks/event-payloads/#delivery-headers).
     * @example "********"
     */
    "webhook-config-secret": string;
    "webhook-config-insecure-ssl": string | number;
    /**
     * Webhook Configuration
     * @description Configuration object of the webhook
     */
    "webhook-config": {
      url?: components["schemas"]["webhook-config-url"];
      content_type?: components["schemas"]["webhook-config-content-type"];
      secret?: components["schemas"]["webhook-config-secret"];
      insecure_ssl?: components["schemas"]["webhook-config-insecure-ssl"];
    };
    /**
     * Simple webhook delivery
     * @description Delivery made by a webhook, without request and response information.
     */
    "hook-delivery-item": {
      /**
       * @description Unique identifier of the webhook delivery.
       * @example 42
       */
      id: number;
      /**
       * @description Unique identifier for the event (shared with all deliveries for all webhooks that subscribe to this event).
       * @example 58474f00-b361-11eb-836d-0e4f3503ccbe
       */
      guid: string;
      /**
       * Format: date-time
       * @description Time when the webhook delivery occurred.
       * @example 2021-05-12T20:33:44Z
       */
      delivered_at: string;
      /**
       * @description Whether the webhook delivery is a redelivery.
       * @example false
       */
      redelivery: boolean;
      /**
       * @description Time spent delivering.
       * @example 0.03
       */
      duration: number;
      /**
       * @description Describes the response returned after attempting the delivery.
       * @example failed to connect
       */
      status: string;
      /**
       * @description Status code received when delivery was made.
       * @example 502
       */
      status_code: number;
      /**
       * @description The event that triggered the delivery.
       * @example issues
       */
      event: string;
      /**
       * @description The type of activity for the event that triggered the delivery.
       * @example opened
       */
      action: string | null;
      /**
       * @description The id of the GitHub App installation associated with this event.
       * @example 123
       */
      installation_id: number | null;
      /**
       * @description The id of the repository associated with this event.
       * @example 123
       */
      repository_id: number | null;
    };
    /**
     * Scim Error
     * @description Scim Error
     */
    "scim-error": {
      message?: string | null;
      documentation_url?: string | null;
      detail?: string | null;
      status?: number;
      scimType?: string | null;
      schemas?: string[];
    };
    /**
     * Validation Error
     * @description Validation Error
     */
    "validation-error": {
      message: string;
      documentation_url: string;
      errors?: {
        resource?: string;
        field?: string;
        message?: string;
        code: string;
        index?: number;
        value?: (string | null) | (number | null) | (string[] | null);
      }[];
    };
    /**
     * Webhook delivery
     * @description Delivery made by a webhook.
     */
    "hook-delivery": {
      /**
       * @description Unique identifier of the delivery.
       * @example 42
       */
      id: number;
      /**
       * @description Unique identifier for the event (shared with all deliveries for all webhooks that subscribe to this event).
       * @example 58474f00-b361-11eb-836d-0e4f3503ccbe
       */
      guid: string;
      /**
       * Format: date-time
       * @description Time when the delivery was delivered.
       * @example 2021-05-12T20:33:44Z
       */
      delivered_at: string;
      /**
       * @description Whether the delivery is a redelivery.
       * @example false
       */
      redelivery: boolean;
      /**
       * @description Time spent delivering.
       * @example 0.03
       */
      duration: number;
      /**
       * @description Description of the status of the attempted delivery
       * @example failed to connect
       */
      status: string;
      /**
       * @description Status code received when delivery was made.
       * @example 502
       */
      status_code: number;
      /**
       * @description The event that triggered the delivery.
       * @example issues
       */
      event: string;
      /**
       * @description The type of activity for the event that triggered the delivery.
       * @example opened
       */
      action: string | null;
      /**
       * @description The id of the GitHub App installation associated with this event.
       * @example 123
       */
      installation_id: number | null;
      /**
       * @description The id of the repository associated with this event.
       * @example 123
       */
      repository_id: number | null;
      /**
       * @description The URL target of the delivery.
       * @example https://www.example.com
       */
      url?: string;
      request: {
        /** @description The request headers sent with the webhook delivery. */
        headers: { [key: string]: unknown } | null;
        /** @description The webhook payload. */
        payload: { [key: string]: unknown } | null;
      };
      response: {
        /** @description The response headers received when the delivery was made. */
        headers: { [key: string]: unknown } | null;
        /** @description The response payload received. */
        payload: string | null;
      };
    };
    /**
     * Enterprise
     * @description An enterprise account
     */
    enterprise: {
      /** @description A short description of the enterprise. */
      description?: string | null;
      /**
       * Format: uri
       * @example https://github.com/enterprises/octo-business
       */
      html_url: string;
      /**
       * Format: uri
       * @description The enterprise's website URL.
       */
      website_url?: string | null;
      /**
       * @description Unique identifier of the enterprise
       * @example 42
       */
      id: number;
      /** @example MDEwOlJlcG9zaXRvcnkxMjk2MjY5 */
      node_id: string;
      /**
       * @description The name of the enterprise.
       * @example Octo Business
       */
      name: string;
      /**
       * @description The slug url identifier for the enterprise.
       * @example octo-business
       */
      slug: string;
      /**
       * Format: date-time
       * @example 2019-01-26T19:01:12Z
       */
      created_at: string | null;
      /**
       * Format: date-time
       * @example 2019-01-26T19:14:43Z
       */
      updated_at: string | null;
      /** Format: uri */
      avatar_url: string;
    };
    /**
     * Installation
     * @description Installation
     */
    installation: {
      /**
       * @description The ID of the installation.
       * @example 1
       */
      id: number;
      account:
        | (Partial<components["schemas"]["simple-user"]> &
            Partial<components["schemas"]["enterprise"]>)
        | null;
      /**
       * @description Describe whether all repositories have been selected or there's a selection involved
       * @enum {string}
       */
      repository_selection: "all" | "selected";
      /**
       * Format: uri
       * @example https://api.github.com/installations/1/access_tokens
       */
      access_tokens_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/installation/repositories
       */
      repositories_url: string;
      /**
       * Format: uri
       * @example https://github.com/organizations/github/settings/installations/1
       */
      html_url: string;
      /** @example 1 */
      app_id: number;
      /** @description The ID of the user or organization this token is being scoped to. */
      target_id: number;
      /** @example Organization */
      target_type: string;
      permissions: components["schemas"]["app-permissions"];
      events: string[];
      /** Format: date-time */
      created_at: string;
      /** Format: date-time */
      updated_at: string;
      /** @example config.yaml */
      single_file_name: string | null;
      /** @example true */
      has_multiple_single_files?: boolean;
      /**
       * @example [
       *   "config.yml",
       *   ".github/issue_TEMPLATE.md"
       * ]
       */
      single_file_paths?: string[];
      /** @example github-actions */
      app_slug: string;
      suspended_by: components["schemas"]["nullable-simple-user"];
      /** Format: date-time */
      suspended_at: string | null;
      /** @example "test_13f1e99741e3e004@d7e1eb0bc0a1ba12.com" */
      contact_email?: string | null;
    };
    /**
     * License Simple
     * @description License Simple
     */
    "nullable-license-simple": {
      /** @example mit */
      key: string;
      /** @example MIT License */
      name: string;
      /**
       * Format: uri
       * @example https://api.github.com/licenses/mit
       */
      url: string | null;
      /** @example MIT */
      spdx_id: string | null;
      /** @example MDc6TGljZW5zZW1pdA== */
      node_id: string;
      /** Format: uri */
      html_url?: string;
    } | null;
    /**
     * Repository
     * @description A git repository
     */
    repository: {
      /**
       * @description Unique identifier of the repository
       * @example 42
       */
      id: number;
      /** @example MDEwOlJlcG9zaXRvcnkxMjk2MjY5 */
      node_id: string;
      /**
       * @description The name of the repository.
       * @example Team Environment
       */
      name: string;
      /** @example octocat/Hello-World */
      full_name: string;
      license: components["schemas"]["nullable-license-simple"];
      organization?: components["schemas"]["nullable-simple-user"];
      forks: number;
      permissions?: {
        admin: boolean;
        pull: boolean;
        triage?: boolean;
        push: boolean;
        maintain?: boolean;
      };
      owner: components["schemas"]["simple-user"];
      /**
       * @description Whether the repository is private or public.
       * @default false
       */
      private: boolean;
      /**
       * Format: uri
       * @example https://github.com/octocat/Hello-World
       */
      html_url: string;
      /** @example This your first repo! */
      description: string | null;
      fork: boolean;
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/Hello-World
       */
      url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/{archive_format}{/ref} */
      archive_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/assignees{/user} */
      assignees_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/git/blobs{/sha} */
      blobs_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/branches{/branch} */
      branches_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/collaborators{/collaborator} */
      collaborators_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/comments{/number} */
      comments_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/commits{/sha} */
      commits_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/compare/{base}...{head} */
      compare_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/contents/{+path} */
      contents_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/contributors
       */
      contributors_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/deployments
       */
      deployments_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/downloads
       */
      downloads_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/events
       */
      events_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/forks
       */
      forks_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/git/commits{/sha} */
      git_commits_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/git/refs{/sha} */
      git_refs_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/git/tags{/sha} */
      git_tags_url: string;
      /** @example git:github.com/octocat/Hello-World.git */
      git_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/issues/comments{/number} */
      issue_comment_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/issues/events{/number} */
      issue_events_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/issues{/number} */
      issues_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/keys{/key_id} */
      keys_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/labels{/name} */
      labels_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/languages
       */
      languages_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/merges
       */
      merges_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/milestones{/number} */
      milestones_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/notifications{?since,all,participating} */
      notifications_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/pulls{/number} */
      pulls_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/releases{/id} */
      releases_url: string;
      /** @example git@github.com:octocat/Hello-World.git */
      ssh_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/stargazers
       */
      stargazers_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/statuses/{sha} */
      statuses_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/subscribers
       */
      subscribers_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/subscription
       */
      subscription_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/tags
       */
      tags_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/teams
       */
      teams_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/git/trees{/sha} */
      trees_url: string;
      /** @example https://github.com/octocat/Hello-World.git */
      clone_url: string;
      /**
       * Format: uri
       * @example git:git.example.com/octocat/Hello-World
       */
      mirror_url: string | null;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/hooks
       */
      hooks_url: string;
      /**
       * Format: uri
       * @example https://svn.github.com/octocat/Hello-World
       */
      svn_url: string;
      /**
       * Format: uri
       * @example https://github.com
       */
      homepage: string | null;
      language: string | null;
      /** @example 9 */
      forks_count: number;
      /** @example 80 */
      stargazers_count: number;
      /** @example 80 */
      watchers_count: number;
      /**
       * @description The size of the repository. Size is calculated hourly. When a repository is initially created, the size is 0.
       * @example 108
       */
      size: number;
      /**
       * @description The default branch of the repository.
       * @example master
       */
      default_branch: string;
      /** @example 0 */
      open_issues_count: number;
      /**
       * @description Whether this repository acts as a template that can be used to generate new repositories.
       * @default false
       * @example true
       */
      is_template?: boolean;
      topics?: string[];
      /**
       * @description Whether issues are enabled.
       * @default true
       * @example true
       */
      has_issues: boolean;
      /**
       * @description Whether projects are enabled.
       * @default true
       * @example true
       */
      has_projects: boolean;
      /**
       * @description Whether the wiki is enabled.
       * @default true
       * @example true
       */
      has_wiki: boolean;
      has_pages: boolean;
      /**
       * @description Whether downloads are enabled.
       * @default true
       * @example true
       */
      has_downloads: boolean;
      /**
       * @description Whether the repository is archived.
       * @default false
       */
      archived: boolean;
      /** @description Returns whether or not this repository disabled. */
      disabled: boolean;
      /**
       * @description The repository visibility: public, private, or internal.
       * @default public
       */
      visibility?: string;
      /**
       * Format: date-time
       * @example 2011-01-26T19:06:43Z
       */
      pushed_at: string | null;
      /**
       * Format: date-time
       * @example 2011-01-26T19:01:12Z
       */
      created_at: string | null;
      /**
       * Format: date-time
       * @example 2011-01-26T19:14:43Z
       */
      updated_at: string | null;
      /**
       * @description Whether to allow rebase merges for pull requests.
       * @default true
       * @example true
       */
      allow_rebase_merge?: boolean;
      template_repository?: {
        id?: number;
        node_id?: string;
        name?: string;
        full_name?: string;
        owner?: {
          login?: string;
          id?: number;
          node_id?: string;
          avatar_url?: string;
          gravatar_id?: string;
          url?: string;
          html_url?: string;
          followers_url?: string;
          following_url?: string;
          gists_url?: string;
          starred_url?: string;
          subscriptions_url?: string;
          organizations_url?: string;
          repos_url?: string;
          events_url?: string;
          received_events_url?: string;
          type?: string;
          site_admin?: boolean;
        };
        private?: boolean;
        html_url?: string;
        description?: string;
        fork?: boolean;
        url?: string;
        archive_url?: string;
        assignees_url?: string;
        blobs_url?: string;
        branches_url?: string;
        collaborators_url?: string;
        comments_url?: string;
        commits_url?: string;
        compare_url?: string;
        contents_url?: string;
        contributors_url?: string;
        deployments_url?: string;
        downloads_url?: string;
        events_url?: string;
        forks_url?: string;
        git_commits_url?: string;
        git_refs_url?: string;
        git_tags_url?: string;
        git_url?: string;
        issue_comment_url?: string;
        issue_events_url?: string;
        issues_url?: string;
        keys_url?: string;
        labels_url?: string;
        languages_url?: string;
        merges_url?: string;
        milestones_url?: string;
        notifications_url?: string;
        pulls_url?: string;
        releases_url?: string;
        ssh_url?: string;
        stargazers_url?: string;
        statuses_url?: string;
        subscribers_url?: string;
        subscription_url?: string;
        tags_url?: string;
        teams_url?: string;
        trees_url?: string;
        clone_url?: string;
        mirror_url?: string;
        hooks_url?: string;
        svn_url?: string;
        homepage?: string;
        language?: string;
        forks_count?: number;
        stargazers_count?: number;
        watchers_count?: number;
        size?: number;
        default_branch?: string;
        open_issues_count?: number;
        is_template?: boolean;
        topics?: string[];
        has_issues?: boolean;
        has_projects?: boolean;
        has_wiki?: boolean;
        has_pages?: boolean;
        has_downloads?: boolean;
        archived?: boolean;
        disabled?: boolean;
        visibility?: string;
        pushed_at?: string;
        created_at?: string;
        updated_at?: string;
        permissions?: {
          admin?: boolean;
          maintain?: boolean;
          push?: boolean;
          triage?: boolean;
          pull?: boolean;
        };
        allow_rebase_merge?: boolean;
        temp_clone_token?: string;
        allow_squash_merge?: boolean;
        allow_auto_merge?: boolean;
        delete_branch_on_merge?: boolean;
        allow_update_branch?: boolean;
        allow_merge_commit?: boolean;
        subscribers_count?: number;
        network_count?: number;
      } | null;
      temp_clone_token?: string;
      /**
       * @description Whether to allow squash merges for pull requests.
       * @default true
       * @example true
       */
      allow_squash_merge?: boolean;
      /**
       * @description Whether to allow Auto-merge to be used on pull requests.
       * @default false
       * @example false
       */
      allow_auto_merge?: boolean;
      /**
       * @description Whether to delete head branches when pull requests are merged
       * @default false
       * @example false
       */
      delete_branch_on_merge?: boolean;
      /**
       * @description Whether or not a pull request head branch that is behind its base branch can always be updated even if it is not required to be up to date before merging.
       * @default false
       * @example false
       */
      allow_update_branch?: boolean;
      /**
       * @description Whether to allow merge commits for pull requests.
       * @default true
       * @example true
       */
      allow_merge_commit?: boolean;
      /** @description Whether to allow forking this repo */
      allow_forking?: boolean;
      subscribers_count?: number;
      network_count?: number;
      open_issues: number;
      watchers: number;
      master_branch?: string;
      /** @example "2020-07-09T00:17:42Z" */
      starred_at?: string;
      /** @description Whether anonymous git access is enabled for this repository */
      anonymous_access_enabled?: boolean;
    };
    /**
     * Installation Token
     * @description Authentication token for a GitHub App installed on a user or org.
     */
    "installation-token": {
      token: string;
      expires_at: string;
      permissions?: components["schemas"]["app-permissions"];
      /** @enum {string} */
      repository_selection?: "all" | "selected";
      repositories?: components["schemas"]["repository"][];
      /** @example README.md */
      single_file?: string;
      /** @example true */
      has_multiple_single_files?: boolean;
      /**
       * @example [
       *   "config.yml",
       *   ".github/issue_TEMPLATE.md"
       * ]
       */
      single_file_paths?: string[];
    };
    /**
     * Application Grant
     * @description The authorization associated with an OAuth Access.
     */
    "application-grant": {
      /** @example 1 */
      id: number;
      /**
       * Format: uri
       * @example https://api.github.com/applications/grants/1
       */
      url: string;
      app: {
        client_id: string;
        name: string;
        /** Format: uri */
        url: string;
      };
      /**
       * Format: date-time
       * @example 2011-09-06T17:26:27Z
       */
      created_at: string;
      /**
       * Format: date-time
       * @example 2011-09-06T20:39:23Z
       */
      updated_at: string;
      /**
       * @example [
       *   "public_repo"
       * ]
       */
      scopes: string[];
      user?: components["schemas"]["nullable-simple-user"];
    };
    /**
     * Authorization
     * @description The authorization for an OAuth app, GitHub App, or a Personal Access Token.
     */
    "nullable-authorization": {
      id: number;
      /** Format: uri */
      url: string;
      /** @description A list of scopes that this authorization is in. */
      scopes: string[] | null;
      token: string;
      token_last_eight: string | null;
      hashed_token: string | null;
      app: {
        client_id: string;
        name: string;
        /** Format: uri */
        url: string;
      };
      note: string | null;
      /** Format: uri */
      note_url: string | null;
      /** Format: date-time */
      updated_at: string;
      /** Format: date-time */
      created_at: string;
      fingerprint: string | null;
      user?: components["schemas"]["nullable-simple-user"];
      installation?: components["schemas"]["nullable-scoped-installation"];
      /** Format: date-time */
      expires_at: string | null;
    } | null;
    /**
     * Code Of Conduct
     * @description Code Of Conduct
     */
    "code-of-conduct": {
      /** @example contributor_covenant */
      key: string;
      /** @example Contributor Covenant */
      name: string;
      /**
       * Format: uri
       * @example https://api.github.com/codes_of_conduct/contributor_covenant
       */
      url: string;
      /**
       * @example # Contributor Covenant Code of Conduct
       *
       * ## Our Pledge
       *
       * In the interest of fostering an open and welcoming environment, we as contributors and maintainers pledge to making participation in our project and our community a harassment-free experience for everyone, regardless of age, body size, disability, ethnicity, gender identity and expression, level of experience, nationality, personal appearance, race, religion, or sexual identity and orientation.
       *
       * ## Our Standards
       *
       * Examples of behavior that contributes to creating a positive environment include:
       *
       * * Using welcoming and inclusive language
       * * Being respectful of differing viewpoints and experiences
       * * Gracefully accepting constructive criticism
       * * Focusing on what is best for the community
       * * Showing empathy towards other community members
       *
       * Examples of unacceptable behavior by participants include:
       *
       * * The use of sexualized language or imagery and unwelcome sexual attention or advances
       * * Trolling, insulting/derogatory comments, and personal or political attacks
       * * Public or private harassment
       * * Publishing others' private information, such as a physical or electronic address, without explicit permission
       * * Other conduct which could reasonably be considered inappropriate in a professional setting
       *
       * ## Our Responsibilities
       *
       * Project maintainers are responsible for clarifying the standards of acceptable behavior and are expected to take appropriate and fair corrective action in response
       *                   to any instances of unacceptable behavior.
       *
       * Project maintainers have the right and responsibility to remove, edit, or reject comments, commits, code, wiki edits, issues, and other contributions that are not aligned to this Code of Conduct, or to ban temporarily or permanently any contributor for other behaviors that they deem inappropriate, threatening, offensive, or harmful.
       *
       * ## Scope
       *
       * This Code of Conduct applies both within project spaces and in public spaces when an individual is representing the project or its community. Examples of representing a project or community include using an official project e-mail address,
       *                   posting via an official social media account, or acting as an appointed representative at an online or offline event. Representation of a project may be further defined and clarified by project maintainers.
       *
       * ## Enforcement
       *
       * Instances of abusive, harassing, or otherwise unacceptable behavior may be reported by contacting the project team at [EMAIL]. The project team will review and investigate all complaints, and will respond in a way that it deems appropriate to the circumstances. The project team is obligated to maintain confidentiality with regard to the reporter of an incident. Further details of specific enforcement policies may be posted separately.
       *
       * Project maintainers who do not follow or enforce the Code of Conduct in good faith may face temporary or permanent repercussions as determined by other members of the project's leadership.
       *
       * ## Attribution
       *
       * This Code of Conduct is adapted from the [Contributor Covenant][homepage], version 1.4, available at [http://contributor-covenant.org/version/1/4][version]
       *
       * [homepage]: http://contributor-covenant.org
       * [version]: http://contributor-covenant.org/version/1/4/
       */
      body?: string;
      /** Format: uri */
      html_url: string | null;
    };
    /**
     * @description The announcement text in GitHub Flavored Markdown. For more information about GitHub Flavored Markdown, see "[Basic writing and formatting syntax](https://docs.github.com/enterprise-server@3.3/github/writing-on-github/getting-started-with-writing-and-formatting-on-github/basic-writing-and-formatting-syntax)."
     * @example Very **important** announcement about _nothing_.
     */
    "announcement-message": string;
    /**
     * Format: date-time
     * @description The time at which the announcement expires. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`. To set an announcement that never expires, omit this parameter, set it to `null`, or set it to an empty string.
     * @example "2021-01-01T00:00:00.000-07:00"
     */
    "announcement-expiration": string | null;
    /**
     * Enterprise Announcement
     * @description Enterprise global announcement
     */
    announcement: {
      announcement: components["schemas"]["announcement-message"];
      expires_at?: components["schemas"]["announcement-expiration"];
    };
    "license-info": {
      seats?: string | number;
      seats_used?: number;
      seats_available?: string | number;
      kind?: string;
      days_until_expiration?: number;
      expire_at?: string;
    };
    /** Repository Enterprise Stats */
    "enterprise-repository-overview": {
      total_repos: number;
      root_repos: number;
      fork_repos: number;
      org_repos: number;
      total_pushes: number;
      total_wikis: number;
    };
    /** Hooks Enterprise Stats */
    "enterprise-hook-overview": {
      total_hooks: number;
      active_hooks: number;
      inactive_hooks: number;
    };
    /** Enterprise Pages Stats */
    "enterprise-page-overview": {
      total_pages: number;
    };
    /** Enterprise Organization Stats */
    "enterprise-organization-overview": {
      total_orgs: number;
      disabled_orgs: number;
      total_teams: number;
      total_team_members: number;
    };
    /** Enterprise User Stats */
    "enterprise-user-overview": {
      total_users: number;
      admin_users: number;
      suspended_users: number;
    };
    /** Enterprise Pull Request Stats */
    "enterprise-pull-request-overview": {
      total_pulls: number;
      merged_pulls: number;
      mergeable_pulls: number;
      unmergeable_pulls: number;
    };
    /** Enterprise Issue Stats */
    "enterprise-issue-overview": {
      total_issues: number;
      open_issues: number;
      closed_issues: number;
    };
    /** Enterprise Milestone Stats */
    "enterprise-milestone-overview": {
      total_milestones: number;
      open_milestones: number;
      closed_milestones: number;
    };
    /** Enterprise Gist Stats */
    "enterprise-gist-overview": {
      total_gists: number;
      private_gists: number;
      public_gists: number;
    };
    /** Enterprise Comment Stats */
    "enterprise-comment-overview": {
      total_commit_comments: number;
      total_gist_comments: number;
      total_issue_comments: number;
      total_pull_request_comments: number;
    };
    "enterprise-overview": {
      repos?: components["schemas"]["enterprise-repository-overview"];
      hooks?: components["schemas"]["enterprise-hook-overview"];
      pages?: components["schemas"]["enterprise-page-overview"];
      orgs?: components["schemas"]["enterprise-organization-overview"];
      users?: components["schemas"]["enterprise-user-overview"];
      pulls?: components["schemas"]["enterprise-pull-request-overview"];
      issues?: components["schemas"]["enterprise-issue-overview"];
      milestones?: components["schemas"]["enterprise-milestone-overview"];
      gists?: components["schemas"]["enterprise-gist-overview"];
      comments?: components["schemas"]["enterprise-comment-overview"];
    };
    /**
     * @description The policy that controls the organizations in the enterprise that are allowed to run GitHub Actions.
     * @enum {string}
     */
    "enabled-organizations": "all" | "none" | "selected";
    /**
     * @description The permissions policy that controls the actions that are allowed to run.
     * @enum {string}
     */
    "allowed-actions": "all" | "local_only" | "selected";
    /** @description The API URL to use to get or set the actions that are allowed to run, when `allowed_actions` is set to `selected`. */
    "selected-actions-url": string;
    "actions-enterprise-permissions": {
      enabled_organizations: components["schemas"]["enabled-organizations"];
      /** @description The API URL to use to get or set the selected organizations that are allowed to run GitHub Actions, when `enabled_organizations` is set to `selected`. */
      selected_organizations_url?: string;
      allowed_actions?: components["schemas"]["allowed-actions"];
      selected_actions_url?: components["schemas"]["selected-actions-url"];
    };
    "selected-actions": {
      /** @description Whether GitHub-owned actions are allowed. For example, this includes the actions in the `actions` organization. */
      github_owned_allowed: boolean;
      /** @description Specifies a list of string-matching patterns to allow specific action(s). Wildcards, tags, and SHAs are allowed. For example, `monalisa/octocat@*`, `monalisa/octocat@v2`, `monalisa/*`." */
      patterns_allowed: string[];
    };
    "runner-groups-enterprise": {
      id: number;
      name: string;
      visibility: string;
      default: boolean;
      selected_organizations_url?: string;
      runners_url: string;
      allows_public_repositories: boolean;
    };
    /**
     * Self hosted runner label
     * @description A label for a self hosted runner
     */
    "runner-label": {
      /** @description Unique identifier of the label. */
      id?: number;
      /** @description Name of the label. */
      name: string;
      /**
       * @description The type of label. Read-only labels are applied automatically when the runner is configured.
       * @enum {string}
       */
      type?: "read-only" | "custom";
    };
    /**
     * Self hosted runners
     * @description A self hosted runner
     */
    runner: {
      /**
       * @description The id of the runner.
       * @example 5
       */
      id: number;
      /**
       * @description The name of the runner.
       * @example iMac
       */
      name: string;
      /**
       * @description The Operating System of the runner.
       * @example macos
       */
      os: string;
      /**
       * @description The status of the runner.
       * @example online
       */
      status: string;
      busy: boolean;
      labels: components["schemas"]["runner-label"][];
    };
    /**
     * Runner Application
     * @description Runner Application
     */
    "runner-application": {
      os: string;
      architecture: string;
      download_url: string;
      filename: string;
      /** @description A short lived bearer token used to download the runner, if needed. */
      temp_download_token?: string;
      sha256_checksum?: string;
    };
    /**
     * Authentication Token
     * @description Authentication Token
     */
    "authentication-token": {
      /**
       * @description The token used for authentication
       * @example v1.1f699f1069f60xxx
       */
      token: string;
      /**
       * Format: date-time
       * @description The time this token expires
       * @example 2016-07-11T22:14:10Z
       */
      expires_at: string;
      /**
       * @example {
       *   "issues": "read",
       *   "deployments": "write"
       * }
       */
      permissions?: { [key: string]: unknown };
      /** @description The repositories this token has access to */
      repositories?: components["schemas"]["repository"][];
      /** @example config.yaml */
      single_file?: string | null;
      /**
       * @description Describe whether all repositories have been selected or there's a selection involved
       * @enum {string}
       */
      repository_selection?: "all" | "selected";
    };
    "audit-log-event": {
      /** @description The time the audit log event occurred, given as a [Unix timestamp](http://en.wikipedia.org/wiki/Unix_time). */
      "@timestamp"?: number;
      /** @description The name of the action that was performed, for example `user.login` or `repo.create`. */
      action?: string;
      active?: boolean;
      active_was?: boolean;
      /** @description The actor who performed the action. */
      actor?: string;
      /** @description The id of the actor who performed the action. */
      actor_id?: number;
      actor_location?: {
        country_name?: string;
      };
      data?: { [key: string]: unknown };
      org_id?: number;
      /** @description The username of the account being blocked. */
      blocked_user?: string;
      business?: string;
      config?: { [key: string]: unknown }[];
      config_was?: { [key: string]: unknown }[];
      content_type?: string;
      /** @description The time the audit log event was recorded, given as a [Unix timestamp](http://en.wikipedia.org/wiki/Unix_time). */
      created_at?: number;
      deploy_key_fingerprint?: string;
      /** @description A unique identifier for an audit event. */
      _document_id?: string;
      emoji?: string;
      events?: { [key: string]: unknown }[];
      events_were?: { [key: string]: unknown }[];
      explanation?: string;
      fingerprint?: string;
      hook_id?: number;
      limited_availability?: boolean;
      message?: string;
      name?: string;
      old_user?: string;
      openssh_public_key?: string;
      org?: string;
      previous_visibility?: string;
      read_only?: boolean;
      /** @description The name of the repository. */
      repo?: string;
      /** @description The name of the repository. */
      repository?: string;
      repository_public?: boolean;
      target_login?: string;
      team?: string;
      /** @description The type of protocol (for example, HTTP or SSH) used to transfer Git data. */
      transport_protocol?: number;
      /** @description A human readable name for the protocol (for example, HTTP or SSH) used to transfer Git data. */
      transport_protocol_name?: string;
      /** @description The user that was affected by the action performed (if available). */
      user?: string;
      /** @description The repository visibility, for example `public` or `private`. */
      visibility?: string;
    };
    /**
     * Actor
     * @description Actor
     */
    actor: {
      id: number;
      login: string;
      display_login?: string;
      gravatar_id: string | null;
      /** Format: uri */
      url: string;
      /** Format: uri */
      avatar_url: string;
    };
    /**
     * Milestone
     * @description A collection of related issues and pull requests.
     */
    "nullable-milestone": {
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/Hello-World/milestones/1
       */
      url: string;
      /**
       * Format: uri
       * @example https://github.com/octocat/Hello-World/milestones/v1.0
       */
      html_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/Hello-World/milestones/1/labels
       */
      labels_url: string;
      /** @example 1002604 */
      id: number;
      /** @example MDk6TWlsZXN0b25lMTAwMjYwNA== */
      node_id: string;
      /**
       * @description The number of the milestone.
       * @example 42
       */
      number: number;
      /**
       * @description The state of the milestone.
       * @default open
       * @example open
       * @enum {string}
       */
      state: "open" | "closed";
      /**
       * @description The title of the milestone.
       * @example v1.0
       */
      title: string;
      /** @example Tracking milestone for version 1.0 */
      description: string | null;
      creator: components["schemas"]["nullable-simple-user"];
      /** @example 4 */
      open_issues: number;
      /** @example 8 */
      closed_issues: number;
      /**
       * Format: date-time
       * @example 2011-04-10T20:09:31Z
       */
      created_at: string;
      /**
       * Format: date-time
       * @example 2014-03-03T18:58:10Z
       */
      updated_at: string;
      /**
       * Format: date-time
       * @example 2013-02-12T13:22:01Z
       */
      closed_at: string | null;
      /**
       * Format: date-time
       * @example 2012-10-09T23:39:01Z
       */
      due_on: string | null;
    } | null;
    /**
     * GitHub app
     * @description GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
     */
    "nullable-integration": {
      /**
       * @description Unique identifier of the GitHub app
       * @example 37
       */
      id: number;
      /**
       * @description The slug name of the GitHub app
       * @example probot-owners
       */
      slug?: string;
      /** @example MDExOkludGVncmF0aW9uMQ== */
      node_id: string;
      owner: components["schemas"]["nullable-simple-user"];
      /**
       * @description The name of the GitHub app
       * @example Probot Owners
       */
      name: string;
      /** @example The description of the app. */
      description: string | null;
      /**
       * Format: uri
       * @example https://example.com
       */
      external_url: string;
      /**
       * Format: uri
       * @example https://github.com/apps/super-ci
       */
      html_url: string;
      /**
       * Format: date-time
       * @example 2017-07-08T16:18:44-04:00
       */
      created_at: string;
      /**
       * Format: date-time
       * @example 2017-07-08T16:18:44-04:00
       */
      updated_at: string;
      /**
       * @description The set of permissions for the GitHub app
       * @example {
       *   "issues": "read",
       *   "deployments": "write"
       * }
       */
      permissions: {
        issues?: string;
        checks?: string;
        metadata?: string;
        contents?: string;
        deployments?: string;
      } & { [key: string]: string };
      /**
       * @description The list of events for the GitHub app
       * @example [
       *   "label",
       *   "deployment"
       * ]
       */
      events: string[];
      /**
       * @description The number of installations associated with the GitHub app
       * @example 5
       */
      installations_count?: number;
      /** @example "Iv1.25b5d1e65ffc4022" */
      client_id?: string;
      /** @example "1d4b2097ac622ba702d19de498f005747a8b21d3" */
      client_secret?: string;
      /** @example "6fba8f2fc8a7e8f2cca5577eddd82ca7586b3b6b" */
      webhook_secret?: string | null;
      /** @example "-----BEGIN RSA PRIVATE KEY-----\nMIIEogIBAAKCAQEArYxrNYD/iT5CZVpRJu4rBKmmze3PVmT/gCo2ATUvDvZTPTey\nxcGJ3vvrJXazKk06pN05TN29o98jrYz4cengG3YGsXPNEpKsIrEl8NhbnxapEnM9\nJCMRe0P5JcPsfZlX6hmiT7136GRWiGOUba2X9+HKh8QJVLG5rM007TBER9/z9mWm\nrJuNh+m5l320oBQY/Qq3A7wzdEfZw8qm/mIN0FCeoXH1L6B8xXWaAYBwhTEh6SSn\nZHlO1Xu1JWDmAvBCi0RO5aRSKM8q9QEkvvHP4yweAtK3N8+aAbZ7ovaDhyGz8r6r\nzhU1b8Uo0Z2ysf503WqzQgIajr7Fry7/kUwpgQIDAQABAoIBADwJp80Ko1xHPZDy\nfcCKBDfIuPvkmSW6KumbsLMaQv1aGdHDwwTGv3t0ixSay8CGlxMRtRDyZPib6SvQ\n6OH/lpfpbMdW2ErkksgtoIKBVrDilfrcAvrNZu7NxRNbhCSvN8q0s4ICecjbbVQh\nnueSdlA6vGXbW58BHMq68uRbHkP+k+mM9U0mDJ1HMch67wlg5GbayVRt63H7R2+r\nVxcna7B80J/lCEjIYZznawgiTvp3MSanTglqAYi+m1EcSsP14bJIB9vgaxS79kTu\noiSo93leJbBvuGo8QEiUqTwMw4tDksmkLsoqNKQ1q9P7LZ9DGcujtPy4EZsamSJT\ny8OJt0ECgYEA2lxOxJsQk2kI325JgKFjo92mQeUObIvPfSNWUIZQDTjniOI6Gv63\nGLWVFrZcvQBWjMEQraJA9xjPbblV8PtfO87MiJGLWCHFxmPz2dzoedN+2Coxom8m\nV95CLz8QUShuao6u/RYcvUaZEoYs5bHcTmy5sBK80JyEmafJPtCQVxMCgYEAy3ar\nZr3yv4xRPEPMat4rseswmuMooSaK3SKub19WFI5IAtB/e7qR1Rj9JhOGcZz+OQrl\nT78O2OFYlgOIkJPvRMrPpK5V9lslc7tz1FSh3BZMRGq5jSyD7ETSOQ0c8T2O/s7v\nbeEPbVbDe4mwvM24XByH0GnWveVxaDl51ABD65sCgYB3ZAspUkOA5egVCh8kNpnd\nSd6SnuQBE3ySRlT2WEnCwP9Ph6oPgn+oAfiPX4xbRqkL8q/k0BdHQ4h+zNwhk7+h\nWtPYRAP1Xxnc/F+jGjb+DVaIaKGU18MWPg7f+FI6nampl3Q0KvfxwX0GdNhtio8T\nTj1E+SnFwh56SRQuxSh2gwKBgHKjlIO5NtNSflsUYFM+hyQiPiqnHzddfhSG+/3o\nm5nNaSmczJesUYreH5San7/YEy2UxAugvP7aSY2MxB+iGsiJ9WD2kZzTUlDZJ7RV\nUzWsoqBR+eZfVJ2FUWWvy8TpSG6trh4dFxImNtKejCR1TREpSiTV3Zb1dmahK9GV\nrK9NAoGAbBxRLoC01xfxCTgt5BDiBcFVh4fp5yYKwavJPLzHSpuDOrrI9jDn1oKN\nonq5sDU1i391zfQvdrbX4Ova48BN+B7p63FocP/MK5tyyBoT8zQEk2+vWDOw7H/Z\nu5dTCPxTIsoIwUw1I+7yIxqJzLPFgR2gVBwY1ra/8iAqCj+zeBw=\n-----END RSA PRIVATE KEY-----\n" */
      pem?: string;
    } | null;
    /**
     * author_association
     * @description How the author is associated with the repository.
     * @example OWNER
     * @enum {string}
     */
    "author-association":
      | "COLLABORATOR"
      | "CONTRIBUTOR"
      | "FIRST_TIMER"
      | "FIRST_TIME_CONTRIBUTOR"
      | "MANNEQUIN"
      | "MEMBER"
      | "NONE"
      | "OWNER";
    /** Reaction Rollup */
    "reaction-rollup": {
      /** Format: uri */
      url: string;
      total_count: number;
      "+1": number;
      "-1": number;
      laugh: number;
      confused: number;
      heart: number;
      hooray: number;
      eyes: number;
      rocket: number;
    };
    /**
     * Issue
     * @description Issues are a great way to keep track of tasks, enhancements, and bugs for your projects.
     */
    issue: {
      id: number;
      node_id: string;
      /**
       * Format: uri
       * @description URL for the issue
       * @example https://api.github.com/repositories/42/issues/1
       */
      url: string;
      /** Format: uri */
      repository_url: string;
      labels_url: string;
      /** Format: uri */
      comments_url: string;
      /** Format: uri */
      events_url: string;
      /** Format: uri */
      html_url: string;
      /**
       * @description Number uniquely identifying the issue within its repository
       * @example 42
       */
      number: number;
      /**
       * @description State of the issue; either 'open' or 'closed'
       * @example open
       */
      state: string;
      /**
       * @description The reason for the current state
       * @example not_planned
       * @enum {string|null}
       */
      state_reason?: ("completed" | "reopened" | "not_planned") | null;
      /**
       * @description Title of the issue
       * @example Widget creation fails in Safari on OS X 10.8
       */
      title: string;
      /**
       * @description Contents of the issue
       * @example It looks like the new widget form is broken on Safari. When I try and create the widget, Safari crashes. This is reproducible on 10.8, but not 10.9. Maybe a browser bug?
       */
      body?: string | null;
      user: components["schemas"]["nullable-simple-user"];
      /**
       * @description Labels to associate with this issue; pass one or more label names to replace the set of labels on this issue; send an empty array to clear all labels from the issue; note that the labels are silently dropped for users without push access to the repository
       * @example [
       *   "bug",
       *   "registration"
       * ]
       */
      labels: (
        | string
        | {
            /** Format: int64 */
            id?: number;
            node_id?: string;
            /** Format: uri */
            url?: string;
            name?: string;
            description?: string | null;
            color?: string | null;
            default?: boolean;
          }
      )[];
      assignee: components["schemas"]["nullable-simple-user"];
      assignees?: components["schemas"]["simple-user"][] | null;
      milestone: components["schemas"]["nullable-milestone"];
      locked: boolean;
      active_lock_reason?: string | null;
      comments: number;
      pull_request?: {
        /** Format: date-time */
        merged_at?: string | null;
        /** Format: uri */
        diff_url: string | null;
        /** Format: uri */
        html_url: string | null;
        /** Format: uri */
        patch_url: string | null;
        /** Format: uri */
        url: string | null;
      };
      /** Format: date-time */
      closed_at: string | null;
      /** Format: date-time */
      created_at: string;
      /** Format: date-time */
      updated_at: string;
      draft?: boolean;
      closed_by?: components["schemas"]["nullable-simple-user"];
      body_html?: string;
      body_text?: string;
      /** Format: uri */
      timeline_url?: string;
      repository?: components["schemas"]["repository"];
      performed_via_github_app?: components["schemas"]["nullable-integration"];
      author_association: components["schemas"]["author-association"];
      reactions?: components["schemas"]["reaction-rollup"];
    };
    /**
     * Issue Comment
     * @description Comments provide a way for people to collaborate on an issue.
     */
    "issue-comment": {
      /**
       * @description Unique identifier of the issue comment
       * @example 42
       */
      id: number;
      node_id: string;
      /**
       * Format: uri
       * @description URL for the issue comment
       * @example https://api.github.com/repositories/42/issues/comments/1
       */
      url: string;
      /**
       * @description Contents of the issue comment
       * @example What version of Safari were you using when you observed this bug?
       */
      body?: string;
      body_text?: string;
      body_html?: string;
      /** Format: uri */
      html_url: string;
      user: components["schemas"]["nullable-simple-user"];
      /**
       * Format: date-time
       * @example 2011-04-14T16:00:49Z
       */
      created_at: string;
      /**
       * Format: date-time
       * @example 2011-04-14T16:00:49Z
       */
      updated_at: string;
      /** Format: uri */
      issue_url: string;
      author_association: components["schemas"]["author-association"];
      performed_via_github_app?: components["schemas"]["nullable-integration"];
      reactions?: components["schemas"]["reaction-rollup"];
    };
    /**
     * Event
     * @description Event
     */
    event: {
      id: string;
      type: string | null;
      actor: components["schemas"]["actor"];
      repo: {
        id: number;
        name: string;
        /** Format: uri */
        url: string;
      };
      org?: components["schemas"]["actor"];
      payload: {
        action?: string;
        issue?: components["schemas"]["issue"];
        comment?: components["schemas"]["issue-comment"];
        pages?: {
          page_name?: string;
          title?: string;
          summary?: string | null;
          action?: string;
          sha?: string;
          html_url?: string;
        }[];
      };
      public: boolean;
      /** Format: date-time */
      created_at: string | null;
    };
    /**
     * Link With Type
     * @description Hypermedia Link with Type
     */
    "link-with-type": {
      href: string;
      type: string;
    };
    /**
     * Feed
     * @description Feed
     */
    feed: {
      /** @example https://github.com/timeline */
      timeline_url: string;
      /** @example https://github.com/{user} */
      user_url: string;
      /** @example https://github.com/octocat */
      current_user_public_url?: string;
      /** @example https://github.com/octocat.private?token=abc123 */
      current_user_url?: string;
      /** @example https://github.com/octocat.private.actor?token=abc123 */
      current_user_actor_url?: string;
      /** @example https://github.com/octocat-org */
      current_user_organization_url?: string;
      /**
       * @example [
       *   "https://github.com/organizations/github/octocat.private.atom?token=abc123"
       * ]
       */
      current_user_organization_urls?: string[];
      /** @example https://github.com/security-advisories */
      security_advisories_url?: string;
      _links: {
        timeline: components["schemas"]["link-with-type"];
        user: components["schemas"]["link-with-type"];
        security_advisories?: components["schemas"]["link-with-type"];
        current_user?: components["schemas"]["link-with-type"];
        current_user_public?: components["schemas"]["link-with-type"];
        current_user_actor?: components["schemas"]["link-with-type"];
        current_user_organization?: components["schemas"]["link-with-type"];
        current_user_organizations?: components["schemas"]["link-with-type"][];
      };
    };
    /**
     * Base Gist
     * @description Base Gist
     */
    "base-gist": {
      /** Format: uri */
      url: string;
      /** Format: uri */
      forks_url: string;
      /** Format: uri */
      commits_url: string;
      id: string;
      node_id: string;
      /** Format: uri */
      git_pull_url: string;
      /** Format: uri */
      git_push_url: string;
      /** Format: uri */
      html_url: string;
      files: {
        [key: string]: {
          filename?: string;
          type?: string;
          language?: string;
          raw_url?: string;
          size?: number;
        };
      };
      public: boolean;
      /** Format: date-time */
      created_at: string;
      /** Format: date-time */
      updated_at: string;
      description: string | null;
      comments: number;
      user: components["schemas"]["nullable-simple-user"];
      /** Format: uri */
      comments_url: string;
      owner?: components["schemas"]["simple-user"];
      truncated?: boolean;
      forks?: unknown[];
      history?: unknown[];
    };
    /**
     * Public User
     * @description Public User
     */
    "public-user": {
      login: string;
      id: number;
      node_id: string;
      /** Format: uri */
      avatar_url: string;
      gravatar_id: string | null;
      /** Format: uri */
      url: string;
      /** Format: uri */
      html_url: string;
      /** Format: uri */
      followers_url: string;
      following_url: string;
      gists_url: string;
      starred_url: string;
      /** Format: uri */
      subscriptions_url: string;
      /** Format: uri */
      organizations_url: string;
      /** Format: uri */
      repos_url: string;
      events_url: string;
      /** Format: uri */
      received_events_url: string;
      type: string;
      site_admin: boolean;
      name: string | null;
      company: string | null;
      blog: string | null;
      location: string | null;
      /** Format: email */
      email: string | null;
      hireable: boolean | null;
      bio: string | null;
      twitter_username?: string | null;
      public_repos: number;
      public_gists: number;
      followers: number;
      following: number;
      /** Format: date-time */
      created_at: string;
      /** Format: date-time */
      updated_at: string;
      plan?: {
        collaborators: number;
        name: string;
        space: number;
        private_repos: number;
      };
      /** Format: date-time */
      suspended_at?: string | null;
      /** @example 1 */
      private_gists?: number;
      /** @example 2 */
      total_private_repos?: number;
      /** @example 2 */
      owned_private_repos?: number;
      /** @example 1 */
      disk_usage?: number;
      /** @example 3 */
      collaborators?: number;
    };
    /**
     * Gist History
     * @description Gist History
     */
    "gist-history": {
      user?: components["schemas"]["nullable-simple-user"];
      version?: string;
      /** Format: date-time */
      committed_at?: string;
      change_status?: {
        total?: number;
        additions?: number;
        deletions?: number;
      };
      /** Format: uri */
      url?: string;
    };
    /**
     * Gist Simple
     * @description Gist Simple
     */
    "gist-simple": {
      /** @deprecated */
      forks?:
        | {
            id?: string;
            /** Format: uri */
            url?: string;
            user?: components["schemas"]["public-user"];
            /** Format: date-time */
            created_at?: string;
            /** Format: date-time */
            updated_at?: string;
          }[]
        | null;
      /** @deprecated */
      history?: components["schemas"]["gist-history"][] | null;
      /**
       * Gist
       * @description Gist
       */
      fork_of?: {
        /** Format: uri */
        url: string;
        /** Format: uri */
        forks_url: string;
        /** Format: uri */
        commits_url: string;
        id: string;
        node_id: string;
        /** Format: uri */
        git_pull_url: string;
        /** Format: uri */
        git_push_url: string;
        /** Format: uri */
        html_url: string;
        files: {
          [key: string]: {
            filename?: string;
            type?: string;
            language?: string;
            raw_url?: string;
            size?: number;
          };
        };
        public: boolean;
        /** Format: date-time */
        created_at: string;
        /** Format: date-time */
        updated_at: string;
        description: string | null;
        comments: number;
        user: components["schemas"]["nullable-simple-user"];
        /** Format: uri */
        comments_url: string;
        owner?: components["schemas"]["nullable-simple-user"];
        truncated?: boolean;
        forks?: unknown[];
        history?: unknown[];
      } | null;
      url?: string;
      forks_url?: string;
      commits_url?: string;
      id?: string;
      node_id?: string;
      git_pull_url?: string;
      git_push_url?: string;
      html_url?: string;
      files?: {
        [key: string]: {
          filename?: string;
          type?: string;
          language?: string;
          raw_url?: string;
          size?: number;
          truncated?: boolean;
          content?: string;
        } | null;
      };
      public?: boolean;
      created_at?: string;
      updated_at?: string;
      description?: string | null;
      comments?: number;
      user?: string | null;
      comments_url?: string;
      owner?: components["schemas"]["simple-user"];
      truncated?: boolean;
    };
    /**
     * Gist Comment
     * @description A comment made to a gist.
     */
    "gist-comment": {
      /** @example 1 */
      id: number;
      /** @example MDExOkdpc3RDb21tZW50MQ== */
      node_id: string;
      /**
       * Format: uri
       * @example https://api.github.com/gists/a6db0bec360bb87e9418/comments/1
       */
      url: string;
      /**
       * @description The comment text.
       * @example Body of the attachment
       */
      body: string;
      user: components["schemas"]["nullable-simple-user"];
      /**
       * Format: date-time
       * @example 2011-04-18T23:23:56Z
       */
      created_at: string;
      /**
       * Format: date-time
       * @example 2011-04-18T23:23:56Z
       */
      updated_at: string;
      author_association: components["schemas"]["author-association"];
    };
    /**
     * Gist Commit
     * @description Gist Commit
     */
    "gist-commit": {
      /**
       * Format: uri
       * @example https://api.github.com/gists/aa5a315d61ae9438b18d/57a7f021a713b1c5a6a199b54cc514735d2d462f
       */
      url: string;
      /** @example 57a7f021a713b1c5a6a199b54cc514735d2d462f */
      version: string;
      user: components["schemas"]["nullable-simple-user"];
      change_status: {
        total?: number;
        additions?: number;
        deletions?: number;
      };
      /**
       * Format: date-time
       * @example 2010-04-14T02:15:15Z
       */
      committed_at: string;
    };
    /**
     * Gitignore Template
     * @description Gitignore Template
     */
    "gitignore-template": {
      /** @example C */
      name: string;
      /**
       * @example # Object files
       * *.o
       *
       * # Libraries
       * *.lib
       * *.a
       *
       * # Shared objects (inc. Windows DLLs)
       * *.dll
       * *.so
       * *.so.*
       * *.dylib
       *
       * # Executables
       * *.exe
       * *.out
       * *.app
       */
      source: string;
    };
    /**
     * License Simple
     * @description License Simple
     */
    "license-simple": {
      /** @example mit */
      key: string;
      /** @example MIT License */
      name: string;
      /**
       * Format: uri
       * @example https://api.github.com/licenses/mit
       */
      url: string | null;
      /** @example MIT */
      spdx_id: string | null;
      /** @example MDc6TGljZW5zZW1pdA== */
      node_id: string;
      /** Format: uri */
      html_url?: string;
    };
    /**
     * License
     * @description License
     */
    license: {
      /** @example mit */
      key: string;
      /** @example MIT License */
      name: string;
      /** @example MIT */
      spdx_id: string | null;
      /**
       * Format: uri
       * @example https://api.github.com/licenses/mit
       */
      url: string | null;
      /** @example MDc6TGljZW5zZW1pdA== */
      node_id: string;
      /**
       * Format: uri
       * @example http://choosealicense.com/licenses/mit/
       */
      html_url: string;
      /** @example A permissive license that is short and to the point. It lets people do anything with your code with proper attribution and without warranty. */
      description: string;
      /** @example Create a text file (typically named LICENSE or LICENSE.txt) in the root of your source code and copy the text of the license into the file. Replace [year] with the current year and [fullname] with the name (or names) of the copyright holders. */
      implementation: string;
      /**
       * @example [
       *   "commercial-use",
       *   "modifications",
       *   "distribution",
       *   "sublicense",
       *   "private-use"
       * ]
       */
      permissions: string[];
      /**
       * @example [
       *   "include-copyright"
       * ]
       */
      conditions: string[];
      /**
       * @example [
       *   "no-liability"
       * ]
       */
      limitations: string[];
      /**
       * @example
       *
       * The MIT License (MIT)
       *
       * Copyright (c) [year] [fullname]
       *
       * Permission is hereby granted, free of charge, to any person obtaining a copy
       * of this software and associated documentation files (the "Software"), to deal
       * in the Software without restriction, including without limitation the rights
       * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
       * copies of the Software, and to permit persons to whom the Software is
       * furnished to do so, subject to the following conditions:
       *
       * The above copyright notice and this permission notice shall be included in all
       * copies or substantial portions of the Software.
       *
       * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
       * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
       * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
       * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
       * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
       * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
       * SOFTWARE.
       */
      body: string;
      /** @example true */
      featured: boolean;
    };
    /**
     * Api Overview
     * @description Api Overview
     */
    "api-overview": {
      /** @example true */
      verifiable_password_authentication: boolean;
      /**
       * @example [
       *   "13.65.0.0/16",
       *   "157.55.204.33/32",
       *   "2a01:111:f403:f90c::/62"
       * ]
       */
      packages?: string[];
      /**
       * @example [
       *   "192.168.7.15/32",
       *   "192.168.7.16/32"
       * ]
       */
      dependabot?: string[];
      /** @example 3.3.0 */
      installed_version?: string;
    };
    /**
     * Repository
     * @description A git repository
     */
    "nullable-repository": {
      /**
       * @description Unique identifier of the repository
       * @example 42
       */
      id: number;
      /** @example MDEwOlJlcG9zaXRvcnkxMjk2MjY5 */
      node_id: string;
      /**
       * @description The name of the repository.
       * @example Team Environment
       */
      name: string;
      /** @example octocat/Hello-World */
      full_name: string;
      license: components["schemas"]["nullable-license-simple"];
      organization?: components["schemas"]["nullable-simple-user"];
      forks: number;
      permissions?: {
        admin: boolean;
        pull: boolean;
        triage?: boolean;
        push: boolean;
        maintain?: boolean;
      };
      owner: components["schemas"]["simple-user"];
      /**
       * @description Whether the repository is private or public.
       * @default false
       */
      private: boolean;
      /**
       * Format: uri
       * @example https://github.com/octocat/Hello-World
       */
      html_url: string;
      /** @example This your first repo! */
      description: string | null;
      fork: boolean;
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/Hello-World
       */
      url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/{archive_format}{/ref} */
      archive_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/assignees{/user} */
      assignees_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/git/blobs{/sha} */
      blobs_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/branches{/branch} */
      branches_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/collaborators{/collaborator} */
      collaborators_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/comments{/number} */
      comments_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/commits{/sha} */
      commits_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/compare/{base}...{head} */
      compare_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/contents/{+path} */
      contents_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/contributors
       */
      contributors_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/deployments
       */
      deployments_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/downloads
       */
      downloads_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/events
       */
      events_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/forks
       */
      forks_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/git/commits{/sha} */
      git_commits_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/git/refs{/sha} */
      git_refs_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/git/tags{/sha} */
      git_tags_url: string;
      /** @example git:github.com/octocat/Hello-World.git */
      git_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/issues/comments{/number} */
      issue_comment_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/issues/events{/number} */
      issue_events_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/issues{/number} */
      issues_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/keys{/key_id} */
      keys_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/labels{/name} */
      labels_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/languages
       */
      languages_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/merges
       */
      merges_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/milestones{/number} */
      milestones_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/notifications{?since,all,participating} */
      notifications_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/pulls{/number} */
      pulls_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/releases{/id} */
      releases_url: string;
      /** @example git@github.com:octocat/Hello-World.git */
      ssh_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/stargazers
       */
      stargazers_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/statuses/{sha} */
      statuses_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/subscribers
       */
      subscribers_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/subscription
       */
      subscription_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/tags
       */
      tags_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/teams
       */
      teams_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/git/trees{/sha} */
      trees_url: string;
      /** @example https://github.com/octocat/Hello-World.git */
      clone_url: string;
      /**
       * Format: uri
       * @example git:git.example.com/octocat/Hello-World
       */
      mirror_url: string | null;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/hooks
       */
      hooks_url: string;
      /**
       * Format: uri
       * @example https://svn.github.com/octocat/Hello-World
       */
      svn_url: string;
      /**
       * Format: uri
       * @example https://github.com
       */
      homepage: string | null;
      language: string | null;
      /** @example 9 */
      forks_count: number;
      /** @example 80 */
      stargazers_count: number;
      /** @example 80 */
      watchers_count: number;
      /**
       * @description The size of the repository. Size is calculated hourly. When a repository is initially created, the size is 0.
       * @example 108
       */
      size: number;
      /**
       * @description The default branch of the repository.
       * @example master
       */
      default_branch: string;
      /** @example 0 */
      open_issues_count: number;
      /**
       * @description Whether this repository acts as a template that can be used to generate new repositories.
       * @default false
       * @example true
       */
      is_template?: boolean;
      topics?: string[];
      /**
       * @description Whether issues are enabled.
       * @default true
       * @example true
       */
      has_issues: boolean;
      /**
       * @description Whether projects are enabled.
       * @default true
       * @example true
       */
      has_projects: boolean;
      /**
       * @description Whether the wiki is enabled.
       * @default true
       * @example true
       */
      has_wiki: boolean;
      has_pages: boolean;
      /**
       * @description Whether downloads are enabled.
       * @default true
       * @example true
       */
      has_downloads: boolean;
      /**
       * @description Whether the repository is archived.
       * @default false
       */
      archived: boolean;
      /** @description Returns whether or not this repository disabled. */
      disabled: boolean;
      /**
       * @description The repository visibility: public, private, or internal.
       * @default public
       */
      visibility?: string;
      /**
       * Format: date-time
       * @example 2011-01-26T19:06:43Z
       */
      pushed_at: string | null;
      /**
       * Format: date-time
       * @example 2011-01-26T19:01:12Z
       */
      created_at: string | null;
      /**
       * Format: date-time
       * @example 2011-01-26T19:14:43Z
       */
      updated_at: string | null;
      /**
       * @description Whether to allow rebase merges for pull requests.
       * @default true
       * @example true
       */
      allow_rebase_merge?: boolean;
      template_repository?: {
        id?: number;
        node_id?: string;
        name?: string;
        full_name?: string;
        owner?: {
          login?: string;
          id?: number;
          node_id?: string;
          avatar_url?: string;
          gravatar_id?: string;
          url?: string;
          html_url?: string;
          followers_url?: string;
          following_url?: string;
          gists_url?: string;
          starred_url?: string;
          subscriptions_url?: string;
          organizations_url?: string;
          repos_url?: string;
          events_url?: string;
          received_events_url?: string;
          type?: string;
          site_admin?: boolean;
        };
        private?: boolean;
        html_url?: string;
        description?: string;
        fork?: boolean;
        url?: string;
        archive_url?: string;
        assignees_url?: string;
        blobs_url?: string;
        branches_url?: string;
        collaborators_url?: string;
        comments_url?: string;
        commits_url?: string;
        compare_url?: string;
        contents_url?: string;
        contributors_url?: string;
        deployments_url?: string;
        downloads_url?: string;
        events_url?: string;
        forks_url?: string;
        git_commits_url?: string;
        git_refs_url?: string;
        git_tags_url?: string;
        git_url?: string;
        issue_comment_url?: string;
        issue_events_url?: string;
        issues_url?: string;
        keys_url?: string;
        labels_url?: string;
        languages_url?: string;
        merges_url?: string;
        milestones_url?: string;
        notifications_url?: string;
        pulls_url?: string;
        releases_url?: string;
        ssh_url?: string;
        stargazers_url?: string;
        statuses_url?: string;
        subscribers_url?: string;
        subscription_url?: string;
        tags_url?: string;
        teams_url?: string;
        trees_url?: string;
        clone_url?: string;
        mirror_url?: string;
        hooks_url?: string;
        svn_url?: string;
        homepage?: string;
        language?: string;
        forks_count?: number;
        stargazers_count?: number;
        watchers_count?: number;
        size?: number;
        default_branch?: string;
        open_issues_count?: number;
        is_template?: boolean;
        topics?: string[];
        has_issues?: boolean;
        has_projects?: boolean;
        has_wiki?: boolean;
        has_pages?: boolean;
        has_downloads?: boolean;
        archived?: boolean;
        disabled?: boolean;
        visibility?: string;
        pushed_at?: string;
        created_at?: string;
        updated_at?: string;
        permissions?: {
          admin?: boolean;
          maintain?: boolean;
          push?: boolean;
          triage?: boolean;
          pull?: boolean;
        };
        allow_rebase_merge?: boolean;
        temp_clone_token?: string;
        allow_squash_merge?: boolean;
        allow_auto_merge?: boolean;
        delete_branch_on_merge?: boolean;
        allow_update_branch?: boolean;
        allow_merge_commit?: boolean;
        subscribers_count?: number;
        network_count?: number;
      } | null;
      temp_clone_token?: string;
      /**
       * @description Whether to allow squash merges for pull requests.
       * @default true
       * @example true
       */
      allow_squash_merge?: boolean;
      /**
       * @description Whether to allow Auto-merge to be used on pull requests.
       * @default false
       * @example false
       */
      allow_auto_merge?: boolean;
      /**
       * @description Whether to delete head branches when pull requests are merged
       * @default false
       * @example false
       */
      delete_branch_on_merge?: boolean;
      /**
       * @description Whether or not a pull request head branch that is behind its base branch can always be updated even if it is not required to be up to date before merging.
       * @default false
       * @example false
       */
      allow_update_branch?: boolean;
      /**
       * @description Whether to allow merge commits for pull requests.
       * @default true
       * @example true
       */
      allow_merge_commit?: boolean;
      /** @description Whether to allow forking this repo */
      allow_forking?: boolean;
      subscribers_count?: number;
      network_count?: number;
      open_issues: number;
      watchers: number;
      master_branch?: string;
      /** @example "2020-07-09T00:17:42Z" */
      starred_at?: string;
      /** @description Whether anonymous git access is enabled for this repository */
      anonymous_access_enabled?: boolean;
    } | null;
    /**
     * Minimal Repository
     * @description Minimal Repository
     */
    "minimal-repository": {
      /** @example 1296269 */
      id: number;
      /** @example MDEwOlJlcG9zaXRvcnkxMjk2MjY5 */
      node_id: string;
      /** @example Hello-World */
      name: string;
      /** @example octocat/Hello-World */
      full_name: string;
      owner: components["schemas"]["simple-user"];
      private: boolean;
      /**
       * Format: uri
       * @example https://github.com/octocat/Hello-World
       */
      html_url: string;
      /** @example This your first repo! */
      description: string | null;
      fork: boolean;
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/Hello-World
       */
      url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/{archive_format}{/ref} */
      archive_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/assignees{/user} */
      assignees_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/git/blobs{/sha} */
      blobs_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/branches{/branch} */
      branches_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/collaborators{/collaborator} */
      collaborators_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/comments{/number} */
      comments_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/commits{/sha} */
      commits_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/compare/{base}...{head} */
      compare_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/contents/{+path} */
      contents_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/contributors
       */
      contributors_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/deployments
       */
      deployments_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/downloads
       */
      downloads_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/events
       */
      events_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/forks
       */
      forks_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/git/commits{/sha} */
      git_commits_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/git/refs{/sha} */
      git_refs_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/git/tags{/sha} */
      git_tags_url: string;
      git_url?: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/issues/comments{/number} */
      issue_comment_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/issues/events{/number} */
      issue_events_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/issues{/number} */
      issues_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/keys{/key_id} */
      keys_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/labels{/name} */
      labels_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/languages
       */
      languages_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/merges
       */
      merges_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/milestones{/number} */
      milestones_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/notifications{?since,all,participating} */
      notifications_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/pulls{/number} */
      pulls_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/releases{/id} */
      releases_url: string;
      ssh_url?: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/stargazers
       */
      stargazers_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/statuses/{sha} */
      statuses_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/subscribers
       */
      subscribers_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/subscription
       */
      subscription_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/tags
       */
      tags_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/teams
       */
      teams_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/git/trees{/sha} */
      trees_url: string;
      clone_url?: string;
      mirror_url?: string | null;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/hooks
       */
      hooks_url: string;
      svn_url?: string;
      homepage?: string | null;
      language?: string | null;
      forks_count?: number;
      stargazers_count?: number;
      watchers_count?: number;
      /** @description The size of the repository. Size is calculated hourly. When a repository is initially created, the size is 0. */
      size?: number;
      default_branch?: string;
      open_issues_count?: number;
      is_template?: boolean;
      topics?: string[];
      has_issues?: boolean;
      has_projects?: boolean;
      has_wiki?: boolean;
      has_pages?: boolean;
      has_downloads?: boolean;
      archived?: boolean;
      disabled?: boolean;
      visibility?: string;
      /**
       * Format: date-time
       * @example 2011-01-26T19:06:43Z
       */
      pushed_at?: string | null;
      /**
       * Format: date-time
       * @example 2011-01-26T19:01:12Z
       */
      created_at?: string | null;
      /**
       * Format: date-time
       * @example 2011-01-26T19:14:43Z
       */
      updated_at?: string | null;
      permissions?: {
        admin?: boolean;
        maintain?: boolean;
        push?: boolean;
        triage?: boolean;
        pull?: boolean;
      };
      template_repository?: components["schemas"]["nullable-repository"];
      temp_clone_token?: string;
      delete_branch_on_merge?: boolean;
      subscribers_count?: number;
      network_count?: number;
      code_of_conduct?: components["schemas"]["code-of-conduct"];
      license?: {
        key?: string;
        name?: string;
        spdx_id?: string;
        url?: string;
        node_id?: string;
      } | null;
      /** @example 0 */
      forks?: number;
      /** @example 0 */
      open_issues?: number;
      /** @example 0 */
      watchers?: number;
      allow_forking?: boolean;
    };
    /**
     * Thread
     * @description Thread
     */
    thread: {
      id: string;
      repository: components["schemas"]["minimal-repository"];
      subject: {
        title: string;
        url: string;
        latest_comment_url: string;
        type: string;
      };
      reason: string;
      unread: boolean;
      updated_at: string;
      last_read_at: string | null;
      url: string;
      /** @example https://api.github.com/notifications/threads/2/subscription */
      subscription_url: string;
    };
    /**
     * Thread Subscription
     * @description Thread Subscription
     */
    "thread-subscription": {
      /** @example true */
      subscribed: boolean;
      ignored: boolean;
      reason: string | null;
      /**
       * Format: date-time
       * @example 2012-10-06T21:34:12Z
       */
      created_at: string | null;
      /**
       * Format: uri
       * @example https://api.github.com/notifications/threads/1/subscription
       */
      url: string;
      /**
       * Format: uri
       * @example https://api.github.com/notifications/threads/1
       */
      thread_url?: string;
      /**
       * Format: uri
       * @example https://api.github.com/repos/1
       */
      repository_url?: string;
    };
    /**
     * Organization Full
     * @description Organization Full
     */
    "organization-full": {
      /** @example github */
      login: string;
      /** @example 1 */
      id: number;
      /** @example MDEyOk9yZ2FuaXphdGlvbjE= */
      node_id: string;
      /**
       * Format: uri
       * @example https://api.github.com/orgs/github
       */
      url: string;
      /**
       * Format: uri
       * @example https://api.github.com/orgs/github/repos
       */
      repos_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/orgs/github/events
       */
      events_url: string;
      /** @example https://api.github.com/orgs/github/hooks */
      hooks_url: string;
      /** @example https://api.github.com/orgs/github/issues */
      issues_url: string;
      /** @example https://api.github.com/orgs/github/members{/member} */
      members_url: string;
      /** @example https://api.github.com/orgs/github/public_members{/member} */
      public_members_url: string;
      /** @example https://github.com/images/error/octocat_happy.gif */
      avatar_url: string;
      /** @example A great organization */
      description: string | null;
      /** @example github */
      name?: string;
      /** @example GitHub */
      company?: string;
      /**
       * Format: uri
       * @example https://github.com/blog
       */
      blog?: string;
      /** @example San Francisco */
      location?: string;
      /**
       * Format: email
       * @example octocat@github.com
       */
      email?: string;
      /** @example github */
      twitter_username?: string | null;
      /** @example true */
      is_verified?: boolean;
      /** @example true */
      has_organization_projects: boolean;
      /** @example true */
      has_repository_projects: boolean;
      /** @example 2 */
      public_repos: number;
      /** @example 1 */
      public_gists: number;
      /** @example 20 */
      followers: number;
      /** @example 0 */
      following: number;
      /**
       * Format: uri
       * @example https://github.com/octocat
       */
      html_url: string;
      /**
       * Format: date-time
       * @example 2008-01-14T04:33:35Z
       */
      created_at: string;
      /** @example Organization */
      type: string;
      /** @example 100 */
      total_private_repos?: number;
      /** @example 100 */
      owned_private_repos?: number;
      /** @example 81 */
      private_gists?: number | null;
      /** @example 10000 */
      disk_usage?: number | null;
      /** @example 8 */
      collaborators?: number | null;
      /**
       * Format: email
       * @example org@example.com
       */
      billing_email?: string | null;
      plan?: {
        name: string;
        space: number;
        private_repos: number;
        filled_seats?: number;
        seats?: number;
      };
      default_repository_permission?: string | null;
      /** @example true */
      members_can_create_repositories?: boolean | null;
      /** @example true */
      two_factor_requirement_enabled?: boolean | null;
      /** @example all */
      members_allowed_repository_creation_type?: string;
      /** @example true */
      members_can_create_public_repositories?: boolean;
      /** @example true */
      members_can_create_private_repositories?: boolean;
      /** @example true */
      members_can_create_internal_repositories?: boolean;
      /** @example true */
      members_can_create_pages?: boolean;
      /** @example true */
      members_can_create_public_pages?: boolean;
      /** @example true */
      members_can_create_private_pages?: boolean;
      /** Format: date-time */
      updated_at: string;
    };
    /**
     * @description The policy that controls the repositories in the organization that are allowed to run GitHub Actions.
     * @enum {string}
     */
    "enabled-repositories": "all" | "none" | "selected";
    "actions-organization-permissions": {
      enabled_repositories: components["schemas"]["enabled-repositories"];
      /** @description The API URL to use to get or set the selected repositories that are allowed to run GitHub Actions, when `enabled_repositories` is set to `selected`. */
      selected_repositories_url?: string;
      allowed_actions?: components["schemas"]["allowed-actions"];
      selected_actions_url?: components["schemas"]["selected-actions-url"];
    };
    "runner-groups-org": {
      id: number;
      name: string;
      visibility: string;
      default: boolean;
      /** @description Link to the selected repositories resource for this runner group. Not present unless visibility was set to `selected` */
      selected_repositories_url?: string;
      runners_url: string;
      inherited: boolean;
      inherited_allows_public_repositories?: boolean;
      allows_public_repositories: boolean;
    };
    /**
     * Actions Secret for an Organization
     * @description Secrets for GitHub Actions for an organization.
     */
    "organization-actions-secret": {
      /**
       * @description The name of the secret.
       * @example SECRET_TOKEN
       */
      name: string;
      /** Format: date-time */
      created_at: string;
      /** Format: date-time */
      updated_at: string;
      /**
       * @description Visibility of a secret
       * @enum {string}
       */
      visibility: "all" | "private" | "selected";
      /**
       * Format: uri
       * @example https://api.github.com/organizations/org/secrets/my_secret/repositories
       */
      selected_repositories_url?: string;
    };
    /**
     * ActionsPublicKey
     * @description The public key used for setting Actions Secrets.
     */
    "actions-public-key": {
      /**
       * @description The identifier for the key.
       * @example 1234567
       */
      key_id: string;
      /**
       * @description The Base64 encoded public key.
       * @example hBT5WZEj8ZoOv6TYJsfWq7MxTEQopZO5/IT3ZCVQPzs=
       */
      key: string;
      /** @example 2 */
      id?: number;
      /** @example https://api.github.com/user/keys/2 */
      url?: string;
      /** @example ssh-rsa AAAAB3NzaC1yc2EAAA */
      title?: string;
      /** @example 2011-01-26T19:01:12Z */
      created_at?: string;
    };
    /**
     * Empty Object
     * @description An object without any properties.
     */
    "empty-object": { [key: string]: unknown };
    /**
     * Org Hook
     * @description Org Hook
     */
    "org-hook": {
      /** @example 1 */
      id: number;
      /**
       * Format: uri
       * @example https://api.github.com/orgs/octocat/hooks/1
       */
      url: string;
      /**
       * Format: uri
       * @example https://api.github.com/orgs/octocat/hooks/1/pings
       */
      ping_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/orgs/octocat/hooks/1/deliveries
       */
      deliveries_url?: string;
      /** @example web */
      name: string;
      /**
       * @example [
       *   "push",
       *   "pull_request"
       * ]
       */
      events: string[];
      /** @example true */
      active: boolean;
      config: {
        /** @example "http://example.com/2" */
        url?: string;
        /** @example "0" */
        insecure_ssl?: string;
        /** @example "form" */
        content_type?: string;
        /** @example "********" */
        secret?: string;
      };
      /**
       * Format: date-time
       * @example 2011-09-06T20:39:23Z
       */
      updated_at: string;
      /**
       * Format: date-time
       * @example 2011-09-06T17:26:27Z
       */
      created_at: string;
      type: string;
    };
    /**
     * Org Membership
     * @description Org Membership
     */
    "org-membership": {
      /**
       * Format: uri
       * @example https://api.github.com/orgs/octocat/memberships/defunkt
       */
      url: string;
      /**
       * @description The state of the member in the organization. The `pending` state indicates the user has not yet accepted an invitation.
       * @example active
       * @enum {string}
       */
      state: "active" | "pending";
      /**
       * @description The user's membership type in the organization.
       * @example admin
       * @enum {string}
       */
      role: "admin" | "member" | "billing_manager";
      /**
       * Format: uri
       * @example https://api.github.com/orgs/octocat
       */
      organization_url: string;
      organization: components["schemas"]["organization-simple"];
      user: components["schemas"]["nullable-simple-user"];
      permissions?: {
        can_create_repository: boolean;
      };
    };
    "org-pre-receive-hook": {
      id?: number;
      name?: string;
      enforcement?: string;
      configuration_url?: string;
      allow_downstream_configuration?: boolean;
    };
    /**
     * Project
     * @description Projects are a way to organize columns and cards of work.
     */
    project: {
      /**
       * Format: uri
       * @example https://api.github.com/repos/api-playground/projects-test
       */
      owner_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/projects/1002604
       */
      url: string;
      /**
       * Format: uri
       * @example https://github.com/api-playground/projects-test/projects/12
       */
      html_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/projects/1002604/columns
       */
      columns_url: string;
      /** @example 1002604 */
      id: number;
      /** @example MDc6UHJvamVjdDEwMDI2MDQ= */
      node_id: string;
      /**
       * @description Name of the project
       * @example Week One Sprint
       */
      name: string;
      /**
       * @description Body of the project
       * @example This project represents the sprint of the first week in January
       */
      body: string | null;
      /** @example 1 */
      number: number;
      /**
       * @description State of the project; either 'open' or 'closed'
       * @example open
       */
      state: string;
      creator: components["schemas"]["nullable-simple-user"];
      /**
       * Format: date-time
       * @example 2011-04-10T20:09:31Z
       */
      created_at: string;
      /**
       * Format: date-time
       * @example 2014-03-03T18:58:10Z
       */
      updated_at: string;
      /**
       * @description The baseline permission that all organization members have on this project. Only present if owner is an organization.
       * @enum {string}
       */
      organization_permission?: "read" | "write" | "admin" | "none";
      /** @description Whether or not this project can be seen by everyone. Only present if owner is an organization. */
      private?: boolean;
    };
    /** @description The security alert number. */
    "alert-number": number;
    /**
     * Format: date-time
     * @description The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    "alert-created-at": string;
    /**
     * Format: date-time
     * @description The time that the alert was last updated in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    "nullable-alert-updated-at": string | null;
    /**
     * Format: uri
     * @description The REST API URL of the alert resource.
     */
    "alert-url": string;
    /**
     * Format: uri
     * @description The GitHub URL of the alert resource.
     */
    "alert-html-url": string;
    /**
     * @description Sets the state of the secret scanning alert. You must provide `resolution` when you set the state to `resolved`.
     * @enum {string}
     */
    "secret-scanning-alert-state": "open" | "resolved";
    /**
     * @description **Required when the `state` is `resolved`.** The reason for resolving the alert.
     * @enum {string|null}
     */
    "secret-scanning-alert-resolution":
      | (null | "false_positive" | "wont_fix" | "revoked" | "used_in_tests")
      | null;
    /**
     * Simple Repository
     * @description Simple Repository
     */
    "simple-repository": {
      /**
       * @description A unique identifier of the repository.
       * @example 1296269
       */
      id: number;
      /**
       * @description The GraphQL identifier of the repository.
       * @example MDEwOlJlcG9zaXRvcnkxMjk2MjY5
       */
      node_id: string;
      /**
       * @description The name of the repository.
       * @example Hello-World
       */
      name: string;
      /**
       * @description The full, globally unique, name of the repository.
       * @example octocat/Hello-World
       */
      full_name: string;
      owner: components["schemas"]["simple-user"];
      /** @description Whether the repository is private. */
      private: boolean;
      /**
       * Format: uri
       * @description The URL to view the repository on GitHub.com.
       * @example https://github.com/octocat/Hello-World
       */
      html_url: string;
      /**
       * @description The repository description.
       * @example This your first repo!
       */
      description: string | null;
      /** @description Whether the repository is a fork. */
      fork: boolean;
      /**
       * Format: uri
       * @description The URL to get more information about the repository from the GitHub API.
       * @example https://api.github.com/repos/octocat/Hello-World
       */
      url: string;
      /**
       * @description A template for the API URL to download the repository as an archive.
       * @example https://api.github.com/repos/octocat/Hello-World/{archive_format}{/ref}
       */
      archive_url: string;
      /**
       * @description A template for the API URL to list the available assignees for issues in the repository.
       * @example https://api.github.com/repos/octocat/Hello-World/assignees{/user}
       */
      assignees_url: string;
      /**
       * @description A template for the API URL to create or retrieve a raw Git blob in the repository.
       * @example https://api.github.com/repos/octocat/Hello-World/git/blobs{/sha}
       */
      blobs_url: string;
      /**
       * @description A template for the API URL to get information about branches in the repository.
       * @example https://api.github.com/repos/octocat/Hello-World/branches{/branch}
       */
      branches_url: string;
      /**
       * @description A template for the API URL to get information about collaborators of the repository.
       * @example https://api.github.com/repos/octocat/Hello-World/collaborators{/collaborator}
       */
      collaborators_url: string;
      /**
       * @description A template for the API URL to get information about comments on the repository.
       * @example https://api.github.com/repos/octocat/Hello-World/comments{/number}
       */
      comments_url: string;
      /**
       * @description A template for the API URL to get information about commits on the repository.
       * @example https://api.github.com/repos/octocat/Hello-World/commits{/sha}
       */
      commits_url: string;
      /**
       * @description A template for the API URL to compare two commits or refs.
       * @example https://api.github.com/repos/octocat/Hello-World/compare/{base}...{head}
       */
      compare_url: string;
      /**
       * @description A template for the API URL to get the contents of the repository.
       * @example https://api.github.com/repos/octocat/Hello-World/contents/{+path}
       */
      contents_url: string;
      /**
       * Format: uri
       * @description A template for the API URL to list the contributors to the repository.
       * @example https://api.github.com/repos/octocat/Hello-World/contributors
       */
      contributors_url: string;
      /**
       * Format: uri
       * @description The API URL to list the deployments of the repository.
       * @example https://api.github.com/repos/octocat/Hello-World/deployments
       */
      deployments_url: string;
      /**
       * Format: uri
       * @description The API URL to list the downloads on the repository.
       * @example https://api.github.com/repos/octocat/Hello-World/downloads
       */
      downloads_url: string;
      /**
       * Format: uri
       * @description The API URL to list the events of the repository.
       * @example https://api.github.com/repos/octocat/Hello-World/events
       */
      events_url: string;
      /**
       * Format: uri
       * @description The API URL to list the forks of the repository.
       * @example https://api.github.com/repos/octocat/Hello-World/forks
       */
      forks_url: string;
      /**
       * @description A template for the API URL to get information about Git commits of the repository.
       * @example https://api.github.com/repos/octocat/Hello-World/git/commits{/sha}
       */
      git_commits_url: string;
      /**
       * @description A template for the API URL to get information about Git refs of the repository.
       * @example https://api.github.com/repos/octocat/Hello-World/git/refs{/sha}
       */
      git_refs_url: string;
      /**
       * @description A template for the API URL to get information about Git tags of the repository.
       * @example https://api.github.com/repos/octocat/Hello-World/git/tags{/sha}
       */
      git_tags_url: string;
      /**
       * @description A template for the API URL to get information about issue comments on the repository.
       * @example https://api.github.com/repos/octocat/Hello-World/issues/comments{/number}
       */
      issue_comment_url: string;
      /**
       * @description A template for the API URL to get information about issue events on the repository.
       * @example https://api.github.com/repos/octocat/Hello-World/issues/events{/number}
       */
      issue_events_url: string;
      /**
       * @description A template for the API URL to get information about issues on the repository.
       * @example https://api.github.com/repos/octocat/Hello-World/issues{/number}
       */
      issues_url: string;
      /**
       * @description A template for the API URL to get information about deploy keys on the repository.
       * @example https://api.github.com/repos/octocat/Hello-World/keys{/key_id}
       */
      keys_url: string;
      /**
       * @description A template for the API URL to get information about labels of the repository.
       * @example https://api.github.com/repos/octocat/Hello-World/labels{/name}
       */
      labels_url: string;
      /**
       * Format: uri
       * @description The API URL to get information about the languages of the repository.
       * @example https://api.github.com/repos/octocat/Hello-World/languages
       */
      languages_url: string;
      /**
       * Format: uri
       * @description The API URL to merge branches in the repository.
       * @example https://api.github.com/repos/octocat/Hello-World/merges
       */
      merges_url: string;
      /**
       * @description A template for the API URL to get information about milestones of the repository.
       * @example https://api.github.com/repos/octocat/Hello-World/milestones{/number}
       */
      milestones_url: string;
      /**
       * @description A template for the API URL to get information about notifications on the repository.
       * @example https://api.github.com/repos/octocat/Hello-World/notifications{?since,all,participating}
       */
      notifications_url: string;
      /**
       * @description A template for the API URL to get information about pull requests on the repository.
       * @example https://api.github.com/repos/octocat/Hello-World/pulls{/number}
       */
      pulls_url: string;
      /**
       * @description A template for the API URL to get information about releases on the repository.
       * @example https://api.github.com/repos/octocat/Hello-World/releases{/id}
       */
      releases_url: string;
      /**
       * Format: uri
       * @description The API URL to list the stargazers on the repository.
       * @example https://api.github.com/repos/octocat/Hello-World/stargazers
       */
      stargazers_url: string;
      /**
       * @description A template for the API URL to get information about statuses of a commit.
       * @example https://api.github.com/repos/octocat/Hello-World/statuses/{sha}
       */
      statuses_url: string;
      /**
       * Format: uri
       * @description The API URL to list the subscribers on the repository.
       * @example https://api.github.com/repos/octocat/Hello-World/subscribers
       */
      subscribers_url: string;
      /**
       * Format: uri
       * @description The API URL to subscribe to notifications for this repository.
       * @example https://api.github.com/repos/octocat/Hello-World/subscription
       */
      subscription_url: string;
      /**
       * Format: uri
       * @description The API URL to get information about tags on the repository.
       * @example https://api.github.com/repos/octocat/Hello-World/tags
       */
      tags_url: string;
      /**
       * Format: uri
       * @description The API URL to list the teams on the repository.
       * @example https://api.github.com/repos/octocat/Hello-World/teams
       */
      teams_url: string;
      /**
       * @description A template for the API URL to create or retrieve a raw Git tree of the repository.
       * @example https://api.github.com/repos/octocat/Hello-World/git/trees{/sha}
       */
      trees_url: string;
      /**
       * Format: uri
       * @description The API URL to list the hooks on the repository.
       * @example https://api.github.com/repos/octocat/Hello-World/hooks
       */
      hooks_url: string;
    };
    "organization-secret-scanning-alert": {
      number?: components["schemas"]["alert-number"];
      created_at?: components["schemas"]["alert-created-at"];
      updated_at?: components["schemas"]["nullable-alert-updated-at"];
      url?: components["schemas"]["alert-url"];
      html_url?: components["schemas"]["alert-html-url"];
      /**
       * Format: uri
       * @description The REST API URL of the code locations for this alert.
       */
      locations_url?: string;
      state?: components["schemas"]["secret-scanning-alert-state"];
      resolution?: components["schemas"]["secret-scanning-alert-resolution"];
      /**
       * Format: date-time
       * @description The time that the alert was resolved in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
       */
      resolved_at?: string | null;
      resolved_by?: components["schemas"]["nullable-simple-user"];
      /** @description The type of secret that secret scanning detected. */
      secret_type?: string;
      /** @description The secret that was detected. */
      secret?: string;
      repository?: components["schemas"]["simple-repository"];
    };
    /**
     * Team Simple
     * @description Groups of organization members that gives permissions on specified repositories.
     */
    "nullable-team-simple": {
      /**
       * @description Unique identifier of the team
       * @example 1
       */
      id: number;
      /** @example MDQ6VGVhbTE= */
      node_id: string;
      /**
       * Format: uri
       * @description URL for the team
       * @example https://api.github.com/organizations/1/team/1
       */
      url: string;
      /** @example https://api.github.com/organizations/1/team/1/members{/member} */
      members_url: string;
      /**
       * @description Name of the team
       * @example Justice League
       */
      name: string;
      /**
       * @description Description of the team
       * @example A great team.
       */
      description: string | null;
      /**
       * @description Permission that the team will have for its repositories
       * @example admin
       */
      permission: string;
      /**
       * @description The level of privacy this team should have
       * @example closed
       */
      privacy?: string;
      /**
       * Format: uri
       * @example https://github.com/orgs/rails/teams/core
       */
      html_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/organizations/1/team/1/repos
       */
      repositories_url: string;
      /** @example justice-league */
      slug: string;
      /**
       * @description Distinguished Name (DN) that team maps to within LDAP environment
       * @example uid=example,ou=users,dc=github,dc=com
       */
      ldap_dn?: string;
    } | null;
    /**
     * Team
     * @description Groups of organization members that gives permissions on specified repositories.
     */
    team: {
      id: number;
      node_id: string;
      name: string;
      slug: string;
      description: string | null;
      privacy?: string;
      permission: string;
      permissions?: {
        pull: boolean;
        triage: boolean;
        push: boolean;
        maintain: boolean;
        admin: boolean;
      };
      /** Format: uri */
      url: string;
      /**
       * Format: uri
       * @example https://github.com/orgs/rails/teams/core
       */
      html_url: string;
      members_url: string;
      /** Format: uri */
      repositories_url: string;
      parent: components["schemas"]["nullable-team-simple"];
    };
    /**
     * Team Organization
     * @description Team Organization
     */
    "team-organization": {
      /** @example github */
      login: string;
      /** @example 1 */
      id: number;
      /** @example MDEyOk9yZ2FuaXphdGlvbjE= */
      node_id: string;
      /**
       * Format: uri
       * @example https://api.github.com/orgs/github
       */
      url: string;
      /**
       * Format: uri
       * @example https://api.github.com/orgs/github/repos
       */
      repos_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/orgs/github/events
       */
      events_url: string;
      /** @example https://api.github.com/orgs/github/hooks */
      hooks_url: string;
      /** @example https://api.github.com/orgs/github/issues */
      issues_url: string;
      /** @example https://api.github.com/orgs/github/members{/member} */
      members_url: string;
      /** @example https://api.github.com/orgs/github/public_members{/member} */
      public_members_url: string;
      /** @example https://github.com/images/error/octocat_happy.gif */
      avatar_url: string;
      /** @example A great organization */
      description: string | null;
      /** @example github */
      name?: string;
      /** @example GitHub */
      company?: string;
      /**
       * Format: uri
       * @example https://github.com/blog
       */
      blog?: string;
      /** @example San Francisco */
      location?: string;
      /**
       * Format: email
       * @example octocat@github.com
       */
      email?: string;
      /** @example github */
      twitter_username?: string | null;
      /** @example true */
      is_verified?: boolean;
      /** @example true */
      has_organization_projects: boolean;
      /** @example true */
      has_repository_projects: boolean;
      /** @example 2 */
      public_repos: number;
      /** @example 1 */
      public_gists: number;
      /** @example 20 */
      followers: number;
      /** @example 0 */
      following: number;
      /**
       * Format: uri
       * @example https://github.com/octocat
       */
      html_url: string;
      /**
       * Format: date-time
       * @example 2008-01-14T04:33:35Z
       */
      created_at: string;
      /** @example Organization */
      type: string;
      /** @example 100 */
      total_private_repos?: number;
      /** @example 100 */
      owned_private_repos?: number;
      /** @example 81 */
      private_gists?: number | null;
      /** @example 10000 */
      disk_usage?: number | null;
      /** @example 8 */
      collaborators?: number | null;
      /**
       * Format: email
       * @example org@example.com
       */
      billing_email?: string | null;
      plan?: {
        name: string;
        space: number;
        private_repos: number;
        filled_seats?: number;
        seats?: number;
      };
      default_repository_permission?: string | null;
      /** @example true */
      members_can_create_repositories?: boolean | null;
      /** @example true */
      two_factor_requirement_enabled?: boolean | null;
      /** @example all */
      members_allowed_repository_creation_type?: string;
      /** @example true */
      members_can_create_public_repositories?: boolean;
      /** @example true */
      members_can_create_private_repositories?: boolean;
      /** @example true */
      members_can_create_internal_repositories?: boolean;
      /** @example true */
      members_can_create_pages?: boolean;
      /** @example true */
      members_can_create_public_pages?: boolean;
      /** @example true */
      members_can_create_private_pages?: boolean;
      /** Format: date-time */
      updated_at: string;
    };
    /**
     * Full Team
     * @description Groups of organization members that gives permissions on specified repositories.
     */
    "team-full": {
      /**
       * @description Unique identifier of the team
       * @example 42
       */
      id: number;
      /** @example MDQ6VGVhbTE= */
      node_id: string;
      /**
       * Format: uri
       * @description URL for the team
       * @example https://api.github.com/organizations/1/team/1
       */
      url: string;
      /**
       * Format: uri
       * @example https://github.com/orgs/rails/teams/core
       */
      html_url: string;
      /**
       * @description Name of the team
       * @example Developers
       */
      name: string;
      /** @example justice-league */
      slug: string;
      /** @example A great team. */
      description: string | null;
      /**
       * @description The level of privacy this team should have
       * @example closed
       * @enum {string}
       */
      privacy?: "closed" | "secret";
      /**
       * @description Permission that the team will have for its repositories
       * @example push
       */
      permission: string;
      /** @example https://api.github.com/organizations/1/team/1/members{/member} */
      members_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/organizations/1/team/1/repos
       */
      repositories_url: string;
      parent?: components["schemas"]["nullable-team-simple"];
      /** @example 3 */
      members_count: number;
      /** @example 10 */
      repos_count: number;
      /**
       * Format: date-time
       * @example 2017-07-14T16:53:42Z
       */
      created_at: string;
      /**
       * Format: date-time
       * @example 2017-08-17T12:37:15Z
       */
      updated_at: string;
      organization: components["schemas"]["team-organization"];
      /**
       * @description Distinguished Name (DN) that team maps to within LDAP environment
       * @example uid=example,ou=users,dc=github,dc=com
       */
      ldap_dn?: string;
    };
    /**
     * Team Discussion
     * @description A team discussion is a persistent record of a free-form conversation within a team.
     */
    "team-discussion": {
      author: components["schemas"]["nullable-simple-user"];
      /**
       * @description The main text of the discussion.
       * @example Please suggest improvements to our workflow in comments.
       */
      body: string;
      /** @example <p>Hi! This is an area for us to collaborate as a team</p> */
      body_html: string;
      /**
       * @description The current version of the body content. If provided, this update operation will be rejected if the given version does not match the latest version on the server.
       * @example 0307116bbf7ced493b8d8a346c650b71
       */
      body_version: string;
      /** @example 0 */
      comments_count: number;
      /**
       * Format: uri
       * @example https://api.github.com/organizations/1/team/2343027/discussions/1/comments
       */
      comments_url: string;
      /**
       * Format: date-time
       * @example 2018-01-25T18:56:31Z
       */
      created_at: string;
      /** Format: date-time */
      last_edited_at: string | null;
      /**
       * Format: uri
       * @example https://github.com/orgs/github/teams/justice-league/discussions/1
       */
      html_url: string;
      /** @example MDE0OlRlYW1EaXNjdXNzaW9uMQ== */
      node_id: string;
      /**
       * @description The unique sequence number of a team discussion.
       * @example 42
       */
      number: number;
      /**
       * @description Whether or not this discussion should be pinned for easy retrieval.
       * @example true
       */
      pinned: boolean;
      /**
       * @description Whether or not this discussion should be restricted to team members and organization administrators.
       * @example true
       */
      private: boolean;
      /**
       * Format: uri
       * @example https://api.github.com/organizations/1/team/2343027
       */
      team_url: string;
      /**
       * @description The title of the discussion.
       * @example How can we improve our workflow?
       */
      title: string;
      /**
       * Format: date-time
       * @example 2018-01-25T18:56:31Z
       */
      updated_at: string;
      /**
       * Format: uri
       * @example https://api.github.com/organizations/1/team/2343027/discussions/1
       */
      url: string;
      reactions?: components["schemas"]["reaction-rollup"];
    };
    /**
     * Team Discussion Comment
     * @description A reply to a discussion within a team.
     */
    "team-discussion-comment": {
      author: components["schemas"]["nullable-simple-user"];
      /**
       * @description The main text of the comment.
       * @example I agree with this suggestion.
       */
      body: string;
      /** @example <p>Do you like apples?</p> */
      body_html: string;
      /**
       * @description The current version of the body content. If provided, this update operation will be rejected if the given version does not match the latest version on the server.
       * @example 0307116bbf7ced493b8d8a346c650b71
       */
      body_version: string;
      /**
       * Format: date-time
       * @example 2018-01-15T23:53:58Z
       */
      created_at: string;
      /** Format: date-time */
      last_edited_at: string | null;
      /**
       * Format: uri
       * @example https://api.github.com/organizations/1/team/2403582/discussions/1
       */
      discussion_url: string;
      /**
       * Format: uri
       * @example https://github.com/orgs/github/teams/justice-league/discussions/1/comments/1
       */
      html_url: string;
      /** @example MDIxOlRlYW1EaXNjdXNzaW9uQ29tbWVudDE= */
      node_id: string;
      /**
       * @description The unique sequence number of a team discussion comment.
       * @example 42
       */
      number: number;
      /**
       * Format: date-time
       * @example 2018-01-15T23:53:58Z
       */
      updated_at: string;
      /**
       * Format: uri
       * @example https://api.github.com/organizations/1/team/2403582/discussions/1/comments/1
       */
      url: string;
      reactions?: components["schemas"]["reaction-rollup"];
    };
    /**
     * Reaction
     * @description Reactions to conversations provide a way to help people express their feelings more simply and effectively.
     */
    reaction: {
      /** @example 1 */
      id: number;
      /** @example MDg6UmVhY3Rpb24x */
      node_id: string;
      user: components["schemas"]["nullable-simple-user"];
      /**
       * @description The reaction to use
       * @example heart
       * @enum {string}
       */
      content:
        | "+1"
        | "-1"
        | "laugh"
        | "confused"
        | "heart"
        | "hooray"
        | "rocket"
        | "eyes";
      /**
       * Format: date-time
       * @example 2016-05-20T20:09:31Z
       */
      created_at: string;
    };
    /**
     * Team Membership
     * @description Team Membership
     */
    "team-membership": {
      /** Format: uri */
      url: string;
      /**
       * @description The role of the user in the team.
       * @default member
       * @example member
       * @enum {string}
       */
      role: "member" | "maintainer";
      /**
       * @description The state of the user's membership in the team.
       * @enum {string}
       */
      state: "active" | "pending";
    };
    /**
     * Team Project
     * @description A team's access to a project.
     */
    "team-project": {
      owner_url: string;
      url: string;
      html_url: string;
      columns_url: string;
      id: number;
      node_id: string;
      name: string;
      body: string | null;
      number: number;
      state: string;
      creator: components["schemas"]["simple-user"];
      created_at: string;
      updated_at: string;
      /** @description The organization permission for this project. Only present when owner is an organization. */
      organization_permission?: string;
      /** @description Whether the project is private or not. Only present when owner is an organization. */
      private?: boolean;
      permissions: {
        read: boolean;
        write: boolean;
        admin: boolean;
      };
    };
    /**
     * Team Repository
     * @description A team's access to a repository.
     */
    "team-repository": {
      /**
       * @description Unique identifier of the repository
       * @example 42
       */
      id: number;
      /** @example MDEwOlJlcG9zaXRvcnkxMjk2MjY5 */
      node_id: string;
      /**
       * @description The name of the repository.
       * @example Team Environment
       */
      name: string;
      /** @example octocat/Hello-World */
      full_name: string;
      license: components["schemas"]["nullable-license-simple"];
      forks: number;
      permissions?: {
        admin: boolean;
        pull: boolean;
        triage?: boolean;
        push: boolean;
        maintain?: boolean;
      };
      owner: components["schemas"]["nullable-simple-user"];
      /**
       * @description Whether the repository is private or public.
       * @default false
       */
      private: boolean;
      /**
       * Format: uri
       * @example https://github.com/octocat/Hello-World
       */
      html_url: string;
      /** @example This your first repo! */
      description: string | null;
      fork: boolean;
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/Hello-World
       */
      url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/{archive_format}{/ref} */
      archive_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/assignees{/user} */
      assignees_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/git/blobs{/sha} */
      blobs_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/branches{/branch} */
      branches_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/collaborators{/collaborator} */
      collaborators_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/comments{/number} */
      comments_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/commits{/sha} */
      commits_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/compare/{base}...{head} */
      compare_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/contents/{+path} */
      contents_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/contributors
       */
      contributors_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/deployments
       */
      deployments_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/downloads
       */
      downloads_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/events
       */
      events_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/forks
       */
      forks_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/git/commits{/sha} */
      git_commits_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/git/refs{/sha} */
      git_refs_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/git/tags{/sha} */
      git_tags_url: string;
      /** @example git:github.com/octocat/Hello-World.git */
      git_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/issues/comments{/number} */
      issue_comment_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/issues/events{/number} */
      issue_events_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/issues{/number} */
      issues_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/keys{/key_id} */
      keys_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/labels{/name} */
      labels_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/languages
       */
      languages_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/merges
       */
      merges_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/milestones{/number} */
      milestones_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/notifications{?since,all,participating} */
      notifications_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/pulls{/number} */
      pulls_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/releases{/id} */
      releases_url: string;
      /** @example git@github.com:octocat/Hello-World.git */
      ssh_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/stargazers
       */
      stargazers_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/statuses/{sha} */
      statuses_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/subscribers
       */
      subscribers_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/subscription
       */
      subscription_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/tags
       */
      tags_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/teams
       */
      teams_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/git/trees{/sha} */
      trees_url: string;
      /** @example https://github.com/octocat/Hello-World.git */
      clone_url: string;
      /**
       * Format: uri
       * @example git:git.example.com/octocat/Hello-World
       */
      mirror_url: string | null;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/hooks
       */
      hooks_url: string;
      /**
       * Format: uri
       * @example https://svn.github.com/octocat/Hello-World
       */
      svn_url: string;
      /**
       * Format: uri
       * @example https://github.com
       */
      homepage: string | null;
      language: string | null;
      /** @example 9 */
      forks_count: number;
      /** @example 80 */
      stargazers_count: number;
      /** @example 80 */
      watchers_count: number;
      /** @example 108 */
      size: number;
      /**
       * @description The default branch of the repository.
       * @example master
       */
      default_branch: string;
      /** @example 0 */
      open_issues_count: number;
      /**
       * @description Whether this repository acts as a template that can be used to generate new repositories.
       * @default false
       * @example true
       */
      is_template?: boolean;
      topics?: string[];
      /**
       * @description Whether issues are enabled.
       * @default true
       * @example true
       */
      has_issues: boolean;
      /**
       * @description Whether projects are enabled.
       * @default true
       * @example true
       */
      has_projects: boolean;
      /**
       * @description Whether the wiki is enabled.
       * @default true
       * @example true
       */
      has_wiki: boolean;
      has_pages: boolean;
      /**
       * @description Whether downloads are enabled.
       * @default true
       * @example true
       */
      has_downloads: boolean;
      /**
       * @description Whether the repository is archived.
       * @default false
       */
      archived: boolean;
      /** @description Returns whether or not this repository disabled. */
      disabled: boolean;
      /**
       * @description The repository visibility: public, private, or internal.
       * @default public
       */
      visibility?: string;
      /**
       * Format: date-time
       * @example 2011-01-26T19:06:43Z
       */
      pushed_at: string | null;
      /**
       * Format: date-time
       * @example 2011-01-26T19:01:12Z
       */
      created_at: string | null;
      /**
       * Format: date-time
       * @example 2011-01-26T19:14:43Z
       */
      updated_at: string | null;
      /**
       * @description Whether to allow rebase merges for pull requests.
       * @default true
       * @example true
       */
      allow_rebase_merge?: boolean;
      template_repository?: components["schemas"]["nullable-repository"];
      temp_clone_token?: string;
      /**
       * @description Whether to allow squash merges for pull requests.
       * @default true
       * @example true
       */
      allow_squash_merge?: boolean;
      /**
       * @description Whether to allow Auto-merge to be used on pull requests.
       * @default false
       * @example false
       */
      allow_auto_merge?: boolean;
      /**
       * @description Whether to delete head branches when pull requests are merged
       * @default false
       * @example false
       */
      delete_branch_on_merge?: boolean;
      /**
       * @description Whether to allow merge commits for pull requests.
       * @default true
       * @example true
       */
      allow_merge_commit?: boolean;
      /**
       * @description Whether to allow forking this repo
       * @default false
       * @example false
       */
      allow_forking?: boolean;
      subscribers_count?: number;
      network_count?: number;
      open_issues: number;
      watchers: number;
      master_branch?: string;
    };
    /**
     * Project Card
     * @description Project cards represent a scope of work.
     */
    "project-card": {
      /**
       * Format: uri
       * @example https://api.github.com/projects/columns/cards/1478
       */
      url: string;
      /**
       * @description The project card's ID
       * @example 42
       */
      id: number;
      /** @example MDExOlByb2plY3RDYXJkMTQ3OA== */
      node_id: string;
      /** @example Add payload for delete Project column */
      note: string | null;
      creator: components["schemas"]["nullable-simple-user"];
      /**
       * Format: date-time
       * @example 2016-09-05T14:21:06Z
       */
      created_at: string;
      /**
       * Format: date-time
       * @example 2016-09-05T14:20:22Z
       */
      updated_at: string;
      /**
       * @description Whether or not the card is archived
       * @example false
       */
      archived?: boolean;
      column_name?: string;
      project_id?: string;
      /**
       * Format: uri
       * @example https://api.github.com/projects/columns/367
       */
      column_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/repos/api-playground/projects-test/issues/3
       */
      content_url?: string;
      /**
       * Format: uri
       * @example https://api.github.com/projects/120
       */
      project_url: string;
    };
    /**
     * Project Column
     * @description Project columns contain cards of work.
     */
    "project-column": {
      /**
       * Format: uri
       * @example https://api.github.com/projects/columns/367
       */
      url: string;
      /**
       * Format: uri
       * @example https://api.github.com/projects/120
       */
      project_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/projects/columns/367/cards
       */
      cards_url: string;
      /**
       * @description The unique identifier of the project column
       * @example 42
       */
      id: number;
      /** @example MDEzOlByb2plY3RDb2x1bW4zNjc= */
      node_id: string;
      /**
       * @description Name of the project column
       * @example Remaining tasks
       */
      name: string;
      /**
       * Format: date-time
       * @example 2016-09-05T14:18:44Z
       */
      created_at: string;
      /**
       * Format: date-time
       * @example 2016-09-05T14:22:28Z
       */
      updated_at: string;
    };
    /**
     * Project Collaborator Permission
     * @description Project Collaborator Permission
     */
    "project-collaborator-permission": {
      permission: string;
      user: components["schemas"]["nullable-simple-user"];
    };
    /** Rate Limit */
    "rate-limit": {
      limit: number;
      remaining: number;
      reset: number;
      used: number;
    };
    /**
     * Rate Limit Overview
     * @description Rate Limit Overview
     */
    "rate-limit-overview": {
      resources: {
        core: components["schemas"]["rate-limit"];
        graphql?: components["schemas"]["rate-limit"];
        search: components["schemas"]["rate-limit"];
        source_import?: components["schemas"]["rate-limit"];
        integration_manifest?: components["schemas"]["rate-limit"];
        code_scanning_upload?: components["schemas"]["rate-limit"];
        actions_runner_registration?: components["schemas"]["rate-limit"];
        scim?: components["schemas"]["rate-limit"];
      };
      rate: components["schemas"]["rate-limit"];
    };
    /**
     * Code Of Conduct Simple
     * @description Code of Conduct Simple
     */
    "code-of-conduct-simple": {
      /**
       * Format: uri
       * @example https://api.github.com/repos/github/docs/community/code_of_conduct
       */
      url: string;
      /** @example citizen_code_of_conduct */
      key: string;
      /** @example Citizen Code of Conduct */
      name: string;
      /**
       * Format: uri
       * @example https://github.com/github/docs/blob/main/CODE_OF_CONDUCT.md
       */
      html_url: string | null;
    };
    "security-and-analysis": {
      advanced_security?: {
        /** @enum {string} */
        status?: "enabled" | "disabled";
      };
      secret_scanning?: {
        /** @enum {string} */
        status?: "enabled" | "disabled";
      };
      secret_scanning_push_protection?: {
        /** @enum {string} */
        status?: "enabled" | "disabled";
      };
    } | null;
    /**
     * Full Repository
     * @description Full Repository
     */
    "full-repository": {
      /** @example 1296269 */
      id: number;
      /** @example MDEwOlJlcG9zaXRvcnkxMjk2MjY5 */
      node_id: string;
      /** @example Hello-World */
      name: string;
      /** @example octocat/Hello-World */
      full_name: string;
      owner: components["schemas"]["simple-user"];
      private: boolean;
      /**
       * Format: uri
       * @example https://github.com/octocat/Hello-World
       */
      html_url: string;
      /** @example This your first repo! */
      description: string | null;
      fork: boolean;
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/Hello-World
       */
      url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/{archive_format}{/ref} */
      archive_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/assignees{/user} */
      assignees_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/git/blobs{/sha} */
      blobs_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/branches{/branch} */
      branches_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/collaborators{/collaborator} */
      collaborators_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/comments{/number} */
      comments_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/commits{/sha} */
      commits_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/compare/{base}...{head} */
      compare_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/contents/{+path} */
      contents_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/contributors
       */
      contributors_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/deployments
       */
      deployments_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/downloads
       */
      downloads_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/events
       */
      events_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/forks
       */
      forks_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/git/commits{/sha} */
      git_commits_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/git/refs{/sha} */
      git_refs_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/git/tags{/sha} */
      git_tags_url: string;
      /** @example git:github.com/octocat/Hello-World.git */
      git_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/issues/comments{/number} */
      issue_comment_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/issues/events{/number} */
      issue_events_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/issues{/number} */
      issues_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/keys{/key_id} */
      keys_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/labels{/name} */
      labels_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/languages
       */
      languages_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/merges
       */
      merges_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/milestones{/number} */
      milestones_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/notifications{?since,all,participating} */
      notifications_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/pulls{/number} */
      pulls_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/releases{/id} */
      releases_url: string;
      /** @example git@github.com:octocat/Hello-World.git */
      ssh_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/stargazers
       */
      stargazers_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/statuses/{sha} */
      statuses_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/subscribers
       */
      subscribers_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/subscription
       */
      subscription_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/tags
       */
      tags_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/teams
       */
      teams_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/git/trees{/sha} */
      trees_url: string;
      /** @example https://github.com/octocat/Hello-World.git */
      clone_url: string;
      /**
       * Format: uri
       * @example git:git.example.com/octocat/Hello-World
       */
      mirror_url: string | null;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/hooks
       */
      hooks_url: string;
      /**
       * Format: uri
       * @example https://svn.github.com/octocat/Hello-World
       */
      svn_url: string;
      /**
       * Format: uri
       * @example https://github.com
       */
      homepage: string | null;
      language: string | null;
      /** @example 9 */
      forks_count: number;
      /** @example 80 */
      stargazers_count: number;
      /** @example 80 */
      watchers_count: number;
      /**
       * @description The size of the repository. Size is calculated hourly. When a repository is initially created, the size is 0.
       * @example 108
       */
      size: number;
      /** @example master */
      default_branch: string;
      /** @example 0 */
      open_issues_count: number;
      /** @example true */
      is_template?: boolean;
      /**
       * @example [
       *   "octocat",
       *   "atom",
       *   "electron",
       *   "API"
       * ]
       */
      topics?: string[];
      /** @example true */
      has_issues: boolean;
      /** @example true */
      has_projects: boolean;
      /** @example true */
      has_wiki: boolean;
      has_pages: boolean;
      /** @example true */
      has_downloads: boolean;
      archived: boolean;
      /** @description Returns whether or not this repository disabled. */
      disabled: boolean;
      /**
       * @description The repository visibility: public, private, or internal.
       * @example public
       */
      visibility?: string;
      /**
       * Format: date-time
       * @example 2011-01-26T19:06:43Z
       */
      pushed_at: string;
      /**
       * Format: date-time
       * @example 2011-01-26T19:01:12Z
       */
      created_at: string;
      /**
       * Format: date-time
       * @example 2011-01-26T19:14:43Z
       */
      updated_at: string;
      permissions?: {
        admin: boolean;
        maintain?: boolean;
        push: boolean;
        triage?: boolean;
        pull: boolean;
      };
      /** @example true */
      allow_rebase_merge?: boolean;
      template_repository?: components["schemas"]["nullable-repository"];
      temp_clone_token?: string | null;
      /** @example true */
      allow_squash_merge?: boolean;
      /** @example false */
      allow_auto_merge?: boolean;
      /** @example false */
      delete_branch_on_merge?: boolean;
      /** @example true */
      allow_merge_commit?: boolean;
      /** @example true */
      allow_update_branch?: boolean;
      /** @example true */
      allow_forking?: boolean;
      /** @example 42 */
      subscribers_count: number;
      /** @example 0 */
      network_count: number;
      license: components["schemas"]["nullable-license-simple"];
      organization?: components["schemas"]["nullable-simple-user"];
      parent?: components["schemas"]["repository"];
      source?: components["schemas"]["repository"];
      forks: number;
      master_branch?: string;
      open_issues: number;
      watchers: number;
      /**
       * @description Whether anonymous git access is allowed.
       * @default true
       */
      anonymous_access_enabled?: boolean;
      code_of_conduct?: components["schemas"]["code-of-conduct-simple"];
      security_and_analysis?: components["schemas"]["security-and-analysis"];
    };
    /**
     * Artifact
     * @description An artifact
     */
    artifact: {
      /** @example 5 */
      id: number;
      /** @example MDEwOkNoZWNrU3VpdGU1 */
      node_id: string;
      /**
       * @description The name of the artifact.
       * @example AdventureWorks.Framework
       */
      name: string;
      /**
       * @description The size in bytes of the artifact.
       * @example 12345
       */
      size_in_bytes: number;
      /** @example https://api.github.com/repos/github/hello-world/actions/artifacts/5 */
      url: string;
      /** @example https://api.github.com/repos/github/hello-world/actions/artifacts/5/zip */
      archive_download_url: string;
      /** @description Whether or not the artifact has expired. */
      expired: boolean;
      /** Format: date-time */
      created_at: string | null;
      /** Format: date-time */
      expires_at: string | null;
      /** Format: date-time */
      updated_at: string | null;
      workflow_run?: {
        /** @example 10 */
        id?: number;
        /** @example 42 */
        repository_id?: number;
        /** @example 42 */
        head_repository_id?: number;
        /** @example main */
        head_branch?: string;
        /** @example 009b8a3a9ccbb128af87f9b1c0f4c62e8a304f6d */
        head_sha?: string;
      } | null;
    };
    /**
     * Job
     * @description Information of a job execution in a workflow run
     */
    job: {
      /**
       * @description The id of the job.
       * @example 21
       */
      id: number;
      /**
       * @description The id of the associated workflow run.
       * @example 5
       */
      run_id: number;
      /** @example https://api.github.com/repos/github/hello-world/actions/runs/5 */
      run_url: string;
      /**
       * @description Attempt number of the associated workflow run, 1 for first attempt and higher if the workflow was re-run.
       * @example 1
       */
      run_attempt?: number;
      /** @example MDg6Q2hlY2tSdW40 */
      node_id: string;
      /**
       * @description The SHA of the commit that is being run.
       * @example 009b8a3a9ccbb128af87f9b1c0f4c62e8a304f6d
       */
      head_sha: string;
      /** @example https://api.github.com/repos/github/hello-world/actions/jobs/21 */
      url: string;
      /** @example https://github.com/github/hello-world/runs/4 */
      html_url: string | null;
      /**
       * @description The phase of the lifecycle that the job is currently in.
       * @example queued
       * @enum {string}
       */
      status: "queued" | "in_progress" | "completed";
      /**
       * @description The outcome of the job.
       * @example success
       * @enum {string|null}
       */
      conclusion:
        | (
            | "success"
            | "failure"
            | "neutral"
            | "cancelled"
            | "skipped"
            | "timed_out"
            | "action_required"
          )
        | null;
      /**
       * Format: date-time
       * @description The time that the job started, in ISO 8601 format.
       * @example 2019-08-08T08:00:00-07:00
       */
      started_at: string;
      /**
       * Format: date-time
       * @description The time that the job finished, in ISO 8601 format.
       * @example 2019-08-08T08:00:00-07:00
       */
      completed_at: string | null;
      /**
       * @description The name of the job.
       * @example test-coverage
       */
      name: string;
      /** @description Steps in this job. */
      steps?: {
        /**
         * @description The phase of the lifecycle that the job is currently in.
         * @example queued
         * @enum {string}
         */
        status: "queued" | "in_progress" | "completed";
        /**
         * @description The outcome of the job.
         * @example success
         */
        conclusion: string | null;
        /**
         * @description The name of the job.
         * @example test-coverage
         */
        name: string;
        /** @example 1 */
        number: number;
        /**
         * Format: date-time
         * @description The time that the step started, in ISO 8601 format.
         * @example 2019-08-08T08:00:00-07:00
         */
        started_at?: string | null;
        /**
         * Format: date-time
         * @description The time that the job finished, in ISO 8601 format.
         * @example 2019-08-08T08:00:00-07:00
         */
        completed_at?: string | null;
      }[];
      /** @example https://api.github.com/repos/github/hello-world/check-runs/4 */
      check_run_url: string;
      /**
       * @description Labels for the workflow job. Specified by the "runs_on" attribute in the action's workflow file.
       * @example [
       *   "self-hosted",
       *   "foo",
       *   "bar"
       * ]
       */
      labels: string[];
      /**
       * @description The ID of the runner to which this job has been assigned. (If a runner hasn't yet been assigned, this will be null.)
       * @example 1
       */
      runner_id: number | null;
      /**
       * @description The name of the runner to which this job has been assigned. (If a runner hasn't yet been assigned, this will be null.)
       * @example my runner
       */
      runner_name: string | null;
      /**
       * @description The ID of the runner group to which this job has been assigned. (If a runner hasn't yet been assigned, this will be null.)
       * @example 2
       */
      runner_group_id: number | null;
      /**
       * @description The name of the runner group to which this job has been assigned. (If a runner hasn't yet been assigned, this will be null.)
       * @example my runner group
       */
      runner_group_name: string | null;
    };
    /** @description Whether GitHub Actions is enabled on the repository. */
    "actions-enabled": boolean;
    "actions-repository-permissions": {
      enabled: components["schemas"]["actions-enabled"];
      allowed_actions?: components["schemas"]["allowed-actions"];
      selected_actions_url?: components["schemas"]["selected-actions-url"];
    };
    /** Pull Request Minimal */
    "pull-request-minimal": {
      id: number;
      number: number;
      url: string;
      head: {
        ref: string;
        sha: string;
        repo: {
          id: number;
          url: string;
          name: string;
        };
      };
      base: {
        ref: string;
        sha: string;
        repo: {
          id: number;
          url: string;
          name: string;
        };
      };
    };
    /**
     * Simple Commit
     * @description Simple Commit
     */
    "nullable-simple-commit": {
      id: string;
      tree_id: string;
      message: string;
      /** Format: date-time */
      timestamp: string;
      author: {
        name: string;
        email: string;
      } | null;
      committer: {
        name: string;
        email: string;
      } | null;
    } | null;
    /**
     * Workflow Run
     * @description An invocation of a workflow
     */
    "workflow-run": {
      /**
       * @description The ID of the workflow run.
       * @example 5
       */
      id: number;
      /**
       * @description The name of the workflow run.
       * @example Build
       */
      name?: string | null;
      /** @example MDEwOkNoZWNrU3VpdGU1 */
      node_id: string;
      /**
       * @description The ID of the associated check suite.
       * @example 42
       */
      check_suite_id?: number;
      /**
       * @description The node ID of the associated check suite.
       * @example MDEwOkNoZWNrU3VpdGU0Mg==
       */
      check_suite_node_id?: string;
      /** @example master */
      head_branch: string | null;
      /**
       * @description The SHA of the head commit that points to the version of the workflow being run.
       * @example 009b8a3a9ccbb128af87f9b1c0f4c62e8a304f6d
       */
      head_sha: string;
      /**
       * @description The auto incrementing run number for the workflow run.
       * @example 106
       */
      run_number: number;
      /** @example push */
      event: string;
      /** @example completed */
      status: string | null;
      /** @example neutral */
      conclusion: string | null;
      /**
       * @description The ID of the parent workflow.
       * @example 5
       */
      workflow_id: number;
      /**
       * @description The URL to the workflow run.
       * @example https://api.github.com/repos/github/hello-world/actions/runs/5
       */
      url: string;
      /** @example https://github.com/github/hello-world/suites/4 */
      html_url: string;
      pull_requests: components["schemas"]["pull-request-minimal"][] | null;
      /** Format: date-time */
      created_at: string;
      /** Format: date-time */
      updated_at: string;
      /**
       * @description The URL to the jobs for the workflow run.
       * @example https://api.github.com/repos/github/hello-world/actions/runs/5/jobs
       */
      jobs_url: string;
      /**
       * @description The URL to download the logs for the workflow run.
       * @example https://api.github.com/repos/github/hello-world/actions/runs/5/logs
       */
      logs_url: string;
      /**
       * @description The URL to the associated check suite.
       * @example https://api.github.com/repos/github/hello-world/check-suites/12
       */
      check_suite_url: string;
      /**
       * @description The URL to the artifacts for the workflow run.
       * @example https://api.github.com/repos/github/hello-world/actions/runs/5/rerun/artifacts
       */
      artifacts_url: string;
      /**
       * @description The URL to cancel the workflow run.
       * @example https://api.github.com/repos/github/hello-world/actions/runs/5/cancel
       */
      cancel_url: string;
      /**
       * @description The URL to rerun the workflow run.
       * @example https://api.github.com/repos/github/hello-world/actions/runs/5/rerun
       */
      rerun_url: string;
      /**
       * @description The URL to the workflow.
       * @example https://api.github.com/repos/github/hello-world/actions/workflows/main.yaml
       */
      workflow_url: string;
      head_commit: components["schemas"]["nullable-simple-commit"];
      repository: components["schemas"]["minimal-repository"];
      head_repository: components["schemas"]["minimal-repository"];
      /** @example 5 */
      head_repository_id?: number;
    } & {
      display_title: unknown;
      path: unknown;
    };
    /**
     * Environment Approval
     * @description An entry in the reviews log for environment deployments
     */
    "environment-approvals": {
      /** @description The list of environments that were approved or rejected */
      environments: {
        /**
         * @description The id of the environment.
         * @example 56780428
         */
        id?: number;
        /** @example MDExOkVudmlyb25tZW50NTY3ODA0Mjg= */
        node_id?: string;
        /**
         * @description The name of the environment.
         * @example staging
         */
        name?: string;
        /** @example https://api.github.com/repos/github/hello-world/environments/staging */
        url?: string;
        /** @example https://github.com/github/hello-world/deployments/activity_log?environments_filter=staging */
        html_url?: string;
        /**
         * Format: date-time
         * @description The time that the environment was created, in ISO 8601 format.
         * @example 2020-11-23T22:00:40Z
         */
        created_at?: string;
        /**
         * Format: date-time
         * @description The time that the environment was last updated, in ISO 8601 format.
         * @example 2020-11-23T22:00:40Z
         */
        updated_at?: string;
      }[];
      /**
       * @description Whether deployment to the environment(s) was approved or rejected
       * @example approved
       * @enum {string}
       */
      state: "approved" | "rejected";
      user: components["schemas"]["simple-user"];
      /**
       * @description The comment submitted with the deployment review
       * @example Ship it!
       */
      comment: string;
    };
    /**
     * @description The type of reviewer.
     * @example User
     * @enum {string}
     */
    "deployment-reviewer-type": "User" | "Team";
    /**
     * Pending Deployment
     * @description Details of a deployment that is waiting for protection rules to pass
     */
    "pending-deployment": {
      environment: {
        /**
         * @description The id of the environment.
         * @example 56780428
         */
        id?: number;
        /** @example MDExOkVudmlyb25tZW50NTY3ODA0Mjg= */
        node_id?: string;
        /**
         * @description The name of the environment.
         * @example staging
         */
        name?: string;
        /** @example https://api.github.com/repos/github/hello-world/environments/staging */
        url?: string;
        /** @example https://github.com/github/hello-world/deployments/activity_log?environments_filter=staging */
        html_url?: string;
      };
      /**
       * @description The set duration of the wait timer
       * @example 30
       */
      wait_timer: number;
      /**
       * Format: date-time
       * @description The time that the wait timer began.
       * @example 2020-11-23T22:00:40Z
       */
      wait_timer_started_at: string | null;
      /**
       * @description Whether the currently authenticated user can approve the deployment
       * @example true
       */
      current_user_can_approve: boolean;
      /** @description The people or teams that may approve jobs that reference the environment. You can list up to six users or teams as reviewers. The reviewers must have at least read access to the repository. Only one of the required reviewers needs to approve the job for it to proceed. */
      reviewers: {
        type?: components["schemas"]["deployment-reviewer-type"];
        reviewer?: Partial<components["schemas"]["simple-user"]> &
          Partial<components["schemas"]["team"]>;
      }[];
    };
    /**
     * Deployment
     * @description A request for a specific ref(branch,sha,tag) to be deployed
     */
    deployment: {
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/example/deployments/1
       */
      url: string;
      /**
       * @description Unique identifier of the deployment
       * @example 42
       */
      id: number;
      /** @example MDEwOkRlcGxveW1lbnQx */
      node_id: string;
      /** @example a84d88e7554fc1fa21bcbc4efae3c782a70d2b9d */
      sha: string;
      /**
       * @description The ref to deploy. This can be a branch, tag, or sha.
       * @example topic-branch
       */
      ref: string;
      /**
       * @description Parameter to specify a task to execute
       * @example deploy
       */
      task: string;
      payload: { [key: string]: unknown } | string;
      /** @example staging */
      original_environment?: string;
      /**
       * @description Name for the target deployment environment.
       * @example production
       */
      environment: string;
      /** @example Deploy request from hubot */
      description: string | null;
      creator: components["schemas"]["nullable-simple-user"];
      /**
       * Format: date-time
       * @example 2012-07-20T01:19:13Z
       */
      created_at: string;
      /**
       * Format: date-time
       * @example 2012-07-20T01:19:13Z
       */
      updated_at: string;
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/example/deployments/1/statuses
       */
      statuses_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/example
       */
      repository_url: string;
      /**
       * @description Specifies if the given environment is will no longer exist at some point in the future. Default: false.
       * @example true
       */
      transient_environment?: boolean;
      /**
       * @description Specifies if the given environment is one that end-users directly interact with. Default: false.
       * @example true
       */
      production_environment?: boolean;
      performed_via_github_app?: components["schemas"]["nullable-integration"];
    };
    /**
     * Actions Secret
     * @description Set secrets for GitHub Actions.
     */
    "actions-secret": {
      /**
       * @description The name of the secret.
       * @example SECRET_TOKEN
       */
      name: string;
      /** Format: date-time */
      created_at: string;
      /** Format: date-time */
      updated_at: string;
    };
    /**
     * Workflow
     * @description A GitHub Actions workflow
     */
    workflow: {
      /** @example 5 */
      id: number;
      /** @example MDg6V29ya2Zsb3cxMg== */
      node_id: string;
      /** @example CI */
      name: string;
      /** @example ruby.yaml */
      path: string;
      /**
       * @example active
       * @enum {string}
       */
      state:
        | "active"
        | "deleted"
        | "disabled_fork"
        | "disabled_inactivity"
        | "disabled_manually";
      /**
       * Format: date-time
       * @example 2019-12-06T14:20:20.000Z
       */
      created_at: string;
      /**
       * Format: date-time
       * @example 2019-12-06T14:20:20.000Z
       */
      updated_at: string;
      /** @example https://api.github.com/repos/actions/setup-ruby/workflows/5 */
      url: string;
      /** @example https://github.com/actions/setup-ruby/blob/master/.github/workflows/ruby.yaml */
      html_url: string;
      /** @example https://github.com/actions/setup-ruby/workflows/CI/badge.svg */
      badge_url: string;
      /**
       * Format: date-time
       * @example 2019-12-06T14:20:20.000Z
       */
      deleted_at?: string;
    };
    /**
     * Autolink reference
     * @description An autolink reference.
     */
    autolink: {
      /** @example 3 */
      id: number;
      /**
       * @description The prefix of a key that is linkified.
       * @example TICKET-
       */
      key_prefix: string;
      /**
       * @description A template for the target URL that is generated if a key was found.
       * @example https://example.com/TICKET?query=<num>
       */
      url_template: string;
    };
    /**
     * Protected Branch Required Status Check
     * @description Protected Branch Required Status Check
     */
    "protected-branch-required-status-check": {
      url?: string;
      enforcement_level?: string;
      contexts: string[];
      contexts_url?: string;
      strict?: boolean;
    };
    /**
     * Protected Branch Admin Enforced
     * @description Protected Branch Admin Enforced
     */
    "protected-branch-admin-enforced": {
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/Hello-World/branches/master/protection/enforce_admins
       */
      url: string;
      /** @example true */
      enabled: boolean;
    };
    /**
     * Protected Branch Pull Request Review
     * @description Protected Branch Pull Request Review
     */
    "protected-branch-pull-request-review": {
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/Hello-World/branches/master/protection/dismissal_restrictions
       */
      url?: string;
      dismissal_restrictions?: {
        /** @description The list of users with review dismissal access. */
        users?: components["schemas"]["simple-user"][];
        /** @description The list of teams with review dismissal access. */
        teams?: components["schemas"]["team"][];
        /** @description The list of apps with review dismissal access. */
        apps?: components["schemas"]["integration"][];
        /** @example "https://api.github.com/repos/the-org/an-org-repo/branches/master/protection/dismissal_restrictions" */
        url?: string;
        /** @example "https://api.github.com/repos/the-org/an-org-repo/branches/master/protection/dismissal_restrictions/users" */
        users_url?: string;
        /** @example "https://api.github.com/repos/the-org/an-org-repo/branches/master/protection/dismissal_restrictions/teams" */
        teams_url?: string;
      };
      /** @example true */
      dismiss_stale_reviews: boolean;
      /** @example true */
      require_code_owner_reviews: boolean;
      /** @example 2 */
      required_approving_review_count?: number;
    };
    /**
     * Branch Restriction Policy
     * @description Branch Restriction Policy
     */
    "branch-restriction-policy": {
      /** Format: uri */
      url: string;
      /** Format: uri */
      users_url: string;
      /** Format: uri */
      teams_url: string;
      /** Format: uri */
      apps_url: string;
      users: {
        login?: string;
        id?: number;
        node_id?: string;
        avatar_url?: string;
        gravatar_id?: string;
        url?: string;
        html_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        starred_url?: string;
        subscriptions_url?: string;
        organizations_url?: string;
        repos_url?: string;
        events_url?: string;
        received_events_url?: string;
        type?: string;
        site_admin?: boolean;
      }[];
      teams: {
        id?: number;
        node_id?: string;
        url?: string;
        html_url?: string;
        name?: string;
        slug?: string;
        description?: string | null;
        privacy?: string;
        permission?: string;
        members_url?: string;
        repositories_url?: string;
        parent?: string | null;
      }[];
      apps: {
        id?: number;
        slug?: string;
        node_id?: string;
        owner?: {
          login?: string;
          id?: number;
          node_id?: string;
          url?: string;
          repos_url?: string;
          events_url?: string;
          hooks_url?: string;
          issues_url?: string;
          members_url?: string;
          public_members_url?: string;
          avatar_url?: string;
          description?: string;
          /** @example "" */
          gravatar_id?: string;
          /** @example "https://github.com/testorg-ea8ec76d71c3af4b" */
          html_url?: string;
          /** @example "https://api.github.com/users/testorg-ea8ec76d71c3af4b/followers" */
          followers_url?: string;
          /** @example "https://api.github.com/users/testorg-ea8ec76d71c3af4b/following{/other_user}" */
          following_url?: string;
          /** @example "https://api.github.com/users/testorg-ea8ec76d71c3af4b/gists{/gist_id}" */
          gists_url?: string;
          /** @example "https://api.github.com/users/testorg-ea8ec76d71c3af4b/starred{/owner}{/repo}" */
          starred_url?: string;
          /** @example "https://api.github.com/users/testorg-ea8ec76d71c3af4b/subscriptions" */
          subscriptions_url?: string;
          /** @example "https://api.github.com/users/testorg-ea8ec76d71c3af4b/orgs" */
          organizations_url?: string;
          /** @example "https://api.github.com/users/testorg-ea8ec76d71c3af4b/received_events" */
          received_events_url?: string;
          /** @example "Organization" */
          type?: string;
          /** @example false */
          site_admin?: boolean;
        };
        name?: string;
        description?: string;
        external_url?: string;
        html_url?: string;
        created_at?: string;
        updated_at?: string;
        permissions?: {
          metadata?: string;
          contents?: string;
          issues?: string;
          single_file?: string;
        };
        events?: string[];
      }[];
    };
    /**
     * Branch Protection
     * @description Branch Protection
     */
    "branch-protection": {
      url?: string;
      enabled?: boolean;
      required_status_checks?: components["schemas"]["protected-branch-required-status-check"];
      enforce_admins?: components["schemas"]["protected-branch-admin-enforced"];
      required_pull_request_reviews?: components["schemas"]["protected-branch-pull-request-review"];
      restrictions?: components["schemas"]["branch-restriction-policy"];
      required_linear_history?: {
        enabled?: boolean;
      };
      allow_force_pushes?: {
        enabled?: boolean;
      };
      allow_deletions?: {
        enabled?: boolean;
      };
      block_creations?: {
        enabled?: boolean;
      };
      required_conversation_resolution?: {
        enabled?: boolean;
      };
      /** @example "branch/with/protection" */
      name?: string;
      /** @example "https://api.github.com/repos/owner-79e94e2d36b3fd06a32bb213/AAA_Public_Repo/branches/branch/with/protection/protection" */
      protection_url?: string;
      required_signatures?: {
        /**
         * Format: uri
         * @example https://api.github.com/repos/octocat/Hello-World/branches/master/protection/required_signatures
         */
        url: string;
        /** @example true */
        enabled: boolean;
      };
    };
    /**
     * Short Branch
     * @description Short Branch
     */
    "short-branch": {
      name: string;
      commit: {
        sha: string;
        /** Format: uri */
        url: string;
      };
      protected: boolean;
      protection?: components["schemas"]["branch-protection"];
      /** Format: uri */
      protection_url?: string;
    };
    /**
     * Git User
     * @description Metaproperties for Git author/committer information.
     */
    "nullable-git-user": {
      /** @example "Chris Wanstrath" */
      name?: string;
      /** @example "chris@ozmm.org" */
      email?: string;
      /** @example "2007-10-29T02:42:39.000-07:00" */
      date?: string;
    } | null;
    /** Verification */
    verification: {
      verified: boolean;
      reason: string;
      payload: string | null;
      signature: string | null;
    };
    /**
     * Diff Entry
     * @description Diff Entry
     */
    "diff-entry": {
      /** @example bbcd538c8e72b8c175046e27cc8f907076331401 */
      sha: string;
      /** @example file1.txt */
      filename: string;
      /**
       * @example added
       * @enum {string}
       */
      status:
        | "added"
        | "removed"
        | "modified"
        | "renamed"
        | "copied"
        | "changed"
        | "unchanged";
      /** @example 103 */
      additions: number;
      /** @example 21 */
      deletions: number;
      /** @example 124 */
      changes: number;
      /**
       * Format: uri
       * @example https://github.com/octocat/Hello-World/blob/6dcb09b5b57875f334f61aebed695e2e4193db5e/file1.txt
       */
      blob_url: string;
      /**
       * Format: uri
       * @example https://github.com/octocat/Hello-World/raw/6dcb09b5b57875f334f61aebed695e2e4193db5e/file1.txt
       */
      raw_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/Hello-World/contents/file1.txt?ref=6dcb09b5b57875f334f61aebed695e2e4193db5e
       */
      contents_url: string;
      /** @example @@ -132,7 +132,7 @@ module Test @@ -1000,7 +1000,7 @@ module Test */
      patch?: string;
      /** @example file.txt */
      previous_filename?: string;
    };
    /**
     * Commit
     * @description Commit
     */
    commit: {
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/Hello-World/commits/6dcb09b5b57875f334f61aebed695e2e4193db5e
       */
      url: string;
      /** @example 6dcb09b5b57875f334f61aebed695e2e4193db5e */
      sha: string;
      /** @example MDY6Q29tbWl0NmRjYjA5YjViNTc4NzVmMzM0ZjYxYWViZWQ2OTVlMmU0MTkzZGI1ZQ== */
      node_id: string;
      /**
       * Format: uri
       * @example https://github.com/octocat/Hello-World/commit/6dcb09b5b57875f334f61aebed695e2e4193db5e
       */
      html_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/Hello-World/commits/6dcb09b5b57875f334f61aebed695e2e4193db5e/comments
       */
      comments_url: string;
      commit: {
        /**
         * Format: uri
         * @example https://api.github.com/repos/octocat/Hello-World/commits/6dcb09b5b57875f334f61aebed695e2e4193db5e
         */
        url: string;
        author: components["schemas"]["nullable-git-user"];
        committer: components["schemas"]["nullable-git-user"];
        /** @example Fix all the bugs */
        message: string;
        /** @example 0 */
        comment_count: number;
        tree: {
          /** @example 827efc6d56897b048c772eb4087f854f46256132 */
          sha: string;
          /**
           * Format: uri
           * @example https://api.github.com/repos/octocat/Hello-World/tree/827efc6d56897b048c772eb4087f854f46256132
           */
          url: string;
        };
        verification?: components["schemas"]["verification"];
      };
      author: components["schemas"]["nullable-simple-user"];
      committer: components["schemas"]["nullable-simple-user"];
      parents: {
        /** @example 7638417db6d59f3c431d3e1f261cc637155684cd */
        sha: string;
        /**
         * Format: uri
         * @example https://api.github.com/repos/octocat/Hello-World/commits/7638417db6d59f3c431d3e1f261cc637155684cd
         */
        url: string;
        /**
         * Format: uri
         * @example https://github.com/octocat/Hello-World/commit/7638417db6d59f3c431d3e1f261cc637155684cd
         */
        html_url?: string;
      }[];
      stats?: {
        additions?: number;
        deletions?: number;
        total?: number;
      };
      files?: components["schemas"]["diff-entry"][];
    };
    /**
     * Branch With Protection
     * @description Branch With Protection
     */
    "branch-with-protection": {
      name: string;
      commit: components["schemas"]["commit"];
      _links: {
        html: string;
        /** Format: uri */
        self: string;
      };
      protected: boolean;
      protection: components["schemas"]["branch-protection"];
      /** Format: uri */
      protection_url: string;
      /** @example "mas*" */
      pattern?: string;
      /** @example 1 */
      required_approving_review_count?: number;
    };
    /**
     * Status Check Policy
     * @description Status Check Policy
     */
    "status-check-policy": {
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/Hello-World/branches/master/protection/required_status_checks
       */
      url: string;
      /** @example true */
      strict: boolean;
      /**
       * @example [
       *   "continuous-integration/travis-ci"
       * ]
       */
      contexts: string[];
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/Hello-World/branches/master/protection/required_status_checks/contexts
       */
      contexts_url: string;
    };
    /**
     * Protected Branch
     * @description Branch protections protect branches
     */
    "protected-branch": {
      /** Format: uri */
      url: string;
      required_status_checks?: components["schemas"]["status-check-policy"];
      required_pull_request_reviews?: {
        /** Format: uri */
        url: string;
        dismiss_stale_reviews?: boolean;
        require_code_owner_reviews?: boolean;
        required_approving_review_count?: number;
        dismissal_restrictions?: {
          /** Format: uri */
          url: string;
          /** Format: uri */
          users_url: string;
          /** Format: uri */
          teams_url: string;
          users: components["schemas"]["simple-user"][];
          teams: components["schemas"]["team"][];
          apps?: components["schemas"]["integration"][];
        };
      };
      required_signatures?: {
        /**
         * Format: uri
         * @example https://api.github.com/repos/octocat/Hello-World/branches/master/protection/required_signatures
         */
        url: string;
        /** @example true */
        enabled: boolean;
      };
      enforce_admins?: {
        /** Format: uri */
        url: string;
        enabled: boolean;
      };
      required_linear_history?: {
        enabled: boolean;
      };
      allow_force_pushes?: {
        enabled: boolean;
      };
      allow_deletions?: {
        enabled: boolean;
      };
      restrictions?: components["schemas"]["branch-restriction-policy"];
      required_conversation_resolution?: {
        enabled?: boolean;
      };
      block_creations?: {
        enabled: boolean;
      };
    };
    /**
     * Deployment
     * @description A deployment created as the result of an Actions check run from a workflow that references an environment
     */
    "deployment-simple": {
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/example/deployments/1
       */
      url: string;
      /**
       * @description Unique identifier of the deployment
       * @example 42
       */
      id: number;
      /** @example MDEwOkRlcGxveW1lbnQx */
      node_id: string;
      /**
       * @description Parameter to specify a task to execute
       * @example deploy
       */
      task: string;
      /** @example staging */
      original_environment?: string;
      /**
       * @description Name for the target deployment environment.
       * @example production
       */
      environment: string;
      /** @example Deploy request from hubot */
      description: string | null;
      /**
       * Format: date-time
       * @example 2012-07-20T01:19:13Z
       */
      created_at: string;
      /**
       * Format: date-time
       * @example 2012-07-20T01:19:13Z
       */
      updated_at: string;
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/example/deployments/1/statuses
       */
      statuses_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/example
       */
      repository_url: string;
      /**
       * @description Specifies if the given environment is will no longer exist at some point in the future. Default: false.
       * @example true
       */
      transient_environment?: boolean;
      /**
       * @description Specifies if the given environment is one that end-users directly interact with. Default: false.
       * @example true
       */
      production_environment?: boolean;
      performed_via_github_app?: components["schemas"]["nullable-integration"];
    };
    /**
     * CheckRun
     * @description A check performed on the code of a given code change
     */
    "check-run": {
      /**
       * @description The id of the check.
       * @example 21
       */
      id: number;
      /**
       * @description The SHA of the commit that is being checked.
       * @example 009b8a3a9ccbb128af87f9b1c0f4c62e8a304f6d
       */
      head_sha: string;
      /** @example MDg6Q2hlY2tSdW40 */
      node_id: string;
      /** @example 42 */
      external_id: string | null;
      /** @example https://api.github.com/repos/github/hello-world/check-runs/4 */
      url: string;
      /** @example https://github.com/github/hello-world/runs/4 */
      html_url: string | null;
      /** @example https://example.com */
      details_url: string | null;
      /**
       * @description The phase of the lifecycle that the check is currently in.
       * @example queued
       * @enum {string}
       */
      status: "queued" | "in_progress" | "completed";
      /**
       * @example neutral
       * @enum {string|null}
       */
      conclusion:
        | (
            | "success"
            | "failure"
            | "neutral"
            | "cancelled"
            | "skipped"
            | "timed_out"
            | "action_required"
          )
        | null;
      /**
       * Format: date-time
       * @example 2018-05-04T01:14:52Z
       */
      started_at: string | null;
      /**
       * Format: date-time
       * @example 2018-05-04T01:14:52Z
       */
      completed_at: string | null;
      output: {
        title: string | null;
        summary: string | null;
        text: string | null;
        annotations_count: number;
        /** Format: uri */
        annotations_url: string;
      };
      /**
       * @description The name of the check.
       * @example test-coverage
       */
      name: string;
      check_suite: {
        id: number;
      } | null;
      app: components["schemas"]["nullable-integration"];
      pull_requests: components["schemas"]["pull-request-minimal"][];
      deployment?: components["schemas"]["deployment-simple"];
    };
    /**
     * Check Annotation
     * @description Check Annotation
     */
    "check-annotation": {
      /** @example README.md */
      path: string;
      /** @example 2 */
      start_line: number;
      /** @example 2 */
      end_line: number;
      /** @example 5 */
      start_column: number | null;
      /** @example 10 */
      end_column: number | null;
      /** @example warning */
      annotation_level: string | null;
      /** @example Spell Checker */
      title: string | null;
      /** @example Check your spelling for 'banaas'. */
      message: string | null;
      /** @example Do you mean 'bananas' or 'banana'? */
      raw_details: string | null;
      blob_href: string;
    };
    /**
     * Simple Commit
     * @description Simple Commit
     */
    "simple-commit": {
      id: string;
      tree_id: string;
      message: string;
      /** Format: date-time */
      timestamp: string;
      author: {
        name: string;
        email: string;
      } | null;
      committer: {
        name: string;
        email: string;
      } | null;
    };
    /**
     * CheckSuite
     * @description A suite of checks performed on the code of a given code change
     */
    "check-suite": {
      /** @example 5 */
      id: number;
      /** @example MDEwOkNoZWNrU3VpdGU1 */
      node_id: string;
      /** @example master */
      head_branch: string | null;
      /**
       * @description The SHA of the head commit that is being checked.
       * @example 009b8a3a9ccbb128af87f9b1c0f4c62e8a304f6d
       */
      head_sha: string;
      /**
       * @example completed
       * @enum {string|null}
       */
      status: ("queued" | "in_progress" | "completed") | null;
      /**
       * @example neutral
       * @enum {string|null}
       */
      conclusion:
        | (
            | "success"
            | "failure"
            | "neutral"
            | "cancelled"
            | "skipped"
            | "timed_out"
            | "action_required"
          )
        | null;
      /** @example https://api.github.com/repos/github/hello-world/check-suites/5 */
      url: string | null;
      /** @example 146e867f55c26428e5f9fade55a9bbf5e95a7912 */
      before: string | null;
      /** @example d6fde92930d4715a2b49857d24b940956b26d2d3 */
      after: string | null;
      pull_requests: components["schemas"]["pull-request-minimal"][] | null;
      app: components["schemas"]["nullable-integration"];
      repository: components["schemas"]["minimal-repository"];
      /** Format: date-time */
      created_at: string | null;
      /** Format: date-time */
      updated_at: string | null;
      head_commit: components["schemas"]["simple-commit"];
      latest_check_runs_count: number;
      check_runs_url: string;
      rerequestable?: boolean;
      runs_rerequestable?: boolean;
    };
    /**
     * Check Suite Preference
     * @description Check suite configuration preferences for a repository.
     */
    "check-suite-preference": {
      preferences: {
        auto_trigger_checks?: {
          app_id: number;
          setting: boolean;
        }[];
      };
      repository: components["schemas"]["minimal-repository"];
    };
    /** @description The name of the tool used to generate the code scanning analysis. */
    "code-scanning-analysis-tool-name": string;
    /** @description The GUID of the tool used to generate the code scanning analysis, if provided in the uploaded SARIF data. */
    "code-scanning-analysis-tool-guid": string | null;
    /**
     * @description The full Git reference, formatted as `refs/heads/<branch name>`,
     * `refs/pull/<number>/merge`, or `refs/pull/<number>/head`.
     */
    "code-scanning-ref": string;
    /**
     * @description State of a code scanning alert.
     * @enum {string}
     */
    "code-scanning-alert-state": "open" | "closed" | "dismissed" | "fixed";
    /**
     * Format: uri
     * @description The REST API URL for fetching the list of instances for an alert.
     */
    "alert-instances-url": string;
    /**
     * Format: date-time
     * @description The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    "code-scanning-alert-dismissed-at": string | null;
    /**
     * @description **Required when the state is dismissed.** The reason for dismissing or closing the alert.
     * @enum {string|null}
     */
    "code-scanning-alert-dismissed-reason":
      | (null | "false positive" | "won't fix" | "used in tests")
      | null;
    "code-scanning-alert-rule-summary": {
      /** @description A unique identifier for the rule used to detect the alert. */
      id?: string | null;
      /** @description The name of the rule used to detect the alert. */
      name?: string;
      /**
       * @description The severity of the alert.
       * @enum {string|null}
       */
      severity?: ("none" | "note" | "warning" | "error") | null;
      /** @description A short description of the rule used to detect the alert. */
      description?: string;
    };
    /** @description The version of the tool used to generate the code scanning analysis. */
    "code-scanning-analysis-tool-version": string | null;
    "code-scanning-analysis-tool": {
      name?: components["schemas"]["code-scanning-analysis-tool-name"];
      version?: components["schemas"]["code-scanning-analysis-tool-version"];
      guid?: components["schemas"]["code-scanning-analysis-tool-guid"];
    };
    /** @description Identifies the configuration under which the analysis was executed. For example, in GitHub Actions this includes the workflow filename and job name. */
    "code-scanning-analysis-analysis-key": string;
    /** @description Identifies the variable values associated with the environment in which the analysis that generated this alert instance was performed, such as the language that was analyzed. */
    "code-scanning-alert-environment": string;
    /** @description Identifies the configuration under which the analysis was executed. Used to distinguish between multiple analyses for the same tool and commit, but performed on different languages or different parts of the code. */
    "code-scanning-analysis-category": string;
    /** @description Describe a region within a file for the alert. */
    "code-scanning-alert-location": {
      path?: string;
      start_line?: number;
      end_line?: number;
      start_column?: number;
      end_column?: number;
    };
    /**
     * @description A classification of the file. For example to identify it as generated.
     * @enum {string|null}
     */
    "code-scanning-alert-classification":
      | ("source" | "generated" | "test" | "library")
      | null;
    "code-scanning-alert-instance": {
      ref?: components["schemas"]["code-scanning-ref"];
      analysis_key?: components["schemas"]["code-scanning-analysis-analysis-key"];
      environment?: components["schemas"]["code-scanning-alert-environment"];
      category?: components["schemas"]["code-scanning-analysis-category"];
      state?: components["schemas"]["code-scanning-alert-state"];
      commit_sha?: string;
      message?: {
        text?: string;
      };
      location?: components["schemas"]["code-scanning-alert-location"];
      html_url?: string;
      /**
       * @description Classifications that have been applied to the file that triggered the alert.
       * For example identifying it as documentation, or a generated file.
       */
      classifications?: components["schemas"]["code-scanning-alert-classification"][];
    };
    "code-scanning-alert-items": {
      number: components["schemas"]["alert-number"];
      created_at: components["schemas"]["alert-created-at"];
      url: components["schemas"]["alert-url"];
      html_url: components["schemas"]["alert-html-url"];
      instances_url: components["schemas"]["alert-instances-url"];
      state: components["schemas"]["code-scanning-alert-state"];
      dismissed_by: components["schemas"]["nullable-simple-user"];
      dismissed_at: components["schemas"]["code-scanning-alert-dismissed-at"];
      dismissed_reason: components["schemas"]["code-scanning-alert-dismissed-reason"];
      rule: components["schemas"]["code-scanning-alert-rule-summary"];
      tool: components["schemas"]["code-scanning-analysis-tool"];
      most_recent_instance: components["schemas"]["code-scanning-alert-instance"];
    };
    "code-scanning-alert-rule": {
      /** @description A unique identifier for the rule used to detect the alert. */
      id?: string | null;
      /** @description The name of the rule used to detect the alert. */
      name?: string;
      /**
       * @description The severity of the alert.
       * @enum {string|null}
       */
      severity?: ("none" | "note" | "warning" | "error") | null;
      /**
       * @description The security severity of the alert.
       * @enum {string|null}
       */
      security_severity_level?: ("low" | "medium" | "high" | "critical") | null;
      /** @description A short description of the rule used to detect the alert. */
      description?: string;
      /** @description description of the rule used to detect the alert. */
      full_description?: string;
      /** @description A set of tags applicable for the rule. */
      tags?: string[] | null;
      /** @description Detailed documentation for the rule as GitHub Flavored Markdown. */
      help?: string | null;
      /** @description A link to the documentation for the rule used to detect the alert. */
      help_uri?: string | null;
    };
    "code-scanning-alert": {
      number: components["schemas"]["alert-number"];
      created_at: components["schemas"]["alert-created-at"];
      url: components["schemas"]["alert-url"];
      html_url: components["schemas"]["alert-html-url"];
      instances_url: components["schemas"]["alert-instances-url"];
      state: components["schemas"]["code-scanning-alert-state"];
      dismissed_by: components["schemas"]["nullable-simple-user"];
      dismissed_at: components["schemas"]["code-scanning-alert-dismissed-at"];
      dismissed_reason: components["schemas"]["code-scanning-alert-dismissed-reason"];
      rule: components["schemas"]["code-scanning-alert-rule"];
      tool: components["schemas"]["code-scanning-analysis-tool"];
      most_recent_instance: components["schemas"]["code-scanning-alert-instance"];
    };
    /**
     * @description Sets the state of the code scanning alert. You must provide `dismissed_reason` when you set the state to `dismissed`.
     * @enum {string}
     */
    "code-scanning-alert-set-state": "open" | "dismissed";
    /**
     * @description An identifier for the upload.
     * @example 6c81cd8e-b078-4ac3-a3be-1dad7dbd0b53
     */
    "code-scanning-analysis-sarif-id": string;
    /** @description The SHA of the commit to which the analysis you are uploading relates. */
    "code-scanning-analysis-commit-sha": string;
    /** @description Identifies the variable values associated with the environment in which this analysis was performed. */
    "code-scanning-analysis-environment": string;
    /**
     * Format: date-time
     * @description The time that the analysis was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    "code-scanning-analysis-created-at": string;
    /**
     * Format: uri
     * @description The REST API URL of the analysis resource.
     */
    "code-scanning-analysis-url": string;
    "code-scanning-analysis": {
      ref: components["schemas"]["code-scanning-ref"];
      commit_sha: components["schemas"]["code-scanning-analysis-commit-sha"];
      analysis_key: components["schemas"]["code-scanning-analysis-analysis-key"];
      environment: components["schemas"]["code-scanning-analysis-environment"];
      category?: components["schemas"]["code-scanning-analysis-category"];
      /** @example error reading field xyz */
      error: string;
      created_at: components["schemas"]["code-scanning-analysis-created-at"];
      /** @description The total number of results in the analysis. */
      results_count: number;
      /** @description The total number of rules used in the analysis. */
      rules_count: number;
      /** @description Unique identifier for this analysis. */
      id: number;
      url: components["schemas"]["code-scanning-analysis-url"];
      sarif_id: components["schemas"]["code-scanning-analysis-sarif-id"];
      tool: components["schemas"]["code-scanning-analysis-tool"];
      deletable: boolean;
      /**
       * @description Warning generated when processing the analysis
       * @example 123 results were ignored
       */
      warning: string;
    };
    /**
     * Analysis deletion
     * @description Successful deletion of a code scanning analysis
     */
    "code-scanning-analysis-deletion": {
      /**
       * Format: uri
       * @description Next deletable analysis in chain, without last analysis deletion confirmation
       */
      next_analysis_url: string | null;
      /**
       * Format: uri
       * @description Next deletable analysis in chain, with last analysis deletion confirmation
       */
      confirm_delete_url: string | null;
    };
    /** @description A Base64 string representing the SARIF file to upload. You must first compress your SARIF file using [`gzip`](http://www.gnu.org/software/gzip/manual/gzip.html) and then translate the contents of the file into a Base64 encoding string. For more information, see "[SARIF support for code scanning](https://docs.github.com/enterprise-server@3.3/code-security/secure-coding/sarif-support-for-code-scanning)." */
    "code-scanning-analysis-sarif-file": string;
    "code-scanning-sarifs-receipt": {
      id?: components["schemas"]["code-scanning-analysis-sarif-id"];
      /**
       * Format: uri
       * @description The REST API URL for checking the status of the upload.
       */
      url?: string;
    };
    "code-scanning-sarifs-status": {
      /**
       * @description `pending` files have not yet been processed, while `complete` means all results in the SARIF have been stored.
       * @enum {string}
       */
      processing_status?: "pending" | "complete";
      /**
       * Format: uri
       * @description The REST API URL for getting the analyses associated with the upload.
       */
      analyses_url?: string | null;
    };
    /**
     * Collaborator
     * @description Collaborator
     */
    collaborator: {
      /** @example octocat */
      login: string;
      /** @example 1 */
      id: number;
      email?: string | null;
      name?: string | null;
      /** @example MDQ6VXNlcjE= */
      node_id: string;
      /**
       * Format: uri
       * @example https://github.com/images/error/octocat_happy.gif
       */
      avatar_url: string;
      /** @example 41d064eb2195891e12d0413f63227ea7 */
      gravatar_id: string | null;
      /**
       * Format: uri
       * @example https://api.github.com/users/octocat
       */
      url: string;
      /**
       * Format: uri
       * @example https://github.com/octocat
       */
      html_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/users/octocat/followers
       */
      followers_url: string;
      /** @example https://api.github.com/users/octocat/following{/other_user} */
      following_url: string;
      /** @example https://api.github.com/users/octocat/gists{/gist_id} */
      gists_url: string;
      /** @example https://api.github.com/users/octocat/starred{/owner}{/repo} */
      starred_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/users/octocat/subscriptions
       */
      subscriptions_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/users/octocat/orgs
       */
      organizations_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/users/octocat/repos
       */
      repos_url: string;
      /** @example https://api.github.com/users/octocat/events{/privacy} */
      events_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/users/octocat/received_events
       */
      received_events_url: string;
      /** @example User */
      type: string;
      site_admin: boolean;
      permissions?: {
        pull: boolean;
        triage?: boolean;
        push: boolean;
        maintain?: boolean;
        admin: boolean;
      };
    };
    /**
     * Repository Invitation
     * @description Repository invitations let you manage who you collaborate with.
     */
    "repository-invitation": {
      /**
       * @description Unique identifier of the repository invitation.
       * @example 42
       */
      id: number;
      repository: components["schemas"]["minimal-repository"];
      invitee: components["schemas"]["nullable-simple-user"];
      inviter: components["schemas"]["nullable-simple-user"];
      /**
       * @description The permission associated with the invitation.
       * @example read
       * @enum {string}
       */
      permissions: "read" | "write" | "admin" | "triage" | "maintain";
      /**
       * Format: date-time
       * @example 2016-06-13T14:52:50-05:00
       */
      created_at: string;
      /** @description Whether or not the invitation has expired */
      expired?: boolean;
      /**
       * @description URL for the repository invitation
       * @example https://api.github.com/user/repository-invitations/1
       */
      url: string;
      /** @example https://github.com/octocat/Hello-World/invitations */
      html_url: string;
      node_id: string;
    };
    /**
     * Collaborator
     * @description Collaborator
     */
    "nullable-collaborator": {
      /** @example octocat */
      login: string;
      /** @example 1 */
      id: number;
      email?: string | null;
      name?: string | null;
      /** @example MDQ6VXNlcjE= */
      node_id: string;
      /**
       * Format: uri
       * @example https://github.com/images/error/octocat_happy.gif
       */
      avatar_url: string;
      /** @example 41d064eb2195891e12d0413f63227ea7 */
      gravatar_id: string | null;
      /**
       * Format: uri
       * @example https://api.github.com/users/octocat
       */
      url: string;
      /**
       * Format: uri
       * @example https://github.com/octocat
       */
      html_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/users/octocat/followers
       */
      followers_url: string;
      /** @example https://api.github.com/users/octocat/following{/other_user} */
      following_url: string;
      /** @example https://api.github.com/users/octocat/gists{/gist_id} */
      gists_url: string;
      /** @example https://api.github.com/users/octocat/starred{/owner}{/repo} */
      starred_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/users/octocat/subscriptions
       */
      subscriptions_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/users/octocat/orgs
       */
      organizations_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/users/octocat/repos
       */
      repos_url: string;
      /** @example https://api.github.com/users/octocat/events{/privacy} */
      events_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/users/octocat/received_events
       */
      received_events_url: string;
      /** @example User */
      type: string;
      site_admin: boolean;
      permissions?: {
        pull: boolean;
        triage?: boolean;
        push: boolean;
        maintain?: boolean;
        admin: boolean;
      };
    } | null;
    /**
     * Repository Collaborator Permission
     * @description Repository Collaborator Permission
     */
    "repository-collaborator-permission": {
      permission: string;
      user: components["schemas"]["nullable-collaborator"];
    };
    /**
     * Commit Comment
     * @description Commit Comment
     */
    "commit-comment": {
      /** Format: uri */
      html_url: string;
      /** Format: uri */
      url: string;
      id: number;
      node_id: string;
      body: string;
      path: string | null;
      position: number | null;
      line: number | null;
      commit_id: string;
      user: components["schemas"]["nullable-simple-user"];
      /** Format: date-time */
      created_at: string;
      /** Format: date-time */
      updated_at: string;
      author_association: components["schemas"]["author-association"];
      reactions?: components["schemas"]["reaction-rollup"];
    };
    /**
     * Branch Short
     * @description Branch Short
     */
    "branch-short": {
      name: string;
      commit: {
        sha: string;
        url: string;
      };
      protected: boolean;
    };
    /**
     * Link
     * @description Hypermedia Link
     */
    link: {
      href: string;
    };
    /**
     * Auto merge
     * @description The status of auto merging a pull request.
     */
    "auto-merge": {
      enabled_by: components["schemas"]["simple-user"];
      /**
       * @description The merge method to use.
       * @enum {string}
       */
      merge_method: "merge" | "squash" | "rebase";
      /** @description Title for the merge commit message. */
      commit_title: string;
      /** @description Commit message for the merge commit. */
      commit_message: string;
    } | null;
    /**
     * Pull Request Simple
     * @description Pull Request Simple
     */
    "pull-request-simple": {
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/Hello-World/pulls/1347
       */
      url: string;
      /** @example 1 */
      id: number;
      /** @example MDExOlB1bGxSZXF1ZXN0MQ== */
      node_id: string;
      /**
       * Format: uri
       * @example https://github.com/octocat/Hello-World/pull/1347
       */
      html_url: string;
      /**
       * Format: uri
       * @example https://github.com/octocat/Hello-World/pull/1347.diff
       */
      diff_url: string;
      /**
       * Format: uri
       * @example https://github.com/octocat/Hello-World/pull/1347.patch
       */
      patch_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/Hello-World/issues/1347
       */
      issue_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/Hello-World/pulls/1347/commits
       */
      commits_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/Hello-World/pulls/1347/comments
       */
      review_comments_url: string;
      /** @example https://api.github.com/repos/octocat/Hello-World/pulls/comments{/number} */
      review_comment_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/Hello-World/issues/1347/comments
       */
      comments_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/Hello-World/statuses/6dcb09b5b57875f334f61aebed695e2e4193db5e
       */
      statuses_url: string;
      /** @example 1347 */
      number: number;
      /** @example open */
      state: string;
      /** @example true */
      locked: boolean;
      /** @example new-feature */
      title: string;
      user: components["schemas"]["nullable-simple-user"];
      /** @example Please pull these awesome changes */
      body: string | null;
      labels: {
        /** Format: int64 */
        id: number;
        node_id: string;
        url: string;
        name: string;
        description: string;
        color: string;
        default: boolean;
      }[];
      milestone: components["schemas"]["nullable-milestone"];
      /** @example too heated */
      active_lock_reason?: string | null;
      /**
       * Format: date-time
       * @example 2011-01-26T19:01:12Z
       */
      created_at: string;
      /**
       * Format: date-time
       * @example 2011-01-26T19:01:12Z
       */
      updated_at: string;
      /**
       * Format: date-time
       * @example 2011-01-26T19:01:12Z
       */
      closed_at: string | null;
      /**
       * Format: date-time
       * @example 2011-01-26T19:01:12Z
       */
      merged_at: string | null;
      /** @example e5bd3914e2e596debea16f433f57875b5b90bcd6 */
      merge_commit_sha: string | null;
      assignee: components["schemas"]["nullable-simple-user"];
      assignees?: components["schemas"]["simple-user"][] | null;
      requested_reviewers?: components["schemas"]["simple-user"][] | null;
      requested_teams?: components["schemas"]["team"][] | null;
      head: {
        label: string;
        ref: string;
        repo: components["schemas"]["repository"];
        sha: string;
        user: components["schemas"]["nullable-simple-user"];
      };
      base: {
        label: string;
        ref: string;
        repo: components["schemas"]["repository"];
        sha: string;
        user: components["schemas"]["nullable-simple-user"];
      };
      _links: {
        comments: components["schemas"]["link"];
        commits: components["schemas"]["link"];
        statuses: components["schemas"]["link"];
        html: components["schemas"]["link"];
        issue: components["schemas"]["link"];
        review_comments: components["schemas"]["link"];
        review_comment: components["schemas"]["link"];
        self: components["schemas"]["link"];
      };
      author_association: components["schemas"]["author-association"];
      auto_merge: components["schemas"]["auto-merge"];
      /**
       * @description Indicates whether or not the pull request is a draft.
       * @example false
       */
      draft?: boolean;
    };
    /** Simple Commit Status */
    "simple-commit-status": {
      description: string | null;
      id: number;
      node_id: string;
      state: string;
      context: string;
      /** Format: uri */
      target_url: string | null;
      required?: boolean | null;
      /** Format: uri */
      avatar_url: string | null;
      /** Format: uri */
      url: string;
      /** Format: date-time */
      created_at: string;
      /** Format: date-time */
      updated_at: string;
    };
    /**
     * Combined Commit Status
     * @description Combined Commit Status
     */
    "combined-commit-status": {
      state: string;
      statuses: components["schemas"]["simple-commit-status"][];
      sha: string;
      total_count: number;
      repository: components["schemas"]["minimal-repository"];
      /** Format: uri */
      commit_url: string;
      /** Format: uri */
      url: string;
    };
    /**
     * Status
     * @description The status of a commit.
     */
    status: {
      url: string;
      avatar_url: string | null;
      id: number;
      node_id: string;
      state: string;
      description: string | null;
      target_url: string | null;
      context: string;
      created_at: string;
      updated_at: string;
      creator: components["schemas"]["nullable-simple-user"];
    };
    /**
     * Commit Comparison
     * @description Commit Comparison
     */
    "commit-comparison": {
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/Hello-World/compare/master...topic
       */
      url: string;
      /**
       * Format: uri
       * @example https://github.com/octocat/Hello-World/compare/master...topic
       */
      html_url: string;
      /**
       * Format: uri
       * @example https://github.com/octocat/Hello-World/compare/octocat:bbcd538c8e72b8c175046e27cc8f907076331401...octocat:0328041d1152db8ae77652d1618a02e57f745f17
       */
      permalink_url: string;
      /**
       * Format: uri
       * @example https://github.com/octocat/Hello-World/compare/master...topic.diff
       */
      diff_url: string;
      /**
       * Format: uri
       * @example https://github.com/octocat/Hello-World/compare/master...topic.patch
       */
      patch_url: string;
      base_commit: components["schemas"]["commit"];
      merge_base_commit: components["schemas"]["commit"];
      /**
       * @example ahead
       * @enum {string}
       */
      status: "diverged" | "ahead" | "behind" | "identical";
      /** @example 4 */
      ahead_by: number;
      /** @example 5 */
      behind_by: number;
      /** @example 6 */
      total_commits: number;
      commits: components["schemas"]["commit"][];
      files?: components["schemas"]["diff-entry"][];
    };
    /**
     * ContentReferenceAttachment
     * @description Content Reference attachments allow you to provide context around URLs posted in comments
     */
    "content-reference-attachment": {
      /**
       * @description The ID of the attachment
       * @example 21
       */
      id: number;
      /**
       * @description The title of the attachment
       * @example Title of the attachment
       */
      title: string;
      /**
       * @description The body of the attachment
       * @example Body of the attachment
       */
      body: string;
      /**
       * @description The node_id of the content attachment
       * @example MDE3OkNvbnRlbnRBdHRhY2htZW50MjE=
       */
      node_id?: string;
    };
    /**
     * Content Tree
     * @description Content Tree
     */
    "content-tree": {
      type: string;
      size: number;
      name: string;
      path: string;
      sha: string;
      /** Format: uri */
      url: string;
      /** Format: uri */
      git_url: string | null;
      /** Format: uri */
      html_url: string | null;
      /** Format: uri */
      download_url: string | null;
      entries?: {
        type: string;
        size: number;
        name: string;
        path: string;
        content?: string;
        sha: string;
        /** Format: uri */
        url: string;
        /** Format: uri */
        git_url: string | null;
        /** Format: uri */
        html_url: string | null;
        /** Format: uri */
        download_url: string | null;
        _links: {
          /** Format: uri */
          git: string | null;
          /** Format: uri */
          html: string | null;
          /** Format: uri */
          self: string;
        };
      }[];
      _links: {
        /** Format: uri */
        git: string | null;
        /** Format: uri */
        html: string | null;
        /** Format: uri */
        self: string;
      };
    } & {
      content: unknown;
      encoding: unknown;
    };
    /**
     * Content Directory
     * @description A list of directory items
     */
    "content-directory": {
      /** @enum {string} */
      type: "dir" | "file" | "submodule" | "symlink";
      size: number;
      name: string;
      path: string;
      content?: string;
      sha: string;
      /** Format: uri */
      url: string;
      /** Format: uri */
      git_url: string | null;
      /** Format: uri */
      html_url: string | null;
      /** Format: uri */
      download_url: string | null;
      _links: {
        /** Format: uri */
        git: string | null;
        /** Format: uri */
        html: string | null;
        /** Format: uri */
        self: string;
      };
    }[];
    /**
     * Content File
     * @description Content File
     */
    "content-file": {
      /** @enum {string} */
      type: "file";
      encoding: string;
      size: number;
      name: string;
      path: string;
      content: string;
      sha: string;
      /** Format: uri */
      url: string;
      /** Format: uri */
      git_url: string | null;
      /** Format: uri */
      html_url: string | null;
      /** Format: uri */
      download_url: string | null;
      _links: {
        /** Format: uri */
        git: string | null;
        /** Format: uri */
        html: string | null;
        /** Format: uri */
        self: string;
      };
      /** @example "actual/actual.md" */
      target?: string;
      /** @example "git://example.com/defunkt/dotjs.git" */
      submodule_git_url?: string;
    };
    /**
     * Symlink Content
     * @description An object describing a symlink
     */
    "content-symlink": {
      /** @enum {string} */
      type: "symlink";
      target: string;
      size: number;
      name: string;
      path: string;
      sha: string;
      /** Format: uri */
      url: string;
      /** Format: uri */
      git_url: string | null;
      /** Format: uri */
      html_url: string | null;
      /** Format: uri */
      download_url: string | null;
      _links: {
        /** Format: uri */
        git: string | null;
        /** Format: uri */
        html: string | null;
        /** Format: uri */
        self: string;
      };
    };
    /**
     * Submodule Content
     * @description An object describing a submodule
     */
    "content-submodule": {
      /** @enum {string} */
      type: "submodule";
      /** Format: uri */
      submodule_git_url: string;
      size: number;
      name: string;
      path: string;
      sha: string;
      /** Format: uri */
      url: string;
      /** Format: uri */
      git_url: string | null;
      /** Format: uri */
      html_url: string | null;
      /** Format: uri */
      download_url: string | null;
      _links: {
        /** Format: uri */
        git: string | null;
        /** Format: uri */
        html: string | null;
        /** Format: uri */
        self: string;
      };
    };
    /**
     * File Commit
     * @description File Commit
     */
    "file-commit": {
      content: {
        name?: string;
        path?: string;
        sha?: string;
        size?: number;
        url?: string;
        html_url?: string;
        git_url?: string;
        download_url?: string;
        type?: string;
        _links?: {
          self?: string;
          git?: string;
          html?: string;
        };
      } | null;
      commit: {
        sha?: string;
        node_id?: string;
        url?: string;
        html_url?: string;
        author?: {
          date?: string;
          name?: string;
          email?: string;
        };
        committer?: {
          date?: string;
          name?: string;
          email?: string;
        };
        message?: string;
        tree?: {
          url?: string;
          sha?: string;
        };
        parents?: {
          url?: string;
          html_url?: string;
          sha?: string;
        }[];
        verification?: {
          verified?: boolean;
          reason?: string;
          signature?: string | null;
          payload?: string | null;
        };
      };
    };
    /**
     * Contributor
     * @description Contributor
     */
    contributor: {
      login?: string;
      id?: number;
      node_id?: string;
      /** Format: uri */
      avatar_url?: string;
      gravatar_id?: string | null;
      /** Format: uri */
      url?: string;
      /** Format: uri */
      html_url?: string;
      /** Format: uri */
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      starred_url?: string;
      /** Format: uri */
      subscriptions_url?: string;
      /** Format: uri */
      organizations_url?: string;
      /** Format: uri */
      repos_url?: string;
      events_url?: string;
      /** Format: uri */
      received_events_url?: string;
      type: string;
      site_admin?: boolean;
      contributions: number;
      email?: string;
      name?: string;
    };
    /**
     * Deployment Status
     * @description The status of a deployment.
     */
    "deployment-status": {
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/example/deployments/42/statuses/1
       */
      url: string;
      /** @example 1 */
      id: number;
      /** @example MDE2OkRlcGxveW1lbnRTdGF0dXMx */
      node_id: string;
      /**
       * @description The state of the status.
       * @example success
       * @enum {string}
       */
      state:
        | "error"
        | "failure"
        | "inactive"
        | "pending"
        | "success"
        | "queued"
        | "in_progress";
      creator: components["schemas"]["nullable-simple-user"];
      /**
       * @description A short description of the status.
       * @default
       * @example Deployment finished successfully.
       */
      description: string;
      /**
       * @description The environment of the deployment that the status is for.
       * @default
       * @example production
       */
      environment?: string;
      /**
       * Format: uri
       * @description Deprecated: the URL to associate with this status.
       * @default
       * @example https://example.com/deployment/42/output
       */
      target_url: string;
      /**
       * Format: date-time
       * @example 2012-07-20T01:19:13Z
       */
      created_at: string;
      /**
       * Format: date-time
       * @example 2012-07-20T01:19:13Z
       */
      updated_at: string;
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/example/deployments/42
       */
      deployment_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/example
       */
      repository_url: string;
      /**
       * Format: uri
       * @description The URL for accessing your environment.
       * @default
       * @example https://staging.example.com/
       */
      environment_url?: string;
      /**
       * Format: uri
       * @description The URL to associate with this status.
       * @default
       * @example https://example.com/deployment/42/output
       */
      log_url?: string;
      performed_via_github_app?: components["schemas"]["nullable-integration"];
    };
    /**
     * @description The amount of time to delay a job after the job is initially triggered. The time (in minutes) must be an integer between 0 and 43,200 (30 days).
     * @example 30
     */
    "wait-timer": number;
    /** @description The type of deployment branch policy for this environment. To allow all branches to deploy, set to `null`. */
    "deployment-branch-policy-settings": {
      /** @description Whether only branches with branch protection rules can deploy to this environment. If `protected_branches` is `true`, `custom_branch_policies` must be `false`; if `protected_branches` is `false`, `custom_branch_policies` must be `true`. */
      protected_branches: boolean;
      /** @description Whether only branches that match the specified name patterns can deploy to this environment.  If `custom_branch_policies` is `true`, `protected_branches` must be `false`; if `custom_branch_policies` is `false`, `protected_branches` must be `true`. */
      custom_branch_policies: boolean;
    } | null;
    /**
     * Environment
     * @description Details of a deployment environment
     */
    environment: {
      /**
       * @description The id of the environment.
       * @example 56780428
       */
      id: number;
      /** @example MDExOkVudmlyb25tZW50NTY3ODA0Mjg= */
      node_id: string;
      /**
       * @description The name of the environment.
       * @example staging
       */
      name: string;
      /** @example https://api.github.com/repos/github/hello-world/environments/staging */
      url: string;
      /** @example https://github.com/github/hello-world/deployments/activity_log?environments_filter=staging */
      html_url: string;
      /**
       * Format: date-time
       * @description The time that the environment was created, in ISO 8601 format.
       * @example 2020-11-23T22:00:40Z
       */
      created_at: string;
      /**
       * Format: date-time
       * @description The time that the environment was last updated, in ISO 8601 format.
       * @example 2020-11-23T22:00:40Z
       */
      updated_at: string;
      protection_rules?: (Partial<{
        /** @example 3515 */
        id: number;
        /** @example MDQ6R2F0ZTM1MTU= */
        node_id: string;
        /** @example wait_timer */
        type: string;
        wait_timer?: components["schemas"]["wait-timer"];
      }> &
        Partial<{
          /** @example 3755 */
          id: number;
          /** @example MDQ6R2F0ZTM3NTU= */
          node_id: string;
          /** @example required_reviewers */
          type: string;
          /** @description The people or teams that may approve jobs that reference the environment. You can list up to six users or teams as reviewers. The reviewers must have at least read access to the repository. Only one of the required reviewers needs to approve the job for it to proceed. */
          reviewers?: {
            type?: components["schemas"]["deployment-reviewer-type"];
            reviewer?: Partial<components["schemas"]["simple-user"]> &
              Partial<components["schemas"]["team"]>;
          }[];
        }> &
        Partial<{
          /** @example 3515 */
          id: number;
          /** @example MDQ6R2F0ZTM1MTU= */
          node_id: string;
          /** @example branch_policy */
          type: string;
        }>)[];
      deployment_branch_policy?: components["schemas"]["deployment-branch-policy-settings"];
    };
    /**
     * Deployment branch policy
     * @description Details of a deployment branch policy.
     */
    "deployment-branch-policy": {
      /**
       * @description The unique identifier of the branch policy.
       * @example 361471
       */
      id?: number;
      /** @example MDE2OkdhdGVCcmFuY2hQb2xpY3kzNjE0NzE= */
      node_id?: string;
      /**
       * @description The name pattern that branches must match in order to deploy to the environment.
       * @example release/*
       */
      name?: string;
    };
    /** Deployment branch policy name pattern */
    "deployment-branch-policy-name-pattern": {
      /**
       * @description The name pattern that branches must match in order to deploy to the environment.
       *
       * Wildcard characters will not match `/`. For example, to match branches that begin with `release/` and contain an additional single slash, use `release/*\/*`.
       * For more information about pattern matching syntax, see the [Ruby File.fnmatch documentation](https://ruby-doc.org/core-2.5.1/File.html#method-c-fnmatch).
       * @example release/*
       */
      name: string;
    };
    /**
     * Short Blob
     * @description Short Blob
     */
    "short-blob": {
      url: string;
      sha: string;
    };
    /**
     * Blob
     * @description Blob
     */
    blob: {
      content: string;
      encoding: string;
      /** Format: uri */
      url: string;
      sha: string;
      size: number | null;
      node_id: string;
      highlighted_content?: string;
    };
    /**
     * Git Commit
     * @description Low-level Git commit operations within a repository
     */
    "git-commit": {
      /**
       * @description SHA for the commit
       * @example 7638417db6d59f3c431d3e1f261cc637155684cd
       */
      sha: string;
      node_id: string;
      /** Format: uri */
      url: string;
      /** @description Identifying information for the git-user */
      author: {
        /**
         * Format: date-time
         * @description Timestamp of the commit
         * @example 2014-08-09T08:02:04+12:00
         */
        date: string;
        /**
         * @description Git email address of the user
         * @example monalisa.octocat@example.com
         */
        email: string;
        /**
         * @description Name of the git user
         * @example Monalisa Octocat
         */
        name: string;
      };
      /** @description Identifying information for the git-user */
      committer: {
        /**
         * Format: date-time
         * @description Timestamp of the commit
         * @example 2014-08-09T08:02:04+12:00
         */
        date: string;
        /**
         * @description Git email address of the user
         * @example monalisa.octocat@example.com
         */
        email: string;
        /**
         * @description Name of the git user
         * @example Monalisa Octocat
         */
        name: string;
      };
      /**
       * @description Message describing the purpose of the commit
       * @example Fix #42
       */
      message: string;
      tree: {
        /**
         * @description SHA for the commit
         * @example 7638417db6d59f3c431d3e1f261cc637155684cd
         */
        sha: string;
        /** Format: uri */
        url: string;
      };
      parents: {
        /**
         * @description SHA for the commit
         * @example 7638417db6d59f3c431d3e1f261cc637155684cd
         */
        sha: string;
        /** Format: uri */
        url: string;
        /** Format: uri */
        html_url: string;
      }[];
      verification: {
        verified: boolean;
        reason: string;
        signature: string | null;
        payload: string | null;
      };
      /** Format: uri */
      html_url: string;
    };
    /**
     * Git Reference
     * @description Git references within a repository
     */
    "git-ref": {
      ref: string;
      node_id: string;
      /** Format: uri */
      url: string;
      object: {
        type: string;
        /**
         * @description SHA for the reference
         * @example 7638417db6d59f3c431d3e1f261cc637155684cd
         */
        sha: string;
        /** Format: uri */
        url: string;
      };
    };
    /**
     * Git Tag
     * @description Metadata for a Git tag
     */
    "git-tag": {
      /** @example MDM6VGFnOTQwYmQzMzYyNDhlZmFlMGY5ZWU1YmM3YjJkNWM5ODU4ODdiMTZhYw== */
      node_id: string;
      /**
       * @description Name of the tag
       * @example v0.0.1
       */
      tag: string;
      /** @example 940bd336248efae0f9ee5bc7b2d5c985887b16ac */
      sha: string;
      /**
       * Format: uri
       * @description URL for the tag
       * @example https://api.github.com/repositories/42/git/tags/940bd336248efae0f9ee5bc7b2d5c985887b16ac
       */
      url: string;
      /**
       * @description Message describing the purpose of the tag
       * @example Initial public release
       */
      message: string;
      tagger: {
        date: string;
        email: string;
        name: string;
      };
      object: {
        sha: string;
        type: string;
        /** Format: uri */
        url: string;
      };
      verification?: components["schemas"]["verification"];
    };
    /**
     * Git Tree
     * @description The hierarchy between files in a Git repository.
     */
    "git-tree": {
      sha: string;
      /** Format: uri */
      url: string;
      truncated: boolean;
      /**
       * @description Objects specifying a tree structure
       * @example [
       *   {
       *     "path": "file.rb",
       *     "mode": "100644",
       *     "type": "blob",
       *     "size": 30,
       *     "sha": "44b4fc6d56897b048c772eb4087f854f46256132",
       *     "url": "https://api.github.com/repos/octocat/Hello-World/git/blobs/44b4fc6d56897b048c772eb4087f854f46256132",
       *     "properties": {
       *       "path": {
       *         "type": "string"
       *       },
       *       "mode": {
       *         "type": "string"
       *       },
       *       "type": {
       *         "type": "string"
       *       },
       *       "size": {
       *         "type": "integer"
       *       },
       *       "sha": {
       *         "type": "string"
       *       },
       *       "url": {
       *         "type": "string"
       *       }
       *     },
       *     "required": [
       *       "path",
       *       "mode",
       *       "type",
       *       "sha",
       *       "url",
       *       "size"
       *     ]
       *   }
       * ]
       */
      tree: {
        /** @example test/file.rb */
        path?: string;
        /** @example 040000 */
        mode?: string;
        /** @example tree */
        type?: string;
        /** @example 23f6827669e43831def8a7ad935069c8bd418261 */
        sha?: string;
        /** @example 12 */
        size?: number;
        /** @example https://api.github.com/repos/owner-482f3203ecf01f67e9deb18e/BBB_Private_Repo/git/blobs/23f6827669e43831def8a7ad935069c8bd418261 */
        url?: string;
      }[];
    };
    /** Hook Response */
    "hook-response": {
      code: number | null;
      status: string | null;
      message: string | null;
    };
    /**
     * Webhook
     * @description Webhooks for repositories.
     */
    hook: {
      type: string;
      /**
       * @description Unique identifier of the webhook.
       * @example 42
       */
      id: number;
      /**
       * @description The name of a valid service, use 'web' for a webhook.
       * @example web
       */
      name: string;
      /**
       * @description Determines whether the hook is actually triggered on pushes.
       * @example true
       */
      active: boolean;
      /**
       * @description Determines what events the hook is triggered for. Default: ['push'].
       * @example [
       *   "push",
       *   "pull_request"
       * ]
       */
      events: string[];
      config: {
        /** @example "foo@bar.com" */
        email?: string;
        /** @example "foo" */
        password?: string;
        /** @example "roomer" */
        room?: string;
        /** @example "foo" */
        subdomain?: string;
        url?: components["schemas"]["webhook-config-url"];
        insecure_ssl?: components["schemas"]["webhook-config-insecure-ssl"];
        content_type?: components["schemas"]["webhook-config-content-type"];
        /** @example "sha256" */
        digest?: string;
        secret?: components["schemas"]["webhook-config-secret"];
        /** @example "abc" */
        token?: string;
      };
      /**
       * Format: date-time
       * @example 2011-09-06T20:39:23Z
       */
      updated_at: string;
      /**
       * Format: date-time
       * @example 2011-09-06T17:26:27Z
       */
      created_at: string;
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/Hello-World/hooks/1
       */
      url: string;
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/Hello-World/hooks/1/test
       */
      test_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/Hello-World/hooks/1/pings
       */
      ping_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/Hello-World/hooks/1/deliveries
       */
      deliveries_url?: string;
      last_response: components["schemas"]["hook-response"];
    };
    /**
     * Issue
     * @description Issues are a great way to keep track of tasks, enhancements, and bugs for your projects.
     */
    "nullable-issue": {
      id: number;
      node_id: string;
      /**
       * Format: uri
       * @description URL for the issue
       * @example https://api.github.com/repositories/42/issues/1
       */
      url: string;
      /** Format: uri */
      repository_url: string;
      labels_url: string;
      /** Format: uri */
      comments_url: string;
      /** Format: uri */
      events_url: string;
      /** Format: uri */
      html_url: string;
      /**
       * @description Number uniquely identifying the issue within its repository
       * @example 42
       */
      number: number;
      /**
       * @description State of the issue; either 'open' or 'closed'
       * @example open
       */
      state: string;
      /**
       * @description The reason for the current state
       * @example not_planned
       * @enum {string|null}
       */
      state_reason?: ("completed" | "reopened" | "not_planned") | null;
      /**
       * @description Title of the issue
       * @example Widget creation fails in Safari on OS X 10.8
       */
      title: string;
      /**
       * @description Contents of the issue
       * @example It looks like the new widget form is broken on Safari. When I try and create the widget, Safari crashes. This is reproducible on 10.8, but not 10.9. Maybe a browser bug?
       */
      body?: string | null;
      user: components["schemas"]["nullable-simple-user"];
      /**
       * @description Labels to associate with this issue; pass one or more label names to replace the set of labels on this issue; send an empty array to clear all labels from the issue; note that the labels are silently dropped for users without push access to the repository
       * @example [
       *   "bug",
       *   "registration"
       * ]
       */
      labels: (
        | string
        | {
            /** Format: int64 */
            id?: number;
            node_id?: string;
            /** Format: uri */
            url?: string;
            name?: string;
            description?: string | null;
            color?: string | null;
            default?: boolean;
          }
      )[];
      assignee: components["schemas"]["nullable-simple-user"];
      assignees?: components["schemas"]["simple-user"][] | null;
      milestone: components["schemas"]["nullable-milestone"];
      locked: boolean;
      active_lock_reason?: string | null;
      comments: number;
      pull_request?: {
        /** Format: date-time */
        merged_at?: string | null;
        /** Format: uri */
        diff_url: string | null;
        /** Format: uri */
        html_url: string | null;
        /** Format: uri */
        patch_url: string | null;
        /** Format: uri */
        url: string | null;
      };
      /** Format: date-time */
      closed_at: string | null;
      /** Format: date-time */
      created_at: string;
      /** Format: date-time */
      updated_at: string;
      draft?: boolean;
      closed_by?: components["schemas"]["nullable-simple-user"];
      body_html?: string;
      body_text?: string;
      /** Format: uri */
      timeline_url?: string;
      repository?: components["schemas"]["repository"];
      performed_via_github_app?: components["schemas"]["nullable-integration"];
      author_association: components["schemas"]["author-association"];
      reactions?: components["schemas"]["reaction-rollup"];
    } | null;
    /**
     * Issue Event Label
     * @description Issue Event Label
     */
    "issue-event-label": {
      name: string | null;
      color: string | null;
    };
    /** Issue Event Dismissed Review */
    "issue-event-dismissed-review": {
      state: string;
      review_id: number;
      dismissal_message: string | null;
      dismissal_commit_id?: string | null;
    };
    /**
     * Issue Event Milestone
     * @description Issue Event Milestone
     */
    "issue-event-milestone": {
      title: string;
    };
    /**
     * Issue Event Project Card
     * @description Issue Event Project Card
     */
    "issue-event-project-card": {
      /** Format: uri */
      url: string;
      id: number;
      /** Format: uri */
      project_url: string;
      project_id: number;
      column_name: string;
      previous_column_name?: string;
    };
    /**
     * Issue Event Rename
     * @description Issue Event Rename
     */
    "issue-event-rename": {
      from: string;
      to: string;
    };
    /**
     * Issue Event
     * @description Issue Event
     */
    "issue-event": {
      /** @example 1 */
      id: number;
      /** @example MDEwOklzc3VlRXZlbnQx */
      node_id: string;
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/Hello-World/issues/events/1
       */
      url: string;
      actor: components["schemas"]["nullable-simple-user"];
      /** @example closed */
      event: string;
      /** @example 6dcb09b5b57875f334f61aebed695e2e4193db5e */
      commit_id: string | null;
      /** @example https://api.github.com/repos/octocat/Hello-World/commits/6dcb09b5b57875f334f61aebed695e2e4193db5e */
      commit_url: string | null;
      /**
       * Format: date-time
       * @example 2011-04-14T16:00:49Z
       */
      created_at: string;
      issue?: components["schemas"]["nullable-issue"];
      label?: components["schemas"]["issue-event-label"];
      assignee?: components["schemas"]["nullable-simple-user"];
      assigner?: components["schemas"]["nullable-simple-user"];
      review_requester?: components["schemas"]["nullable-simple-user"];
      requested_reviewer?: components["schemas"]["nullable-simple-user"];
      requested_team?: components["schemas"]["team"];
      dismissed_review?: components["schemas"]["issue-event-dismissed-review"];
      milestone?: components["schemas"]["issue-event-milestone"];
      project_card?: components["schemas"]["issue-event-project-card"];
      rename?: components["schemas"]["issue-event-rename"];
      author_association?: components["schemas"]["author-association"];
      lock_reason?: string | null;
      performed_via_github_app?: components["schemas"]["nullable-integration"];
    };
    /**
     * Labeled Issue Event
     * @description Labeled Issue Event
     */
    "labeled-issue-event": {
      id: number;
      node_id: string;
      url: string;
      actor: components["schemas"]["simple-user"];
      event: string;
      commit_id: string | null;
      commit_url: string | null;
      created_at: string;
      performed_via_github_app: components["schemas"]["nullable-integration"];
      label: {
        name: string;
        color: string;
      };
    };
    /**
     * Unlabeled Issue Event
     * @description Unlabeled Issue Event
     */
    "unlabeled-issue-event": {
      id: number;
      node_id: string;
      url: string;
      actor: components["schemas"]["simple-user"];
      event: string;
      commit_id: string | null;
      commit_url: string | null;
      created_at: string;
      performed_via_github_app: components["schemas"]["nullable-integration"];
      label: {
        name: string;
        color: string;
      };
    };
    /**
     * Assigned Issue Event
     * @description Assigned Issue Event
     */
    "assigned-issue-event": {
      id: number;
      node_id: string;
      url: string;
      actor: components["schemas"]["simple-user"];
      event: string;
      commit_id: string | null;
      commit_url: string | null;
      created_at: string;
      performed_via_github_app: components["schemas"]["integration"];
      assignee: components["schemas"]["simple-user"];
      assigner: components["schemas"]["simple-user"];
    };
    /**
     * Unassigned Issue Event
     * @description Unassigned Issue Event
     */
    "unassigned-issue-event": {
      id: number;
      node_id: string;
      url: string;
      actor: components["schemas"]["simple-user"];
      event: string;
      commit_id: string | null;
      commit_url: string | null;
      created_at: string;
      performed_via_github_app: components["schemas"]["nullable-integration"];
      assignee: components["schemas"]["simple-user"];
      assigner: components["schemas"]["simple-user"];
    };
    /**
     * Milestoned Issue Event
     * @description Milestoned Issue Event
     */
    "milestoned-issue-event": {
      id: number;
      node_id: string;
      url: string;
      actor: components["schemas"]["simple-user"];
      event: string;
      commit_id: string | null;
      commit_url: string | null;
      created_at: string;
      performed_via_github_app: components["schemas"]["nullable-integration"];
      milestone: {
        title: string;
      };
    };
    /**
     * Demilestoned Issue Event
     * @description Demilestoned Issue Event
     */
    "demilestoned-issue-event": {
      id: number;
      node_id: string;
      url: string;
      actor: components["schemas"]["simple-user"];
      event: string;
      commit_id: string | null;
      commit_url: string | null;
      created_at: string;
      performed_via_github_app: components["schemas"]["nullable-integration"];
      milestone: {
        title: string;
      };
    };
    /**
     * Renamed Issue Event
     * @description Renamed Issue Event
     */
    "renamed-issue-event": {
      id: number;
      node_id: string;
      url: string;
      actor: components["schemas"]["simple-user"];
      event: string;
      commit_id: string | null;
      commit_url: string | null;
      created_at: string;
      performed_via_github_app: components["schemas"]["nullable-integration"];
      rename: {
        from: string;
        to: string;
      };
    };
    /**
     * Review Requested Issue Event
     * @description Review Requested Issue Event
     */
    "review-requested-issue-event": {
      id: number;
      node_id: string;
      url: string;
      actor: components["schemas"]["simple-user"];
      event: string;
      commit_id: string | null;
      commit_url: string | null;
      created_at: string;
      performed_via_github_app: components["schemas"]["nullable-integration"];
      review_requester: components["schemas"]["simple-user"];
      requested_team?: components["schemas"]["team"];
      requested_reviewer?: components["schemas"]["simple-user"];
    };
    /**
     * Review Request Removed Issue Event
     * @description Review Request Removed Issue Event
     */
    "review-request-removed-issue-event": {
      id: number;
      node_id: string;
      url: string;
      actor: components["schemas"]["simple-user"];
      event: string;
      commit_id: string | null;
      commit_url: string | null;
      created_at: string;
      performed_via_github_app: components["schemas"]["nullable-integration"];
      review_requester: components["schemas"]["simple-user"];
      requested_team?: components["schemas"]["team"];
      requested_reviewer?: components["schemas"]["simple-user"];
    };
    /**
     * Review Dismissed Issue Event
     * @description Review Dismissed Issue Event
     */
    "review-dismissed-issue-event": {
      id: number;
      node_id: string;
      url: string;
      actor: components["schemas"]["simple-user"];
      event: string;
      commit_id: string | null;
      commit_url: string | null;
      created_at: string;
      performed_via_github_app: components["schemas"]["nullable-integration"];
      dismissed_review: {
        state: string;
        review_id: number;
        dismissal_message: string | null;
        dismissal_commit_id?: string;
      };
    };
    /**
     * Locked Issue Event
     * @description Locked Issue Event
     */
    "locked-issue-event": {
      id: number;
      node_id: string;
      url: string;
      actor: components["schemas"]["simple-user"];
      event: string;
      commit_id: string | null;
      commit_url: string | null;
      created_at: string;
      performed_via_github_app: components["schemas"]["nullable-integration"];
      /** @example "off-topic" */
      lock_reason: string | null;
    };
    /**
     * Added to Project Issue Event
     * @description Added to Project Issue Event
     */
    "added-to-project-issue-event": {
      id: number;
      node_id: string;
      url: string;
      actor: components["schemas"]["simple-user"];
      event: string;
      commit_id: string | null;
      commit_url: string | null;
      created_at: string;
      performed_via_github_app: components["schemas"]["nullable-integration"];
      project_card?: {
        id: number;
        /** Format: uri */
        url: string;
        project_id: number;
        /** Format: uri */
        project_url: string;
        column_name: string;
        previous_column_name?: string;
      };
    };
    /**
     * Moved Column in Project Issue Event
     * @description Moved Column in Project Issue Event
     */
    "moved-column-in-project-issue-event": {
      id: number;
      node_id: string;
      url: string;
      actor: components["schemas"]["simple-user"];
      event: string;
      commit_id: string | null;
      commit_url: string | null;
      created_at: string;
      performed_via_github_app: components["schemas"]["nullable-integration"];
      project_card?: {
        id: number;
        /** Format: uri */
        url: string;
        project_id: number;
        /** Format: uri */
        project_url: string;
        column_name: string;
        previous_column_name?: string;
      };
    };
    /**
     * Removed from Project Issue Event
     * @description Removed from Project Issue Event
     */
    "removed-from-project-issue-event": {
      id: number;
      node_id: string;
      url: string;
      actor: components["schemas"]["simple-user"];
      event: string;
      commit_id: string | null;
      commit_url: string | null;
      created_at: string;
      performed_via_github_app: components["schemas"]["nullable-integration"];
      project_card?: {
        id: number;
        /** Format: uri */
        url: string;
        project_id: number;
        /** Format: uri */
        project_url: string;
        column_name: string;
        previous_column_name?: string;
      };
    };
    /**
     * Converted Note to Issue Issue Event
     * @description Converted Note to Issue Issue Event
     */
    "converted-note-to-issue-issue-event": {
      id: number;
      node_id: string;
      url: string;
      actor: components["schemas"]["simple-user"];
      event: string;
      commit_id: string | null;
      commit_url: string | null;
      created_at: string;
      performed_via_github_app: components["schemas"]["integration"];
      project_card?: {
        id: number;
        /** Format: uri */
        url: string;
        project_id: number;
        /** Format: uri */
        project_url: string;
        column_name: string;
        previous_column_name?: string;
      };
    };
    /**
     * Issue Event for Issue
     * @description Issue Event for Issue
     */
    "issue-event-for-issue": Partial<
      components["schemas"]["labeled-issue-event"]
    > &
      Partial<components["schemas"]["unlabeled-issue-event"]> &
      Partial<components["schemas"]["assigned-issue-event"]> &
      Partial<components["schemas"]["unassigned-issue-event"]> &
      Partial<components["schemas"]["milestoned-issue-event"]> &
      Partial<components["schemas"]["demilestoned-issue-event"]> &
      Partial<components["schemas"]["renamed-issue-event"]> &
      Partial<components["schemas"]["review-requested-issue-event"]> &
      Partial<components["schemas"]["review-request-removed-issue-event"]> &
      Partial<components["schemas"]["review-dismissed-issue-event"]> &
      Partial<components["schemas"]["locked-issue-event"]> &
      Partial<components["schemas"]["added-to-project-issue-event"]> &
      Partial<components["schemas"]["moved-column-in-project-issue-event"]> &
      Partial<components["schemas"]["removed-from-project-issue-event"]> &
      Partial<components["schemas"]["converted-note-to-issue-issue-event"]>;
    /**
     * Label
     * @description Color-coded labels help you categorize and filter your issues (just like labels in Gmail).
     */
    label: {
      /**
       * Format: int64
       * @example 208045946
       */
      id: number;
      /** @example MDU6TGFiZWwyMDgwNDU5NDY= */
      node_id: string;
      /**
       * Format: uri
       * @description URL for the label
       * @example https://api.github.com/repositories/42/labels/bug
       */
      url: string;
      /**
       * @description The name of the label.
       * @example bug
       */
      name: string;
      /** @example Something isn't working */
      description: string | null;
      /**
       * @description 6-character hex code, without the leading #, identifying the color
       * @example FFFFFF
       */
      color: string;
      /** @example true */
      default: boolean;
    };
    /**
     * Timeline Comment Event
     * @description Timeline Comment Event
     */
    "timeline-comment-event": {
      event: string;
      actor: components["schemas"]["simple-user"];
      /**
       * @description Unique identifier of the issue comment
       * @example 42
       */
      id: number;
      node_id: string;
      /**
       * Format: uri
       * @description URL for the issue comment
       * @example https://api.github.com/repositories/42/issues/comments/1
       */
      url: string;
      /**
       * @description Contents of the issue comment
       * @example What version of Safari were you using when you observed this bug?
       */
      body?: string;
      body_text?: string;
      body_html?: string;
      /** Format: uri */
      html_url: string;
      user: components["schemas"]["simple-user"];
      /**
       * Format: date-time
       * @example 2011-04-14T16:00:49Z
       */
      created_at: string;
      /**
       * Format: date-time
       * @example 2011-04-14T16:00:49Z
       */
      updated_at: string;
      /** Format: uri */
      issue_url: string;
      author_association: components["schemas"]["author-association"];
      performed_via_github_app?: components["schemas"]["nullable-integration"];
      reactions?: components["schemas"]["reaction-rollup"];
    };
    /**
     * Timeline Cross Referenced Event
     * @description Timeline Cross Referenced Event
     */
    "timeline-cross-referenced-event": {
      event: string;
      actor?: components["schemas"]["simple-user"];
      /** Format: date-time */
      created_at: string;
      /** Format: date-time */
      updated_at: string;
      source: {
        type?: string;
        issue?: components["schemas"]["issue"];
      };
    };
    /**
     * Timeline Committed Event
     * @description Timeline Committed Event
     */
    "timeline-committed-event": {
      event?: string;
      /**
       * @description SHA for the commit
       * @example 7638417db6d59f3c431d3e1f261cc637155684cd
       */
      sha: string;
      node_id: string;
      /** Format: uri */
      url: string;
      /** @description Identifying information for the git-user */
      author: {
        /**
         * Format: date-time
         * @description Timestamp of the commit
         * @example 2014-08-09T08:02:04+12:00
         */
        date: string;
        /**
         * @description Git email address of the user
         * @example monalisa.octocat@example.com
         */
        email: string;
        /**
         * @description Name of the git user
         * @example Monalisa Octocat
         */
        name: string;
      };
      /** @description Identifying information for the git-user */
      committer: {
        /**
         * Format: date-time
         * @description Timestamp of the commit
         * @example 2014-08-09T08:02:04+12:00
         */
        date: string;
        /**
         * @description Git email address of the user
         * @example monalisa.octocat@example.com
         */
        email: string;
        /**
         * @description Name of the git user
         * @example Monalisa Octocat
         */
        name: string;
      };
      /**
       * @description Message describing the purpose of the commit
       * @example Fix #42
       */
      message: string;
      tree: {
        /**
         * @description SHA for the commit
         * @example 7638417db6d59f3c431d3e1f261cc637155684cd
         */
        sha: string;
        /** Format: uri */
        url: string;
      };
      parents: {
        /**
         * @description SHA for the commit
         * @example 7638417db6d59f3c431d3e1f261cc637155684cd
         */
        sha: string;
        /** Format: uri */
        url: string;
        /** Format: uri */
        html_url: string;
      }[];
      verification: {
        verified: boolean;
        reason: string;
        signature: string | null;
        payload: string | null;
      };
      /** Format: uri */
      html_url: string;
    };
    /**
     * Timeline Reviewed Event
     * @description Timeline Reviewed Event
     */
    "timeline-reviewed-event": {
      event: string;
      /**
       * @description Unique identifier of the review
       * @example 42
       */
      id: number;
      /** @example MDE3OlB1bGxSZXF1ZXN0UmV2aWV3ODA= */
      node_id: string;
      user: components["schemas"]["simple-user"];
      /**
       * @description The text of the review.
       * @example This looks great.
       */
      body: string | null;
      /** @example CHANGES_REQUESTED */
      state: string;
      /**
       * Format: uri
       * @example https://github.com/octocat/Hello-World/pull/12#pullrequestreview-80
       */
      html_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/Hello-World/pulls/12
       */
      pull_request_url: string;
      _links: {
        html: {
          href: string;
        };
        pull_request: {
          href: string;
        };
      };
      /** Format: date-time */
      submitted_at?: string;
      /**
       * @description A commit SHA for the review.
       * @example 54bb654c9e6025347f57900a4a5c2313a96b8035
       */
      commit_id: string;
      body_html?: string;
      body_text?: string;
      author_association: components["schemas"]["author-association"];
    };
    /**
     * Pull Request Review Comment
     * @description Pull Request Review Comments are comments on a portion of the Pull Request's diff.
     */
    "pull-request-review-comment": {
      /**
       * @description URL for the pull request review comment
       * @example https://api.github.com/repos/octocat/Hello-World/pulls/comments/1
       */
      url: string;
      /**
       * @description The ID of the pull request review to which the comment belongs.
       * @example 42
       */
      pull_request_review_id: number | null;
      /**
       * @description The ID of the pull request review comment.
       * @example 1
       */
      id: number;
      /**
       * @description The node ID of the pull request review comment.
       * @example MDI0OlB1bGxSZXF1ZXN0UmV2aWV3Q29tbWVudDEw
       */
      node_id: string;
      /**
       * @description The diff of the line that the comment refers to.
       * @example @@ -16,33 +16,40 @@ public class Connection : IConnection...
       */
      diff_hunk: string;
      /**
       * @description The relative path of the file to which the comment applies.
       * @example config/database.yaml
       */
      path: string;
      /**
       * @description The line index in the diff to which the comment applies. This field is deprecated; use `line` instead.
       * @example 1
       */
      position: number;
      /**
       * @description The index of the original line in the diff to which the comment applies. This field is deprecated; use `original_line` instead.
       * @example 4
       */
      original_position: number;
      /**
       * @description The SHA of the commit to which the comment applies.
       * @example 6dcb09b5b57875f334f61aebed695e2e4193db5e
       */
      commit_id: string;
      /**
       * @description The SHA of the original commit to which the comment applies.
       * @example 9c48853fa3dc5c1c3d6f1f1cd1f2743e72652840
       */
      original_commit_id: string;
      /**
       * @description The comment ID to reply to.
       * @example 8
       */
      in_reply_to_id?: number;
      user: components["schemas"]["simple-user"];
      /**
       * @description The text of the comment.
       * @example We should probably include a check for null values here.
       */
      body: string;
      /**
       * Format: date-time
       * @example 2011-04-14T16:00:49Z
       */
      created_at: string;
      /**
       * Format: date-time
       * @example 2011-04-14T16:00:49Z
       */
      updated_at: string;
      /**
       * Format: uri
       * @description HTML URL for the pull request review comment.
       * @example https://github.com/octocat/Hello-World/pull/1#discussion-diff-1
       */
      html_url: string;
      /**
       * Format: uri
       * @description URL for the pull request that the review comment belongs to.
       * @example https://api.github.com/repos/octocat/Hello-World/pulls/1
       */
      pull_request_url: string;
      author_association: components["schemas"]["author-association"];
      _links: {
        self: {
          /**
           * Format: uri
           * @example https://api.github.com/repos/octocat/Hello-World/pulls/comments/1
           */
          href: string;
        };
        html: {
          /**
           * Format: uri
           * @example https://github.com/octocat/Hello-World/pull/1#discussion-diff-1
           */
          href: string;
        };
        pull_request: {
          /**
           * Format: uri
           * @example https://api.github.com/repos/octocat/Hello-World/pulls/1
           */
          href: string;
        };
      };
      /**
       * @description The first line of the range for a multi-line comment.
       * @example 2
       */
      start_line?: number | null;
      /**
       * @description The first line of the range for a multi-line comment.
       * @example 2
       */
      original_start_line?: number | null;
      /**
       * @description The side of the first line of the range for a multi-line comment.
       * @default RIGHT
       * @enum {string|null}
       */
      start_side?: ("LEFT" | "RIGHT") | null;
      /**
       * @description The line of the blob to which the comment applies. The last line of the range for a multi-line comment
       * @example 2
       */
      line?: number;
      /**
       * @description The line of the blob to which the comment applies. The last line of the range for a multi-line comment
       * @example 2
       */
      original_line?: number;
      /**
       * @description The side of the diff to which the comment applies. The side of the last line of the range for a multi-line comment
       * @default RIGHT
       * @enum {string}
       */
      side?: "LEFT" | "RIGHT";
      reactions?: components["schemas"]["reaction-rollup"];
      /** @example "<p>comment body</p>" */
      body_html?: string;
      /** @example "comment body" */
      body_text?: string;
    };
    /**
     * Timeline Line Commented Event
     * @description Timeline Line Commented Event
     */
    "timeline-line-commented-event": {
      event?: string;
      node_id?: string;
      comments?: components["schemas"]["pull-request-review-comment"][];
    };
    /**
     * Timeline Commit Commented Event
     * @description Timeline Commit Commented Event
     */
    "timeline-commit-commented-event": {
      event?: string;
      node_id?: string;
      commit_id?: string;
      comments?: components["schemas"]["commit-comment"][];
    };
    /**
     * Timeline Assigned Issue Event
     * @description Timeline Assigned Issue Event
     */
    "timeline-assigned-issue-event": {
      id: number;
      node_id: string;
      url: string;
      actor: components["schemas"]["simple-user"];
      event: string;
      commit_id: string | null;
      commit_url: string | null;
      created_at: string;
      performed_via_github_app: components["schemas"]["nullable-integration"];
      assignee: components["schemas"]["simple-user"];
    };
    /**
     * Timeline Unassigned Issue Event
     * @description Timeline Unassigned Issue Event
     */
    "timeline-unassigned-issue-event": {
      id: number;
      node_id: string;
      url: string;
      actor: components["schemas"]["simple-user"];
      event: string;
      commit_id: string | null;
      commit_url: string | null;
      created_at: string;
      performed_via_github_app: components["schemas"]["nullable-integration"];
      assignee: components["schemas"]["simple-user"];
    };
    /**
     * State Change Issue Event
     * @description State Change Issue Event
     */
    "state-change-issue-event": {
      id: number;
      node_id: string;
      url: string;
      actor: components["schemas"]["simple-user"];
      event: string;
      commit_id: string | null;
      commit_url: string | null;
      created_at: string;
      performed_via_github_app: components["schemas"]["nullable-integration"];
      state_reason?: string | null;
    };
    /**
     * Timeline Event
     * @description Timeline Event
     */
    "timeline-issue-events": Partial<
      components["schemas"]["labeled-issue-event"]
    > &
      Partial<components["schemas"]["unlabeled-issue-event"]> &
      Partial<components["schemas"]["milestoned-issue-event"]> &
      Partial<components["schemas"]["demilestoned-issue-event"]> &
      Partial<components["schemas"]["renamed-issue-event"]> &
      Partial<components["schemas"]["review-requested-issue-event"]> &
      Partial<components["schemas"]["review-request-removed-issue-event"]> &
      Partial<components["schemas"]["review-dismissed-issue-event"]> &
      Partial<components["schemas"]["locked-issue-event"]> &
      Partial<components["schemas"]["added-to-project-issue-event"]> &
      Partial<components["schemas"]["moved-column-in-project-issue-event"]> &
      Partial<components["schemas"]["removed-from-project-issue-event"]> &
      Partial<components["schemas"]["converted-note-to-issue-issue-event"]> &
      Partial<components["schemas"]["timeline-comment-event"]> &
      Partial<components["schemas"]["timeline-cross-referenced-event"]> &
      Partial<components["schemas"]["timeline-committed-event"]> &
      Partial<components["schemas"]["timeline-reviewed-event"]> &
      Partial<components["schemas"]["timeline-line-commented-event"]> &
      Partial<components["schemas"]["timeline-commit-commented-event"]> &
      Partial<components["schemas"]["timeline-assigned-issue-event"]> &
      Partial<components["schemas"]["timeline-unassigned-issue-event"]> &
      Partial<components["schemas"]["state-change-issue-event"]>;
    /**
     * Deploy Key
     * @description An SSH key granting access to a single repository.
     */
    "deploy-key": {
      id: number;
      key: string;
      url: string;
      title: string;
      verified: boolean;
      created_at: string;
      read_only: boolean;
    };
    /**
     * Language
     * @description Language
     */
    language: { [key: string]: number };
    /**
     * License Content
     * @description License Content
     */
    "license-content": {
      name: string;
      path: string;
      sha: string;
      size: number;
      /** Format: uri */
      url: string;
      /** Format: uri */
      html_url: string | null;
      /** Format: uri */
      git_url: string | null;
      /** Format: uri */
      download_url: string | null;
      type: string;
      content: string;
      encoding: string;
      _links: {
        /** Format: uri */
        git: string | null;
        /** Format: uri */
        html: string | null;
        /** Format: uri */
        self: string;
      };
      license: components["schemas"]["nullable-license-simple"];
    };
    /**
     * Merged upstream
     * @description Results of a successful merge upstream request
     */
    "merged-upstream": {
      message?: string;
      /** @enum {string} */
      merge_type?: "merge" | "fast-forward" | "none";
      base_branch?: string;
    };
    /**
     * Milestone
     * @description A collection of related issues and pull requests.
     */
    milestone: {
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/Hello-World/milestones/1
       */
      url: string;
      /**
       * Format: uri
       * @example https://github.com/octocat/Hello-World/milestones/v1.0
       */
      html_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/Hello-World/milestones/1/labels
       */
      labels_url: string;
      /** @example 1002604 */
      id: number;
      /** @example MDk6TWlsZXN0b25lMTAwMjYwNA== */
      node_id: string;
      /**
       * @description The number of the milestone.
       * @example 42
       */
      number: number;
      /**
       * @description The state of the milestone.
       * @default open
       * @example open
       * @enum {string}
       */
      state: "open" | "closed";
      /**
       * @description The title of the milestone.
       * @example v1.0
       */
      title: string;
      /** @example Tracking milestone for version 1.0 */
      description: string | null;
      creator: components["schemas"]["nullable-simple-user"];
      /** @example 4 */
      open_issues: number;
      /** @example 8 */
      closed_issues: number;
      /**
       * Format: date-time
       * @example 2011-04-10T20:09:31Z
       */
      created_at: string;
      /**
       * Format: date-time
       * @example 2014-03-03T18:58:10Z
       */
      updated_at: string;
      /**
       * Format: date-time
       * @example 2013-02-12T13:22:01Z
       */
      closed_at: string | null;
      /**
       * Format: date-time
       * @example 2012-10-09T23:39:01Z
       */
      due_on: string | null;
    };
    /** Pages Source Hash */
    "pages-source-hash": {
      branch: string;
      path: string;
    };
    /** Pages Https Certificate */
    "pages-https-certificate": {
      /**
       * @example approved
       * @enum {string}
       */
      state:
        | "new"
        | "authorization_created"
        | "authorization_pending"
        | "authorized"
        | "authorization_revoked"
        | "issued"
        | "uploaded"
        | "approved"
        | "errored"
        | "bad_authz"
        | "destroy_pending"
        | "dns_changed";
      /** @example Certificate is approved */
      description: string;
      /**
       * @description Array of the domain set and its alternate name (if it is configured)
       * @example [
       *   "example.com",
       *   "www.example.com"
       * ]
       */
      domains: string[];
      /** Format: date */
      expires_at?: string;
    };
    /**
     * GitHub Pages
     * @description The configuration for GitHub Pages for a repository.
     */
    page: {
      /**
       * Format: uri
       * @description The API address for accessing this Page resource.
       * @example https://api.github.com/repos/github/hello-world/pages
       */
      url: string;
      /**
       * @description The status of the most recent build of the Page.
       * @example built
       * @enum {string|null}
       */
      status: ("built" | "building" | "errored") | null;
      /**
       * @description The Pages site's custom domain
       * @example example.com
       */
      cname: string | null;
      /**
       * @description The state if the domain is verified
       * @example pending
       * @enum {string|null}
       */
      protected_domain_state?: ("pending" | "verified" | "unverified") | null;
      /**
       * Format: date-time
       * @description The timestamp when a pending domain becomes unverified.
       */
      pending_domain_unverified_at?: string | null;
      /**
       * @description Whether the Page has a custom 404 page.
       * @default false
       * @example false
       */
      custom_404: boolean;
      /**
       * Format: uri
       * @description The web address the Page can be accessed from.
       * @example https://example.com
       */
      html_url?: string;
      /**
       * @description The process in which the Page will be built.
       * @example legacy
       * @enum {string|null}
       */
      build_type?: ("legacy" | "workflow") | null;
      source?: components["schemas"]["pages-source-hash"];
      /**
       * @description Whether the GitHub Pages site is publicly visible. If set to `true`, the site is accessible to anyone on the internet. If set to `false`, the site will only be accessible to users who have at least `read` access to the repository that published the site.
       * @example true
       */
      public: boolean;
      https_certificate?: components["schemas"]["pages-https-certificate"];
      /**
       * @description Whether https is enabled on the domain
       * @example true
       */
      https_enforced?: boolean;
    };
    /**
     * Page Build
     * @description Page Build
     */
    "page-build": {
      /** Format: uri */
      url: string;
      status: string;
      error: {
        message: string | null;
      };
      pusher: components["schemas"]["nullable-simple-user"];
      commit: string;
      duration: number;
      /** Format: date-time */
      created_at: string;
      /** Format: date-time */
      updated_at: string;
    };
    /**
     * Page Build Status
     * @description Page Build Status
     */
    "page-build-status": {
      /**
       * Format: uri
       * @example https://api.github.com/repos/github/hello-world/pages/builds/latest
       */
      url: string;
      /** @example queued */
      status: string;
    };
    "repository-pre-receive-hook": {
      id?: number;
      name?: string;
      enforcement?: string;
      configuration_url?: string;
    };
    /**
     * Team Simple
     * @description Groups of organization members that gives permissions on specified repositories.
     */
    "team-simple": {
      /**
       * @description Unique identifier of the team
       * @example 1
       */
      id: number;
      /** @example MDQ6VGVhbTE= */
      node_id: string;
      /**
       * Format: uri
       * @description URL for the team
       * @example https://api.github.com/organizations/1/team/1
       */
      url: string;
      /** @example https://api.github.com/organizations/1/team/1/members{/member} */
      members_url: string;
      /**
       * @description Name of the team
       * @example Justice League
       */
      name: string;
      /**
       * @description Description of the team
       * @example A great team.
       */
      description: string | null;
      /**
       * @description Permission that the team will have for its repositories
       * @example admin
       */
      permission: string;
      /**
       * @description The level of privacy this team should have
       * @example closed
       */
      privacy?: string;
      /**
       * Format: uri
       * @example https://github.com/orgs/rails/teams/core
       */
      html_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/organizations/1/team/1/repos
       */
      repositories_url: string;
      /** @example justice-league */
      slug: string;
      /**
       * @description Distinguished Name (DN) that team maps to within LDAP environment
       * @example uid=example,ou=users,dc=github,dc=com
       */
      ldap_dn?: string;
    };
    /**
     * Pull Request
     * @description Pull requests let you tell others about changes you've pushed to a repository on GitHub. Once a pull request is sent, interested parties can review the set of changes, discuss potential modifications, and even push follow-up commits if necessary.
     */
    "pull-request": {
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/Hello-World/pulls/1347
       */
      url: string;
      /** @example 1 */
      id: number;
      /** @example MDExOlB1bGxSZXF1ZXN0MQ== */
      node_id: string;
      /**
       * Format: uri
       * @example https://github.com/octocat/Hello-World/pull/1347
       */
      html_url: string;
      /**
       * Format: uri
       * @example https://github.com/octocat/Hello-World/pull/1347.diff
       */
      diff_url: string;
      /**
       * Format: uri
       * @example https://github.com/octocat/Hello-World/pull/1347.patch
       */
      patch_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/Hello-World/issues/1347
       */
      issue_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/Hello-World/pulls/1347/commits
       */
      commits_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/Hello-World/pulls/1347/comments
       */
      review_comments_url: string;
      /** @example https://api.github.com/repos/octocat/Hello-World/pulls/comments{/number} */
      review_comment_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/Hello-World/issues/1347/comments
       */
      comments_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/Hello-World/statuses/6dcb09b5b57875f334f61aebed695e2e4193db5e
       */
      statuses_url: string;
      /**
       * @description Number uniquely identifying the pull request within its repository.
       * @example 42
       */
      number: number;
      /**
       * @description State of this Pull Request. Either `open` or `closed`.
       * @example open
       * @enum {string}
       */
      state: "open" | "closed";
      /** @example true */
      locked: boolean;
      /**
       * @description The title of the pull request.
       * @example Amazing new feature
       */
      title: string;
      user: components["schemas"]["nullable-simple-user"];
      /** @example Please pull these awesome changes */
      body: string | null;
      labels: {
        /** Format: int64 */
        id: number;
        node_id: string;
        url: string;
        name: string;
        description: string | null;
        color: string;
        default: boolean;
      }[];
      milestone: components["schemas"]["nullable-milestone"];
      /** @example too heated */
      active_lock_reason?: string | null;
      /**
       * Format: date-time
       * @example 2011-01-26T19:01:12Z
       */
      created_at: string;
      /**
       * Format: date-time
       * @example 2011-01-26T19:01:12Z
       */
      updated_at: string;
      /**
       * Format: date-time
       * @example 2011-01-26T19:01:12Z
       */
      closed_at: string | null;
      /**
       * Format: date-time
       * @example 2011-01-26T19:01:12Z
       */
      merged_at: string | null;
      /** @example e5bd3914e2e596debea16f433f57875b5b90bcd6 */
      merge_commit_sha: string | null;
      assignee: components["schemas"]["nullable-simple-user"];
      assignees?: components["schemas"]["simple-user"][] | null;
      requested_reviewers?: components["schemas"]["simple-user"][] | null;
      requested_teams?: components["schemas"]["team-simple"][] | null;
      head: {
        label: string;
        ref: string;
        repo: {
          archive_url: string;
          assignees_url: string;
          blobs_url: string;
          branches_url: string;
          collaborators_url: string;
          comments_url: string;
          commits_url: string;
          compare_url: string;
          contents_url: string;
          /** Format: uri */
          contributors_url: string;
          /** Format: uri */
          deployments_url: string;
          description: string | null;
          /** Format: uri */
          downloads_url: string;
          /** Format: uri */
          events_url: string;
          fork: boolean;
          /** Format: uri */
          forks_url: string;
          full_name: string;
          git_commits_url: string;
          git_refs_url: string;
          git_tags_url: string;
          /** Format: uri */
          hooks_url: string;
          /** Format: uri */
          html_url: string;
          id: number;
          node_id: string;
          issue_comment_url: string;
          issue_events_url: string;
          issues_url: string;
          keys_url: string;
          labels_url: string;
          /** Format: uri */
          languages_url: string;
          /** Format: uri */
          merges_url: string;
          milestones_url: string;
          name: string;
          notifications_url: string;
          owner: {
            /** Format: uri */
            avatar_url: string;
            events_url: string;
            /** Format: uri */
            followers_url: string;
            following_url: string;
            gists_url: string;
            gravatar_id: string | null;
            /** Format: uri */
            html_url: string;
            id: number;
            node_id: string;
            login: string;
            /** Format: uri */
            organizations_url: string;
            /** Format: uri */
            received_events_url: string;
            /** Format: uri */
            repos_url: string;
            site_admin: boolean;
            starred_url: string;
            /** Format: uri */
            subscriptions_url: string;
            type: string;
            /** Format: uri */
            url: string;
          };
          private: boolean;
          pulls_url: string;
          releases_url: string;
          /** Format: uri */
          stargazers_url: string;
          statuses_url: string;
          /** Format: uri */
          subscribers_url: string;
          /** Format: uri */
          subscription_url: string;
          /** Format: uri */
          tags_url: string;
          /** Format: uri */
          teams_url: string;
          trees_url: string;
          /** Format: uri */
          url: string;
          clone_url: string;
          default_branch: string;
          forks: number;
          forks_count: number;
          git_url: string;
          has_downloads: boolean;
          has_issues: boolean;
          has_projects: boolean;
          has_wiki: boolean;
          has_pages: boolean;
          /** Format: uri */
          homepage: string | null;
          language: string | null;
          master_branch?: string;
          archived: boolean;
          disabled: boolean;
          /** @description The repository visibility: public, private, or internal. */
          visibility?: string;
          /** Format: uri */
          mirror_url: string | null;
          open_issues: number;
          open_issues_count: number;
          permissions?: {
            admin: boolean;
            maintain?: boolean;
            push: boolean;
            triage?: boolean;
            pull: boolean;
          };
          temp_clone_token?: string;
          allow_merge_commit?: boolean;
          allow_squash_merge?: boolean;
          allow_rebase_merge?: boolean;
          license: {
            key: string;
            name: string;
            /** Format: uri */
            url: string | null;
            spdx_id: string | null;
            node_id: string;
          } | null;
          /** Format: date-time */
          pushed_at: string;
          size: number;
          ssh_url: string;
          stargazers_count: number;
          /** Format: uri */
          svn_url: string;
          topics?: string[];
          watchers: number;
          watchers_count: number;
          /** Format: date-time */
          created_at: string;
          /** Format: date-time */
          updated_at: string;
          allow_forking?: boolean;
          is_template?: boolean;
        } | null;
        sha: string;
        user: {
          /** Format: uri */
          avatar_url: string;
          events_url: string;
          /** Format: uri */
          followers_url: string;
          following_url: string;
          gists_url: string;
          gravatar_id: string | null;
          /** Format: uri */
          html_url: string;
          id: number;
          node_id: string;
          login: string;
          /** Format: uri */
          organizations_url: string;
          /** Format: uri */
          received_events_url: string;
          /** Format: uri */
          repos_url: string;
          site_admin: boolean;
          starred_url: string;
          /** Format: uri */
          subscriptions_url: string;
          type: string;
          /** Format: uri */
          url: string;
        };
      };
      base: {
        label: string;
        ref: string;
        repo: {
          archive_url: string;
          assignees_url: string;
          blobs_url: string;
          branches_url: string;
          collaborators_url: string;
          comments_url: string;
          commits_url: string;
          compare_url: string;
          contents_url: string;
          /** Format: uri */
          contributors_url: string;
          /** Format: uri */
          deployments_url: string;
          description: string | null;
          /** Format: uri */
          downloads_url: string;
          /** Format: uri */
          events_url: string;
          fork: boolean;
          /** Format: uri */
          forks_url: string;
          full_name: string;
          git_commits_url: string;
          git_refs_url: string;
          git_tags_url: string;
          /** Format: uri */
          hooks_url: string;
          /** Format: uri */
          html_url: string;
          id: number;
          is_template?: boolean;
          node_id: string;
          issue_comment_url: string;
          issue_events_url: string;
          issues_url: string;
          keys_url: string;
          labels_url: string;
          /** Format: uri */
          languages_url: string;
          /** Format: uri */
          merges_url: string;
          milestones_url: string;
          name: string;
          notifications_url: string;
          owner: {
            /** Format: uri */
            avatar_url: string;
            events_url: string;
            /** Format: uri */
            followers_url: string;
            following_url: string;
            gists_url: string;
            gravatar_id: string | null;
            /** Format: uri */
            html_url: string;
            id: number;
            node_id: string;
            login: string;
            /** Format: uri */
            organizations_url: string;
            /** Format: uri */
            received_events_url: string;
            /** Format: uri */
            repos_url: string;
            site_admin: boolean;
            starred_url: string;
            /** Format: uri */
            subscriptions_url: string;
            type: string;
            /** Format: uri */
            url: string;
          };
          private: boolean;
          pulls_url: string;
          releases_url: string;
          /** Format: uri */
          stargazers_url: string;
          statuses_url: string;
          /** Format: uri */
          subscribers_url: string;
          /** Format: uri */
          subscription_url: string;
          /** Format: uri */
          tags_url: string;
          /** Format: uri */
          teams_url: string;
          trees_url: string;
          /** Format: uri */
          url: string;
          clone_url: string;
          default_branch: string;
          forks: number;
          forks_count: number;
          git_url: string;
          has_downloads: boolean;
          has_issues: boolean;
          has_projects: boolean;
          has_wiki: boolean;
          has_pages: boolean;
          /** Format: uri */
          homepage: string | null;
          language: string | null;
          master_branch?: string;
          archived: boolean;
          disabled: boolean;
          /** @description The repository visibility: public, private, or internal. */
          visibility?: string;
          /** Format: uri */
          mirror_url: string | null;
          open_issues: number;
          open_issues_count: number;
          permissions?: {
            admin: boolean;
            maintain?: boolean;
            push: boolean;
            triage?: boolean;
            pull: boolean;
          };
          temp_clone_token?: string;
          allow_merge_commit?: boolean;
          allow_squash_merge?: boolean;
          allow_rebase_merge?: boolean;
          license: components["schemas"]["nullable-license-simple"];
          /** Format: date-time */
          pushed_at: string;
          size: number;
          ssh_url: string;
          stargazers_count: number;
          /** Format: uri */
          svn_url: string;
          topics?: string[];
          watchers: number;
          watchers_count: number;
          /** Format: date-time */
          created_at: string;
          /** Format: date-time */
          updated_at: string;
          allow_forking?: boolean;
        };
        sha: string;
        user: {
          /** Format: uri */
          avatar_url: string;
          events_url: string;
          /** Format: uri */
          followers_url: string;
          following_url: string;
          gists_url: string;
          gravatar_id: string | null;
          /** Format: uri */
          html_url: string;
          id: number;
          node_id: string;
          login: string;
          /** Format: uri */
          organizations_url: string;
          /** Format: uri */
          received_events_url: string;
          /** Format: uri */
          repos_url: string;
          site_admin: boolean;
          starred_url: string;
          /** Format: uri */
          subscriptions_url: string;
          type: string;
          /** Format: uri */
          url: string;
        };
      };
      _links: {
        comments: components["schemas"]["link"];
        commits: components["schemas"]["link"];
        statuses: components["schemas"]["link"];
        html: components["schemas"]["link"];
        issue: components["schemas"]["link"];
        review_comments: components["schemas"]["link"];
        review_comment: components["schemas"]["link"];
        self: components["schemas"]["link"];
      };
      author_association: components["schemas"]["author-association"];
      auto_merge: components["schemas"]["auto-merge"];
      /**
       * @description Indicates whether or not the pull request is a draft.
       * @example false
       */
      draft?: boolean;
      merged: boolean;
      /** @example true */
      mergeable: boolean | null;
      /** @example true */
      rebaseable?: boolean | null;
      /** @example clean */
      mergeable_state: string;
      merged_by: components["schemas"]["nullable-simple-user"];
      /** @example 10 */
      comments: number;
      /** @example 0 */
      review_comments: number;
      /**
       * @description Indicates whether maintainers can modify the pull request.
       * @example true
       */
      maintainer_can_modify: boolean;
      /** @example 3 */
      commits: number;
      /** @example 100 */
      additions: number;
      /** @example 3 */
      deletions: number;
      /** @example 5 */
      changed_files: number;
    };
    /**
     * Pull Request Merge Result
     * @description Pull Request Merge Result
     */
    "pull-request-merge-result": {
      sha: string;
      merged: boolean;
      message: string;
    };
    /**
     * Pull Request Review Request
     * @description Pull Request Review Request
     */
    "pull-request-review-request": {
      users: components["schemas"]["simple-user"][];
      teams: components["schemas"]["team"][];
    };
    /**
     * Pull Request Review
     * @description Pull Request Reviews are reviews on pull requests.
     */
    "pull-request-review": {
      /**
       * @description Unique identifier of the review
       * @example 42
       */
      id: number;
      /** @example MDE3OlB1bGxSZXF1ZXN0UmV2aWV3ODA= */
      node_id: string;
      user: components["schemas"]["nullable-simple-user"];
      /**
       * @description The text of the review.
       * @example This looks great.
       */
      body: string;
      /** @example CHANGES_REQUESTED */
      state: string;
      /**
       * Format: uri
       * @example https://github.com/octocat/Hello-World/pull/12#pullrequestreview-80
       */
      html_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/Hello-World/pulls/12
       */
      pull_request_url: string;
      _links: {
        html: {
          href: string;
        };
        pull_request: {
          href: string;
        };
      };
      /** Format: date-time */
      submitted_at?: string;
      /**
       * @description A commit SHA for the review.
       * @example 54bb654c9e6025347f57900a4a5c2313a96b8035
       */
      commit_id: string;
      body_html?: string;
      body_text?: string;
      author_association: components["schemas"]["author-association"];
    };
    /**
     * Legacy Review Comment
     * @description Legacy Review Comment
     */
    "review-comment": {
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/Hello-World/pulls/comments/1
       */
      url: string;
      /** @example 42 */
      pull_request_review_id: number | null;
      /** @example 10 */
      id: number;
      /** @example MDI0OlB1bGxSZXF1ZXN0UmV2aWV3Q29tbWVudDEw */
      node_id: string;
      /** @example @@ -16,33 +16,40 @@ public class Connection : IConnection... */
      diff_hunk: string;
      /** @example file1.txt */
      path: string;
      /** @example 1 */
      position: number | null;
      /** @example 4 */
      original_position: number;
      /** @example 6dcb09b5b57875f334f61aebed695e2e4193db5e */
      commit_id: string;
      /** @example 9c48853fa3dc5c1c3d6f1f1cd1f2743e72652840 */
      original_commit_id: string;
      /** @example 8 */
      in_reply_to_id?: number;
      user: components["schemas"]["nullable-simple-user"];
      /** @example Great stuff */
      body: string;
      /**
       * Format: date-time
       * @example 2011-04-14T16:00:49Z
       */
      created_at: string;
      /**
       * Format: date-time
       * @example 2011-04-14T16:00:49Z
       */
      updated_at: string;
      /**
       * Format: uri
       * @example https://github.com/octocat/Hello-World/pull/1#discussion-diff-1
       */
      html_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/Hello-World/pulls/1
       */
      pull_request_url: string;
      author_association: components["schemas"]["author-association"];
      _links: {
        self: components["schemas"]["link"];
        html: components["schemas"]["link"];
        pull_request: components["schemas"]["link"];
      };
      body_text?: string;
      body_html?: string;
      reactions?: components["schemas"]["reaction-rollup"];
      /**
       * @description The side of the first line of the range for a multi-line comment.
       * @default RIGHT
       * @enum {string}
       */
      side?: "LEFT" | "RIGHT";
      /**
       * @description The side of the first line of the range for a multi-line comment.
       * @default RIGHT
       * @enum {string|null}
       */
      start_side?: ("LEFT" | "RIGHT") | null;
      /**
       * @description The line of the blob to which the comment applies. The last line of the range for a multi-line comment
       * @example 2
       */
      line?: number;
      /**
       * @description The original line of the blob to which the comment applies. The last line of the range for a multi-line comment
       * @example 2
       */
      original_line?: number;
      /**
       * @description The first line of the range for a multi-line comment.
       * @example 2
       */
      start_line?: number | null;
      /**
       * @description The original first line of the range for a multi-line comment.
       * @example 2
       */
      original_start_line?: number | null;
    };
    /**
     * Release Asset
     * @description Data related to a release.
     */
    "release-asset": {
      /** Format: uri */
      url: string;
      /** Format: uri */
      browser_download_url: string;
      id: number;
      node_id: string;
      /**
       * @description The file name of the asset.
       * @example Team Environment
       */
      name: string;
      label: string | null;
      /**
       * @description State of the release asset.
       * @enum {string}
       */
      state: "uploaded" | "open";
      content_type: string;
      size: number;
      download_count: number;
      /** Format: date-time */
      created_at: string;
      /** Format: date-time */
      updated_at: string;
      uploader: components["schemas"]["nullable-simple-user"];
    };
    /**
     * Release
     * @description A release.
     */
    release: {
      /** Format: uri */
      url: string;
      /** Format: uri */
      html_url: string;
      /** Format: uri */
      assets_url: string;
      upload_url: string;
      /** Format: uri */
      tarball_url: string | null;
      /** Format: uri */
      zipball_url: string | null;
      id: number;
      node_id: string;
      /**
       * @description The name of the tag.
       * @example v1.0.0
       */
      tag_name: string;
      /**
       * @description Specifies the commitish value that determines where the Git tag is created from.
       * @example master
       */
      target_commitish: string;
      name: string | null;
      body?: string | null;
      /**
       * @description true to create a draft (unpublished) release, false to create a published one.
       * @example false
       */
      draft: boolean;
      /**
       * @description Whether to identify the release as a prerelease or a full release.
       * @example false
       */
      prerelease: boolean;
      /** Format: date-time */
      created_at: string;
      /** Format: date-time */
      published_at: string | null;
      author: components["schemas"]["simple-user"];
      assets: components["schemas"]["release-asset"][];
      body_html?: string;
      body_text?: string;
      mentions_count?: number;
      reactions?: components["schemas"]["reaction-rollup"];
    };
    /**
     * Generated Release Notes Content
     * @description Generated name and body describing a release
     */
    "release-notes-content": {
      /**
       * @description The generated name of the release
       * @example Release v1.0.0 is now available!
       */
      name: string;
      /** @description The generated body describing the contents of the release supporting markdown formatting */
      body: string;
    };
    /**
     * Format: date-time
     * @description The time that the alert was last updated in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    "alert-updated-at": string;
    "secret-scanning-alert": {
      number?: components["schemas"]["alert-number"];
      created_at?: components["schemas"]["alert-created-at"];
      updated_at?: components["schemas"]["alert-updated-at"];
      url?: components["schemas"]["alert-url"];
      html_url?: components["schemas"]["alert-html-url"];
      /**
       * Format: uri
       * @description The REST API URL of the code locations for this alert.
       */
      locations_url?: string;
      state?: components["schemas"]["secret-scanning-alert-state"];
      resolution?: components["schemas"]["secret-scanning-alert-resolution"];
      /**
       * Format: date-time
       * @description The time that the alert was resolved in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
       */
      resolved_at?: string | null;
      resolved_by?: components["schemas"]["nullable-simple-user"];
      /** @description The type of secret that secret scanning detected. */
      secret_type?: string;
      /** @description The secret that was detected. */
      secret?: string;
    };
    /** @description Represents a 'commit' secret scanning location type. This location type shows that a secret was detected inside a commit to a repository. */
    "secret-scanning-location-commit": {
      /**
       * @description The file path in the repository
       * @example /example/secrets.txt
       */
      path: string;
      /** @description Line number at which the secret starts in the file */
      start_line: number;
      /** @description Line number at which the secret ends in the file */
      end_line: number;
      /** @description The column at which the secret starts within the start line when the file is interpreted as 8BIT ASCII */
      start_column: number;
      /** @description The column at which the secret ends within the end line when the file is interpreted as 8BIT ASCII */
      end_column: number;
      /**
       * @description SHA-1 hash ID of the associated blob
       * @example af5626b4a114abcb82d63db7c8082c3c4756e51b
       */
      blob_sha: string;
      /** @description The API URL to get the associated blob resource */
      blob_url: string;
      /**
       * @description SHA-1 hash ID of the associated commit
       * @example af5626b4a114abcb82d63db7c8082c3c4756e51b
       */
      commit_sha: string;
      /** @description The API URL to get the associated commit resource */
      commit_url: string;
    };
    "secret-scanning-location": {
      /**
       * @description The location type. Because secrets may be found in different types of resources (ie. code, comments, issues), this field identifies the type of resource where the secret was found.
       * @example commit
       * @enum {string}
       */
      type: "commit";
      details: components["schemas"]["secret-scanning-location-commit"];
    };
    /**
     * Stargazer
     * @description Stargazer
     */
    stargazer: {
      /** Format: date-time */
      starred_at: string;
      user: components["schemas"]["nullable-simple-user"];
    };
    /**
     * Code Frequency Stat
     * @description Code Frequency Stat
     */
    "code-frequency-stat": number[];
    /**
     * Commit Activity
     * @description Commit Activity
     */
    "commit-activity": {
      /**
       * @example [
       *   0,
       *   3,
       *   26,
       *   20,
       *   39,
       *   1,
       *   0
       * ]
       */
      days: number[];
      /** @example 89 */
      total: number;
      /** @example 1336280400 */
      week: number;
    };
    /**
     * Contributor Activity
     * @description Contributor Activity
     */
    "contributor-activity": {
      author: components["schemas"]["nullable-simple-user"];
      /** @example 135 */
      total: number;
      /**
       * @example [
       *   {
       *     "w": "1367712000",
       *     "a": 6898,
       *     "d": 77,
       *     "c": 10
       *   }
       * ]
       */
      weeks: {
        w?: number;
        a?: number;
        d?: number;
        c?: number;
      }[];
    };
    /** Participation Stats */
    "participation-stats": {
      all: number[];
      owner: number[];
    };
    /**
     * Repository Invitation
     * @description Repository invitations let you manage who you collaborate with.
     */
    "repository-subscription": {
      /**
       * @description Determines if notifications should be received from this repository.
       * @example true
       */
      subscribed: boolean;
      /** @description Determines if all notifications should be blocked from this repository. */
      ignored: boolean;
      reason: string | null;
      /**
       * Format: date-time
       * @example 2012-10-06T21:34:12Z
       */
      created_at: string;
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/example/subscription
       */
      url: string;
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/example
       */
      repository_url: string;
    };
    /**
     * Tag
     * @description Tag
     */
    tag: {
      /** @example v0.1 */
      name: string;
      commit: {
        sha: string;
        /** Format: uri */
        url: string;
      };
      /**
       * Format: uri
       * @example https://github.com/octocat/Hello-World/zipball/v0.1
       */
      zipball_url: string;
      /**
       * Format: uri
       * @example https://github.com/octocat/Hello-World/tarball/v0.1
       */
      tarball_url: string;
      node_id: string;
    };
    /**
     * Topic
     * @description A topic aggregates entities that are related to a subject.
     */
    topic: {
      names: string[];
    };
    /** Search Result Text Matches */
    "search-result-text-matches": {
      object_url?: string;
      object_type?: string | null;
      property?: string;
      fragment?: string;
      matches?: {
        text?: string;
        indices?: number[];
      }[];
    }[];
    /**
     * Code Search Result Item
     * @description Code Search Result Item
     */
    "code-search-result-item": {
      name: string;
      path: string;
      sha: string;
      /** Format: uri */
      url: string;
      /** Format: uri */
      git_url: string;
      /** Format: uri */
      html_url: string;
      repository: components["schemas"]["minimal-repository"];
      score: number;
      file_size?: number;
      language?: string | null;
      /** Format: date-time */
      last_modified_at?: string;
      /**
       * @example [
       *   "73..77",
       *   "77..78"
       * ]
       */
      line_numbers?: string[];
      text_matches?: components["schemas"]["search-result-text-matches"];
    };
    /**
     * Commit Search Result Item
     * @description Commit Search Result Item
     */
    "commit-search-result-item": {
      /** Format: uri */
      url: string;
      sha: string;
      /** Format: uri */
      html_url: string;
      /** Format: uri */
      comments_url: string;
      commit: {
        author: {
          name: string;
          email: string;
          /** Format: date-time */
          date: string;
        };
        committer: components["schemas"]["nullable-git-user"];
        comment_count: number;
        message: string;
        tree: {
          sha: string;
          /** Format: uri */
          url: string;
        };
        /** Format: uri */
        url: string;
        verification?: components["schemas"]["verification"];
      };
      author: components["schemas"]["nullable-simple-user"];
      committer: components["schemas"]["nullable-git-user"];
      parents: {
        url?: string;
        html_url?: string;
        sha?: string;
      }[];
      repository: components["schemas"]["minimal-repository"];
      score: number;
      node_id: string;
      text_matches?: components["schemas"]["search-result-text-matches"];
    };
    /**
     * Issue Search Result Item
     * @description Issue Search Result Item
     */
    "issue-search-result-item": {
      /** Format: uri */
      url: string;
      /** Format: uri */
      repository_url: string;
      labels_url: string;
      /** Format: uri */
      comments_url: string;
      /** Format: uri */
      events_url: string;
      /** Format: uri */
      html_url: string;
      id: number;
      node_id: string;
      number: number;
      title: string;
      locked: boolean;
      active_lock_reason?: string | null;
      assignees?: components["schemas"]["simple-user"][] | null;
      user: components["schemas"]["nullable-simple-user"];
      labels: {
        /** Format: int64 */
        id?: number;
        node_id?: string;
        url?: string;
        name?: string;
        color?: string;
        default?: boolean;
        description?: string | null;
      }[];
      state: string;
      state_reason?: string | null;
      assignee: components["schemas"]["nullable-simple-user"];
      milestone: components["schemas"]["nullable-milestone"];
      comments: number;
      /** Format: date-time */
      created_at: string;
      /** Format: date-time */
      updated_at: string;
      /** Format: date-time */
      closed_at: string | null;
      text_matches?: components["schemas"]["search-result-text-matches"];
      pull_request?: {
        /** Format: date-time */
        merged_at?: string | null;
        /** Format: uri */
        diff_url: string | null;
        /** Format: uri */
        html_url: string | null;
        /** Format: uri */
        patch_url: string | null;
        /** Format: uri */
        url: string | null;
      };
      body?: string;
      score: number;
      author_association: components["schemas"]["author-association"];
      draft?: boolean;
      repository?: components["schemas"]["repository"];
      body_html?: string;
      body_text?: string;
      /** Format: uri */
      timeline_url?: string;
      performed_via_github_app?: components["schemas"]["nullable-integration"];
      reactions?: components["schemas"]["reaction-rollup"];
    };
    /**
     * Label Search Result Item
     * @description Label Search Result Item
     */
    "label-search-result-item": {
      id: number;
      node_id: string;
      /** Format: uri */
      url: string;
      name: string;
      color: string;
      default: boolean;
      description: string | null;
      score: number;
      text_matches?: components["schemas"]["search-result-text-matches"];
    };
    /**
     * Repo Search Result Item
     * @description Repo Search Result Item
     */
    "repo-search-result-item": {
      id: number;
      node_id: string;
      name: string;
      full_name: string;
      owner: components["schemas"]["nullable-simple-user"];
      private: boolean;
      /** Format: uri */
      html_url: string;
      description: string | null;
      fork: boolean;
      /** Format: uri */
      url: string;
      /** Format: date-time */
      created_at: string;
      /** Format: date-time */
      updated_at: string;
      /** Format: date-time */
      pushed_at: string;
      /** Format: uri */
      homepage: string | null;
      size: number;
      stargazers_count: number;
      watchers_count: number;
      language: string | null;
      forks_count: number;
      open_issues_count: number;
      master_branch?: string;
      default_branch: string;
      score: number;
      /** Format: uri */
      forks_url: string;
      keys_url: string;
      collaborators_url: string;
      /** Format: uri */
      teams_url: string;
      /** Format: uri */
      hooks_url: string;
      issue_events_url: string;
      /** Format: uri */
      events_url: string;
      assignees_url: string;
      branches_url: string;
      /** Format: uri */
      tags_url: string;
      blobs_url: string;
      git_tags_url: string;
      git_refs_url: string;
      trees_url: string;
      statuses_url: string;
      /** Format: uri */
      languages_url: string;
      /** Format: uri */
      stargazers_url: string;
      /** Format: uri */
      contributors_url: string;
      /** Format: uri */
      subscribers_url: string;
      /** Format: uri */
      subscription_url: string;
      commits_url: string;
      git_commits_url: string;
      comments_url: string;
      issue_comment_url: string;
      contents_url: string;
      compare_url: string;
      /** Format: uri */
      merges_url: string;
      archive_url: string;
      /** Format: uri */
      downloads_url: string;
      issues_url: string;
      pulls_url: string;
      milestones_url: string;
      notifications_url: string;
      labels_url: string;
      releases_url: string;
      /** Format: uri */
      deployments_url: string;
      git_url: string;
      ssh_url: string;
      clone_url: string;
      /** Format: uri */
      svn_url: string;
      forks: number;
      open_issues: number;
      watchers: number;
      topics?: string[];
      /** Format: uri */
      mirror_url: string | null;
      has_issues: boolean;
      has_projects: boolean;
      has_pages: boolean;
      has_wiki: boolean;
      has_downloads: boolean;
      archived: boolean;
      /** @description Returns whether or not this repository disabled. */
      disabled: boolean;
      /** @description The repository visibility: public, private, or internal. */
      visibility?: string;
      license: components["schemas"]["nullable-license-simple"];
      permissions?: {
        admin: boolean;
        maintain?: boolean;
        push: boolean;
        triage?: boolean;
        pull: boolean;
      };
      text_matches?: components["schemas"]["search-result-text-matches"];
      temp_clone_token?: string;
      allow_merge_commit?: boolean;
      allow_squash_merge?: boolean;
      allow_rebase_merge?: boolean;
      allow_auto_merge?: boolean;
      delete_branch_on_merge?: boolean;
      allow_forking?: boolean;
      is_template?: boolean;
    };
    /**
     * Topic Search Result Item
     * @description Topic Search Result Item
     */
    "topic-search-result-item": {
      name: string;
      display_name: string | null;
      short_description: string | null;
      description: string | null;
      created_by: string | null;
      released: string | null;
      /** Format: date-time */
      created_at: string;
      /** Format: date-time */
      updated_at: string;
      featured: boolean;
      curated: boolean;
      score: number;
      repository_count?: number | null;
      /** Format: uri */
      logo_url?: string | null;
      text_matches?: components["schemas"]["search-result-text-matches"];
      related?:
        | {
            topic_relation?: {
              id?: number;
              name?: string;
              topic_id?: number;
              relation_type?: string;
            };
          }[]
        | null;
      aliases?:
        | {
            topic_relation?: {
              id?: number;
              name?: string;
              topic_id?: number;
              relation_type?: string;
            };
          }[]
        | null;
    };
    /**
     * User Search Result Item
     * @description User Search Result Item
     */
    "user-search-result-item": {
      login: string;
      id: number;
      node_id: string;
      /** Format: uri */
      avatar_url: string;
      gravatar_id: string | null;
      /** Format: uri */
      url: string;
      /** Format: uri */
      html_url: string;
      /** Format: uri */
      followers_url: string;
      /** Format: uri */
      subscriptions_url: string;
      /** Format: uri */
      organizations_url: string;
      /** Format: uri */
      repos_url: string;
      /** Format: uri */
      received_events_url: string;
      type: string;
      score: number;
      following_url: string;
      gists_url: string;
      starred_url: string;
      events_url: string;
      public_repos?: number;
      public_gists?: number;
      followers?: number;
      following?: number;
      /** Format: date-time */
      created_at?: string;
      /** Format: date-time */
      updated_at?: string;
      name?: string | null;
      bio?: string | null;
      /** Format: email */
      email?: string | null;
      location?: string | null;
      site_admin: boolean;
      hireable?: boolean | null;
      text_matches?: components["schemas"]["search-result-text-matches"];
      blog?: string | null;
      company?: string | null;
      /** Format: date-time */
      suspended_at?: string | null;
    };
    "configuration-status": {
      status?: string;
      progress?: {
        status: string;
        key: string;
      }[];
    };
    "maintenance-status": {
      status?: string;
      scheduled_time?: string;
      connection_services?: {
        name: string;
        number: number;
      }[];
    };
    "enterprise-settings": {
      enterprise?: {
        private_mode?: boolean;
        public_pages?: boolean;
        subdomain_isolation?: boolean;
        signup_enabled?: boolean;
        github_hostname?: string;
        identicons_host?: string;
        http_proxy?: string | null;
        auth_mode?: string;
        expire_sessions?: boolean;
        admin_password?: string | null;
        configuration_id?: number;
        configuration_run_count?: number;
        avatar?: {
          enabled?: boolean;
          uri?: string;
        };
        customer?: {
          name?: string;
          email?: string;
          uuid?: string;
          secret_key_data?: string;
          public_key_data?: string;
        };
        license?: {
          seats?: number;
          evaluation?: boolean;
          perpetual?: boolean;
          unlimited_seating?: boolean;
          support_key?: string;
          ssh_allowed?: boolean;
          cluster_support?: boolean;
          expire_at?: string;
        };
        github_ssl?: {
          enabled?: boolean;
          cert?: string | null;
          key?: string | null;
        };
        ldap?: {
          host?: string | null;
          port?: number;
          base?: unknown[];
          uid?: string | null;
          bind_dn?: string | null;
          password?: string | null;
          method?: string;
          search_strategy?: string;
          user_groups?: unknown[];
          admin_group?: string | null;
          virtual_attribute_enabled?: boolean;
          recursive_group_search?: boolean;
          posix_support?: boolean;
          user_sync_emails?: boolean;
          user_sync_keys?: boolean;
          user_sync_interval?: number;
          team_sync_interval?: number;
          sync_enabled?: boolean;
          reconciliation?: {
            user?: string | null;
            org?: string | null;
          };
          profile?: {
            uid?: string;
            name?: string | null;
            mail?: string | null;
            key?: string | null;
          };
        };
        cas?: {
          url?: string | null;
        };
        saml?: {
          sso_url?: string | null;
          certificate?: string | null;
          certificate_path?: string | null;
          issuer?: string | null;
          idp_initiated_sso?: boolean;
          disable_admin_demote?: boolean;
        };
        github_oauth?: {
          client_id?: string;
          client_secret?: string;
          organization_name?: string;
          organization_team?: string;
        };
        smtp?: {
          enabled?: boolean;
          address?: string;
          authentication?: string;
          port?: string;
          domain?: string;
          username?: string;
          user_name?: string;
          enable_starttls_auto?: boolean;
          password?: string;
          "discard-to-noreply-address"?: boolean;
          support_address?: string;
          support_address_type?: string;
          noreply_address?: string;
        };
        ntp?: {
          primary_server?: string;
          secondary_server?: string;
        };
        timezone?: string | null;
        snmp?: {
          enabled?: boolean;
          community?: string;
        };
        syslog?: {
          enabled?: boolean;
          server?: string | null;
          protocol_name?: string;
        };
        assets?: string | null;
        pages?: {
          enabled?: boolean;
        };
        collectd?: {
          enabled?: boolean;
          server?: string | null;
          port?: number;
          encryption?: string | null;
          username?: string | null;
          password?: string | null;
        };
        mapping?: {
          enabled?: boolean;
          tileserver?: string | null;
          basemap?: string;
          token?: string | null;
        };
        load_balancer?: string | null;
      };
      run_list?: string[];
    };
    "ssh-key": {
      key?: string;
      "pretty-print"?: string;
    };
    /**
     * Private User
     * @description Private User
     */
    "private-user": {
      /** @example octocat */
      login: string;
      /** @example 1 */
      id: number;
      /** @example MDQ6VXNlcjE= */
      node_id: string;
      /**
       * Format: uri
       * @example https://github.com/images/error/octocat_happy.gif
       */
      avatar_url: string;
      /** @example 41d064eb2195891e12d0413f63227ea7 */
      gravatar_id: string | null;
      /**
       * Format: uri
       * @example https://api.github.com/users/octocat
       */
      url: string;
      /**
       * Format: uri
       * @example https://github.com/octocat
       */
      html_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/users/octocat/followers
       */
      followers_url: string;
      /** @example https://api.github.com/users/octocat/following{/other_user} */
      following_url: string;
      /** @example https://api.github.com/users/octocat/gists{/gist_id} */
      gists_url: string;
      /** @example https://api.github.com/users/octocat/starred{/owner}{/repo} */
      starred_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/users/octocat/subscriptions
       */
      subscriptions_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/users/octocat/orgs
       */
      organizations_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/users/octocat/repos
       */
      repos_url: string;
      /** @example https://api.github.com/users/octocat/events{/privacy} */
      events_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/users/octocat/received_events
       */
      received_events_url: string;
      /** @example User */
      type: string;
      site_admin: boolean;
      /** @example monalisa octocat */
      name: string | null;
      /** @example GitHub */
      company: string | null;
      /** @example https://github.com/blog */
      blog: string | null;
      /** @example San Francisco */
      location: string | null;
      /**
       * Format: email
       * @example octocat@github.com
       */
      email: string | null;
      hireable: boolean | null;
      /** @example There once was... */
      bio: string | null;
      /** @example monalisa */
      twitter_username?: string | null;
      /** @example 2 */
      public_repos: number;
      /** @example 1 */
      public_gists: number;
      /** @example 20 */
      followers: number;
      /** @example 0 */
      following: number;
      /**
       * Format: date-time
       * @example 2008-01-14T04:33:35Z
       */
      created_at: string;
      /**
       * Format: date-time
       * @example 2008-01-14T04:33:35Z
       */
      updated_at: string;
      /** @example 81 */
      private_gists: number;
      /** @example 100 */
      total_private_repos: number;
      /** @example 100 */
      owned_private_repos: number;
      /** @example 10000 */
      disk_usage: number;
      /** @example 8 */
      collaborators: number;
      /** @example true */
      two_factor_authentication: boolean;
      plan?: {
        collaborators: number;
        name: string;
        space: number;
        private_repos: number;
      };
      /** Format: date-time */
      suspended_at?: string | null;
      business_plus?: boolean;
      ldap_dn?: string;
    };
    /**
     * Email
     * @description Email
     */
    email: {
      /**
       * Format: email
       * @example octocat@github.com
       */
      email: string;
      /** @example true */
      primary: boolean;
      /** @example true */
      verified: boolean;
      /** @example public */
      visibility: string | null;
    };
    /**
     * GPG Key
     * @description A unique encryption key
     */
    "gpg-key": {
      /** @example 3 */
      id: number;
      primary_key_id: number | null;
      /** @example 3262EFF25BA0D270 */
      key_id: string;
      /** @example xsBNBFayYZ... */
      public_key: string;
      /**
       * @example [
       *   {
       *     "email": "octocat@users.noreply.github.com",
       *     "verified": true
       *   }
       * ]
       */
      emails: {
        email?: string;
        verified?: boolean;
      }[];
      /**
       * @example [
       *   {
       *     "id": 4,
       *     "primary_key_id": 3,
       *     "key_id": "4A595D4C72EE49C7",
       *     "public_key": "zsBNBFayYZ...",
       *     "emails": [],
       *     "subkeys": [],
       *     "can_sign": false,
       *     "can_encrypt_comms": true,
       *     "can_encrypt_storage": true,
       *     "can_certify": false,
       *     "created_at": "2016-03-24T11:31:04-06:00",
       *     "expires_at": null
       *   }
       * ]
       */
      subkeys: {
        id?: number;
        primary_key_id?: number;
        key_id?: string;
        public_key?: string;
        emails?: unknown[];
        subkeys?: unknown[];
        can_sign?: boolean;
        can_encrypt_comms?: boolean;
        can_encrypt_storage?: boolean;
        can_certify?: boolean;
        created_at?: string;
        expires_at?: string | null;
        raw_key?: string | null;
      }[];
      /** @example true */
      can_sign: boolean;
      can_encrypt_comms: boolean;
      can_encrypt_storage: boolean;
      /** @example true */
      can_certify: boolean;
      /**
       * Format: date-time
       * @example 2016-03-24T11:31:04-06:00
       */
      created_at: string;
      /** Format: date-time */
      expires_at: string | null;
      raw_key: string | null;
    };
    /**
     * Key
     * @description Key
     */
    key: {
      key: string;
      id: number;
      url: string;
      title: string;
      /** Format: date-time */
      created_at: string;
      verified: boolean;
      read_only: boolean;
    };
    /**
     * Starred Repository
     * @description Starred Repository
     */
    "starred-repository": {
      /** Format: date-time */
      starred_at: string;
      repo: components["schemas"]["repository"];
    };
    /**
     * Hovercard
     * @description Hovercard
     */
    hovercard: {
      contexts: {
        message: string;
        octicon: string;
      }[];
    };
    /**
     * Key Simple
     * @description Key Simple
     */
    "key-simple": {
      id: number;
      key: string;
    };
  };
  responses: {
    /** Resource not found */
    not_found: {
      content: {
        "application/json": components["schemas"]["basic-error"];
      };
    };
    /** Validation failed, or the endpoint has been spammed. */
    validation_failed_simple: {
      content: {
        "application/json": components["schemas"]["validation-error-simple"];
      };
    };
    /** Bad Request */
    bad_request: {
      content: {
        "application/json": components["schemas"]["basic-error"];
        "application/scim+json": components["schemas"]["scim-error"];
      };
    };
    /** Validation failed, or the endpoint has been spammed. */
    validation_failed: {
      content: {
        "application/json": components["schemas"]["validation-error"];
      };
    };
    /** Accepted */
    accepted: {
      content: {
        "application/json": { [key: string]: unknown };
      };
    };
    /** Forbidden */
    forbidden: {
      content: {
        "application/json": components["schemas"]["basic-error"];
      };
    };
    /** Requires authentication */
    requires_authentication: {
      content: {
        "application/json": components["schemas"]["basic-error"];
      };
    };
    /** Not modified */
    not_modified: unknown;
    /** Gone */
    gone: {
      content: {
        "application/json": components["schemas"]["basic-error"];
      };
    };
    /** Service unavailable */
    service_unavailable: {
      content: {
        "application/json": {
          code?: string;
          message?: string;
          documentation_url?: string;
        };
      };
    };
    /** Forbidden Gist */
    forbidden_gist: {
      content: {
        "application/json": {
          block?: {
            reason?: string;
            created_at?: string;
            html_url?: string | null;
          };
          message?: string;
          documentation_url?: string;
        };
      };
    };
    /** Moved permanently */
    moved_permanently: {
      content: {
        "application/json": components["schemas"]["basic-error"];
      };
    };
    /** Conflict */
    conflict: {
      content: {
        "application/json": components["schemas"]["basic-error"];
      };
    };
    /** Temporary Redirect */
    temporary_redirect: {
      content: {
        "application/json": components["schemas"]["basic-error"];
      };
    };
    /** Internal Error */
    internal_error: {
      content: {
        "application/json": components["schemas"]["basic-error"];
      };
    };
    /** Response if GitHub Advanced Security is not enabled for this repository */
    code_scanning_forbidden_read: {
      content: {
        "application/json": components["schemas"]["basic-error"];
      };
    };
    /** Response if the repository is archived or if GitHub Advanced Security is not enabled for this repository */
    code_scanning_forbidden_write: {
      content: {
        "application/json": components["schemas"]["basic-error"];
      };
    };
    /** Preview header missing */
    preview_header_missing: {
      content: {
        "application/json": {
          message: string;
          documentation_url: string;
        };
      };
    };
    /** Found */
    found: unknown;
    /** A header with no content is returned. */
    no_content: unknown;
  };
  parameters: {
    /** @description The number of results per page (max 100). */
    "per-page": number;
    /** @description Page number of the results to fetch. */
    page: number;
    /** @description The unique identifier of the hook. */
    "hook-id": number;
    /** @description The direction to sort the results by. */
    direction: "asc" | "desc";
    /** @description The unique identifier of the key. */
    "key-ids": string;
    /** @description The unique identifier of the team. */
    "team-id": number;
    /** @description The handle for the GitHub user account. */
    username: string;
    /** @description The organization name. The name is not case sensitive. */
    org: string;
    /** @description The unique identifier of the pre-receive environment. */
    "pre-receive-environment-id": number;
    /** @description The unique identifier of the pre-receive hook. */
    "pre-receive-hook-id": number;
    /** @description The unique identifier of the token. */
    "token-id": number;
    /** @description Used for pagination: the starting delivery from which the page of deliveries is fetched. Refer to the `link` header for the next and previous page cursors. */
    cursor: string;
    "delivery-id": number;
    /** @description Only show notifications updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`. */
    since: string;
    /** @description The unique identifier of the installation. */
    "installation-id": number;
    /** @description The unique identifier of the grant. */
    "grant-id": number;
    /** @description The client ID of the GitHub app. */
    "client-id": string;
    "access-token": string;
    "app-slug": string;
    /** @description The client ID of the OAuth app. */
    "oauth-client-id": string;
    /** @description The unique identifier of the authorization. */
    "authorization-id": number;
    /** @description The slug version of the enterprise name. You can also substitute this value with the enterprise id. */
    enterprise: string;
    /** @description The unique identifier of the organization. */
    "org-id": number;
    /** @description Unique identifier of the self-hosted runner group. */
    "runner-group-id": number;
    /** @description Unique identifier of the self-hosted runner. */
    "runner-id": number;
    /** @description A search phrase. For more information, see [Searching the audit log](https://docs.github.com/enterprise-server@3.3/github/setting-up-and-managing-organizations-and-teams/reviewing-the-audit-log-for-your-organization#searching-the-audit-log). */
    "audit-log-phrase": string;
    /** @description A cursor, as given in the [Link header](https://docs.github.com/enterprise-server@3.3/rest/overview/resources-in-the-rest-api#link-header). If specified, the query only searches for events after this cursor. */
    "audit-log-after": string;
    /** @description A cursor, as given in the [Link header](https://docs.github.com/enterprise-server@3.3/rest/overview/resources-in-the-rest-api#link-header). If specified, the query only searches for events before this cursor. */
    "audit-log-before": string;
    /**
     * @description The order of audit log events. To list newest events first, specify `desc`. To list oldest events first, specify `asc`.
     *
     * The default is `desc`.
     */
    "audit-log-order": "desc" | "asc";
    /** @description The unique identifier of the gist. */
    "gist-id": string;
    /** @description The unique identifier of the comment. */
    "comment-id": number;
    /** @description A list of comma separated label names. Example: `bug,ui,@high` */
    labels: string;
    /** @description The account owner of the repository. The name is not case sensitive. */
    owner: string;
    /** @description The name of the repository. The name is not case sensitive. */
    repo: string;
    /** @description If `true`, show notifications marked as read. */
    all: boolean;
    /** @description If `true`, only shows notifications in which the user is directly participating or mentioned. */
    participating: boolean;
    /** @description Only show notifications updated before the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`. */
    before: string;
    /** @description The unique identifier of the pull request thread. */
    "thread-id": number;
    /** @description An organization ID. Only return organizations with an ID greater than this ID. */
    "since-org": number;
    /** @description The unique identifier of the repository. */
    "repository-id": number;
    /** @description The name of the secret. */
    "secret-name": string;
    /** @description Set to `open` or `resolved` to only list secret scanning alerts in a specific state. */
    "secret-scanning-alert-state": "open" | "resolved";
    /**
     * @description A comma-separated list of secret types to return. By default all secret types are returned.
     * See "[Secret scanning patterns](https://docs.github.com/enterprise-server@3.3/code-security/secret-scanning/secret-scanning-patterns#supported-secrets-for-advanced-security)"
     * for a complete list of secret types.
     */
    "secret-scanning-alert-secret-type": string;
    /** @description A comma-separated list of resolutions. Only secret scanning alerts with one of these resolutions are listed. Valid resolutions are `false_positive`, `wont_fix`, `revoked`, `pattern_edited`, `pattern_deleted` or `used_in_tests`. */
    "secret-scanning-alert-resolution": string;
    /** @description The slug of the team name. */
    "team-slug": string;
    /** @description The number that identifies the discussion. */
    "discussion-number": number;
    /** @description The number that identifies the comment. */
    "comment-number": number;
    /** @description The unique identifier of the reaction. */
    "reaction-id": number;
    /** @description The unique identifier of the project. */
    "project-id": number;
    /** @description The unique identifier of the card. */
    "card-id": number;
    /** @description The unique identifier of the column. */
    "column-id": number;
    /** @description The unique identifier of the artifact. */
    "artifact-id": number;
    /** @description The unique identifier of the job. */
    "job-id": number;
    /** @description Returns someone's workflow runs. Use the login for the user who created the `push` associated with the check suite or workflow run. */
    actor: string;
    /** @description Returns workflow runs associated with a branch. Use the name of the branch of the `push`. */
    "workflow-run-branch": string;
    /** @description Returns workflow run triggered by the event you specify. For example, `push`, `pull_request` or `issue`. For more information, see "[Events that trigger workflows](https://docs.github.com/en/actions/automating-your-workflow-with-github-actions/events-that-trigger-workflows)." */
    event: string;
    /** @description Returns workflow runs with the check run `status` or `conclusion` that you specify. For example, a conclusion can be `success` or a status can be `in_progress`. Only GitHub can set a status of `waiting` or `requested`. */
    "workflow-run-status":
      | "completed"
      | "action_required"
      | "cancelled"
      | "failure"
      | "neutral"
      | "skipped"
      | "stale"
      | "success"
      | "timed_out"
      | "in_progress"
      | "queued"
      | "requested"
      | "waiting";
    /** @description Returns workflow runs created within the given date-time range. For more information on the syntax, see "[Understanding the search syntax](https://docs.github.com/enterprise-server@3.3/search-github/getting-started-with-searching-on-github/understanding-the-search-syntax#query-for-dates)." */
    created: string;
    /** @description If `true` pull requests are omitted from the response (empty array). */
    "exclude-pull-requests": boolean;
    /** @description The unique identifier of the workflow run. */
    "run-id": number;
    /** @description The ID of the workflow. You can also pass the workflow file name as a string. */
    "workflow-id": number | string;
    /** @description The unique identifier of the autolink. */
    "autolink-id": number;
    /** @description The name of the branch. */
    branch: string;
    /** @description The unique identifier of the check run. */
    "check-run-id": number;
    /** @description The unique identifier of the check suite. */
    "check-suite-id": number;
    /** @description Returns check runs with the specified `name`. */
    "check-name": string;
    /** @description Returns check runs with the specified `status`. */
    status: "queued" | "in_progress" | "completed";
    /** @description The name of a code scanning tool. Only results by this tool will be listed. You can specify the tool by using either `tool_name` or `tool_guid`, but not both. */
    "tool-name": components["schemas"]["code-scanning-analysis-tool-name"];
    /** @description The GUID of a code scanning tool. Only results by this tool will be listed. Note that some code scanning tools may not include a GUID in their analysis data. You can specify the tool by using either `tool_guid` or `tool_name`, but not both. */
    "tool-guid": components["schemas"]["code-scanning-analysis-tool-guid"];
    /** @description The Git reference for the results you want to list. The `ref` for a branch can be formatted either as `refs/heads/<branch name>` or simply `<branch name>`. To reference a pull request use `refs/pull/<number>/merge`. */
    "git-ref": components["schemas"]["code-scanning-ref"];
    /** @description The number that identifies an alert. You can find this at the end of the URL for a code scanning alert within GitHub, and in the `number` field in the response from the `GET /repos/{owner}/{repo}/code-scanning/alerts` operation. */
    "alert-number": components["schemas"]["alert-number"];
    /** @description The SHA of the commit. */
    "commit-sha": string;
    /** @description deployment_id parameter */
    "deployment-id": number;
    /** @description The name of the environment. */
    "environment-name": string;
    /** @description The unique identifier of the branch policy. */
    "branch-policy-id": number;
    /** @description The unique identifier of the invitation. */
    "invitation-id": number;
    /** @description The property to sort the results by. `created` means when the repository was starred. `updated` means when the repository was last pushed to. */
    sort: "created" | "updated";
    /** @description The number that identifies the issue. */
    "issue-number": number;
    /** @description The unique identifier of the key. */
    "key-id": number;
    /** @description The number that identifies the milestone. */
    "milestone-number": number;
    /** @description The number that identifies the pull request. */
    "pull-number": number;
    /** @description The unique identifier of the review. */
    "review-id": number;
    /** @description The unique identifier of the asset. */
    "asset-id": number;
    /** @description The unique identifier of the release. */
    "release-id": number;
    /** @description A repository ID. Only return repositories with an ID greater than this ID. */
    "since-repo": number;
    /** @description Determines whether the first search result returned is the highest number of matches (`desc`) or lowest number of matches (`asc`). This parameter is ignored unless you provide `sort`. */
    order: "desc" | "asc";
    /** @description The unique identifier of the GPG key. */
    "gpg-key-id": number;
    /** @description A user ID. Only return users with an ID greater than this ID. */
    "since-user": number;
  };
  headers: {
    link?: string;
    "content-type"?: string;
    "x-common-marker-version"?: string;
    "x-rate-limit-limit"?: number;
    "x-rate-limit-remaining"?: number;
    "x-rate-limit-reset"?: number;
    location?: string;
  };
}

export interface operations {
  /** Get Hypermedia links to resources accessible in GitHub's REST API */
  "meta/root": {
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["root"];
        };
      };
    };
  };
  "enterprise-admin/list-global-webhooks": {
    parameters: {
      query: {
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /** Response */
      200: {
        headers: {};
        content: {
          "application/json": components["schemas"]["global-hook"][];
        };
      };
    };
  };
  "enterprise-admin/create-global-webhook": {
    responses: {
      /** Response */
      201: {
        content: {
          "application/json": components["schemas"]["global-hook"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": {
          /** @description Must be passed as "web". */
          name: string;
          /** @description Key/value pairs to provide settings for this webhook. */
          config: {
            /** @description The URL to which the payloads will be delivered. */
            url: string;
            /** @description The media type used to serialize the payloads. Supported values include `json` and `form`. The default is `form`. */
            content_type?: string;
            /** @description If provided, the `secret` will be used as the `key` to generate the HMAC hex digest value in the [`X-Hub-Signature`](https://docs.github.com/enterprise-server@3.3/webhooks/event-payloads/#delivery-headers) header. */
            secret?: string;
            /** @description Determines whether the SSL certificate of the host for `url` will be verified when delivering payloads. Supported values include `0` (verification is performed) and `1` (verification is not performed). The default is `0`. **We strongly recommend not setting this to `1` as you are subject to man-in-the-middle and other attacks.** */
            insecure_ssl?: string;
          };
          /** @description The [events](https://docs.github.com/enterprise-server@3.3/webhooks/event-payloads) that trigger this webhook. A global webhook can be triggered by `user` and `organization` events. Default: `user` and `organization`. */
          events?: string[];
          /**
           * @description Determines if notifications are sent when the webhook is triggered. Set to `true` to send notifications.
           * @default true
           */
          active?: boolean;
        };
      };
    };
  };
  "enterprise-admin/get-global-webhook": {
    parameters: {
      path: {
        /** The unique identifier of the hook. */
        hook_id: components["parameters"]["hook-id"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["global-hook"];
        };
      };
    };
  };
  "enterprise-admin/delete-global-webhook": {
    parameters: {
      path: {
        /** The unique identifier of the hook. */
        hook_id: components["parameters"]["hook-id"];
      };
    };
    responses: {
      /** Response */
      204: never;
    };
  };
  /** Parameters that are not provided will be overwritten with the default value or removed if no default exists. */
  "enterprise-admin/update-global-webhook": {
    parameters: {
      path: {
        /** The unique identifier of the hook. */
        hook_id: components["parameters"]["hook-id"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["global-hook-2"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": {
          /** @description Key/value pairs to provide settings for this webhook. */
          config?: {
            /** @description The URL to which the payloads will be delivered. */
            url: string;
            /** @description The media type used to serialize the payloads. Supported values include `json` and `form`. The default is `form`. */
            content_type?: string;
            /** @description If provided, the `secret` will be used as the `key` to generate the HMAC hex digest value in the [`X-Hub-Signature`](https://docs.github.com/enterprise-server@3.3/webhooks/event-payloads/#delivery-headers) header. */
            secret?: string;
            /** @description Determines whether the SSL certificate of the host for `url` will be verified when delivering payloads. Supported values include `0` (verification is performed) and `1` (verification is not performed). The default is `0`. **We strongly recommend not setting this to `1` as you are subject to man-in-the-middle and other attacks.** */
            insecure_ssl?: string;
          };
          /** @description The [events](https://docs.github.com/enterprise-server@3.3/webhooks/event-payloads) that trigger this webhook. A global webhook can be triggered by `user` and `organization` events. Default: `user` and `organization`. */
          events?: string[];
          /**
           * @description Determines if notifications are sent when the webhook is triggered. Set to `true` to send notifications.
           * @default true
           */
          active?: boolean;
        };
      };
    };
  };
  /** This will trigger a [ping event](https://docs.github.com/enterprise-server@3.3/webhooks/#ping-event) to be sent to the webhook. */
  "enterprise-admin/ping-global-webhook": {
    parameters: {
      path: {
        /** The unique identifier of the hook. */
        hook_id: components["parameters"]["hook-id"];
      };
    };
    responses: {
      /** Response */
      204: never;
    };
  };
  "enterprise-admin/list-public-keys": {
    parameters: {
      query: {
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
        /** The direction to sort the results by. */
        direction?: components["parameters"]["direction"];
        sort?: "created" | "updated" | "accessed";
        /** Only show public keys accessed after the given time. */
        since?: string;
      };
    };
    responses: {
      /** Response */
      200: {
        headers: {};
        content: {
          "application/json": components["schemas"]["public-key-full"][];
        };
      };
    };
  };
  "enterprise-admin/delete-public-key": {
    parameters: {
      path: {
        /** The unique identifier of the key. */
        key_ids: components["parameters"]["key-ids"];
      };
    };
    responses: {
      /** Response */
      204: never;
    };
  };
  /** Updates the [distinguished name](https://www.ldap.com/ldap-dns-and-rdns) (DN) of the LDAP entry to map to a team. [LDAP synchronization](https://docs.github.com/enterprise-server@3.3/admin/identity-and-access-management/using-ldap-for-enterprise-iam/using-ldap#enabling-ldap-sync) must be enabled to map LDAP entries to a team. Use the [Create a team](https://docs.github.com/enterprise-server@3.3/rest/reference/teams/#create-a-team) endpoint to create a team with LDAP mapping. */
  "enterprise-admin/update-ldap-mapping-for-team": {
    parameters: {
      path: {
        /** The unique identifier of the team. */
        team_id: components["parameters"]["team-id"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["ldap-mapping-team"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": {
          /** @description The [distinguished name](https://www.ldap.com/ldap-dns-and-rdns) (DN) of the LDAP entry to map to a team. */
          ldap_dn: string;
        };
      };
    };
  };
  /** Note that this API call does not automatically initiate an LDAP sync. Rather, if a `201` is returned, the sync job is queued successfully, and is performed when the instance is ready. */
  "enterprise-admin/sync-ldap-mapping-for-team": {
    parameters: {
      path: {
        /** The unique identifier of the team. */
        team_id: components["parameters"]["team-id"];
      };
    };
    responses: {
      /** Response */
      201: {
        content: {
          "application/json": {
            status?: string;
          };
        };
      };
    };
  };
  "enterprise-admin/update-ldap-mapping-for-user": {
    parameters: {
      path: {
        /** The handle for the GitHub user account. */
        username: components["parameters"]["username"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["ldap-mapping-user"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": {
          /** @description The [distinguished name](https://www.ldap.com/ldap-dns-and-rdns) (DN) of the LDAP entry to map to a team. */
          ldap_dn: string;
        };
      };
    };
  };
  /** Note that this API call does not automatically initiate an LDAP sync. Rather, if a `201` is returned, the sync job is queued successfully, and is performed when the instance is ready. */
  "enterprise-admin/sync-ldap-mapping-for-user": {
    parameters: {
      path: {
        /** The handle for the GitHub user account. */
        username: components["parameters"]["username"];
      };
    };
    responses: {
      /** Response */
      201: {
        content: {
          "application/json": {
            status?: string;
          };
        };
      };
    };
  };
  "enterprise-admin/create-org": {
    responses: {
      /** Response */
      201: {
        content: {
          "application/json": components["schemas"]["organization-simple"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": {
          /** @description The organization's username. */
          login: string;
          /** @description The login of the user who will manage this organization. */
          admin: string;
          /** @description The organization's display name. */
          profile_name?: string;
        };
      };
    };
  };
  "enterprise-admin/update-org-name": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
    };
    responses: {
      /** Response */
      202: {
        content: {
          "application/json": {
            message?: string;
            url?: string;
          };
        };
      };
    };
    requestBody: {
      content: {
        "application/json": {
          /** @description The organization's new name. */
          login: string;
        };
      };
    };
  };
  "enterprise-admin/list-pre-receive-environments": {
    parameters: {
      query: {
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
        /** The direction to sort the results by. */
        direction?: components["parameters"]["direction"];
        sort?: "created" | "updated" | "name";
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["pre-receive-environment"][];
        };
      };
    };
  };
  "enterprise-admin/create-pre-receive-environment": {
    responses: {
      /** Response */
      201: {
        content: {
          "application/json": components["schemas"]["pre-receive-environment"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": {
          /** @description The new pre-receive environment's name. */
          name: string;
          /** @description URL from which to download a tarball of this environment. */
          image_url: string;
        };
      };
    };
  };
  "enterprise-admin/get-pre-receive-environment": {
    parameters: {
      path: {
        /** The unique identifier of the pre-receive environment. */
        pre_receive_environment_id: components["parameters"]["pre-receive-environment-id"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["pre-receive-environment"];
        };
      };
    };
  };
  /**
   * If you attempt to delete an environment that cannot be deleted, you will receive a `422 Unprocessable Entity` response.
   *
   * The possible error messages are:
   *
   * *   _Cannot modify or delete the default environment_
   * *   _Cannot delete environment that has hooks_
   * *   _Cannot delete environment when download is in progress_
   */
  "enterprise-admin/delete-pre-receive-environment": {
    parameters: {
      path: {
        /** The unique identifier of the pre-receive environment. */
        pre_receive_environment_id: components["parameters"]["pre-receive-environment-id"];
      };
    };
    responses: {
      /** Response */
      204: never;
      /** Client Errors */
      422: {
        content: {
          "application/json": {
            message?: string;
            errors?: {
              resource?: string;
              code?: string;
              message?: string;
            }[];
          };
        };
      };
    };
  };
  /** You cannot modify the default environment. If you attempt to modify the default environment, you will receive a `422 Unprocessable Entity` response. */
  "enterprise-admin/update-pre-receive-environment": {
    parameters: {
      path: {
        /** The unique identifier of the pre-receive environment. */
        pre_receive_environment_id: components["parameters"]["pre-receive-environment-id"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["pre-receive-environment"];
        };
      };
      /** Client Errors */
      422: {
        content: {
          "application/json": {
            message?: string;
            errors?: {
              resource?: string;
              code?: string;
              message?: string;
            }[];
          };
        };
      };
    };
    requestBody: {
      content: {
        "application/json": {
          /** @description This pre-receive environment's new name. */
          name?: string;
          /** @description URL from which to download a tarball of this environment. */
          image_url?: string;
        };
      };
    };
  };
  /**
   * Triggers a new download of the environment tarball from the environment's `image_url`. When the download is finished, the newly downloaded tarball will overwrite the existing environment.
   *
   * If a download cannot be triggered, you will receive a `422 Unprocessable Entity` response.
   *
   * The possible error messages are:
   *
   * * _Cannot modify or delete the default environment_
   * * _Can not start a new download when a download is in progress_
   */
  "enterprise-admin/start-pre-receive-environment-download": {
    parameters: {
      path: {
        /** The unique identifier of the pre-receive environment. */
        pre_receive_environment_id: components["parameters"]["pre-receive-environment-id"];
      };
    };
    responses: {
      /** Response */
      202: {
        content: {
          "application/json": components["schemas"]["pre-receive-environment-download-status"];
        };
      };
      /** Client Errors */
      422: {
        content: {
          "application/json": {
            message?: string;
            errors?: {
              resource?: string;
              code?: string;
              message?: string;
            }[];
          };
        };
      };
    };
  };
  /** In addition to seeing the download status at the "[Get a pre-receive environment](#get-a-pre-receive-environment)" endpoint, there is also this separate endpoint for just the download status. */
  "enterprise-admin/get-download-status-for-pre-receive-environment": {
    parameters: {
      path: {
        /** The unique identifier of the pre-receive environment. */
        pre_receive_environment_id: components["parameters"]["pre-receive-environment-id"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["pre-receive-environment-download-status"];
        };
      };
    };
  };
  "enterprise-admin/list-pre-receive-hooks": {
    parameters: {
      query: {
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
        /** The direction to sort the results by. */
        direction?: components["parameters"]["direction"];
        /** The property to sort the results by. */
        sort?: "created" | "updated" | "name";
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["pre-receive-hook"][];
        };
      };
    };
  };
  "enterprise-admin/create-pre-receive-hook": {
    responses: {
      /** Response */
      201: {
        content: {
          "application/json": components["schemas"]["pre-receive-hook"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": {
          /** @description The name of the hook. */
          name: string;
          /** @description The script that the hook runs. */
          script: string;
          /** @description The GitHub repository where the script is kept. */
          script_repository: { [key: string]: unknown };
          /** @description The pre-receive environment where the script is executed. */
          environment: { [key: string]: unknown };
          /** @description The state of enforcement for this hook. default: `disabled` */
          enforcement?: string;
          /** @description Whether enforcement can be overridden at the org or repo level. default: `false` */
          allow_downstream_configuration?: boolean;
        };
      };
    };
  };
  "enterprise-admin/get-pre-receive-hook": {
    parameters: {
      path: {
        /** The unique identifier of the pre-receive hook. */
        pre_receive_hook_id: components["parameters"]["pre-receive-hook-id"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["pre-receive-hook"];
        };
      };
    };
  };
  "enterprise-admin/delete-pre-receive-hook": {
    parameters: {
      path: {
        /** The unique identifier of the pre-receive hook. */
        pre_receive_hook_id: components["parameters"]["pre-receive-hook-id"];
      };
    };
    responses: {
      /** Response */
      204: never;
    };
  };
  "enterprise-admin/update-pre-receive-hook": {
    parameters: {
      path: {
        /** The unique identifier of the pre-receive hook. */
        pre_receive_hook_id: components["parameters"]["pre-receive-hook-id"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["pre-receive-hook"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": {
          /** @description The name of the hook. */
          name?: string;
          /** @description The script that the hook runs. */
          script?: string;
          /** @description The GitHub repository where the script is kept. */
          script_repository?: { [key: string]: unknown };
          /** @description The pre-receive environment where the script is executed. */
          environment?: { [key: string]: unknown };
          /** @description The state of enforcement for this hook. */
          enforcement?: string;
          /** @description Whether enforcement can be overridden at the org or repo level. */
          allow_downstream_configuration?: boolean;
        };
      };
    };
  };
  /** Lists personal access tokens for all users, including admin users. */
  "enterprise-admin/list-personal-access-tokens": {
    parameters: {
      query: {
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /** Response */
      200: {
        headers: {};
        content: {
          "application/json": components["schemas"]["authorization"][];
        };
      };
    };
  };
  /** Deletes a personal access token. Returns a `403 - Forbidden` status when a personal access token is in use. For example, if you access this endpoint with the same personal access token that you are trying to delete, you will receive this error. */
  "enterprise-admin/delete-personal-access-token": {
    parameters: {
      path: {
        /** The unique identifier of the token. */
        token_id: components["parameters"]["token-id"];
      };
    };
    responses: {
      /** Response */
      204: never;
    };
  };
  /**
   * If an external authentication mechanism is used, the login name should match the login name in the external system. If you are using LDAP authentication, you should also [update the LDAP mapping](https://docs.github.com/enterprise-server@3.3/rest/reference/enterprise-admin#update-ldap-mapping-for-a-user) for the user.
   *
   * The login name will be normalized to only contain alphanumeric characters or single hyphens. For example, if you send `"octo_cat"` as the login, a user named `"octo-cat"` will be created.
   *
   * If the login name or email address is already associated with an account, the server will return a `422` response.
   */
  "enterprise-admin/create-user": {
    responses: {
      /** Response */
      201: {
        content: {
          "application/json": components["schemas"]["simple-user"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": {
          /** @description The user's username. */
          login: string;
          /**
           * @description **Required for built-in authentication.** The user's email
           * address. This parameter can be omitted when using CAS, LDAP, or SAML.
           * For more information, see "[About authentication for your enterprise](https://docs.github.com/enterprise-server@3.3/admin/identity-and-access-management/managing-iam-for-your-enterprise/about-authentication-for-your-enterprise)."
           */
          email?: string;
        };
      };
    };
  };
  /**
   * Deleting a user will delete all their repositories, gists, applications, and personal settings. [Suspending a user](https://docs.github.com/enterprise-server@3.3/rest/reference/enterprise-admin#suspend-a-user) is often a better option.
   *
   * You can delete any user account except your own.
   */
  "enterprise-admin/delete-user": {
    parameters: {
      path: {
        /** The handle for the GitHub user account. */
        username: components["parameters"]["username"];
      };
    };
    responses: {
      /** Response */
      204: never;
    };
  };
  "enterprise-admin/update-username-for-user": {
    parameters: {
      path: {
        /** The handle for the GitHub user account. */
        username: components["parameters"]["username"];
      };
    };
    responses: {
      /** Response */
      202: {
        content: {
          "application/json": {
            message?: string;
            url?: string;
          };
        };
      };
    };
    requestBody: {
      content: {
        "application/json": {
          /** @description The user's new username. */
          login: string;
        };
      };
    };
  };
  "enterprise-admin/create-impersonation-o-auth-token": {
    parameters: {
      path: {
        /** The handle for the GitHub user account. */
        username: components["parameters"]["username"];
      };
    };
    responses: {
      /** Response when getting an existing impersonation OAuth token */
      200: {
        content: {
          "application/json": components["schemas"]["authorization"];
        };
      };
      /** Response when creating a new impersonation OAuth token */
      201: {
        content: {
          "application/json": components["schemas"]["authorization"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": {
          /** @description A list of [scopes](https://docs.github.com/enterprise-server@3.3/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/). */
          scopes?: string[];
        };
      };
    };
  };
  "enterprise-admin/delete-impersonation-o-auth-token": {
    parameters: {
      path: {
        /** The handle for the GitHub user account. */
        username: components["parameters"]["username"];
      };
    };
    responses: {
      /** Response */
      204: never;
    };
  };
  /**
   * Returns the GitHub App associated with the authentication credentials used. To see how many app installations are associated with this GitHub App, see the `installations_count` in the response. For more details about your app's installations, see the "[List installations for the authenticated app](https://docs.github.com/enterprise-server@3.3/rest/reference/apps#list-installations-for-the-authenticated-app)" endpoint.
   *
   * You must use a [JWT](https://docs.github.com/enterprise-server@3.3/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
   */
  "apps/get-authenticated": {
    parameters: {};
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["integration"];
        };
      };
    };
  };
  /** Use this endpoint to complete the handshake necessary when implementing the [GitHub App Manifest flow](https://docs.github.com/enterprise-server@3.3/apps/building-github-apps/creating-github-apps-from-a-manifest/). When you create a GitHub App with the manifest flow, you receive a temporary `code` used to retrieve the GitHub App's `id`, `pem` (private key), and `webhook_secret`. */
  "apps/create-from-manifest": {
    parameters: {
      path: {
        code: string;
      };
    };
    responses: {
      /** Response */
      201: {
        content: {
          "application/json": components["schemas"]["integration"] &
            ({
              client_id: string;
              client_secret: string;
              webhook_secret: string | null;
              pem: string;
            } & { [key: string]: unknown });
        };
      };
      404: components["responses"]["not_found"];
      422: components["responses"]["validation_failed_simple"];
    };
  };
  /**
   * Returns the webhook configuration for a GitHub App. For more information about configuring a webhook for your app, see "[Creating a GitHub App](/developers/apps/creating-a-github-app)."
   *
   * You must use a [JWT](https://docs.github.com/enterprise-server@3.3/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
   */
  "apps/get-webhook-config-for-app": {
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["webhook-config"];
        };
      };
    };
  };
  /**
   * Updates the webhook configuration for a GitHub App. For more information about configuring a webhook for your app, see "[Creating a GitHub App](/developers/apps/creating-a-github-app)."
   *
   * You must use a [JWT](https://docs.github.com/enterprise-server@3.3/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
   */
  "apps/update-webhook-config-for-app": {
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["webhook-config"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": {
          url?: components["schemas"]["webhook-config-url"];
          content_type?: components["schemas"]["webhook-config-content-type"];
          secret?: components["schemas"]["webhook-config-secret"];
          insecure_ssl?: components["schemas"]["webhook-config-insecure-ssl"];
        };
      };
    };
  };
  /**
   * Returns a list of webhook deliveries for the webhook configured for a GitHub App.
   *
   * You must use a [JWT](https://docs.github.com/enterprise-server@3.3/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
   */
  "apps/list-webhook-deliveries": {
    parameters: {
      query: {
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Used for pagination: the starting delivery from which the page of deliveries is fetched. Refer to the `link` header for the next and previous page cursors. */
        cursor?: components["parameters"]["cursor"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["hook-delivery-item"][];
        };
      };
      400: components["responses"]["bad_request"];
      422: components["responses"]["validation_failed"];
    };
  };
  /**
   * Returns a delivery for the webhook configured for a GitHub App.
   *
   * You must use a [JWT](https://docs.github.com/enterprise-server@3.3/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
   */
  "apps/get-webhook-delivery": {
    parameters: {
      path: {
        delivery_id: components["parameters"]["delivery-id"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["hook-delivery"];
        };
      };
      400: components["responses"]["bad_request"];
      422: components["responses"]["validation_failed"];
    };
  };
  /**
   * Redeliver a delivery for the webhook configured for a GitHub App.
   *
   * You must use a [JWT](https://docs.github.com/enterprise-server@3.3/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
   */
  "apps/redeliver-webhook-delivery": {
    parameters: {
      path: {
        delivery_id: components["parameters"]["delivery-id"];
      };
    };
    responses: {
      202: components["responses"]["accepted"];
      400: components["responses"]["bad_request"];
      422: components["responses"]["validation_failed"];
    };
  };
  /**
   * You must use a [JWT](https://docs.github.com/enterprise-server@3.3/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
   *
   * The permissions the installation has are included under the `permissions` key.
   */
  "apps/list-installations": {
    parameters: {
      query: {
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
        /** Only show notifications updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`. */
        since?: components["parameters"]["since"];
        outdated?: string;
      };
    };
    responses: {
      /** The permissions the installation has are included under the `permissions` key. */
      200: {
        headers: {};
        content: {
          "application/json": components["schemas"]["installation"][];
        };
      };
    };
  };
  /**
   * Enables an authenticated GitHub App to find an installation's information using the installation id.
   *
   * You must use a [JWT](https://docs.github.com/enterprise-server@3.3/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
   */
  "apps/get-installation": {
    parameters: {
      path: {
        /** The unique identifier of the installation. */
        installation_id: components["parameters"]["installation-id"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["installation"];
        };
      };
      404: components["responses"]["not_found"];
    };
  };
  /**
   * Uninstalls a GitHub App on a user, organization, or business account. If you prefer to temporarily suspend an app's access to your account's resources, then we recommend the "[Suspend an app installation](https://docs.github.com/enterprise-server@3.3/rest/reference/apps/#suspend-an-app-installation)" endpoint.
   *
   * You must use a [JWT](https://docs.github.com/enterprise-server@3.3/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
   */
  "apps/delete-installation": {
    parameters: {
      path: {
        /** The unique identifier of the installation. */
        installation_id: components["parameters"]["installation-id"];
      };
    };
    responses: {
      /** Response */
      204: never;
      404: components["responses"]["not_found"];
    };
  };
  /**
   * Creates an installation access token that enables a GitHub App to make authenticated API requests for the app's installation on an organization or individual account. Installation tokens expire one hour from the time you create them. Using an expired token produces a status code of `401 - Unauthorized`, and requires creating a new installation token. By default the installation token has access to all repositories that the installation can access. To restrict the access to specific repositories, you can provide the `repository_ids` when creating the token. When you omit `repository_ids`, the response does not contain the `repositories` key.
   *
   * You must use a [JWT](https://docs.github.com/enterprise-server@3.3/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
   */
  "apps/create-installation-access-token": {
    parameters: {
      path: {
        /** The unique identifier of the installation. */
        installation_id: components["parameters"]["installation-id"];
      };
    };
    responses: {
      /** Response */
      201: {
        content: {
          "application/json": components["schemas"]["installation-token"];
        };
      };
      401: components["responses"]["requires_authentication"];
      403: components["responses"]["forbidden"];
      404: components["responses"]["not_found"];
      422: components["responses"]["validation_failed"];
    };
    requestBody: {
      content: {
        "application/json": {
          /** @description List of repository names that the token should have access to */
          repositories?: string[];
          /**
           * @description List of repository IDs that the token should have access to
           * @example [
           *   1
           * ]
           */
          repository_ids?: number[];
          permissions?: components["schemas"]["app-permissions"];
        };
      };
    };
  };
  /**
   * Suspends a GitHub App on a user, organization, or business account, which blocks the app from accessing the account's resources. When a GitHub App is suspended, the app's access to the GitHub Enterprise Server API or webhook events is blocked for that account.
   *
   * You must use a [JWT](https://docs.github.com/enterprise-server@3.3/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
   */
  "apps/suspend-installation": {
    parameters: {
      path: {
        /** The unique identifier of the installation. */
        installation_id: components["parameters"]["installation-id"];
      };
    };
    responses: {
      /** Response */
      204: never;
      404: components["responses"]["not_found"];
    };
  };
  /**
   * Removes a GitHub App installation suspension.
   *
   * You must use a [JWT](https://docs.github.com/enterprise-server@3.3/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
   */
  "apps/unsuspend-installation": {
    parameters: {
      path: {
        /** The unique identifier of the installation. */
        installation_id: components["parameters"]["installation-id"];
      };
    };
    responses: {
      /** Response */
      204: never;
      404: components["responses"]["not_found"];
    };
  };
  /**
   * **Deprecation Notice:** GitHub Enterprise Server will discontinue the [OAuth Authorizations API](https://docs.github.com/enterprise-server@3.3/rest/reference/oauth-authorizations/), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/enterprise-server@3.3/developers/apps/authorizing-oauth-apps#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/enterprise-server@3.3/rest/reference/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/).
   *
   * You can use this API to list the set of OAuth applications that have been granted access to your account. Unlike the [list your authorizations](https://docs.github.com/enterprise-server@3.3/rest/reference/oauth-authorizations#list-your-authorizations) API, this API does not manage individual tokens. This API will return one entry for each OAuth application that has been granted access to your account, regardless of the number of tokens an application has generated for your user. The list of OAuth applications returned matches what is shown on [the application authorizations settings screen within GitHub](https://github.com/settings/applications#authorized). The `scopes` returned are the union of scopes authorized for the application. For example, if an application has one token with `repo` scope and another token with `user` scope, the grant will return `["repo", "user"]`.
   */
  "oauth-authorizations/list-grants": {
    parameters: {
      query: {
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
        /** The client ID of your GitHub app. */
        client_id?: string;
      };
    };
    responses: {
      /** Response */
      200: {
        headers: {};
        content: {
          "application/json": components["schemas"]["application-grant"][];
        };
      };
      304: components["responses"]["not_modified"];
      401: components["responses"]["requires_authentication"];
      403: components["responses"]["forbidden"];
      404: components["responses"]["not_found"];
    };
  };
  /** **Deprecation Notice:** GitHub Enterprise Server will discontinue the [OAuth Authorizations API](https://docs.github.com/enterprise-server@3.3/rest/reference/oauth-authorizations), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/enterprise-server@3.3/apps/building-oauth-apps/authorizing-oauth-apps/#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/enterprise-server@3.3/rest/reference/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/). */
  "oauth-authorizations/get-grant": {
    parameters: {
      path: {
        /** The unique identifier of the grant. */
        grant_id: components["parameters"]["grant-id"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["application-grant"];
        };
      };
      304: components["responses"]["not_modified"];
      401: components["responses"]["requires_authentication"];
      403: components["responses"]["forbidden"];
    };
  };
  /**
   * **Deprecation Notice:** GitHub Enterprise Server will discontinue the [OAuth Authorizations API](https://docs.github.com/enterprise-server@3.3/rest/reference/oauth-authorizations/), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/enterprise-server@3.3/developers/apps/authorizing-oauth-apps#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/enterprise-server@3.3/rest/reference/oauth-authorizations/) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/).
   *
   * Deleting an OAuth application's grant will also delete all OAuth tokens associated with the application for your user. Once deleted, the application has no access to your account and is no longer listed on [the application authorizations settings screen within GitHub](https://github.com/settings/applications#authorized).
   */
  "oauth-authorizations/delete-grant": {
    parameters: {
      path: {
        /** The unique identifier of the grant. */
        grant_id: components["parameters"]["grant-id"];
      };
    };
    responses: {
      /** Response */
      204: never;
      304: components["responses"]["not_modified"];
      401: components["responses"]["requires_authentication"];
      403: components["responses"]["forbidden"];
    };
  };
  /**
   * OAuth application owners can revoke a grant for their OAuth application and a specific user. You must use [Basic Authentication](https://docs.github.com/enterprise-server@3.3/rest/overview/other-authentication-methods#basic-authentication) when accessing this endpoint, using the OAuth application's `client_id` and `client_secret` as the username and password. You must also provide a valid OAuth `access_token` as an input parameter and the grant for the token's owner will be deleted.
   * Deleting an OAuth application's grant will also delete all OAuth tokens associated with the application for the user. Once deleted, the application will have no access to the user's account and will no longer be listed on [the application authorizations settings screen within GitHub](https://github.com/settings/applications#authorized).
   */
  "apps/delete-authorization": {
    parameters: {
      path: {
        /** The client ID of the GitHub app. */
        client_id: components["parameters"]["client-id"];
      };
    };
    responses: {
      /** Response */
      204: never;
      422: components["responses"]["validation_failed"];
    };
    requestBody: {
      content: {
        "application/json": {
          /** @description The OAuth access token used to authenticate to the GitHub API. */
          access_token: string;
        };
      };
    };
  };
  /**
   * **Deprecation Notice:** GitHub Enterprise Server will discontinue OAuth endpoints that contain `access_token` in the path parameter. We have introduced new endpoints that allow you to securely manage tokens for OAuth Apps by moving `access_token` to the request body. For more information, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-app-endpoint/).
   *
   * OAuth application owners can revoke a grant for their OAuth application and a specific user. You must use [Basic Authentication](https://docs.github.com/enterprise-server@3.3/rest/overview/other-authentication-methods#basic-authentication) when accessing this endpoint, using the OAuth application's `client_id` and `client_secret` as the username and password. You must also provide a valid token as `:access_token` and the grant for the token's owner will be deleted.
   *
   * Deleting an OAuth application's grant will also delete all OAuth tokens associated with the application for the user. Once deleted, the application will have no access to the user's account and will no longer be listed on [the Applications settings page under "Authorized OAuth Apps" on GitHub Enterprise Server](https://github.com/settings/applications#authorized).
   */
  "apps/revoke-grant-for-application": {
    parameters: {
      path: {
        /** The client ID of the GitHub app. */
        client_id: components["parameters"]["client-id"];
        access_token: components["parameters"]["access-token"];
      };
    };
    responses: {
      /** Response */
      204: never;
    };
  };
  /** OAuth applications can use a special API method for checking OAuth token validity without exceeding the normal rate limits for failed login attempts. Authentication works differently with this particular endpoint. You must use [Basic Authentication](https://docs.github.com/enterprise-server@3.3/rest/overview/other-authentication-methods#basic-authentication) to use this endpoint, where the username is the OAuth application `client_id` and the password is its `client_secret`. Invalid tokens will return `404 NOT FOUND`. */
  "apps/check-token": {
    parameters: {
      path: {
        /** The client ID of the GitHub app. */
        client_id: components["parameters"]["client-id"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["authorization"];
        };
      };
      404: components["responses"]["not_found"];
      422: components["responses"]["validation_failed"];
    };
    requestBody: {
      content: {
        "application/json": {
          /** @description The access_token of the OAuth application. */
          access_token: string;
        };
      };
    };
  };
  /** OAuth application owners can revoke a single token for an OAuth application. You must use [Basic Authentication](https://docs.github.com/enterprise-server@3.3/rest/overview/other-authentication-methods#basic-authentication) when accessing this endpoint, using the OAuth application's `client_id` and `client_secret` as the username and password. */
  "apps/delete-token": {
    parameters: {
      path: {
        /** The client ID of the GitHub app. */
        client_id: components["parameters"]["client-id"];
      };
    };
    responses: {
      /** Response */
      204: never;
      422: components["responses"]["validation_failed"];
    };
    requestBody: {
      content: {
        "application/json": {
          /** @description The OAuth access token used to authenticate to the GitHub API. */
          access_token: string;
        };
      };
    };
  };
  /** OAuth applications can use this API method to reset a valid OAuth token without end-user involvement. Applications must save the "token" property in the response because changes take effect immediately. You must use [Basic Authentication](https://docs.github.com/enterprise-server@3.3/rest/overview/other-authentication-methods#basic-authentication) when accessing this endpoint, using the OAuth application's `client_id` and `client_secret` as the username and password. Invalid tokens will return `404 NOT FOUND`. */
  "apps/reset-token": {
    parameters: {
      path: {
        /** The client ID of the GitHub app. */
        client_id: components["parameters"]["client-id"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["authorization"];
        };
      };
      422: components["responses"]["validation_failed"];
    };
    requestBody: {
      content: {
        "application/json": {
          /** @description The access_token of the OAuth application. */
          access_token: string;
        };
      };
    };
  };
  /** Use a non-scoped user-to-server OAuth access token to create a repository scoped and/or permission scoped user-to-server OAuth access token. You can specify which repositories the token can access and which permissions are granted to the token. You must use [Basic Authentication](https://docs.github.com/enterprise-server@3.3/rest/overview/other-authentication-methods#basic-authentication) when accessing this endpoint, using the OAuth application's `client_id` and `client_secret` as the username and password. Invalid tokens will return `404 NOT FOUND`. */
  "apps/scope-token": {
    parameters: {
      path: {
        /** The client ID of the GitHub app. */
        client_id: components["parameters"]["client-id"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["authorization"];
        };
      };
      401: components["responses"]["requires_authentication"];
      403: components["responses"]["forbidden"];
      404: components["responses"]["not_found"];
      422: components["responses"]["validation_failed"];
    };
    requestBody: {
      content: {
        "application/json": {
          /**
           * @description The OAuth access token used to authenticate to the GitHub API.
           * @example e72e16c7e42f292c6912e7710c838347ae178b4a
           */
          access_token: string;
          /**
           * @description The name of the user or organization to scope the user-to-server access token to. **Required** unless `target_id` is specified.
           * @example octocat
           */
          target?: string;
          /**
           * @description The ID of the user or organization to scope the user-to-server access token to. **Required** unless `target` is specified.
           * @example 1
           */
          target_id?: number;
          /** @description The list of repository names to scope the user-to-server access token to. `repositories` may not be specified if `repository_ids` is specified. */
          repositories?: string[];
          /**
           * @description The list of repository IDs to scope the user-to-server access token to. `repository_ids` may not be specified if `repositories` is specified.
           * @example [
           *   1
           * ]
           */
          repository_ids?: number[];
          permissions?: components["schemas"]["app-permissions"];
        };
      };
    };
  };
  /**
   * **Deprecation Notice:** GitHub Enterprise Server will discontinue OAuth endpoints that contain `access_token` in the path parameter. We have introduced new endpoints that allow you to securely manage tokens for OAuth Apps by moving `access_token` to the request body. For more information, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-app-endpoint/).
   *
   * OAuth applications can use a special API method for checking OAuth token validity without exceeding the normal rate limits for failed login attempts. Authentication works differently with this particular endpoint. You must use [Basic Authentication](https://docs.github.com/enterprise-server@3.3/rest/overview/other-authentication-methods#basic-authentication) when accessing this endpoint, using the OAuth application's `client_id` and `client_secret` as the username and password. Invalid tokens will return `404 NOT FOUND`.
   */
  "apps/check-authorization": {
    parameters: {
      path: {
        /** The client ID of the GitHub app. */
        client_id: components["parameters"]["client-id"];
        access_token: components["parameters"]["access-token"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["nullable-authorization"];
        };
      };
      404: components["responses"]["not_found"];
    };
  };
  /**
   * **Deprecation Notice:** GitHub Enterprise Server will discontinue OAuth endpoints that contain `access_token` in the path parameter. We have introduced new endpoints that allow you to securely manage tokens for OAuth Apps by moving `access_token` to the request body. For more information, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-app-endpoint/).
   *
   * OAuth applications can use this API method to reset a valid OAuth token without end-user involvement. Applications must save the "token" property in the response because changes take effect immediately. You must use [Basic Authentication](https://docs.github.com/enterprise-server@3.3/rest/overview/other-authentication-methods#basic-authentication) when accessing this endpoint, using the OAuth application's `client_id` and `client_secret` as the username and password. Invalid tokens will return `404 NOT FOUND`.
   */
  "apps/reset-authorization": {
    parameters: {
      path: {
        /** The client ID of the GitHub app. */
        client_id: components["parameters"]["client-id"];
        access_token: components["parameters"]["access-token"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["authorization"];
        };
      };
    };
  };
  /**
   * **Deprecation Notice:** GitHub Enterprise Server will discontinue OAuth endpoints that contain `access_token` in the path parameter. We have introduced new endpoints that allow you to securely manage tokens for OAuth Apps by moving `access_token` to the request body. For more information, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-app-endpoint/).
   *
   * OAuth application owners can revoke a single token for an OAuth application. You must use [Basic Authentication](https://docs.github.com/enterprise-server@3.3/rest/overview/other-authentication-methods#basic-authentication) when accessing this endpoint, using the OAuth application's `client_id` and `client_secret` as the username and password.
   */
  "apps/revoke-authorization-for-application": {
    parameters: {
      path: {
        /** The client ID of the GitHub app. */
        client_id: components["parameters"]["client-id"];
        access_token: components["parameters"]["access-token"];
      };
    };
    responses: {
      /** Response */
      204: never;
    };
  };
  /**
   * **Note**: The `:app_slug` is just the URL-friendly name of your GitHub App. You can find this on the settings page for your GitHub App (e.g., `https://github.com/settings/apps/:app_slug`).
   *
   * If the GitHub App you specify is public, you can access this endpoint without authenticating. If the GitHub App you specify is private, you must authenticate with a [personal access token](https://docs.github.com/articles/creating-a-personal-access-token-for-the-command-line/) or an [installation access token](https://docs.github.com/enterprise-server@3.3/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-an-installation) to access this endpoint.
   */
  "apps/get-by-slug": {
    parameters: {
      path: {
        app_slug: components["parameters"]["app-slug"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["integration"];
        };
      };
      403: components["responses"]["forbidden"];
      404: components["responses"]["not_found"];
    };
  };
  /** **Deprecation Notice:** GitHub Enterprise Server will discontinue the [OAuth Authorizations API](https://docs.github.com/enterprise-server@3.3/rest/reference/oauth-authorizations), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/enterprise-server@3.3/apps/building-oauth-apps/authorizing-oauth-apps/#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/enterprise-server@3.3/rest/reference/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/). */
  "oauth-authorizations/list-authorizations": {
    parameters: {
      query: {
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
        /** The client ID of your GitHub app. */
        client_id?: string;
      };
    };
    responses: {
      /** Response */
      200: {
        headers: {};
        content: {
          "application/json": components["schemas"]["authorization"][];
        };
      };
      304: components["responses"]["not_modified"];
      401: components["responses"]["requires_authentication"];
      403: components["responses"]["forbidden"];
      404: components["responses"]["not_found"];
    };
  };
  /**
   * **Deprecation Notice:** GitHub Enterprise Server will discontinue the [OAuth Authorizations API](https://docs.github.com/enterprise-server@3.3/rest/reference/oauth-authorizations), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/enterprise-server@3.3/developers/apps/authorizing-oauth-apps#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/enterprise-server@3.3/rest/reference/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/).
   *
   * **Warning:** Apps must use the [web application flow](https://docs.github.com/enterprise-server@3.3/apps/building-oauth-apps/authorizing-oauth-apps/#web-application-flow) to obtain OAuth tokens that work with GitHub Enterprise Server SAML organizations. OAuth tokens created using the Authorizations API will be unable to access GitHub Enterprise Server SAML organizations. For more information, see the [blog post](https://developer.github.com/changes/2019-11-05-deprecated-passwords-and-authorizations-api).
   *
   * Creates OAuth tokens using [Basic Authentication](https://docs.github.com/enterprise-server@3.3/rest/overview/other-authentication-methods#basic-authentication). If you have two-factor authentication setup, Basic Authentication for this endpoint requires that you use a one-time password (OTP) and your username and password instead of tokens. For more information, see "[Working with two-factor authentication](https://docs.github.com/enterprise-server@3.3/rest/overview/other-authentication-methods#working-with-two-factor-authentication)."
   *
   * To create tokens for a particular OAuth application using this endpoint, you must authenticate as the user you want to create an authorization for and provide the app's client ID and secret, found on your OAuth application's settings page. If your OAuth application intends to create multiple tokens for one user, use `fingerprint` to differentiate between them.
   *
   * You can also create tokens on GitHub Enterprise Server from the [personal access tokens settings](https://github.com/settings/tokens) page. Read more about these tokens in [the GitHub Help documentation](https://docs.github.com/articles/creating-an-access-token-for-command-line-use).
   *
   * Organizations that enforce SAML SSO require personal access tokens to be allowed. Read more about allowing tokens in [the GitHub Help documentation](https://docs.github.com/articles/about-identity-and-access-management-with-saml-single-sign-on).
   */
  "oauth-authorizations/create-authorization": {
    parameters: {};
    responses: {
      /** Response */
      201: {
        headers: {
          Location?: string;
        };
        content: {
          "application/json": components["schemas"]["authorization"];
        };
      };
      304: components["responses"]["not_modified"];
      401: components["responses"]["requires_authentication"];
      403: components["responses"]["forbidden"];
      410: components["responses"]["gone"];
      422: components["responses"]["validation_failed"];
    };
    requestBody: {
      content: {
        "application/json": {
          /**
           * @description A list of scopes that this authorization is in.
           * @example [
           *   "public_repo",
           *   "user"
           * ]
           */
          scopes?: string[] | null;
          /**
           * @description A note to remind you what the OAuth token is for.
           * @example Update all gems
           */
          note?: string;
          /** @description A URL to remind you what app the OAuth token is for. */
          note_url?: string;
          /** @description The OAuth app client key for which to create the token. */
          client_id?: string;
          /** @description The OAuth app client secret for which to create the token. */
          client_secret?: string;
          /** @description A unique string to distinguish an authorization from others created for the same client ID and user. */
          fingerprint?: string;
        };
      };
    };
  };
  /**
   * **Deprecation Notice:** GitHub Enterprise Server will discontinue the [OAuth Authorizations API](https://docs.github.com/enterprise-server@3.3/rest/reference/oauth-authorizations/), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/enterprise-server@3.3/developers/apps/authorizing-oauth-apps#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/enterprise-server@3.3/rest/reference/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/).
   *
   * **Warning:** Apps must use the [web application flow](https://docs.github.com/enterprise-server@3.3/apps/building-oauth-apps/authorizing-oauth-apps/#web-application-flow) to obtain OAuth tokens that work with GitHub Enterprise Server SAML organizations. OAuth tokens created using the Authorizations API will be unable to access GitHub Enterprise Server SAML organizations. For more information, see the [blog post](https://developer.github.com/changes/2019-11-05-deprecated-passwords-and-authorizations-api).
   *
   * Creates a new authorization for the specified OAuth application, only if an authorization for that application doesn't already exist for the user. The URL includes the 20 character client ID for the OAuth app that is requesting the token. It returns the user's existing authorization for the application if one is present. Otherwise, it creates and returns a new one.
   *
   * If you have two-factor authentication setup, Basic Authentication for this endpoint requires that you use a one-time password (OTP) and your username and password instead of tokens. For more information, see "[Working with two-factor authentication](https://docs.github.com/enterprise-server@3.3/rest/overview/other-authentication-methods#working-with-two-factor-authentication)."
   *
   * **Deprecation Notice:** GitHub Enterprise Server will discontinue the [OAuth Authorizations API](https://docs.github.com/enterprise-server@3.3/rest/reference/oauth-authorizations/), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/enterprise-server@3.3/developers/apps/authorizing-oauth-apps#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/enterprise-server@3.3/rest/reference/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/).
   */
  "oauth-authorizations/get-or-create-authorization-for-app": {
    parameters: {
      path: {
        /** The client ID of the OAuth app. */
        client_id: components["parameters"]["oauth-client-id"];
      };
    };
    responses: {
      /** if returning an existing token */
      200: {
        headers: {
          Location?: string;
        };
        content: {
          "application/json": components["schemas"]["authorization"];
        };
      };
      /** **Deprecation Notice:** GitHub will discontinue the [OAuth Authorizations API](https://docs.github.com/enterprise-server@3.3/rest/reference/oauth-authorizations), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/enterprise-server@3.3/apps/building-oauth-apps/authorizing-oauth-apps/#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/enterprise-server@3.3/rest/reference/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/). */
      201: {
        headers: {
          Location?: string;
        };
        content: {
          "application/json": components["schemas"]["authorization"];
        };
      };
      304: components["responses"]["not_modified"];
      401: components["responses"]["requires_authentication"];
      403: components["responses"]["forbidden"];
      422: components["responses"]["validation_failed"];
    };
    requestBody: {
      content: {
        "application/json": {
          /** @description The OAuth app client secret for which to create the token. */
          client_secret: string;
          /**
           * @description A list of scopes that this authorization is in.
           * @example [
           *   "public_repo",
           *   "user"
           * ]
           */
          scopes?: string[] | null;
          /**
           * @description A note to remind you what the OAuth token is for.
           * @example Update all gems
           */
          note?: string;
          /** @description A URL to remind you what app the OAuth token is for. */
          note_url?: string;
          /** @description A unique string to distinguish an authorization from others created for the same client ID and user. */
          fingerprint?: string;
        };
      };
    };
  };
  /**
   * **Deprecation Notice:** GitHub Enterprise Server will discontinue the [OAuth Authorizations API](https://docs.github.com/enterprise-server@3.3/rest/reference/oauth-authorizations/), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/enterprise-server@3.3/developers/apps/authorizing-oauth-apps#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/enterprise-server@3.3/rest/reference/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/).
   *
   * **Warning:** Apps must use the [web application flow](https://docs.github.com/enterprise-server@3.3/apps/building-oauth-apps/authorizing-oauth-apps/#web-application-flow) to obtain OAuth tokens that work with GitHub Enterprise Server SAML organizations. OAuth tokens created using the Authorizations API will be unable to access GitHub Enterprise Server SAML organizations. For more information, see the [blog post](https://developer.github.com/changes/2019-11-05-deprecated-passwords-and-authorizations-api).
   *
   * This method will create a new authorization for the specified OAuth application, only if an authorization for that application and fingerprint do not already exist for the user. The URL includes the 20 character client ID for the OAuth app that is requesting the token. `fingerprint` is a unique string to distinguish an authorization from others created for the same client ID and user. It returns the user's existing authorization for the application if one is present. Otherwise, it creates and returns a new one.
   *
   * If you have two-factor authentication setup, Basic Authentication for this endpoint requires that you use a one-time password (OTP) and your username and password instead of tokens. For more information, see "[Working with two-factor authentication](https://docs.github.com/enterprise-server@3.3/rest/overview/other-authentication-methods#working-with-two-factor-authentication)."
   */
  "oauth-authorizations/get-or-create-authorization-for-app-and-fingerprint": {
    parameters: {
      path: {
        /** The client ID of the OAuth app. */
        client_id: components["parameters"]["oauth-client-id"];
        fingerprint: string;
      };
    };
    responses: {
      /** if returning an existing token */
      200: {
        headers: {
          Location?: string;
        };
        content: {
          "application/json": components["schemas"]["authorization"];
        };
      };
      /** Response if returning a new token */
      201: {
        headers: {
          Location?: string;
        };
        content: {
          "application/json": components["schemas"]["authorization"];
        };
      };
      422: components["responses"]["validation_failed"];
    };
    requestBody: {
      content: {
        "application/json": {
          /** @description The OAuth app client secret for which to create the token. */
          client_secret: string;
          /**
           * @description A list of scopes that this authorization is in.
           * @example [
           *   "public_repo",
           *   "user"
           * ]
           */
          scopes?: string[] | null;
          /**
           * @description A note to remind you what the OAuth token is for.
           * @example Update all gems
           */
          note?: string;
          /** @description A URL to remind you what app the OAuth token is for. */
          note_url?: string;
        };
      };
    };
  };
  /** **Deprecation Notice:** GitHub Enterprise Server will discontinue the [OAuth Authorizations API](https://docs.github.com/enterprise-server@3.3/rest/reference/oauth-authorizations), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/enterprise-server@3.3/apps/building-oauth-apps/authorizing-oauth-apps/#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/enterprise-server@3.3/rest/reference/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/). */
  "oauth-authorizations/get-authorization": {
    parameters: {
      path: {
        /** The unique identifier of the authorization. */
        authorization_id: components["parameters"]["authorization-id"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["authorization"];
        };
      };
      304: components["responses"]["not_modified"];
      401: components["responses"]["requires_authentication"];
      403: components["responses"]["forbidden"];
    };
  };
  /** **Deprecation Notice:** GitHub Enterprise Server will discontinue the [OAuth Authorizations API](https://docs.github.com/enterprise-server@3.3/rest/reference/oauth-authorizations), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/enterprise-server@3.3/apps/building-oauth-apps/authorizing-oauth-apps/#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/enterprise-server@3.3/rest/reference/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/). */
  "oauth-authorizations/delete-authorization": {
    parameters: {
      path: {
        /** The unique identifier of the authorization. */
        authorization_id: components["parameters"]["authorization-id"];
      };
    };
    responses: {
      /** Response */
      204: never;
      304: components["responses"]["not_modified"];
      401: components["responses"]["requires_authentication"];
      403: components["responses"]["forbidden"];
    };
  };
  /**
   * **Deprecation Notice:** GitHub Enterprise Server will discontinue the [OAuth Authorizations API](https://docs.github.com/enterprise-server@3.3/rest/reference/oauth-authorizations/), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/enterprise-server@3.3/developers/apps/authorizing-oauth-apps#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/enterprise-server@3.3/rest/reference/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/).
   *
   * If you have two-factor authentication setup, Basic Authentication for this endpoint requires that you use a one-time password (OTP) and your username and password instead of tokens. For more information, see "[Working with two-factor authentication](https://docs.github.com/enterprise-server@3.3/rest/overview/other-authentication-methods#working-with-two-factor-authentication)."
   *
   * You can only send one of these scope keys at a time.
   */
  "oauth-authorizations/update-authorization": {
    parameters: {
      path: {
        /** The unique identifier of the authorization. */
        authorization_id: components["parameters"]["authorization-id"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["authorization"];
        };
      };
      422: components["responses"]["validation_failed"];
    };
    requestBody: {
      content: {
        "application/json": {
          /**
           * @description A list of scopes that this authorization is in.
           * @example [
           *   "public_repo",
           *   "user"
           * ]
           */
          scopes?: string[] | null;
          /** @description A list of scopes to add to this authorization. */
          add_scopes?: string[];
          /** @description A list of scopes to remove from this authorization. */
          remove_scopes?: string[];
          /**
           * @description A note to remind you what the OAuth token is for.
           * @example Update all gems
           */
          note?: string;
          /** @description A URL to remind you what app the OAuth token is for. */
          note_url?: string;
          /** @description A unique string to distinguish an authorization from others created for the same client ID and user. */
          fingerprint?: string;
        };
      };
    };
  };
  "codes-of-conduct/get-all-codes-of-conduct": {
    parameters: {};
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["code-of-conduct"][];
        };
      };
      304: components["responses"]["not_modified"];
    };
  };
  "codes-of-conduct/get-conduct-code": {
    parameters: {
      path: {
        key: string;
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["code-of-conduct"];
        };
      };
      304: components["responses"]["not_modified"];
      404: components["responses"]["not_found"];
    };
  };
  /** Lists all the emojis available to use on GitHub Enterprise Server. */
  "emojis/get": {
    parameters: {};
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": { [key: string]: string };
        };
      };
      304: components["responses"]["not_modified"];
    };
  };
  /** Gets the current message and expiration date of the global announcement banner in your enterprise. */
  "enterprise-admin/get-announcement": {
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["announcement"];
        };
      };
    };
  };
  /** Removes the global announcement banner in your enterprise. */
  "enterprise-admin/remove-announcement": {
    responses: {
      /** Response */
      204: never;
    };
  };
  /** Sets the message and expiration time for the global announcement banner in your enterprise. */
  "enterprise-admin/set-announcement": {
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["announcement"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["announcement"];
      };
    };
  };
  "enterprise-admin/get-license-information": {
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["license-info"];
        };
      };
    };
  };
  "enterprise-admin/get-all-stats": {
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["enterprise-overview"];
        };
      };
    };
  };
  "enterprise-admin/get-comment-stats": {
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["enterprise-comment-overview"];
        };
      };
    };
  };
  "enterprise-admin/get-gist-stats": {
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["enterprise-gist-overview"];
        };
      };
    };
  };
  "enterprise-admin/get-hooks-stats": {
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["enterprise-hook-overview"];
        };
      };
    };
  };
  "enterprise-admin/get-issue-stats": {
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["enterprise-issue-overview"];
        };
      };
    };
  };
  "enterprise-admin/get-milestone-stats": {
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["enterprise-milestone-overview"];
        };
      };
    };
  };
  "enterprise-admin/get-org-stats": {
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["enterprise-organization-overview"];
        };
      };
    };
  };
  "enterprise-admin/get-pages-stats": {
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["enterprise-page-overview"];
        };
      };
    };
  };
  "enterprise-admin/get-pull-request-stats": {
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["enterprise-pull-request-overview"];
        };
      };
    };
  };
  "enterprise-admin/get-repo-stats": {
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["enterprise-repository-overview"];
        };
      };
    };
  };
  "enterprise-admin/get-user-stats": {
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["enterprise-user-overview"];
        };
      };
    };
  };
  /**
   * Gets the GitHub Actions permissions policy for organizations and allowed actions in an enterprise.
   *
   * You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
   */
  "enterprise-admin/get-github-actions-permissions-enterprise": {
    parameters: {
      path: {
        /** The slug version of the enterprise name. You can also substitute this value with the enterprise id. */
        enterprise: components["parameters"]["enterprise"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["actions-enterprise-permissions"];
        };
      };
    };
  };
  /**
   * Sets the GitHub Actions permissions policy for organizations and allowed actions in an enterprise.
   *
   * You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
   */
  "enterprise-admin/set-github-actions-permissions-enterprise": {
    parameters: {
      path: {
        /** The slug version of the enterprise name. You can also substitute this value with the enterprise id. */
        enterprise: components["parameters"]["enterprise"];
      };
    };
    responses: {
      /** Response */
      204: never;
    };
    requestBody: {
      content: {
        "application/json": {
          enabled_organizations: components["schemas"]["enabled-organizations"];
          allowed_actions?: components["schemas"]["allowed-actions"];
        };
      };
    };
  };
  /**
   * Lists the organizations that are selected to have GitHub Actions enabled in an enterprise. To use this endpoint, the enterprise permission policy for `enabled_organizations` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an enterprise](#set-github-actions-permissions-for-an-enterprise)."
   *
   * You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
   */
  "enterprise-admin/list-selected-organizations-enabled-github-actions-enterprise": {
    parameters: {
      path: {
        /** The slug version of the enterprise name. You can also substitute this value with the enterprise id. */
        enterprise: components["parameters"]["enterprise"];
      };
      query: {
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": {
            total_count: number;
            organizations: components["schemas"]["organization-simple"][];
          };
        };
      };
    };
  };
  /**
   * Replaces the list of selected organizations that are enabled for GitHub Actions in an enterprise. To use this endpoint, the enterprise permission policy for `enabled_organizations` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an enterprise](#set-github-actions-permissions-for-an-enterprise)."
   *
   * You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
   */
  "enterprise-admin/set-selected-organizations-enabled-github-actions-enterprise": {
    parameters: {
      path: {
        /** The slug version of the enterprise name. You can also substitute this value with the enterprise id. */
        enterprise: components["parameters"]["enterprise"];
      };
    };
    responses: {
      /** Response */
      204: never;
    };
    requestBody: {
      content: {
        "application/json": {
          /** @description List of organization IDs to enable for GitHub Actions. */
          selected_organization_ids: number[];
        };
      };
    };
  };
  /**
   * Adds an organization to the list of selected organizations that are enabled for GitHub Actions in an enterprise. To use this endpoint, the enterprise permission policy for `enabled_organizations` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an enterprise](#set-github-actions-permissions-for-an-enterprise)."
   *
   * You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
   */
  "enterprise-admin/enable-selected-organization-github-actions-enterprise": {
    parameters: {
      path: {
        /** The slug version of the enterprise name. You can also substitute this value with the enterprise id. */
        enterprise: components["parameters"]["enterprise"];
        /** The unique identifier of the organization. */
        org_id: components["parameters"]["org-id"];
      };
    };
    responses: {
      /** Response */
      204: never;
    };
  };
  /**
   * Removes an organization from the list of selected organizations that are enabled for GitHub Actions in an enterprise. To use this endpoint, the enterprise permission policy for `enabled_organizations` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an enterprise](#set-github-actions-permissions-for-an-enterprise)."
   *
   * You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
   */
  "enterprise-admin/disable-selected-organization-github-actions-enterprise": {
    parameters: {
      path: {
        /** The slug version of the enterprise name. You can also substitute this value with the enterprise id. */
        enterprise: components["parameters"]["enterprise"];
        /** The unique identifier of the organization. */
        org_id: components["parameters"]["org-id"];
      };
    };
    responses: {
      /** Response */
      204: never;
    };
  };
  /**
   * Gets the selected actions that are allowed in an enterprise. To use this endpoint, the enterprise permission policy for `allowed_actions` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an enterprise](#set-github-actions-permissions-for-an-enterprise)."
   *
   * You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
   */
  "enterprise-admin/get-allowed-actions-enterprise": {
    parameters: {
      path: {
        /** The slug version of the enterprise name. You can also substitute this value with the enterprise id. */
        enterprise: components["parameters"]["enterprise"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["selected-actions"];
        };
      };
    };
  };
  /**
   * Sets the actions that are allowed in an enterprise. To use this endpoint, the enterprise permission policy for `allowed_actions` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an enterprise](#set-github-actions-permissions-for-an-enterprise)."
   *
   * You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
   */
  "enterprise-admin/set-allowed-actions-enterprise": {
    parameters: {
      path: {
        /** The slug version of the enterprise name. You can also substitute this value with the enterprise id. */
        enterprise: components["parameters"]["enterprise"];
      };
    };
    responses: {
      /** Response */
      204: never;
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["selected-actions"];
      };
    };
  };
  /**
   * Lists all self-hosted runner groups for an enterprise.
   *
   * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
   */
  "enterprise-admin/list-self-hosted-runner-groups-for-enterprise": {
    parameters: {
      path: {
        /** The slug version of the enterprise name. You can also substitute this value with the enterprise id. */
        enterprise: components["parameters"]["enterprise"];
      };
      query: {
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": {
            total_count: number;
            runner_groups: components["schemas"]["runner-groups-enterprise"][];
          };
        };
      };
    };
  };
  /**
   * Creates a new self-hosted runner group for an enterprise.
   *
   * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
   */
  "enterprise-admin/create-self-hosted-runner-group-for-enterprise": {
    parameters: {
      path: {
        /** The slug version of the enterprise name. You can also substitute this value with the enterprise id. */
        enterprise: components["parameters"]["enterprise"];
      };
    };
    responses: {
      /** Response */
      201: {
        content: {
          "application/json": components["schemas"]["runner-groups-enterprise"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": {
          /** @description Name of the runner group. */
          name: string;
          /**
           * @description Visibility of a runner group. You can select all organizations or select individual organization.
           * @enum {string}
           */
          visibility?: "selected" | "all";
          /** @description List of organization IDs that can access the runner group. */
          selected_organization_ids?: number[];
          /** @description List of runner IDs to add to the runner group. */
          runners?: number[];
          /**
           * @description Whether the runner group can be used by `public` repositories.
           * @default false
           */
          allows_public_repositories?: boolean;
        };
      };
    };
  };
  /**
   * Gets a specific self-hosted runner group for an enterprise.
   *
   * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
   */
  "enterprise-admin/get-self-hosted-runner-group-for-enterprise": {
    parameters: {
      path: {
        /** The slug version of the enterprise name. You can also substitute this value with the enterprise id. */
        enterprise: components["parameters"]["enterprise"];
        /** Unique identifier of the self-hosted runner group. */
        runner_group_id: components["parameters"]["runner-group-id"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["runner-groups-enterprise"];
        };
      };
    };
  };
  /**
   * Deletes a self-hosted runner group for an enterprise.
   *
   * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
   */
  "enterprise-admin/delete-self-hosted-runner-group-from-enterprise": {
    parameters: {
      path: {
        /** The slug version of the enterprise name. You can also substitute this value with the enterprise id. */
        enterprise: components["parameters"]["enterprise"];
        /** Unique identifier of the self-hosted runner group. */
        runner_group_id: components["parameters"]["runner-group-id"];
      };
    };
    responses: {
      /** Response */
      204: never;
    };
  };
  /**
   * Updates the `name` and `visibility` of a self-hosted runner group in an enterprise.
   *
   * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
   */
  "enterprise-admin/update-self-hosted-runner-group-for-enterprise": {
    parameters: {
      path: {
        /** The slug version of the enterprise name. You can also substitute this value with the enterprise id. */
        enterprise: components["parameters"]["enterprise"];
        /** Unique identifier of the self-hosted runner group. */
        runner_group_id: components["parameters"]["runner-group-id"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["runner-groups-enterprise"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": {
          /** @description Name of the runner group. */
          name?: string;
          /**
           * @description Visibility of a runner group. You can select all organizations or select individual organizations.
           * @default all
           * @enum {string}
           */
          visibility?: "selected" | "all";
          /**
           * @description Whether the runner group can be used by `public` repositories.
           * @default false
           */
          allows_public_repositories?: boolean;
        };
      };
    };
  };
  /**
   * Lists the organizations with access to a self-hosted runner group.
   *
   * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
   */
  "enterprise-admin/list-org-access-to-self-hosted-runner-group-in-enterprise": {
    parameters: {
      path: {
        /** The slug version of the enterprise name. You can also substitute this value with the enterprise id. */
        enterprise: components["parameters"]["enterprise"];
        /** Unique identifier of the self-hosted runner group. */
        runner_group_id: components["parameters"]["runner-group-id"];
      };
      query: {
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": {
            total_count: number;
            organizations: components["schemas"]["organization-simple"][];
          };
        };
      };
    };
  };
  /**
   * Replaces the list of organizations that have access to a self-hosted runner configured in an enterprise.
   *
   * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
   */
  "enterprise-admin/set-org-access-to-self-hosted-runner-group-in-enterprise": {
    parameters: {
      path: {
        /** The slug version of the enterprise name. You can also substitute this value with the enterprise id. */
        enterprise: components["parameters"]["enterprise"];
        /** Unique identifier of the self-hosted runner group. */
        runner_group_id: components["parameters"]["runner-group-id"];
      };
    };
    responses: {
      /** Response */
      204: never;
    };
    requestBody: {
      content: {
        "application/json": {
          /** @description List of organization IDs that can access the runner group. */
          selected_organization_ids: number[];
        };
      };
    };
  };
  /**
   * Adds an organization to the list of selected organizations that can access a self-hosted runner group. The runner group must have `visibility` set to `selected`. For more information, see "[Create a self-hosted runner group for an enterprise](#create-a-self-hosted-runner-group-for-an-enterprise)."
   *
   * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
   */
  "enterprise-admin/add-org-access-to-self-hosted-runner-group-in-enterprise": {
    parameters: {
      path: {
        /** The slug version of the enterprise name. You can also substitute this value with the enterprise id. */
        enterprise: components["parameters"]["enterprise"];
        /** Unique identifier of the self-hosted runner group. */
        runner_group_id: components["parameters"]["runner-group-id"];
        /** The unique identifier of the organization. */
        org_id: components["parameters"]["org-id"];
      };
    };
    responses: {
      /** Response */
      204: never;
    };
  };
  /**
   * Removes an organization from the list of selected organizations that can access a self-hosted runner group. The runner group must have `visibility` set to `selected`. For more information, see "[Create a self-hosted runner group for an enterprise](#create-a-self-hosted-runner-group-for-an-enterprise)."
   *
   * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
   */
  "enterprise-admin/remove-org-access-to-self-hosted-runner-group-in-enterprise": {
    parameters: {
      path: {
        /** The slug version of the enterprise name. You can also substitute this value with the enterprise id. */
        enterprise: components["parameters"]["enterprise"];
        /** Unique identifier of the self-hosted runner group. */
        runner_group_id: components["parameters"]["runner-group-id"];
        /** The unique identifier of the organization. */
        org_id: components["parameters"]["org-id"];
      };
    };
    responses: {
      /** Response */
      204: never;
    };
  };
  /**
   * Lists the self-hosted runners that are in a specific enterprise group.
   *
   * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
   */
  "enterprise-admin/list-self-hosted-runners-in-group-for-enterprise": {
    parameters: {
      path: {
        /** The slug version of the enterprise name. You can also substitute this value with the enterprise id. */
        enterprise: components["parameters"]["enterprise"];
        /** Unique identifier of the self-hosted runner group. */
        runner_group_id: components["parameters"]["runner-group-id"];
      };
      query: {
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /** Response */
      200: {
        headers: {};
        content: {
          "application/json": {
            total_count: number;
            runners: components["schemas"]["runner"][];
          };
        };
      };
    };
  };
  /**
   * Replaces the list of self-hosted runners that are part of an enterprise runner group.
   *
   * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
   */
  "enterprise-admin/set-self-hosted-runners-in-group-for-enterprise": {
    parameters: {
      path: {
        /** The slug version of the enterprise name. You can also substitute this value with the enterprise id. */
        enterprise: components["parameters"]["enterprise"];
        /** Unique identifier of the self-hosted runner group. */
        runner_group_id: components["parameters"]["runner-group-id"];
      };
    };
    responses: {
      /** Response */
      204: never;
    };
    requestBody: {
      content: {
        "application/json": {
          /** @description List of runner IDs to add to the runner group. */
          runners: number[];
        };
      };
    };
  };
  /**
   * Adds a self-hosted runner to a runner group configured in an enterprise.
   *
   * You must authenticate using an access token with the `manage_runners:enterprise`
   * scope to use this endpoint.
   */
  "enterprise-admin/add-self-hosted-runner-to-group-for-enterprise": {
    parameters: {
      path: {
        /** The slug version of the enterprise name. You can also substitute this value with the enterprise id. */
        enterprise: components["parameters"]["enterprise"];
        /** Unique identifier of the self-hosted runner group. */
        runner_group_id: components["parameters"]["runner-group-id"];
        /** Unique identifier of the self-hosted runner. */
        runner_id: components["parameters"]["runner-id"];
      };
    };
    responses: {
      /** Response */
      204: never;
    };
  };
  /**
   * Removes a self-hosted runner from a group configured in an enterprise. The runner is then returned to the default group.
   *
   * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
   */
  "enterprise-admin/remove-self-hosted-runner-from-group-for-enterprise": {
    parameters: {
      path: {
        /** The slug version of the enterprise name. You can also substitute this value with the enterprise id. */
        enterprise: components["parameters"]["enterprise"];
        /** Unique identifier of the self-hosted runner group. */
        runner_group_id: components["parameters"]["runner-group-id"];
        /** Unique identifier of the self-hosted runner. */
        runner_id: components["parameters"]["runner-id"];
      };
    };
    responses: {
      /** Response */
      204: never;
    };
  };
  /**
   * Lists all self-hosted runners configured for an enterprise.
   *
   * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
   */
  "enterprise-admin/list-self-hosted-runners-for-enterprise": {
    parameters: {
      path: {
        /** The slug version of the enterprise name. You can also substitute this value with the enterprise id. */
        enterprise: components["parameters"]["enterprise"];
      };
      query: {
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /** Response */
      200: {
        headers: {};
        content: {
          "application/json": {
            total_count?: number;
            runners?: components["schemas"]["runner"][];
          };
        };
      };
    };
  };
  /**
   * Lists binaries for the runner application that you can download and run.
   *
   * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
   */
  "enterprise-admin/list-runner-applications-for-enterprise": {
    parameters: {
      path: {
        /** The slug version of the enterprise name. You can also substitute this value with the enterprise id. */
        enterprise: components["parameters"]["enterprise"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["runner-application"][];
        };
      };
    };
  };
  /**
   * Returns a token that you can pass to the `config` script. The token expires after one hour.
   *
   * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
   *
   * #### Example using registration token
   *
   * Configure your self-hosted runner, replacing `TOKEN` with the registration token provided by this endpoint.
   *
   * ```
   * ./config.sh --url https://github.com/enterprises/octo-enterprise --token TOKEN
   * ```
   */
  "enterprise-admin/create-registration-token-for-enterprise": {
    parameters: {
      path: {
        /** The slug version of the enterprise name. You can also substitute this value with the enterprise id. */
        enterprise: components["parameters"]["enterprise"];
      };
    };
    responses: {
      /** Response */
      201: {
        content: {
          "application/json": components["schemas"]["authentication-token"];
        };
      };
    };
  };
  /**
   * Returns a token that you can pass to the `config` script to remove a self-hosted runner from an enterprise. The token expires after one hour.
   *
   * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
   *
   * #### Example using remove token
   *
   * To remove your self-hosted runner from an enterprise, replace `TOKEN` with the remove token provided by this
   * endpoint.
   *
   * ```
   * ./config.sh remove --token TOKEN
   * ```
   */
  "enterprise-admin/create-remove-token-for-enterprise": {
    parameters: {
      path: {
        /** The slug version of the enterprise name. You can also substitute this value with the enterprise id. */
        enterprise: components["parameters"]["enterprise"];
      };
    };
    responses: {
      /** Response */
      201: {
        content: {
          "application/json": components["schemas"]["authentication-token"];
        };
      };
    };
  };
  /**
   * Gets a specific self-hosted runner configured in an enterprise.
   *
   * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
   */
  "enterprise-admin/get-self-hosted-runner-for-enterprise": {
    parameters: {
      path: {
        /** The slug version of the enterprise name. You can also substitute this value with the enterprise id. */
        enterprise: components["parameters"]["enterprise"];
        /** Unique identifier of the self-hosted runner. */
        runner_id: components["parameters"]["runner-id"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["runner"];
        };
      };
    };
  };
  /**
   * Forces the removal of a self-hosted runner from an enterprise. You can use this endpoint to completely remove the runner when the machine you were using no longer exists.
   *
   * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
   */
  "enterprise-admin/delete-self-hosted-runner-from-enterprise": {
    parameters: {
      path: {
        /** The slug version of the enterprise name. You can also substitute this value with the enterprise id. */
        enterprise: components["parameters"]["enterprise"];
        /** Unique identifier of the self-hosted runner. */
        runner_id: components["parameters"]["runner-id"];
      };
    };
    responses: {
      /** Response */
      204: never;
    };
  };
  /** Gets the audit log for an enterprise. To use this endpoint, you must be an enterprise admin, and you must use an access token with the `admin:enterprise` scope. */
  "enterprise-admin/get-audit-log": {
    parameters: {
      path: {
        /** The slug version of the enterprise name. You can also substitute this value with the enterprise id. */
        enterprise: components["parameters"]["enterprise"];
      };
      query: {
        /** A search phrase. For more information, see [Searching the audit log](https://docs.github.com/enterprise-server@3.3/github/setting-up-and-managing-organizations-and-teams/reviewing-the-audit-log-for-your-organization#searching-the-audit-log). */
        phrase?: components["parameters"]["audit-log-phrase"];
        /** A cursor, as given in the [Link header](https://docs.github.com/enterprise-server@3.3/rest/overview/resources-in-the-rest-api#link-header). If specified, the query only searches for events after this cursor. */
        after?: components["parameters"]["audit-log-after"];
        /** A cursor, as given in the [Link header](https://docs.github.com/enterprise-server@3.3/rest/overview/resources-in-the-rest-api#link-header). If specified, the query only searches for events before this cursor. */
        before?: components["parameters"]["audit-log-before"];
        /**
         * The order of audit log events. To list newest events first, specify `desc`. To list oldest events first, specify `asc`.
         *
         * The default is `desc`.
         */
        order?: components["parameters"]["audit-log-order"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["audit-log-event"][];
        };
      };
    };
  };
  /** We delay the public events feed by five minutes, which means the most recent event returned by the public events API actually occurred at least five minutes ago. */
  "activity/list-public-events": {
    parameters: {
      query: {
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["event"][];
        };
      };
      304: components["responses"]["not_modified"];
      403: components["responses"]["forbidden"];
      503: components["responses"]["service_unavailable"];
    };
  };
  /**
   * GitHub Enterprise Server provides several timeline resources in [Atom](http://en.wikipedia.org/wiki/Atom_(standard)) format. The Feeds API lists all the feeds available to the authenticated user:
   *
   * *   **Timeline**: The GitHub Enterprise Server global public timeline
   * *   **User**: The public timeline for any user, using [URI template](https://docs.github.com/enterprise-server@3.3/rest/overview/resources-in-the-rest-api#hypermedia)
   * *   **Current user public**: The public timeline for the authenticated user
   * *   **Current user**: The private timeline for the authenticated user
   * *   **Current user actor**: The private timeline for activity created by the authenticated user
   * *   **Current user organizations**: The private timeline for the organizations the authenticated user is a member of.
   * *   **Security advisories**: A collection of public announcements that provide information about security-related vulnerabilities in software on GitHub Enterprise Server.
   *
   * **Note**: Private feeds are only returned when [authenticating via Basic Auth](https://docs.github.com/enterprise-server@3.3/rest/overview/other-authentication-methods#basic-authentication) since current feed URIs use the older, non revocable auth tokens.
   */
  "activity/get-feeds": {
    parameters: {};
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["feed"];
        };
      };
    };
  };
  /** Lists the authenticated user's gists or if called anonymously, this endpoint returns all public gists: */
  "gists/list": {
    parameters: {
      query: {
        /** Only show notifications updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`. */
        since?: components["parameters"]["since"];
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /** Response */
      200: {
        headers: {};
        content: {
          "application/json": components["schemas"]["base-gist"][];
        };
      };
      304: components["responses"]["not_modified"];
      403: components["responses"]["forbidden"];
    };
  };
  /**
   * Allows you to add a new gist with one or more files.
   *
   * **Note:** Don't name your files "gistfile" with a numerical suffix. This is the format of the automatic naming scheme that Gist uses internally.
   */
  "gists/create": {
    parameters: {};
    responses: {
      /** Response */
      201: {
        headers: {
          Location?: string;
        };
        content: {
          "application/json": components["schemas"]["gist-simple"];
        };
      };
      304: components["responses"]["not_modified"];
      403: components["responses"]["forbidden"];
      404: components["responses"]["not_found"];
      422: components["responses"]["validation_failed"];
    };
    requestBody: {
      content: {
        "application/json": {
          /**
           * @description Description of the gist
           * @example Example Ruby script
           */
          description?: string;
          /**
           * @description Names and content for the files that make up the gist
           * @example {
           *   "hello.rb": {
           *     "content": "puts \"Hello, World!\""
           *   }
           * }
           */
          files: {
            [key: string]: {
              /** @description Content of the file */
              content: string;
            };
          };
          public?: boolean | ("true" | "false");
        };
      };
    };
  };
  /**
   * List public gists sorted by most recently updated to least recently updated.
   *
   * Note: With [pagination](https://docs.github.com/enterprise-server@3.3/rest/overview/resources-in-the-rest-api#pagination), you can fetch up to 3000 gists. For example, you can fetch 100 pages with 30 gists per page or 30 pages with 100 gists per page.
   */
  "gists/list-public": {
    parameters: {
      query: {
        /** Only show notifications updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`. */
        since?: components["parameters"]["since"];
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /** Response */
      200: {
        headers: {};
        content: {
          "application/json": components["schemas"]["base-gist"][];
        };
      };
      304: components["responses"]["not_modified"];
      403: components["responses"]["forbidden"];
      422: components["responses"]["validation_failed"];
    };
  };
  /** List the authenticated user's starred gists: */
  "gists/list-starred": {
    parameters: {
      query: {
        /** Only show notifications updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`. */
        since?: components["parameters"]["since"];
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /** Response */
      200: {
        headers: {};
        content: {
          "application/json": components["schemas"]["base-gist"][];
        };
      };
      304: components["responses"]["not_modified"];
      401: components["responses"]["requires_authentication"];
      403: components["responses"]["forbidden"];
    };
  };
  "gists/get": {
    parameters: {
      path: {
        /** The unique identifier of the gist. */
        gist_id: components["parameters"]["gist-id"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["gist-simple"];
        };
      };
      304: components["responses"]["not_modified"];
      403: components["responses"]["forbidden_gist"];
      404: components["responses"]["not_found"];
    };
  };
  "gists/delete": {
    parameters: {
      path: {
        /** The unique identifier of the gist. */
        gist_id: components["parameters"]["gist-id"];
      };
    };
    responses: {
      /** Response */
      204: never;
      304: components["responses"]["not_modified"];
      403: components["responses"]["forbidden"];
      404: components["responses"]["not_found"];
    };
  };
  /** Allows you to update or delete a gist file and rename gist files. Files from the previous version of the gist that aren't explicitly changed during an edit are unchanged. */
  "gists/update": {
    parameters: {
      path: {
        /** The unique identifier of the gist. */
        gist_id: components["parameters"]["gist-id"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["gist-simple"];
        };
      };
      404: components["responses"]["not_found"];
      422: components["responses"]["validation_failed"];
    };
    requestBody: {
      content: {
        "application/json": {
          /**
           * @description Description of the gist
           * @example Example Ruby script
           */
          description?: string;
          /**
           * @description Names of files to be updated
           * @example {
           *   "hello.rb": {
           *     "content": "blah",
           *     "filename": "goodbye.rb"
           *   }
           * }
           */
          files?: { [key: string]: Partial<{ [key: string]: unknown }> };
        } | null;
      };
    };
  };
  "gists/list-comments": {
    parameters: {
      path: {
        /** The unique identifier of the gist. */
        gist_id: components["parameters"]["gist-id"];
      };
      query: {
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /** Response */
      200: {
        headers: {};
        content: {
          "application/json": components["schemas"]["gist-comment"][];
        };
      };
      304: components["responses"]["not_modified"];
      403: components["responses"]["forbidden"];
      404: components["responses"]["not_found"];
    };
  };
  "gists/create-comment": {
    parameters: {
      path: {
        /** The unique identifier of the gist. */
        gist_id: components["parameters"]["gist-id"];
      };
    };
    responses: {
      /** Response */
      201: {
        headers: {
          Location?: string;
        };
        content: {
          "application/json": components["schemas"]["gist-comment"];
        };
      };
      304: components["responses"]["not_modified"];
      403: components["responses"]["forbidden"];
      404: components["responses"]["not_found"];
    };
    requestBody: {
      content: {
        "application/json": {
          /**
           * @description The comment text.
           * @example Body of the attachment
           */
          body: string;
        };
      };
    };
  };
  "gists/get-comment": {
    parameters: {
      path: {
        /** The unique identifier of the gist. */
        gist_id: components["parameters"]["gist-id"];
        /** The unique identifier of the comment. */
        comment_id: components["parameters"]["comment-id"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["gist-comment"];
        };
      };
      304: components["responses"]["not_modified"];
      403: components["responses"]["forbidden_gist"];
      404: components["responses"]["not_found"];
    };
  };
  "gists/delete-comment": {
    parameters: {
      path: {
        /** The unique identifier of the gist. */
        gist_id: components["parameters"]["gist-id"];
        /** The unique identifier of the comment. */
        comment_id: components["parameters"]["comment-id"];
      };
    };
    responses: {
      /** Response */
      204: never;
      304: components["responses"]["not_modified"];
      403: components["responses"]["forbidden"];
      404: components["responses"]["not_found"];
    };
  };
  "gists/update-comment": {
    parameters: {
      path: {
        /** The unique identifier of the gist. */
        gist_id: components["parameters"]["gist-id"];
        /** The unique identifier of the comment. */
        comment_id: components["parameters"]["comment-id"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["gist-comment"];
        };
      };
      404: components["responses"]["not_found"];
    };
    requestBody: {
      content: {
        "application/json": {
          /**
           * @description The comment text.
           * @example Body of the attachment
           */
          body: string;
        };
      };
    };
  };
  "gists/list-commits": {
    parameters: {
      path: {
        /** The unique identifier of the gist. */
        gist_id: components["parameters"]["gist-id"];
      };
      query: {
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /** Response */
      200: {
        headers: {
          Link?: string;
        };
        content: {
          "application/json": components["schemas"]["gist-commit"][];
        };
      };
      304: components["responses"]["not_modified"];
      403: components["responses"]["forbidden"];
      404: components["responses"]["not_found"];
    };
  };
  "gists/list-forks": {
    parameters: {
      path: {
        /** The unique identifier of the gist. */
        gist_id: components["parameters"]["gist-id"];
      };
      query: {
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /** Response */
      200: {
        headers: {};
        content: {
          "application/json": components["schemas"]["gist-simple"][];
        };
      };
      304: components["responses"]["not_modified"];
      403: components["responses"]["forbidden"];
      404: components["responses"]["not_found"];
    };
  };
  "gists/fork": {
    parameters: {
      path: {
        /** The unique identifier of the gist. */
        gist_id: components["parameters"]["gist-id"];
      };
    };
    responses: {
      /** Response */
      201: {
        headers: {
          Location?: string;
        };
        content: {
          "application/json": components["schemas"]["base-gist"];
        };
      };
      304: components["responses"]["not_modified"];
      403: components["responses"]["forbidden"];
      404: components["responses"]["not_found"];
      422: components["responses"]["validation_failed"];
    };
  };
  "gists/check-is-starred": {
    parameters: {
      path: {
        /** The unique identifier of the gist. */
        gist_id: components["parameters"]["gist-id"];
      };
    };
    responses: {
      /** Response if gist is starred */
      204: never;
      304: components["responses"]["not_modified"];
      403: components["responses"]["forbidden"];
      /** Not Found if gist is not starred */
      404: {
        content: {
          "application/json": { [key: string]: unknown };
        };
      };
    };
  };
  /** Note that you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://docs.github.com/enterprise-server@3.3/rest/overview/resources-in-the-rest-api#http-verbs)." */
  "gists/star": {
    parameters: {
      path: {
        /** The unique identifier of the gist. */
        gist_id: components["parameters"]["gist-id"];
      };
    };
    responses: {
      /** Response */
      204: never;
      304: components["responses"]["not_modified"];
      403: components["responses"]["forbidden"];
      404: components["responses"]["not_found"];
    };
  };
  "gists/unstar": {
    parameters: {
      path: {
        /** The unique identifier of the gist. */
        gist_id: components["parameters"]["gist-id"];
      };
    };
    responses: {
      /** Response */
      204: never;
      304: components["responses"]["not_modified"];
      403: components["responses"]["forbidden"];
      404: components["responses"]["not_found"];
    };
  };
  "gists/get-revision": {
    parameters: {
      path: {
        /** The unique identifier of the gist. */
        gist_id: components["parameters"]["gist-id"];
        sha: string;
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["gist-simple"];
        };
      };
      403: components["responses"]["forbidden"];
      404: components["responses"]["not_found"];
      422: components["responses"]["validation_failed"];
    };
  };
  /** List all templates available to pass as an option when [creating a repository](https://docs.github.com/enterprise-server@3.3/rest/reference/repos#create-a-repository-for-the-authenticated-user). */
  "gitignore/get-all-templates": {
    parameters: {};
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": string[];
        };
      };
      304: components["responses"]["not_modified"];
    };
  };
  /**
   * The API also allows fetching the source of a single template.
   * Use the raw [media type](https://docs.github.com/enterprise-server@3.3/rest/overview/media-types/) to get the raw contents.
   */
  "gitignore/get-template": {
    parameters: {
      path: {
        name: string;
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["gitignore-template"];
        };
      };
      304: components["responses"]["not_modified"];
    };
  };
  /**
   * List repositories that an app installation can access.
   *
   * You must use an [installation access token](https://docs.github.com/enterprise-server@3.3/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-an-installation) to access this endpoint.
   */
  "apps/list-repos-accessible-to-installation": {
    parameters: {
      query: {
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /** Response */
      200: {
        headers: {};
        content: {
          "application/json": {
            total_count: number;
            repositories: components["schemas"]["repository"][];
            /** @example selected */
            repository_selection?: string;
          };
        };
      };
      304: components["responses"]["not_modified"];
      401: components["responses"]["requires_authentication"];
      403: components["responses"]["forbidden"];
    };
  };
  /**
   * Revokes the installation token you're using to authenticate as an installation and access this endpoint.
   *
   * Once an installation token is revoked, the token is invalidated and cannot be used. Other endpoints that require the revoked installation token must have a new installation token to work. You can create a new token using the "[Create an installation access token for an app](https://docs.github.com/enterprise-server@3.3/rest/reference/apps#create-an-installation-access-token-for-an-app)" endpoint.
   *
   * You must use an [installation access token](https://docs.github.com/enterprise-server@3.3/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-an-installation) to access this endpoint.
   */
  "apps/revoke-installation-access-token": {
    parameters: {};
    responses: {
      /** Response */
      204: never;
    };
  };
  /**
   * List issues assigned to the authenticated user across all visible repositories including owned repositories, member
   * repositories, and organization repositories. You can use the `filter` query parameter to fetch issues that are not
   * necessarily assigned to you.
   *
   *
   * **Note**: GitHub's REST API v3 considers every pull request an issue, but not every issue is a pull request. For this
   * reason, "Issues" endpoints may return both issues and pull requests in the response. You can identify pull requests by
   * the `pull_request` key. Be aware that the `id` of a pull request returned from "Issues" endpoints will be an _issue id_. To find out the pull
   * request id, use the "[List pull requests](https://docs.github.com/enterprise-server@3.3/rest/reference/pulls#list-pull-requests)" endpoint.
   */
  "issues/list": {
    parameters: {
      query: {
        /** Indicates which sorts of issues to return. `assigned` means issues assigned to you. `created` means issues created by you. `mentioned` means issues mentioning you. `subscribed` means issues you're subscribed to updates for. `all` or `repos` means all issues you can see, regardless of participation or creation. */
        filter?:
          | "assigned"
          | "created"
          | "mentioned"
          | "subscribed"
          | "repos"
          | "all";
        /** Indicates the state of the issues to return. */
        state?: "open" | "closed" | "all";
        /** A list of comma separated label names. Example: `bug,ui,@high` */
        labels?: components["parameters"]["labels"];
        /** What to sort results by. */
        sort?: "created" | "updated" | "comments";
        /** The direction to sort the results by. */
        direction?: components["parameters"]["direction"];
        /** Only show notifications updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`. */
        since?: components["parameters"]["since"];
        collab?: boolean;
        orgs?: boolean;
        owned?: boolean;
        pulls?: boolean;
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /** Response */
      200: {
        headers: {};
        content: {
          "application/json": components["schemas"]["issue"][];
        };
      };
      304: components["responses"]["not_modified"];
      404: components["responses"]["not_found"];
      422: components["responses"]["validation_failed"];
    };
  };
  "licenses/get-all-commonly-used": {
    parameters: {
      query: {
        featured?: boolean;
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["license-simple"][];
        };
      };
      304: components["responses"]["not_modified"];
    };
  };
  "licenses/get": {
    parameters: {
      path: {
        license: string;
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["license"];
        };
      };
      304: components["responses"]["not_modified"];
      403: components["responses"]["forbidden"];
      404: components["responses"]["not_found"];
    };
  };
  "markdown/render": {
    parameters: {};
    responses: {
      /** Response */
      200: {
        headers: {
          "Content-Length"?: string;
        };
        content: {
          "text/html": string;
        };
      };
      304: components["responses"]["not_modified"];
    };
    requestBody: {
      content: {
        "application/json": {
          /** @description The Markdown text to render in HTML. */
          text: string;
          /**
           * @description The rendering mode.
           * @default markdown
           * @example markdown
           * @enum {string}
           */
          mode?: "markdown" | "gfm";
          /** @description The repository context to use when creating references in `gfm` mode.  For example, setting `context` to `octo-org/octo-repo` will change the text `#42` into an HTML link to issue 42 in the `octo-org/octo-repo` repository. */
          context?: string;
        };
      };
    };
  };
  /** You must send Markdown as plain text (using a `Content-Type` header of `text/plain` or `text/x-markdown`) to this endpoint, rather than using JSON format. In raw mode, [GitHub Flavored Markdown](https://github.github.com/gfm/) is not supported and Markdown will be rendered in plain format like a README.md file. Markdown content must be 400 KB or less. */
  "markdown/render-raw": {
    parameters: {};
    responses: {
      /** Response */
      200: {
        headers: {};
        content: {
          "text/html": string;
        };
      };
      304: components["responses"]["not_modified"];
    };
    requestBody: {
      content: {
        "text/plain": string;
        "text/x-markdown": string;
      };
    };
  };
  "meta/get": {
    parameters: {};
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["api-overview"];
        };
      };
      304: components["responses"]["not_modified"];
    };
  };
  "activity/list-public-events-for-repo-network": {
    parameters: {
      path: {
        /** The account owner of the repository. The name is not case sensitive. */
        owner: components["parameters"]["owner"];
        /** The name of the repository. The name is not case sensitive. */
        repo: components["parameters"]["repo"];
      };
      query: {
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["event"][];
        };
      };
      301: components["responses"]["moved_permanently"];
      304: components["responses"]["not_modified"];
      403: components["responses"]["forbidden"];
      404: components["responses"]["not_found"];
    };
  };
  /** List all notifications for the current user, sorted by most recently updated. */
  "activity/list-notifications-for-authenticated-user": {
    parameters: {
      query: {
        /** If `true`, show notifications marked as read. */
        all?: components["parameters"]["all"];
        /** If `true`, only shows notifications in which the user is directly participating or mentioned. */
        participating?: components["parameters"]["participating"];
        /** Only show notifications updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`. */
        since?: components["parameters"]["since"];
        /** Only show notifications updated before the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`. */
        before?: components["parameters"]["before"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
        /** The number of results per page (max 50). */
        per_page?: number;
      };
    };
    responses: {
      /** Response */
      200: {
        headers: {};
        content: {
          "application/json": components["schemas"]["thread"][];
        };
      };
      304: components["responses"]["not_modified"];
      401: components["responses"]["requires_authentication"];
      403: components["responses"]["forbidden"];
      422: components["responses"]["validation_failed"];
    };
  };
  /** Marks all notifications as "read" removes it from the [default view on GitHub Enterprise Server](https://github.com/notifications). If the number of notifications is too large to complete in one request, you will receive a `202 Accepted` status and GitHub Enterprise Server will run an asynchronous process to mark notifications as "read." To check whether any "unread" notifications remain, you can use the [List notifications for the authenticated user](https://docs.github.com/enterprise-server@3.3/rest/reference/activity#list-notifications-for-the-authenticated-user) endpoint and pass the query parameter `all=false`. */
  "activity/mark-notifications-as-read": {
    parameters: {};
    responses: {
      /** Response */
      202: {
        content: {
          "application/json": {
            message?: string;
          };
        };
      };
      /** Reset Content */
      205: unknown;
      304: components["responses"]["not_modified"];
      401: components["responses"]["requires_authentication"];
      403: components["responses"]["forbidden"];
    };
    requestBody: {
      content: {
        "application/json": {
          /**
           * Format: date-time
           * @description Describes the last point that notifications were checked. Anything updated since this time will not be marked as read. If you omit this parameter, all notifications are marked as read. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`. Default: The current timestamp.
           */
          last_read_at?: string;
          /** @description Whether the notification has been read. */
          read?: boolean;
        };
      };
    };
  };
  "activity/get-thread": {
    parameters: {
      path: {
        /** The unique identifier of the pull request thread. */
        thread_id: components["parameters"]["thread-id"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["thread"];
        };
      };
      304: components["responses"]["not_modified"];
      401: components["responses"]["requires_authentication"];
      403: components["responses"]["forbidden"];
    };
  };
  "activity/mark-thread-as-read": {
    parameters: {
      path: {
        /** The unique identifier of the pull request thread. */
        thread_id: components["parameters"]["thread-id"];
      };
    };
    responses: {
      /** Reset Content */
      205: unknown;
      304: components["responses"]["not_modified"];
      403: components["responses"]["forbidden"];
    };
  };
  /**
   * This checks to see if the current user is subscribed to a thread. You can also [get a repository subscription](https://docs.github.com/enterprise-server@3.3/rest/reference/activity#get-a-repository-subscription).
   *
   * Note that subscriptions are only generated if a user is participating in a conversation--for example, they've replied to the thread, were **@mentioned**, or manually subscribe to a thread.
   */
  "activity/get-thread-subscription-for-authenticated-user": {
    parameters: {
      path: {
        /** The unique identifier of the pull request thread. */
        thread_id: components["parameters"]["thread-id"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["thread-subscription"];
        };
      };
      304: components["responses"]["not_modified"];
      401: components["responses"]["requires_authentication"];
      403: components["responses"]["forbidden"];
    };
  };
  /**
   * If you are watching a repository, you receive notifications for all threads by default. Use this endpoint to ignore future notifications for threads until you comment on the thread or get an **@mention**.
   *
   * You can also use this endpoint to subscribe to threads that you are currently not receiving notifications for or to subscribed to threads that you have previously ignored.
   *
   * Unsubscribing from a conversation in a repository that you are not watching is functionally equivalent to the [Delete a thread subscription](https://docs.github.com/enterprise-server@3.3/rest/reference/activity#delete-a-thread-subscription) endpoint.
   */
  "activity/set-thread-subscription": {
    parameters: {
      path: {
        /** The unique identifier of the pull request thread. */
        thread_id: components["parameters"]["thread-id"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["thread-subscription"];
        };
      };
      304: components["responses"]["not_modified"];
      401: components["responses"]["requires_authentication"];
      403: components["responses"]["forbidden"];
    };
    requestBody: {
      content: {
        "application/json": {
          /**
           * @description Whether to block all notifications from a thread.
           * @default false
           */
          ignored?: boolean;
        };
      };
    };
  };
  /** Mutes all future notifications for a conversation until you comment on the thread or get an **@mention**. If you are watching the repository of the thread, you will still receive notifications. To ignore future notifications for a repository you are watching, use the [Set a thread subscription](https://docs.github.com/enterprise-server@3.3/rest/reference/activity#set-a-thread-subscription) endpoint and set `ignore` to `true`. */
  "activity/delete-thread-subscription": {
    parameters: {
      path: {
        /** The unique identifier of the pull request thread. */
        thread_id: components["parameters"]["thread-id"];
      };
    };
    responses: {
      /** Response */
      204: never;
      304: components["responses"]["not_modified"];
      401: components["responses"]["requires_authentication"];
      403: components["responses"]["forbidden"];
    };
  };
  /** Get the octocat as ASCII art */
  "meta/get-octocat": {
    parameters: {
      query: {
        /** The words to show in Octocat's speech bubble */
        s?: string;
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/octocat-stream": string;
        };
      };
    };
  };
  /**
   * Lists all organizations, in the order that they were created on GitHub Enterprise Server.
   *
   * **Note:** Pagination is powered exclusively by the `since` parameter. Use the [Link header](https://docs.github.com/enterprise-server@3.3/rest/overview/resources-in-the-rest-api#link-header) to get the URL for the next page of organizations.
   */
  "orgs/list": {
    parameters: {
      query: {
        /** An organization ID. Only return organizations with an ID greater than this ID. */
        since?: components["parameters"]["since-org"];
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
      };
    };
    responses: {
      /** Response */
      200: {
        headers: {
          Link?: string;
        };
        content: {
          "application/json": components["schemas"]["organization-simple"][];
        };
      };
      304: components["responses"]["not_modified"];
    };
  };
  /**
   * To see many of the organization response values, you need to be an authenticated organization owner with the `admin:org` scope. When the value of `two_factor_requirement_enabled` is `true`, the organization requires all members, billing managers, and outside collaborators to enable [two-factor authentication](https://docs.github.com/articles/securing-your-account-with-two-factor-authentication-2fa/).
   *
   * GitHub Apps with the `Organization plan` permission can use this endpoint to retrieve information about an organization's GitHub Enterprise Server plan. See "[Authenticating with GitHub Apps](https://docs.github.com/enterprise-server@3.3/apps/building-github-apps/authenticating-with-github-apps/)" for details. For an example response, see 'Response with GitHub Enterprise Server plan information' below."
   */
  "orgs/get": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["organization-full"];
        };
      };
      404: components["responses"]["not_found"];
    };
  };
  /**
   * **Parameter Deprecation Notice:** GitHub Enterprise Server will replace and discontinue `members_allowed_repository_creation_type` in favor of more granular permissions. The new input parameters are `members_can_create_public_repositories`, `members_can_create_private_repositories` for all organizations and `members_can_create_internal_repositories` for organizations associated with an enterprise account using GitHub Enterprise Cloud or GitHub Enterprise Server 2.20+. For more information, see the [blog post](https://developer.github.com/changes/2019-12-03-internal-visibility-changes).
   *
   * Enables an authenticated organization owner with the `admin:org` scope to update the organization's profile and member privileges.
   */
  "orgs/update": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["organization-full"];
        };
      };
      409: components["responses"]["conflict"];
      /** Validation failed */
      422: {
        content: {
          "application/json":
            | components["schemas"]["validation-error"]
            | components["schemas"]["validation-error-simple"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": {
          /** @description Billing email address. This address is not publicized. */
          billing_email?: string;
          /** @description The company name. */
          company?: string;
          /** @description The publicly visible email address. */
          email?: string;
          /** @description The Twitter username of the company. */
          twitter_username?: string;
          /** @description The location. */
          location?: string;
          /** @description The shorthand name of the company. */
          name?: string;
          /** @description The description of the company. */
          description?: string;
          /** @description Whether an organization can use organization projects. */
          has_organization_projects?: boolean;
          /** @description Whether repositories that belong to the organization can use repository projects. */
          has_repository_projects?: boolean;
          /**
           * @description Default permission level members have for organization repositories.
           * @default read
           * @enum {string}
           */
          default_repository_permission?: "read" | "write" | "admin" | "none";
          /**
           * @description Whether of non-admin organization members can create repositories. **Note:** A parameter can override this parameter. See `members_allowed_repository_creation_type` in this table for details.
           * @default true
           */
          members_can_create_repositories?: boolean;
          /** @description Whether organization members can create internal repositories, which are visible to all enterprise members. You can only allow members to create internal repositories if your organization is associated with an enterprise account using GitHub Enterprise Cloud or GitHub Enterprise Server 2.20+. For more information, see "[Restricting repository creation in your organization](https://docs.github.com/github/setting-up-and-managing-organizations-and-teams/restricting-repository-creation-in-your-organization)" in the GitHub Help documentation. */
          members_can_create_internal_repositories?: boolean;
          /** @description Whether organization members can create private repositories, which are visible to organization members with permission. For more information, see "[Restricting repository creation in your organization](https://docs.github.com/github/setting-up-and-managing-organizations-and-teams/restricting-repository-creation-in-your-organization)" in the GitHub Help documentation. */
          members_can_create_private_repositories?: boolean;
          /** @description Whether organization members can create public repositories, which are visible to anyone. For more information, see "[Restricting repository creation in your organization](https://docs.github.com/github/setting-up-and-managing-organizations-and-teams/restricting-repository-creation-in-your-organization)" in the GitHub Help documentation. */
          members_can_create_public_repositories?: boolean;
          /**
           * @description Specifies which types of repositories non-admin organization members can create.
           * **Note:** This parameter is deprecated and will be removed in the future. Its return value ignores internal repositories. Using this parameter overrides values set in `members_can_create_repositories`. See the parameter deprecation notice in the operation description for details.
           * @enum {string}
           */
          members_allowed_repository_creation_type?: "all" | "private" | "none";
          /**
           * @description Whether organization members can create GitHub Pages sites. Existing published sites will not be impacted.
           * @default true
           */
          members_can_create_pages?: boolean;
          /** @example "http://github.blog" */
          blog?: string;
        };
      };
    };
  };
  /**
   * Gets the GitHub Actions permissions policy for repositories and allowed actions in an organization.
   *
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `administration` organization permission to use this API.
   */
  "actions/get-github-actions-permissions-organization": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["actions-organization-permissions"];
        };
      };
    };
  };
  /**
   * Sets the GitHub Actions permissions policy for repositories and allowed actions in an organization.
   *
   * If the organization belongs to an enterprise that has set restrictive permissions at the enterprise level, such as `allowed_actions` to `selected` actions, then you cannot override them for the organization.
   *
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `administration` organization permission to use this API.
   */
  "actions/set-github-actions-permissions-organization": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
    };
    responses: {
      /** Response */
      204: never;
    };
    requestBody: {
      content: {
        "application/json": {
          enabled_repositories: components["schemas"]["enabled-repositories"];
          allowed_actions?: components["schemas"]["allowed-actions"];
        };
      };
    };
  };
  /**
   * Lists the selected repositories that are enabled for GitHub Actions in an organization. To use this endpoint, the organization permission policy for `enabled_repositories` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization)."
   *
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `administration` organization permission to use this API.
   */
  "actions/list-selected-repositories-enabled-github-actions-organization": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
      query: {
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": {
            total_count: number;
            repositories: components["schemas"]["repository"][];
          };
        };
      };
    };
  };
  /**
   * Replaces the list of selected repositories that are enabled for GitHub Actions in an organization. To use this endpoint, the organization permission policy for `enabled_repositories` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization)."
   *
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `administration` organization permission to use this API.
   */
  "actions/set-selected-repositories-enabled-github-actions-organization": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
    };
    responses: {
      /** Response */
      204: never;
    };
    requestBody: {
      content: {
        "application/json": {
          /** @description List of repository IDs to enable for GitHub Actions. */
          selected_repository_ids: number[];
        };
      };
    };
  };
  /**
   * Adds a repository to the list of selected repositories that are enabled for GitHub Actions in an organization. To use this endpoint, the organization permission policy for `enabled_repositories` must be must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization)."
   *
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `administration` organization permission to use this API.
   */
  "actions/enable-selected-repository-github-actions-organization": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The unique identifier of the repository. */
        repository_id: components["parameters"]["repository-id"];
      };
    };
    responses: {
      /** Response */
      204: never;
    };
  };
  /**
   * Removes a repository from the list of selected repositories that are enabled for GitHub Actions in an organization. To use this endpoint, the organization permission policy for `enabled_repositories` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization)."
   *
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `administration` organization permission to use this API.
   */
  "actions/disable-selected-repository-github-actions-organization": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The unique identifier of the repository. */
        repository_id: components["parameters"]["repository-id"];
      };
    };
    responses: {
      /** Response */
      204: never;
    };
  };
  /**
   * Gets the selected actions that are allowed in an organization. To use this endpoint, the organization permission policy for `allowed_actions` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization).""
   *
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `administration` organization permission to use this API.
   */
  "actions/get-allowed-actions-organization": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["selected-actions"];
        };
      };
    };
  };
  /**
   * Sets the actions that are allowed in an organization. To use this endpoint, the organization permission policy for `allowed_actions` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization)."
   *
   * If the organization belongs to an enterprise that has `selected` actions set at the enterprise level, then you cannot override any of the enterprise's allowed actions settings.
   *
   * To use the `patterns_allowed` setting for private repositories, the organization must belong to an enterprise. If the organization does not belong to an enterprise, then the `patterns_allowed` setting only applies to public repositories in the organization.
   *
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `administration` organization permission to use this API.
   */
  "actions/set-allowed-actions-organization": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
    };
    responses: {
      /** Response */
      204: never;
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["selected-actions"];
      };
    };
  };
  /**
   * Lists all self-hosted runner groups configured in an organization and inherited from an enterprise.
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
   */
  "actions/list-self-hosted-runner-groups-for-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
      query: {
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": {
            total_count: number;
            runner_groups: components["schemas"]["runner-groups-org"][];
          };
        };
      };
    };
  };
  /**
   * The self-hosted runner groups REST API is available with GitHub Enterprise Cloud and GitHub Enterprise Server. For more information, see "[GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products)."
   *
   * Creates a new self-hosted runner group for an organization.
   *
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
   */
  "actions/create-self-hosted-runner-group-for-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
    };
    responses: {
      /** Response */
      201: {
        content: {
          "application/json": components["schemas"]["runner-groups-org"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": {
          /** @description Name of the runner group. */
          name: string;
          /**
           * @description Visibility of a runner group. You can select all repositories, select individual repositories, or limit access to private repositories.
           * @default all
           * @enum {string}
           */
          visibility?: "selected" | "all" | "private";
          /** @description List of repository IDs that can access the runner group. */
          selected_repository_ids?: number[];
          /** @description List of runner IDs to add to the runner group. */
          runners?: number[];
          /**
           * @description Whether the runner group can be used by `public` repositories.
           * @default false
           */
          allows_public_repositories?: boolean;
        };
      };
    };
  };
  /**
   * Gets a specific self-hosted runner group for an organization.
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
   */
  "actions/get-self-hosted-runner-group-for-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** Unique identifier of the self-hosted runner group. */
        runner_group_id: components["parameters"]["runner-group-id"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["runner-groups-org"];
        };
      };
    };
  };
  /**
   * Deletes a self-hosted runner group for an organization.
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
   */
  "actions/delete-self-hosted-runner-group-from-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** Unique identifier of the self-hosted runner group. */
        runner_group_id: components["parameters"]["runner-group-id"];
      };
    };
    responses: {
      /** Response */
      204: never;
    };
  };
  /**
   * Updates the `name` and `visibility` of a self-hosted runner group in an organization.
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
   */
  "actions/update-self-hosted-runner-group-for-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** Unique identifier of the self-hosted runner group. */
        runner_group_id: components["parameters"]["runner-group-id"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["runner-groups-org"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": {
          /** @description Name of the runner group. */
          name: string;
          /**
           * @description Visibility of a runner group. You can select all repositories, select individual repositories, or all private repositories.
           * @enum {string}
           */
          visibility?: "selected" | "all" | "private";
          /**
           * @description Whether the runner group can be used by `public` repositories.
           * @default false
           */
          allows_public_repositories?: boolean;
        };
      };
    };
  };
  /**
   * The self-hosted runner groups REST API is available with GitHub Enterprise Cloud and GitHub Enterprise Server. For more information, see "[GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products)."
   *
   * Lists the repositories with access to a self-hosted runner group configured in an organization.
   *
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
   */
  "actions/list-repo-access-to-self-hosted-runner-group-in-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** Unique identifier of the self-hosted runner group. */
        runner_group_id: components["parameters"]["runner-group-id"];
      };
      query: {
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": {
            total_count: number;
            repositories: components["schemas"]["minimal-repository"][];
          };
        };
      };
    };
  };
  /**
   * Replaces the list of repositories that have access to a self-hosted runner group configured in an organization.
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
   */
  "actions/set-repo-access-to-self-hosted-runner-group-in-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** Unique identifier of the self-hosted runner group. */
        runner_group_id: components["parameters"]["runner-group-id"];
      };
    };
    responses: {
      /** Response */
      204: never;
    };
    requestBody: {
      content: {
        "application/json": {
          /** @description List of repository IDs that can access the runner group. */
          selected_repository_ids: number[];
        };
      };
    };
  };
  /**
   * Adds a repository to the list of selected repositories that can access a self-hosted runner group. The runner group must have `visibility` set to `selected`. For more information, see "[Create a self-hosted runner group for an organization](#create-a-self-hosted-runner-group-for-an-organization)."
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
   */
  "actions/add-repo-access-to-self-hosted-runner-group-in-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** Unique identifier of the self-hosted runner group. */
        runner_group_id: components["parameters"]["runner-group-id"];
        /** The unique identifier of the repository. */
        repository_id: components["parameters"]["repository-id"];
      };
    };
    responses: {
      /** Response */
      204: never;
    };
  };
  /**
   * Removes a repository from the list of selected repositories that can access a self-hosted runner group. The runner group must have `visibility` set to `selected`. For more information, see "[Create a self-hosted runner group for an organization](#create-a-self-hosted-runner-group-for-an-organization)."
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
   */
  "actions/remove-repo-access-to-self-hosted-runner-group-in-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** Unique identifier of the self-hosted runner group. */
        runner_group_id: components["parameters"]["runner-group-id"];
        /** The unique identifier of the repository. */
        repository_id: components["parameters"]["repository-id"];
      };
    };
    responses: {
      /** Response */
      204: never;
    };
  };
  /**
   * Lists self-hosted runners that are in a specific organization group.
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
   */
  "actions/list-self-hosted-runners-in-group-for-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** Unique identifier of the self-hosted runner group. */
        runner_group_id: components["parameters"]["runner-group-id"];
      };
      query: {
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /** Response */
      200: {
        headers: {};
        content: {
          "application/json": {
            total_count: number;
            runners: components["schemas"]["runner"][];
          };
        };
      };
    };
  };
  /**
   * Replaces the list of self-hosted runners that are part of an organization runner group.
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
   */
  "actions/set-self-hosted-runners-in-group-for-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** Unique identifier of the self-hosted runner group. */
        runner_group_id: components["parameters"]["runner-group-id"];
      };
    };
    responses: {
      /** Response */
      204: never;
    };
    requestBody: {
      content: {
        "application/json": {
          /** @description List of runner IDs to add to the runner group. */
          runners: number[];
        };
      };
    };
  };
  /**
   * Adds a self-hosted runner to a runner group configured in an organization.
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
   */
  "actions/add-self-hosted-runner-to-group-for-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** Unique identifier of the self-hosted runner group. */
        runner_group_id: components["parameters"]["runner-group-id"];
        /** Unique identifier of the self-hosted runner. */
        runner_id: components["parameters"]["runner-id"];
      };
    };
    responses: {
      /** Response */
      204: never;
    };
  };
  /**
   * Removes a self-hosted runner from a group configured in an organization. The runner is then returned to the default group.
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
   */
  "actions/remove-self-hosted-runner-from-group-for-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** Unique identifier of the self-hosted runner group. */
        runner_group_id: components["parameters"]["runner-group-id"];
        /** Unique identifier of the self-hosted runner. */
        runner_id: components["parameters"]["runner-id"];
      };
    };
    responses: {
      /** Response */
      204: never;
    };
  };
  /**
   * Lists all self-hosted runners configured in an organization.
   *
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
   */
  "actions/list-self-hosted-runners-for-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
      query: {
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /** Response */
      200: {
        headers: {};
        content: {
          "application/json": {
            total_count: number;
            runners: components["schemas"]["runner"][];
          };
        };
      };
    };
  };
  /**
   * Lists binaries for the runner application that you can download and run.
   *
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
   */
  "actions/list-runner-applications-for-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["runner-application"][];
        };
      };
    };
  };
  /**
   * Returns a token that you can pass to the `config` script. The token expires after one hour.
   *
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
   *
   * #### Example using registration token
   *
   * Configure your self-hosted runner, replacing `TOKEN` with the registration token provided by this endpoint.
   *
   * ```
   * ./config.sh --url https://github.com/octo-org --token TOKEN
   * ```
   */
  "actions/create-registration-token-for-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
    };
    responses: {
      /** Response */
      201: {
        content: {
          "application/json": components["schemas"]["authentication-token"];
        };
      };
    };
  };
  /**
   * Returns a token that you can pass to the `config` script to remove a self-hosted runner from an organization. The token expires after one hour.
   *
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
   *
   * #### Example using remove token
   *
   * To remove your self-hosted runner from an organization, replace `TOKEN` with the remove token provided by this
   * endpoint.
   *
   * ```
   * ./config.sh remove --token TOKEN
   * ```
   */
  "actions/create-remove-token-for-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
    };
    responses: {
      /** Response */
      201: {
        content: {
          "application/json": components["schemas"]["authentication-token"];
        };
      };
    };
  };
  /**
   * Gets a specific self-hosted runner configured in an organization.
   *
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
   */
  "actions/get-self-hosted-runner-for-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** Unique identifier of the self-hosted runner. */
        runner_id: components["parameters"]["runner-id"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["runner"];
        };
      };
    };
  };
  /**
   * Forces the removal of a self-hosted runner from an organization. You can use this endpoint to completely remove the runner when the machine you were using no longer exists.
   *
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
   */
  "actions/delete-self-hosted-runner-from-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** Unique identifier of the self-hosted runner. */
        runner_id: components["parameters"]["runner-id"];
      };
    };
    responses: {
      /** Response */
      204: never;
    };
  };
  /** Lists all secrets available in an organization without revealing their encrypted values. You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `secrets` organization permission to use this endpoint. */
  "actions/list-org-secrets": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
      query: {
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /** Response */
      200: {
        headers: {};
        content: {
          "application/json": {
            total_count: number;
            secrets: components["schemas"]["organization-actions-secret"][];
          };
        };
      };
    };
  };
  /** Gets your public key, which you need to encrypt secrets. You need to encrypt a secret before you can create or update secrets. You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `secrets` organization permission to use this endpoint. */
  "actions/get-org-public-key": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["actions-public-key"];
        };
      };
    };
  };
  /** Gets a single organization secret without revealing its encrypted value. You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `secrets` organization permission to use this endpoint. */
  "actions/get-org-secret": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The name of the secret. */
        secret_name: components["parameters"]["secret-name"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["organization-actions-secret"];
        };
      };
    };
  };
  /**
   * Creates or updates an organization secret with an encrypted value. Encrypt your secret using
   * [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages). You must authenticate using an access
   * token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `secrets` organization permission to
   * use this endpoint.
   *
   * #### Example encrypting a secret using Node.js
   *
   * Encrypt your secret using the [tweetsodium](https://github.com/github/tweetsodium) library.
   *
   * ```
   * const sodium = require('tweetsodium');
   *
   * const key = "base64-encoded-public-key";
   * const value = "plain-text-secret";
   *
   * // Convert the message and key to Uint8Array's (Buffer implements that interface)
   * const messageBytes = Buffer.from(value);
   * const keyBytes = Buffer.from(key, 'base64');
   *
   * // Encrypt using LibSodium.
   * const encryptedBytes = sodium.seal(messageBytes, keyBytes);
   *
   * // Base64 the encrypted secret
   * const encrypted = Buffer.from(encryptedBytes).toString('base64');
   *
   * console.log(encrypted);
   * ```
   *
   *
   * #### Example encrypting a secret using Python
   *
   * Encrypt your secret using [pynacl](https://pynacl.readthedocs.io/en/latest/public/#nacl-public-sealedbox) with Python 3.
   *
   * ```
   * from base64 import b64encode
   * from nacl import encoding, public
   *
   * def encrypt(public_key: str, secret_value: str) -> str:
   *   """Encrypt a Unicode string using the public key."""
   *   public_key = public.PublicKey(public_key.encode("utf-8"), encoding.Base64Encoder())
   *   sealed_box = public.SealedBox(public_key)
   *   encrypted = sealed_box.encrypt(secret_value.encode("utf-8"))
   *   return b64encode(encrypted).decode("utf-8")
   * ```
   *
   * #### Example encrypting a secret using C#
   *
   * Encrypt your secret using the [Sodium.Core](https://www.nuget.org/packages/Sodium.Core/) package.
   *
   * ```
   * var secretValue = System.Text.Encoding.UTF8.GetBytes("mySecret");
   * var publicKey = Convert.FromBase64String("2Sg8iYjAxxmI2LvUXpJjkYrMxURPc8r+dB7TJyvvcCU=");
   *
   * var sealedPublicKeyBox = Sodium.SealedPublicKeyBox.Create(secretValue, publicKey);
   *
   * Console.WriteLine(Convert.ToBase64String(sealedPublicKeyBox));
   * ```
   *
   * #### Example encrypting a secret using Ruby
   *
   * Encrypt your secret using the [rbnacl](https://github.com/RubyCrypto/rbnacl) gem.
   *
   * ```ruby
   * require "rbnacl"
   * require "base64"
   *
   * key = Base64.decode64("+ZYvJDZMHUfBkJdyq5Zm9SKqeuBQ4sj+6sfjlH4CgG0=")
   * public_key = RbNaCl::PublicKey.new(key)
   *
   * box = RbNaCl::Boxes::Sealed.from_public_key(public_key)
   * encrypted_secret = box.encrypt("my_secret")
   *
   * # Print the base64 encoded secret
   * puts Base64.strict_encode64(encrypted_secret)
   * ```
   */
  "actions/create-or-update-org-secret": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The name of the secret. */
        secret_name: components["parameters"]["secret-name"];
      };
    };
    responses: {
      /** Response when creating a secret */
      201: {
        content: {
          "application/json": components["schemas"]["empty-object"];
        };
      };
      /** Response when updating a secret */
      204: never;
    };
    requestBody: {
      content: {
        "application/json": {
          /** @description Value for your secret, encrypted with [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages) using the public key retrieved from the [Get an organization public key](https://docs.github.com/enterprise-server@3.3/rest/reference/actions#get-an-organization-public-key) endpoint. */
          encrypted_value?: string;
          /** @description ID of the key you used to encrypt the secret. */
          key_id?: string;
          /**
           * @description Which type of organization repositories have access to the organization secret. `selected` means only the repositories specified by `selected_repository_ids` can access the secret.
           * @enum {string}
           */
          visibility: "all" | "private" | "selected";
          /** @description An array of repository ids that can access the organization secret. You can only provide a list of repository ids when the `visibility` is set to `selected`. You can manage the list of selected repositories using the [List selected repositories for an organization secret](https://docs.github.com/enterprise-server@3.3/rest/reference/actions#list-selected-repositories-for-an-organization-secret), [Set selected repositories for an organization secret](https://docs.github.com/enterprise-server@3.3/rest/reference/actions#set-selected-repositories-for-an-organization-secret), and [Remove selected repository from an organization secret](https://docs.github.com/enterprise-server@3.3/rest/reference/actions#remove-selected-repository-from-an-organization-secret) endpoints. */
          selected_repository_ids?: number[];
        };
      };
    };
  };
  /** Deletes a secret in an organization using the secret name. You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `secrets` organization permission to use this endpoint. */
  "actions/delete-org-secret": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The name of the secret. */
        secret_name: components["parameters"]["secret-name"];
      };
    };
    responses: {
      /** Response */
      204: never;
    };
  };
  /** Lists all repositories that have been selected when the `visibility` for repository access to a secret is set to `selected`. You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `secrets` organization permission to use this endpoint. */
  "actions/list-selected-repos-for-org-secret": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The name of the secret. */
        secret_name: components["parameters"]["secret-name"];
      };
      query: {
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": {
            total_count: number;
            repositories: components["schemas"]["minimal-repository"][];
          };
        };
      };
    };
  };
  /** Replaces all repositories for an organization secret when the `visibility` for repository access is set to `selected`. The visibility is set when you [Create or update an organization secret](https://docs.github.com/enterprise-server@3.3/rest/reference/actions#create-or-update-an-organization-secret). You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `secrets` organization permission to use this endpoint. */
  "actions/set-selected-repos-for-org-secret": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The name of the secret. */
        secret_name: components["parameters"]["secret-name"];
      };
    };
    responses: {
      /** Response */
      204: never;
    };
    requestBody: {
      content: {
        "application/json": {
          /** @description An array of repository ids that can access the organization secret. You can only provide a list of repository ids when the `visibility` is set to `selected`. You can add and remove individual repositories using the [Set selected repositories for an organization secret](https://docs.github.com/enterprise-server@3.3/rest/reference/actions#set-selected-repositories-for-an-organization-secret) and [Remove selected repository from an organization secret](https://docs.github.com/enterprise-server@3.3/rest/reference/actions#remove-selected-repository-from-an-organization-secret) endpoints. */
          selected_repository_ids: number[];
        };
      };
    };
  };
  /** Adds a repository to an organization secret when the `visibility` for repository access is set to `selected`. The visibility is set when you [Create or update an organization secret](https://docs.github.com/enterprise-server@3.3/rest/reference/actions#create-or-update-an-organization-secret). You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `secrets` organization permission to use this endpoint. */
  "actions/add-selected-repo-to-org-secret": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The name of the secret. */
        secret_name: components["parameters"]["secret-name"];
        repository_id: number;
      };
    };
    responses: {
      /** No Content when repository was added to the selected list */
      204: never;
      /** Conflict when visibility type is not set to selected */
      409: unknown;
    };
  };
  /** Removes a repository from an organization secret when the `visibility` for repository access is set to `selected`. The visibility is set when you [Create or update an organization secret](https://docs.github.com/enterprise-server@3.3/rest/reference/actions#create-or-update-an-organization-secret). You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `secrets` organization permission to use this endpoint. */
  "actions/remove-selected-repo-from-org-secret": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The name of the secret. */
        secret_name: components["parameters"]["secret-name"];
        repository_id: number;
      };
    };
    responses: {
      /** Response when repository was removed from the selected list */
      204: never;
      /** Conflict when visibility type not set to selected */
      409: unknown;
    };
  };
  /**
   * Gets the audit log for an organization. For more information, see "[Reviewing the audit log for your organization](https://docs.github.com/enterprise-server@3.3/github/setting-up-and-managing-organizations-and-teams/reviewing-the-audit-log-for-your-organization)."
   *
   * To use this endpoint, you must be an organization owner, and you must use an access token with the `admin:org` scope. GitHub Apps must have the `organization_administration` read permission to use this endpoint.
   *
   * By default, the response includes up to 30 events from the past three months. Use the `phrase` parameter to filter results and retrieve older events. For example, use the `phrase` parameter with the `created` qualifier to filter events based on when the events occurred. For more information, see "[Reviewing the audit log for your organization](https://docs.github.com/enterprise-server@3.3/organizations/keeping-your-organization-secure/managing-security-settings-for-your-organization/reviewing-the-audit-log-for-your-organization#searching-the-audit-log)."
   *
   * Use pagination to retrieve fewer or more than 30 events. For more information, see "[Resources in the REST API](https://docs.github.com/enterprise-server@3.3/rest/overview/resources-in-the-rest-api#pagination)."
   */
  "orgs/get-audit-log": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
      query: {
        /** A search phrase. For more information, see [Searching the audit log](https://docs.github.com/enterprise-server@3.3/github/setting-up-and-managing-organizations-and-teams/reviewing-the-audit-log-for-your-organization#searching-the-audit-log). */
        phrase?: components["parameters"]["audit-log-phrase"];
        /** A cursor, as given in the [Link header](https://docs.github.com/enterprise-server@3.3/rest/overview/resources-in-the-rest-api#link-header). If specified, the query only searches for events after this cursor. */
        after?: components["parameters"]["audit-log-after"];
        /** A cursor, as given in the [Link header](https://docs.github.com/enterprise-server@3.3/rest/overview/resources-in-the-rest-api#link-header). If specified, the query only searches for events before this cursor. */
        before?: components["parameters"]["audit-log-before"];
        /**
         * The order of audit log events. To list newest events first, specify `desc`. To list oldest events first, specify `asc`.
         *
         * The default is `desc`.
         */
        order?: components["parameters"]["audit-log-order"];
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["audit-log-event"][];
        };
      };
    };
  };
  "activity/list-public-org-events": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
      query: {
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["event"][];
        };
      };
    };
  };
  "orgs/list-webhooks": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
      query: {
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /** Response */
      200: {
        headers: {};
        content: {
          "application/json": components["schemas"]["org-hook"][];
        };
      };
      404: components["responses"]["not_found"];
    };
  };
  /** Here's how you can create a hook that posts payloads in JSON format: */
  "orgs/create-webhook": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
    };
    responses: {
      /** Response */
      201: {
        headers: {
          Location?: string;
        };
        content: {
          "application/json": components["schemas"]["org-hook"];
        };
      };
      404: components["responses"]["not_found"];
      422: components["responses"]["validation_failed"];
    };
    requestBody: {
      content: {
        "application/json": {
          /** @description Must be passed as "web". */
          name: string;
          /** @description Key/value pairs to provide settings for this webhook. [These are defined below](https://docs.github.com/enterprise-server@3.3/rest/reference/orgs#create-hook-config-params). */
          config: {
            url: components["schemas"]["webhook-config-url"];
            content_type?: components["schemas"]["webhook-config-content-type"];
            secret?: components["schemas"]["webhook-config-secret"];
            insecure_ssl?: components["schemas"]["webhook-config-insecure-ssl"];
            /** @example "kdaigle" */
            username?: string;
            /** @example "password" */
            password?: string;
          };
          /**
           * @description Determines what [events](https://docs.github.com/enterprise-server@3.3/webhooks/event-payloads) the hook is triggered for.
           * @default [
           *   "push"
           * ]
           */
          events?: string[];
          /**
           * @description Determines if notifications are sent when the webhook is triggered. Set to `true` to send notifications.
           * @default true
           */
          active?: boolean;
        };
      };
    };
  };
  /** Returns a webhook configured in an organization. To get only the webhook `config` properties, see "[Get a webhook configuration for an organization](/rest/reference/orgs#get-a-webhook-configuration-for-an-organization)." */
  "orgs/get-webhook": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The unique identifier of the hook. */
        hook_id: components["parameters"]["hook-id"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["org-hook"];
        };
      };
      404: components["responses"]["not_found"];
    };
  };
  "orgs/delete-webhook": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The unique identifier of the hook. */
        hook_id: components["parameters"]["hook-id"];
      };
    };
    responses: {
      /** Response */
      204: never;
      404: components["responses"]["not_found"];
    };
  };
  /** Updates a webhook configured in an organization. When you update a webhook, the `secret` will be overwritten. If you previously had a `secret` set, you must provide the same `secret` or set a new `secret` or the secret will be removed. If you are only updating individual webhook `config` properties, use "[Update a webhook configuration for an organization](/rest/reference/orgs#update-a-webhook-configuration-for-an-organization)." */
  "orgs/update-webhook": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The unique identifier of the hook. */
        hook_id: components["parameters"]["hook-id"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["org-hook"];
        };
      };
      404: components["responses"]["not_found"];
      422: components["responses"]["validation_failed"];
    };
    requestBody: {
      content: {
        "application/json": {
          /** @description Key/value pairs to provide settings for this webhook. [These are defined below](https://docs.github.com/enterprise-server@3.3/rest/reference/orgs#update-hook-config-params). */
          config?: {
            url: components["schemas"]["webhook-config-url"];
            content_type?: components["schemas"]["webhook-config-content-type"];
            secret?: components["schemas"]["webhook-config-secret"];
            insecure_ssl?: components["schemas"]["webhook-config-insecure-ssl"];
          };
          /**
           * @description Determines what [events](https://docs.github.com/enterprise-server@3.3/webhooks/event-payloads) the hook is triggered for.
           * @default [
           *   "push"
           * ]
           */
          events?: string[];
          /**
           * @description Determines if notifications are sent when the webhook is triggered. Set to `true` to send notifications.
           * @default true
           */
          active?: boolean;
          /** @example "web" */
          name?: string;
        };
      };
    };
  };
  /**
   * Returns the webhook configuration for an organization. To get more information about the webhook, including the `active` state and `events`, use "[Get an organization webhook ](/rest/reference/orgs#get-an-organization-webhook)."
   *
   * Access tokens must have the `admin:org_hook` scope, and GitHub Apps must have the `organization_hooks:read` permission.
   */
  "orgs/get-webhook-config-for-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The unique identifier of the hook. */
        hook_id: components["parameters"]["hook-id"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["webhook-config"];
        };
      };
    };
  };
  /**
   * Updates the webhook configuration for an organization. To update more information about the webhook, including the `active` state and `events`, use "[Update an organization webhook ](/rest/reference/orgs#update-an-organization-webhook)."
   *
   * Access tokens must have the `admin:org_hook` scope, and GitHub Apps must have the `organization_hooks:write` permission.
   */
  "orgs/update-webhook-config-for-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The unique identifier of the hook. */
        hook_id: components["parameters"]["hook-id"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["webhook-config"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": {
          url?: components["schemas"]["webhook-config-url"];
          content_type?: components["schemas"]["webhook-config-content-type"];
          secret?: components["schemas"]["webhook-config-secret"];
          insecure_ssl?: components["schemas"]["webhook-config-insecure-ssl"];
        };
      };
    };
  };
  /** Returns a list of webhook deliveries for a webhook configured in an organization. */
  "orgs/list-webhook-deliveries": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The unique identifier of the hook. */
        hook_id: components["parameters"]["hook-id"];
      };
      query: {
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Used for pagination: the starting delivery from which the page of deliveries is fetched. Refer to the `link` header for the next and previous page cursors. */
        cursor?: components["parameters"]["cursor"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["hook-delivery-item"][];
        };
      };
      400: components["responses"]["bad_request"];
      422: components["responses"]["validation_failed"];
    };
  };
  /** Returns a delivery for a webhook configured in an organization. */
  "orgs/get-webhook-delivery": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The unique identifier of the hook. */
        hook_id: components["parameters"]["hook-id"];
        delivery_id: components["parameters"]["delivery-id"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["hook-delivery"];
        };
      };
      400: components["responses"]["bad_request"];
      422: components["responses"]["validation_failed"];
    };
  };
  /** Redeliver a delivery for a webhook configured in an organization. */
  "orgs/redeliver-webhook-delivery": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The unique identifier of the hook. */
        hook_id: components["parameters"]["hook-id"];
        delivery_id: components["parameters"]["delivery-id"];
      };
    };
    responses: {
      202: components["responses"]["accepted"];
      400: components["responses"]["bad_request"];
      422: components["responses"]["validation_failed"];
    };
  };
  /** This will trigger a [ping event](https://docs.github.com/enterprise-server@3.3/webhooks/#ping-event) to be sent to the hook. */
  "orgs/ping-webhook": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The unique identifier of the hook. */
        hook_id: components["parameters"]["hook-id"];
      };
    };
    responses: {
      /** Response */
      204: never;
      404: components["responses"]["not_found"];
    };
  };
  /**
   * Enables an authenticated GitHub App to find the organization's installation information.
   *
   * You must use a [JWT](https://docs.github.com/enterprise-server@3.3/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
   */
  "apps/get-org-installation": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["installation"];
        };
      };
    };
  };
  /** Lists all GitHub Apps in an organization. The installation count includes all GitHub Apps installed on repositories in the organization. You must be an organization owner with `admin:read` scope to use this endpoint. */
  "orgs/list-app-installations": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
      query: {
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /** Response */
      200: {
        headers: {};
        content: {
          "application/json": {
            total_count: number;
            installations: components["schemas"]["installation"][];
          };
        };
      };
    };
  };
  /**
   * List issues in an organization assigned to the authenticated user.
   *
   * **Note**: GitHub's REST API v3 considers every pull request an issue, but not every issue is a pull request. For this
   * reason, "Issues" endpoints may return both issues and pull requests in the response. You can identify pull requests by
   * the `pull_request` key. Be aware that the `id` of a pull request returned from "Issues" endpoints will be an _issue id_. To find out the pull
   * request id, use the "[List pull requests](https://docs.github.com/enterprise-server@3.3/rest/reference/pulls#list-pull-requests)" endpoint.
   */
  "issues/list-for-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
      query: {
        /** Indicates which sorts of issues to return. `assigned` means issues assigned to you. `created` means issues created by you. `mentioned` means issues mentioning you. `subscribed` means issues you're subscribed to updates for. `all` or `repos` means all issues you can see, regardless of participation or creation. */
        filter?:
          | "assigned"
          | "created"
          | "mentioned"
          | "subscribed"
          | "repos"
          | "all";
        /** Indicates the state of the issues to return. */
        state?: "open" | "closed" | "all";
        /** A list of comma separated label names. Example: `bug,ui,@high` */
        labels?: components["parameters"]["labels"];
        /** What to sort results by. */
        sort?: "created" | "updated" | "comments";
        /** The direction to sort the results by. */
        direction?: components["parameters"]["direction"];
        /** Only show notifications updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`. */
        since?: components["parameters"]["since"];
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /** Response */
      200: {
        headers: {};
        content: {
          "application/json": components["schemas"]["issue"][];
        };
      };
      404: components["responses"]["not_found"];
    };
  };
  /** List all users who are members of an organization. If the authenticated user is also a member of this organization then both concealed and public members will be returned. */
  "orgs/list-members": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
      query: {
        /** Filter members returned in the list. `2fa_disabled` means that only members without [two-factor authentication](https://github.com/blog/1614-two-factor-authentication) enabled will be returned. This options is only available for organization owners. */
        filter?: "2fa_disabled" | "all";
        /** Filter members returned by their role. */
        role?: "all" | "admin" | "member";
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /** Response */
      200: {
        headers: {};
        content: {
          "application/json": components["schemas"]["simple-user"][];
        };
      };
      422: components["responses"]["validation_failed"];
    };
  };
  /** Check if a user is, publicly or privately, a member of the organization. */
  "orgs/check-membership-for-user": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The handle for the GitHub user account. */
        username: components["parameters"]["username"];
      };
    };
    responses: {
      /** Response if requester is an organization member and user is a member */
      204: never;
      /** Response if requester is not an organization member */
      302: never;
      /** Not Found if requester is an organization member and user is not a member */
      404: unknown;
    };
  };
  /** Removing a user from this list will remove them from all teams and they will no longer have any access to the organization's repositories. */
  "orgs/remove-member": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The handle for the GitHub user account. */
        username: components["parameters"]["username"];
      };
    };
    responses: {
      /** Response */
      204: never;
      403: components["responses"]["forbidden"];
    };
  };
  /** In order to get a user's membership with an organization, the authenticated user must be an organization member. The `state` parameter in the response can be used to identify the user's membership status. */
  "orgs/get-membership-for-user": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The handle for the GitHub user account. */
        username: components["parameters"]["username"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["org-membership"];
        };
      };
      403: components["responses"]["forbidden"];
      404: components["responses"]["not_found"];
    };
  };
  /**
   * Only authenticated organization owners can add a member to the organization or update the member's role.
   *
   * *   If the authenticated user is _adding_ a member to the organization, the invited user will receive an email inviting them to the organization. The user's [membership status](https://docs.github.com/enterprise-server@3.3/rest/reference/orgs#get-organization-membership-for-a-user) will be `pending` until they accept the invitation.
   *
   * *   Authenticated users can _update_ a user's membership by passing the `role` parameter. If the authenticated user changes a member's role to `admin`, the affected user will receive an email notifying them that they've been made an organization owner. If the authenticated user changes an owner's role to `member`, no email will be sent.
   *
   * **Rate limits**
   *
   * To prevent abuse, the authenticated user is limited to 50 organization invitations per 24 hour period. If the organization is more than one month old or on a paid plan, the limit is 500 invitations per 24 hour period.
   */
  "orgs/set-membership-for-user": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The handle for the GitHub user account. */
        username: components["parameters"]["username"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["org-membership"];
        };
      };
      403: components["responses"]["forbidden"];
      422: components["responses"]["validation_failed"];
    };
    requestBody: {
      content: {
        "application/json": {
          /**
           * @description The role to give the user in the organization. Can be one of:
           * \* `admin` - The user will become an owner of the organization.
           * \* `member` - The user will become a non-owner member of the organization.
           * @default member
           * @enum {string}
           */
          role?: "admin" | "member";
        };
      };
    };
  };
  /**
   * In order to remove a user's membership with an organization, the authenticated user must be an organization owner.
   *
   * If the specified user is an active member of the organization, this will remove them from the organization. If the specified user has been invited to the organization, this will cancel their invitation. The specified user will receive an email notification in both cases.
   */
  "orgs/remove-membership-for-user": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The handle for the GitHub user account. */
        username: components["parameters"]["username"];
      };
    };
    responses: {
      /** Response */
      204: never;
      403: components["responses"]["forbidden"];
      404: components["responses"]["not_found"];
    };
  };
  /** List all users who are outside collaborators of an organization. */
  "orgs/list-outside-collaborators": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
      query: {
        /** Filter the list of outside collaborators. `2fa_disabled` means that only outside collaborators without [two-factor authentication](https://github.com/blog/1614-two-factor-authentication) enabled will be returned. */
        filter?: "2fa_disabled" | "all";
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /** Response */
      200: {
        headers: {};
        content: {
          "application/json": components["schemas"]["simple-user"][];
        };
      };
    };
  };
  /** When an organization member is converted to an outside collaborator, they'll only have access to the repositories that their current team membership allows. The user will no longer be a member of the organization. For more information, see "[Converting an organization member to an outside collaborator](https://docs.github.com/enterprise-server@3.3/articles/converting-an-organization-member-to-an-outside-collaborator/)". */
  "orgs/convert-member-to-outside-collaborator": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The handle for the GitHub user account. */
        username: components["parameters"]["username"];
      };
    };
    responses: {
      /** User is getting converted asynchronously */
      202: {
        content: {
          "application/json": { [key: string]: unknown };
        };
      };
      /** User was converted */
      204: never;
      /** Forbidden if user is the last owner of the organization or not a member of the organization. */
      403: unknown;
      404: components["responses"]["not_found"];
    };
    requestBody: {
      content: {
        "application/json": {
          /**
           * @description When set to `true`, the request will be performed asynchronously. Returns a 202 status code when the job is successfully queued.
           * @default false
           */
          async?: boolean;
        };
      };
    };
  };
  /** Removing a user from this list will remove them from all the organization's repositories. */
  "orgs/remove-outside-collaborator": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The handle for the GitHub user account. */
        username: components["parameters"]["username"];
      };
    };
    responses: {
      /** Response */
      204: never;
      /** Unprocessable Entity if user is a member of the organization */
      422: {
        content: {
          "application/json": {
            message?: string;
            documentation_url?: string;
          };
        };
      };
    };
  };
  /** List all pre-receive hooks that are enabled or testing for this organization as well as any disabled hooks that can be configured at the organization level. Globally disabled pre-receive hooks that do not allow downstream configuration are not listed. */
  "enterprise-admin/list-pre-receive-hooks-for-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
      query: {
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
        /** The direction to sort the results by. */
        direction?: components["parameters"]["direction"];
        /** The sort order for the response collection. */
        sort?: "created" | "updated" | "name";
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["org-pre-receive-hook"][];
        };
      };
    };
  };
  "enterprise-admin/get-pre-receive-hook-for-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The unique identifier of the pre-receive hook. */
        pre_receive_hook_id: components["parameters"]["pre-receive-hook-id"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["org-pre-receive-hook"];
        };
      };
    };
  };
  /** Removes any overrides for this hook at the org level for this org. */
  "enterprise-admin/remove-pre-receive-hook-enforcement-for-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The unique identifier of the pre-receive hook. */
        pre_receive_hook_id: components["parameters"]["pre-receive-hook-id"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["org-pre-receive-hook"];
        };
      };
    };
  };
  /** For pre-receive hooks which are allowed to be configured at the org level, you can set `enforcement` and `allow_downstream_configuration` */
  "enterprise-admin/update-pre-receive-hook-enforcement-for-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The unique identifier of the pre-receive hook. */
        pre_receive_hook_id: components["parameters"]["pre-receive-hook-id"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["org-pre-receive-hook"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": {
          /** @description The state of enforcement for the hook on this repository. */
          enforcement?: string;
          /** @description Whether repositories can override enforcement. */
          allow_downstream_configuration?: boolean;
        };
      };
    };
  };
  /** Lists the projects in an organization. Returns a `404 Not Found` status if projects are disabled in the organization. If you do not have sufficient privileges to perform this action, a `401 Unauthorized` or `410 Gone` status is returned. */
  "projects/list-for-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
      query: {
        /** Indicates the state of the projects to return. */
        state?: "open" | "closed" | "all";
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /** Response */
      200: {
        headers: {};
        content: {
          "application/json": components["schemas"]["project"][];
        };
      };
      422: components["responses"]["validation_failed_simple"];
    };
  };
  /** Creates an organization project board. Returns a `410 Gone` status if projects are disabled in the organization or if the organization does not have existing classic projects. If you do not have sufficient privileges to perform this action, a `401 Unauthorized` or `410 Gone` status is returned. */
  "projects/create-for-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
    };
    responses: {
      /** Response */
      201: {
        content: {
          "application/json": components["schemas"]["project"];
        };
      };
      401: components["responses"]["requires_authentication"];
      403: components["responses"]["forbidden"];
      404: components["responses"]["not_found"];
      410: components["responses"]["gone"];
      422: components["responses"]["validation_failed_simple"];
    };
    requestBody: {
      content: {
        "application/json": {
          /** @description The name of the project. */
          name: string;
          /** @description The description of the project. */
          body?: string;
        };
      };
    };
  };
  /** Members of an organization can choose to have their membership publicized or not. */
  "orgs/list-public-members": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
      query: {
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /** Response */
      200: {
        headers: {};
        content: {
          "application/json": components["schemas"]["simple-user"][];
        };
      };
    };
  };
  "orgs/check-public-membership-for-user": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The handle for the GitHub user account. */
        username: components["parameters"]["username"];
      };
    };
    responses: {
      /** Response if user is a public member */
      204: never;
      /** Not Found if user is not a public member */
      404: unknown;
    };
  };
  /**
   * The user can publicize their own membership. (A user cannot publicize the membership for another user.)
   *
   * Note that you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://docs.github.com/enterprise-server@3.3/rest/overview/resources-in-the-rest-api#http-verbs)."
   */
  "orgs/set-public-membership-for-authenticated-user": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The handle for the GitHub user account. */
        username: components["parameters"]["username"];
      };
    };
    responses: {
      /** Response */
      204: never;
      403: components["responses"]["forbidden"];
    };
  };
  "orgs/remove-public-membership-for-authenticated-user": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The handle for the GitHub user account. */
        username: components["parameters"]["username"];
      };
    };
    responses: {
      /** Response */
      204: never;
    };
  };
  /** Lists repositories for the specified organization. */
  "repos/list-for-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
      query: {
        /** Specifies the types of repositories you want returned. If your organization is associated with an enterprise account using GitHub Enterprise Cloud or GitHub Enterprise Server 2.20+, `type` can also be `internal`. However, the `internal` value is not yet supported when a GitHub App calls this API with an installation access token. */
        type?:
          | "all"
          | "public"
          | "private"
          | "forks"
          | "sources"
          | "member"
          | "internal";
        /** The property to sort the results by. */
        sort?: "created" | "updated" | "pushed" | "full_name";
        /** The order to sort by. Default: `asc` when using `full_name`, otherwise `desc`. */
        direction?: "asc" | "desc";
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /** Response */
      200: {
        headers: {};
        content: {
          "application/json": components["schemas"]["minimal-repository"][];
        };
      };
    };
  };
  /**
   * Creates a new repository in the specified organization. The authenticated user must be a member of the organization.
   *
   * **OAuth scope requirements**
   *
   * When using [OAuth](https://docs.github.com/enterprise-server@3.3/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/), authorizations must include:
   *
   * *   `public_repo` scope or `repo` scope to create a public repository. Note: For GitHub AE, use `repo` scope to create an internal repository.
   * *   `repo` scope to create a private repository
   */
  "repos/create-in-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
    };
    responses: {
      /** Response */
      201: {
        headers: {
          Location?: string;
        };
        content: {
          "application/json": components["schemas"]["repository"];
        };
      };
      403: components["responses"]["forbidden"];
      422: components["responses"]["validation_failed"];
    };
    requestBody: {
      content: {
        "application/json": {
          /** @description The name of the repository. */
          name: string;
          /** @description A short description of the repository. */
          description?: string;
          /** @description A URL with more information about the repository. */
          homepage?: string;
          /**
           * @description Whether the repository is private.
           * @default false
           */
          private?: boolean;
          /**
           * @description Can be `public` or `private`. If your organization is associated with an enterprise account using GitHub Enterprise Cloud or GitHub Enterprise Server 2.20+, `visibility` can also be `internal`. Note: For GitHub Enterprise Server and GitHub AE, this endpoint will only list repositories available to all users on the enterprise. For more information, see "[Creating an internal repository](https://docs.github.com/en/github/creating-cloning-and-archiving-repositories/about-repository-visibility#about-internal-repositories)" in the GitHub Help documentation.
           * @enum {string}
           */
          visibility?: "public" | "private" | "internal";
          /**
           * @description Either `true` to enable issues for this repository or `false` to disable them.
           * @default true
           */
          has_issues?: boolean;
          /**
           * @description Either `true` to enable projects for this repository or `false` to disable them. **Note:** If you're creating a repository in an organization that has disabled repository projects, the default is `false`, and if you pass `true`, the API returns an error.
           * @default true
           */
          has_projects?: boolean;
          /**
           * @description Either `true` to enable the wiki for this repository or `false` to disable it.
           * @default true
           */
          has_wiki?: boolean;
          /**
           * @description Either `true` to make this repo available as a template repository or `false` to prevent it.
           * @default false
           */
          is_template?: boolean;
          /** @description The id of the team that will be granted access to this repository. This is only valid when creating a repository in an organization. */
          team_id?: number;
          /**
           * @description Pass `true` to create an initial commit with empty README.
           * @default false
           */
          auto_init?: boolean;
          /** @description Desired language or platform [.gitignore template](https://github.com/github/gitignore) to apply. Use the name of the template without the extension. For example, "Haskell". */
          gitignore_template?: string;
          /** @description Choose an [open source license template](https://choosealicense.com/) that best suits your needs, and then use the [license keyword](https://docs.github.com/articles/licensing-a-repository/#searching-github-by-license-type) as the `license_template` string. For example, "mit" or "mpl-2.0". */
          license_template?: string;
          /**
           * @description Either `true` to allow squash-merging pull requests, or `false` to prevent squash-merging.
           * @default true
           */
          allow_squash_merge?: boolean;
          /**
           * @description Either `true` to allow merging pull requests with a merge commit, or `false` to prevent merging pull requests with merge commits.
           * @default true
           */
          allow_merge_commit?: boolean;
          /**
           * @description Either `true` to allow rebase-merging pull requests, or `false` to prevent rebase-merging.
           * @default true
           */
          allow_rebase_merge?: boolean;
          /**
           * @description Either `true` to allow auto-merge on pull requests, or `false` to disallow auto-merge.
           * @default false
           */
          allow_auto_merge?: boolean;
          /**
           * @description Either `true` to allow automatically deleting head branches when pull requests are merged, or `false` to prevent automatic deletion.
           * @default false
           */
          delete_branch_on_merge?: boolean;
          /**
           * @deprecated
           * @description Either `true` to allow squash-merge commits to use pull request title, or `false` to use commit message. **This property has been deprecated. Please use `squash_merge_commit_title` instead.
           * @default false
           */
          use_squash_pr_title_as_default?: boolean;
          /**
           * @description The default value for a squash merge commit title:
           *
           * - `PR_TITLE` - default to the pull request's title.
           * - `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).
           * @enum {string}
           */
          squash_merge_commit_title?: "PR_TITLE" | "COMMIT_OR_PR_TITLE";
          /**
           * @description The default value for a squash merge commit message:
           *
           * - `PR_BODY` - default to the pull request's body.
           * - `COMMIT_MESSAGES` - default to the branch's commit messages.
           * - `BLANK` - default to a blank commit message.
           * @enum {string}
           */
          squash_merge_commit_message?: "PR_BODY" | "COMMIT_MESSAGES" | "BLANK";
          /**
           * @description The default value for a merge commit title.
           *
           * - `PR_TITLE` - default to the pull request's title.
           * - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).
           * @enum {string}
           */
          merge_commit_title?: "PR_TITLE" | "MERGE_MESSAGE";
          /**
           * @description The default value for a merge commit message.
           *
           * - `PR_TITLE` - default to the pull request's title.
           * - `PR_BODY` - default to the pull request's body.
           * - `BLANK` - default to a blank commit message.
           * @enum {string}
           */
          merge_commit_message?: "PR_BODY" | "PR_TITLE" | "BLANK";
        };
      };
    };
  };
  /**
   * Lists secret scanning alerts for eligible repositories in an organization, from newest to oldest.
   * To use this endpoint, you must be an administrator or security manager for the organization, and you must use an access token with the `repo` scope or `security_events` scope.
   *
   * GitHub Apps must have the `secret_scanning_alerts` read permission to use this endpoint.
   */
  "secret-scanning/list-alerts-for-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
      query: {
        /** Set to `open` or `resolved` to only list secret scanning alerts in a specific state. */
        state?: components["parameters"]["secret-scanning-alert-state"];
        /**
         * A comma-separated list of secret types to return. By default all secret types are returned.
         * See "[Secret scanning patterns](https://docs.github.com/enterprise-server@3.3/code-security/secret-scanning/secret-scanning-patterns#supported-secrets-for-advanced-security)"
         * for a complete list of secret types.
         */
        secret_type?: components["parameters"]["secret-scanning-alert-secret-type"];
        /** A comma-separated list of resolutions. Only secret scanning alerts with one of these resolutions are listed. Valid resolutions are `false_positive`, `wont_fix`, `revoked`, `pattern_edited`, `pattern_deleted` or `used_in_tests`. */
        resolution?: components["parameters"]["secret-scanning-alert-resolution"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
      };
    };
    responses: {
      /** Response */
      200: {
        headers: {};
        content: {
          "application/json": components["schemas"]["organization-secret-scanning-alert"][];
        };
      };
      404: components["responses"]["not_found"];
      503: components["responses"]["service_unavailable"];
    };
  };
  /** Lists all teams in an organization that are visible to the authenticated user. */
  "teams/list": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
      query: {
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /** Response */
      200: {
        headers: {};
        content: {
          "application/json": components["schemas"]["team"][];
        };
      };
      403: components["responses"]["forbidden"];
    };
  };
  /**
   * To create a team, the authenticated user must be a member or owner of `{org}`. By default, organization members can create teams. Organization owners can limit team creation to organization owners. For more information, see "[Setting team creation permissions](https://docs.github.com/en/articles/setting-team-creation-permissions-in-your-organization)."
   *
   * When you create a new team, you automatically become a team maintainer without explicitly adding yourself to the optional array of `maintainers`. For more information, see "[About teams](https://docs.github.com/en/github/setting-up-and-managing-organizations-and-teams/about-teams)".
   */
  "teams/create": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
    };
    responses: {
      /** Response */
      201: {
        content: {
          "application/json": components["schemas"]["team-full"];
        };
      };
      403: components["responses"]["forbidden"];
      422: components["responses"]["validation_failed"];
    };
    requestBody: {
      content: {
        "application/json": {
          /** @description The name of the team. */
          name: string;
          /** @description The description of the team. */
          description?: string;
          /** @description List GitHub IDs for organization members who will become team maintainers. */
          maintainers?: string[];
          /** @description The full name (e.g., "organization-name/repository-name") of repositories to add the team to. */
          repo_names?: string[];
          /**
           * @description The level of privacy this team should have. The options are:
           * **For a non-nested team:**
           * \* `secret` - only visible to organization owners and members of this team.
           * \* `closed` - visible to all members of this organization.
           * Default: `secret`
           * **For a parent or child team:**
           * \* `closed` - visible to all members of this organization.
           * Default for child team: `closed`
           * @enum {string}
           */
          privacy?: "secret" | "closed";
          /**
           * @description **Deprecated**. The permission that new repositories will be added to the team with when none is specified.
           * @default pull
           * @enum {string}
           */
          permission?: "pull" | "push";
          /** @description The ID of a team to set as the parent team. */
          parent_team_id?: number;
          /** @description The [distinguished name](https://www.ldap.com/ldap-dns-and-rdns) (DN) of the LDAP entry to map to a team. LDAP synchronization must be enabled to map LDAP entries to a team. Use the "[Update LDAP mapping for a team](https://docs.github.com/enterprise-server@3.3/rest/reference/enterprise-admin#update-ldap-mapping-for-a-team)" endpoint to change the LDAP DN. For more information, see "[Using LDAP](https://docs.github.com/enterprise-server@3.3/admin/identity-and-access-management/authenticating-users-for-your-github-enterprise-server-instance/using-ldap#enabling-ldap-sync)." */
          ldap_dn?: string;
        };
      };
    };
  };
  /**
   * Gets a team using the team's `slug`. GitHub Enterprise Server generates the `slug` from the team `name`.
   *
   * **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}`.
   */
  "teams/get-by-name": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The slug of the team name. */
        team_slug: components["parameters"]["team-slug"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["team-full"];
        };
      };
      404: components["responses"]["not_found"];
    };
  };
  /**
   * To delete a team, the authenticated user must be an organization owner or team maintainer.
   *
   * If you are an organization owner, deleting a parent team will delete all of its child teams as well.
   *
   * **Note:** You can also specify a team by `org_id` and `team_id` using the route `DELETE /organizations/{org_id}/team/{team_id}`.
   */
  "teams/delete-in-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The slug of the team name. */
        team_slug: components["parameters"]["team-slug"];
      };
    };
    responses: {
      /** Response */
      204: never;
    };
  };
  /**
   * To edit a team, the authenticated user must either be an organization owner or a team maintainer.
   *
   * **Note:** You can also specify a team by `org_id` and `team_id` using the route `PATCH /organizations/{org_id}/team/{team_id}`.
   */
  "teams/update-in-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The slug of the team name. */
        team_slug: components["parameters"]["team-slug"];
      };
    };
    responses: {
      /** Response when the updated information already exists */
      200: {
        content: {
          "application/json": components["schemas"]["team-full"];
        };
      };
      /** Response */
      201: {
        content: {
          "application/json": components["schemas"]["team-full"];
        };
      };
      403: components["responses"]["forbidden"];
      404: components["responses"]["not_found"];
      422: components["responses"]["validation_failed"];
    };
    requestBody: {
      content: {
        "application/json": {
          /** @description The name of the team. */
          name?: string;
          /** @description The description of the team. */
          description?: string;
          /**
           * @description The level of privacy this team should have. Editing teams without specifying this parameter leaves `privacy` intact. When a team is nested, the `privacy` for parent teams cannot be `secret`. The options are:
           * **For a non-nested team:**
           * \* `secret` - only visible to organization owners and members of this team.
           * \* `closed` - visible to all members of this organization.
           * **For a parent or child team:**
           * \* `closed` - visible to all members of this organization.
           * @enum {string}
           */
          privacy?: "secret" | "closed";
          /**
           * @description **Deprecated**. The permission that new repositories will be added to the team with when none is specified.
           * @default pull
           * @enum {string}
           */
          permission?: "pull" | "push" | "admin";
          /** @description The ID of a team to set as the parent team. */
          parent_team_id?: number | null;
        };
      };
    };
  };
  /**
   * List all discussions on a team's page. OAuth access tokens require the `read:discussion` [scope](https://docs.github.com/enterprise-server@3.3/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
   *
   * **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/discussions`.
   */
  "teams/list-discussions-in-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The slug of the team name. */
        team_slug: components["parameters"]["team-slug"];
      };
      query: {
        /** The direction to sort the results by. */
        direction?: components["parameters"]["direction"];
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
        /** Pinned discussions only filter */
        pinned?: string;
      };
    };
    responses: {
      /** Response */
      200: {
        headers: {};
        content: {
          "application/json": components["schemas"]["team-discussion"][];
        };
      };
    };
  };
  /**
   * Creates a new discussion post on a team's page. OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/enterprise-server@3.3/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
   *
   * This endpoint triggers [notifications](https://docs.github.com/en/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. See "[Secondary rate limits](https://docs.github.com/enterprise-server@3.3/rest/overview/resources-in-the-rest-api#secondary-rate-limits)" and "[Dealing with secondary rate limits](https://docs.github.com/enterprise-server@3.3/rest/guides/best-practices-for-integrators#dealing-with-secondary-rate-limits)" for details.
   *
   * **Note:** You can also specify a team by `org_id` and `team_id` using the route `POST /organizations/{org_id}/team/{team_id}/discussions`.
   */
  "teams/create-discussion-in-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The slug of the team name. */
        team_slug: components["parameters"]["team-slug"];
      };
    };
    responses: {
      /** Response */
      201: {
        content: {
          "application/json": components["schemas"]["team-discussion"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": {
          /** @description The discussion post's title. */
          title: string;
          /** @description The discussion post's body text. */
          body: string;
          /**
           * @description Private posts are only visible to team members, organization owners, and team maintainers. Public posts are visible to all members of the organization. Set to `true` to create a private post.
           * @default false
           */
          private?: boolean;
        };
      };
    };
  };
  /**
   * Get a specific discussion on a team's page. OAuth access tokens require the `read:discussion` [scope](https://docs.github.com/enterprise-server@3.3/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
   *
   * **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}`.
   */
  "teams/get-discussion-in-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The slug of the team name. */
        team_slug: components["parameters"]["team-slug"];
        /** The number that identifies the discussion. */
        discussion_number: components["parameters"]["discussion-number"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["team-discussion"];
        };
      };
    };
  };
  /**
   * Delete a discussion from a team's page. OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/enterprise-server@3.3/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
   *
   * **Note:** You can also specify a team by `org_id` and `team_id` using the route `DELETE /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}`.
   */
  "teams/delete-discussion-in-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The slug of the team name. */
        team_slug: components["parameters"]["team-slug"];
        /** The number that identifies the discussion. */
        discussion_number: components["parameters"]["discussion-number"];
      };
    };
    responses: {
      /** Response */
      204: never;
    };
  };
  /**
   * Edits the title and body text of a discussion post. Only the parameters you provide are updated. OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/enterprise-server@3.3/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
   *
   * **Note:** You can also specify a team by `org_id` and `team_id` using the route `PATCH /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}`.
   */
  "teams/update-discussion-in-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The slug of the team name. */
        team_slug: components["parameters"]["team-slug"];
        /** The number that identifies the discussion. */
        discussion_number: components["parameters"]["discussion-number"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["team-discussion"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": {
          /** @description The discussion post's title. */
          title?: string;
          /** @description The discussion post's body text. */
          body?: string;
        };
      };
    };
  };
  /**
   * List all comments on a team discussion. OAuth access tokens require the `read:discussion` [scope](https://docs.github.com/enterprise-server@3.3/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
   *
   * **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}/comments`.
   */
  "teams/list-discussion-comments-in-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The slug of the team name. */
        team_slug: components["parameters"]["team-slug"];
        /** The number that identifies the discussion. */
        discussion_number: components["parameters"]["discussion-number"];
      };
      query: {
        /** The direction to sort the results by. */
        direction?: components["parameters"]["direction"];
        /** The number of results per page (max 100). */
        per_p