/**
 * This file was auto-generated by openapi-typescript.
 * Do not make direct changes to the file.
 */

/** OneOf type helpers */
type Without<T, U> = { [P in Exclude<keyof T, keyof U>]?: never };
type XOR<T, U> = T | U extends object
  ? (Without<T, U> & U) | (Without<U, T> & T)
  : T | U;
type OneOf<T extends any[]> = T extends [infer Only]
  ? Only
  : T extends [infer A, infer B, ...infer Rest]
    ? OneOf<[XOR<A, B>, ...Rest]>
    : never;

export interface paths {
  "/": {
    /**
     * GitHub API Root
     * @description Get Hypermedia links to resources accessible in GitHub's REST API
     */
    get: operations["meta/root"];
  };
  "/admin/hooks": {
    /** List global webhooks */
    get: operations["enterprise-admin/list-global-webhooks"];
    /** Create a global webhook */
    post: operations["enterprise-admin/create-global-webhook"];
  };
  "/admin/hooks/{hook_id}": {
    /** Get a global webhook */
    get: operations["enterprise-admin/get-global-webhook"];
    /** Delete a global webhook */
    delete: operations["enterprise-admin/delete-global-webhook"];
    /**
     * Update a global webhook
     * @description Parameters that are not provided will be overwritten with the default value or removed if no default exists.
     */
    patch: operations["enterprise-admin/update-global-webhook"];
  };
  "/admin/hooks/{hook_id}/pings": {
    /**
     * Ping a global webhook
     * @description This will trigger a [ping event](https://docs.github.com/enterprise-server@3.10/webhooks/#ping-event) to be sent to the webhook.
     */
    post: operations["enterprise-admin/ping-global-webhook"];
  };
  "/admin/keys": {
    /** List public keys */
    get: operations["enterprise-admin/list-public-keys"];
  };
  "/admin/keys/{key_ids}": {
    /** Delete a public key */
    delete: operations["enterprise-admin/delete-public-key"];
  };
  "/admin/ldap/teams/{team_id}/mapping": {
    /**
     * Update LDAP mapping for a team
     * @description Updates the [distinguished name](https://www.ldap.com/ldap-dns-and-rdns) (DN) of the LDAP entry to map to a team. [LDAP synchronization](https://docs.github.com/enterprise-server@3.10/admin/identity-and-access-management/using-ldap-for-enterprise-iam/using-ldap#enabling-ldap-sync) must be enabled to map LDAP entries to a team. Use the [Create a team](https://docs.github.com/enterprise-server@3.10/rest/teams/teams/#create-a-team) endpoint to create a team with LDAP mapping.
     */
    patch: operations["enterprise-admin/update-ldap-mapping-for-team"];
  };
  "/admin/ldap/teams/{team_id}/sync": {
    /**
     * Sync LDAP mapping for a team
     * @description Note that this API call does not automatically initiate an LDAP sync. Rather, if a `201` is returned, the sync job is queued successfully, and is performed when the instance is ready.
     */
    post: operations["enterprise-admin/sync-ldap-mapping-for-team"];
  };
  "/admin/ldap/users/{username}/mapping": {
    /** Update LDAP mapping for a user */
    patch: operations["enterprise-admin/update-ldap-mapping-for-user"];
  };
  "/admin/ldap/users/{username}/sync": {
    /**
     * Sync LDAP mapping for a user
     * @description Note that this API call does not automatically initiate an LDAP sync. Rather, if a `201` is returned, the sync job is queued successfully, and is performed when the instance is ready.
     */
    post: operations["enterprise-admin/sync-ldap-mapping-for-user"];
  };
  "/admin/organizations": {
    /** Create an organization */
    post: operations["enterprise-admin/create-org"];
  };
  "/admin/organizations/{org}": {
    /** Update an organization name */
    patch: operations["enterprise-admin/update-org-name"];
  };
  "/admin/pre-receive-environments": {
    /** List pre-receive environments */
    get: operations["enterprise-admin/list-pre-receive-environments"];
    /** Create a pre-receive environment */
    post: operations["enterprise-admin/create-pre-receive-environment"];
  };
  "/admin/pre-receive-environments/{pre_receive_environment_id}": {
    /** Get a pre-receive environment */
    get: operations["enterprise-admin/get-pre-receive-environment"];
    /**
     * Delete a pre-receive environment
     * @description If you attempt to delete an environment that cannot be deleted, you will receive a `422 Unprocessable Entity` response.
     *
     * The possible error messages are:
     *
     * *   _Cannot modify or delete the default environment_
     * *   _Cannot delete environment that has hooks_
     * *   _Cannot delete environment when download is in progress_
     */
    delete: operations["enterprise-admin/delete-pre-receive-environment"];
    /**
     * Update a pre-receive environment
     * @description You cannot modify the default environment. If you attempt to modify the default environment, you will receive a `422 Unprocessable Entity` response.
     */
    patch: operations["enterprise-admin/update-pre-receive-environment"];
  };
  "/admin/pre-receive-environments/{pre_receive_environment_id}/downloads": {
    /**
     * Start a pre-receive environment download
     * @description Triggers a new download of the environment tarball from the environment's `image_url`. When the download is finished, the newly downloaded tarball will overwrite the existing environment.
     *
     * If a download cannot be triggered, you will receive a `422 Unprocessable Entity` response.
     *
     * The possible error messages are:
     *
     * * _Cannot modify or delete the default environment_
     * * _Can not start a new download when a download is in progress_
     */
    post: operations["enterprise-admin/start-pre-receive-environment-download"];
  };
  "/admin/pre-receive-environments/{pre_receive_environment_id}/downloads/latest": {
    /**
     * Get the download status for a pre-receive environment
     * @description In addition to seeing the download status at the "[Get a pre-receive environment](#get-a-pre-receive-environment)" endpoint, there is also this separate endpoint for just the download status.
     */
    get: operations["enterprise-admin/get-download-status-for-pre-receive-environment"];
  };
  "/admin/pre-receive-hooks": {
    /** List pre-receive hooks */
    get: operations["enterprise-admin/list-pre-receive-hooks"];
    /** Create a pre-receive hook */
    post: operations["enterprise-admin/create-pre-receive-hook"];
  };
  "/admin/pre-receive-hooks/{pre_receive_hook_id}": {
    /** Get a pre-receive hook */
    get: operations["enterprise-admin/get-pre-receive-hook"];
    /** Delete a pre-receive hook */
    delete: operations["enterprise-admin/delete-pre-receive-hook"];
    /** Update a pre-receive hook */
    patch: operations["enterprise-admin/update-pre-receive-hook"];
  };
  "/admin/tokens": {
    /**
     * List personal access tokens
     * @description Lists personal access tokens for all users, including admin users.
     */
    get: operations["enterprise-admin/list-personal-access-tokens"];
  };
  "/admin/tokens/{token_id}": {
    /**
     * Delete a personal access token
     * @description Deletes a personal access token. Returns a `403 - Forbidden` status when a personal access token is in use. For example, if you access this endpoint with the same personal access token that you are trying to delete, you will receive this error.
     */
    delete: operations["enterprise-admin/delete-personal-access-token"];
  };
  "/admin/users": {
    /**
     * Create a user
     * @description If an external authentication mechanism is used, the login name should match the login name in the external system. If you are using LDAP authentication, you should also [update the LDAP mapping](https://docs.github.com/enterprise-server@3.10/rest/enterprise-admin/ldap#update-ldap-mapping-for-a-user) for the user.
     *
     * The login name will be normalized to only contain alphanumeric characters or single hyphens. For example, if you send `"octo_cat"` as the login, a user named `"octo-cat"` will be created.
     *
     * If the login name or email address is already associated with an account, the server will return a `422` response.
     */
    post: operations["enterprise-admin/create-user"];
  };
  "/admin/users/{username}": {
    /**
     * Delete a user
     * @description Deleting a user will delete all their repositories, gists, applications, and personal settings. [Suspending a user](https://docs.github.com/enterprise-server@3.10/rest/enterprise-admin/users#suspend-a-user) is often a better option.
     *
     * You can delete any user account except your own.
     */
    delete: operations["enterprise-admin/delete-user"];
    /** Update the username for a user */
    patch: operations["enterprise-admin/update-username-for-user"];
  };
  "/admin/users/{username}/authorizations": {
    /** Create an impersonation OAuth token */
    post: operations["enterprise-admin/create-impersonation-o-auth-token"];
    /** Delete an impersonation OAuth token */
    delete: operations["enterprise-admin/delete-impersonation-o-auth-token"];
  };
  "/app": {
    /**
     * Get the authenticated app
     * @description Returns the GitHub App associated with the authentication credentials used. To see how many app installations are associated with this GitHub App, see the `installations_count` in the response. For more details about your app's installations, see the "[List installations for the authenticated app](https://docs.github.com/enterprise-server@3.10/rest/apps/apps#list-installations-for-the-authenticated-app)" endpoint.
     *
     * You must use a [JWT](https://docs.github.com/enterprise-server@3.10/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
     */
    get: operations["apps/get-authenticated"];
  };
  "/app-manifests/{code}/conversions": {
    /**
     * Create a GitHub App from a manifest
     * @description Use this endpoint to complete the handshake necessary when implementing the [GitHub App Manifest flow](https://docs.github.com/enterprise-server@3.10/apps/building-github-apps/creating-github-apps-from-a-manifest/). When you create a GitHub App with the manifest flow, you receive a temporary `code` used to retrieve the GitHub App's `id`, `pem` (private key), and `webhook_secret`.
     */
    post: operations["apps/create-from-manifest"];
  };
  "/app/hook/config": {
    /**
     * Get a webhook configuration for an app
     * @description Returns the webhook configuration for a GitHub App. For more information about configuring a webhook for your app, see "[Creating a GitHub App](/developers/apps/creating-a-github-app)."
     *
     * You must use a [JWT](https://docs.github.com/enterprise-server@3.10/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
     */
    get: operations["apps/get-webhook-config-for-app"];
    /**
     * Update a webhook configuration for an app
     * @description Updates the webhook configuration for a GitHub App. For more information about configuring a webhook for your app, see "[Creating a GitHub App](/developers/apps/creating-a-github-app)."
     *
     * You must use a [JWT](https://docs.github.com/enterprise-server@3.10/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
     */
    patch: operations["apps/update-webhook-config-for-app"];
  };
  "/app/hook/deliveries": {
    /**
     * List deliveries for an app webhook
     * @description Returns a list of webhook deliveries for the webhook configured for a GitHub App.
     *
     * You must use a [JWT](https://docs.github.com/enterprise-server@3.10/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
     */
    get: operations["apps/list-webhook-deliveries"];
  };
  "/app/hook/deliveries/{delivery_id}": {
    /**
     * Get a delivery for an app webhook
     * @description Returns a delivery for the webhook configured for a GitHub App.
     *
     * You must use a [JWT](https://docs.github.com/enterprise-server@3.10/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
     */
    get: operations["apps/get-webhook-delivery"];
  };
  "/app/hook/deliveries/{delivery_id}/attempts": {
    /**
     * Redeliver a delivery for an app webhook
     * @description Redeliver a delivery for the webhook configured for a GitHub App.
     *
     * You must use a [JWT](https://docs.github.com/enterprise-server@3.10/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
     */
    post: operations["apps/redeliver-webhook-delivery"];
  };
  "/app/installation-requests": {
    /**
     * List installation requests for the authenticated app
     * @description Lists all the pending installation requests for the authenticated GitHub App.
     */
    get: operations["apps/list-installation-requests-for-authenticated-app"];
  };
  "/app/installations": {
    /**
     * List installations for the authenticated app
     * @description You must use a [JWT](https://docs.github.com/enterprise-server@3.9/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
     *
     * The permissions the installation has are included under the `permissions` key.
     */
    get: operations["apps/list-installations"];
  };
  "/app/installations/{installation_id}": {
    /**
     * Get an installation for the authenticated app
     * @description Enables an authenticated GitHub App to find an installation's information using the installation id.
     *
     * You must use a [JWT](https://docs.github.com/enterprise-server@3.10/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
     */
    get: operations["apps/get-installation"];
    /**
     * Delete an installation for the authenticated app
     * @description Uninstalls a GitHub App on a user, organization, or business account. If you prefer to temporarily suspend an app's access to your account's resources, then we recommend the "[Suspend an app installation](https://docs.github.com/enterprise-server@3.10/rest/apps/apps#suspend-an-app-installation)" endpoint.
     *
     * You must use a [JWT](https://docs.github.com/enterprise-server@3.10/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
     */
    delete: operations["apps/delete-installation"];
  };
  "/app/installations/{installation_id}/access_tokens": {
    /**
     * Create an installation access token for an app
     * @description Creates an installation access token that enables a GitHub App to make authenticated API requests for the app's installation on an organization or individual account. Installation tokens expire one hour from the time you create them. Using an expired token produces a status code of `401 - Unauthorized`, and requires creating a new installation token. By default the installation token has access to all repositories that the installation can access.
     *
     * Optionally, you can use the `repositories` or `repository_ids` body parameters to specify individual repositories that the installation access token can access. If you don't use `repositories` or `repository_ids` to grant access to specific repositories, the installation access token will have access to all repositories that the installation was granted access to. The installation access token cannot be granted access to repositories that the installation was not granted access to. Up to 500 repositories can be listed in this manner.
     *
     * Optionally, use the `permissions` body parameter to specify the permissions that the installation access token should have. If `permissions` is not specified, the installation access token will have all of the permissions that were granted to the app. The installation access token cannot be granted permissions that the app was not granted.
     *
     * When using the repository or permission parameters to reduce the access of the token, the complexity of the token is increased due to both the number of permissions in the request and the number of repositories the token will have access to. If the complexity is too large, the token will fail to be issued. If this occurs, the error message will indicate the maximum number of repositories that should be requested. For the average application requesting 8 permissions, this limit is around 5000 repositories. With fewer permissions requested, more repositories are supported.
     *
     * You must use a [JWT](https://docs.github.com/enterprise-server@3.10/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
     */
    post: operations["apps/create-installation-access-token"];
  };
  "/app/installations/{installation_id}/suspended": {
    /**
     * Suspend an app installation
     * @description Suspends a GitHub App on a user, organization, or business account, which blocks the app from accessing the account's resources. When a GitHub App is suspended, the app's access to the GitHub Enterprise Server API or webhook events is blocked for that account.
     *
     * You must use a [JWT](https://docs.github.com/enterprise-server@3.10/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
     */
    put: operations["apps/suspend-installation"];
    /**
     * Unsuspend an app installation
     * @description Removes a GitHub App installation suspension.
     *
     * You must use a [JWT](https://docs.github.com/enterprise-server@3.10/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
     */
    delete: operations["apps/unsuspend-installation"];
  };
  "/applications/grants": {
    /**
     * List your grants
     * @deprecated
     * @description **Deprecation Notice:** GitHub Enterprise Server will discontinue the [OAuth Authorizations API](https://docs.github.com/enterprise-server@3.10/rest/oauth-authorizations/oauth-authorizations/), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/enterprise-server@3.10/developers/apps/authorizing-oauth-apps#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/enterprise-server@3.10/rest/oauth-authorizations/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/).
     *
     * You can use this API to list the set of OAuth applications that have been granted access to your account. Unlike the [list your authorizations](https://docs.github.com/enterprise-server@3.10/rest/oauth-authorizations/oauth-authorizations#list-your-authorizations) API, this API does not manage individual tokens. This API will return one entry for each OAuth application that has been granted access to your account, regardless of the number of tokens an application has generated for your user. The list of OAuth applications returned matches what is shown on [the application authorizations settings screen within GitHub](https://github.com/settings/applications#authorized). The `scopes` returned are the union of scopes authorized for the application. For example, if an application has one token with `repo` scope and another token with `user` scope, the grant will return `["repo", "user"]`.
     */
    get: operations["oauth-authorizations/list-grants"];
  };
  "/applications/grants/{grant_id}": {
    /**
     * Get a single grant
     * @deprecated
     * @description **Deprecation Notice:** GitHub Enterprise Server will discontinue the [OAuth Authorizations API](https://docs.github.com/enterprise-server@3.10/rest/oauth-authorizations/oauth-authorizations), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/enterprise-server@3.10/apps/building-oauth-apps/authorizing-oauth-apps/#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/enterprise-server@3.10/rest/oauth-authorizations/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/).
     */
    get: operations["oauth-authorizations/get-grant"];
    /**
     * Delete a grant
     * @deprecated
     * @description **Deprecation Notice:** GitHub Enterprise Server will discontinue the [OAuth Authorizations API](https://docs.github.com/enterprise-server@3.10/rest/oauth-authorizations/oauth-authorizations/), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/enterprise-server@3.10/developers/apps/authorizing-oauth-apps#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/enterprise-server@3.10/rest/oauth-authorizations/oauth-authorizations/) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/).
     *
     * Deleting an OAuth application's grant will also delete all OAuth tokens associated with the application for your user. Once deleted, the application has no access to your account and is no longer listed on [the application authorizations settings screen within GitHub](https://github.com/settings/applications#authorized).
     */
    delete: operations["oauth-authorizations/delete-grant"];
  };
  "/applications/{client_id}/grant": {
    /**
     * Delete an app authorization
     * @description OAuth and GitHub application owners can revoke a grant for their application and a specific user. You must use [Basic Authentication](https://docs.github.com/enterprise-server@3.10/rest/overview/other-authentication-methods#basic-authentication) when accessing this endpoint, using the OAuth application's `client_id` and `client_secret` as the username and password. You must also provide a valid OAuth `access_token` as an input parameter and the grant for the token's owner will be deleted.
     * Deleting an application's grant will also delete all OAuth tokens associated with the application for the user. Once deleted, the application will have no access to the user's account and will no longer be listed on [the application authorizations settings screen within GitHub](https://github.com/settings/applications#authorized).
     */
    delete: operations["apps/delete-authorization"];
  };
  "/applications/{client_id}/token": {
    /**
     * Check a token
     * @description OAuth applications and GitHub applications with OAuth authorizations can use this API method for checking OAuth token validity without exceeding the normal rate limits for failed login attempts. Authentication works differently with this particular endpoint. You must use [Basic Authentication](https://docs.github.com/enterprise-server@3.10/rest/overview/other-authentication-methods#basic-authentication) to use this endpoint, where the username is the application `client_id` and the password is its `client_secret`. Invalid tokens will return `404 NOT FOUND`.
     */
    post: operations["apps/check-token"];
    /**
     * Delete an app token
     * @description OAuth  or GitHub application owners can revoke a single token for an OAuth application or a GitHub application with an OAuth authorization. You must use [Basic Authentication](https://docs.github.com/enterprise-server@3.10/rest/overview/other-authentication-methods#basic-authentication) when accessing this endpoint, using the application's `client_id` and `client_secret` as the username and password.
     */
    delete: operations["apps/delete-token"];
    /**
     * Reset a token
     * @description OAuth applications and GitHub applications with OAuth authorizations can use this API method to reset a valid OAuth token without end-user involvement. Applications must save the "token" property in the response because changes take effect immediately. You must use [Basic Authentication](https://docs.github.com/enterprise-server@3.10/rest/overview/other-authentication-methods#basic-authentication) when accessing this endpoint, using the application's `client_id` and `client_secret` as the username and password. Invalid tokens will return `404 NOT FOUND`.
     */
    patch: operations["apps/reset-token"];
  };
  "/applications/{client_id}/token/scoped": {
    /**
     * Create a scoped access token
     * @description Use a non-scoped user access token to create a repository-scoped and/or permission-scoped user access token. You can specify
     * which repositories the token can access and which permissions are granted to the
     * token.
     *
     * Invalid tokens will return `404 NOT FOUND`.
     *
     * You must use [Basic Authentication](https://docs.github.com/enterprise-server@3.10/rest/overview/other-authentication-methods#basic-authentication)
     * when accessing this endpoint, using the `client_id` and `client_secret` of the GitHub App
     * as the username and password.
     */
    post: operations["apps/scope-token"];
  };
  "/apps/{app_slug}": {
    /**
     * Get an app
     * @description **Note**: The `:app_slug` is just the URL-friendly name of your GitHub App. You can find this on the settings page for your GitHub App (e.g., `https://github.com/settings/apps/:app_slug`).
     */
    get: operations["apps/get-by-slug"];
  };
  "/authorizations": {
    /**
     * List your authorizations
     * @deprecated
     * @description **Deprecation Notice:** GitHub Enterprise Server will discontinue the [OAuth Authorizations API](https://docs.github.com/enterprise-server@3.10/rest/oauth-authorizations/oauth-authorizations), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/enterprise-server@3.10/apps/building-oauth-apps/authorizing-oauth-apps/#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/enterprise-server@3.10/rest/oauth-authorizations/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/).
     */
    get: operations["oauth-authorizations/list-authorizations"];
    /**
     * Create a new authorization
     * @deprecated
     * @description **Deprecation Notice:** GitHub Enterprise Server will discontinue the [OAuth Authorizations API](https://docs.github.com/enterprise-server@3.10/rest/oauth-authorizations/oauth-authorizations), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/enterprise-server@3.10/developers/apps/authorizing-oauth-apps#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/enterprise-server@3.10/rest/oauth-authorizations/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/).
     *
     * **Warning:** Apps must use the [web application flow](https://docs.github.com/enterprise-server@3.10/apps/building-oauth-apps/authorizing-oauth-apps/#web-application-flow) to obtain OAuth tokens that work with GitHub Enterprise Server SAML organizations. OAuth tokens created using the Authorizations API will be unable to access GitHub Enterprise Server SAML organizations. For more information, see the [blog post](https://developer.github.com/changes/2019-11-05-deprecated-passwords-and-authorizations-api).
     *
     * Creates OAuth tokens using [Basic Authentication](https://docs.github.com/enterprise-server@3.10/rest/overview/other-authentication-methods#basic-authentication). If you have two-factor authentication setup, Basic Authentication for this endpoint requires that you use a one-time password (OTP) and your username and password instead of tokens. For more information, see "[Working with two-factor authentication](https://docs.github.com/enterprise-server@3.10/rest/overview/other-authentication-methods#working-with-two-factor-authentication)."
     *
     * To create tokens for a particular OAuth application using this endpoint, you must authenticate as the user you want to create an authorization for and provide the app's client ID and secret, found on your OAuth application's settings page. If your OAuth application intends to create multiple tokens for one user, use `fingerprint` to differentiate between them.
     *
     * You can also create tokens on GitHub Enterprise Server from the [personal access tokens settings](https://github.com/settings/tokens) page. Read more about these tokens in [the GitHub Help documentation](https://docs.github.com/enterprise-server@3.10/articles/creating-an-access-token-for-command-line-use).
     *
     * Organizations that enforce SAML SSO require personal access tokens to be allowed. For more information, see "[About identity and access management with SAML single sign-on](https://docs.github.com/enterprise-server@3.10/enterprise-cloud@latest/organizations/managing-saml-single-sign-on-for-your-organization/about-identity-and-access-management-with-saml-single-sign-on)" in the GitHub Enterprise Cloud documentation.
     */
    post: operations["oauth-authorizations/create-authorization"];
  };
  "/authorizations/clients/{client_id}": {
    /**
     * Get-or-create an authorization for a specific app
     * @deprecated
     * @description **Deprecation Notice:** GitHub Enterprise Server will discontinue the [OAuth Authorizations API](https://docs.github.com/enterprise-server@3.10/rest/oauth-authorizations/oauth-authorizations/), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/enterprise-server@3.10/developers/apps/authorizing-oauth-apps#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/enterprise-server@3.10/rest/oauth-authorizations/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/).
     *
     * **Warning:** Apps must use the [web application flow](https://docs.github.com/enterprise-server@3.10/apps/building-oauth-apps/authorizing-oauth-apps/#web-application-flow) to obtain OAuth tokens that work with GitHub Enterprise Server SAML organizations. OAuth tokens created using the Authorizations API will be unable to access GitHub Enterprise Server SAML organizations. For more information, see the [blog post](https://developer.github.com/changes/2019-11-05-deprecated-passwords-and-authorizations-api).
     *
     * Creates a new authorization for the specified OAuth application, only if an authorization for that application doesn't already exist for the user. The URL includes the 20 character client ID for the OAuth app that is requesting the token. It returns the user's existing authorization for the application if one is present. Otherwise, it creates and returns a new one.
     *
     * If you have two-factor authentication setup, Basic Authentication for this endpoint requires that you use a one-time password (OTP) and your username and password instead of tokens. For more information, see "[Working with two-factor authentication](https://docs.github.com/enterprise-server@3.10/rest/overview/other-authentication-methods#working-with-two-factor-authentication)."
     *
     * **Deprecation Notice:** GitHub Enterprise Server will discontinue the [OAuth Authorizations API](https://docs.github.com/enterprise-server@3.10/rest/oauth-authorizations/oauth-authorizations/), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/enterprise-server@3.10/developers/apps/authorizing-oauth-apps#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/enterprise-server@3.10/rest/oauth-authorizations/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/).
     */
    put: operations["oauth-authorizations/get-or-create-authorization-for-app"];
  };
  "/authorizations/clients/{client_id}/{fingerprint}": {
    /**
     * Get-or-create an authorization for a specific app and fingerprint
     * @deprecated
     * @description **Deprecation Notice:** GitHub Enterprise Server will discontinue the [OAuth Authorizations API](https://docs.github.com/enterprise-server@3.10/rest/oauth-authorizations/oauth-authorizations/), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/enterprise-server@3.10/developers/apps/authorizing-oauth-apps#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/enterprise-server@3.10/rest/oauth-authorizations/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/).
     *
     * **Warning:** Apps must use the [web application flow](https://docs.github.com/enterprise-server@3.10/apps/building-oauth-apps/authorizing-oauth-apps/#web-application-flow) to obtain OAuth tokens that work with GitHub Enterprise Server SAML organizations. OAuth tokens created using the Authorizations API will be unable to access GitHub Enterprise Server SAML organizations. For more information, see the [blog post](https://developer.github.com/changes/2019-11-05-deprecated-passwords-and-authorizations-api).
     *
     * This method will create a new authorization for the specified OAuth application, only if an authorization for that application and fingerprint do not already exist for the user. The URL includes the 20 character client ID for the OAuth app that is requesting the token. `fingerprint` is a unique string to distinguish an authorization from others created for the same client ID and user. It returns the user's existing authorization for the application if one is present. Otherwise, it creates and returns a new one.
     *
     * If you have two-factor authentication setup, Basic Authentication for this endpoint requires that you use a one-time password (OTP) and your username and password instead of tokens. For more information, see "[Working with two-factor authentication](https://docs.github.com/enterprise-server@3.10/rest/overview/other-authentication-methods#working-with-two-factor-authentication)."
     */
    put: operations["oauth-authorizations/get-or-create-authorization-for-app-and-fingerprint"];
  };
  "/authorizations/{authorization_id}": {
    /**
     * Get a single authorization
     * @deprecated
     * @description **Deprecation Notice:** GitHub Enterprise Server will discontinue the [OAuth Authorizations API](https://docs.github.com/enterprise-server@3.10/rest/oauth-authorizations/oauth-authorizations), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/enterprise-server@3.10/apps/building-oauth-apps/authorizing-oauth-apps/#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/enterprise-server@3.10/rest/oauth-authorizations/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/).
     */
    get: operations["oauth-authorizations/get-authorization"];
    /**
     * Delete an authorization
     * @deprecated
     * @description **Deprecation Notice:** GitHub Enterprise Server will discontinue the [OAuth Authorizations API](https://docs.github.com/enterprise-server@3.10/rest/oauth-authorizations/oauth-authorizations), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/enterprise-server@3.10/apps/building-oauth-apps/authorizing-oauth-apps/#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/enterprise-server@3.10/rest/oauth-authorizations/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/).
     */
    delete: operations["oauth-authorizations/delete-authorization"];
    /**
     * Update an existing authorization
     * @deprecated
     * @description **Deprecation Notice:** GitHub Enterprise Server will discontinue the [OAuth Authorizations API](https://docs.github.com/enterprise-server@3.10/rest/oauth-authorizations/oauth-authorizations/), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/enterprise-server@3.10/developers/apps/authorizing-oauth-apps#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/enterprise-server@3.10/rest/oauth-authorizations/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/).
     *
     * If you have two-factor authentication setup, Basic Authentication for this endpoint requires that you use a one-time password (OTP) and your username and password instead of tokens. For more information, see "[Working with two-factor authentication](https://docs.github.com/enterprise-server@3.10/rest/overview/other-authentication-methods#working-with-two-factor-authentication)."
     *
     * You can only send one of these scope keys at a time.
     */
    patch: operations["oauth-authorizations/update-authorization"];
  };
  "/codes_of_conduct": {
    /**
     * Get all codes of conduct
     * @description Returns array of all GitHub's codes of conduct.
     */
    get: operations["codes-of-conduct/get-all-codes-of-conduct"];
  };
  "/codes_of_conduct/{key}": {
    /**
     * Get a code of conduct
     * @description Returns information about the specified GitHub code of conduct.
     */
    get: operations["codes-of-conduct/get-conduct-code"];
  };
  "/emojis": {
    /**
     * Get emojis
     * @description Lists all the emojis available to use on GitHub Enterprise Server.
     */
    get: operations["emojis/get"];
  };
  "/enterprise/announcement": {
    /**
     * Get the global announcement banner
     * @description Gets the current message and expiration date of the global announcement banner in your enterprise.
     */
    get: operations["enterprise-admin/get-announcement"];
    /**
     * Remove the global announcement banner
     * @description Removes the global announcement banner in your enterprise.
     */
    delete: operations["enterprise-admin/remove-announcement"];
    /**
     * Set the global announcement banner
     * @description Sets the message and expiration time for the global announcement banner in your enterprise.
     */
    patch: operations["enterprise-admin/set-announcement"];
  };
  "/enterprise/settings/license": {
    /** Get license information */
    get: operations["enterprise-admin/get-license-information"];
  };
  "/enterprise/stats/all": {
    /** Get all statistics */
    get: operations["enterprise-admin/get-all-stats"];
  };
  "/enterprise/stats/comments": {
    /** Get comment statistics */
    get: operations["enterprise-admin/get-comment-stats"];
  };
  "/enterprise/stats/gists": {
    /** Get gist statistics */
    get: operations["enterprise-admin/get-gist-stats"];
  };
  "/enterprise/stats/hooks": {
    /** Get hooks statistics */
    get: operations["enterprise-admin/get-hooks-stats"];
  };
  "/enterprise/stats/issues": {
    /** Get issue statistics */
    get: operations["enterprise-admin/get-issue-stats"];
  };
  "/enterprise/stats/milestones": {
    /** Get milestone statistics */
    get: operations["enterprise-admin/get-milestone-stats"];
  };
  "/enterprise/stats/orgs": {
    /** Get organization statistics */
    get: operations["enterprise-admin/get-org-stats"];
  };
  "/enterprise/stats/pages": {
    /** Get pages statistics */
    get: operations["enterprise-admin/get-pages-stats"];
  };
  "/enterprise/stats/pulls": {
    /** Get pull request statistics */
    get: operations["enterprise-admin/get-pull-request-stats"];
  };
  "/enterprise/stats/repos": {
    /** Get repository statistics */
    get: operations["enterprise-admin/get-repo-stats"];
  };
  "/enterprise/stats/security-products": {
    /**
     * Get security products statistics
     * @description Gets the statistics about security products for a GitHub Enterprise Server instance.
     *
     * To use this endpoint, you must be a site admin.
     */
    get: operations["enterprise-admin/get-security-products"];
  };
  "/enterprise/stats/users": {
    /** Get users statistics */
    get: operations["enterprise-admin/get-user-stats"];
  };
  "/enterprises/{enterprise}/actions/cache/usage": {
    /**
     * Get GitHub Actions cache usage for an enterprise
     * @description Gets the total GitHub Actions cache usage for an enterprise.
     * The data fetched using this API is refreshed approximately every 5 minutes, so values returned from this endpoint may take at least 5 minutes to get updated.
     *
     * OAuth tokens and personal access tokens (classic) need the `admin:enterprise` scope to use this endpoint.
     */
    get: operations["actions/get-actions-cache-usage-for-enterprise"];
  };
  "/enterprises/{enterprise}/actions/cache/usage-policy": {
    /**
     * Get GitHub Actions cache usage policy for an enterprise
     * @description Gets the GitHub Actions cache usage policy for an enterprise.
     *
     * OAuth tokens and personal access tokens (classic) need the `admin:enterprise` scope to use this endpoint.
     */
    get: operations["actions/get-actions-cache-usage-policy-for-enterprise"];
    /**
     * Set GitHub Actions cache usage policy for an enterprise
     * @description Sets the GitHub Actions cache usage policy for an enterprise.
     *
     * OAuth app tokens and personal access tokens (classic) need the `admin:enterprise` scope to use this endpoint.
     */
    patch: operations["actions/set-actions-cache-usage-policy-for-enterprise"];
  };
  "/enterprises/{enterprise}/actions/permissions": {
    /**
     * Get GitHub Actions permissions for an enterprise
     * @description Gets the GitHub Actions permissions policy for organizations and allowed actions in an enterprise.
     *
     * OAuth app tokens and personal access tokens (classic) need the `admin:enterprise` scope to use this endpoint.
     */
    get: operations["enterprise-admin/get-github-actions-permissions-enterprise"];
    /**
     * Set GitHub Actions permissions for an enterprise
     * @description Sets the GitHub Actions permissions policy for organizations and allowed actions in an enterprise.
     *
     * OAuth app tokens and personal access tokens (classic) need the `admin:enterprise` scope to use this endpoint.
     */
    put: operations["enterprise-admin/set-github-actions-permissions-enterprise"];
  };
  "/enterprises/{enterprise}/actions/permissions/organizations": {
    /**
     * List selected organizations enabled for GitHub Actions in an enterprise
     * @description Lists the organizations that are selected to have GitHub Actions enabled in an enterprise. To use this endpoint, the enterprise permission policy for `enabled_organizations` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an enterprise](#set-github-actions-permissions-for-an-enterprise)."
     *
     * OAuth app tokens and personal access tokens (classic) need the `admin:enterprise` scope to use this endpoint.
     */
    get: operations["enterprise-admin/list-selected-organizations-enabled-github-actions-enterprise"];
    /**
     * Set selected organizations enabled for GitHub Actions in an enterprise
     * @description Replaces the list of selected organizations that are enabled for GitHub Actions in an enterprise. To use this endpoint, the enterprise permission policy for `enabled_organizations` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an enterprise](#set-github-actions-permissions-for-an-enterprise)."
     *
     * OAuth app tokens and personal access tokens (classic) need the `admin:enterprise` scope to use this endpoint.
     */
    put: operations["enterprise-admin/set-selected-organizations-enabled-github-actions-enterprise"];
  };
  "/enterprises/{enterprise}/actions/permissions/organizations/{org_id}": {
    /**
     * Enable a selected organization for GitHub Actions in an enterprise
     * @description Adds an organization to the list of selected organizations that are enabled for GitHub Actions in an enterprise. To use this endpoint, the enterprise permission policy for `enabled_organizations` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an enterprise](#set-github-actions-permissions-for-an-enterprise)."
     *
     * OAuth app tokens and personal access tokens (classic) need the `admin:enterprise` scope to use this endpoint.
     */
    put: operations["enterprise-admin/enable-selected-organization-github-actions-enterprise"];
    /**
     * Disable a selected organization for GitHub Actions in an enterprise
     * @description Removes an organization from the list of selected organizations that are enabled for GitHub Actions in an enterprise. To use this endpoint, the enterprise permission policy for `enabled_organizations` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an enterprise](#set-github-actions-permissions-for-an-enterprise)."
     *
     * OAuth app tokens and personal access tokens (classic) need the `admin:enterprise` scope to use this endpoint.
     */
    delete: operations["enterprise-admin/disable-selected-organization-github-actions-enterprise"];
  };
  "/enterprises/{enterprise}/actions/permissions/selected-actions": {
    /**
     * Get allowed actions for an enterprise
     * @description Gets the selected actions that are allowed in an enterprise. To use this endpoint, the enterprise permission policy for `allowed_actions` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an enterprise](#set-github-actions-permissions-for-an-enterprise)."
     *
     * OAuth app tokens and personal access tokens (classic) need the `admin:enterprise` scope to use this endpoint.
     */
    get: operations["enterprise-admin/get-allowed-actions-enterprise"];
    /**
     * Set allowed actions for an enterprise
     * @description Sets the actions that are allowed in an enterprise. To use this endpoint, the enterprise permission policy for `allowed_actions` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an enterprise](#set-github-actions-permissions-for-an-enterprise)."
     *
     * OAuth app tokens and personal access tokens (classic) need the `admin:enterprise` scope to use this endpoint.
     */
    put: operations["enterprise-admin/set-allowed-actions-enterprise"];
  };
  "/enterprises/{enterprise}/actions/permissions/workflow": {
    /**
     * Get default workflow permissions for an enterprise
     * @description Gets the default workflow permissions granted to the `GITHUB_TOKEN` when running workflows in an enterprise,
     * as well as whether GitHub Actions can submit approving pull request reviews. For more information, see
     * "[Enforcing a policy for workflow permissions in your enterprise](https://docs.github.com/enterprise-server@3.10/admin/policies/enforcing-policies-for-your-enterprise/enforcing-policies-for-github-actions-in-your-enterprise#enforcing-a-policy-for-workflow-permissions-in-your-enterprise)."
     *
     * OAuth tokens and personal access tokens (classic) need the `admin:enterprise` scope to use this endpoint.
     */
    get: operations["actions/get-github-actions-default-workflow-permissions-enterprise"];
    /**
     * Set default workflow permissions for an enterprise
     * @description Sets the default workflow permissions granted to the `GITHUB_TOKEN` when running workflows in an enterprise, and sets
     * whether GitHub Actions can submit approving pull request reviews. For more information, see
     * "[Enforcing a policy for workflow permissions in your enterprise](https://docs.github.com/enterprise-server@3.10/admin/policies/enforcing-policies-for-your-enterprise/enforcing-policies-for-github-actions-in-your-enterprise#enforcing-a-policy-for-workflow-permissions-in-your-enterprise)."
     *
     * OAuth app tokens and personal access tokens (classic) need the `admin:enterprise` scope to use this endpoint.
     */
    put: operations["actions/set-github-actions-default-workflow-permissions-enterprise"];
  };
  "/enterprises/{enterprise}/actions/runner-groups": {
    /**
     * List self-hosted runner groups for an enterprise
     * @description Lists all self-hosted runner groups for an enterprise.
     *
     * OAuth app tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.
     */
    get: operations["enterprise-admin/list-self-hosted-runner-groups-for-enterprise"];
    /**
     * Create a self-hosted runner group for an enterprise
     * @description Creates a new self-hosted runner group for an enterprise.
     *
     * OAuth app tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.
     */
    post: operations["enterprise-admin/create-self-hosted-runner-group-for-enterprise"];
  };
  "/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}": {
    /**
     * Get a self-hosted runner group for an enterprise
     * @description Gets a specific self-hosted runner group for an enterprise.
     *
     * OAuth app tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.
     */
    get: operations["enterprise-admin/get-self-hosted-runner-group-for-enterprise"];
    /**
     * Delete a self-hosted runner group from an enterprise
     * @description Deletes a self-hosted runner group for an enterprise.
     *
     * OAuth app tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.
     */
    delete: operations["enterprise-admin/delete-self-hosted-runner-group-from-enterprise"];
    /**
     * Update a self-hosted runner group for an enterprise
     * @description Updates the `name` and `visibility` of a self-hosted runner group in an enterprise.
     *
     * OAuth app tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.
     */
    patch: operations["enterprise-admin/update-self-hosted-runner-group-for-enterprise"];
  };
  "/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/organizations": {
    /**
     * List organization access to a self-hosted runner group in an enterprise
     * @description Lists the organizations with access to a self-hosted runner group.
     *
     * OAuth app tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.
     */
    get: operations["enterprise-admin/list-org-access-to-self-hosted-runner-group-in-enterprise"];
    /**
     * Set organization access for a self-hosted runner group in an enterprise
     * @description Replaces the list of organizations that have access to a self-hosted runner configured in an enterprise.
     *
     * OAuth app tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.
     */
    put: operations["enterprise-admin/set-org-access-to-self-hosted-runner-group-in-enterprise"];
  };
  "/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/organizations/{org_id}": {
    /**
     * Add organization access to a self-hosted runner group in an enterprise
     * @description Adds an organization to the list of selected organizations that can access a self-hosted runner group. The runner group must have `visibility` set to `selected`. For more information, see "[Create a self-hosted runner group for an enterprise](#create-a-self-hosted-runner-group-for-an-enterprise)."
     *
     * OAuth app tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.
     */
    put: operations["enterprise-admin/add-org-access-to-self-hosted-runner-group-in-enterprise"];
    /**
     * Remove organization access to a self-hosted runner group in an enterprise
     * @description Removes an organization from the list of selected organizations that can access a self-hosted runner group. The runner group must have `visibility` set to `selected`. For more information, see "[Create a self-hosted runner group for an enterprise](#create-a-self-hosted-runner-group-for-an-enterprise)."
     *
     * OAuth app tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.
     */
    delete: operations["enterprise-admin/remove-org-access-to-self-hosted-runner-group-in-enterprise"];
  };
  "/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/runners": {
    /**
     * List self-hosted runners in a group for an enterprise
     * @description Lists the self-hosted runners that are in a specific enterprise group.
     *
     * OAuth app tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.
     */
    get: operations["enterprise-admin/list-self-hosted-runners-in-group-for-enterprise"];
    /**
     * Set self-hosted runners in a group for an enterprise
     * @description Replaces the list of self-hosted runners that are part of an enterprise runner group.
     *
     * OAuth app tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.
     */
    put: operations["enterprise-admin/set-self-hosted-runners-in-group-for-enterprise"];
  };
  "/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/runners/{runner_id}": {
    /**
     * Add a self-hosted runner to a group for an enterprise
     * @description Adds a self-hosted runner to a runner group configured in an enterprise.
     *
     * OAuth app tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.
     */
    put: operations["enterprise-admin/add-self-hosted-runner-to-group-for-enterprise"];
    /**
     * Remove a self-hosted runner from a group for an enterprise
     * @description Removes a self-hosted runner from a group configured in an enterprise. The runner is then returned to the default group.
     *
     * OAuth app tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.
     */
    delete: operations["enterprise-admin/remove-self-hosted-runner-from-group-for-enterprise"];
  };
  "/enterprises/{enterprise}/actions/runners": {
    /**
     * List self-hosted runners for an enterprise
     * @description Lists all self-hosted runners configured for an enterprise.
     *
     * OAuth app tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.
     */
    get: operations["enterprise-admin/list-self-hosted-runners-for-enterprise"];
  };
  "/enterprises/{enterprise}/actions/runners/downloads": {
    /**
     * List runner applications for an enterprise
     * @description Lists binaries for the runner application that you can download and run.
     *
     * OAuth app tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.
     */
    get: operations["enterprise-admin/list-runner-applications-for-enterprise"];
  };
  "/enterprises/{enterprise}/actions/runners/generate-jitconfig": {
    /**
     * Create configuration for a just-in-time runner for an Enterprise
     * @description Generates a configuration that can be passed to the runner application at startup.
     *
     * OAuth tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.
     */
    post: operations["actions/generate-runner-jitconfig-for-enterprise"];
  };
  "/enterprises/{enterprise}/actions/runners/registration-token": {
    /**
     * Create a registration token for an enterprise
     * @description Returns a token that you can pass to the `config` script. The token expires after one hour.
     *
     * Example using registration token:
     *
     * Configure your self-hosted runner, replacing `TOKEN` with the registration token provided by this endpoint.
     *
     * ```
     * ./config.sh --url https://github.com/enterprises/octo-enterprise --token TOKEN
     * ```
     *
     * OAuth app tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.
     */
    post: operations["enterprise-admin/create-registration-token-for-enterprise"];
  };
  "/enterprises/{enterprise}/actions/runners/remove-token": {
    /**
     * Create a remove token for an enterprise
     * @description Returns a token that you can pass to the `config` script to remove a self-hosted runner from an enterprise. The token expires after one hour.
     *
     * Example using remove token:
     *
     * To remove your self-hosted runner from an enterprise, replace `TOKEN` with the remove token provided by this
     * endpoint.
     *
     * ```
     * ./config.sh remove --token TOKEN
     * ```
     *
     * OAuth app tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.
     */
    post: operations["enterprise-admin/create-remove-token-for-enterprise"];
  };
  "/enterprises/{enterprise}/actions/runners/{runner_id}": {
    /**
     * Get a self-hosted runner for an enterprise
     * @description Gets a specific self-hosted runner configured in an enterprise.
     *
     * OAuth app tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.
     */
    get: operations["enterprise-admin/get-self-hosted-runner-for-enterprise"];
    /**
     * Delete a self-hosted runner from an enterprise
     * @description Forces the removal of a self-hosted runner from an enterprise. You can use this endpoint to completely remove the runner when the machine you were using no longer exists.
     *
     * OAuth app tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.
     */
    delete: operations["enterprise-admin/delete-self-hosted-runner-from-enterprise"];
  };
  "/enterprises/{enterprise}/actions/runners/{runner_id}/labels": {
    /**
     * List labels for a self-hosted runner for an enterprise
     * @description Lists all labels for a self-hosted runner configured in an enterprise.
     *
     * OAuth app tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.
     */
    get: operations["enterprise-admin/list-labels-for-self-hosted-runner-for-enterprise"];
    /**
     * Set custom labels for a self-hosted runner for an enterprise
     * @description Remove all previous custom labels and set the new custom labels for a specific
     * self-hosted runner configured in an enterprise.
     *
     * OAuth app tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.
     */
    put: operations["enterprise-admin/set-custom-labels-for-self-hosted-runner-for-enterprise"];
    /**
     * Add custom labels to a self-hosted runner for an enterprise
     * @description Add custom labels to a self-hosted runner configured in an enterprise.
     *
     * OAuth app tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.
     */
    post: operations["enterprise-admin/add-custom-labels-to-self-hosted-runner-for-enterprise"];
    /**
     * Remove all custom labels from a self-hosted runner for an enterprise
     * @description Remove all custom labels from a self-hosted runner configured in an
     * enterprise. Returns the remaining read-only labels from the runner.
     *
     * OAuth app tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.
     */
    delete: operations["enterprise-admin/remove-all-custom-labels-from-self-hosted-runner-for-enterprise"];
  };
  "/enterprises/{enterprise}/actions/runners/{runner_id}/labels/{name}": {
    /**
     * Remove a custom label from a self-hosted runner for an enterprise
     * @description Remove a custom label from a self-hosted runner configured
     * in an enterprise. Returns the remaining labels from the runner.
     *
     * This endpoint returns a `404 Not Found` status if the custom label is not
     * present on the runner.
     *
     * OAuth app tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.
     */
    delete: operations["enterprise-admin/remove-custom-label-from-self-hosted-runner-for-enterprise"];
  };
  "/enterprises/{enterprise}/audit-log": {
    /**
     * Get the audit log for an enterprise
     * @description Gets the audit log for an enterprise.
     *
     * The authenticated user must be an enterprise admin to use this endpoint.
     *
     * OAuth app tokens and personal access tokens (classic) need the `admin:enterprise` scope to use this endpoint.
     */
    get: operations["enterprise-admin/get-audit-log"];
  };
  "/enterprises/{enterprise}/code-scanning/alerts": {
    /**
     * List code scanning alerts for an enterprise
     * @description Lists code scanning alerts for the default branch for all eligible repositories in an enterprise. Eligible repositories are repositories that are owned by organizations that you own or for which you are a security manager. For more information, see "[Managing security managers in your organization](https://docs.github.com/enterprise-server@3.10/organizations/managing-peoples-access-to-your-organization-with-roles/managing-security-managers-in-your-organization)."
     *
     * The authenticated user must be a member of the enterprise to use this endpoint.
     *
     * OAuth app tokens and personal access tokens (classic) need the `security_events` or `repo` scope to use this endpoint.
     */
    get: operations["code-scanning/list-alerts-for-enterprise"];
  };
  "/enterprises/{enterprise}/code_security_and_analysis": {
    /**
     * Get code security and analysis features for an enterprise
     * @description Gets code security and analysis settings for the specified enterprise.
     *
     * The authenticated user must be an administrator of the enterprise in order to use this endpoint.
     *
     * OAuth app tokens and personal access tokens (classic) need the `admin:enterprise` scope to use this endpoint.
     */
    get: operations["secret-scanning/get-security-analysis-settings-for-enterprise"];
    /**
     * Update code security and analysis features for an enterprise
     * @description Updates the settings for advanced security, Dependabot alerts, secret scanning, and push protection for new repositories in an enterprise.
     *
     * The authenticated user must be an administrator of the enterprise to use this endpoint.
     *
     * OAuth app tokens and personal access tokens (classic) need the `admin:enterprise` scope to use this endpoint.
     */
    patch: operations["secret-scanning/patch-security-analysis-settings-for-enterprise"];
  };
  "/enterprises/{enterprise}/dependabot/alerts": {
    /**
     * List Dependabot alerts for an enterprise
     * @description Lists Dependabot alerts for repositories that are owned by the specified enterprise.
     *
     * The authenticated user must be a member of the enterprise to use this endpoint.
     *
     * Alerts are only returned for organizations in the enterprise for which you are an organization owner or a security manager. For more information about security managers, see "[Managing security managers in your organization](https://docs.github.com/enterprise-server@3.10/organizations/managing-peoples-access-to-your-organization-with-roles/managing-security-managers-in-your-organization)."
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` or `security_events` scope to use this endpoint.
     */
    get: operations["dependabot/list-alerts-for-enterprise"];
  };
  "/enterprises/{enterprise}/secret-scanning/alerts": {
    /**
     * List secret scanning alerts for an enterprise
     * @description Lists secret scanning alerts for eligible repositories in an enterprise, from newest to oldest.
     * To use this endpoint, you must be a member of the enterprise, and you must use an access token with the `repo` scope or `security_events` scope. Alerts are only returned for organizations in the enterprise for which you are an organization owner or a [security manager](https://docs.github.com/enterprise-server@3.10/organizations/managing-peoples-access-to-your-organization-with-roles/managing-security-managers-in-your-organization).
     */
    get: operations["secret-scanning/list-alerts-for-enterprise"];
  };
  "/enterprises/{enterprise}/settings/billing/advanced-security": {
    /**
     * Get GitHub Advanced Security active committers for an enterprise
     * @description Gets the GitHub Advanced Security active committers for an enterprise per repository.
     *
     * Each distinct user login across all repositories is counted as a single Advanced Security seat, so the `total_advanced_security_committers` is not the sum of active_users for each repository.
     *
     * The total number of repositories with committer information is tracked by the `total_count` field.
     */
    get: operations["billing/get-github-advanced-security-billing-ghe"];
  };
  "/enterprises/{enterprise}/{security_product}/{enablement}": {
    /**
     * Enable or disable a security feature
     * @description Enables or disables the specified security feature for all repositories in an enterprise.
     *
     * The authenticated user must be an administrator of the enterprise to use this endpoint.
     *
     * OAuth app tokens and personal access tokens (classic) need the `admin:enterprise` scope to use this endpoint.
     */
    post: operations["secret-scanning/post-security-product-enablement-for-enterprise"];
  };
  "/events": {
    /**
     * List public events
     * @description We delay the public events feed by five minutes, which means the most recent event returned by the public events API actually occurred at least five minutes ago.
     */
    get: operations["activity/list-public-events"];
  };
  "/feeds": {
    /**
     * Get feeds
     * @description Lists the feeds available to the authenticated user. The response provides a URL for each feed. You can then get a specific feed by sending a request to one of the feed URLs.
     *
     * *   **Timeline**: The GitHub Enterprise Server global public timeline
     * *   **User**: The public timeline for any user, using `uri_template`. For more information, see "[Hypermedia](https://docs.github.com/enterprise-server@3.10/rest/using-the-rest-api/getting-started-with-the-rest-api#hypermedia)."
     * *   **Current user public**: The public timeline for the authenticated user
     * *   **Current user**: The private timeline for the authenticated user
     * *   **Current user actor**: The private timeline for activity created by the authenticated user
     * *   **Current user organizations**: The private timeline for the organizations the authenticated user is a member of.
     * *   **Security advisories**: A collection of public announcements that provide information about security-related vulnerabilities in software on GitHub Enterprise Server.
     *
     * By default, timeline resources are returned in JSON. You can specify the `application/atom+xml` type in the `Accept` header to return timeline resources in Atom format. For more information, see "[Media types](https://docs.github.com/enterprise-server@3.10/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
     *
     * **Note**: Private feeds are only returned when [authenticating via Basic Auth](https://docs.github.com/enterprise-server@3.10/rest/overview/other-authentication-methods#basic-authentication) since current feed URIs use the older, non revocable auth tokens.
     */
    get: operations["activity/get-feeds"];
  };
  "/gists": {
    /**
     * List gists for the authenticated user
     * @description Lists the authenticated user's gists or if called anonymously, this endpoint returns all public gists:
     */
    get: operations["gists/list"];
    /**
     * Create a gist
     * @description Allows you to add a new gist with one or more files.
     *
     * **Note:** Don't name your files "gistfile" with a numerical suffix. This is the format of the automatic naming scheme that Gist uses internally.
     */
    post: operations["gists/create"];
  };
  "/gists/public": {
    /**
     * List public gists
     * @description List public gists sorted by most recently updated to least recently updated.
     *
     * Note: With [pagination](https://docs.github.com/enterprise-server@3.10/rest/guides/using-pagination-in-the-rest-api), you can fetch up to 3000 gists. For example, you can fetch 100 pages with 30 gists per page or 30 pages with 100 gists per page.
     */
    get: operations["gists/list-public"];
  };
  "/gists/starred": {
    /**
     * List starred gists
     * @description List the authenticated user's starred gists:
     */
    get: operations["gists/list-starred"];
  };
  "/gists/{gist_id}": {
    /**
     * Get a gist
     * @description Gets a specified gist.
     *
     * This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/enterprise-server@3.10/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
     *
     * - **`application/vnd.github.raw+json`**: Returns the raw markdown. This is the default if you do not pass any specific media type.
     * - **`application/vnd.github.base64+json`**: Returns the base64-encoded contents. This can be useful if your gist contains any invalid UTF-8 sequences.
     */
    get: operations["gists/get"];
    /** Delete a gist */
    delete: operations["gists/delete"];
    /**
     * Update a gist
     * @description Allows you to update a gist's description and to update, delete, or rename gist files. Files from the previous version of the gist that aren't explicitly changed during an edit are unchanged.
     */
    patch: operations["gists/update"];
  };
  "/gists/{gist_id}/comments": {
    /**
     * List gist comments
     * @description Lists the comments on a gist.
     *
     * This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/enterprise-server@3.10/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
     *
     * - **`application/vnd.github.raw+json`**: Returns the raw markdown. This is the default if you do not pass any specific media type.
     * - **`application/vnd.github.base64+json`**: Returns the base64-encoded contents. This can be useful if your gist contains any invalid UTF-8 sequences.
     */
    get: operations["gists/list-comments"];
    /**
     * Create a gist comment
     * @description Creates a comment on a gist.
     *
     * This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/enterprise-server@3.10/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
     *
     * - **`application/vnd.github.raw+json`**: Returns the raw markdown. This is the default if you do not pass any specific media type.
     * - **`application/vnd.github.base64+json`**: Returns the base64-encoded contents. This can be useful if your gist contains any invalid UTF-8 sequences.
     */
    post: operations["gists/create-comment"];
  };
  "/gists/{gist_id}/comments/{comment_id}": {
    /**
     * Get a gist comment
     * @description Gets a comment on a gist.
     *
     * This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/enterprise-server@3.10/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
     *
     * - **`application/vnd.github.raw+json`**: Returns the raw markdown. This is the default if you do not pass any specific media type.
     * - **`application/vnd.github.base64+json`**: Returns the base64-encoded contents. This can be useful if your gist contains any invalid UTF-8 sequences.
     */
    get: operations["gists/get-comment"];
    /** Delete a gist comment */
    delete: operations["gists/delete-comment"];
    /**
     * Update a gist comment
     * @description Updates a comment on a gist.
     *
     * This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/enterprise-server@3.10/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
     *
     * - **`application/vnd.github.raw+json`**: Returns the raw markdown. This is the default if you do not pass any specific media type.
     * - **`application/vnd.github.base64+json`**: Returns the base64-encoded contents. This can be useful if your gist contains any invalid UTF-8 sequences.
     */
    patch: operations["gists/update-comment"];
  };
  "/gists/{gist_id}/commits": {
    /** List gist commits */
    get: operations["gists/list-commits"];
  };
  "/gists/{gist_id}/forks": {
    /** List gist forks */
    get: operations["gists/list-forks"];
    /** Fork a gist */
    post: operations["gists/fork"];
  };
  "/gists/{gist_id}/star": {
    /** Check if a gist is starred */
    get: operations["gists/check-is-starred"];
    /**
     * Star a gist
     * @description Note that you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP method](https://docs.github.com/enterprise-server@3.10/rest/guides/getting-started-with-the-rest-api#http-method)."
     */
    put: operations["gists/star"];
    /** Unstar a gist */
    delete: operations["gists/unstar"];
  };
  "/gists/{gist_id}/{sha}": {
    /**
     * Get a gist revision
     * @description Gets a specified gist revision.
     *
     * This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/enterprise-server@3.10/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
     *
     * - **`application/vnd.github.raw+json`**: Returns the raw markdown. This is the default if you do not pass any specific media type.
     * - **`application/vnd.github.base64+json`**: Returns the base64-encoded contents. This can be useful if your gist contains any invalid UTF-8 sequences.
     */
    get: operations["gists/get-revision"];
  };
  "/gitignore/templates": {
    /**
     * Get all gitignore templates
     * @description List all templates available to pass as an option when [creating a repository](https://docs.github.com/enterprise-server@3.10/rest/repos/repos#create-a-repository-for-the-authenticated-user).
     */
    get: operations["gitignore/get-all-templates"];
  };
  "/gitignore/templates/{name}": {
    /**
     * Get a gitignore template
     * @description Get the content of a gitignore template.
     *
     * This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/enterprise-server@3.10/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
     *
     * - **`application/vnd.github.raw+json`**: Returns the raw .gitignore contents.
     */
    get: operations["gitignore/get-template"];
  };
  "/installation/repositories": {
    /**
     * List repositories accessible to the app installation
     * @description List repositories that an app installation can access.
     */
    get: operations["apps/list-repos-accessible-to-installation"];
  };
  "/installation/token": {
    /**
     * Revoke an installation access token
     * @description Revokes the installation token you're using to authenticate as an installation and access this endpoint.
     *
     * Once an installation token is revoked, the token is invalidated and cannot be used. Other endpoints that require the revoked installation token must have a new installation token to work. You can create a new token using the "[Create an installation access token for an app](https://docs.github.com/enterprise-server@3.10/rest/apps/apps#create-an-installation-access-token-for-an-app)" endpoint.
     */
    delete: operations["apps/revoke-installation-access-token"];
  };
  "/issues": {
    /**
     * List issues assigned to the authenticated user
     * @description List issues assigned to the authenticated user across all visible repositories including owned repositories, member
     * repositories, and organization repositories. You can use the `filter` query parameter to fetch issues that are not
     * necessarily assigned to you.
     *
     * **Note**: GitHub's REST API considers every pull request an issue, but not every issue is a pull request. For this
     * reason, "Issues" endpoints may return both issues and pull requests in the response. You can identify pull requests by
     * the `pull_request` key. Be aware that the `id` of a pull request returned from "Issues" endpoints will be an _issue id_. To find out the pull
     * request id, use the "[List pull requests](https://docs.github.com/enterprise-server@3.10/rest/pulls/pulls#list-pull-requests)" endpoint.
     *
     * This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/enterprise-server@3.10/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
     *
     * - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
     * - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
     * - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
     * - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
     */
    get: operations["issues/list"];
  };
  "/licenses": {
    /**
     * Get all commonly used licenses
     * @description Lists the most commonly used licenses on GitHub. For more information, see "[Licensing a repository ](https://docs.github.com/enterprise-server@3.10/repositories/managing-your-repositorys-settings-and-features/customizing-your-repository/licensing-a-repository)."
     */
    get: operations["licenses/get-all-commonly-used"];
  };
  "/licenses/{license}": {
    /**
     * Get a license
     * @description Gets information about a specific license. For more information, see "[Licensing a repository ](https://docs.github.com/enterprise-server@3.10/repositories/managing-your-repositorys-settings-and-features/customizing-your-repository/licensing-a-repository)."
     */
    get: operations["licenses/get"];
  };
  "/manage/v1/config/nodes": {
    /**
     * Get GHES node metadata for all nodes
     * @description Get node metadata for all configured nodes in the current cluster. For more information, see "[About clustering](https://docs.github.com/enterprise-server@3.10/admin/enterprise-management/configuring-clustering/about-clustering)."
     */
    get: operations["enterprise-admin/get-config-nodes"];
  };
  "/manage/v1/maintenance": {
    /**
     * Get the status of maintenance mode
     * @description Gets the status and details of maintenance mode on all available nodes. For more information, see "[Enabling and scheduling maintenance mode](https://docs.github.com/enterprise-server@3.10/admin/configuration/configuring-your-enterprise/enabling-and-scheduling-maintenance-mode)."
     */
    get: operations["enterprise-admin/get-manage-maintenance"];
    /**
     * Set the status of maintenance mode
     * @description Sets or schedules the maintenance mode. For more information, see "[Enabling and scheduling maintenance mode](https://docs.github.com/enterprise-server@3.10/admin/configuration/configuring-your-enterprise/enabling-and-scheduling-maintenance-mode)."
     */
    post: operations["enterprise-admin/set-manage-maintenance"];
  };
  "/manage/v1/replication/status": {
    /**
     * Get the status of services running on all replica nodes
     * @description Gets the status of all services running on each replica node.
     * This endpoint may take several seconds to reply.
     */
    get: operations["enterprise-admin/get-replication-status"];
  };
  "/manage/v1/version": {
    /**
     * Get all GHES release versions for all nodes
     * @description Gets the GitHub Enterprise Server release versions that are currently installed on all available nodes. For more information, see "[GitHub Enterprise Server releases](https://docs.github.com/enterprise-server@3.10/admin/all-releases)."
     */
    get: operations["enterprise-admin/get-version"];
  };
  "/markdown": {
    /** Render a Markdown document */
    post: operations["markdown/render"];
  };
  "/markdown/raw": {
    /**
     * Render a Markdown document in raw mode
     * @description You must send Markdown as plain text (using a `Content-Type` header of `text/plain` or `text/x-markdown`) to this endpoint, rather than using JSON format. In raw mode, [GitHub Flavored Markdown](https://github.github.com/gfm/) is not supported and Markdown will be rendered in plain format like a README.md file. Markdown content must be 400 KB or less.
     */
    post: operations["markdown/render-raw"];
  };
  "/meta": {
    /** Get GitHub Enterprise Server meta information */
    get: operations["meta/get"];
  };
  "/networks/{owner}/{repo}/events": {
    /** List public events for a network of repositories */
    get: operations["activity/list-public-events-for-repo-network"];
  };
  "/notifications": {
    /**
     * List notifications for the authenticated user
     * @description List all notifications for the current user, sorted by most recently updated.
     */
    get: operations["activity/list-notifications-for-authenticated-user"];
    /**
     * Mark notifications as read
     * @description Marks all notifications as "read" for the current user. If the number of notifications is too large to complete in one request, you will receive a `202 Accepted` status and GitHub Enterprise Server will run an asynchronous process to mark notifications as "read." To check whether any "unread" notifications remain, you can use the [List notifications for the authenticated user](https://docs.github.com/enterprise-server@3.10/rest/activity/notifications#list-notifications-for-the-authenticated-user) endpoint and pass the query parameter `all=false`.
     */
    put: operations["activity/mark-notifications-as-read"];
  };
  "/notifications/threads/{thread_id}": {
    /**
     * Get a thread
     * @description Gets information about a notification thread.
     */
    get: operations["activity/get-thread"];
    /**
     * Mark a thread as read
     * @description Marks a thread as "read." Marking a thread as "read" is equivalent to clicking a notification in your notification inbox on GitHub Enterprise Server: https://github.com/notifications.
     */
    patch: operations["activity/mark-thread-as-read"];
  };
  "/notifications/threads/{thread_id}/subscription": {
    /**
     * Get a thread subscription for the authenticated user
     * @description This checks to see if the current user is subscribed to a thread. You can also [get a repository subscription](https://docs.github.com/enterprise-server@3.10/rest/activity/watching#get-a-repository-subscription).
     *
     * Note that subscriptions are only generated if a user is participating in a conversation--for example, they've replied to the thread, were **@mentioned**, or manually subscribe to a thread.
     */
    get: operations["activity/get-thread-subscription-for-authenticated-user"];
    /**
     * Set a thread subscription
     * @description If you are watching a repository, you receive notifications for all threads by default. Use this endpoint to ignore future notifications for threads until you comment on the thread or get an **@mention**.
     *
     * You can also use this endpoint to subscribe to threads that you are currently not receiving notifications for or to subscribed to threads that you have previously ignored.
     *
     * Unsubscribing from a conversation in a repository that you are not watching is functionally equivalent to the [Delete a thread subscription](https://docs.github.com/enterprise-server@3.10/rest/activity/notifications#delete-a-thread-subscription) endpoint.
     */
    put: operations["activity/set-thread-subscription"];
    /**
     * Delete a thread subscription
     * @description Mutes all future notifications for a conversation until you comment on the thread or get an **@mention**. If you are watching the repository of the thread, you will still receive notifications. To ignore future notifications for a repository you are watching, use the [Set a thread subscription](https://docs.github.com/enterprise-server@3.10/rest/activity/notifications#set-a-thread-subscription) endpoint and set `ignore` to `true`.
     */
    delete: operations["activity/delete-thread-subscription"];
  };
  "/octocat": {
    /**
     * Get Octocat
     * @description Get the octocat as ASCII art
     */
    get: operations["meta/get-octocat"];
  };
  "/organizations": {
    /**
     * List organizations
     * @description Lists all organizations, in the order that they were created.
     *
     * **Note:** Pagination is powered exclusively by the `since` parameter. Use the [Link header](https://docs.github.com/enterprise-server@3.10/rest/guides/using-pagination-in-the-rest-api#using-link-headers) to get the URL for the next page of organizations.
     */
    get: operations["orgs/list"];
  };
  "/organizations/{organization_id}/custom_roles": {
    /**
     * Deprecated - List custom repository roles in an organization
     * @deprecated
     * @description **Note**: This operation is deprecated and will be removed in the future.
     * Use the "[List custom repository roles](https://docs.github.com/enterprise-server@3.10/rest/orgs/custom-roles#list-custom-repository-roles-in-an-organization)" endpoint instead.
     *
     * List the custom repository roles available in this organization. For more information on custom repository roles, see "[About custom repository roles](https://docs.github.com/enterprise-server@3.10/organizations/managing-peoples-access-to-your-organization-with-roles/about-custom-repository-roles)."
     *
     * The authenticated user must be administrator of the organization or of a repository of the organization to use this endpoint.
     *
     * OAuth app tokens and personal access tokens (classic) need the `admin:org` or `repo` scope to use this endpoint.
     */
    get: operations["orgs/list-custom-roles"];
  };
  "/orgs/{org}": {
    /**
     * Get an organization
     * @description Gets information about an organization.
     *
     * When the value of `two_factor_requirement_enabled` is `true`, the organization requires all members, billing managers, and outside collaborators to enable [two-factor authentication](https://docs.github.com/enterprise-server@3.10/articles/securing-your-account-with-two-factor-authentication-2fa/).
     *
     * To see the full details about an organization, the authenticated user must be an organization owner.
     *
     * The values returned by this endpoint are set by the "Update an organization" endpoint. If your organization set a default security configuration (beta), the following values retrieved from the "Update an organization" endpoint have been overwritten by that configuration:
     *
     * - advanced_security_enabled_for_new_repositories
     * - dependabot_alerts_enabled_for_new_repositories
     * - dependabot_security_updates_enabled_for_new_repositories
     * - dependency_graph_enabled_for_new_repositories
     * - secret_scanning_enabled_for_new_repositories
     * - secret_scanning_push_protection_enabled_for_new_repositories
     *
     * For more information on security configurations, see "[Enabling security features at scale](https://docs.github.com/enterprise-server@3.10/code-security/securing-your-organization/introduction-to-securing-your-organization-at-scale/about-enabling-security-features-at-scale)."
     *
     * OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to see the full details about an organization.
     *
     * To see information about an organization's GitHub Enterprise Server plan, GitHub Apps need the `Organization plan` permission.
     */
    get: operations["orgs/get"];
    /**
     * Delete an organization
     * @description Deletes an organization and all its repositories.
     *
     * The organization login will be unavailable for 90 days after deletion.
     *
     * Please review the Terms of Service regarding account deletion before using this endpoint:
     *
     * https://docs.github.com/enterprise-server@3.10/site-policy/github-terms/github-terms-of-service
     */
    delete: operations["orgs/delete"];
    /**
     * Update an organization
     * @description **Parameter Deprecation Notice:** GitHub Enterprise Server will replace and discontinue `members_allowed_repository_creation_type` in favor of more granular permissions. The new input parameters are `members_can_create_public_repositories`, `members_can_create_private_repositories` for all organizations and `members_can_create_internal_repositories` for organizations associated with an enterprise account using GitHub Enterprise Cloud or GitHub Enterprise Server 2.20+. For more information, see the [blog post](https://developer.github.com/changes/2019-12-03-internal-visibility-changes).
     *
     * Updates the organization's profile and member privileges.
     *
     * With security configurations (beta), your organization can choose a default security configuration which will automatically apply a set of security enablement settings to new repositories in your organization based on their visibility. For targeted repositories, the following attributes will be overridden by the default security configuration:
     *
     * - advanced_security_enabled_for_new_repositories
     * - dependabot_alerts_enabled_for_new_repositories
     * - dependabot_security_updates_enabled_for_new_repositories
     * - dependency_graph_enabled_for_new_repositories
     * - secret_scanning_enabled_for_new_repositories
     * - secret_scanning_push_protection_enabled_for_new_repositories
     *
     * For more information on setting a default security configuration, see "[Enabling security features at scale](https://docs.github.com/enterprise-server@3.10/code-security/securing-your-organization/introduction-to-securing-your-organization-at-scale/about-enabling-security-features-at-scale)."
     *
     * The authenticated user must be an organization owner to use this endpoint.
     *
     * OAuth app tokens and personal access tokens (classic) need the `admin:org` or `repo` scope to use this endpoint.
     */
    patch: operations["orgs/update"];
  };
  "/orgs/{org}/actions/cache/usage": {
    /**
     * Get GitHub Actions cache usage for an organization
     * @description Gets the total GitHub Actions cache usage for an organization.
     * The data fetched using this API is refreshed approximately every 5 minutes, so values returned from this endpoint may take at least 5 minutes to get updated.
     *
     * OAuth tokens and personal access tokens (classic) need the `read:org` scope to use this endpoint.
     */
    get: operations["actions/get-actions-cache-usage-for-org"];
  };
  "/orgs/{org}/actions/cache/usage-by-repository": {
    /**
     * List repositories with GitHub Actions cache usage for an organization
     * @description Lists repositories and their GitHub Actions cache usage for an organization.
     * The data fetched using this API is refreshed approximately every 5 minutes, so values returned from this endpoint may take at least 5 minutes to get updated.
     *
     * OAuth tokens and personal access tokens (classic) need the `read:org` scope to use this endpoint.
     */
    get: operations["actions/get-actions-cache-usage-by-repo-for-org"];
  };
  "/orgs/{org}/actions/oidc/customization/sub": {
    /**
     * Get the customization template for an OIDC subject claim for an organization
     * @description Gets the customization template for an OpenID Connect (OIDC) subject claim.
     *
     * OAuth app tokens and personal access tokens (classic) need the `read:org` scope to use this endpoint.
     */
    get: operations["oidc/get-oidc-custom-sub-template-for-org"];
    /**
     * Set the customization template for an OIDC subject claim for an organization
     * @description Creates or updates the customization template for an OpenID Connect (OIDC) subject claim.
     *
     * OAuth app tokens and personal access tokens (classic) need the `write:org` scope to use this endpoint.
     */
    put: operations["oidc/update-oidc-custom-sub-template-for-org"];
  };
  "/orgs/{org}/actions/permissions": {
    /**
     * Get GitHub Actions permissions for an organization
     * @description Gets the GitHub Actions permissions policy for repositories and allowed actions in an organization.
     *
     * You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `administration` organization permission to use this API.
     */
    get: operations["actions/get-github-actions-permissions-organization"];
    /**
     * Set GitHub Actions permissions for an organization
     * @description Sets the GitHub Actions permissions policy for repositories and allowed actions in an organization.
     *
     * If the organization belongs to an enterprise that has set restrictive permissions at the enterprise level, such as `allowed_actions` to `selected` actions, then you cannot override them for the organization.
     *
     * OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
     */
    put: operations["actions/set-github-actions-permissions-organization"];
  };
  "/orgs/{org}/actions/permissions/repositories": {
    /**
     * List selected repositories enabled for GitHub Actions in an organization
     * @description Lists the selected repositories that are enabled for GitHub Actions in an organization. To use this endpoint, the organization permission policy for `enabled_repositories` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization)."
     *
     * OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
     */
    get: operations["actions/list-selected-repositories-enabled-github-actions-organization"];
    /**
     * Set selected repositories enabled for GitHub Actions in an organization
     * @description Replaces the list of selected repositories that are enabled for GitHub Actions in an organization. To use this endpoint, the organization permission policy for `enabled_repositories` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization)."
     *
     *
     * OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
     */
    put: operations["actions/set-selected-repositories-enabled-github-actions-organization"];
  };
  "/orgs/{org}/actions/permissions/repositories/{repository_id}": {
    /**
     * Enable a selected repository for GitHub Actions in an organization
     * @description Adds a repository to the list of selected repositories that are enabled for GitHub Actions in an organization. To use this endpoint, the organization permission policy for `enabled_repositories` must be must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization)."
     *
     * OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
     */
    put: operations["actions/enable-selected-repository-github-actions-organization"];
    /**
     * Disable a selected repository for GitHub Actions in an organization
     * @description Removes a repository from the list of selected repositories that are enabled for GitHub Actions in an organization. To use this endpoint, the organization permission policy for `enabled_repositories` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization)."
     *
     * OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
     */
    delete: operations["actions/disable-selected-repository-github-actions-organization"];
  };
  "/orgs/{org}/actions/permissions/selected-actions": {
    /**
     * Get allowed actions for an organization
     * @description Gets the selected actions that are allowed in an organization. To use this endpoint, the organization permission policy for `allowed_actions` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization).""
     *
     * You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `administration` organization permission to use this API.
     */
    get: operations["actions/get-allowed-actions-organization"];
    /**
     * Set allowed actions for an organization
     * @description Sets the actions that are allowed in an organization. To use this endpoint, the organization permission policy for `allowed_actions` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization)."
     *
     * If the organization belongs to an enterprise that has `selected` actions set at the enterprise level, then you cannot override any of the enterprise's allowed actions settings.
     *
     * To use the `patterns_allowed` setting for private repositories, the organization must belong to an enterprise. If the organization does not belong to an enterprise, then the `patterns_allowed` setting only applies to public repositories in the organization.
     *
     * OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
     */
    put: operations["actions/set-allowed-actions-organization"];
  };
  "/orgs/{org}/actions/permissions/workflow": {
    /**
     * Get default workflow permissions for an organization
     * @description Gets the default workflow permissions granted to the `GITHUB_TOKEN` when running workflows in an organization,
     * as well as whether GitHub Actions can submit approving pull request reviews. For more information, see
     * "[Setting the permissions of the GITHUB_TOKEN for your organization](https://docs.github.com/enterprise-server@3.10/organizations/managing-organization-settings/disabling-or-limiting-github-actions-for-your-organization#setting-the-permissions-of-the-github_token-for-your-organization)."
     *
     * OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
     */
    get: operations["actions/get-github-actions-default-workflow-permissions-organization"];
    /**
     * Set default workflow permissions for an organization
     * @description Sets the default workflow permissions granted to the `GITHUB_TOKEN` when running workflows in an organization, and sets if GitHub Actions
     * can submit approving pull request reviews. For more information, see
     * "[Setting the permissions of the GITHUB_TOKEN for your organization](https://docs.github.com/enterprise-server@3.10/organizations/managing-organization-settings/disabling-or-limiting-github-actions-for-your-organization#setting-the-permissions-of-the-github_token-for-your-organization)."
     *
     * OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
     */
    put: operations["actions/set-github-actions-default-workflow-permissions-organization"];
  };
  "/orgs/{org}/actions/runner-groups": {
    /**
     * List self-hosted runner groups for an organization
     * @description Lists all self-hosted runner groups configured in an organization and inherited from an enterprise.
     *
     * OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
     */
    get: operations["actions/list-self-hosted-runner-groups-for-org"];
    /**
     * Create a self-hosted runner group for an organization
     * @description Creates a new self-hosted runner group for an organization.
     *
     * OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
     */
    post: operations["actions/create-self-hosted-runner-group-for-org"];
  };
  "/orgs/{org}/actions/runner-groups/{runner_group_id}": {
    /**
     * Get a self-hosted runner group for an organization
     * @description Gets a specific self-hosted runner group for an organization.
     *
     * OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
     */
    get: operations["actions/get-self-hosted-runner-group-for-org"];
    /**
     * Delete a self-hosted runner group from an organization
     * @description Deletes a self-hosted runner group for an organization.
     *
     * OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
     */
    delete: operations["actions/delete-self-hosted-runner-group-from-org"];
    /**
     * Update a self-hosted runner group for an organization
     * @description Updates the `name` and `visibility` of a self-hosted runner group in an organization.
     *
     * OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
     */
    patch: operations["actions/update-self-hosted-runner-group-for-org"];
  };
  "/orgs/{org}/actions/runner-groups/{runner_group_id}/repositories": {
    /**
     * List repository access to a self-hosted runner group in an organization
     * @description Lists the repositories with access to a self-hosted runner group configured in an organization.
     *
     * OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
     */
    get: operations["actions/list-repo-access-to-self-hosted-runner-group-in-org"];
    /**
     * Set repository access for a self-hosted runner group in an organization
     * @description Replaces the list of repositories that have access to a self-hosted runner group configured in an organization.
     *
     * OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
     */
    put: operations["actions/set-repo-access-to-self-hosted-runner-group-in-org"];
  };
  "/orgs/{org}/actions/runner-groups/{runner_group_id}/repositories/{repository_id}": {
    /**
     * Add repository access to a self-hosted runner group in an organization
     * @description Adds a repository to the list of repositories that can access a self-hosted runner group. The runner group must have `visibility` set to `selected`. For more information, see "[Create a self-hosted runner group for an organization](#create-a-self-hosted-runner-group-for-an-organization)."
     *
     * OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
     */
    put: operations["actions/add-repo-access-to-self-hosted-runner-group-in-org"];
    /**
     * Remove repository access to a self-hosted runner group in an organization
     * @description Removes a repository from the list of selected repositories that can access a self-hosted runner group. The runner group must have `visibility` set to `selected`. For more information, see "[Create a self-hosted runner group for an organization](#create-a-self-hosted-runner-group-for-an-organization)."
     *
     * OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
     */
    delete: operations["actions/remove-repo-access-to-self-hosted-runner-group-in-org"];
  };
  "/orgs/{org}/actions/runner-groups/{runner_group_id}/runners": {
    /**
     * List self-hosted runners in a group for an organization
     * @description Lists self-hosted runners that are in a specific organization group.
     *
     * OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
     */
    get: operations["actions/list-self-hosted-runners-in-group-for-org"];
    /**
     * Set self-hosted runners in a group for an organization
     * @description Replaces the list of self-hosted runners that are part of an organization runner group.
     *
     * OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
     */
    put: operations["actions/set-self-hosted-runners-in-group-for-org"];
  };
  "/orgs/{org}/actions/runner-groups/{runner_group_id}/runners/{runner_id}": {
    /**
     * Add a self-hosted runner to a group for an organization
     * @description Adds a self-hosted runner to a runner group configured in an organization.
     *
     * OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
     */
    put: operations["actions/add-self-hosted-runner-to-group-for-org"];
    /**
     * Remove a self-hosted runner from a group for an organization
     * @description Removes a self-hosted runner from a group configured in an organization. The runner is then returned to the default group.
     *
     * OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
     */
    delete: operations["actions/remove-self-hosted-runner-from-group-for-org"];
  };
  "/orgs/{org}/actions/runners": {
    /**
     * List self-hosted runners for an organization
     * @description Lists all self-hosted runners configured in an organization.
     *
     * Authenticated users must have admin access to the organization to use this endpoint.
     *
     * OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.
     */
    get: operations["actions/list-self-hosted-runners-for-org"];
  };
  "/orgs/{org}/actions/runners/downloads": {
    /**
     * List runner applications for an organization
     * @description Lists binaries for the runner application that you can download and run.
     *
     * Authenticated users must have admin access to the organization to use this endpoint.
     *
     * OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.  If the repository is private, the `repo` scope is also required.
     */
    get: operations["actions/list-runner-applications-for-org"];
  };
  "/orgs/{org}/actions/runners/generate-jitconfig": {
    /**
     * Create configuration for a just-in-time runner for an organization
     * @description Generates a configuration that can be passed to the runner application at startup.
     *
     * The authenticated user must have admin access to the organization.
     *
     * OAuth tokens and personal access tokens (classic) need the`admin:org` scope to use this endpoint. If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    post: operations["actions/generate-runner-jitconfig-for-org"];
  };
  "/orgs/{org}/actions/runners/registration-token": {
    /**
     * Create a registration token for an organization
     * @description Returns a token that you can pass to the `config` script. The token expires after one hour.
     *
     * For example, you can replace `TOKEN` in the following example with the registration token provided by this endpoint to configure your self-hosted runner:
     *
     * ```
     * ./config.sh --url https://github.com/octo-org --token TOKEN
     * ```
     *
     * Authenticated users must have admin access to the organization to use this endpoint.
     *
     * OAuth tokens and personal access tokens (classic) need the`admin:org` scope to use this endpoint. If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    post: operations["actions/create-registration-token-for-org"];
  };
  "/orgs/{org}/actions/runners/remove-token": {
    /**
     * Create a remove token for an organization
     * @description Returns a token that you can pass to the `config` script to remove a self-hosted runner from an organization. The token expires after one hour.
     *
     * For example, you can replace `TOKEN` in the following example with the registration token provided by this endpoint to remove your self-hosted runner from an organization:
     *
     * ```
     * ./config.sh remove --token TOKEN
     * ```
     *
     * Authenticated users must have admin access to the organization to use this endpoint.
     *
     * OAuth tokens and personal access tokens (classic) need the`admin:org` scope to use this endpoint. If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    post: operations["actions/create-remove-token-for-org"];
  };
  "/orgs/{org}/actions/runners/{runner_id}": {
    /**
     * Get a self-hosted runner for an organization
     * @description Gets a specific self-hosted runner configured in an organization.
     *
     * Authenticated users must have admin access to the organization to use this endpoint.
     *
     * OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.
     */
    get: operations["actions/get-self-hosted-runner-for-org"];
    /**
     * Delete a self-hosted runner from an organization
     * @description Forces the removal of a self-hosted runner from an organization. You can use this endpoint to completely remove the runner when the machine you were using no longer exists.
     *
     * Authenticated users must have admin access to the organization to use this endpoint.
     *
     * OAuth tokens and personal access tokens (classic) need the`admin:org` scope to use this endpoint. If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    delete: operations["actions/delete-self-hosted-runner-from-org"];
  };
  "/orgs/{org}/actions/runners/{runner_id}/labels": {
    /**
     * List labels for a self-hosted runner for an organization
     * @description Lists all labels for a self-hosted runner configured in an organization.
     *
     * Authenticated users must have admin access to the organization to use this endpoint.
     *
     * OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.
     */
    get: operations["actions/list-labels-for-self-hosted-runner-for-org"];
    /**
     * Set custom labels for a self-hosted runner for an organization
     * @description Remove all previous custom labels and set the new custom labels for a specific
     * self-hosted runner configured in an organization.
     *
     * Authenticated users must have admin access to the organization to use this endpoint.
     *
     * OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.
     */
    put: operations["actions/set-custom-labels-for-self-hosted-runner-for-org"];
    /**
     * Add custom labels to a self-hosted runner for an organization
     * @description Adds custom labels to a self-hosted runner configured in an organization.
     *
     * Authenticated users must have admin access to the organization to use this endpoint.
     *
     * OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
     */
    post: operations["actions/add-custom-labels-to-self-hosted-runner-for-org"];
    /**
     * Remove all custom labels from a self-hosted runner for an organization
     * @description Remove all custom labels from a self-hosted runner configured in an
     * organization. Returns the remaining read-only labels from the runner.
     *
     * Authenticated users must have admin access to the organization to use this endpoint.
     *
     * OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.
     */
    delete: operations["actions/remove-all-custom-labels-from-self-hosted-runner-for-org"];
  };
  "/orgs/{org}/actions/runners/{runner_id}/labels/{name}": {
    /**
     * Remove a custom label from a self-hosted runner for an organization
     * @description Remove a custom label from a self-hosted runner configured
     * in an organization. Returns the remaining labels from the runner.
     *
     * This endpoint returns a `404 Not Found` status if the custom label is not
     * present on the runner.
     *
     * Authenticated users must have admin access to the organization to use this endpoint.
     *
     * OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.
     */
    delete: operations["actions/remove-custom-label-from-self-hosted-runner-for-org"];
  };
  "/orgs/{org}/actions/secrets": {
    /**
     * List organization secrets
     * @description Lists all secrets available in an organization without revealing their
     * encrypted values.
     *
     * Authenticated users must have collaborator access to a repository to create, update, or read secrets.
     *
     * OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.
     */
    get: operations["actions/list-org-secrets"];
  };
  "/orgs/{org}/actions/secrets/public-key": {
    /**
     * Get an organization public key
     * @description Gets your public key, which you need to encrypt secrets. You need to
     * encrypt a secret before you can create or update secrets.
     *
     * The authenticated user must have collaborator access to a repository to create, update, or read secrets.
     *
     * OAuth tokens and personal access tokens (classic) need the`admin:org` scope to use this endpoint. If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    get: operations["actions/get-org-public-key"];
  };
  "/orgs/{org}/actions/secrets/{secret_name}": {
    /**
     * Get an organization secret
     * @description Gets a single organization secret without revealing its encrypted value.
     *
     * The authenticated user must have collaborator access to a repository to create, update, or read secrets
     *
     * OAuth tokens and personal access tokens (classic) need the`admin:org` scope to use this endpoint. If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    get: operations["actions/get-org-secret"];
    /**
     * Create or update an organization secret
     * @description Creates or updates an organization secret with an encrypted value. Encrypt your secret using
     * [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages). You must authenticate using an access
     * token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `secrets` organization permission to
     * use this endpoint.
     *
     * #### Example encrypting a secret using Node.js
     *
     * Encrypt your secret using the [tweetsodium](https://github.com/github/tweetsodium) library.
     *
     * ```
     * const sodium = require('tweetsodium');
     *
     * const key = "base64-encoded-public-key";
     * const value = "plain-text-secret";
     *
     * // Convert the message and key to Uint8Array's (Buffer implements that interface)
     * const messageBytes = Buffer.from(value);
     * const keyBytes = Buffer.from(key, 'base64');
     *
     * // Encrypt using LibSodium.
     * const encryptedBytes = sodium.seal(messageBytes, keyBytes);
     *
     * // Base64 the encrypted secret
     * const encrypted = Buffer.from(encryptedBytes).toString('base64');
     *
     * console.log(encrypted);
     * ```
     *
     *
     * #### Example encrypting a secret using Python
     *
     * Encrypt your secret using [pynacl](https://pynacl.readthedocs.io/en/latest/public/#nacl-public-sealedbox) with Python 3.
     *
     * ```
     * from base64 import b64encode
     * from nacl import encoding, public
     *
     * def encrypt(public_key: str, secret_value: str) -> str:
     *   """Encrypt a Unicode string using the public key."""
     *   public_key = public.PublicKey(public_key.encode("utf-8"), encoding.Base64Encoder())
     *   sealed_box = public.SealedBox(public_key)
     *   encrypted = sealed_box.encrypt(secret_value.encode("utf-8"))
     *   return b64encode(encrypted).decode("utf-8")
     * ```
     *
     * #### Example encrypting a secret using C#
     *
     * Encrypt your secret using the [Sodium.Core](https://www.nuget.org/packages/Sodium.Core/) package.
     *
     * ```
     * var secretValue = System.Text.Encoding.UTF8.GetBytes("mySecret");
     * var publicKey = Convert.FromBase64String("2Sg8iYjAxxmI2LvUXpJjkYrMxURPc8r+dB7TJyvvcCU=");
     *
     * var sealedPublicKeyBox = Sodium.SealedPublicKeyBox.Create(secretValue, publicKey);
     *
     * Console.WriteLine(Convert.ToBase64String(sealedPublicKeyBox));
     * ```
     *
     * #### Example encrypting a secret using Ruby
     *
     * Encrypt your secret using the [rbnacl](https://github.com/RubyCrypto/rbnacl) gem.
     *
     * ```ruby
     * require "rbnacl"
     * require "base64"
     *
     * key = Base64.decode64("+ZYvJDZMHUfBkJdyq5Zm9SKqeuBQ4sj+6sfjlH4CgG0=")
     * public_key = RbNaCl::PublicKey.new(key)
     *
     * box = RbNaCl::Boxes::Sealed.from_public_key(public_key)
     * encrypted_secret = box.encrypt("my_secret")
     *
     * # Print the base64 encoded secret
     * puts Base64.strict_encode64(encrypted_secret)
     * ```
     */
    put: operations["actions/create-or-update-org-secret"];
    /**
     * Delete an organization secret
     * @description Deletes a secret in an organization using the secret name.
     *
     * Authenticated users must have collaborator access to a repository to create, update, or read secrets.
     *
     * OAuth tokens and personal access tokens (classic) need the`admin:org` scope to use this endpoint. If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    delete: operations["actions/delete-org-secret"];
  };
  "/orgs/{org}/actions/secrets/{secret_name}/repositories": {
    /**
     * List selected repositories for an organization secret
     * @description Lists all repositories that have been selected when the `visibility`
     * for repository access to a secret is set to `selected`.
     *
     * Authenticated users must have collaborator access to a repository to create, update, or read secrets.
     *
     * OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.
     */
    get: operations["actions/list-selected-repos-for-org-secret"];
    /**
     * Set selected repositories for an organization secret
     * @description Replaces all repositories for an organization secret when the `visibility`
     * for repository access is set to `selected`. The visibility is set when you [Create
     * or update an organization secret](https://docs.github.com/enterprise-server@3.10/rest/actions/secrets#create-or-update-an-organization-secret).
     *
     * Authenticated users must have collaborator access to a repository to create, update, or read secrets.
     *
     * OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.
     */
    put: operations["actions/set-selected-repos-for-org-secret"];
  };
  "/orgs/{org}/actions/secrets/{secret_name}/repositories/{repository_id}": {
    /**
     * Add selected repository to an organization secret
     * @description Adds a repository to an organization secret when the `visibility` for
     * repository access is set to `selected`. For more information about setting the visibility, see [Create or
     * update an organization secret](https://docs.github.com/enterprise-server@3.10/rest/actions/secrets#create-or-update-an-organization-secret).
     *
     * Authenticated users must have collaborator access to a repository to create, update, or read secrets.
     *
     * OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    put: operations["actions/add-selected-repo-to-org-secret"];
    /**
     * Remove selected repository from an organization secret
     * @description Removes a repository from an organization secret when the `visibility`
     * for repository access is set to `selected`. The visibility is set when you [Create
     * or update an organization secret](https://docs.github.com/enterprise-server@3.10/rest/actions/secrets#create-or-update-an-organization-secret).
     *
     * Authenticated users must have collaborator access to a repository to create, update, or read secrets.
     *
     * OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.
     */
    delete: operations["actions/remove-selected-repo-from-org-secret"];
  };
  "/orgs/{org}/actions/variables": {
    /**
     * List organization variables
     * @description Lists all organization variables.
     *
     * Authenticated users must have collaborator access to a repository to create, update, or read variables.
     *
     * OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.
     */
    get: operations["actions/list-org-variables"];
    /**
     * Create an organization variable
     * @description Creates an organization variable that you can reference in a GitHub Actions workflow.
     *
     * Authenticated users must have collaborator access to a repository to create, update, or read variables.
     *
     * OAuth tokens and personal access tokens (classic) need the`admin:org` scope to use this endpoint. If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    post: operations["actions/create-org-variable"];
  };
  "/orgs/{org}/actions/variables/{name}": {
    /**
     * Get an organization variable
     * @description Gets a specific variable in an organization.
     *
     * The authenticated user must have collaborator access to a repository to create, update, or read variables.
     *
     * OAuth tokens and personal access tokens (classic) need the`admin:org` scope to use this endpoint. If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    get: operations["actions/get-org-variable"];
    /**
     * Delete an organization variable
     * @description Deletes an organization variable using the variable name.
     *
     * Authenticated users must have collaborator access to a repository to create, update, or read variables.
     *
     * OAuth tokens and personal access tokens (classic) need the`admin:org` scope to use this endpoint. If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    delete: operations["actions/delete-org-variable"];
    /**
     * Update an organization variable
     * @description Updates an organization variable that you can reference in a GitHub Actions workflow.
     *
     * Authenticated users must have collaborator access to a repository to create, update, or read variables.
     *
     * OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.
     */
    patch: operations["actions/update-org-variable"];
  };
  "/orgs/{org}/actions/variables/{name}/repositories": {
    /**
     * List selected repositories for an organization variable
     * @description Lists all repositories that can access an organization variable
     * that is available to selected repositories.
     *
     * Authenticated users must have collaborator access to a repository to create, update, or read variables.
     *
     * OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.
     */
    get: operations["actions/list-selected-repos-for-org-variable"];
    /**
     * Set selected repositories for an organization variable
     * @description Replaces all repositories for an organization variable that is available
     * to selected repositories. Organization variables that are available to selected
     * repositories have their `visibility` field set to `selected`.
     *
     * Authenticated users must have collaborator access to a repository to create, update, or read variables.
     *
     * OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.
     */
    put: operations["actions/set-selected-repos-for-org-variable"];
  };
  "/orgs/{org}/actions/variables/{name}/repositories/{repository_id}": {
    /**
     * Add selected repository to an organization variable
     * @description Adds a repository to an organization variable that is available to selected repositories.
     * Organization variables that are available to selected repositories have their `visibility` field set to `selected`.
     *
     * Authenticated users must have collaborator access to a repository to create, update, or read secrets.
     *
     * OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    put: operations["actions/add-selected-repo-to-org-variable"];
    /**
     * Remove selected repository from an organization variable
     * @description Removes a repository from an organization variable that is
     * available to selected repositories. Organization variables that are available to
     * selected repositories have their `visibility` field set to `selected`.
     *
     * Authenticated users must have collaborator access to a repository to create, update, or read variables.
     *
     * OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.
     */
    delete: operations["actions/remove-selected-repo-from-org-variable"];
  };
  "/orgs/{org}/announcement": {
    /**
     * Get announcement banner for organization
     * @description Gets the announcement banner currently set for the organization. Only returns the announcement banner set at the
     * organization level. Organization members may also see an enterprise-level announcement banner. To get an
     * announcement banner displayed at the enterprise level, use the enterprise-level endpoint.
     */
    get: operations["announcement-banners/get-announcement-banner-for-org"];
    /**
     * Remove announcement banner from organization
     * @description Removes the announcement banner currently set for the organization.
     */
    delete: operations["announcement-banners/remove-announcement-banner-for-org"];
    /**
     * Set announcement banner for organization
     * @description Sets the announcement banner to display for the organization.
     */
    patch: operations["announcement-banners/set-announcement-banner-for-org"];
  };
  "/orgs/{org}/audit-log": {
    /**
     * Get the audit log for an organization
     * @description Gets the audit log for an organization. For more information, see "[Reviewing the audit log for your organization](https://docs.github.com/enterprise-server@3.10/github/setting-up-and-managing-organizations-and-teams/reviewing-the-audit-log-for-your-organization)."
     *
     * By default, the response includes up to 30 events from the past three months. Use the `phrase` parameter to filter results and retrieve older events. For example, use the `phrase` parameter with the `created` qualifier to filter events based on when the events occurred. For more information, see "[Reviewing the audit log for your organization](https://docs.github.com/enterprise-server@3.10/organizations/keeping-your-organization-secure/managing-security-settings-for-your-organization/reviewing-the-audit-log-for-your-organization#searching-the-audit-log)."
     *
     * Use pagination to retrieve fewer or more than 30 events. For more information, see "[Using pagination in the REST API](https://docs.github.com/enterprise-server@3.10/rest/guides/using-pagination-in-the-rest-api)."
     *
     * The authenticated user must be an organization owner to use this endpoint.
     *
     * OAuth app tokens and personal access tokens (classic) need the `read:audit_log` scope to use this endpoint.
     */
    get: operations["orgs/get-audit-log"];
  };
  "/orgs/{org}/code-scanning/alerts": {
    /**
     * List code scanning alerts for an organization
     * @description Lists code scanning alerts for the default branch for all eligible repositories in an organization. Eligible repositories are repositories that are owned by organizations that you own or for which you are a security manager. For more information, see "[Managing security managers in your organization](https://docs.github.com/enterprise-server@3.10/organizations/managing-peoples-access-to-your-organization-with-roles/managing-security-managers-in-your-organization)."
     *
     * The authenticated user must be an owner or security manager for the organization to use this endpoint.
     *
     * OAuth app tokens and personal access tokens (classic) need the `security_events` or `repo`s cope to use this endpoint with private or public repositories, or the `public_repo` scope to use this endpoint with only public repositories.
     */
    get: operations["code-scanning/list-alerts-for-org"];
  };
  "/orgs/{org}/custom-repository-roles": {
    /**
     * List custom repository roles in an organization
     * @description List the custom repository roles available in this organization. For more information on custom repository roles, see "[About custom repository roles](https://docs.github.com/enterprise-server@3.10/organizations/managing-peoples-access-to-your-organization-with-roles/about-custom-repository-roles)."
     *
     * The authenticated user must be an administrator of the organization or of a repository of the organization to use this endpoint.
     *
     * OAuth app tokens and personal access tokens (classic) need the `admin:org` or `repo` scope to use this endpoint.
     */
    get: operations["orgs/list-custom-repo-roles"];
    /**
     * Create a custom repository role
     * @description Creates a custom repository role that can be used by all repositories owned by the organization. For more information on custom repository roles, see "[About custom repository roles](https://docs.github.com/enterprise-server@3.10/organizations/managing-peoples-access-to-your-organization-with-roles/about-custom-repository-roles)."
     *
     * The authenticated user must be an administrator for the organization to use this endpoint.
     *
     * OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
     */
    post: operations["orgs/create-custom-repo-role"];
  };
  "/orgs/{org}/custom-repository-roles/{role_id}": {
    /**
     * Get a custom repository role
     * @description Gets a custom repository role that is available to all repositories owned by the organization. For more information on custom repository roles, see "[About custom repository roles](https://docs.github.com/enterprise-server@3.10/organizations/managing-peoples-access-to-your-organization-with-roles/about-custom-repository-roles)."
     *
     * The authenticated user must be an administrator of the organization or of a repository of the organization to use this endpoint.
     *
     * OAuth app tokens and personal access tokens (classic) need the `admin:org` or `repo` scope to use this endpoint.
     */
    get: operations["orgs/get-custom-repo-role"];
    /**
     * Delete a custom repository role
     * @description Deletes a custom role from an organization. Once the custom role has been deleted, any
     * user, team, or invitation with the deleted custom role will be reassigned the inherited role. For more information about custom repository roles, see "[About custom repository roles](https://docs.github.com/enterprise-server@3.10/organizations/managing-peoples-access-to-your-organization-with-roles/about-custom-repository-roles)."
     *
     * The authenticated user must be an administrator for the organization to use this endpoint.
     *
     * OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
     */
    delete: operations["orgs/delete-custom-repo-role"];
    /**
     * Update a custom repository role
     * @description Updates a custom repository role that can be used by all repositories owned by the organization. For more information about custom repository roles, see "[About custom repository roles](https://docs.github.com/enterprise-server@3.10/organizations/managing-peoples-access-to-your-organization-with-roles/about-custom-repository-roles)."
     *
     * The authenticated user must be an administrator for the organization to use this endpoint.
     *
     * OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
     */
    patch: operations["orgs/update-custom-repo-role"];
  };
  "/orgs/{org}/dependabot/alerts": {
    /**
     * List Dependabot alerts for an organization
     * @description Lists Dependabot alerts for an organization.
     *
     * The authenticated user must be an owner or security manager for the organization to use this endpoint.
     *
     * OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.
     */
    get: operations["dependabot/list-alerts-for-org"];
  };
  "/orgs/{org}/dependabot/secrets": {
    /**
     * List organization secrets
     * @description Lists all secrets available in an organization without revealing their
     * encrypted values.
     *
     * OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
     */
    get: operations["dependabot/list-org-secrets"];
  };
  "/orgs/{org}/dependabot/secrets/public-key": {
    /**
     * Get an organization public key
     * @description Gets your public key, which you need to encrypt secrets. You need to
     * encrypt a secret before you can create or update secrets.
     *
     * OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
     */
    get: operations["dependabot/get-org-public-key"];
  };
  "/orgs/{org}/dependabot/secrets/{secret_name}": {
    /**
     * Get an organization secret
     * @description Gets a single organization secret without revealing its encrypted value.
     *
     * OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
     */
    get: operations["dependabot/get-org-secret"];
    /**
     * Create or update an organization secret
     * @description Creates or updates an organization secret with an encrypted value. Encrypt your secret using
     * [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages). You must authenticate using an access
     * token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `dependabot_secrets` organization
     * permission to use this endpoint.
     *
     * #### Example encrypting a secret using Node.js
     *
     * Encrypt your secret using the [tweetsodium](https://github.com/github/tweetsodium) library.
     *
     * ```
     * const sodium = require('tweetsodium');
     *
     * const key = "base64-encoded-public-key";
     * const value = "plain-text-secret";
     *
     * // Convert the message and key to Uint8Array's (Buffer implements that interface)
     * const messageBytes = Buffer.from(value);
     * const keyBytes = Buffer.from(key, 'base64');
     *
     * // Encrypt using LibSodium.
     * const encryptedBytes = sodium.seal(messageBytes, keyBytes);
     *
     * // Base64 the encrypted secret
     * const encrypted = Buffer.from(encryptedBytes).toString('base64');
     *
     * console.log(encrypted);
     * ```
     *
     *
     * #### Example encrypting a secret using Python
     *
     * Encrypt your secret using [pynacl](https://pynacl.readthedocs.io/en/latest/public/#nacl-public-sealedbox) with Python 3.
     *
     * ```
     * from base64 import b64encode
     * from nacl import encoding, public
     *
     * def encrypt(public_key: str, secret_value: str) -> str:
     *   """Encrypt a Unicode string using the public key."""
     *   public_key = public.PublicKey(public_key.encode("utf-8"), encoding.Base64Encoder())
     *   sealed_box = public.SealedBox(public_key)
     *   encrypted = sealed_box.encrypt(secret_value.encode("utf-8"))
     *   return b64encode(encrypted).decode("utf-8")
     * ```
     *
     * #### Example encrypting a secret using C#
     *
     * Encrypt your secret using the [Sodium.Core](https://www.nuget.org/packages/Sodium.Core/) package.
     *
     * ```
     * var secretValue = System.Text.Encoding.UTF8.GetBytes("mySecret");
     * var publicKey = Convert.FromBase64String("2Sg8iYjAxxmI2LvUXpJjkYrMxURPc8r+dB7TJyvvcCU=");
     *
     * var sealedPublicKeyBox = Sodium.SealedPublicKeyBox.Create(secretValue, publicKey);
     *
     * Console.WriteLine(Convert.ToBase64String(sealedPublicKeyBox));
     * ```
     *
     * #### Example encrypting a secret using Ruby
     *
     * Encrypt your secret using the [rbnacl](https://github.com/RubyCrypto/rbnacl) gem.
     *
     * ```ruby
     * require "rbnacl"
     * require "base64"
     *
     * key = Base64.decode64("+ZYvJDZMHUfBkJdyq5Zm9SKqeuBQ4sj+6sfjlH4CgG0=")
     * public_key = RbNaCl::PublicKey.new(key)
     *
     * box = RbNaCl::Boxes::Sealed.from_public_key(public_key)
     * encrypted_secret = box.encrypt("my_secret")
     *
     * # Print the base64 encoded secret
     * puts Base64.strict_encode64(encrypted_secret)
     * ```
     */
    put: operations["dependabot/create-or-update-org-secret"];
    /**
     * Delete an organization secret
     * @description Deletes a secret in an organization using the secret name.
     *
     * OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
     */
    delete: operations["dependabot/delete-org-secret"];
  };
  "/orgs/{org}/dependabot/secrets/{secret_name}/repositories": {
    /**
     * List selected repositories for an organization secret
     * @description Lists all repositories that have been selected when the `visibility`
     * for repository access to a secret is set to `selected`.
     *
     * OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
     */
    get: operations["dependabot/list-selected-repos-for-org-secret"];
    /**
     * Set selected repositories for an organization secret
     * @description Replaces all repositories for an organization secret when the `visibility`
     * for repository access is set to `selected`. The visibility is set when you [Create
     * or update an organization secret](https://docs.github.com/enterprise-server@3.10/rest/dependabot/secrets#create-or-update-an-organization-secret).
     *
     * OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
     */
    put: operations["dependabot/set-selected-repos-for-org-secret"];
  };
  "/orgs/{org}/dependabot/secrets/{secret_name}/repositories/{repository_id}": {
    /**
     * Add selected repository to an organization secret
     * @description Adds a repository to an organization secret when the `visibility` for
     * repository access is set to `selected`. The visibility is set when you [Create or
     * update an organization secret](https://docs.github.com/enterprise-server@3.10/rest/dependabot/secrets#create-or-update-an-organization-secret).
     *
     * OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
     */
    put: operations["dependabot/add-selected-repo-to-org-secret"];
    /**
     * Remove selected repository from an organization secret
     * @description Removes a repository from an organization secret when the `visibility`
     * for repository access is set to `selected`. The visibility is set when you [Create
     * or update an organization secret](https://docs.github.com/enterprise-server@3.10/rest/dependabot/secrets#create-or-update-an-organization-secret).
     *
     * OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
     */
    delete: operations["dependabot/remove-selected-repo-from-org-secret"];
  };
  "/orgs/{org}/docker/conflicts": {
    /**
     * Get list of conflicting packages during Docker migration for organization
     * @description Lists all packages that are in a specific organization, are readable by the requesting user, and that encountered a conflict during a Docker migration.
     *
     * OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint.
     */
    get: operations["packages/list-docker-migration-conflicting-packages-for-organization"];
  };
  "/orgs/{org}/events": {
    /** List public organization events */
    get: operations["activity/list-public-org-events"];
  };
  "/orgs/{org}/external-group/{group_id}": {
    /**
     * Get an external group
     * @description Displays information about the specific group's usage.  Provides a list of the group's external members as well as a list of teams that this group is connected to.
     *
     * You can manage team membership with your identity provider using Enterprise Managed Users for GitHub Enterprise Cloud. For more information, see "[GitHub's products](https://docs.github.com/enterprise-server@3.10/github/getting-started-with-github/githubs-products)" in the GitHub Help documentation.
     */
    get: operations["teams/external-idp-group-info-for-org"];
  };
  "/orgs/{org}/external-groups": {
    /**
     * List external groups in an organization
     * @description Lists external groups available in an organization. You can query the groups using the `display_name` parameter, only groups with a `group_name` containing the text provided in the `display_name` parameter will be returned.  You can also limit your page results using the `per_page` parameter. GitHub Enterprise Server generates a url-encoded `page` token using a cursor value for where the next page begins. For more information on cursor pagination, see "[Offset and Cursor Pagination explained](https://dev.to/jackmarchant/offset-and-cursor-pagination-explained-b89)."
     *
     * You can manage team membership with your identity provider using Enterprise Managed Users for GitHub Enterprise Cloud. For more information, see "[GitHub's products](https://docs.github.com/enterprise-server@3.10/github/getting-started-with-github/githubs-products)" in the GitHub Help documentation.
     */
    get: operations["teams/list-external-idp-groups-for-org"];
  };
  "/orgs/{org}/hooks": {
    /**
     * List organization webhooks
     * @description You must be an organization owner to use this endpoint.
     *
     * OAuth app tokens and personal access tokens (classic) need `admin:org_hook` scope. OAuth apps cannot list, view, or edit
     * webhooks that they did not create and users cannot list, view, or edit webhooks that were created by OAuth apps.
     */
    get: operations["orgs/list-webhooks"];
    /**
     * Create an organization webhook
     * @description Create a hook that posts payloads in JSON format.
     *
     * You must be an organization owner to use this endpoint.
     *
     * OAuth app tokens and personal access tokens (classic) need `admin:org_hook` scope. OAuth apps cannot list, view, or
     * edit webhooks that they did not create and users cannot list, view, or edit webhooks that were created by OAuth apps.
     */
    post: operations["orgs/create-webhook"];
  };
  "/orgs/{org}/hooks/{hook_id}": {
    /**
     * Get an organization webhook
     * @description Returns a webhook configured in an organization. To get only the webhook
     * `config` properties, see "[Get a webhook configuration for an organization](/rest/orgs/webhooks#get-a-webhook-configuration-for-an-organization).
     *
     * You must be an organization owner to use this endpoint.
     *
     * OAuth app tokens and personal access tokens (classic) need `admin:org_hook` scope. OAuth apps cannot list, view, or edit
     * webhooks that they did not create and users cannot list, view, or edit webhooks that were created by OAuth apps.
     */
    get: operations["orgs/get-webhook"];
    /**
     * Delete an organization webhook
     * @description You must be an organization owner to use this endpoint.
     *
     * OAuth app tokens and personal access tokens (classic) need `admin:org_hook` scope. OAuth apps cannot list, view, or edit
     * webhooks that they did not create and users cannot list, view, or edit webhooks that were created by OAuth apps.
     */
    delete: operations["orgs/delete-webhook"];
    /**
     * Update an organization webhook
     * @description Updates a webhook configured in an organization. When you update a webhook,
     * the `secret` will be overwritten. If you previously had a `secret` set, you must
     * provide the same `secret` or set a new `secret` or the secret will be removed. If
     * you are only updating individual webhook `config` properties, use "[Update a webhook
     * configuration for an organization](/rest/orgs/webhooks#update-a-webhook-configuration-for-an-organization)".
     *
     * You must be an organization owner to use this endpoint.
     *
     * OAuth app tokens and personal access tokens (classic) need `admin:org_hook` scope. OAuth apps cannot list, view, or edit
     * webhooks that they did not create and users cannot list, view, or edit webhooks that were created by OAuth apps.
     */
    patch: operations["orgs/update-webhook"];
  };
  "/orgs/{org}/hooks/{hook_id}/config": {
    /**
     * Get a webhook configuration for an organization
     * @description Returns the webhook configuration for an organization. To get more information about the webhook, including the `active` state and `events`, use "[Get an organization webhook ](/rest/orgs/webhooks#get-an-organization-webhook)."
     *
     * You must be an organization owner to use this endpoint.
     *
     * OAuth app tokens and personal access tokens (classic) need `admin:org_hook` scope. OAuth apps cannot list, view, or edit
     * webhooks that they did not create and users cannot list, view, or edit webhooks that were created by OAuth apps.
     */
    get: operations["orgs/get-webhook-config-for-org"];
    /**
     * Update a webhook configuration for an organization
     * @description Updates the webhook configuration for an organization. To update more information about the webhook, including the `active` state and `events`, use "[Update an organization webhook ](/rest/orgs/webhooks#update-an-organization-webhook)."
     *
     * You must be an organization owner to use this endpoint.
     *
     * OAuth app tokens and personal access tokens (classic) need `admin:org_hook` scope. OAuth apps cannot list, view, or edit
     * webhooks that they did not create and users cannot list, view, or edit webhooks that were created by OAuth apps.
     */
    patch: operations["orgs/update-webhook-config-for-org"];
  };
  "/orgs/{org}/hooks/{hook_id}/deliveries": {
    /**
     * List deliveries for an organization webhook
     * @description Returns a list of webhook deliveries for a webhook configured in an organization.
     *
     * You must be an organization owner to use this endpoint.
     *
     * OAuth app tokens and personal access tokens (classic) need `admin:org_hook` scope. OAuth apps cannot list, view, or edit
     * webhooks that they did not create and users cannot list, view, or edit webhooks that were created by OAuth apps.
     */
    get: operations["orgs/list-webhook-deliveries"];
  };
  "/orgs/{org}/hooks/{hook_id}/deliveries/{delivery_id}": {
    /**
     * Get a webhook delivery for an organization webhook
     * @description Returns a delivery for a webhook configured in an organization.
     *
     * You must be an organization owner to use this endpoint.
     *
     * OAuth app tokens and personal access tokens (classic) need `admin:org_hook` scope. OAuth apps cannot list, view, or edit
     * webhooks that they did not create and users cannot list, view, or edit webhooks that were created by OAuth apps.
     */
    get: operations["orgs/get-webhook-delivery"];
  };
  "/orgs/{org}/hooks/{hook_id}/deliveries/{delivery_id}/attempts": {
    /**
     * Redeliver a delivery for an organization webhook
     * @description Redeliver a delivery for a webhook configured in an organization.
     *
     * You must be an organization owner to use this endpoint.
     *
     * OAuth app tokens and personal access tokens (classic) need `admin:org_hook` scope. OAuth apps cannot list, view, or edit
     * webhooks that they did not create and users cannot list, view, or edit webhooks that were created by OAuth apps.
     */
    post: operations["orgs/redeliver-webhook-delivery"];
  };
  "/orgs/{org}/hooks/{hook_id}/pings": {
    /**
     * Ping an organization webhook
     * @description This will trigger a [ping event](https://docs.github.com/enterprise-server@3.10/webhooks/#ping-event)
     * to be sent to the hook.
     *
     * You must be an organization owner to use this endpoint.
     *
     * OAuth app tokens and personal access tokens (classic) need `admin:org_hook` scope. OAuth apps cannot list, view, or edit
     * webhooks that they did not create and users cannot list, view, or edit webhooks that were created by OAuth apps.
     */
    post: operations["orgs/ping-webhook"];
  };
  "/orgs/{org}/installation": {
    /**
     * Get an organization installation for the authenticated app
     * @description Enables an authenticated GitHub App to find the organization's installation information.
     *
     * You must use a [JWT](https://docs.github.com/enterprise-server@3.10/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
     */
    get: operations["apps/get-org-installation"];
  };
  "/orgs/{org}/installations": {
    /**
     * List app installations for an organization
     * @description Lists all GitHub Apps in an organization. The installation count includes
     * all GitHub Apps installed on repositories in the organization.
     *
     * The authenticated user must be an organization owner to use this endpoint.
     *
     * OAuth app tokens and personal access tokens (classic) need the `admin:read` scope to use this endpoint.
     */
    get: operations["orgs/list-app-installations"];
  };
  "/orgs/{org}/issues": {
    /**
     * List organization issues assigned to the authenticated user
     * @description List issues in an organization assigned to the authenticated user.
     *
     * **Note**: GitHub's REST API considers every pull request an issue, but not every issue is a pull request. For this
     * reason, "Issues" endpoints may return both issues and pull requests in the response. You can identify pull requests by
     * the `pull_request` key. Be aware that the `id` of a pull request returned from "Issues" endpoints will be an _issue id_. To find out the pull
     * request id, use the "[List pull requests](https://docs.github.com/enterprise-server@3.10/rest/pulls/pulls#list-pull-requests)" endpoint.
     *
     * This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/enterprise-server@3.10/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
     *
     * - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
     * - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
     * - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
     * - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
     */
    get: operations["issues/list-for-org"];
  };
  "/orgs/{org}/members": {
    /**
     * List organization members
     * @description List all users who are members of an organization. If the authenticated user is also a member of this organization then both concealed and public members will be returned.
     */
    get: operations["orgs/list-members"];
  };
  "/orgs/{org}/members/{username}": {
    /**
     * Check organization membership for a user
     * @description Check if a user is, publicly or privately, a member of the organization.
     */
    get: operations["orgs/check-membership-for-user"];
    /**
     * Remove an organization member
     * @description Removing a user from this list will remove them from all teams and they will no longer have any access to the organization's repositories.
     */
    delete: operations["orgs/remove-member"];
  };
  "/orgs/{org}/memberships/{username}": {
    /**
     * Get organization membership for a user
     * @description In order to get a user's membership with an organization, the authenticated user must be an organization member. The `state` parameter in the response can be used to identify the user's membership status.
     */
    get: operations["orgs/get-membership-for-user"];
    /**
     * Set organization membership for a user
     * @description Only authenticated organization owners can add a member to the organization or update the member's role.
     *
     * *   If the authenticated user is _adding_ a member to the organization, the invited user will receive an email inviting them to the organization. The user's [membership status](https://docs.github.com/enterprise-server@3.10/rest/orgs/members#get-organization-membership-for-a-user) will be `pending` until they accept the invitation.
     *
     * *   Authenticated users can _update_ a user's membership by passing the `role` parameter. If the authenticated user changes a member's role to `admin`, the affected user will receive an email notifying them that they've been made an organization owner. If the authenticated user changes an owner's role to `member`, no email will be sent.
     *
     * **Rate limits**
     *
     * To prevent abuse, the authenticated user is limited to 50 organization invitations per 24 hour period. If the organization is more than one month old or on a paid plan, the limit is 500 invitations per 24 hour period.
     */
    put: operations["orgs/set-membership-for-user"];
    /**
     * Remove organization membership for a user
     * @description In order to remove a user's membership with an organization, the authenticated user must be an organization owner.
     *
     * If the specified user is an active member of the organization, this will remove them from the organization. If the specified user has been invited to the organization, this will cancel their invitation. The specified user will receive an email notification in both cases.
     */
    delete: operations["orgs/remove-membership-for-user"];
  };
  "/orgs/{org}/migrations": {
    /**
     * List organization migrations
     * @description Lists the most recent migrations, including both exports (which can be started through the REST API) and imports (which cannot be started using the REST API).
     *
     * A list of `repositories` is only returned for export migrations.
     */
    get: operations["migrations/list-for-org"];
    /**
     * Start an organization migration
     * @description Initiates the generation of a migration archive.
     *
     * Before you can use this endpoint, you must configure a blob storage provider in the "Migrations" section in the Management Console. For more details, see "[Migrating repositories from GitHub Enterprise Server to GitHub Enterprise Cloud](https://docs.github.com/enterprise-server@3.10/migrations/using-github-enterprise-importer/migrating-repositories-with-github-enterprise-importer/migrating-repositories-from-github-enterprise-server-to-github-enterprise-cloud#step-4-set-up-blob-storage)."
     */
    post: operations["migrations/start-for-org"];
  };
  "/orgs/{org}/migrations/{migration_id}": {
    /**
     * Get an organization migration status
     * @description Fetches the status of a migration.
     *
     * The `state` of a migration can be one of the following values:
     *
     * *   `pending`, which means the migration hasn't started yet.
     * *   `exporting`, which means the migration is in progress.
     * *   `exported`, which means the migration finished successfully.
     * *   `failed`, which means the migration failed.
     */
    get: operations["migrations/get-status-for-org"];
  };
  "/orgs/{org}/migrations/{migration_id}/archive": {
    /**
     * Download an organization migration archive
     * @description Fetches the URL to a migration archive.
     */
    get: operations["migrations/download-archive-for-org"];
    /**
     * Delete an organization migration archive
     * @description Deletes a previous migration archive. Migration archives are automatically deleted after seven days.
     */
    delete: operations["migrations/delete-archive-for-org"];
  };
  "/orgs/{org}/migrations/{migration_id}/repos/{repo_name}/lock": {
    /**
     * Unlock an organization repository
     * @description Unlocks a repository that was locked for migration. You should unlock each migrated repository and [delete them](https://docs.github.com/enterprise-server@3.10/rest/repos/repos#delete-a-repository) when the migration is complete and you no longer need the source data.
     */
    delete: operations["migrations/unlock-repo-for-org"];
  };
  "/orgs/{org}/migrations/{migration_id}/repositories": {
    /**
     * List repositories in an organization migration
     * @description List all the repositories for this organization migration.
     */
    get: operations["migrations/list-repos-for-org"];
  };
  "/orgs/{org}/outside_collaborators": {
    /**
     * List outside collaborators for an organization
     * @description List all users who are outside collaborators of an organization.
     */
    get: operations["orgs/list-outside-collaborators"];
  };
  "/orgs/{org}/outside_collaborators/{username}": {
    /**
     * Convert an organization member to outside collaborator
     * @description When an organization member is converted to an outside collaborator, they'll only have access to the repositories that their current team membership allows. The user will no longer be a member of the organization. For more information, see "[Converting an organization member to an outside collaborator](https://docs.github.com/enterprise-server@3.10/articles/converting-an-organization-member-to-an-outside-collaborator/)". Converting an organization member to an outside collaborator may be restricted by enterprise administrators. For more information, see "[Enforcing repository management policies in your enterprise](https://docs.github.com/enterprise-server@3.10/admin/policies/enforcing-policies-for-your-enterprise/enforcing-repository-management-policies-in-your-enterprise#enforcing-a-policy-for-inviting-outside-collaborators-to-repositories)."
     */
    put: operations["orgs/convert-member-to-outside-collaborator"];
    /**
     * Remove outside collaborator from an organization
     * @description Removing a user from this list will remove them from all the organization's repositories.
     */
    delete: operations["orgs/remove-outside-collaborator"];
  };
  "/orgs/{org}/packages": {
    /**
     * List packages for an organization
     * @description Lists packages in an organization readable by the user.
     *
     * OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint. If the `package_type` belongs to a GitHub Packages registry that only supports repository-scoped permissions, the `repo` scope is also required. For the list of these registries, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-server@3.10/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
     */
    get: operations["packages/list-packages-for-organization"];
  };
  "/orgs/{org}/packages/{package_type}/{package_name}": {
    /**
     * Get a package for an organization
     * @description Gets a specific package in an organization.
     *
     * OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint. If the `package_type` belongs to a GitHub Packages registry that only supports repository-scoped permissions, the `repo` scope is also required. For the list of these registries, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-server@3.10/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
     */
    get: operations["packages/get-package-for-organization"];
    /**
     * Delete a package for an organization
     * @description Deletes an entire package in an organization. You cannot delete a public package if any version of the package has more than 5,000 downloads. In this scenario, contact GitHub support for further assistance.
     *
     * The authenticated user must have admin permissions in the organization to use this endpoint. If the `package_type` belongs to a GitHub Packages registry that supports granular permissions, the authenticated user must also have admin permissions to the package. For the list of these registries, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-server@3.10/packages/learn-github-packages/about-permissions-for-github-packages#granular-permissions-for-userorganization-scoped-packages)."
     *
     * OAuth app tokens and personal access tokens (classic) need the `read:packages` and `delete:packages` scopes to use this endpoint. If the `package_type` belongs to a GitHub Packages registry that only supports repository-scoped permissions, the `repo` scope is also required. For the list of these registries, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-server@3.10/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
     */
    delete: operations["packages/delete-package-for-org"];
  };
  "/orgs/{org}/packages/{package_type}/{package_name}/restore": {
    /**
     * Restore a package for an organization
     * @description Restores an entire package in an organization.
     *
     * You can restore a deleted package under the following conditions:
     *   - The package was deleted within the last 30 days.
     *   - The same package namespace and version is still available and not reused for a new package. If the same package namespace is not available, you will not be able to restore your package. In this scenario, to restore the deleted package, you must delete the new package that uses the deleted package's namespace first.
     *
     * The authenticated user must have admin permissions in the organization to use this endpoint. If the `package_type` belongs to a GitHub Packages registry that supports granular permissions, the authenticated user must also have admin permissions to the package. For the list of these registries, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-server@3.10/packages/learn-github-packages/about-permissions-for-github-packages#granular-permissions-for-userorganization-scoped-packages)."
     *
     * OAuth app tokens and personal access tokens (classic) need the `read:packages` and `write:packages` scopes to use this endpoint. If the `package_type` belongs to a GitHub Packages registry that only supports repository-scoped permissions, the `repo` scope is also required. For the list of these registries, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-server@3.10/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
     */
    post: operations["packages/restore-package-for-org"];
  };
  "/orgs/{org}/packages/{package_type}/{package_name}/versions": {
    /**
     * List package versions for a package owned by an organization
     * @description Lists package versions for a package owned by an organization.
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint if the `package_type` belongs to a GitHub Packages registry that only supports repository-scoped permissions. For the list of these registries, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-server@3.10/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
     */
    get: operations["packages/get-all-package-versions-for-package-owned-by-org"];
  };
  "/orgs/{org}/packages/{package_type}/{package_name}/versions/{package_version_id}": {
    /**
     * Get a package version for an organization
     * @description Gets a specific package version in an organization.
     *
     * OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint. If the `package_type` belongs to a GitHub Packages registry that only supports repository-scoped permissions, the `repo` scope is also required. For the list of these registries, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-server@3.10/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
     */
    get: operations["packages/get-package-version-for-organization"];
    /**
     * Delete package version for an organization
     * @description Deletes a specific package version in an organization. If the package is public and the package version has more than 5,000 downloads, you cannot delete the package version. In this scenario, contact GitHub support for further assistance.
     *
     * The authenticated user must have admin permissions in the organization to use this endpoint. If the `package_type` belongs to a GitHub Packages registry that supports granular permissions, the authenticated user must also have admin permissions to the package. For the list of these registries, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-server@3.10/packages/learn-github-packages/about-permissions-for-github-packages#granular-permissions-for-userorganization-scoped-packages)."
     *
     * OAuth app tokens and personal access tokens (classic) need the `read:packages` and `delete:packages` scopes to use this endpoint. If the `package_type` belongs to a GitHub Packages registry that only supports repository-scoped permissions, the `repo` scope is also required. For the list of these registries, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-server@3.10/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
     */
    delete: operations["packages/delete-package-version-for-org"];
  };
  "/orgs/{org}/packages/{package_type}/{package_name}/versions/{package_version_id}/restore": {
    /**
     * Restore package version for an organization
     * @description Restores a specific package version in an organization.
     *
     * You can restore a deleted package under the following conditions:
     *   - The package was deleted within the last 30 days.
     *   - The same package namespace and version is still available and not reused for a new package. If the same package namespace is not available, you will not be able to restore your package. In this scenario, to restore the deleted package, you must delete the new package that uses the deleted package's namespace first.
     *
     * The authenticated user must have admin permissions in the organization to use this endpoint. If the `package_type` belongs to a GitHub Packages registry that supports granular permissions, the authenticated user must also have admin permissions to the package. For the list of these registries, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-server@3.10/packages/learn-github-packages/about-permissions-for-github-packages#granular-permissions-for-userorganization-scoped-packages)."
     *
     * OAuth app tokens and personal access tokens (classic) need the `read:packages` and `write:packages` scopes to use this endpoint. If the `package_type` belongs to a GitHub Packages registry that only supports repository-scoped permissions, the `repo` scope is also required. For the list of these registries, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-server@3.10/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
     */
    post: operations["packages/restore-package-version-for-org"];
  };
  "/orgs/{org}/personal-access-token-requests": {
    /**
     * List requests to access organization resources with fine-grained personal access tokens
     * @description Lists requests from organization members to access organization resources with a fine-grained personal access token.
     *
     * Only GitHub Apps can use this endpoint.
     */
    get: operations["orgs/list-pat-grant-requests"];
    /**
     * Review requests to access organization resources with fine-grained personal access tokens
     * @description Approves or denies multiple pending requests to access organization resources via a fine-grained personal access token.
     *
     * Only GitHub Apps can use this endpoint.
     */
    post: operations["orgs/review-pat-grant-requests-in-bulk"];
  };
  "/orgs/{org}/personal-access-token-requests/{pat_request_id}": {
    /**
     * Review a request to access organization resources with a fine-grained personal access token
     * @description Approves or denies a pending request to access organization resources via a fine-grained personal access token.
     *
     * Only GitHub Apps can use this endpoint.
     */
    post: operations["orgs/review-pat-grant-request"];
  };
  "/orgs/{org}/personal-access-token-requests/{pat_request_id}/repositories": {
    /**
     * List repositories requested to be accessed by a fine-grained personal access token
     * @description Lists the repositories a fine-grained personal access token request is requesting access to.
     *
     * Only GitHub Apps can use this endpoint.
     */
    get: operations["orgs/list-pat-grant-request-repositories"];
  };
  "/orgs/{org}/personal-access-tokens": {
    /**
     * List fine-grained personal access tokens with access to organization resources
     * @description Lists approved fine-grained personal access tokens owned by organization members that can access organization resources.
     *
     * Only GitHub Apps can use this endpoint.
     */
    get: operations["orgs/list-pat-grants"];
    /**
     * Update the access to organization resources via fine-grained personal access tokens
     * @description Updates the access organization members have to organization resources via fine-grained personal access tokens. Limited to revoking a token's existing access.
     *
     * Only GitHub Apps can use this endpoint.
     */
    post: operations["orgs/update-pat-accesses"];
  };
  "/orgs/{org}/personal-access-tokens/{pat_id}": {
    /**
     * Update the access a fine-grained personal access token has to organization resources
     * @description Updates the access an organization member has to organization resources via a fine-grained personal access token. Limited to revoking the token's existing access. Limited to revoking a token's existing access.
     *
     * Only GitHub Apps can use this endpoint.
     */
    post: operations["orgs/update-pat-access"];
  };
  "/orgs/{org}/personal-access-tokens/{pat_id}/repositories": {
    /**
     * List repositories a fine-grained personal access token has access to
     * @description Lists the repositories a fine-grained personal access token has access to.
     *
     * Only GitHub Apps can use this endpoint.
     */
    get: operations["orgs/list-pat-grant-repositories"];
  };
  "/orgs/{org}/pre-receive-hooks": {
    /**
     * List pre-receive hooks for an organization
     * @description List all pre-receive hooks that are enabled or testing for this organization as well as any disabled hooks that can be configured at the organization level. Globally disabled pre-receive hooks that do not allow downstream configuration are not listed.
     */
    get: operations["enterprise-admin/list-pre-receive-hooks-for-org"];
  };
  "/orgs/{org}/pre-receive-hooks/{pre_receive_hook_id}": {
    /** Get a pre-receive hook for an organization */
    get: operations["enterprise-admin/get-pre-receive-hook-for-org"];
    /**
     * Remove pre-receive hook enforcement for an organization
     * @description Removes any overrides for this hook at the org level for this org.
     */
    delete: operations["enterprise-admin/remove-pre-receive-hook-enforcement-for-org"];
    /**
     * Update pre-receive hook enforcement for an organization
     * @description For pre-receive hooks which are allowed to be configured at the org level, you can set `enforcement` and `allow_downstream_configuration`
     */
    patch: operations["enterprise-admin/update-pre-receive-hook-enforcement-for-org"];
  };
  "/orgs/{org}/projects": {
    /**
     * List organization projects
     * @description Lists the projects in an organization. Returns a `404 Not Found` status if projects are disabled in the organization. If you do not have sufficient privileges to perform this action, a `401 Unauthorized` or `410 Gone` status is returned.
     */
    get: operations["projects/list-for-org"];
    /**
     * Create an organization project
     * @description Creates an organization project board. Returns a `410 Gone` status if projects are disabled in the organization or if the organization does not have existing classic projects. If you do not have sufficient privileges to perform this action, a `401 Unauthorized` or `410 Gone` status is returned.
     */
    post: operations["projects/create-for-org"];
  };
  "/orgs/{org}/public_members": {
    /**
     * List public organization members
     * @description Members of an organization can choose to have their membership publicized or not.
     */
    get: operations["orgs/list-public-members"];
  };
  "/orgs/{org}/public_members/{username}": {
    /**
     * Check public organization membership for a user
     * @description Check if the provided user is a public member of the organization.
     */
    get: operations["orgs/check-public-membership-for-user"];
    /**
     * Set public organization membership for the authenticated user
     * @description The user can publicize their own membership. (A user cannot publicize the membership for another user.)
     *
     * Note that you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP method](https://docs.github.com/enterprise-server@3.10/rest/guides/getting-started-with-the-rest-api#http-method)."
     */
    put: operations["orgs/set-public-membership-for-authenticated-user"];
    /**
     * Remove public organization membership for the authenticated user
     * @description Removes the public membership for the authenticated user from the specified organization, unless public visibility is enforced by default.
     */
    delete: operations["orgs/remove-public-membership-for-authenticated-user"];
  };
  "/orgs/{org}/repos": {
    /**
     * List organization repositories
     * @description Lists repositories for the specified organization.
     *
     * **Note:** In order to see the `security_and_analysis` block for a repository you must have admin permissions for the repository or be an owner or security manager for the organization that owns the repository. For more information, see "[Managing security managers in your organization](https://docs.github.com/enterprise-server@3.10/organizations/managing-peoples-access-to-your-organization-with-roles/managing-security-managers-in-your-organization)."
     */
    get: operations["repos/list-for-org"];
    /**
     * Create an organization repository
     * @description Creates a new repository in the specified organization. The authenticated user must be a member of the organization.
     *
     * OAuth app tokens and personal access tokens (classic) need the `public_repo` or `repo` scope to create a public repository, and `repo` scope to create a private repository.
     */
    post: operations["repos/create-in-org"];
  };
  "/orgs/{org}/repository-fine-grained-permissions": {
    /**
     * List repository fine-grained permissions for an organization
     * @description Lists the fine-grained permissions that can be used in custom repository roles for an organization. For more information, see "[About custom repository roles](https://docs.github.com/enterprise-server@3.10/organizations/managing-peoples-access-to-your-organization-with-roles/about-custom-repository-roles)."
     *
     * The authenticated user must be an administrator of the organization or of a repository of the organization to use this endpoint.
     *
     * OAuth app tokens and personal access tokens (classic) need the `admin:org` or `repo` scope to use this endpoint.
     */
    get: operations["orgs/list-repo-fine-grained-permissions"];
  };
  "/orgs/{org}/secret-scanning/alerts": {
    /**
     * List secret scanning alerts for an organization
     * @description Lists secret scanning alerts for eligible repositories in an organization, from newest to oldest.
     *
     * The authenticated user must be an administrator or security manager for the organization to use this endpoint.
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` or `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.
     */
    get: operations["secret-scanning/list-alerts-for-org"];
  };
  "/orgs/{org}/security-managers": {
    /**
     * List security manager teams
     * @description Lists teams that are security managers for an organization. For more information, see "[Managing security managers in your organization](https://docs.github.com/enterprise-server@3.10/organizations/managing-peoples-access-to-your-organization-with-roles/managing-security-managers-in-your-organization)."
     *
     * The authenticated user must be an administrator or security manager for the organization to use this endpoint.
     *
     * OAuth app tokens and personal access tokens (classic) need the `read:org` scope to use this endpoint.
     */
    get: operations["orgs/list-security-manager-teams"];
  };
  "/orgs/{org}/security-managers/teams/{team_slug}": {
    /**
     * Add a security manager team
     * @description Adds a team as a security manager for an organization. For more information, see "[Managing security for an organization](https://docs.github.com/enterprise-server@3.10/organizations/managing-peoples-access-to-your-organization-with-roles/managing-security-managers-in-your-organization) for an organization."
     *
     * The authenticated user must be an administrator for the organization to use this endpoint.
     *
     * OAuth app tokens and personal access tokens (classic) need the `write:org` scope to use this endpoint.
     */
    put: operations["orgs/add-security-manager-team"];
    /**
     * Remove a security manager team
     * @description Removes the security manager role from a team for an organization. For more information, see "[Managing security managers in your organization](https://docs.github.com/enterprise-server@3.10/organizations/managing-peoples-access-to-your-organization-with-roles/managing-security-managers-in-your-organization) team from an organization."
     *
     * The authenticated user must be an administrator for the organization to use this endpoint.
     *
     * OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
     */
    delete: operations["orgs/remove-security-manager-team"];
  };
  "/orgs/{org}/settings/billing/advanced-security": {
    /**
     * Get GitHub Advanced Security active committers for an organization
     * @description Gets the GitHub Advanced Security active committers for an organization per repository.
     *
     * Each distinct user login across all repositories is counted as a single Advanced Security seat, so the `total_advanced_security_committers` is not the sum of advanced_security_committers for each repository.
     *
     * If this organization defers to an enterprise for billing, the `total_advanced_security_committers` returned from the organization API may include some users that are in more than one organization, so they will only consume a single Advanced Security seat at the enterprise level.
     *
     * The total number of repositories with committer information is tracked by the `total_count` field.
     */
    get: operations["billing/get-github-advanced-security-billing-org"];
  };
  "/orgs/{org}/teams": {
    /**
     * List teams
     * @description Lists all teams in an organization that are visible to the authenticated user.
     */
    get: operations["teams/list"];
    /**
     * Create a team
     * @description To create a team, the authenticated user must be a member or owner of `{org}`. By default, organization members can create teams. Organization owners can limit team creation to organization owners. For more information, see "[Setting team creation permissions](https://docs.github.com/enterprise-server@3.10/articles/setting-team-creation-permissions-in-your-organization)."
     *
     * When you create a new team, you automatically become a team maintainer without explicitly adding yourself to the optional array of `maintainers`. For more information, see "[About teams](https://docs.github.com/enterprise-server@3.10/github/setting-up-and-managing-organizations-and-teams/about-teams)".
     */
    post: operations["teams/create"];
  };
  "/orgs/{org}/teams/{team_slug}": {
    /**
     * Get a team by name
     * @description Gets a team using the team's `slug`. To create the `slug`, GitHub Enterprise Server replaces special characters in the `name` string, changes all words to lowercase, and replaces spaces with a `-` separator. For example, `"My TEam Näme"` would become `my-team-name`.
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}`.
     */
    get: operations["teams/get-by-name"];
    /**
     * Delete a team
     * @description To delete a team, the authenticated user must be an organization owner or team maintainer.
     *
     * If you are an organization owner, deleting a parent team will delete all of its child teams as well.
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `DELETE /organizations/{org_id}/team/{team_id}`.
     */
    delete: operations["teams/delete-in-org"];
    /**
     * Update a team
     * @description To edit a team, the authenticated user must either be an organization owner or a team maintainer.
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `PATCH /organizations/{org_id}/team/{team_id}`.
     */
    patch: operations["teams/update-in-org"];
  };
  "/orgs/{org}/teams/{team_slug}/discussions": {
    /**
     * List discussions
     * @description List all discussions on a team's page.
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/discussions`.
     *
     * OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.
     */
    get: operations["teams/list-discussions-in-org"];
    /**
     * Create a discussion
     * @description Creates a new discussion post on a team's page.
     *
     * This endpoint triggers [notifications](https://docs.github.com/enterprise-server@3.10/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/enterprise-server@3.10/rest/overview/rate-limits-for-the-rest-api#about-secondary-rate-limits)" and "[Best practices for using the REST API](https://docs.github.com/enterprise-server@3.10/rest/guides/best-practices-for-using-the-rest-api)."
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `POST /organizations/{org_id}/team/{team_id}/discussions`.
     *
     * OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
     */
    post: operations["teams/create-discussion-in-org"];
  };
  "/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}": {
    /**
     * Get a discussion
     * @description Get a specific discussion on a team's page.
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}`.
     *
     * OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.
     */
    get: operations["teams/get-discussion-in-org"];
    /**
     * Delete a discussion
     * @description Delete a discussion from a team's page.
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `DELETE /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}`.
     *
     * OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
     */
    delete: operations["teams/delete-discussion-in-org"];
    /**
     * Update a discussion
     * @description Edits the title and body text of a discussion post. Only the parameters you provide are updated.
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `PATCH /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}`.
     *
     * OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
     */
    patch: operations["teams/update-discussion-in-org"];
  };
  "/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments": {
    /**
     * List discussion comments
     * @description List all comments on a team discussion.
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}/comments`.
     *
     * OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.
     */
    get: operations["teams/list-discussion-comments-in-org"];
    /**
     * Create a discussion comment
     * @description Creates a new comment on a team discussion.
     *
     * This endpoint triggers [notifications](https://docs.github.com/enterprise-server@3.10/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/enterprise-server@3.10/rest/overview/rate-limits-for-the-rest-api#about-secondary-rate-limits)" and "[Best practices for using the REST API](https://docs.github.com/enterprise-server@3.10/rest/guides/best-practices-for-using-the-rest-api)."
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `POST /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}/comments`.
     *
     * OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
     */
    post: operations["teams/create-discussion-comment-in-org"];
  };
  "/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}": {
    /**
     * Get a discussion comment
     * @description Get a specific comment on a team discussion.
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}/comments/{comment_number}`.
     *
     * OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.
     */
    get: operations["teams/get-discussion-comment-in-org"];
    /**
     * Delete a discussion comment
     * @description Deletes a comment on a team discussion.
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `DELETE /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}/comments/{comment_number}`.
     *
     * OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
     */
    delete: operations["teams/delete-discussion-comment-in-org"];
    /**
     * Update a discussion comment
     * @description Edits the body text of a discussion comment.
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `PATCH /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}/comments/{comment_number}`.
     *
     * OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
     */
    patch: operations["teams/update-discussion-comment-in-org"];
  };
  "/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions": {
    /**
     * List reactions for a team discussion comment
     * @description List the reactions to a [team discussion comment](https://docs.github.com/enterprise-server@3.10/rest/teams/discussion-comments#get-a-discussion-comment).
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/:org_id/team/:team_id/discussions/:discussion_number/comments/:comment_number/reactions`.
     *
     * OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.
     */
    get: operations["reactions/list-for-team-discussion-comment-in-org"];
    /**
     * Create reaction for a team discussion comment
     * @description Create a reaction to a [team discussion comment](https://docs.github.com/enterprise-server@3.10/rest/teams/discussion-comments#get-a-discussion-comment).
     *
     * A response with an HTTP `200` status means that you already added the reaction type to this team discussion comment.
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `POST /organizations/:org_id/team/:team_id/discussions/:discussion_number/comments/:comment_number/reactions`.
     *
     * OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
     */
    post: operations["reactions/create-for-team-discussion-comment-in-org"];
  };
  "/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions/{reaction_id}": {
    /**
     * Delete team discussion comment reaction
     * @description **Note:** You can also specify a team or organization with `team_id` and `org_id` using the route `DELETE /organizations/:org_id/team/:team_id/discussions/:discussion_number/comments/:comment_number/reactions/:reaction_id`.
     *
     * Delete a reaction to a [team discussion comment](https://docs.github.com/enterprise-server@3.10/rest/teams/discussion-comments#get-a-discussion-comment).
     *
     * OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
     */
    delete: operations["reactions/delete-for-team-discussion-comment"];
  };
  "/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions": {
    /**
     * List reactions for a team discussion
     * @description List the reactions to a [team discussion](https://docs.github.com/enterprise-server@3.10/rest/teams/discussions#get-a-discussion).
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/:org_id/team/:team_id/discussions/:discussion_number/reactions`.
     *
     * OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.
     */
    get: operations["reactions/list-for-team-discussion-in-org"];
    /**
     * Create reaction for a team discussion
     * @description Create a reaction to a [team discussion](https://docs.github.com/enterprise-server@3.10/rest/teams/discussions#get-a-discussion).
     *
     * A response with an HTTP `200` status means that you already added the reaction type to this team discussion.
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `POST /organizations/:org_id/team/:team_id/discussions/:discussion_number/reactions`.
     *
     * OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
     */
    post: operations["reactions/create-for-team-discussion-in-org"];
  };
  "/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions/{reaction_id}": {
    /**
     * Delete team discussion reaction
     * @description **Note:** You can also specify a team or organization with `team_id` and `org_id` using the route `DELETE /organizations/:org_id/team/:team_id/discussions/:discussion_number/reactions/:reaction_id`.
     *
     * Delete a reaction to a [team discussion](https://docs.github.com/enterprise-server@3.10/rest/teams/discussions#get-a-discussion).
     *
     * OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
     */
    delete: operations["reactions/delete-for-team-discussion"];
  };
  "/orgs/{org}/teams/{team_slug}/external-groups": {
    /**
     * List a connection between an external group and a team
     * @description Lists a connection between a team and an external group.
     *
     * You can manage team membership with your identity provider using Enterprise Managed Users for GitHub Enterprise Cloud. For more information, see "[GitHub's products](https://docs.github.com/enterprise-server@3.10/github/getting-started-with-github/githubs-products)" in the GitHub Help documentation.
     */
    get: operations["teams/list-linked-external-idp-groups-to-team-for-org"];
    /**
     * Remove the connection between an external group and a team
     * @description Deletes a connection between a team and an external group.
     *
     * You can manage team membership with your IdP using Enterprise Managed Users for GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/enterprise-server@3.10/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     */
    delete: operations["teams/unlink-external-idp-group-from-team-for-org"];
    /**
     * Update the connection between an external group and a team
     * @description Creates a connection between a team and an external group.  Only one external group can be linked to a team.
     *
     * You can manage team membership with your identity provider using Enterprise Managed Users for GitHub Enterprise Cloud. For more information, see "[GitHub's products](https://docs.github.com/enterprise-server@3.10/github/getting-started-with-github/githubs-products)" in the GitHub Help documentation.
     */
    patch: operations["teams/link-external-idp-group-to-team-for-org"];
  };
  "/orgs/{org}/teams/{team_slug}/members": {
    /**
     * List team members
     * @description Team members will include the members of child teams.
     *
     * To list members in a team, the team must be visible to the authenticated user.
     */
    get: operations["teams/list-members-in-org"];
  };
  "/orgs/{org}/teams/{team_slug}/memberships/{username}": {
    /**
     * Get team membership for a user
     * @description Team members will include the members of child teams.
     *
     * To get a user's membership with a team, the team must be visible to the authenticated user.
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/memberships/{username}`.
     *
     * **Note:**
     * The response contains the `state` of the membership and the member's `role`.
     *
     * The `role` for organization owners is set to `maintainer`. For more information about `maintainer` roles, see [Create a team](https://docs.github.com/enterprise-server@3.10/rest/teams/teams#create-a-team).
     */
    get: operations["teams/get-membership-for-user-in-org"];
    /**
     * Add or update team membership for a user
     * @description Adds an organization member to a team. An authenticated organization owner or team maintainer can add organization members to a team.
     *
     * Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/enterprise-server@3.10/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * **Note:** When you have team synchronization set up for a team with your organization's identity provider (IdP), you will see an error if you attempt to use the API for making changes to the team's membership. If you have access to manage group membership in your IdP, you can manage GitHub Enterprise Server team membership through your identity provider, which automatically adds and removes team members in an organization. For more information, see "[Synchronizing teams between your identity provider and GitHub Enterprise Server](https://docs.github.com/enterprise-server@3.10/articles/synchronizing-teams-between-your-identity-provider-and-github/)."
     *
     * An organization owner can add someone who is not part of the team's organization to a team. When an organization owner adds someone to a team who is not an organization member, this endpoint will send an invitation to the person via email. This newly-created membership will be in the "pending" state until the person accepts the invitation, at which point the membership will transition to the "active" state and the user will be added as a member of the team.
     *
     * If the user is already a member of the team, this endpoint will update the role of the team member's role. To update the membership of a team member, the authenticated user must be an organization owner or a team maintainer.
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `PUT /organizations/{org_id}/team/{team_id}/memberships/{username}`.
     */
    put: operations["teams/add-or-update-membership-for-user-in-org"];
    /**
     * Remove team membership for a user
     * @description To remove a membership between a user and a team, the authenticated user must have 'admin' permissions to the team or be an owner of the organization that the team is associated with. Removing team membership does not delete the user, it just removes their membership from the team.
     *
     * Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/enterprise-server@3.10/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * **Note:** When you have team synchronization set up for a team with your organization's identity provider (IdP), you will see an error if you attempt to use the API for making changes to the team's membership. If you have access to manage group membership in your IdP, you can manage GitHub Enterprise Server team membership through your identity provider, which automatically adds and removes team members in an organization. For more information, see "[Synchronizing teams between your identity provider and GitHub Enterprise Server](https://docs.github.com/enterprise-server@3.10/articles/synchronizing-teams-between-your-identity-provider-and-github/)."
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `DELETE /organizations/{org_id}/team/{team_id}/memberships/{username}`.
     */
    delete: operations["teams/remove-membership-for-user-in-org"];
  };
  "/orgs/{org}/teams/{team_slug}/projects": {
    /**
     * List team projects
     * @description Lists the organization projects for a team.
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/projects`.
     */
    get: operations["teams/list-projects-in-org"];
  };
  "/orgs/{org}/teams/{team_slug}/projects/{project_id}": {
    /**
     * Check team permissions for a project
     * @description Checks whether a team has `read`, `write`, or `admin` permissions for an organization project. The response includes projects inherited from a parent team.
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/projects/{project_id}`.
     */
    get: operations["teams/check-permissions-for-project-in-org"];
    /**
     * Add or update team project permissions
     * @description Adds an organization project to a team. To add a project to a team or update the team's permission on a project, the authenticated user must have `admin` permissions for the project. The project and team must be part of the same organization.
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `PUT /organizations/{org_id}/team/{team_id}/projects/{project_id}`.
     */
    put: operations["teams/add-or-update-project-permissions-in-org"];
    /**
     * Remove a project from a team
     * @description Removes an organization project from a team. An organization owner or a team maintainer can remove any project from the team. To remove a project from a team as an organization member, the authenticated user must have `read` access to both the team and project, or `admin` access to the team or project. This endpoint removes the project from the team, but does not delete the project.
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `DELETE /organizations/{org_id}/team/{team_id}/projects/{project_id}`.
     */
    delete: operations["teams/remove-project-in-org"];
  };
  "/orgs/{org}/teams/{team_slug}/repos": {
    /**
     * List team repositories
     * @description Lists a team's repositories visible to the authenticated user.
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/repos`.
     */
    get: operations["teams/list-repos-in-org"];
  };
  "/orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}": {
    /**
     * Check team permissions for a repository
     * @description Checks whether a team has `admin`, `push`, `maintain`, `triage`, or `pull` permission for a repository. Repositories inherited through a parent team will also be checked.
     *
     * You can also get information about the specified repository, including what permissions the team grants on it, by passing the following custom [media type](https://docs.github.com/enterprise-server@3.10/rest/overview/media-types/) via the `application/vnd.github.v3.repository+json` accept header.
     *
     * If a team doesn't have permission for the repository, you will receive a `404 Not Found` response status.
     *
     * If the repository is private, you must have at least `read` permission for that repository, and your token must have the `repo` or `admin:org` scope. Otherwise, you will receive a `404 Not Found` response status.
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/repos/{owner}/{repo}`.
     */
    get: operations["teams/check-permissions-for-repo-in-org"];
    /**
     * Add or update team repository permissions
     * @description To add a repository to a team or update the team's permission on a repository, the authenticated user must have admin access to the repository, and must be able to see the team. The repository must be owned by the organization, or a direct fork of a repository owned by the organization. You will get a `422 Unprocessable Entity` status if you attempt to add a repository to a team that is not owned by the organization. Note that, if you choose not to pass any parameters, you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP method](https://docs.github.com/enterprise-server@3.10/rest/guides/getting-started-with-the-rest-api#http-method)."
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `PUT /organizations/{org_id}/team/{team_id}/repos/{owner}/{repo}`.
     *
     * For more information about the permission levels, see "[Repository permission levels for an organization](https://docs.github.com/enterprise-server@3.10/github/setting-up-and-managing-organizations-and-teams/repository-permission-levels-for-an-organization#permission-levels-for-repositories-owned-by-an-organization)".
     */
    put: operations["teams/add-or-update-repo-permissions-in-org"];
    /**
     * Remove a repository from a team
     * @description If the authenticated user is an organization owner or a team maintainer, they can remove any repositories from the team. To remove a repository from a team as an organization member, the authenticated user must have admin access to the repository and must be able to see the team. This does not delete the repository, it just removes it from the team.
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `DELETE /organizations/{org_id}/team/{team_id}/repos/{owner}/{repo}`.
     */
    delete: operations["teams/remove-repo-in-org"];
  };
  "/orgs/{org}/teams/{team_slug}/teams": {
    /**
     * List child teams
     * @description Lists the child teams of the team specified by `{team_slug}`.
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/teams`.
     */
    get: operations["teams/list-child-in-org"];
  };
  "/orgs/{org}/{security_product}/{enablement}": {
    /**
     * Enable or disable a security feature for an organization
     * @description Enables or disables the specified security feature for all eligible repositories in an organization. For more information, see "[Managing security managers in your organization](https://docs.github.com/enterprise-server@3.10/organizations/managing-peoples-access-to-your-organization-with-roles/managing-security-managers-in-your-organization)."
     *
     * The authenticated user must be an organization owner or be member of a team with the security manager role to use this endpoint.
     *
     * OAuth app tokens and personal access tokens (classic) need the `write:org` scope to use this endpoint.
     */
    post: operations["orgs/enable-or-disable-security-product-on-all-org-repos"];
  };
  "/projects/columns/cards/{card_id}": {
    /**
     * Get a project card
     * @description Gets information about a project card.
     */
    get: operations["projects/get-card"];
    /**
     * Delete a project card
     * @description Deletes a project card
     */
    delete: operations["projects/delete-card"];
    /** Update an existing project card */
    patch: operations["projects/update-card"];
  };
  "/projects/columns/cards/{card_id}/moves": {
    /** Move a project card */
    post: operations["projects/move-card"];
  };
  "/projects/columns/{column_id}": {
    /**
     * Get a project column
     * @description Gets information about a project column.
     */
    get: operations["projects/get-column"];
    /**
     * Delete a project column
     * @description Deletes a project column.
     */
    delete: operations["projects/delete-column"];
    /** Update an existing project column */
    patch: operations["projects/update-column"];
  };
  "/projects/columns/{column_id}/cards": {
    /**
     * List project cards
     * @description Lists the project cards in a project.
     */
    get: operations["projects/list-cards"];
    /** Create a project card */
    post: operations["projects/create-card"];
  };
  "/projects/columns/{column_id}/moves": {
    /** Move a project column */
    post: operations["projects/move-column"];
  };
  "/projects/{project_id}": {
    /**
     * Get a project
     * @description Gets a project by its `id`. Returns a `404 Not Found` status if projects are disabled. If you do not have sufficient privileges to perform this action, a `401 Unauthorized` or `410 Gone` status is returned.
     */
    get: operations["projects/get"];
    /**
     * Delete a project
     * @description Deletes a project board. Returns a `404 Not Found` status if projects are disabled.
     */
    delete: operations["projects/delete"];
    /**
     * Update a project
     * @description Updates a project board's information. Returns a `404 Not Found` status if projects are disabled. If you do not have sufficient privileges to perform this action, a `401 Unauthorized` or `410 Gone` status is returned.
     */
    patch: operations["projects/update"];
  };
  "/projects/{project_id}/collaborators": {
    /**
     * List project collaborators
     * @description Lists the collaborators for an organization project. For a project, the list of collaborators includes outside collaborators, organization members that are direct collaborators, organization members with access through team memberships, organization members with access through default organization permissions, and organization owners. You must be an organization owner or a project `admin` to list collaborators.
     */
    get: operations["projects/list-collaborators"];
  };
  "/projects/{project_id}/collaborators/{username}": {
    /**
     * Add project collaborator
     * @description Adds a collaborator to an organization project and sets their permission level. You must be an organization owner or a project `admin` to add a collaborator.
     */
    put: operations["projects/add-collaborator"];
    /**
     * Remove user as a collaborator
     * @description Removes a collaborator from an organization project. You must be an organization owner or a project `admin` to remove a collaborator.
     */
    delete: operations["projects/remove-collaborator"];
  };
  "/projects/{project_id}/collaborators/{username}/permission": {
    /**
     * Get project permission for a user
     * @description Returns the collaborator's permission level for an organization project. Possible values for the `permission` key: `admin`, `write`, `read`, `none`. You must be an organization owner or a project `admin` to review a user's permission level.
     */
    get: operations["projects/get-permission-for-user"];
  };
  "/projects/{project_id}/columns": {
    /**
     * List project columns
     * @description Lists the project columns in a project.
     */
    get: operations["projects/list-columns"];
    /**
     * Create a project column
     * @description Creates a new project column.
     */
    post: operations["projects/create-column"];
  };
  "/rate_limit": {
    /**
     * Get rate limit status for the authenticated user
     * @description **Note:** Accessing this endpoint does not count against your REST API rate limit.
     *
     * Some categories of endpoints have custom rate limits that are separate from the rate limit governing the other REST API endpoints. For this reason, the API response categorizes your rate limit. Under `resources`, you'll see objects relating to different categories:
     * * The `core` object provides your rate limit status for all non-search-related resources in the REST API.
     * * The `search` object provides your rate limit status for the REST API for searching (excluding code searches). For more information, see "[Search](https://docs.github.com/enterprise-server@3.10/rest/search/search)."
     * * The `code_search` object provides your rate limit status for the REST API for searching code. For more information, see "[Search code](https://docs.github.com/enterprise-server@3.10/rest/search/search#search-code)."
     * * The `graphql` object provides your rate limit status for the GraphQL API. For more information, see "[Resource limitations](https://docs.github.com/enterprise-server@3.10/graphql/overview/resource-limitations#rate-limit)."
     * * The `integration_manifest` object provides your rate limit status for the `POST /app-manifests/{code}/conversions` operation. For more information, see "[Creating a GitHub App from a manifest](https://docs.github.com/enterprise-server@3.10/apps/creating-github-apps/setting-up-a-github-app/creating-a-github-app-from-a-manifest#3-you-exchange-the-temporary-code-to-retrieve-the-app-configuration)."
     * * The `dependency_snapshots` object provides your rate limit status for submitting snapshots to the dependency graph. For more information, see "[Dependency graph](https://docs.github.com/enterprise-server@3.10/rest/dependency-graph)."
     * * The `code_scanning_upload` object provides your rate limit status for uploading SARIF results to code scanning. For more information, see "[Uploading a SARIF file to GitHub](https://docs.github.com/enterprise-server@3.10/code-security/code-scanning/integrating-with-code-scanning/uploading-a-sarif-file-to-github)."
     * * The `actions_runner_registration` object provides your rate limit status for registering self-hosted runners in GitHub Actions. For more information, see "[Self-hosted runners](https://docs.github.com/enterprise-server@3.10/rest/actions/self-hosted-runners)."
     * * The `source_import` object is no longer in use for any API endpoints, and it will be removed in the next API version. For more information about API versions, see "[API Versions](https://docs.github.com/enterprise-server@3.10/rest/overview/api-versions)."
     *
     * **Note:** The `rate` object is deprecated. If you're writing new API client code or updating existing code, you should use the `core` object instead of the `rate` object. The `core` object contains the same information that is present in the `rate` object.
     */
    get: operations["rate-limit/get"];
  };
  "/repos/{owner}/{repo}": {
    /**
     * Get a repository
     * @description The `parent` and `source` objects are present when the repository is a fork. `parent` is the repository this repository was forked from, `source` is the ultimate source for the network.
     *
     * **Note:** In order to see the `security_and_analysis` block for a repository you must have admin permissions for the repository or be an owner or security manager for the organization that owns the repository. For more information, see "[Managing security managers in your organization](https://docs.github.com/enterprise-server@3.10/organizations/managing-peoples-access-to-your-organization-with-roles/managing-security-managers-in-your-organization)."
     */
    get: operations["repos/get"];
    /**
     * Delete a repository
     * @description Deleting a repository requires admin access.
     *
     * If an organization owner has configured the organization to prevent members from deleting organization-owned
     * repositories, you will get a `403 Forbidden` response.
     *
     * OAuth app tokens and personal access tokens (classic) need the `delete_repo` scope to use this endpoint.
     */
    delete: operations["repos/delete"];
    /**
     * Update a repository
     * @description **Note**: To edit a repository's topics, use the [Replace all repository topics](https://docs.github.com/enterprise-server@3.10/rest/repos/repos#replace-all-repository-topics) endpoint.
     */
    patch: operations["repos/update"];
  };
  "/repos/{owner}/{repo}/actions/artifacts": {
    /**
     * List artifacts for a repository
     * @description Lists all artifacts for a repository.
     *
     * Anyone with read access to the repository can use this endpoint.
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.
     */
    get: operations["actions/list-artifacts-for-repo"];
  };
  "/repos/{owner}/{repo}/actions/artifacts/{artifact_id}": {
    /**
     * Get an artifact
     * @description Gets a specific artifact for a workflow run.
     *
     * Anyone with read access to the repository can use this endpoint.
     *
     * If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    get: operations["actions/get-artifact"];
    /**
     * Delete an artifact
     * @description Deletes an artifact for a workflow run.
     * OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    delete: operations["actions/delete-artifact"];
  };
  "/repos/{owner}/{repo}/actions/artifacts/{artifact_id}/{archive_format}": {
    /**
     * Download an artifact
     * @description Gets a redirect URL to download an archive for a repository. This URL expires after 1 minute. Look for `Location:` in
     * the response header to find the URL for the download. The `:archive_format` must be `zip`.
     *
     * OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    get: operations["actions/download-artifact"];
  };
  "/repos/{owner}/{repo}/actions/cache/usage": {
    /**
     * Get GitHub Actions cache usage for a repository
     * @description Gets GitHub Actions cache usage for a repository.
     * The data fetched using this API is refreshed approximately every 5 minutes, so values returned from this endpoint may take at least 5 minutes to get updated.
     *
     * Anyone with read access to the repository can use this endpoint.
     *
     * If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    get: operations["actions/get-actions-cache-usage"];
  };
  "/repos/{owner}/{repo}/actions/cache/usage-policy": {
    /**
     * Get GitHub Actions cache usage policy for a repository
     * @description Gets GitHub Actions cache usage policy for a repository.
     *
     * OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    get: operations["actions/get-actions-cache-usage-policy"];
    /**
     * Set GitHub Actions cache usage policy for a repository
     * @description Sets GitHub Actions cache usage policy for a repository.
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    patch: operations["actions/set-actions-cache-usage-policy"];
  };
  "/repos/{owner}/{repo}/actions/caches": {
    /**
     * List GitHub Actions caches for a repository
     * @description Lists the GitHub Actions caches for a repository.
     *
     * OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    get: operations["actions/get-actions-cache-list"];
    /**
     * Delete GitHub Actions caches for a repository (using a cache key)
     * @description Deletes one or more GitHub Actions caches for a repository, using a complete cache key. By default, all caches that match the provided key are deleted, but you can optionally provide a Git ref to restrict deletions to caches that match both the provided key and the Git ref.
     *
     * OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    delete: operations["actions/delete-actions-cache-by-key"];
  };
  "/repos/{owner}/{repo}/actions/caches/{cache_id}": {
    /**
     * Delete a GitHub Actions cache for a repository (using a cache ID)
     * @description Deletes a GitHub Actions cache for a repository, using a cache ID.
     *
     * OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    delete: operations["actions/delete-actions-cache-by-id"];
  };
  "/repos/{owner}/{repo}/actions/jobs/{job_id}": {
    /**
     * Get a job for a workflow run
     * @description Gets a specific job in a workflow run.
     *
     * Anyone with read access to the repository can use this endpoint.
     *
     * If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    get: operations["actions/get-job-for-workflow-run"];
  };
  "/repos/{owner}/{repo}/actions/jobs/{job_id}/logs": {
    /**
     * Download job logs for a workflow run
     * @description Gets a redirect URL to download a plain text file of logs for a workflow job. This link expires after 1 minute. Look
     * for `Location:` in the response header to find the URL for the download.
     *
     * Anyone with read access to the repository can use this endpoint.
     *
     * If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    get: operations["actions/download-job-logs-for-workflow-run"];
  };
  "/repos/{owner}/{repo}/actions/jobs/{job_id}/rerun": {
    /**
     * Re-run a job from a workflow run
     * @description Re-run a job and its dependent jobs in a workflow run.
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    post: operations["actions/re-run-job-for-workflow-run"];
  };
  "/repos/{owner}/{repo}/actions/oidc/customization/sub": {
    /**
     * Get the customization template for an OIDC subject claim for a repository
     * @description Gets the customization template for an OpenID Connect (OIDC) subject claim.
     *
     * OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    get: operations["actions/get-custom-oidc-sub-claim-for-repo"];
    /**
     * Set the customization template for an OIDC subject claim for a repository
     * @description Sets the customization template and `opt-in` or `opt-out` flag for an OpenID Connect (OIDC) subject claim for a repository.
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    put: operations["actions/set-custom-oidc-sub-claim-for-repo"];
  };
  "/repos/{owner}/{repo}/actions/organization-secrets": {
    /**
     * List repository organization secrets
     * @description Lists all organization secrets shared with a repository without revealing their encrypted
     * values.
     *
     * Authenticated users must have collaborator access to a repository to create, update, or read secrets.
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    get: operations["actions/list-repo-organization-secrets"];
  };
  "/repos/{owner}/{repo}/actions/organization-variables": {
    /**
     * List repository organization variables
     * @description Lists all organization variables shared with a repository.
     *
     * Authenticated users must have collaborator access to a repository to create, update, or read variables.
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    get: operations["actions/list-repo-organization-variables"];
  };
  "/repos/{owner}/{repo}/actions/permissions": {
    /**
     * Get GitHub Actions permissions for a repository
     * @description Gets the GitHub Actions permissions policy for a repository, including whether GitHub Actions is enabled and the actions allowed to run in the repository.
     *
     * You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `administration` repository permission to use this API.
     */
    get: operations["actions/get-github-actions-permissions-repository"];
    /**
     * Set GitHub Actions permissions for a repository
     * @description Sets the GitHub Actions permissions policy for enabling GitHub Actions and allowed actions in the repository.
     *
     * If the repository belongs to an organization or enterprise that has set restrictive permissions at the organization or enterprise levels, such as `allowed_actions` to `selected` actions, then you cannot override them for the repository.
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    put: operations["actions/set-github-actions-permissions-repository"];
  };
  "/repos/{owner}/{repo}/actions/permissions/access": {
    /**
     * Get the level of access for workflows outside of the repository
     * @description Gets the level of access that workflows outside of the repository have to actions and reusable workflows in the repository.
     * This endpoint only applies to internal and private repositories.
     * For more information, see "[Allowing access to components in a private repository](https://docs.github.com/enterprise-server@3.10/repositories/managing-your-repositorys-settings-and-features/enabling-features-for-your-repository/managing-github-actions-settings-for-a-repository#allowing-access-to-components-in-a-private-repository)" and
     * "[Allowing access to components in an internal repository](https://docs.github.com/enterprise-server@3.10/repositories/managing-your-repositorys-settings-and-features/enabling-features-for-your-repository/managing-github-actions-settings-for-a-repository#allowing-access-to-components-in-an-internal-repository)."
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    get: operations["actions/get-workflow-access-to-repository"];
    /**
     * Set the level of access for workflows outside of the repository
     * @description Sets the level of access that workflows outside of the repository have to actions and reusable workflows in the repository.
     * This endpoint only applies to internal and private repositories.
     * For more information, see "[Allowing access to components in a private repository](https://docs.github.com/enterprise-server@3.10/repositories/managing-your-repositorys-settings-and-features/enabling-features-for-your-repository/managing-github-actions-settings-for-a-repository#allowing-access-to-components-in-a-private-repository)" and
     * "[Allowing access to components in an internal repository](https://docs.github.com/enterprise-server@3.10/repositories/managing-your-repositorys-settings-and-features/enabling-features-for-your-repository/managing-github-actions-settings-for-a-repository#allowing-access-to-components-in-an-internal-repository)."
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    put: operations["actions/set-workflow-access-to-repository"];
  };
  "/repos/{owner}/{repo}/actions/permissions/selected-actions": {
    /**
     * Get allowed actions for a repository
     * @description Gets the settings for selected actions that are allowed in a repository. To use this endpoint, the repository policy for `allowed_actions` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for a repository](#set-github-actions-permissions-for-a-repository)."
     *
     * You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `administration` repository permission to use this API.
     */
    get: operations["actions/get-allowed-actions-repository"];
    /**
     * Set allowed actions for a repository
     * @description Sets the actions that are allowed in a repository. To use this endpoint, the repository permission policy for `allowed_actions` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for a repository](#set-github-actions-permissions-for-a-repository)."
     *
     * If the repository belongs to an organization or enterprise that has `selected` actions set at the organization or enterprise levels, then you cannot override any of the allowed actions settings.
     *
     * To use the `patterns_allowed` setting for private repositories, the repository must belong to an enterprise. If the repository does not belong to an enterprise, then the `patterns_allowed` setting only applies to public repositories.
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    put: operations["actions/set-allowed-actions-repository"];
  };
  "/repos/{owner}/{repo}/actions/permissions/workflow": {
    /**
     * Get default workflow permissions for a repository
     * @description Gets the default workflow permissions granted to the `GITHUB_TOKEN` when running workflows in a repository,
     * as well as if GitHub Actions can submit approving pull request reviews.
     * For more information, see "[Setting the permissions of the GITHUB_TOKEN for your repository](https://docs.github.com/enterprise-server@3.10/repositories/managing-your-repositorys-settings-and-features/enabling-features-for-your-repository/managing-github-actions-settings-for-a-repository#setting-the-permissions-of-the-github_token-for-your-repository)."
     *
     * OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    get: operations["actions/get-github-actions-default-workflow-permissions-repository"];
    /**
     * Set default workflow permissions for a repository
     * @description Sets the default workflow permissions granted to the `GITHUB_TOKEN` when running workflows in a repository, and sets if GitHub Actions
     * can submit approving pull request reviews.
     * For more information, see "[Setting the permissions of the GITHUB_TOKEN for your repository](https://docs.github.com/enterprise-server@3.10/repositories/managing-your-repositorys-settings-and-features/enabling-features-for-your-repository/managing-github-actions-settings-for-a-repository#setting-the-permissions-of-the-github_token-for-your-repository)."
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    put: operations["actions/set-github-actions-default-workflow-permissions-repository"];
  };
  "/repos/{owner}/{repo}/actions/runners": {
    /**
     * List self-hosted runners for a repository
     * @description Lists all self-hosted runners configured in a repository.
     *
     * Authenticated users must have admin access to the repository to use this endpoint.
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    get: operations["actions/list-self-hosted-runners-for-repo"];
  };
  "/repos/{owner}/{repo}/actions/runners/downloads": {
    /**
     * List runner applications for a repository
     * @description Lists binaries for the runner application that you can download and run.
     *
     * Authenticated users must have admin access to the repository to use this endpoint.
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    get: operations["actions/list-runner-applications-for-repo"];
  };
  "/repos/{owner}/{repo}/actions/runners/generate-jitconfig": {
    /**
     * Create configuration for a just-in-time runner for a repository
     * @description Generates a configuration that can be passed to the runner application at startup.
     *
     * The authenticated user must have admin access to the repository.
     *
     * OAuth tokens and personal access tokens (classic) need the`repo` scope to use this endpoint.
     */
    post: operations["actions/generate-runner-jitconfig-for-repo"];
  };
  "/repos/{owner}/{repo}/actions/runners/registration-token": {
    /**
     * Create a registration token for a repository
     * @description Returns a token that you can pass to the `config` script. The token expires after one hour.
     *
     * For example, you can replace `TOKEN` in the following example with the registration token provided by this endpoint to configure your self-hosted runner:
     *
     * ```
     * ./config.sh --url https://github.com/octo-org --token TOKEN
     * ```
     *
     * Authenticated users must have admin access to the repository to use this endpoint.
     *
     * OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    post: operations["actions/create-registration-token-for-repo"];
  };
  "/repos/{owner}/{repo}/actions/runners/remove-token": {
    /**
     * Create a remove token for a repository
     * @description Returns a token that you can pass to the `config` script to remove a self-hosted runner from an repository. The token expires after one hour.
     *
     * For example, you can replace `TOKEN` in the following example with the registration token provided by this endpoint to remove your self-hosted runner from an organization:
     *
     * ```
     * ./config.sh remove --token TOKEN
     * ```
     *
     * Authenticated users must have admin access to the repository to use this endpoint.
     *
     * OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    post: operations["actions/create-remove-token-for-repo"];
  };
  "/repos/{owner}/{repo}/actions/runners/{runner_id}": {
    /**
     * Get a self-hosted runner for a repository
     * @description Gets a specific self-hosted runner configured in a repository.
     *
     * Authenticated users must have admin access to the repository to use this endpoint.
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    get: operations["actions/get-self-hosted-runner-for-repo"];
    /**
     * Delete a self-hosted runner from a repository
     * @description Forces the removal of a self-hosted runner from a repository. You can use this endpoint to completely remove the runner when the machine you were using no longer exists.
     *
     * Authenticated users must have admin access to the repository to use this endpoint.
     *
     * OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    delete: operations["actions/delete-self-hosted-runner-from-repo"];
  };
  "/repos/{owner}/{repo}/actions/runners/{runner_id}/labels": {
    /**
     * List labels for a self-hosted runner for a repository
     * @description Lists all labels for a self-hosted runner configured in a repository.
     *
     * Authenticated users must have admin access to the repository to use this endpoint.
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    get: operations["actions/list-labels-for-self-hosted-runner-for-repo"];
    /**
     * Set custom labels for a self-hosted runner for a repository
     * @description Remove all previous custom labels and set the new custom labels for a specific
     * self-hosted runner configured in a repository.
     *
     * Authenticated users must have admin access to the repository to use this endpoint.
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    put: operations["actions/set-custom-labels-for-self-hosted-runner-for-repo"];
    /**
     * Add custom labels to a self-hosted runner for a repository
     * @description Adds custom labels to a self-hosted runner configured in a repository.
     *
     * Authenticated users must have admin access to the organization to use this endpoint.
     *
     * OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    post: operations["actions/add-custom-labels-to-self-hosted-runner-for-repo"];
    /**
     * Remove all custom labels from a self-hosted runner for a repository
     * @description Remove all custom labels from a self-hosted runner configured in a
     * repository. Returns the remaining read-only labels from the runner.
     *
     * Authenticated users must have admin access to the repository to use this endpoint.
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    delete: operations["actions/remove-all-custom-labels-from-self-hosted-runner-for-repo"];
  };
  "/repos/{owner}/{repo}/actions/runners/{runner_id}/labels/{name}": {
    /**
     * Remove a custom label from a self-hosted runner for a repository
     * @description Remove a custom label from a self-hosted runner configured
     * in a repository. Returns the remaining labels from the runner.
     *
     * This endpoint returns a `404 Not Found` status if the custom label is not
     * present on the runner.
     *
     * Authenticated users must have admin access to the repository to use this endpoint.
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    delete: operations["actions/remove-custom-label-from-self-hosted-runner-for-repo"];
  };
  "/repos/{owner}/{repo}/actions/runs": {
    /**
     * List workflow runs for a repository
     * @description Lists all workflow runs for a repository. You can use parameters to narrow the list of results. For more information about using parameters, see [Parameters](https://docs.github.com/enterprise-server@3.10/rest/guides/getting-started-with-the-rest-api#parameters).
     *
     * Anyone with read access to the repository can use this endpoint.
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.
     *
     * This API will return up to 1,000 results for each search when using the following parameters: `actor`, `branch`, `check_suite_id`, `created`, `event`, `head_sha`, `status`.
     */
    get: operations["actions/list-workflow-runs-for-repo"];
  };
  "/repos/{owner}/{repo}/actions/runs/{run_id}": {
    /**
     * Get a workflow run
     * @description Gets a specific workflow run.
     *
     * Anyone with read access to the repository can use this endpoint.
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.
     */
    get: operations["actions/get-workflow-run"];
    /**
     * Delete a workflow run
     * @description Deletes a specific workflow run.
     *
     * Anyone with write access to the repository can use this endpoint.
     *
     * If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    delete: operations["actions/delete-workflow-run"];
  };
  "/repos/{owner}/{repo}/actions/runs/{run_id}/approvals": {
    /**
     * Get the review history for a workflow run
     * @description Anyone with read access to the repository can use this endpoint.
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.
     */
    get: operations["actions/get-reviews-for-run"];
  };
  "/repos/{owner}/{repo}/actions/runs/{run_id}/artifacts": {
    /**
     * List workflow run artifacts
     * @description Lists artifacts for a workflow run.
     *
     * Anyone with read access to the repository can use this endpoint.
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.
     */
    get: operations["actions/list-workflow-run-artifacts"];
  };
  "/repos/{owner}/{repo}/actions/runs/{run_id}/attempts/{attempt_number}": {
    /**
     * Get a workflow run attempt
     * @description Gets a specific workflow run attempt.
     *
     * Anyone with read access to the repository can use this endpoint.
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.
     */
    get: operations["actions/get-workflow-run-attempt"];
  };
  "/repos/{owner}/{repo}/actions/runs/{run_id}/attempts/{attempt_number}/jobs": {
    /**
     * List jobs for a workflow run attempt
     * @description Lists jobs for a specific workflow run attempt. You can use parameters to narrow the list of results. For more information
     * about using parameters, see [Parameters](https://docs.github.com/enterprise-server@3.10/rest/guides/getting-started-with-the-rest-api#parameters).
     *
     * Anyone with read access to the repository can use this endpoint.
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint  with a private repository.
     */
    get: operations["actions/list-jobs-for-workflow-run-attempt"];
  };
  "/repos/{owner}/{repo}/actions/runs/{run_id}/attempts/{attempt_number}/logs": {
    /**
     * Download workflow run attempt logs
     * @description Gets a redirect URL to download an archive of log files for a specific workflow run attempt. This link expires after
     * 1 minute. Look for `Location:` in the response header to find the URL for the download.
     *
     * Anyone with read access to the repository can use this endpoint.
     *
     * If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    get: operations["actions/download-workflow-run-attempt-logs"];
  };
  "/repos/{owner}/{repo}/actions/runs/{run_id}/cancel": {
    /**
     * Cancel a workflow run
     * @description Cancels a workflow run using its `id`.
     *
     * OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    post: operations["actions/cancel-workflow-run"];
  };
  "/repos/{owner}/{repo}/actions/runs/{run_id}/deployment_protection_rule": {
    /**
     * Review custom deployment protection rules for a workflow run
     * @description Approve or reject custom deployment protection rules provided by a GitHub App for a workflow run. For more information, see "[Using environments for deployment](https://docs.github.com/enterprise-server@3.10/actions/deployment/targeting-different-environments/using-environments-for-deployment)."
     *
     * **Note:** GitHub Apps can only review their own custom deployment protection rules.
     * To approve or reject pending deployments that are waiting for review from a specific person or team, see [`POST /repos/{owner}/{repo}/actions/runs/{run_id}/pending_deployments`](/rest/actions/workflow-runs#review-pending-deployments-for-a-workflow-run).
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.
     */
    post: operations["actions/review-custom-gates-for-run"];
  };
  "/repos/{owner}/{repo}/actions/runs/{run_id}/jobs": {
    /**
     * List jobs for a workflow run
     * @description Lists jobs for a workflow run. You can use parameters to narrow the list of results. For more information
     * about using parameters, see [Parameters](https://docs.github.com/enterprise-server@3.10/rest/guides/getting-started-with-the-rest-api#parameters).
     *
     * Anyone with read access to the repository can use this endpoint.
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.
     */
    get: operations["actions/list-jobs-for-workflow-run"];
  };
  "/repos/{owner}/{repo}/actions/runs/{run_id}/logs": {
    /**
     * Download workflow run logs
     * @description Gets a redirect URL to download an archive of log files for a workflow run. This link expires after 1 minute. Look for
     * `Location:` in the response header to find the URL for the download.
     *
     * Anyone with read access to the repository can use this endpoint.
     *
     * If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    get: operations["actions/download-workflow-run-logs"];
    /**
     * Delete workflow run logs
     * @description Deletes all logs for a workflow run.
     *
     * OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    delete: operations["actions/delete-workflow-run-logs"];
  };
  "/repos/{owner}/{repo}/actions/runs/{run_id}/pending_deployments": {
    /**
     * Get pending deployments for a workflow run
     * @description Get all deployment environments for a workflow run that are waiting for protection rules to pass.
     *
     * Anyone with read access to the repository can use this endpoint.
     *
     * If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    get: operations["actions/get-pending-deployments-for-run"];
    /**
     * Review pending deployments for a workflow run
     * @description Approve or reject pending deployments that are waiting on approval by a required reviewer.
     *
     * Required reviewers with read access to the repository contents and deployments can use this endpoint.
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    post: operations["actions/review-pending-deployments-for-run"];
  };
  "/repos/{owner}/{repo}/actions/runs/{run_id}/rerun": {
    /**
     * Re-run a workflow
     * @description Re-runs your workflow run using its `id`.
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    post: operations["actions/re-run-workflow"];
  };
  "/repos/{owner}/{repo}/actions/runs/{run_id}/rerun-failed-jobs": {
    /**
     * Re-run failed jobs from a workflow run
     * @description Re-run all of the failed jobs and their dependent jobs in a workflow run using the `id` of the workflow run.
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    post: operations["actions/re-run-workflow-failed-jobs"];
  };
  "/repos/{owner}/{repo}/actions/secrets": {
    /**
     * List repository secrets
     * @description Lists all secrets available in a repository without revealing their encrypted
     * values.
     *
     * Authenticated users must have collaborator access to a repository to create, update, or read secrets.
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    get: operations["actions/list-repo-secrets"];
  };
  "/repos/{owner}/{repo}/actions/secrets/public-key": {
    /**
     * Get a repository public key
     * @description Gets your public key, which you need to encrypt secrets. You need to
     * encrypt a secret before you can create or update secrets.
     *
     * Anyone with read access to the repository can use this endpoint.
     *
     * If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    get: operations["actions/get-repo-public-key"];
  };
  "/repos/{owner}/{repo}/actions/secrets/{secret_name}": {
    /**
     * Get a repository secret
     * @description Gets a single repository secret without revealing its encrypted value.
     *
     * The authenticated user must have collaborator access to the repository to use this endpoint.
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    get: operations["actions/get-repo-secret"];
    /**
     * Create or update a repository secret
     * @description Creates or updates a repository secret with an encrypted value. Encrypt your secret using
     * [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages). For more information, see "[Encrypting secrets for the REST API](https://docs.github.com/enterprise-server@3.10/rest/guides/encrypting-secrets-for-the-rest-api)."
     *
     * Authenticated users must have collaborator access to a repository to create, update, or read secrets.
     *
     * OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    put: operations["actions/create-or-update-repo-secret"];
    /**
     * Delete a repository secret
     * @description Deletes a secret in a repository using the secret name.
     *
     * Authenticated users must have collaborator access to a repository to create, update, or read secrets.
     *
     * OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    delete: operations["actions/delete-repo-secret"];
  };
  "/repos/{owner}/{repo}/actions/variables": {
    /**
     * List repository variables
     * @description Lists all repository variables.
     *
     * Authenticated users must have collaborator access to a repository to create, update, or read variables.
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    get: operations["actions/list-repo-variables"];
    /**
     * Create a repository variable
     * @description Creates a repository variable that you can reference in a GitHub Actions workflow.
     *
     * Authenticated users must have collaborator access to a repository to create, update, or read variables.
     *
     * OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    post: operations["actions/create-repo-variable"];
  };
  "/repos/{owner}/{repo}/actions/variables/{name}": {
    /**
     * Get a repository variable
     * @description Gets a specific variable in a repository.
     *
     * The authenticated user must have collaborator access to the repository to use this endpoint.
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    get: operations["actions/get-repo-variable"];
    /**
     * Delete a repository variable
     * @description Deletes a repository variable using the variable name.
     *
     * Authenticated users must have collaborator access to a repository to create, update, or read variables.
     *
     * OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    delete: operations["actions/delete-repo-variable"];
    /**
     * Update a repository variable
     * @description Updates a repository variable that you can reference in a GitHub Actions workflow.
     *
     * Authenticated users must have collaborator access to a repository to create, update, or read variables.
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    patch: operations["actions/update-repo-variable"];
  };
  "/repos/{owner}/{repo}/actions/workflows": {
    /**
     * List repository workflows
     * @description Lists the workflows in a repository.
     *
     * Anyone with read access to the repository can use this endpoint.
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.
     */
    get: operations["actions/list-repo-workflows"];
  };
  "/repos/{owner}/{repo}/actions/workflows/{workflow_id}": {
    /**
     * Get a workflow
     * @description Gets a specific workflow. You can replace `workflow_id` with the workflow
     * file name. For example, you could use `main.yaml`.
     *
     * Anyone with read access to the repository can use this endpoint.
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.
     */
    get: operations["actions/get-workflow"];
  };
  "/repos/{owner}/{repo}/actions/workflows/{workflow_id}/disable": {
    /**
     * Disable a workflow
     * @description Disables a workflow and sets the `state` of the workflow to `disabled_manually`. You can replace `workflow_id` with the workflow file name. For example, you could use `main.yaml`.
     *
     * OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    put: operations["actions/disable-workflow"];
  };
  "/repos/{owner}/{repo}/actions/workflows/{workflow_id}/dispatches": {
    /**
     * Create a workflow dispatch event
     * @description You can use this endpoint to manually trigger a GitHub Actions workflow run. You can replace `workflow_id` with the workflow file name. For example, you could use `main.yaml`.
     *
     * You must configure your GitHub Actions workflow to run when the [`workflow_dispatch` webhook](/developers/webhooks-and-events/webhook-events-and-payloads#workflow_dispatch) event occurs. The `inputs` are configured in the workflow file. For more information about how to configure the `workflow_dispatch` event in the workflow file, see "[Events that trigger workflows](/actions/reference/events-that-trigger-workflows#workflow_dispatch)."
     *
     * OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    post: operations["actions/create-workflow-dispatch"];
  };
  "/repos/{owner}/{repo}/actions/workflows/{workflow_id}/enable": {
    /**
     * Enable a workflow
     * @description Enables a workflow and sets the `state` of the workflow to `active`. You can replace `workflow_id` with the workflow file name. For example, you could use `main.yaml`.
     *
     * OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    put: operations["actions/enable-workflow"];
  };
  "/repos/{owner}/{repo}/actions/workflows/{workflow_id}/runs": {
    /**
     * List workflow runs for a workflow
     * @description List all workflow runs for a workflow. You can replace `workflow_id` with the workflow file name. For example, you could use `main.yaml`. You can use parameters to narrow the list of results. For more information about using parameters, see [Parameters](https://docs.github.com/enterprise-server@3.10/rest/guides/getting-started-with-the-rest-api#parameters).
     *
     * Anyone with read access to the repository can use this endpoint
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.
     */
    get: operations["actions/list-workflow-runs"];
  };
  "/repos/{owner}/{repo}/assignees": {
    /**
     * List assignees
     * @description Lists the [available assignees](https://docs.github.com/enterprise-server@3.10/articles/assigning-issues-and-pull-requests-to-other-github-users/) for issues in a repository.
     */
    get: operations["issues/list-assignees"];
  };
  "/repos/{owner}/{repo}/assignees/{assignee}": {
    /**
     * Check if a user can be assigned
     * @description Checks if a user has permission to be assigned to an issue in this repository.
     *
     * If the `assignee` can be assigned to issues in the repository, a `204` header with no content is returned.
     *
     * Otherwise a `404` status code is returned.
     */
    get: operations["issues/check-user-can-be-assigned"];
  };
  "/repos/{owner}/{repo}/autolinks": {
    /**
     * Get all autolinks of a repository
     * @description Gets all autolinks that are configured for a repository.
     *
     * Information about autolinks are only available to repository administrators.
     */
    get: operations["repos/list-autolinks"];
    /**
     * Create an autolink reference for a repository
     * @description Users with admin access to the repository can create an autolink.
     */
    post: operations["repos/create-autolink"];
  };
  "/repos/{owner}/{repo}/autolinks/{autolink_id}": {
    /**
     * Get an autolink reference of a repository
     * @description This returns a single autolink reference by ID that was configured for the given repository.
     *
     * Information about autolinks are only available to repository administrators.
     */
    get: operations["repos/get-autolink"];
    /**
     * Delete an autolink reference from a repository
     * @description This deletes a single autolink reference by ID that was configured for the given repository.
     *
     * Information about autolinks are only available to repository administrators.
     */
    delete: operations["repos/delete-autolink"];
  };
  "/repos/{owner}/{repo}/automated-security-fixes": {
    /**
     * Check if automated security fixes are enabled for a repository
     * @description Shows whether automated security fixes are enabled, disabled or paused for a repository. The authenticated user must have admin read access to the repository. For more information, see "[Configuring automated security fixes](https://docs.github.com/enterprise-server@3.10/articles/configuring-automated-security-fixes)".
     */
    get: operations["repos/check-automated-security-fixes"];
  };
  "/repos/{owner}/{repo}/branches": {
    /** List branches */
    get: operations["repos/list-branches"];
  };
  "/repos/{owner}/{repo}/branches/{branch}": {
    /** Get a branch */
    get: operations["repos/get-branch"];
  };
  "/repos/{owner}/{repo}/branches/{branch}/protection": {
    /**
     * Get branch protection
     * @description Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/enterprise-server@3.10/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     */
    get: operations["repos/get-branch-protection"];
    /**
     * Update branch protection
     * @description Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/enterprise-server@3.10/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * Protecting a branch requires admin or owner permissions to the repository.
     *
     * **Note**: Passing new arrays of `users` and `teams` replaces their previous values.
     *
     * **Note**: The list of users, apps, and teams in total is limited to 100 items.
     */
    put: operations["repos/update-branch-protection"];
    /**
     * Delete branch protection
     * @description Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/enterprise-server@3.10/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     */
    delete: operations["repos/delete-branch-protection"];
  };
  "/repos/{owner}/{repo}/branches/{branch}/protection/enforce_admins": {
    /**
     * Get admin branch protection
     * @description Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/enterprise-server@3.10/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     */
    get: operations["repos/get-admin-branch-protection"];
    /**
     * Set admin branch protection
     * @description Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/enterprise-server@3.10/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * Adding admin enforcement requires admin or owner permissions to the repository and branch protection to be enabled.
     */
    post: operations["repos/set-admin-branch-protection"];
    /**
     * Delete admin branch protection
     * @description Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/enterprise-server@3.10/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * Removing admin enforcement requires admin or owner permissions to the repository and branch protection to be enabled.
     */
    delete: operations["repos/delete-admin-branch-protection"];
  };
  "/repos/{owner}/{repo}/branches/{branch}/protection/required_pull_request_reviews": {
    /**
     * Get pull request review protection
     * @description Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/enterprise-server@3.10/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     */
    get: operations["repos/get-pull-request-review-protection"];
    /**
     * Delete pull request review protection
     * @description Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/enterprise-server@3.10/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     */
    delete: operations["repos/delete-pull-request-review-protection"];
    /**
     * Update pull request review protection
     * @description Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/enterprise-server@3.10/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * Updating pull request review enforcement requires admin or owner permissions to the repository and branch protection to be enabled.
     *
     * **Note**: Passing new arrays of `users` and `teams` replaces their previous values.
     */
    patch: operations["repos/update-pull-request-review-protection"];
  };
  "/repos/{owner}/{repo}/branches/{branch}/protection/required_signatures": {
    /**
     * Get commit signature protection
     * @description Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/enterprise-server@3.10/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * When authenticated with admin or owner permissions to the repository, you can use this endpoint to check whether a branch requires signed commits. An enabled status of `true` indicates you must sign commits on this branch. For more information, see [Signing commits with GPG](https://docs.github.com/enterprise-server@3.10/articles/signing-commits-with-gpg) in GitHub Help.
     *
     * **Note**: You must enable branch protection to require signed commits.
     */
    get: operations["repos/get-commit-signature-protection"];
    /**
     * Create commit signature protection
     * @description Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/enterprise-server@3.10/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * When authenticated with admin or owner permissions to the repository, you can use this endpoint to require signed commits on a branch. You must enable branch protection to require signed commits.
     */
    post: operations["repos/create-commit-signature-protection"];
    /**
     * Delete commit signature protection
     * @description Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/enterprise-server@3.10/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * When authenticated with admin or owner permissions to the repository, you can use this endpoint to disable required signed commits on a branch. You must enable branch protection to require signed commits.
     */
    delete: operations["repos/delete-commit-signature-protection"];
  };
  "/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks": {
    /**
     * Get status checks protection
     * @description Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/enterprise-server@3.10/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     */
    get: operations["repos/get-status-checks-protection"];
    /**
     * Remove status check protection
     * @description Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/enterprise-server@3.10/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     */
    delete: operations["repos/remove-status-check-protection"];
    /**
     * Update status check protection
     * @description Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/enterprise-server@3.10/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * Updating required status checks requires admin or owner permissions to the repository and branch protection to be enabled.
     */
    patch: operations["repos/update-status-check-protection"];
  };
  "/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts": {
    /**
     * Get all status check contexts
     * @description Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/enterprise-server@3.10/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     */
    get: operations["repos/get-all-status-check-contexts"];
    /**
     * Set status check contexts
     * @description Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/enterprise-server@3.10/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     */
    put: operations["repos/set-status-check-contexts"];
    /**
     * Add status check contexts
     * @description Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/enterprise-server@3.10/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     */
    post: operations["repos/add-status-check-contexts"];
    /**
     * Remove status check contexts
     * @description Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/enterprise-server@3.10/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     */
    delete: operations["repos/remove-status-check-contexts"];
  };
  "/repos/{owner}/{repo}/branches/{branch}/protection/restrictions": {
    /**
     * Get access restrictions
     * @description Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/enterprise-server@3.10/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * Lists who has access to this protected branch.
     *
     * **Note**: Users, apps, and teams `restrictions` are only available for organization-owned repositories.
     */
    get: operations["repos/get-access-restrictions"];
    /**
     * Delete access restrictions
     * @description Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/enterprise-server@3.10/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * Disables the ability to restrict who can push to this branch.
     */
    delete: operations["repos/delete-access-restrictions"];
  };
  "/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps": {
    /**
     * Get apps with access to the protected branch
     * @description Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/enterprise-server@3.10/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * Lists the GitHub Apps that have push access to this branch. Only GitHub Apps that are installed on the repository and that have been granted write access to the repository contents can be added as authorized actors on a protected branch.
     */
    get: operations["repos/get-apps-with-access-to-protected-branch"];
    /**
     * Set app access restrictions
     * @description Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/enterprise-server@3.10/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * Replaces the list of apps that have push access to this branch. This removes all apps that previously had push access and grants push access to the new list of apps. Only GitHub Apps that are installed on the repository and that have been granted write access to the repository contents can be added as authorized actors on a protected branch.
     */
    put: operations["repos/set-app-access-restrictions"];
    /**
     * Add app access restrictions
     * @description Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/enterprise-server@3.10/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * Grants the specified apps push access for this branch. Only GitHub Apps that are installed on the repository and that have been granted write access to the repository contents can be added as authorized actors on a protected branch.
     */
    post: operations["repos/add-app-access-restrictions"];
    /**
     * Remove app access restrictions
     * @description Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/enterprise-server@3.10/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * Removes the ability of an app to push to this branch. Only GitHub Apps that are installed on the repository and that have been granted write access to the repository contents can be added as authorized actors on a protected branch.
     */
    delete: operations["repos/remove-app-access-restrictions"];
  };
  "/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams": {
    /**
     * Get teams with access to the protected branch
     * @description Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/enterprise-server@3.10/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * Lists the teams who have push access to this branch. The list includes child teams.
     */
    get: operations["repos/get-teams-with-access-to-protected-branch"];
    /**
     * Set team access restrictions
     * @description Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/enterprise-server@3.10/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * Replaces the list of teams that have push access to this branch. This removes all teams that previously had push access and grants push access to the new list of teams. Team restrictions include child teams.
     */
    put: operations["repos/set-team-access-restrictions"];
    /**
     * Add team access restrictions
     * @description Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/enterprise-server@3.10/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * Grants the specified teams push access for this branch. You can also give push access to child teams.
     */
    post: operations["repos/add-team-access-restrictions"];
    /**
     * Remove team access restrictions
     * @description Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/enterprise-server@3.10/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * Removes the ability of a team to push to this branch. You can also remove push access for child teams.
     */
    delete: operations["repos/remove-team-access-restrictions"];
  };
  "/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users": {
    /**
     * Get users with access to the protected branch
     * @description Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/enterprise-server@3.10/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * Lists the people who have push access to this branch.
     */
    get: operations["repos/get-users-with-access-to-protected-branch"];
    /**
     * Set user access restrictions
     * @description Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/enterprise-server@3.10/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * Replaces the list of people that have push access to this branch. This removes all people that previously had push access and grants push access to the new list of people.
     *
     * | Type    | Description                                                                                                                   |
     * | ------- | ----------------------------------------------------------------------------------------------------------------------------- |
     * | `array` | Usernames for people who can have push access. **Note**: The list of users, apps, and teams in total is limited to 100 items. |
     */
    put: operations["repos/set-user-access-restrictions"];
    /**
     * Add user access restrictions
     * @description Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/enterprise-server@3.10/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * Grants the specified people push access for this branch.
     *
     * | Type    | Description                                                                                                                   |
     * | ------- | ----------------------------------------------------------------------------------------------------------------------------- |
     * | `array` | Usernames for people who can have push access. **Note**: The list of users, apps, and teams in total is limited to 100 items. |
     */
    post: operations["repos/add-user-access-restrictions"];
    /**
     * Remove user access restrictions
     * @description Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/enterprise-server@3.10/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * Removes the ability of a user to push to this branch.
     *
     * | Type    | Description                                                                                                                                   |
     * | ------- | --------------------------------------------------------------------------------------------------------------------------------------------- |
     * | `array` | Usernames of the people who should no longer have push access. **Note**: The list of users, apps, and teams in total is limited to 100 items. |
     */
    delete: operations["repos/remove-user-access-restrictions"];
  };
  "/repos/{owner}/{repo}/branches/{branch}/rename": {
    /**
     * Rename a branch
     * @description Renames a branch in a repository.
     *
     * **Note:** Although the API responds immediately, the branch rename process might take some extra time to complete in the background. You won't be able to push to the old branch name while the rename process is in progress. For more information, see "[Renaming a branch](https://docs.github.com/enterprise-server@3.10/github/administering-a-repository/renaming-a-branch)".
     *
     * The authenticated user must have push access to the branch. If the branch is the default branch, the authenticated user must also have admin or owner permissions.
     *
     * In order to rename the default branch, fine-grained access tokens also need the `administration:write` repository permission.
     */
    post: operations["repos/rename-branch"];
  };
  "/repos/{owner}/{repo}/check-runs": {
    /**
     * Create a check run
     * @description **Note:** The Checks API only looks for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array.
     *
     * Creates a new check run for a specific commit in a repository. Your GitHub App must have the `checks:write` permission to create check runs.
     *
     * In a check suite, GitHub limits the number of check runs with the same name to 1000. Once these check runs exceed 1000, GitHub will start to automatically delete older check runs.
     */
    post: operations["checks/create"];
  };
  "/repos/{owner}/{repo}/check-runs/{check_run_id}": {
    /**
     * Get a check run
     * @description Gets a single check run using its `id`.
     *
     * **Note:** The Checks API only looks for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array.
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint on a private repository.
     */
    get: operations["checks/get"];
    /**
     * Update a check run
     * @description Updates a check run for a specific commit in a repository.
     *
     * **Note:** The endpoints to manage checks only look for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array.
     *
     * OAuth apps and personal access tokens (classic) cannot use this endpoint.
     */
    patch: operations["checks/update"];
  };
  "/repos/{owner}/{repo}/check-runs/{check_run_id}/annotations": {
    /**
     * List check run annotations
     * @description Lists annotations for a check run using the annotation `id`.
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint on a private repository.
     */
    get: operations["checks/list-annotations"];
  };
  "/repos/{owner}/{repo}/check-runs/{check_run_id}/rerequest": {
    /**
     * Rerequest a check run
     * @description Triggers GitHub to rerequest an existing check run, without pushing new code to a repository. This endpoint will trigger the [`check_run` webhook](https://docs.github.com/enterprise-server@3.10/webhooks/event-payloads/#check_run) event with the action `rerequested`. When a check run is `rerequested`, its `status` is reset to `queued` and the `conclusion` is cleared.
     *
     * For more information about how to re-run GitHub Actions jobs, see "[Re-run a job from a workflow run](https://docs.github.com/enterprise-server@3.10/rest/actions/workflow-runs#re-run-a-job-from-a-workflow-run)".
     *
     * OAuth apps and personal access tokens (classic) cannot use this endpoint.
     */
    post: operations["checks/rerequest-run"];
  };
  "/repos/{owner}/{repo}/check-suites": {
    /**
     * Create a check suite
     * @description Creates a check suite manually. By default, check suites are automatically created when you create a [check run](https://docs.github.com/enterprise-server@3.10/rest/checks/runs). You only need to use this endpoint for manually creating check suites when you've disabled automatic creation using "[Update repository preferences for check suites](https://docs.github.com/enterprise-server@3.10/rest/checks/suites#update-repository-preferences-for-check-suites)".
     *
     * **Note:** The Checks API only looks for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array and a `null` value for `head_branch`.
     *
     * OAuth apps and personal access tokens (classic) cannot use this endpoint.
     */
    post: operations["checks/create-suite"];
  };
  "/repos/{owner}/{repo}/check-suites/preferences": {
    /**
     * Update repository preferences for check suites
     * @description Changes the default automatic flow when creating check suites. By default, a check suite is automatically created each time code is pushed to a repository. When you disable the automatic creation of check suites, you can manually [Create a check suite](https://docs.github.com/enterprise-server@3.10/rest/checks/suites#create-a-check-suite).
     * You must have admin permissions in the repository to set preferences for check suites.
     */
    patch: operations["checks/set-suites-preferences"];
  };
  "/repos/{owner}/{repo}/check-suites/{check_suite_id}": {
    /**
     * Get a check suite
     * @description Gets a single check suite using its `id`.
     *
     * **Note:** The Checks API only looks for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array and a `null` value for `head_branch`.
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint on a private repository.
     */
    get: operations["checks/get-suite"];
  };
  "/repos/{owner}/{repo}/check-suites/{check_suite_id}/check-runs": {
    /**
     * List check runs in a check suite
     * @description Lists check runs for a check suite using its `id`.
     *
     * **Note:** The endpoints to manage checks only look for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array.
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint on a private repository.
     */
    get: operations["checks/list-for-suite"];
  };
  "/repos/{owner}/{repo}/check-suites/{check_suite_id}/rerequest": {
    /**
     * Rerequest a check suite
     * @description Triggers GitHub to rerequest an existing check suite, without pushing new code to a repository. This endpoint will trigger the [`check_suite` webhook](https://docs.github.com/enterprise-server@3.10/webhooks/event-payloads/#check_suite) event with the action `rerequested`. When a check suite is `rerequested`, its `status` is reset to `queued` and the `conclusion` is cleared.
     *
     * OAuth apps and personal access tokens (classic) cannot use this endpoint.
     */
    post: operations["checks/rerequest-suite"];
  };
  "/repos/{owner}/{repo}/code-scanning/alerts": {
    /**
     * List code scanning alerts for a repository
     * @description Lists code scanning alerts.
     *
     * The response includes a `most_recent_instance` object.
     * This provides details of the most recent instance of this alert
     * for the default branch (or for the specified Git reference if you used `ref` in the request).
     *
     * OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint with private or public repositories, or the `public_repo` scope to use this endpoint with only public repositories.
     */
    get: operations["code-scanning/list-alerts-for-repo"];
  };
  "/repos/{owner}/{repo}/code-scanning/alerts/{alert_number}": {
    /**
     * Get a code scanning alert
     * @description Gets a single code scanning alert.
     *
     * OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint with private or public repositories, or the `public_repo` scope to use this endpoint with only public repositories.
     */
    get: operations["code-scanning/get-alert"];
    /**
     * Update a code scanning alert
     * @description Updates the status of a single code scanning alert.
     * OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint with private or public repositories, or the `public_repo` scope to use this endpoint with only public repositories.
     */
    patch: operations["code-scanning/update-alert"];
  };
  "/repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/instances": {
    /**
     * List instances of a code scanning alert
     * @description Lists all instances of the specified code scanning alert.
     *
     * OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint with private or public repositories, or the `public_repo` scope to use this endpoint with only public repositories.
     */
    get: operations["code-scanning/list-alert-instances"];
  };
  "/repos/{owner}/{repo}/code-scanning/analyses": {
    /**
     * List code scanning analyses for a repository
     * @description Lists the details of all code scanning analyses for a repository,
     * starting with the most recent.
     * The response is paginated and you can use the `page` and `per_page` parameters
     * to list the analyses you're interested in.
     * By default 30 analyses are listed per page.
     *
     * The `rules_count` field in the response give the number of rules
     * that were run in the analysis.
     * For very old analyses this data is not available,
     * and `0` is returned in this field.
     *
     * **Deprecation notice**:
     * The `tool_name` field is deprecated and will, in future, not be included in the response for this endpoint. The example response reflects this change. The tool name can now be found inside the `tool` field.
     *
     * OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint with private or public repositories, or the `public_repo` scope to use this endpoint with only public repositories.
     */
    get: operations["code-scanning/list-recent-analyses"];
  };
  "/repos/{owner}/{repo}/code-scanning/analyses/{analysis_id}": {
    /**
     * Get a code scanning analysis for a repository
     * @description Gets a specified code scanning analysis for a repository.
     *
     * The default JSON response contains fields that describe the analysis.
     * This includes the Git reference and commit SHA to which the analysis relates,
     * the datetime of the analysis, the name of the code scanning tool,
     * and the number of alerts.
     *
     * The `rules_count` field in the default response give the number of rules
     * that were run in the analysis.
     * For very old analyses this data is not available,
     * and `0` is returned in this field.
     *
     * This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/enterprise-server@3.10/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
     *
     * - **`application/sarif+json`**: Instead of returning a summary of the analysis, this endpoint returns a subset of the analysis data that was uploaded. The data is formatted as [SARIF version 2.1.0](https://docs.oasis-open.org/sarif/sarif/v2.1.0/cs01/sarif-v2.1.0-cs01.html). It also returns additional data such as the `github/alertNumber` and `github/alertUrl` properties.
     *
     * OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint with private or public repositories, or the `public_repo` scope to use this endpoint with only public repositories.
     */
    get: operations["code-scanning/get-analysis"];
    /**
     * Delete a code scanning analysis from a repository
     * @description Deletes a specified code scanning analysis from a repository.
     *
     * You can delete one analysis at a time.
     * To delete a series of analyses, start with the most recent analysis and work backwards.
     * Conceptually, the process is similar to the undo function in a text editor.
     *
     * When you list the analyses for a repository,
     * one or more will be identified as deletable in the response:
     *
     * ```
     * "deletable": true
     * ```
     *
     * An analysis is deletable when it's the most recent in a set of analyses.
     * Typically, a repository will have multiple sets of analyses
     * for each enabled code scanning tool,
     * where a set is determined by a unique combination of analysis values:
     *
     * * `ref`
     * * `tool`
     * * `category`
     *
     * If you attempt to delete an analysis that is not the most recent in a set,
     * you'll get a 400 response with the message:
     *
     * ```
     * Analysis specified is not deletable.
     * ```
     *
     * The response from a successful `DELETE` operation provides you with
     * two alternative URLs for deleting the next analysis in the set:
     * `next_analysis_url` and `confirm_delete_url`.
     * Use the `next_analysis_url` URL if you want to avoid accidentally deleting the final analysis
     * in a set. This is a useful option if you want to preserve at least one analysis
     * for the specified tool in your repository.
     * Use the `confirm_delete_url` URL if you are content to remove all analyses for a tool.
     * When you delete the last analysis in a set, the value of `next_analysis_url` and `confirm_delete_url`
     * in the 200 response is `null`.
     *
     * As an example of the deletion process,
     * let's imagine that you added a workflow that configured a particular code scanning tool
     * to analyze the code in a repository. This tool has added 15 analyses:
     * 10 on the default branch, and another 5 on a topic branch.
     * You therefore have two separate sets of analyses for this tool.
     * You've now decided that you want to remove all of the analyses for the tool.
     * To do this you must make 15 separate deletion requests.
     * To start, you must find an analysis that's identified as deletable.
     * Each set of analyses always has one that's identified as deletable.
     * Having found the deletable analysis for one of the two sets,
     * delete this analysis and then continue deleting the next analysis in the set until they're all deleted.
     * Then repeat the process for the second set.
     * The procedure therefore consists of a nested loop:
     *
     * **Outer loop**:
     * * List the analyses for the repository, filtered by tool.
     * * Parse this list to find a deletable analysis. If found:
     *
     *   **Inner loop**:
     *   * Delete the identified analysis.
     *   * Parse the response for the value of `confirm_delete_url` and, if found, use this in the next iteration.
     *
     * The above process assumes that you want to remove all trace of the tool's analyses from the GitHub user interface, for the specified repository, and it therefore uses the `confirm_delete_url` value. Alternatively, you could use the `next_analysis_url` value, which would leave the last analysis in each set undeleted to avoid removing a tool's analysis entirely.
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with private or public repositories, or the `public_repo` scope to use this endpoint with only public repositories.
     */
    delete: operations["code-scanning/delete-analysis"];
  };
  "/repos/{owner}/{repo}/code-scanning/default-setup": {
    /**
     * Get a code scanning default setup configuration
     * @description Gets a code scanning default setup configuration.
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with private or public repositories, or the `public_repo` scope to use this endpoint with only public repositories.
     */
    get: operations["code-scanning/get-default-setup"];
    /**
     * Update a code scanning default setup configuration
     * @description Updates a code scanning default setup configuration.
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with private or public repositories, or the `public_repo` scope to use this endpoint with only public repositories.
     */
    patch: operations["code-scanning/update-default-setup"];
  };
  "/repos/{owner}/{repo}/code-scanning/sarifs": {
    /**
     * Upload an analysis as SARIF data
     * @description Uploads SARIF data containing the results of a code scanning analysis to make the results available in a repository. For troubleshooting information, see "[Troubleshooting SARIF uploads](https://docs.github.com/enterprise-server@3.10/code-security/code-scanning/troubleshooting-sarif)."
     *
     * There are two places where you can upload code scanning results.
     *  - If you upload to a pull request, for example `--ref refs/pull/42/merge` or `--ref refs/pull/42/head`, then the results appear as alerts in a pull request check. For more information, see "[Triaging code scanning alerts in pull requests](/code-security/secure-coding/triaging-code-scanning-alerts-in-pull-requests)."
     *  - If you upload to a branch, for example `--ref refs/heads/my-branch`, then the results appear in the **Security** tab for your repository. For more information, see "[Managing code scanning alerts for your repository](/code-security/secure-coding/managing-code-scanning-alerts-for-your-repository#viewing-the-alerts-for-a-repository)."
     *
     * You must compress the SARIF-formatted analysis data that you want to upload, using `gzip`, and then encode it as a Base64 format string. For example:
     *
     * ```
     * gzip -c analysis-data.sarif | base64 -w0
     * ```
     *
     * SARIF upload supports a maximum number of entries per the following data objects, and an analysis will be rejected if any of these objects is above its maximum value. For some objects, there are additional values over which the entries will be ignored while keeping the most important entries whenever applicable.
     * To get the most out of your analysis when it includes data above the supported limits, try to optimize the analysis configuration. For example, for the CodeQL tool, identify and remove the most noisy queries. For more information, see "[SARIF results exceed one or more limits](https://docs.github.com/enterprise-server@3.10/code-security/code-scanning/troubleshooting-sarif/results-exceed-limit)."
     *
     *
     * | **SARIF data**                   | **Maximum values** | **Additional limits**                                                            |
     * |----------------------------------|:------------------:|----------------------------------------------------------------------------------|
     * | Runs per file                    |         20         |                                                                                  |
     * | Results per run                  |       25,000       | Only the top 5,000 results will be included, prioritized by severity.            |
     * | Rules per run                    |       25,000       |                                                                                  |
     * | Tool extensions per run          |        100         |                                                                                  |
     * | Thread Flow Locations per result |       10,000       | Only the top 1,000 Thread Flow Locations will be included, using prioritization. |
     * | Location per result	             |       1,000        | Only 100 locations will be included.                                             |
     * | Tags per rule	                   |         20         | Only 10 tags will be included.                                                   |
     *
     *
     * The `202 Accepted` response includes an `id` value.
     * You can use this ID to check the status of the upload by using it in the `/sarifs/{sarif_id}` endpoint.
     * For more information, see "[Get information about a SARIF upload](/rest/code-scanning/code-scanning#get-information-about-a-sarif-upload)."
     *
     * OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint with private or public repositories, or the `public_repo` scope to use this endpoint with only public repositories.
     */
    post: operations["code-scanning/upload-sarif"];
  };
  "/repos/{owner}/{repo}/code-scanning/sarifs/{sarif_id}": {
    /**
     * Get information about a SARIF upload
     * @description Gets information about a SARIF upload, including the status and the URL of the analysis that was uploaded so that you can retrieve details of the analysis. For more information, see "[Get a code scanning analysis for a repository](/rest/code-scanning/code-scanning#get-a-code-scanning-analysis-for-a-repository)."
     * OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint with private or public repositories, or the `public_repo` scope to use this endpoint with only public repositories.
     */
    get: operations["code-scanning/get-sarif"];
  };
  "/repos/{owner}/{repo}/codeowners/errors": {
    /**
     * List CODEOWNERS errors
     * @description List any syntax errors that are detected in the CODEOWNERS
     * file.
     *
     * For more information about the correct CODEOWNERS syntax,
     * see "[About code owners](https://docs.github.com/enterprise-server@3.10/repositories/managing-your-repositorys-settings-and-features/customizing-your-repository/about-code-owners)."
     */
    get: operations["repos/codeowners-errors"];
  };
  "/repos/{owner}/{repo}/collaborators": {
    /**
     * List repository collaborators
     * @description For organization-owned repositories, the list of collaborators includes outside collaborators, organization members that are direct collaborators, organization members with access through team memberships, organization members with access through default organization permissions, and organization owners.
     * Organization members with write, maintain, or admin privileges on the organization-owned repository can use this endpoint.
     *
     * Team members will include the members of child teams.
     *
     * The authenticated user must have push access to the repository to use this endpoint.
     *
     * OAuth app tokens and personal access tokens (classic) need the `read:org` and `repo` scopes to use this endpoint.
     */
    get: operations["repos/list-collaborators"];
  };
  "/repos/{owner}/{repo}/collaborators/{username}": {
    /**
     * Check if a user is a repository collaborator
     * @description For organization-owned repositories, the list of collaborators includes outside collaborators, organization members that are direct collaborators, organization members with access through team memberships, organization members with access through default organization permissions, and organization owners.
     *
     * Team members will include the members of child teams.
     *
     * The authenticated user must have push access to the repository to use this endpoint.
     *
     * OAuth app tokens and personal access tokens (classic) need the `read:org` and `repo` scopes to use this endpoint.
     */
    get: operations["repos/check-collaborator"];
    /**
     * Add a repository collaborator
     * @description This endpoint triggers [notifications](https://docs.github.com/enterprise-server@3.10/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/enterprise-server@3.10/rest/overview/rate-limits-for-the-rest-api#about-secondary-rate-limits)" and "[Best practices for using the REST API](https://docs.github.com/enterprise-server@3.10/rest/guides/best-practices-for-using-the-rest-api)."
     *
     * Adding an outside collaborator may be restricted by enterprise administrators. For more information, see "[Enforcing repository management policies in your enterprise](https://docs.github.com/enterprise-server@3.10/admin/policies/enforcing-policies-for-your-enterprise/enforcing-repository-management-policies-in-your-enterprise#enforcing-a-policy-for-inviting-outside-collaborators-to-repositories)."
     *
     * For more information on permission levels, see "[Repository permission levels for an organization](https://docs.github.com/enterprise-server@3.10/github/setting-up-and-managing-organizations-and-teams/repository-permission-levels-for-an-organization#permission-levels-for-repositories-owned-by-an-organization)". There are restrictions on which permissions can be granted to organization members when an organization base role is in place. In this case, the permission being given must be equal to or higher than the org base permission. Otherwise, the request will fail with:
     *
     * ```
     * Cannot assign {member} permission of {role name}
     * ```
     *
     * Note that, if you choose not to pass any parameters, you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP method](https://docs.github.com/enterprise-server@3.10/rest/guides/getting-started-with-the-rest-api#http-method)."
     *
     * **Updating an existing collaborator's permission level**
     *
     * The endpoint can also be used to change the permissions of an existing collaborator without first removing and re-adding the collaborator. To change the permissions, use the same endpoint and pass a different `permission` parameter. The response will be a `204`, with no other indication that the permission level changed.
     */
    put: operations["repos/add-collaborator"];
    /**
     * Remove a repository collaborator
     * @description Removes a collaborator from a repository.
     *
     * To use this endpoint, the authenticated user must either be an administrator of the repository or target themselves for removal.
     *
     * This endpoint also:
     * - Cancels any outstanding invitations
     * - Unasigns the user from any issues
     * - Removes access to organization projects if the user is not an organization member and is not a collaborator on any other organization repositories.
     * - Unstars the repository
     * - Updates access permissions to packages
     *
     * Removing a user as a collaborator has the following effects on forks:
     *  - If the user had access to a fork through their membership to this repository, the user will also be removed from the fork.
     *  - If the user had their own fork of the repository, the fork will be deleted.
     *  - If the user still has read access to the repository, open pull requests by this user from a fork will be denied.
     *
     * **Note**: A user can still have access to the repository through organization permissions like base repository permissions.
     *
     * Although the API responds immediately, the additional permission updates might take some extra time to complete in the background.
     *
     * For more information on fork permissions, see "[About permissions and visibility of forks](https://docs.github.com/enterprise-server@3.10/pull-requests/collaborating-with-pull-requests/working-with-forks/about-permissions-and-visibility-of-forks)".
     */
    delete: operations["repos/remove-collaborator"];
  };
  "/repos/{owner}/{repo}/collaborators/{username}/permission": {
    /**
     * Get repository permissions for a user
     * @description Checks the repository permission of a collaborator. The possible repository
     * permissions are `admin`, `write`, `read`, and `none`.
     *
     * *Note*: The `permission` attribute provides the legacy base roles of `admin`, `write`, `read`, and `none`, where the
     * `maintain` role is mapped to `write` and the `triage` role is mapped to `read`. To determine the role assigned to the
     * collaborator, see the `role_name` attribute, which will provide the full role name, including custom roles. The
     * `permissions` hash can also be used to determine which base level of access the collaborator has to the repository.
     */
    get: operations["repos/get-collaborator-permission-level"];
  };
  "/repos/{owner}/{repo}/comments": {
    /**
     * List commit comments for a repository
     * @description Lists the commit comments for a specified repository. Comments are ordered by ascending ID.
     *
     * This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/enterprise-server@3.10/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
     *
     * - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
     * - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
     * - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
     * - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
     */
    get: operations["repos/list-commit-comments-for-repo"];
  };
  "/repos/{owner}/{repo}/comments/{comment_id}": {
    /**
     * Get a commit comment
     * @description Gets a specified commit comment.
     *
     * This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/enterprise-server@3.10/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
     *
     * - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
     * - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
     * - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
     * - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
     */
    get: operations["repos/get-commit-comment"];
    /** Delete a commit comment */
    delete: operations["repos/delete-commit-comment"];
    /**
     * Update a commit comment
     * @description Updates the contents of a specified commit comment.
     *
     * This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/enterprise-server@3.10/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
     *
     * - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
     * - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
     * - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
     * - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
     */
    patch: operations["repos/update-commit-comment"];
  };
  "/repos/{owner}/{repo}/comments/{comment_id}/reactions": {
    /**
     * List reactions for a commit comment
     * @description List the reactions to a [commit comment](https://docs.github.com/enterprise-server@3.10/rest/commits/comments#get-a-commit-comment).
     */
    get: operations["reactions/list-for-commit-comment"];
    /**
     * Create reaction for a commit comment
     * @description Create a reaction to a [commit comment](https://docs.github.com/enterprise-server@3.10/rest/commits/comments#get-a-commit-comment). A response with an HTTP `200` status means that you already added the reaction type to this commit comment.
     */
    post: operations["reactions/create-for-commit-comment"];
  };
  "/repos/{owner}/{repo}/comments/{comment_id}/reactions/{reaction_id}": {
    /**
     * Delete a commit comment reaction
     * @description **Note:** You can also specify a repository by `repository_id` using the route `DELETE /repositories/:repository_id/comments/:comment_id/reactions/:reaction_id`.
     *
     * Delete a reaction to a [commit comment](https://docs.github.com/enterprise-server@3.10/rest/commits/comments#get-a-commit-comment).
     */
    delete: operations["reactions/delete-for-commit-comment"];
  };
  "/repos/{owner}/{repo}/commits": {
    /**
     * List commits
     * @description **Signature verification object**
     *
     * The response will include a `verification` object that describes the result of verifying the commit's signature. The following fields are included in the `verification` object:
     *
     * | Name | Type | Description |
     * | ---- | ---- | ----------- |
     * | `verified` | `boolean` | Indicates whether GitHub considers the signature in this commit to be verified. |
     * | `reason` | `string` | The reason for verified value. Possible values and their meanings are enumerated in table below. |
     * | `signature` | `string` | The signature that was extracted from the commit. |
     * | `payload` | `string` | The value that was signed. |
     *
     * These are the possible values for `reason` in the `verification` object:
     *
     * | Value | Description |
     * | ----- | ----------- |
     * | `expired_key` | The key that made the signature is expired. |
     * | `not_signing_key` | The "signing" flag is not among the usage flags in the GPG key that made the signature. |
     * | `gpgverify_error` | There was an error communicating with the signature verification service. |
     * | `gpgverify_unavailable` | The signature verification service is currently unavailable. |
     * | `unsigned` | The object does not include a signature. |
     * | `unknown_signature_type` | A non-PGP signature was found in the commit. |
     * | `no_user` | No user was associated with the `committer` email address in the commit. |
     * | `unverified_email` | The `committer` email address in the commit was associated with a user, but the email address is not verified on their account. |
     * | `bad_email` | The `committer` email address in the commit is not included in the identities of the PGP key that made the signature. |
     * | `unknown_key` | The key that made the signature has not been registered with any user's account. |
     * | `malformed_signature` | There was an error parsing the signature. |
     * | `invalid` | The signature could not be cryptographically verified using the key whose key-id was found in the signature. |
     * | `valid` | None of the above errors applied, so the signature is considered to be verified. |
     */
    get: operations["repos/list-commits"];
  };
  "/repos/{owner}/{repo}/commits/{commit_sha}/branches-where-head": {
    /**
     * List branches for HEAD commit
     * @description Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/enterprise-server@3.10/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * Returns all branches where the given commit SHA is the HEAD, or latest commit for the branch.
     */
    get: operations["repos/list-branches-for-head-commit"];
  };
  "/repos/{owner}/{repo}/commits/{commit_sha}/comments": {
    /**
     * List commit comments
     * @description Lists the comments for a specified commit.
     *
     * This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/enterprise-server@3.10/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
     *
     * - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
     * - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
     * - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
     * - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
     */
    get: operations["repos/list-comments-for-commit"];
    /**
     * Create a commit comment
     * @description Create a comment for a commit using its `:commit_sha`.
     *
     * This endpoint triggers [notifications](https://docs.github.com/enterprise-server@3.10/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/enterprise-server@3.10/rest/overview/rate-limits-for-the-rest-api#about-secondary-rate-limits)" and "[Best practices for using the REST API](https://docs.github.com/enterprise-server@3.10/rest/guides/best-practices-for-using-the-rest-api)."
     *
     * This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/enterprise-server@3.10/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
     *
     * - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
     * - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
     * - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
     * - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
     */
    post: operations["repos/create-commit-comment"];
  };
  "/repos/{owner}/{repo}/commits/{commit_sha}/pulls": {
    /**
     * List pull requests associated with a commit
     * @description Lists the merged pull request that introduced the commit to the repository. If the commit is not present in the default branch, will only return open pull requests associated with the commit.
     *
     * To list the open or merged pull requests associated with a branch, you can set the `commit_sha` parameter to the branch name.
     */
    get: operations["repos/list-pull-requests-associated-with-commit"];
  };
  "/repos/{owner}/{repo}/commits/{ref}": {
    /**
     * Get a commit
     * @description Returns the contents of a single commit reference. You must have `read` access for the repository to use this endpoint.
     *
     * **Note:** If there are more than 300 files in the commit diff and the default JSON media type is requested, the response will include pagination link headers for the remaining files, up to a limit of 3000 files. Each page contains the static commit information, and the only changes are to the file listing.
     *
     * This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/enterprise-server@3.10/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)." Pagination query parameters are not supported for these media types.
     *
     * - **`application/vnd.github.diff`**: Returns the diff of the commit. Larger diffs may time out and return a 5xx status code.
     * - **`application/vnd.github.patch`**: Returns the patch of the commit. Diffs with binary data will have no `patch` property. Larger diffs may time out and return a 5xx status code.
     * - **`application/vnd.github.sha`**: Returns the commit's SHA-1 hash. You can use this endpoint to check if a remote reference's SHA-1 hash is the same as your local reference's SHA-1 hash by providing the local SHA-1 reference as the ETag.
     *
     * **Signature verification object**
     *
     * The response will include a `verification` object that describes the result of verifying the commit's signature. The following fields are included in the `verification` object:
     *
     * | Name | Type | Description |
     * | ---- | ---- | ----------- |
     * | `verified` | `boolean` | Indicates whether GitHub considers the signature in this commit to be verified. |
     * | `reason` | `string` | The reason for verified value. Possible values and their meanings are enumerated in table below. |
     * | `signature` | `string` | The signature that was extracted from the commit. |
     * | `payload` | `string` | The value that was signed. |
     *
     * These are the possible values for `reason` in the `verification` object:
     *
     * | Value | Description |
     * | ----- | ----------- |
     * | `expired_key` | The key that made the signature is expired. |
     * | `not_signing_key` | The "signing" flag is not among the usage flags in the GPG key that made the signature. |
     * | `gpgverify_error` | There was an error communicating with the signature verification service. |
     * | `gpgverify_unavailable` | The signature verification service is currently unavailable. |
     * | `unsigned` | The object does not include a signature. |
     * | `unknown_signature_type` | A non-PGP signature was found in the commit. |
     * | `no_user` | No user was associated with the `committer` email address in the commit. |
     * | `unverified_email` | The `committer` email address in the commit was associated with a user, but the email address is not verified on their account. |
     * | `bad_email` | The `committer` email address in the commit is not included in the identities of the PGP key that made the signature. |
     * | `unknown_key` | The key that made the signature has not been registered with any user's account. |
     * | `malformed_signature` | There was an error parsing the signature. |
     * | `invalid` | The signature could not be cryptographically verified using the key whose key-id was found in the signature. |
     * | `valid` | None of the above errors applied, so the signature is considered to be verified. |
     */
    get: operations["repos/get-commit"];
  };
  "/repos/{owner}/{repo}/commits/{ref}/check-runs": {
    /**
     * List check runs for a Git reference
     * @description Lists check runs for a commit ref. The `ref` can be a SHA, branch name, or a tag name.
     *
     * **Note:** The endpoints to manage checks only look for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array.
     *
     * If there are more than 1000 check suites on a single git reference, this endpoint will limit check runs to the 1000 most recent check suites. To iterate over all possible check runs, use the [List check suites for a Git reference](https://docs.github.com/enterprise-server@3.10/rest/reference/checks#list-check-suites-for-a-git-reference) endpoint and provide the `check_suite_id` parameter to the [List check runs in a check suite](https://docs.github.com/enterprise-server@3.10/rest/reference/checks#list-check-runs-in-a-check-suite) endpoint.
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint on a private repository.
     */
    get: operations["checks/list-for-ref"];
  };
  "/repos/{owner}/{repo}/commits/{ref}/check-suites": {
    /**
     * List check suites for a Git reference
     * @description Lists check suites for a commit `ref`. The `ref` can be a SHA, branch name, or a tag name.
     *
     * **Note:** The endpoints to manage checks only look for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array and a `null` value for `head_branch`.
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint on a private repository.
     */
    get: operations["checks/list-suites-for-ref"];
  };
  "/repos/{owner}/{repo}/commits/{ref}/status": {
    /**
     * Get the combined status for a specific reference
     * @description Users with pull access in a repository can access a combined view of commit statuses for a given ref. The ref can be a SHA, a branch name, or a tag name.
     *
     *
     * Additionally, a combined `state` is returned. The `state` is one of:
     *
     * *   **failure** if any of the contexts report as `error` or `failure`
     * *   **pending** if there are no statuses or a context is `pending`
     * *   **success** if the latest status for all contexts is `success`
     */
    get: operations["repos/get-combined-status-for-ref"];
  };
  "/repos/{owner}/{repo}/commits/{ref}/statuses": {
    /**
     * List commit statuses for a reference
     * @description Users with pull access in a repository can view commit statuses for a given ref. The ref can be a SHA, a branch name, or a tag name. Statuses are returned in reverse chronological order. The first status in the list will be the latest one.
     *
     * This resource is also available via a legacy route: `GET /repos/:owner/:repo/statuses/:ref`.
     */
    get: operations["repos/list-commit-statuses-for-ref"];
  };
  "/repos/{owner}/{repo}/compare/{basehead}": {
    /**
     * Compare two commits
     * @description Compares two commits against one another. You can compare refs (branches or tags) and commit SHAs in the same repository, or you can compare refs and commit SHAs that exist in different repositories within the same repository network, including fork branches. For more information about how to view a repository's network, see "[Understanding connections between repositories](https://docs.github.com/enterprise-server@3.10/repositories/viewing-activity-and-data-for-your-repository/understanding-connections-between-repositories)."
     *
     * This endpoint is equivalent to running the `git log BASE..HEAD` command, but it returns commits in a different order. The `git log BASE..HEAD` command returns commits in reverse chronological order, whereas the API returns commits in chronological order.
     *
     * This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/enterprise-server@3.10/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
     *
     * - **`application/vnd.github.diff`**: Returns the diff of the commit.
     * - **`application/vnd.github.patch`**: Returns the patch of the commit. Diffs with binary data will have no `patch` property.
     *
     * The API response includes details about the files that were changed between the two commits. This includes the status of the change (if a file was added, removed, modified, or renamed), and details of the change itself. For example, files with a `renamed` status have a `previous_filename` field showing the previous filename of the file, and files with a `modified` status have a `patch` field showing the changes made to the file.
     *
     * When calling this endpoint without any paging parameter (`per_page` or `page`), the returned list is limited to 250 commits, and the last commit in the list is the most recent of the entire comparison.
     *
     * **Working with large comparisons**
     *
     * To process a response with a large number of commits, use a query parameter (`per_page` or `page`) to paginate the results. When using pagination:
     *
     * - The list of changed files is only shown on the first page of results, but it includes all changed files for the entire comparison.
     * - The results are returned in chronological order, but the last commit in the returned list may not be the most recent one in the entire set if there are more pages of results.
     *
     * For more information on working with pagination, see "[Using pagination in the REST API](https://docs.github.com/enterprise-server@3.10/rest/guides/using-pagination-in-the-rest-api)."
     *
     * **Signature verification object**
     *
     * The response will include a `verification` object that describes the result of verifying the commit's signature. The `verification` object includes the following fields:
     *
     * | Name | Type | Description |
     * | ---- | ---- | ----------- |
     * | `verified` | `boolean` | Indicates whether GitHub considers the signature in this commit to be verified. |
     * | `reason` | `string` | The reason for verified value. Possible values and their meanings are enumerated in table below. |
     * | `signature` | `string` | The signature that was extracted from the commit. |
     * | `payload` | `string` | The value that was signed. |
     *
     * These are the possible values for `reason` in the `verification` object:
     *
     * | Value | Description |
     * | ----- | ----------- |
     * | `expired_key` | The key that made the signature is expired. |
     * | `not_signing_key` | The "signing" flag is not among the usage flags in the GPG key that made the signature. |
     * | `gpgverify_error` | There was an error communicating with the signature verification service. |
     * | `gpgverify_unavailable` | The signature verification service is currently unavailable. |
     * | `unsigned` | The object does not include a signature. |
     * | `unknown_signature_type` | A non-PGP signature was found in the commit. |
     * | `no_user` | No user was associated with the `committer` email address in the commit. |
     * | `unverified_email` | The `committer` email address in the commit was associated with a user, but the email address is not verified on their account. |
     * | `bad_email` | The `committer` email address in the commit is not included in the identities of the PGP key that made the signature. |
     * | `unknown_key` | The key that made the signature has not been registered with any user's account. |
     * | `malformed_signature` | There was an error parsing the signature. |
     * | `invalid` | The signature could not be cryptographically verified using the key whose key-id was found in the signature. |
     * | `valid` | None of the above errors applied, so the signature is considered to be verified. |
     */
    get: operations["repos/compare-commits-with-basehead"];
  };
  "/repos/{owner}/{repo}/contents/{path}": {
    /**
     * Get repository content
     * @description Gets the contents of a file or directory in a repository. Specify the file path or directory with the `path` parameter. If you omit the `path` parameter, you will receive the contents of the repository's root directory.
     *
     * This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/enterprise-server@3.10/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
     *
     * - **`application/vnd.github.raw+json`**: Returns the raw file contents for files and symlinks.
     * - **`application/vnd.github.html+json`**: Returns the file contents in HTML. Markup languages are rendered to HTML using GitHub's open-source [Markup library](https://github.com/github/markup).
     * - **`application/vnd.github.object+json`**: Returns the contents in a consistent object format regardless of the content type. For example, instead of an array of objects for a directory, the response will be an object with an `entries` attribute containing the array of objects.
     *
     * If the content is a directory, the response will be an array of objects, one object for each item in the directory. When listing the contents of a directory, submodules have their "type" specified as "file". Logically, the value _should_ be "submodule". This behavior exists [for backwards compatibility purposes](https://git.io/v1YCW). In the next major version of the API, the type will be returned as "submodule".
     *
     * If the content is a symlink and the symlink's target is a normal file in the repository, then the API responds with the content of the file. Otherwise, the API responds with an object describing the symlink itself.
     *
     * If the content is a submodule, the `submodule_git_url` field identifies the location of the submodule repository, and the `sha` identifies a specific commit within the submodule repository. Git uses the given URL when cloning the submodule repository, and checks out the submodule at that specific commit. If the submodule repository is not hosted on github.com, the Git URLs (`git_url` and `_links["git"]`) and the github.com URLs (`html_url` and `_links["html"]`) will have null values.
     *
     * **Notes**:
     *
     * - To get a repository's contents recursively, you can [recursively get the tree](https://docs.github.com/enterprise-server@3.10/rest/git/trees#get-a-tree).
     * - This API has an upper limit of 1,000 files for a directory. If you need to retrieve
     * more files, use the [Git Trees API](https://docs.github.com/enterprise-server@3.10/rest/git/trees#get-a-tree).
     * - Download URLs expire and are meant to be used just once. To ensure the download URL does not expire, please use the contents API to obtain a fresh download URL for each download.
     * - If the requested file's size is:
     *   - 1 MB or smaller: All features of this endpoint are supported.
     *   - Between 1-100 MB: Only the `raw` or `object` custom media types are supported. Both will work as normal, except that when using the `object` media type, the `content` field will be an empty
     * string and the `encoding` field will be `"none"`. To get the contents of these larger files, use the `raw` media type.
     *   - Greater than 100 MB: This endpoint is not supported.
     */
    get: operations["repos/get-content"];
    /**
     * Create or update file contents
     * @description Creates a new file or replaces an existing file in a repository.
     *
     * **Note:** If you use this endpoint and the "[Delete a file](https://docs.github.com/enterprise-server@3.10/rest/repos/contents/#delete-a-file)" endpoint in parallel, the concurrent requests will conflict and you will receive errors. You must use these endpoints serially instead.
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint. The `workflow` scope is also required in order to modify files in the `.github/workflows` directory.
     */
    put: operations["repos/create-or-update-file-contents"];
    /**
     * Delete a file
     * @description Deletes a file in a repository.
     *
     * You can provide an additional `committer` parameter, which is an object containing information about the committer. Or, you can provide an `author` parameter, which is an object containing information about the author.
     *
     * The `author` section is optional and is filled in with the `committer` information if omitted. If the `committer` information is omitted, the authenticated user's information is used.
     *
     * You must provide values for both `name` and `email`, whether you choose to use `author` or `committer`. Otherwise, you'll receive a `422` status code.
     *
     * **Note:** If you use this endpoint and the "[Create or update file contents](https://docs.github.com/enterprise-server@3.10/rest/repos/contents/#create-or-update-file-contents)" endpoint in parallel, the concurrent requests will conflict and you will receive errors. You must use these endpoints serially instead.
     */
    delete: operations["repos/delete-file"];
  };
  "/repos/{owner}/{repo}/contributors": {
    /**
     * List repository contributors
     * @description Lists contributors to the specified repository and sorts them by the number of commits per contributor in descending order. This endpoint may return information that is a few hours old because the GitHub REST API caches contributor data to improve performance.
     *
     * GitHub identifies contributors by author email address. This endpoint groups contribution counts by GitHub user, which includes all associated email addresses. To improve performance, only the first 500 author email addresses in the repository link to GitHub users. The rest will appear as anonymous contributors without associated GitHub user information.
     */
    get: operations["repos/list-contributors"];
  };
  "/repos/{owner}/{repo}/dependabot/alerts": {
    /**
     * List Dependabot alerts for a repository
     * @description OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.
     */
    get: operations["dependabot/list-alerts-for-repo"];
  };
  "/repos/{owner}/{repo}/dependabot/alerts/{alert_number}": {
    /**
     * Get a Dependabot alert
     * @description OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.
     */
    get: operations["dependabot/get-alert"];
    /**
     * Update a Dependabot alert
     * @description The authenticated user must have access to security alerts for the repository to use this endpoint. For more information, see "[Granting access to security alerts](https://docs.github.com/enterprise-server@3.10/repositories/managing-your-repositorys-settings-and-features/enabling-features-for-your-repository/managing-security-and-analysis-settings-for-your-repository#granting-access-to-security-alerts)."
     *
     * OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.
     */
    patch: operations["dependabot/update-alert"];
  };
  "/repos/{owner}/{repo}/dependabot/secrets": {
    /**
     * List repository secrets
     * @description Lists all secrets available in a repository without revealing their encrypted
     * values.
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    get: operations["dependabot/list-repo-secrets"];
  };
  "/repos/{owner}/{repo}/dependabot/secrets/public-key": {
    /**
     * Get a repository public key
     * @description Gets your public key, which you need to encrypt secrets. You need to
     * encrypt a secret before you can create or update secrets. Anyone with read access
     * to the repository can use this endpoint.
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint if the repository is private.
     */
    get: operations["dependabot/get-repo-public-key"];
  };
  "/repos/{owner}/{repo}/dependabot/secrets/{secret_name}": {
    /**
     * Get a repository secret
     * @description Gets a single repository secret without revealing its encrypted value.
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    get: operations["dependabot/get-repo-secret"];
    /**
     * Create or update a repository secret
     * @description Creates or updates a repository secret with an encrypted value. Encrypt your secret using
     * [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages). For more information, see "[Encrypting secrets for the REST API](https://docs.github.com/enterprise-server@3.10/rest/guides/encrypting-secrets-for-the-rest-api)."
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    put: operations["dependabot/create-or-update-repo-secret"];
    /**
     * Delete a repository secret
     * @description Deletes a secret in a repository using the secret name.
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    delete: operations["dependabot/delete-repo-secret"];
  };
  "/repos/{owner}/{repo}/dependency-graph/compare/{basehead}": {
    /**
     * Get a diff of the dependencies between commits
     * @description Gets the diff of the dependency changes between two commits of a repository, based on the changes to the dependency manifests made in those commits.
     */
    get: operations["dependency-graph/diff-range"];
  };
  "/repos/{owner}/{repo}/dependency-graph/sbom": {
    /**
     * Export a software bill of materials (SBOM) for a repository.
     * @description Exports the software bill of materials (SBOM) for a repository in SPDX JSON format.
     */
    get: operations["dependency-graph/export-sbom"];
  };
  "/repos/{owner}/{repo}/dependency-graph/snapshots": {
    /**
     * Create a snapshot of dependencies for a repository
     * @description Create a new snapshot of a repository's dependencies.
     *
     * The authenticated user must have access to the repository.
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    post: operations["dependency-graph/create-repository-snapshot"];
  };
  "/repos/{owner}/{repo}/deployments": {
    /**
     * List deployments
     * @description Simple filtering of deployments is available via query parameters:
     */
    get: operations["repos/list-deployments"];
    /**
     * Create a deployment
     * @description Deployments offer a few configurable parameters with certain defaults.
     *
     * The `ref` parameter can be any named branch, tag, or SHA. At GitHub Enterprise Server we often deploy branches and verify them
     * before we merge a pull request.
     *
     * The `environment` parameter allows deployments to be issued to different runtime environments. Teams often have
     * multiple environments for verifying their applications, such as `production`, `staging`, and `qa`. This parameter
     * makes it easier to track which environments have requested deployments. The default environment is `production`.
     *
     * The `auto_merge` parameter is used to ensure that the requested ref is not behind the repository's default branch. If
     * the ref _is_ behind the default branch for the repository, we will attempt to merge it for you. If the merge succeeds,
     * the API will return a successful merge commit. If merge conflicts prevent the merge from succeeding, the API will
     * return a failure response.
     *
     * By default, [commit statuses](https://docs.github.com/enterprise-server@3.10/rest/commits/statuses) for every submitted context must be in a `success`
     * state. The `required_contexts` parameter allows you to specify a subset of contexts that must be `success`, or to
     * specify contexts that have not yet been submitted. You are not required to use commit statuses to deploy. If you do
     * not require any contexts or create any commit statuses, the deployment will always succeed.
     *
     * The `payload` parameter is available for any extra information that a deployment system might need. It is a JSON text
     * field that will be passed on when a deployment event is dispatched.
     *
     * The `task` parameter is used by the deployment system to allow different execution paths. In the web world this might
     * be `deploy:migrations` to run schema changes on the system. In the compiled world this could be a flag to compile an
     * application with debugging enabled.
     *
     * Merged branch response:
     *
     * You will see this response when GitHub automatically merges the base branch into the topic branch instead of creating
     * a deployment. This auto-merge happens when:
     * *   Auto-merge option is enabled in the repository
     * *   Topic branch does not include the latest changes on the base branch, which is `master` in the response example
     * *   There are no merge conflicts
     *
     * If there are no new commits in the base branch, a new request to create a deployment should give a successful
     * response.
     *
     * Merge conflict response:
     *
     * This error happens when the `auto_merge` option is enabled and when the default branch (in this case `master`), can't
     * be merged into the branch that's being deployed (in this case `topic-branch`), due to merge conflicts.
     *
     * Failed commit status checks:
     *
     * This error happens when the `required_contexts` parameter indicates that one or more contexts need to have a `success`
     * status for the commit to be deployed, but one or more of the required contexts do not have a state of `success`.
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` or `repo_deployment` scope to use this endpoint.
     */
    post: operations["repos/create-deployment"];
  };
  "/repos/{owner}/{repo}/deployments/{deployment_id}": {
    /** Get a deployment */
    get: operations["repos/get-deployment"];
    /**
     * Delete a deployment
     * @description If the repository only has one deployment, you can delete the deployment regardless of its status. If the repository has more than one deployment, you can only delete inactive deployments. This ensures that repositories with multiple deployments will always have an active deployment.
     *
     * To set a deployment as inactive, you must:
     *
     * *   Create a new deployment that is active so that the system has a record of the current state, then delete the previously active deployment.
     * *   Mark the active deployment as inactive by adding any non-successful deployment status.
     *
     * For more information, see "[Create a deployment](https://docs.github.com/enterprise-server@3.10/rest/deployments/deployments/#create-a-deployment)" and "[Create a deployment status](https://docs.github.com/enterprise-server@3.10/rest/deployments/statuses#create-a-deployment-status)."
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` or `repo_deployment` scope to use this endpoint.
     */
    delete: operations["repos/delete-deployment"];
  };
  "/repos/{owner}/{repo}/deployments/{deployment_id}/statuses": {
    /**
     * List deployment statuses
     * @description Users with pull access can view deployment statuses for a deployment:
     */
    get: operations["repos/list-deployment-statuses"];
    /**
     * Create a deployment status
     * @description Users with `push` access can create deployment statuses for a given deployment.
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo_deployment` scope to use this endpoint.
     */
    post: operations["repos/create-deployment-status"];
  };
  "/repos/{owner}/{repo}/deployments/{deployment_id}/statuses/{status_id}": {
    /**
     * Get a deployment status
     * @description Users with pull access can view a deployment status for a deployment:
     */
    get: operations["repos/get-deployment-status"];
  };
  "/repos/{owner}/{repo}/dispatches": {
    /**
     * Create a repository dispatch event
     * @description You can use this endpoint to trigger a webhook event called `repository_dispatch` when you want activity that happens outside of GitHub Enterprise Server to trigger a GitHub Actions workflow or GitHub App webhook. You must configure your GitHub Actions workflow or GitHub App to run when the `repository_dispatch` event occurs. For an example `repository_dispatch` webhook payload, see "[RepositoryDispatchEvent](https://docs.github.com/enterprise-server@3.10/webhooks/event-payloads/#repository_dispatch)."
     *
     * The `client_payload` parameter is available for any extra information that your workflow might need. This parameter is a JSON payload that will be passed on when the webhook event is dispatched. For example, the `client_payload` can include a message that a user would like to send using a GitHub Actions workflow. Or the `client_payload` can be used as a test to debug your workflow.
     *
     * This input example shows how you can use the `client_payload` as a test to debug your workflow.
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    post: operations["repos/create-dispatch-event"];
  };
  "/repos/{owner}/{repo}/environments": {
    /**
     * List environments
     * @description Lists the environments for a repository.
     *
     * Anyone with read access to the repository can use this endpoint.
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.
     */
    get: operations["repos/get-all-environments"];
  };
  "/repos/{owner}/{repo}/environments/{environment_name}": {
    /**
     * Get an environment
     * @description **Note:** To get information about name patterns that branches must match in order to deploy to this environment, see "[Get a deployment branch policy](/rest/deployments/branch-policies#get-a-deployment-branch-policy)."
     *
     * Anyone with read access to the repository can use this endpoint.
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.
     */
    get: operations["repos/get-environment"];
    /**
     * Create or update an environment
     * @description Create or update an environment with protection rules, such as required reviewers. For more information about environment protection rules, see "[Environments](/actions/reference/environments#environment-protection-rules)."
     *
     * **Note:** To create or update name patterns that branches must match in order to deploy to this environment, see "[Deployment branch policies](/rest/deployments/branch-policies)."
     *
     * **Note:** To create or update secrets for an environment, see "[GitHub Actions secrets](/rest/actions/secrets)."
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    put: operations["repos/create-or-update-environment"];
    /**
     * Delete an environment
     * @description OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    delete: operations["repos/delete-an-environment"];
  };
  "/repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies": {
    /**
     * List deployment branch policies
     * @description Lists the deployment branch policies for an environment.
     *
     * Anyone with read access to the repository can use this endpoint.
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.
     */
    get: operations["repos/list-deployment-branch-policies"];
    /**
     * Create a deployment branch policy
     * @description Creates a deployment branch policy for an environment.
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    post: operations["repos/create-deployment-branch-policy"];
  };
  "/repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies/{branch_policy_id}": {
    /**
     * Get a deployment branch policy
     * @description Gets a deployment branch policy for an environment.
     *
     * Anyone with read access to the repository can use this endpoint.
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.
     */
    get: operations["repos/get-deployment-branch-policy"];
    /**
     * Update a deployment branch policy
     * @description Updates a deployment branch policy for an environment.
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    put: operations["repos/update-deployment-branch-policy"];
    /**
     * Delete a deployment branch policy
     * @description Deletes a deployment branch policy for an environment.
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    delete: operations["repos/delete-deployment-branch-policy"];
  };
  "/repos/{owner}/{repo}/environments/{environment_name}/deployment_protection_rules": {
    /**
     * Get all deployment protection rules for an environment
     * @description Gets all custom deployment protection rules that are enabled for an environment. Anyone with read access to the repository can use this endpoint. For more information about environments, see "[Using environments for deployment](https://docs.github.com/enterprise-server@3.10/actions/deployment/targeting-different-environments/using-environments-for-deployment)."
     *
     * For more information about the app that is providing this custom deployment rule, see the [documentation for the `GET /apps/{app_slug}` endpoint](https://docs.github.com/enterprise-server@3.10/rest/apps/apps#get-an-app).
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.
     */
    get: operations["repos/get-all-deployment-protection-rules"];
    /**
     * Create a custom deployment protection rule on an environment
     * @description Enable a custom deployment protection rule for an environment.
     *
     * The authenticated user must have admin or owner permissions to the repository to use this endpoint.
     *
     * For more information about the app that is providing this custom deployment rule, see the [documentation for the `GET /apps/{app_slug}` endpoint](https://docs.github.com/enterprise-server@3.10/rest/apps/apps#get-an-app).
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    post: operations["repos/create-deployment-protection-rule"];
  };
  "/repos/{owner}/{repo}/environments/{environment_name}/deployment_protection_rules/apps": {
    /**
     * List custom deployment rule integrations available for an environment
     * @description Gets all custom deployment protection rule integrations that are available for an environment. Anyone with read access to the repository can use this endpoint.
     *
     * For more information about environments, see "[Using environments for deployment](https://docs.github.com/enterprise-server@3.10/actions/deployment/targeting-different-environments/using-environments-for-deployment)."
     *
     * For more information about the app that is providing this custom deployment rule, see "[GET an app](https://docs.github.com/enterprise-server@3.10/rest/apps/apps#get-an-app)".
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.
     */
    get: operations["repos/list-custom-deployment-rule-integrations"];
  };
  "/repos/{owner}/{repo}/environments/{environment_name}/deployment_protection_rules/{protection_rule_id}": {
    /**
     * Get a custom deployment protection rule
     * @description Gets an enabled custom deployment protection rule for an environment. Anyone with read access to the repository can use this endpoint. For more information about environments, see "[Using environments for deployment](https://docs.github.com/enterprise-server@3.10/actions/deployment/targeting-different-environments/using-environments-for-deployment)."
     *
     * For more information about the app that is providing this custom deployment rule, see [`GET /apps/{app_slug}`](https://docs.github.com/enterprise-server@3.10/rest/apps/apps#get-an-app).
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.
     */
    get: operations["repos/get-custom-deployment-protection-rule"];
    /**
     * Disable a custom protection rule for an environment
     * @description Disables a custom deployment protection rule for an environment.
     *
     * The authenticated user must have admin or owner permissions to the repository to use this endpoint.
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    delete: operations["repos/disable-deployment-protection-rule"];
  };
  "/repos/{owner}/{repo}/environments/{environment_name}/secrets": {
    /**
     * List environment secrets
     * @description Lists all secrets available in an environment without revealing their
     * encrypted values.
     *
     * Authenticated users must have collaborator access to a repository to create, update, or read secrets.
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    get: operations["actions/list-environment-secrets"];
  };
  "/repos/{owner}/{repo}/environments/{environment_name}/secrets/public-key": {
    /**
     * Get an environment public key
     * @description Get the public key for an environment, which you need to encrypt environment
     * secrets. You need to encrypt a secret before you can create or update secrets.
     *
     * Anyone with read access to the repository can use this endpoint.
     *
     * If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    get: operations["actions/get-environment-public-key"];
  };
  "/repos/{owner}/{repo}/environments/{environment_name}/secrets/{secret_name}": {
    /**
     * Get an environment secret
     * @description Gets a single environment secret without revealing its encrypted value.
     *
     * Authenticated users must have collaborator access to a repository to create, update, or read secrets.
     *
     * OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    get: operations["actions/get-environment-secret"];
    /**
     * Create or update an environment secret
     * @description Creates or updates an environment secret with an encrypted value. Encrypt your secret using
     * [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages). For more information, see "[Encrypting secrets for the REST API](https://docs.github.com/enterprise-server@3.10/rest/guides/encrypting-secrets-for-the-rest-api)."
     *
     * Authenticated users must have collaborator access to a repository to create, update, or read secrets.
     *
     * OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    put: operations["actions/create-or-update-environment-secret"];
    /**
     * Delete an environment secret
     * @description Deletes a secret in an environment using the secret name.
     *
     * Authenticated users must have collaborator access to a repository to create, update, or read secrets.
     *
     * OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    delete: operations["actions/delete-environment-secret"];
  };
  "/repos/{owner}/{repo}/environments/{environment_name}/variables": {
    /**
     * List environment variables
     * @description Lists all environment variables.
     *
     * Authenticated users must have collaborator access to a repository to create, update, or read variables.
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    get: operations["actions/list-environment-variables"];
    /**
     * Create an environment variable
     * @description Create an environment variable that you can reference in a GitHub Actions workflow.
     *
     * Authenticated users must have collaborator access to a repository to create, update, or read variables.
     *
     * OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    post: operations["actions/create-environment-variable"];
  };
  "/repos/{owner}/{repo}/environments/{environment_name}/variables/{name}": {
    /**
     * Get an environment variable
     * @description Gets a specific variable in an environment.
     *
     * Authenticated users must have collaborator access to a repository to create, update, or read variables.
     *
     * OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    get: operations["actions/get-environment-variable"];
    /**
     * Delete an environment variable
     * @description Deletes an environment variable using the variable name.
     *
     * Authenticated users must have collaborator access to a repository to create, update, or read variables.
     *
     * OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    delete: operations["actions/delete-environment-variable"];
    /**
     * Update an environment variable
     * @description Updates an environment variable that you can reference in a GitHub Actions workflow.
     *
     * Authenticated users must have collaborator access to a repository to create, update, or read variables.
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    patch: operations["actions/update-environment-variable"];
  };
  "/repos/{owner}/{repo}/events": {
    /**
     * List repository events
     * @description **Note**: This API is not built to serve real-time use cases. Depending on the time of day, event latency can be anywhere from 30s to 6h.
     */
    get: operations["activity/list-repo-events"];
  };
  "/repos/{owner}/{repo}/forks": {
    /** List forks */
    get: operations["repos/list-forks"];
    /**
     * Create a fork
     * @description Create a fork for the authenticated user.
     *
     * **Note**: Forking a Repository happens asynchronously. You may have to wait a short period of time before you can access the git objects. If this takes longer than 5 minutes, be sure to contact [GitHub Enterprise Server Support](https://support.github.com/contact?tags=dotcom-rest-api).
     *
     * **Note**: Although this endpoint works with GitHub Apps, the GitHub App must be installed on the destination account with access to all repositories and on the source account with access to the source repository.
     */
    post: operations["repos/create-fork"];
  };
  "/repos/{owner}/{repo}/git/blobs": {
    /** Create a blob */
    post: operations["git/create-blob"];
  };
  "/repos/{owner}/{repo}/git/blobs/{file_sha}": {
    /**
     * Get a blob
     * @description The `content` in the response will always be Base64 encoded.
     *
     * This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/enterprise-server@3.10/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
     *
     * - **`application/vnd.github.raw+json`**: Returns the raw blob data.
     * - **`application/vnd.github+json`**: Returns a JSON representation of the blob with `content` as a base64 encoded string. This is the default if no media type is specified.
     *
     * **Note** This endpoint supports blobs up to 100 megabytes in size.
     */
    get: operations["git/get-blob"];
  };
  "/repos/{owner}/{repo}/git/commits": {
    /**
     * Create a commit
     * @description Creates a new Git [commit object](https://git-scm.com/book/en/v2/Git-Internals-Git-Objects).
     *
     * **Signature verification object**
     *
     * The response will include a `verification` object that describes the result of verifying the commit's signature. The following fields are included in the `verification` object:
     *
     * | Name | Type | Description |
     * | ---- | ---- | ----------- |
     * | `verified` | `boolean` | Indicates whether GitHub considers the signature in this commit to be verified. |
     * | `reason` | `string` | The reason for verified value. Possible values and their meanings are enumerated in the table below. |
     * | `signature` | `string` | The signature that was extracted from the commit. |
     * | `payload` | `string` | The value that was signed. |
     *
     * These are the possible values for `reason` in the `verification` object:
     *
     * | Value | Description |
     * | ----- | ----------- |
     * | `expired_key` | The key that made the signature is expired. |
     * | `not_signing_key` | The "signing" flag is not among the usage flags in the GPG key that made the signature. |
     * | `gpgverify_error` | There was an error communicating with the signature verification service. |
     * | `gpgverify_unavailable` | The signature verification service is currently unavailable. |
     * | `unsigned` | The object does not include a signature. |
     * | `unknown_signature_type` | A non-PGP signature was found in the commit. |
     * | `no_user` | No user was associated with the `committer` email address in the commit. |
     * | `unverified_email` | The `committer` email address in the commit was associated with a user, but the email address is not verified on their account. |
     * | `bad_email` | The `committer` email address in the commit is not included in the identities of the PGP key that made the signature. |
     * | `unknown_key` | The key that made the signature has not been registered with any user's account. |
     * | `malformed_signature` | There was an error parsing the signature. |
     * | `invalid` | The signature could not be cryptographically verified using the key whose key-id was found in the signature. |
     * | `valid` | None of the above errors applied, so the signature is considered to be verified. |
     */
    post: operations["git/create-commit"];
  };
  "/repos/{owner}/{repo}/git/commits/{commit_sha}": {
    /**
     * Get a commit object
     * @description Gets a Git [commit object](https://git-scm.com/book/en/v2/Git-Internals-Git-Objects).
     *
     * To get the contents of a commit, see "[Get a commit](/rest/commits/commits#get-a-commit)."
     *
     * **Signature verification object**
     *
     * The response will include a `verification` object that describes the result of verifying the commit's signature. The following fields are included in the `verification` object:
     *
     * | Name | Type | Description |
     * | ---- | ---- | ----------- |
     * | `verified` | `boolean` | Indicates whether GitHub considers the signature in this commit to be verified. |
     * | `reason` | `string` | The reason for verified value. Possible values and their meanings are enumerated in the table below. |
     * | `signature` | `string` | The signature that was extracted from the commit. |
     * | `payload` | `string` | The value that was signed. |
     *
     * These are the possible values for `reason` in the `verification` object:
     *
     * | Value | Description |
     * | ----- | ----------- |
     * | `expired_key` | The key that made the signature is expired. |
     * | `not_signing_key` | The "signing" flag is not among the usage flags in the GPG key that made the signature. |
     * | `gpgverify_error` | There was an error communicating with the signature verification service. |
     * | `gpgverify_unavailable` | The signature verification service is currently unavailable. |
     * | `unsigned` | The object does not include a signature. |
     * | `unknown_signature_type` | A non-PGP signature was found in the commit. |
     * | `no_user` | No user was associated with the `committer` email address in the commit. |
     * | `unverified_email` | The `committer` email address in the commit was associated with a user, but the email address is not verified on their account. |
     * | `bad_email` | The `committer` email address in the commit is not included in the identities of the PGP key that made the signature. |
     * | `unknown_key` | The key that made the signature has not been registered with any user's account. |
     * | `malformed_signature` | There was an error parsing the signature. |
     * | `invalid` | The signature could not be cryptographically verified using the key whose key-id was found in the signature. |
     * | `valid` | None of the above errors applied, so the signature is considered to be verified. |
     */
    get: operations["git/get-commit"];
  };
  "/repos/{owner}/{repo}/git/matching-refs/{ref}": {
    /**
     * List matching references
     * @description Returns an array of references from your Git database that match the supplied name. The `:ref` in the URL must be formatted as `heads/<branch name>` for branches and `tags/<tag name>` for tags. If the `:ref` doesn't exist in the repository, but existing refs start with `:ref`, they will be returned as an array.
     *
     * When you use this endpoint without providing a `:ref`, it will return an array of all the references from your Git database, including notes and stashes if they exist on the server. Anything in the namespace is returned, not just `heads` and `tags`.
     *
     * **Note:** You need to explicitly [request a pull request](https://docs.github.com/enterprise-server@3.10/rest/pulls/pulls#get-a-pull-request) to trigger a test merge commit, which checks the mergeability of pull requests. For more information, see "[Checking mergeability of pull requests](https://docs.github.com/enterprise-server@3.10/rest/guides/getting-started-with-the-git-database-api#checking-mergeability-of-pull-requests)".
     *
     * If you request matching references for a branch named `feature` but the branch `feature` doesn't exist, the response can still include other matching head refs that start with the word `feature`, such as `featureA` and `featureB`.
     */
    get: operations["git/list-matching-refs"];
  };
  "/repos/{owner}/{repo}/git/ref/{ref}": {
    /**
     * Get a reference
     * @description Returns a single reference from your Git database. The `:ref` in the URL must be formatted as `heads/<branch name>` for branches and `tags/<tag name>` for tags. If the `:ref` doesn't match an existing ref, a `404` is returned.
     *
     * **Note:** You need to explicitly [request a pull request](https://docs.github.com/enterprise-server@3.10/rest/pulls/pulls#get-a-pull-request) to trigger a test merge commit, which checks the mergeability of pull requests. For more information, see "[Checking mergeability of pull requests](https://docs.github.com/enterprise-server@3.10/rest/guides/getting-started-with-the-git-database-api#checking-mergeability-of-pull-requests)".
     */
    get: operations["git/get-ref"];
  };
  "/repos/{owner}/{repo}/git/refs": {
    /**
     * Create a reference
     * @description Creates a reference for your repository. You are unable to create new references for empty repositories, even if the commit SHA-1 hash used exists. Empty repositories are repositories without branches.
     */
    post: operations["git/create-ref"];
  };
  "/repos/{owner}/{repo}/git/refs/{ref}": {
    /**
     * Delete a reference
     * @description Deletes the provided reference.
     */
    delete: operations["git/delete-ref"];
    /**
     * Update a reference
     * @description Updates the provided reference to point to a new SHA. For more information, see "[Git References](https://git-scm.com/book/en/v2/Git-Internals-Git-References)" in the Git documentation.
     */
    patch: operations["git/update-ref"];
  };
  "/repos/{owner}/{repo}/git/tags": {
    /**
     * Create a tag object
     * @description Note that creating a tag object does not create the reference that makes a tag in Git. If you want to create an annotated tag in Git, you have to do this call to create the tag object, and then [create](https://docs.github.com/enterprise-server@3.10/rest/git/refs#create-a-reference) the `refs/tags/[tag]` reference. If you want to create a lightweight tag, you only have to [create](https://docs.github.com/enterprise-server@3.10/rest/git/refs#create-a-reference) the tag reference - this call would be unnecessary.
     *
     * **Signature verification object**
     *
     * The response will include a `verification` object that describes the result of verifying the commit's signature. The following fields are included in the `verification` object:
     *
     * | Name | Type | Description |
     * | ---- | ---- | ----------- |
     * | `verified` | `boolean` | Indicates whether GitHub considers the signature in this commit to be verified. |
     * | `reason` | `string` | The reason for verified value. Possible values and their meanings are enumerated in table below. |
     * | `signature` | `string` | The signature that was extracted from the commit. |
     * | `payload` | `string` | The value that was signed. |
     *
     * These are the possible values for `reason` in the `verification` object:
     *
     * | Value | Description |
     * | ----- | ----------- |
     * | `expired_key` | The key that made the signature is expired. |
     * | `not_signing_key` | The "signing" flag is not among the usage flags in the GPG key that made the signature. |
     * | `gpgverify_error` | There was an error communicating with the signature verification service. |
     * | `gpgverify_unavailable` | The signature verification service is currently unavailable. |
     * | `unsigned` | The object does not include a signature. |
     * | `unknown_signature_type` | A non-PGP signature was found in the commit. |
     * | `no_user` | No user was associated with the `committer` email address in the commit. |
     * | `unverified_email` | The `committer` email address in the commit was associated with a user, but the email address is not verified on their account. |
     * | `bad_email` | The `committer` email address in the commit is not included in the identities of the PGP key that made the signature. |
     * | `unknown_key` | The key that made the signature has not been registered with any user's account. |
     * | `malformed_signature` | There was an error parsing the signature. |
     * | `invalid` | The signature could not be cryptographically verified using the key whose key-id was found in the signature. |
     * | `valid` | None of the above errors applied, so the signature is considered to be verified. |
     */
    post: operations["git/create-tag"];
  };
  "/repos/{owner}/{repo}/git/tags/{tag_sha}": {
    /**
     * Get a tag
     * @description **Signature verification object**
     *
     * The response will include a `verification` object that describes the result of verifying the commit's signature. The following fields are included in the `verification` object:
     *
     * | Name | Type | Description |
     * | ---- | ---- | ----------- |
     * | `verified` | `boolean` | Indicates whether GitHub considers the signature in this commit to be verified. |
     * | `reason` | `string` | The reason for verified value. Possible values and their meanings are enumerated in table below. |
     * | `signature` | `string` | The signature that was extracted from the commit. |
     * | `payload` | `string` | The value that was signed. |
     *
     * These are the possible values for `reason` in the `verification` object:
     *
     * | Value | Description |
     * | ----- | ----------- |
     * | `expired_key` | The key that made the signature is expired. |
     * | `not_signing_key` | The "signing" flag is not among the usage flags in the GPG key that made the signature. |
     * | `gpgverify_error` | There was an error communicating with the signature verification service. |
     * | `gpgverify_unavailable` | The signature verification service is currently unavailable. |
     * | `unsigned` | The object does not include a signature. |
     * | `unknown_signature_type` | A non-PGP signature was found in the commit. |
     * | `no_user` | No user was associated with the `committer` email address in the commit. |
     * | `unverified_email` | The `committer` email address in the commit was associated with a user, but the email address is not verified on their account. |
     * | `bad_email` | The `committer` email address in the commit is not included in the identities of the PGP key that made the signature. |
     * | `unknown_key` | The key that made the signature has not been registered with any user's account. |
     * | `malformed_signature` | There was an error parsing the signature. |
     * | `invalid` | The signature could not be cryptographically verified using the key whose key-id was found in the signature. |
     * | `valid` | None of the above errors applied, so the signature is considered to be verified. |
     */
    get: operations["git/get-tag"];
  };
  "/repos/{owner}/{repo}/git/trees": {
    /**
     * Create a tree
     * @description The tree creation API accepts nested entries. If you specify both a tree and a nested path modifying that tree, this endpoint will overwrite the contents of the tree with the new path contents, and create a new tree structure.
     *
     * If you use this endpoint to add, delete, or modify the file contents in a tree, you will need to commit the tree and then update a branch to point to the commit. For more information see "[Create a commit](https://docs.github.com/enterprise-server@3.10/rest/git/commits#create-a-commit)" and "[Update a reference](https://docs.github.com/enterprise-server@3.10/rest/git/refs#update-a-reference)."
     *
     * Returns an error if you try to delete a file that does not exist.
     */
    post: operations["git/create-tree"];
  };
  "/repos/{owner}/{repo}/git/trees/{tree_sha}": {
    /**
     * Get a tree
     * @description Returns a single tree using the SHA1 value or ref name for that tree.
     *
     * If `truncated` is `true` in the response then the number of items in the `tree` array exceeded our maximum limit. If you need to fetch more items, use the non-recursive method of fetching trees, and fetch one sub-tree at a time.
     *
     *
     * **Note**: The limit for the `tree` array is 100,000 entries with a maximum size of 7 MB when using the `recursive` parameter.
     */
    get: operations["git/get-tree"];
  };
  "/repos/{owner}/{repo}/hooks": {
    /**
     * List repository webhooks
     * @description Lists webhooks for a repository. `last response` may return null if there have not been any deliveries within 30 days.
     */
    get: operations["repos/list-webhooks"];
    /**
     * Create a repository webhook
     * @description Repositories can have multiple webhooks installed. Each webhook should have a unique `config`. Multiple webhooks can
     * share the same `config` as long as those webhooks do not have any `events` that overlap.
     */
    post: operations["repos/create-webhook"];
  };
  "/repos/{owner}/{repo}/hooks/{hook_id}": {
    /**
     * Get a repository webhook
     * @description Returns a webhook configured in a repository. To get only the webhook `config` properties, see "[Get a webhook configuration for a repository](/rest/webhooks/repo-config#get-a-webhook-configuration-for-a-repository)."
     */
    get: operations["repos/get-webhook"];
    /** Delete a repository webhook */
    delete: operations["repos/delete-webhook"];
    /**
     * Update a repository webhook
     * @description Updates a webhook configured in a repository. If you previously had a `secret` set, you must provide the same `secret` or set a new `secret` or the secret will be removed. If you are only updating individual webhook `config` properties, use "[Update a webhook configuration for a repository](/rest/webhooks/repo-config#update-a-webhook-configuration-for-a-repository)."
     */
    patch: operations["repos/update-webhook"];
  };
  "/repos/{owner}/{repo}/hooks/{hook_id}/config": {
    /**
     * Get a webhook configuration for a repository
     * @description Returns the webhook configuration for a repository. To get more information about the webhook, including the `active` state and `events`, use "[Get a repository webhook](/rest/webhooks/repos#get-a-repository-webhook)."
     *
     * OAuth app tokens and personal access tokens (classic) need the `read:repo_hook` or `repo` scope to use this endpoint.
     */
    get: operations["repos/get-webhook-config-for-repo"];
    /**
     * Update a webhook configuration for a repository
     * @description Updates the webhook configuration for a repository. To update more information about the webhook, including the `active` state and `events`, use "[Update a repository webhook](/rest/webhooks/repos#update-a-repository-webhook)."
     *
     * OAuth app tokens and personal access tokens (classic) need the `write:repo_hook` or `repo` scope to use this endpoint.
     */
    patch: operations["repos/update-webhook-config-for-repo"];
  };
  "/repos/{owner}/{repo}/hooks/{hook_id}/deliveries": {
    /**
     * List deliveries for a repository webhook
     * @description Returns a list of webhook deliveries for a webhook configured in a repository.
     */
    get: operations["repos/list-webhook-deliveries"];
  };
  "/repos/{owner}/{repo}/hooks/{hook_id}/deliveries/{delivery_id}": {
    /**
     * Get a delivery for a repository webhook
     * @description Returns a delivery for a webhook configured in a repository.
     */
    get: operations["repos/get-webhook-delivery"];
  };
  "/repos/{owner}/{repo}/hooks/{hook_id}/deliveries/{delivery_id}/attempts": {
    /**
     * Redeliver a delivery for a repository webhook
     * @description Redeliver a webhook delivery for a webhook configured in a repository.
     */
    post: operations["repos/redeliver-webhook-delivery"];
  };
  "/repos/{owner}/{repo}/hooks/{hook_id}/pings": {
    /**
     * Ping a repository webhook
     * @description This will trigger a [ping event](https://docs.github.com/enterprise-server@3.10/webhooks/#ping-event) to be sent to the hook.
     */
    post: operations["repos/ping-webhook"];
  };
  "/repos/{owner}/{repo}/hooks/{hook_id}/tests": {
    /**
     * Test the push repository webhook
     * @description This will trigger the hook with the latest push to the current repository if the hook is subscribed to `push` events. If the hook is not subscribed to `push` events, the server will respond with 204 but no test POST will be generated.
     *
     * **Note**: Previously `/repos/:owner/:repo/hooks/:hook_id/test`
     */
    post: operations["repos/test-push-webhook"];
  };
  "/repos/{owner}/{repo}/installation": {
    /**
     * Get a repository installation for the authenticated app
     * @description Enables an authenticated GitHub App to find the repository's installation information. The installation's account type will be either an organization or a user account, depending which account the repository belongs to.
     *
     * You must use a [JWT](https://docs.github.com/enterprise-server@3.10/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
     */
    get: operations["apps/get-repo-installation"];
  };
  "/repos/{owner}/{repo}/invitations": {
    /**
     * List repository invitations
     * @description When authenticating as a user with admin rights to a repository, this endpoint will list all currently open repository invitations.
     */
    get: operations["repos/list-invitations"];
  };
  "/repos/{owner}/{repo}/invitations/{invitation_id}": {
    /** Delete a repository invitation */
    delete: operations["repos/delete-invitation"];
    /** Update a repository invitation */
    patch: operations["repos/update-invitation"];
  };
  "/repos/{owner}/{repo}/issues": {
    /**
     * List repository issues
     * @description List issues in a repository. Only open issues will be listed.
     *
     * **Note**: GitHub's REST API considers every pull request an issue, but not every issue is a pull request. For this
     * reason, "Issues" endpoints may return both issues and pull requests in the response. You can identify pull requests by
     * the `pull_request` key. Be aware that the `id` of a pull request returned from "Issues" endpoints will be an _issue id_. To find out the pull
     * request id, use the "[List pull requests](https://docs.github.com/enterprise-server@3.10/rest/pulls/pulls#list-pull-requests)" endpoint.
     *
     * This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/enterprise-server@3.10/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
     *
     * - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
     * - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
     * - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
     * - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
     */
    get: operations["issues/list-for-repo"];
    /**
     * Create an issue
     * @description Any user with pull access to a repository can create an issue. If [issues are disabled in the repository](https://docs.github.com/enterprise-server@3.10/articles/disabling-issues/), the API returns a `410 Gone` status.
     *
     * This endpoint triggers [notifications](https://docs.github.com/enterprise-server@3.10/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/enterprise-server@3.10/rest/overview/rate-limits-for-the-rest-api#about-secondary-rate-limits)"
     * and "[Best practices for using the REST API](https://docs.github.com/enterprise-server@3.10/rest/guides/best-practices-for-using-the-rest-api)."
     *
     * This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/enterprise-server@3.10/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
     *
     * - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
     * - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
     * - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
     * - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
     */
    post: operations["issues/create"];
  };
  "/repos/{owner}/{repo}/issues/comments": {
    /**
     * List issue comments for a repository
     * @description You can use the REST API to list comments on issues and pull requests for a repository. Every pull request is an issue, but not every issue is a pull request.
     *
     * By default, issue comments are ordered by ascending ID.
     *
     * This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/enterprise-server@3.10/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
     *
     * - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
     * - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
     * - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
     * - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
     */
    get: operations["issues/list-comments-for-repo"];
  };
  "/repos/{owner}/{repo}/issues/comments/{comment_id}": {
    /**
     * Get an issue comment
     * @description You can use the REST API to get comments on issues and pull requests. Every pull request is an issue, but not every issue is a pull request.
     *
     * This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/enterprise-server@3.10/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
     *
     * - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
     * - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
     * - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
     * - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
     */
    get: operations["issues/get-comment"];
    /**
     * Delete an issue comment
     * @description You can use the REST API to delete comments on issues and pull requests. Every pull request is an issue, but not every issue is a pull request.
     */
    delete: operations["issues/delete-comment"];
    /**
     * Update an issue comment
     * @description You can use the REST API to update comments on issues and pull requests. Every pull request is an issue, but not every issue is a pull request.
     *
     * This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/enterprise-server@3.10/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
     *
     * - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
     * - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
     * - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
     * - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
     */
    patch: operations["issues/update-comment"];
  };
  "/repos/{owner}/{repo}/issues/comments/{comment_id}/reactions": {
    /**
     * List reactions for an issue comment
     * @description List the reactions to an [issue comment](https://docs.github.com/enterprise-server@3.10/rest/issues/comments#get-an-issue-comment).
     */
    get: operations["reactions/list-for-issue-comment"];
    /**
     * Create reaction for an issue comment
     * @description Create a reaction to an [issue comment](https://docs.github.com/enterprise-server@3.10/rest/issues/comments#get-an-issue-comment). A response with an HTTP `200` status means that you already added the reaction type to this issue comment.
     */
    post: operations["reactions/create-for-issue-comment"];
  };
  "/repos/{owner}/{repo}/issues/comments/{comment_id}/reactions/{reaction_id}": {
    /**
     * Delete an issue comment reaction
     * @description **Note:** You can also specify a repository by `repository_id` using the route `DELETE delete /repositories/:repository_id/issues/comments/:comment_id/reactions/:reaction_id`.
     *
     * Delete a reaction to an [issue comment](https://docs.github.com/enterprise-server@3.10/rest/issues/comments#get-an-issue-comment).
     */
    delete: operations["reactions/delete-for-issue-comment"];
  };
  "/repos/{owner}/{repo}/issues/events": {
    /**
     * List issue events for a repository
     * @description Lists events for a repository.
     */
    get: operations["issues/list-events-for-repo"];
  };
  "/repos/{owner}/{repo}/issues/events/{event_id}": {
    /**
     * Get an issue event
     * @description Gets a single event by the event id.
     */
    get: operations["issues/get-event"];
  };
  "/repos/{owner}/{repo}/issues/{issue_number}": {
    /**
     * Get an issue
     * @description The API returns a [`301 Moved Permanently` status](https://docs.github.com/enterprise-server@3.10/rest/guides/best-practices-for-using-the-rest-api#follow-redirects) if the issue was
     * [transferred](https://docs.github.com/enterprise-server@3.10/articles/transferring-an-issue-to-another-repository/) to another repository. If
     * the issue was transferred to or deleted from a repository where the authenticated user lacks read access, the API
     * returns a `404 Not Found` status. If the issue was deleted from a repository where the authenticated user has read
     * access, the API returns a `410 Gone` status. To receive webhook events for transferred and deleted issues, subscribe
     * to the [`issues`](https://docs.github.com/enterprise-server@3.10/webhooks/event-payloads/#issues) webhook.
     *
     * **Note**: GitHub's REST API considers every pull request an issue, but not every issue is a pull request. For this
     * reason, "Issues" endpoints may return both issues and pull requests in the response. You can identify pull requests by
     * the `pull_request` key. Be aware that the `id` of a pull request returned from "Issues" endpoints will be an _issue id_. To find out the pull
     * request id, use the "[List pull requests](https://docs.github.com/enterprise-server@3.10/rest/pulls/pulls#list-pull-requests)" endpoint.
     *
     * This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/enterprise-server@3.10/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
     *
     * - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
     * - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
     * - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
     * - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
     */
    get: operations["issues/get"];
    /**
     * Update an issue
     * @description Issue owners and users with push access can edit an issue.
     *
     * This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/enterprise-server@3.10/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
     *
     * - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
     * - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
     * - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
     * - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
     */
    patch: operations["issues/update"];
  };
  "/repos/{owner}/{repo}/issues/{issue_number}/assignees": {
    /**
     * Add assignees to an issue
     * @description Adds up to 10 assignees to an issue. Users already assigned to an issue are not replaced.
     */
    post: operations["issues/add-assignees"];
    /**
     * Remove assignees from an issue
     * @description Removes one or more assignees from an issue.
     */
    delete: operations["issues/remove-assignees"];
  };
  "/repos/{owner}/{repo}/issues/{issue_number}/assignees/{assignee}": {
    /**
     * Check if a user can be assigned to a issue
     * @description Checks if a user has permission to be assigned to a specific issue.
     *
     * If the `assignee` can be assigned to this issue, a `204` status code with no content is returned.
     *
     * Otherwise a `404` status code is returned.
     */
    get: operations["issues/check-user-can-be-assigned-to-issue"];
  };
  "/repos/{owner}/{repo}/issues/{issue_number}/comments": {
    /**
     * List issue comments
     * @description You can use the REST API to list comments on issues and pull requests. Every pull request is an issue, but not every issue is a pull request.
     *
     * Issue comments are ordered by ascending ID.
     *
     * This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/enterprise-server@3.10/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
     *
     * - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
     * - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
     * - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
     * - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
     */
    get: operations["issues/list-comments"];
    /**
     * Create an issue comment
     * @description You can use the REST API to create comments on issues and pull requests. Every pull request is an issue, but not every issue is a pull request.
     *
     * This endpoint triggers [notifications](https://docs.github.com/enterprise-server@3.10/github/managing-subscriptions-and-notifications-on-github/about-notifications).
     * Creating content too quickly using this endpoint may result in secondary rate limiting.
     * For more information, see "[Rate limits for the API](https://docs.github.com/enterprise-server@3.10/rest/overview/rate-limits-for-the-rest-api#about-secondary-rate-limits)"
     * and "[Best practices for using the REST API](https://docs.github.com/enterprise-server@3.10/rest/guides/best-practices-for-using-the-rest-api)."
     *
     * This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/enterprise-server@3.10/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
     *
     * - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
     * - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
     * - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
     * - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
     */
    post: operations["issues/create-comment"];
  };
  "/repos/{owner}/{repo}/issues/{issue_number}/events": {
    /**
     * List issue events
     * @description Lists all events for an issue.
     */
    get: operations["issues/list-events"];
  };
  "/repos/{owner}/{repo}/issues/{issue_number}/labels": {
    /**
     * List labels for an issue
     * @description Lists all labels for an issue.
     */
    get: operations["issues/list-labels-on-issue"];
    /**
     * Set labels for an issue
     * @description Removes any previous labels and sets the new labels for an issue.
     */
    put: operations["issues/set-labels"];
    /**
     * Add labels to an issue
     * @description Adds labels to an issue. If you provide an empty array of labels, all labels are removed from the issue.
     */
    post: operations["issues/add-labels"];
    /**
     * Remove all labels from an issue
     * @description Removes all labels from an issue.
     */
    delete: operations["issues/remove-all-labels"];
  };
  "/repos/{owner}/{repo}/issues/{issue_number}/labels/{name}": {
    /**
     * Remove a label from an issue
     * @description Removes the specified label from the issue, and returns the remaining labels on the issue. This endpoint returns a `404 Not Found` status if the label does not exist.
     */
    delete: operations["issues/remove-label"];
  };
  "/repos/{owner}/{repo}/issues/{issue_number}/lock": {
    /**
     * Lock an issue
     * @description Users with push access can lock an issue or pull request's conversation.
     *
     * Note that, if you choose not to pass any parameters, you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP method](https://docs.github.com/enterprise-server@3.10/rest/guides/getting-started-with-the-rest-api#http-method)."
     */
    put: operations["issues/lock"];
    /**
     * Unlock an issue
     * @description Users with push access can unlock an issue's conversation.
     */
    delete: operations["issues/unlock"];
  };
  "/repos/{owner}/{repo}/issues/{issue_number}/reactions": {
    /**
     * List reactions for an issue
     * @description List the reactions to an [issue](https://docs.github.com/enterprise-server@3.10/rest/issues/issues#get-an-issue).
     */
    get: operations["reactions/list-for-issue"];
    /**
     * Create reaction for an issue
     * @description Create a reaction to an [issue](https://docs.github.com/enterprise-server@3.10/rest/issues/issues#get-an-issue). A response with an HTTP `200` status means that you already added the reaction type to this issue.
     */
    post: operations["reactions/create-for-issue"];
  };
  "/repos/{owner}/{repo}/issues/{issue_number}/reactions/{reaction_id}": {
    /**
     * Delete an issue reaction
     * @description **Note:** You can also specify a repository by `repository_id` using the route `DELETE /repositories/:repository_id/issues/:issue_number/reactions/:reaction_id`.
     *
     * Delete a reaction to an [issue](https://docs.github.com/enterprise-server@3.10/rest/issues/issues#get-an-issue).
     */
    delete: operations["reactions/delete-for-issue"];
  };
  "/repos/{owner}/{repo}/issues/{issue_number}/timeline": {
    /**
     * List timeline events for an issue
     * @description List all timeline events for an issue.
     */
    get: operations["issues/list-events-for-timeline"];
  };
  "/repos/{owner}/{repo}/keys": {
    /** List deploy keys */
    get: operations["repos/list-deploy-keys"];
    /**
     * Create a deploy key
     * @description You can create a read-only deploy key.
     */
    post: operations["repos/create-deploy-key"];
  };
  "/repos/{owner}/{repo}/keys/{key_id}": {
    /** Get a deploy key */
    get: operations["repos/get-deploy-key"];
    /**
     * Delete a deploy key
     * @description Deploy keys are immutable. If you need to update a key, remove the key and create a new one instead.
     */
    delete: operations["repos/delete-deploy-key"];
  };
  "/repos/{owner}/{repo}/labels": {
    /**
     * List labels for a repository
     * @description Lists all labels for a repository.
     */
    get: operations["issues/list-labels-for-repo"];
    /**
     * Create a label
     * @description Creates a label for the specified repository with the given name and color. The name and color parameters are required. The color must be a valid [hexadecimal color code](http://www.color-hex.com/).
     */
    post: operations["issues/create-label"];
  };
  "/repos/{owner}/{repo}/labels/{name}": {
    /**
     * Get a label
     * @description Gets a label using the given name.
     */
    get: operations["issues/get-label"];
    /**
     * Delete a label
     * @description Deletes a label using the given label name.
     */
    delete: operations["issues/delete-label"];
    /**
     * Update a label
     * @description Updates a label using the given label name.
     */
    patch: operations["issues/update-label"];
  };
  "/repos/{owner}/{repo}/languages": {
    /**
     * List repository languages
     * @description Lists languages for the specified repository. The value shown for each language is the number of bytes of code written in that language.
     */
    get: operations["repos/list-languages"];
  };
  "/repos/{owner}/{repo}/lfs": {
    /**
     * Enable Git LFS for a repository
     * @description Enables Git LFS for a repository.
     *
     * OAuth app tokens and personal access tokens (classic) need the `admin:enterprise` scope to use this endpoint.
     */
    put: operations["repos/enable-lfs-for-repo"];
    /**
     * Disable Git LFS for a repository
     * @description Disables Git LFS for a repository.
     *
     * OAuth app tokens and personal access tokens (classic) need the `admin:enterprise` scope to use this endpoint.
     */
    delete: operations["repos/disable-lfs-for-repo"];
  };
  "/repos/{owner}/{repo}/license": {
    /**
     * Get the license for a repository
     * @description This method returns the contents of the repository's license file, if one is detected.
     *
     * This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/enterprise-server@3.10/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
     *
     * - **`application/vnd.github.raw+json`**: Returns the raw contents of the license.
     * - **`application/vnd.github.html+json`**: Returns the license contents in HTML. Markup languages are rendered to HTML using GitHub's open-source [Markup library](https://github.com/github/markup).
     */
    get: operations["licenses/get-for-repo"];
  };
  "/repos/{owner}/{repo}/merge-upstream": {
    /**
     * Sync a fork branch with the upstream repository
     * @description Sync a branch of a forked repository to keep it up-to-date with the upstream repository.
     */
    post: operations["repos/merge-upstream"];
  };
  "/repos/{owner}/{repo}/merges": {
    /** Merge a branch */
    post: operations["repos/merge"];
  };
  "/repos/{owner}/{repo}/milestones": {
    /**
     * List milestones
     * @description Lists milestones for a repository.
     */
    get: operations["issues/list-milestones"];
    /**
     * Create a milestone
     * @description Creates a milestone.
     */
    post: operations["issues/create-milestone"];
  };
  "/repos/{owner}/{repo}/milestones/{milestone_number}": {
    /**
     * Get a milestone
     * @description Gets a milestone using the given milestone number.
     */
    get: operations["issues/get-milestone"];
    /**
     * Delete a milestone
     * @description Deletes a milestone using the given milestone number.
     */
    delete: operations["issues/delete-milestone"];
    /** Update a milestone */
    patch: operations["issues/update-milestone"];
  };
  "/repos/{owner}/{repo}/milestones/{milestone_number}/labels": {
    /**
     * List labels for issues in a milestone
     * @description Lists labels for issues in a milestone.
     */
    get: operations["issues/list-labels-for-milestone"];
  };
  "/repos/{owner}/{repo}/notifications": {
    /**
     * List repository notifications for the authenticated user
     * @description Lists all notifications for the current user in the specified repository.
     */
    get: operations["activity/list-repo-notifications-for-authenticated-user"];
    /**
     * Mark repository notifications as read
     * @description Marks all notifications in a repository as "read" for the current user. If the number of notifications is too large to complete in one request, you will receive a `202 Accepted` status and GitHub Enterprise Server will run an asynchronous process to mark notifications as "read." To check whether any "unread" notifications remain, you can use the [List repository notifications for the authenticated user](https://docs.github.com/enterprise-server@3.10/rest/activity/notifications#list-repository-notifications-for-the-authenticated-user) endpoint and pass the query parameter `all=false`.
     */
    put: operations["activity/mark-repo-notifications-as-read"];
  };
  "/repos/{owner}/{repo}/pages": {
    /**
     * Get a GitHub Enterprise Server Pages site
     * @description Gets information about a GitHub Enterprise Server Pages site.
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    get: operations["repos/get-pages"];
    /**
     * Update information about a GitHub Enterprise Server Pages site
     * @description Updates information for a GitHub Enterprise Server Pages site. For more information, see "[About GitHub Pages](/github/working-with-github-pages/about-github-pages).
     *
     * The authenticated user must be a repository administrator, maintainer, or have the 'manage GitHub Pages settings' permission.
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    put: operations["repos/update-information-about-pages-site"];
    /**
     * Create a GitHub Enterprise Server Pages site
     * @description Configures a GitHub Enterprise Server Pages site. For more information, see "[About GitHub Pages](/github/working-with-github-pages/about-github-pages)."
     *
     * The authenticated user must be a repository administrator, maintainer, or have the 'manage GitHub Pages settings' permission.
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    post: operations["repos/create-pages-site"];
    /**
     * Delete a GitHub Enterprise Server Pages site
     * @description Deletes a GitHub Enterprise Server Pages site. For more information, see "[About GitHub Pages](/github/working-with-github-pages/about-github-pages).
     *
     * The authenticated user must be a repository administrator, maintainer, or have the 'manage GitHub Pages settings' permission.
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    delete: operations["repos/delete-pages-site"];
  };
  "/repos/{owner}/{repo}/pages/builds": {
    /**
     * List GitHub Enterprise Server Pages builds
     * @description Lists builts of a GitHub Enterprise Server Pages site.
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    get: operations["repos/list-pages-builds"];
    /**
     * Request a GitHub Enterprise Server Pages build
     * @description You can request that your site be built from the latest revision on the default branch. This has the same effect as pushing a commit to your default branch, but does not require an additional commit. Manually triggering page builds can be helpful when diagnosing build warnings and failures.
     *
     * Build requests are limited to one concurrent build per repository and one concurrent build per requester. If you request a build while another is still in progress, the second request will be queued until the first completes.
     */
    post: operations["repos/request-pages-build"];
  };
  "/repos/{owner}/{repo}/pages/builds/latest": {
    /**
     * Get latest Pages build
     * @description Gets information about the single most recent build of a GitHub Enterprise Server Pages site.
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    get: operations["repos/get-latest-pages-build"];
  };
  "/repos/{owner}/{repo}/pages/builds/{build_id}": {
    /**
     * Get GitHub Enterprise Server Pages build
     * @description Gets information about a GitHub Enterprise Server Pages build.
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    get: operations["repos/get-pages-build"];
  };
  "/repos/{owner}/{repo}/pages/deployments": {
    /**
     * Create a GitHub Pages deployment
     * @description Create a GitHub Pages deployment for a repository.
     *
     * The authenticated user must have write permission to the repository.
     */
    post: operations["repos/create-pages-deployment"];
  };
  "/repos/{owner}/{repo}/pre-receive-hooks": {
    /**
     * List pre-receive hooks for a repository
     * @description List all pre-receive hooks that are enabled or testing for this repository as well as any disabled hooks that are allowed to be enabled at the repository level. Pre-receive hooks that are disabled at a higher level and are not configurable will not be listed.
     */
    get: operations["enterprise-admin/list-pre-receive-hooks-for-repo"];
  };
  "/repos/{owner}/{repo}/pre-receive-hooks/{pre_receive_hook_id}": {
    /** Get a pre-receive hook for a repository */
    get: operations["enterprise-admin/get-pre-receive-hook-for-repo"];
    /**
     * Remove pre-receive hook enforcement for a repository
     * @description Deletes any overridden enforcement on this repository for the specified hook.
     *
     * Responds with effective values inherited from owner and/or global level.
     */
    delete: operations["enterprise-admin/remove-pre-receive-hook-enforcement-for-repo"];
    /**
     * Update pre-receive hook enforcement for a repository
     * @description For pre-receive hooks which are allowed to be configured at the repo level, you can set `enforcement`
     */
    patch: operations["enterprise-admin/update-pre-receive-hook-enforcement-for-repo"];
  };
  "/repos/{owner}/{repo}/projects": {
    /**
     * List repository projects
     * @description Lists the projects in a repository. Returns a `404 Not Found` status if projects are disabled in the repository. If you do not have sufficient privileges to perform this action, a `401 Unauthorized` or `410 Gone` status is returned.
     */
    get: operations["projects/list-for-repo"];
    /**
     * Create a repository project
     * @description Creates a repository project board. Returns a `410 Gone` status if projects are disabled in the repository or if the repository does not have existing classic projects. If you do not have sufficient privileges to perform this action, a `401 Unauthorized` or `410 Gone` status is returned.
     */
    post: operations["projects/create-for-repo"];
  };
  "/repos/{owner}/{repo}/pulls": {
    /**
     * List pull requests
     * @description Lists pull requests in a specified repository.
     *
     * Draft pull requests are available in public repositories with GitHub
     * Free and GitHub Free for organizations, GitHub Pro, and legacy per-repository billing
     * plans, and in public and private repositories with GitHub Team and GitHub Enterprise
     * Cloud. For more information, see [GitHub's products](https://docs.github.com/enterprise-server@3.10/github/getting-started-with-github/githubs-products)
     * in the GitHub Help documentation.
     *
     * This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/enterprise-server@3.10/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
     *
     * - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
     * - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
     * - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
     * - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
     * - **`application/vnd.github.diff`**: For more information, see "[git-diff](https://git-scm.com/docs/git-diff)" in the Git documentation. If a diff is corrupt, contact us through the [GitHub Support portal](https://support.github.com/). Include the repository name and pull request ID in your message.
     * - **`application/vnd.github.patch`**: For more information, see "[git-format-patch](https://git-scm.com/docs/git-format-patch)" in the Git documentation.
     */
    get: operations["pulls/list"];
    /**
     * Create a pull request
     * @description Draft pull requests are available in public repositories with GitHub Free and GitHub Free for organizations, GitHub Pro, and legacy per-repository billing plans, and in public and private repositories with GitHub Team and GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/enterprise-server@3.10/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * To open or update a pull request in a public repository, you must have write access to the head or the source branch. For organization-owned repositories, you must be a member of the organization that owns the repository to open or update a pull request.
     *
     * This endpoint triggers [notifications](https://docs.github.com/enterprise-server@3.10/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/enterprise-server@3.10/rest/overview/rate-limits-for-the-rest-api#about-secondary-rate-limits)" and "[Best practices for using the REST API](https://docs.github.com/enterprise-server@3.10/rest/guides/best-practices-for-using-the-rest-api)."
     *
     * This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/enterprise-server@3.10/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
     *
     * - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
     * - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
     * - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
     * - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
     * - **`application/vnd.github.diff`**: For more information, see "[git-diff](https://git-scm.com/docs/git-diff)" in the Git documentation. If a diff is corrupt, contact us through the [GitHub Support portal](https://support.github.com/). Include the repository name and pull request ID in your message.
     */
    post: operations["pulls/create"];
  };
  "/repos/{owner}/{repo}/pulls/comments": {
    /**
     * List review comments in a repository
     * @description Lists review comments for all pull requests in a repository. By default,
     * review comments are in ascending order by ID.
     *
     * This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/enterprise-server@3.10/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
     *
     * - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
     * - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
     * - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
     * - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
     */
    get: operations["pulls/list-review-comments-for-repo"];
  };
  "/repos/{owner}/{repo}/pulls/comments/{comment_id}": {
    /**
     * Get a review comment for a pull request
     * @description Provides details for a specified review comment.
     *
     * This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/enterprise-server@3.10/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
     *
     * - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
     * - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
     * - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
     * - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
     */
    get: operations["pulls/get-review-comment"];
    /**
     * Delete a review comment for a pull request
     * @description Deletes a review comment.
     */
    delete: operations["pulls/delete-review-comment"];
    /**
     * Update a review comment for a pull request
     * @description Edits the content of a specified review comment.
     *
     * This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/enterprise-server@3.10/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
     *
     * - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
     * - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
     * - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
     * - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
     */
    patch: operations["pulls/update-review-comment"];
  };
  "/repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions": {
    /**
     * List reactions for a pull request review comment
     * @description List the reactions to a [pull request review comment](https://docs.github.com/enterprise-server@3.10/rest/pulls/comments#get-a-review-comment-for-a-pull-request).
     */
    get: operations["reactions/list-for-pull-request-review-comment"];
    /**
     * Create reaction for a pull request review comment
     * @description Create a reaction to a [pull request review comment](https://docs.github.com/enterprise-server@3.10/rest/pulls/comments#get-a-review-comment-for-a-pull-request). A response with an HTTP `200` status means that you already added the reaction type to this pull request review comment.
     */
    post: operations["reactions/create-for-pull-request-review-comment"];
  };
  "/repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions/{reaction_id}": {
    /**
     * Delete a pull request comment reaction
     * @description **Note:** You can also specify a repository by `repository_id` using the route `DELETE /repositories/:repository_id/pulls/comments/:comment_id/reactions/:reaction_id.`
     *
     * Delete a reaction to a [pull request review comment](https://docs.github.com/enterprise-server@3.10/rest/pulls/comments#get-a-review-comment-for-a-pull-request).
     */
    delete: operations["reactions/delete-for-pull-request-comment"];
  };
  "/repos/{owner}/{repo}/pulls/{pull_number}": {
    /**
     * Get a pull request
     * @description Draft pull requests are available in public repositories with GitHub Free and GitHub Free for organizations, GitHub Pro, and legacy per-repository billing plans, and in public and private repositories with GitHub Team and GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/enterprise-server@3.10/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * Lists details of a pull request by providing its number.
     *
     * When you get, [create](https://docs.github.com/enterprise-server@3.10/rest/pulls/pulls/#create-a-pull-request), or [edit](https://docs.github.com/enterprise-server@3.10/rest/pulls/pulls#update-a-pull-request) a pull request, GitHub Enterprise Server creates a merge commit to test whether the pull request can be automatically merged into the base branch. This test commit is not added to the base branch or the head branch. You can review the status of the test commit using the `mergeable` key. For more information, see "[Checking mergeability of pull requests](https://docs.github.com/enterprise-server@3.10/rest/guides/getting-started-with-the-git-database-api#checking-mergeability-of-pull-requests)".
     *
     * The value of the `mergeable` attribute can be `true`, `false`, or `null`. If the value is `null`, then GitHub Enterprise Server has started a background job to compute the mergeability. After giving the job time to complete, resubmit the request. When the job finishes, you will see a non-`null` value for the `mergeable` attribute in the response. If `mergeable` is `true`, then `merge_commit_sha` will be the SHA of the _test_ merge commit.
     *
     * The value of the `merge_commit_sha` attribute changes depending on the state of the pull request. Before merging a pull request, the `merge_commit_sha` attribute holds the SHA of the _test_ merge commit. After merging a pull request, the `merge_commit_sha` attribute changes depending on how you merged the pull request:
     *
     * *   If merged as a [merge commit](https://docs.github.com/enterprise-server@3.10/articles/about-merge-methods-on-github/), `merge_commit_sha` represents the SHA of the merge commit.
     * *   If merged via a [squash](https://docs.github.com/enterprise-server@3.10/articles/about-merge-methods-on-github/#squashing-your-merge-commits), `merge_commit_sha` represents the SHA of the squashed commit on the base branch.
     * *   If [rebased](https://docs.github.com/enterprise-server@3.10/articles/about-merge-methods-on-github/#rebasing-and-merging-your-commits), `merge_commit_sha` represents the commit that the base branch was updated to.
     *
     * Pass the appropriate [media type](https://docs.github.com/enterprise-server@3.10/rest/overview/media-types/#commits-commit-comparison-and-pull-requests) to fetch diff and patch formats.
     *
     * This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/enterprise-server@3.10/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
     *
     * - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
     * - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
     * - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
     * - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
     * - **`application/vnd.github.diff`**: For more information, see "[git-diff](https://git-scm.com/docs/git-diff)" in the Git documentation. If a diff is corrupt, contact us through the [GitHub Support portal](https://support.github.com/). Include the repository name and pull request ID in your message.
     */
    get: operations["pulls/get"];
    /**
     * Update a pull request
     * @description Draft pull requests are available in public repositories with GitHub Free and GitHub Free for organizations, GitHub Pro, and legacy per-repository billing plans, and in public and private repositories with GitHub Team and GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/enterprise-server@3.10/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * To open or update a pull request in a public repository, you must have write access to the head or the source branch. For organization-owned repositories, you must be a member of the organization that owns the repository to open or update a pull request.
     *
     * This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/enterprise-server@3.10/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
     *
     * - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
     * - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
     * - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
     * - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
     * - **`application/vnd.github.diff`**: For more information, see "[git-diff](https://git-scm.com/docs/git-diff)" in the Git documentation. If a diff is corrupt, contact us through the [GitHub Support portal](https://support.github.com/). Include the repository name and pull request ID in your message.
     */
    patch: operations["pulls/update"];
  };
  "/repos/{owner}/{repo}/pulls/{pull_number}/comments": {
    /**
     * List review comments on a pull request
     * @description Lists all review comments for a specified pull request. By default, review comments
     * are in ascending order by ID.
     *
     * This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/enterprise-server@3.10/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
     *
     * - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
     * - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
     * - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
     * - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
     */
    get: operations["pulls/list-review-comments"];
    /**
     * Create a review comment for a pull request
     * @description Creates a review comment on the diff of a specified pull request. To add a regular comment to a pull request timeline, see "[Create an issue comment](https://docs.github.com/enterprise-server@3.10/rest/issues/comments#create-an-issue-comment)."
     *
     * If your comment applies to more than one line in the pull request diff, you should use the parameters `line`, `side`, and optionally `start_line` and `start_side` in your request.
     *
     * The `position` parameter is deprecated. If you use `position`, the `line`, `side`, `start_line`, and `start_side` parameters are not required.
     *
     * This endpoint triggers [notifications](https://docs.github.com/enterprise-server@3.10/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/enterprise-server@3.10/rest/overview/rate-limits-for-the-rest-api#about-secondary-rate-limits)"
     * and "[Best practices for using the REST API](https://docs.github.com/enterprise-server@3.10/rest/guides/best-practices-for-using-the-rest-api)."
     *
     * This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/enterprise-server@3.10/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
     *
     * - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
     * - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
     * - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
     * - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
     */
    post: operations["pulls/create-review-comment"];
  };
  "/repos/{owner}/{repo}/pulls/{pull_number}/comments/{comment_id}/replies": {
    /**
     * Create a reply for a review comment
     * @description Creates a reply to a review comment for a pull request. For the `comment_id`, provide the ID of the review comment you are replying to. This must be the ID of a _top-level review comment_, not a reply to that comment. Replies to replies are not supported.
     *
     * This endpoint triggers [notifications](https://docs.github.com/enterprise-server@3.10/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/enterprise-server@3.10/rest/overview/rate-limits-for-the-rest-api#about-secondary-rate-limits)"
     * and "[Best practices for using the REST API](https://docs.github.com/enterprise-server@3.10/rest/guides/best-practices-for-using-the-rest-api)."
     *
     * This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/enterprise-server@3.10/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
     *
     * - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
     * - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
     * - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
     * - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
     */
    post: operations["pulls/create-reply-for-review-comment"];
  };
  "/repos/{owner}/{repo}/pulls/{pull_number}/commits": {
    /**
     * List commits on a pull request
     * @description Lists a maximum of 250 commits for a pull request. To receive a complete
     * commit list for pull requests with more than 250 commits, use the [List commits](https://docs.github.com/enterprise-server@3.10/rest/commits/commits#list-commits)
     * endpoint.
     *
     * This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/enterprise-server@3.10/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
     *
     * - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
     * - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
     * - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
     * - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
     * - **`application/vnd.github.diff`**: For more information, see "[git-diff](https://git-scm.com/docs/git-diff)" in the Git documentation. If a diff is corrupt, contact us through the [GitHub Support portal](https://support.github.com/). Include the repository name and pull request ID in your message.
     */
    get: operations["pulls/list-commits"];
  };
  "/repos/{owner}/{repo}/pulls/{pull_number}/files": {
    /**
     * List pull requests files
     * @description Lists the files in a specified pull request.
     *
     * **Note:** Responses include a maximum of 3000 files. The paginated response
     * returns 30 files per page by default.
     *
     * This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/enterprise-server@3.10/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
     *
     * - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
     * - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
     * - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
     * - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
     * - **`application/vnd.github.diff`**: For more information, see "[git-diff](https://git-scm.com/docs/git-diff)" in the Git documentation. If a diff is corrupt, contact us through the [GitHub Support portal](https://support.github.com/). Include the repository name and pull request ID in your message.
     */
    get: operations["pulls/list-files"];
  };
  "/repos/{owner}/{repo}/pulls/{pull_number}/merge": {
    /**
     * Check if a pull request has been merged
     * @description Checks if a pull request has been merged into the base branch. The HTTP status of the response indicates whether or not the pull request has been merged; the response body is empty.
     */
    get: operations["pulls/check-if-merged"];
    /**
     * Merge a pull request
     * @description Merges a pull request into the base branch.
     * This endpoint triggers [notifications](https://docs.github.com/enterprise-server@3.10/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/enterprise-server@3.10/rest/overview/rate-limits-for-the-rest-api#about-secondary-rate-limits)" and "[Best practices for using the REST API](https://docs.github.com/enterprise-server@3.10/rest/guides/best-practices-for-using-the-rest-api)."
     */
    put: operations["pulls/merge"];
  };
  "/repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers": {
    /**
     * Get all requested reviewers for a pull request
     * @description Gets the users or teams whose review is requested for a pull request. Once a requested reviewer submits a review, they are no longer considered a requested reviewer. Their review will instead be returned by the [List reviews for a pull request](https://docs.github.com/enterprise-server@3.10/rest/pulls/reviews#list-reviews-for-a-pull-request) operation.
     */
    get: operations["pulls/list-requested-reviewers"];
    /**
     * Request reviewers for a pull request
     * @description This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. See "[Secondary rate limits](https://docs.github.com/rest/overview/resources-in-the-rest-api#secondary-rate-limits)" and "[Dealing with secondary rate limits](https://docs.github.com/rest/guides/best-practices-for-integrators#dealing-with-secondary-rate-limits)" for details.
     */
    post: operations["pulls/request-reviewers"];
    /**
     * Remove requested reviewers from a pull request
     * @description Removes review requests from a pull request for a given set of users and/or teams.
     */
    delete: operations["pulls/remove-requested-reviewers"];
  };
  "/repos/{owner}/{repo}/pulls/{pull_number}/reviews": {
    /**
     * List reviews for a pull request
     * @description Lists all reviews for a specified pull request. The list of reviews returns in chronological order.
     *
     * This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/enterprise-server@3.10/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
     *
     * - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
     * - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
     * - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
     * - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
     */
    get: operations["pulls/list-reviews"];
    /**
     * Create a review for a pull request
     * @description Creates a review on a specified pull request.
     *
     * This endpoint triggers [notifications](https://docs.github.com/enterprise-server@3.10/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/enterprise-server@3.10/rest/overview/rate-limits-for-the-rest-api#about-secondary-rate-limits)" and "[Best practices for using the REST API](https://docs.github.com/enterprise-server@3.10/rest/guides/best-practices-for-using-the-rest-api)."
     *
     * Pull request reviews created in the `PENDING` state are not submitted and therefore do not include the `submitted_at` property in the response. To create a pending review for a pull request, leave the `event` parameter blank. For more information about submitting a `PENDING` review, see "[Submit a review for a pull request](https://docs.github.com/enterprise-server@3.10/rest/pulls/reviews#submit-a-review-for-a-pull-request)."
     *
     * **Note:** To comment on a specific line in a file, you need to first determine the position of that line in the diff. To see a pull request diff, add the `application/vnd.github.v3.diff` media type to the `Accept` header of a call to the [Get a pull request](https://docs.github.com/enterprise-server@3.10/rest/pulls/pulls#get-a-pull-request) endpoint.
     *
     * The `position` value equals the number of lines down from the first "@@" hunk header in the file you want to add a comment. The line just below the "@@" line is position 1, the next line is position 2, and so on. The position in the diff continues to increase through lines of whitespace and additional hunks until the beginning of a new file.
     *
     * This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/enterprise-server@3.10/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
     *
     * - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
     * - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
     * - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
     * - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
     */
    post: operations["pulls/create-review"];
  };
  "/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}": {
    /**
     * Get a review for a pull request
     * @description Retrieves a pull request review by its ID.
     *
     * This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/enterprise-server@3.10/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
     *
     * - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
     * - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
     * - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
     * - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
     */
    get: operations["pulls/get-review"];
    /**
     * Update a review for a pull request
     * @description Updates the contents of a specified review summary comment.
     *
     * This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/enterprise-server@3.10/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
     *
     * - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
     * - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
     * - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
     * - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
     */
    put: operations["pulls/update-review"];
    /**
     * Delete a pending review for a pull request
     * @description Deletes a pull request review that has not been submitted. Submitted reviews cannot be deleted.
     *
     * This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/enterprise-server@3.10/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
     *
     * - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
     * - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
     * - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
     * - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
     */
    delete: operations["pulls/delete-pending-review"];
  };
  "/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/comments": {
    /**
     * List comments for a pull request review
     * @description Lists comments for a specific pull request review.
     *
     * This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/enterprise-server@3.10/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
     *
     * - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
     * - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
     * - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
     * - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
     */
    get: operations["pulls/list-comments-for-review"];
  };
  "/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/dismissals": {
    /**
     * Dismiss a review for a pull request
     * @description Dismisses a specified review on a pull request.
     *
     * **Note:** To dismiss a pull request review on a [protected branch](https://docs.github.com/enterprise-server@3.10/rest/branches/branch-protection),
     * you must be a repository administrator or be included in the list of people or teams
     * who can dismiss pull request reviews.
     *
     * This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/enterprise-server@3.10/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
     *
     * - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
     * - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
     * - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
     * - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
     */
    put: operations["pulls/dismiss-review"];
  };
  "/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/events": {
    /**
     * Submit a review for a pull request
     * @description Submits a pending review for a pull request. For more information about creating a pending review for a pull request, see "[Create a review for a pull request](https://docs.github.com/enterprise-server@3.10/rest/pulls/reviews#create-a-review-for-a-pull-request)."
     *
     * This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/enterprise-server@3.10/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
     *
     * - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
     * - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
     * - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
     * - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
     */
    post: operations["pulls/submit-review"];
  };
  "/repos/{owner}/{repo}/pulls/{pull_number}/update-branch": {
    /**
     * Update a pull request branch
     * @description Updates the pull request branch with the latest upstream changes by merging HEAD from the base branch into the pull request branch.
     */
    put: operations["pulls/update-branch"];
  };
  "/repos/{owner}/{repo}/readme": {
    /**
     * Get a repository README
     * @description Gets the preferred README for a repository.
     *
     * This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/enterprise-server@3.10/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
     *
     * - **`application/vnd.github.raw+json`**: Returns the raw file contents. This is the default if you do not specify a media type.
     * - **`application/vnd.github.html+json`**: Returns the README in HTML. Markup languages are rendered to HTML using GitHub's open-source [Markup library](https://github.com/github/markup).
     */
    get: operations["repos/get-readme"];
  };
  "/repos/{owner}/{repo}/readme/{dir}": {
    /**
     * Get a repository README for a directory
     * @description Gets the README from a repository directory.
     *
     * This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/enterprise-server@3.10/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
     *
     * - **`application/vnd.github.raw+json`**: Returns the raw file contents. This is the default if you do not specify a media type.
     * - **`application/vnd.github.html+json`**: Returns the README in HTML. Markup languages are rendered to HTML using GitHub's open-source [Markup library](https://github.com/github/markup).
     */
    get: operations["repos/get-readme-in-directory"];
  };
  "/repos/{owner}/{repo}/releases": {
    /**
     * List releases
     * @description This returns a list of releases, which does not include regular Git tags that have not been associated with a release. To get a list of Git tags, use the [Repository Tags API](https://docs.github.com/enterprise-server@3.10/rest/repos/repos#list-repository-tags).
     *
     * Information about published releases are available to everyone. Only users with push access will receive listings for draft releases.
     */
    get: operations["repos/list-releases"];
    /**
     * Create a release
     * @description Users with push access to the repository can create a release.
     *
     * This endpoint triggers [notifications](https://docs.github.com/enterprise-server@3.10/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/enterprise-server@3.10/rest/overview/rate-limits-for-the-rest-api#about-secondary-rate-limits)" and "[Best practices for using the REST API](https://docs.github.com/enterprise-server@3.10/rest/guides/best-practices-for-using-the-rest-api)."
     */
    post: operations["repos/create-release"];
  };
  "/repos/{owner}/{repo}/releases/assets/{asset_id}": {
    /**
     * Get a release asset
     * @description To download the asset's binary content, set the `Accept` header of the request to [`application/octet-stream`](https://docs.github.com/enterprise-server@3.10/rest/overview/media-types). The API will either redirect the client to the location, or stream it directly if possible. API clients should handle both a `200` or `302` response.
     */
    get: operations["repos/get-release-asset"];
    /** Delete a release asset */
    delete: operations["repos/delete-release-asset"];
    /**
     * Update a release asset
     * @description Users with push access to the repository can edit a release asset.
     */
    patch: operations["repos/update-release-asset"];
  };
  "/repos/{owner}/{repo}/releases/generate-notes": {
    /**
     * Generate release notes content for a release
     * @description Generate a name and body describing a [release](https://docs.github.com/enterprise-server@3.10/rest/releases/releases#get-a-release). The body content will be markdown formatted and contain information like the changes since last release and users who contributed. The generated release notes are not saved anywhere. They are intended to be generated and used when creating a new release.
     */
    post: operations["repos/generate-release-notes"];
  };
  "/repos/{owner}/{repo}/releases/latest": {
    /**
     * Get the latest release
     * @description View the latest published full release for the repository.
     *
     * The latest release is the most recent non-prerelease, non-draft release, sorted by the `created_at` attribute. The `created_at` attribute is the date of the commit used for the release, and not the date when the release was drafted or published.
     */
    get: operations["repos/get-latest-release"];
  };
  "/repos/{owner}/{repo}/releases/tags/{tag}": {
    /**
     * Get a release by tag name
     * @description Get a published release with the specified tag.
     */
    get: operations["repos/get-release-by-tag"];
  };
  "/repos/{owner}/{repo}/releases/{release_id}": {
    /**
     * Get a release
     * @description Gets a public release with the specified release ID.
     *
     * **Note:** This returns an `upload_url` key corresponding to the endpoint
     * for uploading release assets. This key is a hypermedia resource. For more information, see
     * "[Getting started with the REST API](https://docs.github.com/enterprise-server@3.10/rest/using-the-rest-api/getting-started-with-the-rest-api#hypermedia)."
     */
    get: operations["repos/get-release"];
    /**
     * Delete a release
     * @description Users with push access to the repository can delete a release.
     */
    delete: operations["repos/delete-release"];
    /**
     * Update a release
     * @description Users with push access to the repository can edit a release.
     */
    patch: operations["repos/update-release"];
  };
  "/repos/{owner}/{repo}/releases/{release_id}/assets": {
    /** List release assets */
    get: operations["repos/list-release-assets"];
    /**
     * Upload a release asset
     * @description This endpoint makes use of a [Hypermedia relation](https://docs.github.com/enterprise-server@3.10/rest/using-the-rest-api/getting-started-with-the-rest-api#hypermedia) to determine which URL to access. The endpoint you call to upload release assets is specific to your release. Use the `upload_url` returned in
     * the response of the [Create a release endpoint](https://docs.github.com/enterprise-server@3.10/rest/releases/releases#create-a-release) to upload a release asset.
     *
     * You need to use an HTTP client which supports [SNI](http://en.wikipedia.org/wiki/Server_Name_Indication) to make calls to this endpoint.
     *
     * Most libraries will set the required `Content-Length` header automatically. Use the required `Content-Type` header to provide the media type of the asset. For a list of media types, see [Media Types](https://www.iana.org/assignments/media-types/media-types.xhtml). For example:
     *
     * `application/zip`
     *
     * GitHub Enterprise Server expects the asset data in its raw binary form, rather than JSON. You will send the raw binary content of the asset as the request body. Everything else about the endpoint is the same as the rest of the API. For example,
     * you'll still need to pass your authentication to be able to upload an asset.
     *
     * When an upstream failure occurs, you will receive a `502 Bad Gateway` status. This may leave an empty asset with a state of `starter`. It can be safely deleted.
     *
     * **Notes:**
     * *   GitHub Enterprise Server renames asset filenames that have special characters, non-alphanumeric characters, and leading or trailing periods. The "[List release assets](https://docs.github.com/enterprise-server@3.10/rest/releases/assets#list-release-assets)"
     * endpoint lists the renamed filenames. For more information and help, contact [GitHub Enterprise Server Support](https://support.github.com/contact?tags=dotcom-rest-api).
     * *   To find the `release_id` query the [`GET /repos/{owner}/{repo}/releases/latest` endpoint](https://docs.github.com/enterprise-server@3.10/rest/releases/releases#get-the-latest-release).
     * *   If you upload an asset with the same filename as another uploaded asset, you'll receive an error and must delete the old file before you can re-upload the new asset.
     */
    post: operations["repos/upload-release-asset"];
  };
  "/repos/{owner}/{repo}/releases/{release_id}/reactions": {
    /**
     * List reactions for a release
     * @description List the reactions to a [release](https://docs.github.com/enterprise-server@3.10/rest/releases/releases#get-a-release).
     */
    get: operations["reactions/list-for-release"];
    /**
     * Create reaction for a release
     * @description Create a reaction to a [release](https://docs.github.com/enterprise-server@3.10/rest/releases/releases#get-a-release). A response with a `Status: 200 OK` means that you already added the reaction type to this release.
     */
    post: operations["reactions/create-for-release"];
  };
  "/repos/{owner}/{repo}/releases/{release_id}/reactions/{reaction_id}": {
    /**
     * Delete a release reaction
     * @description **Note:** You can also specify a repository by `repository_id` using the route `DELETE delete /repositories/:repository_id/releases/:release_id/reactions/:reaction_id`.
     *
     * Delete a reaction to a [release](https://docs.github.com/enterprise-server@3.10/rest/releases/releases#get-a-release).
     */
    delete: operations["reactions/delete-for-release"];
  };
  "/repos/{owner}/{repo}/replicas/caches": {
    /**
     * List repository cache replication status
     * @description Lists the status of each repository cache replica.
     */
    get: operations["repos/list-cache-info"];
  };
  "/repos/{owner}/{repo}/secret-scanning/alerts": {
    /**
     * List secret scanning alerts for a repository
     * @description Lists secret scanning alerts for an eligible repository, from newest to oldest.
     *
     * The authenticated user must be an administrator for the repository or for the organization that owns the repository to use this endpoint.
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` or `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.
     */
    get: operations["secret-scanning/list-alerts-for-repo"];
  };
  "/repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}": {
    /**
     * Get a secret scanning alert
     * @description Gets a single secret scanning alert detected in an eligible repository.
     *
     * The authenticated user must be an administrator for the repository or for the organization that owns the repository to use this endpoint.
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` or `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.
     */
    get: operations["secret-scanning/get-alert"];
    /**
     * Update a secret scanning alert
     * @description Updates the status of a secret scanning alert in an eligible repository.
     *
     * The authenticated user must be an administrator for the repository or for the organization that owns the repository to use this endpoint.
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` or `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.
     */
    patch: operations["secret-scanning/update-alert"];
  };
  "/repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}/locations": {
    /**
     * List locations for a secret scanning alert
     * @description Lists all locations for a given secret scanning alert for an eligible repository.
     *
     * The authenticated user must be an administrator for the repository or for the organization that owns the repository to use this endpoint.
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` or `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.
     */
    get: operations["secret-scanning/list-locations-for-alert"];
  };
  "/repos/{owner}/{repo}/stargazers": {
    /**
     * List stargazers
     * @description Lists the people that have starred the repository.
     *
     * This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/enterprise-server@3.10/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
     *
     * - **`application/vnd.github.star+json`**: Includes a timestamp of when the star was created.
     */
    get: operations["activity/list-stargazers-for-repo"];
  };
  "/repos/{owner}/{repo}/stats/code_frequency": {
    /**
     * Get the weekly commit activity
     * @description Returns a weekly aggregate of the number of additions and deletions pushed to a repository.
     */
    get: operations["repos/get-code-frequency-stats"];
  };
  "/repos/{owner}/{repo}/stats/commit_activity": {
    /**
     * Get the last year of commit activity
     * @description Returns the last year of commit activity grouped by week. The `days` array is a group of commits per day, starting on `Sunday`.
     */
    get: operations["repos/get-commit-activity-stats"];
  };
  "/repos/{owner}/{repo}/stats/contributors": {
    /**
     * Get all contributor commit activity
     * @description
     * Returns the `total` number of commits authored by the contributor. In addition, the response includes a Weekly Hash (`weeks` array) with the following information:
     *
     * *   `w` - Start of the week, given as a [Unix timestamp](https://en.wikipedia.org/wiki/Unix_time).
     * *   `a` - Number of additions
     * *   `d` - Number of deletions
     * *   `c` - Number of commits
     */
    get: operations["repos/get-contributors-stats"];
  };
  "/repos/{owner}/{repo}/stats/participation": {
    /**
     * Get the weekly commit count
     * @description Returns the total commit counts for the `owner` and total commit counts in `all`. `all` is everyone combined, including the `owner` in the last 52 weeks. If you'd like to get the commit counts for non-owners, you can subtract `owner` from `all`.
     *
     * The array order is oldest week (index 0) to most recent week.
     *
     * The most recent week is seven days ago at UTC midnight to today at UTC midnight.
     */
    get: operations["repos/get-participation-stats"];
  };
  "/repos/{owner}/{repo}/stats/punch_card": {
    /**
     * Get the hourly commit count for each day
     * @description Each array contains the day number, hour number, and number of commits:
     *
     * *   `0-6`: Sunday - Saturday
     * *   `0-23`: Hour of day
     * *   Number of commits
     *
     * For example, `[2, 14, 25]` indicates that there were 25 total commits, during the 2:00pm hour on Tuesdays. All times are based on the time zone of individual commits.
     */
    get: operations["repos/get-punch-card-stats"];
  };
  "/repos/{owner}/{repo}/statuses/{sha}": {
    /**
     * Create a commit status
     * @description Users with push access in a repository can create commit statuses for a given SHA.
     *
     * Note: there is a limit of 1000 statuses per `sha` and `context` within a repository. Attempts to create more than 1000 statuses will result in a validation error.
     */
    post: operations["repos/create-commit-status"];
  };
  "/repos/{owner}/{repo}/subscribers": {
    /**
     * List watchers
     * @description Lists the people watching the specified repository.
     */
    get: operations["activity/list-watchers-for-repo"];
  };
  "/repos/{owner}/{repo}/subscription": {
    /**
     * Get a repository subscription
     * @description Gets information about whether the authenticated user is subscribed to the repository.
     */
    get: operations["activity/get-repo-subscription"];
    /**
     * Set a repository subscription
     * @description If you would like to watch a repository, set `subscribed` to `true`. If you would like to ignore notifications made within a repository, set `ignored` to `true`. If you would like to stop watching a repository, [delete the repository's subscription](https://docs.github.com/enterprise-server@3.10/rest/activity/watching#delete-a-repository-subscription) completely.
     */
    put: operations["activity/set-repo-subscription"];
    /**
     * Delete a repository subscription
     * @description This endpoint should only be used to stop watching a repository. To control whether or not you wish to receive notifications from a repository, [set the repository's subscription manually](https://docs.github.com/enterprise-server@3.10/rest/activity/watching#set-a-repository-subscription).
     */
    delete: operations["activity/delete-repo-subscription"];
  };
  "/repos/{owner}/{repo}/tags": {
    /** List repository tags */
    get: operations["repos/list-tags"];
  };
  "/repos/{owner}/{repo}/tags/protection": {
    /**
     * List tag protection states for a repository
     * @description This returns the tag protection states of a repository.
     *
     * This information is only available to repository administrators.
     */
    get: operations["repos/list-tag-protection"];
    /**
     * Create a tag protection state for a repository
     * @description This creates a tag protection state for a repository.
     * This endpoint is only available to repository administrators.
     */
    post: operations["repos/create-tag-protection"];
  };
  "/repos/{owner}/{repo}/tags/protection/{tag_protection_id}": {
    /**
     * Delete a tag protection state for a repository
     * @description This deletes a tag protection state for a repository.
     * This endpoint is only available to repository administrators.
     */
    delete: operations["repos/delete-tag-protection"];
  };
  "/repos/{owner}/{repo}/tarball/{ref}": {
    /**
     * Download a repository archive (tar)
     * @description Gets a redirect URL to download a tar archive for a repository. If you omit `:ref`, the repository’s default branch (usually
     * `main`) will be used. Please make sure your HTTP framework is configured to follow redirects or you will need to use
     * the `Location` header to make a second `GET` request.
     * **Note**: For private repositories, these links are temporary and expire after five minutes.
     */
    get: operations["repos/download-tarball-archive"];
  };
  "/repos/{owner}/{repo}/teams": {
    /**
     * List repository teams
     * @description Lists the teams that have access to the specified repository and that are also visible to the authenticated user.
     *
     * For a public repository, a team is listed only if that team added the public repository explicitly.
     *
     * OAuth app tokens and personal access tokens (classic) need the `public_repo` or `repo` scope to use this endpoint with a public repository, and `repo` scope to use this endpoint with a private repository.
     */
    get: operations["repos/list-teams"];
  };
  "/repos/{owner}/{repo}/topics": {
    /** Get all repository topics */
    get: operations["repos/get-all-topics"];
    /** Replace all repository topics */
    put: operations["repos/replace-all-topics"];
  };
  "/repos/{owner}/{repo}/transfer": {
    /**
     * Transfer a repository
     * @description A transfer request will need to be accepted by the new owner when transferring a personal repository to another user. The response will contain the original `owner`, and the transfer will continue asynchronously. For more details on the requirements to transfer personal and organization-owned repositories, see [about repository transfers](https://docs.github.com/enterprise-server@3.10/articles/about-repository-transfers/).
     */
    post: operations["repos/transfer"];
  };
  "/repos/{owner}/{repo}/vulnerability-alerts": {
    /**
     * Check if vulnerability alerts are enabled for a repository
     * @description Shows whether dependency alerts are enabled or disabled for a repository. The authenticated user must have admin read access to the repository. For more information, see "[About security alerts for vulnerable dependencies](https://docs.github.com/enterprise-server@3.10/articles/about-security-alerts-for-vulnerable-dependencies)".
     */
    get: operations["repos/check-vulnerability-alerts"];
    /**
     * Enable vulnerability alerts
     * @description Enables dependency alerts and the dependency graph for a repository. The authenticated user must have admin access to the repository. For more information, see "[About security alerts for vulnerable dependencies](https://docs.github.com/enterprise-server@3.10/articles/about-security-alerts-for-vulnerable-dependencies)".
     */
    put: operations["repos/enable-vulnerability-alerts"];
    /**
     * Disable vulnerability alerts
     * @description Disables dependency alerts for a repository.
     * The authenticated user must have admin access to the repository. For more information,
     * see "[About security alerts for vulnerable dependencies](https://docs.github.com/enterprise-server@3.10/articles/about-security-alerts-for-vulnerable-dependencies)".
     */
    delete: operations["repos/disable-vulnerability-alerts"];
  };
  "/repos/{owner}/{repo}/zipball/{ref}": {
    /**
     * Download a repository archive (zip)
     * @description Gets a redirect URL to download a zip archive for a repository. If you omit `:ref`, the repository’s default branch (usually
     * `main`) will be used. Please make sure your HTTP framework is configured to follow redirects or you will need to use
     * the `Location` header to make a second `GET` request.
     *
     * **Note**: For private repositories, these links are temporary and expire after five minutes. If the repository is empty, you will receive a 404 when you follow the redirect.
     */
    get: operations["repos/download-zipball-archive"];
  };
  "/repos/{template_owner}/{template_repo}/generate": {
    /**
     * Create a repository using a template
     * @description Creates a new repository using a repository template. Use the `template_owner` and `template_repo` route parameters to specify the repository to use as the template. If the repository is not public, the authenticated user must own or be a member of an organization that owns the repository. To check if a repository is available to use as a template, get the repository's information using the [Get a repository](https://docs.github.com/enterprise-server@3.10/rest/repos/repos#get-a-repository) endpoint and check that the `is_template` key is `true`.
     *
     * OAuth app tokens and personal access tokens (classic) need the `public_repo` or `repo` scope to create a public repository, and `repo` scope to create a private repository.
     */
    post: operations["repos/create-using-template"];
  };
  "/repositories": {
    /**
     * List public repositories
     * @description Lists all public repositories in the order that they were created.
     *
     * Note:
     * - For GitHub Enterprise Server, this endpoint will only list repositories available to all users on the enterprise.
     * - Pagination is powered exclusively by the `since` parameter. Use the [Link header](https://docs.github.com/enterprise-server@3.10/rest/guides/using-pagination-in-the-rest-api#using-link-headers) to get the URL for the next page of repositories.
     */
    get: operations["repos/list-public"];
  };
  "/scim/v2/enterprises/{enterprise}/Groups": {
    /**
     * List provisioned SCIM groups for an enterprise
     * @description **Note:** The SCIM API endpoints for enterprise accounts are currently in *private* beta and are subject to change.
     *
     * Lists provisioned SCIM groups in an enterprise.
     *
     * You can improve query search time by using the `excludedAttributes` query parameter with a value of `members` to exclude members from the response.
     */
    get: operations["enterprise-admin/list-provisioned-groups-enterprise"];
    /**
     * Provision a SCIM enterprise group
     * @description **Note:** The SCIM API endpoints for enterprise accounts are currently in *private* beta and are subject to change.
     *
     * Creates a SCIM group for an enterprise.
     *
     * If members are included as part of the group provisioning payload, they will be created as external group members. It is up to a provider to store a mapping between the `externalId` and `id` of each user.
     */
    post: operations["enterprise-admin/provision-enterprise-group"];
  };
  "/scim/v2/enterprises/{enterprise}/Groups/{scim_group_id}": {
    /**
     * Get SCIM provisioning information for an enterprise group
     * @description **Note:** The SCIM API endpoints for enterprise accounts are currently in *private* beta and are subject to change.
     *
     * Gets information about a SCIM group.
     */
    get: operations["enterprise-admin/get-provisioning-information-for-enterprise-group"];
    /**
     * Set SCIM information for a provisioned enterprise group
     * @description **Note:** The SCIM API endpoints for enterprise accounts are currently in *private* beta and are subject to change.
     *
     * Replaces an existing provisioned group’s information.
     *
     * You must provide all the information required for the group as if you were provisioning it for the first time. Any existing group information that you don't provide will be removed, including group membership. If you want to only update a specific attribute, use the [Update an attribute for a SCIM enterprise group](#update-an-attribute-for-a-scim-enterprise-group) endpoint instead.
     */
    put: operations["enterprise-admin/set-information-for-provisioned-enterprise-group"];
    /**
     * Delete a SCIM group from an enterprise
     * @description **Note:** The SCIM API endpoints for enterprise accounts are currently in *private* beta and are subject to change.
     *
     *  Deletes a SCIM group from an enterprise.
     */
    delete: operations["enterprise-admin/delete-scim-group-from-enterprise"];
    /**
     * Update an attribute for a SCIM enterprise group
     * @description **Note:** The SCIM API endpoints for enterprise accounts are currently in *private* beta and are subject to change.
     *
     * Update a provisioned group’s individual attributes.
     *
     * To change a group’s values, you must provide a specific Operations JSON format that contains at least one of the add, remove, or replace operations. For examples and more information on the SCIM operations format, see the [SCIM specification](https://tools.ietf.org/html/rfc7644#section-3.5.2).  Update can also be used to add group memberships.
     *
     * Group memberships can be sent one at a time or in batches for faster performance. **Note**: The memberships are referenced through a local user `id`, and the user will need to be created before they are referenced here.
     */
    patch: operations["enterprise-admin/update-attribute-for-enterprise-group"];
  };
  "/scim/v2/enterprises/{enterprise}/Users": {
    /**
     * List SCIM provisioned identities for an enterprise
     * @description **Note:** The SCIM API endpoints for enterprise accounts are currently in *private* beta and are subject to change.
     *
     * Lists provisioned SCIM enterprise members.
     *
     * When a user with a SCIM-provisioned external identity is removed from an enterprise through a `patch` with `active` flag set to `false`, the account's metadata is preserved to allow the user to re-join the enterprise in the future. However, the user's account will be suspended and the user will not be able to sign-in. In order to permanently suspend the users account with no ability to re-join the enterprise in the future, use the `delete` request. Users that were not permanently deleted will be visible in the returned results.
     */
    get: operations["enterprise-admin/list-provisioned-identities-enterprise"];
    /**
     * Provision a SCIM enterprise user
     * @description **Note:** The SCIM API endpoints for enterprise accounts are currently in *private* beta and are subject to change.
     *
     * Creates an external identity for a new SCIM enterprise user.
     *
     * SCIM does not authenticate users, it only provisions them. The authentication of users is done by SAML. However, when SCIM is enabled, all users need to be provisioned through SCIM before a user can sign in through SAML. The matching of a user to a SCIM provisioned user is done when the SAML assertion is consumed. The user will be matched on SAML response `NameID` to SCIM `userName`.
     *
     * When converting existing enterprise to use SCIM, the user handle (`userName`) from the SCIM payload will be used to match the provisioned user to an already existing user in the enterprise. Since the new identity record is created for newly provisioned users the matching for those records is done using a user's handle. Currently the matching will be performed to all of the users no matter if they were SAML JIT provisioned or created as local users.
     */
    post: operations["enterprise-admin/provision-enterprise-user"];
  };
  "/scim/v2/enterprises/{enterprise}/Users/{scim_user_id}": {
    /**
     * Get SCIM provisioning information for an enterprise user
     * @description **Note:** The SCIM API endpoints for enterprise accounts are currently in *private* beta and are subject to change.
     *
     * Gets information about a SCIM user.
     */
    get: operations["enterprise-admin/get-provisioning-information-for-enterprise-user"];
    /**
     * Set SCIM information for a provisioned enterprise user
     * @description **Note:** The SCIM API endpoints for enterprise accounts are currently in *private* beta and are subject to change.
     *
     * Replaces an existing provisioned user's information.
     *
     * You must provide all the information required for the user as if you were provisioning them for the first time. Any existing user information that you don't provide will be removed. If you want to only update a specific attribute, use the [Update an attribute for a SCIM user](#update-an-attribute-for-a-scim-enterprise-user) endpoint instead.
     *
     * **Warning:** Setting `active: false` will suspend a user and obfuscate the user handle and user email. Since the implementation is a generic SCIM implementation and does not differentiate yet between different IdP providers, for Okta, the user GDPR data will not be purged and the credentials will not be removed.
     */
    put: operations["enterprise-admin/set-information-for-provisioned-enterprise-user"];
    /**
     * Delete a SCIM user from an enterprise
     * @description **Note:** The SCIM API endpoints for enterprise accounts are currently in *private* beta and are subject to change.
     *
     * Permanently suspends a SCIM user from an enterprise, removes all data for the user, obfuscates the login, email, and display name of the user, removes all external-identity SCIM attributes, and deletes the emails, avatar, PATs, SSH keys, OAuth authorizations credentials, GPG keys, and SAML mappings for the user. You will not be able to undo this action.
     */
    delete: operations["enterprise-admin/delete-user-from-enterprise"];
    /**
     * Update an attribute for a SCIM enterprise user
     * @description **Note:** The SCIM API endpoints for enterprise accounts are currently in *private* beta and are subject to change.
     *
     * Update a provisioned user's individual attributes.
     *
     * To change a user's values, you must provide a specific `Operations` JSON format that contains at least one of the `add`, `remove`, or `replace` operations. For examples and more information on the SCIM operations format, see the [SCIM specification](https://tools.ietf.org/html/rfc7644#section-3.5.2).
     *
     * **Note:** Complicated SCIM `path` selectors that include filters are not supported. For example, a `path` selector defined as `"path": "emails[type eq \"work\"]"` will not work.
     *
     * **Warning:** Setting `active: false` will suspend a user and obfuscate the user handle and user email. Since the implementation is a generic SCIM implementation and does not differentiate yet between different IdP providers, for Okta, the user GDPR data will not be purged and the credentials will not be removed.
     * ```
     * {
     *   "Operations":[{
     *     "op":"replace",
     *     "value":{
     *       "active":false
     *     }
     *   }]
     * }
     * ```
     */
    patch: operations["enterprise-admin/update-attribute-for-enterprise-user"];
  };
  "/search/code": {
    /**
     * Search code
     * @description Searches for query terms inside of a file. This method returns up to 100 results [per page](https://docs.github.com/enterprise-server@3.10/rest/guides/using-pagination-in-the-rest-api).
     *
     * When searching for code, you can get text match metadata for the file **content** and file **path** fields when you pass the `text-match` media type. For more details about how to receive highlighted search results, see [Text match metadata](https://docs.github.com/enterprise-server@3.10/rest/search/search#text-match-metadata).
     *
     * For example, if you want to find the definition of the `addClass` function inside [jQuery](https://github.com/jquery/jquery) repository, your query would look something like this:
     *
     * `q=addClass+in:file+language:js+repo:jquery/jquery`
     *
     * This query searches for the keyword `addClass` within a file's contents. The query limits the search to files where the language is JavaScript in the `jquery/jquery` repository.
     *
     * Considerations for code search:
     *
     * Due to the complexity of searching code, there are a few restrictions on how searches are performed:
     *
     * *   Only the _default branch_ is considered. In most cases, this will be the `master` branch.
     * *   Only files smaller than 384 KB are searchable.
     * *   You must always include at least one search term when searching source code. For example, searching for [`language:go`](https://github.com/search?utf8=%E2%9C%93&q=language%3Ago&type=Code) is not valid, while [`amazing
     * language:go`](https://github.com/search?utf8=%E2%9C%93&q=amazing+language%3Ago&type=Code) is.
     */
    get: operations["search/code"];
  };
  "/search/commits": {
    /**
     * Search commits
     * @description Find commits via various criteria on the default branch (usually `main`). This method returns up to 100 results [per page](https://docs.github.com/enterprise-server@3.10/rest/guides/using-pagination-in-the-rest-api).
     *
     * When searching for commits, you can get text match metadata for the **message** field when you provide the `text-match` media type. For more details about how to receive highlighted search results, see [Text match
     * metadata](https://docs.github.com/enterprise-server@3.10/rest/search/search#text-match-metadata).
     *
     * For example, if you want to find commits related to CSS in the [octocat/Spoon-Knife](https://github.com/octocat/Spoon-Knife) repository. Your query would look something like this:
     *
     * `q=repo:octocat/Spoon-Knife+css`
     */
    get: operations["search/commits"];
  };
  "/search/issues": {
    /**
     * Search issues and pull requests
     * @description Find issues by state and keyword. This method returns up to 100 results [per page](https://docs.github.com/enterprise-server@3.10/rest/guides/using-pagination-in-the-rest-api).
     *
     * When searching for issues, you can get text match metadata for the issue **title**, issue **body**, and issue **comment body** fields when you pass the `text-match` media type. For more details about how to receive highlighted
     * search results, see [Text match metadata](https://docs.github.com/enterprise-server@3.10/rest/search/search#text-match-metadata).
     *
     * For example, if you want to find the oldest unresolved Python bugs on Windows. Your query might look something like this.
     *
     * `q=windows+label:bug+language:python+state:open&sort=created&order=asc`
     *
     * This query searches for the keyword `windows`, within any open issue that is labeled as `bug`. The search runs across repositories whose primary language is Python. The results are sorted by creation date in ascending order, which means the oldest issues appear first in the search results.
     *
     * **Note:** For requests made by GitHub Apps with a user access token, you can't retrieve a combination of issues and pull requests in a single query. Requests that don't include the `is:issue` or `is:pull-request` qualifier will receive an HTTP `422 Unprocessable Entity` response. To get results for both issues and pull requests, you must send separate queries for issues and pull requests. For more information about the `is` qualifier, see "[Searching only issues or pull requests](https://docs.github.com/enterprise-server@3.10/github/searching-for-information-on-github/searching-issues-and-pull-requests#search-only-issues-or-pull-requests)."
     */
    get: operations["search/issues-and-pull-requests"];
  };
  "/search/labels": {
    /**
     * Search labels
     * @description Find labels in a repository with names or descriptions that match search keywords. Returns up to 100 results [per page](https://docs.github.com/enterprise-server@3.10/rest/guides/using-pagination-in-the-rest-api).
     *
     * When searching for labels, you can get text match metadata for the label **name** and **description** fields when you pass the `text-match` media type. For more details about how to receive highlighted search results, see [Text match metadata](https://docs.github.com/enterprise-server@3.10/rest/search/search#text-match-metadata).
     *
     * For example, if you want to find labels in the `linguist` repository that match `bug`, `defect`, or `enhancement`. Your query might look like this:
     *
     * `q=bug+defect+enhancement&repository_id=64778136`
     *
     * The labels that best match the query appear first in the search results.
     */
    get: operations["search/labels"];
  };
  "/search/repositories": {
    /**
     * Search repositories
     * @description Find repositories via various criteria. This method returns up to 100 results [per page](https://docs.github.com/enterprise-server@3.10/rest/guides/using-pagination-in-the-rest-api).
     *
     * When searching for repositories, you can get text match metadata for the **name** and **description** fields when you pass the `text-match` media type. For more details about how to receive highlighted search results, see [Text match metadata](https://docs.github.com/enterprise-server@3.10/rest/search/search#text-match-metadata).
     *
     * For example, if you want to search for popular Tetris repositories written in assembly code, your query might look like this:
     *
     * `q=tetris+language:assembly&sort=stars&order=desc`
     *
     * This query searches for repositories with the word `tetris` in the name, the description, or the README. The results are limited to repositories where the primary language is assembly. The results are sorted by stars in descending order, so that the most popular repositories appear first in the search results.
     */
    get: operations["search/repos"];
  };
  "/search/topics": {
    /**
     * Search topics
     * @description Find topics via various criteria. Results are sorted by best match. This method returns up to 100 results [per page](https://docs.github.com/enterprise-server@3.10/rest/guides/using-pagination-in-the-rest-api). See "[Searching topics](https://docs.github.com/enterprise-server@3.10/articles/searching-topics/)" for a detailed list of qualifiers.
     *
     * When searching for topics, you can get text match metadata for the topic's **short\_description**, **description**, **name**, or **display\_name** field when you pass the `text-match` media type. For more details about how to receive highlighted search results, see [Text match metadata](https://docs.github.com/enterprise-server@3.10/rest/search/search#text-match-metadata).
     *
     * For example, if you want to search for topics related to Ruby that are featured on https://github.com/topics. Your query might look like this:
     *
     * `q=ruby+is:featured`
     *
     * This query searches for topics with the keyword `ruby` and limits the results to find only topics that are featured. The topics that are the best match for the query appear first in the search results.
     */
    get: operations["search/topics"];
  };
  "/search/users": {
    /**
     * Search users
     * @description Find users via various criteria. This method returns up to 100 results [per page](https://docs.github.com/enterprise-server@3.10/rest/guides/using-pagination-in-the-rest-api).
     *
     * When searching for users, you can get text match metadata for the issue **login**, public **email**, and **name** fields when you pass the `text-match` media type. For more details about highlighting search results, see [Text match metadata](https://docs.github.com/enterprise-server@3.10/rest/search/search#text-match-metadata). For more details about how to receive highlighted search results, see [Text match metadata](https://docs.github.com/enterprise-server@3.10/rest/search/search#text-match-metadata).
     *
     * For example, if you're looking for a list of popular users, you might try this query:
     *
     * `q=tom+repos:%3E42+followers:%3E1000`
     *
     * This query searches for users with the name `tom`. The results are restricted to users with more than 42 repositories and over 1,000 followers.
     *
     * This endpoint does not accept authentication and will only include publicly visible users. As an alternative, you can use the GraphQL API. The GraphQL API requires authentication and will return private users, including Enterprise Managed Users (EMUs), that you are authorized to view. For more information, see "[GraphQL Queries](https://docs.github.com/enterprise-server@3.10/graphql/reference/queries#search)."
     */
    get: operations["search/users"];
  };
  "/setup/api/configcheck": {
    /**
     * Get the configuration status
     * @description This endpoint allows you to check the status of the most recent configuration process:
     *
     * Note that you may need to wait several seconds after you start a process before you can check its status.
     *
     * The different statuses are:
     *
     * | Status        | Description                       |
     * | ------------- | --------------------------------- |
     * | `PENDING`     | The job has not started yet       |
     * | `CONFIGURING` | The job is running                |
     * | `DONE`        | The job has finished correctly    |
     * | `FAILED`      | The job has finished unexpectedly |
     */
    get: operations["enterprise-admin/get-configuration-status"];
  };
  "/setup/api/configure": {
    /**
     * Start a configuration process
     * @description This endpoint allows you to start a configuration process at any time for your updated settings to take effect:
     */
    post: operations["enterprise-admin/start-configuration-process"];
  };
  "/setup/api/maintenance": {
    /**
     * Get the maintenance status
     * @description Check your installation's maintenance status:
     */
    get: operations["enterprise-admin/get-maintenance-status"];
    /**
     * Enable or disable maintenance mode
     * @description **Note:** The request body for this operation must be submitted as `application/x-www-form-urlencoded` data. You can submit a parameter value as a string, or you can use a tool such as `curl` to submit a parameter value as the contents of a text file. For more information, see the [`curl` documentation](https://curl.se/docs/manpage.html#--data-urlencode).
     */
    post: operations["enterprise-admin/enable-or-disable-maintenance-mode"];
  };
  "/setup/api/settings": {
    /**
     * Get settings
     * @description Gets the settings for your instance. To change settings, see the [Set settings endpoint](https://docs.github.com/enterprise-server@3.10/rest/enterprise-admin/management-console#set-settings).
     *
     * **Note:** You cannot retrieve the management console password with the Enterprise administration API.
     */
    get: operations["enterprise-admin/get-settings"];
    /**
     * Set settings
     * @description Applies settings on your instance. For a list of the available settings, see the [Get settings endpoint](https://docs.github.com/enterprise-server@3.10/rest/enterprise-admin/management-console#get-settings).
     *
     * **Notes:**
     *
     * - The request body for this operation must be submitted as `application/x-www-form-urlencoded` data. You can submit a parameter value as a string, or you can use a tool such as `curl` to submit a parameter value as the contents of a text file. For more information, see the [`curl` documentation](https://curl.se/docs/manpage.html#--data-urlencode).
     * - You cannot set the management console password with the Enterprise administration API. Use the `ghe-set-password` utility to change the management console password. For more information, see "[Command-line utilities](https://docs.github.com/enterprise-server@3.10/admin/configuration/configuring-your-enterprise/command-line-utilities#ghe-set-password)."
     */
    put: operations["enterprise-admin/set-settings"];
  };
  "/setup/api/settings/authorized-keys": {
    /** Get all authorized SSH keys */
    get: operations["enterprise-admin/get-all-authorized-ssh-keys"];
    /**
     * Add an authorized SSH key
     * @description **Note:** The request body for this operation must be submitted as `application/x-www-form-urlencoded` data. You can submit a parameter value as a string, or you can use a tool such as `curl` to submit a parameter value as the contents of a text file. For more information, see the [`curl` documentation](https://curl.se/docs/manpage.html#--data-urlencode).
     */
    post: operations["enterprise-admin/add-authorized-ssh-key"];
    /**
     * Remove an authorized SSH key
     * @description **Note:** The request body for this operation must be submitted as `application/x-www-form-urlencoded` data. You can submit a parameter value as a string, or you can use a tool such as `curl` to submit a parameter value as the contents of a text file. For more information, see the [`curl` documentation](https://curl.se/docs/manpage.html#--data-urlencode).
     */
    delete: operations["enterprise-admin/remove-authorized-ssh-key"];
  };
  "/setup/api/start": {
    /**
     * Create a GitHub license
     * @description When you boot a GitHub instance for the first time, you can use the following endpoint to upload a license.
     *
     * Note that you need to `POST` to [`/setup/api/configure`](https://docs.github.com/enterprise-server@3.10/rest/enterprise-admin/management-console#start-a-configuration-process) to start the actual configuration process.
     *
     * When using this endpoint, your GitHub instance must have a password set. This can be accomplished two ways:
     *
     * 1.  If you're working directly with the API before accessing the web interface, you must pass in the password parameter to set your password.
     * 2.  If you set up your instance via the web interface before accessing the API, your calls to this endpoint do not need the password parameter.
     *
     * **Note:** The request body for this operation must be submitted as `multipart/form-data` data. You can can reference the license file by prefixing the filename with the `@` symbol using `curl`. For more information, see the [`curl` documentation](https://curl.se/docs/manpage.html#-F).
     */
    post: operations["enterprise-admin/create-enterprise-server-license"];
  };
  "/setup/api/upgrade": {
    /**
     * Upgrade a license
     * @description This API upgrades your license and also triggers the configuration process.
     *
     * **Note:** The request body for this operation must be submitted as `multipart/form-data` data. You can can reference the license file by prefixing the filename with the `@` symbol using `curl`. For more information, see the [`curl` documentation](https://curl.se/docs/manpage.html#-F).
     */
    post: operations["enterprise-admin/upgrade-license"];
  };
  "/teams/{team_id}": {
    /**
     * Get a team (Legacy)
     * @deprecated
     * @description **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the [Get a team by name](https://docs.github.com/enterprise-server@3.10/rest/teams/teams#get-a-team-by-name) endpoint.
     */
    get: operations["teams/get-legacy"];
    /**
     * Delete a team (Legacy)
     * @deprecated
     * @description **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Delete a team](https://docs.github.com/enterprise-server@3.10/rest/teams/teams#delete-a-team) endpoint.
     *
     * To delete a team, the authenticated user must be an organization owner or team maintainer.
     *
     * If you are an organization owner, deleting a parent team will delete all of its child teams as well.
     */
    delete: operations["teams/delete-legacy"];
    /**
     * Update a team (Legacy)
     * @deprecated
     * @description **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Update a team](https://docs.github.com/enterprise-server@3.10/rest/teams/teams#update-a-team) endpoint.
     *
     * To edit a team, the authenticated user must either be an organization owner or a team maintainer.
     *
     * **Note:** With nested teams, the `privacy` for parent teams cannot be `secret`.
     */
    patch: operations["teams/update-legacy"];
  };
  "/teams/{team_id}/discussions": {
    /**
     * List discussions (Legacy)
     * @deprecated
     * @description **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List discussions`](https://docs.github.com/enterprise-server@3.10/rest/teams/discussions#list-discussions) endpoint.
     *
     * List all discussions on a team's page.
     *
     * OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.
     */
    get: operations["teams/list-discussions-legacy"];
    /**
     * Create a discussion (Legacy)
     * @deprecated
     * @description **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [`Create a discussion`](https://docs.github.com/enterprise-server@3.10/rest/teams/discussions#create-a-discussion) endpoint.
     *
     * Creates a new discussion post on a team's page.
     *
     * This endpoint triggers [notifications](https://docs.github.com/enterprise-server@3.10/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/enterprise-server@3.10/rest/overview/rate-limits-for-the-rest-api#about-secondary-rate-limits)" and "[Best practices for using the REST API](https://docs.github.com/enterprise-server@3.10/rest/guides/best-practices-for-using-the-rest-api)."
     *
     * OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
     */
    post: operations["teams/create-discussion-legacy"];
  };
  "/teams/{team_id}/discussions/{discussion_number}": {
    /**
     * Get a discussion (Legacy)
     * @deprecated
     * @description **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Get a discussion](https://docs.github.com/enterprise-server@3.10/rest/teams/discussions#get-a-discussion) endpoint.
     *
     * Get a specific discussion on a team's page.
     *
     * OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.
     */
    get: operations["teams/get-discussion-legacy"];
    /**
     * Delete a discussion (Legacy)
     * @deprecated
     * @description **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [`Delete a discussion`](https://docs.github.com/enterprise-server@3.10/rest/teams/discussions#delete-a-discussion) endpoint.
     *
     * Delete a discussion from a team's page.
     *
     * OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
     */
    delete: operations["teams/delete-discussion-legacy"];
    /**
     * Update a discussion (Legacy)
     * @deprecated
     * @description **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Update a discussion](https://docs.github.com/enterprise-server@3.10/rest/teams/discussions#update-a-discussion) endpoint.
     *
     * Edits the title and body text of a discussion post. Only the parameters you provide are updated.
     *
     * OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
     */
    patch: operations["teams/update-discussion-legacy"];
  };
  "/teams/{team_id}/discussions/{discussion_number}/comments": {
    /**
     * List discussion comments (Legacy)
     * @deprecated
     * @description **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [List discussion comments](https://docs.github.com/enterprise-server@3.10/rest/teams/discussion-comments#list-discussion-comments) endpoint.
     *
     * List all comments on a team discussion.
     *
     * OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.
     */
    get: operations["teams/list-discussion-comments-legacy"];
    /**
     * Create a discussion comment (Legacy)
     * @deprecated
     * @description **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Create a discussion comment](https://docs.github.com/enterprise-server@3.10/rest/teams/discussion-comments#create-a-discussion-comment) endpoint.
     *
     * Creates a new comment on a team discussion.
     *
     * This endpoint triggers [notifications](https://docs.github.com/enterprise-server@3.10/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/enterprise-server@3.10/rest/overview/rate-limits-for-the-rest-api#about-secondary-rate-limits)" and "[Best practices for using the REST API](https://docs.github.com/enterprise-server@3.10/rest/guides/best-practices-for-using-the-rest-api)."
     *
     * OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
     */
    post: operations["teams/create-discussion-comment-legacy"];
  };
  "/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}": {
    /**
     * Get a discussion comment (Legacy)
     * @deprecated
     * @description **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Get a discussion comment](https://docs.github.com/enterprise-server@3.10/rest/teams/discussion-comments#get-a-discussion-comment) endpoint.
     *
     * Get a specific comment on a team discussion.
     *
     * OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.
     */
    get: operations["teams/get-discussion-comment-legacy"];
    /**
     * Delete a discussion comment (Legacy)
     * @deprecated
     * @description **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Delete a discussion comment](https://docs.github.com/enterprise-server@3.10/rest/teams/discussion-comments#delete-a-discussion-comment) endpoint.
     *
     * Deletes a comment on a team discussion.
     *
     * OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
     */
    delete: operations["teams/delete-discussion-comment-legacy"];
    /**
     * Update a discussion comment (Legacy)
     * @deprecated
     * @description **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Update a discussion comment](https://docs.github.com/enterprise-server@3.10/rest/teams/discussion-comments#update-a-discussion-comment) endpoint.
     *
     * Edits the body text of a discussion comment.
     *
     * OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
     */
    patch: operations["teams/update-discussion-comment-legacy"];
  };
  "/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/reactions": {
    /**
     * List reactions for a team discussion comment (Legacy)
     * @deprecated
     * @description **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List reactions for a team discussion comment`](https://docs.github.com/enterprise-server@3.10/rest/reactions/reactions#list-reactions-for-a-team-discussion-comment) endpoint.
     *
     * List the reactions to a [team discussion comment](https://docs.github.com/enterprise-server@3.10/rest/teams/discussion-comments#get-a-discussion-comment).
     *
     * OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.
     */
    get: operations["reactions/list-for-team-discussion-comment-legacy"];
    /**
     * Create reaction for a team discussion comment (Legacy)
     * @deprecated
     * @description **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new "[Create reaction for a team discussion comment](https://docs.github.com/enterprise-server@3.10/rest/reactions/reactions#create-reaction-for-a-team-discussion-comment)" endpoint.
     *
     * Create a reaction to a [team discussion comment](https://docs.github.com/enterprise-server@3.10/rest/teams/discussion-comments#get-a-discussion-comment).
     *
     * A response with an HTTP `200` status means that you already added the reaction type to this team discussion comment.
     *
     * OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
     */
    post: operations["reactions/create-for-team-discussion-comment-legacy"];
  };
  "/teams/{team_id}/discussions/{discussion_number}/reactions": {
    /**
     * List reactions for a team discussion (Legacy)
     * @deprecated
     * @description **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List reactions for a team discussion`](https://docs.github.com/enterprise-server@3.10/rest/reactions/reactions#list-reactions-for-a-team-discussion) endpoint.
     *
     * List the reactions to a [team discussion](https://docs.github.com/enterprise-server@3.10/rest/teams/discussions#get-a-discussion).
     *
     * OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.
     */
    get: operations["reactions/list-for-team-discussion-legacy"];
    /**
     * Create reaction for a team discussion (Legacy)
     * @deprecated
     * @description **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [`Create reaction for a team discussion`](https://docs.github.com/enterprise-server@3.10/rest/reactions/reactions#create-reaction-for-a-team-discussion) endpoint.
     *
     * Create a reaction to a [team discussion](https://docs.github.com/enterprise-server@3.10/rest/teams/discussions#get-a-discussion).
     *
     * A response with an HTTP `200` status means that you already added the reaction type to this team discussion.
     *
     * OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
     */
    post: operations["reactions/create-for-team-discussion-legacy"];
  };
  "/teams/{team_id}/members": {
    /**
     * List team members (Legacy)
     * @deprecated
     * @description **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List team members`](https://docs.github.com/enterprise-server@3.10/rest/teams/members#list-team-members) endpoint.
     *
     * Team members will include the members of child teams.
     */
    get: operations["teams/list-members-legacy"];
  };
  "/teams/{team_id}/members/{username}": {
    /**
     * Get team member (Legacy)
     * @deprecated
     * @description The "Get team member" endpoint (described below) is deprecated.
     *
     * We recommend using the [Get team membership for a user](https://docs.github.com/enterprise-server@3.10/rest/teams/members#get-team-membership-for-a-user) endpoint instead. It allows you to get both active and pending memberships.
     *
     * To list members in a team, the team must be visible to the authenticated user.
     */
    get: operations["teams/get-member-legacy"];
    /**
     * Add team member (Legacy)
     * @deprecated
     * @description The "Add team member" endpoint (described below) is deprecated.
     *
     * We recommend using the [Add or update team membership for a user](https://docs.github.com/enterprise-server@3.10/rest/teams/members#add-or-update-team-membership-for-a-user) endpoint instead. It allows you to invite new organization members to your teams.
     *
     * Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/enterprise-server@3.10/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * To add someone to a team, the authenticated user must be an organization owner or a team maintainer in the team they're changing. The person being added to the team must be a member of the team's organization.
     *
     * **Note:** When you have team synchronization set up for a team with your organization's identity provider (IdP), you will see an error if you attempt to use the API for making changes to the team's membership. If you have access to manage group membership in your IdP, you can manage GitHub Enterprise Server team membership through your identity provider, which automatically adds and removes team members in an organization. For more information, see "[Synchronizing teams between your identity provider and GitHub Enterprise Server](https://docs.github.com/enterprise-server@3.10/articles/synchronizing-teams-between-your-identity-provider-and-github/)."
     *
     * Note that you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP method](https://docs.github.com/enterprise-server@3.10/rest/guides/getting-started-with-the-rest-api#http-method)."
     */
    put: operations["teams/add-member-legacy"];
    /**
     * Remove team member (Legacy)
     * @deprecated
     * @description The "Remove team member" endpoint (described below) is deprecated.
     *
     * We recommend using the [Remove team membership for a user](https://docs.github.com/enterprise-server@3.10/rest/teams/members#remove-team-membership-for-a-user) endpoint instead. It allows you to remove both active and pending memberships.
     *
     * Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/enterprise-server@3.10/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * To remove a team member, the authenticated user must have 'admin' permissions to the team or be an owner of the org that the team is associated with. Removing a team member does not delete the user, it just removes them from the team.
     *
     * **Note:** When you have team synchronization set up for a team with your organization's identity provider (IdP), you will see an error if you attempt to use the API for making changes to the team's membership. If you have access to manage group membership in your IdP, you can manage GitHub Enterprise Server team membership through your identity provider, which automatically adds and removes team members in an organization. For more information, see "[Synchronizing teams between your identity provider and GitHub Enterprise Server](https://docs.github.com/enterprise-server@3.10/articles/synchronizing-teams-between-your-identity-provider-and-github/)."
     */
    delete: operations["teams/remove-member-legacy"];
  };
  "/teams/{team_id}/memberships/{username}": {
    /**
     * Get team membership for a user (Legacy)
     * @deprecated
     * @description **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Get team membership for a user](https://docs.github.com/enterprise-server@3.10/rest/teams/members#get-team-membership-for-a-user) endpoint.
     *
     * Team members will include the members of child teams.
     *
     * To get a user's membership with a team, the team must be visible to the authenticated user.
     *
     * **Note:**
     * The response contains the `state` of the membership and the member's `role`.
     *
     * The `role` for organization owners is set to `maintainer`. For more information about `maintainer` roles, see [Create a team](https://docs.github.com/enterprise-server@3.10/rest/teams/teams#create-a-team).
     */
    get: operations["teams/get-membership-for-user-legacy"];
    /**
     * Add or update team membership for a user (Legacy)
     * @deprecated
     * @description **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Add or update team membership for a user](https://docs.github.com/enterprise-server@3.10/rest/teams/members#add-or-update-team-membership-for-a-user) endpoint.
     *
     * Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/enterprise-server@3.10/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * If the user is already a member of the team's organization, this endpoint will add the user to the team. To add a membership between an organization member and a team, the authenticated user must be an organization owner or a team maintainer.
     *
     * **Note:** When you have team synchronization set up for a team with your organization's identity provider (IdP), you will see an error if you attempt to use the API for making changes to the team's membership. If you have access to manage group membership in your IdP, you can manage GitHub Enterprise Server team membership through your identity provider, which automatically adds and removes team members in an organization. For more information, see "[Synchronizing teams between your identity provider and GitHub Enterprise Server](https://docs.github.com/enterprise-server@3.10/articles/synchronizing-teams-between-your-identity-provider-and-github/)."
     *
     * If the user is unaffiliated with the team's organization, this endpoint will send an invitation to the user via email. This newly-created membership will be in the "pending" state until the user accepts the invitation, at which point the membership will transition to the "active" state and the user will be added as a member of the team. To add a membership between an unaffiliated user and a team, the authenticated user must be an organization owner.
     *
     * If the user is already a member of the team, this endpoint will update the role of the team member's role. To update the membership of a team member, the authenticated user must be an organization owner or a team maintainer.
     */
    put: operations["teams/add-or-update-membership-for-user-legacy"];
    /**
     * Remove team membership for a user (Legacy)
     * @deprecated
     * @description **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Remove team membership for a user](https://docs.github.com/enterprise-server@3.10/rest/teams/members#remove-team-membership-for-a-user) endpoint.
     *
     * Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/enterprise-server@3.10/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * To remove a membership between a user and a team, the authenticated user must have 'admin' permissions to the team or be an owner of the organization that the team is associated with. Removing team membership does not delete the user, it just removes their membership from the team.
     *
     * **Note:** When you have team synchronization set up for a team with your organization's identity provider (IdP), you will see an error if you attempt to use the API for making changes to the team's membership. If you have access to manage group membership in your IdP, you can manage GitHub Enterprise Server team membership through your identity provider, which automatically adds and removes team members in an organization. For more information, see "[Synchronizing teams between your identity provider and GitHub Enterprise Server](https://docs.github.com/enterprise-server@3.10/articles/synchronizing-teams-between-your-identity-provider-and-github/)."
     */
    delete: operations["teams/remove-membership-for-user-legacy"];
  };
  "/teams/{team_id}/projects": {
    /**
     * List team projects (Legacy)
     * @deprecated
     * @description **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List team projects`](https://docs.github.com/enterprise-server@3.10/rest/teams/teams#list-team-projects) endpoint.
     *
     * Lists the organization projects for a team.
     */
    get: operations["teams/list-projects-legacy"];
  };
  "/teams/{team_id}/projects/{project_id}": {
    /**
     * Check team permissions for a project (Legacy)
     * @deprecated
     * @description **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Check team permissions for a project](https://docs.github.com/enterprise-server@3.10/rest/teams/teams#check-team-permissions-for-a-project) endpoint.
     *
     * Checks whether a team has `read`, `write`, or `admin` permissions for an organization project. The response includes projects inherited from a parent team.
     */
    get: operations["teams/check-permissions-for-project-legacy"];
    /**
     * Add or update team project permissions (Legacy)
     * @deprecated
     * @description **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Add or update team project permissions](https://docs.github.com/enterprise-server@3.10/rest/teams/teams#add-or-update-team-project-permissions) endpoint.
     *
     * Adds an organization project to a team. To add a project to a team or update the team's permission on a project, the authenticated user must have `admin` permissions for the project. The project and team must be part of the same organization.
     */
    put: operations["teams/add-or-update-project-permissions-legacy"];
    /**
     * Remove a project from a team (Legacy)
     * @deprecated
     * @description **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Remove a project from a team](https://docs.github.com/enterprise-server@3.10/rest/teams/teams#remove-a-project-from-a-team) endpoint.
     *
     * Removes an organization project from a team. An organization owner or a team maintainer can remove any project from the team. To remove a project from a team as an organization member, the authenticated user must have `read` access to both the team and project, or `admin` access to the team or project. **Note:** This endpoint removes the project from the team, but does not delete it.
     */
    delete: operations["teams/remove-project-legacy"];
  };
  "/teams/{team_id}/repos": {
    /**
     * List team repositories (Legacy)
     * @deprecated
     * @description **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [List team repositories](https://docs.github.com/enterprise-server@3.10/rest/teams/teams#list-team-repositories) endpoint.
     */
    get: operations["teams/list-repos-legacy"];
  };
  "/teams/{team_id}/repos/{owner}/{repo}": {
    /**
     * Check team permissions for a repository (Legacy)
     * @deprecated
     * @description **Note**: Repositories inherited through a parent team will also be checked.
     *
     * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Check team permissions for a repository](https://docs.github.com/enterprise-server@3.10/rest/teams/teams#check-team-permissions-for-a-repository) endpoint.
     *
     * You can also get information about the specified repository, including what permissions the team grants on it, by passing the following custom [media type](https://docs.github.com/enterprise-server@3.10/rest/overview/media-types/) via the `Accept` header:
     */
    get: operations["teams/check-permissions-for-repo-legacy"];
    /**
     * Add or update team repository permissions (Legacy)
     * @deprecated
     * @description **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new "[Add or update team repository permissions](https://docs.github.com/enterprise-server@3.10/rest/teams/teams#add-or-update-team-repository-permissions)" endpoint.
     *
     * To add a repository to a team or update the team's permission on a repository, the authenticated user must have admin access to the repository, and must be able to see the team. The repository must be owned by the organization, or a direct fork of a repository owned by the organization. You will get a `422 Unprocessable Entity` status if you attempt to add a repository to a team that is not owned by the organization.
     *
     * Note that, if you choose not to pass any parameters, you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP method](https://docs.github.com/enterprise-server@3.10/rest/guides/getting-started-with-the-rest-api#http-method)."
     */
    put: operations["teams/add-or-update-repo-permissions-legacy"];
    /**
     * Remove a repository from a team (Legacy)
     * @deprecated
     * @description **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Remove a repository from a team](https://docs.github.com/enterprise-server@3.10/rest/teams/teams#remove-a-repository-from-a-team) endpoint.
     *
     * If the authenticated user is an organization owner or a team maintainer, they can remove any repositories from the team. To remove a repository from a team as an organization member, the authenticated user must have admin access to the repository and must be able to see the team. NOTE: This does not delete the repository, it just removes it from the team.
     */
    delete: operations["teams/remove-repo-legacy"];
  };
  "/teams/{team_id}/teams": {
    /**
     * List child teams (Legacy)
     * @deprecated
     * @description **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List child teams`](https://docs.github.com/enterprise-server@3.10/rest/teams/teams#list-child-teams) endpoint.
     */
    get: operations["teams/list-child-legacy"];
  };
  "/user": {
    /**
     * Get the authenticated user
     * @description OAuth app tokens and personal access tokens (classic) need the `user` scope in order for the response to include private profile information.
     */
    get: operations["users/get-authenticated"];
    /**
     * Update the authenticated user
     * @description **Note:** If your email is set to private and you send an `email` parameter as part of this request to update your profile, your privacy settings are still enforced: the email address will not be displayed on your public profile or via the API.
     */
    patch: operations["users/update-authenticated"];
  };
  "/user/docker/conflicts": {
    /**
     * Get list of conflicting packages during Docker migration for authenticated-user
     * @description Lists all packages that are owned by the authenticated user within the user's namespace, and that encountered a conflict during a Docker migration.
     *
     * OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint.
     */
    get: operations["packages/list-docker-migration-conflicting-packages-for-authenticated-user"];
  };
  "/user/emails": {
    /**
     * List email addresses for the authenticated user
     * @description Lists all of your email addresses, and specifies which one is visible
     * to the public.
     *
     * OAuth app tokens and personal access tokens (classic) need the `user:email` scope to use this endpoint.
     */
    get: operations["users/list-emails-for-authenticated-user"];
    /**
     * Add an email address for the authenticated user
     * @description OAuth app tokens and personal access tokens (classic) need the `user` scope to use this endpoint.
     */
    post: operations["users/add-email-for-authenticated-user"];
    /**
     * Delete an email address for the authenticated user
     * @description OAuth app tokens and personal access tokens (classic) need the `user` scope to use this endpoint.
     */
    delete: operations["users/delete-email-for-authenticated-user"];
  };
  "/user/followers": {
    /**
     * List followers of the authenticated user
     * @description Lists the people following the authenticated user.
     */
    get: operations["users/list-followers-for-authenticated-user"];
  };
  "/user/following": {
    /**
     * List the people the authenticated user follows
     * @description Lists the people who the authenticated user follows.
     */
    get: operations["users/list-followed-by-authenticated-user"];
  };
  "/user/following/{username}": {
    /** Check if a person is followed by the authenticated user */
    get: operations["users/check-person-is-followed-by-authenticated"];
    /**
     * Follow a user
     * @description Note that you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://docs.github.com/enterprise-server@3.10/rest/guides/getting-started-with-the-rest-api#http-method)."
     *
     * OAuth app tokens and personal access tokens (classic) need the `user:follow` scope to use this endpoint.
     */
    put: operations["users/follow"];
    /**
     * Unfollow a user
     * @description OAuth app tokens and personal access tokens (classic) need the `user:follow` scope to use this endpoint.
     */
    delete: operations["users/unfollow"];
  };
  "/user/gpg_keys": {
    /**
     * List GPG keys for the authenticated user
     * @description Lists the current user's GPG keys.
     *
     * OAuth app tokens and personal access tokens (classic) need the `read:gpg_key` scope to use this endpoint.
     */
    get: operations["users/list-gpg-keys-for-authenticated-user"];
    /**
     * Create a GPG key for the authenticated user
     * @description Adds a GPG key to the authenticated user's GitHub account.
     *
     * OAuth app tokens and personal access tokens (classic) need the `write:gpg_key` scope to use this endpoint.
     */
    post: operations["users/create-gpg-key-for-authenticated-user"];
  };
  "/user/gpg_keys/{gpg_key_id}": {
    /**
     * Get a GPG key for the authenticated user
     * @description View extended details for a single GPG key.
     *
     * OAuth app tokens and personal access tokens (classic) need the `read:gpg_key` scope to use this endpoint.
     */
    get: operations["users/get-gpg-key-for-authenticated-user"];
    /**
     * Delete a GPG key for the authenticated user
     * @description Removes a GPG key from the authenticated user's GitHub account.
     *
     * OAuth app tokens and personal access tokens (classic) need the `admin:gpg_key` scope to use this endpoint.
     */
    delete: operations["users/delete-gpg-key-for-authenticated-user"];
  };
  "/user/installations": {
    /**
     * List app installations accessible to the user access token
     * @description Lists installations of your GitHub App that the authenticated user has explicit permission (`:read`, `:write`, or `:admin`) to access.
     *
     * The authenticated user has explicit permission to access repositories they own, repositories where they are a collaborator, and repositories that they can access through an organization membership.
     *
     * You can find the permissions for the installation under the `permissions` key.
     */
    get: operations["apps/list-installations-for-authenticated-user"];
  };
  "/user/installations/{installation_id}/repositories": {
    /**
     * List repositories accessible to the user access token
     * @description List repositories that the authenticated user has explicit permission (`:read`, `:write`, or `:admin`) to access for an installation.
     *
     * The authenticated user has explicit permission to access repositories they own, repositories where they are a collaborator, and repositories that they can access through an organization membership.
     *
     * The access the user has to each repository is included in the hash under the `permissions` key.
     */
    get: operations["apps/list-installation-repos-for-authenticated-user"];
  };
  "/user/installations/{installation_id}/repositories/{repository_id}": {
    /**
     * Add a repository to an app installation
     * @description Add a single repository to an installation. The authenticated user must have admin access to the repository.
     */
    put: operations["apps/add-repo-to-installation-for-authenticated-user"];
    /**
     * Remove a repository from an app installation
     * @description Remove a single repository from an installation. The authenticated user must have admin access to the repository. The installation must have the `repository_selection` of `selected`.
     */
    delete: operations["apps/remove-repo-from-installation-for-authenticated-user"];
  };
  "/user/issues": {
    /**
     * List user account issues assigned to the authenticated user
     * @description List issues across owned and member repositories assigned to the authenticated user.
     *
     * **Note**: GitHub's REST API considers every pull request an issue, but not every issue is a pull request. For this
     * reason, "Issues" endpoints may return both issues and pull requests in the response. You can identify pull requests by
     * the `pull_request` key. Be aware that the `id` of a pull request returned from "Issues" endpoints will be an _issue id_. To find out the pull
     * request id, use the "[List pull requests](https://docs.github.com/enterprise-server@3.10/rest/pulls/pulls#list-pull-requests)" endpoint.
     *
     * This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/enterprise-server@3.10/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
     *
     * - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
     * - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
     * - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
     * - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
     */
    get: operations["issues/list-for-authenticated-user"];
  };
  "/user/keys": {
    /**
     * List public SSH keys for the authenticated user
     * @description Lists the public SSH keys for the authenticated user's GitHub account.
     *
     * OAuth app tokens and personal access tokens (classic) need the `read:public_key` scope to use this endpoint.
     */
    get: operations["users/list-public-ssh-keys-for-authenticated-user"];
    /**
     * Create a public SSH key for the authenticated user
     * @description Adds a public SSH key to the authenticated user's GitHub account.
     *
     * OAuth app tokens and personal access tokens (classic) need the `write:gpg_key` scope to use this endpoint.
     */
    post: operations["users/create-public-ssh-key-for-authenticated-user"];
  };
  "/user/keys/{key_id}": {
    /**
     * Get a public SSH key for the authenticated user
     * @description View extended details for a single public SSH key.
     *
     * OAuth app tokens and personal access tokens (classic) need the `read:public_key` scope to use this endpoint.
     */
    get: operations["users/get-public-ssh-key-for-authenticated-user"];
    /**
     * Delete a public SSH key for the authenticated user
     * @description Removes a public SSH key from the authenticated user's GitHub account.
     *
     * OAuth app tokens and personal access tokens (classic) need the `admin:public_key` scope to use this endpoint.
     */
    delete: operations["users/delete-public-ssh-key-for-authenticated-user"];
  };
  "/user/memberships/orgs": {
    /**
     * List organization memberships for the authenticated user
     * @description Lists all of the authenticated user's organization memberships.
     */
    get: operations["orgs/list-memberships-for-authenticated-user"];
  };
  "/user/memberships/orgs/{org}": {
    /**
     * Get an organization membership for the authenticated user
     * @description If the authenticated user is an active or pending member of the organization, this endpoint will return the user's membership. If the authenticated user is not affiliated with the organization, a `404` is returned. This endpoint will return a `403` if the request is made by a GitHub App that is blocked by the organization.
     */
    get: operations["orgs/get-membership-for-authenticated-user"];
    /**
     * Update an organization membership for the authenticated user
     * @description Converts the authenticated user to an active member of the organization, if that user has a pending invitation from the organization.
     */
    patch: operations["orgs/update-membership-for-authenticated-user"];
  };
  "/user/migrations": {
    /**
     * List user migrations
     * @description Lists all migrations a user has started.
     */
    get: operations["migrations/list-for-authenticated-user"];
    /**
     * Start a user migration
     * @description Initiates the generation of a user migration archive.
     */
    post: operations["migrations/start-for-authenticated-user"];
  };
  "/user/migrations/{migration_id}/archive": {
    /**
     * Download a user migration archive
     * @description Fetches the URL to download the migration archive as a `tar.gz` file. Depending on the resources your repository uses, the migration archive can contain JSON files with data for these objects:
     *
     * *   attachments
     * *   bases
     * *   commit\_comments
     * *   issue\_comments
     * *   issue\_events
     * *   issues
     * *   milestones
     * *   organizations
     * *   projects
     * *   protected\_branches
     * *   pull\_request\_reviews
     * *   pull\_requests
     * *   releases
     * *   repositories
     * *   review\_comments
     * *   schema
     * *   users
     *
     * The archive will also contain an `attachments` directory that includes all attachment files uploaded to GitHub.com and a `repositories` directory that contains the repository's Git data.
     */
    get: operations["migrations/get-archive-for-authenticated-user"];
  };
  "/user/migrations/{migration_id}/repositories": {
    /**
     * List repositories for a user migration
     * @description Lists all the repositories for this user migration.
     */
    get: operations["migrations/list-repos-for-authenticated-user"];
  };
  "/user/orgs": {
    /**
     * List organizations for the authenticated user
     * @description List organizations for the authenticated user.
     *
     * For OAuth app tokens and personal access tokens (classic), this endpoint only lists organizations that your authorization allows you to operate on in some way (e.g., you can list teams with `read:org` scope, you can publicize your organization membership with `user` scope, etc.). Therefore, this API requires at least `user` or `read:org` scope for OAuth app tokens and personal access tokens (classic). Requests with insufficient scope will receive a `403 Forbidden` response.
     */
    get: operations["orgs/list-for-authenticated-user"];
  };
  "/user/packages": {
    /**
     * List packages for the authenticated user's namespace
     * @description Lists packages owned by the authenticated user within the user's namespace.
     *
     * OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint. If the `package_type` belongs to a GitHub Packages registry that only supports repository-scoped permissions, the `repo` scope is also required. For the list of these registries, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-server@3.10/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
     */
    get: operations["packages/list-packages-for-authenticated-user"];
  };
  "/user/packages/{package_type}/{package_name}": {
    /**
     * Get a package for the authenticated user
     * @description Gets a specific package for a package owned by the authenticated user.
     *
     * OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint. If the `package_type` belongs to a GitHub Packages registry that only supports repository-scoped permissions, the `repo` scope is also required. For the list of these registries, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-server@3.10/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
     */
    get: operations["packages/get-package-for-authenticated-user"];
    /**
     * Delete a package for the authenticated user
     * @description Deletes a package owned by the authenticated user. You cannot delete a public package if any version of the package has more than 5,000 downloads. In this scenario, contact GitHub support for further assistance.
     *
     * OAuth app tokens and personal access tokens (classic) need the `read:packages` and `delete:packages` scopes to use this endpoint. If the `package_type` belongs to a GitHub Packages registry that only supports repository-scoped permissions, `repo` scope is also required. For the list these registries, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-server@3.10/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
     */
    delete: operations["packages/delete-package-for-authenticated-user"];
  };
  "/user/packages/{package_type}/{package_name}/restore": {
    /**
     * Restore a package for the authenticated user
     * @description Restores a package owned by the authenticated user.
     *
     * You can restore a deleted package under the following conditions:
     *   - The package was deleted within the last 30 days.
     *   - The same package namespace and version is still available and not reused for a new package. If the same package namespace is not available, you will not be able to restore your package. In this scenario, to restore the deleted package, you must delete the new package that uses the deleted package's namespace first.
     *
     * OAuth app tokens and personal access tokens (classic) need the `read:packages` and `write:packages` scopes to use this endpoint. If the `package_type` belongs to a GitHub Packages registry that only supports repository-scoped permissions, the `repo` scope is also required. For the list of these registries, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-server@3.10/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
     */
    post: operations["packages/restore-package-for-authenticated-user"];
  };
  "/user/packages/{package_type}/{package_name}/versions": {
    /**
     * List package versions for a package owned by the authenticated user
     * @description Lists package versions for a package owned by the authenticated user.
     *
     * OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint. If the `package_type` belongs to a GitHub Packages registry that only supports repository-scoped permissions, the `repo` scope is also required. For the list of these registries, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-server@3.10/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
     */
    get: operations["packages/get-all-package-versions-for-package-owned-by-authenticated-user"];
  };
  "/user/packages/{package_type}/{package_name}/versions/{package_version_id}": {
    /**
     * Get a package version for the authenticated user
     * @description Gets a specific package version for a package owned by the authenticated user.
     *
     * OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint. If the `package_type` belongs to a GitHub Packages registry that only supports repository-scoped permissions, the `repo` scope is also required. For the list of these registries, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-server@3.10/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
     */
    get: operations["packages/get-package-version-for-authenticated-user"];
    /**
     * Delete a package version for the authenticated user
     * @description Deletes a specific package version for a package owned by the authenticated user.  If the package is public and the package version has more than 5,000 downloads, you cannot delete the package version. In this scenario, contact GitHub support for further assistance.
     *
     * The authenticated user must have admin permissions in the organization to use this endpoint.
     *
     * OAuth app tokens and personal access tokens (classic) need the `read:packages` and `delete:packages` scopes to use this endpoint. If the `package_type` belongs to a GitHub Packages registry that only supports repository-scoped permissions, the `repo` scope is also required. For the list of these registries, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-server@3.10/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
     */
    delete: operations["packages/delete-package-version-for-authenticated-user"];
  };
  "/user/packages/{package_type}/{package_name}/versions/{package_version_id}/restore": {
    /**
     * Restore a package version for the authenticated user
     * @description Restores a package version owned by the authenticated user.
     *
     * You can restore a deleted package version under the following conditions:
     *   - The package was deleted within the last 30 days.
     *   - The same package namespace and version is still available and not reused for a new package. If the same package namespace is not available, you will not be able to restore your package. In this scenario, to restore the deleted package, you must delete the new package that uses the deleted package's namespace first.
     *
     * OAuth app tokens and personal access tokens (classic) need the `read:packages` and `write:packages` scopes to use this endpoint. If the `package_type` belongs to a GitHub Packages registry that only supports repository-scoped permissions, the `repo` scope is also required. For the list of these registries, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-server@3.10/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
     */
    post: operations["packages/restore-package-version-for-authenticated-user"];
  };
  "/user/projects": {
    /**
     * Create a user project
     * @description Creates a user project board. Returns a `410 Gone` status if the user does not have existing classic projects. If you do not have sufficient privileges to perform this action, a `401 Unauthorized` or `410 Gone` status is returned.
     */
    post: operations["projects/create-for-authenticated-user"];
  };
  "/user/public_emails": {
    /**
     * List public email addresses for the authenticated user
     * @description Lists your publicly visible email address, which you can set with the
     * [Set primary email visibility for the authenticated user](https://docs.github.com/enterprise-server@3.10/rest/users/emails#set-primary-email-visibility-for-the-authenticated-user)
     * endpoint.
     *
     * OAuth app tokens and personal access tokens (classic) need the `user:email` scope to use this endpoint.
     */
    get: operations["users/list-public-emails-for-authenticated-user"];
  };
  "/user/repos": {
    /**
     * List repositories for the authenticated user
     * @description Lists repositories that the authenticated user has explicit permission (`:read`, `:write`, or `:admin`) to access.
     *
     * The authenticated user has explicit permission to access repositories they own, repositories where they are a collaborator, and repositories that they can access through an organization membership.
     */
    get: operations["repos/list-for-authenticated-user"];
    /**
     * Create a repository for the authenticated user
     * @description Creates a new repository for the authenticated user.
     *
     * OAuth app tokens and personal access tokens (classic) need the `public_repo` or `repo` scope to create a public repository, and `repo` scope to create a private repository.
     */
    post: operations["repos/create-for-authenticated-user"];
  };
  "/user/repository_invitations": {
    /**
     * List repository invitations for the authenticated user
     * @description When authenticating as a user, this endpoint will list all currently open repository invitations for that user.
     */
    get: operations["repos/list-invitations-for-authenticated-user"];
  };
  "/user/repository_invitations/{invitation_id}": {
    /** Decline a repository invitation */
    delete: operations["repos/decline-invitation-for-authenticated-user"];
    /** Accept a repository invitation */
    patch: operations["repos/accept-invitation-for-authenticated-user"];
  };
  "/user/social_accounts": {
    /**
     * List social accounts for the authenticated user
     * @description Lists all of your social accounts.
     */
    get: operations["users/list-social-accounts-for-authenticated-user"];
    /**
     * Add social accounts for the authenticated user
     * @description Add one or more social accounts to the authenticated user's profile.
     *
     * OAuth app tokens and personal access tokens (classic) need the `user` scope to use this endpoint.
     */
    post: operations["users/add-social-account-for-authenticated-user"];
    /**
     * Delete social accounts for the authenticated user
     * @description Deletes one or more social accounts from the authenticated user's profile.
     *
     * OAuth app tokens and personal access tokens (classic) need the `user` scope to use this endpoint.
     */
    delete: operations["users/delete-social-account-for-authenticated-user"];
  };
  "/user/ssh_signing_keys": {
    /**
     * List SSH signing keys for the authenticated user
     * @description Lists the SSH signing keys for the authenticated user's GitHub account.
     *
     * OAuth app tokens and personal access tokens (classic) need the `read:ssh_signing_key` scope to use this endpoint.
     */
    get: operations["users/list-ssh-signing-keys-for-authenticated-user"];
    /**
     * Create a SSH signing key for the authenticated user
     * @description Creates an SSH signing key for the authenticated user's GitHub account.
     *
     * OAuth app tokens and personal access tokens (classic) need the `write:ssh_signing_key` scope to use this endpoint.
     */
    post: operations["users/create-ssh-signing-key-for-authenticated-user"];
  };
  "/user/ssh_signing_keys/{ssh_signing_key_id}": {
    /**
     * Get an SSH signing key for the authenticated user
     * @description Gets extended details for an SSH signing key.
     *
     * OAuth app tokens and personal access tokens (classic) need the `read:ssh_signing_key` scope to use this endpoint.
     */
    get: operations["users/get-ssh-signing-key-for-authenticated-user"];
    /**
     * Delete an SSH signing key for the authenticated user
     * @description Deletes an SSH signing key from the authenticated user's GitHub account.
     *
     * OAuth app tokens and personal access tokens (classic) need the `admin:ssh_signing_key` scope to use this endpoint.
     */
    delete: operations["users/delete-ssh-signing-key-for-authenticated-user"];
  };
  "/user/starred": {
    /**
     * List repositories starred by the authenticated user
     * @description Lists repositories the authenticated user has starred.
     *
     * This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/enterprise-server@3.10/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
     *
     * - **`application/vnd.github.star+json`**: Includes a timestamp of when the star was created.
     */
    get: operations["activity/list-repos-starred-by-authenticated-user"];
  };
  "/user/starred/{owner}/{repo}": {
    /**
     * Check if a repository is starred by the authenticated user
     * @description Whether the authenticated user has starred the repository.
     */
    get: operations["activity/check-repo-is-starred-by-authenticated-user"];
    /**
     * Star a repository for the authenticated user
     * @description Note that you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP method](https://docs.github.com/enterprise-server@3.10/rest/guides/getting-started-with-the-rest-api#http-method)."
     */
    put: operations["activity/star-repo-for-authenticated-user"];
    /**
     * Unstar a repository for the authenticated user
     * @description Unstar a repository that the authenticated user has previously starred.
     */
    delete: operations["activity/unstar-repo-for-authenticated-user"];
  };
  "/user/subscriptions": {
    /**
     * List repositories watched by the authenticated user
     * @description Lists repositories the authenticated user is watching.
     */
    get: operations["activity/list-watched-repos-for-authenticated-user"];
  };
  "/user/teams": {
    /**
     * List teams for the authenticated user
     * @description List all of the teams across all of the organizations to which the authenticated
     * user belongs.
     *
     * OAuth app tokens and personal access tokens (classic) need the `user`, `repo`, or `read:org` scope to use this endpoint.
     *
     * When using a fine-grained personal access token, the resource owner of the token must be a single organization, and the response will only include the teams from that organization.
     */
    get: operations["teams/list-for-authenticated-user"];
  };
  "/users": {
    /**
     * List users
     * @description Lists all users, in the order that they signed up on GitHub Enterprise Server. This list includes personal user accounts and organization accounts.
     *
     * Note: Pagination is powered exclusively by the `since` parameter. Use the [Link header](https://docs.github.com/enterprise-server@3.10/rest/guides/using-pagination-in-the-rest-api#using-link-headers) to get the URL for the next page of users.
     */
    get: operations["users/list"];
  };
  "/users/{username}": {
    /**
     * Get a user
     * @description Provides publicly available information about someone with a GitHub account.
     *
     * The `email` key in the following response is the publicly visible email address from your GitHub Enterprise Server [profile page](https://github.com/settings/profile). When setting up your profile, you can select a primary email address to be “public” which provides an email entry for this endpoint. If you do not set a public email address for `email`, then it will have a value of `null`. You only see publicly visible email addresses when authenticated with GitHub Enterprise Server. For more information, see [Authentication](https://docs.github.com/enterprise-server@3.10/rest/guides/getting-started-with-the-rest-api#authentication).
     *
     * The Emails API enables you to list all of your email addresses, and toggle a primary email to be visible publicly. For more information, see "[Emails API](https://docs.github.com/enterprise-server@3.10/rest/users/emails)".
     */
    get: operations["users/get-by-username"];
  };
  "/users/{username}/docker/conflicts": {
    /**
     * Get list of conflicting packages during Docker migration for user
     * @description Lists all packages that are in a specific user's namespace, that the requesting user has access to, and that encountered a conflict during Docker migration.
     *
     * OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint.
     */
    get: operations["packages/list-docker-migration-conflicting-packages-for-user"];
  };
  "/users/{username}/events": {
    /**
     * List events for the authenticated user
     * @description If you are authenticated as the given user, you will see your private events. Otherwise, you'll only see public events.
     */
    get: operations["activity/list-events-for-authenticated-user"];
  };
  "/users/{username}/events/orgs/{org}": {
    /**
     * List organization events for the authenticated user
     * @description This is the user's organization dashboard. You must be authenticated as the user to view this.
     */
    get: operations["activity/list-org-events-for-authenticated-user"];
  };
  "/users/{username}/events/public": {
    /** List public events for a user */
    get: operations["activity/list-public-events-for-user"];
  };
  "/users/{username}/followers": {
    /**
     * List followers of a user
     * @description Lists the people following the specified user.
     */
    get: operations["users/list-followers-for-user"];
  };
  "/users/{username}/following": {
    /**
     * List the people a user follows
     * @description Lists the people who the specified user follows.
     */
    get: operations["users/list-following-for-user"];
  };
  "/users/{username}/following/{target_user}": {
    /** Check if a user follows another user */
    get: operations["users/check-following-for-user"];
  };
  "/users/{username}/gists": {
    /**
     * List gists for a user
     * @description Lists public gists for the specified user:
     */
    get: operations["gists/list-for-user"];
  };
  "/users/{username}/gpg_keys": {
    /**
     * List GPG keys for a user
     * @description Lists the GPG keys for a user. This information is accessible by anyone.
     */
    get: operations["users/list-gpg-keys-for-user"];
  };
  "/users/{username}/hovercard": {
    /**
     * Get contextual information for a user
     * @description Provides hovercard information. You can find out more about someone in relation to their pull requests, issues, repositories, and organizations.
     *
     *   The `subject_type` and `subject_id` parameters provide context for the person's hovercard, which returns more information than without the parameters. For example, if you wanted to find out more about `octocat` who owns the `Spoon-Knife` repository, you would use a `subject_type` value of `repository` and a `subject_id` value of `1300192` (the ID of the `Spoon-Knife` repository).
     *
     * OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
     */
    get: operations["users/get-context-for-user"];
  };
  "/users/{username}/installation": {
    /**
     * Get a user installation for the authenticated app
     * @description Enables an authenticated GitHub App to find the user’s installation information.
     *
     * You must use a [JWT](https://docs.github.com/enterprise-server@3.10/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
     */
    get: operations["apps/get-user-installation"];
  };
  "/users/{username}/keys": {
    /**
     * List public keys for a user
     * @description Lists the _verified_ public SSH keys for a user. This is accessible by anyone.
     */
    get: operations["users/list-public-keys-for-user"];
  };
  "/users/{username}/orgs": {
    /**
     * List organizations for a user
     * @description List [public organization memberships](https://docs.github.com/enterprise-server@3.10/articles/publicizing-or-concealing-organization-membership) for the specified user.
     *
     * This method only lists _public_ memberships, regardless of authentication. If you need to fetch all of the organization memberships (public and private) for the authenticated user, use the [List organizations for the authenticated user](https://docs.github.com/enterprise-server@3.10/rest/orgs/orgs#list-organizations-for-the-authenticated-user) API instead.
     */
    get: operations["orgs/list-for-user"];
  };
  "/users/{username}/packages": {
    /**
     * List packages for a user
     * @description Lists all packages in a user's namespace for which the requesting user has access.
     *
     * OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint. If the `package_type` belongs to a GitHub Packages registry that only supports repository-scoped permissions, the `repo` scope is also required. For the list of these registries, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-server@3.10/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
     */
    get: operations["packages/list-packages-for-user"];
  };
  "/users/{username}/packages/{package_type}/{package_name}": {
    /**
     * Get a package for a user
     * @description Gets a specific package metadata for a public package owned by a user.
     *
     * OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint. If the `package_type` belongs to a GitHub Packages registry that only supports repository-scoped permissions, the `repo` scope is also required. For the list of these registries, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-server@3.10/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
     */
    get: operations["packages/get-package-for-user"];
    /**
     * Delete a package for a user
     * @description Deletes an entire package for a user. You cannot delete a public package if any version of the package has more than 5,000 downloads. In this scenario, contact GitHub support for further assistance.
     *
     * If the `package_type` belongs to a GitHub Packages registry that supports granular permissions, the authenticated user must have admin permissions to the package. For the list of these registries, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-server@3.10/packages/learn-github-packages/about-permissions-for-github-packages#granular-permissions-for-userorganization-scoped-packages)."
     *
     * OAuth app tokens and personal access tokens (classic) need the `read:packages` and `delete:packages` scopes to use this endpoint. If the `package_type` belongs to a GitHub Packages registry that only supports repository-scoped permissions, the `repo` scope is also required. For the list of these registries, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-server@3.10/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
     */
    delete: operations["packages/delete-package-for-user"];
  };
  "/users/{username}/packages/{package_type}/{package_name}/restore": {
    /**
     * Restore a package for a user
     * @description Restores an entire package for a user.
     *
     * You can restore a deleted package under the following conditions:
     *   - The package was deleted within the last 30 days.
     *   - The same package namespace and version is still available and not reused for a new package. If the same package namespace is not available, you will not be able to restore your package. In this scenario, to restore the deleted package, you must delete the new package that uses the deleted package's namespace first.
     *
     * If the `package_type` belongs to a GitHub Packages registry that supports granular permissions, the authenticated user must have admin permissions to the package. For the list of these registries, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-server@3.10/packages/learn-github-packages/about-permissions-for-github-packages#granular-permissions-for-userorganization-scoped-packages)."
     *
     * OAuth app tokens and personal access tokens (classic) need the `read:packages` and `write:packages` scopes to use this endpoint. If the `package_type` belongs to a GitHub Packages registry that only supports repository-scoped permissions, the `repo` scope is also required. For the list of these registries, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-server@3.10/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
     */
    post: operations["packages/restore-package-for-user"];
  };
  "/users/{username}/packages/{package_type}/{package_name}/versions": {
    /**
     * List package versions for a package owned by a user
     * @description Lists package versions for a public package owned by a specified user.
     *
     * OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint. If the `package_type` belongs to a GitHub Packages registry that only supports repository-scoped permissions, the `repo` scope is also required. For the list of these registries, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-server@3.10/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
     */
    get: operations["packages/get-all-package-versions-for-package-owned-by-user"];
  };
  "/users/{username}/packages/{package_type}/{package_name}/versions/{package_version_id}": {
    /**
     * Get a package version for a user
     * @description Gets a specific package version for a public package owned by a specified user.
     *
     * OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint. If the `package_type` belongs to a GitHub Packages registry that only supports repository-scoped permissions, the `repo` scope is also required. For the list of these registries, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-server@3.10/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
     */
    get: operations["packages/get-package-version-for-user"];
    /**
     * Delete package version for a user
     * @description Deletes a specific package version for a user. If the package is public and the package version has more than 5,000 downloads, you cannot delete the package version. In this scenario, contact GitHub support for further assistance.
     *
     * If the `package_type` belongs to a GitHub Packages registry that supports granular permissions, the authenticated user must have admin permissions to the package. For the list of these registries, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-server@3.10/packages/learn-github-packages/about-permissions-for-github-packages#granular-permissions-for-userorganization-scoped-packages)."
     *
     * OAuth app tokens and personal access tokens (classic) need the `read:packages` and `delete:packages` scopes to use this endpoint. If the `package_type` belongs to a GitHub Packages registry that only supports repository-scoped permissions, the `repo` scope is also required. For the list of these registries, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-server@3.10/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
     */
    delete: operations["packages/delete-package-version-for-user"];
  };
  "/users/{username}/packages/{package_type}/{package_name}/versions/{package_version_id}/restore": {
    /**
     * Restore package version for a user
     * @description Restores a specific package version for a user.
     *
     * You can restore a deleted package under the following conditions:
     *   - The package was deleted within the last 30 days.
     *   - The same package namespace and version is still available and not reused for a new package. If the same package namespace is not available, you will not be able to restore your package. In this scenario, to restore the deleted package, you must delete the new package that uses the deleted package's namespace first.
     *
     * If the `package_type` belongs to a GitHub Packages registry that supports granular permissions, the authenticated user must have admin permissions to the package. For the list of these registries, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-server@3.10/packages/learn-github-packages/about-permissions-for-github-packages#granular-permissions-for-userorganization-scoped-packages)."
     *
     * OAuth app tokens and personal access tokens (classic) need the `read:packages` and `write:packages` scopes to use this endpoint. If the `package_type` belongs to a GitHub Packages registry that only supports repository-scoped permissions, the `repo` scope is also required. For the list of these registries, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-server@3.10/packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."
     */
    post: operations["packages/restore-package-version-for-user"];
  };
  "/users/{username}/projects": {
    /**
     * List user projects
     * @description Lists projects for a user.
     */
    get: operations["projects/list-for-user"];
  };
  "/users/{username}/received_events": {
    /**
     * List events received by the authenticated user
     * @description These are events that you've received by watching repositories and following users. If you are authenticated as the given user, you will see private events. Otherwise, you'll only see public events.
     */
    get: operations["activity/list-received-events-for-user"];
  };
  "/users/{username}/received_events/public": {
    /** List public events received by a user */
    get: operations["activity/list-received-public-events-for-user"];
  };
  "/users/{username}/repos": {
    /**
     * List repositories for a user
     * @description Lists public repositories for the specified user.
     */
    get: operations["repos/list-for-user"];
  };
  "/users/{username}/site_admin": {
    /**
     * Promote a user to be a site administrator
     * @description Note that you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP method](https://docs.github.com/enterprise-server@3.10/rest/guides/getting-started-with-the-rest-api#http-method)."
     */
    put: operations["enterprise-admin/promote-user-to-be-site-administrator"];
    /**
     * Demote a site administrator
     * @description You can demote any user account except your own.
     */
    delete: operations["enterprise-admin/demote-site-administrator"];
  };
  "/users/{username}/social_accounts": {
    /**
     * List social accounts for a user
     * @description Lists social media accounts for a user. This endpoint is accessible by anyone.
     */
    get: operations["users/list-social-accounts-for-user"];
  };
  "/users/{username}/ssh_signing_keys": {
    /**
     * List SSH signing keys for a user
     * @description Lists the SSH signing keys for a user. This operation is accessible by anyone.
     */
    get: operations["users/list-ssh-signing-keys-for-user"];
  };
  "/users/{username}/starred": {
    /**
     * List repositories starred by a user
     * @description Lists repositories a user has starred.
     *
     * This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/enterprise-server@3.10/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
     *
     * - **`application/vnd.github.star+json`**: Includes a timestamp of when the star was created.
     */
    get: operations["activity/list-repos-starred-by-user"];
  };
  "/users/{username}/subscriptions": {
    /**
     * List repositories watched by a user
     * @description Lists repositories a user is watching.
     */
    get: operations["activity/list-repos-watched-by-user"];
  };
  "/users/{username}/suspended": {
    /**
     * Suspend a user
     * @description If your GitHub instance uses [LDAP Sync with Active Directory LDAP servers](https://docs.github.com/enterprise-server@3.10/admin/identity-and-access-management/using-ldap-for-enterprise-iam/using-ldap), Active Directory LDAP-authenticated users cannot be suspended through this API. If you attempt to suspend an Active Directory LDAP-authenticated user through this API, it will return a `403` response.
     *
     * You can suspend any user account except your own.
     *
     * Note that, if you choose not to pass any parameters, you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP method](https://docs.github.com/enterprise-server@3.10/rest/guides/getting-started-with-the-rest-api#http-method)."
     */
    put: operations["enterprise-admin/suspend-user"];
    /**
     * Unsuspend a user
     * @description If your GitHub instance uses [LDAP Sync with Active Directory LDAP servers](https://docs.github.com/enterprise-server@3.10/admin/identity-and-access-management/using-ldap-for-enterprise-iam/using-ldap), this API is disabled and will return a `403` response. Active Directory LDAP-authenticated users cannot be unsuspended using the API.
     */
    delete: operations["enterprise-admin/unsuspend-user"];
  };
  "/zen": {
    /**
     * Get the Zen of GitHub
     * @description Get a random sentence from the Zen of GitHub
     */
    get: operations["meta/get-zen"];
  };
  "/repos/{owner}/{repo}/compare/{base}...{head}": {
    /**
     * Compare two commits
     * @description **Deprecated**: Use `repos.compareCommitsWithBasehead()` (`GET /repos/{owner}/{repo}/compare/{basehead}`) instead. Both `:base` and `:head` must be branch names in `:repo`. To compare branches across other repositories in the same network as `:repo`, use the format `<USERNAME>:branch`.
     *
     * The response from the API is equivalent to running the `git log base..head` command; however, commits are returned in chronological order. Pass the appropriate [media type](https://docs.github.com/rest/overview/media-types/#commits-commit-comparison-and-pull-requests) to fetch diff and patch formats.
     *
     * The response also includes details on the files that were changed between the two commits. This includes the status of the change (for example, if a file was added, removed, modified, or renamed), and details of the change itself. For example, files with a `renamed` status have a `previous_filename` field showing the previous filename of the file, and files with a `modified` status have a `patch` field showing the changes made to the file.
     *
     * **Working with large comparisons**
     *
     * To process a response with a large number of commits, you can use (`per_page` or `page`) to paginate the results. When using paging, the list of changed files is only returned with page 1, but includes all changed files for the entire comparison. For more information on working with pagination, see "[Traversing with pagination](/rest/guides/traversing-with-pagination)."
     *
     * When calling this API without any paging parameters (`per_page` or `page`), the returned list is limited to 250 commits and the last commit in the list is the most recent of the entire comparison. When a paging parameter is specified, the first commit in the returned list of each page is the earliest.
     *
     * **Signature verification object**
     *
     * The response will include a `verification` object that describes the result of verifying the commit's signature. The following fields are included in the `verification` object:
     *
     * | Name | Type | Description |
     * | ---- | ---- | ----------- |
     * | `verified` | `boolean` | Indicates whether GitHub considers the signature in this commit to be verified. |
     * | `reason` | `string` | The reason for verified value. Possible values and their meanings are enumerated in table below. |
     * | `signature` | `string` | The signature that was extracted from the commit. |
     * | `payload` | `string` | The value that was signed. |
     *
     * These are the possible values for `reason` in the `verification` object:
     *
     * | Value | Description |
     * | ----- | ----------- |
     * | `expired_key` | The key that made the signature is expired. |
     * | `not_signing_key` | The "signing" flag is not among the usage flags in the GPG key that made the signature. |
     * | `gpgverify_error` | There was an error communicating with the signature verification service. |
     * | `gpgverify_unavailable` | The signature verification service is currently unavailable. |
     * | `unsigned` | The object does not include a signature. |
     * | `unknown_signature_type` | A non-PGP signature was found in the commit. |
     * | `no_user` | No user was associated with the `committer` email address in the commit. |
     * | `unverified_email` | The `committer` email address in the commit was associated with a user, but the email address is not verified on her/his account. |
     * | `bad_email` | The `committer` email address in the commit is not included in the identities of the PGP key that made the signature. |
     * | `unknown_key` | The key that made the signature has not been registered with any user's account. |
     * | `malformed_signature` | There was an error parsing the signature. |
     * | `invalid` | The signature could not be cryptographically verified using the key whose key-id was found in the signature. |
     * | `valid` | None of the above errors applied, so the signature is considered to be verified. |
     */
    get: operations["repos/compare-commits"];
  };
}

export type webhooks = Record<string, never>;

export interface components {
  schemas: {
    root: {
      /** Format: uri-template */
      current_user_url: string;
      /** Format: uri-template */
      current_user_authorizations_html_url: string;
      /** Format: uri-template */
      authorizations_url: string;
      /** Format: uri-template */
      code_search_url: string;
      /** Format: uri-template */
      commit_search_url: string;
      /** Format: uri-template */
      emails_url: string;
      /** Format: uri-template */
      emojis_url: string;
      /** Format: uri-template */
      events_url: string;
      /** Format: uri-template */
      feeds_url: string;
      /** Format: uri-template */
      followers_url: string;
      /** Format: uri-template */
      following_url: string;
      /** Format: uri-template */
      gists_url: string;
      /**
       * Format: uri-template
       * @deprecated
       */
      hub_url?: string;
      /** Format: uri-template */
      issue_search_url: string;
      /** Format: uri-template */
      issues_url: string;
      /** Format: uri-template */
      keys_url: string;
      /** Format: uri-template */
      label_search_url: string;
      /** Format: uri-template */
      notifications_url: string;
      /** Format: uri-template */
      organization_url: string;
      /** Format: uri-template */
      organization_repositories_url: string;
      /** Format: uri-template */
      organization_teams_url: string;
      /** Format: uri-template */
      public_gists_url: string;
      /** Format: uri-template */
      rate_limit_url: string;
      /** Format: uri-template */
      repository_url: string;
      /** Format: uri-template */
      repository_search_url: string;
      /** Format: uri-template */
      current_user_repositories_url: string;
      /** Format: uri-template */
      starred_url: string;
      /** Format: uri-template */
      starred_gists_url: string;
      /** Format: uri-template */
      topic_search_url?: string;
      /** Format: uri-template */
      user_url: string;
      /** Format: uri-template */
      user_organizations_url: string;
      /** Format: uri-template */
      user_repositories_url: string;
      /** Format: uri-template */
      user_search_url: string;
    };
    "global-hook": {
      type?: string;
      id?: number;
      name?: string;
      active?: boolean;
      events?: string[];
      config?: {
        url?: string;
        content_type?: string;
        insecure_ssl?: string;
        secret?: string;
      };
      updated_at?: string;
      created_at?: string;
      url?: string;
      ping_url?: string;
    };
    "global-hook-2": {
      type?: string;
      id?: number;
      name?: string;
      active?: boolean;
      events?: string[];
      config?: {
        url?: string;
        content_type?: string;
        insecure_ssl?: string;
      };
      updated_at?: string;
      created_at?: string;
      url?: string;
      ping_url?: string;
    };
    "public-key-full": {
      id: number;
      key: string;
      user_id: number | null;
      repository_id: number | null;
      url: string;
      title: string;
      read_only: boolean;
      verified: boolean;
      /** Format: date-time */
      created_at: string;
      added_by?: string | null;
      /** Format: date-time */
      last_used: string | null;
    };
    "ldap-mapping-team": {
      ldap_dn?: string;
      id?: number;
      node_id?: string;
      url?: string;
      html_url?: string;
      name?: string;
      slug?: string;
      description?: string | null;
      privacy?: string;
      notification_setting?: string;
      permission?: string;
      members_url?: string;
      repositories_url?: string;
      parent?: unknown;
    };
    /**
     * Ldap Private User
     * @description Ldap Private User
     */
    "ldap-mapping-user": {
      ldap_dn?: string;
      /** @example octocat */
      login: string;
      /** @example 1 */
      id: number;
      /** @example MDQ6VXNlcjE= */
      node_id: string;
      /**
       * Format: uri
       * @example https://github.com/images/error/octocat_happy.gif
       */
      avatar_url: string;
      /** @example 41d064eb2195891e12d0413f63227ea7 */
      gravatar_id: string | null;
      /**
       * Format: uri
       * @example https://api.github.com/users/octocat
       */
      url: string;
      /**
       * Format: uri
       * @example https://github.com/octocat
       */
      html_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/users/octocat/followers
       */
      followers_url: string;
      /** @example https://api.github.com/users/octocat/following{/other_user} */
      following_url: string;
      /** @example https://api.github.com/users/octocat/gists{/gist_id} */
      gists_url: string;
      /** @example https://api.github.com/users/octocat/starred{/owner}{/repo} */
      starred_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/users/octocat/subscriptions
       */
      subscriptions_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/users/octocat/orgs
       */
      organizations_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/users/octocat/repos
       */
      repos_url: string;
      /** @example https://api.github.com/users/octocat/events{/privacy} */
      events_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/users/octocat/received_events
       */
      received_events_url: string;
      /** @example User */
      type: string;
      site_admin: boolean;
      /** @example monalisa octocat */
      name: string | null;
      /** @example GitHub */
      company: string | null;
      /** @example https://github.com/blog */
      blog: string | null;
      /** @example San Francisco */
      location: string | null;
      /**
       * Format: email
       * @example octocat@github.com
       */
      email: string | null;
      hireable: boolean | null;
      /** @example There once was... */
      bio: string | null;
      /** @example monalisa */
      twitter_username?: string | null;
      /** @example 2 */
      public_repos: number;
      /** @example 1 */
      public_gists: number;
      /** @example 20 */
      followers: number;
      /** @example 0 */
      following: number;
      /**
       * Format: date-time
       * @example 2008-01-14T04:33:35Z
       */
      created_at: string;
      /**
       * Format: date-time
       * @example 2008-01-14T04:33:35Z
       */
      updated_at: string;
      /** @example 81 */
      private_gists: number;
      /** @example 100 */
      total_private_repos: number;
      /** @example 100 */
      owned_private_repos: number;
      /** @example 10000 */
      disk_usage: number;
      /** @example 8 */
      collaborators: number;
      /** @example true */
      two_factor_authentication: boolean;
      plan?: {
        collaborators: number;
        name: string;
        space: number;
        private_repos: number;
      };
      /** Format: date-time */
      suspended_at?: string | null;
      business_plus?: boolean;
    };
    /**
     * Organization Simple
     * @description A GitHub organization.
     */
    "organization-simple": {
      /** @example github */
      login: string;
      /** @example 1 */
      id: number;
      /** @example MDEyOk9yZ2FuaXphdGlvbjE= */
      node_id: string;
      /**
       * Format: uri
       * @example https://api.github.com/orgs/github
       */
      url: string;
      /**
       * Format: uri
       * @example https://api.github.com/orgs/github/repos
       */
      repos_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/orgs/github/events
       */
      events_url: string;
      /** @example https://api.github.com/orgs/github/hooks */
      hooks_url: string;
      /** @example https://api.github.com/orgs/github/issues */
      issues_url: string;
      /** @example https://api.github.com/orgs/github/members{/member} */
      members_url: string;
      /** @example https://api.github.com/orgs/github/public_members{/member} */
      public_members_url: string;
      /** @example https://github.com/images/error/octocat_happy.gif */
      avatar_url: string;
      /** @example A great organization */
      description: string | null;
    };
    "pre-receive-environment": {
      id?: number;
      name?: string;
      image_url?: string;
      url?: string;
      html_url?: string;
      default_environment?: boolean;
      created_at?: string;
      hooks_count?: number;
      download?: {
        url?: string;
        state?: string;
        downloaded_at?: string | null;
        message?: string | null;
      };
    };
    "pre-receive-environment-download-status": {
      url?: string;
      state?: string;
      downloaded_at?: string | null;
      message?: string | null;
    };
    "pre-receive-hook": {
      id?: number;
      name?: string;
      enforcement?: string;
      script?: string;
      script_repository?: {
        id?: number;
        full_name?: string;
        url?: string;
        html_url?: string;
      };
      environment?: {
        id?: number;
        name?: string;
        image_url?: string;
        url?: string;
        html_url?: string;
        default_environment?: boolean;
        created_at?: string;
        hooks_count?: number;
        download?: {
          url?: string;
          state?: string;
          downloaded_at?: string | null;
          message?: string | null;
        };
      };
      allow_downstream_configuration?: boolean;
    };
    /**
     * Simple User
     * @description A GitHub user.
     */
    "nullable-simple-user": {
      name?: string | null;
      email?: string | null;
      /** @example octocat */
      login: string;
      /** @example 1 */
      id: number;
      /** @example MDQ6VXNlcjE= */
      node_id: string;
      /**
       * Format: uri
       * @example https://github.com/images/error/octocat_happy.gif
       */
      avatar_url: string;
      /** @example 41d064eb2195891e12d0413f63227ea7 */
      gravatar_id: string | null;
      /**
       * Format: uri
       * @example https://api.github.com/users/octocat
       */
      url: string;
      /**
       * Format: uri
       * @example https://github.com/octocat
       */
      html_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/users/octocat/followers
       */
      followers_url: string;
      /** @example https://api.github.com/users/octocat/following{/other_user} */
      following_url: string;
      /** @example https://api.github.com/users/octocat/gists{/gist_id} */
      gists_url: string;
      /** @example https://api.github.com/users/octocat/starred{/owner}{/repo} */
      starred_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/users/octocat/subscriptions
       */
      subscriptions_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/users/octocat/orgs
       */
      organizations_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/users/octocat/repos
       */
      repos_url: string;
      /** @example https://api.github.com/users/octocat/events{/privacy} */
      events_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/users/octocat/received_events
       */
      received_events_url: string;
      /** @example User */
      type: string;
      site_admin: boolean;
      /** @example "2020-07-09T00:17:55Z" */
      starred_at?: string;
    } | null;
    /**
     * App Permissions
     * @description The permissions granted to the user access token.
     * @example {
     *   "contents": "read",
     *   "issues": "read",
     *   "deployments": "write",
     *   "single_file": "read"
     * }
     */
    "app-permissions": {
      /**
       * @description The level of permission to grant the access token for GitHub Actions workflows, workflow runs, and artifacts.
       * @enum {string}
       */
      actions?: "read" | "write";
      /**
       * @description The level of permission to grant the access token for repository creation, deletion, settings, teams, and collaborators creation.
       * @enum {string}
       */
      administration?: "read" | "write";
      /**
       * @description The level of permission to grant the access token for checks on code.
       * @enum {string}
       */
      checks?: "read" | "write";
      /**
       * @description The level of permission to grant the access token to create, edit, delete, and list Codespaces.
       * @enum {string}
       */
      codespaces?: "read" | "write";
      /**
       * @description The level of permission to grant the access token for repository contents, commits, branches, downloads, releases, and merges.
       * @enum {string}
       */
      contents?: "read" | "write";
      /**
       * @description The leve of permission to grant the access token to manage Dependabot secrets.
       * @enum {string}
       */
      dependabot_secrets?: "read" | "write";
      /**
       * @description The level of permission to grant the access token for deployments and deployment statuses.
       * @enum {string}
       */
      deployments?: "read" | "write";
      /**
       * @description The level of permission to grant the access token for managing repository environments.
       * @enum {string}
       */
      environments?: "read" | "write";
      /**
       * @description The level of permission to grant the access token for issues and related comments, assignees, labels, and milestones.
       * @enum {string}
       */
      issues?: "read" | "write";
      /**
       * @description The level of permission to grant the access token to search repositories, list collaborators, and access repository metadata.
       * @enum {string}
       */
      metadata?: "read" | "write";
      /**
       * @description The level of permission to grant the access token for packages published to GitHub Packages.
       * @enum {string}
       */
      packages?: "read" | "write";
      /**
       * @description The level of permission to grant the access token to retrieve Pages statuses, configuration, and builds, as well as create new builds.
       * @enum {string}
       */
      pages?: "read" | "write";
      /**
       * @description The level of permission to grant the access token for pull requests and related comments, assignees, labels, milestones, and merges.
       * @enum {string}
       */
      pull_requests?: "read" | "write";
      /**
       * @description The level of permission to grant the access token to manage the post-receive hooks for a repository.
       * @enum {string}
       */
      repository_hooks?: "read" | "write";
      /**
       * @description The level of permission to grant the access token to manage repository projects, columns, and cards.
       * @enum {string}
       */
      repository_projects?: "read" | "write" | "admin";
      /**
       * @description The level of permission to grant the access token to view and manage secret scanning alerts.
       * @enum {string}
       */
      secret_scanning_alerts?: "read" | "write";
      /**
       * @description The level of permission to grant the access token to manage repository secrets.
       * @enum {string}
       */
      secrets?: "read" | "write";
      /**
       * @description The level of permission to grant the access token to view and manage security events like code scanning alerts.
       * @enum {string}
       */
      security_events?: "read" | "write";
      /**
       * @description The level of permission to grant the access token to manage just a single file.
       * @enum {string}
       */
      single_file?: "read" | "write";
      /**
       * @description The level of permission to grant the access token for commit statuses.
       * @enum {string}
       */
      statuses?: "read" | "write";
      /**
       * @description The level of permission to grant the access token to manage Dependabot alerts.
       * @enum {string}
       */
      vulnerability_alerts?: "read" | "write";
      /**
       * @description The level of permission to grant the access token to update GitHub Actions workflow files.
       * @enum {string}
       */
      workflows?: "write";
      /**
       * @description The level of permission to grant the access token for organization teams and members.
       * @enum {string}
       */
      members?: "read" | "write";
      /**
       * @description The level of permission to grant the access token to manage access to an organization.
       * @enum {string}
       */
      organization_administration?: "read" | "write";
      /**
       * @description The level of permission to grant the access token for custom repository roles management.
       * @enum {string}
       */
      organization_custom_roles?: "read" | "write";
      /**
       * @description The level of permission to grant the access token for managing access to GitHub Copilot for members of an organization with a Copilot Business subscription. This property is in beta and is subject to change.
       * @enum {string}
       */
      organization_copilot_seat_management?: "write";
      /**
       * @description The level of permission to grant the access token to view and manage announcement banners for an organization.
       * @enum {string}
       */
      organization_announcement_banners?: "read" | "write";
      /**
       * @description The level of permission to grant the access token to view events triggered by an activity in an organization.
       * @enum {string}
       */
      organization_events?: "read";
      /**
       * @description The level of permission to grant the access token to manage the post-receive hooks for an organization.
       * @enum {string}
       */
      organization_hooks?: "read" | "write";
      /**
       * @description The level of permission to grant the access token for viewing and managing fine-grained personal access token requests to an organization.
       * @enum {string}
       */
      organization_personal_access_tokens?: "read" | "write";
      /**
       * @description The level of permission to grant the access token for viewing and managing fine-grained personal access tokens that have been approved by an organization.
       * @enum {string}
       */
      organization_personal_access_token_requests?: "read" | "write";
      /**
       * @description The level of permission to grant the access token for viewing an organization's plan.
       * @enum {string}
       */
      organization_plan?: "read";
      /**
       * @description The level of permission to grant the access token to manage organization projects and projects beta (where available).
       * @enum {string}
       */
      organization_projects?: "read" | "write" | "admin";
      /**
       * @description The level of permission to grant the access token for organization packages published to GitHub Packages.
       * @enum {string}
       */
      organization_packages?: "read" | "write";
      /**
       * @description The level of permission to grant the access token to manage organization secrets.
       * @enum {string}
       */
      organization_secrets?: "read" | "write";
      /**
       * @description The level of permission to grant the access token to view and manage GitHub Actions self-hosted runners available to an organization.
       * @enum {string}
       */
      organization_self_hosted_runners?: "read" | "write";
      /**
       * @description The level of permission to grant the access token to view and manage users blocked by the organization.
       * @enum {string}
       */
      organization_user_blocking?: "read" | "write";
      /**
       * @description The level of permission to grant the access token to manage team discussions and related comments.
       * @enum {string}
       */
      team_discussions?: "read" | "write";
      /**
       * @description The level of permission to grant the access token to manage the email addresses belonging to a user.
       * @enum {string}
       */
      email_addresses?: "read" | "write";
      /**
       * @description The level of permission to grant the access token to manage the followers belonging to a user.
       * @enum {string}
       */
      followers?: "read" | "write";
      /**
       * @description The level of permission to grant the access token to manage git SSH keys.
       * @enum {string}
       */
      git_ssh_keys?: "read" | "write";
      /**
       * @description The level of permission to grant the access token to view and manage GPG keys belonging to a user.
       * @enum {string}
       */
      gpg_keys?: "read" | "write";
      /**
       * @description The level of permission to grant the access token to view and manage interaction limits on a repository.
       * @enum {string}
       */
      interaction_limits?: "read" | "write";
      /**
       * @description The level of permission to grant the access token to manage the profile settings belonging to a user.
       * @enum {string}
       */
      profile?: "write";
      /**
       * @description The level of permission to grant the access token to list and manage repositories a user is starring.
       * @enum {string}
       */
      starring?: "read" | "write";
    };
    /**
     * Simple User
     * @description A GitHub user.
     */
    "simple-user": {
      name?: string | null;
      email?: string | null;
      /** @example octocat */
      login: string;
      /** @example 1 */
      id: number;
      /** @example MDQ6VXNlcjE= */
      node_id: string;
      /**
       * Format: uri
       * @example https://github.com/images/error/octocat_happy.gif
       */
      avatar_url: string;
      /** @example 41d064eb2195891e12d0413f63227ea7 */
      gravatar_id: string | null;
      /**
       * Format: uri
       * @example https://api.github.com/users/octocat
       */
      url: string;
      /**
       * Format: uri
       * @example https://github.com/octocat
       */
      html_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/users/octocat/followers
       */
      followers_url: string;
      /** @example https://api.github.com/users/octocat/following{/other_user} */
      following_url: string;
      /** @example https://api.github.com/users/octocat/gists{/gist_id} */
      gists_url: string;
      /** @example https://api.github.com/users/octocat/starred{/owner}{/repo} */
      starred_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/users/octocat/subscriptions
       */
      subscriptions_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/users/octocat/orgs
       */
      organizations_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/users/octocat/repos
       */
      repos_url: string;
      /** @example https://api.github.com/users/octocat/events{/privacy} */
      events_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/users/octocat/received_events
       */
      received_events_url: string;
      /** @example User */
      type: string;
      site_admin: boolean;
      /** @example "2020-07-09T00:17:55Z" */
      starred_at?: string;
    };
    /** Scoped Installation */
    "nullable-scoped-installation": {
      permissions: components["schemas"]["app-permissions"];
      /**
       * @description Describe whether all repositories have been selected or there's a selection involved
       * @enum {string}
       */
      repository_selection: "all" | "selected";
      /** @example config.yaml */
      single_file_name: string | null;
      /** @example true */
      has_multiple_single_files?: boolean;
      /**
       * @example [
       *   "config.yml",
       *   ".github/issue_TEMPLATE.md"
       * ]
       */
      single_file_paths?: string[];
      /**
       * Format: uri
       * @example https://api.github.com/users/octocat/repos
       */
      repositories_url: string;
      account: components["schemas"]["simple-user"];
    } | null;
    /**
     * Authorization
     * @description The authorization for an OAuth app, GitHub App, or a Personal Access Token.
     */
    authorization: {
      id: number;
      /** Format: uri */
      url: string;
      /** @description A list of scopes that this authorization is in. */
      scopes: string[] | null;
      token: string;
      token_last_eight: string | null;
      hashed_token: string | null;
      app: {
        client_id: string;
        name: string;
        /** Format: uri */
        url: string;
      };
      note: string | null;
      /** Format: uri */
      note_url: string | null;
      /** Format: date-time */
      updated_at: string;
      /** Format: date-time */
      created_at: string;
      fingerprint: string | null;
      user?: components["schemas"]["nullable-simple-user"];
      installation?: components["schemas"]["nullable-scoped-installation"];
      /** Format: date-time */
      expires_at: string | null;
    };
    /**
     * GitHub app
     * @description GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
     */
    integration: {
      /**
       * @description Unique identifier of the GitHub app
       * @example 37
       */
      id: number;
      /**
       * @description The slug name of the GitHub app
       * @example probot-owners
       */
      slug?: string;
      /** @example MDExOkludGVncmF0aW9uMQ== */
      node_id: string;
      owner: components["schemas"]["nullable-simple-user"];
      /**
       * @description The name of the GitHub app
       * @example Probot Owners
       */
      name: string;
      /** @example The description of the app. */
      description: string | null;
      /**
       * Format: uri
       * @example https://example.com
       */
      external_url: string;
      /**
       * Format: uri
       * @example https://github.com/apps/super-ci
       */
      html_url: string;
      /**
       * Format: date-time
       * @example 2017-07-08T16:18:44-04:00
       */
      created_at: string;
      /**
       * Format: date-time
       * @example 2017-07-08T16:18:44-04:00
       */
      updated_at: string;
      /**
       * @description The set of permissions for the GitHub app
       * @example {
       *   "issues": "read",
       *   "deployments": "write"
       * }
       */
      permissions: {
        issues?: string;
        checks?: string;
        metadata?: string;
        contents?: string;
        deployments?: string;
        [key: string]: string | undefined;
      };
      /**
       * @description The list of events for the GitHub app
       * @example [
       *   "label",
       *   "deployment"
       * ]
       */
      events: string[];
      /**
       * @description The number of installations associated with the GitHub app
       * @example 5
       */
      installations_count?: number;
      /** @example "Iv1.25b5d1e65ffc4022" */
      client_id?: string;
      /** @example "1d4b2097ac622ba702d19de498f005747a8b21d3" */
      client_secret?: string;
      /** @example "6fba8f2fc8a7e8f2cca5577eddd82ca7586b3b6b" */
      webhook_secret?: string | null;
      /** @example "-----BEGIN RSA PRIVATE KEY-----\nMIIEogIBAAKCAQEArYxrNYD/iT5CZVpRJu4rBKmmze3PVmT/gCo2ATUvDvZTPTey\nxcGJ3vvrJXazKk06pN05TN29o98jrYz4cengG3YGsXPNEpKsIrEl8NhbnxapEnM9\nJCMRe0P5JcPsfZlX6hmiT7136GRWiGOUba2X9+HKh8QJVLG5rM007TBER9/z9mWm\nrJuNh+m5l320oBQY/Qq3A7wzdEfZw8qm/mIN0FCeoXH1L6B8xXWaAYBwhTEh6SSn\nZHlO1Xu1JWDmAvBCi0RO5aRSKM8q9QEkvvHP4yweAtK3N8+aAbZ7ovaDhyGz8r6r\nzhU1b8Uo0Z2ysf503WqzQgIajr7Fry7/kUwpgQIDAQABAoIBADwJp80Ko1xHPZDy\nfcCKBDfIuPvkmSW6KumbsLMaQv1aGdHDwwTGv3t0ixSay8CGlxMRtRDyZPib6SvQ\n6OH/lpfpbMdW2ErkksgtoIKBVrDilfrcAvrNZu7NxRNbhCSvN8q0s4ICecjbbVQh\nnueSdlA6vGXbW58BHMq68uRbHkP+k+mM9U0mDJ1HMch67wlg5GbayVRt63H7R2+r\nVxcna7B80J/lCEjIYZznawgiTvp3MSanTglqAYi+m1EcSsP14bJIB9vgaxS79kTu\noiSo93leJbBvuGo8QEiUqTwMw4tDksmkLsoqNKQ1q9P7LZ9DGcujtPy4EZsamSJT\ny8OJt0ECgYEA2lxOxJsQk2kI325JgKFjo92mQeUObIvPfSNWUIZQDTjniOI6Gv63\nGLWVFrZcvQBWjMEQraJA9xjPbblV8PtfO87MiJGLWCHFxmPz2dzoedN+2Coxom8m\nV95CLz8QUShuao6u/RYcvUaZEoYs5bHcTmy5sBK80JyEmafJPtCQVxMCgYEAy3ar\nZr3yv4xRPEPMat4rseswmuMooSaK3SKub19WFI5IAtB/e7qR1Rj9JhOGcZz+OQrl\nT78O2OFYlgOIkJPvRMrPpK5V9lslc7tz1FSh3BZMRGq5jSyD7ETSOQ0c8T2O/s7v\nbeEPbVbDe4mwvM24XByH0GnWveVxaDl51ABD65sCgYB3ZAspUkOA5egVCh8kNpnd\nSd6SnuQBE3ySRlT2WEnCwP9Ph6oPgn+oAfiPX4xbRqkL8q/k0BdHQ4h+zNwhk7+h\nWtPYRAP1Xxnc/F+jGjb+DVaIaKGU18MWPg7f+FI6nampl3Q0KvfxwX0GdNhtio8T\nTj1E+SnFwh56SRQuxSh2gwKBgHKjlIO5NtNSflsUYFM+hyQiPiqnHzddfhSG+/3o\nm5nNaSmczJesUYreH5San7/YEy2UxAugvP7aSY2MxB+iGsiJ9WD2kZzTUlDZJ7RV\nUzWsoqBR+eZfVJ2FUWWvy8TpSG6trh4dFxImNtKejCR1TREpSiTV3Zb1dmahK9GV\nrK9NAoGAbBxRLoC01xfxCTgt5BDiBcFVh4fp5yYKwavJPLzHSpuDOrrI9jDn1oKN\nonq5sDU1i391zfQvdrbX4Ova48BN+B7p63FocP/MK5tyyBoT8zQEk2+vWDOw7H/Z\nu5dTCPxTIsoIwUw1I+7yIxqJzLPFgR2gVBwY1ra/8iAqCj+zeBw=\n-----END RSA PRIVATE KEY-----\n" */
      pem?: string;
    };
    /**
     * Basic Error
     * @description Basic Error
     */
    "basic-error": {
      message?: string;
      documentation_url?: string;
      url?: string;
      status?: string;
    };
    /**
     * Validation Error Simple
     * @description Validation Error Simple
     */
    "validation-error-simple": {
      message: string;
      documentation_url: string;
      errors?: string[];
    };
    /**
     * Format: uri
     * @description The URL to which the payloads will be delivered.
     * @example https://example.com/webhook
     */
    "webhook-config-url": string;
    /**
     * @description The media type used to serialize the payloads. Supported values include `json` and `form`. The default is `form`.
     * @example "json"
     */
    "webhook-config-content-type": string;
    /**
     * @description If provided, the `secret` will be used as the `key` to generate the HMAC hex digest value for [delivery signature headers](https://docs.github.com/enterprise-server@3.10/webhooks/event-payloads/#delivery-headers).
     * @example "********"
     */
    "webhook-config-secret": string;
    "webhook-config-insecure-ssl": string | number;
    /**
     * Webhook Configuration
     * @description Configuration object of the webhook
     */
    "webhook-config": {
      url?: components["schemas"]["webhook-config-url"];
      content_type?: components["schemas"]["webhook-config-content-type"];
      secret?: components["schemas"]["webhook-config-secret"];
      insecure_ssl?: components["schemas"]["webhook-config-insecure-ssl"];
    };
    /**
     * Simple webhook delivery
     * @description Delivery made by a webhook, without request and response information.
     */
    "hook-delivery-item": {
      /**
       * @description Unique identifier of the webhook delivery.
       * @example 42
       */
      id: number;
      /**
       * @description Unique identifier for the event (shared with all deliveries for all webhooks that subscribe to this event).
       * @example 58474f00-b361-11eb-836d-0e4f3503ccbe
       */
      guid: string;
      /**
       * Format: date-time
       * @description Time when the webhook delivery occurred.
       * @example 2021-05-12T20:33:44Z
       */
      delivered_at: string;
      /**
       * @description Whether the webhook delivery is a redelivery.
       * @example false
       */
      redelivery: boolean;
      /**
       * @description Time spent delivering.
       * @example 0.03
       */
      duration: number;
      /**
       * @description Describes the response returned after attempting the delivery.
       * @example failed to connect
       */
      status: string;
      /**
       * @description Status code received when delivery was made.
       * @example 502
       */
      status_code: number;
      /**
       * @description The event that triggered the delivery.
       * @example issues
       */
      event: string;
      /**
       * @description The type of activity for the event that triggered the delivery.
       * @example opened
       */
      action: string | null;
      /**
       * @description The id of the GitHub App installation associated with this event.
       * @example 123
       */
      installation_id: number | null;
      /**
       * @description The id of the repository associated with this event.
       * @example 123
       */
      repository_id: number | null;
    };
    /**
     * Scim Error
     * @description Scim Error
     */
    "scim-error": {
      message?: string | null;
      documentation_url?: string | null;
      detail?: string | null;
      status?: number;
      scimType?: string | null;
      schemas?: string[];
    };
    /**
     * Validation Error
     * @description Validation Error
     */
    "validation-error": {
      message: string;
      documentation_url: string;
      errors?: {
        resource?: string;
        field?: string;
        message?: string;
        code: string;
        index?: number;
        value?: (string | null) | (number | null) | (string[] | null);
      }[];
    };
    /**
     * Webhook delivery
     * @description Delivery made by a webhook.
     */
    "hook-delivery": {
      /**
       * @description Unique identifier of the delivery.
       * @example 42
       */
      id: number;
      /**
       * @description Unique identifier for the event (shared with all deliveries for all webhooks that subscribe to this event).
       * @example 58474f00-b361-11eb-836d-0e4f3503ccbe
       */
      guid: string;
      /**
       * Format: date-time
       * @description Time when the delivery was delivered.
       * @example 2021-05-12T20:33:44Z
       */
      delivered_at: string;
      /**
       * @description Whether the delivery is a redelivery.
       * @example false
       */
      redelivery: boolean;
      /**
       * @description Time spent delivering.
       * @example 0.03
       */
      duration: number;
      /**
       * @description Description of the status of the attempted delivery
       * @example failed to connect
       */
      status: string;
      /**
       * @description Status code received when delivery was made.
       * @example 502
       */
      status_code: number;
      /**
       * @description The event that triggered the delivery.
       * @example issues
       */
      event: string;
      /**
       * @description The type of activity for the event that triggered the delivery.
       * @example opened
       */
      action: string | null;
      /**
       * @description The id of the GitHub App installation associated with this event.
       * @example 123
       */
      installation_id: number | null;
      /**
       * @description The id of the repository associated with this event.
       * @example 123
       */
      repository_id: number | null;
      /**
       * @description The URL target of the delivery.
       * @example https://www.example.com
       */
      url?: string;
      request: {
        /** @description The request headers sent with the webhook delivery. */
        headers: {
          [key: string]: unknown;
        } | null;
        /** @description The webhook payload. */
        payload: {
          [key: string]: unknown;
        } | null;
      };
      response: {
        /** @description The response headers received when the delivery was made. */
        headers: {
          [key: string]: unknown;
        } | null;
        /** @description The response payload received. */
        payload: string | null;
      };
    };
    /**
     * Enterprise
     * @description An enterprise on GitHub.
     */
    enterprise: {
      /** @description A short description of the enterprise. */
      description?: string | null;
      /**
       * Format: uri
       * @example https://github.com/enterprises/octo-business
       */
      html_url: string;
      /**
       * Format: uri
       * @description The enterprise's website URL.
       */
      website_url?: string | null;
      /**
       * @description Unique identifier of the enterprise
       * @example 42
       */
      id: number;
      /** @example MDEwOlJlcG9zaXRvcnkxMjk2MjY5 */
      node_id: string;
      /**
       * @description The name of the enterprise.
       * @example Octo Business
       */
      name: string;
      /**
       * @description The slug url identifier for the enterprise.
       * @example octo-business
       */
      slug: string;
      /**
       * Format: date-time
       * @example 2019-01-26T19:01:12Z
       */
      created_at: string | null;
      /**
       * Format: date-time
       * @example 2019-01-26T19:14:43Z
       */
      updated_at: string | null;
      /** Format: uri */
      avatar_url: string;
    };
    /**
     * Integration Installation Request
     * @description Request to install an integration on a target
     */
    "integration-installation-request": {
      /**
       * @description Unique identifier of the request installation.
       * @example 42
       */
      id: number;
      /** @example MDExOkludGVncmF0aW9uMQ== */
      node_id?: string;
      account:
        | components["schemas"]["simple-user"]
        | components["schemas"]["enterprise"];
      requester: components["schemas"]["simple-user"];
      /**
       * Format: date-time
       * @example 2022-07-08T16:18:44-04:00
       */
      created_at: string;
    };
    /**
     * Installation
     * @description Installation
     */
    installation: {
      /**
       * @description The ID of the installation.
       * @example 1
       */
      id: number;
      account:
        | (
            | components["schemas"]["simple-user"]
            | components["schemas"]["enterprise"]
          )
        | null;
      /**
       * @description Describe whether all repositories have been selected or there's a selection involved
       * @enum {string}
       */
      repository_selection: "all" | "selected";
      /**
       * Format: uri
       * @example https://api.github.com/app/installations/1/access_tokens
       */
      access_tokens_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/installation/repositories
       */
      repositories_url: string;
      /**
       * Format: uri
       * @example https://github.com/organizations/github/settings/installations/1
       */
      html_url: string;
      /** @example 1 */
      app_id: number;
      /** @description The ID of the user or organization this token is being scoped to. */
      target_id: number;
      /** @example Organization */
      target_type: string;
      permissions: components["schemas"]["app-permissions"];
      events: string[];
      /** Format: date-time */
      created_at: string;
      /** Format: date-time */
      updated_at: string;
      /** @example config.yaml */
      single_file_name: string | null;
      /** @example true */
      has_multiple_single_files?: boolean;
      /**
       * @example [
       *   "config.yml",
       *   ".github/issue_TEMPLATE.md"
       * ]
       */
      single_file_paths?: string[];
      /** @example github-actions */
      app_slug: string;
      suspended_by: components["schemas"]["nullable-simple-user"];
      /** Format: date-time */
      suspended_at: string | null;
      /** @example "test_13f1e99741e3e004@d7e1eb0bc0a1ba12.com" */
      contact_email?: string | null;
    };
    /**
     * License Simple
     * @description License Simple
     */
    "nullable-license-simple": {
      /** @example mit */
      key: string;
      /** @example MIT License */
      name: string;
      /**
       * Format: uri
       * @example https://api.github.com/licenses/mit
       */
      url: string | null;
      /** @example MIT */
      spdx_id: string | null;
      /** @example MDc6TGljZW5zZW1pdA== */
      node_id: string;
      /** Format: uri */
      html_url?: string;
    } | null;
    /**
     * Repository
     * @description A repository on GitHub.
     */
    repository: {
      /**
       * @description Unique identifier of the repository
       * @example 42
       */
      id: number;
      /** @example MDEwOlJlcG9zaXRvcnkxMjk2MjY5 */
      node_id: string;
      /**
       * @description The name of the repository.
       * @example Team Environment
       */
      name: string;
      /** @example octocat/Hello-World */
      full_name: string;
      license: components["schemas"]["nullable-license-simple"];
      forks: number;
      permissions?: {
        admin: boolean;
        pull: boolean;
        triage?: boolean;
        push: boolean;
        maintain?: boolean;
      };
      owner: components["schemas"]["simple-user"];
      /**
       * @description Whether the repository is private or public.
       * @default false
       */
      private: boolean;
      /**
       * Format: uri
       * @example https://github.com/octocat/Hello-World
       */
      html_url: string;
      /** @example This your first repo! */
      description: string | null;
      fork: boolean;
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/Hello-World
       */
      url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/{archive_format}{/ref} */
      archive_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/assignees{/user} */
      assignees_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/git/blobs{/sha} */
      blobs_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/branches{/branch} */
      branches_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/collaborators{/collaborator} */
      collaborators_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/comments{/number} */
      comments_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/commits{/sha} */
      commits_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/compare/{base}...{head} */
      compare_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/contents/{+path} */
      contents_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/contributors
       */
      contributors_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/deployments
       */
      deployments_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/downloads
       */
      downloads_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/events
       */
      events_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/forks
       */
      forks_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/git/commits{/sha} */
      git_commits_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/git/refs{/sha} */
      git_refs_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/git/tags{/sha} */
      git_tags_url: string;
      /** @example git:github.com/octocat/Hello-World.git */
      git_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/issues/comments{/number} */
      issue_comment_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/issues/events{/number} */
      issue_events_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/issues{/number} */
      issues_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/keys{/key_id} */
      keys_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/labels{/name} */
      labels_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/languages
       */
      languages_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/merges
       */
      merges_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/milestones{/number} */
      milestones_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/notifications{?since,all,participating} */
      notifications_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/pulls{/number} */
      pulls_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/releases{/id} */
      releases_url: string;
      /** @example git@github.com:octocat/Hello-World.git */
      ssh_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/stargazers
       */
      stargazers_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/statuses/{sha} */
      statuses_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/subscribers
       */
      subscribers_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/subscription
       */
      subscription_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/tags
       */
      tags_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/teams
       */
      teams_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/git/trees{/sha} */
      trees_url: string;
      /** @example https://github.com/octocat/Hello-World.git */
      clone_url: string;
      /**
       * Format: uri
       * @example git:git.example.com/octocat/Hello-World
       */
      mirror_url: string | null;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/hooks
       */
      hooks_url: string;
      /**
       * Format: uri
       * @example https://svn.github.com/octocat/Hello-World
       */
      svn_url: string;
      /**
       * Format: uri
       * @example https://github.com
       */
      homepage: string | null;
      language: string | null;
      /** @example 9 */
      forks_count: number;
      /** @example 80 */
      stargazers_count: number;
      /** @example 80 */
      watchers_count: number;
      /**
       * @description The size of the repository, in kilobytes. Size is calculated hourly. When a repository is initially created, the size is 0.
       * @example 108
       */
      size: number;
      /**
       * @description The default branch of the repository.
       * @example master
       */
      default_branch: string;
      /** @example 0 */
      open_issues_count: number;
      /**
       * @description Whether this repository acts as a template that can be used to generate new repositories.
       * @default false
       * @example true
       */
      is_template?: boolean;
      topics?: string[];
      /**
       * @description Whether issues are enabled.
       * @default true
       * @example true
       */
      has_issues: boolean;
      /**
       * @description Whether projects are enabled.
       * @default true
       * @example true
       */
      has_projects: boolean;
      /**
       * @description Whether the wiki is enabled.
       * @default true
       * @example true
       */
      has_wiki: boolean;
      has_pages: boolean;
      /**
       * @deprecated
       * @description Whether downloads are enabled.
       * @default true
       * @example true
       */
      has_downloads: boolean;
      /**
       * @description Whether discussions are enabled.
       * @default false
       * @example true
       */
      has_discussions?: boolean;
      /**
       * @description Whether the repository is archived.
       * @default false
       */
      archived: boolean;
      /** @description Returns whether or not this repository disabled. */
      disabled: boolean;
      /**
       * @description The repository visibility: public, private, or internal.
       * @default public
       */
      visibility?: string;
      /**
       * Format: date-time
       * @example 2011-01-26T19:06:43Z
       */
      pushed_at: string | null;
      /**
       * Format: date-time
       * @example 2011-01-26T19:01:12Z
       */
      created_at: string | null;
      /**
       * Format: date-time
       * @example 2011-01-26T19:14:43Z
       */
      updated_at: string | null;
      /**
       * @description Whether to allow rebase merges for pull requests.
       * @default true
       * @example true
       */
      allow_rebase_merge?: boolean;
      temp_clone_token?: string;
      /**
       * @description Whether to allow squash merges for pull requests.
       * @default true
       * @example true
       */
      allow_squash_merge?: boolean;
      /**
       * @description Whether to allow Auto-merge to be used on pull requests.
       * @default false
       * @example false
       */
      allow_auto_merge?: boolean;
      /**
       * @description Whether to delete head branches when pull requests are merged
       * @default false
       * @example false
       */
      delete_branch_on_merge?: boolean;
      /**
       * @description Whether or not a pull request head branch that is behind its base branch can always be updated even if it is not required to be up to date before merging.
       * @default false
       * @example false
       */
      allow_update_branch?: boolean;
      /**
       * @deprecated
       * @description Whether a squash merge commit can use the pull request title as default. **This property has been deprecated. Please use `squash_merge_commit_title` instead.
       * @default false
       */
      use_squash_pr_title_as_default?: boolean;
      /**
       * @description The default value for a squash merge commit title:
       *
       * - `PR_TITLE` - default to the pull request's title.
       * - `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).
       * @enum {string}
       */
      squash_merge_commit_title?: "PR_TITLE" | "COMMIT_OR_PR_TITLE";
      /**
       * @description The default value for a squash merge commit message:
       *
       * - `PR_BODY` - default to the pull request's body.
       * - `COMMIT_MESSAGES` - default to the branch's commit messages.
       * - `BLANK` - default to a blank commit message.
       * @enum {string}
       */
      squash_merge_commit_message?: "PR_BODY" | "COMMIT_MESSAGES" | "BLANK";
      /**
       * @description The default value for a merge commit title.
       *
       * - `PR_TITLE` - default to the pull request's title.
       * - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).
       * @enum {string}
       */
      merge_commit_title?: "PR_TITLE" | "MERGE_MESSAGE";
      /**
       * @description The default value for a merge commit message.
       *
       * - `PR_TITLE` - default to the pull request's title.
       * - `PR_BODY` - default to the pull request's body.
       * - `BLANK` - default to a blank commit message.
       * @enum {string}
       */
      merge_commit_message?: "PR_BODY" | "PR_TITLE" | "BLANK";
      /**
       * @description Whether to allow merge commits for pull requests.
       * @default true
       * @example true
       */
      allow_merge_commit?: boolean;
      /** @description Whether to allow forking this repo */
      allow_forking?: boolean;
      /**
       * @description Whether to require contributors to sign off on web-based commits
       * @default false
       */
      web_commit_signoff_required?: boolean;
      open_issues: number;
      watchers: number;
      master_branch?: string;
      /** @example "2020-07-09T00:17:42Z" */
      starred_at?: string;
      /** @description Whether anonymous git access is enabled for this repository */
      anonymous_access_enabled?: boolean;
    };
    /**
     * Installation Token
     * @description Authentication token for a GitHub App installed on a user or org.
     */
    "installation-token": {
      token: string;
      expires_at: string;
      permissions?: components["schemas"]["app-permissions"];
      /** @enum {string} */
      repository_selection?: "all" | "selected";
      repositories?: components["schemas"]["repository"][];
      /** @example README.md */
      single_file?: string;
      /** @example true */
      has_multiple_single_files?: boolean;
      /**
       * @example [
       *   "config.yml",
       *   ".github/issue_TEMPLATE.md"
       * ]
       */
      single_file_paths?: string[];
    };
    /**
     * Application Grant
     * @description The authorization associated with an OAuth Access.
     */
    "application-grant": {
      /** @example 1 */
      id: number;
      /**
       * Format: uri
       * @example https://api.github.com/applications/grants/1
       */
      url: string;
      app: {
        client_id: string;
        name: string;
        /** Format: uri */
        url: string;
      };
      /**
       * Format: date-time
       * @example 2011-09-06T17:26:27Z
       */
      created_at: string;
      /**
       * Format: date-time
       * @example 2011-09-06T20:39:23Z
       */
      updated_at: string;
      /**
       * @example [
       *   "public_repo"
       * ]
       */
      scopes: string[];
      user?: components["schemas"]["nullable-simple-user"];
    };
    /**
     * Code Of Conduct
     * @description Code Of Conduct
     */
    "code-of-conduct": {
      /** @example contributor_covenant */
      key: string;
      /** @example Contributor Covenant */
      name: string;
      /**
       * Format: uri
       * @example https://api.github.com/codes_of_conduct/contributor_covenant
       */
      url: string;
      /**
       * @example # Contributor Covenant Code of Conduct
       *
       * ## Our Pledge
       *
       * In the interest of fostering an open and welcoming environment, we as contributors and maintainers pledge to making participation in our project and our community a harassment-free experience for everyone, regardless of age, body size, disability, ethnicity, gender identity and expression, level of experience, nationality, personal appearance, race, religion, or sexual identity and orientation.
       *
       * ## Our Standards
       *
       * Examples of behavior that contributes to creating a positive environment include:
       *
       * * Using welcoming and inclusive language
       * * Being respectful of differing viewpoints and experiences
       * * Gracefully accepting constructive criticism
       * * Focusing on what is best for the community
       * * Showing empathy towards other community members
       *
       * Examples of unacceptable behavior by participants include:
       *
       * * The use of sexualized language or imagery and unwelcome sexual attention or advances
       * * Trolling, insulting/derogatory comments, and personal or political attacks
       * * Public or private harassment
       * * Publishing others' private information, such as a physical or electronic address, without explicit permission
       * * Other conduct which could reasonably be considered inappropriate in a professional setting
       *
       * ## Our Responsibilities
       *
       * Project maintainers are responsible for clarifying the standards of acceptable behavior and are expected to take appropriate and fair corrective action in response
       *                   to any instances of unacceptable behavior.
       *
       * Project maintainers have the right and responsibility to remove, edit, or reject comments, commits, code, wiki edits, issues, and other contributions that are not aligned to this Code of Conduct, or to ban temporarily or permanently any contributor for other behaviors that they deem inappropriate, threatening, offensive, or harmful.
       *
       * ## Scope
       *
       * This Code of Conduct applies both within project spaces and in public spaces when an individual is representing the project or its community. Examples of representing a project or community include using an official project e-mail address,
       *                   posting via an official social media account, or acting as an appointed representative at an online or offline event. Representation of a project may be further defined and clarified by project maintainers.
       *
       * ## Enforcement
       *
       * Instances of abusive, harassing, or otherwise unacceptable behavior may be reported by contacting the project team at [EMAIL]. The project team will review and investigate all complaints, and will respond in a way that it deems appropriate to the circumstances. The project team is obligated to maintain confidentiality with regard to the reporter of an incident. Further details of specific enforcement policies may be posted separately.
       *
       * Project maintainers who do not follow or enforce the Code of Conduct in good faith may face temporary or permanent repercussions as determined by other members of the project's leadership.
       *
       * ## Attribution
       *
       * This Code of Conduct is adapted from the [Contributor Covenant](http://contributor-covenant.org), version 1.4, available at [http://contributor-covenant.org/version/1/4](http://contributor-covenant.org/version/1/4/).
       */
      body?: string;
      /** Format: uri */
      html_url: string | null;
    };
    /**
     * @description The announcement text in GitHub Flavored Markdown. For more information about GitHub Flavored Markdown, see "[Basic writing and formatting syntax](https://docs.github.com/enterprise-server@3.10/github/writing-on-github/getting-started-with-writing-and-formatting-on-github/basic-writing-and-formatting-syntax)."
     * @example Very **important** announcement about _something_.
     */
    "announcement-message": string | null;
    /**
     * Format: date-time
     * @description The time at which the announcement expires. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`. To set an announcement that never expires, omit this parameter, set it to `null`, or set it to an empty string.
     * @example "2021-01-01T00:00:00.000-07:00"
     */
    "announcement-expiration": string | null;
    /**
     * Enterprise Announcement
     * @description Enterprise global announcement
     */
    announcement: {
      announcement: components["schemas"]["announcement-message"];
      expires_at?: components["schemas"]["announcement-expiration"];
    };
    "license-info": {
      seats?: string | number;
      seats_used?: number;
      seats_available?: string | number;
      kind?: string;
      days_until_expiration?: number;
      expire_at?: string;
    };
    /** Repository Enterprise Stats */
    "enterprise-repository-overview": {
      total_repos: number;
      root_repos: number;
      fork_repos: number;
      org_repos: number;
      total_pushes: number;
      total_wikis: number;
    };
    /** Hooks Enterprise Stats */
    "enterprise-hook-overview": {
      total_hooks: number;
      active_hooks: number;
      inactive_hooks: number;
    };
    /** Enterprise Pages Stats */
    "enterprise-page-overview": {
      total_pages: number;
    };
    /** Enterprise Organization Stats */
    "enterprise-organization-overview": {
      total_orgs: number;
      disabled_orgs: number;
      total_teams: number;
      total_team_members: number;
    };
    /** Enterprise User Stats */
    "enterprise-user-overview": {
      total_users: number;
      admin_users: number;
      suspended_users: number;
    };
    /** Enterprise Pull Request Stats */
    "enterprise-pull-request-overview": {
      total_pulls: number;
      merged_pulls: number;
      mergeable_pulls: number;
      unmergeable_pulls: number;
    };
    /** Enterprise Issue Stats */
    "enterprise-issue-overview": {
      total_issues: number;
      open_issues: number;
      closed_issues: number;
    };
    /** Enterprise Milestone Stats */
    "enterprise-milestone-overview": {
      total_milestones: number;
      open_milestones: number;
      closed_milestones: number;
    };
    /** Enterprise Gist Stats */
    "enterprise-gist-overview": {
      total_gists: number;
      private_gists: number;
      public_gists: number;
    };
    /** Enterprise Comment Stats */
    "enterprise-comment-overview": {
      total_commit_comments: number;
      total_gist_comments: number;
      total_issue_comments: number;
      total_pull_request_comments: number;
    };
    "enterprise-overview": {
      repos?: components["schemas"]["enterprise-repository-overview"];
      hooks?: components["schemas"]["enterprise-hook-overview"];
      pages?: components["schemas"]["enterprise-page-overview"];
      orgs?: components["schemas"]["enterprise-organization-overview"];
      users?: components["schemas"]["enterprise-user-overview"];
      pulls?: components["schemas"]["enterprise-pull-request-overview"];
      issues?: components["schemas"]["enterprise-issue-overview"];
      milestones?: components["schemas"]["enterprise-milestone-overview"];
      gists?: components["schemas"]["enterprise-gist-overview"];
      comments?: components["schemas"]["enterprise-comment-overview"];
    };
    /** Enterprise Security Products Stats */
    "enterprise-security-products-overview": {
      total_repos?: number;
      nonarchived_repos?: number;
      secret_scanning_enabled_repos?: number;
      secret_scanning_push_protection_enabled_repos?: number;
      code_scanning_enabled_repos?: number;
      code_scanning_pr_reviews_enabled_repos?: number;
      code_scanning_default_setup_enabled_repos?: number;
      code_scanning_default_setup_eligible_repos?: number;
      dependabot_alerts_enabled_repos?: number;
      dependabot_security_updates_enabled_repos?: number;
      dependabot_version_updates_enabled_repos?: number;
      advanced_security_enabled_repos?: number;
      active_committers?: number;
      purchased_committers?: number;
      maximum_committers?: number;
    };
    "actions-cache-usage-org-enterprise": {
      /** @description The count of active caches across all repositories of an enterprise or an organization. */
      total_active_caches_count: number;
      /** @description The total size in bytes of all active cache items across all repositories of an enterprise or an organization. */
      total_active_caches_size_in_bytes: number;
    };
    /**
     * Actions cache usage policy for an enterprise
     * @description GitHub Actions cache usage policy for an enterprise.
     */
    "actions-cache-usage-policy-enterprise": {
      /**
       * @description For repositories in an enterprise, the default size limit for the sum of all caches in a repository, in gigabytes.
       * @example 10
       */
      repo_cache_size_limit_in_gb?: number;
      /**
       * @description For repositories in an enterprise, the maximum value that can be set as the limit for the sum of all caches in a repository, in gigabytes.
       * @example 15
       */
      max_repo_cache_size_limit_in_gb?: number;
    };
    /**
     * @description The policy that controls the organizations in the enterprise that are allowed to run GitHub Actions.
     * @enum {string}
     */
    "enabled-organizations": "all" | "none" | "selected";
    /**
     * @description The permissions policy that controls the actions that are allowed to run.
     * @enum {string}
     */
    "allowed-actions": "all" | "local_only" | "selected";
    /** @description The API URL to use to get or set the actions that are allowed to run, when `allowed_actions` is set to `selected`. */
    "selected-actions-url": string;
    "actions-enterprise-permissions": {
      enabled_organizations: components["schemas"]["enabled-organizations"];
      /** @description The API URL to use to get or set the selected organizations that are allowed to run GitHub Actions, when `enabled_organizations` is set to `selected`. */
      selected_organizations_url?: string;
      allowed_actions?: components["schemas"]["allowed-actions"];
      selected_actions_url?: components["schemas"]["selected-actions-url"];
    };
    "selected-actions": {
      /** @description Whether GitHub-owned actions are allowed. For example, this includes the actions in the `actions` organization. */
      github_owned_allowed: boolean;
      /** @description Specifies a list of string-matching patterns to allow specific action(s). Wildcards, tags, and SHAs are allowed. For example, `monalisa/octocat@*`, `monalisa/octocat@v2`, `monalisa/*`. */
      patterns_allowed: string[];
    };
    /**
     * @description The default workflow permissions granted to the GITHUB_TOKEN when running workflows.
     * @enum {string}
     */
    "actions-default-workflow-permissions": "read" | "write";
    /** @description Whether GitHub Actions can approve pull requests. Enabling this can be a security risk. */
    "actions-can-approve-pull-request-reviews": boolean;
    "actions-get-default-workflow-permissions": {
      default_workflow_permissions: components["schemas"]["actions-default-workflow-permissions"];
      can_approve_pull_request_reviews: components["schemas"]["actions-can-approve-pull-request-reviews"];
    };
    "actions-set-default-workflow-permissions": {
      default_workflow_permissions?: components["schemas"]["actions-default-workflow-permissions"];
      can_approve_pull_request_reviews?: components["schemas"]["actions-can-approve-pull-request-reviews"];
    };
    "runner-groups-enterprise": {
      id: number;
      name: string;
      visibility: string;
      default: boolean;
      selected_organizations_url?: string;
      runners_url: string;
      allows_public_repositories: boolean;
      /**
       * @description If `true`, the `restricted_to_workflows` and `selected_workflows` fields cannot be modified.
       * @default false
       */
      workflow_restrictions_read_only?: boolean;
      /**
       * @description If `true`, the runner group will be restricted to running only the workflows specified in the `selected_workflows` array.
       * @default false
       */
      restricted_to_workflows?: boolean;
      /** @description List of workflows the runner group should be allowed to run. This setting will be ignored unless `restricted_to_workflows` is set to `true`. */
      selected_workflows?: string[];
    };
    /**
     * Self hosted runner label
     * @description A label for a self hosted runner
     */
    "runner-label": {
      /** @description Unique identifier of the label. */
      id?: number;
      /** @description Name of the label. */
      name: string;
      /**
       * @description The type of label. Read-only labels are applied automatically when the runner is configured.
       * @enum {string}
       */
      type?: "read-only" | "custom";
    };
    /**
     * Self hosted runners
     * @description A self hosted runner
     */
    runner: {
      /**
       * @description The id of the runner.
       * @example 5
       */
      id: number;
      /**
       * @description The id of the runner group.
       * @example 1
       */
      runner_group_id?: number;
      /**
       * @description The name of the runner.
       * @example iMac
       */
      name: string;
      /**
       * @description The Operating System of the runner.
       * @example macos
       */
      os: string;
      /**
       * @description The status of the runner.
       * @example online
       */
      status: string;
      busy: boolean;
      labels: components["schemas"]["runner-label"][];
    };
    /**
     * Runner Application
     * @description Runner Application
     */
    "runner-application": {
      os: string;
      architecture: string;
      download_url: string;
      filename: string;
      /** @description A short lived bearer token used to download the runner, if needed. */
      temp_download_token?: string;
      sha256_checksum?: string;
    };
    /**
     * Authentication Token
     * @description Authentication Token
     */
    "authentication-token": {
      /**
       * @description The token used for authentication
       * @example v1.1f699f1069f60xxx
       */
      token: string;
      /**
       * Format: date-time
       * @description The time this token expires
       * @example 2016-07-11T22:14:10Z
       */
      expires_at: string;
      /**
       * @example {
       *   "issues": "read",
       *   "deployments": "write"
       * }
       */
      permissions?: Record<string, never>;
      /** @description The repositories this token has access to */
      repositories?: components["schemas"]["repository"][];
      /** @example config.yaml */
      single_file?: string | null;
      /**
       * @description Describe whether all repositories have been selected or there's a selection involved
       * @enum {string}
       */
      repository_selection?: "all" | "selected";
    };
    "audit-log-event": {
      /** @description The time the audit log event occurred, given as a [Unix timestamp](http://en.wikipedia.org/wiki/Unix_time). */
      "@timestamp"?: number;
      /** @description The name of the action that was performed, for example `user.login` or `repo.create`. */
      action?: string;
      active?: boolean;
      active_was?: boolean;
      /** @description The actor who performed the action. */
      actor?: string;
      /** @description The id of the actor who performed the action. */
      actor_id?: number;
      actor_location?: {
        country_name?: string;
      };
      data?: {
        [key: string]: unknown;
      };
      org_id?: number;
      user_id?: number;
      business_id?: number;
      /** @description The username of the account being blocked. */
      blocked_user?: string;
      business?: string;
      config?: Record<string, never>[];
      config_was?: Record<string, never>[];
      content_type?: string;
      operation_type?: string;
      /** @description The time the audit log event was recorded, given as a [Unix timestamp](http://en.wikipedia.org/wiki/Unix_time). */
      created_at?: number;
      deploy_key_fingerprint?: string;
      /** @description A unique identifier for an audit event. */
      _document_id?: string;
      emoji?: string;
      events?: Record<string, never>[];
      events_were?: Record<string, never>[];
      explanation?: string;
      fingerprint?: string;
      hook_id?: number;
      limited_availability?: boolean;
      message?: string;
      name?: string;
      old_user?: string;
      openssh_public_key?: string;
      org?: string;
      previous_visibility?: string;
      read_only?: boolean;
      /** @description The name of the repository. */
      repo?: string;
      /** @description The name of the repository. */
      repository?: string;
      repository_public?: boolean;
      target_login?: string;
      team?: string;
      /** @description The type of protocol (for example, HTTP or SSH) used to transfer Git data. */
      transport_protocol?: number;
      /** @description A human readable name for the protocol (for example, HTTP or SSH) used to transfer Git data. */
      transport_protocol_name?: string;
      /** @description The user that was affected by the action performed (if available). */
      user?: string;
      /** @description The repository visibility, for example `public` or `private`. */
      visibility?: string;
    };
    /** @description The name of the tool used to generate the code scanning analysis. */
    "code-scanning-analysis-tool-name": string;
    /** @description The GUID of the tool used to generate the code scanning analysis, if provided in the uploaded SARIF data. */
    "code-scanning-analysis-tool-guid": string | null;
    /**
     * @description State of a code scanning alert.
     * @enum {string}
     */
    "code-scanning-alert-state-query":
      | "open"
      | "closed"
      | "dismissed"
      | "fixed";
    /** @description The security alert number. */
    readonly "alert-number": number;
    /**
     * Format: date-time
     * @description The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    readonly "alert-created-at": string;
    /**
     * Format: date-time
     * @description The time that the alert was last updated in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    readonly "alert-updated-at": string;
    /**
     * Format: uri
     * @description The REST API URL of the alert resource.
     */
    readonly "alert-url": string;
    /**
     * Format: uri
     * @description The GitHub URL of the alert resource.
     */
    readonly "alert-html-url": string;
    /**
     * Format: uri
     * @description The REST API URL for fetching the list of instances for an alert.
     */
    readonly "alert-instances-url": string;
    /**
     * @description State of a code scanning alert.
     * @enum {string}
     */
    "code-scanning-alert-state": "open" | "dismissed" | "fixed";
    /**
     * Format: date-time
     * @description The time that the alert was no longer detected and was considered fixed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    readonly "alert-fixed-at": string | null;
    /**
     * Format: date-time
     * @description The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    readonly "alert-dismissed-at": string | null;
    /**
     * @description **Required when the state is dismissed.** The reason for dismissing or closing the alert.
     * @enum {string|null}
     */
    "code-scanning-alert-dismissed-reason":
      | null
      | "false positive"
      | "won't fix"
      | "used in tests";
    /** @description The dismissal comment associated with the dismissal of the alert. */
    "code-scanning-alert-dismissed-comment": string | null;
    "code-scanning-alert-rule-summary": {
      /** @description A unique identifier for the rule used to detect the alert. */
      id?: string | null;
      /** @description The name of the rule used to detect the alert. */
      name?: string;
      /** @description A set of tags applicable for the rule. */
      tags?: string[] | null;
      /**
       * @description The severity of the alert.
       * @enum {string|null}
       */
      severity?: "none" | "note" | "warning" | "error" | null;
      /**
       * @description The security severity of the alert.
       * @enum {string|null}
       */
      security_severity_level?: "low" | "medium" | "high" | "critical" | null;
      /** @description A short description of the rule used to detect the alert. */
      description?: string;
    };
    /** @description The version of the tool used to generate the code scanning analysis. */
    "code-scanning-analysis-tool-version": string | null;
    "code-scanning-analysis-tool": {
      name?: components["schemas"]["code-scanning-analysis-tool-name"];
      version?: components["schemas"]["code-scanning-analysis-tool-version"];
      guid?: components["schemas"]["code-scanning-analysis-tool-guid"];
    };
    /**
     * @description The Git reference, formatted as `refs/pull/<number>/merge`, `refs/pull/<number>/head`,
     * `refs/heads/<branch name>` or simply `<branch name>`.
     */
    "code-scanning-ref": string;
    /** @description Identifies the configuration under which the analysis was executed. For example, in GitHub Actions this includes the workflow filename and job name. */
    "code-scanning-analysis-analysis-key": string;
    /** @description Identifies the variable values associated with the environment in which the analysis that generated this alert instance was performed, such as the language that was analyzed. */
    "code-scanning-alert-environment": string;
    /** @description Identifies the configuration under which the analysis was executed. Used to distinguish between multiple analyses for the same tool and commit, but performed on different languages or different parts of the code. */
    "code-scanning-analysis-category": string;
    /** @description Describe a region within a file for the alert. */
    "code-scanning-alert-location": {
      path?: string;
      start_line?: number;
      end_line?: number;
      start_column?: number;
      end_column?: number;
    };
    /**
     * @description A classification of the file. For example to identify it as generated.
     * @enum {string|null}
     */
    "code-scanning-alert-classification":
      | "source"
      | "generated"
      | "test"
      | "library"
      | null;
    "code-scanning-alert-instance": {
      ref?: components["schemas"]["code-scanning-ref"];
      analysis_key?: components["schemas"]["code-scanning-analysis-analysis-key"];
      environment?: components["schemas"]["code-scanning-alert-environment"];
      category?: components["schemas"]["code-scanning-analysis-category"];
      state?: components["schemas"]["code-scanning-alert-state"];
      commit_sha?: string;
      message?: {
        text?: string;
      };
      location?: components["schemas"]["code-scanning-alert-location"];
      html_url?: string;
      /**
       * @description Classifications that have been applied to the file that triggered the alert.
       * For example identifying it as documentation, or a generated file.
       */
      classifications?: components["schemas"]["code-scanning-alert-classification"][];
    };
    /**
     * Simple Repository
     * @description A GitHub repository.
     */
    "simple-repository": {
      /**
       * @description A unique identifier of the repository.
       * @example 1296269
       */
      id: number;
      /**
       * @description The GraphQL identifier of the repository.
       * @example MDEwOlJlcG9zaXRvcnkxMjk2MjY5
       */
      node_id: string;
      /**
       * @description The name of the repository.
       * @example Hello-World
       */
      name: string;
      /**
       * @description The full, globally unique, name of the repository.
       * @example octocat/Hello-World
       */
      full_name: string;
      owner: components["schemas"]["simple-user"];
      /** @description Whether the repository is private. */
      private: boolean;
      /**
       * Format: uri
       * @description The URL to view the repository on GitHub.com.
       * @example https://github.com/octocat/Hello-World
       */
      html_url: string;
      /**
       * @description The repository description.
       * @example This your first repo!
       */
      description: string | null;
      /** @description Whether the repository is a fork. */
      fork: boolean;
      /**
       * Format: uri
       * @description The URL to get more information about the repository from the GitHub API.
       * @example https://api.github.com/repos/octocat/Hello-World
       */
      url: string;
      /**
       * @description A template for the API URL to download the repository as an archive.
       * @example https://api.github.com/repos/octocat/Hello-World/{archive_format}{/ref}
       */
      archive_url: string;
      /**
       * @description A template for the API URL to list the available assignees for issues in the repository.
       * @example https://api.github.com/repos/octocat/Hello-World/assignees{/user}
       */
      assignees_url: string;
      /**
       * @description A template for the API URL to create or retrieve a raw Git blob in the repository.
       * @example https://api.github.com/repos/octocat/Hello-World/git/blobs{/sha}
       */
      blobs_url: string;
      /**
       * @description A template for the API URL to get information about branches in the repository.
       * @example https://api.github.com/repos/octocat/Hello-World/branches{/branch}
       */
      branches_url: string;
      /**
       * @description A template for the API URL to get information about collaborators of the repository.
       * @example https://api.github.com/repos/octocat/Hello-World/collaborators{/collaborator}
       */
      collaborators_url: string;
      /**
       * @description A template for the API URL to get information about comments on the repository.
       * @example https://api.github.com/repos/octocat/Hello-World/comments{/number}
       */
      comments_url: string;
      /**
       * @description A template for the API URL to get information about commits on the repository.
       * @example https://api.github.com/repos/octocat/Hello-World/commits{/sha}
       */
      commits_url: string;
      /**
       * @description A template for the API URL to compare two commits or refs.
       * @example https://api.github.com/repos/octocat/Hello-World/compare/{base}...{head}
       */
      compare_url: string;
      /**
       * @description A template for the API URL to get the contents of the repository.
       * @example https://api.github.com/repos/octocat/Hello-World/contents/{+path}
       */
      contents_url: string;
      /**
       * Format: uri
       * @description A template for the API URL to list the contributors to the repository.
       * @example https://api.github.com/repos/octocat/Hello-World/contributors
       */
      contributors_url: string;
      /**
       * Format: uri
       * @description The API URL to list the deployments of the repository.
       * @example https://api.github.com/repos/octocat/Hello-World/deployments
       */
      deployments_url: string;
      /**
       * Format: uri
       * @description The API URL to list the downloads on the repository.
       * @example https://api.github.com/repos/octocat/Hello-World/downloads
       */
      downloads_url: string;
      /**
       * Format: uri
       * @description The API URL to list the events of the repository.
       * @example https://api.github.com/repos/octocat/Hello-World/events
       */
      events_url: string;
      /**
       * Format: uri
       * @description The API URL to list the forks of the repository.
       * @example https://api.github.com/repos/octocat/Hello-World/forks
       */
      forks_url: string;
      /**
       * @description A template for the API URL to get information about Git commits of the repository.
       * @example https://api.github.com/repos/octocat/Hello-World/git/commits{/sha}
       */
      git_commits_url: string;
      /**
       * @description A template for the API URL to get information about Git refs of the repository.
       * @example https://api.github.com/repos/octocat/Hello-World/git/refs{/sha}
       */
      git_refs_url: string;
      /**
       * @description A template for the API URL to get information about Git tags of the repository.
       * @example https://api.github.com/repos/octocat/Hello-World/git/tags{/sha}
       */
      git_tags_url: string;
      /**
       * @description A template for the API URL to get information about issue comments on the repository.
       * @example https://api.github.com/repos/octocat/Hello-World/issues/comments{/number}
       */
      issue_comment_url: string;
      /**
       * @description A template for the API URL to get information about issue events on the repository.
       * @example https://api.github.com/repos/octocat/Hello-World/issues/events{/number}
       */
      issue_events_url: string;
      /**
       * @description A template for the API URL to get information about issues on the repository.
       * @example https://api.github.com/repos/octocat/Hello-World/issues{/number}
       */
      issues_url: string;
      /**
       * @description A template for the API URL to get information about deploy keys on the repository.
       * @example https://api.github.com/repos/octocat/Hello-World/keys{/key_id}
       */
      keys_url: string;
      /**
       * @description A template for the API URL to get information about labels of the repository.
       * @example https://api.github.com/repos/octocat/Hello-World/labels{/name}
       */
      labels_url: string;
      /**
       * Format: uri
       * @description The API URL to get information about the languages of the repository.
       * @example https://api.github.com/repos/octocat/Hello-World/languages
       */
      languages_url: string;
      /**
       * Format: uri
       * @description The API URL to merge branches in the repository.
       * @example https://api.github.com/repos/octocat/Hello-World/merges
       */
      merges_url: string;
      /**
       * @description A template for the API URL to get information about milestones of the repository.
       * @example https://api.github.com/repos/octocat/Hello-World/milestones{/number}
       */
      milestones_url: string;
      /**
       * @description A template for the API URL to get information about notifications on the repository.
       * @example https://api.github.com/repos/octocat/Hello-World/notifications{?since,all,participating}
       */
      notifications_url: string;
      /**
       * @description A template for the API URL to get information about pull requests on the repository.
       * @example https://api.github.com/repos/octocat/Hello-World/pulls{/number}
       */
      pulls_url: string;
      /**
       * @description A template for the API URL to get information about releases on the repository.
       * @example https://api.github.com/repos/octocat/Hello-World/releases{/id}
       */
      releases_url: string;
      /**
       * Format: uri
       * @description The API URL to list the stargazers on the repository.
       * @example https://api.github.com/repos/octocat/Hello-World/stargazers
       */
      stargazers_url: string;
      /**
       * @description A template for the API URL to get information about statuses of a commit.
       * @example https://api.github.com/repos/octocat/Hello-World/statuses/{sha}
       */
      statuses_url: string;
      /**
       * Format: uri
       * @description The API URL to list the subscribers on the repository.
       * @example https://api.github.com/repos/octocat/Hello-World/subscribers
       */
      subscribers_url: string;
      /**
       * Format: uri
       * @description The API URL to subscribe to notifications for this repository.
       * @example https://api.github.com/repos/octocat/Hello-World/subscription
       */
      subscription_url: string;
      /**
       * Format: uri
       * @description The API URL to get information about tags on the repository.
       * @example https://api.github.com/repos/octocat/Hello-World/tags
       */
      tags_url: string;
      /**
       * Format: uri
       * @description The API URL to list the teams on the repository.
       * @example https://api.github.com/repos/octocat/Hello-World/teams
       */
      teams_url: string;
      /**
       * @description A template for the API URL to create or retrieve a raw Git tree of the repository.
       * @example https://api.github.com/repos/octocat/Hello-World/git/trees{/sha}
       */
      trees_url: string;
      /**
       * Format: uri
       * @description The API URL to list the hooks on the repository.
       * @example https://api.github.com/repos/octocat/Hello-World/hooks
       */
      hooks_url: string;
    };
    "code-scanning-organization-alert-items": {
      number: components["schemas"]["alert-number"];
      created_at: components["schemas"]["alert-created-at"];
      updated_at?: components["schemas"]["alert-updated-at"];
      url: components["schemas"]["alert-url"];
      html_url: components["schemas"]["alert-html-url"];
      instances_url: components["schemas"]["alert-instances-url"];
      state: components["schemas"]["code-scanning-alert-state"];
      fixed_at?: components["schemas"]["alert-fixed-at"];
      dismissed_by: components["schemas"]["nullable-simple-user"];
      dismissed_at: components["schemas"]["alert-dismissed-at"];
      dismissed_reason: components["schemas"]["code-scanning-alert-dismissed-reason"];
      dismissed_comment?: components["schemas"]["code-scanning-alert-dismissed-comment"];
      rule: components["schemas"]["code-scanning-alert-rule-summary"];
      tool: components["schemas"]["code-scanning-analysis-tool"];
      most_recent_instance: components["schemas"]["code-scanning-alert-instance"];
      repository: components["schemas"]["simple-repository"];
    };
    /** Enterprise Security Analysis Settings */
    "enterprise-security-analysis-settings": {
      /**
       * @description Whether GitHub advanced security is automatically enabled for new repositories and repositories transferred to
       * this enterprise.
       * @example false
       */
      advanced_security_enabled_for_new_repositories: boolean;
      /**
       * @description Whether Dependabot alerts are automatically enabled for new repositories and repositories transferred to this
       * enterprise.
       * @example false
       */
      dependabot_alerts_enabled_for_new_repositories: boolean;
      /**
       * @description Whether secret scanning is automatically enabled for new repositories and repositories transferred to this
       * enterprise.
       * @example false
       */
      secret_scanning_enabled_for_new_repositories: boolean;
      /**
       * @description Whether secret scanning push protection is automatically enabled for new repositories and repositories
       * transferred to this enterprise.
       * @example false
       */
      secret_scanning_push_protection_enabled_for_new_repositories: boolean;
      /**
       * @description An optional URL string to display to contributors who are blocked from pushing a secret.
       * @example https://github.com/test-org/test-repo/blob/main/README.md
       */
      secret_scanning_push_protection_custom_link?: string | null;
    };
    /** @description Details for the vulnerable package. */
    readonly "dependabot-alert-package": {
      /** @description The package's language or package management ecosystem. */
      readonly ecosystem: string;
      /** @description The unique package name within its ecosystem. */
      readonly name: string;
    };
    /** @description Details pertaining to one vulnerable version range for the advisory. */
    readonly "dependabot-alert-security-vulnerability": {
      readonly package: components["schemas"]["dependabot-alert-package"];
      /**
       * @description The severity of the vulnerability.
       * @enum {string}
       */
      readonly severity: "low" | "medium" | "high" | "critical";
      /** @description Conditions that identify vulnerable versions of this vulnerability's package. */
      readonly vulnerable_version_range: string;
      /** @description Details pertaining to the package version that patches this vulnerability. */
      readonly first_patched_version: {
        /** @description The package version that patches this vulnerability. */
        readonly identifier: string;
      } | null;
    };
    /** @description Details for the GitHub Security Advisory. */
    readonly "dependabot-alert-security-advisory": {
      /** @description The unique GitHub Security Advisory ID assigned to the advisory. */
      readonly ghsa_id: string;
      /** @description The unique CVE ID assigned to the advisory. */
      readonly cve_id: string | null;
      /** @description A short, plain text summary of the advisory. */
      readonly summary: string;
      /** @description A long-form Markdown-supported description of the advisory. */
      readonly description: string;
      /** @description Vulnerable version range information for the advisory. */
      readonly vulnerabilities: readonly components["schemas"]["dependabot-alert-security-vulnerability"][];
      /**
       * @description The severity of the advisory.
       * @enum {string}
       */
      readonly severity: "low" | "medium" | "high" | "critical";
      /** @description Details for the advisory pertaining to the Common Vulnerability Scoring System. */
      readonly cvss: {
        /** @description The overall CVSS score of the advisory. */
        readonly score: number;
        /** @description The full CVSS vector string for the advisory. */
        readonly vector_string: string | null;
      };
      /** @description Details for the advisory pertaining to Common Weakness Enumeration. */
      readonly cwes: readonly {
        /** @description The unique CWE ID. */
        readonly cwe_id: string;
        /** @description The short, plain text name of the CWE. */
        readonly name: string;
      }[];
      /** @description Values that identify this advisory among security information sources. */
      readonly identifiers: readonly {
        /**
         * @description The type of advisory identifier.
         * @enum {string}
         */
        readonly type: "CVE" | "GHSA";
        /** @description The value of the advisory identifer. */
        readonly value: string;
      }[];
      /** @description Links to additional advisory information. */
      readonly references: readonly {
        /**
         * Format: uri
         * @description The URL of the reference.
         */
        readonly url: string;
      }[];
      /**
       * Format: date-time
       * @description The time that the advisory was published in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
       */
      readonly published_at: string;
      /**
       * Format: date-time
       * @description The time that the advisory was last modified in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
       */
      readonly updated_at: string;
      /**
       * Format: date-time
       * @description The time that the advisory was withdrawn in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
       */
      readonly withdrawn_at: string | null;
    };
    /**
     * Format: date-time
     * @description The time that the alert was auto-dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    readonly "alert-auto-dismissed-at": string | null;
    /** @description A Dependabot alert. */
    "dependabot-alert-with-repository": {
      number: components["schemas"]["alert-number"];
      /**
       * @description The state of the Dependabot alert.
       * @enum {string}
       */
      state: "auto_dismissed" | "dismissed" | "fixed" | "open";
      /** @description Details for the vulnerable dependency. */
      dependency: {
        readonly package?: components["schemas"]["dependabot-alert-package"];
        /** @description The full path to the dependency manifest file, relative to the root of the repository. */
        readonly manifest_path?: string;
        /**
         * @description The execution scope of the vulnerable dependency.
         * @enum {string|null}
         */
        readonly scope?: "development" | "runtime" | null;
      };
      security_advisory: components["schemas"]["dependabot-alert-security-advisory"];
      security_vulnerability: components["schemas"]["dependabot-alert-security-vulnerability"];
      url: components["schemas"]["alert-url"];
      html_url: components["schemas"]["alert-html-url"];
      created_at: components["schemas"]["alert-created-at"];
      updated_at: components["schemas"]["alert-updated-at"];
      dismissed_at: components["schemas"]["alert-dismissed-at"];
      dismissed_by: components["schemas"]["nullable-simple-user"];
      /**
       * @description The reason that the alert was dismissed.
       * @enum {string|null}
       */
      dismissed_reason:
        | "fix_started"
        | "inaccurate"
        | "no_bandwidth"
        | "not_used"
        | "tolerable_risk"
        | null;
      /** @description An optional comment associated with the alert's dismissal. */
      dismissed_comment: string | null;
      fixed_at: components["schemas"]["alert-fixed-at"];
      auto_dismissed_at?: components["schemas"]["alert-auto-dismissed-at"];
      repository: components["schemas"]["simple-repository"];
    };
    /**
     * Format: date-time
     * @description The time that the alert was last updated in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    readonly "nullable-alert-updated-at": string | null;
    /**
     * @description Sets the state of the secret scanning alert. You must provide `resolution` when you set the state to `resolved`.
     * @enum {string}
     */
    "secret-scanning-alert-state": "open" | "resolved";
    /**
     * @description **Required when the `state` is `resolved`.** The reason for resolving the alert.
     * @enum {string|null}
     */
    "secret-scanning-alert-resolution":
      | "false_positive"
      | "wont_fix"
      | "revoked"
      | "used_in_tests"
      | null;
    "organization-secret-scanning-alert": {
      number?: components["schemas"]["alert-number"];
      created_at?: components["schemas"]["alert-created-at"];
      updated_at?: components["schemas"]["nullable-alert-updated-at"];
      url?: components["schemas"]["alert-url"];
      html_url?: components["schemas"]["alert-html-url"];
      /**
       * Format: uri
       * @description The REST API URL of the code locations for this alert.
       */
      locations_url?: string;
      state?: components["schemas"]["secret-scanning-alert-state"];
      resolution?: components["schemas"]["secret-scanning-alert-resolution"];
      /**
       * Format: date-time
       * @description The time that the alert was resolved in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
       */
      resolved_at?: string | null;
      resolved_by?: components["schemas"]["nullable-simple-user"];
      /** @description The type of secret that secret scanning detected. */
      secret_type?: string;
      /**
       * @description User-friendly name for the detected secret, matching the `secret_type`.
       * For a list of built-in patterns, see "[Secret scanning patterns](https://docs.github.com/enterprise-server@3.10/code-security/secret-scanning/secret-scanning-patterns#supported-secrets-for-advanced-security)."
       */
      secret_type_display_name?: string;
      /** @description The secret that was detected. */
      secret?: string;
      repository?: components["schemas"]["simple-repository"];
      /** @description Whether push protection was bypassed for the detected secret. */
      push_protection_bypassed?: boolean | null;
      push_protection_bypassed_by?: components["schemas"]["nullable-simple-user"];
      /**
       * Format: date-time
       * @description The time that push protection was bypassed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
       */
      push_protection_bypassed_at?: string | null;
      /** @description The comment that was optionally added when this alert was closed */
      resolution_comment?: string | null;
    };
    "advanced-security-active-committers-user": {
      user_login: string;
      /** @example 2021-11-03 */
      last_pushed_date: string;
    };
    "advanced-security-active-committers-repository": {
      /** @example octocat/Hello-World */
      name: string;
      /** @example 25 */
      advanced_security_committers: number;
      advanced_security_committers_breakdown: components["schemas"]["advanced-security-active-committers-user"][];
    };
    "advanced-security-active-committers": {
      /** @example 25 */
      total_advanced_security_committers?: number;
      /** @example 2 */
      total_count?: number;
      repositories: components["schemas"]["advanced-security-active-committers-repository"][];
    };
    /**
     * Actor
     * @description Actor
     */
    actor: {
      id: number;
      login: string;
      display_login?: string;
      gravatar_id: string | null;
      /** Format: uri */
      url: string;
      /** Format: uri */
      avatar_url: string;
    };
    /**
     * Milestone
     * @description A collection of related issues and pull requests.
     */
    "nullable-milestone": {
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/Hello-World/milestones/1
       */
      url: string;
      /**
       * Format: uri
       * @example https://github.com/octocat/Hello-World/milestones/v1.0
       */
      html_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/Hello-World/milestones/1/labels
       */
      labels_url: string;
      /** @example 1002604 */
      id: number;
      /** @example MDk6TWlsZXN0b25lMTAwMjYwNA== */
      node_id: string;
      /**
       * @description The number of the milestone.
       * @example 42
       */
      number: number;
      /**
       * @description The state of the milestone.
       * @default open
       * @example open
       * @enum {string}
       */
      state: "open" | "closed";
      /**
       * @description The title of the milestone.
       * @example v1.0
       */
      title: string;
      /** @example Tracking milestone for version 1.0 */
      description: string | null;
      creator: components["schemas"]["nullable-simple-user"];
      /** @example 4 */
      open_issues: number;
      /** @example 8 */
      closed_issues: number;
      /**
       * Format: date-time
       * @example 2011-04-10T20:09:31Z
       */
      created_at: string;
      /**
       * Format: date-time
       * @example 2014-03-03T18:58:10Z
       */
      updated_at: string;
      /**
       * Format: date-time
       * @example 2013-02-12T13:22:01Z
       */
      closed_at: string | null;
      /**
       * Format: date-time
       * @example 2012-10-09T23:39:01Z
       */
      due_on: string | null;
    } | null;
    /**
     * GitHub app
     * @description GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
     */
    "nullable-integration": {
      /**
       * @description Unique identifier of the GitHub app
       * @example 37
       */
      id: number;
      /**
       * @description The slug name of the GitHub app
       * @example probot-owners
       */
      slug?: string;
      /** @example MDExOkludGVncmF0aW9uMQ== */
      node_id: string;
      owner: components["schemas"]["nullable-simple-user"];
      /**
       * @description The name of the GitHub app
       * @example Probot Owners
       */
      name: string;
      /** @example The description of the app. */
      description: string | null;
      /**
       * Format: uri
       * @example https://example.com
       */
      external_url: string;
      /**
       * Format: uri
       * @example https://github.com/apps/super-ci
       */
      html_url: string;
      /**
       * Format: date-time
       * @example 2017-07-08T16:18:44-04:00
       */
      created_at: string;
      /**
       * Format: date-time
       * @example 2017-07-08T16:18:44-04:00
       */
      updated_at: string;
      /**
       * @description The set of permissions for the GitHub app
       * @example {
       *   "issues": "read",
       *   "deployments": "write"
       * }
       */
      permissions: {
        issues?: string;
        checks?: string;
        metadata?: string;
        contents?: string;
        deployments?: string;
        [key: string]: string | undefined;
      };
      /**
       * @description The list of events for the GitHub app
       * @example [
       *   "label",
       *   "deployment"
       * ]
       */
      events: string[];
      /**
       * @description The number of installations associated with the GitHub app
       * @example 5
       */
      installations_count?: number;
      /** @example "Iv1.25b5d1e65ffc4022" */
      client_id?: string;
      /** @example "1d4b2097ac622ba702d19de498f005747a8b21d3" */
      client_secret?: string;
      /** @example "6fba8f2fc8a7e8f2cca5577eddd82ca7586b3b6b" */
      webhook_secret?: string | null;
      /** @example "-----BEGIN RSA PRIVATE KEY-----\nMIIEogIBAAKCAQEArYxrNYD/iT5CZVpRJu4rBKmmze3PVmT/gCo2ATUvDvZTPTey\nxcGJ3vvrJXazKk06pN05TN29o98jrYz4cengG3YGsXPNEpKsIrEl8NhbnxapEnM9\nJCMRe0P5JcPsfZlX6hmiT7136GRWiGOUba2X9+HKh8QJVLG5rM007TBER9/z9mWm\nrJuNh+m5l320oBQY/Qq3A7wzdEfZw8qm/mIN0FCeoXH1L6B8xXWaAYBwhTEh6SSn\nZHlO1Xu1JWDmAvBCi0RO5aRSKM8q9QEkvvHP4yweAtK3N8+aAbZ7ovaDhyGz8r6r\nzhU1b8Uo0Z2ysf503WqzQgIajr7Fry7/kUwpgQIDAQABAoIBADwJp80Ko1xHPZDy\nfcCKBDfIuPvkmSW6KumbsLMaQv1aGdHDwwTGv3t0ixSay8CGlxMRtRDyZPib6SvQ\n6OH/lpfpbMdW2ErkksgtoIKBVrDilfrcAvrNZu7NxRNbhCSvN8q0s4ICecjbbVQh\nnueSdlA6vGXbW58BHMq68uRbHkP+k+mM9U0mDJ1HMch67wlg5GbayVRt63H7R2+r\nVxcna7B80J/lCEjIYZznawgiTvp3MSanTglqAYi+m1EcSsP14bJIB9vgaxS79kTu\noiSo93leJbBvuGo8QEiUqTwMw4tDksmkLsoqNKQ1q9P7LZ9DGcujtPy4EZsamSJT\ny8OJt0ECgYEA2lxOxJsQk2kI325JgKFjo92mQeUObIvPfSNWUIZQDTjniOI6Gv63\nGLWVFrZcvQBWjMEQraJA9xjPbblV8PtfO87MiJGLWCHFxmPz2dzoedN+2Coxom8m\nV95CLz8QUShuao6u/RYcvUaZEoYs5bHcTmy5sBK80JyEmafJPtCQVxMCgYEAy3ar\nZr3yv4xRPEPMat4rseswmuMooSaK3SKub19WFI5IAtB/e7qR1Rj9JhOGcZz+OQrl\nT78O2OFYlgOIkJPvRMrPpK5V9lslc7tz1FSh3BZMRGq5jSyD7ETSOQ0c8T2O/s7v\nbeEPbVbDe4mwvM24XByH0GnWveVxaDl51ABD65sCgYB3ZAspUkOA5egVCh8kNpnd\nSd6SnuQBE3ySRlT2WEnCwP9Ph6oPgn+oAfiPX4xbRqkL8q/k0BdHQ4h+zNwhk7+h\nWtPYRAP1Xxnc/F+jGjb+DVaIaKGU18MWPg7f+FI6nampl3Q0KvfxwX0GdNhtio8T\nTj1E+SnFwh56SRQuxSh2gwKBgHKjlIO5NtNSflsUYFM+hyQiPiqnHzddfhSG+/3o\nm5nNaSmczJesUYreH5San7/YEy2UxAugvP7aSY2MxB+iGsiJ9WD2kZzTUlDZJ7RV\nUzWsoqBR+eZfVJ2FUWWvy8TpSG6trh4dFxImNtKejCR1TREpSiTV3Zb1dmahK9GV\nrK9NAoGAbBxRLoC01xfxCTgt5BDiBcFVh4fp5yYKwavJPLzHSpuDOrrI9jDn1oKN\nonq5sDU1i391zfQvdrbX4Ova48BN+B7p63FocP/MK5tyyBoT8zQEk2+vWDOw7H/Z\nu5dTCPxTIsoIwUw1I+7yIxqJzLPFgR2gVBwY1ra/8iAqCj+zeBw=\n-----END RSA PRIVATE KEY-----\n" */
      pem?: string;
    } | null;
    /**
     * author_association
     * @description How the author is associated with the repository.
     * @example OWNER
     * @enum {string}
     */
    "author-association":
      | "COLLABORATOR"
      | "CONTRIBUTOR"
      | "FIRST_TIMER"
      | "FIRST_TIME_CONTRIBUTOR"
      | "MANNEQUIN"
      | "MEMBER"
      | "NONE"
      | "OWNER";
    /** Reaction Rollup */
    "reaction-rollup": {
      /** Format: uri */
      url: string;
      total_count: number;
      "+1": number;
      "-1": number;
      laugh: number;
      confused: number;
      heart: number;
      hooray: number;
      eyes: number;
      rocket: number;
    };
    /**
     * Issue
     * @description Issues are a great way to keep track of tasks, enhancements, and bugs for your projects.
     */
    issue: {
      /** Format: int64 */
      id: number;
      node_id: string;
      /**
       * Format: uri
       * @description URL for the issue
       * @example https://api.github.com/repositories/42/issues/1
       */
      url: string;
      /** Format: uri */
      repository_url: string;
      labels_url: string;
      /** Format: uri */
      comments_url: string;
      /** Format: uri */
      events_url: string;
      /** Format: uri */
      html_url: string;
      /**
       * @description Number uniquely identifying the issue within its repository
       * @example 42
       */
      number: number;
      /**
       * @description State of the issue; either 'open' or 'closed'
       * @example open
       */
      state: string;
      /**
       * @description The reason for the current state
       * @example not_planned
       * @enum {string|null}
       */
      state_reason?: "completed" | "reopened" | "not_planned" | null;
      /**
       * @description Title of the issue
       * @example Widget creation fails in Safari on OS X 10.8
       */
      title: string;
      /**
       * @description Contents of the issue
       * @example It looks like the new widget form is broken on Safari. When I try and create the widget, Safari crashes. This is reproducible on 10.8, but not 10.9. Maybe a browser bug?
       */
      body?: string | null;
      user: components["schemas"]["nullable-simple-user"];
      /**
       * @description Labels to associate with this issue; pass one or more label names to replace the set of labels on this issue; send an empty array to clear all labels from the issue; note that the labels are silently dropped for users without push access to the repository
       * @example [
       *   "bug",
       *   "registration"
       * ]
       */
      labels: OneOf<
        [
          string,
          {
            /** Format: int64 */
            id?: number;
            node_id?: string;
            /** Format: uri */
            url?: string;
            name?: string;
            description?: string | null;
            color?: string | null;
            default?: boolean;
          },
        ]
      >[];
      assignee: components["schemas"]["nullable-simple-user"];
      assignees?: components["schemas"]["simple-user"][] | null;
      milestone: components["schemas"]["nullable-milestone"];
      locked: boolean;
      active_lock_reason?: string | null;
      comments: number;
      pull_request?: {
        /** Format: date-time */
        merged_at?: string | null;
        /** Format: uri */
        diff_url: string | null;
        /** Format: uri */
        html_url: string | null;
        /** Format: uri */
        patch_url: string | null;
        /** Format: uri */
        url: string | null;
      };
      /** Format: date-time */
      closed_at: string | null;
      /** Format: date-time */
      created_at: string;
      /** Format: date-time */
      updated_at: string;
      draft?: boolean;
      closed_by?: components["schemas"]["nullable-simple-user"];
      body_html?: string;
      body_text?: string;
      /** Format: uri */
      timeline_url?: string;
      repository?: components["schemas"]["repository"];
      performed_via_github_app?: components["schemas"]["nullable-integration"];
      author_association: components["schemas"]["author-association"];
      reactions?: components["schemas"]["reaction-rollup"];
    };
    /**
     * Issue Comment
     * @description Comments provide a way for people to collaborate on an issue.
     */
    "issue-comment": {
      /**
       * Format: int64
       * @description Unique identifier of the issue comment
       * @example 42
       */
      id: number;
      node_id: string;
      /**
       * Format: uri
       * @description URL for the issue comment
       * @example https://api.github.com/repositories/42/issues/comments/1
       */
      url: string;
      /**
       * @description Contents of the issue comment
       * @example What version of Safari were you using when you observed this bug?
       */
      body?: string;
      body_text?: string;
      body_html?: string;
      /** Format: uri */
      html_url: string;
      user: components["schemas"]["nullable-simple-user"];
      /**
       * Format: date-time
       * @example 2011-04-14T16:00:49Z
       */
      created_at: string;
      /**
       * Format: date-time
       * @example 2011-04-14T16:00:49Z
       */
      updated_at: string;
      /** Format: uri */
      issue_url: string;
      author_association: components["schemas"]["author-association"];
      performed_via_github_app?: components["schemas"]["nullable-integration"];
      reactions?: components["schemas"]["reaction-rollup"];
    };
    /**
     * Event
     * @description Event
     */
    event: {
      id: string;
      type: string | null;
      actor: components["schemas"]["actor"];
      repo: {
        id: number;
        name: string;
        /** Format: uri */
        url: string;
      };
      org?: components["schemas"]["actor"];
      payload: {
        action?: string;
        issue?: components["schemas"]["issue"];
        comment?: components["schemas"]["issue-comment"];
        pages?: {
          page_name?: string;
          title?: string;
          summary?: string | null;
          action?: string;
          sha?: string;
          html_url?: string;
        }[];
      };
      public: boolean;
      /** Format: date-time */
      created_at: string | null;
    };
    /**
     * Link With Type
     * @description Hypermedia Link with Type
     */
    "link-with-type": {
      href: string;
      type: string;
    };
    /**
     * Feed
     * @description Feed
     */
    feed: {
      /** @example https://github.com/timeline */
      timeline_url: string;
      /** @example https://github.com/{user} */
      user_url: string;
      /** @example https://github.com/octocat */
      current_user_public_url?: string;
      /** @example https://github.com/octocat.private?token=abc123 */
      current_user_url?: string;
      /** @example https://github.com/octocat.private.actor?token=abc123 */
      current_user_actor_url?: string;
      /** @example https://github.com/octocat-org */
      current_user_organization_url?: string;
      /**
       * @example [
       *   "https://github.com/organizations/github/octocat.private.atom?token=abc123"
       * ]
       */
      current_user_organization_urls?: string[];
      /** @example https://github.com/security-advisories */
      security_advisories_url?: string;
      /**
       * @description A feed of discussions for a given repository.
       * @example https://github.com/{user}/{repo}/discussions
       */
      repository_discussions_url?: string;
      /**
       * @description A feed of discussions for a given repository and category.
       * @example https://github.com/{user}/{repo}/discussions/categories/{category}
       */
      repository_discussions_category_url?: string;
      _links: {
        timeline: components["schemas"]["link-with-type"];
        user: components["schemas"]["link-with-type"];
        security_advisories?: components["schemas"]["link-with-type"];
        current_user?: components["schemas"]["link-with-type"];
        current_user_public?: components["schemas"]["link-with-type"];
        current_user_actor?: components["schemas"]["link-with-type"];
        current_user_organization?: components["schemas"]["link-with-type"];
        current_user_organizations?: components["schemas"]["link-with-type"][];
        repository_discussions?: components["schemas"]["link-with-type"];
        repository_discussions_category?: components["schemas"]["link-with-type"];
      };
    };
    /**
     * Base Gist
     * @description Base Gist
     */
    "base-gist": {
      /** Format: uri */
      url: string;
      /** Format: uri */
      forks_url: string;
      /** Format: uri */
      commits_url: string;
      id: string;
      node_id: string;
      /** Format: uri */
      git_pull_url: string;
      /** Format: uri */
      git_push_url: string;
      /** Format: uri */
      html_url: string;
      files: {
        [key: string]: {
          filename?: string;
          type?: string;
          language?: string;
          raw_url?: string;
          size?: number;
        };
      };
      public: boolean;
      /** Format: date-time */
      created_at: string;
      /** Format: date-time */
      updated_at: string;
      description: string | null;
      comments: number;
      user: components["schemas"]["nullable-simple-user"];
      /** Format: uri */
      comments_url: string;
      owner?: components["schemas"]["simple-user"];
      truncated?: boolean;
      forks?: unknown[];
      history?: unknown[];
    };
    /**
     * Public User
     * @description Public User
     */
    "public-user": {
      login: string;
      id: number;
      node_id: string;
      /** Format: uri */
      avatar_url: string;
      gravatar_id: string | null;
      /** Format: uri */
      url: string;
      /** Format: uri */
      html_url: string;
      /** Format: uri */
      followers_url: string;
      following_url: string;
      gists_url: string;
      starred_url: string;
      /** Format: uri */
      subscriptions_url: string;
      /** Format: uri */
      organizations_url: string;
      /** Format: uri */
      repos_url: string;
      events_url: string;
      /** Format: uri */
      received_events_url: string;
      type: string;
      site_admin: boolean;
      name: string | null;
      company: string | null;
      blog: string | null;
      location: string | null;
      /** Format: email */
      email: string | null;
      hireable: boolean | null;
      bio: string | null;
      twitter_username?: string | null;
      public_repos: number;
      public_gists: number;
      followers: number;
      following: number;
      /** Format: date-time */
      created_at: string;
      /** Format: date-time */
      updated_at: string;
      plan?: {
        collaborators: number;
        name: string;
        space: number;
        private_repos: number;
      };
      /** Format: date-time */
      suspended_at?: string | null;
      /** @example 1 */
      private_gists?: number;
      /** @example 2 */
      total_private_repos?: number;
      /** @example 2 */
      owned_private_repos?: number;
      /** @example 1 */
      disk_usage?: number;
      /** @example 3 */
      collaborators?: number;
    };
    /**
     * Gist History
     * @description Gist History
     */
    "gist-history": {
      user?: components["schemas"]["nullable-simple-user"];
      version?: string;
      /** Format: date-time */
      committed_at?: string;
      change_status?: {
        total?: number;
        additions?: number;
        deletions?: number;
      };
      /** Format: uri */
      url?: string;
    };
    /**
     * Gist Simple
     * @description Gist Simple
     */
    "gist-simple": {
      /** @deprecated */
      forks?:
        | {
            id?: string;
            /** Format: uri */
            url?: string;
            user?: components["schemas"]["public-user"];
            /** Format: date-time */
            created_at?: string;
            /** Format: date-time */
            updated_at?: string;
          }[]
        | null;
      /** @deprecated */
      history?: components["schemas"]["gist-history"][] | null;
      /**
       * Gist
       * @description Gist
       */
      fork_of?: {
        /** Format: uri */
        url: string;
        /** Format: uri */
        forks_url: string;
        /** Format: uri */
        commits_url: string;
        id: string;
        node_id: string;
        /** Format: uri */
        git_pull_url: string;
        /** Format: uri */
        git_push_url: string;
        /** Format: uri */
        html_url: string;
        files: {
          [key: string]: {
            filename?: string;
            type?: string;
            language?: string;
            raw_url?: string;
            size?: number;
          };
        };
        public: boolean;
        /** Format: date-time */
        created_at: string;
        /** Format: date-time */
        updated_at: string;
        description: string | null;
        comments: number;
        user: components["schemas"]["nullable-simple-user"];
        /** Format: uri */
        comments_url: string;
        owner?: components["schemas"]["nullable-simple-user"];
        truncated?: boolean;
        forks?: unknown[];
        history?: unknown[];
      } | null;
      url?: string;
      forks_url?: string;
      commits_url?: string;
      id?: string;
      node_id?: string;
      git_pull_url?: string;
      git_push_url?: string;
      html_url?: string;
      files?: {
        [key: string]: {
          filename?: string;
          type?: string;
          language?: string;
          raw_url?: string;
          size?: number;
          truncated?: boolean;
          content?: string;
        } | null;
      };
      public?: boolean;
      created_at?: string;
      updated_at?: string;
      description?: string | null;
      comments?: number;
      user?: string | null;
      comments_url?: string;
      owner?: components["schemas"]["simple-user"];
      truncated?: boolean;
    };
    /**
     * Gist Comment
     * @description A comment made to a gist.
     */
    "gist-comment": {
      /** @example 1 */
      id: number;
      /** @example MDExOkdpc3RDb21tZW50MQ== */
      node_id: string;
      /**
       * Format: uri
       * @example https://api.github.com/gists/a6db0bec360bb87e9418/comments/1
       */
      url: string;
      /**
       * @description The comment text.
       * @example Body of the attachment
       */
      body: string;
      user: components["schemas"]["nullable-simple-user"];
      /**
       * Format: date-time
       * @example 2011-04-18T23:23:56Z
       */
      created_at: string;
      /**
       * Format: date-time
       * @example 2011-04-18T23:23:56Z
       */
      updated_at: string;
      author_association: components["schemas"]["author-association"];
    };
    /**
     * Gist Commit
     * @description Gist Commit
     */
    "gist-commit": {
      /**
       * Format: uri
       * @example https://api.github.com/gists/aa5a315d61ae9438b18d/57a7f021a713b1c5a6a199b54cc514735d2d462f
       */
      url: string;
      /** @example 57a7f021a713b1c5a6a199b54cc514735d2d462f */
      version: string;
      user: components["schemas"]["nullable-simple-user"];
      change_status: {
        total?: number;
        additions?: number;
        deletions?: number;
      };
      /**
       * Format: date-time
       * @example 2010-04-14T02:15:15Z
       */
      committed_at: string;
    };
    /**
     * Gitignore Template
     * @description Gitignore Template
     */
    "gitignore-template": {
      /** @example C */
      name: string;
      /**
       * @example # Object files
       * *.o
       *
       * # Libraries
       * *.lib
       * *.a
       *
       * # Shared objects (inc. Windows DLLs)
       * *.dll
       * *.so
       * *.so.*
       * *.dylib
       *
       * # Executables
       * *.exe
       * *.out
       * *.app
       */
      source: string;
    };
    /**
     * License Simple
     * @description License Simple
     */
    "license-simple": {
      /** @example mit */
      key: string;
      /** @example MIT License */
      name: string;
      /**
       * Format: uri
       * @example https://api.github.com/licenses/mit
       */
      url: string | null;
      /** @example MIT */
      spdx_id: string | null;
      /** @example MDc6TGljZW5zZW1pdA== */
      node_id: string;
      /** Format: uri */
      html_url?: string;
    };
    /**
     * License
     * @description License
     */
    license: {
      /** @example mit */
      key: string;
      /** @example MIT License */
      name: string;
      /** @example MIT */
      spdx_id: string | null;
      /**
       * Format: uri
       * @example https://api.github.com/licenses/mit
       */
      url: string | null;
      /** @example MDc6TGljZW5zZW1pdA== */
      node_id: string;
      /**
       * Format: uri
       * @example http://choosealicense.com/licenses/mit/
       */
      html_url: string;
      /** @example A permissive license that is short and to the point. It lets people do anything with your code with proper attribution and without warranty. */
      description: string;
      /** @example Create a text file (typically named LICENSE or LICENSE.txt) in the root of your source code and copy the text of the license into the file. Replace [year] with the current year and [fullname] with the name (or names) of the copyright holders. */
      implementation: string;
      /**
       * @example [
       *   "commercial-use",
       *   "modifications",
       *   "distribution",
       *   "sublicense",
       *   "private-use"
       * ]
       */
      permissions: string[];
      /**
       * @example [
       *   "include-copyright"
       * ]
       */
      conditions: string[];
      /**
       * @example [
       *   "no-liability"
       * ]
       */
      limitations: string[];
      /**
       * @example
       *
       * The MIT License (MIT)
       *
       * Copyright (c) [year] [fullname]
       *
       * Permission is hereby granted, free of charge, to any person obtaining a copy
       * of this software and associated documentation files (the "Software"), to deal
       * in the Software without restriction, including without limitation the rights
       * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
       * copies of the Software, and to permit persons to whom the Software is
       * furnished to do so, subject to the following conditions:
       *
       * The above copyright notice and this permission notice shall be included in all
       * copies or substantial portions of the Software.
       *
       * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
       * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
       * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
       * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
       * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
       * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
       * SOFTWARE.
       */
      body: string;
      /** @example true */
      featured: boolean;
    };
    /** @enum {string} */
    "ghes-cluster-topology": "SingleNode" | "Ha" | "Cluster";
    /** @enum {string} */
    "ghes-cluster-roles":
      | "Blank"
      | "ActionsServer"
      | "ConsulServer"
      | "ElasticsearchServer"
      | "GitServer"
      | "JobServer"
      | "LaunchServer"
      | "MemcacheServer"
      | "MetricsServer"
      | "MssqlServer"
      | "MysqlServer"
      | "PagesServer"
      | "RedisServer"
      | "StorageServer"
      | "WebServer";
    "ghes-config-nodes": {
      topology?: components["schemas"]["ghes-cluster-topology"];
      nodes?: {
        hostname?: string;
        uuid?: string;
        replica?: boolean;
        cluster_roles?: components["schemas"]["ghes-cluster-roles"][];
      }[];
    };
    "ghes-get-maintenance": {
      /** Format: hostname */
      hostname?: string;
      /** Format: uuid */
      uuid?: string;
      /** @enum {string} */
      status?: "on" | "off" | "scheduled";
      /** Format: date */
      scheduled_time?: string;
      connection_services?: {
        name?: string;
        number?: number;
      }[];
      can_unset_maintenance?: boolean;
      ip_exception_list?: string[];
      maintenance_mode_message?: string;
    }[];
    /** Set Maintenance mode */
    "ghes-set-maintenance-request": {
      /** @description Whether to enable maintenance mode. */
      enabled: boolean;
      /**
       * Format: uuid
       * @description The UUID of the node to target. This parameter is incompatible with maintenance mode scheduling. Only use `uuid` if the value of `when` is empty or `now`.
       */
      uuid?: string;
      /**
       * Format: date-time
       * @description The time to enable maintenance mode. If this parameter is empty or set to `now`, maintenance mode is enabled immediately. Otherwise, maintenance mode is enabled at the specified time. The format is ISO 8601.
       * @example 2006-01-02T15:04:05+00:00
       */
      when?: string;
      /**
       * @description The list of IP addresses to exclude from maintenance mode. IPv4, IPv6, and CIDR addresses are supported.
       * @example ["1.1.1.1","192.168.1.0/24"]
       */
      ip_exception_list?: string[];
      /** @description The message to display to users when maintenance mode is enabled. */
      maintenance_mode_message?: string;
    };
    "ghes-set-maintenance-response": {
      /** Format: hostname */
      hostname?: string;
      /** Format: uuid */
      uuid?: string;
      message?: string;
      error?: string;
    }[];
    /** @enum {string} */
    "ghes-replication-status-indicator":
      | "UNKNOWN"
      | "OK"
      | "WARNING"
      | "CRITICAL";
    "ghes-replication-status": {
      status?: components["schemas"]["ghes-replication-status-indicator"];
      nodes?: {
        hostname?: string;
        status?: components["schemas"]["ghes-replication-status-indicator"];
        services?: {
          status?: components["schemas"]["ghes-replication-status-indicator"];
          name?: string;
          details?: string;
        }[];
      }[];
    };
    "ghes-version": {
      /** Format: hostname */
      hostname?: string;
      version?: {
        version?: string;
        /** @enum {string} */
        platform?: "ami" | "azure" | "esx" | "gce" | "hyperv" | "kvm";
        build_id?: string;
        /** Format: date */
        build_date?: string;
      };
    }[];
    /**
     * Api Overview
     * @description Api Overview
     */
    "api-overview": {
      /** @example true */
      verifiable_password_authentication: boolean;
      /**
       * @example [
       *   "192.0.2.1"
       * ]
       */
      packages?: string[];
      /**
       * @example [
       *   "192.0.2.1"
       * ]
       */
      dependabot?: string[];
      domains?: {
        website?: string[];
        codespaces?: string[];
        copilot?: string[];
        packages?: string[];
        actions?: string[];
      };
      /** @example 3.10.0 */
      installed_version?: string;
    };
    "security-and-analysis": {
      advanced_security?: {
        /** @enum {string} */
        status?: "enabled" | "disabled";
      };
      /** @description Enable or disable Dependabot security updates for the repository. */
      dependabot_security_updates?: {
        /**
         * @description The enablement status of Dependabot security updates for the repository.
         * @enum {string}
         */
        status?: "enabled" | "disabled";
      };
      secret_scanning?: {
        /** @enum {string} */
        status?: "enabled" | "disabled";
      };
      secret_scanning_push_protection?: {
        /** @enum {string} */
        status?: "enabled" | "disabled";
      };
    } | null;
    /**
     * Minimal Repository
     * @description Minimal Repository
     */
    "minimal-repository": {
      /** @example 1296269 */
      id: number;
      /** @example MDEwOlJlcG9zaXRvcnkxMjk2MjY5 */
      node_id: string;
      /** @example Hello-World */
      name: string;
      /** @example octocat/Hello-World */
      full_name: string;
      owner: components["schemas"]["simple-user"];
      private: boolean;
      /**
       * Format: uri
       * @example https://github.com/octocat/Hello-World
       */
      html_url: string;
      /** @example This your first repo! */
      description: string | null;
      fork: boolean;
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/Hello-World
       */
      url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/{archive_format}{/ref} */
      archive_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/assignees{/user} */
      assignees_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/git/blobs{/sha} */
      blobs_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/branches{/branch} */
      branches_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/collaborators{/collaborator} */
      collaborators_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/comments{/number} */
      comments_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/commits{/sha} */
      commits_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/compare/{base}...{head} */
      compare_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/contents/{+path} */
      contents_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/contributors
       */
      contributors_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/deployments
       */
      deployments_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/downloads
       */
      downloads_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/events
       */
      events_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/forks
       */
      forks_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/git/commits{/sha} */
      git_commits_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/git/refs{/sha} */
      git_refs_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/git/tags{/sha} */
      git_tags_url: string;
      git_url?: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/issues/comments{/number} */
      issue_comment_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/issues/events{/number} */
      issue_events_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/issues{/number} */
      issues_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/keys{/key_id} */
      keys_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/labels{/name} */
      labels_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/languages
       */
      languages_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/merges
       */
      merges_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/milestones{/number} */
      milestones_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/notifications{?since,all,participating} */
      notifications_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/pulls{/number} */
      pulls_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/releases{/id} */
      releases_url: string;
      ssh_url?: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/stargazers
       */
      stargazers_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/statuses/{sha} */
      statuses_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/subscribers
       */
      subscribers_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/subscription
       */
      subscription_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/tags
       */
      tags_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/teams
       */
      teams_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/git/trees{/sha} */
      trees_url: string;
      clone_url?: string;
      mirror_url?: string | null;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/hooks
       */
      hooks_url: string;
      svn_url?: string;
      homepage?: string | null;
      language?: string | null;
      forks_count?: number;
      stargazers_count?: number;
      watchers_count?: number;
      /** @description The size of the repository, in kilobytes. Size is calculated hourly. When a repository is initially created, the size is 0. */
      size?: number;
      default_branch?: string;
      open_issues_count?: number;
      is_template?: boolean;
      topics?: string[];
      has_issues?: boolean;
      has_projects?: boolean;
      has_wiki?: boolean;
      has_pages?: boolean;
      has_downloads?: boolean;
      has_discussions?: boolean;
      archived?: boolean;
      disabled?: boolean;
      visibility?: string;
      /**
       * Format: date-time
       * @example 2011-01-26T19:06:43Z
       */
      pushed_at?: string | null;
      /**
       * Format: date-time
       * @example 2011-01-26T19:01:12Z
       */
      created_at?: string | null;
      /**
       * Format: date-time
       * @example 2011-01-26T19:14:43Z
       */
      updated_at?: string | null;
      permissions?: {
        admin?: boolean;
        maintain?: boolean;
        push?: boolean;
        triage?: boolean;
        pull?: boolean;
      };
      /** @example admin */
      role_name?: string;
      temp_clone_token?: string;
      delete_branch_on_merge?: boolean;
      subscribers_count?: number;
      network_count?: number;
      code_of_conduct?: components["schemas"]["code-of-conduct"];
      license?: {
        key?: string;
        name?: string;
        spdx_id?: string;
        url?: string;
        node_id?: string;
      } | null;
      /** @example 0 */
      forks?: number;
      /** @example 0 */
      open_issues?: number;
      /** @example 0 */
      watchers?: number;
      allow_forking?: boolean;
      /** @example false */
      web_commit_signoff_required?: boolean;
      security_and_analysis?: components["schemas"]["security-and-analysis"];
    };
    /**
     * Thread
     * @description Thread
     */
    thread: {
      id: string;
      repository: components["schemas"]["minimal-repository"];
      subject: {
        title: string;
        url: string;
        latest_comment_url: string;
        type: string;
      };
      reason: string;
      unread: boolean;
      updated_at: string;
      last_read_at: string | null;
      url: string;
      /** @example https://api.github.com/notifications/threads/2/subscription */
      subscription_url: string;
    };
    /**
     * Thread Subscription
     * @description Thread Subscription
     */
    "thread-subscription": {
      /** @example true */
      subscribed: boolean;
      ignored: boolean;
      reason: string | null;
      /**
       * Format: date-time
       * @example 2012-10-06T21:34:12Z
       */
      created_at: string | null;
      /**
       * Format: uri
       * @example https://api.github.com/notifications/threads/1/subscription
       */
      url: string;
      /**
       * Format: uri
       * @example https://api.github.com/notifications/threads/1
       */
      thread_url?: string;
      /**
       * Format: uri
       * @example https://api.github.com/repos/1
       */
      repository_url?: string;
    };
    /**
     * Organization Custom Repository Role
     * @description Custom repository roles created by organization owners
     */
    "organization-custom-repository-role": {
      /** @description The unique identifier of the custom role. */
      id: number;
      /** @description The name of the custom role. */
      name: string;
      /** @description A short description about who this role is for or what permissions it grants. */
      description?: string | null;
      /**
       * @description The system role from which this role inherits permissions.
       * @enum {string}
       */
      base_role: "read" | "triage" | "write" | "maintain";
      /** @description A list of additional permissions included in this role. */
      permissions: string[];
      organization: components["schemas"]["simple-user"];
      /** Format: date-time */
      created_at: string;
      /** Format: date-time */
      updated_at: string;
    };
    /**
     * Organization Full
     * @description Organization Full
     */
    "organization-full": {
      /** @example github */
      login: string;
      /** @example 1 */
      id: number;
      /** @example MDEyOk9yZ2FuaXphdGlvbjE= */
      node_id: string;
      /**
       * Format: uri
       * @example https://api.github.com/orgs/github
       */
      url: string;
      /**
       * Format: uri
       * @example https://api.github.com/orgs/github/repos
       */
      repos_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/orgs/github/events
       */
      events_url: string;
      /** @example https://api.github.com/orgs/github/hooks */
      hooks_url: string;
      /** @example https://api.github.com/orgs/github/issues */
      issues_url: string;
      /** @example https://api.github.com/orgs/github/members{/member} */
      members_url: string;
      /** @example https://api.github.com/orgs/github/public_members{/member} */
      public_members_url: string;
      /** @example https://github.com/images/error/octocat_happy.gif */
      avatar_url: string;
      /** @example A great organization */
      description: string | null;
      /** @example github */
      name?: string;
      /** @example GitHub */
      company?: string;
      /**
       * Format: uri
       * @example https://github.com/blog
       */
      blog?: string;
      /** @example San Francisco */
      location?: string;
      /**
       * Format: email
       * @example octocat@github.com
       */
      email?: string;
      /** @example github */
      twitter_username?: string | null;
      /** @example true */
      is_verified?: boolean;
      /** @example true */
      has_organization_projects: boolean;
      /** @example true */
      has_repository_projects: boolean;
      /** @example 2 */
      public_repos: number;
      /** @example 1 */
      public_gists: number;
      /** @example 20 */
      followers: number;
      /** @example 0 */
      following: number;
      /**
       * Format: uri
       * @example https://github.com/octocat
       */
      html_url: string;
      /** @example Organization */
      type: string;
      /** @example 100 */
      total_private_repos?: number;
      /** @example 100 */
      owned_private_repos?: number;
      /** @example 81 */
      private_gists?: number | null;
      /** @example 10000 */
      disk_usage?: number | null;
      /** @example 8 */
      collaborators?: number | null;
      /**
       * Format: email
       * @example org@example.com
       */
      billing_email?: string | null;
      plan?: {
        name: string;
        space: number;
        private_repos: number;
        filled_seats?: number;
        seats?: number;
      };
      default_repository_permission?: string | null;
      /** @example true */
      members_can_create_repositories?: boolean | null;
      /** @example true */
      two_factor_requirement_enabled?: boolean | null;
      /** @example all */
      members_allowed_repository_creation_type?: string;
      /** @example true */
      members_can_create_public_repositories?: boolean;
      /** @example true */
      members_can_create_private_repositories?: boolean;
      /** @example true */
      members_can_create_internal_repositories?: boolean;
      /** @example true */
      members_can_create_pages?: boolean;
      /** @example true */
      members_can_create_public_pages?: boolean;
      /** @example true */
      members_can_create_private_pages?: boolean;
      /** @example false */
      members_can_fork_private_repositories?: boolean | null;
      /** @example false */
      web_commit_signoff_required?: boolean;
      /**
       * @description Whether GitHub Advanced Security is enabled for new repositories and repositories transferred to this organization.
       *
       * This field is only visible to organization owners or members of a team with the security manager role.
       * @example false
       */
      advanced_security_enabled_for_new_repositories?: boolean;
      /**
       * @description Whether GitHub Advanced Security is automatically enabled for new repositories and repositories transferred to
       * this organization.
       *
       * This field is only visible to organization owners or members of a team with the security manager role.
       * @example false
       */
      dependabot_alerts_enabled_for_new_repositories?: boolean;
      /**
       * @description Whether dependabot security updates are automatically enabled for new repositories and repositories transferred
       * to this organization.
       *
       * This field is only visible to organization owners or members of a team with the security manager role.
       * @example false
       */
      dependabot_security_updates_enabled_for_new_repositories?: boolean;
      /**
       * @description Whether dependency graph is automatically enabled for new repositories and repositories transferred to this
       * organization.
       *
       * This field is only visible to organization owners or members of a team with the security manager role.
       * @example false
       */
      dependency_graph_enabled_for_new_repositories?: boolean;
      /**
       * @description Whether secret scanning is automatically enabled for new repositories and repositories transferred to this
       * organization.
       *
       * This field is only visible to organization owners or members of a team with the security manager role.
       * @example false
       */
      secret_scanning_enabled_for_new_repositories?: boolean;
      /**
       * @description Whether secret scanning push protection is automatically enabled for new repositories and repositories
       * transferred to this organization.
       *
       * This field is only visible to organization owners or members of a team with the security manager role.
       * @example false
       */
      secret_scanning_push_protection_enabled_for_new_repositories?: boolean;
      /**
       * @description Whether a custom link is shown to contributors who are blocked from pushing a secret by push protection.
       * @example false
       */
      secret_scanning_push_protection_custom_link_enabled?: boolean;
      /**
       * @description An optional URL string to display to contributors who are blocked from pushing a secret.
       * @example https://github.com/test-org/test-repo/blob/main/README.md
       */
      secret_scanning_push_protection_custom_link?: string | null;
      /**
       * Format: date-time
       * @example 2008-01-14T04:33:35Z
       */
      created_at: string;
      /** Format: date-time */
      updated_at: string;
    };
    /**
     * Actions Cache Usage by repository
     * @description GitHub Actions Cache Usage by repository.
     */
    "actions-cache-usage-by-repository": {
      /**
       * @description The repository owner and name for the cache usage being shown.
       * @example octo-org/Hello-World
       */
      full_name: string;
      /**
       * @description The sum of the size in bytes of all the active cache items in the repository.
       * @example 2322142
       */
      active_caches_size_in_bytes: number;
      /**
       * @description The number of active caches in the repository.
       * @example 3
       */
      active_caches_count: number;
    };
    /**
     * Actions OIDC Subject customization
     * @description Actions OIDC Subject customization
     */
    "oidc-custom-sub": {
      /** @description Array of unique strings. Each claim key can only contain alphanumeric characters and underscores. */
      include_claim_keys: string[];
    };
    /**
     * Empty Object
     * @description An object without any properties.
     */
    "empty-object": Record<string, never>;
    /**
     * @description The policy that controls the repositories in the organization that are allowed to run GitHub Actions.
     * @enum {string}
     */
    "enabled-repositories": "all" | "none" | "selected";
    "actions-organization-permissions": {
      enabled_repositories: components["schemas"]["enabled-repositories"];
      /** @description The API URL to use to get or set the selected repositories that are allowed to run GitHub Actions, when `enabled_repositories` is set to `selected`. */
      selected_repositories_url?: string;
      allowed_actions?: components["schemas"]["allowed-actions"];
      selected_actions_url?: components["schemas"]["selected-actions-url"];
    };
    "runner-groups-org": {
      id: number;
      name: string;
      visibility: string;
      default: boolean;
      /** @description Link to the selected repositories resource for this runner group. Not present unless visibility was set to `selected` */
      selected_repositories_url?: string;
      runners_url: string;
      inherited: boolean;
      inherited_allows_public_repositories?: boolean;
      allows_public_repositories: boolean;
      /**
       * @description If `true`, the `restricted_to_workflows` and `selected_workflows` fields cannot be modified.
       * @default false
       */
      workflow_restrictions_read_only?: boolean;
      /**
       * @description If `true`, the runner group will be restricted to running only the workflows specified in the `selected_workflows` array.
       * @default false
       */
      restricted_to_workflows?: boolean;
      /** @description List of workflows the runner group should be allowed to run. This setting will be ignored unless `restricted_to_workflows` is set to `true`. */
      selected_workflows?: string[];
    };
    /**
     * Actions Secret for an Organization
     * @description Secrets for GitHub Actions for an organization.
     */
    "organization-actions-secret": {
      /**
       * @description The name of the secret.
       * @example SECRET_TOKEN
       */
      name: string;
      /** Format: date-time */
      created_at: string;
      /** Format: date-time */
      updated_at: string;
      /**
       * @description Visibility of a secret
       * @enum {string}
       */
      visibility: "all" | "private" | "selected";
      /**
       * Format: uri
       * @example https://api.github.com/organizations/org/secrets/my_secret/repositories
       */
      selected_repositories_url?: string;
    };
    /**
     * ActionsPublicKey
     * @description The public key used for setting Actions Secrets.
     */
    "actions-public-key": {
      /**
       * @description The identifier for the key.
       * @example 1234567
       */
      key_id: string;
      /**
       * @description The Base64 encoded public key.
       * @example hBT5WZEj8ZoOv6TYJsfWq7MxTEQopZO5/IT3ZCVQPzs=
       */
      key: string;
      /** @example 2 */
      id?: number;
      /** @example https://api.github.com/user/keys/2 */
      url?: string;
      /** @example ssh-rsa AAAAB3NzaC1yc2EAAA */
      title?: string;
      /** @example 2011-01-26T19:01:12Z */
      created_at?: string;
    };
    /**
     * Actions Variable for an Organization
     * @description Organization variable for GitHub Actions.
     */
    "organization-actions-variable": {
      /**
       * @description The name of the variable.
       * @example USERNAME
       */
      name: string;
      /**
       * @description The value of the variable.
       * @example octocat
       */
      value: string;
      /**
       * Format: date-time
       * @description The date and time at which the variable was created, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.
       * @example 2019-01-24T22:45:36.000Z
       */
      created_at: string;
      /**
       * Format: date-time
       * @description The date and time at which the variable was last updated, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.
       * @example 2019-01-24T22:45:36.000Z
       */
      updated_at: string;
      /**
       * @description Visibility of a variable
       * @enum {string}
       */
      visibility: "all" | "private" | "selected";
      /**
       * Format: uri
       * @example https://api.github.com/organizations/org/variables/USERNAME/repositories
       */
      selected_repositories_url?: string;
    };
    /**
     * @description Whether an announcement can be dismissed by the user.
     * @default false
     * @example false
     */
    "announcement-user-dismissible": boolean | null;
    /**
     * Announcement Banner
     * @description Announcement at either the repository, organization, or enterprise level
     */
    "announcement-banner": {
      announcement: components["schemas"]["announcement-message"];
      expires_at: components["schemas"]["announcement-expiration"];
      user_dismissible: components["schemas"]["announcement-user-dismissible"];
    };
    /**
     * @description Severity of a code scanning alert.
     * @enum {string}
     */
    "code-scanning-alert-severity":
      | "critical"
      | "high"
      | "medium"
      | "low"
      | "warning"
      | "note"
      | "error";
    "organization-custom-repository-role-create-schema": {
      /** @description The name of the custom role. */
      name: string;
      /** @description A short description about who this role is for or what permissions it grants. */
      description?: string | null;
      /**
       * @description The system role from which this role inherits permissions.
       * @enum {string}
       */
      base_role: "read" | "triage" | "write" | "maintain";
      /** @description A list of additional permissions included in this role. */
      permissions: string[];
    };
    "organization-custom-repository-role-update-schema": {
      /** @description The name of the custom role. */
      name?: string;
      /** @description A short description about who this role is for or what permissions it grants. */
      description?: string | null;
      /**
       * @description The system role from which this role inherits permissions.
       * @enum {string}
       */
      base_role?: "read" | "triage" | "write" | "maintain";
      /** @description A list of additional permissions included in this role. */
      permissions?: string[];
    };
    /**
     * Dependabot Secret for an Organization
     * @description Secrets for GitHub Dependabot for an organization.
     */
    "organization-dependabot-secret": {
      /**
       * @description The name of the secret.
       * @example SECRET_TOKEN
       */
      name: string;
      /** Format: date-time */
      created_at: string;
      /** Format: date-time */
      updated_at: string;
      /**
       * @description Visibility of a secret
       * @enum {string}
       */
      visibility: "all" | "private" | "selected";
      /**
       * Format: uri
       * @example https://api.github.com/organizations/org/dependabot/secrets/my_secret/repositories
       */
      selected_repositories_url?: string;
    };
    /**
     * DependabotPublicKey
     * @description The public key used for setting Dependabot Secrets.
     */
    "dependabot-public-key": {
      /**
       * @description The identifier for the key.
       * @example 1234567
       */
      key_id: string;
      /**
       * @description The Base64 encoded public key.
       * @example hBT5WZEj8ZoOv6TYJsfWq7MxTEQopZO5/IT3ZCVQPzs=
       */
      key: string;
    };
    /**
     * Minimal Repository
     * @description Minimal Repository
     */
    "nullable-minimal-repository": {
      /** @example 1296269 */
      id: number;
      /** @example MDEwOlJlcG9zaXRvcnkxMjk2MjY5 */
      node_id: string;
      /** @example Hello-World */
      name: string;
      /** @example octocat/Hello-World */
      full_name: string;
      owner: components["schemas"]["simple-user"];
      private: boolean;
      /**
       * Format: uri
       * @example https://github.com/octocat/Hello-World
       */
      html_url: string;
      /** @example This your first repo! */
      description: string | null;
      fork: boolean;
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/Hello-World
       */
      url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/{archive_format}{/ref} */
      archive_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/assignees{/user} */
      assignees_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/git/blobs{/sha} */
      blobs_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/branches{/branch} */
      branches_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/collaborators{/collaborator} */
      collaborators_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/comments{/number} */
      comments_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/commits{/sha} */
      commits_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/compare/{base}...{head} */
      compare_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/contents/{+path} */
      contents_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/contributors
       */
      contributors_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/deployments
       */
      deployments_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/downloads
       */
      downloads_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/events
       */
      events_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/forks
       */
      forks_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/git/commits{/sha} */
      git_commits_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/git/refs{/sha} */
      git_refs_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/git/tags{/sha} */
      git_tags_url: string;
      git_url?: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/issues/comments{/number} */
      issue_comment_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/issues/events{/number} */
      issue_events_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/issues{/number} */
      issues_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/keys{/key_id} */
      keys_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/labels{/name} */
      labels_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/languages
       */
      languages_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/merges
       */
      merges_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/milestones{/number} */
      milestones_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/notifications{?since,all,participating} */
      notifications_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/pulls{/number} */
      pulls_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/releases{/id} */
      releases_url: string;
      ssh_url?: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/stargazers
       */
      stargazers_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/statuses/{sha} */
      statuses_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/subscribers
       */
      subscribers_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/subscription
       */
      subscription_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/tags
       */
      tags_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/teams
       */
      teams_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/git/trees{/sha} */
      trees_url: string;
      clone_url?: string;
      mirror_url?: string | null;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/hooks
       */
      hooks_url: string;
      svn_url?: string;
      homepage?: string | null;
      language?: string | null;
      forks_count?: number;
      stargazers_count?: number;
      watchers_count?: number;
      /** @description The size of the repository, in kilobytes. Size is calculated hourly. When a repository is initially created, the size is 0. */
      size?: number;
      default_branch?: string;
      open_issues_count?: number;
      is_template?: boolean;
      topics?: string[];
      has_issues?: boolean;
      has_projects?: boolean;
      has_wiki?: boolean;
      has_pages?: boolean;
      has_downloads?: boolean;
      has_discussions?: boolean;
      archived?: boolean;
      disabled?: boolean;
      visibility?: string;
      /**
       * Format: date-time
       * @example 2011-01-26T19:06:43Z
       */
      pushed_at?: string | null;
      /**
       * Format: date-time
       * @example 2011-01-26T19:01:12Z
       */
      created_at?: string | null;
      /**
       * Format: date-time
       * @example 2011-01-26T19:14:43Z
       */
      updated_at?: string | null;
      permissions?: {
        admin?: boolean;
        maintain?: boolean;
        push?: boolean;
        triage?: boolean;
        pull?: boolean;
      };
      /** @example admin */
      role_name?: string;
      temp_clone_token?: string;
      delete_branch_on_merge?: boolean;
      subscribers_count?: number;
      network_count?: number;
      code_of_conduct?: components["schemas"]["code-of-conduct"];
      license?: {
        key?: string;
        name?: string;
        spdx_id?: string;
        url?: string;
        node_id?: string;
      } | null;
      /** @example 0 */
      forks?: number;
      /** @example 0 */
      open_issues?: number;
      /** @example 0 */
      watchers?: number;
      allow_forking?: boolean;
      /** @example false */
      web_commit_signoff_required?: boolean;
      security_and_analysis?: components["schemas"]["security-and-analysis"];
    } | null;
    /**
     * Package
     * @description A software package
     */
    package: {
      /**
       * @description Unique identifier of the package.
       * @example 1
       */
      id: number;
      /**
       * @description The name of the package.
       * @example super-linter
       */
      name: string;
      /**
       * @example docker
       * @enum {string}
       */
      package_type:
        | "npm"
        | "maven"
        | "rubygems"
        | "docker"
        | "nuget"
        | "container";
      /** @example https://api.github.com/orgs/github/packages/container/super-linter */
      url: string;
      /** @example https://github.com/orgs/github/packages/container/package/super-linter */
      html_url: string;
      /**
       * @description The number of versions of the package.
       * @example 1
       */
      version_count: number;
      /**
       * @example private
       * @enum {string}
       */
      visibility: "private" | "public";
      owner?: components["schemas"]["nullable-simple-user"];
      repository?: components["schemas"]["nullable-minimal-repository"];
      /** Format: date-time */
      created_at: string;
      /** Format: date-time */
      updated_at: string;
    };
    /**
     * ExternalGroup
     * @description Information about an external group's usage and its members
     */
    "external-group": {
      /**
       * @description The internal ID of the group
       * @example 1
       */
      group_id: number;
      /**
       * @description The display name for the group
       * @example group-azuread-test
       */
      group_name: string;
      /**
       * @description The date when the group was last updated_at
       * @example 2021-01-03 22:27:15:000 -700
       */
      updated_at?: string;
      /**
       * @description An array of teams linked to this group
       * @example [
       *   {
       *     "team_id": 1,
       *     "team_name": "team-test"
       *   },
       *   {
       *     "team_id": 2,
       *     "team_name": "team-test2"
       *   }
       * ]
       */
      teams: {
        /**
         * @description The id for a team
         * @example 1
         */
        team_id: number;
        /**
         * @description The name of the team
         * @example team-test
         */
        team_name: string;
      }[];
      /**
       * @description An array of external members linked to this group
       * @example [
       *   {
       *     "member_id": 1,
       *     "member_login": "mona-lisa_eocsaxrs",
       *     "member_name": "Mona Lisa",
       *     "member_email": "mona_lisa@github.com"
       *   },
       *   {
       *     "member_id": 2,
       *     "member_login": "octo-lisa_eocsaxrs",
       *     "member_name": "Octo Lisa",
       *     "member_email": "octo_lisa@github.com"
       *   }
       * ]
       */
      members: {
        /**
         * @description The internal user ID of the identity
         * @example 1
         */
        member_id: number;
        /**
         * @description The handle/login for the user
         * @example mona-lisa_eocsaxrs
         */
        member_login: string;
        /**
         * @description The user display name/profile name
         * @example Mona Lisa
         */
        member_name: string;
        /**
         * @description An email attached to a user
         * @example mona_lisa@github.com
         */
        member_email: string;
      }[];
    };
    /**
     * ExternalGroups
     * @description A list of external groups available to be connected to a team
     */
    "external-groups": {
      /**
       * @description An array of external groups available to be mapped to a team
       * @example [
       *   {
       *     "group_id": 1,
       *     "group_name": "group-azuread-test",
       *     "updated_at": "2021-01-03 22:27:15:000 -700"
       *   },
       *   {
       *     "group_id": 2,
       *     "group_name": "group-azuread-test2",
       *     "updated_at": "2021-06-03 22:27:15:000 -700"
       *   }
       * ]
       */
      groups?: {
        /**
         * @description The internal ID of the group
         * @example 1
         */
        group_id: number;
        /**
         * @description The display name of the group
         * @example group-azuread-test
         */
        group_name: string;
        /**
         * @description The time of the last update for this group
         * @example 2019-06-03 22:27:15:000 -700
         */
        updated_at: string;
      }[];
    };
    /**
     * Org Hook
     * @description Org Hook
     */
    "org-hook": {
      /** @example 1 */
      id: number;
      /**
       * Format: uri
       * @example https://api.github.com/orgs/octocat/hooks/1
       */
      url: string;
      /**
       * Format: uri
       * @example https://api.github.com/orgs/octocat/hooks/1/pings
       */
      ping_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/orgs/octocat/hooks/1/deliveries
       */
      deliveries_url?: string;
      /** @example web */
      name: string;
      /**
       * @example [
       *   "push",
       *   "pull_request"
       * ]
       */
      events: string[];
      /** @example true */
      active: boolean;
      config: {
        /** @example "http://example.com/2" */
        url?: string;
        /** @example "0" */
        insecure_ssl?: string;
        /** @example "form" */
        content_type?: string;
        /** @example "********" */
        secret?: string;
      };
      /**
       * Format: date-time
       * @example 2011-09-06T20:39:23Z
       */
      updated_at: string;
      /**
       * Format: date-time
       * @example 2011-09-06T17:26:27Z
       */
      created_at: string;
      type: string;
    };
    /**
     * Org Membership
     * @description Org Membership
     */
    "org-membership": {
      /**
       * Format: uri
       * @example https://api.github.com/orgs/octocat/memberships/defunkt
       */
      url: string;
      /**
       * @description The state of the member in the organization. The `pending` state indicates the user has not yet accepted an invitation.
       * @example active
       * @enum {string}
       */
      state: "active" | "pending";
      /**
       * @description The user's membership type in the organization.
       * @example admin
       * @enum {string}
       */
      role: "admin" | "member" | "billing_manager";
      /**
       * Format: uri
       * @example https://api.github.com/orgs/octocat
       */
      organization_url: string;
      organization: components["schemas"]["organization-simple"];
      user: components["schemas"]["nullable-simple-user"];
      permissions?: {
        can_create_repository: boolean;
      };
    };
    /**
     * Migration
     * @description A migration.
     */
    migration: {
      /** @example 79 */
      id: number;
      owner: components["schemas"]["nullable-simple-user"];
      /** @example 0b989ba4-242f-11e5-81e1-c7b6966d2516 */
      guid: string;
      /** @example pending */
      state: string;
      /** @example true */
      lock_repositories: boolean;
      exclude_metadata: boolean;
      exclude_git_data: boolean;
      exclude_attachments: boolean;
      exclude_releases: boolean;
      exclude_owner_projects: boolean;
      org_metadata_only: boolean;
      /** @description The repositories included in the migration. Only returned for export migrations. */
      repositories: components["schemas"]["repository"][];
      /**
       * Format: uri
       * @example https://api.github.com/orgs/octo-org/migrations/79
       */
      url: string;
      /**
       * Format: date-time
       * @example 2015-07-06T15:33:38-07:00
       */
      created_at: string;
      /**
       * Format: date-time
       * @example 2015-07-06T15:33:38-07:00
       */
      updated_at: string;
      node_id: string;
      /** Format: uri */
      archive_url?: string;
      /** @description Exclude related items from being returned in the response in order to improve performance of the request. The array can include any of: `"repositories"`. */
      exclude?: string[];
    };
    /**
     * Package Version
     * @description A version of a software package
     */
    "package-version": {
      /**
       * @description Unique identifier of the package version.
       * @example 1
       */
      id: number;
      /**
       * @description The name of the package version.
       * @example latest
       */
      name: string;
      /** @example https://api.github.com/orgs/github/packages/container/super-linter/versions/786068 */
      url: string;
      /** @example https://github.com/orgs/github/packages/container/package/super-linter */
      package_html_url: string;
      /** @example https://github.com/orgs/github/packages/container/super-linter/786068 */
      html_url?: string;
      /** @example MIT */
      license?: string;
      description?: string;
      /**
       * Format: date-time
       * @example 2011-04-10T20:09:31Z
       */
      created_at: string;
      /**
       * Format: date-time
       * @example 2014-03-03T18:58:10Z
       */
      updated_at: string;
      /**
       * Format: date-time
       * @example 2014-03-03T18:58:10Z
       */
      deleted_at?: string;
      /** Package Version Metadata */
      metadata?: {
        /**
         * @example docker
         * @enum {string}
         */
        package_type:
          | "npm"
          | "maven"
          | "rubygems"
          | "docker"
          | "nuget"
          | "container";
        /** Container Metadata */
        container?: {
          tags: string[];
        };
        /** Docker Metadata */
        docker?: {
          tag?: string[];
        };
      };
    };
    /**
     * Simple Organization Programmatic Access Grant Request
     * @description Minimal representation of an organization programmatic access grant request for enumerations
     */
    "organization-programmatic-access-grant-request": {
      /** @description Unique identifier of the request for access via fine-grained personal access token. The `pat_request_id` used to review PAT requests. */
      id: number;
      /** @description Reason for requesting access. */
      reason: string | null;
      owner: components["schemas"]["simple-user"];
      /**
       * @description Type of repository selection requested.
       * @enum {string}
       */
      repository_selection: "none" | "all" | "subset";
      /** @description URL to the list of repositories requested to be accessed via fine-grained personal access token. Should only be followed when `repository_selection` is `subset`. */
      repositories_url: string;
      /** @description Permissions requested, categorized by type of permission. */
      permissions: {
        organization?: {
          [key: string]: string;
        };
        repository?: {
          [key: string]: string;
        };
        other?: {
          [key: string]: string;
        };
      };
      /** @description Date and time when the request for access was created. */
      created_at: string;
      /** @description Whether the associated fine-grained personal access token has expired. */
      token_expired: boolean;
      /** @description Date and time when the associated fine-grained personal access token expires. */
      token_expires_at: string | null;
      /** @description Date and time when the associated fine-grained personal access token was last used for authentication. */
      token_last_used_at: string | null;
    };
    /**
     * Organization Programmatic Access Grant
     * @description Minimal representation of an organization programmatic access grant for enumerations
     */
    "organization-programmatic-access-grant": {
      /** @description Unique identifier of the fine-grained personal access token. The `pat_id` used to get details about an approved fine-grained personal access token. */
      id: number;
      owner: components["schemas"]["simple-user"];
      /**
       * @description Type of repository selection requested.
       * @enum {string}
       */
      repository_selection: "none" | "all" | "subset";
      /** @description URL to the list of repositories the fine-grained personal access token can access. Only follow when `repository_selection` is `subset`. */
      repositories_url: string;
      /** @description Permissions requested, categorized by type of permission. */
      permissions: {
        organization?: {
          [key: string]: string;
        };
        repository?: {
          [key: string]: string;
        };
        other?: {
          [key: string]: string;
        };
      };
      /** @description Date and time when the fine-grained personal access token was approved to access the organization. */
      access_granted_at: string;
      /** @description Whether the associated fine-grained personal access token has expired. */
      token_expired: boolean;
      /** @description Date and time when the associated fine-grained personal access token expires. */
      token_expires_at: string | null;
      /** @description Date and time when the associated fine-grained personal access token was last used for authentication. */
      token_last_used_at: string | null;
    };
    "org-pre-receive-hook": {
      id?: number;
      name?: string;
      enforcement?: string;
      configuration_url?: string;
      allow_downstream_configuration?: boolean;
    };
    /**
     * Project
     * @description Projects are a way to organize columns and cards of work.
     */
    project: {
      /**
       * Format: uri
       * @example https://api.github.com/repos/api-playground/projects-test
       */
      owner_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/projects/1002604
       */
      url: string;
      /**
       * Format: uri
       * @example https://github.com/api-playground/projects-test/projects/12
       */
      html_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/projects/1002604/columns
       */
      columns_url: string;
      /** @example 1002604 */
      id: number;
      /** @example MDc6UHJvamVjdDEwMDI2MDQ= */
      node_id: string;
      /**
       * @description Name of the project
       * @example Week One Sprint
       */
      name: string;
      /**
       * @description Body of the project
       * @example This project represents the sprint of the first week in January
       */
      body: string | null;
      /** @example 1 */
      number: number;
      /**
       * @description State of the project; either 'open' or 'closed'
       * @example open
       */
      state: string;
      creator: components["schemas"]["nullable-simple-user"];
      /**
       * Format: date-time
       * @example 2011-04-10T20:09:31Z
       */
      created_at: string;
      /**
       * Format: date-time
       * @example 2014-03-03T18:58:10Z
       */
      updated_at: string;
      /**
       * @description The baseline permission that all organization members have on this project. Only present if owner is an organization.
       * @enum {string}
       */
      organization_permission?: "read" | "write" | "admin" | "none";
      /** @description Whether or not this project can be seen by everyone. Only present if owner is an organization. */
      private?: boolean;
    };
    /**
     * Repository
     * @description A repository on GitHub.
     */
    "nullable-repository": {
      /**
       * @description Unique identifier of the repository
       * @example 42
       */
      id: number;
      /** @example MDEwOlJlcG9zaXRvcnkxMjk2MjY5 */
      node_id: string;
      /**
       * @description The name of the repository.
       * @example Team Environment
       */
      name: string;
      /** @example octocat/Hello-World */
      full_name: string;
      license: components["schemas"]["nullable-license-simple"];
      forks: number;
      permissions?: {
        admin: boolean;
        pull: boolean;
        triage?: boolean;
        push: boolean;
        maintain?: boolean;
      };
      owner: components["schemas"]["simple-user"];
      /**
       * @description Whether the repository is private or public.
       * @default false
       */
      private: boolean;
      /**
       * Format: uri
       * @example https://github.com/octocat/Hello-World
       */
      html_url: string;
      /** @example This your first repo! */
      description: string | null;
      fork: boolean;
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/Hello-World
       */
      url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/{archive_format}{/ref} */
      archive_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/assignees{/user} */
      assignees_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/git/blobs{/sha} */
      blobs_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/branches{/branch} */
      branches_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/collaborators{/collaborator} */
      collaborators_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/comments{/number} */
      comments_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/commits{/sha} */
      commits_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/compare/{base}...{head} */
      compare_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/contents/{+path} */
      contents_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/contributors
       */
      contributors_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/deployments
       */
      deployments_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/downloads
       */
      downloads_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/events
       */
      events_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/forks
       */
      forks_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/git/commits{/sha} */
      git_commits_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/git/refs{/sha} */
      git_refs_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/git/tags{/sha} */
      git_tags_url: string;
      /** @example git:github.com/octocat/Hello-World.git */
      git_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/issues/comments{/number} */
      issue_comment_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/issues/events{/number} */
      issue_events_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/issues{/number} */
      issues_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/keys{/key_id} */
      keys_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/labels{/name} */
      labels_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/languages
       */
      languages_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/merges
       */
      merges_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/milestones{/number} */
      milestones_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/notifications{?since,all,participating} */
      notifications_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/pulls{/number} */
      pulls_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/releases{/id} */
      releases_url: string;
      /** @example git@github.com:octocat/Hello-World.git */
      ssh_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/stargazers
       */
      stargazers_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/statuses/{sha} */
      statuses_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/subscribers
       */
      subscribers_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/subscription
       */
      subscription_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/tags
       */
      tags_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/teams
       */
      teams_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/git/trees{/sha} */
      trees_url: string;
      /** @example https://github.com/octocat/Hello-World.git */
      clone_url: string;
      /**
       * Format: uri
       * @example git:git.example.com/octocat/Hello-World
       */
      mirror_url: string | null;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/hooks
       */
      hooks_url: string;
      /**
       * Format: uri
       * @example https://svn.github.com/octocat/Hello-World
       */
      svn_url: string;
      /**
       * Format: uri
       * @example https://github.com
       */
      homepage: string | null;
      language: string | null;
      /** @example 9 */
      forks_count: number;
      /** @example 80 */
      stargazers_count: number;
      /** @example 80 */
      watchers_count: number;
      /**
       * @description The size of the repository, in kilobytes. Size is calculated hourly. When a repository is initially created, the size is 0.
       * @example 108
       */
      size: number;
      /**
       * @description The default branch of the repository.
       * @example master
       */
      default_branch: string;
      /** @example 0 */
      open_issues_count: number;
      /**
       * @description Whether this repository acts as a template that can be used to generate new repositories.
       * @default false
       * @example true
       */
      is_template?: boolean;
      topics?: string[];
      /**
       * @description Whether issues are enabled.
       * @default true
       * @example true
       */
      has_issues: boolean;
      /**
       * @description Whether projects are enabled.
       * @default true
       * @example true
       */
      has_projects: boolean;
      /**
       * @description Whether the wiki is enabled.
       * @default true
       * @example true
       */
      has_wiki: boolean;
      has_pages: boolean;
      /**
       * @deprecated
       * @description Whether downloads are enabled.
       * @default true
       * @example true
       */
      has_downloads: boolean;
      /**
       * @description Whether discussions are enabled.
       * @default false
       * @example true
       */
      has_discussions?: boolean;
      /**
       * @description Whether the repository is archived.
       * @default false
       */
      archived: boolean;
      /** @description Returns whether or not this repository disabled. */
      disabled: boolean;
      /**
       * @description The repository visibility: public, private, or internal.
       * @default public
       */
      visibility?: string;
      /**
       * Format: date-time
       * @example 2011-01-26T19:06:43Z
       */
      pushed_at: string | null;
      /**
       * Format: date-time
       * @example 2011-01-26T19:01:12Z
       */
      created_at: string | null;
      /**
       * Format: date-time
       * @example 2011-01-26T19:14:43Z
       */
      updated_at: string | null;
      /**
       * @description Whether to allow rebase merges for pull requests.
       * @default true
       * @example true
       */
      allow_rebase_merge?: boolean;
      temp_clone_token?: string;
      /**
       * @description Whether to allow squash merges for pull requests.
       * @default true
       * @example true
       */
      allow_squash_merge?: boolean;
      /**
       * @description Whether to allow Auto-merge to be used on pull requests.
       * @default false
       * @example false
       */
      allow_auto_merge?: boolean;
      /**
       * @description Whether to delete head branches when pull requests are merged
       * @default false
       * @example false
       */
      delete_branch_on_merge?: boolean;
      /**
       * @description Whether or not a pull request head branch that is behind its base branch can always be updated even if it is not required to be up to date before merging.
       * @default false
       * @example false
       */
      allow_update_branch?: boolean;
      /**
       * @deprecated
       * @description Whether a squash merge commit can use the pull request title as default. **This property has been deprecated. Please use `squash_merge_commit_title` instead.
       * @default false
       */
      use_squash_pr_title_as_default?: boolean;
      /**
       * @description The default value for a squash merge commit title:
       *
       * - `PR_TITLE` - default to the pull request's title.
       * - `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).
       * @enum {string}
       */
      squash_merge_commit_title?: "PR_TITLE" | "COMMIT_OR_PR_TITLE";
      /**
       * @description The default value for a squash merge commit message:
       *
       * - `PR_BODY` - default to the pull request's body.
       * - `COMMIT_MESSAGES` - default to the branch's commit messages.
       * - `BLANK` - default to a blank commit message.
       * @enum {string}
       */
      squash_merge_commit_message?: "PR_BODY" | "COMMIT_MESSAGES" | "BLANK";
      /**
       * @description The default value for a merge commit title.
       *
       * - `PR_TITLE` - default to the pull request's title.
       * - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).
       * @enum {string}
       */
      merge_commit_title?: "PR_TITLE" | "MERGE_MESSAGE";
      /**
       * @description The default value for a merge commit message.
       *
       * - `PR_TITLE` - default to the pull request's title.
       * - `PR_BODY` - default to the pull request's body.
       * - `BLANK` - default to a blank commit message.
       * @enum {string}
       */
      merge_commit_message?: "PR_BODY" | "PR_TITLE" | "BLANK";
      /**
       * @description Whether to allow merge commits for pull requests.
       * @default true
       * @example true
       */
      allow_merge_commit?: boolean;
      /** @description Whether to allow forking this repo */
      allow_forking?: boolean;
      /**
       * @description Whether to require contributors to sign off on web-based commits
       * @default false
       */
      web_commit_signoff_required?: boolean;
      open_issues: number;
      watchers: number;
      master_branch?: string;
      /** @example "2020-07-09T00:17:42Z" */
      starred_at?: string;
      /** @description Whether anonymous git access is enabled for this repository */
      anonymous_access_enabled?: boolean;
    } | null;
    /**
     * Code Of Conduct Simple
     * @description Code of Conduct Simple
     */
    "code-of-conduct-simple": {
      /**
       * Format: uri
       * @example https://api.github.com/repos/github/docs/community/code_of_conduct
       */
      url: string;
      /** @example citizen_code_of_conduct */
      key: string;
      /** @example Citizen Code of Conduct */
      name: string;
      /**
       * Format: uri
       * @example https://github.com/github/docs/blob/main/CODE_OF_CONDUCT.md
       */
      html_url: string | null;
    };
    /**
     * Full Repository
     * @description Full Repository
     */
    "full-repository": {
      /** @example 1296269 */
      id: number;
      /** @example MDEwOlJlcG9zaXRvcnkxMjk2MjY5 */
      node_id: string;
      /** @example Hello-World */
      name: string;
      /** @example octocat/Hello-World */
      full_name: string;
      owner: components["schemas"]["simple-user"];
      private: boolean;
      /**
       * Format: uri
       * @example https://github.com/octocat/Hello-World
       */
      html_url: string;
      /** @example This your first repo! */
      description: string | null;
      fork: boolean;
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/Hello-World
       */
      url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/{archive_format}{/ref} */
      archive_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/assignees{/user} */
      assignees_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/git/blobs{/sha} */
      blobs_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/branches{/branch} */
      branches_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/collaborators{/collaborator} */
      collaborators_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/comments{/number} */
      comments_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/commits{/sha} */
      commits_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/compare/{base}...{head} */
      compare_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/contents/{+path} */
      contents_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/contributors
       */
      contributors_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/deployments
       */
      deployments_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/downloads
       */
      downloads_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/events
       */
      events_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/forks
       */
      forks_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/git/commits{/sha} */
      git_commits_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/git/refs{/sha} */
      git_refs_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/git/tags{/sha} */
      git_tags_url: string;
      /** @example git:github.com/octocat/Hello-World.git */
      git_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/issues/comments{/number} */
      issue_comment_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/issues/events{/number} */
      issue_events_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/issues{/number} */
      issues_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/keys{/key_id} */
      keys_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/labels{/name} */
      labels_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/languages
       */
      languages_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/merges
       */
      merges_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/milestones{/number} */
      milestones_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/notifications{?since,all,participating} */
      notifications_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/pulls{/number} */
      pulls_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/releases{/id} */
      releases_url: string;
      /** @example git@github.com:octocat/Hello-World.git */
      ssh_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/stargazers
       */
      stargazers_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/statuses/{sha} */
      statuses_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/subscribers
       */
      subscribers_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/subscription
       */
      subscription_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/tags
       */
      tags_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/teams
       */
      teams_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/git/trees{/sha} */
      trees_url: string;
      /** @example https://github.com/octocat/Hello-World.git */
      clone_url: string;
      /**
       * Format: uri
       * @example git:git.example.com/octocat/Hello-World
       */
      mirror_url: string | null;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/hooks
       */
      hooks_url: string;
      /**
       * Format: uri
       * @example https://svn.github.com/octocat/Hello-World
       */
      svn_url: string;
      /**
       * Format: uri
       * @example https://github.com
       */
      homepage: string | null;
      language: string | null;
      /** @example 9 */
      forks_count: number;
      /** @example 80 */
      stargazers_count: number;
      /** @example 80 */
      watchers_count: number;
      /**
       * @description The size of the repository, in kilobytes. Size is calculated hourly. When a repository is initially created, the size is 0.
       * @example 108
       */
      size: number;
      /** @example master */
      default_branch: string;
      /** @example 0 */
      open_issues_count: number;
      /** @example true */
      is_template?: boolean;
      /**
       * @example [
       *   "octocat",
       *   "atom",
       *   "electron",
       *   "API"
       * ]
       */
      topics?: string[];
      /** @example true */
      has_issues: boolean;
      /** @example true */
      has_projects: boolean;
      /** @example true */
      has_wiki: boolean;
      has_pages: boolean;
      /** @example true */
      has_downloads?: boolean;
      /** @example true */
      has_discussions: boolean;
      archived: boolean;
      /** @description Returns whether or not this repository disabled. */
      disabled: boolean;
      /**
       * @description The repository visibility: public, private, or internal.
       * @example public
       */
      visibility?: string;
      /**
       * Format: date-time
       * @example 2011-01-26T19:06:43Z
       */
      pushed_at: string;
      /**
       * Format: date-time
       * @example 2011-01-26T19:01:12Z
       */
      created_at: string;
      /**
       * Format: date-time
       * @example 2011-01-26T19:14:43Z
       */
      updated_at: string;
      permissions?: {
        admin: boolean;
        maintain?: boolean;
        push: boolean;
        triage?: boolean;
        pull: boolean;
      };
      /** @example true */
      allow_rebase_merge?: boolean;
      template_repository?: components["schemas"]["nullable-repository"];
      temp_clone_token?: string | null;
      /** @example true */
      allow_squash_merge?: boolean;
      /** @example false */
      allow_auto_merge?: boolean;
      /** @example false */
      delete_branch_on_merge?: boolean;
      /** @example true */
      allow_merge_commit?: boolean;
      /** @example true */
      allow_update_branch?: boolean;
      /** @example false */
      use_squash_pr_title_as_default?: boolean;
      /**
       * @description The default value for a squash merge commit title:
       *
       * - `PR_TITLE` - default to the pull request's title.
       * - `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).
       * @example PR_TITLE
       * @enum {string}
       */
      squash_merge_commit_title?: "PR_TITLE" | "COMMIT_OR_PR_TITLE";
      /**
       * @description The default value for a squash merge commit message:
       *
       * - `PR_BODY` - default to the pull request's body.
       * - `COMMIT_MESSAGES` - default to the branch's commit messages.
       * - `BLANK` - default to a blank commit message.
       * @example PR_BODY
       * @enum {string}
       */
      squash_merge_commit_message?: "PR_BODY" | "COMMIT_MESSAGES" | "BLANK";
      /**
       * @description The default value for a merge commit title.
       *
       *   - `PR_TITLE` - default to the pull request's title.
       *   - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).
       * @example PR_TITLE
       * @enum {string}
       */
      merge_commit_title?: "PR_TITLE" | "MERGE_MESSAGE";
      /**
       * @description The default value for a merge commit message.
       *
       * - `PR_TITLE` - default to the pull request's title.
       * - `PR_BODY` - default to the pull request's body.
       * - `BLANK` - default to a blank commit message.
       * @example PR_BODY
       * @enum {string}
       */
      merge_commit_message?: "PR_BODY" | "PR_TITLE" | "BLANK";
      /** @example true */
      allow_forking?: boolean;
      /** @example false */
      web_commit_signoff_required?: boolean;
      /** @example 42 */
      subscribers_count: number;
      /** @example 0 */
      network_count: number;
      license: components["schemas"]["nullable-license-simple"];
      organization?: components["schemas"]["nullable-simple-user"];
      parent?: components["schemas"]["repository"];
      source?: components["schemas"]["repository"];
      forks: number;
      master_branch?: string;
      open_issues: number;
      watchers: number;
      /**
       * @description Whether anonymous git access is allowed.
       * @default true
       */
      anonymous_access_enabled?: boolean;
      code_of_conduct?: components["schemas"]["code-of-conduct-simple"];
      security_and_analysis?: components["schemas"]["security-and-analysis"];
    };
    /**
     * Repository Fine-Grained Permission
     * @description A fine-grained permission that protects repository resources.
     */
    "repository-fine-grained-permission": {
      name: string;
      description: string;
    };
    /**
     * Team Simple
     * @description Groups of organization members that gives permissions on specified repositories.
     */
    "team-simple": {
      /**
       * @description Unique identifier of the team
       * @example 1
       */
      id: number;
      /** @example MDQ6VGVhbTE= */
      node_id: string;
      /**
       * Format: uri
       * @description URL for the team
       * @example https://api.github.com/organizations/1/team/1
       */
      url: string;
      /** @example https://api.github.com/organizations/1/team/1/members{/member} */
      members_url: string;
      /**
       * @description Name of the team
       * @example Justice League
       */
      name: string;
      /**
       * @description Description of the team
       * @example A great team.
       */
      description: string | null;
      /**
       * @description Permission that the team will have for its repositories
       * @example admin
       */
      permission: string;
      /**
       * @description The level of privacy this team should have
       * @example closed
       */
      privacy?: string;
      /**
       * @description The notification setting the team has set
       * @example notifications_enabled
       */
      notification_setting?: string;
      /**
       * Format: uri
       * @example https://github.com/orgs/rails/teams/core
       */
      html_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/organizations/1/team/1/repos
       */
      repositories_url: string;
      /** @example justice-league */
      slug: string;
      /**
       * @description Distinguished Name (DN) that team maps to within LDAP environment
       * @example uid=example,ou=users,dc=github,dc=com
       */
      ldap_dn?: string;
    };
    /**
     * Team Simple
     * @description Groups of organization members that gives permissions on specified repositories.
     */
    "nullable-team-simple": {
      /**
       * @description Unique identifier of the team
       * @example 1
       */
      id: number;
      /** @example MDQ6VGVhbTE= */
      node_id: string;
      /**
       * Format: uri
       * @description URL for the team
       * @example https://api.github.com/organizations/1/team/1
       */
      url: string;
      /** @example https://api.github.com/organizations/1/team/1/members{/member} */
      members_url: string;
      /**
       * @description Name of the team
       * @example Justice League
       */
      name: string;
      /**
       * @description Description of the team
       * @example A great team.
       */
      description: string | null;
      /**
       * @description Permission that the team will have for its repositories
       * @example admin
       */
      permission: string;
      /**
       * @description The level of privacy this team should have
       * @example closed
       */
      privacy?: string;
      /**
       * @description The notification setting the team has set
       * @example notifications_enabled
       */
      notification_setting?: string;
      /**
       * Format: uri
       * @example https://github.com/orgs/rails/teams/core
       */
      html_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/organizations/1/team/1/repos
       */
      repositories_url: string;
      /** @example justice-league */
      slug: string;
      /**
       * @description Distinguished Name (DN) that team maps to within LDAP environment
       * @example uid=example,ou=users,dc=github,dc=com
       */
      ldap_dn?: string;
    } | null;
    /**
     * Team
     * @description Groups of organization members that gives permissions on specified repositories.
     */
    team: {
      id: number;
      node_id: string;
      name: string;
      slug: string;
      description: string | null;
      privacy?: string;
      notification_setting?: string;
      permission: string;
      permissions?: {
        pull: boolean;
        triage: boolean;
        push: boolean;
        maintain: boolean;
        admin: boolean;
      };
      /** Format: uri */
      url: string;
      /**
       * Format: uri
       * @example https://github.com/orgs/rails/teams/core
       */
      html_url: string;
      members_url: string;
      /** Format: uri */
      repositories_url: string;
      parent: components["schemas"]["nullable-team-simple"];
    };
    /**
     * Team Organization
     * @description Team Organization
     */
    "team-organization": {
      /** @example github */
      login: string;
      /** @example 1 */
      id: number;
      /** @example MDEyOk9yZ2FuaXphdGlvbjE= */
      node_id: string;
      /**
       * Format: uri
       * @example https://api.github.com/orgs/github
       */
      url: string;
      /**
       * Format: uri
       * @example https://api.github.com/orgs/github/repos
       */
      repos_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/orgs/github/events
       */
      events_url: string;
      /** @example https://api.github.com/orgs/github/hooks */
      hooks_url: string;
      /** @example https://api.github.com/orgs/github/issues */
      issues_url: string;
      /** @example https://api.github.com/orgs/github/members{/member} */
      members_url: string;
      /** @example https://api.github.com/orgs/github/public_members{/member} */
      public_members_url: string;
      /** @example https://github.com/images/error/octocat_happy.gif */
      avatar_url: string;
      /** @example A great organization */
      description: string | null;
      /** @example github */
      name?: string;
      /** @example GitHub */
      company?: string;
      /**
       * Format: uri
       * @example https://github.com/blog
       */
      blog?: string;
      /** @example San Francisco */
      location?: string;
      /**
       * Format: email
       * @example octocat@github.com
       */
      email?: string;
      /** @example github */
      twitter_username?: string | null;
      /** @example true */
      is_verified?: boolean;
      /** @example true */
      has_organization_projects: boolean;
      /** @example true */
      has_repository_projects: boolean;
      /** @example 2 */
      public_repos: number;
      /** @example 1 */
      public_gists: number;
      /** @example 20 */
      followers: number;
      /** @example 0 */
      following: number;
      /**
       * Format: uri
       * @example https://github.com/octocat
       */
      html_url: string;
      /**
       * Format: date-time
       * @example 2008-01-14T04:33:35Z
       */
      created_at: string;
      /** @example Organization */
      type: string;
      /** @example 100 */
      total_private_repos?: number;
      /** @example 100 */
      owned_private_repos?: number;
      /** @example 81 */
      private_gists?: number | null;
      /** @example 10000 */
      disk_usage?: number | null;
      /** @example 8 */
      collaborators?: number | null;
      /**
       * Format: email
       * @example org@example.com
       */
      billing_email?: string | null;
      plan?: {
        name: string;
        space: number;
        private_repos: number;
        filled_seats?: number;
        seats?: number;
      };
      default_repository_permission?: string | null;
      /** @example true */
      members_can_create_repositories?: boolean | null;
      /** @example true */
      two_factor_requirement_enabled?: boolean | null;
      /** @example all */
      members_allowed_repository_creation_type?: string;
      /** @example true */
      members_can_create_public_repositories?: boolean;
      /** @example true */
      members_can_create_private_repositories?: boolean;
      /** @example true */
      members_can_create_internal_repositories?: boolean;
      /** @example true */
      members_can_create_pages?: boolean;
      /** @example true */
      members_can_create_public_pages?: boolean;
      /** @example true */
      members_can_create_private_pages?: boolean;
      /** @example false */
      members_can_fork_private_repositories?: boolean | null;
      /** @example false */
      web_commit_signoff_required?: boolean;
      /** Format: date-time */
      updated_at: string;
    };
    /**
     * Full Team
     * @description Groups of organization members that gives permissions on specified repositories.
     */
    "team-full": {
      /**
       * @description Unique identifier of the team
       * @example 42
       */
      id: number;
      /** @example MDQ6VGVhbTE= */
      node_id: string;
      /**
       * Format: uri
       * @description URL for the team
       * @example https://api.github.com/organizations/1/team/1
       */
      url: string;
      /**
       * Format: uri
       * @example https://github.com/orgs/rails/teams/core
       */
      html_url: string;
      /**
       * @description Name of the team
       * @example Developers
       */
      name: string;
      /** @example justice-league */
      slug: string;
      /** @example A great team. */
      description: string | null;
      /**
       * @description The level of privacy this team should have
       * @example closed
       * @enum {string}
       */
      privacy?: "closed" | "secret";
      /**
       * @description The notification setting the team has set
       * @example notifications_enabled
       * @enum {string}
       */
      notification_setting?: "notifications_enabled" | "notifications_disabled";
      /**
       * @description Permission that the team will have for its repositories
       * @example push
       */
      permission: string;
      /** @example https://api.github.com/organizations/1/team/1/members{/member} */
      members_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/organizations/1/team/1/repos
       */
      repositories_url: string;
      parent?: components["schemas"]["nullable-team-simple"];
      /** @example 3 */
      members_count: number;
      /** @example 10 */
      repos_count: number;
      /**
       * Format: date-time
       * @example 2017-07-14T16:53:42Z
       */
      created_at: string;
      /**
       * Format: date-time
       * @example 2017-08-17T12:37:15Z
       */
      updated_at: string;
      organization: components["schemas"]["team-organization"];
      /**
       * @description Distinguished Name (DN) that team maps to within LDAP environment
       * @example uid=example,ou=users,dc=github,dc=com
       */
      ldap_dn?: string;
    };
    /**
     * Team Discussion
     * @description A team discussion is a persistent record of a free-form conversation within a team.
     */
    "team-discussion": {
      author: components["schemas"]["nullable-simple-user"];
      /**
       * @description The main text of the discussion.
       * @example Please suggest improvements to our workflow in comments.
       */
      body: string;
      /** @example <p>Hi! This is an area for us to collaborate as a team</p> */
      body_html: string;
      /**
       * @description The current version of the body content. If provided, this update operation will be rejected if the given version does not match the latest version on the server.
       * @example 0307116bbf7ced493b8d8a346c650b71
       */
      body_version: string;
      /** @example 0 */
      comments_count: number;
      /**
       * Format: uri
       * @example https://api.github.com/organizations/1/team/2343027/discussions/1/comments
       */
      comments_url: string;
      /**
       * Format: date-time
       * @example 2018-01-25T18:56:31Z
       */
      created_at: string;
      /** Format: date-time */
      last_edited_at: string | null;
      /**
       * Format: uri
       * @example https://github.com/orgs/github/teams/justice-league/discussions/1
       */
      html_url: string;
      /** @example MDE0OlRlYW1EaXNjdXNzaW9uMQ== */
      node_id: string;
      /**
       * @description The unique sequence number of a team discussion.
       * @example 42
       */
      number: number;
      /**
       * @description Whether or not this discussion should be pinned for easy retrieval.
       * @example true
       */
      pinned: boolean;
      /**
       * @description Whether or not this discussion should be restricted to team members and organization owners.
       * @example true
       */
      private: boolean;
      /**
       * Format: uri
       * @example https://api.github.com/organizations/1/team/2343027
       */
      team_url: string;
      /**
       * @description The title of the discussion.
       * @example How can we improve our workflow?
       */
      title: string;
      /**
       * Format: date-time
       * @example 2018-01-25T18:56:31Z
       */
      updated_at: string;
      /**
       * Format: uri
       * @example https://api.github.com/organizations/1/team/2343027/discussions/1
       */
      url: string;
      reactions?: components["schemas"]["reaction-rollup"];
    };
    /**
     * Team Discussion Comment
     * @description A reply to a discussion within a team.
     */
    "team-discussion-comment": {
      author: components["schemas"]["nullable-simple-user"];
      /**
       * @description The main text of the comment.
       * @example I agree with this suggestion.
       */
      body: string;
      /** @example <p>Do you like apples?</p> */
      body_html: string;
      /**
       * @description The current version of the body content. If provided, this update operation will be rejected if the given version does not match the latest version on the server.
       * @example 0307116bbf7ced493b8d8a346c650b71
       */
      body_version: string;
      /**
       * Format: date-time
       * @example 2018-01-15T23:53:58Z
       */
      created_at: string;
      /** Format: date-time */
      last_edited_at: string | null;
      /**
       * Format: uri
       * @example https://api.github.com/organizations/1/team/2403582/discussions/1
       */
      discussion_url: string;
      /**
       * Format: uri
       * @example https://github.com/orgs/github/teams/justice-league/discussions/1/comments/1
       */
      html_url: string;
      /** @example MDIxOlRlYW1EaXNjdXNzaW9uQ29tbWVudDE= */
      node_id: string;
      /**
       * @description The unique sequence number of a team discussion comment.
       * @example 42
       */
      number: number;
      /**
       * Format: date-time
       * @example 2018-01-15T23:53:58Z
       */
      updated_at: string;
      /**
       * Format: uri
       * @example https://api.github.com/organizations/1/team/2403582/discussions/1/comments/1
       */
      url: string;
      reactions?: components["schemas"]["reaction-rollup"];
    };
    /**
     * Reaction
     * @description Reactions to conversations provide a way to help people express their feelings more simply and effectively.
     */
    reaction: {
      /** @example 1 */
      id: number;
      /** @example MDg6UmVhY3Rpb24x */
      node_id: string;
      user: components["schemas"]["nullable-simple-user"];
      /**
       * @description The reaction to use
       * @example heart
       * @enum {string}
       */
      content:
        | "+1"
        | "-1"
        | "laugh"
        | "confused"
        | "heart"
        | "hooray"
        | "rocket"
        | "eyes";
      /**
       * Format: date-time
       * @example 2016-05-20T20:09:31Z
       */
      created_at: string;
    };
    /**
     * Team Membership
     * @description Team Membership
     */
    "team-membership": {
      /** Format: uri */
      url: string;
      /**
       * @description The role of the user in the team.
       * @default member
       * @example member
       * @enum {string}
       */
      role: "member" | "maintainer";
      /**
       * @description The state of the user's membership in the team.
       * @enum {string}
       */
      state: "active" | "pending";
    };
    /**
     * Team Project
     * @description A team's access to a project.
     */
    "team-project": {
      owner_url: string;
      url: string;
      html_url: string;
      columns_url: string;
      id: number;
      node_id: string;
      name: string;
      body: string | null;
      number: number;
      state: string;
      creator: components["schemas"]["simple-user"];
      created_at: string;
      updated_at: string;
      /** @description The organization permission for this project. Only present when owner is an organization. */
      organization_permission?: string;
      /** @description Whether the project is private or not. Only present when owner is an organization. */
      private?: boolean;
      permissions: {
        read: boolean;
        write: boolean;
        admin: boolean;
      };
    };
    /**
     * Team Repository
     * @description A team's access to a repository.
     */
    "team-repository": {
      /**
       * @description Unique identifier of the repository
       * @example 42
       */
      id: number;
      /** @example MDEwOlJlcG9zaXRvcnkxMjk2MjY5 */
      node_id: string;
      /**
       * @description The name of the repository.
       * @example Team Environment
       */
      name: string;
      /** @example octocat/Hello-World */
      full_name: string;
      license: components["schemas"]["nullable-license-simple"];
      forks: number;
      permissions?: {
        admin: boolean;
        pull: boolean;
        triage?: boolean;
        push: boolean;
        maintain?: boolean;
      };
      /** @example admin */
      role_name?: string;
      owner: components["schemas"]["nullable-simple-user"];
      /**
       * @description Whether the repository is private or public.
       * @default false
       */
      private: boolean;
      /**
       * Format: uri
       * @example https://github.com/octocat/Hello-World
       */
      html_url: string;
      /** @example This your first repo! */
      description: string | null;
      fork: boolean;
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/Hello-World
       */
      url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/{archive_format}{/ref} */
      archive_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/assignees{/user} */
      assignees_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/git/blobs{/sha} */
      blobs_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/branches{/branch} */
      branches_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/collaborators{/collaborator} */
      collaborators_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/comments{/number} */
      comments_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/commits{/sha} */
      commits_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/compare/{base}...{head} */
      compare_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/contents/{+path} */
      contents_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/contributors
       */
      contributors_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/deployments
       */
      deployments_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/downloads
       */
      downloads_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/events
       */
      events_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/forks
       */
      forks_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/git/commits{/sha} */
      git_commits_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/git/refs{/sha} */
      git_refs_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/git/tags{/sha} */
      git_tags_url: string;
      /** @example git:github.com/octocat/Hello-World.git */
      git_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/issues/comments{/number} */
      issue_comment_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/issues/events{/number} */
      issue_events_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/issues{/number} */
      issues_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/keys{/key_id} */
      keys_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/labels{/name} */
      labels_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/languages
       */
      languages_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/merges
       */
      merges_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/milestones{/number} */
      milestones_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/notifications{?since,all,participating} */
      notifications_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/pulls{/number} */
      pulls_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/releases{/id} */
      releases_url: string;
      /** @example git@github.com:octocat/Hello-World.git */
      ssh_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/stargazers
       */
      stargazers_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/statuses/{sha} */
      statuses_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/subscribers
       */
      subscribers_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/subscription
       */
      subscription_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/tags
       */
      tags_url: string;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/teams
       */
      teams_url: string;
      /** @example http://api.github.com/repos/octocat/Hello-World/git/trees{/sha} */
      trees_url: string;
      /** @example https://github.com/octocat/Hello-World.git */
      clone_url: string;
      /**
       * Format: uri
       * @example git:git.example.com/octocat/Hello-World
       */
      mirror_url: string | null;
      /**
       * Format: uri
       * @example http://api.github.com/repos/octocat/Hello-World/hooks
       */
      hooks_url: string;
      /**
       * Format: uri
       * @example https://svn.github.com/octocat/Hello-World
       */
      svn_url: string;
      /**
       * Format: uri
       * @example https://github.com
       */
      homepage: string | null;
      language: string | null;
      /** @example 9 */
      forks_count: number;
      /** @example 80 */
      stargazers_count: number;
      /** @example 80 */
      watchers_count: number;
      /** @example 108 */
      size: number;
      /**
       * @description The default branch of the repository.
       * @example master
       */
      default_branch: string;
      /** @example 0 */
      open_issues_count: number;
      /**
       * @description Whether this repository acts as a template that can be used to generate new repositories.
       * @default false
       * @example true
       */
      is_template?: boolean;
      topics?: string[];
      /**
       * @description Whether issues are enabled.
       * @default true
       * @example true
       */
      has_issues: boolean;
      /**
       * @description Whether projects are enabled.
       * @default true
       * @example true
       */
      has_projects: boolean;
      /**
       * @description Whether the wiki is enabled.
       * @default true
       * @example true
       */
      has_wiki: boolean;
      has_pages: boolean;
      /**
       * @description Whether downloads are enabled.
       * @default true
       * @example true
       */
      has_downloads: boolean;
      /**
       * @description Whether the repository is archived.
       * @default false
       */
      archived: boolean;
      /** @description Returns whether or not this repository disabled. */
      disabled: boolean;
      /**
       * @description The repository visibility: public, private, or internal.
       * @default public
       */
      visibility?: string;
      /**
       * Format: date-time
       * @example 2011-01-26T19:06:43Z
       */
      pushed_at: string | null;
      /**
       * Format: date-time
       * @example 2011-01-26T19:01:12Z
       */
      created_at: string | null;
      /**
       * Format: date-time
       * @example 2011-01-26T19:14:43Z
       */
      updated_at: string | null;
      /**
       * @description Whether to allow rebase merges for pull requests.
       * @default true
       * @example true
       */
      allow_rebase_merge?: boolean;
      temp_clone_token?: string;
      /**
       * @description Whether to allow squash merges for pull requests.
       * @default true
       * @example true
       */
      allow_squash_merge?: boolean;
      /**
       * @description Whether to allow Auto-merge to be used on pull requests.
       * @default false
       * @example false
       */
      allow_auto_merge?: boolean;
      /**
       * @description Whether to delete head branches when pull requests are merged
       * @default false
       * @example false
       */
      delete_branch_on_merge?: boolean;
      /**
       * @description Whether to allow merge commits for pull requests.
       * @default true
       * @example true
       */
      allow_merge_commit?: boolean;
      /**
       * @description Whether to allow forking this repo
       * @default false
       * @example false
       */
      allow_forking?: boolean;
      /**
       * @description Whether to require contributors to sign off on web-based commits
       * @default false
       * @example false
       */
      web_commit_signoff_required?: boolean;
      subscribers_count?: number;
      network_count?: number;
      open_issues: number;
      watchers: number;
      master_branch?: string;
    };
    /**
     * Project Card
     * @description Project cards represent a scope of work.
     */
    "project-card": {
      /**
       * Format: uri
       * @example https://api.github.com/projects/columns/cards/1478
       */
      url: string;
      /**
       * @description The project card's ID
       * @example 42
       */
      id: number;
      /** @example MDExOlByb2plY3RDYXJkMTQ3OA== */
      node_id: string;
      /** @example Add payload for delete Project column */
      note: string | null;
      creator: components["schemas"]["nullable-simple-user"];
      /**
       * Format: date-time
       * @example 2016-09-05T14:21:06Z
       */
      created_at: string;
      /**
       * Format: date-time
       * @example 2016-09-05T14:20:22Z
       */
      updated_at: string;
      /**
       * @description Whether or not the card is archived
       * @example false
       */
      archived?: boolean;
      column_name?: string;
      project_id?: string;
      /**
       * Format: uri
       * @example https://api.github.com/projects/columns/367
       */
      column_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/repos/api-playground/projects-test/issues/3
       */
      content_url?: string;
      /**
       * Format: uri
       * @example https://api.github.com/projects/120
       */
      project_url: string;
    };
    /**
     * Project Column
     * @description Project columns contain cards of work.
     */
    "project-column": {
      /**
       * Format: uri
       * @example https://api.github.com/projects/columns/367
       */
      url: string;
      /**
       * Format: uri
       * @example https://api.github.com/projects/120
       */
      project_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/projects/columns/367/cards
       */
      cards_url: string;
      /**
       * @description The unique identifier of the project column
       * @example 42
       */
      id: number;
      /** @example MDEzOlByb2plY3RDb2x1bW4zNjc= */
      node_id: string;
      /**
       * @description Name of the project column
       * @example Remaining tasks
       */
      name: string;
      /**
       * Format: date-time
       * @example 2016-09-05T14:18:44Z
       */
      created_at: string;
      /**
       * Format: date-time
       * @example 2016-09-05T14:22:28Z
       */
      updated_at: string;
    };
    /**
     * Project Collaborator Permission
     * @description Project Collaborator Permission
     */
    "project-collaborator-permission": {
      permission: string;
      user: components["schemas"]["nullable-simple-user"];
    };
    /** Rate Limit */
    "rate-limit": {
      limit: number;
      remaining: number;
      reset: number;
      used: number;
    };
    /**
     * Rate Limit Overview
     * @description Rate Limit Overview
     */
    "rate-limit-overview": {
      resources: {
        core: components["schemas"]["rate-limit"];
        graphql?: components["schemas"]["rate-limit"];
        search: components["schemas"]["rate-limit"];
        code_search?: components["schemas"]["rate-limit"];
        source_import?: components["schemas"]["rate-limit"];
        integration_manifest?: components["schemas"]["rate-limit"];
        code_scanning_upload?: components["schemas"]["rate-limit"];
        actions_runner_registration?: components["schemas"]["rate-limit"];
        scim?: components["schemas"]["rate-limit"];
      };
      rate: components["schemas"]["rate-limit"];
    };
    /**
     * Artifact
     * @description An artifact
     */
    artifact: {
      /** @example 5 */
      id: number;
      /** @example MDEwOkNoZWNrU3VpdGU1 */
      node_id: string;
      /**
       * @description The name of the artifact.
       * @example AdventureWorks.Framework
       */
      name: string;
      /**
       * @description The size in bytes of the artifact.
       * @example 12345
       */
      size_in_bytes: number;
      /** @example https://api.github.com/repos/github/hello-world/actions/artifacts/5 */
      url: string;
      /** @example https://api.github.com/repos/github/hello-world/actions/artifacts/5/zip */
      archive_download_url: string;
      /** @description Whether or not the artifact has expired. */
      expired: boolean;
      /** Format: date-time */
      created_at: string | null;
      /** Format: date-time */
      expires_at: string | null;
      /** Format: date-time */
      updated_at: string | null;
      workflow_run?: {
        /** @example 10 */
        id?: number;
        /** @example 42 */
        repository_id?: number;
        /** @example 42 */
        head_repository_id?: number;
        /** @example main */
        head_branch?: string;
        /** @example 009b8a3a9ccbb128af87f9b1c0f4c62e8a304f6d */
        head_sha?: string;
      } | null;
    };
    /**
     * Actions cache usage policy for repository
     * @description GitHub Actions cache usage policy for repository.
     */
    "actions-cache-usage-policy-for-repository": {
      /**
       * @description The size limit for the sum of all caches, in gigabytes.
       * @example 14
       */
      repo_cache_size_limit_in_gb: number;
    };
    /**
     * Repository actions caches
     * @description Repository actions caches
     */
    "actions-cache-list": {
      /**
       * @description Total number of caches
       * @example 2
       */
      total_count: number;
      /** @description Array of caches */
      actions_caches: {
        /** @example 2 */
        id?: number;
        /** @example refs/heads/main */
        ref?: string;
        /** @example Linux-node-958aff96db2d75d67787d1e634ae70b659de937b */
        key?: string;
        /** @example 73885106f58cc52a7df9ec4d4a5622a5614813162cb516c759a30af6bf56e6f0 */
        version?: string;
        /**
         * Format: date-time
         * @example 2019-01-24T22:45:36.000Z
         */
        last_accessed_at?: string;
        /**
         * Format: date-time
         * @example 2019-01-24T22:45:36.000Z
         */
        created_at?: string;
        /** @example 1024 */
        size_in_bytes?: number;
      }[];
    };
    /**
     * Job
     * @description Information of a job execution in a workflow run
     */
    job: {
      /**
       * @description The id of the job.
       * @example 21
       */
      id: number;
      /**
       * @description The id of the associated workflow run.
       * @example 5
       */
      run_id: number;
      /** @example https://api.github.com/repos/github/hello-world/actions/runs/5 */
      run_url: string;
      /**
       * @description Attempt number of the associated workflow run, 1 for first attempt and higher if the workflow was re-run.
       * @example 1
       */
      run_attempt?: number;
      /** @example MDg6Q2hlY2tSdW40 */
      node_id: string;
      /**
       * @description The SHA of the commit that is being run.
       * @example 009b8a3a9ccbb128af87f9b1c0f4c62e8a304f6d
       */
      head_sha: string;
      /** @example https://api.github.com/repos/github/hello-world/actions/jobs/21 */
      url: string;
      /** @example https://github.com/github/hello-world/runs/4 */
      html_url: string | null;
      /**
       * @description The phase of the lifecycle that the job is currently in.
       * @example queued
       * @enum {string}
       */
      status:
        | "queued"
        | "in_progress"
        | "completed"
        | "waiting"
        | "requested"
        | "pending";
      /**
       * @description The outcome of the job.
       * @example success
       * @enum {string|null}
       */
      conclusion:
        | "success"
        | "failure"
        | "neutral"
        | "cancelled"
        | "skipped"
        | "timed_out"
        | "action_required"
        | null;
      /**
       * Format: date-time
       * @description The time that the job created, in ISO 8601 format.
       * @example 2019-08-08T08:00:00-07:00
       */
      created_at: string;
      /**
       * Format: date-time
       * @description The time that the job started, in ISO 8601 format.
       * @example 2019-08-08T08:00:00-07:00
       */
      started_at: string;
      /**
       * Format: date-time
       * @description The time that the job finished, in ISO 8601 format.
       * @example 2019-08-08T08:00:00-07:00
       */
      completed_at: string | null;
      /**
       * @description The name of the job.
       * @example test-coverage
       */
      name: string;
      /** @description Steps in this job. */
      steps?: {
        /**
         * @description The phase of the lifecycle that the job is currently in.
         * @example queued
         * @enum {string}
         */
        status: "queued" | "in_progress" | "completed";
        /**
         * @description The outcome of the job.
         * @example success
         */
        conclusion: string | null;
        /**
         * @description The name of the job.
         * @example test-coverage
         */
        name: string;
        /** @example 1 */
        number: number;
        /**
         * Format: date-time
         * @description The time that the step started, in ISO 8601 format.
         * @example 2019-08-08T08:00:00-07:00
         */
        started_at?: string | null;
        /**
         * Format: date-time
         * @description The time that the job finished, in ISO 8601 format.
         * @example 2019-08-08T08:00:00-07:00
         */
        completed_at?: string | null;
      }[];
      /** @example https://api.github.com/repos/github/hello-world/check-runs/4 */
      check_run_url: string;
      /**
       * @description Labels for the workflow job. Specified by the "runs_on" attribute in the action's workflow file.
       * @example [
       *   "self-hosted",
       *   "foo",
       *   "bar"
       * ]
       */
      labels: string[];
      /**
       * @description The ID of the runner to which this job has been assigned. (If a runner hasn't yet been assigned, this will be null.)
       * @example 1
       */
      runner_id: number | null;
      /**
       * @description The name of the runner to which this job has been assigned. (If a runner hasn't yet been assigned, this will be null.)
       * @example my runner
       */
      runner_name: string | null;
      /**
       * @description The ID of the runner group to which this job has been assigned. (If a runner hasn't yet been assigned, this will be null.)
       * @example 2
       */
      runner_group_id: number | null;
      /**
       * @description The name of the runner group to which this job has been assigned. (If a runner hasn't yet been assigned, this will be null.)
       * @example my runner group
       */
      runner_group_name: string | null;
      /**
       * @description The name of the workflow.
       * @example Build
       */
      workflow_name: string | null;
      /**
       * @description The name of the current branch.
       * @example main
       */
      head_branch: string | null;
    };
    /**
     * Actions OIDC subject customization for a repository
     * @description Actions OIDC subject customization for a repository
     */
    "oidc-custom-sub-repo": {
      /** @description Whether to use the default template or not. If `true`, the `include_claim_keys` field is ignored. */
      use_default: boolean;
      /** @description Array of unique strings. Each claim key can only contain alphanumeric characters and underscores. */
      include_claim_keys?: string[];
    };
    /**
     * Actions Secret
     * @description Set secrets for GitHub Actions.
     */
    "actions-secret": {
      /**
       * @description The name of the secret.
       * @example SECRET_TOKEN
       */
      name: string;
      /** Format: date-time */
      created_at: string;
      /** Format: date-time */
      updated_at: string;
    };
    /** Actions Variable */
    "actions-variable": {
      /**
       * @description The name of the variable.
       * @example USERNAME
       */
      name: string;
      /**
       * @description The value of the variable.
       * @example octocat
       */
      value: string;
      /**
       * Format: date-time
       * @description The date and time at which the variable was created, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.
       * @example 2019-01-24T22:45:36.000Z
       */
      created_at: string;
      /**
       * Format: date-time
       * @description The date and time at which the variable was last updated, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.
       * @example 2019-01-24T22:45:36.000Z
       */
      updated_at: string;
    };
    /** @description Whether GitHub Actions is enabled on the repository. */
    "actions-enabled": boolean;
    "actions-repository-permissions": {
      enabled: components["schemas"]["actions-enabled"];
      allowed_actions?: components["schemas"]["allowed-actions"];
      selected_actions_url?: components["schemas"]["selected-actions-url"];
    };
    "actions-workflow-access-to-repository": {
      /**
       * @description Defines the level of access that workflows outside of the repository have to actions and reusable workflows within the
       * repository.
       *
       * `none` means the access is only possible from workflows in this repository. `user` level access allows sharing across user owned private repositories only. `organization` level access allows sharing across the organization. `enterprise` level access allows sharing across the enterprise.
       * @enum {string}
       */
      access_level: "none" | "user" | "organization" | "enterprise";
    };
    /**
     * Referenced workflow
     * @description A workflow referenced/reused by the initial caller workflow
     */
    "referenced-workflow": {
      path: string;
      sha: string;
      ref?: string;
    };
    /** Pull Request Minimal */
    "pull-request-minimal": {
      id: number;
      number: number;
      url: string;
      head: {
        ref: string;
        sha: string;
        repo: {
          id: number;
          url: string;
          name: string;
        };
      };
      base: {
        ref: string;
        sha: string;
        repo: {
          id: number;
          url: string;
          name: string;
        };
      };
    };
    /**
     * Simple Commit
     * @description A commit.
     */
    "nullable-simple-commit": {
      /**
       * @description SHA for the commit
       * @example 7638417db6d59f3c431d3e1f261cc637155684cd
       */
      id: string;
      /** @description SHA for the commit's tree */
      tree_id: string;
      /**
       * @description Message describing the purpose of the commit
       * @example Fix #42
       */
      message: string;
      /**
       * Format: date-time
       * @description Timestamp of the commit
       * @example 2014-08-09T08:02:04+12:00
       */
      timestamp: string;
      /** @description Information about the Git author */
      author: {
        /**
         * @description Name of the commit's author
         * @example Monalisa Octocat
         */
        name: string;
        /**
         * Format: email
         * @description Git email address of the commit's author
         * @example monalisa.octocat@example.com
         */
        email: string;
      } | null;
      /** @description Information about the Git committer */
      committer: {
        /**
         * @description Name of the commit's committer
         * @example Monalisa Octocat
         */
        name: string;
        /**
         * Format: email
         * @description Git email address of the commit's committer
         * @example monalisa.octocat@example.com
         */
        email: string;
      } | null;
    } | null;
    /**
     * Workflow Run
     * @description An invocation of a workflow
     */
    "workflow-run": {
      /**
       * @description The ID of the workflow run.
       * @example 5
       */
      id: number;
      /**
       * @description The name of the workflow run.
       * @example Build
       */
      name?: string | null;
      /** @example MDEwOkNoZWNrU3VpdGU1 */
      node_id: string;
      /**
       * @description The ID of the associated check suite.
       * @example 42
       */
      check_suite_id?: number;
      /**
       * @description The node ID of the associated check suite.
       * @example MDEwOkNoZWNrU3VpdGU0Mg==
       */
      check_suite_node_id?: string;
      /** @example master */
      head_branch: string | null;
      /**
       * @description The SHA of the head commit that points to the version of the workflow being run.
       * @example 009b8a3a9ccbb128af87f9b1c0f4c62e8a304f6d
       */
      head_sha: string;
      /**
       * @description The full path of the workflow
       * @example octocat/octo-repo/.github/workflows/ci.yml@main
       */
      path: string;
      /**
       * @description The auto incrementing run number for the workflow run.
       * @example 106
       */
      run_number: number;
      /**
       * @description Attempt number of the run, 1 for first attempt and higher if the workflow was re-run.
       * @example 1
       */
      run_attempt?: number;
      referenced_workflows?:
        | components["schemas"]["referenced-workflow"][]
        | null;
      /** @example push */
      event: string;
      /** @example completed */
      status: string | null;
      /** @example neutral */
      conclusion: string | null;
      /**
       * @description The ID of the parent workflow.
       * @example 5
       */
      workflow_id: number;
      /**
       * @description The URL to the workflow run.
       * @example https://api.github.com/repos/github/hello-world/actions/runs/5
       */
      url: string;
      /** @example https://github.com/github/hello-world/suites/4 */
      html_url: string;
      /** @description Pull requests that are open with a `head_sha` or `head_branch` that matches the workflow run. The returned pull requests do not necessarily indicate pull requests that triggered the run. */
      pull_requests: components["schemas"]["pull-request-minimal"][] | null;
      /** Format: date-time */
      created_at: string;
      /** Format: date-time */
      updated_at: string;
      actor?: components["schemas"]["simple-user"];
      triggering_actor?: components["schemas"]["simple-user"];
      /**
       * Format: date-time
       * @description The start time of the latest run. Resets on re-run.
       */
      run_started_at?: string;
      /**
       * @description The URL to the jobs for the workflow run.
       * @example https://api.github.com/repos/github/hello-world/actions/runs/5/jobs
       */
      jobs_url: string;
      /**
       * @description The URL to download the logs for the workflow run.
       * @example https://api.github.com/repos/github/hello-world/actions/runs/5/logs
       */
      logs_url: string;
      /**
       * @description The URL to the associated check suite.
       * @example https://api.github.com/repos/github/hello-world/check-suites/12
       */
      check_suite_url: string;
      /**
       * @description The URL to the artifacts for the workflow run.
       * @example https://api.github.com/repos/github/hello-world/actions/runs/5/rerun/artifacts
       */
      artifacts_url: string;
      /**
       * @description The URL to cancel the workflow run.
       * @example https://api.github.com/repos/github/hello-world/actions/runs/5/cancel
       */
      cancel_url: string;
      /**
       * @description The URL to rerun the workflow run.
       * @example https://api.github.com/repos/github/hello-world/actions/runs/5/rerun
       */
      rerun_url: string;
      /**
       * @description The URL to the previous attempted run of this workflow, if one exists.
       * @example https://api.github.com/repos/github/hello-world/actions/runs/5/attempts/3
       */
      previous_attempt_url?: string | null;
      /**
       * @description The URL to the workflow.
       * @example https://api.github.com/repos/github/hello-world/actions/workflows/main.yaml
       */
      workflow_url: string;
      head_commit: components["schemas"]["nullable-simple-commit"];
      repository: components["schemas"]["minimal-repository"];
      head_repository: components["schemas"]["minimal-repository"];
      /** @example 5 */
      head_repository_id?: number;
      /**
       * @description The event-specific title associated with the run or the run-name if set, or the value of `run-name` if it is set in the workflow.
       * @example Simple Workflow
       */
      display_title: string;
    };
    /**
     * Environment Approval
     * @description An entry in the reviews log for environment deployments
     */
    "environment-approvals": {
      /** @description The list of environments that were approved or rejected */
      environments: {
        /**
         * @description The id of the environment.
         * @example 56780428
         */
        id?: number;
        /** @example MDExOkVudmlyb25tZW50NTY3ODA0Mjg= */
        node_id?: string;
        /**
         * @description The name of the environment.
         * @example staging
         */
        name?: string;
        /** @example https://api.github.com/repos/github/hello-world/environments/staging */
        url?: string;
        /** @example https://github.com/github/hello-world/deployments/activity_log?environments_filter=staging */
        html_url?: string;
        /**
         * Format: date-time
         * @description The time that the environment was created, in ISO 8601 format.
         * @example 2020-11-23T22:00:40Z
         */
        created_at?: string;
        /**
         * Format: date-time
         * @description The time that the environment was last updated, in ISO 8601 format.
         * @example 2020-11-23T22:00:40Z
         */
        updated_at?: string;
      }[];
      /**
       * @description Whether deployment to the environment(s) was approved or rejected or pending (with comments)
       * @example approved
       * @enum {string}
       */
      state: "approved" | "rejected" | "pending";
      user: components["schemas"]["simple-user"];
      /**
       * @description The comment submitted with the deployment review
       * @example Ship it!
       */
      comment: string;
    };
    "review-custom-gates-comment-required": {
      /** @description The name of the environment to approve or reject. */
      environment_name: string;
      /** @description Comment associated with the pending deployment protection rule. **Required when state is not provided.** */
      comment: string;
    };
    "review-custom-gates-state-required": {
      /** @description The name of the environment to approve or reject. */
      environment_name: string;
      /**
       * @description Whether to approve or reject deployment to the specified environments.
       * @enum {string}
       */
      state: "approved" | "rejected";
      /** @description Optional comment to include with the review. */
      comment?: string;
    };
    /**
     * @description The type of reviewer.
     * @example User
     * @enum {string}
     */
    "deployment-reviewer-type": "User" | "Team";
    /**
     * Pending Deployment
     * @description Details of a deployment that is waiting for protection rules to pass
     */
    "pending-deployment": {
      environment: {
        /**
         * @description The id of the environment.
         * @example 56780428
         */
        id?: number;
        /** @example MDExOkVudmlyb25tZW50NTY3ODA0Mjg= */
        node_id?: string;
        /**
         * @description The name of the environment.
         * @example staging
         */
        name?: string;
        /** @example https://api.github.com/repos/github/hello-world/environments/staging */
        url?: string;
        /** @example https://github.com/github/hello-world/deployments/activity_log?environments_filter=staging */
        html_url?: string;
      };
      /**
       * @description The set duration of the wait timer
       * @example 30
       */
      wait_timer: number;
      /**
       * Format: date-time
       * @description The time that the wait timer began.
       * @example 2020-11-23T22:00:40Z
       */
      wait_timer_started_at: string | null;
      /**
       * @description Whether the currently authenticated user can approve the deployment
       * @example true
       */
      current_user_can_approve: boolean;
      /** @description The people or teams that may approve jobs that reference the environment. You can list up to six users or teams as reviewers. The reviewers must have at least read access to the repository. Only one of the required reviewers needs to approve the job for it to proceed. */
      reviewers: {
        type?: components["schemas"]["deployment-reviewer-type"];
        reviewer?:
          | components["schemas"]["simple-user"]
          | components["schemas"]["team"];
      }[];
    };
    /**
     * Deployment
     * @description A request for a specific ref(branch,sha,tag) to be deployed
     */
    deployment: {
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/example/deployments/1
       */
      url: string;
      /**
       * @description Unique identifier of the deployment
       * @example 42
       */
      id: number;
      /** @example MDEwOkRlcGxveW1lbnQx */
      node_id: string;
      /** @example a84d88e7554fc1fa21bcbc4efae3c782a70d2b9d */
      sha: string;
      /**
       * @description The ref to deploy. This can be a branch, tag, or sha.
       * @example topic-branch
       */
      ref: string;
      /**
       * @description Parameter to specify a task to execute
       * @example deploy
       */
      task: string;
      payload: OneOf<
        [
          {
            [key: string]: unknown;
          },
          string,
        ]
      >;
      /** @example staging */
      original_environment?: string;
      /**
       * @description Name for the target deployment environment.
       * @example production
       */
      environment: string;
      /** @example Deploy request from hubot */
      description: string | null;
      creator: components["schemas"]["nullable-simple-user"];
      /**
       * Format: date-time
       * @example 2012-07-20T01:19:13Z
       */
      created_at: string;
      /**
       * Format: date-time
       * @example 2012-07-20T01:19:13Z
       */
      updated_at: string;
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/example/deployments/1/statuses
       */
      statuses_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/example
       */
      repository_url: string;
      /**
       * @description Specifies if the given environment is will no longer exist at some point in the future. Default: false.
       * @example true
       */
      transient_environment?: boolean;
      /**
       * @description Specifies if the given environment is one that end-users directly interact with. Default: false.
       * @example true
       */
      production_environment?: boolean;
      performed_via_github_app?: components["schemas"]["nullable-integration"];
    };
    /**
     * Workflow
     * @description A GitHub Actions workflow
     */
    workflow: {
      /** @example 5 */
      id: number;
      /** @example MDg6V29ya2Zsb3cxMg== */
      node_id: string;
      /** @example CI */
      name: string;
      /** @example ruby.yaml */
      path: string;
      /**
       * @example active
       * @enum {string}
       */
      state:
        | "active"
        | "deleted"
        | "disabled_fork"
        | "disabled_inactivity"
        | "disabled_manually";
      /**
       * Format: date-time
       * @example 2019-12-06T14:20:20.000Z
       */
      created_at: string;
      /**
       * Format: date-time
       * @example 2019-12-06T14:20:20.000Z
       */
      updated_at: string;
      /** @example https://api.github.com/repos/actions/setup-ruby/workflows/5 */
      url: string;
      /** @example https://github.com/actions/setup-ruby/blob/master/.github/workflows/ruby.yaml */
      html_url: string;
      /** @example https://github.com/actions/setup-ruby/workflows/CI/badge.svg */
      badge_url: string;
      /**
       * Format: date-time
       * @example 2019-12-06T14:20:20.000Z
       */
      deleted_at?: string;
    };
    /**
     * Autolink reference
     * @description An autolink reference.
     */
    autolink: {
      /** @example 3 */
      id: number;
      /**
       * @description The prefix of a key that is linkified.
       * @example TICKET-
       */
      key_prefix: string;
      /**
       * @description A template for the target URL that is generated if a key was found.
       * @example https://example.com/TICKET?query=<num>
       */
      url_template: string;
      /**
       * @description Whether this autolink reference matches alphanumeric characters. If false, this autolink reference only matches numeric characters.
       * @example true
       */
      is_alphanumeric: boolean;
    };
    /**
     * Check Automated Security Fixes
     * @description Check Automated Security Fixes
     */
    "check-automated-security-fixes": {
      /**
       * @description Whether automated security fixes are enabled for the repository.
       * @example true
       */
      enabled: boolean;
      /**
       * @description Whether automated security fixes are paused for the repository.
       * @example false
       */
      paused: boolean;
    };
    /**
     * Protected Branch Required Status Check
     * @description Protected Branch Required Status Check
     */
    "protected-branch-required-status-check": {
      url?: string;
      enforcement_level?: string;
      contexts: string[];
      checks: {
        context: string;
        app_id: number | null;
      }[];
      contexts_url?: string;
      strict?: boolean;
    };
    /**
     * Protected Branch Admin Enforced
     * @description Protected Branch Admin Enforced
     */
    "protected-branch-admin-enforced": {
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/Hello-World/branches/master/protection/enforce_admins
       */
      url: string;
      /** @example true */
      enabled: boolean;
    };
    /**
     * Protected Branch Pull Request Review
     * @description Protected Branch Pull Request Review
     */
    "protected-branch-pull-request-review": {
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/Hello-World/branches/master/protection/dismissal_restrictions
       */
      url?: string;
      dismissal_restrictions?: {
        /** @description The list of users with review dismissal access. */
        users?: components["schemas"]["simple-user"][];
        /** @description The list of teams with review dismissal access. */
        teams?: components["schemas"]["team"][];
        /** @description The list of apps with review dismissal access. */
        apps?: components["schemas"]["integration"][];
        /** @example "https://api.github.com/repos/the-org/an-org-repo/branches/master/protection/dismissal_restrictions" */
        url?: string;
        /** @example "https://api.github.com/repos/the-org/an-org-repo/branches/master/protection/dismissal_restrictions/users" */
        users_url?: string;
        /** @example "https://api.github.com/repos/the-org/an-org-repo/branches/master/protection/dismissal_restrictions/teams" */
        teams_url?: string;
      };
      /** @description Allow specific users, teams, or apps to bypass pull request requirements. */
      bypass_pull_request_allowances?: {
        /** @description The list of users allowed to bypass pull request requirements. */
        users?: components["schemas"]["simple-user"][];
        /** @description The list of teams allowed to bypass pull request requirements. */
        teams?: components["schemas"]["team"][];
        /** @description The list of apps allowed to bypass pull request requirements. */
        apps?: components["schemas"]["integration"][];
      };
      /** @example true */
      dismiss_stale_reviews: boolean;
      /** @example true */
      require_code_owner_reviews: boolean;
      /** @example 2 */
      required_approving_review_count?: number;
      /**
       * @description Whether the most recent push must be approved by someone other than the person who pushed it.
       * @default false
       * @example true
       */
      require_last_push_approval?: boolean;
    };
    /**
     * Branch Restriction Policy
     * @description Branch Restriction Policy
     */
    "branch-restriction-policy": {
      /** Format: uri */
      url: string;
      /** Format: uri */
      users_url: string;
      /** Format: uri */
      teams_url: string;
      /** Format: uri */
      apps_url: string;
      users: {
        login?: string;
        id?: number;
        node_id?: string;
        avatar_url?: string;
        gravatar_id?: string;
        url?: string;
        html_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        starred_url?: string;
        subscriptions_url?: string;
        organizations_url?: string;
        repos_url?: string;
        events_url?: string;
        received_events_url?: string;
        type?: string;
        site_admin?: boolean;
      }[];
      teams: {
        id?: number;
        node_id?: string;
        url?: string;
        html_url?: string;
        name?: string;
        slug?: string;
        description?: string | null;
        privacy?: string;
        notification_setting?: string;
        permission?: string;
        members_url?: string;
        repositories_url?: string;
        parent?: string | null;
      }[];
      apps: {
        id?: number;
        slug?: string;
        node_id?: string;
        owner?: {
          login?: string;
          id?: number;
          node_id?: string;
          url?: string;
          repos_url?: string;
          events_url?: string;
          hooks_url?: string;
          issues_url?: string;
          members_url?: string;
          public_members_url?: string;
          avatar_url?: string;
          description?: string;
          /** @example "" */
          gravatar_id?: string;
          /** @example "https://github.com/testorg-ea8ec76d71c3af4b" */
          html_url?: string;
          /** @example "https://api.github.com/users/testorg-ea8ec76d71c3af4b/followers" */
          followers_url?: string;
          /** @example "https://api.github.com/users/testorg-ea8ec76d71c3af4b/following{/other_user}" */
          following_url?: string;
          /** @example "https://api.github.com/users/testorg-ea8ec76d71c3af4b/gists{/gist_id}" */
          gists_url?: string;
          /** @example "https://api.github.com/users/testorg-ea8ec76d71c3af4b/starred{/owner}{/repo}" */
          starred_url?: string;
          /** @example "https://api.github.com/users/testorg-ea8ec76d71c3af4b/subscriptions" */
          subscriptions_url?: string;
          /** @example "https://api.github.com/users/testorg-ea8ec76d71c3af4b/orgs" */
          organizations_url?: string;
          /** @example "https://api.github.com/users/testorg-ea8ec76d71c3af4b/received_events" */
          received_events_url?: string;
          /** @example "Organization" */
          type?: string;
          /** @example false */
          site_admin?: boolean;
        };
        name?: string;
        description?: string;
        external_url?: string;
        html_url?: string;
        created_at?: string;
        updated_at?: string;
        permissions?: {
          metadata?: string;
          contents?: string;
          issues?: string;
          single_file?: string;
        };
        events?: string[];
      }[];
    };
    /**
     * Branch Protection
     * @description Branch Protection
     */
    "branch-protection": {
      url?: string;
      enabled?: boolean;
      required_status_checks?: components["schemas"]["protected-branch-required-status-check"];
      enforce_admins?: components["schemas"]["protected-branch-admin-enforced"];
      required_pull_request_reviews?: components["schemas"]["protected-branch-pull-request-review"];
      restrictions?: components["schemas"]["branch-restriction-policy"];
      required_linear_history?: {
        enabled?: boolean;
      };
      allow_force_pushes?: {
        enabled?: boolean;
      };
      allow_deletions?: {
        enabled?: boolean;
      };
      block_creations?: {
        enabled?: boolean;
      };
      required_conversation_resolution?: {
        enabled?: boolean;
      };
      /** @example "branch/with/protection" */
      name?: string;
      /** @example "https://api.github.com/repos/owner-79e94e2d36b3fd06a32bb213/AAA_Public_Repo/branches/branch/with/protection/protection" */
      protection_url?: string;
      required_signatures?: {
        /**
         * Format: uri
         * @example https://api.github.com/repos/octocat/Hello-World/branches/master/protection/required_signatures
         */
        url: string;
        /** @example true */
        enabled: boolean;
      };
      /** @description Whether to set the branch as read-only. If this is true, users will not be able to push to the branch. */
      lock_branch?: {
        /** @default false */
        enabled?: boolean;
      };
      /** @description Whether users can pull changes from upstream when the branch is locked. Set to `true` to allow fork syncing. Set to `false` to prevent fork syncing. */
      allow_fork_syncing?: {
        /** @default false */
        enabled?: boolean;
      };
    };
    /**
     * Short Branch
     * @description Short Branch
     */
    "short-branch": {
      name: string;
      commit: {
        sha: string;
        /** Format: uri */
        url: string;
      };
      protected: boolean;
      protection?: components["schemas"]["branch-protection"];
      /** Format: uri */
      protection_url?: string;
    };
    /**
     * Git User
     * @description Metaproperties for Git author/committer information.
     */
    "nullable-git-user": {
      /** @example "Chris Wanstrath" */
      name?: string;
      /** @example "chris@ozmm.org" */
      email?: string;
      /** @example "2007-10-29T02:42:39.000-07:00" */
      date?: string;
    } | null;
    /** Verification */
    verification: {
      verified: boolean;
      reason: string;
      payload: string | null;
      signature: string | null;
    };
    /**
     * Diff Entry
     * @description Diff Entry
     */
    "diff-entry": {
      /** @example bbcd538c8e72b8c175046e27cc8f907076331401 */
      sha: string;
      /** @example file1.txt */
      filename: string;
      /**
       * @example added
       * @enum {string}
       */
      status:
        | "added"
        | "removed"
        | "modified"
        | "renamed"
        | "copied"
        | "changed"
        | "unchanged";
      /** @example 103 */
      additions: number;
      /** @example 21 */
      deletions: number;
      /** @example 124 */
      changes: number;
      /**
       * Format: uri
       * @example https://github.com/octocat/Hello-World/blob/6dcb09b5b57875f334f61aebed695e2e4193db5e/file1.txt
       */
      blob_url: string;
      /**
       * Format: uri
       * @example https://github.com/octocat/Hello-World/raw/6dcb09b5b57875f334f61aebed695e2e4193db5e/file1.txt
       */
      raw_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/Hello-World/contents/file1.txt?ref=6dcb09b5b57875f334f61aebed695e2e4193db5e
       */
      contents_url: string;
      /** @example @@ -132,7 +132,7 @@ module Test @@ -1000,7 +1000,7 @@ module Test */
      patch?: string;
      /** @example file.txt */
      previous_filename?: string;
    };
    /**
     * Commit
     * @description Commit
     */
    commit: {
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/Hello-World/commits/6dcb09b5b57875f334f61aebed695e2e4193db5e
       */
      url: string;
      /** @example 6dcb09b5b57875f334f61aebed695e2e4193db5e */
      sha: string;
      /** @example MDY6Q29tbWl0NmRjYjA5YjViNTc4NzVmMzM0ZjYxYWViZWQ2OTVlMmU0MTkzZGI1ZQ== */
      node_id: string;
      /**
       * Format: uri
       * @example https://github.com/octocat/Hello-World/commit/6dcb09b5b57875f334f61aebed695e2e4193db5e
       */
      html_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/Hello-World/commits/6dcb09b5b57875f334f61aebed695e2e4193db5e/comments
       */
      comments_url: string;
      commit: {
        /**
         * Format: uri
         * @example https://api.github.com/repos/octocat/Hello-World/commits/6dcb09b5b57875f334f61aebed695e2e4193db5e
         */
        url: string;
        author: components["schemas"]["nullable-git-user"];
        committer: components["schemas"]["nullable-git-user"];
        /** @example Fix all the bugs */
        message: string;
        /** @example 0 */
        comment_count: number;
        tree: {
          /** @example 827efc6d56897b048c772eb4087f854f46256132 */
          sha: string;
          /**
           * Format: uri
           * @example https://api.github.com/repos/octocat/Hello-World/tree/827efc6d56897b048c772eb4087f854f46256132
           */
          url: string;
        };
        verification?: components["schemas"]["verification"];
      };
      author: components["schemas"]["nullable-simple-user"];
      committer: components["schemas"]["nullable-simple-user"];
      parents: {
        /** @example 7638417db6d59f3c431d3e1f261cc637155684cd */
        sha: string;
        /**
         * Format: uri
         * @example https://api.github.com/repos/octocat/Hello-World/commits/7638417db6d59f3c431d3e1f261cc637155684cd
         */
        url: string;
        /**
         * Format: uri
         * @example https://github.com/octocat/Hello-World/commit/7638417db6d59f3c431d3e1f261cc637155684cd
         */
        html_url?: string;
      }[];
      stats?: {
        additions?: number;
        deletions?: number;
        total?: number;
      };
      files?: components["schemas"]["diff-entry"][];
    };
    /**
     * Branch With Protection
     * @description Branch With Protection
     */
    "branch-with-protection": {
      name: string;
      commit: components["schemas"]["commit"];
      _links: {
        html: string;
        /** Format: uri */
        self: string;
      };
      protected: boolean;
      protection: components["schemas"]["branch-protection"];
      /** Format: uri */
      protection_url: string;
      /** @example "mas*" */
      pattern?: string;
      /** @example 1 */
      required_approving_review_count?: number;
    };
    /**
     * Status Check Policy
     * @description Status Check Policy
     */
    "status-check-policy": {
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/Hello-World/branches/master/protection/required_status_checks
       */
      url: string;
      /** @example true */
      strict: boolean;
      /**
       * @example [
       *   "continuous-integration/travis-ci"
       * ]
       */
      contexts: string[];
      checks: {
        /** @example continuous-integration/travis-ci */
        context: string;
        app_id: number | null;
      }[];
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/Hello-World/branches/master/protection/required_status_checks/contexts
       */
      contexts_url: string;
    };
    /**
     * Protected Branch
     * @description Branch protections protect branches
     */
    "protected-branch": {
      /** Format: uri */
      url: string;
      required_status_checks?: components["schemas"]["status-check-policy"];
      required_pull_request_reviews?: {
        /** Format: uri */
        url: string;
        dismiss_stale_reviews?: boolean;
        require_code_owner_reviews?: boolean;
        required_approving_review_count?: number;
        /**
         * @description Whether the most recent push must be approved by someone other than the person who pushed it.
         * @default false
         */
        require_last_push_approval?: boolean;
        dismissal_restrictions?: {
          /** Format: uri */
          url: string;
          /** Format: uri */
          users_url: string;
          /** Format: uri */
          teams_url: string;
          users: components["schemas"]["simple-user"][];
          teams: components["schemas"]["team"][];
          apps?: components["schemas"]["integration"][];
        };
        bypass_pull_request_allowances?: {
          users: components["schemas"]["simple-user"][];
          teams: components["schemas"]["team"][];
          apps?: components["schemas"]["integration"][];
        };
      };
      required_signatures?: {
        /**
         * Format: uri
         * @example https://api.github.com/repos/octocat/Hello-World/branches/master/protection/required_signatures
         */
        url: string;
        /** @example true */
        enabled: boolean;
      };
      enforce_admins?: {
        /** Format: uri */
        url: string;
        enabled: boolean;
      };
      required_linear_history?: {
        enabled: boolean;
      };
      allow_force_pushes?: {
        enabled: boolean;
      };
      allow_deletions?: {
        enabled: boolean;
      };
      restrictions?: components["schemas"]["branch-restriction-policy"];
      required_conversation_resolution?: {
        enabled?: boolean;
      };
      block_creations?: {
        enabled: boolean;
      };
      /** @description Whether to set the branch as read-only. If this is true, users will not be able to push to the branch. */
      lock_branch?: {
        /** @default false */
        enabled?: boolean;
      };
      /** @description Whether users can pull changes from upstream when the branch is locked. Set to `true` to allow fork syncing. Set to `false` to prevent fork syncing. */
      allow_fork_syncing?: {
        /** @default false */
        enabled?: boolean;
      };
    };
    /**
     * Deployment
     * @description A deployment created as the result of an Actions check run from a workflow that references an environment
     */
    "deployment-simple": {
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/example/deployments/1
       */
      url: string;
      /**
       * @description Unique identifier of the deployment
       * @example 42
       */
      id: number;
      /** @example MDEwOkRlcGxveW1lbnQx */
      node_id: string;
      /**
       * @description Parameter to specify a task to execute
       * @example deploy
       */
      task: string;
      /** @example staging */
      original_environment?: string;
      /**
       * @description Name for the target deployment environment.
       * @example production
       */
      environment: string;
      /** @example Deploy request from hubot */
      description: string | null;
      /**
       * Format: date-time
       * @example 2012-07-20T01:19:13Z
       */
      created_at: string;
      /**
       * Format: date-time
       * @example 2012-07-20T01:19:13Z
       */
      updated_at: string;
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/example/deployments/1/statuses
       */
      statuses_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/example
       */
      repository_url: string;
      /**
       * @description Specifies if the given environment is will no longer exist at some point in the future. Default: false.
       * @example true
       */
      transient_environment?: boolean;
      /**
       * @description Specifies if the given environment is one that end-users directly interact with. Default: false.
       * @example true
       */
      production_environment?: boolean;
      performed_via_github_app?: components["schemas"]["nullable-integration"];
    };
    /**
     * CheckRun
     * @description A check performed on the code of a given code change
     */
    "check-run": {
      /**
       * @description The id of the check.
       * @example 21
       */
      id: number;
      /**
       * @description The SHA of the commit that is being checked.
       * @example 009b8a3a9ccbb128af87f9b1c0f4c62e8a304f6d
       */
      head_sha: string;
      /** @example MDg6Q2hlY2tSdW40 */
      node_id: string;
      /** @example 42 */
      external_id: string | null;
      /** @example https://api.github.com/repos/github/hello-world/check-runs/4 */
      url: string;
      /** @example https://github.com/github/hello-world/runs/4 */
      html_url: string | null;
      /** @example https://example.com */
      details_url: string | null;
      /**
       * @description The phase of the lifecycle that the check is currently in. Statuses of waiting, requested, and pending are reserved for GitHub Actions check runs.
       * @example queued
       * @enum {string}
       */
      status:
        | "queued"
        | "in_progress"
        | "completed"
        | "waiting"
        | "requested"
        | "pending";
      /**
       * @example neutral
       * @enum {string|null}
       */
      conclusion:
        | "success"
        | "failure"
        | "neutral"
        | "cancelled"
        | "skipped"
        | "timed_out"
        | "action_required"
        | null;
      /**
       * Format: date-time
       * @example 2018-05-04T01:14:52Z
       */
      started_at: string | null;
      /**
       * Format: date-time
       * @example 2018-05-04T01:14:52Z
       */
      completed_at: string | null;
      output: {
        title: string | null;
        summary: string | null;
        text: string | null;
        annotations_count: number;
        /** Format: uri */
        annotations_url: string;
      };
      /**
       * @description The name of the check.
       * @example test-coverage
       */
      name: string;
      check_suite: {
        id: number;
      } | null;
      app: components["schemas"]["nullable-integration"];
      /** @description Pull requests that are open with a `head_sha` or `head_branch` that matches the check. The returned pull requests do not necessarily indicate pull requests that triggered the check. */
      pull_requests: components["schemas"]["pull-request-minimal"][];
      deployment?: components["schemas"]["deployment-simple"];
    };
    /**
     * Check Annotation
     * @description Check Annotation
     */
    "check-annotation": {
      /** @example README.md */
      path: string;
      /** @example 2 */
      start_line: number;
      /** @example 2 */
      end_line: number;
      /** @example 5 */
      start_column: number | null;
      /** @example 10 */
      end_column: number | null;
      /** @example warning */
      annotation_level: string | null;
      /** @example Spell Checker */
      title: string | null;
      /** @example Check your spelling for 'banaas'. */
      message: string | null;
      /** @example Do you mean 'bananas' or 'banana'? */
      raw_details: string | null;
      blob_href: string;
    };
    /**
     * Simple Commit
     * @description A commit.
     */
    "simple-commit": {
      /**
       * @description SHA for the commit
       * @example 7638417db6d59f3c431d3e1f261cc637155684cd
       */
      id: string;
      /** @description SHA for the commit's tree */
      tree_id: string;
      /**
       * @description Message describing the purpose of the commit
       * @example Fix #42
       */
      message: string;
      /**
       * Format: date-time
       * @description Timestamp of the commit
       * @example 2014-08-09T08:02:04+12:00
       */
      timestamp: string;
      /** @description Information about the Git author */
      author: {
        /**
         * @description Name of the commit's author
         * @example Monalisa Octocat
         */
        name: string;
        /**
         * Format: email
         * @description Git email address of the commit's author
         * @example monalisa.octocat@example.com
         */
        email: string;
      } | null;
      /** @description Information about the Git committer */
      committer: {
        /**
         * @description Name of the commit's committer
         * @example Monalisa Octocat
         */
        name: string;
        /**
         * Format: email
         * @description Git email address of the commit's committer
         * @example monalisa.octocat@example.com
         */
        email: string;
      } | null;
    };
    /**
     * CheckSuite
     * @description A suite of checks performed on the code of a given code change
     */
    "check-suite": {
      /** @example 5 */
      id: number;
      /** @example MDEwOkNoZWNrU3VpdGU1 */
      node_id: string;
      /** @example master */
      head_branch: string | null;
      /**
       * @description The SHA of the head commit that is being checked.
       * @example 009b8a3a9ccbb128af87f9b1c0f4c62e8a304f6d
       */
      head_sha: string;
      /**
       * @description The phase of the lifecycle that the check suite is currently in. Statuses of waiting, requested, and pending are reserved for GitHub Actions check suites.
       * @example completed
       * @enum {string|null}
       */
      status:
        | "queued"
        | "in_progress"
        | "completed"
        | "waiting"
        | "requested"
        | "pending"
        | null;
      /**
       * @example neutral
       * @enum {string|null}
       */
      conclusion:
        | "success"
        | "failure"
        | "neutral"
        | "cancelled"
        | "skipped"
        | "timed_out"
        | "action_required"
        | "startup_failure"
        | "stale"
        | null;
      /** @example https://api.github.com/repos/github/hello-world/check-suites/5 */
      url: string | null;
      /** @example 146e867f55c26428e5f9fade55a9bbf5e95a7912 */
      before: string | null;
      /** @example d6fde92930d4715a2b49857d24b940956b26d2d3 */
      after: string | null;
      pull_requests: components["schemas"]["pull-request-minimal"][] | null;
      app: components["schemas"]["nullable-integration"];
      repository: components["schemas"]["minimal-repository"];
      /** Format: date-time */
      created_at: string | null;
      /** Format: date-time */
      updated_at: string | null;
      head_commit: components["schemas"]["simple-commit"];
      latest_check_runs_count: number;
      check_runs_url: string;
      rerequestable?: boolean;
      runs_rerequestable?: boolean;
    };
    /**
     * Check Suite Preference
     * @description Check suite configuration preferences for a repository.
     */
    "check-suite-preference": {
      preferences: {
        auto_trigger_checks?: {
          app_id: number;
          setting: boolean;
        }[];
      };
      repository: components["schemas"]["minimal-repository"];
    };
    "code-scanning-alert-items": {
      number: components["schemas"]["alert-number"];
      created_at: components["schemas"]["alert-created-at"];
      updated_at?: components["schemas"]["alert-updated-at"];
      url: components["schemas"]["alert-url"];
      html_url: components["schemas"]["alert-html-url"];
      instances_url: components["schemas"]["alert-instances-url"];
      state: components["schemas"]["code-scanning-alert-state"];
      fixed_at?: components["schemas"]["alert-fixed-at"];
      dismissed_by: components["schemas"]["nullable-simple-user"];
      dismissed_at: components["schemas"]["alert-dismissed-at"];
      dismissed_reason: components["schemas"]["code-scanning-alert-dismissed-reason"];
      dismissed_comment?: components["schemas"]["code-scanning-alert-dismissed-comment"];
      rule: components["schemas"]["code-scanning-alert-rule-summary"];
      tool: components["schemas"]["code-scanning-analysis-tool"];
      most_recent_instance: components["schemas"]["code-scanning-alert-instance"];
    };
    "code-scanning-alert-rule": {
      /** @description A unique identifier for the rule used to detect the alert. */
      id?: string | null;
      /** @description The name of the rule used to detect the alert. */
      name?: string;
      /**
       * @description The severity of the alert.
       * @enum {string|null}
       */
      severity?: "none" | "note" | "warning" | "error" | null;
      /**
       * @description The security severity of the alert.
       * @enum {string|null}
       */
      security_severity_level?: "low" | "medium" | "high" | "critical" | null;
      /** @description A short description of the rule used to detect the alert. */
      description?: string;
      /** @description description of the rule used to detect the alert. */
      full_description?: string;
      /** @description A set of tags applicable for the rule. */
      tags?: string[] | null;
      /** @description Detailed documentation for the rule as GitHub Flavored Markdown. */
      help?: string | null;
      /** @description A link to the documentation for the rule used to detect the alert. */
      help_uri?: string | null;
    };
    "code-scanning-alert": {
      number: components["schemas"]["alert-number"];
      created_at: components["schemas"]["alert-created-at"];
      updated_at?: components["schemas"]["alert-updated-at"];
      url: components["schemas"]["alert-url"];
      html_url: components["schemas"]["alert-html-url"];
      instances_url: components["schemas"]["alert-instances-url"];
      state: components["schemas"]["code-scanning-alert-state"];
      fixed_at?: components["schemas"]["alert-fixed-at"];
      dismissed_by: components["schemas"]["nullable-simple-user"];
      dismissed_at: components["schemas"]["alert-dismissed-at"];
      dismissed_reason: components["schemas"]["code-scanning-alert-dismissed-reason"];
      dismissed_comment?: components["schemas"]["code-scanning-alert-dismissed-comment"];
      rule: components["schemas"]["code-scanning-alert-rule"];
      tool: components["schemas"]["code-scanning-analysis-tool"];
      most_recent_instance: components["schemas"]["code-scanning-alert-instance"];
    };
    /**
     * @description Sets the state of the code scanning alert. You must provide `dismissed_reason` when you set the state to `dismissed`.
     * @enum {string}
     */
    "code-scanning-alert-set-state": "open" | "dismissed";
    /**
     * @description An identifier for the upload.
     * @example 6c81cd8e-b078-4ac3-a3be-1dad7dbd0b53
     */
    "code-scanning-analysis-sarif-id": string;
    /** @description The SHA of the commit to which the analysis you are uploading relates. */
    "code-scanning-analysis-commit-sha": string;
    /** @description Identifies the variable values associated with the environment in which this analysis was performed. */
    "code-scanning-analysis-environment": string;
    /**
     * Format: date-time
     * @description The time that the analysis was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    readonly "code-scanning-analysis-created-at": string;
    /**
     * Format: uri
     * @description The REST API URL of the analysis resource.
     */
    readonly "code-scanning-analysis-url": string;
    "code-scanning-analysis": {
      ref: components["schemas"]["code-scanning-ref"];
      commit_sha: components["schemas"]["code-scanning-analysis-commit-sha"];
      analysis_key: components["schemas"]["code-scanning-analysis-analysis-key"];
      environment: components["schemas"]["code-scanning-analysis-environment"];
      category?: components["schemas"]["code-scanning-analysis-category"];
      /** @example error reading field xyz */
      error: string;
      created_at: components["schemas"]["code-scanning-analysis-created-at"];
      /** @description The total number of results in the analysis. */
      results_count: number;
      /** @description The total number of rules used in the analysis. */
      rules_count: number;
      /** @description Unique identifier for this analysis. */
      id: number;
      url: components["schemas"]["code-scanning-analysis-url"];
      sarif_id: components["schemas"]["code-scanning-analysis-sarif-id"];
      tool: components["schemas"]["code-scanning-analysis-tool"];
      deletable: boolean;
      /**
       * @description Warning generated when processing the analysis
       * @example 123 results were ignored
       */
      warning: string;
    };
    /**
     * Analysis deletion
     * @description Successful deletion of a code scanning analysis
     */
    "code-scanning-analysis-deletion": {
      /**
       * Format: uri
       * @description Next deletable analysis in chain, without last analysis deletion confirmation
       */
      next_analysis_url: string | null;
      /**
       * Format: uri
       * @description Next deletable analysis in chain, with last analysis deletion confirmation
       */
      confirm_delete_url: string | null;
    };
    /** @description Configuration for code scanning default setup. */
    "code-scanning-default-setup": {
      /**
       * @description Code scanning default setup has been configured or not.
       * @enum {string}
       */
      state?: "configured" | "not-configured";
      /** @description Languages to be analyzed. */
      languages?: (
        | "c-cpp"
        | "csharp"
        | "go"
        | "java-kotlin"
        | "javascript-typescript"
        | "javascript"
        | "python"
        | "ruby"
        | "typescript"
        | "swift"
      )[];
      /**
       * @description CodeQL query suite to be used.
       * @enum {string}
       */
      query_suite?: "default" | "extended";
      /**
       * Format: date-time
       * @description Timestamp of latest configuration update.
       * @example 2023-12-06T14:20:20.000Z
       */
      updated_at?: string | null;
    };
    /** @description Configuration for code scanning default setup. */
    "code-scanning-default-setup-update": {
      /**
       * @description The desired state of code scanning default setup.
       * @enum {string}
       */
      state: "configured" | "not-configured";
      /**
       * @description CodeQL query suite to be used.
       * @enum {string}
       */
      query_suite?: "default" | "extended";
      /** @description CodeQL languages to be analyzed. */
      languages?: (
        | "c-cpp"
        | "csharp"
        | "go"
        | "java-kotlin"
        | "javascript-typescript"
        | "python"
        | "ruby"
      )[];
      [key: string]: unknown;
    };
    /**
     * @description You can use `run_url` to track the status of the run. This includes a property status and conclusion.
     * You should not rely on this always being an actions workflow run object.
     */
    "code-scanning-default-setup-update-response": {
      /** @description ID of the corresponding run. */
      run_id?: number;
      /** @description URL of the corresponding run. */
      run_url?: string;
    };
    /**
     * @description The full Git reference, formatted as `refs/heads/<branch name>`,
     * `refs/tags/<tag>`, `refs/pull/<number>/merge`, or `refs/pull/<number>/head`.
     * @example refs/heads/main
     */
    "code-scanning-ref-full": string;
    /** @description A Base64 string representing the SARIF file to upload. You must first compress your SARIF file using [`gzip`](http://www.gnu.org/software/gzip/manual/gzip.html) and then translate the contents of the file into a Base64 encoding string. For more information, see "[SARIF support for code scanning](https://docs.github.com/enterprise-server@3.10/code-security/secure-coding/sarif-support-for-code-scanning)." */
    "code-scanning-analysis-sarif-file": string;
    "code-scanning-sarifs-receipt": {
      id?: components["schemas"]["code-scanning-analysis-sarif-id"];
      /**
       * Format: uri
       * @description The REST API URL for checking the status of the upload.
       */
      url?: string;
    };
    "code-scanning-sarifs-status": {
      /**
       * @description `pending` files have not yet been processed, while `complete` means results from the SARIF have been stored. `failed` files have either not been processed at all, or could only be partially processed.
       * @enum {string}
       */
      processing_status?: "pending" | "complete" | "failed";
      /**
       * Format: uri
       * @description The REST API URL for getting the analyses associated with the upload.
       */
      analyses_url?: string | null;
      /** @description Any errors that ocurred during processing of the delivery. */
      errors?: readonly string[] | null;
    };
    /**
     * CODEOWNERS errors
     * @description A list of errors found in a repo's CODEOWNERS file
     */
    "codeowners-errors": {
      errors: {
        /**
         * @description The line number where this errors occurs.
         * @example 7
         */
        line: number;
        /**
         * @description The column number where this errors occurs.
         * @example 3
         */
        column: number;
        /**
         * @description The contents of the line where the error occurs.
         * @example * user
         */
        source?: string;
        /**
         * @description The type of error.
         * @example Invalid owner
         */
        kind: string;
        /**
         * @description Suggested action to fix the error. This will usually be `null`, but is provided for some common errors.
         * @example The pattern `/` will never match anything, did you mean `*` instead?
         */
        suggestion?: string | null;
        /**
         * @description A human-readable description of the error, combining information from multiple fields, laid out for display in a monospaced typeface (for example, a command-line setting).
         * @example Invalid owner on line 7:
         *
         *   * user
         *     ^
         */
        message: string;
        /**
         * @description The path of the file where the error occured.
         * @example .github/CODEOWNERS
         */
        path: string;
      }[];
    };
    /**
     * Collaborator
     * @description Collaborator
     */
    collaborator: {
      /** @example octocat */
      login: string;
      /** @example 1 */
      id: number;
      email?: string | null;
      name?: string | null;
      /** @example MDQ6VXNlcjE= */
      node_id: string;
      /**
       * Format: uri
       * @example https://github.com/images/error/octocat_happy.gif
       */
      avatar_url: string;
      /** @example 41d064eb2195891e12d0413f63227ea7 */
      gravatar_id: string | null;
      /**
       * Format: uri
       * @example https://api.github.com/users/octocat
       */
      url: string;
      /**
       * Format: uri
       * @example https://github.com/octocat
       */
      html_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/users/octocat/followers
       */
      followers_url: string;
      /** @example https://api.github.com/users/octocat/following{/other_user} */
      following_url: string;
      /** @example https://api.github.com/users/octocat/gists{/gist_id} */
      gists_url: string;
      /** @example https://api.github.com/users/octocat/starred{/owner}{/repo} */
      starred_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/users/octocat/subscriptions
       */
      subscriptions_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/users/octocat/orgs
       */
      organizations_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/users/octocat/repos
       */
      repos_url: string;
      /** @example https://api.github.com/users/octocat/events{/privacy} */
      events_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/users/octocat/received_events
       */
      received_events_url: string;
      /** @example User */
      type: string;
      site_admin: boolean;
      permissions?: {
        pull: boolean;
        triage?: boolean;
        push: boolean;
        maintain?: boolean;
        admin: boolean;
      };
      /** @example admin */
      role_name?: string;
    };
    /**
     * Collaborator
     * @description Collaborator
     */
    "nullable-collaborator": {
      /** @example octocat */
      login: string;
      /** @example 1 */
      id: number;
      email?: string | null;
      name?: string | null;
      /** @example MDQ6VXNlcjE= */
      node_id: string;
      /**
       * Format: uri
       * @example https://github.com/images/error/octocat_happy.gif
       */
      avatar_url: string;
      /** @example 41d064eb2195891e12d0413f63227ea7 */
      gravatar_id: string | null;
      /**
       * Format: uri
       * @example https://api.github.com/users/octocat
       */
      url: string;
      /**
       * Format: uri
       * @example https://github.com/octocat
       */
      html_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/users/octocat/followers
       */
      followers_url: string;
      /** @example https://api.github.com/users/octocat/following{/other_user} */
      following_url: string;
      /** @example https://api.github.com/users/octocat/gists{/gist_id} */
      gists_url: string;
      /** @example https://api.github.com/users/octocat/starred{/owner}{/repo} */
      starred_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/users/octocat/subscriptions
       */
      subscriptions_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/users/octocat/orgs
       */
      organizations_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/users/octocat/repos
       */
      repos_url: string;
      /** @example https://api.github.com/users/octocat/events{/privacy} */
      events_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/users/octocat/received_events
       */
      received_events_url: string;
      /** @example User */
      type: string;
      site_admin: boolean;
      permissions?: {
        pull: boolean;
        triage?: boolean;
        push: boolean;
        maintain?: boolean;
        admin: boolean;
      };
      /** @example admin */
      role_name?: string;
    } | null;
    /**
     * Repository Collaborator Permission
     * @description Repository Collaborator Permission
     */
    "repository-collaborator-permission": {
      permission: string;
      /** @example admin */
      role_name: string;
      user: components["schemas"]["nullable-collaborator"];
    };
    /**
     * Commit Comment
     * @description Commit Comment
     */
    "commit-comment": {
      /** Format: uri */
      html_url: string;
      /** Format: uri */
      url: string;
      id: number;
      node_id: string;
      body: string;
      path: string | null;
      position: number | null;
      line: number | null;
      commit_id: string;
      user: components["schemas"]["nullable-simple-user"];
      /** Format: date-time */
      created_at: string;
      /** Format: date-time */
      updated_at: string;
      author_association: components["schemas"]["author-association"];
      reactions?: components["schemas"]["reaction-rollup"];
    };
    /**
     * Branch Short
     * @description Branch Short
     */
    "branch-short": {
      name: string;
      commit: {
        sha: string;
        url: string;
      };
      protected: boolean;
    };
    /**
     * Link
     * @description Hypermedia Link
     */
    link: {
      href: string;
    };
    /**
     * Auto merge
     * @description The status of auto merging a pull request.
     */
    "auto-merge": {
      enabled_by: components["schemas"]["simple-user"];
      /**
       * @description The merge method to use.
       * @enum {string}
       */
      merge_method: "merge" | "squash" | "rebase";
      /** @description Title for the merge commit message. */
      commit_title: string;
      /** @description Commit message for the merge commit. */
      commit_message: string;
    } | null;
    /**
     * Pull Request Simple
     * @description Pull Request Simple
     */
    "pull-request-simple": {
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/Hello-World/pulls/1347
       */
      url: string;
      /** @example 1 */
      id: number;
      /** @example MDExOlB1bGxSZXF1ZXN0MQ== */
      node_id: string;
      /**
       * Format: uri
       * @example https://github.com/octocat/Hello-World/pull/1347
       */
      html_url: string;
      /**
       * Format: uri
       * @example https://github.com/octocat/Hello-World/pull/1347.diff
       */
      diff_url: string;
      /**
       * Format: uri
       * @example https://github.com/octocat/Hello-World/pull/1347.patch
       */
      patch_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/Hello-World/issues/1347
       */
      issue_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/Hello-World/pulls/1347/commits
       */
      commits_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/Hello-World/pulls/1347/comments
       */
      review_comments_url: string;
      /** @example https://api.github.com/repos/octocat/Hello-World/pulls/comments{/number} */
      review_comment_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/Hello-World/issues/1347/comments
       */
      comments_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/Hello-World/statuses/6dcb09b5b57875f334f61aebed695e2e4193db5e
       */
      statuses_url: string;
      /** @example 1347 */
      number: number;
      /** @example open */
      state: string;
      /** @example true */
      locked: boolean;
      /** @example new-feature */
      title: string;
      user: components["schemas"]["nullable-simple-user"];
      /** @example Please pull these awesome changes */
      body: string | null;
      labels: {
        /** Format: int64 */
        id: number;
        node_id: string;
        url: string;
        name: string;
        description: string;
        color: string;
        default: boolean;
      }[];
      milestone: components["schemas"]["nullable-milestone"];
      /** @example too heated */
      active_lock_reason?: string | null;
      /**
       * Format: date-time
       * @example 2011-01-26T19:01:12Z
       */
      created_at: string;
      /**
       * Format: date-time
       * @example 2011-01-26T19:01:12Z
       */
      updated_at: string;
      /**
       * Format: date-time
       * @example 2011-01-26T19:01:12Z
       */
      closed_at: string | null;
      /**
       * Format: date-time
       * @example 2011-01-26T19:01:12Z
       */
      merged_at: string | null;
      /** @example e5bd3914e2e596debea16f433f57875b5b90bcd6 */
      merge_commit_sha: string | null;
      assignee: components["schemas"]["nullable-simple-user"];
      assignees?: components["schemas"]["simple-user"][] | null;
      requested_reviewers?: components["schemas"]["simple-user"][] | null;
      requested_teams?: components["schemas"]["team"][] | null;
      head: {
        label: string;
        ref: string;
        repo: components["schemas"]["repository"];
        sha: string;
        user: components["schemas"]["nullable-simple-user"];
      };
      base: {
        label: string;
        ref: string;
        repo: components["schemas"]["repository"];
        sha: string;
        user: components["schemas"]["nullable-simple-user"];
      };
      _links: {
        comments: components["schemas"]["link"];
        commits: components["schemas"]["link"];
        statuses: components["schemas"]["link"];
        html: components["schemas"]["link"];
        issue: components["schemas"]["link"];
        review_comments: components["schemas"]["link"];
        review_comment: components["schemas"]["link"];
        self: components["schemas"]["link"];
      };
      author_association: components["schemas"]["author-association"];
      auto_merge: components["schemas"]["auto-merge"];
      /**
       * @description Indicates whether or not the pull request is a draft.
       * @example false
       */
      draft?: boolean;
    };
    /** Simple Commit Status */
    "simple-commit-status": {
      description: string | null;
      id: number;
      node_id: string;
      state: string;
      context: string;
      /** Format: uri */
      target_url: string | null;
      required?: boolean | null;
      /** Format: uri */
      avatar_url: string | null;
      /** Format: uri */
      url: string;
      /** Format: date-time */
      created_at: string;
      /** Format: date-time */
      updated_at: string;
    };
    /**
     * Combined Commit Status
     * @description Combined Commit Status
     */
    "combined-commit-status": {
      state: string;
      statuses: components["schemas"]["simple-commit-status"][];
      sha: string;
      total_count: number;
      repository: components["schemas"]["minimal-repository"];
      /** Format: uri */
      commit_url: string;
      /** Format: uri */
      url: string;
    };
    /**
     * Status
     * @description The status of a commit.
     */
    status: {
      url: string;
      avatar_url: string | null;
      id: number;
      node_id: string;
      state: string;
      description: string | null;
      target_url: string | null;
      context: string;
      created_at: string;
      updated_at: string;
      creator: components["schemas"]["nullable-simple-user"];
    };
    /**
     * Commit Comparison
     * @description Commit Comparison
     */
    "commit-comparison": {
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/Hello-World/compare/master...topic
       */
      url: string;
      /**
       * Format: uri
       * @example https://github.com/octocat/Hello-World/compare/master...topic
       */
      html_url: string;
      /**
       * Format: uri
       * @example https://github.com/octocat/Hello-World/compare/octocat:bbcd538c8e72b8c175046e27cc8f907076331401...octocat:0328041d1152db8ae77652d1618a02e57f745f17
       */
      permalink_url: string;
      /**
       * Format: uri
       * @example https://github.com/octocat/Hello-World/compare/master...topic.diff
       */
      diff_url: string;
      /**
       * Format: uri
       * @example https://github.com/octocat/Hello-World/compare/master...topic.patch
       */
      patch_url: string;
      base_commit: components["schemas"]["commit"];
      merge_base_commit: components["schemas"]["commit"];
      /**
       * @example ahead
       * @enum {string}
       */
      status: "diverged" | "ahead" | "behind" | "identical";
      /** @example 4 */
      ahead_by: number;
      /** @example 5 */
      behind_by: number;
      /** @example 6 */
      total_commits: number;
      commits: components["schemas"]["commit"][];
      files?: components["schemas"]["diff-entry"][];
    };
    /**
     * Content Tree
     * @description Content Tree
     */
    "content-tree": {
      type: string;
      size: number;
      name: string;
      path: string;
      sha: string;
      /** Format: uri */
      url: string;
      /** Format: uri */
      git_url: string | null;
      /** Format: uri */
      html_url: string | null;
      /** Format: uri */
      download_url: string | null;
      entries?: {
        type: string;
        size: number;
        name: string;
        path: string;
        content?: string;
        sha: string;
        /** Format: uri */
        url: string;
        /** Format: uri */
        git_url: string | null;
        /** Format: uri */
        html_url: string | null;
        /** Format: uri */
        download_url: string | null;
        _links: {
          /** Format: uri */
          git: string | null;
          /** Format: uri */
          html: string | null;
          /** Format: uri */
          self: string;
        };
      }[];
      _links: {
        /** Format: uri */
        git: string | null;
        /** Format: uri */
        html: string | null;
        /** Format: uri */
        self: string;
      };
    };
    /**
     * Content Directory
     * @description A list of directory items
     */
    "content-directory": {
      /** @enum {string} */
      type: "dir" | "file" | "submodule" | "symlink";
      size: number;
      name: string;
      path: string;
      content?: string;
      sha: string;
      /** Format: uri */
      url: string;
      /** Format: uri */
      git_url: string | null;
      /** Format: uri */
      html_url: string | null;
      /** Format: uri */
      download_url: string | null;
      _links: {
        /** Format: uri */
        git: string | null;
        /** Format: uri */
        html: string | null;
        /** Format: uri */
        self: string;
      };
    }[];
    /**
     * Content File
     * @description Content File
     */
    "content-file": {
      /** @enum {string} */
      type: "file";
      encoding: string;
      size: number;
      name: string;
      path: string;
      content: string;
      sha: string;
      /** Format: uri */
      url: string;
      /** Format: uri */
      git_url: string | null;
      /** Format: uri */
      html_url: string | null;
      /** Format: uri */
      download_url: string | null;
      _links: {
        /** Format: uri */
        git: string | null;
        /** Format: uri */
        html: string | null;
        /** Format: uri */
        self: string;
      };
      /** @example "actual/actual.md" */
      target?: string;
      /** @example "git://example.com/defunkt/dotjs.git" */
      submodule_git_url?: string;
    };
    /**
     * Symlink Content
     * @description An object describing a symlink
     */
    "content-symlink": {
      /** @enum {string} */
      type: "symlink";
      target: string;
      size: number;
      name: string;
      path: string;
      sha: string;
      /** Format: uri */
      url: string;
      /** Format: uri */
      git_url: string | null;
      /** Format: uri */
      html_url: string | null;
      /** Format: uri */
      download_url: string | null;
      _links: {
        /** Format: uri */
        git: string | null;
        /** Format: uri */
        html: string | null;
        /** Format: uri */
        self: string;
      };
    };
    /**
     * Submodule Content
     * @description An object describing a submodule
     */
    "content-submodule": {
      /** @enum {string} */
      type: "submodule";
      /** Format: uri */
      submodule_git_url: string;
      size: number;
      name: string;
      path: string;
      sha: string;
      /** Format: uri */
      url: string;
      /** Format: uri */
      git_url: string | null;
      /** Format: uri */
      html_url: string | null;
      /** Format: uri */
      download_url: string | null;
      _links: {
        /** Format: uri */
        git: string | null;
        /** Format: uri */
        html: string | null;
        /** Format: uri */
        self: string;
      };
    };
    /**
     * File Commit
     * @description File Commit
     */
    "file-commit": {
      content: {
        name?: string;
        path?: string;
        sha?: string;
        size?: number;
        url?: string;
        html_url?: string;
        git_url?: string;
        download_url?: string;
        type?: string;
        _links?: {
          self?: string;
          git?: string;
          html?: string;
        };
      } | null;
      commit: {
        sha?: string;
        node_id?: string;
        url?: string;
        html_url?: string;
        author?: {
          date?: string;
          name?: string;
          email?: string;
        };
        committer?: {
          date?: string;
          name?: string;
          email?: string;
        };
        message?: string;
        tree?: {
          url?: string;
          sha?: string;
        };
        parents?: {
          url?: string;
          html_url?: string;
          sha?: string;
        }[];
        verification?: {
          verified?: boolean;
          reason?: string;
          signature?: string | null;
          payload?: string | null;
        };
      };
    };
    /**
     * Contributor
     * @description Contributor
     */
    contributor: {
      login?: string;
      id?: number;
      node_id?: string;
      /** Format: uri */
      avatar_url?: string;
      gravatar_id?: string | null;
      /** Format: uri */
      url?: string;
      /** Format: uri */
      html_url?: string;
      /** Format: uri */
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      starred_url?: string;
      /** Format: uri */
      subscriptions_url?: string;
      /** Format: uri */
      organizations_url?: string;
      /** Format: uri */
      repos_url?: string;
      events_url?: string;
      /** Format: uri */
      received_events_url?: string;
      type: string;
      site_admin?: boolean;
      contributions: number;
      email?: string;
      name?: string;
    };
    /** @description A Dependabot alert. */
    "dependabot-alert": {
      number: components["schemas"]["alert-number"];
      /**
       * @description The state of the Dependabot alert.
       * @enum {string}
       */
      state: "auto_dismissed" | "dismissed" | "fixed" | "open";
      /** @description Details for the vulnerable dependency. */
      dependency: {
        readonly package?: components["schemas"]["dependabot-alert-package"];
        /** @description The full path to the dependency manifest file, relative to the root of the repository. */
        readonly manifest_path?: string;
        /**
         * @description The execution scope of the vulnerable dependency.
         * @enum {string|null}
         */
        readonly scope?: "development" | "runtime" | null;
      };
      security_advisory: components["schemas"]["dependabot-alert-security-advisory"];
      security_vulnerability: components["schemas"]["dependabot-alert-security-vulnerability"];
      url: components["schemas"]["alert-url"];
      html_url: components["schemas"]["alert-html-url"];
      created_at: components["schemas"]["alert-created-at"];
      updated_at: components["schemas"]["alert-updated-at"];
      dismissed_at: components["schemas"]["alert-dismissed-at"];
      dismissed_by: components["schemas"]["nullable-simple-user"];
      /**
       * @description The reason that the alert was dismissed.
       * @enum {string|null}
       */
      dismissed_reason:
        | "fix_started"
        | "inaccurate"
        | "no_bandwidth"
        | "not_used"
        | "tolerable_risk"
        | null;
      /** @description An optional comment associated with the alert's dismissal. */
      dismissed_comment: string | null;
      fixed_at: components["schemas"]["alert-fixed-at"];
      auto_dismissed_at?: components["schemas"]["alert-auto-dismissed-at"];
    };
    /**
     * Dependabot Secret
     * @description Set secrets for Dependabot.
     */
    "dependabot-secret": {
      /**
       * @description The name of the secret.
       * @example MY_ARTIFACTORY_PASSWORD
       */
      name: string;
      /** Format: date-time */
      created_at: string;
      /** Format: date-time */
      updated_at: string;
    };
    /**
     * Dependency Graph Diff
     * @description A diff of the dependencies between two commits.
     */
    "dependency-graph-diff": {
      /** @enum {string} */
      change_type: "added" | "removed";
      /** @example path/to/package-lock.json */
      manifest: string;
      /** @example npm */
      ecosystem: string;
      /** @example @actions/core */
      name: string;
      /** @example 1.0.0 */
      version: string;
      /** @example pkg:/npm/%40actions/core@1.1.0 */
      package_url: string | null;
      /** @example MIT */
      license: string | null;
      /** @example https://github.com/github/actions */
      source_repository_url: string | null;
      vulnerabilities: {
        /** @example critical */
        severity: string;
        /** @example GHSA-rf4j-j272-fj86 */
        advisory_ghsa_id: string;
        /** @example A summary of the advisory. */
        advisory_summary: string;
        /** @example https://github.com/advisories/GHSA-rf4j-j272-fj86 */
        advisory_url: string;
      }[];
      /**
       * @description Where the dependency is utilized. `development` means that the dependency is only utilized in the development environment. `runtime` means that the dependency is utilized at runtime and in the development environment.
       * @enum {string}
       */
      scope: "unknown" | "runtime" | "development";
    }[];
    /**
     * Dependency Graph SPDX SBOM
     * @description A schema for the SPDX JSON format returned by the Dependency Graph.
     */
    "dependency-graph-spdx-sbom": {
      sbom: {
        /**
         * @description The SPDX identifier for the SPDX document.
         * @example SPDXRef-DOCUMENT
         */
        SPDXID: string;
        /**
         * @description The version of the SPDX specification that this document conforms to.
         * @example SPDX-2.3
         */
        spdxVersion: string;
        creationInfo: {
          /**
           * @description The date and time the SPDX document was created.
           * @example 2021-11-03T00:00:00Z
           */
          created: string;
          /** @description The tools that were used to generate the SPDX document. */
          creators: string[];
        };
        /**
         * @description The name of the SPDX document.
         * @example github/github
         */
        name: string;
        /**
         * @description The license under which the SPDX document is licensed.
         * @example CC0-1.0
         */
        dataLicense: string;
        /** @description The name of the repository that the SPDX document describes. */
        documentDescribes: string[];
        /**
         * @description The namespace for the SPDX document.
         * @example https://github.com/example/dependency_graph/sbom-123
         */
        documentNamespace: string;
        packages: {
          /**
           * @description A unique SPDX identifier for the package.
           * @example SPDXRef-Package
           */
          SPDXID?: string;
          /**
           * @description The name of the package.
           * @example rubygems:github/github
           */
          name?: string;
          /**
           * @description The version of the package. If the package does not have an exact version specified,
           * a version range is given.
           * @example 1.0.0
           */
          versionInfo?: string;
          /**
           * @description The location where the package can be downloaded,
           * or NOASSERTION if this has not been determined.
           * @example NOASSERTION
           */
          downloadLocation?: string;
          /**
           * @description Whether the package's file content has been subjected to
           * analysis during the creation of the SPDX document.
           * @example false
           */
          filesAnalyzed?: boolean;
          /**
           * @description The license of the package as determined while creating the SPDX document.
           * @example MIT
           */
          licenseConcluded?: string;
          /**
           * @description The license of the package as declared by its author, or NOASSERTION if this information
           * was not available when the SPDX document was created.
           * @example NOASSERTION
           */
          licenseDeclared?: string;
          /**
           * @description The distribution source of this package, or NOASSERTION if this was not determined.
           * @example NOASSERTION
           */
          supplier?: string;
          externalRefs?: {
            /**
             * @description The category of reference to an external resource this reference refers to.
             * @example PACKAGE-MANAGER
             */
            referenceCategory: string;
            /**
             * @description A locator for the particular external resource this reference refers to.
             * @example pkg:gem/rails@6.0.1
             */
            referenceLocator: string;
            /**
             * @description The category of reference to an external resource this reference refers to.
             * @example purl
             */
            referenceType: string;
          }[];
        }[];
      };
    };
    /**
     * metadata
     * @description User-defined metadata to store domain-specific information limited to 8 keys with scalar values.
     */
    metadata: {
      [key: string]: (string | number | boolean) | null;
    };
    dependency: {
      /**
       * @description Package-url (PURL) of dependency. See https://github.com/package-url/purl-spec for more details.
       * @example pkg:/npm/%40actions/http-client@1.0.11
       */
      package_url?: string;
      metadata?: components["schemas"]["metadata"];
      /**
       * @description A notation of whether a dependency is requested directly by this manifest or is a dependency of another dependency.
       * @example direct
       * @enum {string}
       */
      relationship?: "direct" | "indirect";
      /**
       * @description A notation of whether the dependency is required for the primary build artifact (runtime) or is only used for development. Future versions of this specification may allow for more granular scopes.
       * @example runtime
       * @enum {string}
       */
      scope?: "runtime" | "development";
      /**
       * @description Array of package-url (PURLs) of direct child dependencies.
       * @example @actions/http-client
       */
      dependencies?: string[];
    };
    manifest: {
      /**
       * @description The name of the manifest.
       * @example package-lock.json
       */
      name: string;
      file?: {
        /**
         * @description The path of the manifest file relative to the root of the Git repository.
         * @example /src/build/package-lock.json
         */
        source_location?: string;
      };
      metadata?: components["schemas"]["metadata"];
      /** @description A collection of resolved package dependencies. */
      resolved?: {
        [key: string]: components["schemas"]["dependency"];
      };
    };
    /**
     * snapshot
     * @description Create a new snapshot of a repository's dependencies.
     */
    snapshot: {
      /** @description The version of the repository snapshot submission. */
      version: number;
      job: {
        /**
         * @description The external ID of the job.
         * @example 5622a2b0-63f6-4732-8c34-a1ab27e102a11
         */
        id: string;
        /**
         * @description Correlator provides a key that is used to group snapshots submitted over time. Only the "latest" submitted snapshot for a given combination of `job.correlator` and `detector.name` will be considered when calculating a repository's current dependencies. Correlator should be as unique as it takes to distinguish all detection runs for a given "wave" of CI workflow you run. If you're using GitHub Actions, a good default value for this could be the environment variables GITHUB_WORKFLOW and GITHUB_JOB concatenated together. If you're using a build matrix, then you'll also need to add additional key(s) to distinguish between each submission inside a matrix variation.
         * @example yourworkflowname_yourjobname
         */
        correlator: string;
        /**
         * @description The url for the job.
         * @example http://example.com/build
         */
        html_url?: string;
      };
      /**
       * @description The commit SHA associated with this dependency snapshot. Maximum length: 40 characters.
       * @example ddc951f4b1293222421f2c8df679786153acf689
       */
      sha: string;
      /**
       * @description The repository branch that triggered this snapshot.
       * @example refs/heads/main
       */
      ref: string;
      /** @description A description of the detector used. */
      detector: {
        /**
         * @description The name of the detector used.
         * @example docker buildtime detector
         */
        name: string;
        /**
         * @description The version of the detector used.
         * @example 1.0.0
         */
        version: string;
        /**
         * @description The url of the detector used.
         * @example http://example.com/docker-buildtimer-detector
         */
        url: string;
      };
      metadata?: components["schemas"]["metadata"];
      /** @description A collection of package manifests, which are a collection of related dependencies declared in a file or representing a logical group of dependencies. */
      manifests?: {
        [key: string]: components["schemas"]["manifest"];
      };
      /**
       * Format: date-time
       * @description The time at which the snapshot was scanned.
       * @example 2020-06-13T14:52:50-05:00
       */
      scanned: string;
    };
    /**
     * Deployment Status
     * @description The status of a deployment.
     */
    "deployment-status": {
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/example/deployments/42/statuses/1
       */
      url: string;
      /** @example 1 */
      id: number;
      /** @example MDE2OkRlcGxveW1lbnRTdGF0dXMx */
      node_id: string;
      /**
       * @description The state of the status.
       * @example success
       * @enum {string}
       */
      state:
        | "error"
        | "failure"
        | "inactive"
        | "pending"
        | "success"
        | "queued"
        | "in_progress";
      creator: components["schemas"]["nullable-simple-user"];
      /**
       * @description A short description of the status.
       * @default
       * @example Deployment finished successfully.
       */
      description: string;
      /**
       * @description The environment of the deployment that the status is for.
       * @default
       * @example production
       */
      environment?: string;
      /**
       * Format: uri
       * @description Deprecated: the URL to associate with this status.
       * @default
       * @example https://example.com/deployment/42/output
       */
      target_url: string;
      /**
       * Format: date-time
       * @example 2012-07-20T01:19:13Z
       */
      created_at: string;
      /**
       * Format: date-time
       * @example 2012-07-20T01:19:13Z
       */
      updated_at: string;
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/example/deployments/42
       */
      deployment_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/example
       */
      repository_url: string;
      /**
       * Format: uri
       * @description The URL for accessing your environment.
       * @default
       * @example https://staging.example.com/
       */
      environment_url?: string;
      /**
       * Format: uri
       * @description The URL to associate with this status.
       * @default
       * @example https://example.com/deployment/42/output
       */
      log_url?: string;
      performed_via_github_app?: components["schemas"]["nullable-integration"];
    };
    /**
     * @description The amount of time to delay a job after the job is initially triggered. The time (in minutes) must be an integer between 0 and 43,200 (30 days).
     * @example 30
     */
    "wait-timer": number;
    /** @description The type of deployment branch policy for this environment. To allow all branches to deploy, set to `null`. */
    "deployment-branch-policy-settings": {
      /** @description Whether only branches with branch protection rules can deploy to this environment. If `protected_branches` is `true`, `custom_branch_policies` must be `false`; if `protected_branches` is `false`, `custom_branch_policies` must be `true`. */
      protected_branches: boolean;
      /** @description Whether only branches that match the specified name patterns can deploy to this environment.  If `custom_branch_policies` is `true`, `protected_branches` must be `false`; if `custom_branch_policies` is `false`, `protected_branches` must be `true`. */
      custom_branch_policies: boolean;
    } | null;
    /**
     * Environment
     * @description Details of a deployment environment
     */
    environment: {
      /**
       * @description The id of the environment.
       * @example 56780428
       */
      id: number;
      /** @example MDExOkVudmlyb25tZW50NTY3ODA0Mjg= */
      node_id: string;
      /**
       * @description The name of the environment.
       * @example staging
       */
      name: string;
      /** @example https://api.github.com/repos/github/hello-world/environments/staging */
      url: string;
      /** @example https://github.com/github/hello-world/deployments/activity_log?environments_filter=staging */
      html_url: string;
      /**
       * Format: date-time
       * @description The time that the environment was created, in ISO 8601 format.
       * @example 2020-11-23T22:00:40Z
       */
      created_at: string;
      /**
       * Format: date-time
       * @description The time that the environment was last updated, in ISO 8601 format.
       * @example 2020-11-23T22:00:40Z
       */
      updated_at: string;
      /** @description Built-in deployment protection rules for the environment. */
      protection_rules?: (
        | {
            /** @example 3515 */
            id: number;
            /** @example MDQ6R2F0ZTM1MTU= */
            node_id: string;
            /** @example wait_timer */
            type: string;
            wait_timer?: components["schemas"]["wait-timer"];
          }
        | {
            /** @example 3755 */
            id: number;
            /** @example MDQ6R2F0ZTM3NTU= */
            node_id: string;
            /** @example required_reviewers */
            type: string;
            /** @description The people or teams that may approve jobs that reference the environment. You can list up to six users or teams as reviewers. The reviewers must have at least read access to the repository. Only one of the required reviewers needs to approve the job for it to proceed. */
            reviewers?: {
              type?: components["schemas"]["deployment-reviewer-type"];
              reviewer?:
                | components["schemas"]["simple-user"]
                | components["schemas"]["team"];
            }[];
          }
        | {
            /** @example 3515 */
            id: number;
            /** @example MDQ6R2F0ZTM1MTU= */
            node_id: string;
            /** @example branch_policy */
            type: string;
          }
      )[];
      deployment_branch_policy?: components["schemas"]["deployment-branch-policy-settings"];
    };
    /**
     * Deployment branch policy
     * @description Details of a deployment branch policy.
     */
    "deployment-branch-policy": {
      /**
       * @description The unique identifier of the branch policy.
       * @example 361471
       */
      id?: number;
      /** @example MDE2OkdhdGVCcmFuY2hQb2xpY3kzNjE0NzE= */
      node_id?: string;
      /**
       * @description The name pattern that branches must match in order to deploy to the environment.
       * @example release/*
       */
      name?: string;
    };
    /** Deployment branch and tag policy name pattern */
    "deployment-branch-policy-name-pattern-with-type": {
      /**
       * @description The name pattern that branches or tags must match in order to deploy to the environment.
       *
       * Wildcard characters will not match `/`. For example, to match branches that begin with `release/` and contain an additional single slash, use `release/*\/*`.
       * For more information about pattern matching syntax, see the [Ruby File.fnmatch documentation](https://ruby-doc.org/core-2.5.1/File.html#method-c-fnmatch).
       * @example release/*
       */
      name: string;
    };
    /** Deployment branch policy name pattern */
    "deployment-branch-policy-name-pattern": {
      /**
       * @description The name pattern that branches must match in order to deploy to the environment.
       *
       * Wildcard characters will not match `/`. For example, to match branches that begin with `release/` and contain an additional single slash, use `release/*\/*`.
       * For more information about pattern matching syntax, see the [Ruby File.fnmatch documentation](https://ruby-doc.org/core-2.5.1/File.html#method-c-fnmatch).
       * @example release/*
       */
      name: string;
    };
    /**
     * Custom deployment protection rule app
     * @description A GitHub App that is providing a custom deployment protection rule.
     */
    "custom-deployment-rule-app": {
      /**
       * @description The unique identifier of the deployment protection rule integration.
       * @example 3515
       */
      id: number;
      /**
       * @description The slugified name of the deployment protection rule integration.
       * @example my-custom-app
       */
      slug: string;
      /**
       * @description The URL for the endpoint to get details about the app.
       * @example https://api.github.com/apps/custom-app-slug
       */
      integration_url: string;
      /**
       * @description The node ID for the deployment protection rule integration.
       * @example MDQ6R2F0ZTM1MTU=
       */
      node_id: string;
    };
    /**
     * Deployment protection rule
     * @description Deployment protection rule
     */
    "deployment-protection-rule": {
      /**
       * @description The unique identifier for the deployment protection rule.
       * @example 3515
       */
      id: number;
      /**
       * @description The node ID for the deployment protection rule.
       * @example MDQ6R2F0ZTM1MTU=
       */
      node_id: string;
      /**
       * @description Whether the deployment protection rule is enabled for the environment.
       * @example true
       */
      enabled: boolean;
      app: components["schemas"]["custom-deployment-rule-app"];
    };
    /**
     * Short Blob
     * @description Short Blob
     */
    "short-blob": {
      url: string;
      sha: string;
    };
    /**
     * Blob
     * @description Blob
     */
    blob: {
      content: string;
      encoding: string;
      /** Format: uri */
      url: string;
      sha: string;
      size: number | null;
      node_id: string;
      highlighted_content?: string;
    };
    /**
     * Git Commit
     * @description Low-level Git commit operations within a repository
     */
    "git-commit": {
      /**
       * @description SHA for the commit
       * @example 7638417db6d59f3c431d3e1f261cc637155684cd
       */
      sha: string;
      node_id: string;
      /** Format: uri */
      url: string;
      /** @description Identifying information for the git-user */
      author: {
        /**
         * Format: date-time
         * @description Timestamp of the commit
         * @example 2014-08-09T08:02:04+12:00
         */
        date: string;
        /**
         * @description Git email address of the user
         * @example monalisa.octocat@example.com
         */
        email: string;
        /**
         * @description Name of the git user
         * @example Monalisa Octocat
         */
        name: string;
      };
      /** @description Identifying information for the git-user */
      committer: {
        /**
         * Format: date-time
         * @description Timestamp of the commit
         * @example 2014-08-09T08:02:04+12:00
         */
        date: string;
        /**
         * @description Git email address of the user
         * @example monalisa.octocat@example.com
         */
        email: string;
        /**
         * @description Name of the git user
         * @example Monalisa Octocat
         */
        name: string;
      };
      /**
       * @description Message describing the purpose of the commit
       * @example Fix #42
       */
      message: string;
      tree: {
        /**
         * @description SHA for the commit
         * @example 7638417db6d59f3c431d3e1f261cc637155684cd
         */
        sha: string;
        /** Format: uri */
        url: string;
      };
      parents: {
        /**
         * @description SHA for the commit
         * @example 7638417db6d59f3c431d3e1f261cc637155684cd
         */
        sha: string;
        /** Format: uri */
        url: string;
        /** Format: uri */
        html_url: string;
      }[];
      verification: {
        verified: boolean;
        reason: string;
        signature: string | null;
        payload: string | null;
      };
      /** Format: uri */
      html_url: string;
    };
    /**
     * Git Reference
     * @description Git references within a repository
     */
    "git-ref": {
      ref: string;
      node_id: string;
      /** Format: uri */
      url: string;
      object: {
        type: string;
        /**
         * @description SHA for the reference
         * @example 7638417db6d59f3c431d3e1f261cc637155684cd
         */
        sha: string;
        /** Format: uri */
        url: string;
      };
    };
    /**
     * Git Tag
     * @description Metadata for a Git tag
     */
    "git-tag": {
      /** @example MDM6VGFnOTQwYmQzMzYyNDhlZmFlMGY5ZWU1YmM3YjJkNWM5ODU4ODdiMTZhYw== */
      node_id: string;
      /**
       * @description Name of the tag
       * @example v0.0.1
       */
      tag: string;
      /** @example 940bd336248efae0f9ee5bc7b2d5c985887b16ac */
      sha: string;
      /**
       * Format: uri
       * @description URL for the tag
       * @example https://api.github.com/repositories/42/git/tags/940bd336248efae0f9ee5bc7b2d5c985887b16ac
       */
      url: string;
      /**
       * @description Message describing the purpose of the tag
       * @example Initial public release
       */
      message: string;
      tagger: {
        date: string;
        email: string;
        name: string;
      };
      object: {
        sha: string;
        type: string;
        /** Format: uri */
        url: string;
      };
      verification?: components["schemas"]["verification"];
    };
    /**
     * Git Tree
     * @description The hierarchy between files in a Git repository.
     */
    "git-tree": {
      sha: string;
      /** Format: uri */
      url: string;
      truncated: boolean;
      /**
       * @description Objects specifying a tree structure
       * @example [
       *   {
       *     "path": "file.rb",
       *     "mode": "100644",
       *     "type": "blob",
       *     "size": 30,
       *     "sha": "44b4fc6d56897b048c772eb4087f854f46256132",
       *     "url": "https://api.github.com/repos/octocat/Hello-World/git/blobs/44b4fc6d56897b048c772eb4087f854f46256132",
       *     "properties": {
       *       "path": {
       *         "type": "string"
       *       },
       *       "mode": {
       *         "type": "string"
       *       },
       *       "type": {
       *         "type": "string"
       *       },
       *       "size": {
       *         "type": "integer"
       *       },
       *       "sha": {
       *         "type": "string"
       *       },
       *       "url": {
       *         "type": "string"
       *       }
       *     },
       *     "required": [
       *       "path",
       *       "mode",
       *       "type",
       *       "sha",
       *       "url",
       *       "size"
       *     ]
       *   }
       * ]
       */
      tree: {
        /** @example test/file.rb */
        path?: string;
        /** @example 040000 */
        mode?: string;
        /** @example tree */
        type?: string;
        /** @example 23f6827669e43831def8a7ad935069c8bd418261 */
        sha?: string;
        /** @example 12 */
        size?: number;
        /** @example https://api.github.com/repos/owner-482f3203ecf01f67e9deb18e/BBB_Private_Repo/git/blobs/23f6827669e43831def8a7ad935069c8bd418261 */
        url?: string;
      }[];
    };
    /** Hook Response */
    "hook-response": {
      code: number | null;
      status: string | null;
      message: string | null;
    };
    /**
     * Webhook
     * @description Webhooks for repositories.
     */
    hook: {
      type: string;
      /**
       * @description Unique identifier of the webhook.
       * @example 42
       */
      id: number;
      /**
       * @description The name of a valid service, use 'web' for a webhook.
       * @example web
       */
      name: string;
      /**
       * @description Determines whether the hook is actually triggered on pushes.
       * @example true
       */
      active: boolean;
      /**
       * @description Determines what events the hook is triggered for. Default: ['push'].
       * @example [
       *   "push",
       *   "pull_request"
       * ]
       */
      events: string[];
      config: components["schemas"]["webhook-config"];
      /**
       * Format: date-time
       * @example 2011-09-06T20:39:23Z
       */
      updated_at: string;
      /**
       * Format: date-time
       * @example 2011-09-06T17:26:27Z
       */
      created_at: string;
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/Hello-World/hooks/1
       */
      url: string;
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/Hello-World/hooks/1/test
       */
      test_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/Hello-World/hooks/1/pings
       */
      ping_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/Hello-World/hooks/1/deliveries
       */
      deliveries_url?: string;
      last_response: components["schemas"]["hook-response"];
    };
    /**
     * Repository Invitation
     * @description Repository invitations let you manage who you collaborate with.
     */
    "repository-invitation": {
      /**
       * @description Unique identifier of the repository invitation.
       * @example 42
       */
      id: number;
      repository: components["schemas"]["minimal-repository"];
      invitee: components["schemas"]["nullable-simple-user"];
      inviter: components["schemas"]["nullable-simple-user"];
      /**
       * @description The permission associated with the invitation.
       * @example read
       * @enum {string}
       */
      permissions: "read" | "write" | "admin" | "triage" | "maintain";
      /**
       * Format: date-time
       * @example 2016-06-13T14:52:50-05:00
       */
      created_at: string;
      /** @description Whether or not the invitation has expired */
      expired?: boolean;
      /**
       * @description URL for the repository invitation
       * @example https://api.github.com/user/repository-invitations/1
       */
      url: string;
      /** @example https://github.com/octocat/Hello-World/invitations */
      html_url: string;
      node_id: string;
    };
    /**
     * Issue
     * @description Issues are a great way to keep track of tasks, enhancements, and bugs for your projects.
     */
    "nullable-issue": {
      /** Format: int64 */
      id: number;
      node_id: string;
      /**
       * Format: uri
       * @description URL for the issue
       * @example https://api.github.com/repositories/42/issues/1
       */
      url: string;
      /** Format: uri */
      repository_url: string;
      labels_url: string;
      /** Format: uri */
      comments_url: string;
      /** Format: uri */
      events_url: string;
      /** Format: uri */
      html_url: string;
      /**
       * @description Number uniquely identifying the issue within its repository
       * @example 42
       */
      number: number;
      /**
       * @description State of the issue; either 'open' or 'closed'
       * @example open
       */
      state: string;
      /**
       * @description The reason for the current state
       * @example not_planned
       * @enum {string|null}
       */
      state_reason?: "completed" | "reopened" | "not_planned" | null;
      /**
       * @description Title of the issue
       * @example Widget creation fails in Safari on OS X 10.8
       */
      title: string;
      /**
       * @description Contents of the issue
       * @example It looks like the new widget form is broken on Safari. When I try and create the widget, Safari crashes. This is reproducible on 10.8, but not 10.9. Maybe a browser bug?
       */
      body?: string | null;
      user: components["schemas"]["nullable-simple-user"];
      /**
       * @description Labels to associate with this issue; pass one or more label names to replace the set of labels on this issue; send an empty array to clear all labels from the issue; note that the labels are silently dropped for users without push access to the repository
       * @example [
       *   "bug",
       *   "registration"
       * ]
       */
      labels: OneOf<
        [
          string,
          {
            /** Format: int64 */
            id?: number;
            node_id?: string;
            /** Format: uri */
            url?: string;
            name?: string;
            description?: string | null;
            color?: string | null;
            default?: boolean;
          },
        ]
      >[];
      assignee: components["schemas"]["nullable-simple-user"];
      assignees?: components["schemas"]["simple-user"][] | null;
      milestone: components["schemas"]["nullable-milestone"];
      locked: boolean;
      active_lock_reason?: string | null;
      comments: number;
      pull_request?: {
        /** Format: date-time */
        merged_at?: string | null;
        /** Format: uri */
        diff_url: string | null;
        /** Format: uri */
        html_url: string | null;
        /** Format: uri */
        patch_url: string | null;
        /** Format: uri */
        url: string | null;
      };
      /** Format: date-time */
      closed_at: string | null;
      /** Format: date-time */
      created_at: string;
      /** Format: date-time */
      updated_at: string;
      draft?: boolean;
      closed_by?: components["schemas"]["nullable-simple-user"];
      body_html?: string;
      body_text?: string;
      /** Format: uri */
      timeline_url?: string;
      repository?: components["schemas"]["repository"];
      performed_via_github_app?: components["schemas"]["nullable-integration"];
      author_association: components["schemas"]["author-association"];
      reactions?: components["schemas"]["reaction-rollup"];
    } | null;
    /**
     * Issue Event Label
     * @description Issue Event Label
     */
    "issue-event-label": {
      name: string | null;
      color: string | null;
    };
    /** Issue Event Dismissed Review */
    "issue-event-dismissed-review": {
      state: string;
      review_id: number;
      dismissal_message: string | null;
      dismissal_commit_id?: string | null;
    };
    /**
     * Issue Event Milestone
     * @description Issue Event Milestone
     */
    "issue-event-milestone": {
      title: string;
    };
    /**
     * Issue Event Project Card
     * @description Issue Event Project Card
     */
    "issue-event-project-card": {
      /** Format: uri */
      url: string;
      id: number;
      /** Format: uri */
      project_url: string;
      project_id: number;
      column_name: string;
      previous_column_name?: string;
    };
    /**
     * Issue Event Rename
     * @description Issue Event Rename
     */
    "issue-event-rename": {
      from: string;
      to: string;
    };
    /**
     * Issue Event
     * @description Issue Event
     */
    "issue-event": {
      /**
       * Format: int64
       * @example 1
       */
      id: number;
      /** @example MDEwOklzc3VlRXZlbnQx */
      node_id: string;
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/Hello-World/issues/events/1
       */
      url: string;
      actor: components["schemas"]["nullable-simple-user"];
      /** @example closed */
      event: string;
      /** @example 6dcb09b5b57875f334f61aebed695e2e4193db5e */
      commit_id: string | null;
      /** @example https://api.github.com/repos/octocat/Hello-World/commits/6dcb09b5b57875f334f61aebed695e2e4193db5e */
      commit_url: string | null;
      /**
       * Format: date-time
       * @example 2011-04-14T16:00:49Z
       */
      created_at: string;
      issue?: components["schemas"]["nullable-issue"];
      label?: components["schemas"]["issue-event-label"];
      assignee?: components["schemas"]["nullable-simple-user"];
      assigner?: components["schemas"]["nullable-simple-user"];
      review_requester?: components["schemas"]["nullable-simple-user"];
      requested_reviewer?: components["schemas"]["nullable-simple-user"];
      requested_team?: components["schemas"]["team"];
      dismissed_review?: components["schemas"]["issue-event-dismissed-review"];
      milestone?: components["schemas"]["issue-event-milestone"];
      project_card?: components["schemas"]["issue-event-project-card"];
      rename?: components["schemas"]["issue-event-rename"];
      author_association?: components["schemas"]["author-association"];
      lock_reason?: string | null;
      performed_via_github_app?: components["schemas"]["nullable-integration"];
    };
    /**
     * Labeled Issue Event
     * @description Labeled Issue Event
     */
    "labeled-issue-event": {
      id: number;
      node_id: string;
      url: string;
      actor: components["schemas"]["simple-user"];
      event: string;
      commit_id: string | null;
      commit_url: string | null;
      created_at: string;
      performed_via_github_app: components["schemas"]["nullable-integration"];
      label: {
        name: string;
        color: string;
      };
    };
    /**
     * Unlabeled Issue Event
     * @description Unlabeled Issue Event
     */
    "unlabeled-issue-event": {
      id: number;
      node_id: string;
      url: string;
      actor: components["schemas"]["simple-user"];
      event: string;
      commit_id: string | null;
      commit_url: string | null;
      created_at: string;
      performed_via_github_app: components["schemas"]["nullable-integration"];
      label: {
        name: string;
        color: string;
      };
    };
    /**
     * Assigned Issue Event
     * @description Assigned Issue Event
     */
    "assigned-issue-event": {
      id: number;
      node_id: string;
      url: string;
      actor: components["schemas"]["simple-user"];
      event: string;
      commit_id: string | null;
      commit_url: string | null;
      created_at: string;
      performed_via_github_app: components["schemas"]["integration"];
      assignee: components["schemas"]["simple-user"];
      assigner: components["schemas"]["simple-user"];
    };
    /**
     * Unassigned Issue Event
     * @description Unassigned Issue Event
     */
    "unassigned-issue-event": {
      id: number;
      node_id: string;
      url: string;
      actor: components["schemas"]["simple-user"];
      event: string;
      commit_id: string | null;
      commit_url: string | null;
      created_at: string;
      performed_via_github_app: components["schemas"]["nullable-integration"];
      assignee: components["schemas"]["simple-user"];
      assigner: components["schemas"]["simple-user"];
    };
    /**
     * Milestoned Issue Event
     * @description Milestoned Issue Event
     */
    "milestoned-issue-event": {
      id: number;
      node_id: string;
      url: string;
      actor: components["schemas"]["simple-user"];
      event: string;
      commit_id: string | null;
      commit_url: string | null;
      created_at: string;
      performed_via_github_app: components["schemas"]["nullable-integration"];
      milestone: {
        title: string;
      };
    };
    /**
     * Demilestoned Issue Event
     * @description Demilestoned Issue Event
     */
    "demilestoned-issue-event": {
      id: number;
      node_id: string;
      url: string;
      actor: components["schemas"]["simple-user"];
      event: string;
      commit_id: string | null;
      commit_url: string | null;
      created_at: string;
      performed_via_github_app: components["schemas"]["nullable-integration"];
      milestone: {
        title: string;
      };
    };
    /**
     * Renamed Issue Event
     * @description Renamed Issue Event
     */
    "renamed-issue-event": {
      id: number;
      node_id: string;
      url: string;
      actor: components["schemas"]["simple-user"];
      event: string;
      commit_id: string | null;
      commit_url: string | null;
      created_at: string;
      performed_via_github_app: components["schemas"]["nullable-integration"];
      rename: {
        from: string;
        to: string;
      };
    };
    /**
     * Review Requested Issue Event
     * @description Review Requested Issue Event
     */
    "review-requested-issue-event": {
      id: number;
      node_id: string;
      url: string;
      actor: components["schemas"]["simple-user"];
      event: string;
      commit_id: string | null;
      commit_url: string | null;
      created_at: string;
      performed_via_github_app: components["schemas"]["nullable-integration"];
      review_requester: components["schemas"]["simple-user"];
      requested_team?: components["schemas"]["team"];
      requested_reviewer?: components["schemas"]["simple-user"];
    };
    /**
     * Review Request Removed Issue Event
     * @description Review Request Removed Issue Event
     */
    "review-request-removed-issue-event": {
      id: number;
      node_id: string;
      url: string;
      actor: components["schemas"]["simple-user"];
      event: string;
      commit_id: string | null;
      commit_url: string | null;
      created_at: string;
      performed_via_github_app: components["schemas"]["nullable-integration"];
      review_requester: components["schemas"]["simple-user"];
      requested_team?: components["schemas"]["team"];
      requested_reviewer?: components["schemas"]["simple-user"];
    };
    /**
     * Review Dismissed Issue Event
     * @description Review Dismissed Issue Event
     */
    "review-dismissed-issue-event": {
      id: number;
      node_id: string;
      url: string;
      actor: components["schemas"]["simple-user"];
      event: string;
      commit_id: string | null;
      commit_url: string | null;
      created_at: string;
      performed_via_github_app: components["schemas"]["nullable-integration"];
      dismissed_review: {
        state: string;
        review_id: number;
        dismissal_message: string | null;
        dismissal_commit_id?: string;
      };
    };
    /**
     * Locked Issue Event
     * @description Locked Issue Event
     */
    "locked-issue-event": {
      id: number;
      node_id: string;
      url: string;
      actor: components["schemas"]["simple-user"];
      event: string;
      commit_id: string | null;
      commit_url: string | null;
      created_at: string;
      performed_via_github_app: components["schemas"]["nullable-integration"];
      /** @example "off-topic" */
      lock_reason: string | null;
    };
    /**
     * Added to Project Issue Event
     * @description Added to Project Issue Event
     */
    "added-to-project-issue-event": {
      id: number;
      node_id: string;
      url: string;
      actor: components["schemas"]["simple-user"];
      event: string;
      commit_id: string | null;
      commit_url: string | null;
      created_at: string;
      performed_via_github_app: components["schemas"]["nullable-integration"];
      project_card?: {
        id: number;
        /** Format: uri */
        url: string;
        project_id: number;
        /** Format: uri */
        project_url: string;
        column_name: string;
        previous_column_name?: string;
      };
    };
    /**
     * Moved Column in Project Issue Event
     * @description Moved Column in Project Issue Event
     */
    "moved-column-in-project-issue-event": {
      id: number;
      node_id: string;
      url: string;
      actor: components["schemas"]["simple-user"];
      event: string;
      commit_id: string | null;
      commit_url: string | null;
      created_at: string;
      performed_via_github_app: components["schemas"]["nullable-integration"];
      project_card?: {
        id: number;
        /** Format: uri */
        url: string;
        project_id: number;
        /** Format: uri */
        project_url: string;
        column_name: string;
        previous_column_name?: string;
      };
    };
    /**
     * Removed from Project Issue Event
     * @description Removed from Project Issue Event
     */
    "removed-from-project-issue-event": {
      id: number;
      node_id: string;
      url: string;
      actor: components["schemas"]["simple-user"];
      event: string;
      commit_id: string | null;
      commit_url: string | null;
      created_at: string;
      performed_via_github_app: components["schemas"]["nullable-integration"];
      project_card?: {
        id: number;
        /** Format: uri */
        url: string;
        project_id: number;
        /** Format: uri */
        project_url: string;
        column_name: string;
        previous_column_name?: string;
      };
    };
    /**
     * Converted Note to Issue Issue Event
     * @description Converted Note to Issue Issue Event
     */
    "converted-note-to-issue-issue-event": {
      id: number;
      node_id: string;
      url: string;
      actor: components["schemas"]["simple-user"];
      event: string;
      commit_id: string | null;
      commit_url: string | null;
      created_at: string;
      performed_via_github_app: components["schemas"]["integration"];
      project_card?: {
        id: number;
        /** Format: uri */
        url: string;
        project_id: number;
        /** Format: uri */
        project_url: string;
        column_name: string;
        previous_column_name?: string;
      };
    };
    /**
     * Issue Event for Issue
     * @description Issue Event for Issue
     */
    "issue-event-for-issue":
      | components["schemas"]["labeled-issue-event"]
      | components["schemas"]["unlabeled-issue-event"]
      | components["schemas"]["assigned-issue-event"]
      | components["schemas"]["unassigned-issue-event"]
      | components["schemas"]["milestoned-issue-event"]
      | components["schemas"]["demilestoned-issue-event"]
      | components["schemas"]["renamed-issue-event"]
      | components["schemas"]["review-requested-issue-event"]
      | components["schemas"]["review-request-removed-issue-event"]
      | components["schemas"]["review-dismissed-issue-event"]
      | components["schemas"]["locked-issue-event"]
      | components["schemas"]["added-to-project-issue-event"]
      | components["schemas"]["moved-column-in-project-issue-event"]
      | components["schemas"]["removed-from-project-issue-event"]
      | components["schemas"]["converted-note-to-issue-issue-event"];
    /**
     * Label
     * @description Color-coded labels help you categorize and filter your issues (just like labels in Gmail).
     */
    label: {
      /**
       * Format: int64
       * @example 208045946
       */
      id: number;
      /** @example MDU6TGFiZWwyMDgwNDU5NDY= */
      node_id: string;
      /**
       * Format: uri
       * @description URL for the label
       * @example https://api.github.com/repositories/42/labels/bug
       */
      url: string;
      /**
       * @description The name of the label.
       * @example bug
       */
      name: string;
      /** @example Something isn't working */
      description: string | null;
      /**
       * @description 6-character hex code, without the leading #, identifying the color
       * @example FFFFFF
       */
      color: string;
      /** @example true */
      default: boolean;
    };
    /**
     * Timeline Comment Event
     * @description Timeline Comment Event
     */
    "timeline-comment-event": {
      event: string;
      actor: components["schemas"]["simple-user"];
      /**
       * @description Unique identifier of the issue comment
       * @example 42
       */
      id: number;
      node_id: string;
      /**
       * Format: uri
       * @description URL for the issue comment
       * @example https://api.github.com/repositories/42/issues/comments/1
       */
      url: string;
      /**
       * @description Contents of the issue comment
       * @example What version of Safari were you using when you observed this bug?
       */
      body?: string;
      body_text?: string;
      body_html?: string;
      /** Format: uri */
      html_url: string;
      user: components["schemas"]["simple-user"];
      /**
       * Format: date-time
       * @example 2011-04-14T16:00:49Z
       */
      created_at: string;
      /**
       * Format: date-time
       * @example 2011-04-14T16:00:49Z
       */
      updated_at: string;
      /** Format: uri */
      issue_url: string;
      author_association: components["schemas"]["author-association"];
      performed_via_github_app?: components["schemas"]["nullable-integration"];
      reactions?: components["schemas"]["reaction-rollup"];
    };
    /**
     * Timeline Cross Referenced Event
     * @description Timeline Cross Referenced Event
     */
    "timeline-cross-referenced-event": {
      event: string;
      actor?: components["schemas"]["simple-user"];
      /** Format: date-time */
      created_at: string;
      /** Format: date-time */
      updated_at: string;
      source: {
        type?: string;
        issue?: components["schemas"]["issue"];
      };
    };
    /**
     * Timeline Committed Event
     * @description Timeline Committed Event
     */
    "timeline-committed-event": {
      event?: string;
      /**
       * @description SHA for the commit
       * @example 7638417db6d59f3c431d3e1f261cc637155684cd
       */
      sha: string;
      node_id: string;
      /** Format: uri */
      url: string;
      /** @description Identifying information for the git-user */
      author: {
        /**
         * Format: date-time
         * @description Timestamp of the commit
         * @example 2014-08-09T08:02:04+12:00
         */
        date: string;
        /**
         * @description Git email address of the user
         * @example monalisa.octocat@example.com
         */
        email: string;
        /**
         * @description Name of the git user
         * @example Monalisa Octocat
         */
        name: string;
      };
      /** @description Identifying information for the git-user */
      committer: {
        /**
         * Format: date-time
         * @description Timestamp of the commit
         * @example 2014-08-09T08:02:04+12:00
         */
        date: string;
        /**
         * @description Git email address of the user
         * @example monalisa.octocat@example.com
         */
        email: string;
        /**
         * @description Name of the git user
         * @example Monalisa Octocat
         */
        name: string;
      };
      /**
       * @description Message describing the purpose of the commit
       * @example Fix #42
       */
      message: string;
      tree: {
        /**
         * @description SHA for the commit
         * @example 7638417db6d59f3c431d3e1f261cc637155684cd
         */
        sha: string;
        /** Format: uri */
        url: string;
      };
      parents: {
        /**
         * @description SHA for the commit
         * @example 7638417db6d59f3c431d3e1f261cc637155684cd
         */
        sha: string;
        /** Format: uri */
        url: string;
        /** Format: uri */
        html_url: string;
      }[];
      verification: {
        verified: boolean;
        reason: string;
        signature: string | null;
        payload: string | null;
      };
      /** Format: uri */
      html_url: string;
    };
    /**
     * Timeline Reviewed Event
     * @description Timeline Reviewed Event
     */
    "timeline-reviewed-event": {
      event: string;
      /**
       * @description Unique identifier of the review
       * @example 42
       */
      id: number;
      /** @example MDE3OlB1bGxSZXF1ZXN0UmV2aWV3ODA= */
      node_id: string;
      user: components["schemas"]["simple-user"];
      /**
       * @description The text of the review.
       * @example This looks great.
       */
      body: string | null;
      /** @example CHANGES_REQUESTED */
      state: string;
      /**
       * Format: uri
       * @example https://github.com/octocat/Hello-World/pull/12#pullrequestreview-80
       */
      html_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/Hello-World/pulls/12
       */
      pull_request_url: string;
      _links: {
        html: {
          href: string;
        };
        pull_request: {
          href: string;
        };
      };
      /** Format: date-time */
      submitted_at?: string;
      /**
       * @description A commit SHA for the review.
       * @example 54bb654c9e6025347f57900a4a5c2313a96b8035
       */
      commit_id: string;
      body_html?: string;
      body_text?: string;
      author_association: components["schemas"]["author-association"];
    };
    /**
     * Pull Request Review Comment
     * @description Pull Request Review Comments are comments on a portion of the Pull Request's diff.
     */
    "pull-request-review-comment": {
      /**
       * @description URL for the pull request review comment
       * @example https://api.github.com/repos/octocat/Hello-World/pulls/comments/1
       */
      url: string;
      /**
       * @description The ID of the pull request review to which the comment belongs.
       * @example 42
       */
      pull_request_review_id: number | null;
      /**
       * @description The ID of the pull request review comment.
       * @example 1
       */
      id: number;
      /**
       * @description The node ID of the pull request review comment.
       * @example MDI0OlB1bGxSZXF1ZXN0UmV2aWV3Q29tbWVudDEw
       */
      node_id: string;
      /**
       * @description The diff of the line that the comment refers to.
       * @example @@ -16,33 +16,40 @@ public class Connection : IConnection...
       */
      diff_hunk: string;
      /**
       * @description The relative path of the file to which the comment applies.
       * @example config/database.yaml
       */
      path: string;
      /**
       * @description The line index in the diff to which the comment applies. This field is deprecated; use `line` instead.
       * @example 1
       */
      position?: number;
      /**
       * @description The index of the original line in the diff to which the comment applies. This field is deprecated; use `original_line` instead.
       * @example 4
       */
      original_position?: number;
      /**
       * @description The SHA of the commit to which the comment applies.
       * @example 6dcb09b5b57875f334f61aebed695e2e4193db5e
       */
      commit_id: string;
      /**
       * @description The SHA of the original commit to which the comment applies.
       * @example 9c48853fa3dc5c1c3d6f1f1cd1f2743e72652840
       */
      original_commit_id: string;
      /**
       * @description The comment ID to reply to.
       * @example 8
       */
      in_reply_to_id?: number;
      user: components["schemas"]["simple-user"];
      /**
       * @description The text of the comment.
       * @example We should probably include a check for null values here.
       */
      body: string;
      /**
       * Format: date-time
       * @example 2011-04-14T16:00:49Z
       */
      created_at: string;
      /**
       * Format: date-time
       * @example 2011-04-14T16:00:49Z
       */
      updated_at: string;
      /**
       * Format: uri
       * @description HTML URL for the pull request review comment.
       * @example https://github.com/octocat/Hello-World/pull/1#discussion-diff-1
       */
      html_url: string;
      /**
       * Format: uri
       * @description URL for the pull request that the review comment belongs to.
       * @example https://api.github.com/repos/octocat/Hello-World/pulls/1
       */
      pull_request_url: string;
      author_association: components["schemas"]["author-association"];
      _links: {
        self: {
          /**
           * Format: uri
           * @example https://api.github.com/repos/octocat/Hello-World/pulls/comments/1
           */
          href: string;
        };
        html: {
          /**
           * Format: uri
           * @example https://github.com/octocat/Hello-World/pull/1#discussion-diff-1
           */
          href: string;
        };
        pull_request: {
          /**
           * Format: uri
           * @example https://api.github.com/repos/octocat/Hello-World/pulls/1
           */
          href: string;
        };
      };
      /**
       * @description The first line of the range for a multi-line comment.
       * @example 2
       */
      start_line?: number | null;
      /**
       * @description The first line of the range for a multi-line comment.
       * @example 2
       */
      original_start_line?: number | null;
      /**
       * @description The side of the first line of the range for a multi-line comment.
       * @default RIGHT
       * @enum {string|null}
       */
      start_side?: "LEFT" | "RIGHT" | null;
      /**
       * @description The line of the blob to which the comment applies. The last line of the range for a multi-line comment
       * @example 2
       */
      line?: number;
      /**
       * @description The line of the blob to which the comment applies. The last line of the range for a multi-line comment
       * @example 2
       */
      original_line?: number;
      /**
       * @description The side of the diff to which the comment applies. The side of the last line of the range for a multi-line comment
       * @default RIGHT
       * @enum {string}
       */
      side?: "LEFT" | "RIGHT";
      /**
       * @description The level at which the comment is targeted, can be a diff line or a file.
       * @enum {string}
       */
      subject_type?: "line" | "file";
      reactions?: components["schemas"]["reaction-rollup"];
      /** @example "<p>comment body</p>" */
      body_html?: string;
      /** @example "comment body" */
      body_text?: string;
    };
    /**
     * Timeline Line Commented Event
     * @description Timeline Line Commented Event
     */
    "timeline-line-commented-event": {
      event?: string;
      node_id?: string;
      comments?: components["schemas"]["pull-request-review-comment"][];
    };
    /**
     * Timeline Commit Commented Event
     * @description Timeline Commit Commented Event
     */
    "timeline-commit-commented-event": {
      event?: string;
      node_id?: string;
      commit_id?: string;
      comments?: components["schemas"]["commit-comment"][];
    };
    /**
     * Timeline Assigned Issue Event
     * @description Timeline Assigned Issue Event
     */
    "timeline-assigned-issue-event": {
      id: number;
      node_id: string;
      url: string;
      actor: components["schemas"]["simple-user"];
      event: string;
      commit_id: string | null;
      commit_url: string | null;
      created_at: string;
      performed_via_github_app: components["schemas"]["nullable-integration"];
      assignee: components["schemas"]["simple-user"];
    };
    /**
     * Timeline Unassigned Issue Event
     * @description Timeline Unassigned Issue Event
     */
    "timeline-unassigned-issue-event": {
      id: number;
      node_id: string;
      url: string;
      actor: components["schemas"]["simple-user"];
      event: string;
      commit_id: string | null;
      commit_url: string | null;
      created_at: string;
      performed_via_github_app: components["schemas"]["nullable-integration"];
      assignee: components["schemas"]["simple-user"];
    };
    /**
     * State Change Issue Event
     * @description State Change Issue Event
     */
    "state-change-issue-event": {
      id: number;
      node_id: string;
      url: string;
      actor: components["schemas"]["simple-user"];
      event: string;
      commit_id: string | null;
      commit_url: string | null;
      created_at: string;
      performed_via_github_app: components["schemas"]["nullable-integration"];
      state_reason?: string | null;
    };
    /**
     * Timeline Event
     * @description Timeline Event
     */
    "timeline-issue-events":
      | components["schemas"]["labeled-issue-event"]
      | components["schemas"]["unlabeled-issue-event"]
      | components["schemas"]["milestoned-issue-event"]
      | components["schemas"]["demilestoned-issue-event"]
      | components["schemas"]["renamed-issue-event"]
      | components["schemas"]["review-requested-issue-event"]
      | components["schemas"]["review-request-removed-issue-event"]
      | components["schemas"]["review-dismissed-issue-event"]
      | components["schemas"]["locked-issue-event"]
      | components["schemas"]["added-to-project-issue-event"]
      | components["schemas"]["moved-column-in-project-issue-event"]
      | components["schemas"]["removed-from-project-issue-event"]
      | components["schemas"]["converted-note-to-issue-issue-event"]
      | components["schemas"]["timeline-comment-event"]
      | components["schemas"]["timeline-cross-referenced-event"]
      | components["schemas"]["timeline-committed-event"]
      | components["schemas"]["timeline-reviewed-event"]
      | components["schemas"]["timeline-line-commented-event"]
      | components["schemas"]["timeline-commit-commented-event"]
      | components["schemas"]["timeline-assigned-issue-event"]
      | components["schemas"]["timeline-unassigned-issue-event"]
      | components["schemas"]["state-change-issue-event"];
    /**
     * Deploy Key
     * @description An SSH key granting access to a single repository.
     */
    "deploy-key": {
      id: number;
      key: string;
      url: string;
      title: string;
      verified: boolean;
      created_at: string;
      read_only: boolean;
      added_by?: string | null;
      last_used?: string | null;
    };
    /**
     * Language
     * @description Language
     */
    language: {
      [key: string]: number;
    };
    /**
     * License Content
     * @description License Content
     */
    "license-content": {
      name: string;
      path: string;
      sha: string;
      size: number;
      /** Format: uri */
      url: string;
      /** Format: uri */
      html_url: string | null;
      /** Format: uri */
      git_url: string | null;
      /** Format: uri */
      download_url: string | null;
      type: string;
      content: string;
      encoding: string;
      _links: {
        /** Format: uri */
        git: string | null;
        /** Format: uri */
        html: string | null;
        /** Format: uri */
        self: string;
      };
      license: components["schemas"]["nullable-license-simple"];
    };
    /**
     * Merged upstream
     * @description Results of a successful merge upstream request
     */
    "merged-upstream": {
      message?: string;
      /** @enum {string} */
      merge_type?: "merge" | "fast-forward" | "none";
      base_branch?: string;
    };
    /**
     * Milestone
     * @description A collection of related issues and pull requests.
     */
    milestone: {
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/Hello-World/milestones/1
       */
      url: string;
      /**
       * Format: uri
       * @example https://github.com/octocat/Hello-World/milestones/v1.0
       */
      html_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/Hello-World/milestones/1/labels
       */
      labels_url: string;
      /** @example 1002604 */
      id: number;
      /** @example MDk6TWlsZXN0b25lMTAwMjYwNA== */
      node_id: string;
      /**
       * @description The number of the milestone.
       * @example 42
       */
      number: number;
      /**
       * @description The state of the milestone.
       * @default open
       * @example open
       * @enum {string}
       */
      state: "open" | "closed";
      /**
       * @description The title of the milestone.
       * @example v1.0
       */
      title: string;
      /** @example Tracking milestone for version 1.0 */
      description: string | null;
      creator: components["schemas"]["nullable-simple-user"];
      /** @example 4 */
      open_issues: number;
      /** @example 8 */
      closed_issues: number;
      /**
       * Format: date-time
       * @example 2011-04-10T20:09:31Z
       */
      created_at: string;
      /**
       * Format: date-time
       * @example 2014-03-03T18:58:10Z
       */
      updated_at: string;
      /**
       * Format: date-time
       * @example 2013-02-12T13:22:01Z
       */
      closed_at: string | null;
      /**
       * Format: date-time
       * @example 2012-10-09T23:39:01Z
       */
      due_on: string | null;
    };
    /** Pages Source Hash */
    "pages-source-hash": {
      branch: string;
      path: string;
    };
    /** Pages Https Certificate */
    "pages-https-certificate": {
      /**
       * @example approved
       * @enum {string}
       */
      state:
        | "new"
        | "authorization_created"
        | "authorization_pending"
        | "authorized"
        | "authorization_revoked"
        | "issued"
        | "uploaded"
        | "approved"
        | "errored"
        | "bad_authz"
        | "destroy_pending"
        | "dns_changed";
      /** @example Certificate is approved */
      description: string;
      /**
       * @description Array of the domain set and its alternate name (if it is configured)
       * @example [
       *   "example.com",
       *   "www.example.com"
       * ]
       */
      domains: string[];
      /** Format: date */
      expires_at?: string;
    };
    /**
     * GitHub Pages
     * @description The configuration for GitHub Pages for a repository.
     */
    page: {
      /**
       * Format: uri
       * @description The API address for accessing this Page resource.
       * @example https://api.github.com/repos/github/hello-world/pages
       */
      url: string;
      /**
       * @description The status of the most recent build of the Page.
       * @example built
       * @enum {string|null}
       */
      status: "built" | "building" | "errored" | null;
      /**
       * @description The Pages site's custom domain
       * @example example.com
       */
      cname: string | null;
      /**
       * @description The state if the domain is verified
       * @example pending
       * @enum {string|null}
       */
      protected_domain_state?: "pending" | "verified" | "unverified" | null;
      /**
       * Format: date-time
       * @description The timestamp when a pending domain becomes unverified.
       */
      pending_domain_unverified_at?: string | null;
      /**
       * @description Whether the Page has a custom 404 page.
       * @default false
       * @example false
       */
      custom_404: boolean;
      /**
       * Format: uri
       * @description The web address the Page can be accessed from.
       * @example https://example.com
       */
      html_url?: string;
      /**
       * @description The process in which the Page will be built.
       * @example legacy
       * @enum {string|null}
       */
      build_type?: "legacy" | "workflow" | null;
      source?: components["schemas"]["pages-source-hash"];
      /**
       * @description Whether the GitHub Pages site is publicly visible. If set to `true`, the site is accessible to anyone on the internet. If set to `false`, the site will only be accessible to users who have at least `read` access to the repository that published the site.
       * @example true
       */
      public: boolean;
      https_certificate?: components["schemas"]["pages-https-certificate"];
      /**
       * @description Whether https is enabled on the domain
       * @example true
       */
      https_enforced?: boolean;
    };
    /**
     * Page Build
     * @description Page Build
     */
    "page-build": {
      /** Format: uri */
      url: string;
      status: string;
      error: {
        message: string | null;
      };
      pusher: components["schemas"]["nullable-simple-user"];
      commit: string;
      duration: number;
      /** Format: date-time */
      created_at: string;
      /** Format: date-time */
      updated_at: string;
    };
    /**
     * Page Build Status
     * @description Page Build Status
     */
    "page-build-status": {
      /**
       * Format: uri
       * @example https://api.github.com/repos/github/hello-world/pages/builds/latest
       */
      url: string;
      /** @example queued */
      status: string;
    };
    /**
     * GitHub Pages
     * @description The GitHub Pages deployment status.
     */
    "page-deployment": {
      /**
       * Format: uri
       * @description The URI to monitor GitHub Pages deployment status.
       * @example https://api.github.com/repos/github/hello-world/pages/deployment/status/4fd754f7e594640989b406850d0bc8f06a121251
       */
      status_url: string;
      /**
       * Format: uri
       * @description The URI to the deployed GitHub Pages.
       * @example hello-world.github.io
       */
      page_url: string;
      /**
       * Format: uri
       * @description The URI to the deployed GitHub Pages preview.
       * @example monalisa-1231a2312sa32-23sda74.drafts.github.io
       */
      preview_url?: string;
    };
    "repository-pre-receive-hook": {
      id?: number;
      name?: string;
      enforcement?: string;
      configuration_url?: string;
    };
    /**
     * Pull Request
     * @description Pull requests let you tell others about changes you've pushed to a repository on GitHub. Once a pull request is sent, interested parties can review the set of changes, discuss potential modifications, and even push follow-up commits if necessary.
     */
    "pull-request": {
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/Hello-World/pulls/1347
       */
      url: string;
      /** @example 1 */
      id: number;
      /** @example MDExOlB1bGxSZXF1ZXN0MQ== */
      node_id: string;
      /**
       * Format: uri
       * @example https://github.com/octocat/Hello-World/pull/1347
       */
      html_url: string;
      /**
       * Format: uri
       * @example https://github.com/octocat/Hello-World/pull/1347.diff
       */
      diff_url: string;
      /**
       * Format: uri
       * @example https://github.com/octocat/Hello-World/pull/1347.patch
       */
      patch_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/Hello-World/issues/1347
       */
      issue_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/Hello-World/pulls/1347/commits
       */
      commits_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/Hello-World/pulls/1347/comments
       */
      review_comments_url: string;
      /** @example https://api.github.com/repos/octocat/Hello-World/pulls/comments{/number} */
      review_comment_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/Hello-World/issues/1347/comments
       */
      comments_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/Hello-World/statuses/6dcb09b5b57875f334f61aebed695e2e4193db5e
       */
      statuses_url: string;
      /**
       * @description Number uniquely identifying the pull request within its repository.
       * @example 42
       */
      number: number;
      /**
       * @description State of this Pull Request. Either `open` or `closed`.
       * @example open
       * @enum {string}
       */
      state: "open" | "closed";
      /** @example true */
      locked: boolean;
      /**
       * @description The title of the pull request.
       * @example Amazing new feature
       */
      title: string;
      user: components["schemas"]["simple-user"];
      /** @example Please pull these awesome changes */
      body: string | null;
      labels: {
        /** Format: int64 */
        id: number;
        node_id: string;
        url: string;
        name: string;
        description: string | null;
        color: string;
        default: boolean;
      }[];
      milestone: components["schemas"]["nullable-milestone"];
      /** @example too heated */
      active_lock_reason?: string | null;
      /**
       * Format: date-time
       * @example 2011-01-26T19:01:12Z
       */
      created_at: string;
      /**
       * Format: date-time
       * @example 2011-01-26T19:01:12Z
       */
      updated_at: string;
      /**
       * Format: date-time
       * @example 2011-01-26T19:01:12Z
       */
      closed_at: string | null;
      /**
       * Format: date-time
       * @example 2011-01-26T19:01:12Z
       */
      merged_at: string | null;
      /** @example e5bd3914e2e596debea16f433f57875b5b90bcd6 */
      merge_commit_sha: string | null;
      assignee: components["schemas"]["nullable-simple-user"];
      assignees?: components["schemas"]["simple-user"][] | null;
      requested_reviewers?: components["schemas"]["simple-user"][] | null;
      requested_teams?: components["schemas"]["team-simple"][] | null;
      head: {
        label: string;
        ref: string;
        repo: {
          archive_url: string;
          assignees_url: string;
          blobs_url: string;
          branches_url: string;
          collaborators_url: string;
          comments_url: string;
          commits_url: string;
          compare_url: string;
          contents_url: string;
          /** Format: uri */
          contributors_url: string;
          /** Format: uri */
          deployments_url: string;
          description: string | null;
          /** Format: uri */
          downloads_url: string;
          /** Format: uri */
          events_url: string;
          fork: boolean;
          /** Format: uri */
          forks_url: string;
          full_name: string;
          git_commits_url: string;
          git_refs_url: string;
          git_tags_url: string;
          /** Format: uri */
          hooks_url: string;
          /** Format: uri */
          html_url: string;
          id: number;
          node_id: string;
          issue_comment_url: string;
          issue_events_url: string;
          issues_url: string;
          keys_url: string;
          labels_url: string;
          /** Format: uri */
          languages_url: string;
          /** Format: uri */
          merges_url: string;
          milestones_url: string;
          name: string;
          notifications_url: string;
          owner: {
            /** Format: uri */
            avatar_url: string;
            events_url: string;
            /** Format: uri */
            followers_url: string;
            following_url: string;
            gists_url: string;
            gravatar_id: string | null;
            /** Format: uri */
            html_url: string;
            id: number;
            node_id: string;
            login: string;
            /** Format: uri */
            organizations_url: string;
            /** Format: uri */
            received_events_url: string;
            /** Format: uri */
            repos_url: string;
            site_admin: boolean;
            starred_url: string;
            /** Format: uri */
            subscriptions_url: string;
            type: string;
            /** Format: uri */
            url: string;
          };
          private: boolean;
          pulls_url: string;
          releases_url: string;
          /** Format: uri */
          stargazers_url: string;
          statuses_url: string;
          /** Format: uri */
          subscribers_url: string;
          /** Format: uri */
          subscription_url: string;
          /** Format: uri */
          tags_url: string;
          /** Format: uri */
          teams_url: string;
          trees_url: string;
          /** Format: uri */
          url: string;
          clone_url: string;
          default_branch: string;
          forks: number;
          forks_count: number;
          git_url: string;
          has_downloads: boolean;
          has_issues: boolean;
          has_projects: boolean;
          has_wiki: boolean;
          has_pages: boolean;
          has_discussions: boolean;
          /** Format: uri */
          homepage: string | null;
          language: string | null;
          master_branch?: string;
          archived: boolean;
          disabled: boolean;
          /** @description The repository visibility: public, private, or internal. */
          visibility?: string;
          /** Format: uri */
          mirror_url: string | null;
          open_issues: number;
          open_issues_count: number;
          permissions?: {
            admin: boolean;
            maintain?: boolean;
            push: boolean;
            triage?: boolean;
            pull: boolean;
          };
          temp_clone_token?: string;
          allow_merge_commit?: boolean;
          allow_squash_merge?: boolean;
          allow_rebase_merge?: boolean;
          license: {
            key: string;
            name: string;
            /** Format: uri */
            url: string | null;
            spdx_id: string | null;
            node_id: string;
          } | null;
          /** Format: date-time */
          pushed_at: string;
          size: number;
          ssh_url: string;
          stargazers_count: number;
          /** Format: uri */
          svn_url: string;
          topics?: string[];
          watchers: number;
          watchers_count: number;
          /** Format: date-time */
          created_at: string;
          /** Format: date-time */
          updated_at: string;
          allow_forking?: boolean;
          is_template?: boolean;
          web_commit_signoff_required?: boolean;
        } | null;
        sha: string;
        user: {
          /** Format: uri */
          avatar_url: string;
          events_url: string;
          /** Format: uri */
          followers_url: string;
          following_url: string;
          gists_url: string;
          gravatar_id: string | null;
          /** Format: uri */
          html_url: string;
          id: number;
          node_id: string;
          login: string;
          /** Format: uri */
          organizations_url: string;
          /** Format: uri */
          received_events_url: string;
          /** Format: uri */
          repos_url: string;
          site_admin: boolean;
          starred_url: string;
          /** Format: uri */
          subscriptions_url: string;
          type: string;
          /** Format: uri */
          url: string;
        };
      };
      base: {
        label: string;
        ref: string;
        repo: {
          archive_url: string;
          assignees_url: string;
          blobs_url: string;
          branches_url: string;
          collaborators_url: string;
          comments_url: string;
          commits_url: string;
          compare_url: string;
          contents_url: string;
          /** Format: uri */
          contributors_url: string;
          /** Format: uri */
          deployments_url: string;
          description: string | null;
          /** Format: uri */
          downloads_url: string;
          /** Format: uri */
          events_url: string;
          fork: boolean;
          /** Format: uri */
          forks_url: string;
          full_name: string;
          git_commits_url: string;
          git_refs_url: string;
          git_tags_url: string;
          /** Format: uri */
          hooks_url: string;
          /** Format: uri */
          html_url: string;
          id: number;
          is_template?: boolean;
          node_id: string;
          issue_comment_url: string;
          issue_events_url: string;
          issues_url: string;
          keys_url: string;
          labels_url: string;
          /** Format: uri */
          languages_url: string;
          /** Format: uri */
          merges_url: string;
          milestones_url: string;
          name: string;
          notifications_url: string;
          owner: {
            /** Format: uri */
            avatar_url: string;
            events_url: string;
            /** Format: uri */
            followers_url: string;
            following_url: string;
            gists_url: string;
            gravatar_id: string | null;
            /** Format: uri */
            html_url: string;
            id: number;
            node_id: string;
            login: string;
            /** Format: uri */
            organizations_url: string;
            /** Format: uri */
            received_events_url: string;
            /** Format: uri */
            repos_url: string;
            site_admin: boolean;
            starred_url: string;
            /** Format: uri */
            subscriptions_url: string;
            type: string;
            /** Format: uri */
            url: string;
          };
          private: boolean;
          pulls_url: string;
          releases_url: string;
          /** Format: uri */
          stargazers_url: string;
          statuses_url: string;
          /** Format: uri */
          subscribers_url: string;
          /** Format: uri */
          subscription_url: string;
          /** Format: uri */
          tags_url: string;
          /** Format: uri */
          teams_url: string;
          trees_url: string;
          /** Format: uri */
          url: string;
          clone_url: string;
          default_branch: string;
          forks: number;
          forks_count: number;
          git_url: string;
          has_downloads: boolean;
          has_issues: boolean;
          has_projects: boolean;
          has_wiki: boolean;
          has_pages: boolean;
          has_discussions: boolean;
          /** Format: uri */
          homepage: string | null;
          language: string | null;
          master_branch?: string;
          archived: boolean;
          disabled: boolean;
          /** @description The repository visibility: public, private, or internal. */
          visibility?: string;
          /** Format: uri */
          mirror_url: string | null;
          open_issues: number;
          open_issues_count: number;
          permissions?: {
            admin: boolean;
            maintain?: boolean;
            push: boolean;
            triage?: boolean;
            pull: boolean;
          };
          temp_clone_token?: string;
          allow_merge_commit?: boolean;
          allow_squash_merge?: boolean;
          allow_rebase_merge?: boolean;
          license: components["schemas"]["nullable-license-simple"];
          /** Format: date-time */
          pushed_at: string;
          size: number;
          ssh_url: string;
          stargazers_count: number;
          /** Format: uri */
          svn_url: string;
          topics?: string[];
          watchers: number;
          watchers_count: number;
          /** Format: date-time */
          created_at: string;
          /** Format: date-time */
          updated_at: string;
          allow_forking?: boolean;
          web_commit_signoff_required?: boolean;
        };
        sha: string;
        user: {
          /** Format: uri */
          avatar_url: string;
          events_url: string;
          /** Format: uri */
          followers_url: string;
          following_url: string;
          gists_url: string;
          gravatar_id: string | null;
          /** Format: uri */
          html_url: string;
          id: number;
          node_id: string;
          login: string;
          /** Format: uri */
          organizations_url: string;
          /** Format: uri */
          received_events_url: string;
          /** Format: uri */
          repos_url: string;
          site_admin: boolean;
          starred_url: string;
          /** Format: uri */
          subscriptions_url: string;
          type: string;
          /** Format: uri */
          url: string;
        };
      };
      _links: {
        comments: components["schemas"]["link"];
        commits: components["schemas"]["link"];
        statuses: components["schemas"]["link"];
        html: components["schemas"]["link"];
        issue: components["schemas"]["link"];
        review_comments: components["schemas"]["link"];
        review_comment: components["schemas"]["link"];
        self: components["schemas"]["link"];
      };
      author_association: components["schemas"]["author-association"];
      auto_merge: components["schemas"]["auto-merge"];
      /**
       * @description Indicates whether or not the pull request is a draft.
       * @example false
       */
      draft?: boolean;
      merged: boolean;
      /** @example true */
      mergeable: boolean | null;
      /** @example true */
      rebaseable?: boolean | null;
      /** @example clean */
      mergeable_state: string;
      merged_by: components["schemas"]["nullable-simple-user"];
      /** @example 10 */
      comments: number;
      /** @example 0 */
      review_comments: number;
      /**
       * @description Indicates whether maintainers can modify the pull request.
       * @example true
       */
      maintainer_can_modify: boolean;
      /** @example 3 */
      commits: number;
      /** @example 100 */
      additions: number;
      /** @example 3 */
      deletions: number;
      /** @example 5 */
      changed_files: number;
    };
    /**
     * Pull Request Merge Result
     * @description Pull Request Merge Result
     */
    "pull-request-merge-result": {
      sha: string;
      merged: boolean;
      message: string;
    };
    /**
     * Pull Request Review Request
     * @description Pull Request Review Request
     */
    "pull-request-review-request": {
      users: components["schemas"]["simple-user"][];
      teams: components["schemas"]["team"][];
    };
    /**
     * Pull Request Review
     * @description Pull Request Reviews are reviews on pull requests.
     */
    "pull-request-review": {
      /**
       * @description Unique identifier of the review
       * @example 42
       */
      id: number;
      /** @example MDE3OlB1bGxSZXF1ZXN0UmV2aWV3ODA= */
      node_id: string;
      user: components["schemas"]["nullable-simple-user"];
      /**
       * @description The text of the review.
       * @example This looks great.
       */
      body: string;
      /** @example CHANGES_REQUESTED */
      state: string;
      /**
       * Format: uri
       * @example https://github.com/octocat/Hello-World/pull/12#pullrequestreview-80
       */
      html_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/Hello-World/pulls/12
       */
      pull_request_url: string;
      _links: {
        html: {
          href: string;
        };
        pull_request: {
          href: string;
        };
      };
      /** Format: date-time */
      submitted_at?: string;
      /**
       * @description A commit SHA for the review. If the commit object was garbage collected or forcibly deleted, then it no longer exists in Git and this value will be `null`.
       * @example 54bb654c9e6025347f57900a4a5c2313a96b8035
       */
      commit_id: string | null;
      body_html?: string;
      body_text?: string;
      author_association: components["schemas"]["author-association"];
    };
    /**
     * Legacy Review Comment
     * @description Legacy Review Comment
     */
    "review-comment": {
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/Hello-World/pulls/comments/1
       */
      url: string;
      /** @example 42 */
      pull_request_review_id: number | null;
      /** @example 10 */
      id: number;
      /** @example MDI0OlB1bGxSZXF1ZXN0UmV2aWV3Q29tbWVudDEw */
      node_id: string;
      /** @example @@ -16,33 +16,40 @@ public class Connection : IConnection... */
      diff_hunk: string;
      /** @example file1.txt */
      path: string;
      /** @example 1 */
      position: number | null;
      /** @example 4 */
      original_position: number;
      /** @example 6dcb09b5b57875f334f61aebed695e2e4193db5e */
      commit_id: string;
      /** @example 9c48853fa3dc5c1c3d6f1f1cd1f2743e72652840 */
      original_commit_id: string;
      /** @example 8 */
      in_reply_to_id?: number;
      user: components["schemas"]["nullable-simple-user"];
      /** @example Great stuff */
      body: string;
      /**
       * Format: date-time
       * @example 2011-04-14T16:00:49Z
       */
      created_at: string;
      /**
       * Format: date-time
       * @example 2011-04-14T16:00:49Z
       */
      updated_at: string;
      /**
       * Format: uri
       * @example https://github.com/octocat/Hello-World/pull/1#discussion-diff-1
       */
      html_url: string;
      /**
       * Format: uri
       * @example https://api.github.com/repos/octocat/Hello-World/pulls/1
       */
      pull_request_url: string;
      author_association: components["schemas"]["author-association"];
      _links: {
        self: components["schemas"]["link"];
        html: components["schemas"]["link"];
        pull_request: components["schemas"]["link"];
      };
      body_text?: string;
      body_html?: string;
      reactions?: components["schemas"]["reaction-rollup"];
      /**
       * @description The side of the first line of the range for a multi-line comment.
       * @default RIGHT
       * @enum {string}
       */
      side?: "LEFT" | "RIGHT";
      /**
       * @description The side of the first line of the range for a multi-line comment.
       * @default RIGHT
       * @enum {string|null}
       */
      start_side?: "LEFT" | "RIGHT" | null;
      /**
       * @description The line of the blob to which the comment applies. The last line of the range for a multi-line comment
       * @example 2
       */
      line?: number;
      /**
       * @description The original line of the blob to which the comment applies. The last line of the range for a multi-line comment
       * @example 2
       */
      original_line?: number;
      /**
       * @description The first line of the range for a multi-line comment.
       * @example 2
       */
      start_line?: number | null;
      /**
       * @description The original first line of the range for a multi-line comment.
       * @example 2
       */
      original_start_line?: number | null;
    };
    /**
     * Release Asset
     * @description Data related to a release.
     */
    "release-asset": {
      /** Format: uri */
      url: string;
      /** Format: uri */
      browser_download_url: string;
      id: number;
      node_id: string;
      /**
