cask 'textmate' do
  version '2.0-beta.8.5'
  sha256 '18ef15feea960cff6034c9cbe5e3cb38cbf0fcd0d57e4b8c78656a392dd5dc07'

  # textmate.org is the official download host per the vendor homepage
  url "https://api.textmate.org/downloads/TextMate_#{version}.tbz"
  name 'TextMate'
  homepage 'https://macromates.com/'
  license :gpl

  app 'TextMate.app'
  binary 'TextMate.app/Contents/Resources/mate'

  zap :delete => [
                   '~/Library/Application Support/Avian',
                   '~/Library/Application Support/TextMate',
                   '~/Library/Preferences/com.macromates.TextMate.preview.LSSharedFileList.plist',
                   '~/Library/Preferences/com.macromates.TextMate.preview.plist',
                   '~/Library/Preferences/com.macromates.textmate.webpreview.plist',
                   '~/Library/Preferences/com.macromates.textmate.plist',
                   '~/Library/Preferences/com.macromates.textmate.latex_config.plist',
                 ]
end
