cask 'python3' do
  # note: "3" is a trailing version number on the Cask token, which
  # breaks our own token conventions, for consistency with Homebrew
  version '3.5.1'
  sha256 '1f3c070b9005e894eddc23120ddf1d2c5f82977ebb43e1a89ca4a2fbfac8caf4'

  url "https://www.python.org/ftp/python/#{version}/python-#{version}-macosx10.6.pkg"
  name 'Python'
  homepage 'https://www.python.org/'
  license :oss

  pkg "python-#{version}-macosx10.6.pkg"

  uninstall :pkgutil => [
                          "org.python.Python.PythonApplications-#{version.slice(%r{\d+\.\d+})}",
                          "org.python.Python.PythonDocumentation-#{version.slice(%r{\d+\.\d+})}",
                          "org.python.Python.PythonFramework-#{version.slice(%r{\d+\.\d+})}",
                          "org.python.Python.PythonUnixTools-#{version.slice(%r{\d+\.\d+})}",
                        ],
            :delete  => [
                          "/Library/Receipts/PythonInstallPip-#{version.slice(%r{\d+\.\d+})}",
                          "/Applications/Python #{version.slice(%r{\d+\.\d+})}",
                          "/Library/Frameworks/Python.Framework/Versions/#{version.slice(%r{\d+\.\d+})}",
                          "/Library/Python/#{version.slice(%r{\d+\.\d+})}",
                        ]

  zap :delete => "~/Library/Python/#{version.slice(%r{\d+\.\d+})}"
end
