cask 'malwarebytes-anti-malware' do
  version '1.1.3.72'
  sha256 '9ef3c6e40b7995e6b9d1b4724881e21f8b4028c5199f346215cb8afb148a925e'

  # mbamupdates.com is the official download host per the vendor homepage
  url "https://data-cdn.mbamupdates.com/v1/mbam-mac/data/mbam-mac-#{version}.zip"
  appcast 'https://data-cdn.mbamupdates.com/v1/mbam-mac/updates.xml',
          :sha256 => 'e04f59fe2b226c7463216e55e02463a6b9290f4dd506106f10a9c44d8135c38a'
  name 'Malwarebytes Anti-Malware for Mac'
  name 'AdwareMedic'
  homepage 'https://www.malwarebytes.org/antimalware/mac/'
  license :gratis

  depends_on :macos => '>= :lion'

  app 'Malwarebytes Anti-Malware.app'

  zap :delete => [
                   '~/Library/Preferences/com.malwarebytes.antimalware.plist',
                   '~/Library/Caches/com.malwarebytes.antimalware',
                   '~/Library/Application Support/com.malwarebytes.antimalware',
                   '~/Library/Saved Application State/com.malwarebytes.antimalware.savedState',
                 ]
end
