cask 'dnscrypt' do
  version '1.0.10'
  sha256 'd092d9151035a0853902261e883d5ba7c50cb93beea9834db41303b2ec4276e0'

  url "https://github.com/alterstep/dnscrypt-osxclient/releases/download/#{version}/dnscrypt-osxclient-#{version}.dmg"
  appcast 'https://github.com/alterstep/dnscrypt-osxclient/releases.atom',
          :sha256 => 'c90ef83cd8f91e7a9f7cda90a4ad2ed9ceab0807afe6deeeb39a8a2a75d56360'
  name 'DNSCrypt'
  homepage 'https://github.com/alterstep/dnscrypt-osxclient'
  license :oss

  pkg 'DNSCrypt.pkg'

  uninstall :quit      => 'com.github.dnscrypt-osxclient.DNSCrypt-Menubar',
            :pkgutil   => 'com.github.dnscrypt-osxclient.dnscryptClient.*',
            :launchctl => [
                            'com.github.dnscrypt-osxclient.DNSCryptAfterboot',
                            'com.github.dnscrypt-osxclient.DNSCryptConsoleChange',
                            'com.github.dnscrypt-osxclient.DNSCryptControlChange',
                            'com.github.dnscrypt-osxclient.DNSCryptNetworkChange',
                          ]
end
