cask 'amazon-music' do
  version '20151215_033955b5fb'
  sha256 'c430be9914fe81c4c1162290e8665632b98962d8c7837a60b67afe671f4d53f8'

  url "https://images-na.ssl-images-amazon.com/images/G/01/digital/music/morpho/installers/#{version.sub(%r{_.*}, '')}/#{version.sub(%r{.*_}, '')}/AmazonMusicInstaller.dmg"
  name 'Amazon Music'
  homepage 'http://www.amazon.com/gp/feature.html/?ie=UTF8&docId=1001067901'
  license :gratis

  installer :script => 'Amazon Music Installer.app/Contents/MacOS/osx-intel',
            :args   => ['--unattendedmodeui', 'none'],
            :sudo   => true

  uninstall :quit      => [
                            'com.amazon.music',
                            'com.amazon.music-renderer',
                          ],
            :delete    => [
                            '/Applications/Amazon Music.app'
                          ],
            :launchctl => 'com.amazon.music'

  zap :delete => [
                   '~/Library/Preferences/com.amazon.music.plist',
                   '~/Library/Application Support/Amazon Music/',
                 ]

  caveats <<-EOS.undent
    If the app won't launch after installation, try

      brew cask zap #{token}
      brew cask install #{token}

    then re-launch the app. You can read more about the issue on Amazon's customer forums
    http://www.amazon.com/App-wont-open-OS-Yosemite/forum/FxZLHSK3AW6KZU/Tx1EJYW65OQ5TZS
  EOS
end
