% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_client.R
\docType{class}
\name{run_client}
\alias{run_client}
\title{run_client}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} with fields/methods for introspection.
}
\description{
A R6 class representing a past run for an existing flow.
Instances of this class contain all steps related to a run.
}
\section{Usage}{

\preformatted{
r <- run_client$new(flow, run_id)
r <- run_client$new("HelloFlow/12")

r$id
r$tags
r$finished_at
r$steps
r$artifacts
r$step("end")
r$artifact("script_name")
r$summary()
}
}

\section{Super class}{
\code{\link[metaflow:metaflow_object]{metaflow::metaflow_object}} -> \code{RunClient}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{super_}}{Get the metaflow object base class}

\item{\code{id}}{The identifier of this run object.}

\item{\code{created_at}}{The time of creation of this run object.}

\item{\code{pathspec}}{The path spec that uniquely identifies this run object.}

\item{\code{parent}}{The parent object (flow object) identifier of the current run object.}

\item{\code{tags}}{A vector of strings representing tags assigned to this run object.}

\item{\code{code}}{Get the code package of the run if it exists}

\item{\code{end_task}}{The task identifier, if available, corresponding to the end step of this run.}

\item{\code{finished}}{The boolean flag identifying if the run has finished.}

\item{\code{finished_at}}{The finish time, if available, of this run.}

\item{\code{successful}}{The boolean flag identifying if the end task was successful.}

\item{\code{steps}}{The vector of all step identifiers of this run.}

\item{\code{artifacts}}{The vector of all data artifact identifiers produced by the end step of this run.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{run_client$new()}}
\item \href{#method-step}{\code{run_client$step()}}
\item \href{#method-artifact}{\code{run_client$artifact()}}
\item \href{#method-summary}{\code{run_client$summary()}}
\item \href{#method-clone}{\code{run_client$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="metaflow" data-topic="metaflow_object" data-id="get_obj">}\href{../../metaflow/html/metaflow_object.html#method-get_obj}{\code{metaflow::metaflow_object$get_obj()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="metaflow" data-topic="metaflow_object" data-id="get_values">}\href{../../metaflow/html/metaflow_object.html#method-get_values}{\code{metaflow::metaflow_object$get_values()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="metaflow" data-topic="metaflow_object" data-id="is_in_namespace">}\href{../../metaflow/html/metaflow_object.html#method-is_in_namespace}{\code{metaflow::metaflow_object$is_in_namespace()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Initialize the object from a \code{FlowClient} object and \code{run_id}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{run_client$new(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{The argument list can be either (1) a single \code{pathspec} string such as "HelloFlow/123"
or (2) \code{(flow, run_id)}, where
a \code{flow} is a parent \code{FlowClient} object which contains the run, and \code{run_id} is the identifier of the run.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{RunClient} R6 object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-step"></a>}}
\if{latex}{\out{\hypertarget{method-step}{}}}
\subsection{Method \code{step()}}{
Create a \code{StepClient} object under this \code{run}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{run_client$step(step_id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{step_id}}{identifier of the step, for example "start" or "end"}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
StepClient R6 object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-artifact"></a>}}
\if{latex}{\out{\hypertarget{method-artifact}{}}}
\subsection{Method \code{artifact()}}{
Fetch the data artifacts for the end step of this \code{run}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{run_client$artifact(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{names of artifacts}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
metaflow artifact
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-summary"></a>}}
\if{latex}{\out{\hypertarget{method-summary}{}}}
\subsection{Method \code{summary()}}{
Summary of the \code{run}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{run_client$summary()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{run_client$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
