% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metaflow_client.R
\docType{class}
\name{metaflow_object}
\alias{metaflow_object}
\title{Metaflow object base class}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} with fields/methods for introspection.
}
\description{
A Reference Class to represent a metaflow object.
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{id}}{The identifier of this object.}

\item{\code{created_at}}{The time of creation of this object.}

\item{\code{parent}}{The parent object identifier of this current object.}

\item{\code{pathspec}}{The path spec that uniquely identifies this object.}

\item{\code{tags}}{The vector of tags assigned to this object.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{metaflow_object$new()}}
\item \href{#method-is_in_namespace}{\code{metaflow_object$is_in_namespace()}}
\item \href{#method-get_obj}{\code{metaflow_object$get_obj()}}
\item \href{#method-get_values}{\code{metaflow_object$get_values()}}
\item \href{#method-clone}{\code{metaflow_object$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Initialize a metaflow object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{metaflow_object$new(obj = NA)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{obj}}{the python metaflow object}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-is_in_namespace"></a>}}
\if{latex}{\out{\hypertarget{method-is_in_namespace}{}}}
\subsection{Method \code{is_in_namespace()}}{
Check if this metaflow object is in current namespace
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{metaflow_object$is_in_namespace()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
TRUE/FALSE
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_obj"></a>}}
\if{latex}{\out{\hypertarget{method-get_obj}{}}}
\subsection{Method \code{get_obj()}}{
Get the python metaflow object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{metaflow_object$get_obj()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
python (reticulate) metaflow object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_values"></a>}}
\if{latex}{\out{\hypertarget{method-get_values}{}}}
\subsection{Method \code{get_values()}}{
Get values of current metaflow object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{metaflow_object$get_values()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
a list of lower level metaflow objects
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{metaflow_object$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
