% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/task_client.R
\docType{class}
\name{task_client}
\alias{task_client}
\title{task_client}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} with fields/methods for introspection.
}
\description{
An R6 Class representing a task for a step.
Instances of this class contain all data artifacts related to a task.
}
\section{Usage}{

\preformatted{
t <- task_client$new(step, task_id)
t <- task_client$new("HelloFlow/12/start/139423")

t$id
t$tags
t$finished_at
t$artifacts
t$artifact(t$artifacts)
t$summary()
}
}

\section{Super class}{
\code{\link[metaflow:metaflow_object]{metaflow::metaflow_object}} -> \code{TaskClient}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{super_}}{Get the metaflow object base class}

\item{\code{id}}{The identifier of this task object.}

\item{\code{pathspec}}{The path spec that uniquely identifies this task object,}

\item{\code{parent}}{The parent object (step object) identifier of this task object.}

\item{\code{tags}}{A vector of strings representing tags assigned to this task object.}

\item{\code{exception}}{The exception that caused this task to fail.}

\item{\code{created_at}}{The time of creation of this task.}

\item{\code{finished}}{The boolean flag identifying if the task has finished.}

\item{\code{finished_at}}{The finish time, if available, of this task.}

\item{\code{code}}{Get the code package of the run if it exists}

\item{\code{index}}{The index of the innermost foreach loop,}

\item{\code{metadata_dict}}{The dictionary of}

\item{\code{runtime_name}}{The name of the runtime environment}

\item{\code{stderr}}{The full stderr output of this task.}

\item{\code{stdout}}{The full stdout output of this task.}

\item{\code{successful}}{The boolean flag identifying if}

\item{\code{artifacts}}{The vector of artifact ids produced by this task.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{task_client$new()}}
\item \href{#method-artifact}{\code{task_client$artifact()}}
\item \href{#method-summary}{\code{task_client$summary()}}
\item \href{#method-clone}{\code{task_client$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="metaflow" data-topic="metaflow_object" data-id="get_obj">}\href{../../metaflow/html/metaflow_object.html#method-get_obj}{\code{metaflow::metaflow_object$get_obj()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="metaflow" data-topic="metaflow_object" data-id="get_values">}\href{../../metaflow/html/metaflow_object.html#method-get_values}{\code{metaflow::metaflow_object$get_values()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="metaflow" data-topic="metaflow_object" data-id="is_in_namespace">}\href{../../metaflow/html/metaflow_object.html#method-is_in_namespace}{\code{metaflow::metaflow_object$is_in_namespace()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Initialize a \code{TaskClient} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{task_client$new(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{The argument list can be either (1) a single \code{pathspec} string such as "HelloFlow/123/start/293812"
or (2) \code{(step, task_id)}, where
a \code{step} is a parent \code{StepClient} object which contains the run, and \code{task_id} is the identifier of the task.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a \code{TaskClient} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-artifact"></a>}}
\if{latex}{\out{\hypertarget{method-artifact}{}}}
\subsection{Method \code{artifact()}}{
Fetch the data artifacts for this task
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{task_client$artifact(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{names of artifacts}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
metaflow artifact
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-summary"></a>}}
\if{latex}{\out{\hypertarget{method-summary}{}}}
\subsection{Method \code{summary()}}{
Summary of the task
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{task_client$summary()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{task_client$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
