% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step_client.R
\docType{class}
\name{step_client}
\alias{step_client}
\title{step_client}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} with fields/methods for introspection.
}
\description{
An R6 Class representing a step for a past run.
Instances of this class contain all tasks related to a step.
}
\section{Usage}{

\preformatted{
s <- step_client$new(run, step_id)
s <- step_client$new("HelloWorldFlow/123/start")

s$id
s$tags
s$finished_at
s$tasks
s$task("12")
s$summary()
}
}

\section{Super class}{
\code{\link[metaflow:metaflow_object]{metaflow::metaflow_object}} -> \code{StepClient}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{super_}}{Access the R6 metaflow object base class}

\item{\code{id}}{The identifier of this step object.}

\item{\code{created_at}}{The time of creation of this step object.}

\item{\code{pathspec}}{The path spec that uniquely identifies this step object,}

\item{\code{parent}}{The parent object (run object) identifier of this step object.}

\item{\code{tags}}{A vector of strings representing tags assigned to this step object.}

\item{\code{finished_at}}{The finish time, if available, of this step.}

\item{\code{a_task}}{Any task id of the current step}

\item{\code{tasks}}{All task ids of the current step}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{step_client$new()}}
\item \href{#method-task}{\code{step_client$task()}}
\item \href{#method-summary}{\code{step_client$summary()}}
\item \href{#method-clone}{\code{step_client$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="metaflow" data-topic="metaflow_object" data-id="get_obj">}\href{../../metaflow/html/metaflow_object.html#method-get_obj}{\code{metaflow::metaflow_object$get_obj()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="metaflow" data-topic="metaflow_object" data-id="get_values">}\href{../../metaflow/html/metaflow_object.html#method-get_values}{\code{metaflow::metaflow_object$get_values()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="metaflow" data-topic="metaflow_object" data-id="is_in_namespace">}\href{../../metaflow/html/metaflow_object.html#method-is_in_namespace}{\code{metaflow::metaflow_object$is_in_namespace()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Initialize a \code{StepClient} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{step_client$new(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{The argument list can be either (1) a single \code{pathspec} string such as "MyFlow/123/start" or (2) \code{(run, step_id)}, where
\code{run} is a parent \code{RunClient} object which contains the step, and \code{step_id} is the name/id of the step such as "start".}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a \code{StepClient} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-task"></a>}}
\if{latex}{\out{\hypertarget{method-task}{}}}
\subsection{Method \code{task()}}{
create a \code{TaskClient} object of the current step
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{step_client$task(task_id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{task_id}}{the identifier of the task}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a \code{TaskClient} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-summary"></a>}}
\if{latex}{\out{\hypertarget{method-summary}{}}}
\subsection{Method \code{summary()}}{
summary of the current step
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{step_client$summary()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{step_client$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
