% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install.R
\name{install_metaflow}
\alias{install_metaflow}
\title{Install Metaflow Python package}
\usage{
install_metaflow(
  method = c("conda", "virtualenv"),
  prompt = TRUE,
  version = NULL,
  ...
)
}
\arguments{
\item{method}{`character`, indicates to use `"conda"` or `"virtualenv"`.}

\item{prompt}{boolean, whether or not to prompt user for confirmation before installation. Default is TRUE.}

\item{version}{`character`, version of Metaflow to install. The default version
is the latest available on PyPi.}

\item{...}{other arguments sent to [reticulate::conda_install()] or
[reticulate::virtualenv_install()]}
}
\description{
This function wraps installation functions from [reticulate][reticulate::reticulate] to install the Python packages
**metaflow** and it's Python dependencies.
}
\details{
This package uses the [reticulate][reticulate::reticulate] package
to make an interface with the [Metaflow](https://metaflow.org/)
Python package.
}
\examples{
\dontrun{
# not run because it requires Python
install_metaflow()
}
}
\seealso{
[reticulate: Using reticulate in an R Package](https://rstudio.github.io/reticulate/articles/package.html),
[reticulate: Installing Python Packages](https://rstudio.github.io/reticulate/articles/python_packages.html)
}
