% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flow_client.R
\docType{class}
\name{flow_client}
\alias{flow_client}
\title{flow_client}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} with fields/methods for introspection.
}
\description{
An R6 Class representing an existing flow with a certain id.
Instances of this class contain all runs related to a flow.
}
\section{Usage}{

\preformatted{
f <- flow_client$new(flow_id)

f$id
f$tags
f$latest_run
f$latest_successful_run
f$runs
f$run(f$latest_run)
f$summary()
}
}

\section{Super class}{
\code{\link[metaflow:metaflow_object]{metaflow::metaflow_object}} -> \code{FlowClient}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{super_}}{Access the R6 metaflow object base class}

\item{\code{pathspec}}{The path spec that uniquely identifies this flow object}

\item{\code{parent}}{The parent object identifier of this current flow object.}

\item{\code{tags}}{The vector of tags assigned to this object.}

\item{\code{created_at}}{The time of creation of this flow object.}

\item{\code{finished_at}}{The finish time, if available, of this flow.}

\item{\code{latest_run}}{The latest run identifier of this flow.}

\item{\code{latest_successful_run}}{The latest successful run identifier of this flow.}

\item{\code{runs}}{The vector of all run identifiers of this flow.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{flow_client$new()}}
\item \href{#method-run}{\code{flow_client$run()}}
\item \href{#method-runs_with_tags}{\code{flow_client$runs_with_tags()}}
\item \href{#method-summary}{\code{flow_client$summary()}}
\item \href{#method-clone}{\code{flow_client$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="metaflow" data-topic="metaflow_object" data-id="get_obj">}\href{../../metaflow/html/metaflow_object.html#method-get_obj}{\code{metaflow::metaflow_object$get_obj()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="metaflow" data-topic="metaflow_object" data-id="get_values">}\href{../../metaflow/html/metaflow_object.html#method-get_values}{\code{metaflow::metaflow_object$get_values()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="metaflow" data-topic="metaflow_object" data-id="is_in_namespace">}\href{../../metaflow/html/metaflow_object.html#method-is_in_namespace}{\code{metaflow::metaflow_object$is_in_namespace()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Initialize the object from flow_id
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{flow_client$new(flow_id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{flow_id, }}{name/id of the flow such as "HelloWorldFlow"}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
FlowClient R6 object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-run"></a>}}
\if{latex}{\out{\hypertarget{method-run}{}}}
\subsection{Method \code{run()}}{
Get a RunClient R6 object of any run in this flow based on run_id
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{flow_client$run(run_id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{run_id, }}{id of the specific run within this flow}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
RunClient R6 object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-runs_with_tags"></a>}}
\if{latex}{\out{\hypertarget{method-runs_with_tags}{}}}
\subsection{Method \code{runs_with_tags()}}{
Get a list of run_ids which has the specific tag
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{flow_client$runs_with_tags(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{the specific tags (string) we need to have for the runs}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list of run_client R6 object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-summary"></a>}}
\if{latex}{\out{\hypertarget{method-summary}{}}}
\subsection{Method \code{summary()}}{
Summary of this flow
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{flow_client$summary()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{flow_client$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
