# Reconfiguration testing Results

<!-- TOC -->
- [Reconfiguration testing Results](#reconfiguration-testing-results)
  - [Test environment](#test-environment)
  - [Results Tables](#results-tables)
    - [NGINX Reloads and Time to Ready](#nginx-reloads-and-time-to-ready)
    - [Event Batch Processing](#event-batch-processing)
  - [NumResources -> Total Resources](#numresources---total-resources)
  - [Observations](#observations)
<!-- TOC -->

## Test environment

GKE cluster:

- Node count: 3
- Instance Type: e2-medium
- k8s version: 1.27.3-gke.100
- Zone: us-central1-c
- Total vCPUs: 6
- Total RAM: 12GB
- Max pods per node: 110

NGF deployment:

- NGF version: edge - git commit 29b45e38bacd7c4f22834938105e3cda4f29f6d1
- NGINX Version: 1.25.2

## Results Tables

### NGINX Reloads and Time to Ready

| Test number | NumResources | TimeToReadyTotal (s) | TimeToReadyAvgSingle (s) | NGINX reloads | NGINX reload avg time (ms) | <= 500ms | <= 1000ms |
|-------------|--------------|----------------------|--------------------------|---------------|----------------------------|----------|-----------|
| 1           | 30           | 1                    | 1                        | 2             | 191                        | 100%     | 100%      |
| 1           | 150          | 2                    | 2                        | 2             | 440                        | 50%      | 100%      |
| 2           | 30           | 50                   | <1                       | 93            | 162                        | 100%     | 100%      |
| 2           | 150          | 208                  | <1                       | 396           | 281                        | 96.46%   | 100%      |
| 3           | 30           | 1                    | 1                        | 93            | 129                        | 100%     | 100%      |
| 3           | 150          | 1                    | 1                        | 453           | 130                        | 100%     | 100%      |


### Event Batch Processing

| Test number | NumResources | Event Batch Total | Event Batch Processing avg time (ms) | <= 500ms | <= 1000ms |
|-------------|--------------|-------------------|--------------------------------------|----------|-----------|
| 1           | 30           | 69                | 6.232                                | 100%     | 100%      |
| 1           | 150          | 309               | 3.638                                | 99.68%   | 100%      |
| 2           | 30           | 465               | 38.759                               | 100%     | 100%      |
| 2           | 150          | 1941              | 68.539                               | 98.51%   | 100%      |
| 3           | 30           | 374               | 36.834                               | 99.73%   | 99.73%    |
| 3           | 150          | 1812              | 40.411                               | 99.94%   | 99.94%    |


## NumResources -> Total Resources

| NumResources | Gateways | Secrets | ReferenceGrants | Namespaces | application Pods | application Services | HTTPRoutes | Total Resources |
|--------------|----------|---------|-----------------|------------|------------------|----------------------|------------|-----------------|
| x            | 1        | 1       | 1               | x+1        | 2x               | 2x                   | 3x         | <total>         |
| 30           | 1        | 1       | 1               | 31         | 60               | 60                   | 90         | 244             |
| 150          | 1        | 1       | 1               | 151        | 300              | 300                  | 450        | 1204            |

## Observations

1. We are reloading after reconciling a ReferenceGrant even when there is no Gateway. This is because we treat every
   upsert/delete of a ReferenceGrant as a change. This means we will regenerate NGINX config every time a ReferenceGrant
   is created, updated (generation must change), or deleted, even if it does not apply to the accepted Gateway.

   Issue filed: https://github.com/nginx/nginx-gateway-fabric/issues/1124

2. We are reloading after reconciling a HTTPRoute even when there is no accepted Gateway and no config being generated.

   Issue filed: https://github.com/nginx/nginx-gateway-fabric/issues/1123

3. Majority of NGINX reloads were in the <= 500ms bucket, with all of them being in the <= 1000ms bucket. An increase
   in the reload time based on number of configured resources resulting in NGINX configuration changes was observed.

4. No errors (NGF or NGINX) were observed in any test run.
