# Results for v1.1.0

<!-- TOC -->
- [Results for v1.1.0](#results-for-v110)
  - [Summary](#summary)
  - [Versions](#versions)
  - [Tests](#tests)
    - [Restart nginx-gateway container](#restart-nginx-gateway-container)
    - [Restart NGINX container](#restart-nginx-container)
    - [Restart Node with draining](#restart-node-with-draining)
    - [Restart Node without draining](#restart-node-without-draining)
  - [Future Improvements](#future-improvements)
<!-- TOC -->


## Summary

- No new issues since 1.0.
- One new error in the [Restart Node with draining](#restart-node-with-draining) test, but it is not actionable.

## Versions

NGF version:


```text
commit: d6bbdba28a0f9ae3f75864855b76b0fb34bee3e5
date: 2023-12-05T18:43:51Z
version: edge
```

with NGINX:

```text
nginx/1.25.3
built by gcc 12.2.1 20220924 (Alpine 12.2.1_git20220924-r10)
OS: Linux 5.15.49-linuxkit-pr
```


Kubernetes:

```text
Server Version: version.Info{Major:"1", Minor:"28",
GitVersion:"v1.28.0",
GitCommit:"855e7c48de7388eb330da0f8d9d2394ee818fb8d",
GitTreeState:"clean", BuildDate:"2023-08-15T21:26:40Z",
GoVersion:"go1.20.7", Compiler:"gc",
Platform:"linux/arm64"}
```

## Tests

### Restart nginx-gateway container

No errors.

### Restart NGINX container

The NGF Pod was unable to recover after sending a SIGKILL signal to the NGINX master process.
The following appeared in the NGINX logs:

```text
2023/12/05 22:18:45 [emerg] 116#116: bind() to unix:/var/run/nginx/nginx-config-version.sock failed (98: Address in use)
2023/12/05 22:18:45 [emerg] 116#116: bind() to unix:/var/lib/nginx/nginx-502-server.sock failed (98: Address in use)
2023/12/05 22:18:45 [emerg] 116#116: bind() to unix:/var/lib/nginx/nginx-500-server.sock failed (98: Address in use)
2023/12/05 22:18:45 [emerg] 116#116: bind() to unix:/var/run/nginx/nginx-status.sock failed (98: Address in use)
2023/12/05 22:18:45 [notice] 116#116: try again to bind() after 500ms
```

NGF cannot update NGINX after this and logs the following error:

```text
{
  "level": "error",
  "ts": "2023-12-05T22:19:53Z",
  "logger": "eventLoop.eventHandler",
  "msg": "Failed to update NGINX configuration",
  "batchID": 22,
  "error": "failed to reload NGINX: open /proc/19/task/19/children: no such file or directory",
  "stacktrace": "github.com/nginx/nginx-gateway-fabric/internal/mode/static.(*eventHandlerImpl).HandleEventBatch\n\t/home/runner/work/nginx-gateway-fabric/nginx-gateway-fabric/internal/mode/static/handler.go:116\ngithub.com/nginx/nginx-gateway-fabric/internal/framework/events.(*EventLoop).Start.func1.1\n\t/home/runner/work/nginx-gateway-fabric/nginx-gateway-fabric/internal/framework/events/loop.go:74"
}
```

Known issue: https://github.com/nginx/nginx-gateway-fabric/issues/1108


### Restart Node with draining

Previous NGF container error:

```json
{
  "level": "error",
  "ts": "2023-12-05T21:43:31Z",
  "logger": "eventLoop.eventHandler",
  "msg": "Failed to update NGINX configuration",
  "batchID": 11,
  "error": "failed to reload NGINX: could not get expected config version 7: error getting client: Get \"http://config-version/version\": dial unix /var/run/nginx/nginx-config-version.sock: connect: no such file or directory",
  "stacktrace": "github.com/nginx/nginx-gateway-fabric/internal/mode/static.(*eventHandlerImpl).HandleEventBatch\n\t/home/runner/work/nginx-gateway-fabric/nginx-gateway-fabric/internal/mode/static/handler.go:116\ngithub.com/nginx/nginx-gateway-fabric/internal/framework/events.(*EventLoop).Start.func1.1\n\t/home/runner/work/nginx-gateway-fabric/nginx-gateway-fabric/internal/framework/events/loop.go:74"
}
```

This error is likely due to NGINX terminating during a reload attempt and does not consistently occur on a node restart.

No errors in previous NGINX container.
No errors in new NGF/NGINX containers.

### Restart Node without draining

The NGF Pod was unable to recover the majority of times after running `docker restart kind-control-plane`.

The following appeared in the NGINX logs:

```text
2023/12/05 21:53:51 [emerg] 29#29: bind() to unix:/var/run/nginx/nginx-status.sock failed (98: Address in use)
2023/12/05 21:53:51 [notice] 29#29: try again to bind() after 500ms
2023/12/05 21:53:51 [emerg] 29#29: bind() to unix:/var/run/nginx/nginx-status.sock failed (98: Address in use)
2023/12/05 21:53:51 [notice] 29#29: try again to bind() after 500ms
2023/12/05 21:53:51 [emerg] 29#29: bind() to unix:/var/run/nginx/nginx-status.sock failed (98: Address in use)
2023/12/05 21:53:51 [notice] 29#29: try again to bind() after 500ms
2023/12/05 21:53:51 [emerg] 29#29: bind() to unix:/var/run/nginx/nginx-status.sock failed (98: Address in use)
2023/12/05 21:53:51 [notice] 29#29: try again to bind() after 500ms
2023/12/05 21:53:51 [emerg] 29#29: bind() to unix:/var/run/nginx/nginx-status.sock failed (98: Address in use)
2023/12/05 21:53:51 [notice] 29#29: try again to bind() after 500ms
2023/12/05 21:53:51 [emerg] 29#29: still could not bind()
```

The following appeared in the NGF logs:

```text
failed to start control loop: cannot create nginx metrics collector: failed to get http://config-status/stub_status: Get "http://config-status/stub_status": dial unix /var/run/nginx/nginx-status.sock: connect: connection refused
```

Known issue: https://github.com/nginx/nginx-gateway-fabric/issues/1108

## Future Improvements

- None
