# Results for v1.0.0

<!-- TOC -->
- [Results for v1.0.0](#results-for-v100)
  - [Versions](#versions)
  - [Tests](#tests)
    - [Restart nginx-gateway container](#restart-nginx-gateway-container)
    - [Restart NGINX container](#restart-nginx-container)
    - [Restart Node with draining](#restart-node-with-draining)
    - [Restart Node without draining](#restart-node-without-draining)
  - [Future Improvements](#future-improvements)
<!-- TOC -->


## Versions

NGF version:

```text
commit: 72b6c6ef8915c697626eeab88fdb6a3ce15b8da0
date: 2023-10-02T13:13:08Z
version: edge
```

with NGINX:

```text
nginx/1.25.2
built by gcc 12.2.1 20220924 (Alpine 12.2.1_git20220924-r10)
OS: Linux 5.15.49-linuxkit-pr
```


Kubernetes:

```text
Server Version: version.Info{Major:"1", Minor:"28",
GitVersion:"v1.28.0",
GitCommit:"855e7c48de7388eb330da0f8d9d2394ee818fb8d",
GitTreeState:"clean", BuildDate:"2023-08-15T21:26:40Z",
GoVersion:"go1.20.7", Compiler:"gc",
Platform:"linux/arm64"}
```

## Tests

### Restart nginx-gateway container

Passes test with no errors.

### Restart NGINX container

The NGF Pod was unable to recover after sending a SIGKILL signal to the NGINX master process.
The following appeared in the NGINX logs:

```text
2023/10/10 22:46:54 [emerg] 141#141: bind() to unix:/var/run/nginx/nginx-config-version.sock failed (98: Address in use)
2023/10/10 22:46:54 [emerg] 141#141: bind() to unix:/var/lib/nginx/nginx-502-server.sock failed (98: Address in use)
2023/10/10 22:46:54 [emerg] 141#141: bind() to unix:/var/lib/nginx/nginx-500-server.sock failed (98: Address in use)
2023/10/10 22:46:54 [emerg] 141#141: bind() to unix:/var/run/nginx/nginx-status.sock failed (98: Address in use)
2023/10/10 22:46:54 [notice] 141#141: try again to bind() after 500ms
2023/10/10 22:46:54 [emerg] 141#141: bind() to unix:/var/run/nginx/nginx-config-version.sock failed (98: Address in use)
2023/10/10 22:46:54 [emerg] 141#141: bind() to unix:/var/lib/nginx/nginx-502-server.sock failed (98: Address in use)
2023/10/10 22:46:54 [emerg] 141#141: bind() to unix:/var/lib/nginx/nginx-500-server.sock failed (98: Address in use)
2023/10/10 22:46:54 [emerg] 141#141: bind() to unix:/var/run/nginx/nginx-status.sock failed (98: Address in use)
2023/10/10 22:46:54 [notice] 141#141: try again to bind() after 500ms
2023/10/10 22:46:54 [emerg] 141#141: bind() to unix:/var/run/nginx/nginx-config-version.sock failed (98: Address in use)
2023/10/10 22:46:54 [emerg] 141#141: bind() to unix:/var/lib/nginx/nginx-502-server.sock failed (98: Address in use)
2023/10/10 22:46:54 [emerg] 141#141: bind() to unix:/var/lib/nginx/nginx-500-server.sock failed (98: Address in use)
2023/10/10 22:46:54 [emerg] 141#141: bind() to unix:/var/run/nginx/nginx-status.sock failed (98: Address in use)
2023/10/10 22:46:54 [notice] 141#141: try again to bind() after 500ms
2023/10/10 22:46:54 [emerg] 141#141: bind() to unix:/var/run/nginx/nginx-config-version.sock failed (98: Address in use)
2023/10/10 22:46:54 [emerg] 141#141: bind() to unix:/var/lib/nginx/nginx-502-server.sock failed (98: Address in use)
2023/10/10 22:46:54 [emerg] 141#141: bind() to unix:/var/lib/nginx/nginx-500-server.sock failed (98: Address in use)
2023/10/10 22:46:54 [emerg] 141#141: bind() to unix:/var/run/nginx/nginx-status.sock failed (98: Address in use)
2023/10/10 22:46:54 [notice] 141#141: try again to bind() after 500ms
2023/10/10 22:46:54 [emerg] 141#141: bind() to unix:/var/run/nginx/nginx-config-version.sock failed (98: Address in use)
2023/10/10 22:46:54 [emerg] 141#141: bind() to unix:/var/lib/nginx/nginx-502-server.sock failed (98: Address in use)
2023/10/10 22:46:54 [emerg] 141#141: bind() to unix:/var/lib/nginx/nginx-500-server.sock failed (98: Address in use)
2023/10/10 22:46:54 [emerg] 141#141: bind() to unix:/var/run/nginx/nginx-status.sock failed (98: Address in use)
2023/10/10 22:46:54 [notice] 141#141: try again to bind() after 500ms
2023/10/10 22:46:54 [emerg] 141#141: still could not bind()
```

Issue Filed: https://github.com/nginx/nginx-gateway-fabric/issues/1108


### Restart Node with draining

Passes test with no errors.

### Restart Node without draining

The NGF Pod was unable to recover the majority of times after running `docker restart kind-control-plane`.

The following appeared in the NGINX logs:

```text
2023/10/10 22:57:05 [emerg] 140#140: bind() to unix:/var/run/nginx/nginx-status.sock failed (98: Address in use)
2023/10/10 22:57:05 [notice] 140#140: try again to bind() after 500ms
2023/10/10 22:57:05 [emerg] 140#140: bind() to unix:/var/run/nginx/nginx-status.sock failed (98: Address in use)
2023/10/10 22:57:05 [notice] 140#140: try again to bind() after 500ms
2023/10/10 22:57:05 [emerg] 140#140: bind() to unix:/var/run/nginx/nginx-status.sock failed (98: Address in use)
2023/10/10 22:57:05 [notice] 140#140: try again to bind() after 500ms
2023/10/10 22:57:05 [emerg] 140#140: bind() to unix:/var/run/nginx/nginx-status.sock failed (98: Address in use)
2023/10/10 22:57:05 [notice] 140#140: try again to bind() after 500ms
2023/10/10 22:57:05 [emerg] 140#140: bind() to unix:/var/run/nginx/nginx-status.sock failed (98: Address in use)
2023/10/10 22:57:05 [notice] 140#140: try again to bind() after 500ms
2023/10/10 22:57:05 [emerg] 140#140: still could not bind()
```

The following appeared in the NGF logs:

```text
{"level":"info","ts":"2023-10-10T22:57:05Z","msg":"Starting NGINX Gateway Fabric in static mode","version":"edge","commit":"b3fbf98d906f60ce66d70d7a2373c4b12b7d5606","date":"2023-10-10T22:02:06Z"}
Error: failed to start control loop: cannot create and register metrics collectors: cannot create NGINX status metrics collector: failed to get http://config-status/stub_status: Get "http://config-status/stub_status": dial unix /var/run/nginx/nginx-status.sock: connect: connection refused
Usage:
  gateway static-mode [flags]

Flags:
  -c, --config string                      The name of the NginxGateway resource to be used for this controller's dynamic configuration. Lives in the same Namespace as the controller. (default "")
      --gateway string                     The namespaced name of the Gateway resource to use. Must be of the form: NAMESPACE/NAME. If not specified, the control plane will process all Gateways for the configured GatewayClass. However, among them, it will choose the oldest resource by creation timestamp. If the timestamps are equal, it will choose the resource that appears first in alphabetical order by {namespace}/{name}.
      --health-disable                     Disable running the health probe server.
      --health-port int                    Set the port where the health probe server is exposed. Format: [1024 - 65535] (default 8081)
  -h, --help                               help for static-mode
      --leader-election-disable            Disable leader election. Leader election is used to avoid multiple replicas of the NGINX Gateway Fabric reporting the status of the Gateway API resources. If disabled, all replicas of NGINX Gateway Fabric will update the statuses of the Gateway API resources.
      --leader-election-lock-name string   The name of the leader election lock. A Lease object with this name will be created in the same Namespace as the controller. (default "nginx-gateway-leader-election-lock")
      --metrics-disable                    Disable exposing metrics in the Prometheus format.
      --metrics-port int                   Set the port where the metrics are exposed. Format: [1024 - 65535] (default 9113)
      --metrics-secure-serving             Enable serving metrics via https. By default metrics are served via http. Please note that this endpoint will be secured with a self-signed certificate.
      --update-gatewayclass-status         Update the status of the GatewayClass resource. (default true)

Global Flags:
      --gateway-ctlr-name string   The name of the Gateway controller. The controller name must be of the form: DOMAIN/PATH. The controller's domain is 'gateway.nginx.org' (default "")
      --gatewayclass string        The name of the GatewayClass resource. Every NGINX Gateway Fabric must have a unique corresponding GatewayClass resource. (default "")

failed to start control loop: cannot create and register metrics collectors: cannot create NGINX status metrics collector: failed to get http://config-status/stub_status: Get "http://config-status/stub_status": dial unix /var/run/nginx/nginx-status.sock: connect: connection refused
```

Important to note that occasionally the test will pass and the NGF Pod would recover gracefully.

Related to this issue: https://github.com/nginx/nginx-gateway-fabric/issues/1108

## Future Improvements

- None
