# Reconfiguration testing Results

<!-- TOC -->
- [Reconfiguration testing Results](#reconfiguration-testing-results)
  - [Summary](#summary)
  - [Test environment](#test-environment)
  - [Results Tables](#results-tables)
    - [NGINX Reloads and Time to Ready](#nginx-reloads-and-time-to-ready)
    - [Event Batch Processing](#event-batch-processing)
  - [NumResources to Total Resources](#numresources-to-total-resources)
  - [Observations](#observations)
  - [Future Improvements](#future-improvements)
<!-- TOC -->

## Summary

- Better reload times across all tests
- Similar TimeToReadyTotal and TimeToReadyAveSingle times
- Similar event batch totals
- Slightly better event batch processing average times
- No new errors or issues

## Test environment

GKE cluster:

- Node count: 4
- Instance Type: n2d-standard-2
- k8s version: 1.27.3-gke.100
- Zone: us-west2-a
- Total vCPUs: 8
- Total RAM: 32GB
- Max pods per node: 110

NGF deployment:

- NGF version: edge - git commit 3cab370a46bccd55c115c16e23a475df2497a3d2
- NGINX Version: 1.25.3

## Results Tables

### NGINX Reloads and Time to Ready

| Test number | NumResources | TimeToReadyTotal (s) | TimeToReadyAvgSingle (s) | NGINX reloads | NGINX reload avg time (ms) | <= 500ms | <= 1000ms |
|-------------|--------------|----------------------|--------------------------|---------------|----------------------------|----------|-----------|
| 1           | 30           | 1.5                  | <1                       | 2             | 158.5                      | 100%     | 100%      |
| 1           | 150          | 3.5                  | 1                        | 2             | 272.5                      | 100%     | 100%      |
| 2           | 30           | 34                   | <1                       | 93            | 136                        | 100%     | 100%      |
| 2           | 150          | 176.5                | <1                       | 451           | 203.98                     | 100%     | 100%      |
| 3           | 30           | <1                   | 1                        | 93            | 125.7                      | 100%     | 100%      |
| 3           | 150          | 1                    | 1                        | 453           | 126.71                     | 100%     | 100%      |


### Event Batch Processing

| Test number | NumResources | Event Batch Total | Event Batch Processing avg time (ms) | <= 500ms | <= 1000ms | <= 5000ms | <= 10000ms | <= 30000ms |
|-------------|--------------|-------------------|--------------------------------------|----------|-----------|-----------|------------|------------|
| 1           | 30           | 70                | 5.12                                 | 100%     | 100%      | 100%      | 100%       | 100%       |
| 1           | 150          | 309               | 2.14                                 | 100%     | 100%      | 100%      | 100%       | 100%       |
| 2           | 30           | 442               | 35.4                                 | 100%     | 100%      | 100%      | 100%       | 100%       |
| 2           | 150          | 2009              | 54.76                                | 100%     | 100%      | 100%      | 100%       | 100%       |
| 3           | 30           | 373               | 35.72                                | 99.73%   | 99.73%    | 100%      | 100%       | 100%       |
| 3           | 150          | 1813              | 39.46                                | 99.94%   | 99.94%    | 99.94%    | 99.94%     | 100%       |

> Note: The outlier for test #3 is the event batch that contains the Gateway. It took ~13s to process.

## NumResources to Total Resources

| NumResources | Gateways | Secrets | ReferenceGrants | Namespaces | application Pods | application Services | HTTPRoutes | Attached HTTPRoutes | Total Resources |
|--------------|----------|---------|-----------------|------------|------------------|----------------------|------------|---------------------|-----------------|
| x            | 1        | 1       | 1               | x+1        | 2x               | 2x                   | 3x         | 2x                  | <total>         |
| 30           | 1        | 1       | 1               | 31         | 60               | 60                   | 90         | 60                  | 244             |
| 150          | 1        | 1       | 1               | 151        | 300              | 300                  | 450        | 300                 | 1204            |

> Note: Only 2x HTTPRoutes attach to the Gateway because the parentRef name in the `cafe-tls-redirect` HTTPRoute is incorrect. This will be fixed in the next release.

## Observations

1. The following issues still exist:

   - https://github.com/nginx/nginx-gateway-fabric/issues/1124
   - https://github.com/nginx/nginx-gateway-fabric/issues/1123

2. All NGINX reloads were in the <= 500ms bucket. An increase in the reload time based on number of configured resources resulting in NGINX configuration changes was observed.

3. No errors (NGF or NGINX) were observed in any test run.

4. The majority of the event batches were processed in 500ms or less except the 3rd test. In the 3rd test, we create the Gateway resource after all the apps and routes. The batch that contains the Gateway is the only one that takes longer than 500ms. It takes ~13s.

## Future Improvements

1. Fix the parentRef name in the `cafe-tls-redirect` [HTTPRoute](/tests/reconfig/scripts/cafe-routes.yaml), so it matches the deployed Gateway.
