# Results

## Test environment

GKE cluster:

- Node count: 3
- Instance Type: e2-medium
- k8s version: 1.27.4-gke.900
- Zone: europe-west2-b
- Total vCPUs: 6
- Total RAM: 12GB
- Max pods per node: 110

Test VM:

- Instance Type: e2-medium
- Zone: europe-west2-b
- vCPUS: 2
- RAM: 4GB

NGF deployment:

- NGF version: edge - git commit a41e9e46d72788bceea8ba44e01d4062afec75fd
- NGINX Version: 1.25.2

## Test1: Running latte path based routing

```console
Running 30s test @ http://cafe.example.com/latte
  2 threads and 10 connections
  Thread Stats   Avg      Stdev     Max   +/- Stdev
    Latency     6.29ms    7.85ms 182.06ms   88.67%
    Req/Sec     1.11k   588.11     2.31k    59.83%
  Latency Distribution
     50%    3.44ms
     75%    7.09ms
     90%   15.33ms
     99%   31.86ms
  66017 requests in 30.02s, 23.42MB read
Requests/sec:   2199.43
Transfer/sec:    799.00KB
```

## Test2: Running coffee header based routing

```console
Running 30s test @ http://cafe.example.com/coffee
  2 threads and 10 connections
  Thread Stats   Avg      Stdev     Max   +/- Stdev
    Latency    31.95ms   37.10ms 243.16ms   89.07%
    Req/Sec   224.25    238.65     1.83k    90.32%
  Latency Distribution
     50%   14.31ms
     75%   43.74ms
     90%   76.70ms
     99%  171.95ms
  12913 requests in 30.03s, 4.59MB read
Requests/sec:    430.05
Transfer/sec:    156.65KB
```

## Test3: Running coffee query based routing

```console
Running 30s test @ http://cafe.example.com/coffee?TEST=v2
  2 threads and 10 connections
  Thread Stats   Avg      Stdev     Max   +/- Stdev
    Latency    29.26ms   43.85ms 457.05ms   82.26%
    Req/Sec   632.30    464.79     2.07k    60.43%
  Latency Distribution
     50%    4.45ms
     75%   45.84ms
     90%  103.14ms
     99%  145.53ms
  37324 requests in 30.02s, 13.56MB read
Requests/sec:   1243.13
Transfer/sec:    462.53KB
```

## Test4: Running tea GET method based routing

```console
Running 30s test @ http://cafe.example.com/tea
  2 threads and 10 connections
  Thread Stats   Avg      Stdev     Max   +/- Stdev
    Latency    27.19ms   39.40ms 182.48ms   81.49%
    Req/Sec   706.49    416.90     1.85k    65.42%
  Latency Distribution
     50%    4.06ms
     75%   42.24ms
     90%   99.21ms
     99%  133.34ms
  41265 requests in 30.04s, 14.56MB read
Requests/sec:   1373.59
Transfer/sec:    496.31KB
```

## Test5: Running tea POST method based routing

```console
Running 30s test @ http://cafe.example.com/tea
  2 threads and 10 connections
  Thread Stats   Avg      Stdev     Max   +/- Stdev
    Latency    27.32ms   39.49ms 208.66ms   81.40%
    Req/Sec   685.47    491.33     2.08k    58.43%
  Latency Distribution
     50%    4.19ms
     75%   42.40ms
     90%   99.38ms
     99%  133.25ms
  40723 requests in 30.03s, 14.37MB read
Requests/sec:   1356.10
Transfer/sec:    489.99KB
```

## Observations

- Path based routing is the most performant of the routing methods
- The njs based methods are less performant:
  - Header based routing is the least performant of the routing methods, by a factor of roughly 5 compared to the path
    based routing.
  - The query and method based routing methods are approximately 2/3s as performant as the path based routing.
