### `tf.variable_op_scope(values, name_or_scope, default_name=None, initializer=None, regularizer=None, caching_device=None, partitioner=None, custom_getter=None, reuse=None, dtype=None)` {#variable_op_scope}

Returns a context manager for defining an op that creates variables.

This context manager validates that the given `values` are from the
same graph, ensures that graph is the default graph, and pushes a
name scope and a variable scope.

If `name_or_scope` is not None, it is used as is in the variable scope. If
`scope` is None, then `default_name` is used.  In that case, if the same name
has been previously used in the same scope, it will made unique be appending
`_N` to it.

This is intended to be used when defining generic ops and so reuse is always
inherited.

For example, to define a new Python op called `my_op_with_vars`:

```python
def my_op_with_vars(a, b, scope=None):
  with tf.variable_op_scope([a, b], scope, "MyOp") as scope:
    a = tf.convert_to_tensor(a, name="a")
    b = tf.convert_to_tensor(b, name="b")
    c = tf.get_variable('c')
    # Define some computation that uses `a`, `b`, and `c`.
    return foo_op(..., name=scope)
```

##### Args:


*  <b>`values`</b>: The list of `Tensor` arguments that are passed to the op function.
*  <b>`name_or_scope`</b>: The name argument that is passed to the op function,
    this name_or_scope is not uniquified in the variable scope.
*  <b>`default_name`</b>: The default name to use if the `name_or_scope` argument is
    `None`, this name will be uniquified. If name_or_scope is provided it
    won't be used and therefore it is not required and can be None.
*  <b>`initializer`</b>: The default initializer to pass to variable scope.
*  <b>`regularizer`</b>: The default regularizer for variables within this scope.
*  <b>`caching_device`</b>: The default caching device for variables within this scope.
*  <b>`partitioner`</b>: The default partitioner for variables within this scope.
*  <b>`custom_getter`</b>: The default custom getter for variables within this scope.
*  <b>`reuse`</b>: `True` or `None`; if `True`, we go into reuse mode for this scope as
    well as all sub-scopes; if `None`, we just inherit the parent scope reuse.
*  <b>`dtype`</b>: The default type of variables created in this scope, defaults to the
    type of the parent scope.

##### Returns:

  A context manager for use in defining a Python op.

##### Raises:


*  <b>`ValueError`</b>: when trying to reuse within a create scope, or create within
    a reuse scope, or if reuse is not `None` or `True`.
*  <b>`TypeError`</b>: when the types of some arguments are not appropriate.

