// Code generated by protoc-gen-gogo.
// source: types.proto
// DO NOT EDIT!

/*
	Package api is a generated protocol buffer package.

	It is generated from these files:
		types.proto
		specs.proto
		objects.proto
		cluster.proto
		dispatcher.proto
		manager.proto
		ca.proto
		snapshot.proto
		raft.proto

	It has these top-level messages:
		Version
		Resources
		ResourceRequirements
		Platform
		NodeDescription
		MemberDescription
		RaftNode
		MemberStatus
		NodeStatus
		Image
		Mount
		Container
		RestartPolicy
		UpdateStrategy
		TaskStatus
		IPAMConfiguration
		Endpoint
		Driver
		IPAMOptions
		WeightedPeer
		Annotations
		NodeSpec
		MemberSpec
		ServiceSpec
		TaskSpec
		VolumeSpec
		NetworkSpec
		Node
		Member
		Service
		Task
		Volume
		Network
		ListOptions
		GetNodeRequest
		GetNodeResponse
		ListNodesRequest
		ListNodesResponse
		UpdateNodeRequest
		UpdateNodeResponse
		GetTaskRequest
		GetTaskResponse
		RemoveTaskRequest
		RemoveTaskResponse
		ListTasksRequest
		ListTasksResponse
		CreateServiceRequest
		CreateServiceResponse
		GetServiceRequest
		GetServiceResponse
		UpdateServiceRequest
		UpdateServiceResponse
		RemoveServiceRequest
		RemoveServiceResponse
		ListServicesRequest
		ListServicesResponse
		CreateNetworkRequest
		CreateNetworkResponse
		GetNetworkRequest
		GetNetworkResponse
		RemoveNetworkRequest
		RemoveNetworkResponse
		ListNetworksRequest
		ListNetworksResponse
		CreateVolumeRequest
		CreateVolumeResponse
		GetVolumeRequest
		GetVolumeResponse
		RemoveVolumeRequest
		RemoveVolumeResponse
		ListVolumesRequest
		ListVolumesResponse
		ListManagersRequest
		ListManagersResponse
		RegisterRequest
		RegisterResponse
		SessionRequest
		SessionMessage
		HeartbeatRequest
		HeartbeatResponse
		UpdateTaskStatusRequest
		UpdateTaskStatusResponse
		TasksRequest
		TasksMessage
		NodeCountRequest
		NodeCountResponse
		IssuanceStatus
		IssueCertificateRequest
		IssueCertificateResponse
		GetRootCACertificateRequest
		GetRootCACertificateResponse
		StoreSnapshot
		ClusterSnapshot
		Snapshot
		JoinRequest
		JoinResponse
		LeaveRequest
		LeaveResponse
		ProcessRaftMessageRequest
		ProcessRaftMessageResponse
		InternalRaftRequest
		StoreAction
*/
package api

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import docker_cluster_api "github.com/docker/swarm-v2/api/timestamp"
import _ "github.com/gogo/protobuf/gogoproto"

import time "time"

import strings "strings"
import github_com_gogo_protobuf_proto "github.com/gogo/protobuf/proto"
import sort "sort"
import strconv "strconv"
import reflect "reflect"
import github_com_gogo_protobuf_sortkeys "github.com/gogo/protobuf/sortkeys"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
const _ = proto.GoGoProtoPackageIsVersion1

// TaskState enumerates the states that a task progresses through within an
// agent. States are designed to be monotonically increasing, such that if two
// states are seen by a task, the greater of the new represents the true state.
type TaskState int32

const (
	TaskStateNew       TaskState = 0
	TaskStateAllocated TaskState = 64
	TaskStatePending   TaskState = 128
	TaskStateAssigned  TaskState = 192
	TaskStateAccepted  TaskState = 256
	TaskStatePreparing TaskState = 320
	TaskStateReady     TaskState = 384
	TaskStateStarting  TaskState = 448
	TaskStateRunning   TaskState = 512
	TaskStateShutdown  TaskState = 576
	TaskStateCompleted TaskState = 640
	TaskStateFailed    TaskState = 704
	TaskStateRejected  TaskState = 768
	TaskStateFinalize  TaskState = 832
	TaskStateDead      TaskState = 896
)

var TaskState_name = map[int32]string{
	0:   "NEW",
	64:  "ALLOCATED",
	128: "PENDING",
	192: "ASSIGNED",
	256: "ACCEPTED",
	320: "PREPARING",
	384: "READY",
	448: "STARTING",
	512: "RUNNING",
	576: "SHUTDOWN",
	640: "COMPLETE",
	704: "FAILED",
	768: "REJECTED",
	832: "FINALIZE",
	896: "DEAD",
}
var TaskState_value = map[string]int32{
	"NEW":       0,
	"ALLOCATED": 64,
	"PENDING":   128,
	"ASSIGNED":  192,
	"ACCEPTED":  256,
	"PREPARING": 320,
	"READY":     384,
	"STARTING":  448,
	"RUNNING":   512,
	"SHUTDOWN":  576,
	"COMPLETE":  640,
	"FAILED":    704,
	"REJECTED":  768,
	"FINALIZE":  832,
	"DEAD":      896,
}

func (x TaskState) String() string {
	return proto.EnumName(TaskState_name, int32(x))
}
func (TaskState) EnumDescriptor() ([]byte, []int) { return fileDescriptorTypes, []int{0} }

type MemberStatus_State int32

const (
	// Unknown indicates that the manager state cannot be resolved
	MemberStatus_UNKNOWN MemberStatus_State = 0
	// Unreachable indicates that the node cannot be contacted by other
	// raft cluster members.
	MemberStatus_UNREACHABLE MemberStatus_State = 1
	// Reachable indicates that the node is healthy and reachable
	// by other members.
	MemberStatus_REACHABLE MemberStatus_State = 2
)

var MemberStatus_State_name = map[int32]string{
	0: "UNKNOWN",
	1: "UNREACHABLE",
	2: "REACHABLE",
}
var MemberStatus_State_value = map[string]int32{
	"UNKNOWN":     0,
	"UNREACHABLE": 1,
	"REACHABLE":   2,
}

func (x MemberStatus_State) String() string {
	return proto.EnumName(MemberStatus_State_name, int32(x))
}
func (MemberStatus_State) EnumDescriptor() ([]byte, []int) { return fileDescriptorTypes, []int{7, 0} }

// TODO(aluzzardi) These should be using `gogoproto.enumvalue_customname`.
type NodeStatus_State int32

const (
	// Unknown indicates the node state cannot be resolved.
	NodeStatus_UNKNOWN NodeStatus_State = 0
	// Down indicates the node is down.
	NodeStatus_DOWN NodeStatus_State = 1
	// Ready indicates the node is ready to accept tasks.
	NodeStatus_READY NodeStatus_State = 2
	// Disconnected indicates the node is currently trying to find new manager.
	NodeStatus_DISCONNECTED NodeStatus_State = 3
)

var NodeStatus_State_name = map[int32]string{
	0: "UNKNOWN",
	1: "DOWN",
	2: "READY",
	3: "DISCONNECTED",
}
var NodeStatus_State_value = map[string]int32{
	"UNKNOWN":      0,
	"DOWN":         1,
	"READY":        2,
	"DISCONNECTED": 3,
}

func (x NodeStatus_State) String() string {
	return proto.EnumName(NodeStatus_State_name, int32(x))
}
func (NodeStatus_State) EnumDescriptor() ([]byte, []int) { return fileDescriptorTypes, []int{8, 0} }

// Mask
type Mount_Mask int32

const (
	MountMaskReadOnly  Mount_Mask = 0
	MountMaskReadWrite Mount_Mask = 1
)

var Mount_Mask_name = map[int32]string{
	0: "READ_ONLY",
	1: "READ_WRITE",
}
var Mount_Mask_value = map[string]int32{
	"READ_ONLY":  0,
	"READ_WRITE": 1,
}

func (x Mount_Mask) String() string {
	return proto.EnumName(Mount_Mask_name, int32(x))
}
func (Mount_Mask) EnumDescriptor() ([]byte, []int) { return fileDescriptorTypes, []int{10, 0} }

type Mount_Type int32

const (
	MountTypeBind      Mount_Type = 0
	MountTypeEphemeral Mount_Type = 1
	MountTypeVolume    Mount_Type = 2
)

var Mount_Type_name = map[int32]string{
	0: "BIND",
	1: "EPHEMERAL",
	2: "VOLUME",
}
var Mount_Type_value = map[string]int32{
	"BIND":      0,
	"EPHEMERAL": 1,
	"VOLUME":    2,
}

func (x Mount_Type) String() string {
	return proto.EnumName(Mount_Type_name, int32(x))
}
func (Mount_Type) EnumDescriptor() ([]byte, []int) { return fileDescriptorTypes, []int{10, 1} }

type RestartPolicy_RestartCondition int32

const (
	RestartNever     RestartPolicy_RestartCondition = 0
	RestartOnFailure RestartPolicy_RestartCondition = 1
	RestartAlways    RestartPolicy_RestartCondition = 2
)

var RestartPolicy_RestartCondition_name = map[int32]string{
	0: "RESTART_NEVER",
	1: "RESTART_ON_FAILURE",
	2: "RESTART_ALWAYS",
}
var RestartPolicy_RestartCondition_value = map[string]int32{
	"RESTART_NEVER":      0,
	"RESTART_ON_FAILURE": 1,
	"RESTART_ALWAYS":     2,
}

func (x RestartPolicy_RestartCondition) String() string {
	return proto.EnumName(RestartPolicy_RestartCondition_name, int32(x))
}
func (RestartPolicy_RestartCondition) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorTypes, []int{12, 0}
}

// AddressFamily specifies the network address family that
// this IPAMConfiguration belongs to.
type IPAMConfiguration_AddressFamily int32

const (
	IPAMConfiguration_UNKNOWN IPAMConfiguration_AddressFamily = 0
	IPAMConfiguration_IPV4    IPAMConfiguration_AddressFamily = 4
	IPAMConfiguration_IPV6    IPAMConfiguration_AddressFamily = 6
)

var IPAMConfiguration_AddressFamily_name = map[int32]string{
	0: "UNKNOWN",
	4: "IPV4",
	6: "IPV6",
}
var IPAMConfiguration_AddressFamily_value = map[string]int32{
	"UNKNOWN": 0,
	"IPV4":    4,
	"IPV6":    6,
}

func (x IPAMConfiguration_AddressFamily) String() string {
	return proto.EnumName(IPAMConfiguration_AddressFamily_name, int32(x))
}
func (IPAMConfiguration_AddressFamily) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorTypes, []int{15, 0}
}

// Layer 4 port the port configuration belongs to.
type Endpoint_Protocol int32

const (
	Endpoint_TCP Endpoint_Protocol = 0
	Endpoint_UDP Endpoint_Protocol = 1
)

var Endpoint_Protocol_name = map[int32]string{
	0: "TCP",
	1: "UDP",
}
var Endpoint_Protocol_value = map[string]int32{
	"TCP": 0,
	"UDP": 1,
}

func (x Endpoint_Protocol) String() string {
	return proto.EnumName(Endpoint_Protocol_name, int32(x))
}
func (Endpoint_Protocol) EnumDescriptor() ([]byte, []int) { return fileDescriptorTypes, []int{16, 0} }

// Version tracks the last time an object in the store was updated.
type Version struct {
	Index uint64 `protobuf:"varint,1,opt,name=index,proto3" json:"index,omitempty"`
}

func (m *Version) Reset()                    { *m = Version{} }
func (*Version) ProtoMessage()               {}
func (*Version) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{0} }

type Resources struct {
	// Amount of CPUs (e.g. 2000000000 = 2 CPU cores)
	NanoCPUs int64 `protobuf:"varint,1,opt,name=nano_cpus,json=nanoCpus,proto3" json:"nano_cpus,omitempty"`
	// Amount of memory in bytes.
	MemoryBytes int64 `protobuf:"varint,2,opt,name=memory_bytes,json=memoryBytes,proto3" json:"memory_bytes,omitempty"`
}

func (m *Resources) Reset()                    { *m = Resources{} }
func (*Resources) ProtoMessage()               {}
func (*Resources) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{1} }

type ResourceRequirements struct {
	Limits       *Resources `protobuf:"bytes,1,opt,name=limits" json:"limits,omitempty"`
	Reservations *Resources `protobuf:"bytes,2,opt,name=reservations" json:"reservations,omitempty"`
}

func (m *ResourceRequirements) Reset()                    { *m = ResourceRequirements{} }
func (*ResourceRequirements) ProtoMessage()               {}
func (*ResourceRequirements) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{2} }

type Platform struct {
	// Architecture (e.g. x86_64)
	Architecture string `protobuf:"bytes,1,opt,name=architecture,proto3" json:"architecture,omitempty"`
	// Operating System (e.g. linux)
	OS string `protobuf:"bytes,2,opt,name=os,proto3" json:"os,omitempty"`
}

func (m *Platform) Reset()                    { *m = Platform{} }
func (*Platform) ProtoMessage()               {}
func (*Platform) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{3} }

type NodeDescription struct {
	// Hostname of the node as reported by the agent.
	// This is different from spec.meta.name which is user-defined.
	Hostname string `protobuf:"bytes,1,opt,name=hostname,proto3" json:"hostname,omitempty"`
	// Platform of the node.
	Platform *Platform `protobuf:"bytes,2,opt,name=platform" json:"platform,omitempty"`
	// Total resources of the node.
	Resources *Resources `protobuf:"bytes,3,opt,name=resources" json:"resources,omitempty"`
}

func (m *NodeDescription) Reset()                    { *m = NodeDescription{} }
func (*NodeDescription) ProtoMessage()               {}
func (*NodeDescription) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{4} }

type MemberDescription struct {
	// Name of the node
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Cluster the member belongs to
	Cluster string `protobuf:"bytes,2,opt,name=cluster,proto3" json:"cluster,omitempty"`
}

func (m *MemberDescription) Reset()                    { *m = MemberDescription{} }
func (*MemberDescription) ProtoMessage()               {}
func (*MemberDescription) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{5} }

// RaftNode represents a raft node to be added or removed from
// an existing raft cluster
// TODO(stevvooe): Merge with MemberDescription.
type RaftNode struct {
	ID   uint64 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	Addr string `protobuf:"bytes,2,opt,name=addr,proto3" json:"addr,omitempty"`
}

func (m *RaftNode) Reset()                    { *m = RaftNode{} }
func (*RaftNode) ProtoMessage()               {}
func (*RaftNode) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{6} }

type MemberStatus struct {
	Leader  bool               `protobuf:"varint,1,opt,name=leader,proto3" json:"leader,omitempty"`
	State   MemberStatus_State `protobuf:"varint,2,opt,name=state,proto3,enum=docker.cluster.api.MemberStatus_State" json:"state,omitempty"`
	Message string             `protobuf:"bytes,3,opt,name=message,proto3" json:"message,omitempty"`
}

func (m *MemberStatus) Reset()                    { *m = MemberStatus{} }
func (*MemberStatus) ProtoMessage()               {}
func (*MemberStatus) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{7} }

type NodeStatus struct {
	State   NodeStatus_State `protobuf:"varint,1,opt,name=state,proto3,enum=docker.cluster.api.NodeStatus_State" json:"state,omitempty"`
	Message string           `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
}

func (m *NodeStatus) Reset()                    { *m = NodeStatus{} }
func (*NodeStatus) ProtoMessage()               {}
func (*NodeStatus) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{8} }

type Image struct {
	// reference is a docker image reference. This can include a rpository, tag
	// or be fully qualified witha digest. The format is specified in the
	// distribution/reference package.
	Reference string `protobuf:"bytes,1,opt,name=reference,proto3" json:"reference,omitempty"`
}

func (m *Image) Reset()                    { *m = Image{} }
func (*Image) ProtoMessage()               {}
func (*Image) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{9} }

type Mount struct {
	// Target path in container
	Target string `protobuf:"bytes,1,opt,name=target,proto3" json:"target,omitempty"`
	// Source path to mount
	Source string     `protobuf:"bytes,2,opt,name=source,proto3" json:"source,omitempty"`
	Mask   Mount_Mask `protobuf:"varint,3,opt,name=mask,proto3,enum=docker.cluster.api.Mount_Mask" json:"mask,omitempty"`
	Type   Mount_Type `protobuf:"varint,4,opt,name=type,proto3,enum=docker.cluster.api.Mount_Type" json:"type,omitempty"`
	// Source path to mount
	VolumeName string `protobuf:"bytes,5,opt,name=volume_name,json=volumeName,proto3" json:"volume_name,omitempty"`
}

func (m *Mount) Reset()                    { *m = Mount{} }
func (*Mount) ProtoMessage()               {}
func (*Mount) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{10} }

// Container specifies runtime parameters for a container.
type Container struct {
	// Resource requirements for the container.
	Resources *ResourceRequirements `protobuf:"bytes,1,opt,name=resources" json:"resources,omitempty"`
	Image     *Image                `protobuf:"bytes,2,opt,name=image" json:"image,omitempty"`
	// Command to run the the container. The first element is a path to the
	// executable and the following elements are treated as arguments.
	//
	// If command is empty, execution will fall back to the image's entrypoint.
	Command []string `protobuf:"bytes,3,rep,name=command" json:"command,omitempty"`
	// Args specifies arguments provided to the image's entrypoint.
	// Ignored if command is specified.
	Args []string `protobuf:"bytes,4,rep,name=args" json:"args,omitempty"`
	// Env specifies the environment variables for the container in NAME=VALUE
	// format. These must be compliant with  [IEEE Std
	// 1003.1-2001](http://pubs.opengroup.org/onlinepubs/009695399/basedefs/xbd_chap08.html).
	Env []string `protobuf:"bytes,5,rep,name=env" json:"env,omitempty"`
	// Dir defines the working directory to set for the container process.
	Dir string `protobuf:"bytes,6,opt,name=dir,proto3" json:"dir,omitempty"`
	// User specifies the user that should be employed to run the container.
	User     string                         `protobuf:"bytes,7,opt,name=user,proto3" json:"user,omitempty"`
	Networks []*Container_NetworkAttachment `protobuf:"bytes,8,rep,name=networks" json:"networks,omitempty"`
	Mounts   []*Mount                       `protobuf:"bytes,9,rep,name=mounts" json:"mounts,omitempty"`
}

func (m *Container) Reset()                    { *m = Container{} }
func (*Container) ProtoMessage()               {}
func (*Container) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{11} }

// NetworkAttachmentSpec describes a desired attachment to the named network or
// a specific network_id.
type Container_NetworkAttachment struct {
	// Types that are valid to be assigned to Reference:
	//	*Container_NetworkAttachment_Name
	//	*Container_NetworkAttachment_NetworkID
	Reference isContainer_NetworkAttachment_Reference `protobuf_oneof:"reference"`
}

func (m *Container_NetworkAttachment) Reset()      { *m = Container_NetworkAttachment{} }
func (*Container_NetworkAttachment) ProtoMessage() {}
func (*Container_NetworkAttachment) Descriptor() ([]byte, []int) {
	return fileDescriptorTypes, []int{11, 0}
}

type isContainer_NetworkAttachment_Reference interface {
	isContainer_NetworkAttachment_Reference()
	MarshalTo([]byte) (int, error)
	Size() int
}

type Container_NetworkAttachment_Name struct {
	Name string `protobuf:"bytes,1,opt,name=name,proto3,oneof"`
}
type Container_NetworkAttachment_NetworkID struct {
	NetworkID string `protobuf:"bytes,2,opt,name=network_id,json=networkId,proto3,oneof"`
}

func (*Container_NetworkAttachment_Name) isContainer_NetworkAttachment_Reference()      {}
func (*Container_NetworkAttachment_NetworkID) isContainer_NetworkAttachment_Reference() {}

func (m *Container_NetworkAttachment) GetReference() isContainer_NetworkAttachment_Reference {
	if m != nil {
		return m.Reference
	}
	return nil
}

func (m *Container_NetworkAttachment) GetName() string {
	if x, ok := m.GetReference().(*Container_NetworkAttachment_Name); ok {
		return x.Name
	}
	return ""
}

func (m *Container_NetworkAttachment) GetNetworkID() string {
	if x, ok := m.GetReference().(*Container_NetworkAttachment_NetworkID); ok {
		return x.NetworkID
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Container_NetworkAttachment) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Container_NetworkAttachment_OneofMarshaler, _Container_NetworkAttachment_OneofUnmarshaler, _Container_NetworkAttachment_OneofSizer, []interface{}{
		(*Container_NetworkAttachment_Name)(nil),
		(*Container_NetworkAttachment_NetworkID)(nil),
	}
}

func _Container_NetworkAttachment_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Container_NetworkAttachment)
	// reference
	switch x := m.Reference.(type) {
	case *Container_NetworkAttachment_Name:
		_ = b.EncodeVarint(1<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.Name)
	case *Container_NetworkAttachment_NetworkID:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.NetworkID)
	case nil:
	default:
		return fmt.Errorf("Container_NetworkAttachment.Reference has unexpected type %T", x)
	}
	return nil
}

func _Container_NetworkAttachment_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Container_NetworkAttachment)
	switch tag {
	case 1: // reference.name
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Reference = &Container_NetworkAttachment_Name{x}
		return true, err
	case 2: // reference.network_id
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Reference = &Container_NetworkAttachment_NetworkID{x}
		return true, err
	default:
		return false, nil
	}
}

func _Container_NetworkAttachment_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Container_NetworkAttachment)
	// reference
	switch x := m.Reference.(type) {
	case *Container_NetworkAttachment_Name:
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.Name)))
		n += len(x.Name)
	case *Container_NetworkAttachment_NetworkID:
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.NetworkID)))
		n += len(x.NetworkID)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type RestartPolicy struct {
	Condition RestartPolicy_RestartCondition `protobuf:"varint,1,opt,name=condition,proto3,enum=docker.cluster.api.RestartPolicy_RestartCondition" json:"condition,omitempty"`
	// Delay between restart attempts
	Delay time.Duration `protobuf:"varint,2,opt,name=delay,proto3,customtype=time.Duration" json:"delay"`
}

func (m *RestartPolicy) Reset()                    { *m = RestartPolicy{} }
func (*RestartPolicy) ProtoMessage()               {}
func (*RestartPolicy) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{12} }

// UpdateStrategy specifies the rate and policy of updates.
// TODO(aluzzardi): Consider making this a oneof with RollingStrategy and LockstepStrategy.
type UpdateStrategy struct {
	// Maximum number of tasks to be updated in one iteration.
	// 0 means unlimited parallelism.
	Parallelism uint64 `protobuf:"varint,1,opt,name=parallelism,proto3" json:"parallelism,omitempty"`
	// Amount of time between updates.
	Delay time.Duration `protobuf:"varint,2,opt,name=delay,proto3,customtype=time.Duration" json:"delay"`
}

func (m *UpdateStrategy) Reset()                    { *m = UpdateStrategy{} }
func (*UpdateStrategy) ProtoMessage()               {}
func (*UpdateStrategy) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{13} }

type TaskStatus struct {
	Timestamp *docker_cluster_api.Timestamp `protobuf:"bytes,1,opt,name=timestamp" json:"timestamp,omitempty"`
	// State expresses the current state of the task.
	State TaskState `protobuf:"varint,2,opt,name=state,proto3,enum=docker.cluster.api.TaskState" json:"state,omitempty"`
	// TerminalState indicates the state which led to the task stopping,
	// i.e Rejected, Complete or Failed. If the task is not in a terminal
	// state, this is set to New (0).
	TerminalState TaskState `protobuf:"varint,3,opt,name=terminal_state,json=terminalState,proto3,enum=docker.cluster.api.TaskState" json:"terminal_state,omitempty"`
	// Message reports a message for the task status. This should provide a
	// human readable message that can point to how the task actually arrived
	// at a current state.
	//
	// As a convention, we place the a small message here that led to the
	// current state. For example, if the task is in ready, because it was
	// prepared, we'd place "prepared" in this field. If we skipped preparation
	// because the task is prepared, we would put "already prepared" in this
	// field.
	Message string `protobuf:"bytes,4,opt,name=message,proto3" json:"message,omitempty"`
	// Err is set if the task is in an error state.
	//
	// The following states should report a companion error:
	//
	// 	FAILED, REJECTED
	//
	// TODO(stevvooe) Integrate this field with the error interface.
	Err string `protobuf:"bytes,5,opt,name=err,proto3" json:"err,omitempty"`
}

func (m *TaskStatus) Reset()                    { *m = TaskStatus{} }
func (*TaskStatus) ProtoMessage()               {}
func (*TaskStatus) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{14} }

// IPAMConfiguration specifies parameters for IP Address Management.
type IPAMConfiguration struct {
	Family IPAMConfiguration_AddressFamily `protobuf:"varint,1,opt,name=family,proto3,enum=docker.cluster.api.IPAMConfiguration_AddressFamily" json:"family,omitempty"`
	// Subnet defines a network as a CIDR address (ie network and mask
	// 192.168.0.1/24).
	Subnet string `protobuf:"bytes,2,opt,name=subnet,proto3" json:"subnet,omitempty"`
	// Range defines the portion of the subnet to allocate to tasks. This is
	// defined as a subnet within the primary subnet.
	Range string `protobuf:"bytes,3,opt,name=range,proto3" json:"range,omitempty"`
	// Gateway address within the subnet.
	Gateway string `protobuf:"bytes,4,opt,name=gateway,proto3" json:"gateway,omitempty"`
	// Reserved is a list of address from the master pool that should *not* be
	// allocated. These addresses may have already been allocated or may be
	// reserved for another allocation manager.
	Reserved map[string]string `protobuf:"bytes,5,rep,name=reserved" json:"reserved,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (m *IPAMConfiguration) Reset()                    { *m = IPAMConfiguration{} }
func (*IPAMConfiguration) ProtoMessage()               {}
func (*IPAMConfiguration) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{15} }

// Endpoint specified all the network parameters required to
// correctly discover and load balance a service
type Endpoint struct {
	// A virtual IP is used to address this service in IP layer
	// that the client can use to send requests to this service. A
	// DNS A/AAAA query on the service name might return this IP
	// to the client. This is strictly a logical IP and there may
	// not be any interfaces assigned this IP address or any route
	// created for this address.  More than one to accomodate for
	// both IPv4 and IPv6
	VirtualIP []string                      `protobuf:"bytes,1,rep,name=virtual_ip,json=virtualIp" json:"virtual_ip,omitempty"`
	Ports     []*Endpoint_PortConfiguration `protobuf:"bytes,2,rep,name=ports" json:"ports,omitempty"`
}

func (m *Endpoint) Reset()                    { *m = Endpoint{} }
func (*Endpoint) ProtoMessage()               {}
func (*Endpoint) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{16} }

// PortConfiguration specifies an exposed port which can be
// addressed using the given name. This can be later queried
// using a service discovery api or a DNS SRV query. The node
// port specifies a port that can be used to address this
// service external to the cluster by sending a connection
// request to this port to any node on the cluster.
type Endpoint_PortConfiguration struct {
	// Name for the port. If provided the port information can
	// be queried using the name as in a DNS SRV query.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The port which the application is exposing and is bound to.
	Port uint32 `protobuf:"varint,2,opt,name=port,proto3" json:"port,omitempty"`
	// Protocol for the port which is exposed.
	Protocol Endpoint_Protocol `protobuf:"varint,3,opt,name=protocol,proto3,enum=docker.cluster.api.Endpoint_Protocol" json:"protocol,omitempty"`
	// A cluster-wide unique port which is assigned to
	// this port configuration of the service used for
	// requests ingressing into the cluster for this
	// service port.
	NodePort uint32 `protobuf:"varint,4,opt,name=node_port,json=nodePort,proto3" json:"node_port,omitempty"`
}

func (m *Endpoint_PortConfiguration) Reset()      { *m = Endpoint_PortConfiguration{} }
func (*Endpoint_PortConfiguration) ProtoMessage() {}
func (*Endpoint_PortConfiguration) Descriptor() ([]byte, []int) {
	return fileDescriptorTypes, []int{16, 0}
}

// Driver is a generic driver type to be used throughout the API. For now, a
// driver is simply a name and set of options. The field contents depend on the
// target use case and driver application. For example, a network driver may
// have different rules than a volume driver.
type Driver struct {
	Name    string            `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Options map[string]string `protobuf:"bytes,2,rep,name=options" json:"options,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (m *Driver) Reset()                    { *m = Driver{} }
func (*Driver) ProtoMessage()               {}
func (*Driver) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{17} }

type IPAMOptions struct {
	Driver         *Driver              `protobuf:"bytes,1,opt,name=driver" json:"driver,omitempty"`
	Configurations []*IPAMConfiguration `protobuf:"bytes,3,rep,name=configurations" json:"configurations,omitempty"`
}

func (m *IPAMOptions) Reset()                    { *m = IPAMOptions{} }
func (*IPAMOptions) ProtoMessage()               {}
func (*IPAMOptions) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{18} }

// WeightedPeer should be used anywhere where we are describing a remote peer
// with a weight.
type WeightedPeer struct {
	Addr   string `protobuf:"bytes,1,opt,name=addr,proto3" json:"addr,omitempty"`
	Weight int64  `protobuf:"varint,2,opt,name=weight,proto3" json:"weight,omitempty"`
}

func (m *WeightedPeer) Reset()                    { *m = WeightedPeer{} }
func (*WeightedPeer) ProtoMessage()               {}
func (*WeightedPeer) Descriptor() ([]byte, []int) { return fileDescriptorTypes, []int{19} }

func init() {
	proto.RegisterType((*Version)(nil), "docker.cluster.api.Version")
	proto.RegisterType((*Resources)(nil), "docker.cluster.api.Resources")
	proto.RegisterType((*ResourceRequirements)(nil), "docker.cluster.api.ResourceRequirements")
	proto.RegisterType((*Platform)(nil), "docker.cluster.api.Platform")
	proto.RegisterType((*NodeDescription)(nil), "docker.cluster.api.NodeDescription")
	proto.RegisterType((*MemberDescription)(nil), "docker.cluster.api.MemberDescription")
	proto.RegisterType((*RaftNode)(nil), "docker.cluster.api.RaftNode")
	proto.RegisterType((*MemberStatus)(nil), "docker.cluster.api.MemberStatus")
	proto.RegisterType((*NodeStatus)(nil), "docker.cluster.api.NodeStatus")
	proto.RegisterType((*Image)(nil), "docker.cluster.api.Image")
	proto.RegisterType((*Mount)(nil), "docker.cluster.api.Mount")
	proto.RegisterType((*Container)(nil), "docker.cluster.api.Container")
	proto.RegisterType((*Container_NetworkAttachment)(nil), "docker.cluster.api.Container.NetworkAttachment")
	proto.RegisterType((*RestartPolicy)(nil), "docker.cluster.api.RestartPolicy")
	proto.RegisterType((*UpdateStrategy)(nil), "docker.cluster.api.UpdateStrategy")
	proto.RegisterType((*TaskStatus)(nil), "docker.cluster.api.TaskStatus")
	proto.RegisterType((*IPAMConfiguration)(nil), "docker.cluster.api.IPAMConfiguration")
	proto.RegisterType((*Endpoint)(nil), "docker.cluster.api.Endpoint")
	proto.RegisterType((*Endpoint_PortConfiguration)(nil), "docker.cluster.api.Endpoint.PortConfiguration")
	proto.RegisterType((*Driver)(nil), "docker.cluster.api.Driver")
	proto.RegisterType((*IPAMOptions)(nil), "docker.cluster.api.IPAMOptions")
	proto.RegisterType((*WeightedPeer)(nil), "docker.cluster.api.WeightedPeer")
	proto.RegisterEnum("docker.cluster.api.TaskState", TaskState_name, TaskState_value)
	proto.RegisterEnum("docker.cluster.api.MemberStatus_State", MemberStatus_State_name, MemberStatus_State_value)
	proto.RegisterEnum("docker.cluster.api.NodeStatus_State", NodeStatus_State_name, NodeStatus_State_value)
	proto.RegisterEnum("docker.cluster.api.Mount_Mask", Mount_Mask_name, Mount_Mask_value)
	proto.RegisterEnum("docker.cluster.api.Mount_Type", Mount_Type_name, Mount_Type_value)
	proto.RegisterEnum("docker.cluster.api.RestartPolicy_RestartCondition", RestartPolicy_RestartCondition_name, RestartPolicy_RestartCondition_value)
	proto.RegisterEnum("docker.cluster.api.IPAMConfiguration_AddressFamily", IPAMConfiguration_AddressFamily_name, IPAMConfiguration_AddressFamily_value)
	proto.RegisterEnum("docker.cluster.api.Endpoint_Protocol", Endpoint_Protocol_name, Endpoint_Protocol_value)
}

func (m *Version) Copy() *Version {
	if m == nil {
		return nil
	}

	o := &Version{
		Index: m.Index,
	}

	return o
}

func (m *Resources) Copy() *Resources {
	if m == nil {
		return nil
	}

	o := &Resources{
		NanoCPUs:    m.NanoCPUs,
		MemoryBytes: m.MemoryBytes,
	}

	return o
}

func (m *ResourceRequirements) Copy() *ResourceRequirements {
	if m == nil {
		return nil
	}

	o := &ResourceRequirements{
		Limits:       m.Limits.Copy(),
		Reservations: m.Reservations.Copy(),
	}

	return o
}

func (m *Platform) Copy() *Platform {
	if m == nil {
		return nil
	}

	o := &Platform{
		Architecture: m.Architecture,
		OS:           m.OS,
	}

	return o
}

func (m *NodeDescription) Copy() *NodeDescription {
	if m == nil {
		return nil
	}

	o := &NodeDescription{
		Hostname:  m.Hostname,
		Platform:  m.Platform.Copy(),
		Resources: m.Resources.Copy(),
	}

	return o
}

func (m *MemberDescription) Copy() *MemberDescription {
	if m == nil {
		return nil
	}

	o := &MemberDescription{
		Name:    m.Name,
		Cluster: m.Cluster,
	}

	return o
}

func (m *RaftNode) Copy() *RaftNode {
	if m == nil {
		return nil
	}

	o := &RaftNode{
		ID:   m.ID,
		Addr: m.Addr,
	}

	return o
}

func (m *MemberStatus) Copy() *MemberStatus {
	if m == nil {
		return nil
	}

	o := &MemberStatus{
		Leader:  m.Leader,
		State:   m.State,
		Message: m.Message,
	}

	return o
}

func (m *NodeStatus) Copy() *NodeStatus {
	if m == nil {
		return nil
	}

	o := &NodeStatus{
		State:   m.State,
		Message: m.Message,
	}

	return o
}

func (m *Image) Copy() *Image {
	if m == nil {
		return nil
	}

	o := &Image{
		Reference: m.Reference,
	}

	return o
}

func (m *Mount) Copy() *Mount {
	if m == nil {
		return nil
	}

	o := &Mount{
		Target:     m.Target,
		Source:     m.Source,
		Mask:       m.Mask,
		Type:       m.Type,
		VolumeName: m.VolumeName,
	}

	return o
}

func (m *Container) Copy() *Container {
	if m == nil {
		return nil
	}

	o := &Container{
		Resources: m.Resources.Copy(),
		Image:     m.Image.Copy(),
		Dir:       m.Dir,
		User:      m.User,
	}

	if m.Command != nil {
		o.Command = make([]string, 0, len(m.Command))
		for _, v := range m.Command {
			o.Command = append(o.Command, v)
		}
	}

	if m.Args != nil {
		o.Args = make([]string, 0, len(m.Args))
		for _, v := range m.Args {
			o.Args = append(o.Args, v)
		}
	}

	if m.Env != nil {
		o.Env = make([]string, 0, len(m.Env))
		for _, v := range m.Env {
			o.Env = append(o.Env, v)
		}
	}

	if m.Networks != nil {
		o.Networks = make([]*Container_NetworkAttachment, 0, len(m.Networks))
		for _, v := range m.Networks {
			o.Networks = append(o.Networks, v.Copy())
		}
	}

	if m.Mounts != nil {
		o.Mounts = make([]*Mount, 0, len(m.Mounts))
		for _, v := range m.Mounts {
			o.Mounts = append(o.Mounts, v.Copy())
		}
	}

	return o
}

func (m *Container_NetworkAttachment) Copy() *Container_NetworkAttachment {
	if m == nil {
		return nil
	}

	o := &Container_NetworkAttachment{}

	switch m.Reference.(type) {
	case *Container_NetworkAttachment_Name:
		i := &Container_NetworkAttachment_Name{
			Name: m.GetName(),
		}

		o.Reference = i
	case *Container_NetworkAttachment_NetworkID:
		i := &Container_NetworkAttachment_NetworkID{
			NetworkID: m.GetNetworkID(),
		}

		o.Reference = i
	}

	return o
}

func (m *RestartPolicy) Copy() *RestartPolicy {
	if m == nil {
		return nil
	}

	o := &RestartPolicy{
		Condition: m.Condition,
		Delay:     m.Delay,
	}

	return o
}

func (m *UpdateStrategy) Copy() *UpdateStrategy {
	if m == nil {
		return nil
	}

	o := &UpdateStrategy{
		Parallelism: m.Parallelism,
		Delay:       m.Delay,
	}

	return o
}

func (m *TaskStatus) Copy() *TaskStatus {
	if m == nil {
		return nil
	}

	o := &TaskStatus{
		Timestamp:     m.Timestamp.Copy(),
		State:         m.State,
		TerminalState: m.TerminalState,
		Message:       m.Message,
		Err:           m.Err,
	}

	return o
}

func (m *IPAMConfiguration) Copy() *IPAMConfiguration {
	if m == nil {
		return nil
	}

	o := &IPAMConfiguration{
		Family:  m.Family,
		Subnet:  m.Subnet,
		Range:   m.Range,
		Gateway: m.Gateway,
	}

	if m.Reserved != nil {
		o.Reserved = make(map[string]string)
		for k, v := range m.Reserved {
			o.Reserved[k] = v
		}
	}

	return o
}

func (m *Endpoint) Copy() *Endpoint {
	if m == nil {
		return nil
	}

	o := &Endpoint{}

	if m.VirtualIP != nil {
		o.VirtualIP = make([]string, 0, len(m.VirtualIP))
		for _, v := range m.VirtualIP {
			o.VirtualIP = append(o.VirtualIP, v)
		}
	}

	if m.Ports != nil {
		o.Ports = make([]*Endpoint_PortConfiguration, 0, len(m.Ports))
		for _, v := range m.Ports {
			o.Ports = append(o.Ports, v.Copy())
		}
	}

	return o
}

func (m *Endpoint_PortConfiguration) Copy() *Endpoint_PortConfiguration {
	if m == nil {
		return nil
	}

	o := &Endpoint_PortConfiguration{
		Name:     m.Name,
		Port:     m.Port,
		Protocol: m.Protocol,
		NodePort: m.NodePort,
	}

	return o
}

func (m *Driver) Copy() *Driver {
	if m == nil {
		return nil
	}

	o := &Driver{
		Name: m.Name,
	}

	if m.Options != nil {
		o.Options = make(map[string]string)
		for k, v := range m.Options {
			o.Options[k] = v
		}
	}

	return o
}

func (m *IPAMOptions) Copy() *IPAMOptions {
	if m == nil {
		return nil
	}

	o := &IPAMOptions{
		Driver: m.Driver.Copy(),
	}

	if m.Configurations != nil {
		o.Configurations = make([]*IPAMConfiguration, 0, len(m.Configurations))
		for _, v := range m.Configurations {
			o.Configurations = append(o.Configurations, v.Copy())
		}
	}

	return o
}

func (m *WeightedPeer) Copy() *WeightedPeer {
	if m == nil {
		return nil
	}

	o := &WeightedPeer{
		Addr:   m.Addr,
		Weight: m.Weight,
	}

	return o
}

func (this *Version) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&api.Version{")
	s = append(s, "Index: "+fmt.Sprintf("%#v", this.Index)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Resources) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&api.Resources{")
	s = append(s, "NanoCPUs: "+fmt.Sprintf("%#v", this.NanoCPUs)+",\n")
	s = append(s, "MemoryBytes: "+fmt.Sprintf("%#v", this.MemoryBytes)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ResourceRequirements) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&api.ResourceRequirements{")
	if this.Limits != nil {
		s = append(s, "Limits: "+fmt.Sprintf("%#v", this.Limits)+",\n")
	}
	if this.Reservations != nil {
		s = append(s, "Reservations: "+fmt.Sprintf("%#v", this.Reservations)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Platform) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&api.Platform{")
	s = append(s, "Architecture: "+fmt.Sprintf("%#v", this.Architecture)+",\n")
	s = append(s, "OS: "+fmt.Sprintf("%#v", this.OS)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *NodeDescription) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&api.NodeDescription{")
	s = append(s, "Hostname: "+fmt.Sprintf("%#v", this.Hostname)+",\n")
	if this.Platform != nil {
		s = append(s, "Platform: "+fmt.Sprintf("%#v", this.Platform)+",\n")
	}
	if this.Resources != nil {
		s = append(s, "Resources: "+fmt.Sprintf("%#v", this.Resources)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *MemberDescription) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&api.MemberDescription{")
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	s = append(s, "Cluster: "+fmt.Sprintf("%#v", this.Cluster)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *RaftNode) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&api.RaftNode{")
	s = append(s, "ID: "+fmt.Sprintf("%#v", this.ID)+",\n")
	s = append(s, "Addr: "+fmt.Sprintf("%#v", this.Addr)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *MemberStatus) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&api.MemberStatus{")
	s = append(s, "Leader: "+fmt.Sprintf("%#v", this.Leader)+",\n")
	s = append(s, "State: "+fmt.Sprintf("%#v", this.State)+",\n")
	s = append(s, "Message: "+fmt.Sprintf("%#v", this.Message)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *NodeStatus) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&api.NodeStatus{")
	s = append(s, "State: "+fmt.Sprintf("%#v", this.State)+",\n")
	s = append(s, "Message: "+fmt.Sprintf("%#v", this.Message)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Image) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&api.Image{")
	s = append(s, "Reference: "+fmt.Sprintf("%#v", this.Reference)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Mount) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&api.Mount{")
	s = append(s, "Target: "+fmt.Sprintf("%#v", this.Target)+",\n")
	s = append(s, "Source: "+fmt.Sprintf("%#v", this.Source)+",\n")
	s = append(s, "Mask: "+fmt.Sprintf("%#v", this.Mask)+",\n")
	s = append(s, "Type: "+fmt.Sprintf("%#v", this.Type)+",\n")
	s = append(s, "VolumeName: "+fmt.Sprintf("%#v", this.VolumeName)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Container) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 13)
	s = append(s, "&api.Container{")
	if this.Resources != nil {
		s = append(s, "Resources: "+fmt.Sprintf("%#v", this.Resources)+",\n")
	}
	if this.Image != nil {
		s = append(s, "Image: "+fmt.Sprintf("%#v", this.Image)+",\n")
	}
	s = append(s, "Command: "+fmt.Sprintf("%#v", this.Command)+",\n")
	s = append(s, "Args: "+fmt.Sprintf("%#v", this.Args)+",\n")
	s = append(s, "Env: "+fmt.Sprintf("%#v", this.Env)+",\n")
	s = append(s, "Dir: "+fmt.Sprintf("%#v", this.Dir)+",\n")
	s = append(s, "User: "+fmt.Sprintf("%#v", this.User)+",\n")
	if this.Networks != nil {
		s = append(s, "Networks: "+fmt.Sprintf("%#v", this.Networks)+",\n")
	}
	if this.Mounts != nil {
		s = append(s, "Mounts: "+fmt.Sprintf("%#v", this.Mounts)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Container_NetworkAttachment) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&api.Container_NetworkAttachment{")
	if this.Reference != nil {
		s = append(s, "Reference: "+fmt.Sprintf("%#v", this.Reference)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Container_NetworkAttachment_Name) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&api.Container_NetworkAttachment_Name{` +
		`Name:` + fmt.Sprintf("%#v", this.Name) + `}`}, ", ")
	return s
}
func (this *Container_NetworkAttachment_NetworkID) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&api.Container_NetworkAttachment_NetworkID{` +
		`NetworkID:` + fmt.Sprintf("%#v", this.NetworkID) + `}`}, ", ")
	return s
}
func (this *RestartPolicy) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&api.RestartPolicy{")
	s = append(s, "Condition: "+fmt.Sprintf("%#v", this.Condition)+",\n")
	s = append(s, "Delay: "+fmt.Sprintf("%#v", this.Delay)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *UpdateStrategy) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&api.UpdateStrategy{")
	s = append(s, "Parallelism: "+fmt.Sprintf("%#v", this.Parallelism)+",\n")
	s = append(s, "Delay: "+fmt.Sprintf("%#v", this.Delay)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *TaskStatus) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&api.TaskStatus{")
	if this.Timestamp != nil {
		s = append(s, "Timestamp: "+fmt.Sprintf("%#v", this.Timestamp)+",\n")
	}
	s = append(s, "State: "+fmt.Sprintf("%#v", this.State)+",\n")
	s = append(s, "TerminalState: "+fmt.Sprintf("%#v", this.TerminalState)+",\n")
	s = append(s, "Message: "+fmt.Sprintf("%#v", this.Message)+",\n")
	s = append(s, "Err: "+fmt.Sprintf("%#v", this.Err)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *IPAMConfiguration) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&api.IPAMConfiguration{")
	s = append(s, "Family: "+fmt.Sprintf("%#v", this.Family)+",\n")
	s = append(s, "Subnet: "+fmt.Sprintf("%#v", this.Subnet)+",\n")
	s = append(s, "Range: "+fmt.Sprintf("%#v", this.Range)+",\n")
	s = append(s, "Gateway: "+fmt.Sprintf("%#v", this.Gateway)+",\n")
	keysForReserved := make([]string, 0, len(this.Reserved))
	for k, _ := range this.Reserved {
		keysForReserved = append(keysForReserved, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForReserved)
	mapStringForReserved := "map[string]string{"
	for _, k := range keysForReserved {
		mapStringForReserved += fmt.Sprintf("%#v: %#v,", k, this.Reserved[k])
	}
	mapStringForReserved += "}"
	if this.Reserved != nil {
		s = append(s, "Reserved: "+mapStringForReserved+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Endpoint) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&api.Endpoint{")
	s = append(s, "VirtualIP: "+fmt.Sprintf("%#v", this.VirtualIP)+",\n")
	if this.Ports != nil {
		s = append(s, "Ports: "+fmt.Sprintf("%#v", this.Ports)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Endpoint_PortConfiguration) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&api.Endpoint_PortConfiguration{")
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	s = append(s, "Port: "+fmt.Sprintf("%#v", this.Port)+",\n")
	s = append(s, "Protocol: "+fmt.Sprintf("%#v", this.Protocol)+",\n")
	s = append(s, "NodePort: "+fmt.Sprintf("%#v", this.NodePort)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Driver) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&api.Driver{")
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	keysForOptions := make([]string, 0, len(this.Options))
	for k, _ := range this.Options {
		keysForOptions = append(keysForOptions, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForOptions)
	mapStringForOptions := "map[string]string{"
	for _, k := range keysForOptions {
		mapStringForOptions += fmt.Sprintf("%#v: %#v,", k, this.Options[k])
	}
	mapStringForOptions += "}"
	if this.Options != nil {
		s = append(s, "Options: "+mapStringForOptions+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *IPAMOptions) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&api.IPAMOptions{")
	if this.Driver != nil {
		s = append(s, "Driver: "+fmt.Sprintf("%#v", this.Driver)+",\n")
	}
	if this.Configurations != nil {
		s = append(s, "Configurations: "+fmt.Sprintf("%#v", this.Configurations)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *WeightedPeer) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&api.WeightedPeer{")
	s = append(s, "Addr: "+fmt.Sprintf("%#v", this.Addr)+",\n")
	s = append(s, "Weight: "+fmt.Sprintf("%#v", this.Weight)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringTypes(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}
func extensionToGoStringTypes(e map[int32]github_com_gogo_protobuf_proto.Extension) string {
	if e == nil {
		return "nil"
	}
	s := "map[int32]proto.Extension{"
	keys := make([]int, 0, len(e))
	for k := range e {
		keys = append(keys, int(k))
	}
	sort.Ints(keys)
	ss := []string{}
	for _, k := range keys {
		ss = append(ss, strconv.Itoa(k)+": "+e[int32(k)].GoString())
	}
	s += strings.Join(ss, ",") + "}"
	return s
}
func (m *Version) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Version) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Index != 0 {
		data[i] = 0x8
		i++
		i = encodeVarintTypes(data, i, uint64(m.Index))
	}
	return i, nil
}

func (m *Resources) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Resources) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.NanoCPUs != 0 {
		data[i] = 0x8
		i++
		i = encodeVarintTypes(data, i, uint64(m.NanoCPUs))
	}
	if m.MemoryBytes != 0 {
		data[i] = 0x10
		i++
		i = encodeVarintTypes(data, i, uint64(m.MemoryBytes))
	}
	return i, nil
}

func (m *ResourceRequirements) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *ResourceRequirements) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Limits != nil {
		data[i] = 0xa
		i++
		i = encodeVarintTypes(data, i, uint64(m.Limits.Size()))
		n1, err := m.Limits.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if m.Reservations != nil {
		data[i] = 0x12
		i++
		i = encodeVarintTypes(data, i, uint64(m.Reservations.Size()))
		n2, err := m.Reservations.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	return i, nil
}

func (m *Platform) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Platform) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Architecture) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintTypes(data, i, uint64(len(m.Architecture)))
		i += copy(data[i:], m.Architecture)
	}
	if len(m.OS) > 0 {
		data[i] = 0x12
		i++
		i = encodeVarintTypes(data, i, uint64(len(m.OS)))
		i += copy(data[i:], m.OS)
	}
	return i, nil
}

func (m *NodeDescription) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *NodeDescription) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Hostname) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintTypes(data, i, uint64(len(m.Hostname)))
		i += copy(data[i:], m.Hostname)
	}
	if m.Platform != nil {
		data[i] = 0x12
		i++
		i = encodeVarintTypes(data, i, uint64(m.Platform.Size()))
		n3, err := m.Platform.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	if m.Resources != nil {
		data[i] = 0x1a
		i++
		i = encodeVarintTypes(data, i, uint64(m.Resources.Size()))
		n4, err := m.Resources.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	return i, nil
}

func (m *MemberDescription) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *MemberDescription) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintTypes(data, i, uint64(len(m.Name)))
		i += copy(data[i:], m.Name)
	}
	if len(m.Cluster) > 0 {
		data[i] = 0x12
		i++
		i = encodeVarintTypes(data, i, uint64(len(m.Cluster)))
		i += copy(data[i:], m.Cluster)
	}
	return i, nil
}

func (m *RaftNode) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *RaftNode) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.ID != 0 {
		data[i] = 0x8
		i++
		i = encodeVarintTypes(data, i, uint64(m.ID))
	}
	if len(m.Addr) > 0 {
		data[i] = 0x12
		i++
		i = encodeVarintTypes(data, i, uint64(len(m.Addr)))
		i += copy(data[i:], m.Addr)
	}
	return i, nil
}

func (m *MemberStatus) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *MemberStatus) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Leader {
		data[i] = 0x8
		i++
		if m.Leader {
			data[i] = 1
		} else {
			data[i] = 0
		}
		i++
	}
	if m.State != 0 {
		data[i] = 0x10
		i++
		i = encodeVarintTypes(data, i, uint64(m.State))
	}
	if len(m.Message) > 0 {
		data[i] = 0x1a
		i++
		i = encodeVarintTypes(data, i, uint64(len(m.Message)))
		i += copy(data[i:], m.Message)
	}
	return i, nil
}

func (m *NodeStatus) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *NodeStatus) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.State != 0 {
		data[i] = 0x8
		i++
		i = encodeVarintTypes(data, i, uint64(m.State))
	}
	if len(m.Message) > 0 {
		data[i] = 0x12
		i++
		i = encodeVarintTypes(data, i, uint64(len(m.Message)))
		i += copy(data[i:], m.Message)
	}
	return i, nil
}

func (m *Image) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Image) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Reference) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintTypes(data, i, uint64(len(m.Reference)))
		i += copy(data[i:], m.Reference)
	}
	return i, nil
}

func (m *Mount) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Mount) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Target) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintTypes(data, i, uint64(len(m.Target)))
		i += copy(data[i:], m.Target)
	}
	if len(m.Source) > 0 {
		data[i] = 0x12
		i++
		i = encodeVarintTypes(data, i, uint64(len(m.Source)))
		i += copy(data[i:], m.Source)
	}
	if m.Mask != 0 {
		data[i] = 0x18
		i++
		i = encodeVarintTypes(data, i, uint64(m.Mask))
	}
	if m.Type != 0 {
		data[i] = 0x20
		i++
		i = encodeVarintTypes(data, i, uint64(m.Type))
	}
	if len(m.VolumeName) > 0 {
		data[i] = 0x2a
		i++
		i = encodeVarintTypes(data, i, uint64(len(m.VolumeName)))
		i += copy(data[i:], m.VolumeName)
	}
	return i, nil
}

func (m *Container) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Container) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Resources != nil {
		data[i] = 0xa
		i++
		i = encodeVarintTypes(data, i, uint64(m.Resources.Size()))
		n5, err := m.Resources.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	if m.Image != nil {
		data[i] = 0x12
		i++
		i = encodeVarintTypes(data, i, uint64(m.Image.Size()))
		n6, err := m.Image.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	if len(m.Command) > 0 {
		for _, s := range m.Command {
			data[i] = 0x1a
			i++
			l = len(s)
			for l >= 1<<7 {
				data[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			data[i] = uint8(l)
			i++
			i += copy(data[i:], s)
		}
	}
	if len(m.Args) > 0 {
		for _, s := range m.Args {
			data[i] = 0x22
			i++
			l = len(s)
			for l >= 1<<7 {
				data[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			data[i] = uint8(l)
			i++
			i += copy(data[i:], s)
		}
	}
	if len(m.Env) > 0 {
		for _, s := range m.Env {
			data[i] = 0x2a
			i++
			l = len(s)
			for l >= 1<<7 {
				data[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			data[i] = uint8(l)
			i++
			i += copy(data[i:], s)
		}
	}
	if len(m.Dir) > 0 {
		data[i] = 0x32
		i++
		i = encodeVarintTypes(data, i, uint64(len(m.Dir)))
		i += copy(data[i:], m.Dir)
	}
	if len(m.User) > 0 {
		data[i] = 0x3a
		i++
		i = encodeVarintTypes(data, i, uint64(len(m.User)))
		i += copy(data[i:], m.User)
	}
	if len(m.Networks) > 0 {
		for _, msg := range m.Networks {
			data[i] = 0x42
			i++
			i = encodeVarintTypes(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Mounts) > 0 {
		for _, msg := range m.Mounts {
			data[i] = 0x4a
			i++
			i = encodeVarintTypes(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *Container_NetworkAttachment) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Container_NetworkAttachment) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Reference != nil {
		nn7, err := m.Reference.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += nn7
	}
	return i, nil
}

func (m *Container_NetworkAttachment_Name) MarshalTo(data []byte) (int, error) {
	i := 0
	data[i] = 0xa
	i++
	i = encodeVarintTypes(data, i, uint64(len(m.Name)))
	i += copy(data[i:], m.Name)
	return i, nil
}
func (m *Container_NetworkAttachment_NetworkID) MarshalTo(data []byte) (int, error) {
	i := 0
	data[i] = 0x12
	i++
	i = encodeVarintTypes(data, i, uint64(len(m.NetworkID)))
	i += copy(data[i:], m.NetworkID)
	return i, nil
}
func (m *RestartPolicy) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *RestartPolicy) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Condition != 0 {
		data[i] = 0x8
		i++
		i = encodeVarintTypes(data, i, uint64(m.Condition))
	}
	if m.Delay != 0 {
		data[i] = 0x10
		i++
		i = encodeVarintTypes(data, i, uint64(m.Delay))
	}
	return i, nil
}

func (m *UpdateStrategy) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *UpdateStrategy) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Parallelism != 0 {
		data[i] = 0x8
		i++
		i = encodeVarintTypes(data, i, uint64(m.Parallelism))
	}
	if m.Delay != 0 {
		data[i] = 0x10
		i++
		i = encodeVarintTypes(data, i, uint64(m.Delay))
	}
	return i, nil
}

func (m *TaskStatus) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *TaskStatus) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Timestamp != nil {
		data[i] = 0xa
		i++
		i = encodeVarintTypes(data, i, uint64(m.Timestamp.Size()))
		n8, err := m.Timestamp.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n8
	}
	if m.State != 0 {
		data[i] = 0x10
		i++
		i = encodeVarintTypes(data, i, uint64(m.State))
	}
	if m.TerminalState != 0 {
		data[i] = 0x18
		i++
		i = encodeVarintTypes(data, i, uint64(m.TerminalState))
	}
	if len(m.Message) > 0 {
		data[i] = 0x22
		i++
		i = encodeVarintTypes(data, i, uint64(len(m.Message)))
		i += copy(data[i:], m.Message)
	}
	if len(m.Err) > 0 {
		data[i] = 0x2a
		i++
		i = encodeVarintTypes(data, i, uint64(len(m.Err)))
		i += copy(data[i:], m.Err)
	}
	return i, nil
}

func (m *IPAMConfiguration) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *IPAMConfiguration) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Family != 0 {
		data[i] = 0x8
		i++
		i = encodeVarintTypes(data, i, uint64(m.Family))
	}
	if len(m.Subnet) > 0 {
		data[i] = 0x12
		i++
		i = encodeVarintTypes(data, i, uint64(len(m.Subnet)))
		i += copy(data[i:], m.Subnet)
	}
	if len(m.Range) > 0 {
		data[i] = 0x1a
		i++
		i = encodeVarintTypes(data, i, uint64(len(m.Range)))
		i += copy(data[i:], m.Range)
	}
	if len(m.Gateway) > 0 {
		data[i] = 0x22
		i++
		i = encodeVarintTypes(data, i, uint64(len(m.Gateway)))
		i += copy(data[i:], m.Gateway)
	}
	if len(m.Reserved) > 0 {
		for k, _ := range m.Reserved {
			data[i] = 0x2a
			i++
			v := m.Reserved[k]
			mapSize := 1 + len(k) + sovTypes(uint64(len(k))) + 1 + len(v) + sovTypes(uint64(len(v)))
			i = encodeVarintTypes(data, i, uint64(mapSize))
			data[i] = 0xa
			i++
			i = encodeVarintTypes(data, i, uint64(len(k)))
			i += copy(data[i:], k)
			data[i] = 0x12
			i++
			i = encodeVarintTypes(data, i, uint64(len(v)))
			i += copy(data[i:], v)
		}
	}
	return i, nil
}

func (m *Endpoint) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Endpoint) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.VirtualIP) > 0 {
		for _, s := range m.VirtualIP {
			data[i] = 0xa
			i++
			l = len(s)
			for l >= 1<<7 {
				data[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			data[i] = uint8(l)
			i++
			i += copy(data[i:], s)
		}
	}
	if len(m.Ports) > 0 {
		for _, msg := range m.Ports {
			data[i] = 0x12
			i++
			i = encodeVarintTypes(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *Endpoint_PortConfiguration) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Endpoint_PortConfiguration) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintTypes(data, i, uint64(len(m.Name)))
		i += copy(data[i:], m.Name)
	}
	if m.Port != 0 {
		data[i] = 0x10
		i++
		i = encodeVarintTypes(data, i, uint64(m.Port))
	}
	if m.Protocol != 0 {
		data[i] = 0x18
		i++
		i = encodeVarintTypes(data, i, uint64(m.Protocol))
	}
	if m.NodePort != 0 {
		data[i] = 0x20
		i++
		i = encodeVarintTypes(data, i, uint64(m.NodePort))
	}
	return i, nil
}

func (m *Driver) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Driver) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintTypes(data, i, uint64(len(m.Name)))
		i += copy(data[i:], m.Name)
	}
	if len(m.Options) > 0 {
		for k, _ := range m.Options {
			data[i] = 0x12
			i++
			v := m.Options[k]
			mapSize := 1 + len(k) + sovTypes(uint64(len(k))) + 1 + len(v) + sovTypes(uint64(len(v)))
			i = encodeVarintTypes(data, i, uint64(mapSize))
			data[i] = 0xa
			i++
			i = encodeVarintTypes(data, i, uint64(len(k)))
			i += copy(data[i:], k)
			data[i] = 0x12
			i++
			i = encodeVarintTypes(data, i, uint64(len(v)))
			i += copy(data[i:], v)
		}
	}
	return i, nil
}

func (m *IPAMOptions) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *IPAMOptions) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Driver != nil {
		data[i] = 0xa
		i++
		i = encodeVarintTypes(data, i, uint64(m.Driver.Size()))
		n9, err := m.Driver.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n9
	}
	if len(m.Configurations) > 0 {
		for _, msg := range m.Configurations {
			data[i] = 0x1a
			i++
			i = encodeVarintTypes(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *WeightedPeer) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *WeightedPeer) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Addr) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintTypes(data, i, uint64(len(m.Addr)))
		i += copy(data[i:], m.Addr)
	}
	if m.Weight != 0 {
		data[i] = 0x10
		i++
		i = encodeVarintTypes(data, i, uint64(m.Weight))
	}
	return i, nil
}

func encodeFixed64Types(data []byte, offset int, v uint64) int {
	data[offset] = uint8(v)
	data[offset+1] = uint8(v >> 8)
	data[offset+2] = uint8(v >> 16)
	data[offset+3] = uint8(v >> 24)
	data[offset+4] = uint8(v >> 32)
	data[offset+5] = uint8(v >> 40)
	data[offset+6] = uint8(v >> 48)
	data[offset+7] = uint8(v >> 56)
	return offset + 8
}
func encodeFixed32Types(data []byte, offset int, v uint32) int {
	data[offset] = uint8(v)
	data[offset+1] = uint8(v >> 8)
	data[offset+2] = uint8(v >> 16)
	data[offset+3] = uint8(v >> 24)
	return offset + 4
}
func encodeVarintTypes(data []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		data[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	data[offset] = uint8(v)
	return offset + 1
}

func (m *Version) Size() (n int) {
	var l int
	_ = l
	if m.Index != 0 {
		n += 1 + sovTypes(uint64(m.Index))
	}
	return n
}

func (m *Resources) Size() (n int) {
	var l int
	_ = l
	if m.NanoCPUs != 0 {
		n += 1 + sovTypes(uint64(m.NanoCPUs))
	}
	if m.MemoryBytes != 0 {
		n += 1 + sovTypes(uint64(m.MemoryBytes))
	}
	return n
}

func (m *ResourceRequirements) Size() (n int) {
	var l int
	_ = l
	if m.Limits != nil {
		l = m.Limits.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.Reservations != nil {
		l = m.Reservations.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func (m *Platform) Size() (n int) {
	var l int
	_ = l
	l = len(m.Architecture)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.OS)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func (m *NodeDescription) Size() (n int) {
	var l int
	_ = l
	l = len(m.Hostname)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.Platform != nil {
		l = m.Platform.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.Resources != nil {
		l = m.Resources.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func (m *MemberDescription) Size() (n int) {
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.Cluster)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func (m *RaftNode) Size() (n int) {
	var l int
	_ = l
	if m.ID != 0 {
		n += 1 + sovTypes(uint64(m.ID))
	}
	l = len(m.Addr)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func (m *MemberStatus) Size() (n int) {
	var l int
	_ = l
	if m.Leader {
		n += 2
	}
	if m.State != 0 {
		n += 1 + sovTypes(uint64(m.State))
	}
	l = len(m.Message)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func (m *NodeStatus) Size() (n int) {
	var l int
	_ = l
	if m.State != 0 {
		n += 1 + sovTypes(uint64(m.State))
	}
	l = len(m.Message)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func (m *Image) Size() (n int) {
	var l int
	_ = l
	l = len(m.Reference)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func (m *Mount) Size() (n int) {
	var l int
	_ = l
	l = len(m.Target)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.Source)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.Mask != 0 {
		n += 1 + sovTypes(uint64(m.Mask))
	}
	if m.Type != 0 {
		n += 1 + sovTypes(uint64(m.Type))
	}
	l = len(m.VolumeName)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func (m *Container) Size() (n int) {
	var l int
	_ = l
	if m.Resources != nil {
		l = m.Resources.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.Image != nil {
		l = m.Image.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	if len(m.Command) > 0 {
		for _, s := range m.Command {
			l = len(s)
			n += 1 + l + sovTypes(uint64(l))
		}
	}
	if len(m.Args) > 0 {
		for _, s := range m.Args {
			l = len(s)
			n += 1 + l + sovTypes(uint64(l))
		}
	}
	if len(m.Env) > 0 {
		for _, s := range m.Env {
			l = len(s)
			n += 1 + l + sovTypes(uint64(l))
		}
	}
	l = len(m.Dir)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.User)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if len(m.Networks) > 0 {
		for _, e := range m.Networks {
			l = e.Size()
			n += 1 + l + sovTypes(uint64(l))
		}
	}
	if len(m.Mounts) > 0 {
		for _, e := range m.Mounts {
			l = e.Size()
			n += 1 + l + sovTypes(uint64(l))
		}
	}
	return n
}

func (m *Container_NetworkAttachment) Size() (n int) {
	var l int
	_ = l
	if m.Reference != nil {
		n += m.Reference.Size()
	}
	return n
}

func (m *Container_NetworkAttachment_Name) Size() (n int) {
	var l int
	_ = l
	l = len(m.Name)
	n += 1 + l + sovTypes(uint64(l))
	return n
}
func (m *Container_NetworkAttachment_NetworkID) Size() (n int) {
	var l int
	_ = l
	l = len(m.NetworkID)
	n += 1 + l + sovTypes(uint64(l))
	return n
}
func (m *RestartPolicy) Size() (n int) {
	var l int
	_ = l
	if m.Condition != 0 {
		n += 1 + sovTypes(uint64(m.Condition))
	}
	if m.Delay != 0 {
		n += 1 + sovTypes(uint64(m.Delay))
	}
	return n
}

func (m *UpdateStrategy) Size() (n int) {
	var l int
	_ = l
	if m.Parallelism != 0 {
		n += 1 + sovTypes(uint64(m.Parallelism))
	}
	if m.Delay != 0 {
		n += 1 + sovTypes(uint64(m.Delay))
	}
	return n
}

func (m *TaskStatus) Size() (n int) {
	var l int
	_ = l
	if m.Timestamp != nil {
		l = m.Timestamp.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.State != 0 {
		n += 1 + sovTypes(uint64(m.State))
	}
	if m.TerminalState != 0 {
		n += 1 + sovTypes(uint64(m.TerminalState))
	}
	l = len(m.Message)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.Err)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	return n
}

func (m *IPAMConfiguration) Size() (n int) {
	var l int
	_ = l
	if m.Family != 0 {
		n += 1 + sovTypes(uint64(m.Family))
	}
	l = len(m.Subnet)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.Range)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.Gateway)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if len(m.Reserved) > 0 {
		for k, v := range m.Reserved {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovTypes(uint64(len(k))) + 1 + len(v) + sovTypes(uint64(len(v)))
			n += mapEntrySize + 1 + sovTypes(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *Endpoint) Size() (n int) {
	var l int
	_ = l
	if len(m.VirtualIP) > 0 {
		for _, s := range m.VirtualIP {
			l = len(s)
			n += 1 + l + sovTypes(uint64(l))
		}
	}
	if len(m.Ports) > 0 {
		for _, e := range m.Ports {
			l = e.Size()
			n += 1 + l + sovTypes(uint64(l))
		}
	}
	return n
}

func (m *Endpoint_PortConfiguration) Size() (n int) {
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.Port != 0 {
		n += 1 + sovTypes(uint64(m.Port))
	}
	if m.Protocol != 0 {
		n += 1 + sovTypes(uint64(m.Protocol))
	}
	if m.NodePort != 0 {
		n += 1 + sovTypes(uint64(m.NodePort))
	}
	return n
}

func (m *Driver) Size() (n int) {
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if len(m.Options) > 0 {
		for k, v := range m.Options {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovTypes(uint64(len(k))) + 1 + len(v) + sovTypes(uint64(len(v)))
			n += mapEntrySize + 1 + sovTypes(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *IPAMOptions) Size() (n int) {
	var l int
	_ = l
	if m.Driver != nil {
		l = m.Driver.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	if len(m.Configurations) > 0 {
		for _, e := range m.Configurations {
			l = e.Size()
			n += 1 + l + sovTypes(uint64(l))
		}
	}
	return n
}

func (m *WeightedPeer) Size() (n int) {
	var l int
	_ = l
	l = len(m.Addr)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.Weight != 0 {
		n += 1 + sovTypes(uint64(m.Weight))
	}
	return n
}

func sovTypes(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozTypes(x uint64) (n int) {
	return sovTypes(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *Version) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Version{`,
		`Index:` + fmt.Sprintf("%v", this.Index) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Resources) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Resources{`,
		`NanoCPUs:` + fmt.Sprintf("%v", this.NanoCPUs) + `,`,
		`MemoryBytes:` + fmt.Sprintf("%v", this.MemoryBytes) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ResourceRequirements) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ResourceRequirements{`,
		`Limits:` + strings.Replace(fmt.Sprintf("%v", this.Limits), "Resources", "Resources", 1) + `,`,
		`Reservations:` + strings.Replace(fmt.Sprintf("%v", this.Reservations), "Resources", "Resources", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Platform) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Platform{`,
		`Architecture:` + fmt.Sprintf("%v", this.Architecture) + `,`,
		`OS:` + fmt.Sprintf("%v", this.OS) + `,`,
		`}`,
	}, "")
	return s
}
func (this *NodeDescription) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&NodeDescription{`,
		`Hostname:` + fmt.Sprintf("%v", this.Hostname) + `,`,
		`Platform:` + strings.Replace(fmt.Sprintf("%v", this.Platform), "Platform", "Platform", 1) + `,`,
		`Resources:` + strings.Replace(fmt.Sprintf("%v", this.Resources), "Resources", "Resources", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *MemberDescription) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&MemberDescription{`,
		`Name:` + fmt.Sprintf("%v", this.Name) + `,`,
		`Cluster:` + fmt.Sprintf("%v", this.Cluster) + `,`,
		`}`,
	}, "")
	return s
}
func (this *RaftNode) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RaftNode{`,
		`ID:` + fmt.Sprintf("%v", this.ID) + `,`,
		`Addr:` + fmt.Sprintf("%v", this.Addr) + `,`,
		`}`,
	}, "")
	return s
}
func (this *MemberStatus) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&MemberStatus{`,
		`Leader:` + fmt.Sprintf("%v", this.Leader) + `,`,
		`State:` + fmt.Sprintf("%v", this.State) + `,`,
		`Message:` + fmt.Sprintf("%v", this.Message) + `,`,
		`}`,
	}, "")
	return s
}
func (this *NodeStatus) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&NodeStatus{`,
		`State:` + fmt.Sprintf("%v", this.State) + `,`,
		`Message:` + fmt.Sprintf("%v", this.Message) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Image) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Image{`,
		`Reference:` + fmt.Sprintf("%v", this.Reference) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Mount) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Mount{`,
		`Target:` + fmt.Sprintf("%v", this.Target) + `,`,
		`Source:` + fmt.Sprintf("%v", this.Source) + `,`,
		`Mask:` + fmt.Sprintf("%v", this.Mask) + `,`,
		`Type:` + fmt.Sprintf("%v", this.Type) + `,`,
		`VolumeName:` + fmt.Sprintf("%v", this.VolumeName) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Container) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Container{`,
		`Resources:` + strings.Replace(fmt.Sprintf("%v", this.Resources), "ResourceRequirements", "ResourceRequirements", 1) + `,`,
		`Image:` + strings.Replace(fmt.Sprintf("%v", this.Image), "Image", "Image", 1) + `,`,
		`Command:` + fmt.Sprintf("%v", this.Command) + `,`,
		`Args:` + fmt.Sprintf("%v", this.Args) + `,`,
		`Env:` + fmt.Sprintf("%v", this.Env) + `,`,
		`Dir:` + fmt.Sprintf("%v", this.Dir) + `,`,
		`User:` + fmt.Sprintf("%v", this.User) + `,`,
		`Networks:` + strings.Replace(fmt.Sprintf("%v", this.Networks), "Container_NetworkAttachment", "Container_NetworkAttachment", 1) + `,`,
		`Mounts:` + strings.Replace(fmt.Sprintf("%v", this.Mounts), "Mount", "Mount", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Container_NetworkAttachment) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Container_NetworkAttachment{`,
		`Reference:` + fmt.Sprintf("%v", this.Reference) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Container_NetworkAttachment_Name) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Container_NetworkAttachment_Name{`,
		`Name:` + fmt.Sprintf("%v", this.Name) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Container_NetworkAttachment_NetworkID) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Container_NetworkAttachment_NetworkID{`,
		`NetworkID:` + fmt.Sprintf("%v", this.NetworkID) + `,`,
		`}`,
	}, "")
	return s
}
func (this *RestartPolicy) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RestartPolicy{`,
		`Condition:` + fmt.Sprintf("%v", this.Condition) + `,`,
		`Delay:` + fmt.Sprintf("%v", this.Delay) + `,`,
		`}`,
	}, "")
	return s
}
func (this *UpdateStrategy) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&UpdateStrategy{`,
		`Parallelism:` + fmt.Sprintf("%v", this.Parallelism) + `,`,
		`Delay:` + fmt.Sprintf("%v", this.Delay) + `,`,
		`}`,
	}, "")
	return s
}
func (this *TaskStatus) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&TaskStatus{`,
		`Timestamp:` + strings.Replace(fmt.Sprintf("%v", this.Timestamp), "Timestamp", "docker_cluster_api.Timestamp", 1) + `,`,
		`State:` + fmt.Sprintf("%v", this.State) + `,`,
		`TerminalState:` + fmt.Sprintf("%v", this.TerminalState) + `,`,
		`Message:` + fmt.Sprintf("%v", this.Message) + `,`,
		`Err:` + fmt.Sprintf("%v", this.Err) + `,`,
		`}`,
	}, "")
	return s
}
func (this *IPAMConfiguration) String() string {
	if this == nil {
		return "nil"
	}
	keysForReserved := make([]string, 0, len(this.Reserved))
	for k, _ := range this.Reserved {
		keysForReserved = append(keysForReserved, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForReserved)
	mapStringForReserved := "map[string]string{"
	for _, k := range keysForReserved {
		mapStringForReserved += fmt.Sprintf("%v: %v,", k, this.Reserved[k])
	}
	mapStringForReserved += "}"
	s := strings.Join([]string{`&IPAMConfiguration{`,
		`Family:` + fmt.Sprintf("%v", this.Family) + `,`,
		`Subnet:` + fmt.Sprintf("%v", this.Subnet) + `,`,
		`Range:` + fmt.Sprintf("%v", this.Range) + `,`,
		`Gateway:` + fmt.Sprintf("%v", this.Gateway) + `,`,
		`Reserved:` + mapStringForReserved + `,`,
		`}`,
	}, "")
	return s
}
func (this *Endpoint) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Endpoint{`,
		`VirtualIP:` + fmt.Sprintf("%v", this.VirtualIP) + `,`,
		`Ports:` + strings.Replace(fmt.Sprintf("%v", this.Ports), "Endpoint_PortConfiguration", "Endpoint_PortConfiguration", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Endpoint_PortConfiguration) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Endpoint_PortConfiguration{`,
		`Name:` + fmt.Sprintf("%v", this.Name) + `,`,
		`Port:` + fmt.Sprintf("%v", this.Port) + `,`,
		`Protocol:` + fmt.Sprintf("%v", this.Protocol) + `,`,
		`NodePort:` + fmt.Sprintf("%v", this.NodePort) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Driver) String() string {
	if this == nil {
		return "nil"
	}
	keysForOptions := make([]string, 0, len(this.Options))
	for k, _ := range this.Options {
		keysForOptions = append(keysForOptions, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForOptions)
	mapStringForOptions := "map[string]string{"
	for _, k := range keysForOptions {
		mapStringForOptions += fmt.Sprintf("%v: %v,", k, this.Options[k])
	}
	mapStringForOptions += "}"
	s := strings.Join([]string{`&Driver{`,
		`Name:` + fmt.Sprintf("%v", this.Name) + `,`,
		`Options:` + mapStringForOptions + `,`,
		`}`,
	}, "")
	return s
}
func (this *IPAMOptions) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&IPAMOptions{`,
		`Driver:` + strings.Replace(fmt.Sprintf("%v", this.Driver), "Driver", "Driver", 1) + `,`,
		`Configurations:` + strings.Replace(fmt.Sprintf("%v", this.Configurations), "IPAMConfiguration", "IPAMConfiguration", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *WeightedPeer) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&WeightedPeer{`,
		`Addr:` + fmt.Sprintf("%v", this.Addr) + `,`,
		`Weight:` + fmt.Sprintf("%v", this.Weight) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringTypes(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *Version) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Version: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Version: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Index", wireType)
			}
			m.Index = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.Index |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Resources) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Resources: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Resources: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NanoCPUs", wireType)
			}
			m.NanoCPUs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.NanoCPUs |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MemoryBytes", wireType)
			}
			m.MemoryBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.MemoryBytes |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ResourceRequirements) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResourceRequirements: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResourceRequirements: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Limits", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Limits == nil {
				m.Limits = &Resources{}
			}
			if err := m.Limits.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Reservations", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Reservations == nil {
				m.Reservations = &Resources{}
			}
			if err := m.Reservations.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Platform) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Platform: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Platform: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Architecture", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Architecture = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OS", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OS = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NodeDescription) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NodeDescription: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NodeDescription: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Hostname", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Hostname = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Platform", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Platform == nil {
				m.Platform = &Platform{}
			}
			if err := m.Platform.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Resources", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Resources == nil {
				m.Resources = &Resources{}
			}
			if err := m.Resources.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MemberDescription) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MemberDescription: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MemberDescription: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cluster", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Cluster = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RaftNode) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RaftNode: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RaftNode: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ID", wireType)
			}
			m.ID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.ID |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Addr", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Addr = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MemberStatus) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MemberStatus: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MemberStatus: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Leader", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Leader = bool(v != 0)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field State", wireType)
			}
			m.State = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.State |= (MemberStatus_State(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Message = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NodeStatus) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NodeStatus: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NodeStatus: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field State", wireType)
			}
			m.State = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.State |= (NodeStatus_State(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Message = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Image) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Image: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Image: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Reference", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Reference = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Mount) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Mount: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Mount: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Target", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Target = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Source", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Source = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Mask", wireType)
			}
			m.Mask = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.Mask |= (Mount_Mask(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.Type |= (Mount_Type(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VolumeName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.VolumeName = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Container) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Container: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Container: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Resources", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Resources == nil {
				m.Resources = &ResourceRequirements{}
			}
			if err := m.Resources.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Image", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Image == nil {
				m.Image = &Image{}
			}
			if err := m.Image.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Command", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Command = append(m.Command, string(data[iNdEx:postIndex]))
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Args", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Args = append(m.Args, string(data[iNdEx:postIndex]))
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Env", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Env = append(m.Env, string(data[iNdEx:postIndex]))
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Dir", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Dir = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field User", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.User = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Networks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Networks = append(m.Networks, &Container_NetworkAttachment{})
			if err := m.Networks[len(m.Networks)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Mounts", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Mounts = append(m.Mounts, &Mount{})
			if err := m.Mounts[len(m.Mounts)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Container_NetworkAttachment) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NetworkAttachment: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NetworkAttachment: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Reference = &Container_NetworkAttachment_Name{string(data[iNdEx:postIndex])}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NetworkID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Reference = &Container_NetworkAttachment_NetworkID{string(data[iNdEx:postIndex])}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RestartPolicy) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RestartPolicy: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RestartPolicy: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Condition", wireType)
			}
			m.Condition = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.Condition |= (RestartPolicy_RestartCondition(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Delay", wireType)
			}
			m.Delay = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.Delay |= (time.Duration(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UpdateStrategy) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UpdateStrategy: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UpdateStrategy: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Parallelism", wireType)
			}
			m.Parallelism = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.Parallelism |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Delay", wireType)
			}
			m.Delay = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.Delay |= (time.Duration(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TaskStatus) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TaskStatus: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TaskStatus: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Timestamp == nil {
				m.Timestamp = &docker_cluster_api.Timestamp{}
			}
			if err := m.Timestamp.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field State", wireType)
			}
			m.State = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.State |= (TaskState(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TerminalState", wireType)
			}
			m.TerminalState = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.TerminalState |= (TaskState(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Message = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Err", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Err = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *IPAMConfiguration) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: IPAMConfiguration: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: IPAMConfiguration: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Family", wireType)
			}
			m.Family = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.Family |= (IPAMConfiguration_AddressFamily(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Subnet", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Subnet = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Range", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Range = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Gateway", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Gateway = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Reserved", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			var keykey uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				keykey |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			var stringLenmapkey uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLenmapkey |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLenmapkey := int(stringLenmapkey)
			if intStringLenmapkey < 0 {
				return ErrInvalidLengthTypes
			}
			postStringIndexmapkey := iNdEx + intStringLenmapkey
			if postStringIndexmapkey > l {
				return io.ErrUnexpectedEOF
			}
			mapkey := string(data[iNdEx:postStringIndexmapkey])
			iNdEx = postStringIndexmapkey
			var valuekey uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				valuekey |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			var stringLenmapvalue uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLenmapvalue |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLenmapvalue := int(stringLenmapvalue)
			if intStringLenmapvalue < 0 {
				return ErrInvalidLengthTypes
			}
			postStringIndexmapvalue := iNdEx + intStringLenmapvalue
			if postStringIndexmapvalue > l {
				return io.ErrUnexpectedEOF
			}
			mapvalue := string(data[iNdEx:postStringIndexmapvalue])
			iNdEx = postStringIndexmapvalue
			if m.Reserved == nil {
				m.Reserved = make(map[string]string)
			}
			m.Reserved[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Endpoint) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Endpoint: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Endpoint: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VirtualIP", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.VirtualIP = append(m.VirtualIP, string(data[iNdEx:postIndex]))
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ports", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Ports = append(m.Ports, &Endpoint_PortConfiguration{})
			if err := m.Ports[len(m.Ports)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Endpoint_PortConfiguration) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PortConfiguration: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PortConfiguration: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Port", wireType)
			}
			m.Port = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.Port |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Protocol", wireType)
			}
			m.Protocol = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.Protocol |= (Endpoint_Protocol(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodePort", wireType)
			}
			m.NodePort = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.NodePort |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Driver) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Driver: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Driver: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Options", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			var keykey uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				keykey |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			var stringLenmapkey uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLenmapkey |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLenmapkey := int(stringLenmapkey)
			if intStringLenmapkey < 0 {
				return ErrInvalidLengthTypes
			}
			postStringIndexmapkey := iNdEx + intStringLenmapkey
			if postStringIndexmapkey > l {
				return io.ErrUnexpectedEOF
			}
			mapkey := string(data[iNdEx:postStringIndexmapkey])
			iNdEx = postStringIndexmapkey
			var valuekey uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				valuekey |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			var stringLenmapvalue uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLenmapvalue |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLenmapvalue := int(stringLenmapvalue)
			if intStringLenmapvalue < 0 {
				return ErrInvalidLengthTypes
			}
			postStringIndexmapvalue := iNdEx + intStringLenmapvalue
			if postStringIndexmapvalue > l {
				return io.ErrUnexpectedEOF
			}
			mapvalue := string(data[iNdEx:postStringIndexmapvalue])
			iNdEx = postStringIndexmapvalue
			if m.Options == nil {
				m.Options = make(map[string]string)
			}
			m.Options[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *IPAMOptions) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: IPAMOptions: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: IPAMOptions: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Driver", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Driver == nil {
				m.Driver = &Driver{}
			}
			if err := m.Driver.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Configurations", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Configurations = append(m.Configurations, &IPAMConfiguration{})
			if err := m.Configurations[len(m.Configurations)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *WeightedPeer) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: WeightedPeer: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: WeightedPeer: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Addr", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Addr = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Weight", wireType)
			}
			m.Weight = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.Weight |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipTypes(data []byte) (n int, err error) {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if data[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthTypes
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowTypes
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := data[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipTypes(data[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthTypes = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowTypes   = fmt.Errorf("proto: integer overflow")
)

var fileDescriptorTypes = []byte{
	// 1940 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0x94, 0x57, 0xcb, 0x6f, 0x1b, 0xc7,
	0x19, 0xd7, 0xf2, 0x25, 0x72, 0x48, 0xc9, 0xd4, 0xd4, 0x31, 0x68, 0xd6, 0x95, 0xdc, 0x6d, 0xec,
	0xa6, 0x6d, 0x40, 0xb7, 0x72, 0x1a, 0x04, 0x76, 0x0f, 0x5d, 0x92, 0xab, 0x98, 0x0d, 0xb5, 0x5c,
	0x0c, 0x49, 0x09, 0xee, 0x85, 0x58, 0x71, 0x47, 0xd4, 0xd6, 0xfb, 0x60, 0x77, 0x97, 0x52, 0xd9,
	0x93, 0x8e, 0x45, 0x4f, 0xbd, 0x17, 0x45, 0x0e, 0x0d, 0xfa, 0x17, 0x14, 0x28, 0x90, 0x5e, 0x7c,
	0xf4, 0xb1, 0xe8, 0xa9, 0xe8, 0xc1, 0x68, 0x72, 0xea, 0x31, 0x7f, 0x42, 0xbe, 0x79, 0xec, 0x92,
	0xa2, 0x28, 0xc7, 0x39, 0x10, 0x9c, 0x99, 0xfd, 0x7d, 0xcf, 0xf9, 0x5e, 0x83, 0xca, 0xf1, 0x7c,
	0x4a, 0xa3, 0xc6, 0x34, 0x0c, 0xe2, 0x00, 0x63, 0x3b, 0x18, 0xbf, 0xa0, 0x61, 0x63, 0xec, 0xce,
	0xa2, 0x18, 0xfe, 0xad, 0xa9, 0x53, 0xbf, 0x1b, 0x3b, 0x1e, 0x8d, 0x62, 0xcb, 0x9b, 0x3e, 0x4a,
	0x57, 0x02, 0x5e, 0xbf, 0x3d, 0x09, 0x26, 0x01, 0x5f, 0x3e, 0x62, 0x2b, 0x71, 0xaa, 0xee, 0xa1,
	0xcd, 0x23, 0x1a, 0x46, 0x4e, 0xe0, 0xe3, 0xdb, 0x28, 0xef, 0xf8, 0x36, 0xfd, 0x5d, 0x4d, 0xb9,
	0xaf, 0xbc, 0x97, 0x23, 0x62, 0xa3, 0x3e, 0x47, 0x25, 0x42, 0xa3, 0x60, 0x16, 0x8e, 0x69, 0x84,
	0x7f, 0x84, 0x4a, 0xbe, 0xe5, 0x07, 0xa3, 0xf1, 0x74, 0x16, 0x71, 0x58, 0xb6, 0x59, 0xf9, 0xf2,
	0xf5, 0x5e, 0xd1, 0x80, 0xc3, 0x96, 0x39, 0x8c, 0x48, 0x91, 0x7d, 0x6e, 0xc1, 0x57, 0xfc, 0x7d,
	0x54, 0xf1, 0xa8, 0x17, 0x84, 0xf3, 0xd1, 0xc9, 0x3c, 0xa6, 0x51, 0x2d, 0xc3, 0xd0, 0xa4, 0x2c,
	0xce, 0x9a, 0xec, 0x48, 0xfd, 0x93, 0x82, 0x6e, 0x27, 0xbc, 0x09, 0xfd, 0xed, 0xcc, 0x09, 0xa9,
	0x47, 0xfd, 0x38, 0xc2, 0x3f, 0x47, 0x05, 0xd7, 0xf1, 0x9c, 0x58, 0xc8, 0x28, 0xef, 0x7f, 0xaf,
	0x71, 0xdd, 0xd4, 0x46, 0xaa, 0x15, 0x91, 0x60, 0xac, 0xa1, 0x4a, 0x48, 0x23, 0x1a, 0x9e, 0x5b,
	0x31, 0xd8, 0x23, 0x44, 0x7e, 0x23, 0xf1, 0x15, 0x12, 0xf5, 0x00, 0x15, 0x4d, 0xd7, 0x8a, 0x4f,
	0x83, 0xd0, 0xc3, 0x2a, 0xaa, 0x58, 0xe1, 0xf8, 0xcc, 0x89, 0xe9, 0x38, 0x9e, 0x85, 0x94, 0xeb,
	0x52, 0x22, 0x57, 0xce, 0xf0, 0x1d, 0x94, 0x09, 0x84, 0xa0, 0x52, 0xb3, 0x00, 0x9e, 0xc8, 0xf4,
	0xfa, 0x04, 0x4e, 0xd4, 0xcf, 0x14, 0x74, 0xcb, 0x08, 0x6c, 0xda, 0xa6, 0xd1, 0x38, 0x74, 0xa6,
	0x8c, 0x39, 0xae, 0xa3, 0xe2, 0x59, 0x10, 0xc5, 0xbe, 0xe5, 0x25, 0xbc, 0xd2, 0x3d, 0xfe, 0x08,
	0x15, 0xa7, 0x52, 0xae, 0x54, 0xfb, 0xde, 0x3a, 0xb5, 0x13, 0xdd, 0x48, 0x8a, 0xc6, 0x4f, 0x51,
	0x29, 0x4c, 0x8c, 0xa9, 0x65, 0xdf, 0xc6, 0xe2, 0x05, 0x5e, 0xd5, 0xd0, 0xce, 0x21, 0xf5, 0x4e,
	0x68, 0xb8, 0xac, 0x27, 0x46, 0xb9, 0x25, 0x1d, 0xf9, 0x1a, 0xd7, 0xd0, 0xa6, 0x64, 0x26, 0x8c,
	0x25, 0xc9, 0x56, 0xfd, 0x10, 0x15, 0x89, 0x75, 0x1a, 0x33, 0x63, 0x99, 0x37, 0x1c, 0x5b, 0x84,
	0x8f, 0xf0, 0x46, 0xa7, 0x4d, 0xe0, 0x84, 0x71, 0xb4, 0x6c, 0x3b, 0x21, 0xe5, 0x6b, 0xf5, 0xef,
	0x0a, 0xaa, 0x08, 0xd9, 0xfd, 0xd8, 0x8a, 0x21, 0x60, 0xee, 0xc0, 0xa5, 0x53, 0xcb, 0x06, 0x09,
	0x8c, 0x41, 0x91, 0xc8, 0x1d, 0xfe, 0x05, 0xca, 0x43, 0x18, 0xc7, 0x94, 0x53, 0x6f, 0xef, 0x3f,
	0x5c, 0x67, 0xdc, 0x32, 0xa3, 0x06, 0xfb, 0xa3, 0x44, 0x10, 0x31, 0xc5, 0x21, 0x0d, 0x22, 0x6b,
	0x42, 0xb9, 0x73, 0x40, 0x71, 0xb9, 0x55, 0x3f, 0x40, 0x79, 0x8e, 0xc4, 0x65, 0xb4, 0x39, 0x34,
	0x3e, 0x31, 0x7a, 0xc7, 0x46, 0x75, 0x03, 0xdf, 0x42, 0xe5, 0xa1, 0x41, 0x74, 0xad, 0xf5, 0x4c,
	0x6b, 0x76, 0xf5, 0xaa, 0x82, 0xb7, 0x20, 0xfe, 0xd3, 0x6d, 0x46, 0xfd, 0x54, 0x41, 0x88, 0xd9,
	0x2a, 0x95, 0x7e, 0x92, 0x28, 0xa7, 0x70, 0xe5, 0xde, 0x5d, 0xa7, 0xdc, 0x02, 0x7e, 0xa3, 0x6a,
	0x99, 0xab, 0xaa, 0x3d, 0x5d, 0xab, 0x5a, 0x11, 0xe5, 0xda, 0x6c, 0xa5, 0xe0, 0x12, 0xca, 0x83,
	0x4e, 0xed, 0xe7, 0xd5, 0x0c, 0xae, 0xa2, 0x4a, 0xbb, 0xd3, 0x6f, 0xf5, 0x0c, 0x43, 0x6f, 0x0d,
	0xf4, 0x76, 0x35, 0xab, 0x3e, 0x40, 0xf9, 0x8e, 0x07, 0x5c, 0xf0, 0x3d, 0x16, 0x19, 0xa7, 0x34,
	0xa4, 0xfe, 0x38, 0xb9, 0xcc, 0xc5, 0x81, 0xfa, 0x69, 0x16, 0xe5, 0x0f, 0x83, 0x99, 0x1f, 0x33,
	0xc7, 0xc7, 0x56, 0x38, 0xa1, 0xb1, 0x04, 0xc9, 0x1d, 0x3b, 0x17, 0x71, 0x22, 0xd5, 0x93, 0x3b,
	0xbc, 0x8f, 0x72, 0x9e, 0x15, 0xbd, 0xe0, 0xfe, 0xdc, 0xde, 0xdf, 0x5d, 0x7b, 0x1f, 0x8c, 0x71,
	0xe3, 0x10, 0x50, 0x84, 0x63, 0x19, 0x0d, 0x2b, 0x5d, 0xb5, 0xdc, 0x37, 0xd1, 0x0c, 0x00, 0x45,
	0x38, 0x16, 0xef, 0xa1, 0xf2, 0x79, 0xe0, 0xce, 0x3c, 0x3a, 0xe2, 0xe1, 0x98, 0xe7, 0x4a, 0x20,
	0x71, 0x64, 0xc0, 0x89, 0x7a, 0x82, 0x72, 0x4c, 0x04, 0x7e, 0x97, 0x5f, 0x51, 0x7b, 0xd4, 0x33,
	0xba, 0xcf, 0xab, 0x1b, 0xf5, 0x77, 0xfe, 0xf8, 0x97, 0xfb, 0x3b, 0x9c, 0x1b, 0x57, 0x00, 0xa2,
	0xa8, 0xe7, 0xbb, 0x73, 0xfc, 0x10, 0x21, 0x8e, 0x3a, 0x26, 0x9d, 0x01, 0x5c, 0x6c, 0xfd, 0x0e,
	0xc0, 0xf0, 0x15, 0xd8, 0x71, 0x08, 0x79, 0x5d, 0xaf, 0xfc, 0xe1, 0xaf, 0xbb, 0x1b, 0x9f, 0x7f,
	0xb6, 0xcb, 0x79, 0xab, 0x73, 0x94, 0x63, 0x2a, 0xe1, 0xef, 0xa2, 0x5c, 0xb3, 0x63, 0xb4, 0x81,
	0xfd, 0x0e, 0xd0, 0x6d, 0x71, 0x3a, 0xf6, 0xa1, 0x09, 0x55, 0x12, 0x3f, 0x40, 0x25, 0xdd, 0x7c,
	0xa6, 0x1f, 0xea, 0x44, 0xeb, 0x5e, 0xe1, 0xcc, 0x10, 0xfa, 0xf4, 0x0c, 0xca, 0x5a, 0x68, 0xb9,
	0x60, 0x50, 0xe1, 0xa8, 0xd7, 0x1d, 0x1e, 0x42, 0x1c, 0xd5, 0xbf, 0x03, 0x98, 0x5b, 0x29, 0xe6,
	0x88, 0x1b, 0xb5, 0x10, 0xcd, 0xce, 0xd4, 0x7f, 0x67, 0x51, 0xa9, 0x15, 0xf8, 0xb1, 0xe5, 0xf8,
	0x90, 0x06, 0x07, 0xcb, 0x79, 0x2e, 0xca, 0xe2, 0x7b, 0x6f, 0xca, 0xf3, 0xe5, 0x82, 0xba, 0x94,
	0xf2, 0xf8, 0x11, 0x54, 0x79, 0x2f, 0x89, 0xb9, 0xf2, 0xfe, 0xdd, 0x75, 0x3c, 0x78, 0xfc, 0x10,
	0x81, 0xe3, 0xa9, 0x1f, 0x78, 0x9e, 0xe5, 0xdb, 0x70, 0xe3, 0x59, 0x9e, 0xfa, 0x62, 0xcb, 0xd3,
	0x3a, 0x9c, 0x44, 0x70, 0xa9, 0x59, 0x9e, 0xd6, 0xb0, 0x86, 0x78, 0xcc, 0x52, 0xff, 0x1c, 0x2e,
	0x8b, 0x1d, 0xb1, 0x25, 0x3b, 0xb1, 0x9d, 0xb0, 0x56, 0xe0, 0xd7, 0xc7, 0x96, 0x8c, 0x6e, 0x06,
	0x35, 0xb7, 0xb6, 0x29, 0xca, 0x01, 0x5b, 0xe3, 0x4f, 0x50, 0xd1, 0xa7, 0xf1, 0x45, 0x10, 0xbe,
	0x88, 0x6a, 0x45, 0x20, 0x2e, 0xef, 0x3f, 0x5a, 0xa7, 0x59, 0xea, 0x8f, 0x86, 0x21, 0xd0, 0x5a,
	0x1c, 0x5b, 0xe3, 0x33, 0x66, 0x25, 0x49, 0x19, 0xe0, 0x9f, 0xa1, 0x82, 0xc7, 0x5c, 0x1b, 0xd5,
	0x4a, 0x9c, 0xd5, 0xdd, 0x1b, 0xe3, 0x8d, 0x48, 0x60, 0xfd, 0x14, 0xed, 0x5c, 0xe3, 0x08, 0x1d,
	0x71, 0xa9, 0x12, 0x3e, 0xdb, 0x90, 0xb5, 0xb0, 0x81, 0x90, 0x94, 0x34, 0x82, 0x6a, 0x27, 0x6a,
	0xff, 0x16, 0x54, 0xbb, 0x92, 0x64, 0xd0, 0x69, 0x03, 0xb4, 0x24, 0x21, 0x1d, 0xbb, 0x59, 0x5e,
	0xca, 0x43, 0xf5, 0x1f, 0x19, 0xb4, 0x45, 0x58, 0x5f, 0x0e, 0x63, 0x33, 0x70, 0x9d, 0xf1, 0x1c,
	0x9b, 0xa8, 0x34, 0x0e, 0x7c, 0xdb, 0x61, 0xb5, 0x57, 0x96, 0x91, 0xfd, 0x1b, 0x2e, 0x76, 0x41,
	0x95, 0xec, 0x5a, 0x09, 0x25, 0x59, 0x30, 0xc1, 0x3f, 0x41, 0x79, 0x9b, 0xba, 0xd6, 0x9c, 0xeb,
	0x96, 0x6b, 0xbe, 0xf3, 0xea, 0xf5, 0xde, 0xc6, 0x7f, 0x5f, 0xef, 0x6d, 0xb1, 0x89, 0xa0, 0xd1,
	0x9e, 0x85, 0xbc, 0xd7, 0x11, 0x81, 0x51, 0xff, 0xa6, 0xa0, 0xea, 0x2a, 0x33, 0xfc, 0x03, 0x50,
	0x52, 0xef, 0x0f, 0x34, 0x32, 0x18, 0x19, 0xfa, 0x91, 0x4e, 0x20, 0xec, 0xab, 0x10, 0xb0, 0x15,
	0x09, 0x34, 0xe8, 0x39, 0x5c, 0xd9, 0xfb, 0x08, 0x27, 0xa0, 0x9e, 0x31, 0x3a, 0xd0, 0x3a, 0xdd,
	0x21, 0x61, 0x89, 0x75, 0x1b, 0x90, 0x09, 0xcb, 0x9e, 0x7f, 0x60, 0x39, 0x2e, 0xeb, 0x94, 0x0f,
	0xd0, 0x76, 0x82, 0xd6, 0xba, 0xc7, 0xda, 0xf3, 0x3e, 0x24, 0x01, 0x4f, 0x25, 0x89, 0xd4, 0xdc,
	0x0b, 0x6b, 0x1e, 0xd5, 0x6b, 0x32, 0x05, 0xae, 0xe9, 0xa4, 0x8e, 0xd0, 0xf6, 0x70, 0x6a, 0x43,
	0x55, 0xec, 0xc7, 0x60, 0x01, 0x9d, 0xcc, 0xf1, 0x7d, 0x54, 0x9e, 0x5a, 0x90, 0x58, 0x2e, 0x75,
	0x9d, 0xc8, 0x93, 0x63, 0xcb, 0xf2, 0xd1, 0xb7, 0xf3, 0xc4, 0x57, 0x50, 0xda, 0x07, 0x90, 0xf3,
	0xb2, 0xb4, 0x43, 0x63, 0x4d, 0x47, 0xa8, 0x37, 0xcd, 0x21, 0x83, 0x04, 0x44, 0x16, 0x78, 0xfc,
	0xf8, 0x6a, 0xd3, 0x5a, 0x4f, 0x28, 0x65, 0xa5, 0x0d, 0xa1, 0x8d, 0xb6, 0xe1, 0x9b, 0xe7, 0xf8,
	0x96, 0x3b, 0x12, 0xd4, 0xd9, 0xb7, 0xa1, 0xde, 0x4a, 0x88, 0xfa, 0xab, 0x6d, 0x25, 0x77, 0xa5,
	0xad, 0xf0, 0xdc, 0x0c, 0x43, 0x59, 0x48, 0xd9, 0x52, 0xfd, 0x7f, 0x06, 0xed, 0x74, 0x4c, 0xed,
	0x10, 0xbc, 0x7c, 0xea, 0x4c, 0xa4, 0x3f, 0x20, 0x17, 0x0b, 0xa7, 0x96, 0xe7, 0xb8, 0x73, 0x19,
	0x8e, 0x8f, 0xd7, 0xd6, 0x88, 0x55, 0xb2, 0x86, 0x06, 0x6d, 0x1d, 0x24, 0x1d, 0x70, 0x52, 0x22,
	0x59, 0xf0, 0x2e, 0x32, 0x3b, 0x81, 0x6c, 0x48, 0xbb, 0x08, 0xdf, 0xb1, 0x69, 0x33, 0xb4, 0xfc,
	0xb4, 0x2d, 0x8b, 0x0d, 0x53, 0x7e, 0x02, 0x46, 0x40, 0x28, 0x24, 0xca, 0xcb, 0x2d, 0xee, 0xa1,
	0xa2, 0x98, 0xd4, 0xa8, 0xcd, 0xab, 0x4b, 0xf9, 0x6d, 0xd5, 0x22, 0x92, 0x4a, 0xf7, 0xe3, 0x70,
	0x4e, 0x52, 0x26, 0xf5, 0xa7, 0x3c, 0x11, 0x17, 0x9f, 0x98, 0x7b, 0x5e, 0xd0, 0xb9, 0x6c, 0x82,
	0x6c, 0xc9, 0x74, 0x3c, 0xb7, 0xdc, 0x59, 0xd2, 0x00, 0xc5, 0xe6, 0x49, 0xe6, 0x23, 0x45, 0xfd,
	0x29, 0xda, 0xba, 0x62, 0xee, 0xb5, 0x4e, 0xdd, 0x31, 0x8f, 0x3e, 0xa8, 0xe6, 0xe4, 0xea, 0xc3,
	0x6a, 0x41, 0xfd, 0x3c, 0x83, 0x8a, 0xba, 0x6f, 0x4f, 0x03, 0x07, 0x0a, 0xcb, 0xfb, 0x08, 0x9d,
	0x3b, 0x61, 0x3c, 0x83, 0x8b, 0x76, 0x58, 0x70, 0x65, 0x93, 0x12, 0x72, 0x24, 0x4e, 0x3b, 0x26,
	0x29, 0x49, 0x40, 0x67, 0x0a, 0x71, 0x91, 0x9f, 0x06, 0x61, 0xcc, 0xe6, 0x4c, 0x66, 0x77, 0x63,
	0x9d, 0xdd, 0x09, 0xeb, 0x86, 0x19, 0xf0, 0xa4, 0x59, 0x38, 0x80, 0x08, 0xe2, 0xfa, 0x9f, 0x15,
	0xb4, 0x73, 0xed, 0xe3, 0xda, 0x61, 0x0f, 0xce, 0x18, 0x09, 0xb7, 0x7a, 0x8b, 0xf0, 0x35, 0xcc,
	0xd6, 0x45, 0xfe, 0x60, 0x18, 0x07, 0xae, 0x8c, 0xca, 0x07, 0x6f, 0x56, 0x43, 0x82, 0x49, 0x4a,
	0x06, 0x2d, 0xb4, 0xe4, 0xc3, 0x28, 0x34, 0xe2, 0xbc, 0x73, 0x9c, 0x77, 0x91, 0x1d, 0x30, 0xa5,
	0xd4, 0x7b, 0x30, 0x78, 0x27, 0xc0, 0x4d, 0x94, 0x1d, 0xb4, 0x4c, 0xf0, 0x23, 0x2c, 0x86, 0x6d,
	0xb3, 0xaa, 0xa8, 0xa0, 0x7b, 0xa1, 0x1d, 0x3a, 0xac, 0xea, 0xac, 0x53, 0x58, 0x43, 0x9b, 0xc1,
	0x34, 0x99, 0xf9, 0x99, 0x8b, 0x7e, 0xb8, 0x4e, 0x37, 0xc1, 0xa0, 0xd1, 0x13, 0x48, 0x11, 0x0e,
	0x09, 0x5d, 0xfd, 0x09, 0xaa, 0x2c, 0x7f, 0xf8, 0x56, 0xc1, 0x00, 0xef, 0x98, 0x32, 0x8b, 0x3b,
	0xc9, 0x00, 0x86, 0x9d, 0x82, 0xcd, 0x65, 0xc9, 0xb2, 0x51, 0xbf, 0x59, 0x1b, 0x22, 0x91, 0xf8,
	0x10, 0x6d, 0x8f, 0x97, 0x2f, 0x26, 0xe2, 0xcd, 0xb6, 0xbc, 0xde, 0xcb, 0xd7, 0x82, 0x9c, 0xac,
	0x10, 0xab, 0x60, 0xce, 0x31, 0x75, 0x26, 0x67, 0x31, 0xb5, 0x4d, 0x2a, 0xbc, 0xc6, 0x27, 0x70,
	0x65, 0x31, 0x81, 0xb3, 0xcc, 0xbc, 0xe0, 0x18, 0xf9, 0x36, 0x93, 0xbb, 0x1f, 0xff, 0x33, 0x87,
	0x4a, 0x69, 0x75, 0xc1, 0x77, 0x51, 0xd6, 0xd0, 0x8f, 0x93, 0x06, 0x90, 0x9e, 0x1b, 0xf4, 0x82,
	0x8d, 0x3d, 0x5a, 0xb7, 0xdb, 0x6b, 0x69, 0x6c, 0xf0, 0xfc, 0xa5, 0x18, 0x7b, 0x52, 0x80, 0xe6,
	0xba, 0xc1, 0x18, 0xfe, 0x6d, 0x78, 0x47, 0x6d, 0x9a, 0xba, 0xd1, 0xee, 0x18, 0x1f, 0x57, 0x2f,
	0x65, 0x77, 0x48, 0x51, 0x26, 0x85, 0xf2, 0xee, 0x4f, 0x60, 0x84, 0x2b, 0x6a, 0xfd, 0x7e, 0xe7,
	0x63, 0x03, 0x38, 0xbd, 0x54, 0xc4, 0x08, 0xb7, 0x60, 0x15, 0x45, 0xce, 0xc4, 0x07, 0x4e, 0x0c,
	0xd5, 0x6a, 0xe9, 0x26, 0x93, 0x77, 0x99, 0x59, 0x45, 0x8d, 0xc7, 0x74, 0xca, 0xe4, 0x3d, 0x44,
	0x25, 0x93, 0xe8, 0xa6, 0x46, 0x98, 0xc4, 0x97, 0x99, 0x15, 0xbd, 0xcc, 0x90, 0x42, 0x87, 0x60,
	0x32, 0x77, 0x93, 0x29, 0xfa, 0x32, 0x5b, 0xc7, 0x80, 0xd9, 0x5e, 0x94, 0x54, 0x18, 0x06, 0xe7,
	0x4c, 0x1a, 0xef, 0x57, 0x9c, 0x4d, 0x76, 0x45, 0x5a, 0x9f, 0x35, 0x27, 0xc6, 0x05, 0xac, 0x23,
	0x43, 0xc3, 0xe0, 0xd6, 0xe5, 0x56, 0xac, 0x23, 0x33, 0xdf, 0x97, 0xd6, 0xf5, 0x9f, 0x0d, 0x07,
	0x7c, 0x7a, 0x7f, 0x99, 0x5b, 0xe5, 0x74, 0x36, 0x8b, 0xed, 0xe0, 0xc2, 0x07, 0x77, 0x16, 0x5b,
	0xbd, 0x43, 0xb3, 0xab, 0xc3, 0x78, 0x7a, 0x99, 0x5f, 0x51, 0xbb, 0x15, 0x78, 0x53, 0x97, 0x32,
	0xf3, 0xee, 0xa3, 0x02, 0xeb, 0xb5, 0xcc, 0x51, 0x79, 0x31, 0x46, 0xa6, 0x20, 0xd6, 0x6b, 0x85,
	0x9b, 0x88, 0xfe, 0x2b, 0xf1, 0x1e, 0xb8, 0x2c, 0xac, 0x88, 0x23, 0xf4, 0x37, 0xf0, 0x76, 0x15,
	0xa8, 0x83, 0x8e, 0xa1, 0x75, 0x3b, 0xbf, 0xd6, 0xab, 0x2f, 0x57, 0x51, 0x07, 0xac, 0x9f, 0x38,
	0xbf, 0x67, 0x8f, 0x88, 0x5c, 0x1b, 0x9c, 0x54, 0xbd, 0xdc, 0x14, 0xdd, 0x3a, 0x45, 0xb4, 0xc1,
	0x47, 0xf5, 0x1d, 0xd9, 0xad, 0x17, 0xf1, 0xd2, 0xbc, 0xf7, 0xea, 0x8b, 0xdd, 0x8d, 0xff, 0xc0,
	0xef, 0xab, 0x2f, 0x76, 0x95, 0xcb, 0x2f, 0x77, 0x95, 0x57, 0xf0, 0xfb, 0x17, 0xfc, 0xfe, 0x07,
	0xbf, 0x93, 0x02, 0xaf, 0x06, 0x8f, 0xbf, 0x0e, 0x00, 0x00, 0xff, 0xff, 0x4f, 0x79, 0xf8, 0xaa,
	0xc9, 0x10, 0x00, 0x00,
}
