// Code generated by protoc-gen-gogo.
// source: specs.proto
// DO NOT EDIT!

package api

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "github.com/gogo/protobuf/gogoproto"

import strings "strings"
import github_com_gogo_protobuf_proto "github.com/gogo/protobuf/proto"
import sort "sort"
import strconv "strconv"
import reflect "reflect"
import github_com_gogo_protobuf_sortkeys "github.com/gogo/protobuf/sortkeys"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

type NodeSpec_Availability int32

const (
	// Active nodes.
	NodeAvailabilityActive NodeSpec_Availability = 0
	// Paused nodes won't be considered by the scheduler, preventing any
	// further task to run on them.
	NodeAvailabilityPause NodeSpec_Availability = 1
	// Drained nodes are paused and any task already running on them will
	// be evicted.
	NodeAvailabilityDrain NodeSpec_Availability = 2
)

var NodeSpec_Availability_name = map[int32]string{
	0: "ACTIVE",
	1: "PAUSE",
	2: "DRAIN",
}
var NodeSpec_Availability_value = map[string]int32{
	"ACTIVE": 0,
	"PAUSE":  1,
	"DRAIN":  2,
}

func (x NodeSpec_Availability) String() string {
	return proto.EnumName(NodeSpec_Availability_name, int32(x))
}
func (NodeSpec_Availability) EnumDescriptor() ([]byte, []int) { return fileDescriptorSpecs, []int{1, 0} }

type ServiceSpec_Strategy int32

const (
	// Spread instances evenly among candidate nodes.
	ServiceStrategySpread ServiceSpec_Strategy = 0
	// Pack instances tightly across available nodes.
	ServiceStrategyBinPack ServiceSpec_Strategy = 1
)

var ServiceSpec_Strategy_name = map[int32]string{
	0: "SERVICE_STRATEGY_SPREAD",
	1: "SERVICE_STRATEGY_BINPACK",
}
var ServiceSpec_Strategy_value = map[string]int32{
	"SERVICE_STRATEGY_SPREAD":  0,
	"SERVICE_STRATEGY_BINPACK": 1,
}

func (x ServiceSpec_Strategy) String() string {
	return proto.EnumName(ServiceSpec_Strategy_name, int32(x))
}
func (ServiceSpec_Strategy) EnumDescriptor() ([]byte, []int) { return fileDescriptorSpecs, []int{3, 0} }

type ServiceSpec_Mode int32

const (
	// Running sets the reconcilation target to ensure there are running
	// tasks equal to the number instances. If the using the fill
	// scheduling strategy, the number of nodes will be used instead.
	ServiceModeRunning ServiceSpec_Mode = 0
	// Batch sets reconcilation target as number of completed tasks. If in
	// fill scheduling strategy, the number of instances will equal the number
	// of nodes.
	ServiceModeBatch ServiceSpec_Mode = 1
	// Fill each node with instances number of tasks.
	ServiceModeFill ServiceSpec_Mode = 2
)

var ServiceSpec_Mode_name = map[int32]string{
	0: "SERVICE_MODE_RUNNING",
	1: "SERVICE_MODE_BATCH",
	2: "SERVICE_MODE_FILL",
}
var ServiceSpec_Mode_value = map[string]int32{
	"SERVICE_MODE_RUNNING": 0,
	"SERVICE_MODE_BATCH":   1,
	"SERVICE_MODE_FILL":    2,
}

func (x ServiceSpec_Mode) String() string {
	return proto.EnumName(ServiceSpec_Mode_name, int32(x))
}
func (ServiceSpec_Mode) EnumDescriptor() ([]byte, []int) { return fileDescriptorSpecs, []int{3, 1} }

// Annotations provide useful information to identify API objects. They are
// common to all API specs.
type Annotations struct {
	Name   string            `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Labels map[string]string `protobuf:"bytes,2,rep,name=labels" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (m *Annotations) Reset()                    { *m = Annotations{} }
func (*Annotations) ProtoMessage()               {}
func (*Annotations) Descriptor() ([]byte, []int) { return fileDescriptorSpecs, []int{0} }

type NodeSpec struct {
	Annotations Annotations `protobuf:"bytes,1,opt,name=annotations" json:"annotations"`
	// Availability allows a user to control the current scheduling status of a
	// node.
	Availability NodeSpec_Availability `protobuf:"varint,2,opt,name=availability,proto3,enum=docker.cluster.api.NodeSpec_Availability" json:"availability,omitempty"`
}

func (m *NodeSpec) Reset()                    { *m = NodeSpec{} }
func (*NodeSpec) ProtoMessage()               {}
func (*NodeSpec) Descriptor() ([]byte, []int) { return fileDescriptorSpecs, []int{1} }

type MemberSpec struct {
	Annotations Annotations `protobuf:"bytes,1,opt,name=annotations" json:"annotations"`
}

func (m *MemberSpec) Reset()                    { *m = MemberSpec{} }
func (*MemberSpec) ProtoMessage()               {}
func (*MemberSpec) Descriptor() ([]byte, []int) { return fileDescriptorSpecs, []int{2} }

// ServiceSpec defines the properties of a service.
//
// A service instructs the cluster in orchestrating repeated instances of a
// template, implemented as tasks. Based on the number of instances, scheduling
// strategy and restart policy, a number of application-level behaviors can be
// defined.
type ServiceSpec struct {
	Annotations Annotations `protobuf:"bytes,1,opt,name=annotations" json:"annotations"`
	// Template defines the base configuration for tasks created for this service.
	Template *TaskSpec `protobuf:"bytes,2,opt,name=template" json:"template,omitempty"`
	// Instances specifies the number of instances of the service service that
	// should be running.
	Instances int64 `protobuf:"varint,3,opt,name=instances,proto3" json:"instances,omitempty"`
	// RestartPolicy specifies what to do when a task fails or finishes.
	Restart  *RestartPolicy       `protobuf:"bytes,4,opt,name=restart" json:"restart,omitempty"`
	Strategy ServiceSpec_Strategy `protobuf:"varint,5,opt,name=strategy,proto3,enum=docker.cluster.api.ServiceSpec_Strategy" json:"strategy,omitempty"`
	// Mode defines the reconcilation target for the service. This effects the
	// target state sought to satisfy the given service.
	Mode ServiceSpec_Mode `protobuf:"varint,6,opt,name=mode,proto3,enum=docker.cluster.api.ServiceSpec_Mode" json:"mode,omitempty"`
	// UpdateStrategy controls the rate and policy of updates.
	Update *UpdateStrategy `protobuf:"bytes,7,opt,name=update" json:"update,omitempty"`
	// Service endpoint specifies the user provided configuration
	// to properly discover and load balance a service.
	Endpoint *Endpoint `protobuf:"bytes,8,opt,name=endpoint" json:"endpoint,omitempty"`
}

func (m *ServiceSpec) Reset()                    { *m = ServiceSpec{} }
func (*ServiceSpec) ProtoMessage()               {}
func (*ServiceSpec) Descriptor() ([]byte, []int) { return fileDescriptorSpecs, []int{3} }

// TaskSpec defines properties required by the agent for execution.
type TaskSpec struct {
	// Types that are valid to be assigned to Runtime:
	//	*TaskSpec_Container
	Runtime isTaskSpec_Runtime `protobuf_oneof:"runtime"`
}

func (m *TaskSpec) Reset()                    { *m = TaskSpec{} }
func (*TaskSpec) ProtoMessage()               {}
func (*TaskSpec) Descriptor() ([]byte, []int) { return fileDescriptorSpecs, []int{4} }

type isTaskSpec_Runtime interface {
	isTaskSpec_Runtime()
	MarshalTo([]byte) (int, error)
	Size() int
}

type TaskSpec_Container struct {
	Container *Container `protobuf:"bytes,1,opt,name=container,oneof"`
}

func (*TaskSpec_Container) isTaskSpec_Runtime() {}

func (m *TaskSpec) GetRuntime() isTaskSpec_Runtime {
	if m != nil {
		return m.Runtime
	}
	return nil
}

func (m *TaskSpec) GetContainer() *Container {
	if x, ok := m.GetRuntime().(*TaskSpec_Container); ok {
		return x.Container
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*TaskSpec) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _TaskSpec_OneofMarshaler, _TaskSpec_OneofUnmarshaler, _TaskSpec_OneofSizer, []interface{}{
		(*TaskSpec_Container)(nil),
	}
}

func _TaskSpec_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*TaskSpec)
	// runtime
	switch x := m.Runtime.(type) {
	case *TaskSpec_Container:
		_ = b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Container); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("TaskSpec.Runtime has unexpected type %T", x)
	}
	return nil
}

func _TaskSpec_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*TaskSpec)
	switch tag {
	case 1: // runtime.container
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Container)
		err := b.DecodeMessage(msg)
		m.Runtime = &TaskSpec_Container{msg}
		return true, err
	default:
		return false, nil
	}
}

func _TaskSpec_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*TaskSpec)
	// runtime
	switch x := m.Runtime.(type) {
	case *TaskSpec_Container:
		s := proto.Size(x.Container)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// VolumeSpec defines the properties of a Volume.
type VolumeSpec struct {
	Annotations Annotations `protobuf:"bytes,1,opt,name=annotations" json:"annotations"`
	// Driver specific configuration consumed by the Volume driver.
	DriverConfiguration *Driver `protobuf:"bytes,2,opt,name=driver_configuration,json=driverConfiguration" json:"driver_configuration,omitempty"`
}

func (m *VolumeSpec) Reset()                    { *m = VolumeSpec{} }
func (*VolumeSpec) ProtoMessage()               {}
func (*VolumeSpec) Descriptor() ([]byte, []int) { return fileDescriptorSpecs, []int{5} }

// NetworkSpec specifies user defined network parameters.
type NetworkSpec struct {
	Annotations Annotations `protobuf:"bytes,1,opt,name=annotations" json:"annotations"`
	// Driver specific configuration consumed by the network driver.
	DriverConfiguration *Driver `protobuf:"bytes,2,opt,name=driver_configuration,json=driverConfiguration" json:"driver_configuration,omitempty"`
	// IPv6Enabled enables support for IPv6 on the network.
	Ipv6Enabled bool `protobuf:"varint,3,opt,name=ipv6_enabled,json=ipv6Enabled,proto3" json:"ipv6_enabled,omitempty"`
	// internal restricts external access to the network. This may be
	// accomplished by disabling the default gateway or through other means.
	Internal bool         `protobuf:"varint,4,opt,name=internal,proto3" json:"internal,omitempty"`
	IPAM     *IPAMOptions `protobuf:"bytes,5,opt,name=ipam" json:"ipam,omitempty"`
}

func (m *NetworkSpec) Reset()                    { *m = NetworkSpec{} }
func (*NetworkSpec) ProtoMessage()               {}
func (*NetworkSpec) Descriptor() ([]byte, []int) { return fileDescriptorSpecs, []int{6} }

func init() {
	proto.RegisterType((*Annotations)(nil), "docker.cluster.api.Annotations")
	proto.RegisterType((*NodeSpec)(nil), "docker.cluster.api.NodeSpec")
	proto.RegisterType((*MemberSpec)(nil), "docker.cluster.api.MemberSpec")
	proto.RegisterType((*ServiceSpec)(nil), "docker.cluster.api.ServiceSpec")
	proto.RegisterType((*TaskSpec)(nil), "docker.cluster.api.TaskSpec")
	proto.RegisterType((*VolumeSpec)(nil), "docker.cluster.api.VolumeSpec")
	proto.RegisterType((*NetworkSpec)(nil), "docker.cluster.api.NetworkSpec")
	proto.RegisterEnum("docker.cluster.api.NodeSpec_Availability", NodeSpec_Availability_name, NodeSpec_Availability_value)
	proto.RegisterEnum("docker.cluster.api.ServiceSpec_Strategy", ServiceSpec_Strategy_name, ServiceSpec_Strategy_value)
	proto.RegisterEnum("docker.cluster.api.ServiceSpec_Mode", ServiceSpec_Mode_name, ServiceSpec_Mode_value)
}

func (m *Annotations) Copy() *Annotations {
	if m == nil {
		return nil
	}

	o := &Annotations{
		Name: m.Name,
	}

	if m.Labels != nil {
		o.Labels = make(map[string]string)
		for k, v := range m.Labels {
			o.Labels[k] = v
		}
	}

	return o
}

func (m *NodeSpec) Copy() *NodeSpec {
	if m == nil {
		return nil
	}

	o := &NodeSpec{
		Annotations:  *m.Annotations.Copy(),
		Availability: m.Availability,
	}

	return o
}

func (m *MemberSpec) Copy() *MemberSpec {
	if m == nil {
		return nil
	}

	o := &MemberSpec{
		Annotations: *m.Annotations.Copy(),
	}

	return o
}

func (m *ServiceSpec) Copy() *ServiceSpec {
	if m == nil {
		return nil
	}

	o := &ServiceSpec{
		Annotations: *m.Annotations.Copy(),
		Template:    m.Template.Copy(),
		Instances:   m.Instances,
		Restart:     m.Restart.Copy(),
		Strategy:    m.Strategy,
		Mode:        m.Mode,
		Update:      m.Update.Copy(),
		Endpoint:    m.Endpoint.Copy(),
	}

	return o
}

func (m *TaskSpec) Copy() *TaskSpec {
	if m == nil {
		return nil
	}

	o := &TaskSpec{}

	switch m.Runtime.(type) {
	case *TaskSpec_Container:
		i := &TaskSpec_Container{
			Container: m.GetContainer().Copy(),
		}

		o.Runtime = i
	}

	return o
}

func (m *VolumeSpec) Copy() *VolumeSpec {
	if m == nil {
		return nil
	}

	o := &VolumeSpec{
		Annotations:         *m.Annotations.Copy(),
		DriverConfiguration: m.DriverConfiguration.Copy(),
	}

	return o
}

func (m *NetworkSpec) Copy() *NetworkSpec {
	if m == nil {
		return nil
	}

	o := &NetworkSpec{
		Annotations:         *m.Annotations.Copy(),
		DriverConfiguration: m.DriverConfiguration.Copy(),
		Ipv6Enabled:         m.Ipv6Enabled,
		Internal:            m.Internal,
		IPAM:                m.IPAM.Copy(),
	}

	return o
}

func (this *Annotations) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&api.Annotations{")
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	keysForLabels := make([]string, 0, len(this.Labels))
	for k, _ := range this.Labels {
		keysForLabels = append(keysForLabels, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForLabels)
	mapStringForLabels := "map[string]string{"
	for _, k := range keysForLabels {
		mapStringForLabels += fmt.Sprintf("%#v: %#v,", k, this.Labels[k])
	}
	mapStringForLabels += "}"
	if this.Labels != nil {
		s = append(s, "Labels: "+mapStringForLabels+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *NodeSpec) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&api.NodeSpec{")
	s = append(s, "Annotations: "+strings.Replace(this.Annotations.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "Availability: "+fmt.Sprintf("%#v", this.Availability)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *MemberSpec) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&api.MemberSpec{")
	s = append(s, "Annotations: "+strings.Replace(this.Annotations.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ServiceSpec) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 12)
	s = append(s, "&api.ServiceSpec{")
	s = append(s, "Annotations: "+strings.Replace(this.Annotations.GoString(), `&`, ``, 1)+",\n")
	if this.Template != nil {
		s = append(s, "Template: "+fmt.Sprintf("%#v", this.Template)+",\n")
	}
	s = append(s, "Instances: "+fmt.Sprintf("%#v", this.Instances)+",\n")
	if this.Restart != nil {
		s = append(s, "Restart: "+fmt.Sprintf("%#v", this.Restart)+",\n")
	}
	s = append(s, "Strategy: "+fmt.Sprintf("%#v", this.Strategy)+",\n")
	s = append(s, "Mode: "+fmt.Sprintf("%#v", this.Mode)+",\n")
	if this.Update != nil {
		s = append(s, "Update: "+fmt.Sprintf("%#v", this.Update)+",\n")
	}
	if this.Endpoint != nil {
		s = append(s, "Endpoint: "+fmt.Sprintf("%#v", this.Endpoint)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *TaskSpec) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&api.TaskSpec{")
	if this.Runtime != nil {
		s = append(s, "Runtime: "+fmt.Sprintf("%#v", this.Runtime)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *TaskSpec_Container) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&api.TaskSpec_Container{` +
		`Container:` + fmt.Sprintf("%#v", this.Container) + `}`}, ", ")
	return s
}
func (this *VolumeSpec) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&api.VolumeSpec{")
	s = append(s, "Annotations: "+strings.Replace(this.Annotations.GoString(), `&`, ``, 1)+",\n")
	if this.DriverConfiguration != nil {
		s = append(s, "DriverConfiguration: "+fmt.Sprintf("%#v", this.DriverConfiguration)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *NetworkSpec) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&api.NetworkSpec{")
	s = append(s, "Annotations: "+strings.Replace(this.Annotations.GoString(), `&`, ``, 1)+",\n")
	if this.DriverConfiguration != nil {
		s = append(s, "DriverConfiguration: "+fmt.Sprintf("%#v", this.DriverConfiguration)+",\n")
	}
	s = append(s, "Ipv6Enabled: "+fmt.Sprintf("%#v", this.Ipv6Enabled)+",\n")
	s = append(s, "Internal: "+fmt.Sprintf("%#v", this.Internal)+",\n")
	if this.IPAM != nil {
		s = append(s, "IPAM: "+fmt.Sprintf("%#v", this.IPAM)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringSpecs(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}
func extensionToGoStringSpecs(e map[int32]github_com_gogo_protobuf_proto.Extension) string {
	if e == nil {
		return "nil"
	}
	s := "map[int32]proto.Extension{"
	keys := make([]int, 0, len(e))
	for k := range e {
		keys = append(keys, int(k))
	}
	sort.Ints(keys)
	ss := []string{}
	for _, k := range keys {
		ss = append(ss, strconv.Itoa(k)+": "+e[int32(k)].GoString())
	}
	s += strings.Join(ss, ",") + "}"
	return s
}
func (m *Annotations) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Annotations) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintSpecs(data, i, uint64(len(m.Name)))
		i += copy(data[i:], m.Name)
	}
	if len(m.Labels) > 0 {
		for k, _ := range m.Labels {
			data[i] = 0x12
			i++
			v := m.Labels[k]
			mapSize := 1 + len(k) + sovSpecs(uint64(len(k))) + 1 + len(v) + sovSpecs(uint64(len(v)))
			i = encodeVarintSpecs(data, i, uint64(mapSize))
			data[i] = 0xa
			i++
			i = encodeVarintSpecs(data, i, uint64(len(k)))
			i += copy(data[i:], k)
			data[i] = 0x12
			i++
			i = encodeVarintSpecs(data, i, uint64(len(v)))
			i += copy(data[i:], v)
		}
	}
	return i, nil
}

func (m *NodeSpec) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *NodeSpec) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	data[i] = 0xa
	i++
	i = encodeVarintSpecs(data, i, uint64(m.Annotations.Size()))
	n1, err := m.Annotations.MarshalTo(data[i:])
	if err != nil {
		return 0, err
	}
	i += n1
	if m.Availability != 0 {
		data[i] = 0x10
		i++
		i = encodeVarintSpecs(data, i, uint64(m.Availability))
	}
	return i, nil
}

func (m *MemberSpec) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *MemberSpec) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	data[i] = 0xa
	i++
	i = encodeVarintSpecs(data, i, uint64(m.Annotations.Size()))
	n2, err := m.Annotations.MarshalTo(data[i:])
	if err != nil {
		return 0, err
	}
	i += n2
	return i, nil
}

func (m *ServiceSpec) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *ServiceSpec) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	data[i] = 0xa
	i++
	i = encodeVarintSpecs(data, i, uint64(m.Annotations.Size()))
	n3, err := m.Annotations.MarshalTo(data[i:])
	if err != nil {
		return 0, err
	}
	i += n3
	if m.Template != nil {
		data[i] = 0x12
		i++
		i = encodeVarintSpecs(data, i, uint64(m.Template.Size()))
		n4, err := m.Template.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	if m.Instances != 0 {
		data[i] = 0x18
		i++
		i = encodeVarintSpecs(data, i, uint64(m.Instances))
	}
	if m.Restart != nil {
		data[i] = 0x22
		i++
		i = encodeVarintSpecs(data, i, uint64(m.Restart.Size()))
		n5, err := m.Restart.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	if m.Strategy != 0 {
		data[i] = 0x28
		i++
		i = encodeVarintSpecs(data, i, uint64(m.Strategy))
	}
	if m.Mode != 0 {
		data[i] = 0x30
		i++
		i = encodeVarintSpecs(data, i, uint64(m.Mode))
	}
	if m.Update != nil {
		data[i] = 0x3a
		i++
		i = encodeVarintSpecs(data, i, uint64(m.Update.Size()))
		n6, err := m.Update.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	if m.Endpoint != nil {
		data[i] = 0x42
		i++
		i = encodeVarintSpecs(data, i, uint64(m.Endpoint.Size()))
		n7, err := m.Endpoint.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	return i, nil
}

func (m *TaskSpec) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *TaskSpec) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Runtime != nil {
		nn8, err := m.Runtime.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += nn8
	}
	return i, nil
}

func (m *TaskSpec_Container) MarshalTo(data []byte) (int, error) {
	i := 0
	if m.Container != nil {
		data[i] = 0xa
		i++
		i = encodeVarintSpecs(data, i, uint64(m.Container.Size()))
		n9, err := m.Container.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n9
	}
	return i, nil
}
func (m *VolumeSpec) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *VolumeSpec) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	data[i] = 0xa
	i++
	i = encodeVarintSpecs(data, i, uint64(m.Annotations.Size()))
	n10, err := m.Annotations.MarshalTo(data[i:])
	if err != nil {
		return 0, err
	}
	i += n10
	if m.DriverConfiguration != nil {
		data[i] = 0x12
		i++
		i = encodeVarintSpecs(data, i, uint64(m.DriverConfiguration.Size()))
		n11, err := m.DriverConfiguration.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n11
	}
	return i, nil
}

func (m *NetworkSpec) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *NetworkSpec) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	data[i] = 0xa
	i++
	i = encodeVarintSpecs(data, i, uint64(m.Annotations.Size()))
	n12, err := m.Annotations.MarshalTo(data[i:])
	if err != nil {
		return 0, err
	}
	i += n12
	if m.DriverConfiguration != nil {
		data[i] = 0x12
		i++
		i = encodeVarintSpecs(data, i, uint64(m.DriverConfiguration.Size()))
		n13, err := m.DriverConfiguration.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n13
	}
	if m.Ipv6Enabled {
		data[i] = 0x18
		i++
		if m.Ipv6Enabled {
			data[i] = 1
		} else {
			data[i] = 0
		}
		i++
	}
	if m.Internal {
		data[i] = 0x20
		i++
		if m.Internal {
			data[i] = 1
		} else {
			data[i] = 0
		}
		i++
	}
	if m.IPAM != nil {
		data[i] = 0x2a
		i++
		i = encodeVarintSpecs(data, i, uint64(m.IPAM.Size()))
		n14, err := m.IPAM.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n14
	}
	return i, nil
}

func encodeFixed64Specs(data []byte, offset int, v uint64) int {
	data[offset] = uint8(v)
	data[offset+1] = uint8(v >> 8)
	data[offset+2] = uint8(v >> 16)
	data[offset+3] = uint8(v >> 24)
	data[offset+4] = uint8(v >> 32)
	data[offset+5] = uint8(v >> 40)
	data[offset+6] = uint8(v >> 48)
	data[offset+7] = uint8(v >> 56)
	return offset + 8
}
func encodeFixed32Specs(data []byte, offset int, v uint32) int {
	data[offset] = uint8(v)
	data[offset+1] = uint8(v >> 8)
	data[offset+2] = uint8(v >> 16)
	data[offset+3] = uint8(v >> 24)
	return offset + 4
}
func encodeVarintSpecs(data []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		data[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	data[offset] = uint8(v)
	return offset + 1
}

func (m *Annotations) Size() (n int) {
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovSpecs(uint64(l))
	}
	if len(m.Labels) > 0 {
		for k, v := range m.Labels {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovSpecs(uint64(len(k))) + 1 + len(v) + sovSpecs(uint64(len(v)))
			n += mapEntrySize + 1 + sovSpecs(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *NodeSpec) Size() (n int) {
	var l int
	_ = l
	l = m.Annotations.Size()
	n += 1 + l + sovSpecs(uint64(l))
	if m.Availability != 0 {
		n += 1 + sovSpecs(uint64(m.Availability))
	}
	return n
}

func (m *MemberSpec) Size() (n int) {
	var l int
	_ = l
	l = m.Annotations.Size()
	n += 1 + l + sovSpecs(uint64(l))
	return n
}

func (m *ServiceSpec) Size() (n int) {
	var l int
	_ = l
	l = m.Annotations.Size()
	n += 1 + l + sovSpecs(uint64(l))
	if m.Template != nil {
		l = m.Template.Size()
		n += 1 + l + sovSpecs(uint64(l))
	}
	if m.Instances != 0 {
		n += 1 + sovSpecs(uint64(m.Instances))
	}
	if m.Restart != nil {
		l = m.Restart.Size()
		n += 1 + l + sovSpecs(uint64(l))
	}
	if m.Strategy != 0 {
		n += 1 + sovSpecs(uint64(m.Strategy))
	}
	if m.Mode != 0 {
		n += 1 + sovSpecs(uint64(m.Mode))
	}
	if m.Update != nil {
		l = m.Update.Size()
		n += 1 + l + sovSpecs(uint64(l))
	}
	if m.Endpoint != nil {
		l = m.Endpoint.Size()
		n += 1 + l + sovSpecs(uint64(l))
	}
	return n
}

func (m *TaskSpec) Size() (n int) {
	var l int
	_ = l
	if m.Runtime != nil {
		n += m.Runtime.Size()
	}
	return n
}

func (m *TaskSpec_Container) Size() (n int) {
	var l int
	_ = l
	if m.Container != nil {
		l = m.Container.Size()
		n += 1 + l + sovSpecs(uint64(l))
	}
	return n
}
func (m *VolumeSpec) Size() (n int) {
	var l int
	_ = l
	l = m.Annotations.Size()
	n += 1 + l + sovSpecs(uint64(l))
	if m.DriverConfiguration != nil {
		l = m.DriverConfiguration.Size()
		n += 1 + l + sovSpecs(uint64(l))
	}
	return n
}

func (m *NetworkSpec) Size() (n int) {
	var l int
	_ = l
	l = m.Annotations.Size()
	n += 1 + l + sovSpecs(uint64(l))
	if m.DriverConfiguration != nil {
		l = m.DriverConfiguration.Size()
		n += 1 + l + sovSpecs(uint64(l))
	}
	if m.Ipv6Enabled {
		n += 2
	}
	if m.Internal {
		n += 2
	}
	if m.IPAM != nil {
		l = m.IPAM.Size()
		n += 1 + l + sovSpecs(uint64(l))
	}
	return n
}

func sovSpecs(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozSpecs(x uint64) (n int) {
	return sovSpecs(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *Annotations) String() string {
	if this == nil {
		return "nil"
	}
	keysForLabels := make([]string, 0, len(this.Labels))
	for k, _ := range this.Labels {
		keysForLabels = append(keysForLabels, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForLabels)
	mapStringForLabels := "map[string]string{"
	for _, k := range keysForLabels {
		mapStringForLabels += fmt.Sprintf("%v: %v,", k, this.Labels[k])
	}
	mapStringForLabels += "}"
	s := strings.Join([]string{`&Annotations{`,
		`Name:` + fmt.Sprintf("%v", this.Name) + `,`,
		`Labels:` + mapStringForLabels + `,`,
		`}`,
	}, "")
	return s
}
func (this *NodeSpec) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&NodeSpec{`,
		`Annotations:` + strings.Replace(strings.Replace(this.Annotations.String(), "Annotations", "Annotations", 1), `&`, ``, 1) + `,`,
		`Availability:` + fmt.Sprintf("%v", this.Availability) + `,`,
		`}`,
	}, "")
	return s
}
func (this *MemberSpec) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&MemberSpec{`,
		`Annotations:` + strings.Replace(strings.Replace(this.Annotations.String(), "Annotations", "Annotations", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ServiceSpec) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ServiceSpec{`,
		`Annotations:` + strings.Replace(strings.Replace(this.Annotations.String(), "Annotations", "Annotations", 1), `&`, ``, 1) + `,`,
		`Template:` + strings.Replace(fmt.Sprintf("%v", this.Template), "TaskSpec", "TaskSpec", 1) + `,`,
		`Instances:` + fmt.Sprintf("%v", this.Instances) + `,`,
		`Restart:` + strings.Replace(fmt.Sprintf("%v", this.Restart), "RestartPolicy", "RestartPolicy", 1) + `,`,
		`Strategy:` + fmt.Sprintf("%v", this.Strategy) + `,`,
		`Mode:` + fmt.Sprintf("%v", this.Mode) + `,`,
		`Update:` + strings.Replace(fmt.Sprintf("%v", this.Update), "UpdateStrategy", "UpdateStrategy", 1) + `,`,
		`Endpoint:` + strings.Replace(fmt.Sprintf("%v", this.Endpoint), "Endpoint", "Endpoint", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *TaskSpec) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&TaskSpec{`,
		`Runtime:` + fmt.Sprintf("%v", this.Runtime) + `,`,
		`}`,
	}, "")
	return s
}
func (this *TaskSpec_Container) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&TaskSpec_Container{`,
		`Container:` + strings.Replace(fmt.Sprintf("%v", this.Container), "Container", "Container", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *VolumeSpec) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&VolumeSpec{`,
		`Annotations:` + strings.Replace(strings.Replace(this.Annotations.String(), "Annotations", "Annotations", 1), `&`, ``, 1) + `,`,
		`DriverConfiguration:` + strings.Replace(fmt.Sprintf("%v", this.DriverConfiguration), "Driver", "Driver", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *NetworkSpec) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&NetworkSpec{`,
		`Annotations:` + strings.Replace(strings.Replace(this.Annotations.String(), "Annotations", "Annotations", 1), `&`, ``, 1) + `,`,
		`DriverConfiguration:` + strings.Replace(fmt.Sprintf("%v", this.DriverConfiguration), "Driver", "Driver", 1) + `,`,
		`Ipv6Enabled:` + fmt.Sprintf("%v", this.Ipv6Enabled) + `,`,
		`Internal:` + fmt.Sprintf("%v", this.Internal) + `,`,
		`IPAM:` + strings.Replace(fmt.Sprintf("%v", this.IPAM), "IPAMOptions", "IPAMOptions", 1) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringSpecs(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *Annotations) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSpecs
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Annotations: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Annotations: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Labels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			var keykey uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				keykey |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			var stringLenmapkey uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLenmapkey |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLenmapkey := int(stringLenmapkey)
			if intStringLenmapkey < 0 {
				return ErrInvalidLengthSpecs
			}
			postStringIndexmapkey := iNdEx + intStringLenmapkey
			if postStringIndexmapkey > l {
				return io.ErrUnexpectedEOF
			}
			mapkey := string(data[iNdEx:postStringIndexmapkey])
			iNdEx = postStringIndexmapkey
			var valuekey uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				valuekey |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			var stringLenmapvalue uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLenmapvalue |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLenmapvalue := int(stringLenmapvalue)
			if intStringLenmapvalue < 0 {
				return ErrInvalidLengthSpecs
			}
			postStringIndexmapvalue := iNdEx + intStringLenmapvalue
			if postStringIndexmapvalue > l {
				return io.ErrUnexpectedEOF
			}
			mapvalue := string(data[iNdEx:postStringIndexmapvalue])
			iNdEx = postStringIndexmapvalue
			if m.Labels == nil {
				m.Labels = make(map[string]string)
			}
			m.Labels[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSpecs(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSpecs
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NodeSpec) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSpecs
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NodeSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NodeSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Annotations", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Annotations.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Availability", wireType)
			}
			m.Availability = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.Availability |= (NodeSpec_Availability(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipSpecs(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSpecs
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MemberSpec) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSpecs
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MemberSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MemberSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Annotations", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Annotations.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSpecs(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSpecs
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ServiceSpec) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSpecs
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ServiceSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ServiceSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Annotations", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Annotations.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Template", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Template == nil {
				m.Template = &TaskSpec{}
			}
			if err := m.Template.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Instances", wireType)
			}
			m.Instances = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.Instances |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Restart", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Restart == nil {
				m.Restart = &RestartPolicy{}
			}
			if err := m.Restart.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Strategy", wireType)
			}
			m.Strategy = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.Strategy |= (ServiceSpec_Strategy(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Mode", wireType)
			}
			m.Mode = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.Mode |= (ServiceSpec_Mode(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Update", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Update == nil {
				m.Update = &UpdateStrategy{}
			}
			if err := m.Update.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Endpoint", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Endpoint == nil {
				m.Endpoint = &Endpoint{}
			}
			if err := m.Endpoint.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSpecs(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSpecs
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TaskSpec) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSpecs
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TaskSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TaskSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Container", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Container{}
			if err := v.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Runtime = &TaskSpec_Container{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSpecs(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSpecs
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *VolumeSpec) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSpecs
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: VolumeSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: VolumeSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Annotations", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Annotations.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DriverConfiguration", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DriverConfiguration == nil {
				m.DriverConfiguration = &Driver{}
			}
			if err := m.DriverConfiguration.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSpecs(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSpecs
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NetworkSpec) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSpecs
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NetworkSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NetworkSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Annotations", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Annotations.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DriverConfiguration", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DriverConfiguration == nil {
				m.DriverConfiguration = &Driver{}
			}
			if err := m.DriverConfiguration.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ipv6Enabled", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Ipv6Enabled = bool(v != 0)
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Internal", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Internal = bool(v != 0)
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IPAM", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSpecs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.IPAM == nil {
				m.IPAM = &IPAMOptions{}
			}
			if err := m.IPAM.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSpecs(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSpecs
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipSpecs(data []byte) (n int, err error) {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowSpecs
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if data[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowSpecs
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthSpecs
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowSpecs
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := data[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipSpecs(data[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthSpecs = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowSpecs   = fmt.Errorf("proto: integer overflow")
)

var fileDescriptorSpecs = []byte{
	// 844 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0xcc, 0x55, 0x4f, 0x6f, 0x1b, 0x45,
	0x14, 0xf7, 0x3a, 0x8e, 0xbb, 0x79, 0x1b, 0x81, 0x99, 0x9a, 0x62, 0x56, 0x21, 0x49, 0x57, 0x15,
	0x0a, 0x7f, 0x64, 0x50, 0x90, 0xaa, 0x52, 0xc4, 0x61, 0x6d, 0x6f, 0x53, 0x8b, 0xd8, 0xb5, 0xc6,
	0x4e, 0x24, 0x4e, 0xd6, 0x78, 0x3d, 0x98, 0x91, 0xd7, 0xb3, 0xab, 0xd9, 0xb1, 0x91, 0x6f, 0xc0,
	0xa9, 0xe2, 0x13, 0x70, 0xe1, 0x80, 0xca, 0x95, 0xef, 0x91, 0x23, 0x47, 0x4e, 0x15, 0xed, 0x27,
	0xe0, 0x23, 0x30, 0x3b, 0x5e, 0x3b, 0x9b, 0x76, 0xab, 0x5c, 0x72, 0xe0, 0x30, 0xf2, 0xcc, 0xdb,
	0xdf, 0x9f, 0x37, 0x6f, 0xde, 0x8c, 0xc1, 0x8a, 0x23, 0xea, 0xc7, 0xf5, 0x48, 0x84, 0x32, 0x44,
	0x68, 0x1c, 0xfa, 0x53, 0x2a, 0xea, 0x7e, 0x30, 0x8f, 0xa5, 0xfa, 0x25, 0x11, 0xb3, 0x2d, 0xb9,
	0x8c, 0x68, 0x0a, 0xb0, 0xab, 0x93, 0x70, 0x12, 0xea, 0xe9, 0x67, 0xc9, 0x6c, 0x15, 0x75, 0x7e,
	0x37, 0xc0, 0x72, 0x39, 0x0f, 0x25, 0x91, 0x2c, 0xe4, 0x31, 0x42, 0x50, 0xe2, 0x64, 0x46, 0x6b,
	0xc6, 0xa1, 0x71, 0xb4, 0x83, 0xf5, 0x1c, 0x35, 0xa1, 0x1c, 0x90, 0x11, 0x0d, 0xe2, 0x5a, 0xf1,
	0x70, 0xeb, 0xc8, 0x3a, 0xfe, 0xa4, 0xfe, 0xba, 0x57, 0x3d, 0x23, 0x52, 0x3f, 0xd5, 0x68, 0x8f,
	0x4b, 0xb1, 0xc4, 0x29, 0xd5, 0xfe, 0x12, 0xac, 0x4c, 0x18, 0x55, 0x60, 0x6b, 0x4a, 0x97, 0xa9,
	0x4d, 0x32, 0x45, 0x55, 0xd8, 0x5e, 0x90, 0x60, 0x4e, 0x95, 0x49, 0x12, 0x5b, 0x2d, 0x1e, 0x16,
	0x1f, 0x18, 0xce, 0x9f, 0x45, 0x30, 0xbb, 0xe1, 0x98, 0xf6, 0xd5, 0x76, 0xd1, 0x09, 0x58, 0xe4,
	0xd2, 0x4a, 0x0b, 0x58, 0xc7, 0x07, 0xd7, 0x64, 0xd4, 0x28, 0x5d, 0x3c, 0x3f, 0x28, 0xe0, 0x2c,
	0x13, 0x75, 0x60, 0x97, 0x2c, 0x08, 0x53, 0xe9, 0xb1, 0x80, 0xc9, 0xa5, 0xb6, 0x7d, 0xeb, 0xf8,
	0xa3, 0x3c, 0xa5, 0xb5, 0x79, 0xdd, 0xcd, 0x10, 0xf0, 0x15, 0xba, 0xf3, 0xd4, 0x80, 0xdd, 0xec,
	0x67, 0xf4, 0x21, 0x94, 0xdd, 0xe6, 0xa0, 0x7d, 0xee, 0x55, 0x0a, 0xb6, 0xfd, 0xcb, 0x6f, 0x87,
	0x77, 0x12, 0x95, 0x2c, 0xc2, 0xf5, 0x25, 0x5b, 0x50, 0x74, 0x0f, 0xb6, 0x7b, 0xee, 0x59, 0xdf,
	0xab, 0x18, 0xf6, 0xfb, 0x0a, 0xf6, 0xee, 0xab, 0xb0, 0x1e, 0x99, 0xc7, 0x1a, 0xd5, 0xc2, 0x6e,
	0xbb, 0x5b, 0x29, 0xe6, 0xa3, 0x5a, 0x82, 0x30, 0x6e, 0x97, 0x9e, 0x3e, 0xdb, 0x2f, 0x38, 0x67,
	0x00, 0x1d, 0x3a, 0x1b, 0x51, 0x71, 0xa3, 0x05, 0x73, 0x7e, 0x2a, 0x83, 0xd5, 0xa7, 0x62, 0xc1,
	0xfc, 0x1b, 0x3e, 0x89, 0x07, 0x60, 0x4a, 0x3a, 0x8b, 0x02, 0x22, 0x57, 0x87, 0x6f, 0x1d, 0xef,
	0xe5, 0xa9, 0x0c, 0x48, 0x3c, 0x4d, 0x8c, 0xf1, 0x06, 0x8d, 0xf6, 0x60, 0x87, 0xf1, 0x58, 0x12,
	0xee, 0xd3, 0xb8, 0xb6, 0xa5, 0xa8, 0x5b, 0xf8, 0x32, 0x80, 0xbe, 0x82, 0x5b, 0x82, 0xaa, 0x85,
	0x90, 0xb5, 0x92, 0x96, 0xbd, 0x9b, 0x27, 0x8b, 0x57, 0x90, 0x5e, 0x18, 0x30, 0x7f, 0x89, 0xd7,
	0x0c, 0xd4, 0x02, 0x33, 0x96, 0x42, 0x99, 0x4c, 0x96, 0xb5, 0x6d, 0xdd, 0x1a, 0x47, 0x79, 0xec,
	0x4c, 0x41, 0xea, 0xfd, 0x14, 0x8f, 0x37, 0x4c, 0xb5, 0xb5, 0xd2, 0x4c, 0x9d, 0x54, 0xad, 0xac,
	0x15, 0xee, 0x5d, 0xa7, 0xd0, 0x51, 0x58, 0xac, 0x19, 0xe8, 0x21, 0x94, 0xe7, 0xd1, 0x38, 0x29,
	0xc9, 0x2d, 0x9d, 0xbb, 0x93, 0xc7, 0x3d, 0xd3, 0x88, 0x8d, 0x6f, 0xca, 0x48, 0x0a, 0x4a, 0xf9,
	0x38, 0x0a, 0x19, 0x97, 0x35, 0xf3, 0xcd, 0x05, 0xf5, 0x52, 0x0c, 0xde, 0xa0, 0x9d, 0x9f, 0x0d,
	0x30, 0xd7, 0x72, 0xe8, 0x3e, 0xbc, 0xd7, 0xf7, 0xf0, 0x79, 0xbb, 0xe9, 0x0d, 0xfb, 0x03, 0xec,
	0x0e, 0xbc, 0x93, 0x6f, 0x87, 0xfd, 0x1e, 0xf6, 0xdc, 0x96, 0x6a, 0x69, 0xdd, 0x85, 0xeb, 0xdc,
	0x53, 0x46, 0x3f, 0x12, 0x94, 0x8c, 0x95, 0x7d, 0xed, 0x35, 0x5e, 0xa3, 0xdd, 0xed, 0xb9, 0xcd,
	0x6f, 0x54, 0x93, 0xeb, 0xbb, 0xf0, 0x0a, 0xb1, 0xc1, 0x78, 0x8f, 0xf8, 0xd3, 0xb4, 0x7f, 0x7f,
	0x35, 0xa0, 0x94, 0x54, 0x02, 0x7d, 0x0e, 0xd5, 0xb5, 0x50, 0xe7, 0x49, 0xcb, 0x1b, 0xe2, 0xb3,
	0x6e, 0xb7, 0xdd, 0x3d, 0x51, 0xee, 0x77, 0x94, 0x08, 0x4a, 0x45, 0x74, 0xd1, 0xe6, 0x9c, 0x33,
	0x3e, 0x41, 0x9f, 0x02, 0xba, 0xc2, 0x68, 0xb8, 0x83, 0xe6, 0x63, 0x65, 0x5a, 0x55, 0xf8, 0x4a,
	0x06, 0xdf, 0x20, 0xd2, 0xff, 0x1e, 0x7d, 0x0c, 0xef, 0x5c, 0x41, 0x3f, 0x6a, 0x9f, 0x9e, 0xaa,
	0x0b, 0x76, 0x5b, 0x81, 0xdf, 0xce, 0x80, 0x1f, 0xb1, 0x20, 0x48, 0x53, 0x1b, 0x80, 0xb9, 0x6e,
	0x43, 0xf4, 0x35, 0xec, 0xf8, 0x21, 0x97, 0xea, 0xde, 0x51, 0x91, 0x76, 0xff, 0x07, 0x79, 0x65,
	0x6e, 0xae, 0x41, 0x8f, 0x0b, 0xf8, 0x92, 0xd1, 0xd8, 0x51, 0xdd, 0x39, 0xe7, 0x92, 0xcd, 0xa8,
	0xf3, 0x87, 0x01, 0x70, 0x1e, 0x06, 0xf3, 0xd9, 0x8d, 0x3f, 0x71, 0xd5, 0xb1, 0x50, 0x6f, 0x8c,
	0x18, 0x2a, 0xdb, 0xef, 0xd8, 0x64, 0x2e, 0xf4, 0x87, 0xf4, 0x92, 0xd9, 0x79, 0x8a, 0x2d, 0x8d,
	0xc7, 0xb7, 0x57, 0xbc, 0x66, 0x96, 0xe6, 0x3c, 0x2b, 0x82, 0xd5, 0xa5, 0xf2, 0x87, 0x50, 0x4c,
	0xff, 0xcf, 0x79, 0xa2, 0xbb, 0xb0, 0xcb, 0xa2, 0xc5, 0xfd, 0x21, 0xe5, 0x64, 0x14, 0xd0, 0xb1,
	0x7e, 0x18, 0x4c, 0x6c, 0x25, 0x31, 0x6f, 0x15, 0x42, 0x36, 0x98, 0xaa, 0xdd, 0xa9, 0xe0, 0x24,
	0xd0, 0x6f, 0x83, 0x89, 0x37, 0x6b, 0x75, 0xae, 0x25, 0x16, 0x91, 0x99, 0xbe, 0xf5, 0x6f, 0xd8,
	0x4f, 0xbb, 0xe7, 0x76, 0x9e, 0x44, 0xab, 0xfd, 0x98, 0x2f, 0x9f, 0x1f, 0x94, 0x92, 0x00, 0xd6,
	0xb4, 0xc6, 0xde, 0xc5, 0x8b, 0xfd, 0xc2, 0xdf, 0x6a, 0xfc, 0xfb, 0x62, 0xdf, 0xf8, 0xf1, 0xe5,
	0xbe, 0x71, 0xa1, 0xc6, 0x5f, 0x6a, 0xfc, 0xa3, 0xc6, 0xa8, 0xac, 0xff, 0x76, 0xbf, 0xf8, 0x2f,
	0x00, 0x00, 0xff, 0xff, 0xe6, 0xcd, 0x7c, 0xb4, 0xbc, 0x07, 0x00, 0x00,
}
