// Code generated by protoc-gen-gogo.
// source: objects.proto
// DO NOT EDIT!

package api

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "github.com/gogo/protobuf/gogoproto"

import strings "strings"
import github_com_gogo_protobuf_proto "github.com/gogo/protobuf/proto"
import sort "sort"
import strconv "strconv"
import reflect "reflect"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// Node provides the internal node state as seen by the cluster.
type Node struct {
	// ID specifies the identity of the node.
	ID string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Version tracks the last time the node was modified.
	Version Version `protobuf:"bytes,2,opt,name=version" json:"version"`
	// Spec defines the desired state of the node as specified by the user.
	// The system will honor this and will *never* modify it.
	Spec NodeSpec `protobuf:"bytes,3,opt,name=spec" json:"spec"`
	// Description encapsulated the properties of the Node as reported by the
	// agent.
	Description *NodeDescription `protobuf:"bytes,4,opt,name=description" json:"description,omitempty"`
	// Status provides the current status of the node, as seen by the manager.
	Status NodeStatus `protobuf:"bytes,5,opt,name=status" json:"status"`
}

func (m *Node) Reset()                    { *m = Node{} }
func (*Node) ProtoMessage()               {}
func (*Node) Descriptor() ([]byte, []int) { return fileDescriptorObjects, []int{0} }

// Member provides informations about the state of a manager in the cluster.
// A Member is essentially a Manager but from a Raft role perspective
// TODO(abronan): this is not an appropriate name for a top level object (specific to raft),
// this should be changed back to 'Manager'
type Member struct {
	// ID specifies the identity of the manager.
	ID   string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	Addr string `protobuf:"bytes,2,opt,name=addr,proto3" json:"addr,omitempty"`
	// MemberSpec declares labels applied to the Manager.
	Spec *MemberSpec `protobuf:"bytes,3,opt,name=spec" json:"spec,omitempty"`
	// Description encapsulates the properties of the Member as reported by another member of the Manager set.
	Description *MemberDescription `protobuf:"bytes,4,opt,name=description" json:"description,omitempty"`
	// Status provides the current status of the manager from the perspective of another manager.
	Status MemberStatus `protobuf:"bytes,5,opt,name=status" json:"status"`
}

func (m *Member) Reset()                    { *m = Member{} }
func (*Member) ProtoMessage()               {}
func (*Member) Descriptor() ([]byte, []int) { return fileDescriptorObjects, []int{1} }

type Service struct {
	ID string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Version tracks the last time the service was modified.
	Version Version     `protobuf:"bytes,2,opt,name=version" json:"version"`
	Spec    ServiceSpec `protobuf:"bytes,3,opt,name=spec" json:"spec"`
	// Runtime state of service endpoint. This may be different
	// from the spec version because the user may not have entered
	// the optional fields like node_port or virtual_ip and it
	// could be auto allocated by the system.
	Endpoint *Endpoint `protobuf:"bytes,4,opt,name=endpoint" json:"endpoint,omitempty"`
}

func (m *Service) Reset()                    { *m = Service{} }
func (*Service) ProtoMessage()               {}
func (*Service) Descriptor() ([]byte, []int) { return fileDescriptorObjects, []int{2} }

// Task specifies the parameters for implementing a Spec. A task is effectively
// immutable and idempotent. Once it is dispatched to a node, it will not be
// dispatched to another node.
type Task struct {
	ID string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Version tracks the last time the task was modified.
	Version Version `protobuf:"bytes,2,opt,name=version" json:"version"`
	// ServiceID indicates the service under which this task is orchestrated. This
	// should almost always be set.
	ServiceID string `protobuf:"bytes,3,opt,name=service_id,json=serviceId,proto3" json:"service_id,omitempty"`
	// Instance is the instance number for a task. For example, if a
	// running service has instances = 2, there will be a task with
	// instance = 1, and another with instance = 2.
	Instance uint64 `protobuf:"varint,4,opt,name=instance,proto3" json:"instance,omitempty"`
	// NodeID indicates the node to which the task is assigned. If this field
	// is empty or not set, the task is unassigned.
	NodeID string `protobuf:"bytes,5,opt,name=node_id,json=nodeId,proto3" json:"node_id,omitempty"`
	// Annotations inherits labels from the ServiceSpec.Annotations associated
	// with this task. It may include other labels added by the manager. The
	// name will be a human readable name, calculated based on the
	// ServiceSpec.Annotations.Name field.
	Annotations Annotations `protobuf:"bytes,6,opt,name=annotations" json:"annotations"`
	// Spec declares the runtime parameters for the task. This is copied out of
	// the service's template field.
	Spec   TaskSpec   `protobuf:"bytes,7,opt,name=spec" json:"spec"`
	Status TaskStatus `protobuf:"bytes,8,opt,name=status" json:"status"`
	// DesiredState is the target state for the task. It is set to
	// TaskStateRunning when a task is first created, and changed to
	// TaskStateDead if the manager wants to terminate the task. This field
	// is only written by the manager.
	DesiredState TaskState                 `protobuf:"varint,9,opt,name=desired_state,json=desiredState,proto3,enum=docker.cluster.api.TaskState" json:"desired_state,omitempty"`
	Networks     []*Task_NetworkAttachment `protobuf:"bytes,10,rep,name=networks" json:"networks,omitempty"`
	// A copy of runtime state of service endpoint from Service
	// object to be distributed to agents as part of the task.
	Endpoint *Endpoint `protobuf:"bytes,11,opt,name=endpoint" json:"endpoint,omitempty"`
}

func (m *Task) Reset()                    { *m = Task{} }
func (*Task) ProtoMessage()               {}
func (*Task) Descriptor() ([]byte, []int) { return fileDescriptorObjects, []int{3} }

type Task_NetworkAttachment struct {
	// Network state as a whole becomes part of Task so
	// that it always is available for use in agents so
	// that agents don't have any other dependency during execution.
	Network *Network `protobuf:"bytes,1,opt,name=network" json:"network,omitempty"`
	// List of IPv4/IPv6 addresses that are assigned to the task
	// as part of getting attached to this network.
	Addresses []string `protobuf:"bytes,2,rep,name=addresses" json:"addresses,omitempty"`
}

func (m *Task_NetworkAttachment) Reset()                    { *m = Task_NetworkAttachment{} }
func (*Task_NetworkAttachment) ProtoMessage()               {}
func (*Task_NetworkAttachment) Descriptor() ([]byte, []int) { return fileDescriptorObjects, []int{3, 0} }

type Volume struct {
	ID string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Version tracks the last time the volume was modified.
	Version Version    `protobuf:"bytes,2,opt,name=version" json:"version"`
	Spec    VolumeSpec `protobuf:"bytes,3,opt,name=spec" json:"spec"`
	// Driver specific operational state provided by the Volume driver.
	DriverState *Driver `protobuf:"bytes,4,opt,name=driver_state,json=driverState" json:"driver_state,omitempty"`
}

func (m *Volume) Reset()                    { *m = Volume{} }
func (*Volume) ProtoMessage()               {}
func (*Volume) Descriptor() ([]byte, []int) { return fileDescriptorObjects, []int{4} }

type Network struct {
	ID string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Version tracks the last time the network was modified.
	Version Version     `protobuf:"bytes,2,opt,name=version" json:"version"`
	Spec    NetworkSpec `protobuf:"bytes,3,opt,name=spec" json:"spec"`
	// Driver specific operational state provided by the network driver.
	DriverState *Driver `protobuf:"bytes,4,opt,name=driver_state,json=driverState" json:"driver_state,omitempty"`
	// Runtime state of IPAM options. This may not reflect the
	// ipam options from NetworkSpec.
	IPAM *IPAMOptions `protobuf:"bytes,5,opt,name=ipam" json:"ipam,omitempty"`
}

func (m *Network) Reset()                    { *m = Network{} }
func (*Network) ProtoMessage()               {}
func (*Network) Descriptor() ([]byte, []int) { return fileDescriptorObjects, []int{5} }

func init() {
	proto.RegisterType((*Node)(nil), "docker.cluster.api.Node")
	proto.RegisterType((*Member)(nil), "docker.cluster.api.Member")
	proto.RegisterType((*Service)(nil), "docker.cluster.api.Service")
	proto.RegisterType((*Task)(nil), "docker.cluster.api.Task")
	proto.RegisterType((*Task_NetworkAttachment)(nil), "docker.cluster.api.Task.NetworkAttachment")
	proto.RegisterType((*Volume)(nil), "docker.cluster.api.Volume")
	proto.RegisterType((*Network)(nil), "docker.cluster.api.Network")
}

func (m *Node) Copy() *Node {
	if m == nil {
		return nil
	}

	o := &Node{
		ID:          m.ID,
		Version:     *m.Version.Copy(),
		Spec:        *m.Spec.Copy(),
		Description: m.Description.Copy(),
		Status:      *m.Status.Copy(),
	}

	return o
}

func (m *Member) Copy() *Member {
	if m == nil {
		return nil
	}

	o := &Member{
		ID:          m.ID,
		Addr:        m.Addr,
		Spec:        m.Spec.Copy(),
		Description: m.Description.Copy(),
		Status:      *m.Status.Copy(),
	}

	return o
}

func (m *Service) Copy() *Service {
	if m == nil {
		return nil
	}

	o := &Service{
		ID:       m.ID,
		Version:  *m.Version.Copy(),
		Spec:     *m.Spec.Copy(),
		Endpoint: m.Endpoint.Copy(),
	}

	return o
}

func (m *Task) Copy() *Task {
	if m == nil {
		return nil
	}

	o := &Task{
		ID:           m.ID,
		Version:      *m.Version.Copy(),
		ServiceID:    m.ServiceID,
		Instance:     m.Instance,
		NodeID:       m.NodeID,
		Annotations:  *m.Annotations.Copy(),
		Spec:         *m.Spec.Copy(),
		Status:       *m.Status.Copy(),
		DesiredState: m.DesiredState,
		Endpoint:     m.Endpoint.Copy(),
	}

	if m.Networks != nil {
		o.Networks = make([]*Task_NetworkAttachment, 0, len(m.Networks))
		for _, v := range m.Networks {
			o.Networks = append(o.Networks, v.Copy())
		}
	}

	return o
}

func (m *Task_NetworkAttachment) Copy() *Task_NetworkAttachment {
	if m == nil {
		return nil
	}

	o := &Task_NetworkAttachment{
		Network: m.Network.Copy(),
	}

	if m.Addresses != nil {
		o.Addresses = make([]string, 0, len(m.Addresses))
		for _, v := range m.Addresses {
			o.Addresses = append(o.Addresses, v)
		}
	}

	return o
}

func (m *Volume) Copy() *Volume {
	if m == nil {
		return nil
	}

	o := &Volume{
		ID:          m.ID,
		Version:     *m.Version.Copy(),
		Spec:        *m.Spec.Copy(),
		DriverState: m.DriverState.Copy(),
	}

	return o
}

func (m *Network) Copy() *Network {
	if m == nil {
		return nil
	}

	o := &Network{
		ID:          m.ID,
		Version:     *m.Version.Copy(),
		Spec:        *m.Spec.Copy(),
		DriverState: m.DriverState.Copy(),
		IPAM:        m.IPAM.Copy(),
	}

	return o
}

func (this *Node) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&api.Node{")
	s = append(s, "ID: "+fmt.Sprintf("%#v", this.ID)+",\n")
	s = append(s, "Version: "+strings.Replace(this.Version.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "Spec: "+strings.Replace(this.Spec.GoString(), `&`, ``, 1)+",\n")
	if this.Description != nil {
		s = append(s, "Description: "+fmt.Sprintf("%#v", this.Description)+",\n")
	}
	s = append(s, "Status: "+strings.Replace(this.Status.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Member) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&api.Member{")
	s = append(s, "ID: "+fmt.Sprintf("%#v", this.ID)+",\n")
	s = append(s, "Addr: "+fmt.Sprintf("%#v", this.Addr)+",\n")
	if this.Spec != nil {
		s = append(s, "Spec: "+fmt.Sprintf("%#v", this.Spec)+",\n")
	}
	if this.Description != nil {
		s = append(s, "Description: "+fmt.Sprintf("%#v", this.Description)+",\n")
	}
	s = append(s, "Status: "+strings.Replace(this.Status.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Service) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&api.Service{")
	s = append(s, "ID: "+fmt.Sprintf("%#v", this.ID)+",\n")
	s = append(s, "Version: "+strings.Replace(this.Version.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "Spec: "+strings.Replace(this.Spec.GoString(), `&`, ``, 1)+",\n")
	if this.Endpoint != nil {
		s = append(s, "Endpoint: "+fmt.Sprintf("%#v", this.Endpoint)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Task) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 15)
	s = append(s, "&api.Task{")
	s = append(s, "ID: "+fmt.Sprintf("%#v", this.ID)+",\n")
	s = append(s, "Version: "+strings.Replace(this.Version.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "ServiceID: "+fmt.Sprintf("%#v", this.ServiceID)+",\n")
	s = append(s, "Instance: "+fmt.Sprintf("%#v", this.Instance)+",\n")
	s = append(s, "NodeID: "+fmt.Sprintf("%#v", this.NodeID)+",\n")
	s = append(s, "Annotations: "+strings.Replace(this.Annotations.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "Spec: "+strings.Replace(this.Spec.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "Status: "+strings.Replace(this.Status.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "DesiredState: "+fmt.Sprintf("%#v", this.DesiredState)+",\n")
	if this.Networks != nil {
		s = append(s, "Networks: "+fmt.Sprintf("%#v", this.Networks)+",\n")
	}
	if this.Endpoint != nil {
		s = append(s, "Endpoint: "+fmt.Sprintf("%#v", this.Endpoint)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Task_NetworkAttachment) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&api.Task_NetworkAttachment{")
	if this.Network != nil {
		s = append(s, "Network: "+fmt.Sprintf("%#v", this.Network)+",\n")
	}
	s = append(s, "Addresses: "+fmt.Sprintf("%#v", this.Addresses)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Volume) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&api.Volume{")
	s = append(s, "ID: "+fmt.Sprintf("%#v", this.ID)+",\n")
	s = append(s, "Version: "+strings.Replace(this.Version.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "Spec: "+strings.Replace(this.Spec.GoString(), `&`, ``, 1)+",\n")
	if this.DriverState != nil {
		s = append(s, "DriverState: "+fmt.Sprintf("%#v", this.DriverState)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Network) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&api.Network{")
	s = append(s, "ID: "+fmt.Sprintf("%#v", this.ID)+",\n")
	s = append(s, "Version: "+strings.Replace(this.Version.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "Spec: "+strings.Replace(this.Spec.GoString(), `&`, ``, 1)+",\n")
	if this.DriverState != nil {
		s = append(s, "DriverState: "+fmt.Sprintf("%#v", this.DriverState)+",\n")
	}
	if this.IPAM != nil {
		s = append(s, "IPAM: "+fmt.Sprintf("%#v", this.IPAM)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringObjects(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}
func extensionToGoStringObjects(e map[int32]github_com_gogo_protobuf_proto.Extension) string {
	if e == nil {
		return "nil"
	}
	s := "map[int32]proto.Extension{"
	keys := make([]int, 0, len(e))
	for k := range e {
		keys = append(keys, int(k))
	}
	sort.Ints(keys)
	ss := []string{}
	for _, k := range keys {
		ss = append(ss, strconv.Itoa(k)+": "+e[int32(k)].GoString())
	}
	s += strings.Join(ss, ",") + "}"
	return s
}
func (m *Node) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Node) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.ID) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintObjects(data, i, uint64(len(m.ID)))
		i += copy(data[i:], m.ID)
	}
	data[i] = 0x12
	i++
	i = encodeVarintObjects(data, i, uint64(m.Version.Size()))
	n1, err := m.Version.MarshalTo(data[i:])
	if err != nil {
		return 0, err
	}
	i += n1
	data[i] = 0x1a
	i++
	i = encodeVarintObjects(data, i, uint64(m.Spec.Size()))
	n2, err := m.Spec.MarshalTo(data[i:])
	if err != nil {
		return 0, err
	}
	i += n2
	if m.Description != nil {
		data[i] = 0x22
		i++
		i = encodeVarintObjects(data, i, uint64(m.Description.Size()))
		n3, err := m.Description.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	data[i] = 0x2a
	i++
	i = encodeVarintObjects(data, i, uint64(m.Status.Size()))
	n4, err := m.Status.MarshalTo(data[i:])
	if err != nil {
		return 0, err
	}
	i += n4
	return i, nil
}

func (m *Member) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Member) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.ID) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintObjects(data, i, uint64(len(m.ID)))
		i += copy(data[i:], m.ID)
	}
	if len(m.Addr) > 0 {
		data[i] = 0x12
		i++
		i = encodeVarintObjects(data, i, uint64(len(m.Addr)))
		i += copy(data[i:], m.Addr)
	}
	if m.Spec != nil {
		data[i] = 0x1a
		i++
		i = encodeVarintObjects(data, i, uint64(m.Spec.Size()))
		n5, err := m.Spec.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	if m.Description != nil {
		data[i] = 0x22
		i++
		i = encodeVarintObjects(data, i, uint64(m.Description.Size()))
		n6, err := m.Description.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	data[i] = 0x2a
	i++
	i = encodeVarintObjects(data, i, uint64(m.Status.Size()))
	n7, err := m.Status.MarshalTo(data[i:])
	if err != nil {
		return 0, err
	}
	i += n7
	return i, nil
}

func (m *Service) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Service) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.ID) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintObjects(data, i, uint64(len(m.ID)))
		i += copy(data[i:], m.ID)
	}
	data[i] = 0x12
	i++
	i = encodeVarintObjects(data, i, uint64(m.Version.Size()))
	n8, err := m.Version.MarshalTo(data[i:])
	if err != nil {
		return 0, err
	}
	i += n8
	data[i] = 0x1a
	i++
	i = encodeVarintObjects(data, i, uint64(m.Spec.Size()))
	n9, err := m.Spec.MarshalTo(data[i:])
	if err != nil {
		return 0, err
	}
	i += n9
	if m.Endpoint != nil {
		data[i] = 0x22
		i++
		i = encodeVarintObjects(data, i, uint64(m.Endpoint.Size()))
		n10, err := m.Endpoint.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n10
	}
	return i, nil
}

func (m *Task) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Task) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.ID) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintObjects(data, i, uint64(len(m.ID)))
		i += copy(data[i:], m.ID)
	}
	data[i] = 0x12
	i++
	i = encodeVarintObjects(data, i, uint64(m.Version.Size()))
	n11, err := m.Version.MarshalTo(data[i:])
	if err != nil {
		return 0, err
	}
	i += n11
	if len(m.ServiceID) > 0 {
		data[i] = 0x1a
		i++
		i = encodeVarintObjects(data, i, uint64(len(m.ServiceID)))
		i += copy(data[i:], m.ServiceID)
	}
	if m.Instance != 0 {
		data[i] = 0x20
		i++
		i = encodeVarintObjects(data, i, uint64(m.Instance))
	}
	if len(m.NodeID) > 0 {
		data[i] = 0x2a
		i++
		i = encodeVarintObjects(data, i, uint64(len(m.NodeID)))
		i += copy(data[i:], m.NodeID)
	}
	data[i] = 0x32
	i++
	i = encodeVarintObjects(data, i, uint64(m.Annotations.Size()))
	n12, err := m.Annotations.MarshalTo(data[i:])
	if err != nil {
		return 0, err
	}
	i += n12
	data[i] = 0x3a
	i++
	i = encodeVarintObjects(data, i, uint64(m.Spec.Size()))
	n13, err := m.Spec.MarshalTo(data[i:])
	if err != nil {
		return 0, err
	}
	i += n13
	data[i] = 0x42
	i++
	i = encodeVarintObjects(data, i, uint64(m.Status.Size()))
	n14, err := m.Status.MarshalTo(data[i:])
	if err != nil {
		return 0, err
	}
	i += n14
	if m.DesiredState != 0 {
		data[i] = 0x48
		i++
		i = encodeVarintObjects(data, i, uint64(m.DesiredState))
	}
	if len(m.Networks) > 0 {
		for _, msg := range m.Networks {
			data[i] = 0x52
			i++
			i = encodeVarintObjects(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.Endpoint != nil {
		data[i] = 0x5a
		i++
		i = encodeVarintObjects(data, i, uint64(m.Endpoint.Size()))
		n15, err := m.Endpoint.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n15
	}
	return i, nil
}

func (m *Task_NetworkAttachment) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Task_NetworkAttachment) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Network != nil {
		data[i] = 0xa
		i++
		i = encodeVarintObjects(data, i, uint64(m.Network.Size()))
		n16, err := m.Network.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n16
	}
	if len(m.Addresses) > 0 {
		for _, s := range m.Addresses {
			data[i] = 0x12
			i++
			l = len(s)
			for l >= 1<<7 {
				data[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			data[i] = uint8(l)
			i++
			i += copy(data[i:], s)
		}
	}
	return i, nil
}

func (m *Volume) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Volume) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.ID) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintObjects(data, i, uint64(len(m.ID)))
		i += copy(data[i:], m.ID)
	}
	data[i] = 0x12
	i++
	i = encodeVarintObjects(data, i, uint64(m.Version.Size()))
	n17, err := m.Version.MarshalTo(data[i:])
	if err != nil {
		return 0, err
	}
	i += n17
	data[i] = 0x1a
	i++
	i = encodeVarintObjects(data, i, uint64(m.Spec.Size()))
	n18, err := m.Spec.MarshalTo(data[i:])
	if err != nil {
		return 0, err
	}
	i += n18
	if m.DriverState != nil {
		data[i] = 0x22
		i++
		i = encodeVarintObjects(data, i, uint64(m.DriverState.Size()))
		n19, err := m.DriverState.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n19
	}
	return i, nil
}

func (m *Network) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Network) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.ID) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintObjects(data, i, uint64(len(m.ID)))
		i += copy(data[i:], m.ID)
	}
	data[i] = 0x12
	i++
	i = encodeVarintObjects(data, i, uint64(m.Version.Size()))
	n20, err := m.Version.MarshalTo(data[i:])
	if err != nil {
		return 0, err
	}
	i += n20
	data[i] = 0x1a
	i++
	i = encodeVarintObjects(data, i, uint64(m.Spec.Size()))
	n21, err := m.Spec.MarshalTo(data[i:])
	if err != nil {
		return 0, err
	}
	i += n21
	if m.DriverState != nil {
		data[i] = 0x22
		i++
		i = encodeVarintObjects(data, i, uint64(m.DriverState.Size()))
		n22, err := m.DriverState.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n22
	}
	if m.IPAM != nil {
		data[i] = 0x2a
		i++
		i = encodeVarintObjects(data, i, uint64(m.IPAM.Size()))
		n23, err := m.IPAM.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n23
	}
	return i, nil
}

func encodeFixed64Objects(data []byte, offset int, v uint64) int {
	data[offset] = uint8(v)
	data[offset+1] = uint8(v >> 8)
	data[offset+2] = uint8(v >> 16)
	data[offset+3] = uint8(v >> 24)
	data[offset+4] = uint8(v >> 32)
	data[offset+5] = uint8(v >> 40)
	data[offset+6] = uint8(v >> 48)
	data[offset+7] = uint8(v >> 56)
	return offset + 8
}
func encodeFixed32Objects(data []byte, offset int, v uint32) int {
	data[offset] = uint8(v)
	data[offset+1] = uint8(v >> 8)
	data[offset+2] = uint8(v >> 16)
	data[offset+3] = uint8(v >> 24)
	return offset + 4
}
func encodeVarintObjects(data []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		data[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	data[offset] = uint8(v)
	return offset + 1
}

func (m *Node) Size() (n int) {
	var l int
	_ = l
	l = len(m.ID)
	if l > 0 {
		n += 1 + l + sovObjects(uint64(l))
	}
	l = m.Version.Size()
	n += 1 + l + sovObjects(uint64(l))
	l = m.Spec.Size()
	n += 1 + l + sovObjects(uint64(l))
	if m.Description != nil {
		l = m.Description.Size()
		n += 1 + l + sovObjects(uint64(l))
	}
	l = m.Status.Size()
	n += 1 + l + sovObjects(uint64(l))
	return n
}

func (m *Member) Size() (n int) {
	var l int
	_ = l
	l = len(m.ID)
	if l > 0 {
		n += 1 + l + sovObjects(uint64(l))
	}
	l = len(m.Addr)
	if l > 0 {
		n += 1 + l + sovObjects(uint64(l))
	}
	if m.Spec != nil {
		l = m.Spec.Size()
		n += 1 + l + sovObjects(uint64(l))
	}
	if m.Description != nil {
		l = m.Description.Size()
		n += 1 + l + sovObjects(uint64(l))
	}
	l = m.Status.Size()
	n += 1 + l + sovObjects(uint64(l))
	return n
}

func (m *Service) Size() (n int) {
	var l int
	_ = l
	l = len(m.ID)
	if l > 0 {
		n += 1 + l + sovObjects(uint64(l))
	}
	l = m.Version.Size()
	n += 1 + l + sovObjects(uint64(l))
	l = m.Spec.Size()
	n += 1 + l + sovObjects(uint64(l))
	if m.Endpoint != nil {
		l = m.Endpoint.Size()
		n += 1 + l + sovObjects(uint64(l))
	}
	return n
}

func (m *Task) Size() (n int) {
	var l int
	_ = l
	l = len(m.ID)
	if l > 0 {
		n += 1 + l + sovObjects(uint64(l))
	}
	l = m.Version.Size()
	n += 1 + l + sovObjects(uint64(l))
	l = len(m.ServiceID)
	if l > 0 {
		n += 1 + l + sovObjects(uint64(l))
	}
	if m.Instance != 0 {
		n += 1 + sovObjects(uint64(m.Instance))
	}
	l = len(m.NodeID)
	if l > 0 {
		n += 1 + l + sovObjects(uint64(l))
	}
	l = m.Annotations.Size()
	n += 1 + l + sovObjects(uint64(l))
	l = m.Spec.Size()
	n += 1 + l + sovObjects(uint64(l))
	l = m.Status.Size()
	n += 1 + l + sovObjects(uint64(l))
	if m.DesiredState != 0 {
		n += 1 + sovObjects(uint64(m.DesiredState))
	}
	if len(m.Networks) > 0 {
		for _, e := range m.Networks {
			l = e.Size()
			n += 1 + l + sovObjects(uint64(l))
		}
	}
	if m.Endpoint != nil {
		l = m.Endpoint.Size()
		n += 1 + l + sovObjects(uint64(l))
	}
	return n
}

func (m *Task_NetworkAttachment) Size() (n int) {
	var l int
	_ = l
	if m.Network != nil {
		l = m.Network.Size()
		n += 1 + l + sovObjects(uint64(l))
	}
	if len(m.Addresses) > 0 {
		for _, s := range m.Addresses {
			l = len(s)
			n += 1 + l + sovObjects(uint64(l))
		}
	}
	return n
}

func (m *Volume) Size() (n int) {
	var l int
	_ = l
	l = len(m.ID)
	if l > 0 {
		n += 1 + l + sovObjects(uint64(l))
	}
	l = m.Version.Size()
	n += 1 + l + sovObjects(uint64(l))
	l = m.Spec.Size()
	n += 1 + l + sovObjects(uint64(l))
	if m.DriverState != nil {
		l = m.DriverState.Size()
		n += 1 + l + sovObjects(uint64(l))
	}
	return n
}

func (m *Network) Size() (n int) {
	var l int
	_ = l
	l = len(m.ID)
	if l > 0 {
		n += 1 + l + sovObjects(uint64(l))
	}
	l = m.Version.Size()
	n += 1 + l + sovObjects(uint64(l))
	l = m.Spec.Size()
	n += 1 + l + sovObjects(uint64(l))
	if m.DriverState != nil {
		l = m.DriverState.Size()
		n += 1 + l + sovObjects(uint64(l))
	}
	if m.IPAM != nil {
		l = m.IPAM.Size()
		n += 1 + l + sovObjects(uint64(l))
	}
	return n
}

func sovObjects(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozObjects(x uint64) (n int) {
	return sovObjects(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *Node) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Node{`,
		`ID:` + fmt.Sprintf("%v", this.ID) + `,`,
		`Version:` + strings.Replace(strings.Replace(this.Version.String(), "Version", "Version", 1), `&`, ``, 1) + `,`,
		`Spec:` + strings.Replace(strings.Replace(this.Spec.String(), "NodeSpec", "NodeSpec", 1), `&`, ``, 1) + `,`,
		`Description:` + strings.Replace(fmt.Sprintf("%v", this.Description), "NodeDescription", "NodeDescription", 1) + `,`,
		`Status:` + strings.Replace(strings.Replace(this.Status.String(), "NodeStatus", "NodeStatus", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Member) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Member{`,
		`ID:` + fmt.Sprintf("%v", this.ID) + `,`,
		`Addr:` + fmt.Sprintf("%v", this.Addr) + `,`,
		`Spec:` + strings.Replace(fmt.Sprintf("%v", this.Spec), "MemberSpec", "MemberSpec", 1) + `,`,
		`Description:` + strings.Replace(fmt.Sprintf("%v", this.Description), "MemberDescription", "MemberDescription", 1) + `,`,
		`Status:` + strings.Replace(strings.Replace(this.Status.String(), "MemberStatus", "MemberStatus", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Service) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Service{`,
		`ID:` + fmt.Sprintf("%v", this.ID) + `,`,
		`Version:` + strings.Replace(strings.Replace(this.Version.String(), "Version", "Version", 1), `&`, ``, 1) + `,`,
		`Spec:` + strings.Replace(strings.Replace(this.Spec.String(), "ServiceSpec", "ServiceSpec", 1), `&`, ``, 1) + `,`,
		`Endpoint:` + strings.Replace(fmt.Sprintf("%v", this.Endpoint), "Endpoint", "Endpoint", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Task) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Task{`,
		`ID:` + fmt.Sprintf("%v", this.ID) + `,`,
		`Version:` + strings.Replace(strings.Replace(this.Version.String(), "Version", "Version", 1), `&`, ``, 1) + `,`,
		`ServiceID:` + fmt.Sprintf("%v", this.ServiceID) + `,`,
		`Instance:` + fmt.Sprintf("%v", this.Instance) + `,`,
		`NodeID:` + fmt.Sprintf("%v", this.NodeID) + `,`,
		`Annotations:` + strings.Replace(strings.Replace(this.Annotations.String(), "Annotations", "Annotations", 1), `&`, ``, 1) + `,`,
		`Spec:` + strings.Replace(strings.Replace(this.Spec.String(), "TaskSpec", "TaskSpec", 1), `&`, ``, 1) + `,`,
		`Status:` + strings.Replace(strings.Replace(this.Status.String(), "TaskStatus", "TaskStatus", 1), `&`, ``, 1) + `,`,
		`DesiredState:` + fmt.Sprintf("%v", this.DesiredState) + `,`,
		`Networks:` + strings.Replace(fmt.Sprintf("%v", this.Networks), "Task_NetworkAttachment", "Task_NetworkAttachment", 1) + `,`,
		`Endpoint:` + strings.Replace(fmt.Sprintf("%v", this.Endpoint), "Endpoint", "Endpoint", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Task_NetworkAttachment) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Task_NetworkAttachment{`,
		`Network:` + strings.Replace(fmt.Sprintf("%v", this.Network), "Network", "Network", 1) + `,`,
		`Addresses:` + fmt.Sprintf("%v", this.Addresses) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Volume) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Volume{`,
		`ID:` + fmt.Sprintf("%v", this.ID) + `,`,
		`Version:` + strings.Replace(strings.Replace(this.Version.String(), "Version", "Version", 1), `&`, ``, 1) + `,`,
		`Spec:` + strings.Replace(strings.Replace(this.Spec.String(), "VolumeSpec", "VolumeSpec", 1), `&`, ``, 1) + `,`,
		`DriverState:` + strings.Replace(fmt.Sprintf("%v", this.DriverState), "Driver", "Driver", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Network) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Network{`,
		`ID:` + fmt.Sprintf("%v", this.ID) + `,`,
		`Version:` + strings.Replace(strings.Replace(this.Version.String(), "Version", "Version", 1), `&`, ``, 1) + `,`,
		`Spec:` + strings.Replace(strings.Replace(this.Spec.String(), "NetworkSpec", "NetworkSpec", 1), `&`, ``, 1) + `,`,
		`DriverState:` + strings.Replace(fmt.Sprintf("%v", this.DriverState), "Driver", "Driver", 1) + `,`,
		`IPAM:` + strings.Replace(fmt.Sprintf("%v", this.IPAM), "IPAMOptions", "IPAMOptions", 1) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringObjects(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *Node) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowObjects
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Node: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Node: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowObjects
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthObjects
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ID = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowObjects
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthObjects
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Version.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Spec", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowObjects
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthObjects
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Spec.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowObjects
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthObjects
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Description == nil {
				m.Description = &NodeDescription{}
			}
			if err := m.Description.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowObjects
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthObjects
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Status.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipObjects(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthObjects
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Member) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowObjects
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Member: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Member: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowObjects
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthObjects
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ID = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Addr", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowObjects
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthObjects
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Addr = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Spec", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowObjects
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthObjects
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Spec == nil {
				m.Spec = &MemberSpec{}
			}
			if err := m.Spec.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowObjects
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthObjects
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Description == nil {
				m.Description = &MemberDescription{}
			}
			if err := m.Description.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowObjects
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthObjects
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Status.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipObjects(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthObjects
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Service) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowObjects
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Service: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Service: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowObjects
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthObjects
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ID = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowObjects
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthObjects
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Version.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Spec", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowObjects
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthObjects
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Spec.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Endpoint", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowObjects
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthObjects
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Endpoint == nil {
				m.Endpoint = &Endpoint{}
			}
			if err := m.Endpoint.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipObjects(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthObjects
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Task) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowObjects
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Task: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Task: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowObjects
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthObjects
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ID = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowObjects
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthObjects
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Version.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ServiceID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowObjects
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthObjects
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ServiceID = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Instance", wireType)
			}
			m.Instance = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowObjects
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.Instance |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowObjects
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthObjects
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NodeID = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Annotations", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowObjects
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthObjects
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Annotations.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Spec", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowObjects
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthObjects
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Spec.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowObjects
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthObjects
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Status.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DesiredState", wireType)
			}
			m.DesiredState = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowObjects
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.DesiredState |= (TaskState(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Networks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowObjects
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthObjects
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Networks = append(m.Networks, &Task_NetworkAttachment{})
			if err := m.Networks[len(m.Networks)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Endpoint", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowObjects
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthObjects
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Endpoint == nil {
				m.Endpoint = &Endpoint{}
			}
			if err := m.Endpoint.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipObjects(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthObjects
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Task_NetworkAttachment) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowObjects
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NetworkAttachment: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NetworkAttachment: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Network", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowObjects
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthObjects
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Network == nil {
				m.Network = &Network{}
			}
			if err := m.Network.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Addresses", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowObjects
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthObjects
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Addresses = append(m.Addresses, string(data[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipObjects(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthObjects
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Volume) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowObjects
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Volume: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Volume: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowObjects
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthObjects
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ID = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowObjects
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthObjects
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Version.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Spec", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowObjects
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthObjects
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Spec.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DriverState", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowObjects
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthObjects
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DriverState == nil {
				m.DriverState = &Driver{}
			}
			if err := m.DriverState.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipObjects(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthObjects
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Network) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowObjects
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Network: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Network: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowObjects
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthObjects
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ID = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowObjects
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthObjects
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Version.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Spec", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowObjects
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthObjects
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Spec.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DriverState", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowObjects
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthObjects
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DriverState == nil {
				m.DriverState = &Driver{}
			}
			if err := m.DriverState.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IPAM", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowObjects
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthObjects
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.IPAM == nil {
				m.IPAM = &IPAMOptions{}
			}
			if err := m.IPAM.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipObjects(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthObjects
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipObjects(data []byte) (n int, err error) {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowObjects
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowObjects
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if data[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowObjects
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthObjects
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowObjects
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := data[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipObjects(data[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthObjects = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowObjects   = fmt.Errorf("proto: integer overflow")
)

var fileDescriptorObjects = []byte{
	// 664 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0xc4, 0x55, 0x5d, 0x6b, 0xd3, 0x50,
	0x18, 0x5e, 0xda, 0x2c, 0x6d, 0xde, 0xae, 0x82, 0x07, 0x91, 0x50, 0x6b, 0x5b, 0x3a, 0x04, 0x11,
	0xa9, 0x50, 0x51, 0x26, 0x7e, 0x40, 0x4b, 0xa7, 0xf4, 0x62, 0x53, 0x32, 0xd9, 0xed, 0x48, 0x93,
	0xc3, 0x16, 0xbb, 0xe6, 0x84, 0x9c, 0x74, 0xe2, 0x9d, 0xff, 0x42, 0xff, 0x8a, 0xff, 0xa0, 0x97,
	0x82, 0x20, 0x5e, 0x0d, 0xb7, 0x5f, 0xa0, 0xff, 0xc0, 0xf7, 0x9c, 0x9c, 0xb6, 0xab, 0x4d, 0x26,
	0x82, 0xc5, 0x8b, 0x43, 0x93, 0x93, 0xe7, 0x79, 0xde, 0x8f, 0xf3, 0x9c, 0xb7, 0x50, 0x66, 0x83,
	0x37, 0xd4, 0x8d, 0x79, 0x2b, 0x8c, 0x58, 0xcc, 0x08, 0xf1, 0x98, 0x3b, 0xa4, 0x51, 0xcb, 0x3d,
	0x1e, 0xf3, 0x18, 0x7f, 0x9d, 0xd0, 0xaf, 0x94, 0xe2, 0x77, 0x21, 0x55, 0x80, 0x4a, 0x89, 0x87,
	0xd4, 0x9d, 0xbe, 0x5c, 0x3b, 0x64, 0x87, 0x4c, 0x3e, 0xde, 0x13, 0x4f, 0xc9, 0x6e, 0xf3, 0x63,
	0x0e, 0xf4, 0x5d, 0xe6, 0x51, 0x72, 0x1d, 0x72, 0xbe, 0x67, 0x69, 0x0d, 0xed, 0xb6, 0xd9, 0x35,
	0xce, 0x4f, 0xeb, 0xb9, 0x7e, 0xcf, 0xc6, 0x1d, 0xf2, 0x18, 0x0a, 0x27, 0x34, 0xe2, 0x3e, 0x0b,
	0xac, 0x1c, 0x7e, 0x2c, 0xb5, 0x6f, 0xb4, 0x96, 0xc3, 0xb6, 0xf6, 0x13, 0x48, 0x57, 0x9f, 0x9c,
	0xd6, 0xd7, 0xec, 0x29, 0x83, 0x3c, 0x04, 0x5d, 0xa4, 0x60, 0xe5, 0x25, 0xb3, 0x9a, 0xc6, 0x14,
	0xc1, 0xf7, 0x10, 0xa3, 0xa8, 0x12, 0x4f, 0xb6, 0xa1, 0xe4, 0x51, 0xee, 0x46, 0x7e, 0x18, 0x8b,
	0xc0, 0xba, 0xa4, 0x6f, 0x66, 0xd1, 0x7b, 0x73, 0xa8, 0x7d, 0x91, 0x47, 0x9e, 0x80, 0xc1, 0x63,
	0x27, 0x1e, 0x73, 0x6b, 0x5d, 0x2a, 0xd4, 0x32, 0x13, 0x90, 0x28, 0x95, 0x82, 0xe2, 0x34, 0x7f,
	0x6a, 0x60, 0xec, 0xd0, 0xd1, 0x80, 0x46, 0x99, 0xcd, 0x21, 0xa0, 0x3b, 0x9e, 0x17, 0xc9, 0xce,
	0x98, 0xb6, 0x7c, 0x26, 0xed, 0x85, 0x9a, 0x53, 0x43, 0x26, 0xaa, 0xa2, 0x6a, 0x55, 0xef, 0x8b,
	0xb4, 0x7a, 0x6f, 0x65, 0x53, 0x33, 0x2b, 0x7e, 0xf6, 0x5b, 0xc5, 0x8d, 0x4b, 0xc2, 0xa7, 0xd5,
	0xfc, 0x45, 0x83, 0xc2, 0x1e, 0x8d, 0x4e, 0x7c, 0x77, 0x45, 0x8e, 0x78, 0xb4, 0xd0, 0x9d, 0x7a,
	0x1a, 0x53, 0xc5, 0x5f, 0x32, 0xc5, 0x16, 0x14, 0x69, 0xe0, 0x85, 0xcc, 0x0f, 0x62, 0xd5, 0xa1,
	0x54, 0x43, 0x6d, 0x2b, 0x8c, 0x3d, 0x43, 0x37, 0x3f, 0xad, 0x83, 0xfe, 0xda, 0xe1, 0xc3, 0xd5,
	0x94, 0x74, 0x17, 0x80, 0x27, 0x29, 0x1f, 0xa0, 0x78, 0x5e, 0x8a, 0x97, 0x51, 0xdc, 0x54, 0x85,
	0x60, 0x0c, 0x53, 0x01, 0xfa, 0x1e, 0xa9, 0x40, 0xd1, 0x0f, 0xb0, 0xdb, 0x81, 0x4b, 0x65, 0x15,
	0xba, 0x3d, 0x7b, 0x27, 0x9b, 0x50, 0x08, 0xd0, 0x8d, 0x42, 0x66, 0x5d, 0xca, 0x00, 0xca, 0x18,
	0xc2, 0xa0, 0xa8, 0x61, 0x88, 0x4f, 0x28, 0x80, 0x5e, 0x71, 0x82, 0x80, 0xe1, 0x79, 0x61, 0x70,
	0x6e, 0x19, 0xd9, 0x8d, 0xec, 0xcc, 0x61, 0x2a, 0xe7, 0x8b, 0xcc, 0xd9, 0xe5, 0x2c, 0x64, 0xf7,
	0x52, 0x34, 0x6d, 0xe9, 0x1c, 0xe6, 0xb7, 0xaa, 0x98, 0x6d, 0x71, 0xc9, 0x4c, 0x71, 0x18, 0xe9,
	0x42, 0x19, 0x0d, 0xeb, 0x47, 0xd4, 0x3b, 0x10, 0x3b, 0xd4, 0x32, 0x51, 0xe4, 0x4a, 0xfb, 0xe6,
	0x65, 0x22, 0xd4, 0xde, 0x50, 0x1c, 0xf9, 0x46, 0x9e, 0x43, 0x31, 0xa0, 0xf1, 0x5b, 0x16, 0x0d,
	0xb9, 0x05, 0x8d, 0x3c, 0xe6, 0x70, 0x27, 0x8b, 0xde, 0xda, 0x4d, 0x80, 0x9d, 0x38, 0x76, 0xdc,
	0xa3, 0x11, 0x15, 0xbe, 0x98, 0x72, 0x17, 0x1c, 0x55, 0xfa, 0x1b, 0x47, 0x55, 0x8e, 0xe0, 0xea,
	0x92, 0x30, 0x79, 0x80, 0xc7, 0x97, 0x6c, 0x4a, 0x8b, 0x65, 0xb8, 0x48, 0xf1, 0xec, 0x29, 0x96,
	0x54, 0xc1, 0x14, 0x83, 0x83, 0x72, 0x4e, 0x39, 0xda, 0x2f, 0x8f, 0x93, 0x64, 0xbe, 0xd1, 0xfc,
	0x8a, 0x53, 0x68, 0x9f, 0x1d, 0x8f, 0x47, 0x2b, 0xba, 0x90, 0x5b, 0x7f, 0x1e, 0x57, 0x49, 0xf8,
	0x25, 0x1f, 0x3c, 0x85, 0x0d, 0x2f, 0xf2, 0x51, 0x47, 0x1d, 0x64, 0x72, 0x27, 0x2b, 0x69, 0x0a,
	0x3d, 0x89, 0xc3, 0x51, 0x25, 0x7f, 0xe5, 0x21, 0x36, 0x3f, 0xe4, 0xa0, 0xa0, 0x7a, 0xf1, 0xdf,
	0x46, 0x8d, 0x8a, 0xff, 0x8f, 0x4b, 0x43, 0xba, 0xee, 0x87, 0xce, 0x48, 0xcd, 0xe0, 0xd4, 0xc8,
	0xfd, 0x57, 0x9d, 0x9d, 0x97, 0x61, 0x72, 0x37, 0x8b, 0x58, 0xb1, 0x2e, 0x36, 0x6c, 0x49, 0xeb,
	0x56, 0x27, 0x67, 0xb5, 0xb5, 0x6f, 0xb8, 0x7e, 0x9c, 0xd5, 0xb4, 0xf7, 0xe7, 0x35, 0x6d, 0x82,
	0xeb, 0x33, 0xae, 0xef, 0xb8, 0x06, 0x86, 0xfc, 0xe3, 0xbe, 0xff, 0x2b, 0x00, 0x00, 0xff, 0xff,
	0xfe, 0xc4, 0xc5, 0x69, 0x0d, 0x08, 0x00, 0x00,
}
