// Code generated by protoc-gen-gogo.
// source: manager.proto
// DO NOT EDIT!

package api

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"

// skipping weak import gogoproto "github.com/gogo/protobuf/gogoproto"

import strings "strings"
import github_com_gogo_protobuf_proto "github.com/gogo/protobuf/proto"
import sort "sort"
import strconv "strconv"
import reflect "reflect"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

import raftpicker "github.com/docker/swarm-v2/manager/raftpicker"
import codes "google.golang.org/grpc/codes"
import metadata "google.golang.org/grpc/metadata"
import transport "google.golang.org/grpc/transport"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

type NodeCountRequest struct {
}

func (m *NodeCountRequest) Reset()                    { *m = NodeCountRequest{} }
func (*NodeCountRequest) ProtoMessage()               {}
func (*NodeCountRequest) Descriptor() ([]byte, []int) { return fileDescriptorManager, []int{0} }

type NodeCountResponse struct {
	// Count is number of nodes connected to specific manager.
	Count int `protobuf:"varint,1,opt,name=count,proto3,customtype=int" json:"count"`
}

func (m *NodeCountResponse) Reset()                    { *m = NodeCountResponse{} }
func (*NodeCountResponse) ProtoMessage()               {}
func (*NodeCountResponse) Descriptor() ([]byte, []int) { return fileDescriptorManager, []int{1} }

func init() {
	proto.RegisterType((*NodeCountRequest)(nil), "docker.cluster.api.NodeCountRequest")
	proto.RegisterType((*NodeCountResponse)(nil), "docker.cluster.api.NodeCountResponse")
}

func (m *NodeCountRequest) Copy() *NodeCountRequest {
	if m == nil {
		return nil
	}

	o := &NodeCountRequest{}

	return o
}

func (m *NodeCountResponse) Copy() *NodeCountResponse {
	if m == nil {
		return nil
	}

	o := &NodeCountResponse{
		Count: m.Count,
	}

	return o
}

func (this *NodeCountRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 4)
	s = append(s, "&api.NodeCountRequest{")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *NodeCountResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&api.NodeCountResponse{")
	s = append(s, "Count: "+fmt.Sprintf("%#v", this.Count)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringManager(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}
func extensionToGoStringManager(e map[int32]github_com_gogo_protobuf_proto.Extension) string {
	if e == nil {
		return "nil"
	}
	s := "map[int32]proto.Extension{"
	keys := make([]int, 0, len(e))
	for k := range e {
		keys = append(keys, int(k))
	}
	sort.Ints(keys)
	ss := []string{}
	for _, k := range keys {
		ss = append(ss, strconv.Itoa(k)+": "+e[int32(k)].GoString())
	}
	s += strings.Join(ss, ",") + "}"
	return s
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// Client API for Manager service

type ManagerClient interface {
	// NodeCount returns number of nodes connected to particular manager.
	// Supposed to be called only by cluster leader.
	NodeCount(ctx context.Context, in *NodeCountRequest, opts ...grpc.CallOption) (*NodeCountResponse, error)
}

type managerClient struct {
	cc *grpc.ClientConn
}

func NewManagerClient(cc *grpc.ClientConn) ManagerClient {
	return &managerClient{cc}
}

func (c *managerClient) NodeCount(ctx context.Context, in *NodeCountRequest, opts ...grpc.CallOption) (*NodeCountResponse, error) {
	out := new(NodeCountResponse)
	err := grpc.Invoke(ctx, "/docker.cluster.api.Manager/NodeCount", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for Manager service

type ManagerServer interface {
	// NodeCount returns number of nodes connected to particular manager.
	// Supposed to be called only by cluster leader.
	NodeCount(context.Context, *NodeCountRequest) (*NodeCountResponse, error)
}

func RegisterManagerServer(s *grpc.Server, srv ManagerServer) {
	s.RegisterService(&_Manager_serviceDesc, srv)
}

func _Manager_NodeCount_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error) (interface{}, error) {
	in := new(NodeCountRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	out, err := srv.(ManagerServer).NodeCount(ctx, in)
	if err != nil {
		return nil, err
	}
	return out, nil
}

var _Manager_serviceDesc = grpc.ServiceDesc{
	ServiceName: "docker.cluster.api.Manager",
	HandlerType: (*ManagerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "NodeCount",
			Handler:    _Manager_NodeCount_Handler,
		},
	},
	Streams: []grpc.StreamDesc{},
}

func (m *NodeCountRequest) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *NodeCountRequest) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *NodeCountResponse) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *NodeCountResponse) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Count != 0 {
		data[i] = 0x8
		i++
		i = encodeVarintManager(data, i, uint64(m.Count))
	}
	return i, nil
}

func encodeFixed64Manager(data []byte, offset int, v uint64) int {
	data[offset] = uint8(v)
	data[offset+1] = uint8(v >> 8)
	data[offset+2] = uint8(v >> 16)
	data[offset+3] = uint8(v >> 24)
	data[offset+4] = uint8(v >> 32)
	data[offset+5] = uint8(v >> 40)
	data[offset+6] = uint8(v >> 48)
	data[offset+7] = uint8(v >> 56)
	return offset + 8
}
func encodeFixed32Manager(data []byte, offset int, v uint32) int {
	data[offset] = uint8(v)
	data[offset+1] = uint8(v >> 8)
	data[offset+2] = uint8(v >> 16)
	data[offset+3] = uint8(v >> 24)
	return offset + 4
}
func encodeVarintManager(data []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		data[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	data[offset] = uint8(v)
	return offset + 1
}

type raftProxyManagerServer struct {
	local        ManagerServer
	connSelector *raftpicker.ConnSelector
	cluster      raftpicker.RaftCluster
}

func NewRaftProxyManagerServer(local ManagerServer, connSelector *raftpicker.ConnSelector, cluster raftpicker.RaftCluster) ManagerServer {
	return &raftProxyManagerServer{
		local:        local,
		cluster:      cluster,
		connSelector: connSelector,
	}
}

func (p *raftProxyManagerServer) NodeCount(ctx context.Context, r *NodeCountRequest) (*NodeCountResponse, error) {

	if p.cluster.IsLeader() {
		return p.local.NodeCount(ctx, r)
	}
	var addr string
	s, ok := transport.StreamFromContext(ctx)
	if ok {
		addr = s.ServerTransport().RemoteAddr().String()
	}
	md, ok := metadata.FromContext(ctx)
	if ok && len(md["redirect"]) != 0 {
		return nil, grpc.Errorf(codes.ResourceExhausted, "more than one redirect to leader from: %s", md["redirect"])
	}
	if !ok {
		md = metadata.New(map[string]string{})
	}
	md["redirect"] = append(md["redirect"], addr)
	ctx = metadata.NewContext(ctx, md)

	conn, err := p.connSelector.Conn()
	if err != nil {
		return nil, err
	}
	return NewManagerClient(conn).NodeCount(ctx, r)
}

func (m *NodeCountRequest) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *NodeCountResponse) Size() (n int) {
	var l int
	_ = l
	if m.Count != 0 {
		n += 1 + sovManager(uint64(m.Count))
	}
	return n
}

func sovManager(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozManager(x uint64) (n int) {
	return sovManager(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *NodeCountRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&NodeCountRequest{`,
		`}`,
	}, "")
	return s
}
func (this *NodeCountResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&NodeCountResponse{`,
		`Count:` + fmt.Sprintf("%v", this.Count) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringManager(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *NodeCountRequest) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowManager
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NodeCountRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NodeCountRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipManager(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthManager
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NodeCountResponse) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowManager
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NodeCountResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NodeCountResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Count", wireType)
			}
			m.Count = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowManager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.Count |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipManager(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthManager
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipManager(data []byte) (n int, err error) {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowManager
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowManager
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if data[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowManager
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthManager
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowManager
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := data[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipManager(data[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthManager = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowManager   = fmt.Errorf("proto: integer overflow")
)

var fileDescriptorManager = []byte{
	// 192 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0xe2, 0xe2, 0xcd, 0x4d, 0xcc, 0x4b,
	0x4c, 0x4f, 0x2d, 0xd2, 0x2b, 0x28, 0xca, 0x2f, 0xc9, 0x17, 0x12, 0x4a, 0xc9, 0x4f, 0xce, 0x06,
	0xf2, 0x92, 0x73, 0x4a, 0x8b, 0x4b, 0x80, 0x74, 0x62, 0x41, 0xa6, 0x94, 0x48, 0x7a, 0x7e, 0x7a,
	0x3e, 0x58, 0x5a, 0x1f, 0xc4, 0x82, 0xa8, 0x54, 0x12, 0xe2, 0x12, 0xf0, 0xcb, 0x4f, 0x49, 0x75,
	0xce, 0x2f, 0xcd, 0x2b, 0x09, 0x4a, 0x2d, 0x2c, 0x4d, 0x2d, 0x2e, 0x51, 0x32, 0xe3, 0x12, 0x44,
	0x12, 0x2b, 0x2e, 0xc8, 0xcf, 0x2b, 0x4e, 0x15, 0x52, 0xe4, 0x62, 0x4d, 0x06, 0x09, 0x48, 0x30,
	0x2a, 0x30, 0x6a, 0xf0, 0x3a, 0x71, 0x9f, 0xb8, 0x27, 0xcf, 0x70, 0xeb, 0x9e, 0x3c, 0x73, 0x26,
	0x50, 0x0d, 0x44, 0xc6, 0x28, 0x95, 0x8b, 0xdd, 0x17, 0xe2, 0x0c, 0xa1, 0x28, 0x2e, 0x4e, 0xb8,
	0x11, 0x42, 0x2a, 0x7a, 0x98, 0xce, 0xd1, 0x43, 0xb7, 0x55, 0x4a, 0x95, 0x80, 0x2a, 0x88, 0x3b,
	0x94, 0x18, 0x9c, 0x64, 0x4e, 0x3c, 0x94, 0x63, 0xb8, 0x01, 0xc4, 0x1f, 0x1e, 0xca, 0x31, 0x36,
	0x3c, 0x92, 0x63, 0x3c, 0x01, 0xc4, 0x17, 0x80, 0xf8, 0x01, 0x10, 0x47, 0x30, 0x24, 0xb1, 0x81,
	0x7d, 0x66, 0x0c, 0x08, 0x00, 0x00, 0xff, 0xff, 0x24, 0xd8, 0xca, 0xd5, 0x14, 0x01, 0x00, 0x00,
}
