// Code generated by protoc-gen-gogo.
// source: dispatcher.proto
// DO NOT EDIT!

package api

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "github.com/gogo/protobuf/gogoproto"

import time "time"

import strings "strings"
import github_com_gogo_protobuf_proto "github.com/gogo/protobuf/proto"
import sort "sort"
import strconv "strconv"
import reflect "reflect"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

import raftpicker "github.com/docker/swarm-v2/manager/raftpicker"
import codes "google.golang.org/grpc/codes"
import metadata "google.golang.org/grpc/metadata"
import transport "google.golang.org/grpc/transport"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

type RegisterRequest struct {
	Description *NodeDescription `protobuf:"bytes,1,opt,name=description" json:"description,omitempty"`
}

func (m *RegisterRequest) Reset()                    { *m = RegisterRequest{} }
func (*RegisterRequest) ProtoMessage()               {}
func (*RegisterRequest) Descriptor() ([]byte, []int) { return fileDescriptorDispatcher, []int{0} }

type RegisterResponse struct {
	// NodeID identifies the registering node.
	NodeID string `protobuf:"bytes,1,opt,name=node_id,json=nodeId,proto3" json:"node_id,omitempty"`
	// SessionID is allocated after a successful registration. It should be
	// used on all RPC calls after registration. A dispatcher may choose to
	// change the SessionID, at which time an agent must re-register and obtain
	// a new one.
	//
	// All Dispatcher calls after register should include the SessionID. If the
	// Dispatcher so chooses, it may reject the call with an InvalidArgument
	// error code, at which time the agent should call Register to start a new
	// session.
	//
	// As a rule, once an agent has a SessionID, it should never save it to
	// disk or try to otherwise reuse. If the agent loses its SessionID, it
	// must start a new session through a call to Register. A Dispatcher may
	// choose to reuse the SessionID, if it sees fit, but it is not advised.
	//
	// The actual implementation of the SessionID is Dispatcher specific and
	// should be treated as opaque by agents.
	//
	// From a Dispatcher perspective, there are many ways to use the SessionID
	// to ensure uniqueness of a set of client RPC calls. One method is to keep
	// the SessionID unique to every call to Register in a single Dispatcher
	// instance. This ensures that the SessionID represents the unique
	// session from a single Agent to Manager. If the Agent restarts, we
	// allocate a new session, since the restarted Agent is not aware of the
	// new SessionID.
	//
	// The most compelling use case is to support duplicate node detection. If
	// one clones a virtual machine, including certificate material, two nodes
	// may end up with the same identity. This can also happen if two identical
	// agent processes are coming from the same node. If the SessionID is
	// replicated through the cluster, we can immediately detect the condition
	// and address it.
	//
	// Extending from the case above, we can actually detect a compromised
	// identity. Coupled with provisions to rebuild node identity, we can ban
	// the compromised node identity and have the nodes re-authenticate and
	// build a new identity. At this time, an administrator can then
	// re-authorize the compromised nodes, if it was a mistake or ensure that a
	// misbehaved node can no longer connect to the cluster.
	//
	// We considered placing this field in a GRPC header. Because this is a
	// critical feature of the protocol, we thought it should be represented
	// directly in the RPC message set.
	SessionID string `protobuf:"bytes,2,opt,name=session_id,json=sessionId,proto3" json:"session_id,omitempty"`
}

func (m *RegisterResponse) Reset()                    { *m = RegisterResponse{} }
func (*RegisterResponse) ProtoMessage()               {}
func (*RegisterResponse) Descriptor() ([]byte, []int) { return fileDescriptorDispatcher, []int{1} }

// SessionRequest starts a session control stream.
type SessionRequest struct {
	SessionID string `protobuf:"bytes,1,opt,name=session_id,json=sessionId,proto3" json:"session_id,omitempty"`
}

func (m *SessionRequest) Reset()                    { *m = SessionRequest{} }
func (*SessionRequest) ProtoMessage()               {}
func (*SessionRequest) Descriptor() ([]byte, []int) { return fileDescriptorDispatcher, []int{2} }

// SessionMessage instructs an agent on various actions as part of the current
// session. An agent should act immediately on the contents.
type SessionMessage struct {
	// Managers provides a weight list of alternative dispatchers
	Managers []*WeightedPeer `protobuf:"bytes,1,rep,name=managers" json:"managers,omitempty"`
	// Disconnect instructs the agent to disconnect from the current disptacher
	// and select a new one.
	Disconnect bool `protobuf:"varint,2,opt,name=disconnect,proto3" json:"disconnect,omitempty"`
}

func (m *SessionMessage) Reset()                    { *m = SessionMessage{} }
func (*SessionMessage) ProtoMessage()               {}
func (*SessionMessage) Descriptor() ([]byte, []int) { return fileDescriptorDispatcher, []int{3} }

// HeartbeatRequest provides identifying properties for a single heartbeat.
type HeartbeatRequest struct {
	SessionID string `protobuf:"bytes,1,opt,name=session_id,json=sessionId,proto3" json:"session_id,omitempty"`
}

func (m *HeartbeatRequest) Reset()                    { *m = HeartbeatRequest{} }
func (*HeartbeatRequest) ProtoMessage()               {}
func (*HeartbeatRequest) Descriptor() ([]byte, []int) { return fileDescriptorDispatcher, []int{4} }

type HeartbeatResponse struct {
	// Period is the duration to wait before sending the next heartbeat.
	// Well-behaved agents should update this on every heartbeat round trip.
	Period time.Duration `protobuf:"varint,1,opt,name=Period,json=period,proto3,customtype=time.Duration" json:"Period"`
}

func (m *HeartbeatResponse) Reset()                    { *m = HeartbeatResponse{} }
func (*HeartbeatResponse) ProtoMessage()               {}
func (*HeartbeatResponse) Descriptor() ([]byte, []int) { return fileDescriptorDispatcher, []int{5} }

type UpdateTaskStatusRequest struct {
	// Tasks should contain all statuses for running tasks. Only the status
	// field must be set. The spec is not required.
	SessionID string                                      `protobuf:"bytes,1,opt,name=session_id,json=sessionId,proto3" json:"session_id,omitempty"`
	Updates   []*UpdateTaskStatusRequest_TaskStatusUpdate `protobuf:"bytes,3,rep,name=updates" json:"updates,omitempty"`
}

func (m *UpdateTaskStatusRequest) Reset()      { *m = UpdateTaskStatusRequest{} }
func (*UpdateTaskStatusRequest) ProtoMessage() {}
func (*UpdateTaskStatusRequest) Descriptor() ([]byte, []int) {
	return fileDescriptorDispatcher, []int{6}
}

type UpdateTaskStatusRequest_TaskStatusUpdate struct {
	TaskID string      `protobuf:"bytes,1,opt,name=task_id,json=taskId,proto3" json:"task_id,omitempty"`
	Status *TaskStatus `protobuf:"bytes,2,opt,name=status" json:"status,omitempty"`
}

func (m *UpdateTaskStatusRequest_TaskStatusUpdate) Reset() {
	*m = UpdateTaskStatusRequest_TaskStatusUpdate{}
}
func (*UpdateTaskStatusRequest_TaskStatusUpdate) ProtoMessage() {}
func (*UpdateTaskStatusRequest_TaskStatusUpdate) Descriptor() ([]byte, []int) {
	return fileDescriptorDispatcher, []int{6, 0}
}

type UpdateTaskStatusResponse struct {
}

func (m *UpdateTaskStatusResponse) Reset()      { *m = UpdateTaskStatusResponse{} }
func (*UpdateTaskStatusResponse) ProtoMessage() {}
func (*UpdateTaskStatusResponse) Descriptor() ([]byte, []int) {
	return fileDescriptorDispatcher, []int{7}
}

type TasksRequest struct {
	SessionID string `protobuf:"bytes,1,opt,name=session_id,json=sessionId,proto3" json:"session_id,omitempty"`
}

func (m *TasksRequest) Reset()                    { *m = TasksRequest{} }
func (*TasksRequest) ProtoMessage()               {}
func (*TasksRequest) Descriptor() ([]byte, []int) { return fileDescriptorDispatcher, []int{8} }

type TasksMessage struct {
	// Tasks is the set of tasks that should be running on the node.
	// Tasks outside of this set running on the node should be terminated.
	Tasks []*Task `protobuf:"bytes,1,rep,name=tasks" json:"tasks,omitempty"`
}

func (m *TasksMessage) Reset()                    { *m = TasksMessage{} }
func (*TasksMessage) ProtoMessage()               {}
func (*TasksMessage) Descriptor() ([]byte, []int) { return fileDescriptorDispatcher, []int{9} }

func init() {
	proto.RegisterType((*RegisterRequest)(nil), "docker.cluster.api.RegisterRequest")
	proto.RegisterType((*RegisterResponse)(nil), "docker.cluster.api.RegisterResponse")
	proto.RegisterType((*SessionRequest)(nil), "docker.cluster.api.SessionRequest")
	proto.RegisterType((*SessionMessage)(nil), "docker.cluster.api.SessionMessage")
	proto.RegisterType((*HeartbeatRequest)(nil), "docker.cluster.api.HeartbeatRequest")
	proto.RegisterType((*HeartbeatResponse)(nil), "docker.cluster.api.HeartbeatResponse")
	proto.RegisterType((*UpdateTaskStatusRequest)(nil), "docker.cluster.api.UpdateTaskStatusRequest")
	proto.RegisterType((*UpdateTaskStatusRequest_TaskStatusUpdate)(nil), "docker.cluster.api.UpdateTaskStatusRequest.TaskStatusUpdate")
	proto.RegisterType((*UpdateTaskStatusResponse)(nil), "docker.cluster.api.UpdateTaskStatusResponse")
	proto.RegisterType((*TasksRequest)(nil), "docker.cluster.api.TasksRequest")
	proto.RegisterType((*TasksMessage)(nil), "docker.cluster.api.TasksMessage")
}

func (m *RegisterRequest) Copy() *RegisterRequest {
	if m == nil {
		return nil
	}

	o := &RegisterRequest{
		Description: m.Description.Copy(),
	}

	return o
}

func (m *RegisterResponse) Copy() *RegisterResponse {
	if m == nil {
		return nil
	}

	o := &RegisterResponse{
		NodeID:    m.NodeID,
		SessionID: m.SessionID,
	}

	return o
}

func (m *SessionRequest) Copy() *SessionRequest {
	if m == nil {
		return nil
	}

	o := &SessionRequest{
		SessionID: m.SessionID,
	}

	return o
}

func (m *SessionMessage) Copy() *SessionMessage {
	if m == nil {
		return nil
	}

	o := &SessionMessage{
		Disconnect: m.Disconnect,
	}

	if m.Managers != nil {
		o.Managers = make([]*WeightedPeer, 0, len(m.Managers))
		for _, v := range m.Managers {
			o.Managers = append(o.Managers, v.Copy())
		}
	}

	return o
}

func (m *HeartbeatRequest) Copy() *HeartbeatRequest {
	if m == nil {
		return nil
	}

	o := &HeartbeatRequest{
		SessionID: m.SessionID,
	}

	return o
}

func (m *HeartbeatResponse) Copy() *HeartbeatResponse {
	if m == nil {
		return nil
	}

	o := &HeartbeatResponse{
		Period: m.Period,
	}

	return o
}

func (m *UpdateTaskStatusRequest) Copy() *UpdateTaskStatusRequest {
	if m == nil {
		return nil
	}

	o := &UpdateTaskStatusRequest{
		SessionID: m.SessionID,
	}

	if m.Updates != nil {
		o.Updates = make([]*UpdateTaskStatusRequest_TaskStatusUpdate, 0, len(m.Updates))
		for _, v := range m.Updates {
			o.Updates = append(o.Updates, v.Copy())
		}
	}

	return o
}

func (m *UpdateTaskStatusRequest_TaskStatusUpdate) Copy() *UpdateTaskStatusRequest_TaskStatusUpdate {
	if m == nil {
		return nil
	}

	o := &UpdateTaskStatusRequest_TaskStatusUpdate{
		TaskID: m.TaskID,
		Status: m.Status.Copy(),
	}

	return o
}

func (m *UpdateTaskStatusResponse) Copy() *UpdateTaskStatusResponse {
	if m == nil {
		return nil
	}

	o := &UpdateTaskStatusResponse{}

	return o
}

func (m *TasksRequest) Copy() *TasksRequest {
	if m == nil {
		return nil
	}

	o := &TasksRequest{
		SessionID: m.SessionID,
	}

	return o
}

func (m *TasksMessage) Copy() *TasksMessage {
	if m == nil {
		return nil
	}

	o := &TasksMessage{}

	if m.Tasks != nil {
		o.Tasks = make([]*Task, 0, len(m.Tasks))
		for _, v := range m.Tasks {
			o.Tasks = append(o.Tasks, v.Copy())
		}
	}

	return o
}

func (this *RegisterRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&api.RegisterRequest{")
	if this.Description != nil {
		s = append(s, "Description: "+fmt.Sprintf("%#v", this.Description)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *RegisterResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&api.RegisterResponse{")
	s = append(s, "NodeID: "+fmt.Sprintf("%#v", this.NodeID)+",\n")
	s = append(s, "SessionID: "+fmt.Sprintf("%#v", this.SessionID)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *SessionRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&api.SessionRequest{")
	s = append(s, "SessionID: "+fmt.Sprintf("%#v", this.SessionID)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *SessionMessage) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&api.SessionMessage{")
	if this.Managers != nil {
		s = append(s, "Managers: "+fmt.Sprintf("%#v", this.Managers)+",\n")
	}
	s = append(s, "Disconnect: "+fmt.Sprintf("%#v", this.Disconnect)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *HeartbeatRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&api.HeartbeatRequest{")
	s = append(s, "SessionID: "+fmt.Sprintf("%#v", this.SessionID)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *HeartbeatResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&api.HeartbeatResponse{")
	s = append(s, "Period: "+fmt.Sprintf("%#v", this.Period)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *UpdateTaskStatusRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&api.UpdateTaskStatusRequest{")
	s = append(s, "SessionID: "+fmt.Sprintf("%#v", this.SessionID)+",\n")
	if this.Updates != nil {
		s = append(s, "Updates: "+fmt.Sprintf("%#v", this.Updates)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *UpdateTaskStatusRequest_TaskStatusUpdate) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&api.UpdateTaskStatusRequest_TaskStatusUpdate{")
	s = append(s, "TaskID: "+fmt.Sprintf("%#v", this.TaskID)+",\n")
	if this.Status != nil {
		s = append(s, "Status: "+fmt.Sprintf("%#v", this.Status)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *UpdateTaskStatusResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 4)
	s = append(s, "&api.UpdateTaskStatusResponse{")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *TasksRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&api.TasksRequest{")
	s = append(s, "SessionID: "+fmt.Sprintf("%#v", this.SessionID)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *TasksMessage) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&api.TasksMessage{")
	if this.Tasks != nil {
		s = append(s, "Tasks: "+fmt.Sprintf("%#v", this.Tasks)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringDispatcher(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}
func extensionToGoStringDispatcher(e map[int32]github_com_gogo_protobuf_proto.Extension) string {
	if e == nil {
		return "nil"
	}
	s := "map[int32]proto.Extension{"
	keys := make([]int, 0, len(e))
	for k := range e {
		keys = append(keys, int(k))
	}
	sort.Ints(keys)
	ss := []string{}
	for _, k := range keys {
		ss = append(ss, strconv.Itoa(k)+": "+e[int32(k)].GoString())
	}
	s += strings.Join(ss, ",") + "}"
	return s
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// Client API for Dispatcher service

type DispatcherClient interface {
	// Register is used for registration of node with particular dispatcher.
	Register(ctx context.Context, in *RegisterRequest, opts ...grpc.CallOption) (*RegisterResponse, error)
	// Session controls an agent with a stream of SessionMessage. Agents should
	// immediately issue this call after a successful register and listen on
	// the stream at all times for instruction.
	Session(ctx context.Context, in *SessionRequest, opts ...grpc.CallOption) (Dispatcher_SessionClient, error)
	// Heartbeat is heartbeat method for nodes. It returns new TTL in response.
	// Node should send new heartbeat earlier than now + TTL, otherwise it will
	// be deregistered from dispatcher and its status will be updated to NodeStatus_DOWN
	Heartbeat(ctx context.Context, in *HeartbeatRequest, opts ...grpc.CallOption) (*HeartbeatResponse, error)
	// UpdateTaskStatus updates status of task. Node should send such updates
	// on every status change of its tasks.
	UpdateTaskStatus(ctx context.Context, in *UpdateTaskStatusRequest, opts ...grpc.CallOption) (*UpdateTaskStatusResponse, error)
	// Tasks is a stream of tasks state for node. Each message contains full list
	// of tasks which should be run on node, if task is not present in that list,
	// it should be terminated.
	Tasks(ctx context.Context, in *TasksRequest, opts ...grpc.CallOption) (Dispatcher_TasksClient, error)
}

type dispatcherClient struct {
	cc *grpc.ClientConn
}

func NewDispatcherClient(cc *grpc.ClientConn) DispatcherClient {
	return &dispatcherClient{cc}
}

func (c *dispatcherClient) Register(ctx context.Context, in *RegisterRequest, opts ...grpc.CallOption) (*RegisterResponse, error) {
	out := new(RegisterResponse)
	err := grpc.Invoke(ctx, "/docker.cluster.api.Dispatcher/Register", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dispatcherClient) Session(ctx context.Context, in *SessionRequest, opts ...grpc.CallOption) (Dispatcher_SessionClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_Dispatcher_serviceDesc.Streams[0], c.cc, "/docker.cluster.api.Dispatcher/Session", opts...)
	if err != nil {
		return nil, err
	}
	x := &dispatcherSessionClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Dispatcher_SessionClient interface {
	Recv() (*SessionMessage, error)
	grpc.ClientStream
}

type dispatcherSessionClient struct {
	grpc.ClientStream
}

func (x *dispatcherSessionClient) Recv() (*SessionMessage, error) {
	m := new(SessionMessage)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *dispatcherClient) Heartbeat(ctx context.Context, in *HeartbeatRequest, opts ...grpc.CallOption) (*HeartbeatResponse, error) {
	out := new(HeartbeatResponse)
	err := grpc.Invoke(ctx, "/docker.cluster.api.Dispatcher/Heartbeat", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dispatcherClient) UpdateTaskStatus(ctx context.Context, in *UpdateTaskStatusRequest, opts ...grpc.CallOption) (*UpdateTaskStatusResponse, error) {
	out := new(UpdateTaskStatusResponse)
	err := grpc.Invoke(ctx, "/docker.cluster.api.Dispatcher/UpdateTaskStatus", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dispatcherClient) Tasks(ctx context.Context, in *TasksRequest, opts ...grpc.CallOption) (Dispatcher_TasksClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_Dispatcher_serviceDesc.Streams[1], c.cc, "/docker.cluster.api.Dispatcher/Tasks", opts...)
	if err != nil {
		return nil, err
	}
	x := &dispatcherTasksClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Dispatcher_TasksClient interface {
	Recv() (*TasksMessage, error)
	grpc.ClientStream
}

type dispatcherTasksClient struct {
	grpc.ClientStream
}

func (x *dispatcherTasksClient) Recv() (*TasksMessage, error) {
	m := new(TasksMessage)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// Server API for Dispatcher service

type DispatcherServer interface {
	// Register is used for registration of node with particular dispatcher.
	Register(context.Context, *RegisterRequest) (*RegisterResponse, error)
	// Session controls an agent with a stream of SessionMessage. Agents should
	// immediately issue this call after a successful register and listen on
	// the stream at all times for instruction.
	Session(*SessionRequest, Dispatcher_SessionServer) error
	// Heartbeat is heartbeat method for nodes. It returns new TTL in response.
	// Node should send new heartbeat earlier than now + TTL, otherwise it will
	// be deregistered from dispatcher and its status will be updated to NodeStatus_DOWN
	Heartbeat(context.Context, *HeartbeatRequest) (*HeartbeatResponse, error)
	// UpdateTaskStatus updates status of task. Node should send such updates
	// on every status change of its tasks.
	UpdateTaskStatus(context.Context, *UpdateTaskStatusRequest) (*UpdateTaskStatusResponse, error)
	// Tasks is a stream of tasks state for node. Each message contains full list
	// of tasks which should be run on node, if task is not present in that list,
	// it should be terminated.
	Tasks(*TasksRequest, Dispatcher_TasksServer) error
}

func RegisterDispatcherServer(s *grpc.Server, srv DispatcherServer) {
	s.RegisterService(&_Dispatcher_serviceDesc, srv)
}

func _Dispatcher_Register_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error) (interface{}, error) {
	in := new(RegisterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	out, err := srv.(DispatcherServer).Register(ctx, in)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func _Dispatcher_Session_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(SessionRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(DispatcherServer).Session(m, &dispatcherSessionServer{stream})
}

type Dispatcher_SessionServer interface {
	Send(*SessionMessage) error
	grpc.ServerStream
}

type dispatcherSessionServer struct {
	grpc.ServerStream
}

func (x *dispatcherSessionServer) Send(m *SessionMessage) error {
	return x.ServerStream.SendMsg(m)
}

func _Dispatcher_Heartbeat_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error) (interface{}, error) {
	in := new(HeartbeatRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	out, err := srv.(DispatcherServer).Heartbeat(ctx, in)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func _Dispatcher_UpdateTaskStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error) (interface{}, error) {
	in := new(UpdateTaskStatusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	out, err := srv.(DispatcherServer).UpdateTaskStatus(ctx, in)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func _Dispatcher_Tasks_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(TasksRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(DispatcherServer).Tasks(m, &dispatcherTasksServer{stream})
}

type Dispatcher_TasksServer interface {
	Send(*TasksMessage) error
	grpc.ServerStream
}

type dispatcherTasksServer struct {
	grpc.ServerStream
}

func (x *dispatcherTasksServer) Send(m *TasksMessage) error {
	return x.ServerStream.SendMsg(m)
}

var _Dispatcher_serviceDesc = grpc.ServiceDesc{
	ServiceName: "docker.cluster.api.Dispatcher",
	HandlerType: (*DispatcherServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Register",
			Handler:    _Dispatcher_Register_Handler,
		},
		{
			MethodName: "Heartbeat",
			Handler:    _Dispatcher_Heartbeat_Handler,
		},
		{
			MethodName: "UpdateTaskStatus",
			Handler:    _Dispatcher_UpdateTaskStatus_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Session",
			Handler:       _Dispatcher_Session_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "Tasks",
			Handler:       _Dispatcher_Tasks_Handler,
			ServerStreams: true,
		},
	},
}

func (m *RegisterRequest) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *RegisterRequest) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Description != nil {
		data[i] = 0xa
		i++
		i = encodeVarintDispatcher(data, i, uint64(m.Description.Size()))
		n1, err := m.Description.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	return i, nil
}

func (m *RegisterResponse) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *RegisterResponse) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.NodeID) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintDispatcher(data, i, uint64(len(m.NodeID)))
		i += copy(data[i:], m.NodeID)
	}
	if len(m.SessionID) > 0 {
		data[i] = 0x12
		i++
		i = encodeVarintDispatcher(data, i, uint64(len(m.SessionID)))
		i += copy(data[i:], m.SessionID)
	}
	return i, nil
}

func (m *SessionRequest) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *SessionRequest) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.SessionID) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintDispatcher(data, i, uint64(len(m.SessionID)))
		i += copy(data[i:], m.SessionID)
	}
	return i, nil
}

func (m *SessionMessage) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *SessionMessage) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Managers) > 0 {
		for _, msg := range m.Managers {
			data[i] = 0xa
			i++
			i = encodeVarintDispatcher(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.Disconnect {
		data[i] = 0x10
		i++
		if m.Disconnect {
			data[i] = 1
		} else {
			data[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *HeartbeatRequest) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *HeartbeatRequest) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.SessionID) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintDispatcher(data, i, uint64(len(m.SessionID)))
		i += copy(data[i:], m.SessionID)
	}
	return i, nil
}

func (m *HeartbeatResponse) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *HeartbeatResponse) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Period != 0 {
		data[i] = 0x8
		i++
		i = encodeVarintDispatcher(data, i, uint64(m.Period))
	}
	return i, nil
}

func (m *UpdateTaskStatusRequest) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *UpdateTaskStatusRequest) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.SessionID) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintDispatcher(data, i, uint64(len(m.SessionID)))
		i += copy(data[i:], m.SessionID)
	}
	if len(m.Updates) > 0 {
		for _, msg := range m.Updates {
			data[i] = 0x1a
			i++
			i = encodeVarintDispatcher(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *UpdateTaskStatusRequest_TaskStatusUpdate) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *UpdateTaskStatusRequest_TaskStatusUpdate) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.TaskID) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintDispatcher(data, i, uint64(len(m.TaskID)))
		i += copy(data[i:], m.TaskID)
	}
	if m.Status != nil {
		data[i] = 0x12
		i++
		i = encodeVarintDispatcher(data, i, uint64(m.Status.Size()))
		n2, err := m.Status.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	return i, nil
}

func (m *UpdateTaskStatusResponse) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *UpdateTaskStatusResponse) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *TasksRequest) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *TasksRequest) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.SessionID) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintDispatcher(data, i, uint64(len(m.SessionID)))
		i += copy(data[i:], m.SessionID)
	}
	return i, nil
}

func (m *TasksMessage) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *TasksMessage) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Tasks) > 0 {
		for _, msg := range m.Tasks {
			data[i] = 0xa
			i++
			i = encodeVarintDispatcher(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func encodeFixed64Dispatcher(data []byte, offset int, v uint64) int {
	data[offset] = uint8(v)
	data[offset+1] = uint8(v >> 8)
	data[offset+2] = uint8(v >> 16)
	data[offset+3] = uint8(v >> 24)
	data[offset+4] = uint8(v >> 32)
	data[offset+5] = uint8(v >> 40)
	data[offset+6] = uint8(v >> 48)
	data[offset+7] = uint8(v >> 56)
	return offset + 8
}
func encodeFixed32Dispatcher(data []byte, offset int, v uint32) int {
	data[offset] = uint8(v)
	data[offset+1] = uint8(v >> 8)
	data[offset+2] = uint8(v >> 16)
	data[offset+3] = uint8(v >> 24)
	return offset + 4
}
func encodeVarintDispatcher(data []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		data[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	data[offset] = uint8(v)
	return offset + 1
}

type raftProxyDispatcherServer struct {
	local        DispatcherServer
	connSelector *raftpicker.ConnSelector
	cluster      raftpicker.RaftCluster
}

func NewRaftProxyDispatcherServer(local DispatcherServer, connSelector *raftpicker.ConnSelector, cluster raftpicker.RaftCluster) DispatcherServer {
	return &raftProxyDispatcherServer{
		local:        local,
		cluster:      cluster,
		connSelector: connSelector,
	}
}

func (p *raftProxyDispatcherServer) Register(ctx context.Context, r *RegisterRequest) (*RegisterResponse, error) {

	if p.cluster.IsLeader() {
		return p.local.Register(ctx, r)
	}
	var addr string
	s, ok := transport.StreamFromContext(ctx)
	if ok {
		addr = s.ServerTransport().RemoteAddr().String()
	}
	md, ok := metadata.FromContext(ctx)
	if ok && len(md["redirect"]) != 0 {
		return nil, grpc.Errorf(codes.ResourceExhausted, "more than one redirect to leader from: %s", md["redirect"])
	}
	if !ok {
		md = metadata.New(map[string]string{})
	}
	md["redirect"] = append(md["redirect"], addr)
	ctx = metadata.NewContext(ctx, md)

	conn, err := p.connSelector.Conn()
	if err != nil {
		return nil, err
	}
	return NewDispatcherClient(conn).Register(ctx, r)
}

func (p *raftProxyDispatcherServer) Session(r *SessionRequest, stream Dispatcher_SessionServer) error {

	if p.cluster.IsLeader() {
		return p.local.Session(r, stream)
	}
	conn, err := p.connSelector.Conn()
	if err != nil {
		return err
	}
	var addr string
	s, ok := transport.StreamFromContext(stream.Context())
	if ok {
		addr = s.ServerTransport().RemoteAddr().String()
	}
	md, ok := metadata.FromContext(stream.Context())
	if ok && len(md["redirect"]) != 0 {
		return grpc.Errorf(codes.ResourceExhausted, "more than one redirect to leader from: %s", md["redirect"])
	}
	if !ok {
		md = metadata.New(map[string]string{})
	}
	md["redirect"] = append(md["redirect"], addr)
	ctx := metadata.NewContext(stream.Context(), md)

	clientStream, err := NewDispatcherClient(conn).Session(ctx, r)

	if err != nil {
		return err
	}

	for {
		msg, err := clientStream.Recv()
		if err == io.EOF {
			break
		}
		if err != nil {
			return err
		}
		if err := stream.Send(msg); err != nil {
			return err
		}
	}
	return nil
}

func (p *raftProxyDispatcherServer) Heartbeat(ctx context.Context, r *HeartbeatRequest) (*HeartbeatResponse, error) {

	if p.cluster.IsLeader() {
		return p.local.Heartbeat(ctx, r)
	}
	var addr string
	s, ok := transport.StreamFromContext(ctx)
	if ok {
		addr = s.ServerTransport().RemoteAddr().String()
	}
	md, ok := metadata.FromContext(ctx)
	if ok && len(md["redirect"]) != 0 {
		return nil, grpc.Errorf(codes.ResourceExhausted, "more than one redirect to leader from: %s", md["redirect"])
	}
	if !ok {
		md = metadata.New(map[string]string{})
	}
	md["redirect"] = append(md["redirect"], addr)
	ctx = metadata.NewContext(ctx, md)

	conn, err := p.connSelector.Conn()
	if err != nil {
		return nil, err
	}
	return NewDispatcherClient(conn).Heartbeat(ctx, r)
}

func (p *raftProxyDispatcherServer) UpdateTaskStatus(ctx context.Context, r *UpdateTaskStatusRequest) (*UpdateTaskStatusResponse, error) {

	if p.cluster.IsLeader() {
		return p.local.UpdateTaskStatus(ctx, r)
	}
	var addr string
	s, ok := transport.StreamFromContext(ctx)
	if ok {
		addr = s.ServerTransport().RemoteAddr().String()
	}
	md, ok := metadata.FromContext(ctx)
	if ok && len(md["redirect"]) != 0 {
		return nil, grpc.Errorf(codes.ResourceExhausted, "more than one redirect to leader from: %s", md["redirect"])
	}
	if !ok {
		md = metadata.New(map[string]string{})
	}
	md["redirect"] = append(md["redirect"], addr)
	ctx = metadata.NewContext(ctx, md)

	conn, err := p.connSelector.Conn()
	if err != nil {
		return nil, err
	}
	return NewDispatcherClient(conn).UpdateTaskStatus(ctx, r)
}

func (p *raftProxyDispatcherServer) Tasks(r *TasksRequest, stream Dispatcher_TasksServer) error {

	if p.cluster.IsLeader() {
		return p.local.Tasks(r, stream)
	}
	conn, err := p.connSelector.Conn()
	if err != nil {
		return err
	}
	var addr string
	s, ok := transport.StreamFromContext(stream.Context())
	if ok {
		addr = s.ServerTransport().RemoteAddr().String()
	}
	md, ok := metadata.FromContext(stream.Context())
	if ok && len(md["redirect"]) != 0 {
		return grpc.Errorf(codes.ResourceExhausted, "more than one redirect to leader from: %s", md["redirect"])
	}
	if !ok {
		md = metadata.New(map[string]string{})
	}
	md["redirect"] = append(md["redirect"], addr)
	ctx := metadata.NewContext(stream.Context(), md)

	clientStream, err := NewDispatcherClient(conn).Tasks(ctx, r)

	if err != nil {
		return err
	}

	for {
		msg, err := clientStream.Recv()
		if err == io.EOF {
			break
		}
		if err != nil {
			return err
		}
		if err := stream.Send(msg); err != nil {
			return err
		}
	}
	return nil
}

func (m *RegisterRequest) Size() (n int) {
	var l int
	_ = l
	if m.Description != nil {
		l = m.Description.Size()
		n += 1 + l + sovDispatcher(uint64(l))
	}
	return n
}

func (m *RegisterResponse) Size() (n int) {
	var l int
	_ = l
	l = len(m.NodeID)
	if l > 0 {
		n += 1 + l + sovDispatcher(uint64(l))
	}
	l = len(m.SessionID)
	if l > 0 {
		n += 1 + l + sovDispatcher(uint64(l))
	}
	return n
}

func (m *SessionRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.SessionID)
	if l > 0 {
		n += 1 + l + sovDispatcher(uint64(l))
	}
	return n
}

func (m *SessionMessage) Size() (n int) {
	var l int
	_ = l
	if len(m.Managers) > 0 {
		for _, e := range m.Managers {
			l = e.Size()
			n += 1 + l + sovDispatcher(uint64(l))
		}
	}
	if m.Disconnect {
		n += 2
	}
	return n
}

func (m *HeartbeatRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.SessionID)
	if l > 0 {
		n += 1 + l + sovDispatcher(uint64(l))
	}
	return n
}

func (m *HeartbeatResponse) Size() (n int) {
	var l int
	_ = l
	if m.Period != 0 {
		n += 1 + sovDispatcher(uint64(m.Period))
	}
	return n
}

func (m *UpdateTaskStatusRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.SessionID)
	if l > 0 {
		n += 1 + l + sovDispatcher(uint64(l))
	}
	if len(m.Updates) > 0 {
		for _, e := range m.Updates {
			l = e.Size()
			n += 1 + l + sovDispatcher(uint64(l))
		}
	}
	return n
}

func (m *UpdateTaskStatusRequest_TaskStatusUpdate) Size() (n int) {
	var l int
	_ = l
	l = len(m.TaskID)
	if l > 0 {
		n += 1 + l + sovDispatcher(uint64(l))
	}
	if m.Status != nil {
		l = m.Status.Size()
		n += 1 + l + sovDispatcher(uint64(l))
	}
	return n
}

func (m *UpdateTaskStatusResponse) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *TasksRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.SessionID)
	if l > 0 {
		n += 1 + l + sovDispatcher(uint64(l))
	}
	return n
}

func (m *TasksMessage) Size() (n int) {
	var l int
	_ = l
	if len(m.Tasks) > 0 {
		for _, e := range m.Tasks {
			l = e.Size()
			n += 1 + l + sovDispatcher(uint64(l))
		}
	}
	return n
}

func sovDispatcher(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozDispatcher(x uint64) (n int) {
	return sovDispatcher(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *RegisterRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RegisterRequest{`,
		`Description:` + strings.Replace(fmt.Sprintf("%v", this.Description), "NodeDescription", "NodeDescription", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *RegisterResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RegisterResponse{`,
		`NodeID:` + fmt.Sprintf("%v", this.NodeID) + `,`,
		`SessionID:` + fmt.Sprintf("%v", this.SessionID) + `,`,
		`}`,
	}, "")
	return s
}
func (this *SessionRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&SessionRequest{`,
		`SessionID:` + fmt.Sprintf("%v", this.SessionID) + `,`,
		`}`,
	}, "")
	return s
}
func (this *SessionMessage) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&SessionMessage{`,
		`Managers:` + strings.Replace(fmt.Sprintf("%v", this.Managers), "WeightedPeer", "WeightedPeer", 1) + `,`,
		`Disconnect:` + fmt.Sprintf("%v", this.Disconnect) + `,`,
		`}`,
	}, "")
	return s
}
func (this *HeartbeatRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&HeartbeatRequest{`,
		`SessionID:` + fmt.Sprintf("%v", this.SessionID) + `,`,
		`}`,
	}, "")
	return s
}
func (this *HeartbeatResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&HeartbeatResponse{`,
		`Period:` + fmt.Sprintf("%v", this.Period) + `,`,
		`}`,
	}, "")
	return s
}
func (this *UpdateTaskStatusRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&UpdateTaskStatusRequest{`,
		`SessionID:` + fmt.Sprintf("%v", this.SessionID) + `,`,
		`Updates:` + strings.Replace(fmt.Sprintf("%v", this.Updates), "UpdateTaskStatusRequest_TaskStatusUpdate", "UpdateTaskStatusRequest_TaskStatusUpdate", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *UpdateTaskStatusRequest_TaskStatusUpdate) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&UpdateTaskStatusRequest_TaskStatusUpdate{`,
		`TaskID:` + fmt.Sprintf("%v", this.TaskID) + `,`,
		`Status:` + strings.Replace(fmt.Sprintf("%v", this.Status), "TaskStatus", "TaskStatus", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *UpdateTaskStatusResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&UpdateTaskStatusResponse{`,
		`}`,
	}, "")
	return s
}
func (this *TasksRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&TasksRequest{`,
		`SessionID:` + fmt.Sprintf("%v", this.SessionID) + `,`,
		`}`,
	}, "")
	return s
}
func (this *TasksMessage) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&TasksMessage{`,
		`Tasks:` + strings.Replace(fmt.Sprintf("%v", this.Tasks), "Task", "Task", 1) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringDispatcher(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *RegisterRequest) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDispatcher
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RegisterRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RegisterRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDispatcher
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Description == nil {
				m.Description = &NodeDescription{}
			}
			if err := m.Description.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDispatcher(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthDispatcher
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RegisterResponse) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDispatcher
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RegisterResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RegisterResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDispatcher
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NodeID = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SessionID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDispatcher
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SessionID = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDispatcher(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthDispatcher
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SessionRequest) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDispatcher
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SessionRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SessionRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SessionID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDispatcher
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SessionID = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDispatcher(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthDispatcher
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SessionMessage) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDispatcher
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SessionMessage: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SessionMessage: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Managers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDispatcher
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Managers = append(m.Managers, &WeightedPeer{})
			if err := m.Managers[len(m.Managers)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Disconnect", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Disconnect = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipDispatcher(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthDispatcher
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HeartbeatRequest) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDispatcher
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HeartbeatRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HeartbeatRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SessionID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDispatcher
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SessionID = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDispatcher(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthDispatcher
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HeartbeatResponse) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDispatcher
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HeartbeatResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HeartbeatResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Period", wireType)
			}
			m.Period = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.Period |= (time.Duration(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipDispatcher(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthDispatcher
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UpdateTaskStatusRequest) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDispatcher
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UpdateTaskStatusRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UpdateTaskStatusRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SessionID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDispatcher
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SessionID = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Updates", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDispatcher
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Updates = append(m.Updates, &UpdateTaskStatusRequest_TaskStatusUpdate{})
			if err := m.Updates[len(m.Updates)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDispatcher(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthDispatcher
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UpdateTaskStatusRequest_TaskStatusUpdate) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDispatcher
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TaskStatusUpdate: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TaskStatusUpdate: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDispatcher
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TaskID = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDispatcher
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Status == nil {
				m.Status = &TaskStatus{}
			}
			if err := m.Status.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDispatcher(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthDispatcher
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UpdateTaskStatusResponse) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDispatcher
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UpdateTaskStatusResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UpdateTaskStatusResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipDispatcher(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthDispatcher
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TasksRequest) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDispatcher
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TasksRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TasksRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SessionID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDispatcher
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SessionID = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDispatcher(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthDispatcher
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TasksMessage) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDispatcher
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TasksMessage: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TasksMessage: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tasks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDispatcher
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Tasks = append(m.Tasks, &Task{})
			if err := m.Tasks[len(m.Tasks)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDispatcher(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthDispatcher
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipDispatcher(data []byte) (n int, err error) {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowDispatcher
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if data[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthDispatcher
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowDispatcher
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := data[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipDispatcher(data[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthDispatcher = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowDispatcher   = fmt.Errorf("proto: integer overflow")
)

var fileDescriptorDispatcher = []byte{
	// 584 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0x9c, 0x54, 0xcd, 0x6e, 0xd3, 0x40,
	0x10, 0x8e, 0x1b, 0xea, 0x24, 0x13, 0x02, 0x61, 0x05, 0x22, 0xb2, 0x50, 0x12, 0xb9, 0x20, 0x21,
	0x51, 0x0c, 0x0a, 0x12, 0xa7, 0x08, 0xa1, 0x28, 0x48, 0xe4, 0x00, 0x54, 0x2e, 0xa5, 0x88, 0x0b,
	0x72, 0xec, 0x55, 0x6a, 0x4a, 0xbd, 0xc6, 0xbb, 0x39, 0x70, 0xe3, 0x11, 0x78, 0xac, 0x1c, 0x39,
	0xa2, 0x1e, 0x22, 0xda, 0x27, 0xe0, 0x11, 0x98, 0x5d, 0xff, 0x24, 0x75, 0x9d, 0x96, 0xe6, 0xb0,
	0xf2, 0xee, 0xec, 0xf7, 0xcd, 0x7e, 0xf3, 0x67, 0x68, 0x7a, 0x3e, 0x0f, 0x1d, 0xe1, 0x1e, 0xd0,
	0xc8, 0x0a, 0x23, 0x26, 0x18, 0x21, 0x1e, 0x73, 0x0f, 0xf1, 0xe4, 0x7e, 0x9d, 0x72, 0x81, 0x5f,
	0x27, 0xf4, 0x8d, 0xba, 0xf8, 0x1e, 0x52, 0x1e, 0x03, 0x8c, 0x06, 0x1b, 0x7f, 0xa1, 0xae, 0x48,
	0x8f, 0xb7, 0x27, 0x6c, 0xc2, 0xd4, 0xf6, 0x89, 0xdc, 0xc5, 0x56, 0xf3, 0x23, 0xdc, 0xb4, 0xe9,
	0xc4, 0x97, 0x1e, 0x6c, 0xfa, 0x6d, 0x4a, 0xb9, 0x20, 0xaf, 0xa0, 0xee, 0x51, 0xee, 0x46, 0x7e,
	0x28, 0x7c, 0x16, 0xb4, 0xb4, 0xae, 0xf6, 0xb0, 0xde, 0xdb, 0xb2, 0xce, 0x3f, 0x67, 0xbd, 0x65,
	0x1e, 0x1d, 0x2e, 0xa0, 0xf6, 0x32, 0xcf, 0xa4, 0xd0, 0x5c, 0x78, 0xe6, 0x21, 0x0b, 0x38, 0x25,
	0x5b, 0x50, 0x09, 0x90, 0xf3, 0xd9, 0xf7, 0x94, 0xdb, 0xda, 0x00, 0x4e, 0xe7, 0x1d, 0x5d, 0xba,
	0x19, 0x0d, 0x6d, 0x5d, 0x5e, 0x8d, 0x3c, 0xb2, 0x0d, 0xc0, 0x29, 0xe7, 0xe8, 0x43, 0xe2, 0x36,
	0x14, 0xae, 0x81, 0xb8, 0xda, 0x6e, 0x6c, 0x45, 0x68, 0x2d, 0x01, 0x8c, 0x3c, 0xf3, 0x05, 0xdc,
	0x48, 0xec, 0xa9, 0xfe, 0xb3, 0x7c, 0xed, 0x12, 0x7e, 0x90, 0xf1, 0xdf, 0xe0, 0xc7, 0x99, 0x50,
	0xd2, 0x87, 0xea, 0x91, 0x13, 0xe0, 0x2e, 0xe2, 0xc8, 0x2e, 0x63, 0xf0, 0xdd, 0xa2, 0xe0, 0xf7,
	0xa9, 0x3f, 0x39, 0x10, 0xd4, 0xdb, 0xa1, 0x18, 0x60, 0xc6, 0x20, 0x6d, 0x00, 0x2c, 0x95, 0xcb,
	0x82, 0x00, 0x73, 0xaf, 0xd4, 0x57, 0xed, 0x25, 0x8b, 0xf9, 0x12, 0x9a, 0xaf, 0xa9, 0x13, 0x89,
	0x31, 0x75, 0xc4, 0x7a, 0x8a, 0x07, 0x70, 0x6b, 0xc9, 0x43, 0x92, 0xd9, 0xc7, 0xa0, 0xef, 0xd0,
	0xc8, 0x67, 0x31, 0xfd, 0xda, 0xe0, 0xce, 0x6c, 0xde, 0x29, 0x1d, 0xcf, 0x3b, 0x0d, 0xe1, 0x1f,
	0x51, 0x6b, 0x38, 0x8d, 0x1c, 0x55, 0x21, 0x3d, 0x54, 0x20, 0xf3, 0xe7, 0x06, 0xdc, 0xdd, 0x0b,
	0x3d, 0x47, 0xd0, 0xf7, 0x0e, 0x3f, 0xdc, 0x15, 0x8e, 0x98, 0xf2, 0xb5, 0xd4, 0x90, 0x0f, 0x50,
	0x99, 0x2a, 0x47, 0xbc, 0x55, 0x56, 0xc9, 0xea, 0x17, 0x25, 0x6b, 0xc5, 0x5b, 0xd6, 0xc2, 0x12,
	0x23, 0xec, 0xd4, 0x99, 0xc1, 0xa0, 0x99, 0xbf, 0x94, 0xed, 0x23, 0xd0, 0x96, 0x6b, 0x1f, 0x09,
	0x93, 0xed, 0x23, 0xaf, 0x50, 0xd0, 0x73, 0xd0, 0xb9, 0x22, 0xa9, 0xe4, 0xd7, 0x7b, 0xed, 0x22,
	0x3d, 0x4b, 0x4a, 0x12, 0xb4, 0x69, 0x40, 0xeb, 0xbc, 0xca, 0x38, 0xbb, 0x66, 0x1f, 0xae, 0x4b,
	0xeb, 0x7a, 0x29, 0xc2, 0x16, 0x8d, 0xd9, 0x69, 0x83, 0x59, 0xb0, 0x29, 0xb5, 0xa6, 0xdd, 0xd5,
	0x5a, 0x25, 0xd0, 0x8e, 0x61, 0xbd, 0xe3, 0x32, 0xc0, 0x30, 0x1b, 0x7f, 0xb2, 0x0f, 0xd5, 0x74,
	0xb0, 0x48, 0xe1, 0x58, 0xe6, 0x06, 0xda, 0xb8, 0x7f, 0x31, 0x28, 0x89, 0xb1, 0x44, 0xf6, 0xa0,
	0x92, 0xe8, 0x27, 0x66, 0x11, 0xe5, 0xec, 0x9c, 0x19, 0x17, 0x61, 0x92, 0x50, 0xcd, 0xd2, 0x53,
	0x8d, 0x7c, 0x82, 0x5a, 0xd6, 0xaf, 0xa4, 0x50, 0x4b, 0x7e, 0x20, 0x8c, 0x07, 0x97, 0xa0, 0x32,
	0xc9, 0xd8, 0x25, 0xf9, 0xa2, 0x91, 0x47, 0x57, 0x68, 0x40, 0x63, 0xfb, 0xff, 0xc0, 0xd9, 0x83,
	0xef, 0x60, 0x53, 0xd5, 0x92, 0x74, 0x57, 0x55, 0x2d, 0x73, 0xbd, 0x1a, 0xb1, 0x94, 0x9d, 0xc1,
	0xbd, 0xd9, 0x49, 0xbb, 0xf4, 0x1b, 0xd7, 0xdf, 0x93, 0xb6, 0xf6, 0xe3, 0xb4, 0xad, 0xcd, 0x70,
	0xfd, 0xc2, 0xf5, 0x07, 0xd7, 0x58, 0x57, 0x7f, 0xe9, 0x67, 0xff, 0x02, 0x00, 0x00, 0xff, 0xff,
	0xaa, 0x05, 0x84, 0xdf, 0xff, 0x05, 0x00, 0x00,
}
