// Code generated by protoc-gen-gogo.
// source: cluster.proto
// DO NOT EDIT!

package api

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "github.com/gogo/protobuf/gogoproto"

import strings "strings"
import github_com_gogo_protobuf_proto "github.com/gogo/protobuf/proto"
import sort "sort"
import strconv "strconv"
import reflect "reflect"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

import raftpicker "github.com/docker/swarm-v2/manager/raftpicker"
import codes "google.golang.org/grpc/codes"
import metadata "google.golang.org/grpc/metadata"
import transport "google.golang.org/grpc/transport"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

type ListOptions struct {
	// TODO(vieux): Replace `query` with more powerful selectors.
	Query string `protobuf:"bytes,1,opt,name=query,proto3" json:"query,omitempty"`
}

func (m *ListOptions) Reset()                    { *m = ListOptions{} }
func (*ListOptions) ProtoMessage()               {}
func (*ListOptions) Descriptor() ([]byte, []int) { return fileDescriptorCluster, []int{0} }

type GetNodeRequest struct {
	NodeID string `protobuf:"bytes,1,opt,name=node_id,json=nodeId,proto3" json:"node_id,omitempty"`
}

func (m *GetNodeRequest) Reset()                    { *m = GetNodeRequest{} }
func (*GetNodeRequest) ProtoMessage()               {}
func (*GetNodeRequest) Descriptor() ([]byte, []int) { return fileDescriptorCluster, []int{1} }

type GetNodeResponse struct {
	Node *Node `protobuf:"bytes,1,opt,name=node" json:"node,omitempty"`
}

func (m *GetNodeResponse) Reset()                    { *m = GetNodeResponse{} }
func (*GetNodeResponse) ProtoMessage()               {}
func (*GetNodeResponse) Descriptor() ([]byte, []int) { return fileDescriptorCluster, []int{2} }

type ListNodesRequest struct {
	Options *ListOptions `protobuf:"bytes,1,opt,name=options" json:"options,omitempty"`
}

func (m *ListNodesRequest) Reset()                    { *m = ListNodesRequest{} }
func (*ListNodesRequest) ProtoMessage()               {}
func (*ListNodesRequest) Descriptor() ([]byte, []int) { return fileDescriptorCluster, []int{3} }

type ListNodesResponse struct {
	Nodes []*Node `protobuf:"bytes,1,rep,name=nodes" json:"nodes,omitempty"`
}

func (m *ListNodesResponse) Reset()                    { *m = ListNodesResponse{} }
func (*ListNodesResponse) ProtoMessage()               {}
func (*ListNodesResponse) Descriptor() ([]byte, []int) { return fileDescriptorCluster, []int{4} }

// UpdateNodeRequest requests an update to the specified node. This may be used
// to request a new availability for a node, such as PAUSE. Invalid updates
// will be denied and cause an error.
type UpdateNodeRequest struct {
	NodeID      string    `protobuf:"bytes,1,opt,name=node_id,json=nodeId,proto3" json:"node_id,omitempty"`
	NodeVersion *Version  `protobuf:"bytes,2,opt,name=node_version,json=nodeVersion" json:"node_version,omitempty"`
	Spec        *NodeSpec `protobuf:"bytes,3,opt,name=spec" json:"spec,omitempty"`
}

func (m *UpdateNodeRequest) Reset()                    { *m = UpdateNodeRequest{} }
func (*UpdateNodeRequest) ProtoMessage()               {}
func (*UpdateNodeRequest) Descriptor() ([]byte, []int) { return fileDescriptorCluster, []int{5} }

type UpdateNodeResponse struct {
	Node *Node `protobuf:"bytes,1,opt,name=node" json:"node,omitempty"`
}

func (m *UpdateNodeResponse) Reset()                    { *m = UpdateNodeResponse{} }
func (*UpdateNodeResponse) ProtoMessage()               {}
func (*UpdateNodeResponse) Descriptor() ([]byte, []int) { return fileDescriptorCluster, []int{6} }

type GetTaskRequest struct {
	TaskID string `protobuf:"bytes,1,opt,name=task_id,json=taskId,proto3" json:"task_id,omitempty"`
}

func (m *GetTaskRequest) Reset()                    { *m = GetTaskRequest{} }
func (*GetTaskRequest) ProtoMessage()               {}
func (*GetTaskRequest) Descriptor() ([]byte, []int) { return fileDescriptorCluster, []int{7} }

type GetTaskResponse struct {
	Task *Task `protobuf:"bytes,1,opt,name=task" json:"task,omitempty"`
}

func (m *GetTaskResponse) Reset()                    { *m = GetTaskResponse{} }
func (*GetTaskResponse) ProtoMessage()               {}
func (*GetTaskResponse) Descriptor() ([]byte, []int) { return fileDescriptorCluster, []int{8} }

type RemoveTaskRequest struct {
	TaskID string `protobuf:"bytes,1,opt,name=task_id,json=taskId,proto3" json:"task_id,omitempty"`
}

func (m *RemoveTaskRequest) Reset()                    { *m = RemoveTaskRequest{} }
func (*RemoveTaskRequest) ProtoMessage()               {}
func (*RemoveTaskRequest) Descriptor() ([]byte, []int) { return fileDescriptorCluster, []int{9} }

type RemoveTaskResponse struct {
}

func (m *RemoveTaskResponse) Reset()                    { *m = RemoveTaskResponse{} }
func (*RemoveTaskResponse) ProtoMessage()               {}
func (*RemoveTaskResponse) Descriptor() ([]byte, []int) { return fileDescriptorCluster, []int{10} }

type ListTasksRequest struct {
}

func (m *ListTasksRequest) Reset()                    { *m = ListTasksRequest{} }
func (*ListTasksRequest) ProtoMessage()               {}
func (*ListTasksRequest) Descriptor() ([]byte, []int) { return fileDescriptorCluster, []int{11} }

type ListTasksResponse struct {
	Tasks []*Task `protobuf:"bytes,1,rep,name=tasks" json:"tasks,omitempty"`
}

func (m *ListTasksResponse) Reset()                    { *m = ListTasksResponse{} }
func (*ListTasksResponse) ProtoMessage()               {}
func (*ListTasksResponse) Descriptor() ([]byte, []int) { return fileDescriptorCluster, []int{12} }

type CreateServiceRequest struct {
	Spec *ServiceSpec `protobuf:"bytes,1,opt,name=spec" json:"spec,omitempty"`
}

func (m *CreateServiceRequest) Reset()                    { *m = CreateServiceRequest{} }
func (*CreateServiceRequest) ProtoMessage()               {}
func (*CreateServiceRequest) Descriptor() ([]byte, []int) { return fileDescriptorCluster, []int{13} }

type CreateServiceResponse struct {
	Service *Service `protobuf:"bytes,1,opt,name=service" json:"service,omitempty"`
}

func (m *CreateServiceResponse) Reset()                    { *m = CreateServiceResponse{} }
func (*CreateServiceResponse) ProtoMessage()               {}
func (*CreateServiceResponse) Descriptor() ([]byte, []int) { return fileDescriptorCluster, []int{14} }

type GetServiceRequest struct {
	ServiceID string `protobuf:"bytes,1,opt,name=service_id,json=serviceId,proto3" json:"service_id,omitempty"`
}

func (m *GetServiceRequest) Reset()                    { *m = GetServiceRequest{} }
func (*GetServiceRequest) ProtoMessage()               {}
func (*GetServiceRequest) Descriptor() ([]byte, []int) { return fileDescriptorCluster, []int{15} }

type GetServiceResponse struct {
	Service *Service `protobuf:"bytes,1,opt,name=service" json:"service,omitempty"`
}

func (m *GetServiceResponse) Reset()                    { *m = GetServiceResponse{} }
func (*GetServiceResponse) ProtoMessage()               {}
func (*GetServiceResponse) Descriptor() ([]byte, []int) { return fileDescriptorCluster, []int{16} }

type UpdateServiceRequest struct {
	ServiceID      string       `protobuf:"bytes,1,opt,name=service_id,json=serviceId,proto3" json:"service_id,omitempty"`
	ServiceVersion *Version     `protobuf:"bytes,2,opt,name=service_version,json=serviceVersion" json:"service_version,omitempty"`
	Spec           *ServiceSpec `protobuf:"bytes,3,opt,name=spec" json:"spec,omitempty"`
}

func (m *UpdateServiceRequest) Reset()                    { *m = UpdateServiceRequest{} }
func (*UpdateServiceRequest) ProtoMessage()               {}
func (*UpdateServiceRequest) Descriptor() ([]byte, []int) { return fileDescriptorCluster, []int{17} }

type UpdateServiceResponse struct {
	Service *Service `protobuf:"bytes,1,opt,name=service" json:"service,omitempty"`
}

func (m *UpdateServiceResponse) Reset()                    { *m = UpdateServiceResponse{} }
func (*UpdateServiceResponse) ProtoMessage()               {}
func (*UpdateServiceResponse) Descriptor() ([]byte, []int) { return fileDescriptorCluster, []int{18} }

type RemoveServiceRequest struct {
	ServiceID string `protobuf:"bytes,1,opt,name=service_id,json=serviceId,proto3" json:"service_id,omitempty"`
}

func (m *RemoveServiceRequest) Reset()                    { *m = RemoveServiceRequest{} }
func (*RemoveServiceRequest) ProtoMessage()               {}
func (*RemoveServiceRequest) Descriptor() ([]byte, []int) { return fileDescriptorCluster, []int{19} }

type RemoveServiceResponse struct {
}

func (m *RemoveServiceResponse) Reset()                    { *m = RemoveServiceResponse{} }
func (*RemoveServiceResponse) ProtoMessage()               {}
func (*RemoveServiceResponse) Descriptor() ([]byte, []int) { return fileDescriptorCluster, []int{20} }

type ListServicesRequest struct {
	Options *ListOptions `protobuf:"bytes,1,opt,name=options" json:"options,omitempty"`
}

func (m *ListServicesRequest) Reset()                    { *m = ListServicesRequest{} }
func (*ListServicesRequest) ProtoMessage()               {}
func (*ListServicesRequest) Descriptor() ([]byte, []int) { return fileDescriptorCluster, []int{21} }

type ListServicesResponse struct {
	Services []*Service `protobuf:"bytes,1,rep,name=services" json:"services,omitempty"`
}

func (m *ListServicesResponse) Reset()                    { *m = ListServicesResponse{} }
func (*ListServicesResponse) ProtoMessage()               {}
func (*ListServicesResponse) Descriptor() ([]byte, []int) { return fileDescriptorCluster, []int{22} }

type CreateNetworkRequest struct {
	Spec *NetworkSpec `protobuf:"bytes,1,opt,name=spec" json:"spec,omitempty"`
}

func (m *CreateNetworkRequest) Reset()                    { *m = CreateNetworkRequest{} }
func (*CreateNetworkRequest) ProtoMessage()               {}
func (*CreateNetworkRequest) Descriptor() ([]byte, []int) { return fileDescriptorCluster, []int{23} }

type CreateNetworkResponse struct {
	Network *Network `protobuf:"bytes,1,opt,name=network" json:"network,omitempty"`
}

func (m *CreateNetworkResponse) Reset()                    { *m = CreateNetworkResponse{} }
func (*CreateNetworkResponse) ProtoMessage()               {}
func (*CreateNetworkResponse) Descriptor() ([]byte, []int) { return fileDescriptorCluster, []int{24} }

type GetNetworkRequest struct {
	Name      string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	NetworkID string `protobuf:"bytes,2,opt,name=network_id,json=networkId,proto3" json:"network_id,omitempty"`
}

func (m *GetNetworkRequest) Reset()                    { *m = GetNetworkRequest{} }
func (*GetNetworkRequest) ProtoMessage()               {}
func (*GetNetworkRequest) Descriptor() ([]byte, []int) { return fileDescriptorCluster, []int{25} }

type GetNetworkResponse struct {
	Network *Network `protobuf:"bytes,1,opt,name=network" json:"network,omitempty"`
}

func (m *GetNetworkResponse) Reset()                    { *m = GetNetworkResponse{} }
func (*GetNetworkResponse) ProtoMessage()               {}
func (*GetNetworkResponse) Descriptor() ([]byte, []int) { return fileDescriptorCluster, []int{26} }

type RemoveNetworkRequest struct {
	Name      string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	NetworkID string `protobuf:"bytes,2,opt,name=network_id,json=networkId,proto3" json:"network_id,omitempty"`
}

func (m *RemoveNetworkRequest) Reset()                    { *m = RemoveNetworkRequest{} }
func (*RemoveNetworkRequest) ProtoMessage()               {}
func (*RemoveNetworkRequest) Descriptor() ([]byte, []int) { return fileDescriptorCluster, []int{27} }

type RemoveNetworkResponse struct {
}

func (m *RemoveNetworkResponse) Reset()                    { *m = RemoveNetworkResponse{} }
func (*RemoveNetworkResponse) ProtoMessage()               {}
func (*RemoveNetworkResponse) Descriptor() ([]byte, []int) { return fileDescriptorCluster, []int{28} }

type ListNetworksRequest struct {
	Options *ListOptions `protobuf:"bytes,1,opt,name=options" json:"options,omitempty"`
}

func (m *ListNetworksRequest) Reset()                    { *m = ListNetworksRequest{} }
func (*ListNetworksRequest) ProtoMessage()               {}
func (*ListNetworksRequest) Descriptor() ([]byte, []int) { return fileDescriptorCluster, []int{29} }

type ListNetworksResponse struct {
	Networks []*Network `protobuf:"bytes,1,rep,name=networks" json:"networks,omitempty"`
}

func (m *ListNetworksResponse) Reset()                    { *m = ListNetworksResponse{} }
func (*ListNetworksResponse) ProtoMessage()               {}
func (*ListNetworksResponse) Descriptor() ([]byte, []int) { return fileDescriptorCluster, []int{30} }

type CreateVolumeRequest struct {
	Spec *VolumeSpec `protobuf:"bytes,1,opt,name=spec" json:"spec,omitempty"`
}

func (m *CreateVolumeRequest) Reset()                    { *m = CreateVolumeRequest{} }
func (*CreateVolumeRequest) ProtoMessage()               {}
func (*CreateVolumeRequest) Descriptor() ([]byte, []int) { return fileDescriptorCluster, []int{31} }

type CreateVolumeResponse struct {
	Volume *Volume `protobuf:"bytes,1,opt,name=volume" json:"volume,omitempty"`
}

func (m *CreateVolumeResponse) Reset()                    { *m = CreateVolumeResponse{} }
func (*CreateVolumeResponse) ProtoMessage()               {}
func (*CreateVolumeResponse) Descriptor() ([]byte, []int) { return fileDescriptorCluster, []int{32} }

type GetVolumeRequest struct {
	VolumeID string `protobuf:"bytes,1,opt,name=volume_id,json=volumeId,proto3" json:"volume_id,omitempty"`
}

func (m *GetVolumeRequest) Reset()                    { *m = GetVolumeRequest{} }
func (*GetVolumeRequest) ProtoMessage()               {}
func (*GetVolumeRequest) Descriptor() ([]byte, []int) { return fileDescriptorCluster, []int{33} }

type GetVolumeResponse struct {
	Volume *Volume `protobuf:"bytes,1,opt,name=volume" json:"volume,omitempty"`
}

func (m *GetVolumeResponse) Reset()                    { *m = GetVolumeResponse{} }
func (*GetVolumeResponse) ProtoMessage()               {}
func (*GetVolumeResponse) Descriptor() ([]byte, []int) { return fileDescriptorCluster, []int{34} }

type RemoveVolumeRequest struct {
	VolumeID string `protobuf:"bytes,1,opt,name=volume_id,json=volumeId,proto3" json:"volume_id,omitempty"`
}

func (m *RemoveVolumeRequest) Reset()                    { *m = RemoveVolumeRequest{} }
func (*RemoveVolumeRequest) ProtoMessage()               {}
func (*RemoveVolumeRequest) Descriptor() ([]byte, []int) { return fileDescriptorCluster, []int{35} }

type RemoveVolumeResponse struct {
}

func (m *RemoveVolumeResponse) Reset()                    { *m = RemoveVolumeResponse{} }
func (*RemoveVolumeResponse) ProtoMessage()               {}
func (*RemoveVolumeResponse) Descriptor() ([]byte, []int) { return fileDescriptorCluster, []int{36} }

type ListVolumesRequest struct {
}

func (m *ListVolumesRequest) Reset()                    { *m = ListVolumesRequest{} }
func (*ListVolumesRequest) ProtoMessage()               {}
func (*ListVolumesRequest) Descriptor() ([]byte, []int) { return fileDescriptorCluster, []int{37} }

type ListVolumesResponse struct {
	Volumes []*Volume `protobuf:"bytes,1,rep,name=volumes" json:"volumes,omitempty"`
}

func (m *ListVolumesResponse) Reset()                    { *m = ListVolumesResponse{} }
func (*ListVolumesResponse) ProtoMessage()               {}
func (*ListVolumesResponse) Descriptor() ([]byte, []int) { return fileDescriptorCluster, []int{38} }

type ListManagersRequest struct {
	Options *ListOptions `protobuf:"bytes,1,opt,name=options" json:"options,omitempty"`
}

func (m *ListManagersRequest) Reset()                    { *m = ListManagersRequest{} }
func (*ListManagersRequest) ProtoMessage()               {}
func (*ListManagersRequest) Descriptor() ([]byte, []int) { return fileDescriptorCluster, []int{39} }

type ListManagersResponse struct {
	Managers []*Member `protobuf:"bytes,1,rep,name=managers" json:"managers,omitempty"`
}

func (m *ListManagersResponse) Reset()                    { *m = ListManagersResponse{} }
func (*ListManagersResponse) ProtoMessage()               {}
func (*ListManagersResponse) Descriptor() ([]byte, []int) { return fileDescriptorCluster, []int{40} }

func init() {
	proto.RegisterType((*ListOptions)(nil), "docker.cluster.api.ListOptions")
	proto.RegisterType((*GetNodeRequest)(nil), "docker.cluster.api.GetNodeRequest")
	proto.RegisterType((*GetNodeResponse)(nil), "docker.cluster.api.GetNodeResponse")
	proto.RegisterType((*ListNodesRequest)(nil), "docker.cluster.api.ListNodesRequest")
	proto.RegisterType((*ListNodesResponse)(nil), "docker.cluster.api.ListNodesResponse")
	proto.RegisterType((*UpdateNodeRequest)(nil), "docker.cluster.api.UpdateNodeRequest")
	proto.RegisterType((*UpdateNodeResponse)(nil), "docker.cluster.api.UpdateNodeResponse")
	proto.RegisterType((*GetTaskRequest)(nil), "docker.cluster.api.GetTaskRequest")
	proto.RegisterType((*GetTaskResponse)(nil), "docker.cluster.api.GetTaskResponse")
	proto.RegisterType((*RemoveTaskRequest)(nil), "docker.cluster.api.RemoveTaskRequest")
	proto.RegisterType((*RemoveTaskResponse)(nil), "docker.cluster.api.RemoveTaskResponse")
	proto.RegisterType((*ListTasksRequest)(nil), "docker.cluster.api.ListTasksRequest")
	proto.RegisterType((*ListTasksResponse)(nil), "docker.cluster.api.ListTasksResponse")
	proto.RegisterType((*CreateServiceRequest)(nil), "docker.cluster.api.CreateServiceRequest")
	proto.RegisterType((*CreateServiceResponse)(nil), "docker.cluster.api.CreateServiceResponse")
	proto.RegisterType((*GetServiceRequest)(nil), "docker.cluster.api.GetServiceRequest")
	proto.RegisterType((*GetServiceResponse)(nil), "docker.cluster.api.GetServiceResponse")
	proto.RegisterType((*UpdateServiceRequest)(nil), "docker.cluster.api.UpdateServiceRequest")
	proto.RegisterType((*UpdateServiceResponse)(nil), "docker.cluster.api.UpdateServiceResponse")
	proto.RegisterType((*RemoveServiceRequest)(nil), "docker.cluster.api.RemoveServiceRequest")
	proto.RegisterType((*RemoveServiceResponse)(nil), "docker.cluster.api.RemoveServiceResponse")
	proto.RegisterType((*ListServicesRequest)(nil), "docker.cluster.api.ListServicesRequest")
	proto.RegisterType((*ListServicesResponse)(nil), "docker.cluster.api.ListServicesResponse")
	proto.RegisterType((*CreateNetworkRequest)(nil), "docker.cluster.api.CreateNetworkRequest")
	proto.RegisterType((*CreateNetworkResponse)(nil), "docker.cluster.api.CreateNetworkResponse")
	proto.RegisterType((*GetNetworkRequest)(nil), "docker.cluster.api.GetNetworkRequest")
	proto.RegisterType((*GetNetworkResponse)(nil), "docker.cluster.api.GetNetworkResponse")
	proto.RegisterType((*RemoveNetworkRequest)(nil), "docker.cluster.api.RemoveNetworkRequest")
	proto.RegisterType((*RemoveNetworkResponse)(nil), "docker.cluster.api.RemoveNetworkResponse")
	proto.RegisterType((*ListNetworksRequest)(nil), "docker.cluster.api.ListNetworksRequest")
	proto.RegisterType((*ListNetworksResponse)(nil), "docker.cluster.api.ListNetworksResponse")
	proto.RegisterType((*CreateVolumeRequest)(nil), "docker.cluster.api.CreateVolumeRequest")
	proto.RegisterType((*CreateVolumeResponse)(nil), "docker.cluster.api.CreateVolumeResponse")
	proto.RegisterType((*GetVolumeRequest)(nil), "docker.cluster.api.GetVolumeRequest")
	proto.RegisterType((*GetVolumeResponse)(nil), "docker.cluster.api.GetVolumeResponse")
	proto.RegisterType((*RemoveVolumeRequest)(nil), "docker.cluster.api.RemoveVolumeRequest")
	proto.RegisterType((*RemoveVolumeResponse)(nil), "docker.cluster.api.RemoveVolumeResponse")
	proto.RegisterType((*ListVolumesRequest)(nil), "docker.cluster.api.ListVolumesRequest")
	proto.RegisterType((*ListVolumesResponse)(nil), "docker.cluster.api.ListVolumesResponse")
	proto.RegisterType((*ListManagersRequest)(nil), "docker.cluster.api.ListManagersRequest")
	proto.RegisterType((*ListManagersResponse)(nil), "docker.cluster.api.ListManagersResponse")
}

func (m *ListOptions) Copy() *ListOptions {
	if m == nil {
		return nil
	}

	o := &ListOptions{
		Query: m.Query,
	}

	return o
}

func (m *GetNodeRequest) Copy() *GetNodeRequest {
	if m == nil {
		return nil
	}

	o := &GetNodeRequest{
		NodeID: m.NodeID,
	}

	return o
}

func (m *GetNodeResponse) Copy() *GetNodeResponse {
	if m == nil {
		return nil
	}

	o := &GetNodeResponse{
		Node: m.Node.Copy(),
	}

	return o
}

func (m *ListNodesRequest) Copy() *ListNodesRequest {
	if m == nil {
		return nil
	}

	o := &ListNodesRequest{
		Options: m.Options.Copy(),
	}

	return o
}

func (m *ListNodesResponse) Copy() *ListNodesResponse {
	if m == nil {
		return nil
	}

	o := &ListNodesResponse{}

	if m.Nodes != nil {
		o.Nodes = make([]*Node, 0, len(m.Nodes))
		for _, v := range m.Nodes {
			o.Nodes = append(o.Nodes, v.Copy())
		}
	}

	return o
}

func (m *UpdateNodeRequest) Copy() *UpdateNodeRequest {
	if m == nil {
		return nil
	}

	o := &UpdateNodeRequest{
		NodeID:      m.NodeID,
		NodeVersion: m.NodeVersion.Copy(),
		Spec:        m.Spec.Copy(),
	}

	return o
}

func (m *UpdateNodeResponse) Copy() *UpdateNodeResponse {
	if m == nil {
		return nil
	}

	o := &UpdateNodeResponse{
		Node: m.Node.Copy(),
	}

	return o
}

func (m *GetTaskRequest) Copy() *GetTaskRequest {
	if m == nil {
		return nil
	}

	o := &GetTaskRequest{
		TaskID: m.TaskID,
	}

	return o
}

func (m *GetTaskResponse) Copy() *GetTaskResponse {
	if m == nil {
		return nil
	}

	o := &GetTaskResponse{
		Task: m.Task.Copy(),
	}

	return o
}

func (m *RemoveTaskRequest) Copy() *RemoveTaskRequest {
	if m == nil {
		return nil
	}

	o := &RemoveTaskRequest{
		TaskID: m.TaskID,
	}

	return o
}

func (m *RemoveTaskResponse) Copy() *RemoveTaskResponse {
	if m == nil {
		return nil
	}

	o := &RemoveTaskResponse{}

	return o
}

func (m *ListTasksRequest) Copy() *ListTasksRequest {
	if m == nil {
		return nil
	}

	o := &ListTasksRequest{}

	return o
}

func (m *ListTasksResponse) Copy() *ListTasksResponse {
	if m == nil {
		return nil
	}

	o := &ListTasksResponse{}

	if m.Tasks != nil {
		o.Tasks = make([]*Task, 0, len(m.Tasks))
		for _, v := range m.Tasks {
			o.Tasks = append(o.Tasks, v.Copy())
		}
	}

	return o
}

func (m *CreateServiceRequest) Copy() *CreateServiceRequest {
	if m == nil {
		return nil
	}

	o := &CreateServiceRequest{
		Spec: m.Spec.Copy(),
	}

	return o
}

func (m *CreateServiceResponse) Copy() *CreateServiceResponse {
	if m == nil {
		return nil
	}

	o := &CreateServiceResponse{
		Service: m.Service.Copy(),
	}

	return o
}

func (m *GetServiceRequest) Copy() *GetServiceRequest {
	if m == nil {
		return nil
	}

	o := &GetServiceRequest{
		ServiceID: m.ServiceID,
	}

	return o
}

func (m *GetServiceResponse) Copy() *GetServiceResponse {
	if m == nil {
		return nil
	}

	o := &GetServiceResponse{
		Service: m.Service.Copy(),
	}

	return o
}

func (m *UpdateServiceRequest) Copy() *UpdateServiceRequest {
	if m == nil {
		return nil
	}

	o := &UpdateServiceRequest{
		ServiceID:      m.ServiceID,
		ServiceVersion: m.ServiceVersion.Copy(),
		Spec:           m.Spec.Copy(),
	}

	return o
}

func (m *UpdateServiceResponse) Copy() *UpdateServiceResponse {
	if m == nil {
		return nil
	}

	o := &UpdateServiceResponse{
		Service: m.Service.Copy(),
	}

	return o
}

func (m *RemoveServiceRequest) Copy() *RemoveServiceRequest {
	if m == nil {
		return nil
	}

	o := &RemoveServiceRequest{
		ServiceID: m.ServiceID,
	}

	return o
}

func (m *RemoveServiceResponse) Copy() *RemoveServiceResponse {
	if m == nil {
		return nil
	}

	o := &RemoveServiceResponse{}

	return o
}

func (m *ListServicesRequest) Copy() *ListServicesRequest {
	if m == nil {
		return nil
	}

	o := &ListServicesRequest{
		Options: m.Options.Copy(),
	}

	return o
}

func (m *ListServicesResponse) Copy() *ListServicesResponse {
	if m == nil {
		return nil
	}

	o := &ListServicesResponse{}

	if m.Services != nil {
		o.Services = make([]*Service, 0, len(m.Services))
		for _, v := range m.Services {
			o.Services = append(o.Services, v.Copy())
		}
	}

	return o
}

func (m *CreateNetworkRequest) Copy() *CreateNetworkRequest {
	if m == nil {
		return nil
	}

	o := &CreateNetworkRequest{
		Spec: m.Spec.Copy(),
	}

	return o
}

func (m *CreateNetworkResponse) Copy() *CreateNetworkResponse {
	if m == nil {
		return nil
	}

	o := &CreateNetworkResponse{
		Network: m.Network.Copy(),
	}

	return o
}

func (m *GetNetworkRequest) Copy() *GetNetworkRequest {
	if m == nil {
		return nil
	}

	o := &GetNetworkRequest{
		Name:      m.Name,
		NetworkID: m.NetworkID,
	}

	return o
}

func (m *GetNetworkResponse) Copy() *GetNetworkResponse {
	if m == nil {
		return nil
	}

	o := &GetNetworkResponse{
		Network: m.Network.Copy(),
	}

	return o
}

func (m *RemoveNetworkRequest) Copy() *RemoveNetworkRequest {
	if m == nil {
		return nil
	}

	o := &RemoveNetworkRequest{
		Name:      m.Name,
		NetworkID: m.NetworkID,
	}

	return o
}

func (m *RemoveNetworkResponse) Copy() *RemoveNetworkResponse {
	if m == nil {
		return nil
	}

	o := &RemoveNetworkResponse{}

	return o
}

func (m *ListNetworksRequest) Copy() *ListNetworksRequest {
	if m == nil {
		return nil
	}

	o := &ListNetworksRequest{
		Options: m.Options.Copy(),
	}

	return o
}

func (m *ListNetworksResponse) Copy() *ListNetworksResponse {
	if m == nil {
		return nil
	}

	o := &ListNetworksResponse{}

	if m.Networks != nil {
		o.Networks = make([]*Network, 0, len(m.Networks))
		for _, v := range m.Networks {
			o.Networks = append(o.Networks, v.Copy())
		}
	}

	return o
}

func (m *CreateVolumeRequest) Copy() *CreateVolumeRequest {
	if m == nil {
		return nil
	}

	o := &CreateVolumeRequest{
		Spec: m.Spec.Copy(),
	}

	return o
}

func (m *CreateVolumeResponse) Copy() *CreateVolumeResponse {
	if m == nil {
		return nil
	}

	o := &CreateVolumeResponse{
		Volume: m.Volume.Copy(),
	}

	return o
}

func (m *GetVolumeRequest) Copy() *GetVolumeRequest {
	if m == nil {
		return nil
	}

	o := &GetVolumeRequest{
		VolumeID: m.VolumeID,
	}

	return o
}

func (m *GetVolumeResponse) Copy() *GetVolumeResponse {
	if m == nil {
		return nil
	}

	o := &GetVolumeResponse{
		Volume: m.Volume.Copy(),
	}

	return o
}

func (m *RemoveVolumeRequest) Copy() *RemoveVolumeRequest {
	if m == nil {
		return nil
	}

	o := &RemoveVolumeRequest{
		VolumeID: m.VolumeID,
	}

	return o
}

func (m *RemoveVolumeResponse) Copy() *RemoveVolumeResponse {
	if m == nil {
		return nil
	}

	o := &RemoveVolumeResponse{}

	return o
}

func (m *ListVolumesRequest) Copy() *ListVolumesRequest {
	if m == nil {
		return nil
	}

	o := &ListVolumesRequest{}

	return o
}

func (m *ListVolumesResponse) Copy() *ListVolumesResponse {
	if m == nil {
		return nil
	}

	o := &ListVolumesResponse{}

	if m.Volumes != nil {
		o.Volumes = make([]*Volume, 0, len(m.Volumes))
		for _, v := range m.Volumes {
			o.Volumes = append(o.Volumes, v.Copy())
		}
	}

	return o
}

func (m *ListManagersRequest) Copy() *ListManagersRequest {
	if m == nil {
		return nil
	}

	o := &ListManagersRequest{
		Options: m.Options.Copy(),
	}

	return o
}

func (m *ListManagersResponse) Copy() *ListManagersResponse {
	if m == nil {
		return nil
	}

	o := &ListManagersResponse{}

	if m.Managers != nil {
		o.Managers = make([]*Member, 0, len(m.Managers))
		for _, v := range m.Managers {
			o.Managers = append(o.Managers, v.Copy())
		}
	}

	return o
}

func (this *ListOptions) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&api.ListOptions{")
	s = append(s, "Query: "+fmt.Sprintf("%#v", this.Query)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *GetNodeRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&api.GetNodeRequest{")
	s = append(s, "NodeID: "+fmt.Sprintf("%#v", this.NodeID)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *GetNodeResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&api.GetNodeResponse{")
	if this.Node != nil {
		s = append(s, "Node: "+fmt.Sprintf("%#v", this.Node)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ListNodesRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&api.ListNodesRequest{")
	if this.Options != nil {
		s = append(s, "Options: "+fmt.Sprintf("%#v", this.Options)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ListNodesResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&api.ListNodesResponse{")
	if this.Nodes != nil {
		s = append(s, "Nodes: "+fmt.Sprintf("%#v", this.Nodes)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *UpdateNodeRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&api.UpdateNodeRequest{")
	s = append(s, "NodeID: "+fmt.Sprintf("%#v", this.NodeID)+",\n")
	if this.NodeVersion != nil {
		s = append(s, "NodeVersion: "+fmt.Sprintf("%#v", this.NodeVersion)+",\n")
	}
	if this.Spec != nil {
		s = append(s, "Spec: "+fmt.Sprintf("%#v", this.Spec)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *UpdateNodeResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&api.UpdateNodeResponse{")
	if this.Node != nil {
		s = append(s, "Node: "+fmt.Sprintf("%#v", this.Node)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *GetTaskRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&api.GetTaskRequest{")
	s = append(s, "TaskID: "+fmt.Sprintf("%#v", this.TaskID)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *GetTaskResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&api.GetTaskResponse{")
	if this.Task != nil {
		s = append(s, "Task: "+fmt.Sprintf("%#v", this.Task)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *RemoveTaskRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&api.RemoveTaskRequest{")
	s = append(s, "TaskID: "+fmt.Sprintf("%#v", this.TaskID)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *RemoveTaskResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 4)
	s = append(s, "&api.RemoveTaskResponse{")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ListTasksRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 4)
	s = append(s, "&api.ListTasksRequest{")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ListTasksResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&api.ListTasksResponse{")
	if this.Tasks != nil {
		s = append(s, "Tasks: "+fmt.Sprintf("%#v", this.Tasks)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *CreateServiceRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&api.CreateServiceRequest{")
	if this.Spec != nil {
		s = append(s, "Spec: "+fmt.Sprintf("%#v", this.Spec)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *CreateServiceResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&api.CreateServiceResponse{")
	if this.Service != nil {
		s = append(s, "Service: "+fmt.Sprintf("%#v", this.Service)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *GetServiceRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&api.GetServiceRequest{")
	s = append(s, "ServiceID: "+fmt.Sprintf("%#v", this.ServiceID)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *GetServiceResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&api.GetServiceResponse{")
	if this.Service != nil {
		s = append(s, "Service: "+fmt.Sprintf("%#v", this.Service)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *UpdateServiceRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&api.UpdateServiceRequest{")
	s = append(s, "ServiceID: "+fmt.Sprintf("%#v", this.ServiceID)+",\n")
	if this.ServiceVersion != nil {
		s = append(s, "ServiceVersion: "+fmt.Sprintf("%#v", this.ServiceVersion)+",\n")
	}
	if this.Spec != nil {
		s = append(s, "Spec: "+fmt.Sprintf("%#v", this.Spec)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *UpdateServiceResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&api.UpdateServiceResponse{")
	if this.Service != nil {
		s = append(s, "Service: "+fmt.Sprintf("%#v", this.Service)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *RemoveServiceRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&api.RemoveServiceRequest{")
	s = append(s, "ServiceID: "+fmt.Sprintf("%#v", this.ServiceID)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *RemoveServiceResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 4)
	s = append(s, "&api.RemoveServiceResponse{")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ListServicesRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&api.ListServicesRequest{")
	if this.Options != nil {
		s = append(s, "Options: "+fmt.Sprintf("%#v", this.Options)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ListServicesResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&api.ListServicesResponse{")
	if this.Services != nil {
		s = append(s, "Services: "+fmt.Sprintf("%#v", this.Services)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *CreateNetworkRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&api.CreateNetworkRequest{")
	if this.Spec != nil {
		s = append(s, "Spec: "+fmt.Sprintf("%#v", this.Spec)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *CreateNetworkResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&api.CreateNetworkResponse{")
	if this.Network != nil {
		s = append(s, "Network: "+fmt.Sprintf("%#v", this.Network)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *GetNetworkRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&api.GetNetworkRequest{")
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	s = append(s, "NetworkID: "+fmt.Sprintf("%#v", this.NetworkID)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *GetNetworkResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&api.GetNetworkResponse{")
	if this.Network != nil {
		s = append(s, "Network: "+fmt.Sprintf("%#v", this.Network)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *RemoveNetworkRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&api.RemoveNetworkRequest{")
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	s = append(s, "NetworkID: "+fmt.Sprintf("%#v", this.NetworkID)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *RemoveNetworkResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 4)
	s = append(s, "&api.RemoveNetworkResponse{")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ListNetworksRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&api.ListNetworksRequest{")
	if this.Options != nil {
		s = append(s, "Options: "+fmt.Sprintf("%#v", this.Options)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ListNetworksResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&api.ListNetworksResponse{")
	if this.Networks != nil {
		s = append(s, "Networks: "+fmt.Sprintf("%#v", this.Networks)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *CreateVolumeRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&api.CreateVolumeRequest{")
	if this.Spec != nil {
		s = append(s, "Spec: "+fmt.Sprintf("%#v", this.Spec)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *CreateVolumeResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&api.CreateVolumeResponse{")
	if this.Volume != nil {
		s = append(s, "Volume: "+fmt.Sprintf("%#v", this.Volume)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *GetVolumeRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&api.GetVolumeRequest{")
	s = append(s, "VolumeID: "+fmt.Sprintf("%#v", this.VolumeID)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *GetVolumeResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&api.GetVolumeResponse{")
	if this.Volume != nil {
		s = append(s, "Volume: "+fmt.Sprintf("%#v", this.Volume)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *RemoveVolumeRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&api.RemoveVolumeRequest{")
	s = append(s, "VolumeID: "+fmt.Sprintf("%#v", this.VolumeID)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *RemoveVolumeResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 4)
	s = append(s, "&api.RemoveVolumeResponse{")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ListVolumesRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 4)
	s = append(s, "&api.ListVolumesRequest{")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ListVolumesResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&api.ListVolumesResponse{")
	if this.Volumes != nil {
		s = append(s, "Volumes: "+fmt.Sprintf("%#v", this.Volumes)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ListManagersRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&api.ListManagersRequest{")
	if this.Options != nil {
		s = append(s, "Options: "+fmt.Sprintf("%#v", this.Options)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ListManagersResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&api.ListManagersResponse{")
	if this.Managers != nil {
		s = append(s, "Managers: "+fmt.Sprintf("%#v", this.Managers)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringCluster(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}
func extensionToGoStringCluster(e map[int32]github_com_gogo_protobuf_proto.Extension) string {
	if e == nil {
		return "nil"
	}
	s := "map[int32]proto.Extension{"
	keys := make([]int, 0, len(e))
	for k := range e {
		keys = append(keys, int(k))
	}
	sort.Ints(keys)
	ss := []string{}
	for _, k := range keys {
		ss = append(ss, strconv.Itoa(k)+": "+e[int32(k)].GoString())
	}
	s += strings.Join(ss, ",") + "}"
	return s
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// Client API for Cluster service

type ClusterClient interface {
	GetNode(ctx context.Context, in *GetNodeRequest, opts ...grpc.CallOption) (*GetNodeResponse, error)
	ListNodes(ctx context.Context, in *ListNodesRequest, opts ...grpc.CallOption) (*ListNodesResponse, error)
	UpdateNode(ctx context.Context, in *UpdateNodeRequest, opts ...grpc.CallOption) (*UpdateNodeResponse, error)
	GetTask(ctx context.Context, in *GetTaskRequest, opts ...grpc.CallOption) (*GetTaskResponse, error)
	ListTasks(ctx context.Context, in *ListTasksRequest, opts ...grpc.CallOption) (*ListTasksResponse, error)
	RemoveTask(ctx context.Context, in *RemoveTaskRequest, opts ...grpc.CallOption) (*RemoveTaskResponse, error)
	GetService(ctx context.Context, in *GetServiceRequest, opts ...grpc.CallOption) (*GetServiceResponse, error)
	ListServices(ctx context.Context, in *ListServicesRequest, opts ...grpc.CallOption) (*ListServicesResponse, error)
	CreateService(ctx context.Context, in *CreateServiceRequest, opts ...grpc.CallOption) (*CreateServiceResponse, error)
	UpdateService(ctx context.Context, in *UpdateServiceRequest, opts ...grpc.CallOption) (*UpdateServiceResponse, error)
	RemoveService(ctx context.Context, in *RemoveServiceRequest, opts ...grpc.CallOption) (*RemoveServiceResponse, error)
	GetNetwork(ctx context.Context, in *GetNetworkRequest, opts ...grpc.CallOption) (*GetNetworkResponse, error)
	ListNetworks(ctx context.Context, in *ListNetworksRequest, opts ...grpc.CallOption) (*ListNetworksResponse, error)
	CreateNetwork(ctx context.Context, in *CreateNetworkRequest, opts ...grpc.CallOption) (*CreateNetworkResponse, error)
	RemoveNetwork(ctx context.Context, in *RemoveNetworkRequest, opts ...grpc.CallOption) (*RemoveNetworkResponse, error)
	GetVolume(ctx context.Context, in *GetVolumeRequest, opts ...grpc.CallOption) (*GetVolumeResponse, error)
	ListVolumes(ctx context.Context, in *ListVolumesRequest, opts ...grpc.CallOption) (*ListVolumesResponse, error)
	CreateVolume(ctx context.Context, in *CreateVolumeRequest, opts ...grpc.CallOption) (*CreateVolumeResponse, error)
	RemoveVolume(ctx context.Context, in *RemoveVolumeRequest, opts ...grpc.CallOption) (*RemoveVolumeResponse, error)
	ListManagers(ctx context.Context, in *ListManagersRequest, opts ...grpc.CallOption) (*ListManagersResponse, error)
}

type clusterClient struct {
	cc *grpc.ClientConn
}

func NewClusterClient(cc *grpc.ClientConn) ClusterClient {
	return &clusterClient{cc}
}

func (c *clusterClient) GetNode(ctx context.Context, in *GetNodeRequest, opts ...grpc.CallOption) (*GetNodeResponse, error) {
	out := new(GetNodeResponse)
	err := grpc.Invoke(ctx, "/docker.cluster.api.Cluster/GetNode", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterClient) ListNodes(ctx context.Context, in *ListNodesRequest, opts ...grpc.CallOption) (*ListNodesResponse, error) {
	out := new(ListNodesResponse)
	err := grpc.Invoke(ctx, "/docker.cluster.api.Cluster/ListNodes", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterClient) UpdateNode(ctx context.Context, in *UpdateNodeRequest, opts ...grpc.CallOption) (*UpdateNodeResponse, error) {
	out := new(UpdateNodeResponse)
	err := grpc.Invoke(ctx, "/docker.cluster.api.Cluster/UpdateNode", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterClient) GetTask(ctx context.Context, in *GetTaskRequest, opts ...grpc.CallOption) (*GetTaskResponse, error) {
	out := new(GetTaskResponse)
	err := grpc.Invoke(ctx, "/docker.cluster.api.Cluster/GetTask", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterClient) ListTasks(ctx context.Context, in *ListTasksRequest, opts ...grpc.CallOption) (*ListTasksResponse, error) {
	out := new(ListTasksResponse)
	err := grpc.Invoke(ctx, "/docker.cluster.api.Cluster/ListTasks", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterClient) RemoveTask(ctx context.Context, in *RemoveTaskRequest, opts ...grpc.CallOption) (*RemoveTaskResponse, error) {
	out := new(RemoveTaskResponse)
	err := grpc.Invoke(ctx, "/docker.cluster.api.Cluster/RemoveTask", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterClient) GetService(ctx context.Context, in *GetServiceRequest, opts ...grpc.CallOption) (*GetServiceResponse, error) {
	out := new(GetServiceResponse)
	err := grpc.Invoke(ctx, "/docker.cluster.api.Cluster/GetService", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterClient) ListServices(ctx context.Context, in *ListServicesRequest, opts ...grpc.CallOption) (*ListServicesResponse, error) {
	out := new(ListServicesResponse)
	err := grpc.Invoke(ctx, "/docker.cluster.api.Cluster/ListServices", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterClient) CreateService(ctx context.Context, in *CreateServiceRequest, opts ...grpc.CallOption) (*CreateServiceResponse, error) {
	out := new(CreateServiceResponse)
	err := grpc.Invoke(ctx, "/docker.cluster.api.Cluster/CreateService", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterClient) UpdateService(ctx context.Context, in *UpdateServiceRequest, opts ...grpc.CallOption) (*UpdateServiceResponse, error) {
	out := new(UpdateServiceResponse)
	err := grpc.Invoke(ctx, "/docker.cluster.api.Cluster/UpdateService", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterClient) RemoveService(ctx context.Context, in *RemoveServiceRequest, opts ...grpc.CallOption) (*RemoveServiceResponse, error) {
	out := new(RemoveServiceResponse)
	err := grpc.Invoke(ctx, "/docker.cluster.api.Cluster/RemoveService", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterClient) GetNetwork(ctx context.Context, in *GetNetworkRequest, opts ...grpc.CallOption) (*GetNetworkResponse, error) {
	out := new(GetNetworkResponse)
	err := grpc.Invoke(ctx, "/docker.cluster.api.Cluster/GetNetwork", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterClient) ListNetworks(ctx context.Context, in *ListNetworksRequest, opts ...grpc.CallOption) (*ListNetworksResponse, error) {
	out := new(ListNetworksResponse)
	err := grpc.Invoke(ctx, "/docker.cluster.api.Cluster/ListNetworks", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterClient) CreateNetwork(ctx context.Context, in *CreateNetworkRequest, opts ...grpc.CallOption) (*CreateNetworkResponse, error) {
	out := new(CreateNetworkResponse)
	err := grpc.Invoke(ctx, "/docker.cluster.api.Cluster/CreateNetwork", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterClient) RemoveNetwork(ctx context.Context, in *RemoveNetworkRequest, opts ...grpc.CallOption) (*RemoveNetworkResponse, error) {
	out := new(RemoveNetworkResponse)
	err := grpc.Invoke(ctx, "/docker.cluster.api.Cluster/RemoveNetwork", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterClient) GetVolume(ctx context.Context, in *GetVolumeRequest, opts ...grpc.CallOption) (*GetVolumeResponse, error) {
	out := new(GetVolumeResponse)
	err := grpc.Invoke(ctx, "/docker.cluster.api.Cluster/GetVolume", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterClient) ListVolumes(ctx context.Context, in *ListVolumesRequest, opts ...grpc.CallOption) (*ListVolumesResponse, error) {
	out := new(ListVolumesResponse)
	err := grpc.Invoke(ctx, "/docker.cluster.api.Cluster/ListVolumes", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterClient) CreateVolume(ctx context.Context, in *CreateVolumeRequest, opts ...grpc.CallOption) (*CreateVolumeResponse, error) {
	out := new(CreateVolumeResponse)
	err := grpc.Invoke(ctx, "/docker.cluster.api.Cluster/CreateVolume", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterClient) RemoveVolume(ctx context.Context, in *RemoveVolumeRequest, opts ...grpc.CallOption) (*RemoveVolumeResponse, error) {
	out := new(RemoveVolumeResponse)
	err := grpc.Invoke(ctx, "/docker.cluster.api.Cluster/RemoveVolume", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterClient) ListManagers(ctx context.Context, in *ListManagersRequest, opts ...grpc.CallOption) (*ListManagersResponse, error) {
	out := new(ListManagersResponse)
	err := grpc.Invoke(ctx, "/docker.cluster.api.Cluster/ListManagers", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for Cluster service

type ClusterServer interface {
	GetNode(context.Context, *GetNodeRequest) (*GetNodeResponse, error)
	ListNodes(context.Context, *ListNodesRequest) (*ListNodesResponse, error)
	UpdateNode(context.Context, *UpdateNodeRequest) (*UpdateNodeResponse, error)
	GetTask(context.Context, *GetTaskRequest) (*GetTaskResponse, error)
	ListTasks(context.Context, *ListTasksRequest) (*ListTasksResponse, error)
	RemoveTask(context.Context, *RemoveTaskRequest) (*RemoveTaskResponse, error)
	GetService(context.Context, *GetServiceRequest) (*GetServiceResponse, error)
	ListServices(context.Context, *ListServicesRequest) (*ListServicesResponse, error)
	CreateService(context.Context, *CreateServiceRequest) (*CreateServiceResponse, error)
	UpdateService(context.Context, *UpdateServiceRequest) (*UpdateServiceResponse, error)
	RemoveService(context.Context, *RemoveServiceRequest) (*RemoveServiceResponse, error)
	GetNetwork(context.Context, *GetNetworkRequest) (*GetNetworkResponse, error)
	ListNetworks(context.Context, *ListNetworksRequest) (*ListNetworksResponse, error)
	CreateNetwork(context.Context, *CreateNetworkRequest) (*CreateNetworkResponse, error)
	RemoveNetwork(context.Context, *RemoveNetworkRequest) (*RemoveNetworkResponse, error)
	GetVolume(context.Context, *GetVolumeRequest) (*GetVolumeResponse, error)
	ListVolumes(context.Context, *ListVolumesRequest) (*ListVolumesResponse, error)
	CreateVolume(context.Context, *CreateVolumeRequest) (*CreateVolumeResponse, error)
	RemoveVolume(context.Context, *RemoveVolumeRequest) (*RemoveVolumeResponse, error)
	ListManagers(context.Context, *ListManagersRequest) (*ListManagersResponse, error)
}

func RegisterClusterServer(s *grpc.Server, srv ClusterServer) {
	s.RegisterService(&_Cluster_serviceDesc, srv)
}

func _Cluster_GetNode_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error) (interface{}, error) {
	in := new(GetNodeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	out, err := srv.(ClusterServer).GetNode(ctx, in)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func _Cluster_ListNodes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error) (interface{}, error) {
	in := new(ListNodesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	out, err := srv.(ClusterServer).ListNodes(ctx, in)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func _Cluster_UpdateNode_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error) (interface{}, error) {
	in := new(UpdateNodeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	out, err := srv.(ClusterServer).UpdateNode(ctx, in)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func _Cluster_GetTask_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error) (interface{}, error) {
	in := new(GetTaskRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	out, err := srv.(ClusterServer).GetTask(ctx, in)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func _Cluster_ListTasks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error) (interface{}, error) {
	in := new(ListTasksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	out, err := srv.(ClusterServer).ListTasks(ctx, in)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func _Cluster_RemoveTask_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error) (interface{}, error) {
	in := new(RemoveTaskRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	out, err := srv.(ClusterServer).RemoveTask(ctx, in)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func _Cluster_GetService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error) (interface{}, error) {
	in := new(GetServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	out, err := srv.(ClusterServer).GetService(ctx, in)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func _Cluster_ListServices_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error) (interface{}, error) {
	in := new(ListServicesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	out, err := srv.(ClusterServer).ListServices(ctx, in)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func _Cluster_CreateService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error) (interface{}, error) {
	in := new(CreateServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	out, err := srv.(ClusterServer).CreateService(ctx, in)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func _Cluster_UpdateService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error) (interface{}, error) {
	in := new(UpdateServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	out, err := srv.(ClusterServer).UpdateService(ctx, in)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func _Cluster_RemoveService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error) (interface{}, error) {
	in := new(RemoveServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	out, err := srv.(ClusterServer).RemoveService(ctx, in)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func _Cluster_GetNetwork_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error) (interface{}, error) {
	in := new(GetNetworkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	out, err := srv.(ClusterServer).GetNetwork(ctx, in)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func _Cluster_ListNetworks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error) (interface{}, error) {
	in := new(ListNetworksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	out, err := srv.(ClusterServer).ListNetworks(ctx, in)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func _Cluster_CreateNetwork_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error) (interface{}, error) {
	in := new(CreateNetworkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	out, err := srv.(ClusterServer).CreateNetwork(ctx, in)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func _Cluster_RemoveNetwork_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error) (interface{}, error) {
	in := new(RemoveNetworkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	out, err := srv.(ClusterServer).RemoveNetwork(ctx, in)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func _Cluster_GetVolume_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error) (interface{}, error) {
	in := new(GetVolumeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	out, err := srv.(ClusterServer).GetVolume(ctx, in)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func _Cluster_ListVolumes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error) (interface{}, error) {
	in := new(ListVolumesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	out, err := srv.(ClusterServer).ListVolumes(ctx, in)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func _Cluster_CreateVolume_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error) (interface{}, error) {
	in := new(CreateVolumeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	out, err := srv.(ClusterServer).CreateVolume(ctx, in)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func _Cluster_RemoveVolume_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error) (interface{}, error) {
	in := new(RemoveVolumeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	out, err := srv.(ClusterServer).RemoveVolume(ctx, in)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func _Cluster_ListManagers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error) (interface{}, error) {
	in := new(ListManagersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	out, err := srv.(ClusterServer).ListManagers(ctx, in)
	if err != nil {
		return nil, err
	}
	return out, nil
}

var _Cluster_serviceDesc = grpc.ServiceDesc{
	ServiceName: "docker.cluster.api.Cluster",
	HandlerType: (*ClusterServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetNode",
			Handler:    _Cluster_GetNode_Handler,
		},
		{
			MethodName: "ListNodes",
			Handler:    _Cluster_ListNodes_Handler,
		},
		{
			MethodName: "UpdateNode",
			Handler:    _Cluster_UpdateNode_Handler,
		},
		{
			MethodName: "GetTask",
			Handler:    _Cluster_GetTask_Handler,
		},
		{
			MethodName: "ListTasks",
			Handler:    _Cluster_ListTasks_Handler,
		},
		{
			MethodName: "RemoveTask",
			Handler:    _Cluster_RemoveTask_Handler,
		},
		{
			MethodName: "GetService",
			Handler:    _Cluster_GetService_Handler,
		},
		{
			MethodName: "ListServices",
			Handler:    _Cluster_ListServices_Handler,
		},
		{
			MethodName: "CreateService",
			Handler:    _Cluster_CreateService_Handler,
		},
		{
			MethodName: "UpdateService",
			Handler:    _Cluster_UpdateService_Handler,
		},
		{
			MethodName: "RemoveService",
			Handler:    _Cluster_RemoveService_Handler,
		},
		{
			MethodName: "GetNetwork",
			Handler:    _Cluster_GetNetwork_Handler,
		},
		{
			MethodName: "ListNetworks",
			Handler:    _Cluster_ListNetworks_Handler,
		},
		{
			MethodName: "CreateNetwork",
			Handler:    _Cluster_CreateNetwork_Handler,
		},
		{
			MethodName: "RemoveNetwork",
			Handler:    _Cluster_RemoveNetwork_Handler,
		},
		{
			MethodName: "GetVolume",
			Handler:    _Cluster_GetVolume_Handler,
		},
		{
			MethodName: "ListVolumes",
			Handler:    _Cluster_ListVolumes_Handler,
		},
		{
			MethodName: "CreateVolume",
			Handler:    _Cluster_CreateVolume_Handler,
		},
		{
			MethodName: "RemoveVolume",
			Handler:    _Cluster_RemoveVolume_Handler,
		},
		{
			MethodName: "ListManagers",
			Handler:    _Cluster_ListManagers_Handler,
		},
	},
	Streams: []grpc.StreamDesc{},
}

func (m *ListOptions) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *ListOptions) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Query) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintCluster(data, i, uint64(len(m.Query)))
		i += copy(data[i:], m.Query)
	}
	return i, nil
}

func (m *GetNodeRequest) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *GetNodeRequest) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.NodeID) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintCluster(data, i, uint64(len(m.NodeID)))
		i += copy(data[i:], m.NodeID)
	}
	return i, nil
}

func (m *GetNodeResponse) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *GetNodeResponse) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Node != nil {
		data[i] = 0xa
		i++
		i = encodeVarintCluster(data, i, uint64(m.Node.Size()))
		n1, err := m.Node.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	return i, nil
}

func (m *ListNodesRequest) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *ListNodesRequest) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Options != nil {
		data[i] = 0xa
		i++
		i = encodeVarintCluster(data, i, uint64(m.Options.Size()))
		n2, err := m.Options.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	return i, nil
}

func (m *ListNodesResponse) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *ListNodesResponse) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Nodes) > 0 {
		for _, msg := range m.Nodes {
			data[i] = 0xa
			i++
			i = encodeVarintCluster(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *UpdateNodeRequest) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *UpdateNodeRequest) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.NodeID) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintCluster(data, i, uint64(len(m.NodeID)))
		i += copy(data[i:], m.NodeID)
	}
	if m.NodeVersion != nil {
		data[i] = 0x12
		i++
		i = encodeVarintCluster(data, i, uint64(m.NodeVersion.Size()))
		n3, err := m.NodeVersion.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	if m.Spec != nil {
		data[i] = 0x1a
		i++
		i = encodeVarintCluster(data, i, uint64(m.Spec.Size()))
		n4, err := m.Spec.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	return i, nil
}

func (m *UpdateNodeResponse) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *UpdateNodeResponse) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Node != nil {
		data[i] = 0xa
		i++
		i = encodeVarintCluster(data, i, uint64(m.Node.Size()))
		n5, err := m.Node.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	return i, nil
}

func (m *GetTaskRequest) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *GetTaskRequest) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.TaskID) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintCluster(data, i, uint64(len(m.TaskID)))
		i += copy(data[i:], m.TaskID)
	}
	return i, nil
}

func (m *GetTaskResponse) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *GetTaskResponse) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Task != nil {
		data[i] = 0xa
		i++
		i = encodeVarintCluster(data, i, uint64(m.Task.Size()))
		n6, err := m.Task.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	return i, nil
}

func (m *RemoveTaskRequest) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *RemoveTaskRequest) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.TaskID) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintCluster(data, i, uint64(len(m.TaskID)))
		i += copy(data[i:], m.TaskID)
	}
	return i, nil
}

func (m *RemoveTaskResponse) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *RemoveTaskResponse) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *ListTasksRequest) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *ListTasksRequest) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *ListTasksResponse) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *ListTasksResponse) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Tasks) > 0 {
		for _, msg := range m.Tasks {
			data[i] = 0xa
			i++
			i = encodeVarintCluster(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *CreateServiceRequest) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *CreateServiceRequest) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Spec != nil {
		data[i] = 0xa
		i++
		i = encodeVarintCluster(data, i, uint64(m.Spec.Size()))
		n7, err := m.Spec.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	return i, nil
}

func (m *CreateServiceResponse) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *CreateServiceResponse) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Service != nil {
		data[i] = 0xa
		i++
		i = encodeVarintCluster(data, i, uint64(m.Service.Size()))
		n8, err := m.Service.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n8
	}
	return i, nil
}

func (m *GetServiceRequest) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *GetServiceRequest) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.ServiceID) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintCluster(data, i, uint64(len(m.ServiceID)))
		i += copy(data[i:], m.ServiceID)
	}
	return i, nil
}

func (m *GetServiceResponse) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *GetServiceResponse) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Service != nil {
		data[i] = 0xa
		i++
		i = encodeVarintCluster(data, i, uint64(m.Service.Size()))
		n9, err := m.Service.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n9
	}
	return i, nil
}

func (m *UpdateServiceRequest) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *UpdateServiceRequest) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.ServiceID) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintCluster(data, i, uint64(len(m.ServiceID)))
		i += copy(data[i:], m.ServiceID)
	}
	if m.ServiceVersion != nil {
		data[i] = 0x12
		i++
		i = encodeVarintCluster(data, i, uint64(m.ServiceVersion.Size()))
		n10, err := m.ServiceVersion.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n10
	}
	if m.Spec != nil {
		data[i] = 0x1a
		i++
		i = encodeVarintCluster(data, i, uint64(m.Spec.Size()))
		n11, err := m.Spec.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n11
	}
	return i, nil
}

func (m *UpdateServiceResponse) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *UpdateServiceResponse) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Service != nil {
		data[i] = 0xa
		i++
		i = encodeVarintCluster(data, i, uint64(m.Service.Size()))
		n12, err := m.Service.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n12
	}
	return i, nil
}

func (m *RemoveServiceRequest) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *RemoveServiceRequest) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.ServiceID) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintCluster(data, i, uint64(len(m.ServiceID)))
		i += copy(data[i:], m.ServiceID)
	}
	return i, nil
}

func (m *RemoveServiceResponse) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *RemoveServiceResponse) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *ListServicesRequest) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *ListServicesRequest) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Options != nil {
		data[i] = 0xa
		i++
		i = encodeVarintCluster(data, i, uint64(m.Options.Size()))
		n13, err := m.Options.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n13
	}
	return i, nil
}

func (m *ListServicesResponse) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *ListServicesResponse) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Services) > 0 {
		for _, msg := range m.Services {
			data[i] = 0xa
			i++
			i = encodeVarintCluster(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *CreateNetworkRequest) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *CreateNetworkRequest) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Spec != nil {
		data[i] = 0xa
		i++
		i = encodeVarintCluster(data, i, uint64(m.Spec.Size()))
		n14, err := m.Spec.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n14
	}
	return i, nil
}

func (m *CreateNetworkResponse) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *CreateNetworkResponse) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Network != nil {
		data[i] = 0xa
		i++
		i = encodeVarintCluster(data, i, uint64(m.Network.Size()))
		n15, err := m.Network.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n15
	}
	return i, nil
}

func (m *GetNetworkRequest) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *GetNetworkRequest) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintCluster(data, i, uint64(len(m.Name)))
		i += copy(data[i:], m.Name)
	}
	if len(m.NetworkID) > 0 {
		data[i] = 0x12
		i++
		i = encodeVarintCluster(data, i, uint64(len(m.NetworkID)))
		i += copy(data[i:], m.NetworkID)
	}
	return i, nil
}

func (m *GetNetworkResponse) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *GetNetworkResponse) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Network != nil {
		data[i] = 0xa
		i++
		i = encodeVarintCluster(data, i, uint64(m.Network.Size()))
		n16, err := m.Network.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n16
	}
	return i, nil
}

func (m *RemoveNetworkRequest) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *RemoveNetworkRequest) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintCluster(data, i, uint64(len(m.Name)))
		i += copy(data[i:], m.Name)
	}
	if len(m.NetworkID) > 0 {
		data[i] = 0x12
		i++
		i = encodeVarintCluster(data, i, uint64(len(m.NetworkID)))
		i += copy(data[i:], m.NetworkID)
	}
	return i, nil
}

func (m *RemoveNetworkResponse) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *RemoveNetworkResponse) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *ListNetworksRequest) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *ListNetworksRequest) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Options != nil {
		data[i] = 0xa
		i++
		i = encodeVarintCluster(data, i, uint64(m.Options.Size()))
		n17, err := m.Options.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n17
	}
	return i, nil
}

func (m *ListNetworksResponse) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *ListNetworksResponse) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Networks) > 0 {
		for _, msg := range m.Networks {
			data[i] = 0xa
			i++
			i = encodeVarintCluster(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *CreateVolumeRequest) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *CreateVolumeRequest) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Spec != nil {
		data[i] = 0xa
		i++
		i = encodeVarintCluster(data, i, uint64(m.Spec.Size()))
		n18, err := m.Spec.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n18
	}
	return i, nil
}

func (m *CreateVolumeResponse) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *CreateVolumeResponse) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Volume != nil {
		data[i] = 0xa
		i++
		i = encodeVarintCluster(data, i, uint64(m.Volume.Size()))
		n19, err := m.Volume.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n19
	}
	return i, nil
}

func (m *GetVolumeRequest) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *GetVolumeRequest) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.VolumeID) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintCluster(data, i, uint64(len(m.VolumeID)))
		i += copy(data[i:], m.VolumeID)
	}
	return i, nil
}

func (m *GetVolumeResponse) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *GetVolumeResponse) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Volume != nil {
		data[i] = 0xa
		i++
		i = encodeVarintCluster(data, i, uint64(m.Volume.Size()))
		n20, err := m.Volume.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n20
	}
	return i, nil
}

func (m *RemoveVolumeRequest) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *RemoveVolumeRequest) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.VolumeID) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintCluster(data, i, uint64(len(m.VolumeID)))
		i += copy(data[i:], m.VolumeID)
	}
	return i, nil
}

func (m *RemoveVolumeResponse) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *RemoveVolumeResponse) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *ListVolumesRequest) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *ListVolumesRequest) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *ListVolumesResponse) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *ListVolumesResponse) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Volumes) > 0 {
		for _, msg := range m.Volumes {
			data[i] = 0xa
			i++
			i = encodeVarintCluster(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *ListManagersRequest) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *ListManagersRequest) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Options != nil {
		data[i] = 0xa
		i++
		i = encodeVarintCluster(data, i, uint64(m.Options.Size()))
		n21, err := m.Options.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n21
	}
	return i, nil
}

func (m *ListManagersResponse) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *ListManagersResponse) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Managers) > 0 {
		for _, msg := range m.Managers {
			data[i] = 0xa
			i++
			i = encodeVarintCluster(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func encodeFixed64Cluster(data []byte, offset int, v uint64) int {
	data[offset] = uint8(v)
	data[offset+1] = uint8(v >> 8)
	data[offset+2] = uint8(v >> 16)
	data[offset+3] = uint8(v >> 24)
	data[offset+4] = uint8(v >> 32)
	data[offset+5] = uint8(v >> 40)
	data[offset+6] = uint8(v >> 48)
	data[offset+7] = uint8(v >> 56)
	return offset + 8
}
func encodeFixed32Cluster(data []byte, offset int, v uint32) int {
	data[offset] = uint8(v)
	data[offset+1] = uint8(v >> 8)
	data[offset+2] = uint8(v >> 16)
	data[offset+3] = uint8(v >> 24)
	return offset + 4
}
func encodeVarintCluster(data []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		data[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	data[offset] = uint8(v)
	return offset + 1
}

type raftProxyClusterServer struct {
	local        ClusterServer
	connSelector *raftpicker.ConnSelector
	cluster      raftpicker.RaftCluster
}

func NewRaftProxyClusterServer(local ClusterServer, connSelector *raftpicker.ConnSelector, cluster raftpicker.RaftCluster) ClusterServer {
	return &raftProxyClusterServer{
		local:        local,
		cluster:      cluster,
		connSelector: connSelector,
	}
}

func (p *raftProxyClusterServer) GetNode(ctx context.Context, r *GetNodeRequest) (*GetNodeResponse, error) {

	if p.cluster.IsLeader() {
		return p.local.GetNode(ctx, r)
	}
	var addr string
	s, ok := transport.StreamFromContext(ctx)
	if ok {
		addr = s.ServerTransport().RemoteAddr().String()
	}
	md, ok := metadata.FromContext(ctx)
	if ok && len(md["redirect"]) != 0 {
		return nil, grpc.Errorf(codes.ResourceExhausted, "more than one redirect to leader from: %s", md["redirect"])
	}
	if !ok {
		md = metadata.New(map[string]string{})
	}
	md["redirect"] = append(md["redirect"], addr)
	ctx = metadata.NewContext(ctx, md)

	conn, err := p.connSelector.Conn()
	if err != nil {
		return nil, err
	}
	return NewClusterClient(conn).GetNode(ctx, r)
}

func (p *raftProxyClusterServer) ListNodes(ctx context.Context, r *ListNodesRequest) (*ListNodesResponse, error) {

	if p.cluster.IsLeader() {
		return p.local.ListNodes(ctx, r)
	}
	var addr string
	s, ok := transport.StreamFromContext(ctx)
	if ok {
		addr = s.ServerTransport().RemoteAddr().String()
	}
	md, ok := metadata.FromContext(ctx)
	if ok && len(md["redirect"]) != 0 {
		return nil, grpc.Errorf(codes.ResourceExhausted, "more than one redirect to leader from: %s", md["redirect"])
	}
	if !ok {
		md = metadata.New(map[string]string{})
	}
	md["redirect"] = append(md["redirect"], addr)
	ctx = metadata.NewContext(ctx, md)

	conn, err := p.connSelector.Conn()
	if err != nil {
		return nil, err
	}
	return NewClusterClient(conn).ListNodes(ctx, r)
}

func (p *raftProxyClusterServer) UpdateNode(ctx context.Context, r *UpdateNodeRequest) (*UpdateNodeResponse, error) {

	if p.cluster.IsLeader() {
		return p.local.UpdateNode(ctx, r)
	}
	var addr string
	s, ok := transport.StreamFromContext(ctx)
	if ok {
		addr = s.ServerTransport().RemoteAddr().String()
	}
	md, ok := metadata.FromContext(ctx)
	if ok && len(md["redirect"]) != 0 {
		return nil, grpc.Errorf(codes.ResourceExhausted, "more than one redirect to leader from: %s", md["redirect"])
	}
	if !ok {
		md = metadata.New(map[string]string{})
	}
	md["redirect"] = append(md["redirect"], addr)
	ctx = metadata.NewContext(ctx, md)

	conn, err := p.connSelector.Conn()
	if err != nil {
		return nil, err
	}
	return NewClusterClient(conn).UpdateNode(ctx, r)
}

func (p *raftProxyClusterServer) GetTask(ctx context.Context, r *GetTaskRequest) (*GetTaskResponse, error) {

	if p.cluster.IsLeader() {
		return p.local.GetTask(ctx, r)
	}
	var addr string
	s, ok := transport.StreamFromContext(ctx)
	if ok {
		addr = s.ServerTransport().RemoteAddr().String()
	}
	md, ok := metadata.FromContext(ctx)
	if ok && len(md["redirect"]) != 0 {
		return nil, grpc.Errorf(codes.ResourceExhausted, "more than one redirect to leader from: %s", md["redirect"])
	}
	if !ok {
		md = metadata.New(map[string]string{})
	}
	md["redirect"] = append(md["redirect"], addr)
	ctx = metadata.NewContext(ctx, md)

	conn, err := p.connSelector.Conn()
	if err != nil {
		return nil, err
	}
	return NewClusterClient(conn).GetTask(ctx, r)
}

func (p *raftProxyClusterServer) ListTasks(ctx context.Context, r *ListTasksRequest) (*ListTasksResponse, error) {

	if p.cluster.IsLeader() {
		return p.local.ListTasks(ctx, r)
	}
	var addr string
	s, ok := transport.StreamFromContext(ctx)
	if ok {
		addr = s.ServerTransport().RemoteAddr().String()
	}
	md, ok := metadata.FromContext(ctx)
	if ok && len(md["redirect"]) != 0 {
		return nil, grpc.Errorf(codes.ResourceExhausted, "more than one redirect to leader from: %s", md["redirect"])
	}
	if !ok {
		md = metadata.New(map[string]string{})
	}
	md["redirect"] = append(md["redirect"], addr)
	ctx = metadata.NewContext(ctx, md)

	conn, err := p.connSelector.Conn()
	if err != nil {
		return nil, err
	}
	return NewClusterClient(conn).ListTasks(ctx, r)
}

func (p *raftProxyClusterServer) RemoveTask(ctx context.Context, r *RemoveTaskRequest) (*RemoveTaskResponse, error) {

	if p.cluster.IsLeader() {
		return p.local.RemoveTask(ctx, r)
	}
	var addr string
	s, ok := transport.StreamFromContext(ctx)
	if ok {
		addr = s.ServerTransport().RemoteAddr().String()
	}
	md, ok := metadata.FromContext(ctx)
	if ok && len(md["redirect"]) != 0 {
		return nil, grpc.Errorf(codes.ResourceExhausted, "more than one redirect to leader from: %s", md["redirect"])
	}
	if !ok {
		md = metadata.New(map[string]string{})
	}
	md["redirect"] = append(md["redirect"], addr)
	ctx = metadata.NewContext(ctx, md)

	conn, err := p.connSelector.Conn()
	if err != nil {
		return nil, err
	}
	return NewClusterClient(conn).RemoveTask(ctx, r)
}

func (p *raftProxyClusterServer) GetService(ctx context.Context, r *GetServiceRequest) (*GetServiceResponse, error) {

	if p.cluster.IsLeader() {
		return p.local.GetService(ctx, r)
	}
	var addr string
	s, ok := transport.StreamFromContext(ctx)
	if ok {
		addr = s.ServerTransport().RemoteAddr().String()
	}
	md, ok := metadata.FromContext(ctx)
	if ok && len(md["redirect"]) != 0 {
		return nil, grpc.Errorf(codes.ResourceExhausted, "more than one redirect to leader from: %s", md["redirect"])
	}
	if !ok {
		md = metadata.New(map[string]string{})
	}
	md["redirect"] = append(md["redirect"], addr)
	ctx = metadata.NewContext(ctx, md)

	conn, err := p.connSelector.Conn()
	if err != nil {
		return nil, err
	}
	return NewClusterClient(conn).GetService(ctx, r)
}

func (p *raftProxyClusterServer) ListServices(ctx context.Context, r *ListServicesRequest) (*ListServicesResponse, error) {

	if p.cluster.IsLeader() {
		return p.local.ListServices(ctx, r)
	}
	var addr string
	s, ok := transport.StreamFromContext(ctx)
	if ok {
		addr = s.ServerTransport().RemoteAddr().String()
	}
	md, ok := metadata.FromContext(ctx)
	if ok && len(md["redirect"]) != 0 {
		return nil, grpc.Errorf(codes.ResourceExhausted, "more than one redirect to leader from: %s", md["redirect"])
	}
	if !ok {
		md = metadata.New(map[string]string{})
	}
	md["redirect"] = append(md["redirect"], addr)
	ctx = metadata.NewContext(ctx, md)

	conn, err := p.connSelector.Conn()
	if err != nil {
		return nil, err
	}
	return NewClusterClient(conn).ListServices(ctx, r)
}

func (p *raftProxyClusterServer) CreateService(ctx context.Context, r *CreateServiceRequest) (*CreateServiceResponse, error) {

	if p.cluster.IsLeader() {
		return p.local.CreateService(ctx, r)
	}
	var addr string
	s, ok := transport.StreamFromContext(ctx)
	if ok {
		addr = s.ServerTransport().RemoteAddr().String()
	}
	md, ok := metadata.FromContext(ctx)
	if ok && len(md["redirect"]) != 0 {
		return nil, grpc.Errorf(codes.ResourceExhausted, "more than one redirect to leader from: %s", md["redirect"])
	}
	if !ok {
		md = metadata.New(map[string]string{})
	}
	md["redirect"] = append(md["redirect"], addr)
	ctx = metadata.NewContext(ctx, md)

	conn, err := p.connSelector.Conn()
	if err != nil {
		return nil, err
	}
	return NewClusterClient(conn).CreateService(ctx, r)
}

func (p *raftProxyClusterServer) UpdateService(ctx context.Context, r *UpdateServiceRequest) (*UpdateServiceResponse, error) {

	if p.cluster.IsLeader() {
		return p.local.UpdateService(ctx, r)
	}
	var addr string
	s, ok := transport.StreamFromContext(ctx)
	if ok {
		addr = s.ServerTransport().RemoteAddr().String()
	}
	md, ok := metadata.FromContext(ctx)
	if ok && len(md["redirect"]) != 0 {
		return nil, grpc.Errorf(codes.ResourceExhausted, "more than one redirect to leader from: %s", md["redirect"])
	}
	if !ok {
		md = metadata.New(map[string]string{})
	}
	md["redirect"] = append(md["redirect"], addr)
	ctx = metadata.NewContext(ctx, md)

	conn, err := p.connSelector.Conn()
	if err != nil {
		return nil, err
	}
	return NewClusterClient(conn).UpdateService(ctx, r)
}

func (p *raftProxyClusterServer) RemoveService(ctx context.Context, r *RemoveServiceRequest) (*RemoveServiceResponse, error) {

	if p.cluster.IsLeader() {
		return p.local.RemoveService(ctx, r)
	}
	var addr string
	s, ok := transport.StreamFromContext(ctx)
	if ok {
		addr = s.ServerTransport().RemoteAddr().String()
	}
	md, ok := metadata.FromContext(ctx)
	if ok && len(md["redirect"]) != 0 {
		return nil, grpc.Errorf(codes.ResourceExhausted, "more than one redirect to leader from: %s", md["redirect"])
	}
	if !ok {
		md = metadata.New(map[string]string{})
	}
	md["redirect"] = append(md["redirect"], addr)
	ctx = metadata.NewContext(ctx, md)

	conn, err := p.connSelector.Conn()
	if err != nil {
		return nil, err
	}
	return NewClusterClient(conn).RemoveService(ctx, r)
}

func (p *raftProxyClusterServer) GetNetwork(ctx context.Context, r *GetNetworkRequest) (*GetNetworkResponse, error) {

	if p.cluster.IsLeader() {
		return p.local.GetNetwork(ctx, r)
	}
	var addr string
	s, ok := transport.StreamFromContext(ctx)
	if ok {
		addr = s.ServerTransport().RemoteAddr().String()
	}
	md, ok := metadata.FromContext(ctx)
	if ok && len(md["redirect"]) != 0 {
		return nil, grpc.Errorf(codes.ResourceExhausted, "more than one redirect to leader from: %s", md["redirect"])
	}
	if !ok {
		md = metadata.New(map[string]string{})
	}
	md["redirect"] = append(md["redirect"], addr)
	ctx = metadata.NewContext(ctx, md)

	conn, err := p.connSelector.Conn()
	if err != nil {
		return nil, err
	}
	return NewClusterClient(conn).GetNetwork(ctx, r)
}

func (p *raftProxyClusterServer) ListNetworks(ctx context.Context, r *ListNetworksRequest) (*ListNetworksResponse, error) {

	if p.cluster.IsLeader() {
		return p.local.ListNetworks(ctx, r)
	}
	var addr string
	s, ok := transport.StreamFromContext(ctx)
	if ok {
		addr = s.ServerTransport().RemoteAddr().String()
	}
	md, ok := metadata.FromContext(ctx)
	if ok && len(md["redirect"]) != 0 {
		return nil, grpc.Errorf(codes.ResourceExhausted, "more than one redirect to leader from: %s", md["redirect"])
	}
	if !ok {
		md = metadata.New(map[string]string{})
	}
	md["redirect"] = append(md["redirect"], addr)
	ctx = metadata.NewContext(ctx, md)

	conn, err := p.connSelector.Conn()
	if err != nil {
		return nil, err
	}
	return NewClusterClient(conn).ListNetworks(ctx, r)
}

func (p *raftProxyClusterServer) CreateNetwork(ctx context.Context, r *CreateNetworkRequest) (*CreateNetworkResponse, error) {

	if p.cluster.IsLeader() {
		return p.local.CreateNetwork(ctx, r)
	}
	var addr string
	s, ok := transport.StreamFromContext(ctx)
	if ok {
		addr = s.ServerTransport().RemoteAddr().String()
	}
	md, ok := metadata.FromContext(ctx)
	if ok && len(md["redirect"]) != 0 {
		return nil, grpc.Errorf(codes.ResourceExhausted, "more than one redirect to leader from: %s", md["redirect"])
	}
	if !ok {
		md = metadata.New(map[string]string{})
	}
	md["redirect"] = append(md["redirect"], addr)
	ctx = metadata.NewContext(ctx, md)

	conn, err := p.connSelector.Conn()
	if err != nil {
		return nil, err
	}
	return NewClusterClient(conn).CreateNetwork(ctx, r)
}

func (p *raftProxyClusterServer) RemoveNetwork(ctx context.Context, r *RemoveNetworkRequest) (*RemoveNetworkResponse, error) {

	if p.cluster.IsLeader() {
		return p.local.RemoveNetwork(ctx, r)
	}
	var addr string
	s, ok := transport.StreamFromContext(ctx)
	if ok {
		addr = s.ServerTransport().RemoteAddr().String()
	}
	md, ok := metadata.FromContext(ctx)
	if ok && len(md["redirect"]) != 0 {
		return nil, grpc.Errorf(codes.ResourceExhausted, "more than one redirect to leader from: %s", md["redirect"])
	}
	if !ok {
		md = metadata.New(map[string]string{})
	}
	md["redirect"] = append(md["redirect"], addr)
	ctx = metadata.NewContext(ctx, md)

	conn, err := p.connSelector.Conn()
	if err != nil {
		return nil, err
	}
	return NewClusterClient(conn).RemoveNetwork(ctx, r)
}

func (p *raftProxyClusterServer) GetVolume(ctx context.Context, r *GetVolumeRequest) (*GetVolumeResponse, error) {

	if p.cluster.IsLeader() {
		return p.local.GetVolume(ctx, r)
	}
	var addr string
	s, ok := transport.StreamFromContext(ctx)
	if ok {
		addr = s.ServerTransport().RemoteAddr().String()
	}
	md, ok := metadata.FromContext(ctx)
	if ok && len(md["redirect"]) != 0 {
		return nil, grpc.Errorf(codes.ResourceExhausted, "more than one redirect to leader from: %s", md["redirect"])
	}
	if !ok {
		md = metadata.New(map[string]string{})
	}
	md["redirect"] = append(md["redirect"], addr)
	ctx = metadata.NewContext(ctx, md)

	conn, err := p.connSelector.Conn()
	if err != nil {
		return nil, err
	}
	return NewClusterClient(conn).GetVolume(ctx, r)
}

func (p *raftProxyClusterServer) ListVolumes(ctx context.Context, r *ListVolumesRequest) (*ListVolumesResponse, error) {

	if p.cluster.IsLeader() {
		return p.local.ListVolumes(ctx, r)
	}
	var addr string
	s, ok := transport.StreamFromContext(ctx)
	if ok {
		addr = s.ServerTransport().RemoteAddr().String()
	}
	md, ok := metadata.FromContext(ctx)
	if ok && len(md["redirect"]) != 0 {
		return nil, grpc.Errorf(codes.ResourceExhausted, "more than one redirect to leader from: %s", md["redirect"])
	}
	if !ok {
		md = metadata.New(map[string]string{})
	}
	md["redirect"] = append(md["redirect"], addr)
	ctx = metadata.NewContext(ctx, md)

	conn, err := p.connSelector.Conn()
	if err != nil {
		return nil, err
	}
	return NewClusterClient(conn).ListVolumes(ctx, r)
}

func (p *raftProxyClusterServer) CreateVolume(ctx context.Context, r *CreateVolumeRequest) (*CreateVolumeResponse, error) {

	if p.cluster.IsLeader() {
		return p.local.CreateVolume(ctx, r)
	}
	var addr string
	s, ok := transport.StreamFromContext(ctx)
	if ok {
		addr = s.ServerTransport().RemoteAddr().String()
	}
	md, ok := metadata.FromContext(ctx)
	if ok && len(md["redirect"]) != 0 {
		return nil, grpc.Errorf(codes.ResourceExhausted, "more than one redirect to leader from: %s", md["redirect"])
	}
	if !ok {
		md = metadata.New(map[string]string{})
	}
	md["redirect"] = append(md["redirect"], addr)
	ctx = metadata.NewContext(ctx, md)

	conn, err := p.connSelector.Conn()
	if err != nil {
		return nil, err
	}
	return NewClusterClient(conn).CreateVolume(ctx, r)
}

func (p *raftProxyClusterServer) RemoveVolume(ctx context.Context, r *RemoveVolumeRequest) (*RemoveVolumeResponse, error) {

	if p.cluster.IsLeader() {
		return p.local.RemoveVolume(ctx, r)
	}
	var addr string
	s, ok := transport.StreamFromContext(ctx)
	if ok {
		addr = s.ServerTransport().RemoteAddr().String()
	}
	md, ok := metadata.FromContext(ctx)
	if ok && len(md["redirect"]) != 0 {
		return nil, grpc.Errorf(codes.ResourceExhausted, "more than one redirect to leader from: %s", md["redirect"])
	}
	if !ok {
		md = metadata.New(map[string]string{})
	}
	md["redirect"] = append(md["redirect"], addr)
	ctx = metadata.NewContext(ctx, md)

	conn, err := p.connSelector.Conn()
	if err != nil {
		return nil, err
	}
	return NewClusterClient(conn).RemoveVolume(ctx, r)
}

func (p *raftProxyClusterServer) ListManagers(ctx context.Context, r *ListManagersRequest) (*ListManagersResponse, error) {

	if p.cluster.IsLeader() {
		return p.local.ListManagers(ctx, r)
	}
	var addr string
	s, ok := transport.StreamFromContext(ctx)
	if ok {
		addr = s.ServerTransport().RemoteAddr().String()
	}
	md, ok := metadata.FromContext(ctx)
	if ok && len(md["redirect"]) != 0 {
		return nil, grpc.Errorf(codes.ResourceExhausted, "more than one redirect to leader from: %s", md["redirect"])
	}
	if !ok {
		md = metadata.New(map[string]string{})
	}
	md["redirect"] = append(md["redirect"], addr)
	ctx = metadata.NewContext(ctx, md)

	conn, err := p.connSelector.Conn()
	if err != nil {
		return nil, err
	}
	return NewClusterClient(conn).ListManagers(ctx, r)
}

func (m *ListOptions) Size() (n int) {
	var l int
	_ = l
	l = len(m.Query)
	if l > 0 {
		n += 1 + l + sovCluster(uint64(l))
	}
	return n
}

func (m *GetNodeRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.NodeID)
	if l > 0 {
		n += 1 + l + sovCluster(uint64(l))
	}
	return n
}

func (m *GetNodeResponse) Size() (n int) {
	var l int
	_ = l
	if m.Node != nil {
		l = m.Node.Size()
		n += 1 + l + sovCluster(uint64(l))
	}
	return n
}

func (m *ListNodesRequest) Size() (n int) {
	var l int
	_ = l
	if m.Options != nil {
		l = m.Options.Size()
		n += 1 + l + sovCluster(uint64(l))
	}
	return n
}

func (m *ListNodesResponse) Size() (n int) {
	var l int
	_ = l
	if len(m.Nodes) > 0 {
		for _, e := range m.Nodes {
			l = e.Size()
			n += 1 + l + sovCluster(uint64(l))
		}
	}
	return n
}

func (m *UpdateNodeRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.NodeID)
	if l > 0 {
		n += 1 + l + sovCluster(uint64(l))
	}
	if m.NodeVersion != nil {
		l = m.NodeVersion.Size()
		n += 1 + l + sovCluster(uint64(l))
	}
	if m.Spec != nil {
		l = m.Spec.Size()
		n += 1 + l + sovCluster(uint64(l))
	}
	return n
}

func (m *UpdateNodeResponse) Size() (n int) {
	var l int
	_ = l
	if m.Node != nil {
		l = m.Node.Size()
		n += 1 + l + sovCluster(uint64(l))
	}
	return n
}

func (m *GetTaskRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.TaskID)
	if l > 0 {
		n += 1 + l + sovCluster(uint64(l))
	}
	return n
}

func (m *GetTaskResponse) Size() (n int) {
	var l int
	_ = l
	if m.Task != nil {
		l = m.Task.Size()
		n += 1 + l + sovCluster(uint64(l))
	}
	return n
}

func (m *RemoveTaskRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.TaskID)
	if l > 0 {
		n += 1 + l + sovCluster(uint64(l))
	}
	return n
}

func (m *RemoveTaskResponse) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *ListTasksRequest) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *ListTasksResponse) Size() (n int) {
	var l int
	_ = l
	if len(m.Tasks) > 0 {
		for _, e := range m.Tasks {
			l = e.Size()
			n += 1 + l + sovCluster(uint64(l))
		}
	}
	return n
}

func (m *CreateServiceRequest) Size() (n int) {
	var l int
	_ = l
	if m.Spec != nil {
		l = m.Spec.Size()
		n += 1 + l + sovCluster(uint64(l))
	}
	return n
}

func (m *CreateServiceResponse) Size() (n int) {
	var l int
	_ = l
	if m.Service != nil {
		l = m.Service.Size()
		n += 1 + l + sovCluster(uint64(l))
	}
	return n
}

func (m *GetServiceRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.ServiceID)
	if l > 0 {
		n += 1 + l + sovCluster(uint64(l))
	}
	return n
}

func (m *GetServiceResponse) Size() (n int) {
	var l int
	_ = l
	if m.Service != nil {
		l = m.Service.Size()
		n += 1 + l + sovCluster(uint64(l))
	}
	return n
}

func (m *UpdateServiceRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.ServiceID)
	if l > 0 {
		n += 1 + l + sovCluster(uint64(l))
	}
	if m.ServiceVersion != nil {
		l = m.ServiceVersion.Size()
		n += 1 + l + sovCluster(uint64(l))
	}
	if m.Spec != nil {
		l = m.Spec.Size()
		n += 1 + l + sovCluster(uint64(l))
	}
	return n
}

func (m *UpdateServiceResponse) Size() (n int) {
	var l int
	_ = l
	if m.Service != nil {
		l = m.Service.Size()
		n += 1 + l + sovCluster(uint64(l))
	}
	return n
}

func (m *RemoveServiceRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.ServiceID)
	if l > 0 {
		n += 1 + l + sovCluster(uint64(l))
	}
	return n
}

func (m *RemoveServiceResponse) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *ListServicesRequest) Size() (n int) {
	var l int
	_ = l
	if m.Options != nil {
		l = m.Options.Size()
		n += 1 + l + sovCluster(uint64(l))
	}
	return n
}

func (m *ListServicesResponse) Size() (n int) {
	var l int
	_ = l
	if len(m.Services) > 0 {
		for _, e := range m.Services {
			l = e.Size()
			n += 1 + l + sovCluster(uint64(l))
		}
	}
	return n
}

func (m *CreateNetworkRequest) Size() (n int) {
	var l int
	_ = l
	if m.Spec != nil {
		l = m.Spec.Size()
		n += 1 + l + sovCluster(uint64(l))
	}
	return n
}

func (m *CreateNetworkResponse) Size() (n int) {
	var l int
	_ = l
	if m.Network != nil {
		l = m.Network.Size()
		n += 1 + l + sovCluster(uint64(l))
	}
	return n
}

func (m *GetNetworkRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovCluster(uint64(l))
	}
	l = len(m.NetworkID)
	if l > 0 {
		n += 1 + l + sovCluster(uint64(l))
	}
	return n
}

func (m *GetNetworkResponse) Size() (n int) {
	var l int
	_ = l
	if m.Network != nil {
		l = m.Network.Size()
		n += 1 + l + sovCluster(uint64(l))
	}
	return n
}

func (m *RemoveNetworkRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovCluster(uint64(l))
	}
	l = len(m.NetworkID)
	if l > 0 {
		n += 1 + l + sovCluster(uint64(l))
	}
	return n
}

func (m *RemoveNetworkResponse) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *ListNetworksRequest) Size() (n int) {
	var l int
	_ = l
	if m.Options != nil {
		l = m.Options.Size()
		n += 1 + l + sovCluster(uint64(l))
	}
	return n
}

func (m *ListNetworksResponse) Size() (n int) {
	var l int
	_ = l
	if len(m.Networks) > 0 {
		for _, e := range m.Networks {
			l = e.Size()
			n += 1 + l + sovCluster(uint64(l))
		}
	}
	return n
}

func (m *CreateVolumeRequest) Size() (n int) {
	var l int
	_ = l
	if m.Spec != nil {
		l = m.Spec.Size()
		n += 1 + l + sovCluster(uint64(l))
	}
	return n
}

func (m *CreateVolumeResponse) Size() (n int) {
	var l int
	_ = l
	if m.Volume != nil {
		l = m.Volume.Size()
		n += 1 + l + sovCluster(uint64(l))
	}
	return n
}

func (m *GetVolumeRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.VolumeID)
	if l > 0 {
		n += 1 + l + sovCluster(uint64(l))
	}
	return n
}

func (m *GetVolumeResponse) Size() (n int) {
	var l int
	_ = l
	if m.Volume != nil {
		l = m.Volume.Size()
		n += 1 + l + sovCluster(uint64(l))
	}
	return n
}

func (m *RemoveVolumeRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.VolumeID)
	if l > 0 {
		n += 1 + l + sovCluster(uint64(l))
	}
	return n
}

func (m *RemoveVolumeResponse) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *ListVolumesRequest) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *ListVolumesResponse) Size() (n int) {
	var l int
	_ = l
	if len(m.Volumes) > 0 {
		for _, e := range m.Volumes {
			l = e.Size()
			n += 1 + l + sovCluster(uint64(l))
		}
	}
	return n
}

func (m *ListManagersRequest) Size() (n int) {
	var l int
	_ = l
	if m.Options != nil {
		l = m.Options.Size()
		n += 1 + l + sovCluster(uint64(l))
	}
	return n
}

func (m *ListManagersResponse) Size() (n int) {
	var l int
	_ = l
	if len(m.Managers) > 0 {
		for _, e := range m.Managers {
			l = e.Size()
			n += 1 + l + sovCluster(uint64(l))
		}
	}
	return n
}

func sovCluster(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozCluster(x uint64) (n int) {
	return sovCluster(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *ListOptions) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ListOptions{`,
		`Query:` + fmt.Sprintf("%v", this.Query) + `,`,
		`}`,
	}, "")
	return s
}
func (this *GetNodeRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&GetNodeRequest{`,
		`NodeID:` + fmt.Sprintf("%v", this.NodeID) + `,`,
		`}`,
	}, "")
	return s
}
func (this *GetNodeResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&GetNodeResponse{`,
		`Node:` + strings.Replace(fmt.Sprintf("%v", this.Node), "Node", "Node", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ListNodesRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ListNodesRequest{`,
		`Options:` + strings.Replace(fmt.Sprintf("%v", this.Options), "ListOptions", "ListOptions", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ListNodesResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ListNodesResponse{`,
		`Nodes:` + strings.Replace(fmt.Sprintf("%v", this.Nodes), "Node", "Node", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *UpdateNodeRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&UpdateNodeRequest{`,
		`NodeID:` + fmt.Sprintf("%v", this.NodeID) + `,`,
		`NodeVersion:` + strings.Replace(fmt.Sprintf("%v", this.NodeVersion), "Version", "Version", 1) + `,`,
		`Spec:` + strings.Replace(fmt.Sprintf("%v", this.Spec), "NodeSpec", "NodeSpec", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *UpdateNodeResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&UpdateNodeResponse{`,
		`Node:` + strings.Replace(fmt.Sprintf("%v", this.Node), "Node", "Node", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *GetTaskRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&GetTaskRequest{`,
		`TaskID:` + fmt.Sprintf("%v", this.TaskID) + `,`,
		`}`,
	}, "")
	return s
}
func (this *GetTaskResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&GetTaskResponse{`,
		`Task:` + strings.Replace(fmt.Sprintf("%v", this.Task), "Task", "Task", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *RemoveTaskRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RemoveTaskRequest{`,
		`TaskID:` + fmt.Sprintf("%v", this.TaskID) + `,`,
		`}`,
	}, "")
	return s
}
func (this *RemoveTaskResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RemoveTaskResponse{`,
		`}`,
	}, "")
	return s
}
func (this *ListTasksRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ListTasksRequest{`,
		`}`,
	}, "")
	return s
}
func (this *ListTasksResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ListTasksResponse{`,
		`Tasks:` + strings.Replace(fmt.Sprintf("%v", this.Tasks), "Task", "Task", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *CreateServiceRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&CreateServiceRequest{`,
		`Spec:` + strings.Replace(fmt.Sprintf("%v", this.Spec), "ServiceSpec", "ServiceSpec", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *CreateServiceResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&CreateServiceResponse{`,
		`Service:` + strings.Replace(fmt.Sprintf("%v", this.Service), "Service", "Service", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *GetServiceRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&GetServiceRequest{`,
		`ServiceID:` + fmt.Sprintf("%v", this.ServiceID) + `,`,
		`}`,
	}, "")
	return s
}
func (this *GetServiceResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&GetServiceResponse{`,
		`Service:` + strings.Replace(fmt.Sprintf("%v", this.Service), "Service", "Service", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *UpdateServiceRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&UpdateServiceRequest{`,
		`ServiceID:` + fmt.Sprintf("%v", this.ServiceID) + `,`,
		`ServiceVersion:` + strings.Replace(fmt.Sprintf("%v", this.ServiceVersion), "Version", "Version", 1) + `,`,
		`Spec:` + strings.Replace(fmt.Sprintf("%v", this.Spec), "ServiceSpec", "ServiceSpec", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *UpdateServiceResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&UpdateServiceResponse{`,
		`Service:` + strings.Replace(fmt.Sprintf("%v", this.Service), "Service", "Service", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *RemoveServiceRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RemoveServiceRequest{`,
		`ServiceID:` + fmt.Sprintf("%v", this.ServiceID) + `,`,
		`}`,
	}, "")
	return s
}
func (this *RemoveServiceResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RemoveServiceResponse{`,
		`}`,
	}, "")
	return s
}
func (this *ListServicesRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ListServicesRequest{`,
		`Options:` + strings.Replace(fmt.Sprintf("%v", this.Options), "ListOptions", "ListOptions", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ListServicesResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ListServicesResponse{`,
		`Services:` + strings.Replace(fmt.Sprintf("%v", this.Services), "Service", "Service", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *CreateNetworkRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&CreateNetworkRequest{`,
		`Spec:` + strings.Replace(fmt.Sprintf("%v", this.Spec), "NetworkSpec", "NetworkSpec", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *CreateNetworkResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&CreateNetworkResponse{`,
		`Network:` + strings.Replace(fmt.Sprintf("%v", this.Network), "Network", "Network", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *GetNetworkRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&GetNetworkRequest{`,
		`Name:` + fmt.Sprintf("%v", this.Name) + `,`,
		`NetworkID:` + fmt.Sprintf("%v", this.NetworkID) + `,`,
		`}`,
	}, "")
	return s
}
func (this *GetNetworkResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&GetNetworkResponse{`,
		`Network:` + strings.Replace(fmt.Sprintf("%v", this.Network), "Network", "Network", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *RemoveNetworkRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RemoveNetworkRequest{`,
		`Name:` + fmt.Sprintf("%v", this.Name) + `,`,
		`NetworkID:` + fmt.Sprintf("%v", this.NetworkID) + `,`,
		`}`,
	}, "")
	return s
}
func (this *RemoveNetworkResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RemoveNetworkResponse{`,
		`}`,
	}, "")
	return s
}
func (this *ListNetworksRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ListNetworksRequest{`,
		`Options:` + strings.Replace(fmt.Sprintf("%v", this.Options), "ListOptions", "ListOptions", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ListNetworksResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ListNetworksResponse{`,
		`Networks:` + strings.Replace(fmt.Sprintf("%v", this.Networks), "Network", "Network", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *CreateVolumeRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&CreateVolumeRequest{`,
		`Spec:` + strings.Replace(fmt.Sprintf("%v", this.Spec), "VolumeSpec", "VolumeSpec", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *CreateVolumeResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&CreateVolumeResponse{`,
		`Volume:` + strings.Replace(fmt.Sprintf("%v", this.Volume), "Volume", "Volume", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *GetVolumeRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&GetVolumeRequest{`,
		`VolumeID:` + fmt.Sprintf("%v", this.VolumeID) + `,`,
		`}`,
	}, "")
	return s
}
func (this *GetVolumeResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&GetVolumeResponse{`,
		`Volume:` + strings.Replace(fmt.Sprintf("%v", this.Volume), "Volume", "Volume", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *RemoveVolumeRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RemoveVolumeRequest{`,
		`VolumeID:` + fmt.Sprintf("%v", this.VolumeID) + `,`,
		`}`,
	}, "")
	return s
}
func (this *RemoveVolumeResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RemoveVolumeResponse{`,
		`}`,
	}, "")
	return s
}
func (this *ListVolumesRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ListVolumesRequest{`,
		`}`,
	}, "")
	return s
}
func (this *ListVolumesResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ListVolumesResponse{`,
		`Volumes:` + strings.Replace(fmt.Sprintf("%v", this.Volumes), "Volume", "Volume", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ListManagersRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ListManagersRequest{`,
		`Options:` + strings.Replace(fmt.Sprintf("%v", this.Options), "ListOptions", "ListOptions", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ListManagersResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ListManagersResponse{`,
		`Managers:` + strings.Replace(fmt.Sprintf("%v", this.Managers), "Member", "Member", 1) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringCluster(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *ListOptions) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCluster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListOptions: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListOptions: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Query", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCluster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCluster
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Query = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCluster(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCluster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetNodeRequest) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCluster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetNodeRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetNodeRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCluster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCluster
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NodeID = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCluster(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCluster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetNodeResponse) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCluster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetNodeResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetNodeResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Node", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCluster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCluster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Node == nil {
				m.Node = &Node{}
			}
			if err := m.Node.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCluster(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCluster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListNodesRequest) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCluster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListNodesRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListNodesRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Options", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCluster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCluster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Options == nil {
				m.Options = &ListOptions{}
			}
			if err := m.Options.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCluster(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCluster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListNodesResponse) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCluster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListNodesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListNodesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Nodes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCluster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCluster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Nodes = append(m.Nodes, &Node{})
			if err := m.Nodes[len(m.Nodes)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCluster(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCluster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UpdateNodeRequest) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCluster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UpdateNodeRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UpdateNodeRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCluster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCluster
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NodeID = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeVersion", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCluster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCluster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.NodeVersion == nil {
				m.NodeVersion = &Version{}
			}
			if err := m.NodeVersion.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Spec", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCluster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCluster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Spec == nil {
				m.Spec = &NodeSpec{}
			}
			if err := m.Spec.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCluster(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCluster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UpdateNodeResponse) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCluster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UpdateNodeResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UpdateNodeResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Node", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCluster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCluster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Node == nil {
				m.Node = &Node{}
			}
			if err := m.Node.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCluster(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCluster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetTaskRequest) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCluster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetTaskRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetTaskRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCluster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCluster
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TaskID = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCluster(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCluster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetTaskResponse) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCluster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetTaskResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetTaskResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Task", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCluster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCluster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Task == nil {
				m.Task = &Task{}
			}
			if err := m.Task.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCluster(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCluster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RemoveTaskRequest) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCluster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RemoveTaskRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RemoveTaskRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCluster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCluster
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TaskID = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCluster(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCluster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RemoveTaskResponse) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCluster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RemoveTaskResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RemoveTaskResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipCluster(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCluster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListTasksRequest) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCluster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListTasksRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListTasksRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipCluster(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCluster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListTasksResponse) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCluster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListTasksResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListTasksResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tasks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCluster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCluster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Tasks = append(m.Tasks, &Task{})
			if err := m.Tasks[len(m.Tasks)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCluster(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCluster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CreateServiceRequest) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCluster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CreateServiceRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CreateServiceRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Spec", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCluster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCluster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Spec == nil {
				m.Spec = &ServiceSpec{}
			}
			if err := m.Spec.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCluster(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCluster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CreateServiceResponse) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCluster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CreateServiceResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CreateServiceResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Service", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCluster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCluster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Service == nil {
				m.Service = &Service{}
			}
			if err := m.Service.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCluster(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCluster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetServiceRequest) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCluster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetServiceRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetServiceRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ServiceID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCluster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCluster
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ServiceID = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCluster(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCluster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetServiceResponse) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCluster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetServiceResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetServiceResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Service", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCluster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCluster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Service == nil {
				m.Service = &Service{}
			}
			if err := m.Service.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCluster(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCluster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UpdateServiceRequest) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCluster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UpdateServiceRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UpdateServiceRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ServiceID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCluster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCluster
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ServiceID = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ServiceVersion", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCluster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCluster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ServiceVersion == nil {
				m.ServiceVersion = &Version{}
			}
			if err := m.ServiceVersion.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Spec", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCluster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCluster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Spec == nil {
				m.Spec = &ServiceSpec{}
			}
			if err := m.Spec.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCluster(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCluster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UpdateServiceResponse) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCluster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UpdateServiceResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UpdateServiceResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Service", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCluster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCluster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Service == nil {
				m.Service = &Service{}
			}
			if err := m.Service.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCluster(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCluster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RemoveServiceRequest) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCluster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RemoveServiceRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RemoveServiceRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ServiceID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCluster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCluster
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ServiceID = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCluster(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCluster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RemoveServiceResponse) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCluster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RemoveServiceResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RemoveServiceResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipCluster(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCluster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListServicesRequest) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCluster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListServicesRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListServicesRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Options", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCluster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCluster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Options == nil {
				m.Options = &ListOptions{}
			}
			if err := m.Options.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCluster(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCluster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListServicesResponse) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCluster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListServicesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListServicesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Services", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCluster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCluster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Services = append(m.Services, &Service{})
			if err := m.Services[len(m.Services)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCluster(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCluster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CreateNetworkRequest) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCluster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CreateNetworkRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CreateNetworkRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Spec", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCluster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCluster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Spec == nil {
				m.Spec = &NetworkSpec{}
			}
			if err := m.Spec.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCluster(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCluster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CreateNetworkResponse) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCluster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CreateNetworkResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CreateNetworkResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Network", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCluster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCluster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Network == nil {
				m.Network = &Network{}
			}
			if err := m.Network.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCluster(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCluster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetNetworkRequest) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCluster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetNetworkRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetNetworkRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCluster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCluster
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NetworkID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCluster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCluster
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NetworkID = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCluster(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCluster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetNetworkResponse) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCluster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetNetworkResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetNetworkResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Network", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCluster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCluster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Network == nil {
				m.Network = &Network{}
			}
			if err := m.Network.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCluster(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCluster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RemoveNetworkRequest) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCluster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RemoveNetworkRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RemoveNetworkRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCluster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCluster
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NetworkID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCluster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCluster
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NetworkID = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCluster(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCluster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RemoveNetworkResponse) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCluster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RemoveNetworkResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RemoveNetworkResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipCluster(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCluster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListNetworksRequest) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCluster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListNetworksRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListNetworksRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Options", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCluster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCluster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Options == nil {
				m.Options = &ListOptions{}
			}
			if err := m.Options.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCluster(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCluster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListNetworksResponse) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCluster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListNetworksResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListNetworksResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Networks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCluster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCluster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Networks = append(m.Networks, &Network{})
			if err := m.Networks[len(m.Networks)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCluster(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCluster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CreateVolumeRequest) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCluster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CreateVolumeRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CreateVolumeRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Spec", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCluster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCluster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Spec == nil {
				m.Spec = &VolumeSpec{}
			}
			if err := m.Spec.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCluster(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCluster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CreateVolumeResponse) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCluster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CreateVolumeResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CreateVolumeResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Volume", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCluster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCluster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Volume == nil {
				m.Volume = &Volume{}
			}
			if err := m.Volume.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCluster(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCluster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetVolumeRequest) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCluster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetVolumeRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetVolumeRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VolumeID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCluster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCluster
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.VolumeID = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCluster(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCluster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetVolumeResponse) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCluster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetVolumeResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetVolumeResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Volume", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCluster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCluster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Volume == nil {
				m.Volume = &Volume{}
			}
			if err := m.Volume.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCluster(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCluster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RemoveVolumeRequest) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCluster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RemoveVolumeRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RemoveVolumeRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VolumeID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCluster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCluster
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.VolumeID = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCluster(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCluster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RemoveVolumeResponse) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCluster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RemoveVolumeResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RemoveVolumeResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipCluster(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCluster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListVolumesRequest) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCluster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListVolumesRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListVolumesRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipCluster(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCluster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListVolumesResponse) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCluster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListVolumesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListVolumesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Volumes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCluster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCluster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Volumes = append(m.Volumes, &Volume{})
			if err := m.Volumes[len(m.Volumes)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCluster(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCluster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListManagersRequest) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCluster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListManagersRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListManagersRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Options", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCluster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCluster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Options == nil {
				m.Options = &ListOptions{}
			}
			if err := m.Options.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCluster(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCluster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListManagersResponse) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCluster
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListManagersResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListManagersResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Managers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCluster
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCluster
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Managers = append(m.Managers, &Member{})
			if err := m.Managers[len(m.Managers)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCluster(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCluster
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipCluster(data []byte) (n int, err error) {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowCluster
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowCluster
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if data[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowCluster
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthCluster
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowCluster
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := data[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipCluster(data[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthCluster = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowCluster   = fmt.Errorf("proto: integer overflow")
)

var fileDescriptorCluster = []byte{
	// 1131 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0xac, 0x58, 0x5b, 0x6f, 0x1b, 0x45,
	0x14, 0x8e, 0x7b, 0x89, 0xe3, 0xe3, 0xa4, 0x69, 0x26, 0x2e, 0x44, 0xdb, 0x2a, 0x45, 0x13, 0xda,
	0x26, 0x52, 0x15, 0x50, 0x42, 0xb9, 0x3c, 0x70, 0x4b, 0x22, 0x55, 0x21, 0xc4, 0x45, 0xdb, 0x8b,
	0x10, 0x12, 0x02, 0xc7, 0x1e, 0x22, 0x93, 0xda, 0x6b, 0x76, 0x37, 0x46, 0x7d, 0xe3, 0xe7, 0x20,
	0xfe, 0x04, 0xaf, 0x7d, 0xe4, 0x91, 0x27, 0x44, 0xfb, 0x0b, 0xf8, 0x09, 0xcc, 0xe5, 0xcc, 0xec,
	0xec, 0x78, 0x76, 0x1d, 0xd7, 0x7e, 0x58, 0xc9, 0x3b, 0xf3, 0x9d, 0xcb, 0x9c, 0xef, 0xcc, 0x9e,
	0x4f, 0x86, 0xa5, 0xf6, 0xf3, 0xf3, 0x24, 0x65, 0xf1, 0xf6, 0x20, 0x8e, 0xd2, 0x88, 0x90, 0x4e,
	0xd4, 0x3e, 0xe3, 0x6f, 0x7a, 0xb5, 0x35, 0xe8, 0x06, 0xf5, 0x64, 0xc0, 0xda, 0x89, 0x02, 0x04,
	0x4b, 0xd1, 0xc9, 0xcf, 0xac, 0x9d, 0xea, 0xd7, 0x7a, 0xfa, 0x62, 0xc0, 0xf4, 0x4b, 0xe3, 0x34,
	0x3a, 0x8d, 0xe4, 0xcf, 0xf7, 0xc4, 0x2f, 0xb5, 0x4a, 0x37, 0xa0, 0xfe, 0x75, 0x37, 0x49, 0x1f,
	0x0d, 0xd2, 0x6e, 0xd4, 0x4f, 0x48, 0x03, 0xae, 0xfe, 0x72, 0xce, 0xe2, 0x17, 0x6b, 0x95, 0x77,
	0x2a, 0x9b, 0xb5, 0x50, 0xbd, 0xd0, 0x07, 0x70, 0xed, 0x21, 0x4b, 0x9b, 0x51, 0x87, 0x85, 0x8c,
	0xaf, 0x24, 0x29, 0xd9, 0x80, 0x6a, 0x9f, 0xbf, 0xfe, 0xd0, 0xed, 0x28, 0xe4, 0x1e, 0xbc, 0xfe,
	0xe7, 0xf6, 0xbc, 0x40, 0x1c, 0x1e, 0x84, 0xf3, 0x62, 0xeb, 0xb0, 0x43, 0x3f, 0x87, 0x65, 0x63,
	0x96, 0x0c, 0xb8, 0x7b, 0x46, 0xee, 0xc3, 0x15, 0xb1, 0x29, 0x8d, 0xea, 0x3b, 0x6b, 0xdb, 0xa3,
	0x07, 0xda, 0x96, 0x78, 0x89, 0xa2, 0xc7, 0x70, 0x5d, 0x24, 0x27, 0x56, 0x12, 0x1d, 0xf9, 0x13,
	0xa8, 0x46, 0x2a, 0x59, 0x74, 0x72, 0xdb, 0xe7, 0xc4, 0x3a, 0x53, 0xa8, 0xf1, 0x74, 0x1f, 0x56,
	0x2c, 0x77, 0x98, 0xd1, 0x36, 0x5c, 0x15, 0xb1, 0x84, 0xb7, 0xcb, 0xa5, 0x29, 0x29, 0x18, 0xfd,
	0xa3, 0x02, 0x2b, 0x4f, 0x07, 0x9d, 0x56, 0xca, 0x26, 0xad, 0x07, 0xf9, 0x0c, 0x16, 0x25, 0x68,
	0xc8, 0xe2, 0x84, 0x27, 0xb4, 0x76, 0x49, 0xe6, 0x7f, 0xd3, 0x17, 0xf1, 0x99, 0x82, 0x84, 0x75,
	0x61, 0x80, 0x2f, 0xe4, 0x7d, 0xb8, 0x22, 0xc8, 0x5e, 0xbb, 0x2c, 0xed, 0x6e, 0x15, 0x65, 0xfa,
	0x98, 0x63, 0x42, 0x89, 0xa4, 0x7b, 0x40, 0xec, 0x5c, 0xdf, 0x88, 0x04, 0x45, 0xfe, 0x93, 0x56,
	0x72, 0x66, 0x1d, 0x36, 0xe5, 0xaf, 0xce, 0x61, 0x05, 0x42, 0x1c, 0x56, 0x6c, 0x19, 0xf2, 0x95,
	0x59, 0x16, 0x57, 0x6c, 0x96, 0xc5, 0x95, 0x78, 0x89, 0xa2, 0x1f, 0xc3, 0x4a, 0xc8, 0x7a, 0xd1,
	0x90, 0x4d, 0x1c, 0xba, 0x01, 0xc4, 0xb6, 0x54, 0xd1, 0x29, 0x51, 0xcd, 0x24, 0xd6, 0x74, 0x33,
	0xe9, 0x8e, 0xc0, 0xb5, 0xac, 0x23, 0x84, 0xa3, 0xd2, 0x8e, 0x90, 0x9e, 0x15, 0x8c, 0x1e, 0x41,
	0x63, 0x3f, 0x66, 0xbc, 0xc8, 0x8f, 0x59, 0x3c, 0xec, 0xb6, 0x4d, 0x4f, 0xec, 0x22, 0x5d, 0x25,
	0x6d, 0x8a, 0x16, 0x16, 0x63, 0x4d, 0xb8, 0xe1, 0x38, 0xc3, 0xac, 0x1e, 0x40, 0x35, 0x51, 0x4b,
	0xe8, 0xf0, 0x66, 0x89, 0xc3, 0x50, 0x63, 0xe9, 0x97, 0xb0, 0xc2, 0x69, 0x70, 0x32, 0xbb, 0x0f,
	0x80, 0xfb, 0x59, 0x21, 0x97, 0x78, 0x21, 0x6b, 0x88, 0xe3, 0xb5, 0xac, 0x21, 0x80, 0x97, 0xf3,
	0x08, 0x88, 0xed, 0x62, 0xba, 0x7c, 0xfe, 0xac, 0x40, 0x43, 0xb5, 0xe4, 0x34, 0x39, 0x91, 0x03,
	0x58, 0xd6, 0xe8, 0x09, 0x6e, 0xd3, 0x35, 0xb4, 0xd1, 0x17, 0x6a, 0x37, 0x77, 0xa1, 0x2e, 0xce,
	0x90, 0x73, 0x80, 0xe9, 0x2a, 0x72, 0x00, 0x0d, 0xd5, 0xad, 0x53, 0x91, 0xf4, 0x36, 0xdc, 0x70,
	0xbc, 0x60, 0xdb, 0x7f, 0x03, 0xab, 0xa2, 0xc5, 0x71, 0x79, 0x16, 0x9f, 0xd1, 0x47, 0xd0, 0xc8,
	0x7b, 0xc4, 0xf3, 0x7f, 0x04, 0x0b, 0x98, 0x8f, 0xbe, 0x3a, 0xa5, 0x05, 0x30, 0xe0, 0xec, 0x02,
	0x35, 0x59, 0xfa, 0x6b, 0x14, 0x9f, 0x4d, 0x70, 0x81, 0xd0, 0xc2, 0x77, 0x81, 0x8c, 0xb3, 0x8c,
	0x9e, 0xbe, 0x5a, 0x2a, 0xa3, 0x47, 0x5b, 0x69, 0x2c, 0x7d, 0x2a, 0x2f, 0x90, 0x93, 0x19, 0xe1,
	0x5f, 0xd0, 0x56, 0x8f, 0xe1, 0x94, 0x94, 0xbf, 0x05, 0x5f, 0x68, 0x23, 0xf8, 0xba, 0x94, 0xf1,
	0x85, 0xb6, 0x82, 0x2f, 0x04, 0x98, 0x4b, 0x35, 0xa3, 0x1c, 0xbf, 0xd5, 0x2d, 0x34, 0xf3, 0x34,
	0x4d, 0x5b, 0x39, 0x99, 0xea, 0xb6, 0xc2, 0xe5, 0x19, 0xb6, 0x55, 0xe6, 0x31, 0x6b, 0x2b, 0xcc,
	0xa7, 0xb4, 0xad, 0x74, 0x82, 0x06, 0x4c, 0x0f, 0x61, 0x55, 0x75, 0xc2, 0xb3, 0xe8, 0xf9, 0x79,
	0xcf, 0xdc, 0xab, 0x9d, 0x5c, 0x57, 0xad, 0x7b, 0xbf, 0x17, 0xd2, 0xc0, 0x6a, 0xaa, 0xaf, 0x74,
	0x87, 0x6a, 0x57, 0x98, 0xdb, 0x0e, 0xcc, 0x0f, 0xe5, 0x0a, 0x7a, 0x0b, 0x8a, 0xbd, 0x85, 0x88,
	0xa4, 0x9f, 0xc2, 0x75, 0xce, 0x7c, 0x3e, 0xa7, 0x2d, 0xa8, 0xa9, 0xdd, 0xec, 0xaa, 0x2f, 0x72,
	0x4e, 0x16, 0x14, 0x8a, 0x53, 0xb2, 0xa0, 0xb6, 0x39, 0x23, 0x0f, 0x65, 0x3f, 0xce, 0x20, 0x8f,
	0x2f, 0x60, 0x55, 0x51, 0xfb, 0xc6, 0xa9, 0xbc, 0xa5, 0xdb, 0x2e, 0x9f, 0x8d, 0x98, 0xbf, 0x82,
	0x49, 0xb5, 0x6a, 0x66, 0xed, 0x91, 0xea, 0x18, 0xb3, 0x8a, 0xa9, 0x7f, 0x00, 0x55, 0xe5, 0x50,
	0xb3, 0x5b, 0x96, 0xbb, 0x86, 0xea, 0xf6, 0x3b, 0x6e, 0xf5, 0x5b, 0xa7, 0xfc, 0x63, 0x3e, 0x83,
	0xf6, 0x6b, 0xaa, 0xf6, 0xcb, 0x3c, 0x62, 0x7e, 0x1f, 0xc2, 0x42, 0x0f, 0xd7, 0xca, 0x12, 0x3c,
	0x66, 0xbd, 0x13, 0x16, 0x87, 0x06, 0xbb, 0xf3, 0xfb, 0x32, 0x54, 0xf7, 0x15, 0x80, 0x3c, 0x81,
	0x2a, 0x0a, 0x61, 0x42, 0x7d, 0xc6, 0x79, 0x71, 0x1d, 0x6c, 0x94, 0x62, 0xb0, 0xc8, 0x73, 0xe4,
	0x3b, 0xa8, 0x19, 0x39, 0x4b, 0xde, 0x2d, 0x3a, 0xa8, 0x2d, 0x9e, 0x83, 0x3b, 0x63, 0x50, 0xc6,
	0xf7, 0xf7, 0x00, 0x99, 0x70, 0x24, 0x5e, 0xb3, 0x11, 0x11, 0x1c, 0xdc, 0x1d, 0x07, 0x33, 0xee,
	0x55, 0x41, 0x84, 0x88, 0x2a, 0x2c, 0x88, 0xa5, 0xfa, 0x0a, 0x0b, 0x92, 0xd3, 0x77, 0xa6, 0x20,
	0x52, 0xcd, 0x15, 0x17, 0xc4, 0x16, 0x80, 0xc5, 0x05, 0xc9, 0x49, 0x42, 0x55, 0x90, 0x4c, 0x53,
	0xfa, 0x0b, 0x32, 0xa2, 0x56, 0xfd, 0x05, 0xf1, 0x48, 0x53, 0xe9, 0x3e, 0xd3, 0x58, 0x7e, 0xf7,
	0x23, 0x32, 0xce, 0xef, 0x7e, 0x54, 0xaa, 0x71, 0xf7, 0x6d, 0x58, 0xb4, 0x47, 0x36, 0xb9, 0x57,
	0x74, 0x6c, 0x47, 0x26, 0x04, 0x9b, 0xe3, 0x81, 0x26, 0xc8, 0x4f, 0xb0, 0x94, 0x93, 0xae, 0xc4,
	0x6b, 0xec, 0x93, 0xca, 0xc1, 0xd6, 0x05, 0x90, 0x76, 0x9c, 0x9c, 0x00, 0xf3, 0xc7, 0xf1, 0x89,
	0x4c, 0x7f, 0x1c, 0xaf, 0x9a, 0x53, 0x71, 0x72, 0x92, 0xca, 0x1f, 0xc7, 0xa7, 0xdd, 0xfc, 0x71,
	0xfc, 0xfa, 0x4c, 0x73, 0x8f, 0xf3, 0xab, 0x90, 0xfb, 0xfc, 0x68, 0x2f, 0xe4, 0xde, 0x9d, 0xd3,
	0x86, 0x7b, 0x3d, 0x57, 0x8b, 0xb9, 0x77, 0x66, 0x79, 0x31, 0xf7, 0xee, 0x88, 0xb6, 0xb9, 0xd7,
	0xc7, 0x28, 0xe1, 0xde, 0x39, 0xc9, 0xd6, 0x05, 0x90, 0xa3, 0x9c, 0x94, 0xc6, 0xf1, 0x89, 0xa1,
	0x32, 0x4e, 0x46, 0xe3, 0xf0, 0x4f, 0x89, 0x99, 0xb2, 0xfe, 0x4f, 0x89, 0x3b, 0xc3, 0x83, 0x3b,
	0x63, 0x50, 0xc6, 0xf7, 0x8f, 0xea, 0x2f, 0x17, 0x1c, 0x84, 0xe4, 0x6e, 0x51, 0x99, 0xf3, 0xf3,
	0x33, 0xb8, 0x37, 0x16, 0x67, 0x53, 0x6e, 0xcb, 0x15, 0x3f, 0xe5, 0x1e, 0x6d, 0x14, 0x6c, 0x8e,
	0x07, 0xda, 0x41, 0xec, 0xe9, 0xef, 0x0f, 0xe2, 0x51, 0x18, 0xc1, 0xe6, 0x78, 0xa0, 0xdb, 0xbc,
	0x7a, 0x2a, 0x17, 0x37, 0xaf, 0xa3, 0x04, 0x8a, 0x9b, 0xd7, 0x1d, 0xf0, 0x74, 0x6e, 0xef, 0xd6,
	0xcb, 0x57, 0xeb, 0x73, 0x7f, 0xf3, 0xe7, 0xbf, 0x57, 0xeb, 0x95, 0xdf, 0x5e, 0xaf, 0x57, 0x5e,
	0xf2, 0xe7, 0x2f, 0xfe, 0xfc, 0xcb, 0x9f, 0x93, 0x79, 0xf9, 0x47, 0xd9, 0xee, 0xff, 0x01, 0x00,
	0x00, 0xff, 0xff, 0xed, 0x12, 0x71, 0x66, 0x8c, 0x13, 0x00, 0x00,
}
