# Maintainers: Avoiding Burnout

**This guide is for maintainers.** These special people have **write
access** to Homebrew’s repository and help merge the contributions of
others. You may find what is written here interesting, but it’s
definitely not for everyone.

## 1. Use Homebrew

Maintainers of Homebrew should be using it regularly. This is partly because
you won't be a good maintainer unless you can put yourself in the shoes of our
users, but also because you may decide to stop using Homebrew and at that point
you should also decide not to be a maintainer and find other things to work on.

## 2. No Guilt About Leaving

All maintainers can stop working on Homebrew at any time without any guilt or
explanation (like leaving a job). We may still ask for your help with questions
after you leave but you are under no obligation to answer them. Like a job, if
you create a big mess and then leave you still have no obligations but we may
think less of you (or, realistically, probably just revert the problematic
work). Like a job, you should probably take a break from Homebrew at least a few
times a year.

This also means contributors should be consumers. If an owner finds they are
not using a project in the real world, they should reconsider their involvement
with the project.

## 3. Prioritise Maintainers Over Users

It's important to be user-focused but ultimately, as long as you follow #1
above, Homebrew's minimum number of users will be the number of maintainers.
However, if Homebrew has no maintainers it will quickly become useless to all
users and the project will die. As a result, no user complaint, behaviour or
need takes priority over the burnout of maintainers. If users do not like the
direction of the project, the easiest way to influence it is to make
significant, high-quality code contributions and become a maintainer.

## 4. Learn To Say No

Homebrew gets a lot of feature requests, non-reproducible bug reports, usage
questions and PRs we won't accept. These should be closed out as soon as we
realise that they aren't going to be resolved or merged. This is kinder than
deciding this after a long period of review. Our issue tracker should reflect
work to be done.

---

_Thanks to <https://gist.github.com/ryanflorence/124070e7c4b3839d4573> which influenced this document._
