# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `tapioca` gem.
# Please instead update this file by running `bin/tapioca gem tapioca`.

class Module
  include ::ActiveSupport::Dependencies::ModuleConstMissing

  def autoload(const_name, path); end
end

Module::DELEGATION_RESERVED_KEYWORDS = T.let(T.unsafe(nil), Array)
Module::DELEGATION_RESERVED_METHOD_NAMES = T.let(T.unsafe(nil), Set)
Module::RUBY_RESERVED_KEYWORDS = T.let(T.unsafe(nil), Array)
module RBI; end

class RBI::Tree < ::RBI::NodeWithComments
  sig do
    params(
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::Tree).void)
    ).void
  end
  def initialize(loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  sig { params(node: ::RBI::Node).void }
  def <<(node); end

  sig { override.params(v: ::RBI::Printer).void }
  def accept_printer(v); end

  sig { params(with_todo_comment: T::Boolean).void }
  def add_sig_templates!(with_todo_comment: T.unsafe(nil)); end

  sig { params(annotation: ::String, annotate_scopes: T::Boolean, annotate_properties: T::Boolean).void }
  def annotate!(annotation, annotate_scopes: T.unsafe(nil), annotate_properties: T.unsafe(nil)); end

  sig do
    params(
      name: ::String,
      superclass_name: T.nilable(::String),
      block: T.nilable(T.proc.params(scope: ::RBI::Scope).void)
    ).returns(::RBI::Scope)
  end
  def create_class(name, superclass_name: T.unsafe(nil), &block); end

  sig { params(name: ::String, value: ::String).void }
  def create_constant(name, value:); end

  sig { params(name: ::String).void }
  def create_extend(name); end

  sig { params(name: ::String).void }
  def create_include(name); end

  sig do
    params(
      name: ::String,
      parameters: T::Array[::RBI::TypedParam],
      return_type: ::String,
      class_method: T::Boolean,
      visibility: ::RBI::Visibility
    ).void
  end
  def create_method(name, parameters: T.unsafe(nil), return_type: T.unsafe(nil), class_method: T.unsafe(nil), visibility: T.unsafe(nil)); end

  sig { params(name: ::String).void }
  def create_mixes_in_class_methods(name); end

  sig { params(name: ::String, block: T.nilable(T.proc.params(scope: ::RBI::Scope).void)).returns(::RBI::Scope) }
  def create_module(name, &block); end

  sig { params(constant: ::Module, block: T.nilable(T.proc.params(scope: ::RBI::Scope).void)).void }
  def create_path(constant, &block); end

  sig do
    params(
      name: ::String,
      type: ::String,
      variance: ::Symbol,
      fixed: T.nilable(::String),
      upper: T.nilable(::String),
      lower: T.nilable(::String)
    ).void
  end
  def create_type_variable(name, type:, variance: T.unsafe(nil), fixed: T.unsafe(nil), upper: T.unsafe(nil), lower: T.unsafe(nil)); end

  sig { params(annotation: ::String).void }
  def deannotate!(annotation); end

  sig { returns(T::Boolean) }
  def empty?; end

  sig { void }
  def group_nodes!; end

  sig { returns(::RBI::Index) }
  def index; end

  sig do
    params(
      other: ::RBI::Tree,
      left_name: ::String,
      right_name: ::String,
      keep: ::RBI::Rewriters::Merge::Keep
    ).returns(::RBI::MergeTree)
  end
  def merge(other, left_name: T.unsafe(nil), right_name: T.unsafe(nil), keep: T.unsafe(nil)); end

  sig { void }
  def nest_non_public_methods!; end

  sig { void }
  def nest_singleton_methods!; end

  sig { returns(T::Array[::RBI::Node]) }
  def nodes; end

  sig { override.returns(T::Boolean) }
  def oneline?; end

  sig { void }
  def sort_nodes!; end

  private

  sig { params(node: ::RBI::Node).returns(::RBI::Node) }
  def create_node(node); end

  sig { returns(T::Hash[::String, ::RBI::Node]) }
  def nodes_cache; end

  sig { params(name: ::String).returns(T::Boolean) }
  def valid_method_name?(name); end
end

RBI::Tree::SPECIAL_METHOD_NAMES = T.let(T.unsafe(nil), Array)

class RBI::TypedParam < ::T::Struct
  const :param, ::RBI::Param
  const :type, ::String

  class << self
    def inherited(s); end
  end
end

RBI::VERSION = T.let(T.unsafe(nil), String)

module T::Generic::TypeStoragePatch
  def [](*types); end
  def type_member(variance = T.unsafe(nil), fixed: T.unsafe(nil), lower: T.unsafe(nil), upper: T.unsafe(nil), &bounds_proc); end
  def type_template(variance = T.unsafe(nil), fixed: T.unsafe(nil), lower: T.unsafe(nil), upper: T.unsafe(nil), &bounds_proc); end
end

module T::Types::Simple::GenericPatch
  def name; end
end

module T::Types::Simple::NamePatch
  def name; end
end

module T::Utils::CoercePatch
  def coerce(val); end
end

module Tapioca
  class << self
    sig do
      type_parameters(:Result)
        .params(
          blk: T.proc.returns(T.type_parameter(:Result))
        ).returns(T.type_parameter(:Result))
    end
    def silence_warnings(&blk); end
  end
end

Tapioca::BINARY_FILE = T.let(T.unsafe(nil), String)

class Tapioca::Cli < ::Thor
  include ::Tapioca::CliHelper
  include ::Tapioca::ConfigHelper
  include ::Tapioca::ShimsHelper

  def __print_version; end
  def check_shims; end
  def dsl(*constants); end
  def gem(*gems); end
  def init; end
  def require; end
  def todo; end

  class << self
    def exit_on_failure?; end
  end
end

Tapioca::Cli::FILE_HEADER_OPTION_DESC = T.let(T.unsafe(nil), String)

module Tapioca::CliHelper
  requires_ancestor { Thor::Shell }

  sig { params(options: T::Hash[::Symbol, T.untyped]).returns(::Tapioca::RBIFormatter) }
  def rbi_formatter(options); end

  sig { params(message: ::String, color: T.any(::Symbol, T::Array[::Symbol])).void }
  def say_error(message = T.unsafe(nil), *color); end
end

module Tapioca::Commands; end

class Tapioca::Commands::Command
  include ::Thor::Base
  include ::Thor::Invocation
  include ::Thor::Shell
  include ::Tapioca::CliHelper
  extend ::Thor::Base::ClassMethods
  extend ::Thor::Invocation::ClassMethods

  abstract!

  sig { void }
  def initialize; end

  sig { abstract.void }
  def execute; end

  sig { returns(::Thor::Actions) }
  def file_writer; end

  private

  sig do
    params(
      path: T.any(::Pathname, ::String),
      content: ::String,
      force: T::Boolean,
      skip: T::Boolean,
      verbose: T::Boolean
    ).void
  end
  def create_file(path, content, force: T.unsafe(nil), skip: T.unsafe(nil), verbose: T.unsafe(nil)); end

  sig { params(command: ::Symbol, args: ::String).returns(::String) }
  def default_command(command, *args); end

  sig { params(path: T.any(::Pathname, ::String), verbose: T::Boolean).void }
  def remove_file(path, verbose: T.unsafe(nil)); end
end

class Tapioca::Commands::Command::FileWriter < ::Thor
  include ::Thor::Actions
  extend ::Thor::Actions::ClassMethods
end

class Tapioca::Commands::Dsl < ::Tapioca::Commands::Command
  sig do
    params(
      requested_constants: T::Array[::String],
      outpath: ::Pathname,
      only: T::Array[::String],
      exclude: T::Array[::String],
      file_header: T::Boolean,
      compiler_path: ::String,
      tapioca_path: ::String,
      should_verify: T::Boolean,
      quiet: T::Boolean,
      verbose: T::Boolean,
      number_of_workers: T.nilable(::Integer),
      rbi_formatter: ::Tapioca::RBIFormatter
    ).void
  end
  def initialize(requested_constants:, outpath:, only:, exclude:, file_header:, compiler_path:, tapioca_path:, should_verify: T.unsafe(nil), quiet: T.unsafe(nil), verbose: T.unsafe(nil), number_of_workers: T.unsafe(nil), rbi_formatter: T.unsafe(nil)); end

  sig { override.void }
  def execute; end

  private

  sig { void }
  def abort_if_pending_migrations!; end

  sig { params(cause: ::Symbol, files: T::Array[::String]).returns(::String) }
  def build_error_for_files(cause, files); end

  sig do
    params(
      constant_name: ::String,
      rbi: ::RBI::File,
      outpath: ::Pathname,
      quiet: T::Boolean
    ).returns(T.nilable(::Pathname))
  end
  def compile_dsl_rbi(constant_name, rbi, outpath: T.unsafe(nil), quiet: T.unsafe(nil)); end

  sig { params(constant_names: T::Array[::String]).returns(T::Array[::Module]) }
  def constantize(constant_names); end

  sig { params(compiler_names: T::Array[::String]).returns(T::Array[T.class_of(Tapioca::Dsl::Compiler)]) }
  def constantize_compilers(compiler_names); end

  sig { params(constant_name: ::String).returns(::Pathname) }
  def dsl_rbi_filename(constant_name); end

  sig { params(requested_constants: T::Array[::String], path: ::Pathname).returns(T::Set[::Pathname]) }
  def existing_rbi_filenames(requested_constants, path: T.unsafe(nil)); end

  sig { params(constant: ::String).returns(::String) }
  def generate_command_for(constant); end

  sig { params(eager_load: T::Boolean).void }
  def load_application(eager_load:); end

  sig { void }
  def load_dsl_compilers; end

  sig { void }
  def load_dsl_extensions; end

  sig { returns(::Tapioca::Runtime::Loader) }
  def loader; end

  sig { params(dir: ::Pathname).void }
  def perform_dsl_verification(dir); end

  sig { params(files: T::Set[::Pathname]).void }
  def purge_stale_dsl_rbi_files(files); end

  sig { params(constant: ::String).returns(::String) }
  def rbi_filename_for(constant); end

  sig { params(path: ::Pathname).returns(T::Array[::Pathname]) }
  def rbi_files_in(path); end

  sig { params(diff: T::Hash[::String, ::Symbol], command: ::Symbol).void }
  def report_diff_and_exit_if_out_of_date(diff, command); end

  sig { params(name: ::String).returns(T.nilable(T.class_of(Tapioca::Dsl::Compiler))) }
  def resolve(name); end

  sig { params(class_name: ::String).returns(::String) }
  def underscore(class_name); end

  sig { params(tmp_dir: ::Pathname).returns(T::Hash[::String, ::Symbol]) }
  def verify_dsl_rbi(tmp_dir:); end
end

class Tapioca::Commands::Gem < ::Tapioca::Commands::Command
  include ::Tapioca::SorbetHelper

  sig do
    params(
      gem_names: T::Array[::String],
      exclude: T::Array[::String],
      prerequire: T.nilable(::String),
      postrequire: ::String,
      typed_overrides: T::Hash[::String, ::String],
      outpath: ::Pathname,
      file_header: T::Boolean,
      doc: T::Boolean,
      include_exported_rbis: T::Boolean,
      number_of_workers: T.nilable(::Integer),
      auto_strictness: T::Boolean,
      dsl_dir: ::String,
      rbi_formatter: ::Tapioca::RBIFormatter
    ).void
  end
  def initialize(gem_names:, exclude:, prerequire:, postrequire:, typed_overrides:, outpath:, file_header:, doc:, include_exported_rbis:, number_of_workers: T.unsafe(nil), auto_strictness: T.unsafe(nil), dsl_dir: T.unsafe(nil), rbi_formatter: T.unsafe(nil)); end

  sig { override.void }
  def execute; end

  sig { params(should_verify: T::Boolean).void }
  def sync(should_verify: T.unsafe(nil)); end

  private

  sig { returns(T::Array[::String]) }
  def added_rbis; end

  sig { params(cause: ::Symbol, files: T::Array[::String]).returns(::String) }
  def build_error_for_files(cause, files); end

  sig { returns(::Tapioca::Gemfile) }
  def bundle; end

  sig { params(gem: ::Tapioca::Gemfile::GemSpec).void }
  def compile_gem_rbi(gem); end

  sig { params(gem_name: ::String).returns(::Pathname) }
  def existing_rbi(gem_name); end

  sig { returns(T::Hash[::String, ::String]) }
  def existing_rbis; end

  sig { params(gem_name: ::String).returns(::Pathname) }
  def expected_rbi(gem_name); end

  sig { returns(T::Hash[::String, ::String]) }
  def expected_rbis; end

  sig { params(file: ::String, error: ::LoadError).void }
  def explain_failed_require(file, error); end

  sig { params(path: ::String).returns(::String) }
  def gem_name_from_rbi_path(path); end

  sig { params(gem_name: ::String).returns(T::Boolean) }
  def gem_rbi_exists?(gem_name); end

  sig { params(gem_name: ::String, version: ::String).returns(::Pathname) }
  def gem_rbi_filename(gem_name, version); end

  sig { params(gem_names: T::Array[::String]).returns(T::Array[::Tapioca::Gemfile::GemSpec]) }
  def gems_to_generate(gem_names); end

  sig { returns(::Tapioca::Runtime::Loader) }
  def loader; end

  sig { params(gem: ::Tapioca::Gemfile::GemSpec, file: ::RBI::File).void }
  def merge_with_exported_rbi(gem, file); end

  sig { params(old_filename: ::Pathname, new_filename: ::Pathname).void }
  def move(old_filename, new_filename); end

  sig { void }
  def perform_additions; end

  sig { void }
  def perform_removals; end

  sig { void }
  def perform_sync_verification; end

  sig { returns(T::Array[::String]) }
  def removed_rbis; end

  sig { params(diff: T::Hash[::String, ::Symbol], command: ::Symbol).void }
  def report_diff_and_exit_if_out_of_date(diff, command); end

  sig { void }
  def require_gem_file; end

  sig { params(gem_names: T::Array[::String], gem_dir: ::String, dsl_dir: ::String).void }
  def update_strictnesses(gem_names, gem_dir: T.unsafe(nil), dsl_dir: T.unsafe(nil)); end
end

class Tapioca::Commands::Init < ::Tapioca::Commands::Command
  sig { params(sorbet_config: ::String, tapioca_config: ::String, default_postrequire: ::String).void }
  def initialize(sorbet_config:, tapioca_config:, default_postrequire:); end

  sig { override.void }
  def execute; end

  private

  sig { void }
  def create_binstub; end

  sig { void }
  def create_post_require; end

  sig { void }
  def create_sorbet_config; end

  sig { void }
  def create_tapioca_config; end

  sig { returns(::Bundler::Installer) }
  def installer; end

  sig { returns(::Bundler::StubSpecification) }
  def spec; end
end

class Tapioca::Commands::Require < ::Tapioca::Commands::Command
  sig { params(requires_path: ::String, sorbet_config_path: ::String).void }
  def initialize(requires_path:, sorbet_config_path:); end

  sig { override.void }
  def execute; end
end

class Tapioca::Commands::Todo < ::Tapioca::Commands::Command
  include ::Tapioca::SorbetHelper

  sig { params(todo_file: ::String, file_header: T::Boolean).void }
  def initialize(todo_file:, file_header:); end

  sig { override.void }
  def execute; end

  private

  sig { params(constants: T::Array[::String], command: ::String).returns(::RBI::File) }
  def rbi(constants, command:); end

  sig { returns(T::Array[::String]) }
  def unresolved_constants; end
end

module Tapioca::ConfigHelper
  requires_ancestor { Thor }

  sig { params(args: T.untyped, local_options: T.untyped, config: T.untyped).void }
  def initialize(args = T.unsafe(nil), local_options = T.unsafe(nil), config = T.unsafe(nil)); end

  sig { returns(::String) }
  def command_name; end

  sig { returns(::Thor::CoreExt::HashWithIndifferentAccess) }
  def defaults; end

  sig { returns(::Thor::CoreExt::HashWithIndifferentAccess) }
  def options; end

  private

  sig { params(msg: ::String).returns(::Tapioca::ConfigHelper::ConfigError) }
  def build_error(msg); end

  sig do
    params(
      options: ::Thor::CoreExt::HashWithIndifferentAccess
    ).returns(::Thor::CoreExt::HashWithIndifferentAccess)
  end
  def config_options(options); end

  sig { params(options: T::Hash[::Symbol, ::Thor::Option]).void }
  def filter_defaults(options); end

  sig do
    params(
      options: T.nilable(::Thor::CoreExt::HashWithIndifferentAccess)
    ).returns(::Thor::CoreExt::HashWithIndifferentAccess)
  end
  def merge_options(*options); end

  sig { params(config_file: ::String, errors: T::Array[::Tapioca::ConfigHelper::ConfigError]).void }
  def print_errors(config_file, errors); end

  sig { params(config_file: ::String, config: T::Hash[T.untyped, T.untyped]).void }
  def validate_config!(config_file, config); end

  sig do
    params(
      command_options: T::Hash[::Symbol, ::Thor::Option],
      config_key: ::String,
      config_options: T::Hash[T.untyped, T.untyped]
    ).returns(T::Array[::Tapioca::ConfigHelper::ConfigError])
  end
  def validate_config_options(command_options, config_key, config_options); end
end

class Tapioca::ConfigHelper::ConfigError < ::T::Struct
  const :message_parts, T::Array[::Tapioca::ConfigHelper::ConfigErrorMessagePart]

  class << self
    def inherited(s); end
  end
end

class Tapioca::ConfigHelper::ConfigErrorMessagePart < ::T::Struct
  const :colors, T::Array[::Symbol]
  const :message, ::String

  class << self
    def inherited(s); end
  end
end

Tapioca::DEFAULT_DSL_DIR = T.let(T.unsafe(nil), String)
Tapioca::DEFAULT_GEM_DIR = T.let(T.unsafe(nil), String)
Tapioca::DEFAULT_OVERRIDES = T.let(T.unsafe(nil), Hash)
Tapioca::DEFAULT_POSTREQUIRE_FILE = T.let(T.unsafe(nil), String)
Tapioca::DEFAULT_RBI_DIR = T.let(T.unsafe(nil), String)
Tapioca::DEFAULT_RBI_FORMATTER = T.let(T.unsafe(nil), Tapioca::RBIFormatter)
Tapioca::DEFAULT_SHIM_DIR = T.let(T.unsafe(nil), String)
Tapioca::DEFAULT_TODO_FILE = T.let(T.unsafe(nil), String)
module Tapioca::Dsl; end

class Tapioca::Dsl::Compiler
  extend T::Generic
  include ::Tapioca::Runtime::Reflection
  include ::Tapioca::SignaturesHelper
  include ::Tapioca::Dsl::Helpers::ParamHelper
  extend ::Tapioca::Runtime::Reflection

  abstract!

  ConstantType = type_member { { upper: Module } }

  sig { params(pipeline: ::Tapioca::Dsl::Pipeline, root: ::RBI::Tree, constant: ConstantType).void }
  def initialize(pipeline, root, constant); end

  sig { params(error: ::String).void }
  def add_error(error); end

  sig { params(compiler_name: ::String).returns(T::Boolean) }
  def compiler_enabled?(compiler_name); end

  sig { returns(ConstantType) }
  def constant; end

  sig { abstract.void }
  def decorate; end

  sig { returns(::RBI::Tree) }
  def root; end

  private

  sig { params(type: ::String).returns(::String) }
  def as_nilable_type(type); end

  sig { params(method_def: T.any(::Method, ::UnboundMethod)).returns(T::Array[::RBI::TypedParam]) }
  def compile_method_parameters_to_rbi(method_def); end

  sig { params(method_def: T.any(::Method, ::UnboundMethod)).returns(::String) }
  def compile_method_return_type_to_rbi(method_def); end

  sig { params(scope: ::RBI::Scope, method_def: T.any(::Method, ::UnboundMethod), class_method: T::Boolean).void }
  def create_method_from_def(scope, method_def, class_method: T.unsafe(nil)); end

  sig { params(method_def: T.any(::Method, ::UnboundMethod), signature: T.untyped).returns(T::Array[::String]) }
  def parameters_types_from_signature(method_def, signature); end

  sig { params(name: ::String).returns(T::Boolean) }
  def valid_parameter_name?(name); end

  class << self
    sig { abstract.returns(T::Enumerable[::Module]) }
    def gather_constants; end

    sig { params(constant: ::Module).returns(T::Boolean) }
    def handles?(constant); end

    sig { returns(T::Set[::Module]) }
    def processable_constants; end

    private

    sig { returns(T::Enumerable[::Class]) }
    def all_classes; end

    sig { returns(T::Enumerable[::Module]) }
    def all_modules; end
  end
end

module Tapioca::Dsl::Compilers; end
Tapioca::Dsl::Compilers::DIRECTORY = T.let(T.unsafe(nil), String)
Tapioca::Dsl::Compilers::NAMESPACES = T.let(T.unsafe(nil), Array)
module Tapioca::Dsl::Helpers; end

module Tapioca::Dsl::Helpers::ParamHelper
  include ::Tapioca::SignaturesHelper

  sig { params(name: ::String, type: ::String).returns(::RBI::TypedParam) }
  def create_block_param(name, type:); end

  sig { params(name: ::String, type: ::String, default: ::String).returns(::RBI::TypedParam) }
  def create_kw_opt_param(name, type:, default:); end

  sig { params(name: ::String, type: ::String).returns(::RBI::TypedParam) }
  def create_kw_param(name, type:); end

  sig { params(name: ::String, type: ::String).returns(::RBI::TypedParam) }
  def create_kw_rest_param(name, type:); end

  sig { params(name: ::String, type: ::String, default: ::String).returns(::RBI::TypedParam) }
  def create_opt_param(name, type:, default:); end

  sig { params(name: ::String, type: ::String).returns(::RBI::TypedParam) }
  def create_param(name, type:); end

  sig { params(name: ::String, type: ::String).returns(::RBI::TypedParam) }
  def create_rest_param(name, type:); end

  sig { params(param: ::RBI::Param, type: ::String).returns(::RBI::TypedParam) }
  def create_typed_param(param, type); end
end

class Tapioca::Dsl::Pipeline
  sig do
    params(
      requested_constants: T::Array[::Module],
      requested_compilers: T::Array[T.class_of(Tapioca::Dsl::Compiler)],
      excluded_compilers: T::Array[T.class_of(Tapioca::Dsl::Compiler)],
      error_handler: T.proc.params(error: ::String).void,
      number_of_workers: T.nilable(::Integer)
    ).void
  end
  def initialize(requested_constants:, requested_compilers: T.unsafe(nil), excluded_compilers: T.unsafe(nil), error_handler: T.unsafe(nil), number_of_workers: T.unsafe(nil)); end

  sig { params(error: ::String).void }
  def add_error(error); end

  sig { params(compiler_name: ::String).returns(T::Boolean) }
  def compiler_enabled?(compiler_name); end

  sig { returns(T::Enumerable[T.class_of(Tapioca::Dsl::Compiler)]) }
  def compilers; end

  sig { returns(T.proc.params(error: ::String).void) }
  def error_handler; end

  sig { returns(T::Array[::String]) }
  def errors; end

  sig { returns(T::Array[::Module]) }
  def requested_constants; end

  sig do
    type_parameters(:T)
      .params(
        blk: T.proc.params(constant: ::Module, rbi: ::RBI::File).returns(T.type_parameter(:T))
      ).returns(T::Array[T.type_parameter(:T)])
  end
  def run(&blk); end

  private

  sig { params(constants: T::Set[::Module]).returns(T::Set[::Module]) }
  def filter_anonymous_and_reloaded_constants(constants); end

  sig do
    params(
      requested_compilers: T::Array[T.class_of(Tapioca::Dsl::Compiler)],
      excluded_compilers: T::Array[T.class_of(Tapioca::Dsl::Compiler)]
    ).returns(T::Enumerable[T.class_of(Tapioca::Dsl::Compiler)])
  end
  def gather_compilers(requested_compilers, excluded_compilers); end

  sig { params(requested_constants: T::Array[::Module]).returns(T::Set[::Module]) }
  def gather_constants(requested_constants); end

  sig { params(constant: ::Module).returns(T.nilable(::RBI::File)) }
  def rbi_for_constant(constant); end

  sig { params(error: ::String).returns(T.noreturn) }
  def report_error(error); end
end

class Tapioca::Error < ::StandardError; end

class Tapioca::Executor
  sig { params(queue: T::Array[T.untyped], number_of_workers: T.nilable(::Integer)).void }
  def initialize(queue, number_of_workers: T.unsafe(nil)); end

  sig do
    type_parameters(:T)
      .params(
        block: T.proc.params(item: T.untyped).returns(T.type_parameter(:T))
      ).returns(T::Array[T.type_parameter(:T)])
  end
  def run_in_parallel(&block); end
end

Tapioca::Executor::MINIMUM_ITEMS_PER_WORKER = T.let(T.unsafe(nil), Integer)
module Tapioca::Gem; end

class Tapioca::Gem::ConstNodeAdded < ::Tapioca::Gem::NodeAdded
  sig { params(symbol: ::String, constant: ::Module, node: ::RBI::Const).void }
  def initialize(symbol, constant, node); end

  sig { returns(::RBI::Const) }
  def node; end
end

class Tapioca::Gem::ConstantFound < ::Tapioca::Gem::Event
  sig { params(symbol: ::String, constant: ::BasicObject).void }
  def initialize(symbol, constant); end

  sig { returns(::BasicObject) }
  def constant; end

  sig { returns(::String) }
  def symbol; end
end

class Tapioca::Gem::Event
  abstract!

  def initialize(*args, &blk); end
end

module Tapioca::Gem::Listeners; end

class Tapioca::Gem::Listeners::Base
  abstract!

  sig { params(pipeline: ::Tapioca::Gem::Pipeline).void }
  def initialize(pipeline); end

  sig { params(event: ::Tapioca::Gem::NodeAdded).void }
  def dispatch(event); end

  private

  sig { params(event: ::Tapioca::Gem::ConstNodeAdded).void }
  def on_const(event); end

  sig { params(event: ::Tapioca::Gem::MethodNodeAdded).void }
  def on_method(event); end

  sig { params(event: ::Tapioca::Gem::ScopeNodeAdded).void }
  def on_scope(event); end
end

class Tapioca::Gem::Listeners::DynamicMixins < ::Tapioca::Gem::Listeners::Base
  include ::Tapioca::Runtime::Reflection

  private

  sig { override.params(event: ::Tapioca::Gem::ScopeNodeAdded).void }
  def on_scope(event); end
end

class Tapioca::Gem::Listeners::Methods < ::Tapioca::Gem::Listeners::Base
  include ::Tapioca::Runtime::Reflection

  private

  sig { params(tree: ::RBI::Tree, module_name: ::String, mod: ::Module, for_visibility: T::Array[::Symbol]).void }
  def compile_directly_owned_methods(tree, module_name, mod, for_visibility = T.unsafe(nil)); end

  sig do
    params(
      tree: ::RBI::Tree,
      symbol_name: ::String,
      constant: ::Module,
      method: T.nilable(::UnboundMethod),
      visibility: ::RBI::Visibility
    ).void
  end
  def compile_method(tree, symbol_name, constant, method, visibility = T.unsafe(nil)); end

  sig { params(constant: ::Module).returns(T.nilable(::UnboundMethod)) }
  def initialize_method_for(constant); end

  sig { params(mod: ::Module).returns(T::Hash[::Symbol, T::Array[::Symbol]]) }
  def method_names_by_visibility(mod); end

  sig { override.params(event: ::Tapioca::Gem::ScopeNodeAdded).void }
  def on_scope(event); end

  sig { params(constant: ::Module, method_name: ::String).returns(T::Boolean) }
  def struct_method?(constant, method_name); end

  sig { params(name: ::String).returns(T::Boolean) }
  def valid_method_name?(name); end

  sig { params(name: ::String).returns(T::Boolean) }
  def valid_parameter_name?(name); end
end

Tapioca::Gem::Listeners::Methods::SPECIAL_METHOD_NAMES = T.let(T.unsafe(nil), Array)

class Tapioca::Gem::Listeners::Mixins < ::Tapioca::Gem::Listeners::Base
  include ::Tapioca::Runtime::Reflection

  private

  sig do
    params(
      tree: ::RBI::Tree,
      mods: T::Array[::Module],
      mixin_type: ::Tapioca::Runtime::Trackers::Mixin::Type
    ).void
  end
  def add_mixins(tree, mods, mixin_type); end

  sig { params(mixin_name: ::String).returns(T::Boolean) }
  def filtered_mixin?(mixin_name); end

  sig { params(constant: ::Module).returns(T::Array[::Module]) }
  def interesting_ancestors_of(constant); end

  sig { override.params(event: ::Tapioca::Gem::ScopeNodeAdded).void }
  def on_scope(event); end
end

class Tapioca::Gem::Listeners::RemoveEmptyPayloadScopes < ::Tapioca::Gem::Listeners::Base
  include ::Tapioca::Runtime::Reflection

  private

  sig { override.params(event: ::Tapioca::Gem::ScopeNodeAdded).void }
  def on_scope(event); end
end

class Tapioca::Gem::Listeners::SorbetEnums < ::Tapioca::Gem::Listeners::Base
  private

  sig { override.params(event: ::Tapioca::Gem::ScopeNodeAdded).void }
  def on_scope(event); end
end

class Tapioca::Gem::Listeners::SorbetHelpers < ::Tapioca::Gem::Listeners::Base
  include ::Tapioca::Runtime::Reflection

  private

  sig { override.params(event: ::Tapioca::Gem::ScopeNodeAdded).void }
  def on_scope(event); end
end

class Tapioca::Gem::Listeners::SorbetProps < ::Tapioca::Gem::Listeners::Base
  private

  sig { override.params(event: ::Tapioca::Gem::ScopeNodeAdded).void }
  def on_scope(event); end
end

class Tapioca::Gem::Listeners::SorbetRequiredAncestors < ::Tapioca::Gem::Listeners::Base
  private

  sig { override.params(event: ::Tapioca::Gem::ScopeNodeAdded).void }
  def on_scope(event); end
end

class Tapioca::Gem::Listeners::SorbetSignatures < ::Tapioca::Gem::Listeners::Base
  include ::Tapioca::Runtime::Reflection
  include ::Tapioca::SignaturesHelper

  private

  sig { params(signature: T.untyped, parameters: T::Array[[::Symbol, ::String]]).returns(::RBI::Sig) }
  def compile_signature(signature, parameters); end

  sig { override.params(event: ::Tapioca::Gem::MethodNodeAdded).void }
  def on_method(event); end

  sig { params(signature: T.untyped).returns(T::Boolean) }
  def signature_final?(signature); end
end

Tapioca::Gem::Listeners::SorbetSignatures::TYPE_PARAMETER_MATCHER = T.let(T.unsafe(nil), Regexp)

class Tapioca::Gem::Listeners::SorbetTypeVariables < ::Tapioca::Gem::Listeners::Base
  include ::Tapioca::Runtime::Reflection

  private

  sig { params(tree: ::RBI::Tree, constant: ::Module).void }
  def compile_type_variable_declarations(tree, constant); end

  sig { override.params(event: ::Tapioca::Gem::ScopeNodeAdded).void }
  def on_scope(event); end
end

class Tapioca::Gem::Listeners::Subconstants < ::Tapioca::Gem::Listeners::Base
  include ::Tapioca::Runtime::Reflection

  private

  sig { override.params(event: ::Tapioca::Gem::ScopeNodeAdded).void }
  def on_scope(event); end
end

class Tapioca::Gem::Listeners::YardDoc < ::Tapioca::Gem::Listeners::Base
  sig { params(pipeline: ::Tapioca::Gem::Pipeline).void }
  def initialize(pipeline); end

  private

  sig { params(name: ::String, sigs: T::Array[::RBI::Sig]).returns(T::Array[::RBI::Comment]) }
  def documentation_comments(name, sigs: T.unsafe(nil)); end

  sig { override.params(event: ::Tapioca::Gem::ConstNodeAdded).void }
  def on_const(event); end

  sig { override.params(event: ::Tapioca::Gem::MethodNodeAdded).void }
  def on_method(event); end

  sig { override.params(event: ::Tapioca::Gem::ScopeNodeAdded).void }
  def on_scope(event); end
end

Tapioca::Gem::Listeners::YardDoc::IGNORED_COMMENTS = T.let(T.unsafe(nil), Array)
Tapioca::Gem::Listeners::YardDoc::IGNORED_SIG_TAGS = T.let(T.unsafe(nil), Array)

class Tapioca::Gem::MethodNodeAdded < ::Tapioca::Gem::NodeAdded
  sig do
    params(
      symbol: ::String,
      constant: ::Module,
      node: ::RBI::Method,
      signature: T.untyped,
      parameters: T::Array[[::Symbol, ::String]]
    ).void
  end
  def initialize(symbol, constant, node, signature, parameters); end

  sig { returns(::RBI::Method) }
  def node; end

  sig { returns(T::Array[[::Symbol, ::String]]) }
  def parameters; end

  sig { returns(T.untyped) }
  def signature; end
end

class Tapioca::Gem::NodeAdded < ::Tapioca::Gem::Event
  abstract!

  sig { params(symbol: ::String, constant: ::Module).void }
  def initialize(symbol, constant); end

  sig { returns(::Module) }
  def constant; end

  sig { returns(::String) }
  def symbol; end
end

class Tapioca::Gem::Pipeline
  include ::Tapioca::Runtime::Reflection
  include ::Tapioca::SignaturesHelper

  sig { params(gem: ::Tapioca::Gemfile::GemSpec, include_doc: T::Boolean).void }
  def initialize(gem, include_doc: T.unsafe(nil)); end

  sig { returns(::RBI::Tree) }
  def compile; end

  sig { returns(::Tapioca::Gemfile::GemSpec) }
  def gem; end

  sig { params(method: ::UnboundMethod).returns(T::Boolean) }
  def method_in_gem?(method); end

  sig { params(constant: ::Module).returns(T.nilable(::String)) }
  def name_of(constant); end

  sig { params(symbol: ::String, constant: ::Module, node: ::RBI::Const).void }
  def push_const(symbol, constant, node); end

  sig { params(symbol: ::String, constant: ::BasicObject).void }
  def push_constant(symbol, constant); end

  sig do
    params(
      symbol: ::String,
      constant: ::Module,
      node: ::RBI::Method,
      signature: T.untyped,
      parameters: T::Array[[::Symbol, ::String]]
    ).void
  end
  def push_method(symbol, constant, node, signature, parameters); end

  sig { params(symbol: ::String, constant: ::Module, node: ::RBI::Scope).void }
  def push_scope(symbol, constant, node); end

  sig { params(symbol: ::String).void }
  def push_symbol(symbol); end

  sig { params(symbol_name: ::String).returns(T::Boolean) }
  def symbol_in_payload?(symbol_name); end

  private

  sig { params(name: ::String).void }
  def add_to_alias_namespace(name); end

  sig { params(name: ::String).returns(T::Boolean) }
  def alias_namespaced?(name); end

  sig { params(name: ::String, constant: ::Module).void }
  def compile_alias(name, constant); end

  sig { params(symbol: ::String, constant: ::BasicObject).void }
  def compile_constant(symbol, constant); end

  sig { params(name: ::String, constant: ::Module).void }
  def compile_module(name, constant); end

  sig { params(name: ::String, value: ::BasicObject).void }
  def compile_object(name, value); end

  sig { params(constant: ::Class).returns(T.nilable(::String)) }
  def compile_superclass(constant); end

  sig { params(constant: ::Module, strict: T::Boolean).returns(T::Boolean) }
  def defined_in_gem?(constant, strict: T.unsafe(nil)); end

  sig { params(event: ::Tapioca::Gem::Event).void }
  def dispatch(event); end

  sig { params(constant: T.all(::Module, ::T::Generic)).returns(::String) }
  def generic_name_of(constant); end

  sig { params(constant: ::Module).returns(T::Array[::String]) }
  def get_file_candidates(constant); end

  sig { params(name: ::String).void }
  def mark_seen(name); end

  sig { params(constant: ::Module, class_name: T.nilable(::String)).returns(T.nilable(::String)) }
  def name_of_proxy_target(constant, class_name); end

  sig { returns(::Tapioca::Gem::Event) }
  def next_event; end

  sig { params(event: ::Tapioca::Gem::ConstantFound).void }
  def on_constant(event); end

  sig { params(event: ::Tapioca::Gem::NodeAdded).void }
  def on_node(event); end

  sig { params(event: ::Tapioca::Gem::SymbolFound).void }
  def on_symbol(event); end

  sig { params(name: ::String).returns(T::Boolean) }
  def seen?(name); end
end

Tapioca::Gem::Pipeline::IGNORED_SYMBOLS = T.let(T.unsafe(nil), Array)

class Tapioca::Gem::ScopeNodeAdded < ::Tapioca::Gem::NodeAdded
  sig { params(symbol: ::String, constant: ::Module, node: ::RBI::Scope).void }
  def initialize(symbol, constant, node); end

  sig { returns(::RBI::Scope) }
  def node; end
end

class Tapioca::Gem::SymbolFound < ::Tapioca::Gem::Event
  sig { params(symbol: ::String).void }
  def initialize(symbol); end

  sig { returns(::String) }
  def symbol; end
end

class Tapioca::Gemfile
  sig { void }
  def initialize; end

  sig { returns(::Bundler::Definition) }
  def definition; end

  sig { returns(T::Array[::Tapioca::Gemfile::GemSpec]) }
  def dependencies; end

  sig { params(gem_name: ::String).returns(T.nilable(::Tapioca::Gemfile::GemSpec)) }
  def gem(gem_name); end

  sig { returns(T::Array[::String]) }
  def missing_specs; end

  sig { void }
  def require_bundle; end

  private

  sig { returns(::String) }
  def dir; end

  sig { returns(::File) }
  def gemfile; end

  sig { returns(T::Array[::Symbol]) }
  def groups; end

  sig { returns([T::Array[::Tapioca::Gemfile::GemSpec], T::Array[::String]]) }
  def load_dependencies; end

  def lockfile; end

  sig { returns([T::Enumerable[T.any(::Bundler::StubSpecification, ::Gem::Specification)], T::Array[::String]]) }
  def materialize_deps; end

  sig { returns(::Bundler::Runtime) }
  def runtime; end
end

class Tapioca::Gemfile::GemSpec
  sig { params(spec: T.any(::Bundler::StubSpecification, ::Gem::Specification)).void }
  def initialize(spec); end

  sig { params(path: ::String).returns(T::Boolean) }
  def contains_path?(path); end

  sig { returns(T::Boolean) }
  def export_rbi_files?; end

  sig { returns(T::Array[::String]) }
  def exported_rbi_files; end

  sig { returns(::RBI::MergeTree) }
  def exported_rbi_tree; end

  sig { returns(T::Array[::Pathname]) }
  def files; end

  sig { returns(::String) }
  def full_gem_path; end

  sig { params(gemfile_dir: ::String).returns(T::Boolean) }
  def ignore?(gemfile_dir); end

  sig { returns(::String) }
  def name; end

  sig { void }
  def parse_yard_docs; end

  sig { returns(::String) }
  def rbi_file_name; end

  def version; end

  private

  sig { returns(T::Array[::Pathname]) }
  def collect_files; end

  sig { returns(T.nilable(T::Boolean)) }
  def default_gem?; end

  sig { returns(T::Boolean) }
  def gem_ignored?; end

  sig { params(gemfile_dir: ::String).returns(T::Boolean) }
  def gem_in_app_dir?(gemfile_dir); end

  sig { returns(T::Boolean) }
  def gem_in_bundle_path?; end

  sig { params(path: ::String).returns(T::Boolean) }
  def has_parent_gemspec?(path); end

  sig { returns(::Regexp) }
  def require_paths_prefix_matcher; end

  sig { params(file: ::String).returns(::Pathname) }
  def resolve_to_ruby_lib_dir(file); end

  sig { params(path: T.any(::Pathname, ::String)).returns(::String) }
  def to_realpath(path); end

  sig { returns(::String) }
  def version_string; end
end

Tapioca::Gemfile::GemSpec::IGNORED_GEMS = T.let(T.unsafe(nil), Array)
Tapioca::Gemfile::Spec = T.type_alias { T.any(::Bundler::StubSpecification, ::Gem::Specification) }

class Tapioca::RBIFormatter < ::RBI::Formatter
  sig { params(file: ::RBI::File).void }
  def write_empty_body_comment!(file); end

  sig { params(file: ::RBI::File, command: ::String, reason: T.nilable(::String)).void }
  def write_header!(file, command, reason: T.unsafe(nil)); end
end

module Tapioca::Runtime; end

class Tapioca::Runtime::DynamicMixinCompiler
  include ::Tapioca::Runtime::Reflection

  sig { params(constant: ::Module).void }
  def initialize(constant); end

  def class_attribute_predicates; end

  sig { returns(T::Array[::Symbol]) }
  def class_attribute_readers; end

  def class_attribute_writers; end

  sig { params(tree: ::RBI::Tree).void }
  def compile_class_attributes(tree); end

  sig { params(tree: ::RBI::Tree).returns([T::Array[::Module], T::Array[::Module]]) }
  def compile_mixes_in_class_methods(tree); end

  sig { returns(T::Array[::Module]) }
  def dynamic_extends; end

  def dynamic_includes; end

  sig { returns(T::Boolean) }
  def empty_attributes?; end

  sig { params(qualified_mixin_name: ::String).returns(T::Boolean) }
  def filtered_mixin?(qualified_mixin_name); end

  def instance_attribute_predicates; end

  sig { returns(T::Array[::Symbol]) }
  def instance_attribute_readers; end

  def instance_attribute_writers; end

  sig { params(mod: ::Module, dynamic_extends: T::Array[::Module]).returns(T::Boolean) }
  def module_included_by_another_dynamic_extend?(mod, dynamic_extends); end
end

module Tapioca::Runtime::GenericTypeRegistry
  class << self
    sig { params(instance: ::Object).returns(T::Boolean) }
    def generic_type_instance?(instance); end

    sig { params(constant: ::Module).returns(T.nilable(T::Array[::Tapioca::TypeVariableModule])) }
    def lookup_type_variables(constant); end

    sig { params(constant: T.untyped, types: T.untyped).returns(::Module) }
    def register_type(constant, types); end

    sig { params(constant: T.untyped, type_variable: ::Tapioca::TypeVariableModule).void }
    def register_type_variable(constant, type_variable); end

    private

    sig { params(constant: ::Module, name: ::String).returns(::Module) }
    def create_generic_type(constant, name); end

    sig { params(constant: ::Class).returns(::Class) }
    def create_safe_subclass(constant); end

    sig { params(constant: ::Module).returns(T::Array[::Tapioca::TypeVariableModule]) }
    def lookup_or_initialize_type_variables(constant); end
  end
end

class Tapioca::Runtime::Loader
  sig do
    params(
      gemfile: ::Tapioca::Gemfile,
      initialize_file: T.nilable(::String),
      require_file: T.nilable(::String)
    ).void
  end
  def load_bundle(gemfile, initialize_file, require_file); end

  sig { params(environment_load: T::Boolean, eager_load: T::Boolean).void }
  def load_rails_application(environment_load: T.unsafe(nil), eager_load: T.unsafe(nil)); end

  private

  sig { void }
  def eager_load_rails_app; end

  sig { void }
  def load_rails_engines; end

  sig { returns(T::Array[T.untyped]) }
  def rails_engines; end

  sig { params(file: T.nilable(::String)).void }
  def require_helper(file); end

  sig { params(path: ::String).void }
  def safe_require(path); end

  sig { void }
  def silence_deprecations; end
end

module Tapioca::Runtime::Reflection
  extend ::Tapioca::Runtime::Reflection

  sig { params(constant: ::Module).returns(T::Array[::Module]) }
  def ancestors_of(constant); end

  sig { params(object: ::BasicObject, other: ::BasicObject).returns(T::Boolean) }
  def are_equal?(object, other); end

  sig { params(object: ::BasicObject).returns(::Class) }
  def class_of(object); end

  sig { params(symbol: ::String, inherit: T::Boolean, namespace: ::Module).returns(::BasicObject) }
  def constantize(symbol, inherit: T.unsafe(nil), namespace: T.unsafe(nil)); end

  sig { params(constant: ::Module).returns(T::Array[::Symbol]) }
  def constants_of(constant); end

  sig do
    type_parameters(:U)
      .params(
        klass: T.all(::Class, T.type_parameter(:U))
      ).returns(T::Array[T.type_parameter(:U)])
  end
  def descendants_of(klass); end

  sig { params(constant: ::Module).returns(T::Array[::Module]) }
  def inherited_ancestors_of(constant); end

  sig { params(constant: ::Module, method: ::Symbol).returns(::Method) }
  def method_of(constant, method); end

  sig { params(constant: ::Module).returns(T.nilable(::String)) }
  def name_of(constant); end

  sig { params(type: ::T::Types::Base).returns(::String) }
  def name_of_type(type); end

  sig { params(object: ::BasicObject).returns(::Integer) }
  def object_id_of(object); end

  sig { params(constant: ::Module).returns(T::Array[::Symbol]) }
  def private_instance_methods_of(constant); end

  sig { params(constant: ::Module).returns(T::Array[::Symbol]) }
  def protected_instance_methods_of(constant); end

  sig { params(constant: ::Module).returns(T::Array[::Symbol]) }
  def public_instance_methods_of(constant); end

  sig { params(constant: ::Module).returns(T.nilable(::String)) }
  def qualified_name_of(constant); end

  sig { params(method: T.any(::Method, ::UnboundMethod)).returns(T.untyped) }
  def signature_of(method); end

  sig { params(constant: ::Module).returns(::Class) }
  def singleton_class_of(constant); end

  sig { params(constant: ::Class).returns(T.nilable(::Class)) }
  def superclass_of(constant); end
end

Tapioca::Runtime::Reflection::ANCESTORS_METHOD = T.let(T.unsafe(nil), UnboundMethod)
Tapioca::Runtime::Reflection::CLASS_METHOD = T.let(T.unsafe(nil), UnboundMethod)
Tapioca::Runtime::Reflection::CONSTANTS_METHOD = T.let(T.unsafe(nil), UnboundMethod)
Tapioca::Runtime::Reflection::EQUAL_METHOD = T.let(T.unsafe(nil), UnboundMethod)
Tapioca::Runtime::Reflection::METHOD_METHOD = T.let(T.unsafe(nil), UnboundMethod)
Tapioca::Runtime::Reflection::NAME_METHOD = T.let(T.unsafe(nil), UnboundMethod)
Tapioca::Runtime::Reflection::OBJECT_ID_METHOD = T.let(T.unsafe(nil), UnboundMethod)
Tapioca::Runtime::Reflection::PRIVATE_INSTANCE_METHODS_METHOD = T.let(T.unsafe(nil), UnboundMethod)
Tapioca::Runtime::Reflection::PROTECTED_INSTANCE_METHODS_METHOD = T.let(T.unsafe(nil), UnboundMethod)
Tapioca::Runtime::Reflection::PUBLIC_INSTANCE_METHODS_METHOD = T.let(T.unsafe(nil), UnboundMethod)
Tapioca::Runtime::Reflection::SINGLETON_CLASS_METHOD = T.let(T.unsafe(nil), UnboundMethod)
Tapioca::Runtime::Reflection::SUPERCLASS_METHOD = T.let(T.unsafe(nil), UnboundMethod)
module Tapioca::Runtime::Trackers; end

module Tapioca::Runtime::Trackers::Autoload
  class << self
    sig { void }
    def eager_load_all!; end

    sig { params(constant_name: ::String).void }
    def register(constant_name); end

    sig do
      type_parameters(:Result)
        .params(
          block: T.proc.returns(T.type_parameter(:Result))
        ).returns(T.type_parameter(:Result))
    end
    def with_disabled_exits(&block); end
  end
end

Tapioca::Runtime::Trackers::Autoload::NOOP_METHOD = T.let(T.unsafe(nil), Proc)

module Tapioca::Runtime::Trackers::ConstantDefinition
  extend ::Tapioca::Runtime::Reflection

  class << self
    def files_for(klass); end
  end
end

module Tapioca::Runtime::Trackers::Mixin
  class << self
    sig do
      params(
        constant: ::Module
      ).returns(T::Hash[::Tapioca::Runtime::Trackers::Mixin::Type, T::Hash[::Module, T::Array[::String]]])
    end
    def mixin_locations_for(constant); end

    sig do
      params(
        constant: ::Module,
        mod: ::Module,
        mixin_type: ::Tapioca::Runtime::Trackers::Mixin::Type,
        locations: T.nilable(T::Array[::Thread::Backtrace::Location])
      ).void
    end
    def register(constant, mod, mixin_type, locations); end
  end
end

class Tapioca::Runtime::Trackers::Mixin::Type < ::T::Enum
  enums do
    Prepend = new
    Include = new
    Extend = new
  end
end

module Tapioca::Runtime::Trackers::RequiredAncestor
  class << self
    sig { params(requiring: ::T::Helpers, block: T.proc.returns(::Module)).void }
    def register(requiring, block); end

    sig { params(mod: ::Module).returns(T::Array[T.proc.returns(::Module)]) }
    def required_ancestors_blocks_by(mod); end

    sig { params(mod: ::Module).returns(T::Array[T.nilable(::Module)]) }
    def required_ancestors_by(mod); end
  end
end

Tapioca::SORBET_CONFIG_FILE = T.let(T.unsafe(nil), String)
Tapioca::SORBET_DIR = T.let(T.unsafe(nil), String)

module Tapioca::ShimsHelper
  requires_ancestor { Thor::Shell }

  sig { params(index: ::RBI::Index, shim_rbi_dir: ::String).returns(T::Hash[::String, T::Array[::RBI::Node]]) }
  def duplicated_nodes_from_index(index, shim_rbi_dir); end

  sig { params(index: ::RBI::Index, kind: ::String, dir: ::String).void }
  def index_rbis(index, kind, dir); end

  private

  sig { params(nodes: T::Array[::RBI::Node]).returns(T::Array[T.any(::RBI::Attr, ::RBI::Method)]) }
  def extract_methods_and_attrs(nodes); end

  sig do
    params(
      nodes: T::Array[T.any(::RBI::Attr, ::RBI::Method)]
    ).returns(T::Array[T.any(::RBI::Attr, ::RBI::Method)])
  end
  def extract_nodes_with_sigs(nodes); end

  sig { params(nodes: T::Array[::RBI::Node], shim_rbi_dir: ::String).returns(T::Array[::RBI::Node]) }
  def extract_shims(nodes, shim_rbi_dir); end

  sig { params(nodes: T::Array[::RBI::Node], shim_rbi_dir: ::String).returns(T::Boolean) }
  def shims_have_duplicates?(nodes, shim_rbi_dir); end
end

module Tapioca::SignaturesHelper
  sig { params(sig_string: ::String).returns(::String) }
  def sanitize_signature_types(sig_string); end
end

module Tapioca::SorbetHelper
  sig { params(sorbet_args: ::String).returns(::Tapioca::SorbetHelper::CmdResult) }
  def sorbet(*sorbet_args); end

  sig { returns(::String) }
  def sorbet_path; end

  sig { params(feature: ::Symbol, version: T.nilable(::Gem::Version)).returns(T::Boolean) }
  def sorbet_supports?(feature, version: T.unsafe(nil)); end
end

class Tapioca::SorbetHelper::CmdResult < ::T::Struct
  const :err, ::String
  const :out, ::String
  const :status, T::Boolean

  class << self
    def inherited(s); end
  end
end

Tapioca::SorbetHelper::FEATURE_REQUIREMENTS = T.let(T.unsafe(nil), Hash)
Tapioca::SorbetHelper::SORBET_BIN = T.let(T.unsafe(nil), Pathname)
Tapioca::SorbetHelper::SORBET_EXE_PATH_ENV_VAR = T.let(T.unsafe(nil), String)
Tapioca::SorbetHelper::SORBET_GEM_SPEC = T.let(T.unsafe(nil), Gem::Specification)
module Tapioca::Static; end

class Tapioca::Static::RequiresCompiler
  sig { params(sorbet_path: ::String).void }
  def initialize(sorbet_path); end

  sig { returns(::String) }
  def compile; end

  private

  sig { params(config: ::Spoom::Sorbet::Config).returns(T::Array[::String]) }
  def collect_files(config); end

  sig { params(file_path: ::String).returns(T::Enumerable[::String]) }
  def collect_requires(file_path); end

  sig { params(config: ::Spoom::Sorbet::Config, file_path: ::Pathname).returns(T::Boolean) }
  def file_ignored_by_sorbet?(config, file_path); end

  sig { params(path: ::Pathname).returns(T::Array[::String]) }
  def path_parts(path); end
end

module Tapioca::Static::SymbolLoader
  extend ::Tapioca::SorbetHelper
  extend ::Tapioca::Runtime::Reflection

  class << self
    sig { returns(T::Set[::String]) }
    def engine_symbols; end

    sig { params(gem: ::Tapioca::Gemfile::GemSpec).returns(T::Set[::String]) }
    def gem_symbols(gem); end

    sig { returns(T::Set[::String]) }
    def payload_symbols; end

    private

    sig { returns(T::Set[::String]) }
    def load_engine_symbols; end

    sig { params(input: ::String, table_type: ::String).returns(::String) }
    def symbol_table_json_from(input, table_type: T.unsafe(nil)); end

    sig { params(paths: T::Array[::Pathname]).returns(T::Set[::String]) }
    def symbols_from_paths(paths); end
  end
end

class Tapioca::Static::SymbolTableParser
  sig { void }
  def initialize; end

  sig { params(name: ::String).returns(::String) }
  def fully_qualified_name(name); end

  sig { params(object: T::Hash[::String, T.untyped]).void }
  def parse_object(object); end

  sig { returns(T::Set[::String]) }
  def symbols; end

  class << self
    sig { params(json_string: ::String).returns(T::Set[::String]) }
    def parse_json(json_string); end
  end
end

Tapioca::TAPIOCA_CONFIG_FILE = T.let(T.unsafe(nil), String)
Tapioca::TAPIOCA_DIR = T.let(T.unsafe(nil), String)

class Tapioca::TypeVariable < ::T::Types::TypeVariable
  def initialize(name, variance); end

  def name; end
end

module Tapioca::TypeVariableHelper
  extend ::Tapioca::SorbetHelper

  class << self
    sig do
      params(
        type: ::String,
        variance: ::Symbol,
        fixed: T.nilable(::String),
        upper: T.nilable(::String),
        lower: T.nilable(::String)
      ).returns(::String)
    end
    def serialize_type_variable(type, variance, fixed, upper, lower); end
  end
end

class Tapioca::TypeVariableModule < ::Module
  sig do
    params(
      context: ::Module,
      type: ::Tapioca::TypeVariableModule::Type,
      variance: ::Symbol,
      fixed: T.untyped,
      lower: T.untyped,
      upper: T.untyped,
      bounds_proc: T.nilable(T.proc.returns(T::Hash[::Symbol, T.untyped]))
    ).void
  end
  def initialize(context, type, variance, fixed, lower, upper, bounds_proc); end

  sig { returns(::Tapioca::TypeVariable) }
  def coerce_to_type_variable; end

  sig { returns(T.nilable(::String)) }
  def name; end

  sig { returns(::String) }
  def serialize; end

  private

  sig do
    params(
      fixed: T.untyped,
      lower: T.untyped,
      upper: T.untyped
    ).returns(T.proc.returns(T::Hash[::Symbol, T.untyped]))
  end
  def build_bounds_proc(fixed, lower, upper); end

  sig do
    type_parameters(:Result)
      .params(
        block: T.proc.returns(T.type_parameter(:Result))
      ).returns(T.type_parameter(:Result))
  end
  def with_bound_name_pre_3_0(&block); end
end

class Tapioca::TypeVariableModule::Type < ::T::Enum
  enums do
    Member = new
    Template = new
  end
end

Tapioca::VERSION = T.let(T.unsafe(nil), String)
