# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `rack` gem.
# Please instead update this file by running `bin/tapioca gem rack`.

module Rack
  class << self
    def release; end
    def version; end
  end
end

module Rack::Auth; end

class Rack::Auth::AbstractHandler
  def initialize(app, realm = T.unsafe(nil), &authenticator); end

  def realm; end
  def realm=(_arg0); end

  private

  def bad_request; end
  def unauthorized(www_authenticate = T.unsafe(nil)); end
end

class Rack::Auth::AbstractRequest
  def initialize(env); end

  def params; end
  def parts; end
  def provided?; end
  def request; end
  def scheme; end
  def valid?; end

  private

  def authorization_key; end
end

Rack::Auth::AbstractRequest::AUTHORIZATION_KEYS = T.let(T.unsafe(nil), Array)

class Rack::Auth::Basic < ::Rack::Auth::AbstractHandler
  def call(env); end

  private

  def challenge; end
  def valid?(auth); end
end

class Rack::Auth::Basic::Request < ::Rack::Auth::AbstractRequest
  def basic?; end
  def credentials; end
  def username; end
end

module Rack::Auth::Digest; end

class Rack::Auth::Digest::MD5 < ::Rack::Auth::AbstractHandler
  def initialize(app, realm = T.unsafe(nil), opaque = T.unsafe(nil), &authenticator); end

  def call(env); end
  def opaque; end
  def opaque=(_arg0); end
  def passwords_hashed=(_arg0); end
  def passwords_hashed?; end

  private

  def A1(auth, password); end
  def A2(auth); end
  def H(data); end
  def KD(secret, data); end
  def challenge(hash = T.unsafe(nil)); end
  def digest(auth, password); end
  def md5(data); end
  def params(hash = T.unsafe(nil)); end
  def valid?(auth); end
  def valid_digest?(auth); end
  def valid_nonce?(auth); end
  def valid_opaque?(auth); end
  def valid_qop?(auth); end
end

Rack::Auth::Digest::MD5::QOP = T.let(T.unsafe(nil), String)

class Rack::Auth::Digest::Nonce
  def initialize(timestamp = T.unsafe(nil), given_digest = T.unsafe(nil)); end

  def digest; end
  def fresh?; end
  def stale?; end
  def to_s; end
  def valid?; end

  class << self
    def parse(string); end
    def private_key; end
    def private_key=(_arg0); end
    def time_limit; end
    def time_limit=(_arg0); end
  end
end

class Rack::Auth::Digest::Params < ::Hash
  def initialize; end

  def [](k); end
  def []=(k, v); end
  def quote(str); end
  def to_s; end

  class << self
    def dequote(str); end
    def parse(str); end
    def split_header_value(str); end
  end
end

Rack::Auth::Digest::Params::UNQUOTED = T.let(T.unsafe(nil), Array)

class Rack::Auth::Digest::Request < ::Rack::Auth::AbstractRequest
  def correct_uri?; end
  def digest?; end
  def method; end
  def method_missing(sym, *args); end
  def nonce; end
  def params; end
  def respond_to?(sym, *_arg1); end
end

class Rack::BodyProxy
  def initialize(body, &block); end

  def close; end
  def closed?; end
  def method_missing(method_name, *args, &block); end

  private

  def respond_to_missing?(method_name, include_all = T.unsafe(nil)); end
end

class Rack::Builder
  def initialize(default_app = T.unsafe(nil), &block); end

  def call(env); end
  def freeze_app; end
  def map(path, &block); end
  def run(app = T.unsafe(nil), &block); end
  def to_app; end
  def use(middleware, *args, &block); end
  def warmup(prc = T.unsafe(nil), &block); end

  private

  def generate_map(default_app, mapping); end

  class << self
    def app(default_app = T.unsafe(nil), &block); end
    def load_file(path); end
    def new_from_string(builder_script, file = T.unsafe(nil)); end
    def parse_file(path); end
  end
end

Rack::Builder::UTF_8_BOM = T.let(T.unsafe(nil), String)
Rack::CACHE_CONTROL = T.let(T.unsafe(nil), String)
Rack::CONTENT_LENGTH = T.let(T.unsafe(nil), String)
Rack::CONTENT_TYPE = T.let(T.unsafe(nil), String)

class Rack::Cascade
  def initialize(apps, cascade_for = T.unsafe(nil)); end

  def <<(app); end
  def add(app); end
  def apps; end
  def call(env); end
  def include?(app); end
end

Rack::Cascade::NotFound = T.let(T.unsafe(nil), Array)

class Rack::Chunked
  include ::Rack::Utils

  def initialize(app); end

  def call(env); end
  def chunkable_version?(ver); end
end

class Rack::Chunked::Body
  def initialize(body); end

  def close; end
  def each(&block); end

  private

  def yield_trailers; end
end

Rack::Chunked::Body::TAIL = T.let(T.unsafe(nil), String)
Rack::Chunked::Body::TERM = T.let(T.unsafe(nil), String)

class Rack::Chunked::TrailerBody < ::Rack::Chunked::Body
  private

  def yield_trailers; end
end

class Rack::CommonLogger
  def initialize(app, logger = T.unsafe(nil)); end

  def call(env); end

  private

  def extract_content_length(headers); end
  def log(env, status, response_headers, began_at); end
end

Rack::CommonLogger::FORMAT = T.let(T.unsafe(nil), String)

class Rack::ConditionalGet
  def initialize(app); end

  def call(env); end

  private

  def etag_matches?(none_match, headers); end
  def fresh?(env, headers); end
  def modified_since?(modified_since, headers); end
  def to_rfc2822(since); end
end

class Rack::Config
  def initialize(app, &block); end

  def call(env); end
end

class Rack::ContentLength
  include ::Rack::Utils

  def initialize(app); end

  def call(env); end
end

class Rack::ContentType
  include ::Rack::Utils

  def initialize(app, content_type = T.unsafe(nil)); end

  def call(env); end
end

Rack::DELETE = T.let(T.unsafe(nil), String)

class Rack::Deflater
  def initialize(app, options = T.unsafe(nil)); end

  def call(env); end

  private

  def should_deflate?(env, status, headers, body); end
end

class Rack::Deflater::GzipStream
  def initialize(body, mtime, sync); end

  def close; end
  def each(&block); end
  def write(data); end
end

Rack::Deflater::GzipStream::BUFFER_LENGTH = T.let(T.unsafe(nil), Integer)

class Rack::Directory
  def initialize(root, app = T.unsafe(nil)); end

  def call(env); end
  def check_bad_request(path_info); end
  def check_forbidden(path_info); end
  def entity_not_found(path_info); end
  def filesize_format(int); end
  def get(env); end
  def list_directory(path_info, path, script_name); end
  def list_path(env, path, path_info, script_name); end
  def root; end
  def stat(path); end
end

Rack::Directory::DIR_FILE = T.let(T.unsafe(nil), String)
Rack::Directory::DIR_PAGE_FOOTER = T.let(T.unsafe(nil), String)
Rack::Directory::DIR_PAGE_HEADER = T.let(T.unsafe(nil), String)

class Rack::Directory::DirectoryBody < ::Struct
  def each; end

  private

  def DIR_FILE_escape(htmls); end
end

Rack::Directory::FILESIZE_FORMAT = T.let(T.unsafe(nil), Array)
Rack::ETAG = T.let(T.unsafe(nil), String)

class Rack::ETag
  def initialize(app, no_cache_control = T.unsafe(nil), cache_control = T.unsafe(nil)); end

  def call(env); end

  private

  def digest_body(body); end
  def etag_status?(status); end
  def skip_caching?(headers); end
end

Rack::ETag::DEFAULT_CACHE_CONTROL = T.let(T.unsafe(nil), String)
Rack::ETag::ETAG_STRING = T.let(T.unsafe(nil), String)
Rack::EXPIRES = T.let(T.unsafe(nil), String)

class Rack::Events
  def initialize(app, handlers); end

  def call(env); end

  private

  def make_request(env); end
  def make_response(status, headers, body); end
  def on_commit(request, response); end
  def on_error(request, response, e); end
  def on_finish(request, response); end
  def on_start(request, response); end
end

module Rack::Events::Abstract
  def on_commit(req, res); end
  def on_error(req, res, e); end
  def on_finish(req, res); end
  def on_send(req, res); end
  def on_start(req, res); end
end

class Rack::Events::BufferedResponse < ::Rack::Response::Raw
  def initialize(status, headers, body); end

  def body; end
  def to_a; end
end

class Rack::Events::EventedBodyProxy < ::Rack::BodyProxy
  def initialize(body, request, response, handlers, &block); end

  def each; end
  def request; end
  def response; end
end

Rack::File = Rack::Files

class Rack::Files
  def initialize(root, headers = T.unsafe(nil), default_mime = T.unsafe(nil)); end

  def call(env); end
  def get(env); end
  def root; end
  def serving(request, path); end

  private

  def fail(status, body, headers = T.unsafe(nil)); end
  def filesize(path); end
  def mime_type(path, default_mime); end
end

Rack::Files::ALLOWED_VERBS = T.let(T.unsafe(nil), Array)
Rack::Files::ALLOW_HEADER = T.let(T.unsafe(nil), String)

class Rack::Files::BaseIterator
  def initialize(path, ranges, options); end

  def bytesize; end
  def close; end
  def each; end
  def options; end
  def path; end
  def ranges; end

  private

  def each_range_part(file, range); end
  def multipart?; end
  def multipart_heading(range); end
end

class Rack::Files::Iterator < ::Rack::Files::BaseIterator
  def to_path; end
end

Rack::Files::MULTIPART_BOUNDARY = T.let(T.unsafe(nil), String)

class Rack::ForwardRequest < ::Exception
  def initialize(url, env = T.unsafe(nil)); end

  def env; end
  def url; end
end

Rack::GET = T.let(T.unsafe(nil), String)
Rack::HEAD = T.let(T.unsafe(nil), String)
Rack::HTTPS = T.let(T.unsafe(nil), String)
Rack::HTTP_COOKIE = T.let(T.unsafe(nil), String)
Rack::HTTP_HOST = T.let(T.unsafe(nil), String)
Rack::HTTP_PORT = T.let(T.unsafe(nil), String)

class Rack::Head
  def initialize(app); end

  def call(env); end
end

class Rack::Headers < ::Hash
  def [](key); end
  def []=(key, value); end
  def assoc(key); end
  def compare_by_identity; end
  def delete(key); end
  def dig(key, *a); end
  def fetch(key, *default, &block); end
  def fetch_values(*a); end
  def has_key?(key); end
  def include?(key); end
  def invert; end
  def key?(key); end
  def member?(key); end
  def merge(hash, &block); end
  def merge!(hash, &block); end
  def reject(&block); end
  def replace(hash); end
  def select(&block); end
  def slice(*a); end
  def store(key, value); end
  def to_proc; end
  def transform_keys(&block); end
  def transform_keys!; end
  def transform_values(&block); end
  def update(hash, &block); end
  def values_at(*keys); end

  private

  def downcase_key(key); end

  class << self
    def [](*items); end
  end
end

Rack::LINK = T.let(T.unsafe(nil), String)

class Rack::Lint
  def initialize(app); end

  def call(env = T.unsafe(nil)); end
end

class Rack::Lint::LintError < ::RuntimeError; end

class Rack::Lint::Wrapper
  def initialize(app, env); end

  def call(stream); end
  def check_content_length(status, headers); end
  def check_content_type(status, headers); end
  def check_environment(env); end
  def check_error(error); end
  def check_header_value(key, value); end
  def check_headers(headers); end
  def check_hijack(env); end
  def check_hijack_response(headers, env); end
  def check_input(input); end
  def check_status(status); end
  def close; end
  def each; end
  def respond_to?(name, *_arg1); end
  def response; end
  def to_ary; end
  def to_path; end
  def verify_content_length(size); end
  def verify_to_path; end
end

Rack::Lint::Wrapper::BODY_METHODS = T.let(T.unsafe(nil), Hash)

class Rack::Lint::Wrapper::ErrorWrapper
  def initialize(error); end

  def close(*args); end
  def flush; end
  def puts(str); end
  def write(str); end
end

class Rack::Lint::Wrapper::InputWrapper
  def initialize(input); end

  def close(*args); end
  def each(*args); end
  def gets(*args); end
  def read(*args); end
end

class Rack::Lint::Wrapper::StreamWrapper
  extend ::Forwardable

  def initialize(stream); end

  def <<(*args, &block); end
  def close(*args, &block); end
  def close_read(*args, &block); end
  def close_write(*args, &block); end
  def closed?(*args, &block); end
  def flush(*args, &block); end
  def read(*args, &block); end
  def write(*args, &block); end
end

Rack::Lint::Wrapper::StreamWrapper::REQUIRED_METHODS = T.let(T.unsafe(nil), Array)

class Rack::Lock
  def initialize(app, mutex = T.unsafe(nil)); end

  def call(env); end

  private

  def unlock; end
end

class Rack::Logger
  def initialize(app, level = T.unsafe(nil)); end

  def call(env); end
end

class Rack::MediaType
  class << self
    def params(content_type); end
    def type(content_type); end

    private

    def strip_doublequotes(str); end
  end
end

Rack::MediaType::SPLIT_PATTERN = T.let(T.unsafe(nil), Regexp)

class Rack::MethodOverride
  def initialize(app); end

  def call(env); end
  def method_override(env); end

  private

  def allowed_methods; end
  def method_override_param(req); end
end

Rack::MethodOverride::ALLOWED_METHODS = T.let(T.unsafe(nil), Array)
Rack::MethodOverride::HTTP_METHODS = T.let(T.unsafe(nil), Array)
Rack::MethodOverride::HTTP_METHOD_OVERRIDE_HEADER = T.let(T.unsafe(nil), String)
Rack::MethodOverride::METHOD_OVERRIDE_PARAM_KEY = T.let(T.unsafe(nil), String)

module Rack::Mime
  private

  def match?(value, matcher); end
  def mime_type(ext, fallback = T.unsafe(nil)); end

  class << self
    def match?(value, matcher); end
    def mime_type(ext, fallback = T.unsafe(nil)); end
  end
end

Rack::Mime::MIME_TYPES = T.let(T.unsafe(nil), Hash)

class Rack::MockRequest
  def initialize(app); end

  def delete(uri, opts = T.unsafe(nil)); end
  def get(uri, opts = T.unsafe(nil)); end
  def head(uri, opts = T.unsafe(nil)); end
  def options(uri, opts = T.unsafe(nil)); end
  def patch(uri, opts = T.unsafe(nil)); end
  def post(uri, opts = T.unsafe(nil)); end
  def put(uri, opts = T.unsafe(nil)); end
  def request(method = T.unsafe(nil), uri = T.unsafe(nil), opts = T.unsafe(nil)); end

  class << self
    def env_for(uri = T.unsafe(nil), opts = T.unsafe(nil)); end
    def parse_uri_rfc2396(uri); end
  end
end

Rack::MockRequest::DEFAULT_ENV = T.let(T.unsafe(nil), Hash)

class Rack::MockRequest::FatalWarner
  def flush; end
  def puts(warning); end
  def string; end
  def write(warning); end
end

class Rack::MockRequest::FatalWarning < ::RuntimeError; end

class Rack::MockResponse < ::Rack::Response
  def initialize(status, headers, body, errors = T.unsafe(nil)); end

  def =~(other); end
  def body; end
  def cookie(name); end
  def cookies; end
  def empty?; end
  def errors; end
  def errors=(_arg0); end
  def match(other); end
  def original_headers; end

  private

  def identify_cookie_attributes(cookie_filling); end
  def parse_cookies_from_header; end

  class << self
    def [](*_arg0); end
  end
end

module Rack::Multipart
  class << self
    def build_multipart(params, first = T.unsafe(nil)); end
    def extract_multipart(request, params = T.unsafe(nil)); end
    def parse_multipart(env, params = T.unsafe(nil)); end
  end
end

Rack::Multipart::ATTRIBUTE = T.let(T.unsafe(nil), Regexp)
Rack::Multipart::ATTRIBUTE_CHAR = T.let(T.unsafe(nil), Regexp)
Rack::Multipart::BROKEN = T.let(T.unsafe(nil), Regexp)
Rack::Multipart::CONDISP = T.let(T.unsafe(nil), Regexp)
Rack::Multipart::DISPPARM = T.let(T.unsafe(nil), Regexp)
Rack::Multipart::EOL = T.let(T.unsafe(nil), String)
Rack::Multipart::EXTENDED_INITIAL_NAME = T.let(T.unsafe(nil), Regexp)
Rack::Multipart::EXTENDED_INITIAL_PARAMETER = T.let(T.unsafe(nil), Regexp)
Rack::Multipart::EXTENDED_INITIAL_VALUE = T.let(T.unsafe(nil), Regexp)
Rack::Multipart::EXTENDED_OTHER_NAME = T.let(T.unsafe(nil), Regexp)
Rack::Multipart::EXTENDED_OTHER_PARAMETER = T.let(T.unsafe(nil), Regexp)
Rack::Multipart::EXTENDED_OTHER_VALUE = T.let(T.unsafe(nil), Regexp)
Rack::Multipart::EXTENDED_PARAMETER = T.let(T.unsafe(nil), Regexp)
class Rack::Multipart::EmptyContentError < ::EOFError; end
class Rack::Multipart::Error < ::StandardError; end

class Rack::Multipart::Generator
  def initialize(params, first = T.unsafe(nil)); end

  def dump; end

  private

  def content_for_other(file, name); end
  def content_for_tempfile(io, file, name); end
  def flattened_params; end
  def multipart?; end
end

Rack::Multipart::MULTIPART = T.let(T.unsafe(nil), Regexp)
Rack::Multipart::MULTIPART_BOUNDARY = T.let(T.unsafe(nil), String)
Rack::Multipart::MULTIPART_CONTENT_DISPOSITION = T.let(T.unsafe(nil), Regexp)
Rack::Multipart::MULTIPART_CONTENT_ID = T.let(T.unsafe(nil), Regexp)
Rack::Multipart::MULTIPART_CONTENT_TYPE = T.let(T.unsafe(nil), Regexp)
class Rack::Multipart::MultipartPartLimitError < ::Errno::EMFILE; end

class Rack::Multipart::Parser
  def initialize(boundary, tempfile, bufsize, query_parser); end

  def parse(io); end
  def result; end
  def state; end

  private

  def consume_boundary; end
  def dequote(str); end
  def get_filename(head); end
  def handle_consume_token; end
  def handle_empty_content!(content); end
  def handle_fast_forward; end
  def handle_mime_body; end
  def handle_mime_head; end
  def read_data(io, outbuf); end
  def tag_multipart_encoding(filename, content_type, name, body); end

  class << self
    def parse(io, content_length, content_type, tmpfile, bufsize, qp); end
    def parse_boundary(content_type); end
  end
end

Rack::Multipart::Parser::BUFSIZE = T.let(T.unsafe(nil), Integer)

class Rack::Multipart::Parser::BoundedIO
  def initialize(io, content_length); end

  def read(size, outbuf = T.unsafe(nil)); end
end

Rack::Multipart::Parser::CHARSET = T.let(T.unsafe(nil), String)

class Rack::Multipart::Parser::Collector
  include ::Enumerable

  def initialize(tempfile); end

  def each; end
  def on_mime_body(mime_index, content); end
  def on_mime_finish(mime_index); end
  def on_mime_head(mime_index, head, filename, content_type, name); end

  private

  def check_open_files; end
end

class Rack::Multipart::Parser::Collector::BufferPart < ::Rack::Multipart::Parser::Collector::MimePart
  def close; end
  def file?; end
end

class Rack::Multipart::Parser::Collector::MimePart < ::Struct
  def get_data; end
end

class Rack::Multipart::Parser::Collector::TempfilePart < ::Rack::Multipart::Parser::Collector::MimePart
  def close; end
  def file?; end
end

Rack::Multipart::Parser::EMPTY = T.let(T.unsafe(nil), Rack::Multipart::Parser::MultipartInfo)

class Rack::Multipart::Parser::MultipartInfo < ::Struct
  def params; end
  def params=(_); end
  def tmp_files; end
  def tmp_files=(_); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def members; end
    def new(*_arg0); end
  end
end

Rack::Multipart::Parser::TEMPFILE_FACTORY = T.let(T.unsafe(nil), Proc)
Rack::Multipart::Parser::TEXT_PLAIN = T.let(T.unsafe(nil), String)
Rack::Multipart::REGULAR_PARAMETER = T.let(T.unsafe(nil), Regexp)
Rack::Multipart::REGULAR_PARAMETER_NAME = T.let(T.unsafe(nil), Regexp)
Rack::Multipart::RFC2183 = T.let(T.unsafe(nil), Regexp)
Rack::Multipart::SECTION = T.let(T.unsafe(nil), Regexp)
Rack::Multipart::TOKEN = T.let(T.unsafe(nil), Regexp)

class Rack::Multipart::UploadedFile
  def initialize(filepath = T.unsafe(nil), ct = T.unsafe(nil), bin = T.unsafe(nil), path: T.unsafe(nil), content_type: T.unsafe(nil), binary: T.unsafe(nil), filename: T.unsafe(nil), io: T.unsafe(nil)); end

  def content_type; end
  def content_type=(_arg0); end
  def local_path; end
  def method_missing(method_name, *args, &block); end
  def original_filename; end
  def path; end
  def respond_to?(*args); end
end

Rack::Multipart::VALUE = T.let(T.unsafe(nil), Regexp)

class Rack::NullLogger
  def initialize(app); end

  def <<(msg); end
  def add(severity, message = T.unsafe(nil), progname = T.unsafe(nil), &block); end
  def call(env); end
  def close; end
  def datetime_format; end
  def datetime_format=(datetime_format); end
  def debug(progname = T.unsafe(nil), &block); end
  def debug!; end
  def debug?; end
  def error(progname = T.unsafe(nil), &block); end
  def error!; end
  def error?; end
  def fatal(progname = T.unsafe(nil), &block); end
  def fatal!; end
  def fatal?; end
  def formatter; end
  def formatter=(formatter); end
  def info(progname = T.unsafe(nil), &block); end
  def info!; end
  def info?; end
  def level; end
  def level=(level); end
  def log(severity, message = T.unsafe(nil), progname = T.unsafe(nil), &block); end
  def progname; end
  def progname=(progname); end
  def reopen(logdev = T.unsafe(nil)); end
  def sev_threshold; end
  def sev_threshold=(sev_threshold); end
  def unknown(progname = T.unsafe(nil), &block); end
  def warn(progname = T.unsafe(nil), &block); end
  def warn!; end
  def warn?; end
end

Rack::OPTIONS = T.let(T.unsafe(nil), String)
Rack::PATCH = T.let(T.unsafe(nil), String)
Rack::PATH_INFO = T.let(T.unsafe(nil), String)
Rack::POST = T.let(T.unsafe(nil), String)
Rack::PUT = T.let(T.unsafe(nil), String)
Rack::QUERY_STRING = T.let(T.unsafe(nil), String)

class Rack::QueryParser
  def initialize(params_class, _key_space_limit = T.unsafe(nil), param_depth_limit); end

  def make_params; end
  def new_depth_limit(param_depth_limit); end
  def normalize_params(params, name, v, _depth = T.unsafe(nil)); end
  def param_depth_limit; end
  def parse_nested_query(qs, separator = T.unsafe(nil)); end
  def parse_query(qs, separator = T.unsafe(nil), &unescaper); end

  private

  def _normalize_params(params, name, v, depth); end
  def params_hash_has_key?(hash, key); end
  def params_hash_type?(obj); end
  def unescape(s); end

  class << self
    def make_default(_key_space_limit = T.unsafe(nil), param_depth_limit); end
  end
end

Rack::QueryParser::COMMON_SEP = T.let(T.unsafe(nil), Hash)
Rack::QueryParser::DEFAULT_SEP = T.let(T.unsafe(nil), Regexp)
class Rack::QueryParser::InvalidParameterError < ::ArgumentError; end
class Rack::QueryParser::ParameterTypeError < ::TypeError; end

class Rack::QueryParser::Params
  def initialize; end

  def [](key); end
  def []=(key, value); end
  def key?(key); end
  def to_h; end
  def to_params_hash; end
end

class Rack::QueryParser::ParamsTooDeepError < ::RangeError; end
Rack::RACK_ERRORS = T.let(T.unsafe(nil), String)
Rack::RACK_HIJACK = T.let(T.unsafe(nil), String)
Rack::RACK_INPUT = T.let(T.unsafe(nil), String)
Rack::RACK_IS_HIJACK = T.let(T.unsafe(nil), String)
Rack::RACK_LOGGER = T.let(T.unsafe(nil), String)
Rack::RACK_METHODOVERRIDE_ORIGINAL_METHOD = T.let(T.unsafe(nil), String)
Rack::RACK_MULTIPART_BUFFER_SIZE = T.let(T.unsafe(nil), String)
Rack::RACK_MULTIPART_TEMPFILE_FACTORY = T.let(T.unsafe(nil), String)
Rack::RACK_RECURSIVE_INCLUDE = T.let(T.unsafe(nil), String)
Rack::RACK_REQUEST_COOKIE_HASH = T.let(T.unsafe(nil), String)
Rack::RACK_REQUEST_COOKIE_STRING = T.let(T.unsafe(nil), String)
Rack::RACK_REQUEST_FORM_ERROR = T.let(T.unsafe(nil), String)
Rack::RACK_REQUEST_FORM_HASH = T.let(T.unsafe(nil), String)
Rack::RACK_REQUEST_FORM_INPUT = T.let(T.unsafe(nil), String)
Rack::RACK_REQUEST_FORM_VARS = T.let(T.unsafe(nil), String)
Rack::RACK_REQUEST_QUERY_HASH = T.let(T.unsafe(nil), String)
Rack::RACK_REQUEST_QUERY_STRING = T.let(T.unsafe(nil), String)
Rack::RACK_RESPONSE_FINISHED = T.let(T.unsafe(nil), String)
Rack::RACK_SESSION = T.let(T.unsafe(nil), String)
Rack::RACK_SESSION_OPTIONS = T.let(T.unsafe(nil), String)
Rack::RACK_SHOWSTATUS_DETAIL = T.let(T.unsafe(nil), String)
Rack::RACK_TEMPFILES = T.let(T.unsafe(nil), String)
Rack::RACK_URL_SCHEME = T.let(T.unsafe(nil), String)
Rack::RACK_VERSION = T.let(T.unsafe(nil), String)
Rack::RELEASE = T.let(T.unsafe(nil), String)
Rack::REQUEST_METHOD = T.let(T.unsafe(nil), String)
Rack::REQUEST_PATH = T.let(T.unsafe(nil), String)

class Rack::Recursive
  def initialize(app); end

  def _call(env); end
  def call(env); end
  def include(env, path); end
end

class Rack::Reloader
  def initialize(app, cooldown = T.unsafe(nil), backend = T.unsafe(nil)); end

  def call(env); end
  def reload!(stderr = T.unsafe(nil)); end
  def safe_load(file, mtime, stderr = T.unsafe(nil)); end
end

module Rack::Reloader::Stat
  def figure_path(file, paths); end
  def rotation; end
  def safe_stat(file); end
end

class Rack::Request
  include ::Rack::Request::Env
  include ::Rack::Request::Helpers

  def initialize(env); end

  def delete_param(k); end
  def params; end
  def query; end
  def update_param(k, v); end
  def version_supplied; end
  def version_supplied=(_arg0); end
  def xhr?; end

  class << self
    def forwarded_priority; end
    def forwarded_priority=(_arg0); end
    def ip_filter; end
    def ip_filter=(_arg0); end
    def x_forwarded_proto_priority; end
    def x_forwarded_proto_priority=(_arg0); end
  end
end

Rack::Request::ALLOWED_SCHEMES = T.let(T.unsafe(nil), Array)

module Rack::Request::Env
  def initialize(env); end

  def add_header(key, v); end
  def delete_header(name); end
  def each_header(&block); end
  def env; end
  def fetch_header(name, &block); end
  def get_header(name); end
  def has_header?(name); end
  def set_header(name, v); end

  private

  def initialize_copy(other); end
end

module Rack::Request::Helpers
  def GET; end
  def POST; end
  def [](key); end
  def []=(key, value); end
  def accept_encoding; end
  def accept_language; end
  def authority; end
  def base_url; end
  def body; end
  def content_charset; end
  def content_length; end
  def content_type; end
  def cookies; end
  def delete?; end
  def delete_param(k); end
  def form_data?; end
  def forwarded_authority; end
  def forwarded_for; end
  def forwarded_port; end
  def fullpath; end
  def get?; end
  def head?; end
  def host; end
  def host_authority; end
  def host_with_port(authority = T.unsafe(nil)); end
  def hostname; end
  def ip; end
  def link?; end
  def logger; end
  def media_type; end
  def media_type_params; end
  def options?; end
  def params; end
  def parseable_data?; end
  def patch?; end
  def path; end
  def path_info; end
  def path_info=(s); end
  def port; end
  def post?; end
  def put?; end
  def query_string; end
  def referer; end
  def referrer; end
  def request_method; end
  def scheme; end
  def script_name; end
  def script_name=(s); end
  def server_authority; end
  def server_name; end
  def server_port; end
  def session; end
  def session_options; end
  def ssl?; end
  def trace?; end
  def trusted_proxy?(ip); end
  def unlink?; end
  def update_param(k, v); end
  def url; end
  def user_agent; end
  def values_at(*keys); end
  def xhr?; end

  private

  def allowed_scheme(header); end
  def default_session; end
  def forwarded_priority; end
  def forwarded_scheme; end
  def get_http_forwarded(token); end
  def parse_http_accept_header(header); end
  def parse_multipart; end
  def parse_query(qs, d = T.unsafe(nil)); end
  def query_parser; end
  def reject_trusted_ip_addresses(ip_addresses); end
  def split_authority(authority); end
  def split_header(value); end
  def wrap_ipv6(host); end
  def x_forwarded_proto_priority; end
end

Rack::Request::Helpers::AUTHORITY = T.let(T.unsafe(nil), Regexp)
Rack::Request::Helpers::DEFAULT_PORTS = T.let(T.unsafe(nil), Hash)
Rack::Request::Helpers::FORM_DATA_MEDIA_TYPES = T.let(T.unsafe(nil), Array)
Rack::Request::Helpers::FORWARDED_SCHEME_HEADERS = T.let(T.unsafe(nil), Hash)
Rack::Request::Helpers::HTTP_FORWARDED = T.let(T.unsafe(nil), String)
Rack::Request::Helpers::HTTP_X_FORWARDED_FOR = T.let(T.unsafe(nil), String)
Rack::Request::Helpers::HTTP_X_FORWARDED_HOST = T.let(T.unsafe(nil), String)
Rack::Request::Helpers::HTTP_X_FORWARDED_PORT = T.let(T.unsafe(nil), String)
Rack::Request::Helpers::HTTP_X_FORWARDED_PROTO = T.let(T.unsafe(nil), String)
Rack::Request::Helpers::HTTP_X_FORWARDED_SCHEME = T.let(T.unsafe(nil), String)
Rack::Request::Helpers::HTTP_X_FORWARDED_SSL = T.let(T.unsafe(nil), String)
Rack::Request::Helpers::PARSEABLE_DATA_MEDIA_TYPES = T.let(T.unsafe(nil), Array)

class Rack::Response
  include ::Rack::Response::Helpers

  def initialize(body = T.unsafe(nil), status = T.unsafe(nil), headers = T.unsafe(nil)); end

  def [](key); end
  def []=(key, value); end
  def body; end
  def body=(_arg0); end
  def chunked?; end
  def close; end
  def delete_header(key); end
  def each(&callback); end
  def empty?; end
  def finish(&block); end
  def get_header(key); end
  def has_header?(key); end
  def header; end
  def headers; end
  def length; end
  def length=(_arg0); end
  def no_entity_body?; end
  def redirect(target, status = T.unsafe(nil)); end
  def set_header(key, value); end
  def status; end
  def status=(_arg0); end
  def to_a(&block); end
  def write(chunk); end

  class << self
    def [](status, headers, body); end
  end
end

Rack::Response::CHUNKED = T.let(T.unsafe(nil), String)

module Rack::Response::Helpers
  def accepted?; end
  def add_header(key, value); end
  def bad_request?; end
  def cache!(duration = T.unsafe(nil), directive: T.unsafe(nil)); end
  def cache_control; end
  def cache_control=(value); end
  def client_error?; end
  def content_length; end
  def content_type; end
  def content_type=(content_type); end
  def created?; end
  def delete_cookie(key, value = T.unsafe(nil)); end
  def do_not_cache!; end
  def etag; end
  def etag=(value); end
  def forbidden?; end
  def include?(header); end
  def informational?; end
  def invalid?; end
  def location; end
  def location=(location); end
  def media_type; end
  def media_type_params; end
  def method_not_allowed?; end
  def moved_permanently?; end
  def no_content?; end
  def not_acceptable?; end
  def not_found?; end
  def ok?; end
  def precondition_failed?; end
  def redirect?; end
  def redirection?; end
  def request_timeout?; end
  def server_error?; end
  def set_cookie(key, value); end
  def set_cookie_header; end
  def set_cookie_header=(value); end
  def successful?; end
  def unauthorized?; end
  def unprocessable?; end

  protected

  def append(chunk); end
  def buffered_body!; end
end

class Rack::Response::Raw
  include ::Rack::Response::Helpers

  def initialize(status, headers); end

  def delete_header(key); end
  def get_header(key); end
  def has_header?(key); end
  def headers; end
  def set_header(key, value); end
  def status; end
  def status=(_arg0); end
end

Rack::Response::STATUS_WITH_NO_ENTITY_BODY = T.let(T.unsafe(nil), Hash)

class Rack::RewindableInput
  def initialize(io); end

  def close; end
  def each(&block); end
  def gets; end
  def read(*args); end
  def rewind; end
  def size; end

  private

  def filesystem_has_posix_semantics?; end
  def make_rewindable; end
end

class Rack::RewindableInput::Middleware
  def initialize(app); end

  def call(env); end
end

class Rack::Runtime
  def initialize(app, name = T.unsafe(nil)); end

  def call(env); end
end

Rack::Runtime::FORMAT_STRING = T.let(T.unsafe(nil), String)
Rack::Runtime::HEADER_NAME = T.let(T.unsafe(nil), String)
Rack::SCRIPT_NAME = T.let(T.unsafe(nil), String)
Rack::SERVER_NAME = T.let(T.unsafe(nil), String)
Rack::SERVER_PORT = T.let(T.unsafe(nil), String)
Rack::SERVER_PROTOCOL = T.let(T.unsafe(nil), String)
Rack::SET_COOKIE = T.let(T.unsafe(nil), String)

class Rack::Sendfile
  def initialize(app, variation = T.unsafe(nil), mappings = T.unsafe(nil)); end

  def call(env); end

  private

  def map_accel_path(env, path); end
  def variation(env); end
end

class Rack::ShowExceptions
  def initialize(app); end

  def call(env); end
  def dump_exception(exception); end
  def h(obj); end
  def prefers_plaintext?(env); end
  def pretty(env, exception); end
  def template; end

  private

  def accepts_html?(env); end
end

Rack::ShowExceptions::CONTEXT = T.let(T.unsafe(nil), Integer)
Rack::ShowExceptions::TEMPLATE = T.let(T.unsafe(nil), ERB)

class Rack::ShowStatus
  def initialize(app); end

  def call(env); end
  def h(obj); end
end

Rack::ShowStatus::TEMPLATE = T.let(T.unsafe(nil), String)

class Rack::Static
  def initialize(app, options = T.unsafe(nil)); end

  def add_index_root?(path); end
  def applicable_rules(path); end
  def call(env); end
  def can_serve(path); end
  def overwrite_file_path(path); end
  def route_file(path); end
end

Rack::TRACE = T.let(T.unsafe(nil), String)
Rack::TRANSFER_ENCODING = T.let(T.unsafe(nil), String)

class Rack::TempfileReaper
  def initialize(app); end

  def call(env); end
end

Rack::UNLINK = T.let(T.unsafe(nil), String)

class Rack::URLMap
  def initialize(map = T.unsafe(nil)); end

  def call(env); end
  def remap(map); end

  private

  def casecmp?(v1, v2); end
end

module Rack::Utils
  private

  def add_cookie_to_header(header, key, value); end
  def add_remove_cookie_to_header(header, key, value = T.unsafe(nil)); end
  def best_q_match(q_value_header, available_mimes); end
  def build_nested_query(value, prefix = T.unsafe(nil)); end
  def build_query(params); end
  def byte_ranges(env, size); end
  def clean_path_info(path_info); end
  def clock_time; end
  def delete_cookie_header!(headers, key, value = T.unsafe(nil)); end
  def delete_set_cookie_header(key, value = T.unsafe(nil)); end
  def delete_set_cookie_header!(header, key, value = T.unsafe(nil)); end
  def escape(s); end
  def escape_html(string); end
  def escape_path(s); end
  def forwarded_values(forwarded_header); end
  def get_byte_ranges(http_range, size); end
  def make_delete_cookie_header(header, key, value); end
  def parse_cookies(env); end
  def parse_cookies_header(value); end
  def parse_nested_query(qs, d = T.unsafe(nil)); end
  def parse_query(qs, d = T.unsafe(nil), &unescaper); end
  def q_values(q_value_header); end
  def rfc2822(time); end
  def secure_compare(a, b); end
  def select_best_encoding(available_encodings, accept_encoding); end
  def set_cookie_header(key, value); end
  def set_cookie_header!(headers, key, value); end
  def status_code(status); end
  def unescape(s, encoding = T.unsafe(nil)); end
  def unescape_path(s); end
  def valid_path?(path); end

  class << self
    def add_cookie_to_header(header, key, value); end
    def add_remove_cookie_to_header(header, key, value = T.unsafe(nil)); end
    def best_q_match(q_value_header, available_mimes); end
    def build_nested_query(value, prefix = T.unsafe(nil)); end
    def build_query(params); end
    def byte_ranges(env, size); end
    def clean_path_info(path_info); end
    def clock_time; end
    def default_query_parser; end
    def default_query_parser=(_arg0); end
    def delete_cookie_header!(headers, key, value = T.unsafe(nil)); end
    def delete_set_cookie_header(key, value = T.unsafe(nil)); end
    def delete_set_cookie_header!(header, key, value = T.unsafe(nil)); end
    def escape(s); end
    def escape_html(string); end
    def escape_path(s); end
    def forwarded_values(forwarded_header); end
    def get_byte_ranges(http_range, size); end
    def key_space_limit; end
    def key_space_limit=(v); end
    def make_delete_cookie_header(header, key, value); end
    def multipart_part_limit; end
    def multipart_part_limit=(_arg0); end
    def param_depth_limit; end
    def param_depth_limit=(v); end
    def parse_cookies(env); end
    def parse_cookies_header(value); end
    def parse_nested_query(qs, d = T.unsafe(nil)); end
    def parse_query(qs, d = T.unsafe(nil), &unescaper); end
    def q_values(q_value_header); end
    def rfc2822(time); end
    def secure_compare(a, b); end
    def select_best_encoding(available_encodings, accept_encoding); end
    def set_cookie_header(key, value); end
    def set_cookie_header!(headers, key, value); end
    def status_code(status); end
    def unescape(s, encoding = T.unsafe(nil)); end
    def unescape_path(s); end
    def valid_path?(path); end
  end
end

Rack::Utils::COMMON_SEP = T.let(T.unsafe(nil), Hash)

class Rack::Utils::Context
  def initialize(app_f, app_r); end

  def app; end
  def call(env); end
  def context(env, app = T.unsafe(nil)); end
  def for; end
  def recontext(app); end
end

Rack::Utils::DEFAULT_SEP = T.let(T.unsafe(nil), Regexp)
Rack::Utils::ESCAPE_HTML = T.let(T.unsafe(nil), Hash)
Rack::Utils::ESCAPE_HTML_PATTERN = T.let(T.unsafe(nil), Regexp)
Rack::Utils::HTTP_STATUS_CODES = T.let(T.unsafe(nil), Hash)

class Rack::Utils::HeaderHash < ::Hash
  class << self
    def [](headers); end
    def allocate; end
    def new(hash = T.unsafe(nil)); end
  end
end

Rack::Utils::InvalidParameterError = Rack::QueryParser::InvalidParameterError
Rack::Utils::KeySpaceConstrainedParams = Rack::QueryParser::Params
Rack::Utils::NULL_BYTE = T.let(T.unsafe(nil), String)
Rack::Utils::PATH_SEPS = T.let(T.unsafe(nil), Regexp)
Rack::Utils::ParameterTypeError = Rack::QueryParser::ParameterTypeError
Rack::Utils::ParamsTooDeepError = Rack::QueryParser::ParamsTooDeepError
Rack::Utils::STATUS_WITH_NO_ENTITY_BODY = T.let(T.unsafe(nil), Hash)
Rack::Utils::SYMBOL_TO_STATUS_CODE = T.let(T.unsafe(nil), Hash)
Rack::VERSION = T.let(T.unsafe(nil), Array)
Rack::VERSION_STRING = T.let(T.unsafe(nil), String)
