# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `parlour` gem.
# Please instead update this file by running `bin/tapioca gem parlour`.

module Parlour; end

class Parlour::ConflictResolver
  def initialize; end

  sig do
    params(
      namespace: Parlour::RbiGenerator::Namespace,
      resolver: T.proc.params(desc: ::String, choices: T::Array[::Parlour::RbiGenerator::RbiObject]).returns(T.nilable(::Parlour::RbiGenerator::RbiObject))
    ).void
  end
  def resolve_conflicts(namespace, &resolver); end

  private

  sig { params(arr: T::Array[T.untyped]).returns(T::Boolean) }
  def all_eql?(arr); end

  sig { params(namespace: Parlour::RbiGenerator::Namespace, name: T.nilable(::String)).void }
  def deduplicate_mixins_of_name(namespace, name); end

  sig { params(arr: T::Array[T.untyped]).returns(T.nilable(::Symbol)) }
  def merge_strategy(arr); end
end

module Parlour::Conversion; end

class Parlour::Conversion::Converter
  abstract!

  def initialize; end

  sig { params(msg: ::String, node: ::Parlour::RbiGenerator::RbiObject).void }
  def add_warning(msg, node); end

  sig { returns(T::Array[[::String, ::Parlour::TypedObject]]) }
  def warnings; end
end

class Parlour::Conversion::RbiToRbs < ::Parlour::Conversion::Converter
  sig { params(rbs_gen: ::Parlour::RbsGenerator).void }
  def initialize(rbs_gen); end

  sig { params(from: Parlour::RbiGenerator::Namespace, to: Parlour::RbsGenerator::Namespace).void }
  def convert_all(from, to); end

  sig { params(node: ::Parlour::RbiGenerator::RbiObject, new_parent: Parlour::RbsGenerator::Namespace).void }
  def convert_object(node, new_parent); end

  sig { returns(::Parlour::RbsGenerator) }
  def rbs_gen; end
end

module Parlour::Debugging
  class << self
    sig { params(value: T::Boolean).returns(T::Boolean) }
    def debug_mode=(value); end

    sig { returns(T::Boolean) }
    def debug_mode?; end

    sig { params(object: T.untyped, message: ::String).void }
    def debug_puts(object, message); end

    sig { params(object: T.untyped).returns(::String) }
    def name_for_debug_caller(object); end
  end
end

class Parlour::Debugging::Tree
  sig { params(colour: T::Boolean).void }
  def initialize(colour: T.unsafe(nil)); end

  sig { params(message: ::String).returns(::String) }
  def begin(message); end

  sig { returns(T::Boolean) }
  def colour; end

  sig { params(message: ::String).returns(::String) }
  def end(message); end

  sig { params(message: ::String).returns(::String) }
  def here(message); end

  def indent!(offset); end
  def line_prefix; end
  def text_prefix; end
end

Parlour::Debugging::Tree::INDENT_SPACES = T.let(T.unsafe(nil), Integer)

class Parlour::DetachedRbiGenerator < ::Parlour::RbiGenerator
  sig { override.returns(T.nilable(::Parlour::Plugin)) }
  def current_plugin; end

  sig { returns(T.untyped) }
  def detached!; end

  sig { override.returns(::Parlour::Options) }
  def options; end

  sig { override.params(strictness: ::String).returns(::String) }
  def rbi(strictness = T.unsafe(nil)); end
end

class Parlour::DetachedRbsGenerator < ::Parlour::RbsGenerator
  sig { override.returns(T.nilable(::Parlour::Plugin)) }
  def current_plugin; end

  sig { returns(T.untyped) }
  def detached!; end

  sig { override.returns(::Parlour::Options) }
  def options; end

  sig { override.returns(::String) }
  def rbs; end
end

class Parlour::Generator
  sig { params(break_params: ::Integer, tab_size: ::Integer, sort_namespaces: T::Boolean).void }
  def initialize(break_params: T.unsafe(nil), tab_size: T.unsafe(nil), sort_namespaces: T.unsafe(nil)); end

  sig { overridable.returns(T.nilable(::Parlour::Plugin)) }
  def current_plugin; end

  def current_plugin=(_arg0); end

  sig { overridable.returns(::Parlour::Options) }
  def options; end
end

module Parlour::Mixin; end

module Parlour::Mixin::Searchable
  extend T::Generic

  abstract!

  Child = type_member { { upper: Parlour::TypedObject } }

  sig { abstract.returns(T::Array[Child]) }
  def children; end

  sig { params(name: T.nilable(::String), type: T.nilable(::Class)).returns(Child) }
  def find(name: T.unsafe(nil), type: T.unsafe(nil)); end

  sig { params(name: T.nilable(::String), type: T.nilable(::Class)).returns(T::Array[Child]) }
  def find_all(name: T.unsafe(nil), type: T.unsafe(nil)); end

  private

  sig { params(child: Child, name: T.nilable(::String), type: T.nilable(::Class)).returns(T::Boolean) }
  def searchable_child_matches(child, name, type); end
end

class Parlour::Options
  sig { params(break_params: ::Integer, tab_size: ::Integer, sort_namespaces: T::Boolean).void }
  def initialize(break_params:, tab_size:, sort_namespaces:); end

  sig { returns(::Integer) }
  def break_params; end

  sig { params(level: ::Integer, str: ::String).returns(::String) }
  def indented(level, str); end

  sig { returns(T::Boolean) }
  def sort_namespaces; end

  sig { returns(::Integer) }
  def tab_size; end
end

class Parlour::ParseError < ::StandardError
  def initialize(buffer, range); end

  sig { returns(::Parser::Source::Buffer) }
  def buffer; end

  sig { returns(::Parser::Source::Range) }
  def range; end
end

class Parlour::Plugin
  abstract!

  sig { params(options: T::Hash[T.untyped, T.untyped]).void }
  def initialize(options); end

  sig { abstract.params(root: Parlour::RbiGenerator::Namespace).void }
  def generate(root); end

  sig { returns(T.nilable(::String)) }
  def strictness; end

  def strictness=(_arg0); end

  class << self
    sig { params(new_plugin: T.class_of(Parlour::Plugin)).void }
    def inherited(new_plugin); end

    sig { returns(T::Hash[::String, T.class_of(Parlour::Plugin)]) }
    def registered_plugins; end

    sig do
      params(
        plugins: T::Array[::Parlour::Plugin],
        generator: ::Parlour::RbiGenerator,
        allow_failure: T::Boolean
      ).void
    end
    def run_plugins(plugins, generator, allow_failure: T.unsafe(nil)); end
  end
end

class Parlour::RbiGenerator < ::Parlour::Generator
  def initialize(**hash); end

  sig { overridable.params(strictness: ::String).returns(::String) }
  def rbi(strictness = T.unsafe(nil)); end

  sig { overridable.returns(Parlour::RbiGenerator::Namespace) }
  def root; end
end

class Parlour::RbiGenerator::Arbitrary < ::Parlour::RbiGenerator::RbiObject
  sig do
    params(
      generator: ::Parlour::Generator,
      code: ::String,
      block: T.nilable(T.proc.params(x: ::Parlour::RbiGenerator::Arbitrary).void)
    ).void
  end
  def initialize(generator, code: T.unsafe(nil), &block); end

  sig { params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  sig { returns(::String) }
  def code; end

  def code=(_arg0); end

  sig { override.returns(T::Array[T.any(::Symbol, T::Hash[::Symbol, ::String])]) }
  def describe_attrs; end

  sig { override.void }
  def generalize_from_rbi!; end

  sig { override.params(indent_level: ::Integer, options: ::Parlour::Options).returns(T::Array[::String]) }
  def generate_rbi(indent_level, options); end

  sig { override.params(others: T::Array[::Parlour::RbiGenerator::RbiObject]).void }
  def merge_into_self(others); end

  sig { override.params(others: T::Array[::Parlour::RbiGenerator::RbiObject]).returns(T::Boolean) }
  def mergeable?(others); end
end

class Parlour::RbiGenerator::Attribute < ::Parlour::RbiGenerator::Method
  sig do
    params(
      generator: ::Parlour::Generator,
      name: ::String,
      kind: ::Symbol,
      type: T.any(::Parlour::Types::Type, ::String),
      class_attribute: T::Boolean,
      block: T.nilable(T.proc.params(x: ::Parlour::RbiGenerator::Attribute).void)
    ).void
  end
  def initialize(generator, name, kind, type, class_attribute: T.unsafe(nil), &block); end

  sig { override.params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  sig { returns(T::Boolean) }
  def class_attribute; end

  sig { override.returns(T::Array[T.any(::Symbol, T::Hash[::Symbol, ::String])]) }
  def describe_attrs; end

  sig { override.void }
  def generalize_from_rbi!; end

  sig { returns(::Symbol) }
  def kind; end

  sig { returns(T.any(::Parlour::Types::Type, ::String)) }
  def type; end

  private

  sig { override.params(indent_level: ::Integer, options: ::Parlour::Options).returns(T::Array[::String]) }
  def generate_definition(indent_level, options); end
end

class Parlour::RbiGenerator::ClassNamespace < ::Parlour::RbiGenerator::Namespace
  extend T::Generic

  Child = type_member { { fixed: Parlour::RbiGenerator::RbiObject } }

  sig do
    params(
      generator: ::Parlour::Generator,
      name: ::String,
      final: T::Boolean,
      sealed: T::Boolean,
      superclass: T.nilable(::String),
      abstract: T::Boolean,
      block: T.nilable(T.proc.params(x: Parlour::RbiGenerator::ClassNamespace).void)
    ).void
  end
  def initialize(generator, name, final, sealed, superclass, abstract, &block); end

  sig { returns(T::Boolean) }
  def abstract; end

  sig { override.returns(T::Array[T.any(::Symbol, T::Hash[::Symbol, ::String])]) }
  def describe_attrs; end

  sig { override.void }
  def generalize_from_rbi!; end

  sig { override.params(indent_level: ::Integer, options: ::Parlour::Options).returns(T::Array[::String]) }
  def generate_rbi(indent_level, options); end

  sig { override.params(others: T::Array[::Parlour::RbiGenerator::RbiObject]).void }
  def merge_into_self(others); end

  sig { override.params(others: T::Array[::Parlour::RbiGenerator::RbiObject]).returns(T::Boolean) }
  def mergeable?(others); end

  sig { returns(T.nilable(::String)) }
  def superclass; end
end

class Parlour::RbiGenerator::Constant < ::Parlour::RbiGenerator::RbiObject
  sig do
    params(
      generator: ::Parlour::Generator,
      name: ::String,
      value: T.any(::Parlour::Types::Type, ::String),
      eigen_constant: T::Boolean,
      block: T.nilable(T.proc.params(x: ::Parlour::RbiGenerator::Constant).void)
    ).void
  end
  def initialize(generator, name: T.unsafe(nil), value: T.unsafe(nil), eigen_constant: T.unsafe(nil), &block); end

  sig { params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  sig { override.returns(T::Array[T.any(::Symbol, T::Hash[::Symbol, ::String])]) }
  def describe_attrs; end

  def eigen_constant; end

  sig { override.void }
  def generalize_from_rbi!; end

  sig { override.params(indent_level: ::Integer, options: ::Parlour::Options).returns(T::Array[::String]) }
  def generate_rbi(indent_level, options); end

  sig { override.params(others: T::Array[::Parlour::RbiGenerator::RbiObject]).void }
  def merge_into_self(others); end

  sig { override.params(others: T::Array[::Parlour::RbiGenerator::RbiObject]).returns(T::Boolean) }
  def mergeable?(others); end

  sig { returns(T.any(::Parlour::Types::Type, ::String)) }
  def value; end
end

class Parlour::RbiGenerator::EnumClassNamespace < ::Parlour::RbiGenerator::ClassNamespace
  extend T::Generic

  Child = type_member { { fixed: Parlour::RbiGenerator::RbiObject } }

  sig do
    params(
      generator: ::Parlour::Generator,
      name: ::String,
      final: T::Boolean,
      sealed: T::Boolean,
      enums: T::Array[T.any(::String, [::String, ::String])],
      abstract: T::Boolean,
      block: T.nilable(T.proc.params(x: Parlour::RbiGenerator::EnumClassNamespace).void)
    ).void
  end
  def initialize(generator, name, final, sealed, enums, abstract, &block); end

  sig { override.returns(T::Array[T.any(::Symbol, T::Hash[::Symbol, ::String])]) }
  def describe_attrs; end

  sig { returns(T::Array[T.any(::String, [::String, ::String])]) }
  def enums; end

  sig { override.void }
  def generalize_from_rbi!; end

  sig { override.params(indent_level: ::Integer, options: ::Parlour::Options).returns(T::Array[::String]) }
  def generate_body(indent_level, options); end

  sig { override.params(others: T::Array[::Parlour::RbiGenerator::RbiObject]).void }
  def merge_into_self(others); end

  sig { override.params(others: T::Array[::Parlour::RbiGenerator::RbiObject]).returns(T::Boolean) }
  def mergeable?(others); end
end

class Parlour::RbiGenerator::Extend < ::Parlour::RbiGenerator::RbiObject
  sig do
    params(
      generator: ::Parlour::Generator,
      name: ::String,
      block: T.nilable(T.proc.params(x: ::Parlour::RbiGenerator::Extend).void)
    ).void
  end
  def initialize(generator, name: T.unsafe(nil), &block); end

  sig { params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  sig { override.returns(T::Array[T.any(::Symbol, T::Hash[::Symbol, ::String])]) }
  def describe_attrs; end

  sig { override.void }
  def generalize_from_rbi!; end

  sig { override.params(indent_level: ::Integer, options: ::Parlour::Options).returns(T::Array[::String]) }
  def generate_rbi(indent_level, options); end

  sig { override.params(others: T::Array[::Parlour::RbiGenerator::RbiObject]).void }
  def merge_into_self(others); end

  sig { override.params(others: T::Array[::Parlour::RbiGenerator::RbiObject]).returns(T::Boolean) }
  def mergeable?(others); end
end

class Parlour::RbiGenerator::Include < ::Parlour::RbiGenerator::RbiObject
  sig do
    params(
      generator: ::Parlour::Generator,
      name: ::String,
      block: T.nilable(T.proc.params(x: ::Parlour::RbiGenerator::Include).void)
    ).void
  end
  def initialize(generator, name: T.unsafe(nil), &block); end

  sig { params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  sig { override.returns(T::Array[T.any(::Symbol, T::Hash[::Symbol, ::String])]) }
  def describe_attrs; end

  sig { override.void }
  def generalize_from_rbi!; end

  sig { override.params(indent_level: ::Integer, options: ::Parlour::Options).returns(T::Array[::String]) }
  def generate_rbi(indent_level, options); end

  sig { override.params(others: T::Array[::Parlour::RbiGenerator::RbiObject]).void }
  def merge_into_self(others); end

  sig { override.params(others: T::Array[::Parlour::RbiGenerator::RbiObject]).returns(T::Boolean) }
  def mergeable?(others); end
end

class Parlour::RbiGenerator::Method < ::Parlour::RbiGenerator::RbiObject
  sig do
    params(
      generator: ::Parlour::Generator,
      name: ::String,
      parameters: T::Array[::Parlour::RbiGenerator::Parameter],
      return_type: T.nilable(T.any(::Parlour::Types::Type, ::String)),
      abstract: T::Boolean,
      implementation: T::Boolean,
      override: T::Boolean,
      overridable: T::Boolean,
      class_method: T::Boolean,
      final: T::Boolean,
      type_parameters: T.nilable(T::Array[::Symbol]),
      block: T.nilable(T.proc.params(x: ::Parlour::RbiGenerator::Method).void)
    ).void
  end
  def initialize(generator, name, parameters, return_type = T.unsafe(nil), abstract: T.unsafe(nil), implementation: T.unsafe(nil), override: T.unsafe(nil), overridable: T.unsafe(nil), class_method: T.unsafe(nil), final: T.unsafe(nil), type_parameters: T.unsafe(nil), &block); end

  sig { overridable.params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  sig { returns(T::Boolean) }
  def abstract; end

  sig { returns(T::Boolean) }
  def class_method; end

  sig { override.returns(T::Array[T.any(::Symbol, T::Hash[::Symbol, ::String])]) }
  def describe_attrs; end

  sig { returns(T::Boolean) }
  def final; end

  sig { override.void }
  def generalize_from_rbi!; end

  sig { override.params(indent_level: ::Integer, options: ::Parlour::Options).returns(T::Array[::String]) }
  def generate_rbi(indent_level, options); end

  sig { returns(T::Boolean) }
  def implementation; end

  sig { override.params(others: T::Array[::Parlour::RbiGenerator::RbiObject]).void }
  def merge_into_self(others); end

  sig { override.params(others: T::Array[::Parlour::RbiGenerator::RbiObject]).returns(T::Boolean) }
  def mergeable?(others); end

  sig { returns(T::Boolean) }
  def overridable; end

  sig { returns(T::Boolean) }
  def override; end

  sig { returns(T::Array[::Parlour::RbiGenerator::Parameter]) }
  def parameters; end

  sig { returns(T.nilable(T.any(::Parlour::Types::Type, ::String))) }
  def return_type; end

  sig { returns(T::Array[::Symbol]) }
  def type_parameters; end

  private

  sig { overridable.params(indent_level: ::Integer, options: ::Parlour::Options).returns(T::Array[::String]) }
  def generate_definition(indent_level, options); end

  sig { returns(::String) }
  def qualifiers; end
end

class Parlour::RbiGenerator::ModuleNamespace < ::Parlour::RbiGenerator::Namespace
  extend T::Generic

  Child = type_member { { fixed: Parlour::RbiGenerator::RbiObject } }

  sig do
    params(
      generator: ::Parlour::Generator,
      name: ::String,
      final: T::Boolean,
      sealed: T::Boolean,
      interface: T::Boolean,
      abstract: T::Boolean,
      block: T.nilable(T.proc.params(x: Parlour::RbiGenerator::ClassNamespace).void)
    ).void
  end
  def initialize(generator, name, final, sealed, interface, abstract, &block); end

  sig { returns(T::Boolean) }
  def abstract; end

  sig { override.returns(T::Array[T.any(::Symbol, T::Hash[::Symbol, ::String])]) }
  def describe_attrs; end

  sig { override.void }
  def generalize_from_rbi!; end

  sig { override.params(indent_level: ::Integer, options: ::Parlour::Options).returns(T::Array[::String]) }
  def generate_rbi(indent_level, options); end

  sig { returns(T::Boolean) }
  def interface; end

  sig { override.params(others: T::Array[::Parlour::RbiGenerator::RbiObject]).void }
  def merge_into_self(others); end

  sig { override.params(others: T::Array[::Parlour::RbiGenerator::RbiObject]).returns(T::Boolean) }
  def mergeable?(others); end
end

class Parlour::RbiGenerator::Namespace < ::Parlour::RbiGenerator::RbiObject
  extend T::Generic
  include ::Parlour::Mixin::Searchable

  Child = type_member { { fixed: Parlour::RbiGenerator::RbiObject } }

  sig do
    params(
      generator: ::Parlour::Generator,
      name: T.nilable(::String),
      final: T::Boolean,
      sealed: T::Boolean,
      block: T.nilable(T.proc.params(x: Parlour::RbiGenerator::Namespace).void)
    ).void
  end
  def initialize(generator, name = T.unsafe(nil), final = T.unsafe(nil), sealed = T.unsafe(nil), &block); end

  sig { params(comment: T.any(::String, T::Array[::String])).void }
  def add_comment_to_next_child(comment); end

  sig { returns(T::Array[::Parlour::RbiGenerator::TypeAlias]) }
  def aliases; end

  sig { override.returns(T::Array[::Parlour::RbiGenerator::RbiObject]) }
  def children; end

  sig { returns(T::Array[::Parlour::RbiGenerator::Constant]) }
  def constants; end

  def create_arbitrary(code:, &block); end
  def create_attr(*args, &blk); end

  sig do
    params(
      name: ::String,
      type: T.any(::Parlour::Types::Type, ::String),
      class_attribute: T::Boolean,
      block: T.nilable(T.proc.params(x: ::Parlour::RbiGenerator::Attribute).void)
    ).returns(::Parlour::RbiGenerator::Attribute)
  end
  def create_attr_accessor(name, type:, class_attribute: T.unsafe(nil), &block); end

  sig do
    params(
      name: ::String,
      type: T.any(::Parlour::Types::Type, ::String),
      class_attribute: T::Boolean,
      block: T.nilable(T.proc.params(x: ::Parlour::RbiGenerator::Attribute).void)
    ).returns(::Parlour::RbiGenerator::Attribute)
  end
  def create_attr_reader(name, type:, class_attribute: T.unsafe(nil), &block); end

  sig do
    params(
      name: ::String,
      type: T.any(::Parlour::Types::Type, ::String),
      class_attribute: T::Boolean,
      block: T.nilable(T.proc.params(x: ::Parlour::RbiGenerator::Attribute).void)
    ).returns(::Parlour::RbiGenerator::Attribute)
  end
  def create_attr_writer(name, type:, class_attribute: T.unsafe(nil), &block); end

  sig do
    params(
      name: ::String,
      kind: ::Symbol,
      type: T.any(::Parlour::Types::Type, ::String),
      class_attribute: T::Boolean,
      block: T.nilable(T.proc.params(x: ::Parlour::RbiGenerator::Attribute).void)
    ).returns(::Parlour::RbiGenerator::Attribute)
  end
  def create_attribute(name, kind:, type:, class_attribute: T.unsafe(nil), &block); end

  sig do
    params(
      name: ::String,
      final: T::Boolean,
      sealed: T::Boolean,
      superclass: T.nilable(::String),
      abstract: T::Boolean,
      block: T.nilable(T.proc.params(x: Parlour::RbiGenerator::ClassNamespace).void)
    ).returns(Parlour::RbiGenerator::ClassNamespace)
  end
  def create_class(name, final: T.unsafe(nil), sealed: T.unsafe(nil), superclass: T.unsafe(nil), abstract: T.unsafe(nil), &block); end

  sig do
    params(
      name: ::String,
      value: ::String,
      eigen_constant: T::Boolean,
      block: T.nilable(T.proc.params(x: ::Parlour::RbiGenerator::Constant).void)
    ).returns(::Parlour::RbiGenerator::Constant)
  end
  def create_constant(name, value:, eigen_constant: T.unsafe(nil), &block); end

  sig do
    params(
      name: ::String,
      final: T::Boolean,
      sealed: T::Boolean,
      enums: T.nilable(T::Array[T.any(::String, [::String, ::String])]),
      abstract: T::Boolean,
      block: T.nilable(T.proc.params(x: Parlour::RbiGenerator::EnumClassNamespace).void)
    ).returns(Parlour::RbiGenerator::EnumClassNamespace)
  end
  def create_enum_class(name, final: T.unsafe(nil), sealed: T.unsafe(nil), enums: T.unsafe(nil), abstract: T.unsafe(nil), &block); end

  sig do
    params(
      name: ::String,
      block: T.nilable(T.proc.params(x: ::Parlour::RbiGenerator::Extend).void)
    ).returns(::Parlour::RbiGenerator::Extend)
  end
  def create_extend(name, &block); end

  sig { params(extendables: T::Array[::String]).returns(T::Array[::Parlour::RbiGenerator::Extend]) }
  def create_extends(extendables); end

  sig do
    params(
      name: ::String,
      block: T.nilable(T.proc.params(x: ::Parlour::RbiGenerator::Include).void)
    ).returns(::Parlour::RbiGenerator::Include)
  end
  def create_include(name, &block); end

  sig { params(includables: T::Array[::String]).returns(T::Array[::Parlour::RbiGenerator::Include]) }
  def create_includes(includables); end

  sig do
    params(
      name: ::String,
      parameters: T.nilable(T::Array[::Parlour::RbiGenerator::Parameter]),
      return_type: T.nilable(T.any(::Parlour::Types::Type, ::String)),
      returns: T.nilable(T.any(::Parlour::Types::Type, ::String)),
      abstract: T::Boolean,
      implementation: T::Boolean,
      override: T::Boolean,
      overridable: T::Boolean,
      class_method: T::Boolean,
      final: T::Boolean,
      type_parameters: T.nilable(T::Array[::Symbol]),
      block: T.nilable(T.proc.params(x: ::Parlour::RbiGenerator::Method).void)
    ).returns(::Parlour::RbiGenerator::Method)
  end
  def create_method(name, parameters: T.unsafe(nil), return_type: T.unsafe(nil), returns: T.unsafe(nil), abstract: T.unsafe(nil), implementation: T.unsafe(nil), override: T.unsafe(nil), overridable: T.unsafe(nil), class_method: T.unsafe(nil), final: T.unsafe(nil), type_parameters: T.unsafe(nil), &block); end

  sig do
    params(
      name: ::String,
      final: T::Boolean,
      sealed: T::Boolean,
      interface: T::Boolean,
      abstract: T::Boolean,
      block: T.nilable(T.proc.params(x: Parlour::RbiGenerator::ClassNamespace).void)
    ).returns(Parlour::RbiGenerator::ModuleNamespace)
  end
  def create_module(name, final: T.unsafe(nil), sealed: T.unsafe(nil), interface: T.unsafe(nil), abstract: T.unsafe(nil), &block); end

  sig do
    params(
      name: ::String,
      final: T::Boolean,
      sealed: T::Boolean,
      props: T.nilable(T::Array[::Parlour::RbiGenerator::StructProp]),
      abstract: T::Boolean,
      block: T.nilable(T.proc.params(x: Parlour::RbiGenerator::StructClassNamespace).void)
    ).returns(Parlour::RbiGenerator::StructClassNamespace)
  end
  def create_struct_class(name, final: T.unsafe(nil), sealed: T.unsafe(nil), props: T.unsafe(nil), abstract: T.unsafe(nil), &block); end

  sig do
    params(
      name: ::String,
      type: T.any(::Parlour::Types::Type, ::String),
      block: T.nilable(T.proc.params(x: ::Parlour::RbiGenerator::TypeAlias).void)
    ).returns(::Parlour::RbiGenerator::TypeAlias)
  end
  def create_type_alias(name, type:, &block); end

  sig { override.returns(T::Array[T.any(::Symbol, T::Hash[::Symbol, ::String])]) }
  def describe_attrs; end

  sig { returns(T::Array[::Parlour::RbiGenerator::Extend]) }
  def extends; end

  sig { returns(T::Boolean) }
  def final; end

  sig { override.void }
  def generalize_from_rbi!; end

  sig { override.overridable.params(indent_level: ::Integer, options: ::Parlour::Options).returns(T::Array[::String]) }
  def generate_rbi(indent_level, options); end

  sig { returns(T::Array[::Parlour::RbiGenerator::Include]) }
  def includes; end

  sig { override.overridable.params(others: T::Array[::Parlour::RbiGenerator::RbiObject]).void }
  def merge_into_self(others); end

  sig { override.overridable.params(others: T::Array[::Parlour::RbiGenerator::RbiObject]).returns(T::Boolean) }
  def mergeable?(others); end

  sig { params(constant: ::Module, block: T.proc.params(x: Parlour::RbiGenerator::Namespace).void).void }
  def path(constant, &block); end

  sig { returns(T::Boolean) }
  def sealed; end

  def type_aliases(*args, &blk); end

  private

  sig { overridable.params(indent_level: ::Integer, options: ::Parlour::Options).returns(T::Array[::String]) }
  def generate_body(indent_level, options); end

  sig { params(object: ::Parlour::RbiGenerator::RbiObject).void }
  def move_next_comments(object); end
end

Parlour::RbiGenerator::Options = Parlour::Options

class Parlour::RbiGenerator::Parameter
  sig do
    params(
      name: ::String,
      type: T.nilable(T.any(::Parlour::Types::Type, ::String)),
      default: T.nilable(::String)
    ).void
  end
  def initialize(name, type: T.unsafe(nil), default: T.unsafe(nil)); end

  sig { params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  sig { returns(T.nilable(::String)) }
  def default; end

  sig { returns(::String) }
  def describe_in_method; end

  sig { void }
  def generalize_from_rbi!; end

  sig { returns(::Symbol) }
  def kind; end

  sig { returns(::String) }
  def name; end

  sig { returns(::String) }
  def name_without_kind; end

  sig { returns(::String) }
  def to_def_param; end

  sig { returns(::String) }
  def to_sig_param; end

  sig { returns(T.any(::Parlour::Types::Type, ::String)) }
  def type; end
end

Parlour::RbiGenerator::Parameter::PREFIXES = T.let(T.unsafe(nil), Hash)

class Parlour::RbiGenerator::RbiObject < ::Parlour::TypedObject
  abstract!

  sig { params(generator: ::Parlour::Generator, name: ::String).void }
  def initialize(generator, name); end

  sig { abstract.void }
  def generalize_from_rbi!; end

  sig { abstract.params(indent_level: ::Integer, options: ::Parlour::Options).returns(T::Array[::String]) }
  def generate_rbi(indent_level, options); end

  sig { returns(::Parlour::Generator) }
  def generator; end

  sig { abstract.params(others: T::Array[::Parlour::RbiGenerator::RbiObject]).void }
  def merge_into_self(others); end

  sig { abstract.params(others: T::Array[::Parlour::RbiGenerator::RbiObject]).returns(T::Boolean) }
  def mergeable?(others); end
end

class Parlour::RbiGenerator::StructClassNamespace < ::Parlour::RbiGenerator::ClassNamespace
  extend T::Generic

  Child = type_member { { fixed: Parlour::RbiGenerator::RbiObject } }

  sig do
    params(
      generator: ::Parlour::Generator,
      name: ::String,
      final: T::Boolean,
      sealed: T::Boolean,
      props: T::Array[::Parlour::RbiGenerator::StructProp],
      abstract: T::Boolean,
      block: T.nilable(T.proc.params(x: Parlour::RbiGenerator::StructClassNamespace).void)
    ).void
  end
  def initialize(generator, name, final, sealed, props, abstract, &block); end

  sig { override.returns(T::Array[T.any(::Symbol, T::Hash[::Symbol, ::String])]) }
  def describe_attrs; end

  sig { override.void }
  def generalize_from_rbi!; end

  sig { override.params(indent_level: ::Integer, options: ::Parlour::Options).returns(T::Array[::String]) }
  def generate_body(indent_level, options); end

  sig { override.params(others: T::Array[::Parlour::RbiGenerator::RbiObject]).void }
  def merge_into_self(others); end

  sig { override.params(others: T::Array[::Parlour::RbiGenerator::RbiObject]).returns(T::Boolean) }
  def mergeable?(others); end

  sig { returns(T::Array[::Parlour::RbiGenerator::StructProp]) }
  def props; end
end

class Parlour::RbiGenerator::StructProp
  sig do
    params(
      name: ::String,
      type: T.any(::Parlour::Types::Type, ::String),
      optional: T.nilable(T.any(::Symbol, T::Boolean)),
      enum: T.nilable(::String),
      dont_store: T.nilable(T::Boolean),
      foreign: T.nilable(::String),
      default: T.nilable(::String),
      factory: T.nilable(::String),
      immutable: T.nilable(T::Boolean),
      array: T.nilable(::String),
      override: T.nilable(T::Boolean),
      redaction: T.nilable(::String)
    ).void
  end
  def initialize(name, type, optional: T.unsafe(nil), enum: T.unsafe(nil), dont_store: T.unsafe(nil), foreign: T.unsafe(nil), default: T.unsafe(nil), factory: T.unsafe(nil), immutable: T.unsafe(nil), array: T.unsafe(nil), override: T.unsafe(nil), redaction: T.unsafe(nil)); end

  sig { params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  sig { returns(T.nilable(::String)) }
  def array; end

  sig { returns(T.nilable(::String)) }
  def default; end

  sig { returns(T.nilable(T::Boolean)) }
  def dont_store; end

  sig { returns(T.nilable(::String)) }
  def enum; end

  sig { returns(T.nilable(::String)) }
  def factory; end

  sig { returns(T.nilable(::String)) }
  def foreign; end

  sig { void }
  def generalize_from_rbi!; end

  sig { returns(T.nilable(T::Boolean)) }
  def immutable; end

  sig { returns(::String) }
  def name; end

  sig { returns(T.nilable(T.any(::Symbol, T::Boolean))) }
  def optional; end

  sig { returns(T.nilable(T::Boolean)) }
  def override; end

  sig { returns(T.nilable(::String)) }
  def redaction; end

  sig { returns(::String) }
  def to_prop_call; end

  sig { returns(T.any(::Parlour::Types::Type, ::String)) }
  def type; end
end

Parlour::RbiGenerator::StructProp::EXTRA_PROPERTIES = T.let(T.unsafe(nil), Array)

class Parlour::RbiGenerator::TypeAlias < ::Parlour::RbiGenerator::RbiObject
  sig do
    params(
      generator: ::Parlour::Generator,
      name: ::String,
      type: T.any(::Parlour::Types::Type, ::String),
      block: T.nilable(T.proc.params(x: ::Parlour::RbiGenerator::TypeAlias).void)
    ).void
  end
  def initialize(generator, name:, type:, &block); end

  sig { params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  sig { override.returns(T::Array[T.any(::Symbol, T::Hash[::Symbol, ::String])]) }
  def describe_attrs; end

  sig { override.void }
  def generalize_from_rbi!; end

  sig { override.params(indent_level: ::Integer, options: ::Parlour::Options).returns(T::Array[::String]) }
  def generate_rbi(indent_level, options); end

  sig { override.params(others: T::Array[::Parlour::RbiGenerator::RbiObject]).void }
  def merge_into_self(others); end

  sig { override.params(others: T::Array[::Parlour::RbiGenerator::RbiObject]).returns(T::Boolean) }
  def mergeable?(others); end

  sig { returns(T.any(::Parlour::Types::Type, ::String)) }
  def type; end
end

class Parlour::RbsGenerator < ::Parlour::Generator
  def initialize(**hash); end

  sig { overridable.returns(::String) }
  def rbs; end

  sig { overridable.returns(Parlour::RbsGenerator::Namespace) }
  def root; end
end

class Parlour::RbsGenerator::Arbitrary < ::Parlour::RbsGenerator::RbsObject
  sig do
    params(
      generator: ::Parlour::Generator,
      code: ::String,
      block: T.nilable(T.proc.params(x: ::Parlour::RbsGenerator::Arbitrary).void)
    ).void
  end
  def initialize(generator, code: T.unsafe(nil), &block); end

  sig { params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  sig { returns(::String) }
  def code; end

  def code=(_arg0); end

  sig { override.returns(T::Array[T.any(::Symbol, T::Hash[::Symbol, ::String])]) }
  def describe_attrs; end

  sig { override.params(indent_level: ::Integer, options: ::Parlour::Options).returns(T::Array[::String]) }
  def generate_rbs(indent_level, options); end

  sig { override.params(others: T::Array[::Parlour::RbsGenerator::RbsObject]).void }
  def merge_into_self(others); end

  sig { override.params(others: T::Array[::Parlour::RbsGenerator::RbsObject]).returns(T::Boolean) }
  def mergeable?(others); end
end

class Parlour::RbsGenerator::Attribute < ::Parlour::RbsGenerator::Method
  sig do
    params(
      generator: ::Parlour::Generator,
      name: ::String,
      kind: ::Symbol,
      type: T.any(::Parlour::Types::Type, ::String),
      block: T.nilable(T.proc.params(x: ::Parlour::RbsGenerator::Attribute).void)
    ).void
  end
  def initialize(generator, name, kind, type, &block); end

  sig { override.params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  sig { override.returns(T::Array[T.any(::Symbol, T::Hash[::Symbol, ::String])]) }
  def describe_attrs; end

  sig { override.params(indent_level: ::Integer, options: ::Parlour::Options).returns(T::Array[::String]) }
  def generate_rbs(indent_level, options); end

  sig { returns(::Symbol) }
  def kind; end

  sig { returns(T.any(::Parlour::Types::Type, ::String)) }
  def type; end
end

class Parlour::RbsGenerator::Block
  sig { params(type: ::Parlour::Types::Proc, required: T::Boolean).void }
  def initialize(type, required); end

  sig { overridable.params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  sig { params(options: ::Parlour::Options).returns(T::Array[::String]) }
  def generate_rbs(options); end

  sig { returns(T::Boolean) }
  def required; end

  sig { returns(::Parlour::Types::Proc) }
  def type; end
end

class Parlour::RbsGenerator::ClassNamespace < ::Parlour::RbsGenerator::Namespace
  extend T::Generic

  Child = type_member { { fixed: Parlour::RbsGenerator::RbsObject } }

  sig do
    params(
      generator: ::Parlour::Generator,
      name: ::String,
      superclass: T.nilable(T.any(::Parlour::Types::Type, ::String)),
      block: T.nilable(T.proc.params(x: Parlour::RbsGenerator::ClassNamespace).void)
    ).void
  end
  def initialize(generator, name, superclass, &block); end

  sig { override.returns(T::Array[T.any(::Symbol, T::Hash[::Symbol, ::String])]) }
  def describe_attrs; end

  sig { override.params(indent_level: ::Integer, options: ::Parlour::Options).returns(T::Array[::String]) }
  def generate_rbs(indent_level, options); end

  sig { override.params(others: T::Array[::Parlour::RbsGenerator::RbsObject]).void }
  def merge_into_self(others); end

  sig { override.params(others: T::Array[::Parlour::RbsGenerator::RbsObject]).returns(T::Boolean) }
  def mergeable?(others); end

  sig { returns(T.nilable(T.any(::Parlour::Types::Type, ::String))) }
  def superclass; end
end

class Parlour::RbsGenerator::Constant < ::Parlour::RbsGenerator::RbsObject
  sig do
    params(
      generator: ::Parlour::Generator,
      name: ::String,
      type: T.any(::Parlour::Types::Type, ::String),
      block: T.nilable(T.proc.params(x: ::Parlour::RbsGenerator::Constant).void)
    ).void
  end
  def initialize(generator, name, type:, &block); end

  sig { params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  sig { override.returns(T::Array[T.any(::Symbol, T::Hash[::Symbol, ::String])]) }
  def describe_attrs; end

  sig { override.params(indent_level: ::Integer, options: ::Parlour::Options).returns(T::Array[::String]) }
  def generate_rbs(indent_level, options); end

  sig { override.params(others: T::Array[::Parlour::RbsGenerator::RbsObject]).void }
  def merge_into_self(others); end

  sig { override.params(others: T::Array[::Parlour::RbsGenerator::RbsObject]).returns(T::Boolean) }
  def mergeable?(others); end

  sig { returns(T.any(::Parlour::Types::Type, ::String)) }
  def type; end
end

class Parlour::RbsGenerator::Extend < ::Parlour::RbsGenerator::RbsObject
  sig do
    params(
      generator: ::Parlour::Generator,
      type: T.any(::Parlour::Types::Type, ::String),
      block: T.nilable(T.proc.params(x: ::Parlour::RbsGenerator::Extend).void)
    ).void
  end
  def initialize(generator, type:, &block); end

  sig { params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  sig { override.returns(T::Array[T.any(::Symbol, T::Hash[::Symbol, ::String])]) }
  def describe_attrs; end

  sig { override.params(indent_level: ::Integer, options: ::Parlour::Options).returns(T::Array[::String]) }
  def generate_rbs(indent_level, options); end

  sig { override.params(others: T::Array[::Parlour::RbsGenerator::RbsObject]).void }
  def merge_into_self(others); end

  sig { override.params(others: T::Array[::Parlour::RbsGenerator::RbsObject]).returns(T::Boolean) }
  def mergeable?(others); end

  sig { returns(T.any(::Parlour::Types::Type, ::String)) }
  def type; end
end

class Parlour::RbsGenerator::Include < ::Parlour::RbsGenerator::RbsObject
  sig do
    params(
      generator: ::Parlour::Generator,
      type: T.any(::Parlour::Types::Type, ::String),
      block: T.nilable(T.proc.params(x: ::Parlour::RbsGenerator::Include).void)
    ).void
  end
  def initialize(generator, type:, &block); end

  sig { params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  sig { override.returns(T::Array[T.any(::Symbol, T::Hash[::Symbol, ::String])]) }
  def describe_attrs; end

  sig { override.params(indent_level: ::Integer, options: ::Parlour::Options).returns(T::Array[::String]) }
  def generate_rbs(indent_level, options); end

  sig { override.params(others: T::Array[::Parlour::RbsGenerator::RbsObject]).void }
  def merge_into_self(others); end

  sig { override.params(others: T::Array[::Parlour::RbsGenerator::RbsObject]).returns(T::Boolean) }
  def mergeable?(others); end

  sig { returns(T.any(::Parlour::Types::Type, ::String)) }
  def type; end
end

class Parlour::RbsGenerator::InterfaceNamespace < ::Parlour::RbsGenerator::Namespace
  extend T::Generic

  Child = type_member { { fixed: Parlour::RbsGenerator::RbsObject } }

  sig { override.returns(T::Array[T.any(::Symbol, T::Hash[::Symbol, ::String])]) }
  def describe_attrs; end

  sig { override.params(indent_level: ::Integer, options: ::Parlour::Options).returns(T::Array[::String]) }
  def generate_rbs(indent_level, options); end
end

class Parlour::RbsGenerator::Method < ::Parlour::RbsGenerator::RbsObject
  sig do
    params(
      generator: ::Parlour::Generator,
      name: ::String,
      signatures: T::Array[::Parlour::RbsGenerator::MethodSignature],
      class_method: T::Boolean,
      block: T.nilable(T.proc.params(x: ::Parlour::RbsGenerator::Method).void)
    ).void
  end
  def initialize(generator, name, signatures, class_method: T.unsafe(nil), &block); end

  sig { overridable.params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  sig { returns(T::Boolean) }
  def class_method; end

  sig { override.returns(T::Array[T.any(::Symbol, T::Hash[::Symbol, ::String])]) }
  def describe_attrs; end

  sig { override.params(indent_level: ::Integer, options: ::Parlour::Options).returns(T::Array[::String]) }
  def generate_rbs(indent_level, options); end

  sig { override.params(others: T::Array[::Parlour::RbsGenerator::RbsObject]).void }
  def merge_into_self(others); end

  sig { override.params(others: T::Array[::Parlour::RbsGenerator::RbsObject]).returns(T::Boolean) }
  def mergeable?(others); end

  sig { returns(T::Array[::Parlour::RbsGenerator::MethodSignature]) }
  def signatures; end
end

class Parlour::RbsGenerator::MethodSignature
  sig do
    params(
      parameters: T::Array[::Parlour::RbsGenerator::Parameter],
      return_type: T.nilable(T.any(::Parlour::Types::Type, ::String)),
      block: T.nilable(::Parlour::RbsGenerator::Block),
      type_parameters: T.nilable(T::Array[::Symbol])
    ).void
  end
  def initialize(parameters, return_type = T.unsafe(nil), block: T.unsafe(nil), type_parameters: T.unsafe(nil)); end

  sig { overridable.params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  sig { returns(T.nilable(::Parlour::RbsGenerator::Block)) }
  def block; end

  sig { returns(::String) }
  def describe_in_method; end

  sig { params(options: ::Parlour::Options).returns(T::Array[::String]) }
  def generate_rbs(options); end

  sig { returns(T::Array[::Parlour::RbsGenerator::Parameter]) }
  def parameters; end

  sig { returns(T.nilable(T.any(::Parlour::Types::Type, ::String))) }
  def return_type; end

  sig { returns(T::Array[::Symbol]) }
  def type_parameters; end
end

class Parlour::RbsGenerator::ModuleNamespace < ::Parlour::RbsGenerator::Namespace
  extend T::Generic

  Child = type_member { { fixed: Parlour::RbsGenerator::RbsObject } }

  sig { override.returns(T::Array[T.any(::Symbol, T::Hash[::Symbol, ::String])]) }
  def describe_attrs; end

  sig { override.params(indent_level: ::Integer, options: ::Parlour::Options).returns(T::Array[::String]) }
  def generate_rbs(indent_level, options); end
end

class Parlour::RbsGenerator::Namespace < ::Parlour::RbsGenerator::RbsObject
  extend T::Generic
  include ::Parlour::Mixin::Searchable

  Child = type_member { { fixed: Parlour::RbsGenerator::RbsObject } }

  sig do
    params(
      generator: ::Parlour::Generator,
      name: T.nilable(::String),
      block: T.nilable(T.proc.params(x: Parlour::RbsGenerator::Namespace).void)
    ).void
  end
  def initialize(generator, name = T.unsafe(nil), &block); end

  sig { params(comment: T.any(::String, T::Array[::String])).void }
  def add_comment_to_next_child(comment); end

  sig { returns(T::Array[::Parlour::RbsGenerator::TypeAlias]) }
  def aliases; end

  sig { override.returns(T::Array[::Parlour::RbsGenerator::RbsObject]) }
  def children; end

  sig { returns(T::Array[::Parlour::RbsGenerator::Constant]) }
  def constants; end

  def create_arbitrary(code:, &block); end
  def create_attr(*args, &blk); end

  sig do
    params(
      name: ::String,
      type: T.any(::Parlour::Types::Type, ::String),
      block: T.nilable(T.proc.params(x: ::Parlour::RbsGenerator::Attribute).void)
    ).returns(::Parlour::RbsGenerator::Attribute)
  end
  def create_attr_accessor(name, type:, &block); end

  sig do
    params(
      name: ::String,
      type: T.any(::Parlour::Types::Type, ::String),
      block: T.nilable(T.proc.params(x: ::Parlour::RbsGenerator::Attribute).void)
    ).returns(::Parlour::RbsGenerator::Attribute)
  end
  def create_attr_reader(name, type:, &block); end

  sig do
    params(
      name: ::String,
      type: T.any(::Parlour::Types::Type, ::String),
      block: T.nilable(T.proc.params(x: ::Parlour::RbsGenerator::Attribute).void)
    ).returns(::Parlour::RbsGenerator::Attribute)
  end
  def create_attr_writer(name, type:, &block); end

  sig do
    params(
      name: ::String,
      kind: ::Symbol,
      type: T.any(::Parlour::Types::Type, ::String),
      block: T.nilable(T.proc.params(x: ::Parlour::RbsGenerator::Attribute).void)
    ).returns(::Parlour::RbsGenerator::Attribute)
  end
  def create_attribute(name, kind:, type:, &block); end

  sig do
    params(
      name: ::String,
      superclass: T.nilable(T.any(::Parlour::Types::Type, ::String)),
      block: T.nilable(T.proc.params(x: Parlour::RbsGenerator::ClassNamespace).void)
    ).returns(Parlour::RbsGenerator::ClassNamespace)
  end
  def create_class(name, superclass: T.unsafe(nil), &block); end

  sig do
    params(
      name: ::String,
      type: T.any(::Parlour::Types::Type, ::String),
      block: T.nilable(T.proc.params(x: ::Parlour::RbsGenerator::Constant).void)
    ).returns(::Parlour::RbsGenerator::Constant)
  end
  def create_constant(name, type:, &block); end

  sig do
    params(
      type: T.any(::Parlour::Types::Type, ::String),
      block: T.nilable(T.proc.params(x: ::Parlour::RbsGenerator::Extend).void)
    ).returns(::Parlour::RbsGenerator::Extend)
  end
  def create_extend(type, &block); end

  sig do
    params(
      extendables: T::Array[T.any(::Parlour::Types::Type, ::String)]
    ).returns(T::Array[::Parlour::RbsGenerator::Extend])
  end
  def create_extends(extendables); end

  sig do
    params(
      type: T.any(::Parlour::Types::Type, ::String),
      block: T.nilable(T.proc.params(x: ::Parlour::RbsGenerator::Include).void)
    ).returns(::Parlour::RbsGenerator::Include)
  end
  def create_include(type, &block); end

  sig do
    params(
      includables: T::Array[T.any(::Parlour::Types::Type, ::String)]
    ).returns(T::Array[::Parlour::RbsGenerator::Include])
  end
  def create_includes(includables); end

  sig do
    params(
      name: ::String,
      block: T.nilable(T.proc.params(x: Parlour::RbsGenerator::Namespace).void)
    ).returns(Parlour::RbsGenerator::InterfaceNamespace)
  end
  def create_interface(name, &block); end

  sig do
    params(
      name: ::String,
      signatures: T.nilable(T::Array[::Parlour::RbsGenerator::MethodSignature]),
      class_method: T::Boolean,
      block: T.nilable(T.proc.params(x: ::Parlour::RbsGenerator::Method).void)
    ).returns(::Parlour::RbsGenerator::Method)
  end
  def create_method(name, signatures = T.unsafe(nil), class_method: T.unsafe(nil), &block); end

  sig do
    params(
      name: ::String,
      block: T.nilable(T.proc.params(x: Parlour::RbsGenerator::Namespace).void)
    ).returns(Parlour::RbsGenerator::ModuleNamespace)
  end
  def create_module(name, &block); end

  sig do
    params(
      name: ::String,
      type: T.any(::Parlour::Types::Type, ::String),
      block: T.nilable(T.proc.params(x: ::Parlour::RbsGenerator::TypeAlias).void)
    ).returns(::Parlour::RbsGenerator::TypeAlias)
  end
  def create_type_alias(name, type:, &block); end

  sig { override.returns(T::Array[T.any(::Symbol, T::Hash[::Symbol, ::String])]) }
  def describe_attrs; end

  sig { returns(T::Array[::Parlour::RbsGenerator::Extend]) }
  def extends; end

  sig { override.overridable.params(indent_level: ::Integer, options: ::Parlour::Options).returns(T::Array[::String]) }
  def generate_rbs(indent_level, options); end

  sig { returns(T::Array[::Parlour::RbsGenerator::Include]) }
  def includes; end

  sig { override.overridable.params(others: T::Array[::Parlour::RbsGenerator::RbsObject]).void }
  def merge_into_self(others); end

  sig { override.overridable.params(others: T::Array[::Parlour::RbsGenerator::RbsObject]).returns(T::Boolean) }
  def mergeable?(others); end

  sig { params(object: T.untyped, block: T.proc.params(x: Parlour::RbsGenerator::Namespace).void).void }
  def path(object, &block); end

  def type_aliases(*args, &blk); end

  private

  sig { overridable.params(indent_level: ::Integer, options: ::Parlour::Options).returns(T::Array[::String]) }
  def generate_body(indent_level, options); end

  sig { params(object: ::Parlour::RbsGenerator::RbsObject).void }
  def move_next_comments(object); end
end

class Parlour::RbsGenerator::Parameter
  sig { params(name: ::String, type: T.nilable(T.any(::Parlour::Types::Type, ::String)), required: T::Boolean).void }
  def initialize(name, type: T.unsafe(nil), required: T.unsafe(nil)); end

  sig { params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  sig { returns(::Symbol) }
  def kind; end

  sig { returns(::String) }
  def name; end

  sig { returns(::String) }
  def name_without_kind; end

  sig { returns(T::Boolean) }
  def required; end

  sig { returns(::String) }
  def to_rbs_param; end

  sig { returns(T.any(::Parlour::Types::Type, ::String)) }
  def type; end
end

Parlour::RbsGenerator::Parameter::PREFIXES = T.let(T.unsafe(nil), Hash)
Parlour::RbsGenerator::Parameter::RBS_KEYWORDS = T.let(T.unsafe(nil), Array)

class Parlour::RbsGenerator::RbsObject < ::Parlour::TypedObject
  abstract!

  sig { params(generator: ::Parlour::Generator, name: ::String).void }
  def initialize(generator, name); end

  sig { abstract.params(indent_level: ::Integer, options: ::Parlour::Options).returns(T::Array[::String]) }
  def generate_rbs(indent_level, options); end

  sig { returns(::Parlour::Generator) }
  def generator; end

  sig { abstract.params(others: T::Array[::Parlour::RbsGenerator::RbsObject]).void }
  def merge_into_self(others); end

  sig { abstract.params(others: T::Array[::Parlour::RbsGenerator::RbsObject]).returns(T::Boolean) }
  def mergeable?(others); end
end

class Parlour::RbsGenerator::TypeAlias < ::Parlour::RbsGenerator::RbsObject
  sig do
    params(
      generator: ::Parlour::Generator,
      name: ::String,
      type: T.any(::Parlour::Types::Type, ::String),
      block: T.nilable(T.proc.params(x: ::Parlour::RbsGenerator::TypeAlias).void)
    ).void
  end
  def initialize(generator, name:, type:, &block); end

  sig { params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  sig { override.returns(T::Array[T.any(::Symbol, T::Hash[::Symbol, ::String])]) }
  def describe_attrs; end

  sig { override.params(indent_level: ::Integer, options: ::Parlour::Options).returns(T::Array[::String]) }
  def generate_rbs(indent_level, options); end

  sig { override.params(others: T::Array[::Parlour::RbsGenerator::RbsObject]).void }
  def merge_into_self(others); end

  sig { override.params(others: T::Array[::Parlour::RbsGenerator::RbsObject]).returns(T::Boolean) }
  def mergeable?(others); end

  sig { returns(T.any(::Parlour::Types::Type, ::String)) }
  def type; end
end

module Parlour::TypeLoader
  class << self
    sig do
      params(
        filename: ::String,
        generator: T.nilable(::Parlour::RbiGenerator)
      ).returns(Parlour::RbiGenerator::Namespace)
    end
    def load_file(filename, generator: T.unsafe(nil)); end

    sig do
      params(
        root: ::String,
        inclusions: T::Array[::String],
        exclusions: T::Array[::String],
        generator: T.nilable(::Parlour::RbiGenerator)
      ).returns(Parlour::RbiGenerator::Namespace)
    end
    def load_project(root, inclusions: T.unsafe(nil), exclusions: T.unsafe(nil), generator: T.unsafe(nil)); end

    sig do
      params(
        source: ::String,
        filename: T.nilable(::String),
        generator: T.nilable(::Parlour::RbiGenerator)
      ).returns(Parlour::RbiGenerator::Namespace)
    end
    def load_source(source, filename = T.unsafe(nil), generator: T.unsafe(nil)); end
  end
end

class Parlour::TypeParser
  sig do
    params(
      ast: ::Parser::AST::Node,
      unknown_node_errors: T::Boolean,
      generator: T.nilable(::Parlour::RbiGenerator)
    ).void
  end
  def initialize(ast, unknown_node_errors: T.unsafe(nil), generator: T.unsafe(nil)); end

  sig { returns(::Parser::AST::Node) }
  def ast; end

  def ast=(_arg0); end

  sig { returns(::Parlour::RbiGenerator) }
  def generator; end

  def generator=(_arg0); end

  sig { returns(Parlour::RbiGenerator::Namespace) }
  def parse_all; end

  sig do
    params(
      path: ::Parlour::TypeParser::NodePath,
      is_within_eigenclass: T::Boolean
    ).returns(T::Array[::Parlour::RbiGenerator::Method])
  end
  def parse_method_into_methods(path, is_within_eigenclass: T.unsafe(nil)); end

  sig { params(node: ::Parser::AST::Node).returns(::Parlour::Types::Type) }
  def parse_node_to_type(node); end

  sig do
    params(
      path: ::Parlour::TypeParser::NodePath,
      is_within_eigenclass: T::Boolean
    ).returns(T::Array[::Parlour::RbiGenerator::RbiObject])
  end
  def parse_path_to_object(path, is_within_eigenclass: T.unsafe(nil)); end

  sig do
    params(
      path: ::Parlour::TypeParser::NodePath,
      is_within_eigenclass: T::Boolean
    ).returns(T::Array[::Parlour::RbiGenerator::Method])
  end
  def parse_sig_into_methods(path, is_within_eigenclass: T.unsafe(nil)); end

  sig { params(path: ::Parlour::TypeParser::NodePath).returns(::Parlour::TypeParser::IntermediateSig) }
  def parse_sig_into_sig(path); end

  sig { returns(T::Boolean) }
  def unknown_node_errors; end

  protected

  sig { params(node: T.nilable(::Parser::AST::Node), modifier: ::Symbol).returns(T::Boolean) }
  def body_has_modifier?(node, modifier); end

  sig { params(node: ::Parser::AST::Node).returns([T::Array[::String], T::Array[::String]]) }
  def body_includes_and_extends(node); end

  sig { params(node: T.nilable(::Parser::AST::Node)).returns(T::Array[::Symbol]) }
  def constant_names(node); end

  sig { params(node: T.nilable(::Parser::AST::Node)).returns(T.nilable(::String)) }
  def node_to_s(node); end

  sig { params(desc: ::String, node: T.any(::Parlour::TypeParser::NodePath, ::Parser::AST::Node)).returns(T.noreturn) }
  def parse_err(desc, node); end

  sig { params(path: ::Parlour::TypeParser::NodePath).returns(T::Boolean) }
  def previous_sibling_sig_node?(path); end

  sig { params(node: ::Parser::AST::Node).returns(T::Boolean) }
  def sig_node?(node); end

  sig { params(msg: ::String, node: ::Parser::AST::Node).void }
  def warning(msg, node); end

  sig do
    type_parameters(:A, :B)
      .params(
        a: T::Array[T.type_parameter(:A)],
        fa: T.proc.params(item: T.type_parameter(:A)).returns(T.untyped),
        b: T::Array[T.type_parameter(:B)],
        fb: T.proc.params(item: T.type_parameter(:B)).returns(T.untyped)
      ).returns(T::Array[[T.type_parameter(:A), T.type_parameter(:B)]])
  end
  def zip_by(a, fa, b, fb); end

  class << self
    sig do
      params(
        filename: ::String,
        source: ::String,
        generator: T.nilable(::Parlour::RbiGenerator)
      ).returns(::Parlour::TypeParser)
    end
    def from_source(filename, source, generator: T.unsafe(nil)); end

    sig { params(str: ::String).returns(::Parlour::Types::Type) }
    def parse_single_type(str); end
  end
end

class Parlour::TypeParser::IntermediateSig < ::T::Struct
  prop :abstract, T::Boolean
  prop :final, T::Boolean
  prop :overridable, T::Boolean
  prop :override, T::Boolean
  prop :params, T.nilable(T::Array[::Parser::AST::Node])
  prop :return_type, T.nilable(::String)
  prop :type_parameters, T.nilable(T::Array[::Symbol])

  class << self
    def inherited(s); end
  end
end

class Parlour::TypeParser::NodePath
  sig { params(indices: T::Array[::Integer]).void }
  def initialize(indices); end

  sig { params(index: ::Integer).returns(::Parlour::TypeParser::NodePath) }
  def child(index); end

  sig { returns(T::Array[::Integer]) }
  def indices; end

  sig { returns(::Parlour::TypeParser::NodePath) }
  def parent; end

  sig { params(offset: ::Integer).returns(::Parlour::TypeParser::NodePath) }
  def sibling(offset); end

  sig { params(start: ::Parser::AST::Node).returns(::Parser::AST::Node) }
  def traverse(start); end
end

class Parlour::TypedObject
  abstract!

  sig { params(name: ::String).void }
  def initialize(name); end

  sig { params(comment: T.any(::String, T::Array[::String])).void }
  def add_comment(comment); end

  def add_comments(*args, &blk); end

  sig { returns(T::Array[::String]) }
  def comments; end

  sig { returns(::String) }
  def describe; end

  sig { params(tree: T.nilable(::Parlour::Debugging::Tree)).returns(::String) }
  def describe_tree(tree: T.unsafe(nil)); end

  sig { returns(T.nilable(::Parlour::Plugin)) }
  def generated_by; end

  def inspect(*args, &blk); end

  sig { returns(::String) }
  def name; end

  def to_s(*args, &blk); end

  protected

  sig { abstract.returns(T::Array[T.any(::Symbol, T::Hash[::Symbol, ::String])]) }
  def describe_attrs; end

  sig { params(indent_level: ::Integer, options: ::Parlour::Options).returns(T::Array[::String]) }
  def generate_comments(indent_level, options); end
end

module Parlour::Types; end

class Parlour::Types::Array < ::Parlour::Types::SingleElementCollection
  sig { params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  sig { override.returns(::String) }
  def collection_name; end
end

class Parlour::Types::Boolean < ::Parlour::Types::Type
  sig { params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  sig { override.returns(::String) }
  def describe; end

  sig { override.returns(::String) }
  def generate_rbi; end

  sig { override.returns(::String) }
  def generate_rbs; end
end

class Parlour::Types::Class < ::Parlour::Types::Type
  sig { params(type: T.any(::Parlour::Types::Type, ::String)).void }
  def initialize(type); end

  sig { params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  sig { override.returns(::String) }
  def describe; end

  sig { override.returns(::String) }
  def generate_rbi; end

  sig { override.returns(::String) }
  def generate_rbs; end

  sig { returns(::Parlour::Types::Type) }
  def type; end
end

class Parlour::Types::Enumerable < ::Parlour::Types::SingleElementCollection
  sig { params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  sig { override.returns(::String) }
  def collection_name; end
end

class Parlour::Types::Enumerator < ::Parlour::Types::SingleElementCollection
  sig { params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  sig { override.returns(::String) }
  def collection_name; end
end

class Parlour::Types::Generic < ::Parlour::Types::Type
  sig do
    params(
      type: T.any(::Parlour::Types::Type, ::String),
      type_params: T::Array[T.any(::Parlour::Types::Type, ::String)]
    ).void
  end
  def initialize(type, type_params); end

  sig { params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  sig { override.returns(::String) }
  def describe; end

  sig { override.returns(::String) }
  def generate_rbi; end

  sig { override.returns(::String) }
  def generate_rbs; end

  sig { returns(::Parlour::Types::Type) }
  def type; end

  sig { returns(T::Array[::Parlour::Types::Type]) }
  def type_params; end
end

class Parlour::Types::Hash < ::Parlour::Types::Type
  sig { params(key: T.any(::Parlour::Types::Type, ::String), value: T.any(::Parlour::Types::Type, ::String)).void }
  def initialize(key, value); end

  sig { params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  sig { override.returns(::String) }
  def describe; end

  sig { override.returns(::String) }
  def generate_rbi; end

  sig { override.returns(::String) }
  def generate_rbs; end

  sig { returns(::Parlour::Types::Type) }
  def key; end

  sig { returns(::Parlour::Types::Type) }
  def value; end
end

class Parlour::Types::Intersection < ::Parlour::Types::Type
  sig { params(types: T::Array[T.any(::Parlour::Types::Type, ::String)]).void }
  def initialize(types); end

  sig { params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  sig { override.returns(::String) }
  def describe; end

  sig { override.returns(::String) }
  def generate_rbi; end

  sig { override.returns(::String) }
  def generate_rbs; end

  sig { returns(T::Array[::Parlour::Types::Type]) }
  def types; end
end

class Parlour::Types::Nilable < ::Parlour::Types::Type
  sig { params(type: T.any(::Parlour::Types::Type, ::String)).void }
  def initialize(type); end

  sig { params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  sig { override.returns(::String) }
  def describe; end

  sig { override.returns(::String) }
  def generate_rbi; end

  sig { override.returns(::String) }
  def generate_rbs; end

  sig { returns(::Parlour::Types::Type) }
  def type; end
end

class Parlour::Types::Proc < ::Parlour::Types::Type
  sig do
    params(
      parameters: T::Array[::Parlour::Types::Proc::Parameter],
      return_type: T.nilable(T.any(::Parlour::Types::Type, ::String))
    ).void
  end
  def initialize(parameters, return_type); end

  sig { params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  sig { override.returns(::String) }
  def describe; end

  sig { override.returns(::String) }
  def generate_rbi; end

  sig { override.returns(::String) }
  def generate_rbs; end

  sig { returns(T::Array[::Parlour::Types::Proc::Parameter]) }
  def parameters; end

  sig { returns(T.nilable(::Parlour::Types::Type)) }
  def return_type; end
end

class Parlour::Types::Proc::Parameter
  sig { params(name: ::String, type: T.any(::Parlour::Types::Type, ::String), default: T.nilable(::String)).void }
  def initialize(name, type, default = T.unsafe(nil)); end

  sig { params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  sig { returns(T.nilable(::String)) }
  def default; end

  sig { returns(::String) }
  def name; end

  sig { returns(::Parlour::Types::Type) }
  def type; end
end

class Parlour::Types::Range < ::Parlour::Types::SingleElementCollection
  sig { params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  sig { override.returns(::String) }
  def collection_name; end
end

class Parlour::Types::Raw < ::Parlour::Types::Type
  sig { params(str: ::String).void }
  def initialize(str); end

  sig { params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  sig { override.returns(::String) }
  def describe; end

  sig { override.returns(::String) }
  def generate_rbi; end

  sig { override.returns(::String) }
  def generate_rbs; end

  sig { returns(::String) }
  def str; end
end

class Parlour::Types::Record < ::Parlour::Types::Type
  sig { params(keys_to_types: T::Hash[::Symbol, T.any(::Parlour::Types::Type, ::String)]).void }
  def initialize(keys_to_types); end

  sig { params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  sig { override.returns(::String) }
  def describe; end

  sig { override.returns(::String) }
  def generate_rbi; end

  sig { override.returns(::String) }
  def generate_rbs; end

  sig { returns(T::Hash[::Symbol, ::Parlour::Types::Type]) }
  def keys_to_types; end
end

class Parlour::Types::Self < ::Parlour::Types::Type
  sig { params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  sig { override.returns(::String) }
  def describe; end

  sig { override.returns(::String) }
  def generate_rbi; end

  sig { override.returns(::String) }
  def generate_rbs; end
end

class Parlour::Types::Set < ::Parlour::Types::SingleElementCollection
  sig { params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  sig { override.returns(::String) }
  def collection_name; end
end

class Parlour::Types::SingleElementCollection < ::Parlour::Types::Type
  abstract!

  sig { params(element: T.any(::Parlour::Types::Type, ::String)).void }
  def initialize(element); end

  sig { abstract.returns(::String) }
  def collection_name; end

  sig { override.returns(::String) }
  def describe; end

  sig { returns(::Parlour::Types::Type) }
  def element; end

  sig { override.returns(::String) }
  def generate_rbi; end

  sig { override.returns(::String) }
  def generate_rbs; end
end

class Parlour::Types::Tuple < ::Parlour::Types::Type
  sig { params(types: T::Array[T.any(::Parlour::Types::Type, ::String)]).void }
  def initialize(types); end

  sig { params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  sig { override.returns(::String) }
  def describe; end

  sig { override.returns(::String) }
  def generate_rbi; end

  sig { override.returns(::String) }
  def generate_rbs; end

  sig { returns(T::Array[::Parlour::Types::Type]) }
  def types; end
end

class Parlour::Types::Type
  abstract!

  def initialize(*args, &blk); end

  sig { abstract.returns(::String) }
  def describe; end

  sig { abstract.returns(::String) }
  def generate_rbi; end

  sig { abstract.returns(::String) }
  def generate_rbs; end

  def hash; end

  sig { params(type_like: T.any(::Parlour::Types::Type, ::String)).returns(::Parlour::Types::Type) }
  def to_type(type_like); end

  class << self
    sig { params(type_like: T.any(::Parlour::Types::Type, ::String)).returns(::Parlour::Types::Type) }
    def to_type(type_like); end
  end
end

Parlour::Types::TypeLike = T.type_alias { T.any(::Parlour::Types::Type, ::String) }

class Parlour::Types::Union < ::Parlour::Types::Type
  sig { params(types: T::Array[T.any(::Parlour::Types::Type, ::String)]).void }
  def initialize(types); end

  sig { params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  sig { override.returns(::String) }
  def describe; end

  sig { override.returns(::String) }
  def generate_rbi; end

  sig { override.returns(::String) }
  def generate_rbs; end

  sig { returns(T::Array[::Parlour::Types::Type]) }
  def types; end
end

class Parlour::Types::Untyped < ::Parlour::Types::Type
  sig { params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  sig { override.returns(::String) }
  def describe; end

  sig { override.returns(::String) }
  def generate_rbi; end

  sig { override.returns(::String) }
  def generate_rbs; end
end

Parlour::VERSION = T.let(T.unsafe(nil), String)
