# Go Version Management: goenv

[![Build Status](https://travis-ci.org/syndbg/goenv.svg?branch=master)](https://travis-ci.org/syndbg/goenv)

goenv aims to be as simple as possible and follow the already established
successful version management model of [pyenv](https://github.com/yyuu/pyenv) and [rbenv](https://github.com/rbenv/rbenv).

This project was cloned from [pyenv](https://github.com/yyuu/pyenv) and modified for Go.

[![asciicast](https://asciinema.org/a/17IT3YiQ56hiJsb2iHpGHlJqj.svg)](https://asciinema.org/a/17IT3YiQ56hiJsb2iHpGHlJqj)

### goenv _does..._

* Let you **change the global Go version** on a per-user basis.
* Provide support for **per-project Go versions**.
* Allow you to **override the Go version** with an environment
  variable.
* Search commands from **multiple versions of Go at a time**.

### goenv compared to others:

* https://github.com/pwoolcoc/goenv depends on Python,
* https://github.com/crsmithdev/goenv depends on Go,
* https://github.com/moovweb/gvm is a different approach to the problem that's modeled after `nvm`.
 `goenv` is more simplified.

----

## Links

* **[How It Works](./HOW_IT_WORKS.md)**
* **[Installation](./INSTALL.md)**
* **[Command Reference](./COMMANDS.md)**
* **[Environment variables](./ENVIRONMENT_VARIABLES.md)**
* **[Contributing](./CONTRIBUTING.md)**
* **[Code-of-Conduct](./CODE_OF_CONDUCT.md)**

