# gh-prs

`gh` cli extension to display a dashboard or pull requests by filters you care about.

![demo](https://github.com/dlvhdr/gh-prs/blob/8621183574c573e4077360b5027ffea70999b921/demo.gif)

## Installation

1. Install gh cli - see the [installation instructions](https://github.com/cli/cli#installation)

2. Install this extension:

```sh
gh extension install dlvhdr/gh-prs
```

## Configuring

Configuration is done in the `sections.yml` file under the extension's directory.
Each section is defined by a top level array item and has the following properies:
- title - shown in the TUI
- repos - a list of repos to enumerate
- filters - how the repo's PRs should be filtered - these are plain [github filters](https://docs.github.com/en/search-github/searching-on-github/searching-issues-and-pull-requests)

Example `sections.yml` file: 
```yml
- title: My Pull Requests
  repos:
    - dlvhdr/gh-prs
  filters: author:@me
- title: Needs My Review
  repos:
    - dlvhdr/gh-prs
  filters: assignee:@me
- title: Subscribed
  repos:
    - cli/cli
    - charmbracelet/glamour
    - charmbracelet/lipgloss
  filters: -author:@me
```

## Usage

Run:
```sh
gh prs
```

Then press <kbd>?</kbd> for help.

# Author
Dolev Hadar dolevc2@gmail.com
