# Copyright 2018 The TensorFlow Authors. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# ==============================================================================
# pylint: disable=line-too-long
"""List of renames to apply when converting from TF 1.0 to TF 2.0.

THIS FILE IS AUTOGENERATED: To update, please run:
  bazel build tensorflow/tools/compatibility/update:generate_v2_renames_map
  bazel-bin/tensorflow/tools/compatibility/update/generate_v2_renames_map
This file should be updated whenever endpoints are deprecated.
"""
from __future__ import absolute_import
from __future__ import division
from __future__ import print_function

renames = {
    'tf.acos': 'tf.math.acos',
    'tf.acosh': 'tf.math.acosh',
    'tf.add': 'tf.math.add',
    'tf.as_string': 'tf.dtypes.as_string',
    'tf.asin': 'tf.math.asin',
    'tf.asinh': 'tf.math.asinh',
    'tf.atan': 'tf.math.atan',
    'tf.atan2': 'tf.math.atan2',
    'tf.atanh': 'tf.math.atanh',
    'tf.batch_to_space_nd': 'tf.manip.batch_to_space_nd',
    'tf.betainc': 'tf.math.betainc',
    'tf.ceil': 'tf.math.ceil',
    'tf.check_numerics': 'tf.debugging.check_numerics',
    'tf.cholesky': 'tf.linalg.cholesky',
    'tf.cos': 'tf.math.cos',
    'tf.cosh': 'tf.math.cosh',
    'tf.cross': 'tf.linalg.cross',
    'tf.decode_base64': 'tf.io.decode_base64',
    'tf.decode_compressed': 'tf.io.decode_compressed',
    'tf.decode_json_example': 'tf.io.decode_json_example',
    'tf.decode_raw': 'tf.io.decode_raw',
    'tf.dequantize': 'tf.quantization.dequantize',
    'tf.diag': 'tf.linalg.tensor_diag',
    'tf.diag_part': 'tf.linalg.tensor_diag_part',
    'tf.digamma': 'tf.math.digamma',
    'tf.encode_base64': 'tf.io.encode_base64',
    'tf.equal': 'tf.math.equal',
    'tf.erfc': 'tf.math.erfc',
    'tf.exp': 'tf.math.exp',
    'tf.expm1': 'tf.math.expm1',
    'tf.extract_image_patches': 'tf.image.extract_image_patches',
    'tf.fake_quant_with_min_max_args': 'tf.quantization.fake_quant_with_min_max_args',
    'tf.fake_quant_with_min_max_args_gradient': 'tf.quantization.fake_quant_with_min_max_args_gradient',
    'tf.fake_quant_with_min_max_vars': 'tf.quantization.fake_quant_with_min_max_vars',
    'tf.fake_quant_with_min_max_vars_gradient': 'tf.quantization.fake_quant_with_min_max_vars_gradient',
    'tf.fake_quant_with_min_max_vars_per_channel': 'tf.quantization.fake_quant_with_min_max_vars_per_channel',
    'tf.fake_quant_with_min_max_vars_per_channel_gradient': 'tf.quantization.fake_quant_with_min_max_vars_per_channel_gradient',
    'tf.fft': 'tf.spectral.fft',
    'tf.floor': 'tf.math.floor',
    'tf.gather_nd': 'tf.manip.gather_nd',
    'tf.GraphKeys.VARIABLES': 'tf.GraphKeys.GLOBAL_VARIABLES',
    'tf.greater': 'tf.math.greater',
    'tf.greater_equal': 'tf.math.greater_equal',
    'tf.ifft': 'tf.spectral.ifft',
    'tf.igamma': 'tf.math.igamma',
    'tf.igammac': 'tf.math.igammac',
    'tf.invert_permutation': 'tf.math.invert_permutation',
    'tf.is_finite': 'tf.debugging.is_finite',
    'tf.is_inf': 'tf.debugging.is_inf',
    'tf.is_nan': 'tf.debugging.is_nan',
    'tf.less': 'tf.math.less',
    'tf.less_equal': 'tf.math.less_equal',
    'tf.lgamma': 'tf.math.lgamma',
    'tf.log': 'tf.math.log',
    'tf.log1p': 'tf.math.log1p',
    'tf.logical_and': 'tf.math.logical_and',
    'tf.logical_not': 'tf.math.logical_not',
    'tf.logical_or': 'tf.math.logical_or',
    'tf.matching_files': 'tf.io.matching_files',
    'tf.matrix_band_part': 'tf.linalg.band_part',
    'tf.matrix_determinant': 'tf.linalg.det',
    'tf.matrix_diag': 'tf.linalg.diag',
    'tf.matrix_diag_part': 'tf.linalg.diag_part',
    'tf.matrix_inverse': 'tf.linalg.inv',
    'tf.matrix_set_diag': 'tf.linalg.set_diag',
    'tf.matrix_solve': 'tf.linalg.solve',
    'tf.matrix_triangular_solve': 'tf.linalg.triangular_solve',
    'tf.maximum': 'tf.math.maximum',
    'tf.minimum': 'tf.math.minimum',
    'tf.not_equal': 'tf.math.not_equal',
    'tf.parse_tensor': 'tf.io.parse_tensor',
    'tf.polygamma': 'tf.math.polygamma',
    'tf.qr': 'tf.linalg.qr',
    'tf.quantized_concat': 'tf.quantization.quantized_concat',
    'tf.read_file': 'tf.io.read_file',
    'tf.reciprocal': 'tf.math.reciprocal',
    'tf.regex_replace': 'tf.strings.regex_replace',
    'tf.reshape': 'tf.manip.reshape',
    'tf.reverse': 'tf.manip.reverse',
    'tf.reverse_v2': 'tf.manip.reverse',
    'tf.rint': 'tf.math.rint',
    'tf.rsqrt': 'tf.math.rsqrt',
    'tf.scatter_nd': 'tf.manip.scatter_nd',
    'tf.segment_max': 'tf.math.segment_max',
    'tf.segment_mean': 'tf.math.segment_mean',
    'tf.segment_min': 'tf.math.segment_min',
    'tf.segment_prod': 'tf.math.segment_prod',
    'tf.segment_sum': 'tf.math.segment_sum',
    'tf.sin': 'tf.math.sin',
    'tf.sinh': 'tf.math.sinh',
    'tf.space_to_batch_nd': 'tf.manip.space_to_batch_nd',
    'tf.squared_difference': 'tf.math.squared_difference',
    'tf.string_join': 'tf.strings.join',
    'tf.string_strip': 'tf.strings.strip',
    'tf.string_to_hash_bucket': 'tf.strings.to_hash_bucket',
    'tf.string_to_hash_bucket_fast': 'tf.strings.to_hash_bucket_fast',
    'tf.string_to_hash_bucket_strong': 'tf.strings.to_hash_bucket_strong',
    'tf.string_to_number': 'tf.strings.to_number',
    'tf.substr': 'tf.strings.substr',
    'tf.tan': 'tf.math.tan',
    'tf.tile': 'tf.manip.tile',
    'tf.unsorted_segment_max': 'tf.math.unsorted_segment_max',
    'tf.unsorted_segment_min': 'tf.math.unsorted_segment_min',
    'tf.unsorted_segment_prod': 'tf.math.unsorted_segment_prod',
    'tf.unsorted_segment_sum': 'tf.math.unsorted_segment_sum',
    'tf.write_file': 'tf.io.write_file',
    'tf.zeta': 'tf.math.zeta'
}
