#pragma once
#include "acl_cpp/acl_cpp_define.hpp"
#include <vector>

namespace acl
{

/**
 * SSL ֤У鼶Ͷ
 */
typedef enum
{
	POLARSSL_VERIFY_NONE,	// У֤
	POLARSSL_VERIFY_OPT,	// ѡУ飬ʱֺУ
	POLARSSL_VERIFY_REQ	// ҪʱУ
} polarssl_verify_t;

/**
 * SSL Ӷ࣬һΪȫֶÿһ SSL
 * Ӷ֤ãȫԵ֤顢ԿϢÿһ SSL 
 * (polarssl_io) ñsetup_certs ʼ֤顢ԿϢ
 */
class ACL_CPP_API polarssl_conf
{
public:
	polarssl_conf();
	~polarssl_conf();

	/**
	 *  CA ֤(ÿʵֻһα)
	 * @param ca_file {const char*} CA ֤ļȫ·
	 * @param ca_path {const char*}  CA ֤ļĿ¼
	 * @return {bool}   CA ֤Ƿɹ
	 * ע ca_fileca_path ǿգμ֤
	 */
	bool load_ca(const char* ca_file, const char* ca_path);

	/**
	 * һ/ͻԼ֤飬Զεñض֤
	 * @param crt_file {const char*} ֤ļȫ·ǿ
	 * @return {bool} ֤Ƿɹ
	 */
	bool add_cert(const char* crt_file);

	/**
	 * ӷ/ͻ˵Կ(ÿʵֻһα)
	 * @param key_file {const char*} Կļȫ·ǿ
	 * @param key_pass {const char*} Կļ룬ûԿд NULL
	 * @return {bool} Ƿɹ
	 */
	bool set_key(const char* key_file, const char* key_pass = NULL);

	/**
	 *  SSL ֤У鷽ʽڲȱʡΪУ֤
	 * @param verify_mode {polarssl_verify_t}
	 */
	void set_authmode(polarssl_verify_t verify_mode);

	/**
	 * ΪģʽʱǷûỰ湦ܣ SSL Ч
	 * @param on {bool}
	 * עúԷģʽЧ
	 */
	void enable_cache(bool on);

	/**
	 * ض
	 * @return {void*}ֵΪ entropy_context 
	 */
	void* get_entropy()
	{
		return entropy_;
	}

	/**
	 * polarssl_io::open ڲñװǰ SSL Ӷ֤
	 * @param ssl {void*} SSL ӶΪ ssl_context 
	 * @param server_side {bool} ӶǷΪ
	 * @return {bool}  SSL Ƿɹ
	 */
	bool setup_certs(void* ssl, bool server_side);

private:
	void* entropy_;
	void* cacert_;
	void* pkey_;
	void* cert_chain_;
	void* cache_;
	polarssl_verify_t verify_mode_;

	void free_ca();
};

} // namespace acl
