#pragma once
#include "acl_cpp/acl_cpp_define.hpp"
#include <list>

namespace acl {

class string;
class mime_code;

struct rfc2047_entry 
{
	string* pData;		// 
	string* pCharset;	// ַ
	char  coding;		// ʽB ʾ BASE64, Q ʾ QP
};

class ACL_CPP_API rfc2047
{
public:
	/**
	 * 캯
	 * @param strip_sp {bool} ڽǷȥسзÿпͷ
	 *  ոTAB
	 * @param addCrlf {bool} ڱеݱȽϳʱǷԶ "\r\n"
	 */
	rfc2047(bool strip_sp = true, bool addCrlf = true);
	~rfc2047();

	/**
	 * ʽ, ѭô˺, ÿӲ
	 * ֱ
	 * @param in {const char*} Դַ
	 * @param n {int} in 봮ĳ
	 */
	void decode_update(const char* in, int n);

	/**
	 *  rfc2047 תַַָ, 
	 * ȷתԴ
	 * @param to_charset {const char*} Ŀַ
	 * @param out {string*} 洢ת
	 * @param addInvalid {bool} Ϊ true ʱת
	 *  ǷֱַӿĬֱӿ
	 * @return {bool} תǷɹ
	 */
	bool decode_finish(const char* to_charset, string* out,
		bool addInvalid = true);

	/**
	 * rfc2047 
	 * @param in {const char*} 
	 * @param n {int} in ݳ
	 * @param out {string*} 洢
	 * @param charset {const char*} ݵַ
	 * @param coding {char} ֵ֧ͣı:
	 *   B: base64, Q: quoted_printable
	 * @return {bool} ǷȷұǷɹ
	 */
	bool encode_update(const char* in, int n, string* out,
		const char* charset = "gb2312", char coding = 'B');

	/**
	 *  encode_update ӵݽб洢ûָ
	 * @param  out {string*} 洢û
	 * @return {bool} Ƿɹ
	 */
	bool encode_finish(string* out);

	/**
	 * ̬
	 * @param in {const char*} ݵַ
	 * @param n {int} ݳ
	 * @param out {string*} 洢Ļ
	 * @param charset {const char*} ݵַ
	 * @param coding {char} ֵ֧ͣı:
	 *   B: base64, Q: quoted_printable
	 * @param addCrlf {bool} ڱеݱȽϳʱǷԶ "\r\n"
	 * @return {bool} Ƿɹ
	 */
	static bool encode(const char* in, int n, string* out,
		const char* charset = "gb2312", char coding = 'B',
		bool addCrlf = true);

	/**
	 * ̬
	 * @param in {const char*} ݵַ
	 * @param n {int} ݳ
	 * @param out {string*} 洢Ļ
	 * @param to_charset {const char*} Ŀַ
	 * @param strip_sp {bool} ǷȥسзÿпͷĿոTAB
	 * @param addInvalid {bool} Ϊ true ʱת
	 *  ǷֱַӿĬֱӿ
	 * @return {bool} Ƿɹ
	 */
	static bool decode(const char* in, int n, string* out,
		const char* to_charset = "gb2312", bool strip_sp = false,
		bool addInvalid = true);

	/**
	 * ʽ
	 * @return {const std::list<rfc2047_entry*>&}
	 */
	const std::list<rfc2047_entry*>& get_list(void) const;

	/**
	 * ý״̬, ýٴʹ
	 * @param strip_sp {bool} ǷȥسзÿпͷĿոTAB
	 */
	void reset(bool strip_sp = true);

	/**
	 * 
	 */
	void debug_rfc2047(void) const;

private:
	std::list<rfc2047_entry*> m_List;
	rfc2047_entry* m_pCurrentEntry;
	mime_code* m_coder;
	int   m_status;
	bool  m_stripSp;
	bool  m_addCrlf;
	char  m_lastCh;

public:
	// ºڲʹ

	int status_next(const char* s, int n);
	int status_data(const char* s, int n);
	int status_charset(const char* s, int n);
	int status_coding(const char* s, int n);
	int status_equal_question(const char* s, int n);
	int status_question_first(const char* s, int n);
	int status_question_second(const char* s, int n);
	int status_question_equal(const char* s, int n);
};

} // namespace acl
