#ifndef	__DICT_POOL_INCLUDE_H__
#define	__DICT_POOL_INCLUDE_H__

#include "lib_acl.h"
#include "dict.h"

#ifdef	__cplusplus
extern "C" {
#endif

typedef struct DICT_POOL DICT_POOL;

typedef struct DICT_POOL_DB DICT_POOL_DB;

/**
 * ʼܱһ
 */
DICT_API void dict_pool_init(void);

/**
 * һ洢
 * @param partions {const char*} 洢ַ
 * @param partions_size {int} partions ĸ
 * @param dict_type {const char*} 洢 (btree/hash/cdb)
 * @param dict_name {const char*} 洢
 * @param dict_size {int} ô洢رΪ洢
 * @return {DICT_POOL*} 洢صĶָ, Ϊ NULL ʾʧ
 */
DICT_API DICT_POOL *dict_pool_new(const char **partions, int partions_size,
	const char *dict_type, const char *dict_path,
	const char *dict_name, int pool_size);

/**
 * رղͷһ洢
 * @param pool {DICT_POOL*} ĳ洢صĶָ
 */
DICT_API void dict_pool_free(DICT_POOL *pool);

/**
 * һ key/value һ洢
 * @param pool {DICT_POOL*} ĳ洢صĶָ
 * @param key {char*} ֵַ
 * @param key_len {size_t} key ĳ
 * @param value {char*} ݵַ
 * @param len {size_t} value ݵĳȴС(ֽ)
 * @return {int} 0: OK, < 0: Error
 */
DICT_API int  dict_pool_set(DICT_POOL *pool, char *key, size_t key_len, char *value, size_t len);

/**
 * һ洢жȡ
 * @param pool {DICT_POOL*} ĳ洢صĶָ
 * @param key {char*} ֵַ
 * @param key_len {size_t} key ĳ
 * @param size {size_t*} 洢ݶĳȴС(ֽ)
 * @param {char*} ݵַΪʱʾö󲻴,
 * עصݵַΪգ÷ݶ
 *      acl_myfree/1 ͷŵ÷صĶ̬ڴַ
 */
DICT_API char *dict_pool_get(DICT_POOL *pool, char *key, size_t key_len, size_t *size);

/**
 * һ洢ɾ
 * @param pool {DICT_POOL*} ĳ洢صĶָ
 * @param key {char*} ֵַ
 * @param key_len {size_t} key ĳ
 * @return {int} 0: ok; != 0: error
 */
DICT_API int  dict_pool_del(DICT_POOL *pool, char *key, size_t key_len);

/**
 * 洢е
 * @param pool {DICT_POOL*} ĳ洢صĶָ
 * @param key {char**} ǿ洢ֵ, ֵΪգ
 *  ͷ key Ҫ: acl_myfree/1, ڴй¶
 * @param key_size {size_t*} ǿ洢ֵĳ
 * @param val {char**} ǿ洢ݽ, ֵΪգ
 *  ͷ val Ҫ: acl_myfree/1,  ڴй¶
 * @param val_size {size_t*} ǿ洢ݽĳ
 * @return {int} 0: ʾǿ, != 0: ʾΪ
 */
DICT_API int dict_pool_seq(DICT_POOL *pool, char **key, size_t *key_size,
        char **val, size_t *val_size);

/**
 * ô洢
 * @param pool {DICT_POOL*} ĳ洢صĶָ
 */
DICT_API void dict_pool_seq_reset(DICT_POOL *pool);

/**
 * ɾǰݱָ
 * @param pool {DICT_POOL*} ĳ洢صĶָ
 * @return {int} 0: ɾOK, != 0: ڻɾʧ
 */
DICT_API int dict_pool_seq_delcur(DICT_POOL *pool);

/**
 * ݽֵӴ洢лøýڵĴ洢DB
 * @param pool {DICT_POOL*} ĳ洢صĶָ
 * @param key {char*} ֵַ
 * @param key_len {size_t} key ĳ
 * @return {DICT_POOL_DB*} 洢DB
 */
DICT_API DICT_POOL_DB *dict_pool_db(DICT_POOL *pool, const char *key, size_t key_len);

/**
 * ĳ洢DBļȫ·
 * @param pool {DICT_POOL*} ĳ洢صĶָ
 * @return {const char*} 洢ļ
 */
DICT_API const char *dict_pool_db_path(DICT_POOL_DB *db);

/**
 * ĳ洢DB
 * @param {DICT_POOL_DB*} 洢DB
 */
DICT_API void dict_pool_db_lock(DICT_POOL_DB *db);

/**
 * ĳ洢DB
 * @param {DICT_POOL_DB*} 洢DB
 */
DICT_API void dict_pool_db_unlock(DICT_POOL_DB *db);

/**
 * ӻ޸
 * @param {DICT_POOL_DB*} 洢DB
 * @param key {char*} ֵַ
 * @param key_len {size_t} key ĳ
 * @param value {char*} ֵ
 * @param len {size_t} value 
 * @return {int} 0: ok; < 0: error
 */
DICT_API int  dict_pool_db_set(DICT_POOL_DB *db, char *key, size_t key_len, char *value, size_t len);

/**
 * Ӵ洢DBлĳӦֵ
 * @param {DICT_POOL_DB*} 洢DB
 * @param key {char*} ֵַ
 * @param key_len {size_t} key ĳ
 * @param size {size_t*} ѯǿ洢ؽĳ
 * @return {char*} Ӧֵ, Ҫ acl_myfree()/1 ͷ
 */
DICT_API char *dict_pool_db_get(DICT_POOL_DB *db, char *key, size_t key_len, size_t *size);

/**
 * Ӵ洢DBɾĳӦֵ
 * @param {DICT_POOL_DB*} 洢DB
 * @param key {char*} ֵַ
 * @param key_len {size_t} key ĳ
 * @return {int} 0: ok; != 0: error
 */
DICT_API int dict_pool_db_del(DICT_POOL_DB *db, char *key, size_t key_len);

/**
 * ֮ǰĴ洢DB
 * @param {DICT_POOL_DB*} 洢DB
 */
DICT_API void dict_pool_db_seq_reset(DICT_POOL_DB *db);

/**
 * ĳ洢DB
 * @param {DICT_POOL_DB*} 洢DB
 * @param key {char**} 洢ĵַ
 * @param key_size {size_t*} 洢 key ݵĳ
 * @param value {char**} 洢ֵĵַ
 * @param value_size {size_t*} 洢 value ݵĳ
 * @return {int} 0: ʾǿ, != 0: ʾΪ
 */
DICT_API int dict_pool_db_seq(DICT_POOL_DB *db, char **key, size_t *key_size,
        char **val, size_t *val_size);

#ifdef	__cplusplus
}
#endif

#endif
