#pragma once
#include "acl_cpp/acl_cpp_define.hpp"
#include <list>
#include "acl_cpp/ipc/ipc_service.hpp"
#include "acl_cpp/stdlib/string.hpp"

namespace acl {

typedef enum
{
	DB_OK,
	DB_ERR_OPEN,
	DB_ERR_EXEC_SQL,
} db_status;

//////////////////////////////////////////////////////////////////////////

class db_rows;

class ACL_CPP_API db_query
{
public:
	db_query(void) {}
	virtual ~db_query(void) {}

	virtual void on_error(db_status status) = 0;
	virtual void on_ok(const db_rows* rows, int affected) = 0;

	/**
	 * ϻʱڲ̻Զ destroy ӿڣ
	 * ڸýӿڽһЩͷẒ́䵱öǶ̬ʱ
	 * Ӧڸú delete this ɾԼΪúտ϶
	 * ᱻã಻Ӧط
	 */
	virtual void destroy(void) {}
protected:
private:
};

//////////////////////////////////////////////////////////////////////////

class db_handle;
class aio_socket_stream;

/**
 * ݿ࣬һ첽ݿ࣬ڵ̱߳
 * һ̹߳
 */
class ACL_CPP_API db_service : public ipc_service
{
public:
	/**
	 * Ϊ sqlite ݿʱĹ캯
	 * @param dblimit {size_t} ݿӳصĸ
	 * @param nthread {int} ̳߳ص߳
	 * @param win32_gui {bool} ǷǴϢǣڲ
	 *  ͨѶģʽԶΪ _WIN32 ϢȻͨõ׽
	 *  ͨѶʽ
	 */
	db_service(size_t dblimit = 100, int nthread = 2, bool win32_gui = false);
	virtual ~db_service(void);

	/**
	 * 첽ִ SQL ѯ
	 * @param sql {const char*} Ҫִеı׼ SQL 
	 * @param query {db_query*} ִн
	 */
	void sql_select(const char* sql, db_query* query);

	/**
	 * 첽ִ SQL 
	 * @param sql {const char*} Ҫִеı׼ SQL 
	 * @param query {db_query*} ִн
	 */
	void sql_update(const char* sql, db_query* query);

	/**
	 * ݿӳӶ
	 * @param db {db_handle*} ݿӶ
	 */
	void push_back(db_handle* db);
protected:
	/**
	 * Ҫʵִ˺ݿ
	 * @return {db_handle*}
	 */
	virtual db_handle* db_create() = 0;

	/**
	 * 麯ӵʱص˺
	 * @param client {aio_socket_stream*} յµĿͻ
	 */
	virtual void on_accept(aio_socket_stream* client);

#if defined(_WIN32) || defined(_WIN64)
	/**
	 * 麯յ̵߳ win32 ϢʱĻص
	 * @param hWnd {HWND} ھ
	 * @param msg {UINT} ûԶϢ
	 * @param wParam {WPARAM} 
	 * @param lParam {LPARAM} 
	 */
	virtual void win32_proc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);
#endif

private:
	// ݿ
	std::list<db_handle*> dbpool_;

	// ݿӳصĸ
	size_t dblimit_;

	// ǰݿӳصĸ
	size_t dbsize_;
};

} // namespace acl
