#include "stdafx.h"
#include "rpc_manager.h"
#include "status/HttpServerRpc.h"
#include "status/StatusConnection.h"
#include "status/StatusIOCallback.h"

StatusIOCallback::StatusIOCallback(StatusConnection* conn)
: conn_(conn)
{
}

StatusIOCallback::~StatusIOCallback()
{
	delete conn_;
}

// ݿɶʱ
bool StatusIOCallback::read_wakeup()
{
	// Ƚֹ첽
	conn_->get_conn()->disable_read();

	// һ http ˻Ự̣֮߳ȥ
	HttpServerRpc* rpc = new HttpServerRpc(conn_->get_conn());
	rpc_manager::get_instance().fork(rpc);
	return true;
}

// رʱûص
void StatusIOCallback::close_callback()
{
	// ɾԼ
	delete this;
}

bool StatusIOCallback::timeout_callback()
{
	logger_error("read timeout from: %s", conn_->get_peer());
	return false;
}
