#pragma once
#include "IConnection.h"

/**
 * Ӷ
 */
class ServerConnection : public IConnection
{
public:
	ServerConnection(acl::aio_socket_stream* conn);
	~ServerConnection() {}

	/**
	 * õǰĳʵӵĸ
	 * @param conns {unsigned int}
	 * @return {ServerConnection&}
	 */
	ServerConnection& set_conns(unsigned int conns)
	{
		conns_ = conns;
		return *this;
	}

	/**
	 * ǰĳʵĿͻ 1
	 * @return {ServerConnection&}
	 */
	ServerConnection& inc_conns();

	/**
	 * õǰĳʵӵĸ
	 * @return {unsigned int}
	 */
	unsigned int get_conns() const
	{
		return conns_;
	}

	/**
	 * õǰĳʵܹ
	 * @param n {unsigned int}
	 * @return {ServerConnection&}
	 */
	ServerConnection& set_used(unsigned int n)
	{
		used_ = n;
		return *this;
	}

	/**
	 * õǰĳʵܹ
	 * @return {unsigned int}
	 */
	unsigned int get_used() const
	{
		return used_;
	}

	/**
	 * õǰ˵ĳʵĽ̺
	 * @param pid {pid_t}
	 * @return {ServerConnection&}
	 */
	ServerConnection& set_pid(pid_t pid)
	{
		pid_ = pid;
		return *this;
	}

	/**
	 * õǰ˵ĳʵĽ̺
	 * @return {unsigned int}
	 */
	unsigned int get_pid() const
	{
		return pid_;
	}

	/**
	 * õǰ˵ĳʵ߳
	 * @param {unsigned int}
	 * @return {ServerConnection&}
	 */
	ServerConnection& set_max_threads(unsigned int n)
	{
		max_threads_ = n;
		return *this;
	}

	/**
	 * õǰ˵ĳʵ߳
	 * @return {unsigned int}
	 */
	unsigned int get_max_threads() const
	{
		return max_threads_;
	}

	/**
	 * õǰ˵ĳʵĵǰ߳
	 * @param n {unsigned int}
	 * @return {ServerConnection&}
	 */
	ServerConnection& set_curr_threads(unsigned int n)
	{
		curr_threads_ = n;
		return *this;
	}

	/**
	 * õǰ˵ĳʵĵǰ߳
	 * @return {unsigned int}
	 */
	unsigned int get_curr_threads() const
	{
		return curr_threads_;
	}

	/**
	 * õǰ˵ĳʵķæ߳
	 * @param n {unsigned int}
	 * @return {ServerConnection&}
	 */
	ServerConnection& set_busy_threads(unsigned int n)
	{
		busy_threads_ = n;
		return *this;
	}

	/**
	 * õǰ˵ĳʵķæ߳
	 * @return {unsigned int}
	 */
	unsigned int get_busy_threads() const
	{
		return busy_threads_;
	}

	/**
	 * õǰ˵ĳʵѹ
	 * @param n {unsigned int}
	 * @return {ServerConnection&}
	 */
	ServerConnection& set_qlen(unsigned int n)
	{
		qlen_ = n;
		return *this;
	}

	/**
	 * õǰ˵ĳʵѹ
	 * @return {unsigned int}
	 */
	unsigned int get_qlen() const
	{
		return qlen_;
	}

	/**
	 * õǰ˵ĳʵͱʶ
	 * @param type {const char*}
	 * @return {ServerConnection&}
	 */
	ServerConnection& set_type(const char* type)
	{
		type_ = type;
		return *this;
	}

	/**
	 * õǰ˵ĳʵͱʶ
	 * @return {unsigned int}
	 */
	const acl::string& get_type() const
	{
		return type_;
	}

	/**
	 * رշӣӹرʱᴥ ServiceIOCallback е
	 * close_callback ̣ͬʱ ServiceIOCallback 
	 * лɾ˱Ӷ
	 */
	void close();

protected:
	/**
	 * 麯ʵ
	 * @override
	 */
	void run();

private:
	unsigned int conns_;
	unsigned int used_;
	pid_t pid_;
	acl::string type_;
	unsigned int max_threads_;
	unsigned int curr_threads_;
	unsigned int busy_threads_;
	unsigned int qlen_;
};
