#pragma once
#include "acl_cpp/stream/aio_handle.hpp"
#include "acl_cpp/stream/aio_listen_stream.hpp"
#include "acl_cpp/master/master_base.hpp"

struct ACL_VSTREAM;

namespace acl {

class aio_handle;
class aio_socket_stream;

/**
 * acl_master е̷߳ʽģֻ࣬һʵ
 */
class ACL_CPP_API master_aio : public master_base, public aio_accept_callback
{
public:
	/**
	 * ʼУøúָ÷ acl_master 
	 * ֮Уһ״̬
	 * @param argc {int}  main дݵĵһʾ
	 * @param argv {char**}  main дݵĵڶ
	 */
	void run_daemon(int argc, char** argv);

	/**
	 * ڵʱĴûԵô˺һЩҪĵԹ
	 * @param addrs {const char*} ַбʽIP:PORT, IP:PORT...
	 * @param path {const char*} ļȫ·
	 * @param ht {aio_handle_type} ¼
	 * @return {bool} Ƿɹ
	 */
	bool run_alone(const char* addrs, const char* path = NULL,
		aio_handle_type ht = ENGINE_SELECT);

	/**
	 * 첽IO¼ͨ˾ûöʱȹ
	 * @return {aio_handle*}
	 */
	aio_handle* get_handle() const;

	/**
	 *  run_alone ģʽ£֪ܹͨر棬˳
	 */
	void stop();

protected:
	master_aio();
	virtual ~master_aio();

	/**
	 * 麯յһͻʱô˺
	 * @param stream {aio_socket_stream*} ½յĿͻ첽
	 * @return {bool} ú false ֪ͨܲٽ
	 *  Զ̿ͻӣտͻ
	 */
	virtual bool on_accept(aio_socket_stream* stream) = 0;

private:
	/**
	 *  aio_accept_callback 麯ʵ
	 * @param client {aio_socket_stream*} 첽ͻ
	 * @return {bool}  true ֪ͨ
	 */
	virtual bool accept_callback(aio_socket_stream* client);

private:
#if defined(_WIN32) || defined(_WIN64)
	// յһͻʱص˺
	static void service_main(SOCKET, void*);
#else
	static void service_main(int, void*);
#endif

	// һַʱص˺
	static void service_on_listen(ACL_VSTREAM*);

	// лûݺõĻص
	static void service_pre_jail(void*);

	// лûݺõĻص
	static void service_init(void*);

	// ˳ʱõĻص
	static void service_exit(void*);
};

}  // namespace acl
