#pragma once
#include "acl_cpp/acl_cpp_define.hpp"

namespace acl {

class dbuf_guard;
class string;
class ostream;
class socket_stream;
class http_header;
class http_client;
class HttpCookie;
class HttpServletRequest;

/**
 *  HTTP ͻӦص࣬಻Ӧ̳УûҲҪ
 * 򴴽
 */
class ACL_CPP_API HttpServletResponse
{
public:
	/**
	 * 캯
	 * @param stream {socket_stream&} ڲԶر
	 */
	HttpServletResponse(socket_stream& stream);
	~HttpServletResponse(void);

	/**
	 *  HTTP Ӧĳ
	 * @param n {acl_int64} 峤
	 */
#if defined(_WIN32) || defined(_WIN64)
	HttpServletResponse& setContentLength(__int64 n);
#else
	HttpServletResponse& setContentLength(long long int n);
#endif

	/**
	 *  HTTP chunked ģʽ
	 * @param on {bool} Ϊ trueʹ setContentLength
	 *  ڲҲ chunked ䷽ʽ HTTP RFC 淶Ҫ
	 *  chunked ȼ߼ conteng-length ʽ
	 * @return {HttpServletResponse&}
	 */
	HttpServletResponse& setChunkedTransferEncoding(bool on);

	/**
	 *  HTTP ͻ˱ϵ
	 * @param on {bool}
	 * @return {HttpServletResponse&}
	 */
	HttpServletResponse& setKeepAlive(bool on);

	/**
	 *  HTTP Ӧ Content-Type ֵֵֶֶΪ
	 * text/html  text/html; charset=utf8 ʽ
	 * @param value {const char*} ֵֶ
	 * @return {HttpServletResponse&}
	 */
	HttpServletResponse& setContentType(const char* value);

	/**
	 *  HTTP Ӧ gzip ѹʽ
	 * @param gzip {bool} Ƿ gzip ѹʽ
	 * @return {HttpServletResponse&}
	 */
	HttpServletResponse& setContentEncoding(bool gzip);

	/**
	 *  HTTP ӦַѾ setContentType 
	 * ַͲٵñַ
	 * @param charset {const char*} Ӧݵַ
	 * @return {HttpServletResponse&}
	 */
	HttpServletResponse& setCharacterEncoding(const char* charset);

	/**
	 *  HTTP Ӧͷеڸʽֶ
	 * @param name {const char*} HTTP Ӧͷеֶ
	 * @param value {time_t} ʱֵ
	 */
	HttpServletResponse& setDateHeader(const char* name, time_t value);

	/**
	 *  HTTP Ӧͷеַʽֶ
	 * @param name {const char*} HTTP Ӧͷеֶ
	 * @param value {const char*} ֵֶ
	 */
	HttpServletResponse& setHeader(const char* name, const char* value);

	/**
	 *  HTTP Ӧͷеʽֶ
	 * @param name {const char*} HTTP Ӧͷеֶ
	 * @param value {int} ֵֶ
	 */
	HttpServletResponse& setHeader(const char* name, int value);

	/**
	 * ڷأñصƫλã± 0 ʼ
	 * @param from {http_off_t} ʼƫλã± 0 ʼ㣩
	 * @param to {http_off_t} λãֵСݳȣ
	 * @param total {http_off_t} ݳȣԴΪһ̬ļʱֵ
	 *  ӦڸļܳȴС
	 * @return {HttpServletResponse&}
	 */
#if  defined(_WIN32) || defined(_WIN64)
	HttpServletResponse& setRange(__int64 from,
		__int64 to, __int64 total);
#else
	HttpServletResponse& setRange(long long from,
		long long to, long long total);
#endif

	/**
	 *  HTTP Ӧͷе״̬룺1xx, 2xx, 3xx, 4xx, 5xx
	 * @param status {int} HTTP Ӧ״̬, 磺200
	 */
	HttpServletResponse& setStatus(int status);

	/**
	 * Ϊ CGI ģʽûһ㲻ֹãΪ HttpServlet 
	 * ԶǷ CGI ģʽ
	 * @param on {bool} Ƿ CGI ģʽ
	 */
	HttpServletResponse& setCgiMode(bool on);

	/**
	 *  HTTP Ӧͷеض location ֶ
	 * @param location {const char*} URLǿ
	 * @param status {int} HTTP Ӧ״̬룬һΪ 3xx 
	 */
	HttpServletResponse& setRedirect(const char* location, int status = 302);

	/**
	 *  cookie 󣬸öǶ̬ģûԼ
	 * ʾͷŸöΪڲԶͷ
	 * @param cookie {HttpCookie*}
	 */
	HttpServletResponse& addCookie(HttpCookie* cookie);

	/**
	 *  cookie
	 * @param name {const char*} cookie 
	 * @param value {const char*} cookie ֵ
	 * @param domain {const char*} cookie 洢
	 * @param path {const char*} cookie 洢·
	 * @param expires {time_t} cookie ʱǰʱ
	 *  ֵΪ cookie Ĺʱ()
	 */
	HttpServletResponse& addCookie(const char* name, const char* value,
		const char* domain = NULL, const char* path = NULL,
		time_t expires = 0);

	/**
	 *  url  url 
	 * @param out {string&} 洢Ľ
	 * @param url {const char*} δǰԭʼ url
	 */
	void encodeUrl(string& out, const char* url);

	/**
	 *  HTTP Ӧͷ
	 * @return {http_header&}
	 */
	http_header& getHttpHeader(void) const;

	/**
	 * ͻ˷ HTTP Ӧݣѭô˺
	 * ͨ setChunkedTransferEncoding  chunked ䷽ʽ
	 * ڲԶ chunked ䷽ʽô˺ʽ
	 * sendHeader  HTTP ӦͷΪڲԶڵһ
	 * дʱ HTTP Ӧͷ⣬ʹ chunked ʽʱ
	 * ӦӦٵһαҲΪ 0 ʾݽ
	 * @param data {const void*} ݵַ
	 * @param len {size_t} data ݳ
	 * @return {bool} Ƿɹ false ʾж
	 */
	bool write(const void* data, size_t len);

	/**
	 * ͻ˷ HTTP Ӧݣѭô˺ú
	 * ڲ HttpServletResponse::write(const void*, size_t) ̣
	 * ⣬ʹ chunked ʽʱӦӦٵһα
	 * մ buf.empty() == true
	 * @param buf {const string&} ݻ
	 * @return {bool} Ƿɹ false ʾж
	 */
	bool write(const string& buf);

	/**
	 * ʽʽ HTTP ͻ˷ӦݣڲԶ
	 * HttpServletResponse::write(const void*, size_t) ̣ʹ
	 * chunked ʽʱӦӦٵ write(NULL, 0)
	 * ʾݽ
	 * @param fmt {const char*} θʽַ
	 * @return {int} ɹ򷵻ֵ > 0򷵻 -1
	 */
	int format(const char* fmt, ...) ACL_CPP_PRINTF(2, 3);

	/**
	 * ʽʽ HTTP ͻ˷ӦݣڲԶ
	 * HttpServletResponse::write(const string&) ̣ʹ chunked
	 * ʽʱӦӦٵ write(NULL, 0) ʾݽ
	 * @param fmt {const char*} θʽַ
	 * @param ap {va_list} б
	 * @return {int} ɹ򷵻ֵ > 0򷵻 -1
	 */
	int vformat(const char* fmt, va_list ap);

	///////////////////////////////////////////////////////////////////

	/**
	 *  HTTP ӦͷûӦ÷ǰô˺ HTTP
	 * Ӧͷ͸ͻ
	 * @return {bool} Ƿɹ false ʾжϣ
	 *  ϼдĺʱʽã
	 *  ͨ getOutputStream õ socket дʱ򱾺
	 *  ʽ
	 */
	bool sendHeader(void);

	/**
	 *  HTTP Ӧûڵ sendHeader 
	 *  HTTP Ӧͷͨ HTTP 
	 * @return {ostream&}
	 */
	ostream& getOutputStream(void) const;

	/**
	 *  HTTP ˫ɹ캯Ĳ
	 * @return {socket_stream&}
	 */
	socket_stream& getSocketStream(void) const;

	/**
	 * õײ http_client ͨŶ
	 * @return {http_client*}  NULL
	 */
	http_client* getClient() const
	{
		return client_;
	}

	/**
	 *  http 󣬸úĿǰֻӦ HttpServlet ڲ
	 * @param request {HttpServletRequest*}
	 */
	void setHttpServletRequest(HttpServletRequest* request);

private:
	dbuf_guard* dbuf_internal_;
	dbuf_guard* dbuf_;
	socket_stream& stream_;		// ͻ
	HttpServletRequest* request_;	// http 
	http_client* client_;		// http Ӧ
	http_header* header_;		// http Ӧͷ
	char  charset_[32];		// ַ
	char  content_type_[32];	// content-type 
	bool  head_sent_;		// ǷѾ HTTP Ӧͷ
};

}  // namespace acl
