#pragma once
#include "acl_cpp/acl_cpp_define.hpp"
#include "acl_cpp/stdlib/string.hpp"
#include "acl_cpp/db/db_handle.hpp"

typedef struct sqlite3 sqlite3;

namespace acl {

class charset_conv;

class ACL_CPP_API db_sqlite : public db_handle
{
public:
	/**
	 * 캯
	 * @param charset {const char*} ַ(gbk, utf-8, ...)
	 */
	db_sqlite(const char* dbfile, const char* charset = "utf-8");
	~db_sqlite(void);

	/**
	 * صǰ sqlite İ汾Ϣ
	 */
	const char* version(void) const;

	/**
	 * ݿ򿪺ͨ˺ݿĲã
	 * õҪϸѭ sqlite ѡҪ
	 * @param pragma {const char*} ѡݣʽΪ
	 *  PRAGMA xxx=xxx
	 *  磺PRAGMA synchronous = NORMAL
	 * @return {bool} ݿǷɹ
	 */
	bool set_conf(const char* pragma);

	/**
	 * ݿ򿪵ô˺ѡ
	 * @param pragma {const char*} ѡݣʽΪ
	 *  PRAGMA xxx
	 *  磺PRAGMA synchronous
	 * @param out {string&} ֵǿ洢
	 * @return {const char*} Ϊ˵òڻݿδ
	 */
	const char* get_conf(const char* pragma, string& out);

	/**
	 * ݿ򿪵ݿѡ
	 * @param pragma {const char*} ָѡòΪգ
	 *  еѡʽΪPRAGMA xxx磺PRAGMA synchronous
	 */
	void show_conf(const char* pragma = NULL);

	/**
	 * ݿ򿪺еӰļ¼
	 * @return {int} Ӱ-1 ʾ
	 */
	int affect_total_count() const;

	/**
	 * ֱӻ sqlite ľ NULL ʾ sqlite ûд
	 * ʱڲԶر sqlite
	 * @return {sqlite3*}
	 */
	sqlite3* get_conn() const
	{
		return db_;
	}

	/********************************************************************/
	/*            Ϊ db_handle ӿ                         */
	/********************************************************************/

	/**
	 * ݿ
	 * @return {const char*}
	 */
	const char* dbtype() const;

	/**
	 * ϴݿĳ
	 * @return {int}
	 */
	int get_errno() const;

	/**
	 * ϴݿĳ
	 * @return {const char*}
	 */
	const char* get_error() const;

	/**
	 *  db_handle Ĵӿ
	 * @param charset {const char*} ݿʱõַ
	 *  ǿʱḲǹ캯дַ
	 * @return {bool} Ƿɹ
	 */
	bool dbopen(const char* charset = NULL);

	/**
	 *  db_handle ĴӿڣݿǷѾ
	 * @return {bool}  true ݿѾ
	 */
	bool is_opened() const;

	/**
	 *  db_handle Ĵӿ
	 * @return {bool} رǷɹ
	 */
	bool close(void);

	/**
	 *  db_handle Ĵӿڣʵִ˽ӿжݱǷ
	 * @return {bool} Ƿ
	 */
	bool tbl_exists(const char* tbl_name);

	/**
	 *  db_handle Ĵӿ
	 * @param sql {const char*} ׼ SELECT SQL 䣬һҪ
	 *  ע SQL 뾭ת崦Էֹ SQL ע빥
	 * @param result {db_rows*} ǿգ򽫲ѯýУ
	 *  򣬻 db_handle ڲһʱ洢
	 * @return {bool} ִǷɹ
	 */
	bool sql_select(const char* sql, db_rows* result = NULL);

	/**
	 *  db_handle Ĵӿ
	 * @param sql {const char*} ׼ INSERT/UPDATE/DELETE SQL 䣬
	 *  һҪע SQL 뾭ת崦Էֹ SQL ע빥
	 * @return {bool} ִǷɹ
	 */
	bool sql_update(const char* sql);

	/**
	 *  db_handle Ĵӿڣϴ sql Ӱļ¼
	 * @return {int} Ӱ-1 ʾ
	 */
	int affect_count() const;

private:
	// sqlite 
	sqlite3* db_;

	// ݴ洢ļ
	string dbfile_;

	// ַת
	charset_conv* conv_;

	// ַ
	string charset_;

	// ִSQLѯĺ
	bool exec_sql(const char* sql, db_rows* result = NULL);
};

} // namespace acl
