#pragma once
#include "acl_cpp/acl_cpp_define.hpp"
#include <map>
#include "acl_cpp/stdlib/string.hpp"
#include "acl_cpp/redis/redis_command.hpp"

namespace acl
{

class redis_client;
class redis_result;

class ACL_CPP_API redis_server : virtual public redis_command
{
public:
	/**
	 * see redis_command::redis_command()
	 */
	redis_server(void);

	/**
	 * see redis_command::redis_command(redis_client*)
	 */
	redis_server(redis_client* conn);

	/**
	 * see redis_command::redis_command(redis_client_cluster*, size_t)
	 */
	redis_server(redis_client_cluster* cluster, size_t max_conns = 0);

	virtual ~redis_server(void);

	/////////////////////////////////////////////////////////////////////

	
	/**
	 * ִһ AOFļ ддᴴһǰ AOF ļŻ汾
	 * ʹ BGREWRITEAOF ִʧܣҲκݶʧΪɵ AOF ļ
	 * BGREWRITEAOF ɹ֮ǰᱻ޸
	 * @return {bool}
	 */
	bool bgrewriteaof(void);

	/**
	 * ں̨첽(Asynchronously)浱ǰݿݵ̣BGSAVE ִ֮
	 *  OK Ȼ Redis fork һӽ̣ԭ Redis ()
	 * ͻ󣬶ӽݱ浽̣Ȼ˳ͻ˿ͨ
	 * LASTSAVE 鿴Ϣж BGSAVE Ƿִгɹ
	 * @return {bool}
	 */
	bool bgsave(void);

	/**
	 *  CLIENT SETNAME Ϊõ
	 * @param buf {string&} 洢ûΪ
	 * @return {bool}  false ûֻ
	 */
	bool client_getname(string& buf);

	/**
	 * رյַΪ ip:port Ŀͻ
	 * @param addr {const char*} ͻӵַʽip:port
	 * @return {bool} Ƿɹ false Ӳڻ
	 */
	bool client_kill(const char* addr);

	/**
	 * ӵĿͻϢͳ
	 * @param buf {string&} 洢
	 * @return {int} ؽݳȣ-1 ʾ
	 */
	int client_list(string& buf);

	/**
	 * Ϊǰӷһֻ֣ CLIENT LIST ĽУ
	 *  Redis Ӧóй©ʱΪһֺܺõ debug ֶ
	 * @param name {const char*} ֲ֣ҪΨһ
	 * @return {bool} Ƿɹ
	 */
	bool client_setname(const char* name);

	/**
	 * ȡе Redis ò
	 * @param parameter {const char*} ò
	 * @param out {std::map<string, string>&} 洢 name-value ɣ
	 *  Ϊ parameter ֧ģƥ䣬пܷصĽлж
	 * @return {int}  "-ֵ" ĸ-1 ʾ
	 */
	int config_get(const char* parameter, std::map<string, string>& out);

	/**
	 *  INFO еĳЩͳ
	 * @return {bool} Ƿɹ
	 */
	bool config_resetstat(void);

	/**
	 *  Redis ʱָ redis.conf ļид
	 * @return {bool} дǷɹ
	 */
	bool config_rewrite(void);

	/**
	 * ̬ص Redis ö
	 * @param name {const char*} ò
	 * @param value {const char*} òֵ
	 * @return {bool} Ƿɹ
	 */
	bool config_set(const char* name, const char* value);

	/**
	 * صǰݿ key 
	 * @return {int}  -1 ʾ
	 */
	int dbsize(void);

	/**
	 *  Redis (ɾݿ key )
	 * @return {bool}
	 *  עҪã
	 */
	bool flushall(void);

	/**
	 * յǰݿе key
	 * @return {bool}
	 *  עҪã
	 */
	bool flushdb(void);

	/**
	 * ع Redis ĸϢͳֵ
	 * @param buf {string&} 洢
	 * @return {int} 洢ݳ
	 */
	int info(string& buf);

	/**
	 * ع Redis ĸϢͳֵ
	 * @param out {std::map<string, string>&} 洢
	 * @return {int} 洢Ŀ, -1 ʾ
	 */
	int info(std::map<string, string>& out);

	/**
	 * һ Redis ɹݱ浽ϵʱ䣬 UNIX ʱʽʾ
	 * @return {time_t}
	 */
	time_t lastsave(void);

	/**
	 * ʵʱӡ Redis յ; ñѭ
	 * get_command ÷յ
	 * @return {bool}
	 */
	bool monitor(void);

	/**
	 *  monitor Ҫñ÷յѭñ
	 * Աڲϵػ÷յ
	 * @param buf {string&} 洢
	 * @return {bool}
	 */
	bool get_command(string& buf);

	/**
	 * ִһͬǰ Redis ʵݿ(snapshot)
	 *  RDB ļʽ浽Ӳ
	 * @return {bool}
	 */
	bool save(void);

	/**
	 * ֹͣпͻӽݱ̺˳
	 * @param save_data {bool} Ƿ˳ǰ
	 */
	void shutdown(bool save_data = true);

	/**
	 * ǰתΪָĴ
	 * @param ip {const char*} ָ IP
	 * @param port {int} ָĶ˿
	 * @return {bool} Ƿɹ
	 */
	bool slaveof(const char* ip, int port);

	/**
	 * ѯĲ־
	 * @param number {int}  0 ʱ޶־г־
	 * @return {const redis_result*}
	 */
	const redis_result* slowlog_get(int number = 0);

	/**
	 * Բ鿴ǰ־
	 * @return {int}
	 */
	int slowlog_len(void);

	/**
	 *  slow log
	 * @return {bool}
	 */
	bool slowlog_reset(void);

	/**
	 * صǰʱ
	 * @param stamp {time_t&} 洢ʱ( UNIX ʱʽʾ)
	 * @param escape {int*} 洢ǰһѾȥ΢
	 */
	bool get_time(time_t& stamp, int& escape);
};

} // namespace acl
