#pragma once
#include "acl_cpp/acl_cpp_define.hpp"
#include <list>
#include "acl_cpp/stdlib/locker.hpp"

namespace acl
{

class connect_manager;
class connect_client;

/**
 * ͻӳ࣬ʵֶӳصĶ̬Ϊ࣬Ҫʵ
 * 麯 create_connect ڴ˵һӣ
 * ͨ set_delay_destroy() ӳʱʵ
 * Ƕ̬
 */
class ACL_CPP_API connect_pool
{
public:
	/**
	 * 캯
	 * @param addr {const char*} ַʽip:port(domain:port)
	 * @param max {size_t} ӳӸƣֵΪ 0
	 *  ӳص
	 * @param idx {size_t} ӳضڼе±λ( 0 ʼ)
	 */
	connect_pool(const char* addr, size_t max, size_t idx = 0);

	/**
	 * ൱ʱʵӦΪ̬
	 */
	virtual ~connect_pool();

	/**
	 * ˽ӿóʱʱ
	 * @param conn_timeout {int} ӳʱʱ()
	 * @param rw_timeout {int}  IO ʱʱ()
	 */
	connect_pool& set_timeout(int conn_timeout, int rw_timeout);

	/**
	 * ӳ쳣ʱ
	 * @param retry_inter {int} ӶϿٴδӵʱ()
	 *  ֵ <= 0 ʱʾӶϿ볬ʱ
	 *  ϿδñʱڲȱʡֵΪ 1 
	 * @return {connect_pool&}
	 */
	connect_pool& set_retry_inter(int retry_inter);

	/**
	 * ӳпӵĿ
	 * @param ttl {time_t} ӵڣֵ < 0 ʾӲڣ
	 *  == 0 ʱʾ̹ڣ> 0 ʾиʱκ󽫱ͷ
	 * @return {connect_pool&}
	 */
	connect_pool& set_idle_ttl(time_t ttl);

	/**
	 * ԶӵʱȱʡֵΪ 30 
	 * @param n {int} ʱ
	 * @return {connect_pool&}
	 */
	connect_pool& set_check_inter(int n);

	/**
	 * ӳгԻȡһӣáϴη쳣ʱ
	 * δڻӳӸﵽ򽫷 NULLһµ
	 * ʱʧܣӳػᱻΪ״̬
	 * @return {connect_client*} Ϊʾ÷ӳض󲻿
	 */
	connect_client* peek();

	/**
	 * ͷһӳУӳضӦķûϣرոʱ
	 * ӽᱻֱͷ
	 * @param conn {redis_client*}
	 * @param keep {bool} ǷԸӱֳ
	 */
	void put(connect_client* conn, bool keep = true);

	/**
	 * ӳпеӣڵͷŵ
	 * @param ttl {time_t} ʱֵӽͷ
	 * @param exclusive {bool} ڲǷҪ
	 * @return {int} ͷŵĿӸ
	 */
	int check_idle(time_t ttl, bool exclusive = true);

	/**
	 * ӳصĴ״̬
	 * @param ok {bool} øǷ
	 */
	void set_alive(bool ok /* true | false */);

	/**
	 * ӳǷӳʱúӳǷӦԶָ
	 * ָ򽫸ӳΪ״̬
	 * @return {bool}  true ʾǰӳش״̬ʾǰӳز
	 */
	bool aliving();

	/**
	 * ȡӳصķַ
	 * @return {const char*} طǿյַ
	 */
	const char* get_addr() const
	{
		return addr_;
	}

	/**
	 * ȡӳƣֵΪ 0 ʾû
	 * @return {size_t}
	 */
	size_t get_max() const
	{
		return max_;
	}

	/**
	 * ȡӳصǰ
	 * @return {size_t}
	 */
	size_t get_count() const
	{
		return count_;
	}

	/**
	 * øӳضӳؼе±λ
	 * @return {size_t}
	 */
	size_t get_idx() const
	{
		return idx_;
	}

	/**
	 * ͳƼ
	 * @param inter {int} ͳƵʱ
	 */
	void reset_statistics(int inter)
	{
		time_t now = time(NULL);
		lock_.lock();
		if (now - last_ >= inter)
		{
			last_ = now;
			current_used_ = 0;
		}
		lock_.unlock();
	}

	/**
	 * ȡӳܹʹõĴ
	 */
	unsigned long long get_total_used() const
	{
		return total_used_;
	}

	/**
	 * ȡӳصǰʹô
	 * @return {unsigned long long}
	 */
	unsigned long long get_current_used() const
	{
		return current_used_;
	}

protected:
	/**
	 * 麯Ҫʵ
	 * @return {connect_client*}
	 */
	virtual connect_client* create_connect() = 0;

	friend class connect_manager;

	/**
	 * øӳضΪӳ٣ڲüΪ 0 ʱ
	 */
	void set_delay_destroy();

protected:
	bool  alive_;				// Ƿ
	bool  delay_destroy_;			// Ƿӳ
	// ķĿԵʱӳضٴαõʱ
	int   retry_inter_;
	time_t last_dead_;			// ӳضϴβʱʱ

	char  addr_[256];			// ӳضӦķַIP:PORT
	int   conn_timeout_;			// ӳʱʱ()
	int   rw_timeout_;			//  IO ʱʱ()
	size_t idx_;				// ӳضڼе±λ
	size_t max_;				// 
	size_t count_;				// ǰ
	time_t idle_ttl_;			// ӵ
	time_t last_check_;			// ϴμӵʱ
	int   check_inter_;			// ӵʱ

	locker lock_;				//  pool_ ʱĻ
	unsigned long long total_used_;		// ӳصз
	unsigned long long current_used_;	// ĳʱڵķ
	time_t last_;				// ϴμ¼ʱ
	std::list<connect_client*> pool_;	// ӳؼ
};

class ACL_CPP_API connect_guard
{
public:
	connect_guard(connect_pool& pool)
		: keep_(true), pool_(pool), conn_(NULL)
	{
	}

	virtual ~connect_guard(void)
	{
		if (conn_)
			pool_.put(conn_, keep_);
	}

	void set_keep(bool keep)
	{
		keep_ = keep;
	}

	connect_client* peek(void)
	{
		conn_ = pool_.peek();
		return conn_;
	}

protected:
	bool keep_;
	connect_pool& pool_;
	connect_client* conn_;
};

} // namespace acl
