#ifndef	__HTTP_PLUGIN_INCLUDE_H__
#define	__HTTP_PLUGIN_INCLUDE_H__

#include "lib_acl.h"
#include "lib_protocol.h"

#ifdef	__cplusplus
extern "C" {
#endif

#ifdef _USRDLL
# ifdef GBFILTER_EXPORTS
#  define HTTP_PLUGIN_API __declspec(dllexport)
# else
#  define HTTP_PLUGIN_API __declspec(dllimport)
# endif
#else
#  define HTTP_PLUGIN_API
#endif

/**
 * HTTP ʼעắ, úǿգڸտʼʱ
 * @param dll_env {ACL_DLL_ENV*} DLL , dll_env->logfp ־ļ,
 *  ϣ־־ļУԽֵÿ
 * @param cfg_dir {const char*} ļ··´ж̬ļ
 */
HTTP_PLUGIN_API void http_plugin_init(ACL_DLL_ENV *dll_env, const char *cfg_dir);

/**
 * HTTP עắúǿգյHTTPͷʱ
 * @param client {ACL_VSTREAM*} ͻ
 * @param hdr_req {HTTP_HDR_REQ*} HTTPͷ
 * @param ctx_ptr {void**} ָ洢ûĶ̬
 * @return {int} < 0: ʾֹHTTP, ֵʾţΪ-5xx/-4xx;
 *  0: ʾHTTP; > 0: ʾHTTPģĵ
 *  ̴߳
 */
HTTP_PLUGIN_API int http_request_filter(ACL_VSTREAM *client, HTTP_HDR_REQ *hdr_req, void **ctx_ptr);

/**
 * HTTP ӹܴעắúǿգ http_request_filter() > 0
 * ô˺ȫӹܸHTTPӦٴHTTPHTTPӦ
 * @param client {ACL_VSTREAM*} HTTPͻ
 * @param hdr_req {HTTP_HDR_REQ*} ͻHTTPͷ
 * @param ctx {void*} Ĳö̬ http_request_filter е ctx_ptr
 *  ص
 */
HTTP_PLUGIN_API void http_request_forward(ACL_VSTREAM *client, HTTP_HDR_REQ *hdr_req, void *ctx);

/**
 * HTTP ӦעắúǿգյHTTPӦͷʱ
 * @param client {ACL_VSTREAM*} HTTPͻ
 * @param server {ACL_VSTREAM*} HTTP
 * @param hdr_req {HTTP_HDR_REQ*} HTTPͷ
 * @param hdr_res {HTTP_HDR_RES*} HTTPӦͷ
 * @param ctx_ptr {void**} ָ洢ûĶ̬
 * @return {int} 0: ʾHTTPӦ; !0: ʾHTTPӦ
 *  ģĵ̴߳
 */
HTTP_PLUGIN_API int http_respond_filter(ACL_VSTREAM *client, ACL_VSTREAM *server,
	HTTP_HDR_REQ *hdr_req, HTTP_HDR_RES *hdr_res, void **ctx_ptr);

/**
 * HTTP Ӧӹܴעắúǿգ http_respond_filter() > 0, 
 * ô˺ȫӹܸHTTPӦ̣ٴHTTPHTTPӦ
 * @param client {ACL_VSTREAM*} HTTPͻ
 * @param server {ACL_VSTREAM*} HTTP
 * @param hdr_req {HTTP_HDR_REQ*} ͻHTTPͷ
 * @param hdr_res {HTTP_HDR_RES*} HTTPӦͷ
 * @param ctx {void*} Ĳö̬ http_respond_filter е ctx_ptr
 *  ص
 */
HTTP_PLUGIN_API void http_respond_forward(ACL_VSTREAM *client, ACL_VSTREAM *server,
	HTTP_HDR_REQ *hdr_req, HTTP_HDR_RES *hdr_res, void *ctx);

/**
 * HTTP ӦעắԽԴתΪĿ
 * @param data {const char*} Դ
 * @param dlen {int} data 
 * @param ret {int*} ݵĳ, < 0 ʾ
 * @param stop {int*} ֹһ
 * @param ctx {void*} Ĳö̬ http_respond_filter е ctx_ptr
 *  ص
 * @return {char*} , Ϊʾǰݲ
 */
HTTP_PLUGIN_API char *http_respond_dat_filter(const char *data, int dlen,
                int *ret, int *stop, void *ctx);

/**
 * ͷ http_respond_dat_filter Ķ̬ݵעắ
 * @param buf {void*} µĶ̬ݵַ
 * @param ctx {void*} Ĳö̬ http_respond_filter е ctx_ptr
 *  ص
 */
HTTP_PLUGIN_API void http_respond_dat_free(void *buf, void *ctx);

/*---------------------------------------------------------------------------*/

#define	DEBUG_BASE	500
#define	DBG_REQ		(DEBUG_BASE + 1)
#define	DBG_RES		(DEBUG_BASE + 2)

#define	STR	acl_vstring_str
#define	LEN	ACL_VSTRING_LEN

/* ȫñ */

extern char *var_cfg_log_name;
extern int   var_cfg_data_clone;
extern int   var_cfg_rewrite_enable;

/* in http_conf.c */

/**
 * ļ
 * @param cfg_dir {const char*} ļڵĿ¼λ
 */
void http_conf_load(const char *cfg_dir);

/* in http_plugin.c */

/**
 * ̳߳
 * @param threads_limit {int} ̸̳߳߳
 * @param threads_idle {int} ̳߳ÿ̵߳ʱ()
 */
void http_plugin_pool_create(int threads_limit, int threads_idle);

/**
 * ̳߳ûӵ̳߳еĳ߳̽ӹ
 * @param start_routine {void (*)(void*)} ûӵص
 * @param arg {void*} ̳߳еĳ̻߳ص start_routine ʱĻص
 */
void http_plugin_pool_append(void (*start_routine)(void *), void *arg);

/**
 * Ҫڴ״̬ʱĺ
 * @param level {int} Լ𣬿õļΪ: 1, 2, 3
 */
void http_plugin_debug_memory(int level);

#ifdef	__cplusplus
}
#endif

#endif
