#pragma once
#include "acl_cpp/acl_cpp_define.hpp"
#include <vector>
#include <list>
#include "acl_cpp/stdlib/dbuf_pool.hpp"
#include "acl_cpp/stdlib/string.hpp"
#include "acl_cpp/stdlib/pipe_stream.hpp"

struct ACL_TOKEN;
struct ACL_ITER;

/**
 *  ACL  XML ķװ C++ ûʹã̫עأ
 * ֱʹø࣬ڷִҷǳעܣֱʹ ACL 
 * XML ΪҲǵ ACL е XML ̣жο
 * ̣ܻ΢ӰһЩܣһӦӰ΢
 */

namespace acl {

class xml;
class xml_node;
class istream;

class ACL_CPP_API xml_attr : public dbuf_obj
{
public:
	/**
	 * 
	 * @return {const char*} Զ᷵ؿָ룬ֵ
	 *  пΪ "\0"
	 */
	virtual const char* get_name(void) const = 0;

	/**
	 * ֵ
	 * @return {const char*} ֵԶ᷵ؿָ룬ֵ
	 *  пΪ "\0"
	 */
	virtual const char* get_value(void) const = 0;

protected:
	friend class xml_node;

	xml_attr(xml_node* node) : node_(node) {}
	virtual ~xml_attr(void) {}

	xml_node* node_;
};

class ACL_CPP_API xml_node : public dbuf_obj
{
public:
	/**
	 * ȡñ XML ڵıǩ
	 * @return {const char*}  XML ڵǩؿգ˵
	 *  ڱǩ xxxxԷһҪжϷֵ
	 */
	virtual const char* tag_name(void) const = 0;

	/**
	 *  XML ڵ ID Բڣ򷵻ؿָ
	 * @return {const char*}  ID ԴʱضӦֵ򷵻ؿ
	 */
	virtual const char* id(void) const = 0;

	/**
	 * ظ XML ڵ
	 * @return {const char*} ؿ˵û
	 */
	virtual const char* text(void) const = 0;

	/**
	 * ظ XML ڵĳֵ
	 * @param name {const char*} 
	 * @return {const char*} ֵؿ˵Բ
	 */
	virtual const char* attr_value(const char* name) const = 0;

	/**
	 * ظ XML ڵĳֵıд
	 * @param name {const char*} 
	 * @return {const char*} ֵؿ˵Բ
	 */
	const char* operator[](const char* name) const;

	/**
	 * ڵʱҪô˺õһԶ
	 * @return {const xml_attr*} صһԶΪգʾ
	 *  ýڵû
	 */
	virtual const xml_attr* first_attr(void) const = 0;

	/**
	 * ڵʱñһԶ
	 * @return {const xml_attr*} һԶΪգʾ
	 *  
	 */
	virtual const xml_attr* next_attr(void) const = 0;

	/**
	 *  XML ڵ
	 * @param name {const char*} 
	 * @param value {const char*} ֵ
	 * @return {xml_node&}
	 */
	virtual xml_node& add_attr(const char* name, const char* value) = 0;

	/**
	 *  XML ڵ
	 * @param name {const char*} 
	 * @param n {char} ֵ
	 * @return {xml_node&}
	 */
	xml_node& add_attr(const char* name, char n);

	/**
	 *  XML ڵ
	 * @param name {const char*} 
	 * @param n {int} ֵ
	 * @return {xml_node&}
	 */
	xml_node& add_attr(const char* name, int n);

	/**
	 *  XML ڵ
	 * @param name {const char*} 
	 * @param n {size_t} ֵ
	 * @return {xml_node&}
	 */
	xml_node& add_attr(const char* name, size_t n);

	/**
	 *  XML ڵ
	 * @param name {const char*} 
	 * @param n {acl_int64} ֵ
	 * @return {xml_node&}
	 */
#if defined(_WIN32) || defined(_WIN64)
	xml_node& add_attr(const char* name, __int64 n);
#else
	xml_node& add_attr(const char* name, long long int n);
#endif

	/**
	 *  xml ڵı
	 * @param str {const char*} ַ
	 * @param append {bool} ıʱǲ׷ģʽǸģʽΪ׷ģʽ
	 *  ԭýڵıʱӵԭı׷ӣ򸲸
	 * @return {xml_node&}
	 */
	virtual xml_node& set_text(const char* str, bool append = false) = 0;

	/**
	 *  xml ڵ㣬ͬʱеΪýڵı
	 * @param in {istream&} 
	 * @param off {size_t} ļָҪݵʼλ
	 * @param len {size_t} ҪΪ 0 ʱһֱ
	 * @return {xml_node&}
	 */
	virtual xml_node& set_text(istream& in, size_t off = 0,
		size_t len = 0) = 0;

	/**
	 *  xml ڵı
	 * @param number {long long int} 64 λ
	 * @return {xml_node&}
	 */
#if defined(_WIN32) || defined(_WIN64)
	xml_node& set_text(__int64 number);
#else
	xml_node& set_text(long long int number);
#endif

	/**
	 *  xml ڵ xml_node ӽڵ
	 * @param child {xml_node*} ӽڵ
	 * @param return_child {bool} ǷҪ´ӽڵ
	 * @return {xml_node&} return_child Ϊ true ӽڵã
	 *  򷵻ر xml ڵ
	 */
	virtual xml_node& add_child(xml_node* child,
		bool return_child = false) = 0;
	
	/**
	 *  xml ڵ xml_node ӽڵ
	 * @param child {xml_node&} ӽڵ
	 * @param return_child {bool} ǷҪ´ӽڵ
	 * @return {xml_node&} return_child Ϊ true ӽڵã
	 *  򷵻ر xml ڵ
	 */
	xml_node& add_child(xml_node& child, bool return_child = false);

	/**
	 *  xml ڵ xml_node ӽڵ
	 * @param tag {const char* tag} ӽڵıǩ
	 * @param return_child {bool} ǷҪ´ӽڵ
	 * @param str {const char*} ıַ
	 * @return {xml_node&} return_child Ϊ true ӽڵã
	 *  򷵻ر xml ڵ
	 */
	xml_node& add_child(const char* tag, bool return_child = false,
		const char* str = NULL);

	/**
	 *  xml ڵ xml_node ӽڵ
	 * @param tag {const char* tag} ӽڵıǩ
	 * @param txt {long long int} ڵеıݣǿַ
	 * @param return_child {bool} ǷҪ´ӽڵ
	 * @return {xml_node&} return_child Ϊ true ӽڵã
	 *  򷵻ر xml ڵ
	 */
	xml_node& add_child(const char* tag, const char* txt,
		bool return_child = false);

	/**
	 *  xml ڵ xml_node ӽڵ
	 * @param tag {const char* tag} ӽڵıǩ
	 * @param number {long long int} 64 λ
	 * @param return_child {bool} ǷҪ´ӽڵ
	 * @return {xml_node&} return_child Ϊ true ӽڵã
	 *  򷵻ر xml ڵ
	 */
#if defined(_WIN32) || defined(_WIN64)
	xml_node& add_child(const char* tag, __int64 number,
		bool return_child = false);
#else
	xml_node& add_child(const char* tag, long long int number,
		bool return_child = false);
#endif

	/**
	 *  xml ڵ xml_node ӽڵͬʱʹеΪڵı
	 * @param tag {const char* tag} ӽڵıǩ
	 * @param in {istream&} 
	 * @param off {size_t} ļָҪݵʼλ
	 * @param len {size_t} ҪΪ 0 ʱһֱ
	 * @param return_child {bool} ǷҪ´ӽڵ
	 * @return {xml_node&} return_child Ϊ true ӽڵã
	 *  򷵻ر xml ڵ
	 */
	xml_node& add_child(const char* tag, istream& in,
		size_t off = 0, size_t len = 0, bool return_child = false);

	/**
	 * ñڵĸڵ
	 * @return {xml_node&}
	 */
	virtual xml_node& get_parent(void) const = 0;

	/**
	 * ñڵĸڵ
	 * @param node {xml_node*} ڵ
	 * @return {xml_node&}
	 */
	virtual xml_node& set_parent(xml_node* node) = 0;

	/**
	 * ڵ㼰ӽڵ xml з룬ڴ潫 xml ͳһͷ
	 * @return {int} رͷŵĽڵ
	 */
	virtual int detach(void) = 0;

	/**
	 * ñڵĵһӽڵ㣬Ҫӽڵʱȵô˺
	 * @return {xml_node*} ؿձʾûӽڵ
	 */
	virtual xml_node* first_child(void) = 0;

	/**
	 * ñڵһӽڵ
	 * @return {xml_node*} ؿձʾ̽
	 */
	virtual xml_node* next_child(void) = 0;

	/**
	 * ظ XML ڵ XML е
	 * @return {int}
	 */
	virtual int depth(void) const = 0;

	/**
	 * жϵǰڵǷΪ xml е root ڵ
	 * @return {bool}
	 */
	virtual bool is_root(void) const = 0;

	/**
	 * ظ xml ڵһӽڵĸ
	 * @return {int} Զ >= 0
	 */
	virtual int children_count(void) const = 0;

	/**
	 * ڱ xml ڵʱڲᶯ̬һЩʱ xml_node 󣬵
	 * ˺Щһô˺
	 * first_child/next_child ص xml_node ڵ󽫲ٿã
	 * ڴǷ
	 */
	void clear(void);

	/**
	 *  xml 
	 * @return {xml&}
	 */
	xml& get_xml(void) const;

protected:
	friend class xml;
	friend class dbuf_guard;

	/**
	 * xml ڵ㹹캯
	 * @param xml_ptr {xml*} xml 󣬷ǿ
	 */
	xml_node(xml* xml_ptr);

	/**
	 * ҪöǶ̬
	 */
	virtual ~xml_node(void);

protected:
	xml* xml_;
	std::vector<xml_node*> nodes_tmp_;
	std::vector<xml_attr*> attrs_tmp_;
};

class string;

class ACL_CPP_API xml : public pipe_stream, public dbuf_obj
{
public:
	/**
	 * @param dbuf_nblock {size_t} ڲ dbuf_guard ĳʼ
	 * @param dbuf_capacity {size_t} ڲ dbuf_guard ĳʼ
	 */
	xml(size_t dbuf_nblock = 2, size_t dbuf_capacity = 100);
	virtual ~xml(void);

	/**
	 * ڷǱպϵıǩǷҪԱպַ '/'ȱʡΪ
	 * @param on {bool}
	 * @return {xml&}
	 */
	virtual xml& ignore_slash(bool on) = 0;

	/**
	 *  xml ʱǷԶ xml 룬ȱʡ
	 * @param on {bool}
	 * @return {xml&}
	 */
	virtual xml& xml_decode(bool on) = 0;

	/**
	 *  xml ʱǷԶ xml 룬ȱʡ
	 * @param on {bool}
	 * @return {xml&}
	 */
	virtual xml& xml_encode(bool on) = 0;

	/**
	 *  xml ʱǷжڵ㣨ڲȱʡΪ
	 * @param on {bool}
	 * @retrn {xml&}
	 */
	virtual xml& xml_multi_root(bool on) = 0;

	/**
	 * ʽʽѭñ XML ݣҲһ
	 *  XML ݣظʹø XML  XML
	 * Ӧڽһ XML ǰ reset() 
	 * һεĽ
	 * @param data {const char*} xml 
	 * @return {const char*} ʱʣݣ÷ֵ
	 *  ʣ;  data Ϊ '\0'˵Ѿ
	 */
	virtual const char* update(const char* data) = 0;

	/**
	 * ж XML Ƿ
	 * @param root_tag {const char*} ڵǩ NULL ַøñǩ
	 *   xml ıǩȽǷͬ
	 * @return {bool}
	 */
	virtual bool complete(const char* root_tag) = 0;

	/**
	 *  XML ״̬ XML Զ XML 
	 * нڷʹñ XML ǰҪñ
	 * ڲ XML ״̬һεĽ
	 */
	virtual void reset(void) = 0;

	/**
	 * ӽ XML ԭʼнȡı
	 * @return {const string&} ؽã
	 *  ûҪͷ
	 */
	virtual const string& getText(void);

	/**
	 *  XML ȡĳǩнڵ㼯
	 * @param tag {const char*} ǩ(ִСд)
	 * @return {const std::vector<xml_node*>&} ؽĶã
	 *  ѯΪգüΪգempty() == true
	 *  עصе xml_node ڵݿ޸ģɾýڵ㣬
	 *  ΪÿڲԶɾĻ
	 */
	virtual const std::vector<xml_node*>&
		getElementsByTagName(const char* tag) const = 0;

	/**
	 *  xml лöӦǩĵһ xml ڵ
	 * @param tag {const char*} ǩ(ִСд)
	 * @return {xml_node*} ؿձñǩӦ xml ڵ㲻
	 */
	virtual xml_node* getFirstElementByTag(const char* tag) const = 0;

	/**
	 *  xml ле༶ǩͬ xml ڵļ
	 * @param tags {const char*} ༶ǩ '/' ָǩ xml ݣ
	 *  <root> <first> <second> <third name="test1"> text1 </third> </second> </first> ...
	 *  <root> <first> <second> <third name="test2"> text2 </third> </second> </first> ...
	 *  <root> <first> <second> <third name="test3"> text3 </third> </second> </first> ...
	 *  ͨ༶ǩroot/first/second/third һԲзĽڵ
	 * @return {const std::vector<xml_node*>&}  xml ڵ㼯, 
	 *  ѯΪգüΪգempty() == true
	 *  עصе xml_node ڵݿ޸ģɾýڵ㣬
	 *  ΪÿڲԶɾĻ
	 */
	virtual const std::vector<xml_node*>&
		getElementsByTags(const char* tags) const = 0;

	/**
	 *  xml лָ༶ǩĵһ xml ڵ
	 * @param tags {const char*} ༶ǩ '/' ָǩ xml ݣ
	 *  <root> <first> <second> <third name="test1"> text1 </third> </second> </first> ...
	 *  <root> <first> <second> <third name="test2"> text2 </third> </second> </first> ...
	 *  <root> <first> <second> <third name="test3"> text3 </third> </second> </first> ...
	 *  ͨ༶ǩroot/first/second/third һԲзĽڵ
	 * @return {xml_node*} ؿձʾ
	 */
	virtual xml_node* getFirstElementByTags(const char* tags) const = 0;

	/**
	 *  xml л name ֵͬ xml ڵ㼯
	 * @param value {const char*} Ϊ name ֵ
	 * @return {const std::vector<xml_node*>&} ؽĶã
	 *  ѯΪգüΪգempty() == true
	 *  עصе xml_node ڵݿ޸ģɾýڵ㣬
	 *  ΪÿڲԶɾĻ
	 */
	virtual const std::vector<xml_node*>&
		getElementsByName(const char* value) const = 0;

	/**
	 *  xml лиֵ xml ڵԪؼ
	 * @param name {const char*} 
	 * @param value {const char*} ֵ
	 * @return {const std::vector<xml_node*>&} ؽĶã
	 *  ѯΪգüΪգempty() == true
	 */
	virtual const std::vector<xml_node*>& getElementsByAttr(
		const char* name, const char* value) const = 0;

	/**
	 *  xml лָ id ֵ xml ڵԪ
	 * @param id {const char*} id ֵ
	 * @return {const xml_node*} xml ڵԪ,  NULL ʾûз
	 *   xml ڵ, ֵҪͷ
	 */
	virtual xml_node* getElementById(const char* id) const = 0;

	/**
	 * һ xml_node ڵ
	 * @param tag {const char*} ǩ
	 * @param txt {const char*} ıַ
	 * @return {xml_node*} ² xml_node ҪûֹͷţΪ
	 *   xml ͷʱЩڵԶͷţȻûҲڲʱ
	 *   reset ͷЩ xml_node ڵ
	 */
	virtual xml_node& create_node(const char* tag,
		const char* txt = NULL) = 0;

	/**
	 * һ xml_node ڵͬʱָеΪڵı
	 * @param tag {const char*} ǩ
	 * @param in {istream&} 
	 * @param off {size_t} ļָҪݵʼλ
	 * @param len {size_t} ҪΪ 0 ʱһֱ
	 * @return {xml_node*} ² xml_node ҪûֹͷţΪ
	 *   xml ͷʱЩڵԶͷţȻûҲڲʱ
	 *   reset ͷЩ xml_node ڵ
	 */
	virtual xml_node& create_node(const char* tag, istream& in,
		size_t off = 0, size_t len = 0) = 0;

	/**
	 * һ xml_node ڵ
	 * @param tag {const char*} ǩ
	 * @param number {long long int} 64 λ
	 * @return {xml_node*} ² xml_node ҪûֹͷţΪ
	 *  xml ͷʱЩڵԶͷţȻûҲڲʱ
	 *  reset ͷЩ xml_node ڵ
	 */
#if defined(_WIN32) || defined(_WIN64)
	xml_node& create_node(const char* tag, __int64 number);
#else
	xml_node& create_node(const char* tag, long long int number);
#endif

	/**
	 * øڵ󣬵Ҫע⣬ýڵΪڵ㣬治κݣ
	 *  xml ڵ㸸
	 * @return {xml_node&}
	 */
	virtual xml_node& get_root(void) = 0;

	/**
	 * ʼ xml 󲢻õһڵ
	 * @return {xml_node*} ؿձʾ xml Ϊսڵ
	 *  עصĽڵûֹͷţΪö
	 *  ڲԶͷ
	 */
	virtual xml_node* first_node(void) = 0;

	/**
	 *  xml һ xml ڵ
	 * @return {xml_node*} ؿձʾ
	 *  עصĽڵûֹͷţΪö
	 *  ڲԶͷ
	 */
	virtual xml_node* next_node(void) = 0;

	/**
	 *  xml תַ
	 * @param out {string&} 洢תĻ
	 */
	virtual void build_xml(string& out) const { (void) out; };

	/**
	 *  xml תΪַ
	 * @param len {size_t*}  NULL ʱݳ
	 * @return {const char*} xml ַ
	 */
	virtual const char* to_string(size_t* len = NULL) const = 0;

	/**
	 * õǰ xml ѾڴСܺ
	 * @return {size_t}
	 */
	virtual size_t space(void) const = 0;

	/**
	 * ¼ xml ѷڴСı 0
	 */
	virtual void space_clear(void) = 0;

	/**
	 * õǰ xml  xml ڵ
	 * @return {size_t}
	 */
	virtual size_t node_count(void) const = 0;

	/**
	 * õǰ xml  xml ڵԵ
	 * @return {size_t}
	 */
	virtual size_t attr_count(void) const = 0;

public:
	// pipe_stream 麯

	virtual int push_pop(const char* in, size_t len,
		string* out, size_t max = 0);
	virtual int pop_end(string* out, size_t max = 0);
	virtual void clear(void);

protected:
	dbuf_guard dbuf_;
	std::vector<xml_node*> elements_;
	string* buf_;
	//bool dummyRootAdded_;

	ACL_TOKEN* m_pTokenTree;
	//std::list<xml_node*> nodes_tmp_;
};

} // namespace acl
