#pragma once
#include "acl_cpp/master/master_base.hpp"

struct ACL_VSTREAM;
struct ACL_EVENT;

namespace acl {

class socket_stream;

/**
 * acl_master н̷ʽģֻ࣬һʵ
 */
class ACL_CPP_API master_proc : public master_base
{
public:
	/**
	 * ʼУøúָ÷ acl_master 
	 * ֮Уһ״̬
	 * @param argc {int}  main дݵĵһʾ
	 * @param argv {char**}  main дݵĵڶ
	 */
	void run_daemon(int argc, char** argv);

	/**
	 * ڵʱĴûԵô˺һЩҪĵԹ
	 * @param addrs {const char*} ַбʽIP:PORT, IP:PORT...
	 * @param path {const char*} ļȫ·
	 * @param count {int} ֵ > 0 ʱյӴﵽֵ
	 *  󣬸úأһֱѭԶ
	 * @return {bool} Ƿɹ
	 */
	bool run_alone(const char* addrs, const char* path = NULL, int count = 1);

protected:
	master_proc();
	virtual ~master_proc();

	/**
	 * 麯յһͻʱô˺
	 * @param stream {aio_socket_stream*} ½յĿͻ첽
	 * עúغӽᱻرգûӦرո
	 */
	virtual void on_accept(socket_stream* stream) = 0;

private:
	// յһͻʱص˺
	static void service_main(ACL_VSTREAM *stream, char *service, char **argv);

	// һַʱص˺
	static void service_on_listen(ACL_VSTREAM*);

	// лûݺõĻص
	static void service_pre_jail(char* service, char** argv);

	// лûݺõĻص
	static void service_init(char* service, char** argv);

	// ˳ʱõĻص
	static void service_exit(char* service, char** argv);

private:
	// ڵзʽ£ú׽ӵʱ
	static void listen_callback(int event_type, ACL_EVENT*,
		ACL_VSTREAM*, void* context);
};

}  // namespace acl
