#pragma once
#include "acl_cpp/acl_cpp_define.hpp"
#include "acl_cpp/stdlib/string.hpp"
#include "acl_cpp/db/db_handle.hpp"

typedef struct st_mysql MYSQL;

namespace acl {

class mysql_conf;

class ACL_CPP_API db_mysql : public db_handle
{
public:
	/**
	 * 캯ʽһ
	 * @param dbaddr {const char*} ݿַΪ TCP ׽ӿڻ UNIX
	 *  ƽ̨µ׽ӿڣʽ磺127.0.0.1:3306 /tmp/mysql.sock
	 * @param dbname {const char*} ݿƣ NULL
	 * @param dbuser {const char*} ݿʱû
	 * @param dbpass {const char*} ݿʱû
	 * @param dbflags {unsigned long}  MYSQL ʱı־λ
	 * @param auto_commit {bool} ݿ޸ʱǷԶύ
	 * @param conn_timeout {int} ݿĳʱʱ䣨룩
	 * @param rw_timeout {int} ݿʱĳʱʱ䣨룩
	 * @param charset {const char*} ݿʱıַgbk, utf8, ...
	 */
	db_mysql(const char* dbaddr, const char* dbname,
		const char* dbuser, const char* dbpass,
		unsigned long dbflags = 0, bool auto_commit = true,
		int conn_timeout = 60, int rw_timeout = 60,
		const char* charset = "utf8");

	/**
	 * 캯ʽʹòй
	 * @param conf {const mysql_conf&} mysql ݿ
	 */
	db_mysql(const mysql_conf& conf);
	~db_mysql(void);

	/**
	 *  mysql ͻ˿İ汾
	 * @return {unsigned long}
	 */
	unsigned long mysql_libversion() const;

	/**
	 *  mysql ͻ˿Ϣ
	 * @return {const char*}
	 */
	const char* mysql_client_info() const;

	/**
	 * ֱӻ mysql Ӿ NULL ʾ mysql ûд
	 * ʱڲԶر mysql 
	 * @return {MYSQL*}
	 */
	MYSQL* get_conn() const
	{
		return conn_;
	}

	/********************************************************************/
	/*         Ϊ db_handle ӿ                            */
	/********************************************************************/

	/**
	 * ݿ
	 * @return {const char*}
	 */
	const char* dbtype() const;

	/**
	 * ϴݿĳ
	 * @return {int}
	 */
	int get_errno() const;

	/**
	 * ϴݿĳ
	 * @return {const char*}
	 */
	const char* get_error() const;

	/**
	 *  db_handle Ĵӿ
	 * @param charset {const char*} ݿʱõַ
	 *  ǿʱḲǹ캯дַ
	 * @return {bool} Ƿɹ
	 */
	bool dbopen(const char* charset = NULL);

	/**
	 *  db_handle ĴӿڣݿǷѾ
	 * @return {bool}  true ݿѾ
	 */
	bool is_opened() const;

	/**
	 *  db_handle Ĵӿ
	 * @return {bool} رǷɹ
	 */
	bool close(void);

	/**
	 *  db_handle Ĵӿڣʵִ˽ӿжݱǷ
	 * @return {bool} Ƿ
	 */
	bool tbl_exists(const char* tbl_name);

	/**
	 *  db_handle Ĵӿ
	 * @param sql {const char*} ׼ SELECT SQL 䣬ǿգһ
	 *  Ҫע SQL 뾭ת崦Էֹ SQL ע빥
	 * @param result {db_rows*} ǿգ򽫲ѯýУ
	 *  򣬻 db_handle ڲһʱ洢
	 * @return {bool} ִǷɹ
	 */
	bool sql_select(const char* sql, db_rows* result = NULL);

	/**
	 *  db_handle Ĵӿ
	 * @param sql {const char*} ׼ INSERT/UPDATE/DELETE SQL 䣬
	 *  һҪע SQL 뾭ת崦Էֹ SQL ע빥
	 * @return {bool} ִǷɹ
	 */
	bool sql_update(const char* sql);

	/**
	 *  db_handle Ĵӿڣϴ sql Ӱļ¼
	 * @return {int} Ӱ-1 ʾ
	 */
	int affect_count() const;

	/**
	 * @override
	 *  db_handle 麯ʾĿʼעҪʹʽ
	 * Ҫ db_mysql Ĺ캯дĲ auto_commit Ϊ false
	 * @return {bool}
	 */
	bool begin_transaction();

	/**
	 * @override
	 *  db_handle 麯ʾĽ
	 * @return {bool}
	 */
	bool commit();

	/**
	 * @override
	 * @return {bool} عǷɹ
	 */
	bool rollback();

private:
	char* dbaddr_;  // ݿַ
	char* dbname_;  // ݿ
	char* dbuser_;  // ݿ˺
	char* dbpass_;  // ݿ˺
	string charset_; // ݿõַ

	unsigned long dbflags_;
	int   conn_timeout_;
	int   rw_timeout_;
	bool  auto_commit_;
	MYSQL* conn_;

	bool sane_mysql_query(const char* sql);
	void sane_mysql_init(const char* dbaddr, const char* dbname,
		const char* dbuser, const char* dbpass,
		unsigned long dbflags, bool auto_commit,
		int conn_timeout, int rw_timeout,
		const char* charset);
};

} // namespace acl
