#pragma once
#include "acl_cpp/acl_cpp_define.hpp"

namespace acl {

class istream;

class ACL_CPP_API md5
{
public:
	md5();
	~md5();

	/**
	 * ѭô˺Ҫ md5 
	 * @param dat {const void*} ݵַ
	 * @param len {size_t} dat ݳ
	 * @return {md5&}
	 */
	md5& update(const void* dat, size_t len);

	/**
	 * ñʾ md5 ̽
	 * @return {md5&}
	 */
	md5& finish();

	/**
	 *  md5 㷨״̬Ӷظʹͬһ md5 
	 * @return {md5&}
	 */
	md5& reset();

	/**
	 * öƸʽ md5 ֵ
	 * @return {const char*} ֵԶǿգһΪ 16 ֽ
	 */
	const char* get_digest() const;

	/**
	 * ַʽʾ m5 ֵ
	 * @return {const char*} ֵԶǿգ \0 βַ
	 *  Ϊ 32 ֽ
	 */
	const char* get_string() const;

	/**
	 *  md5 㷨ǩֵȡ 128 λ ( 16 ֽ) ƽ
	 * @param dat {const void*} Դ
	 * @param dlen {size_t} dat ݳ
	 * @param key {const char*} ǿʱΪ
	 * @param klen {size_t} key ǿʱʾ key ĳ
	 * @param out {void*} 洢 md5 
	 * @param size {size_t} out СӦΪ 16 ֽ
	 * @return {const char*} ش洢ĵַ( out ַ)
	 */
	static const char* md5_digest(const void *dat, size_t dlen,
		const void *key, size_t klen, void* out, size_t size);

	/**
	 *  md5 㷨ǩֵȡַʽĽ
	 * @param dat {const void*} Դ
	 * @param dlen {size_t} dat ݳ
	 * @param key {const char*} ǿʱΪ
	 * @param klen {size_t} key ǿʱʾ key ĳ
	 * @param out {void*} 洢 md5 
	 * @param size {size_t} out СӦΪ 33 ֽ
	 * @return {const char*} ش洢ĵַ( out ַ)
	 *  ҷֵΪ \0 β 32 ֽڳ( \0)ַ
	 */
	static const char* md5_string(const void *dat, size_t dlen,
		const void *key, size_t klen, char* out, size_t size);

	/**
	 * ļе md5 㷨ǩֵȡַʽ
	 * @param path {const char*} ļȫ·
	 * @param key {const char*} ǿʱΪ
	 * @param klen {size_t} key ǿʱʾ key ĳ
	 * @param out {void*} 洢 md5 
	 * @param size {size_t} out СӦΪ 33 ֽ
	 * @return {int64) ȡļݵĳȣ· -1
	 *  1) ļʧ
	 *  2) δļж
	 *  3) out С size С 33 ֽڳ
	 */
#if defined(_WIN32) || defined(_WIN64)
	static __int64 md5_file(const char* path, const void *key,
		size_t klen, char* out, size_t size);
#else
	static long long int md5_file(const char* path, const void *key,
		size_t klen, char* out, size_t size);
#endif

	/**
	 * ļе md5 㷨ǩֵȡַʽ
	 * @param in {istream&} ļ
	 * @param key {const char*} ǿʱΪ
	 * @param klen {size_t} key ǿʱʾ key ĳ
	 * @param out {void*} 洢 md5 
	 * @param size {size_t} out СӦΪ 33 ֽ
	 * @return {int64) ȡļݵĳȣ· -1:
	 *  1) δжȡʱ
	 *  2) out С size С 33 ֽڳ
	 */
#if defined(_WIN32) || defined(_WIN64)
	static __int64 md5_file(istream& in, const void *key,
		size_t klen, char* out, size_t size);
#else
	static long long int md5_file(istream& in, const void *key,
		size_t klen, char* out, size_t size);
#endif

	/**
	 *  16 ֽڳȵ MD5 ƽתΪ 32 ֽڳȵַ
	 * @param in {const void*} 128 λ( 16 ֽ) md5 ֵ in ݳ
	 *  Ӧ >= 16ڴԽ
	 * @param out {char*} 洢ַʽĽ
	 * @param size {size_t} out ڴСΪ 33 ֽڣڲ
	 * @return {const char*} ش洢ĵַ( out ַ)
	 *  ҷֵΪ \0 β 32 ֽڳ( \0)ַ
	 */
	static const char* hex_encode(const void *in, char* out, size_t size);

private:
	unsigned int buf_[4];
	unsigned int bytes_[2];
	unsigned int in_[16];

	unsigned char digest_[16];
	unsigned char digest_s_[33];
};

}  // namespace acl
